import {
  ANTHROPIC_API_KEY,
  AZURE_OPENAI_API_VERSION,
  AZURE_OPENAI_DEPLOYMENT,
  AZURE_OPENAI_ENDPOINT,
  AZURE_OPENAI_KEY,
  MIDSCENE_ANTHROPIC_API_KEY,
  MIDSCENE_AZURE_OPENAI_API_VERSION,
  MIDSCENE_AZURE_OPENAI_DEPLOYMENT,
  MIDSCENE_AZURE_OPENAI_ENDPOINT,
  MIDSCENE_AZURE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_AZURE_OPENAI_KEY,
  MIDSCENE_AZURE_OPENAI_SCOPE,
  MIDSCENE_GROUNDING_ANTHROPIC_API_KEY,
  MIDSCENE_GROUNDING_AZURE_OPENAI_API_VERSION,
  MIDSCENE_GROUNDING_AZURE_OPENAI_DEPLOYMENT,
  MIDSCENE_GROUNDING_AZURE_OPENAI_ENDPOINT,
  MIDSCENE_GROUNDING_AZURE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_GROUNDING_AZURE_OPENAI_KEY,
  MIDSCENE_GROUNDING_AZURE_OPENAI_SCOPE,
  MIDSCENE_GROUNDING_MODEL_NAME,
  MIDSCENE_GROUNDING_OPENAI_API_KEY,
  MIDSCENE_GROUNDING_OPENAI_BASE_URL,
  MIDSCENE_GROUNDING_OPENAI_HTTP_PROXY,
  MIDSCENE_GROUNDING_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_GROUNDING_OPENAI_SOCKS_PROXY,
  MIDSCENE_GROUNDING_OPENAI_USE_AZURE,
  MIDSCENE_GROUNDING_USE_ANTHROPIC_SDK,
  MIDSCENE_GROUNDING_USE_AZURE_OPENAI,
  MIDSCENE_GROUNDING_VL_MODE,
  MIDSCENE_MODEL_NAME,
  MIDSCENE_OPENAI_API_KEY,
  MIDSCENE_OPENAI_BASE_URL,
  MIDSCENE_OPENAI_HTTP_PROXY,
  MIDSCENE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_OPENAI_SOCKS_PROXY,
  MIDSCENE_OPENAI_USE_AZURE,
  MIDSCENE_PLANNING_ANTHROPIC_API_KEY,
  MIDSCENE_PLANNING_AZURE_OPENAI_API_VERSION,
  MIDSCENE_PLANNING_AZURE_OPENAI_DEPLOYMENT,
  MIDSCENE_PLANNING_AZURE_OPENAI_ENDPOINT,
  MIDSCENE_PLANNING_AZURE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_PLANNING_AZURE_OPENAI_KEY,
  MIDSCENE_PLANNING_AZURE_OPENAI_SCOPE,
  MIDSCENE_PLANNING_MODEL_NAME,
  MIDSCENE_PLANNING_OPENAI_API_KEY,
  MIDSCENE_PLANNING_OPENAI_BASE_URL,
  MIDSCENE_PLANNING_OPENAI_HTTP_PROXY,
  MIDSCENE_PLANNING_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_PLANNING_OPENAI_SOCKS_PROXY,
  MIDSCENE_PLANNING_OPENAI_USE_AZURE,
  MIDSCENE_PLANNING_USE_ANTHROPIC_SDK,
  MIDSCENE_PLANNING_USE_AZURE_OPENAI,
  MIDSCENE_PLANNING_VL_MODE,
  MIDSCENE_USE_ANTHROPIC_SDK,
  MIDSCENE_USE_AZURE_OPENAI,
  MIDSCENE_VL_MODE,
  MIDSCENE_VQA_ANTHROPIC_API_KEY,
  MIDSCENE_VQA_AZURE_OPENAI_API_VERSION,
  MIDSCENE_VQA_AZURE_OPENAI_DEPLOYMENT,
  MIDSCENE_VQA_AZURE_OPENAI_ENDPOINT,
  MIDSCENE_VQA_AZURE_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_VQA_AZURE_OPENAI_KEY,
  MIDSCENE_VQA_AZURE_OPENAI_SCOPE,
  // VQA
  MIDSCENE_VQA_MODEL_NAME,
  MIDSCENE_VQA_OPENAI_API_KEY,
  MIDSCENE_VQA_OPENAI_BASE_URL,
  MIDSCENE_VQA_OPENAI_HTTP_PROXY,
  MIDSCENE_VQA_OPENAI_INIT_CONFIG_JSON,
  MIDSCENE_VQA_OPENAI_SOCKS_PROXY,
  MIDSCENE_VQA_OPENAI_USE_AZURE,
  MIDSCENE_VQA_USE_ANTHROPIC_SDK,
  MIDSCENE_VQA_USE_AZURE_OPENAI,
  MIDSCENE_VQA_VL_MODE,
  OPENAI_API_KEY,
  OPENAI_BASE_URL,
  OPENAI_USE_AZURE,
} from './types';

interface IModelConfigKeys {
  modelName: string;
  /**
   * proxy
   */
  socksProxy: string;
  httpProxy: string;
  /**
   * OpenAI
   */
  openaiBaseURL: string;
  openaiApiKey: string;
  openaiExtraConfig: string;
  /**
   * Azure
   */
  openaiUseAzureDeprecated: string;
  useAzureOpenai: string;
  azureOpenaiScope: string;
  azureOpenaiKey: string;
  azureOpenaiEndpoint: string;
  azureOpenaiApiVersion: string;
  azureOpenaiDeployment: string;
  azureExtraConfig: string;
  /**
   * Anthropic
   */
  useAnthropicSdk: string;
  anthropicApiKey: string;
  /**
   * Extra
   */
  vlMode: string;
}

export const VQA_MODEL_CONFIG_KEYS: IModelConfigKeys = {
  modelName: MIDSCENE_VQA_MODEL_NAME,
  /**
   * proxy
   */
  socksProxy: MIDSCENE_VQA_OPENAI_SOCKS_PROXY,
  httpProxy: MIDSCENE_VQA_OPENAI_HTTP_PROXY,
  /**
   * OpenAI
   */
  openaiBaseURL: MIDSCENE_VQA_OPENAI_BASE_URL,
  openaiApiKey: MIDSCENE_VQA_OPENAI_API_KEY,
  openaiExtraConfig: MIDSCENE_VQA_OPENAI_INIT_CONFIG_JSON,
  /**
   * Azure
   */
  openaiUseAzureDeprecated: MIDSCENE_VQA_OPENAI_USE_AZURE,
  useAzureOpenai: MIDSCENE_VQA_USE_AZURE_OPENAI,
  azureOpenaiScope: MIDSCENE_VQA_AZURE_OPENAI_SCOPE,
  azureOpenaiKey: MIDSCENE_VQA_AZURE_OPENAI_KEY,
  azureOpenaiEndpoint: MIDSCENE_VQA_AZURE_OPENAI_ENDPOINT,
  azureOpenaiApiVersion: MIDSCENE_VQA_AZURE_OPENAI_API_VERSION,
  azureOpenaiDeployment: MIDSCENE_VQA_AZURE_OPENAI_DEPLOYMENT,
  azureExtraConfig: MIDSCENE_VQA_AZURE_OPENAI_INIT_CONFIG_JSON,
  /**
   * Anthropic
   */
  useAnthropicSdk: MIDSCENE_VQA_USE_ANTHROPIC_SDK,
  anthropicApiKey: MIDSCENE_VQA_ANTHROPIC_API_KEY,
  /**
   * Extra
   */
  vlMode: MIDSCENE_VQA_VL_MODE,
} as const;

export const GROUNDING_MODEL_CONFIG_KEYS: IModelConfigKeys = {
  modelName: MIDSCENE_GROUNDING_MODEL_NAME,
  /**
   * proxy
   */
  socksProxy: MIDSCENE_GROUNDING_OPENAI_SOCKS_PROXY,
  httpProxy: MIDSCENE_GROUNDING_OPENAI_HTTP_PROXY,
  /**
   * OpenAI
   */
  openaiBaseURL: MIDSCENE_GROUNDING_OPENAI_BASE_URL,
  openaiApiKey: MIDSCENE_GROUNDING_OPENAI_API_KEY,
  openaiExtraConfig: MIDSCENE_GROUNDING_OPENAI_INIT_CONFIG_JSON,
  /**
   * Azure
   */
  openaiUseAzureDeprecated: MIDSCENE_GROUNDING_OPENAI_USE_AZURE,
  useAzureOpenai: MIDSCENE_GROUNDING_USE_AZURE_OPENAI,
  azureOpenaiScope: MIDSCENE_GROUNDING_AZURE_OPENAI_SCOPE,
  azureOpenaiKey: MIDSCENE_GROUNDING_AZURE_OPENAI_KEY,
  azureOpenaiEndpoint: MIDSCENE_GROUNDING_AZURE_OPENAI_ENDPOINT,
  azureOpenaiApiVersion: MIDSCENE_GROUNDING_AZURE_OPENAI_API_VERSION,
  azureOpenaiDeployment: MIDSCENE_GROUNDING_AZURE_OPENAI_DEPLOYMENT,
  azureExtraConfig: MIDSCENE_GROUNDING_AZURE_OPENAI_INIT_CONFIG_JSON,
  /**
   * Anthropic
   */
  useAnthropicSdk: MIDSCENE_GROUNDING_USE_ANTHROPIC_SDK,
  anthropicApiKey: MIDSCENE_GROUNDING_ANTHROPIC_API_KEY,
  /**
   * Extra
   */
  vlMode: MIDSCENE_GROUNDING_VL_MODE,
} as const;

export const PLANNING_MODEL_CONFIG_KEYS: IModelConfigKeys = {
  modelName: MIDSCENE_PLANNING_MODEL_NAME,
  /**
   * proxy
   */
  socksProxy: MIDSCENE_PLANNING_OPENAI_SOCKS_PROXY,
  httpProxy: MIDSCENE_PLANNING_OPENAI_HTTP_PROXY,
  /**
   * OpenAI
   */
  openaiBaseURL: MIDSCENE_PLANNING_OPENAI_BASE_URL,
  openaiApiKey: MIDSCENE_PLANNING_OPENAI_API_KEY,
  openaiExtraConfig: MIDSCENE_PLANNING_OPENAI_INIT_CONFIG_JSON,
  /**
   * Azure
   */
  openaiUseAzureDeprecated: MIDSCENE_PLANNING_OPENAI_USE_AZURE,
  useAzureOpenai: MIDSCENE_PLANNING_USE_AZURE_OPENAI,
  azureOpenaiScope: MIDSCENE_PLANNING_AZURE_OPENAI_SCOPE,
  azureOpenaiKey: MIDSCENE_PLANNING_AZURE_OPENAI_KEY,
  azureOpenaiEndpoint: MIDSCENE_PLANNING_AZURE_OPENAI_ENDPOINT,
  azureOpenaiApiVersion: MIDSCENE_PLANNING_AZURE_OPENAI_API_VERSION,
  azureOpenaiDeployment: MIDSCENE_PLANNING_AZURE_OPENAI_DEPLOYMENT,
  azureExtraConfig: MIDSCENE_PLANNING_AZURE_OPENAI_INIT_CONFIG_JSON,
  /**
   * Anthropic
   */
  useAnthropicSdk: MIDSCENE_PLANNING_USE_ANTHROPIC_SDK,
  anthropicApiKey: MIDSCENE_PLANNING_ANTHROPIC_API_KEY,
  /**
   * Extra
   */
  vlMode: MIDSCENE_PLANNING_VL_MODE,
} as const;

// modelConfig return default
export const DEFAULT_MODEL_CONFIG_KEYS: IModelConfigKeys = {
  modelName: MIDSCENE_MODEL_NAME,
  /**
   * proxy
   */
  socksProxy: MIDSCENE_OPENAI_SOCKS_PROXY,
  httpProxy: MIDSCENE_OPENAI_HTTP_PROXY,
  /**
   * OpenAI
   */
  openaiBaseURL: MIDSCENE_OPENAI_BASE_URL,
  openaiApiKey: MIDSCENE_OPENAI_API_KEY,
  openaiExtraConfig: MIDSCENE_OPENAI_INIT_CONFIG_JSON,
  /**
   * Azure
   */
  openaiUseAzureDeprecated: MIDSCENE_OPENAI_USE_AZURE,
  useAzureOpenai: MIDSCENE_USE_AZURE_OPENAI,
  azureOpenaiScope: MIDSCENE_AZURE_OPENAI_SCOPE,
  azureOpenaiKey: MIDSCENE_AZURE_OPENAI_KEY,
  azureOpenaiEndpoint: MIDSCENE_AZURE_OPENAI_ENDPOINT,
  azureOpenaiApiVersion: MIDSCENE_AZURE_OPENAI_API_VERSION,
  azureOpenaiDeployment: MIDSCENE_AZURE_OPENAI_DEPLOYMENT,
  azureExtraConfig: MIDSCENE_AZURE_OPENAI_INIT_CONFIG_JSON,
  /**
   * Anthropic
   */
  useAnthropicSdk: MIDSCENE_USE_ANTHROPIC_SDK,
  anthropicApiKey: MIDSCENE_ANTHROPIC_API_KEY,
  /**
   * Extra
   */
  vlMode: MIDSCENE_VL_MODE,
} as const;

// read from process.env
export const DEFAULT_MODEL_CONFIG_KEYS_LEGACY: IModelConfigKeys = {
  modelName: MIDSCENE_MODEL_NAME,
  /**
   * proxy
   */
  socksProxy: MIDSCENE_OPENAI_SOCKS_PROXY,
  httpProxy: MIDSCENE_OPENAI_HTTP_PROXY,
  /**
   * OpenAI
   */
  openaiBaseURL: OPENAI_BASE_URL,
  openaiApiKey: OPENAI_API_KEY,
  openaiExtraConfig: MIDSCENE_OPENAI_INIT_CONFIG_JSON,
  /**
   * Azure
   */
  openaiUseAzureDeprecated: OPENAI_USE_AZURE,
  useAzureOpenai: MIDSCENE_USE_AZURE_OPENAI,
  azureOpenaiScope: MIDSCENE_AZURE_OPENAI_SCOPE,
  azureOpenaiKey: AZURE_OPENAI_KEY,
  azureOpenaiEndpoint: AZURE_OPENAI_ENDPOINT,
  azureOpenaiApiVersion: AZURE_OPENAI_API_VERSION,
  azureOpenaiDeployment: AZURE_OPENAI_DEPLOYMENT,
  azureExtraConfig: MIDSCENE_AZURE_OPENAI_INIT_CONFIG_JSON,
  /**
   * Anthropic
   */
  useAnthropicSdk: MIDSCENE_USE_ANTHROPIC_SDK,
  anthropicApiKey: ANTHROPIC_API_KEY,
  /**
   * Extra
   */
  vlMode: 'DEFAULT_MODEL_CONFIG_KEYS has no vlMode key',
} as const;
