import * as path from 'node:path';
import { defineConfig } from '@rspress/core';
import { pluginLlms } from '@rspress/plugin-llms';
import { pluginSitemap } from '@rspress/plugin-sitemap';

export default defineConfig({
  root: path.join(__dirname, 'docs'),
  title:
    '(AI UI Automation, AI Testing, Computer Use, Browser Use, Android Use)',
  description:
    'AI UI Automation, AI Testing, Computer Use, Browser Use, Android Use. It offers JavaScript SDK, Chrome extension, and support for scripting in YAML.',
  icon: '/midscene-icon.png',
  logo: {
    light: '/midscene_with_text_light.png',
    dark: '/midscene_with_text_dark.png',
  },
  themeConfig: {
    lastUpdated: true,
    socialLinks: [
      {
        icon: 'github',
        mode: 'link',
        content: 'https://github.com/web-infra-dev/midscene',
      },
      {
        icon: 'discord',
        mode: 'link',
        content: 'https://discord.gg/2JyBHxszE4',
      },
      {
        icon: 'x',
        mode: 'link',
        content: 'https://x.com/midscene_ai',
      },
      {
        icon: 'lark',
        mode: 'link',
        content:
          'https://applink.larkoffice.com/client/chat/chatter/add_by_link?link_token=291q2b25-e913-411a-8c51-191e59aab14d',
      },
    ],
    locales: [
      {
        lang: 'en',
        outlineTitle: 'On this page',
        label: 'On this page',
        editLink: {
          docRepoBaseUrl:
            'https://github.com/web-infra-dev/midscene/tree/main/apps/site/docs',
          text: '📝 Edit this page on GitHub',
        },
      },
      {
        lang: 'zh',
        outlineTitle: '大纲',
        label: '大纲',
        editLink: {
          docRepoBaseUrl:
            'https://github.com/web-infra-dev/midscene/tree/main/apps/site/docs',
          text: '📝 在 GitHub 上编辑此页',
        },
      },
    ],
    sidebar: {
      '/': [
        {
          text: 'Getting started',
          items: [
            {
              text: 'Introduction',
              link: '/',
            },
            {
              text: 'Quick experience by Chrome extension',
              link: '/quick-experience',
            },
          ],
        },
        {
          text: 'Web browser automation',
          items: [
            {
              text: 'MCP server',
              link: '/web-mcp',
            },
            {
              text: 'Integrate with Playwright',
              link: '/integrate-with-playwright',
            },
            {
              text: 'Integrate with Puppeteer',
              link: '/integrate-with-puppeteer',
            },
            {
              text: 'Bridge mode by Chrome extension',
              link: '/bridge-mode-by-chrome-extension',
            },
          ],
        },
        {
          text: 'Android automation',
          items: [
            {
              text: 'Intro',
              link: '/blog-support-android-automation',
            },
            {
              text: 'MCP server',
              link: '/mcp-android',
            },
            {
              text: 'Quick experience with Android',
              link: '/quick-experience-with-android',
            },
            {
              text: 'Integrate with Android (adb)',
              link: '/integrate-with-android',
            },
          ],
        },
        {
          text: 'iOS automation',
          items: [
            {
              text: 'Intro',
              link: '/blog-support-ios-automation',
            },
            {
              text: 'Quick experience with iOS',
              link: '/quick-experience-with-ios',
            },
            {
              text: 'Integrate with iOS (WebDriverAgent)',
              link: '/integrate-with-ios',
            },
          ],
        },
        {
          text: 'API and usage',
          items: [
            {
              text: 'Automate with scripts in YAML',
              link: '/automate-with-scripts-in-yaml',
            },
            {
              text: 'API reference',
              link: '/api',
            },
          ],
        },
        {
          text: 'AI model',
          items: [
            {
              text: 'Choose a model 🔥',
              link: '/choose-a-model',
            },
            {
              text: 'Config model and provider',
              link: '/model-provider',
            },
            {
              text: 'Prompting tips',
              link: '/prompting-tips',
            },
          ],
        },
        {
          text: 'Advanced',
          items: [
            {
              text: 'Caching AI planning & locate',
              link: '/caching',
            },
            {
              text: 'Integrate with any interface (preview)',
              link: '/integrate-with-any-interface',
            },
            {
              text: 'Introducing instant actions and deep think',
              link: '/blog-introducing-instant-actions-and-deep-think',
            },
            {
              text: 'Use JavaScript to optimize the AI automation code',
              link: '/blog-programming-practice-using-structured-api',
            },
          ],
        },
        {
          text: 'More',
          items: [
            {
              text: 'Awesome Midscene',
              link: '/awesome-midscene',
            },
            {
              text: 'FAQ',
              link: '/faq',
            },
            {
              text: 'Changelog',
              link: '/changelog',
            },
            {
              text: 'LLMs.txt documentation',
              link: '/llm-txt',
            },
            {
              text: 'Data privacy',
              link: '/data-privacy',
            },
          ],
        },
      ],
      '/zh': [
        {
          text: '快速开始',
          items: [
            {
              text: '介绍',
              link: '/zh/index',
            },
            {
              text: '通过 Chrome 插件快速体验',
              link: '/zh/quick-experience',
            },
          ],
        },
        {
          text: 'Web 浏览器自动化',
          items: [
            {
              text: 'MCP 服务',
              link: '/zh/web-mcp',
            },
            {
              text: '集成到 Playwright',
              link: '/zh/integrate-with-playwright',
            },
            {
              text: '集成到 Puppeteer',
              link: '/zh/integrate-with-puppeteer',
            },
            {
              text: 'Chrome 桥接模式（Bridge Mode）',
              link: '/zh/bridge-mode-by-chrome-extension',
            },
          ],
        },
        {
          text: 'Android 自动化',
          items: [
            {
              text: '介绍',
              link: '/zh/blog-support-android-automation',
            },
            {
              text: 'MCP 服务',
              link: '/zh/mcp-android',
            },
            {
              text: '使用 Android Playground 快速体验',
              link: '/zh/quick-experience-with-android',
            },
            {
              text: '与 Android(adb) 集成',
              link: '/zh/integrate-with-android',
            },
          ],
        },
        {
          text: 'iOS 自动化',
          items: [
            {
              text: '介绍',
              link: '/zh/blog-support-ios-automation',
            },
            {
              text: '使用 iOS Playground 快速体验',
              link: '/zh/quick-experience-with-ios',
            },
            {
              text: '与 iOS(WebDriverAgent) 集成',
              link: '/zh/integrate-with-ios',
            },
          ],
        },
        {
          text: 'API 和用法',
          items: [
            {
              text: '使用 YAML 格式的自动化脚本',
              link: '/zh/automate-with-scripts-in-yaml',
            },
            {
              text: 'API 参考',
              link: '/zh/api',
            },
          ],
        },
        {
          text: 'AI 模型',
          items: [
            {
              text: '选择 AI 模型 🔥',
              link: '/zh/choose-a-model',
            },
            {
              text: '配置模型和服务商',
              link: '/zh/model-provider',
            },
            {
              text: '编写提示词（指令）的技巧',
              link: '/zh/prompting-tips',
            },
          ],
        },
        {
          text: '进阶',
          items: [
            {
              text: '缓存 AI 规划和定位',
              link: '/zh/caching',
            },
            {
              text: '与任意界面集成（预览特性）',
              link: '/zh/integrate-with-any-interface',
            },
            {
              text: '即时操作和深度思考',
              link: '/zh/blog-introducing-instant-actions-and-deep-think',
            },
            {
              text: '使用 JavaScript 优化 AI 自动化代码',
              link: '/zh/blog-programming-practice-using-structured-api',
            },
          ],
        },
        {
          text: '更多',
          items: [
            {
              text: 'Awesome Midscene',
              link: '/zh/awesome-midscene',
            },
            {
              text: '常见问题 FAQ',
              link: '/zh/faq',
            },
            {
              text: '更新日志',
              link: '/zh/changelog',
            },
            {
              text: 'LLMs.txt 文档',
              link: '/zh/llm-txt',
            },
            {
              text: '数据隐私',
              link: '/zh/data-privacy',
            },
          ],
        },
      ],
    },
  },
  globalStyles: path.join(__dirname, 'styles/index.css'),
  locales: [
    {
      lang: 'en',
      label: 'English',
      title: 'Midscene.js - (AI UI Automation, AI Testing)',
      description:
        'Midscene.js - (AI driven UI automation framework, Computer Use, Browser Use, Android Use)',
    },
    {
      lang: 'zh',
      label: '简体中文',
      title: 'Midscene.js - (AI UI 自动化，AI 测试)',
      description:
        'Midscene.js - (AI 驱动的 UI 自动化框架，Computer Use, Browser Use, Android Use)',
    },
  ],
  builderConfig: {
    performance: {
      buildCache: false,
    },
    tools: {
      rspack: {
        watchOptions: {
          ignored: /node_modules/,
        },
      },
    },
    html: {
      tags: [
        {
          tag: 'script',
          attrs: {
            type: 'text/javascript',
          },
          children: `(function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "rg8ztmkti8");`,
        },
      ],
      meta: {
        'google-site-verification':
          'knm1l2oVU9IkHaYjq9q-FnyiEMVkt1b6i2El54Hphdw',
      },
    },
  },
  lang: 'en',
  plugins: [
    pluginLlms([
      {
        llmsTxt: {
          name: 'llms.txt',
        },
        llmsFullTxt: {
          name: 'llms-full.txt',
        },
        include: ({ page }) => page.lang === 'en',
      },
      {
        llmsTxt: {
          name: 'zh/llms.txt',
        },
        llmsFullTxt: {
          name: 'zh/llms-full.txt',
        },
        include: ({ page }) => page.lang === 'zh',
      },
    ]),
    pluginSitemap({
      siteUrl: 'https://midscenejs.com',
    }),
  ],
});
