# Awesome Midscene

A curated list of community projects that extend Midscene.js capabilities across different platforms and programming languages.

## Community projects

### iOS automation
- **[midscene-ios](https://github.com/lhuanyu/midscene-ios)** - iOS Mirror Automation Support for Midscene
  - Enables automated testing and interaction with iOS applications
  - Extends Midscene's cross-platform capabilities to Apple's mobile ecosystem

### Python SDK
- **[Midscene-Python](https://github.com/Python51888/Midscene-Python)** - Python SDK for Midscene automation
  - Brings Midscene's AI-powered automation capabilities to Python developers
  - Allows integration with existing Python testing and automation workflows

### Java SDK
- **[midscene-java](https://github.com/Master-Frank/midscene-java)** - Java SDK for Midscene automation
  - Offers a JVM-friendly way to script Midscene experiences similar to the Python SDK
  - Fits easily into existing Java automation or testing pipelines

## Contributing

Have you created a project that extends Midscene.js? We'd love to feature it here!

To add your project to this list, please submit an issue to the [Midscene repository](https://github.com/web-infra-dev/midscene), and tell us your awesome midscene project.

## Criteria for inclusion

Projects featured in Awesome Midscene should:
- Extend or integrate with Midscene.js functionality
- Be actively maintained
- Have clear documentation and usage examples
- Provide value to the Midscene community

---

*Don't see your favorite platform or language supported yet? Consider creating a community project or contributing to existing ones!*
