import { module, test } from 'qunit';

import { setupTest } from 'ember-qunit';

import Adapter from '@ember-data/adapter';
import Model from '@ember-data/model';
import JSONAPISerializer from '@ember-data/serializer/json-api';

module('integration/adapter/serialize - DS.Adapter integration test', function (hooks) {
  setupTest(hooks);

  test('serialize() is delegated to the serializer', function (assert) {
    assert.expect(1);

    class Person extends Model {}

    this.owner.register('model:person', Person);
    this.owner.register('adapter:application', Adapter.extend());
    this.owner.register('serializer:application', class extends JSONAPISerializer {});

    const store = this.owner.lookup('service:store');
    const adapter = store.adapterFor('application');
    const serializer = store.serializerFor('application');

    serializer.serialize = function (snapshot, options) {
      assert.deepEqual(options, { foo: 'bar' });
      return {};
    };

    const person = store.createRecord('person');

    adapter.serialize(person._createSnapshot(), { foo: 'bar' });
  });
});
