import { defineConfig } from 'vite';
import { extensions, ember } from '@embroider/vite';
import { babel } from '@rollup/plugin-babel';

export default defineConfig({
  build: {
    rollupOptions: {
      input: {
        tests: 'index.html',
      },
    },
  },
  plugins: [
    ember(),
    babel({
      babelHelpers: 'inline',
      extensions,
    }),
  ],
  worker: {
    plugins: () => [
      ember(),
      babel({
        babelHelpers: 'inline',
        extensions,
      }),
    ],
  },
});
