# Terminology

**Sections**

- [Data](#data)
  - [Resource](#resource)
  - [Collection](#collection)
  - [Identifier](#identifier)
  - [Document](#document)
  - [RelationshipDocument](#relationshipdocument)
- [Relationships](#relationships)
  - [Inverse](#inverse)
  - [Self Referential](#self-referential)
  - [Reflexive](#reflexive)
  - [Circular](#circular)
  - [Polymorphic](#polymorphic)

---

## Data

WarpDrive treats data "opaquely" meaning that any data format will work so long as you are able to describe to the library
how that data fits into various concepts (usually this is done by implementing a [Cache](/api/@warp-drive/core/types/cache/interfaces/Cache)).

Below, we describe the semantic meaning of these more opaque concepts.

### Resource

A resource is a unit of discretely identifiable data.

Usually resources map to things like rows in a database
with their "type" being derived from the table name.

Discretely identifiable means that given some data, your
app would consistently be able to identify the source of
that data and meaningfully distinguish it from other data.

For instance, in the following JSON we have two distinct
resources:

```jsonc
{
  "users": [
    { "id": 1, "name": "Chris" }, // => resource 1
    { "id": 2, "name": "Rey" } // => resource 2
  ]
}
```

#### Resource Types

Every resource has a string "type". All resources with the same
type are assumed to have the same [schema](#schema).

Types can represent polymorphic traits.

For instance, imagine your API has the notion of an `automobile` resource. Automobiles have an id, a number of wheels, and a name.

```jsonc
{
  "automobiles": [
    { "id": 1, "wheels": 4, "name": "Rivian R1T" }
  ]
}
```

However, every specific automobile belongs to a more specialized type. For instance "pickup" which has the additional [fields](#field) of `length` and `4wd` and "racecar" which has the additional field of `topspeed`.

```jsonc
{
  "pickups": [
    {
      "id": 1,
      "wheels": 4,
      "name": "Rivian R1T",
      "length": "12ft",
      "4wd": true
    }
  ],
  "racecars": [
    {
      "id": 2,
      "wheels": 4,
      "name": "Mazda 787B",
      "topspeed": { "value": 258, "unit": "mph" }
    }
  ]
}
```

In this case, we can refer to both type `pickup` and type `racecar` as satisfying type `automobile`. We refer to `pickup` and `racecar` as "concrete types" and to `automobile` as an `abstract type`. For more, read about [polymorphism in depth](./relational-data/features/polymorphism.md).

### Field

### Schema

### Collection

### Identifier

### Document

### RelationshipDocument

---

## Relationships

### Inverse

The "inverse" of a relationship is the compound key generated by considering both the [type](#resource-types) and the `name` of the matching [field](#field) on the related [resource](#resource) .

E.g. if Users have Pets and Pets have Owners, then the
inverse of the field `user.pets` is `pet.owners`, and the inverse of `pet.owners` is similarly `user.pets`.

> **Note** `to-none` relationships have no inverse. We often refer to this as a `null inverse`.

### Self Referential

Self referential relationships are relationships that point back at the same resource type.

E.g. if a Person has parents and children, the link between `person.parents` and `person.children` is self-referential because both sides belong to the `person` resource type.

### Reflexive

Reflexive relationships are self-referential relationships that point back at the same property in addition to the same type.

For instance, if a User has friends, where `user.friends` is its own inverse.

### Circular

A circular relationship is a self-referential or reflexive relationship for which the *value* is the same on both sides.

For instance, if Ego is his own best friend, then `ego.bestFriend === ego`

### Polymorphic

Polymorphic relationships can be satisfied by multiple resource types. For instance, a user may have many vehicles, and each vehicle might be of type `car` or `boat` or `airplane` etc.
