---
draft: true
---

## Why WarpDrive?

WarpDrive is the data framework for building ambitious applications.

What do we mean by ambitious? WarpDrive is ideal for applications looking to
be best-in-class: whether that's a small todo app, e-commerce, a
social app, or an enterprise b2b software solution.

That's because WarpDrive is designed to seamlessly handle the hardest parts
of state management when building an app, helping you focus on creating the
features and user experiences that drive value.

At its most basic, it is "managed fetch". At its most advanced it is a powerful
local-first or offline-first solution that dedupes and reactively updates requests
across tabs.

Our value goes beyond our feature set. WarpDrive embraces the platform, making it
quick to pickup the basics. Our patterns are portable and scalable, meaning that as
your app, team and data needs evolve we'll be right there with you.

Usage across various rendering frameworks will be similar. In fact, this is an
explicit goal: WarpDrive enables developers to quickly port and re-use data
patterns.

Because we are universal and also not tied to any API Format or backend architecture,
there's no lock-in. The data patterns you learn and the code you write is portable
between frontend frameworks and backend APIs and can help smooth the evolution of both.

We're also not specific to a given frontend architecture. When serving on the same
domain, you can dedupe and cache requests across multiple apps and tabs at once!
This means we are as good for embedded content and MPAs as we are for SPAs.

A single WarpDrive configuration can power multiple web-apps using differing
frameworks all sharing a single domain: bridging the gap between MPA and SPA.

We see this as one of the keys to scalability. Providing a stable framework
for how data is requested, cached, mutated, and mocked allows developers to
focus more time on the product requirements that matter.

Our core philosophy is to deliver value that lasts decades and evolves with your app,
helping you ship, iterate and deliver to your customers.

<br>

## A Very Brief History

WarpDrive began in ~2006 as a suite of ORM-like data utilities in SproutCore that
later evolved into EmberData. Beginning in ~2017 the team plotted a course towards
a significant evolution of the library based on the lessons learned in the first
eleven years.

In ~2023 we lifted the veil on that work, shifting from a resource-centric library
to a request-centric library and began accelerating towards our goal of becoming
a universal library prepared for the demands of web applications over the coming
decades.

<br>

