/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent.atomic;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.Arrays;
import sandbox.java.util.function.BinaryOperator;
import sandbox.java.util.function.UnaryOperator;
import sandbox.sun.misc.Unsafe;

public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private static final Unsafe unsafe;
    private static final int base;
    private static final int shift;
    private static final long arrayFieldOffset;
    private final Object[] array;

    private long checkedByteOffset(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block2;
                int n2 = this.array.length;
                RuntimeCostAccounter.recordJump();
                if (n < n2) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("index ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:(Ljava/lang/String;)V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(string);
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.byteOffset:(I)J");
        return AtomicReferenceArray.byteOffset(n);
    }

    private static long byteOffset(int n) {
        return ((long)n << shift) + (long)base;
    }

    public AtomicReferenceArray(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.array = new Object[n2];
    }

    public AtomicReferenceArray(E[] EArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        int n = EArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
        this.array = Arrays.copyOf(EArray, n, Object[].class);
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.checkedByteOffset:(I)J");
        long l = this.checkedByteOffset(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.getRaw:(J)Ljava/lang/Object;");
        return this.getRaw(l);
    }

    private E getRaw(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getObjectVolatile:(Ljava/lang/Object;J)Ljava/lang/Object;");
        return (E)unsafe.getObjectVolatile((Object)this.array, l);
    }

    public final void set(int n, E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.checkedByteOffset:(I)J");
        long l = this.checkedByteOffset(n);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObjectVolatile:(Ljava/lang/Object;JLjava/lang/Object;)V");
        unsafe.putObjectVolatile((Object)this.array, l, e);
    }

    public final void lazySet(int n, E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.checkedByteOffset:(I)J");
        long l = this.checkedByteOffset(n);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putOrderedObject:(Ljava/lang/Object;JLjava/lang/Object;)V");
        unsafe.putOrderedObject((Object)this.array, l, e);
    }

    public final E getAndSet(int n, E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.checkedByteOffset:(I)J");
        long l = this.checkedByteOffset(n);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getAndSetObject:(Ljava/lang/Object;JLjava/lang/Object;)Ljava/lang/Object;");
        return (E)unsafe.getAndSetObject((Object)this.array, l, e);
    }

    public final boolean compareAndSet(int n, E e, E e2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.checkedByteOffset:(I)J");
        long l = this.checkedByteOffset(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.compareAndSetRaw:(JLjava/lang/Object;Ljava/lang/Object;)Z");
        return this.compareAndSetRaw(l, e, e2);
    }

    private boolean compareAndSetRaw(long l, E e, E e2) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.compareAndSwapObject:(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z");
        return unsafe.compareAndSwapObject((Object)this.array, l, e, e2);
    }

    public final boolean weakCompareAndSet(int n, E e, E e2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.compareAndSet:(ILjava/lang/Object;Ljava/lang/Object;)Z");
        return this.compareAndSet(n, e, e2);
    }

    public final E getAndUpdate(int n, UnaryOperator<E> unaryOperator) {
        E e;
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.checkedByteOffset:(I)J");
        long l = this.checkedByteOffset(n);
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.getRaw:(J)Ljava/lang/Object;");
            e = this.getRaw(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/UnaryOperator.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = unaryOperator.apply(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.compareAndSetRaw:(JLjava/lang/Object;Ljava/lang/Object;)Z");
            bl = this.compareAndSetRaw(l, e, r);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return e;
    }

    public final E updateAndGet(int n, UnaryOperator<E> unaryOperator) {
        Object r;
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.checkedByteOffset:(I)J");
        long l = this.checkedByteOffset(n);
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.getRaw:(J)Ljava/lang/Object;");
            E e = this.getRaw(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/UnaryOperator.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            r = unaryOperator.apply(e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.compareAndSetRaw:(JLjava/lang/Object;Ljava/lang/Object;)Z");
            bl = this.compareAndSetRaw(l, e, r);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return (E)r;
    }

    public final E getAndAccumulate(int n, E e, BinaryOperator<E> binaryOperator) {
        E e2;
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.checkedByteOffset:(I)J");
        long l = this.checkedByteOffset(n);
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.getRaw:(J)Ljava/lang/Object;");
            e2 = this.getRaw(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            Object r = binaryOperator.apply(e2, e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.compareAndSetRaw:(JLjava/lang/Object;Ljava/lang/Object;)Z");
            bl = this.compareAndSetRaw(l, e2, r);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return e2;
    }

    public final E accumulateAndGet(int n, E e, BinaryOperator<E> binaryOperator) {
        Object r;
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.checkedByteOffset:(I)J");
        long l = this.checkedByteOffset(n);
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.getRaw:(J)Ljava/lang/Object;");
            E e2 = this.getRaw(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BinaryOperator.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            r = binaryOperator.apply(e2, e);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.compareAndSetRaw:(JLjava/lang/Object;Ljava/lang/Object;)Z");
            bl = this.compareAndSetRaw(l, e2, r);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return (E)r;
    }

    public String toString() {
        int n = this.array.length - 1;
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            return "[]";
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.byteOffset:(I)J");
            long l = AtomicReferenceArray.byteOffset(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicReferenceArray.getRaw:(J)Ljava/lang/Object;");
            E e = this.getRaw(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            stringBuilder.append(e);
            RuntimeCostAccounter.recordJump();
            if (n2 == n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(']');
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                return stringBuilder2.toString();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder.append(',');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder3.append(' ');
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, InvalidObjectException {
        T[] TArray;
        block5: {
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readFields:()Ljava/io/ObjectInputStream$GetField;");
                ObjectInputStream.GetField getField = objectInputStream.readFields();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.get:(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
                TArray = getField.get("array", null);
                RuntimeCostAccounter.recordJump();
                if (TArray == null) break block4;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = TArray.getClass();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.isArray:()Z");
                boolean bl = clazz.isArray();
                RuntimeCostAccounter.recordJump();
                if (bl) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
            InvalidObjectException invalidObjectException = new InvalidObjectException("Not array type");
            RuntimeCostAccounter.recordThrow();
            throw invalidObjectException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = TArray.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz != Object[].class) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/reflect/Array.getLength:(Ljava/lang/Object;)I");
            int n = Array.getLength(TArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
            TArray = Arrays.copyOf((Object[])TArray, n, Object[].class);
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObjectVolatile:(Ljava/lang/Object;JLjava/lang/Object;)V");
        unsafe.putObjectVolatile((Object)this, arrayFieldOffset, (Object)TArray);
    }

    static {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            unsafe = Unsafe.getUnsafe();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = AtomicReferenceArray.class.getDeclaredField("array");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            arrayFieldOffset = unsafe.objectFieldOffset(field);
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.arrayBaseOffset:(Ljava/lang/Class;)I");
            base = unsafe.arrayBaseOffset(Object[].class);
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.arrayIndexScale:(Ljava/lang/Class;)I");
            int n = unsafe.arrayIndexScale(Object[].class);
            RuntimeCostAccounter.recordJump();
            if ((n & n - 1) != 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/String;)V");
                Error error = new Error("data type scale not a power of two");
                RuntimeCostAccounter.recordThrow();
                throw error;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.numberOfLeadingZeros:(I)I");
            shift = 31 - Integer.numberOfLeadingZeros(n);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }
}

