/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.time.Duration;
import sandbox.java.time.Instant;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.util.Objects;

public abstract class Clock {
    public static Clock systemUTC() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$SystemClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$SystemClock.<init>:(Ljava/time/ZoneId;)V");
        return new SystemClock(ZoneOffset.UTC);
    }

    public static Clock systemDefaultZone() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$SystemClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.systemDefault:()Ljava/time/ZoneId;");
        ZoneId zoneId = ZoneId.systemDefault();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$SystemClock.<init>:(Ljava/time/ZoneId;)V");
        return new SystemClock(zoneId);
    }

    public static Clock system(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$SystemClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$SystemClock.<init>:(Ljava/time/ZoneId;)V");
        return new SystemClock(zoneId);
    }

    public static Clock tickSeconds(ZoneId zoneId) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$TickClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$TickClock.<init>:(Ljava/time/Clock;J)V");
        return new TickClock(clock, 1000000000L);
    }

    public static Clock tickMinutes(ZoneId zoneId) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$TickClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$TickClock.<init>:(Ljava/time/Clock;J)V");
        return new TickClock(clock, 60000000000L);
    }

    public static Clock tick(Clock clock, Duration duration) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "baseClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(duration, "tickDuration");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.isNegative:()Z");
        boolean bl = duration.isNegative();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Tick duration must not be negative");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.toNanos:()J");
        long l = duration.toNanos();
        RuntimeCostAccounter.recordJump();
        if (l % 1000000L == 0L) {
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordJump();
            if (1000000000L % l == 0L) {
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid tick duration");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (l <= 1L) {
            return clock;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$TickClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$TickClock.<init>:(Ljava/time/Clock;J)V");
        return new TickClock(clock, l);
    }

    public static Clock fixed(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(instant, "fixedInstant");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$FixedClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$FixedClock.<init>:(Ljava/time/Instant;Ljava/time/ZoneId;)V");
        return new FixedClock(instant, zoneId);
    }

    public static Clock offset(Clock clock, Duration duration) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "baseClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(duration, "offsetDuration");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.equals:(Ljava/lang/Object;)Z");
        boolean bl = duration.equals(Duration.ZERO);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return clock;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$OffsetClock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$OffsetClock.<init>:(Ljava/time/Clock;Ljava/time/Duration;)V");
        return new OffsetClock(clock, duration);
    }

    protected Clock() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public abstract ZoneId getZone();

    public abstract Clock withZone(ZoneId var1);

    public long millis() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
        Instant instant = this.instant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.toEpochMilli:()J");
        return instant.toEpochMilli();
    }

    public abstract Instant instant();

    public boolean equals(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
        return super.equals(object);
    }

    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.hashCode:()I");
        return super.hashCode();
    }

    static final class TickClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 6504659149906368850L;
        private final Clock baseClock;
        private final long tickNanos;

        TickClock(Clock clock, long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.<init>:()V");
            this.baseClock = clock;
            this.tickNanos = l;
        }

        @Override
        public ZoneId getZone() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
            return this.baseClock.getZone();
        }

        @Override
        public Clock withZone(ZoneId zoneId) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
            ZoneId zoneId2 = this.baseClock.getZone();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
            boolean bl = zoneId.equals(zoneId2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return this;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$TickClock");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.withZone:(Ljava/time/ZoneId;)Ljava/time/Clock;");
            Clock clock = this.baseClock.withZone(zoneId);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$TickClock.<init>:(Ljava/time/Clock;J)V");
            return new TickClock(clock, this.tickNanos);
        }

        @Override
        public long millis() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.millis:()J");
            long l = this.baseClock.millis();
            long l2 = this.tickNanos / 1000000L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
            return l - Math.floorMod(l, l2);
        }

        @Override
        public Instant instant() {
            RuntimeCostAccounter.recordJump();
            if (this.tickNanos % 1000000L == 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.millis:()J");
                long l = this.baseClock.millis();
                long l2 = this.tickNanos / 1000000L;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
                long l3 = l - Math.floorMod(l, l2);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochMilli:(J)Ljava/time/Instant;");
                return Instant.ofEpochMilli(l3);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
            Instant instant = this.baseClock.instant();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getNano:()I");
            long l = instant.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
            long l4 = Math.floorMod(l, this.tickNanos);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.minusNanos:(J)Ljava/time/Instant;");
            return instant.minusNanos(l4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            boolean bl = object instanceof TickClock;
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            TickClock tickClock = (TickClock)object;
            Clock clock = tickClock.baseClock;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = this.baseClock.equals(clock);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            long l = this.tickNanos - tickClock.tickNanos;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l2 != false) return false;
            boolean bl3 = true;
            RuntimeCostAccounter.recordJump();
            return bl3;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.hashCode:()I");
            return this.baseClock.hashCode() ^ (int)(this.tickNanos ^ this.tickNanos >>> 32);
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("TickClock[");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.baseClock);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.ofNanos:(J)Ljava/time/Duration;");
            Duration duration = Duration.ofNanos(this.tickNanos);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(duration);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append("]");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder6.toString();
        }
    }

    static final class OffsetClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 2007484719125426256L;
        private final Clock baseClock;
        private final Duration offset;

        OffsetClock(Clock clock, Duration duration) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.<init>:()V");
            this.baseClock = clock;
            this.offset = duration;
        }

        @Override
        public ZoneId getZone() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
            return this.baseClock.getZone();
        }

        @Override
        public Clock withZone(ZoneId zoneId) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
            ZoneId zoneId2 = this.baseClock.getZone();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
            boolean bl = zoneId.equals(zoneId2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return this;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$OffsetClock");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.withZone:(Ljava/time/ZoneId;)Ljava/time/Clock;");
            Clock clock = this.baseClock.withZone(zoneId);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$OffsetClock.<init>:(Ljava/time/Clock;Ljava/time/Duration;)V");
            return new OffsetClock(clock, this.offset);
        }

        @Override
        public long millis() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.millis:()J");
            long l = this.baseClock.millis();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.toMillis:()J");
            long l2 = this.offset.toMillis();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
            return Math.addExact(l, l2);
        }

        @Override
        public Instant instant() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
            Instant instant = this.baseClock.instant();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/Instant;");
            return instant.plus(this.offset);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            boolean bl = object instanceof OffsetClock;
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            OffsetClock offsetClock = (OffsetClock)object;
            Clock clock = offsetClock.baseClock;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = this.baseClock.equals(clock);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            Duration duration = offsetClock.offset;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.equals:(Ljava/lang/Object;)Z");
            boolean bl3 = this.offset.equals(duration);
            RuntimeCostAccounter.recordJump();
            if (!bl3) return false;
            boolean bl4 = true;
            RuntimeCostAccounter.recordJump();
            return bl4;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.hashCode:()I");
            int n = this.baseClock.hashCode();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.hashCode:()I");
            return n ^ this.offset.hashCode();
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("OffsetClock[");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.baseClock);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this.offset);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append("]");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder6.toString();
        }
    }

    static final class FixedClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 7430389292664866958L;
        private final Instant instant;
        private final ZoneId zone;

        FixedClock(Instant instant, ZoneId zoneId) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.<init>:()V");
            this.instant = instant;
            this.zone = zoneId;
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        @Override
        public Clock withZone(ZoneId zoneId) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
            boolean bl = zoneId.equals(this.zone);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return this;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$FixedClock");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$FixedClock.<init>:(Ljava/time/Instant;Ljava/time/ZoneId;)V");
            return new FixedClock(this.instant, zoneId);
        }

        @Override
        public long millis() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.toEpochMilli:()J");
            return this.instant.toEpochMilli();
        }

        @Override
        public Instant instant() {
            return this.instant;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            boolean bl = object instanceof FixedClock;
            RuntimeCostAccounter.recordJump();
            if (!bl) return false;
            FixedClock fixedClock = (FixedClock)object;
            Instant instant = fixedClock.instant;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = this.instant.equals(instant);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            ZoneId zoneId = fixedClock.zone;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
            boolean bl3 = this.zone.equals(zoneId);
            RuntimeCostAccounter.recordJump();
            if (!bl3) return false;
            boolean bl4 = true;
            RuntimeCostAccounter.recordJump();
            return bl4;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.hashCode:()I");
            int n = this.instant.hashCode();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.hashCode:()I");
            return n ^ this.zone.hashCode();
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("FixedClock[");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.instant);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this.zone);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append("]");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder6.toString();
        }
    }

    static final class SystemClock
    extends Clock
    implements Serializable {
        private static final long serialVersionUID = 6740630888130243051L;
        private final ZoneId zone;

        SystemClock(ZoneId zoneId) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.<init>:()V");
            this.zone = zoneId;
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        @Override
        public Clock withZone(ZoneId zoneId) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
            boolean bl = zoneId.equals(this.zone);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return this;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/Clock$SystemClock");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$SystemClock.<init>:(Ljava/time/ZoneId;)V");
            return new SystemClock(zoneId);
        }

        @Override
        public long millis() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
            return System.currentTimeMillis();
        }

        @Override
        public Instant instant() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock$SystemClock.millis:()J");
            long l = this.millis();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochMilli:(J)Ljava/time/Instant;");
            return Instant.ofEpochMilli(l);
        }

        @Override
        public boolean equals(Object object) {
            boolean bl = object instanceof SystemClock;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                ZoneId zoneId = ((SystemClock)object).zone;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
                return this.zone.equals(zoneId);
            }
            return false;
        }

        @Override
        public int hashCode() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.hashCode:()I");
            return this.zone.hashCode() + 1;
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("SystemClock[");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.zone);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("]");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder4.toString();
        }
    }
}

