/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.BufferedWriter;
import sandbox.java.io.Closeable;
import sandbox.java.io.File;
import sandbox.java.io.FileNotFoundException;
import sandbox.java.io.FileOutputStream;
import sandbox.java.io.FilterOutputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InterruptedIOException;
import sandbox.java.io.OutputStream;
import sandbox.java.io.OutputStreamWriter;
import sandbox.java.io.UnsupportedEncodingException;
import sandbox.java.nio.charset.Charset;
import sandbox.java.nio.charset.IllegalCharsetNameException;
import sandbox.java.nio.charset.UnsupportedCharsetException;
import sandbox.java.util.Formatter;
import sandbox.java.util.Locale;

public class PrintStream
extends FilterOutputStream
implements Appendable,
Closeable {
    private final boolean autoFlush;
    private boolean trouble;
    private Formatter formatter;
    private BufferedWriter textOut;
    private OutputStreamWriter charOut;
    private boolean closing;

    private static <T> T requireNonNull(T t, String string) {
        RuntimeCostAccounter.recordJump();
        if (t == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:(Ljava/lang/String;)V");
            NullPointerException nullPointerException = new NullPointerException(string);
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        return t;
    }

    private static Charset toCharset(String string) throws UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        PrintStream.requireNonNull(string, "charsetName");
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/charset/Charset.forName:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
            return Charset.forName((String)string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException throwable) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/UnsupportedEncodingException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/UnsupportedEncodingException.<init>:(Ljava/lang/String;)V");
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedEncodingException;
        }
    }

    private PrintStream(boolean bl, OutputStream outputStream) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterOutputStream.<init>:(Ljava/io/OutputStream;)V");
        super(outputStream);
        this.trouble = false;
        this.closing = false;
        this.autoFlush = bl;
        RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;)V");
        this.charOut = new OutputStreamWriter(this);
        RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedWriter");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.<init>:(Ljava/io/Writer;)V");
        this.textOut = new BufferedWriter(this.charOut);
    }

    private PrintStream(boolean bl, OutputStream outputStream, Charset charset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterOutputStream.<init>:(Ljava/io/OutputStream;)V");
        super(outputStream);
        this.trouble = false;
        this.closing = false;
        this.autoFlush = bl;
        RuntimeCostAccounter.recordAllocation((String)"java/io/OutputStreamWriter");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.<init>:(Ljava/io/OutputStream;Ljava/nio/charset/Charset;)V");
        this.charOut = new OutputStreamWriter((OutputStream)this, charset);
        RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedWriter");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.<init>:(Ljava/io/Writer;)V");
        this.textOut = new BufferedWriter(this.charOut);
    }

    private PrintStream(boolean bl, Charset charset, OutputStream outputStream) throws UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.<init>:(ZLjava/io/OutputStream;Ljava/nio/charset/Charset;)V");
        this(bl, outputStream, charset);
    }

    public PrintStream(OutputStream outputStream) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.<init>:(Ljava/io/OutputStream;Z)V");
        this(outputStream, false);
    }

    public PrintStream(OutputStream outputStream, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.<init>:(ZLjava/io/OutputStream;)V");
        this(bl, PrintStream.requireNonNull(outputStream, "Null output stream"));
    }

    public PrintStream(OutputStream outputStream, boolean bl, String string) throws UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.toCharset:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
        Charset charset = PrintStream.toCharset(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.<init>:(ZLjava/io/OutputStream;Ljava/nio/charset/Charset;)V");
        this(bl, PrintStream.requireNonNull(outputStream, "Null output stream"), charset);
    }

    public PrintStream(String string) throws FileNotFoundException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/lang/String;)V");
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.<init>:(ZLjava/io/OutputStream;)V");
        this(false, fileOutputStream);
    }

    public PrintStream(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.toCharset:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
        Charset charset = PrintStream.toCharset(string2);
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/lang/String;)V");
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.<init>:(ZLjava/nio/charset/Charset;Ljava/io/OutputStream;)V");
        this(false, charset, fileOutputStream);
    }

    public PrintStream(File file) throws FileNotFoundException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/io/File;)V");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.<init>:(ZLjava/io/OutputStream;)V");
        this(false, fileOutputStream);
    }

    public PrintStream(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.toCharset:(Ljava/lang/String;)Ljava/nio/charset/Charset;");
        Charset charset = PrintStream.toCharset(string);
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/io/File;)V");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.<init>:(ZLjava/nio/charset/Charset;Ljava/io/OutputStream;)V");
        this(false, charset, fileOutputStream);
    }

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.out == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PrintStream printStream = this;
        try {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.flush:()V");
                this.out.flush();
            }
            catch (IOException iOException) {
                this.trouble = true;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block4: {
            PrintStream printStream = this;
            try {
                RuntimeCostAccounter.recordJump();
                if (this.closing) break block4;
                this.closing = true;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.close:()V");
                    this.textOut.close();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.close:()V");
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.trouble = true;
                }
                RuntimeCostAccounter.recordJump();
                this.textOut = null;
                this.charOut = null;
                this.out = null;
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
        }
        RuntimeCostAccounter.recordJump();
    }

    public boolean checkError() {
        RuntimeCostAccounter.recordJump();
        if (this.out != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.flush:()V");
            this.flush();
        }
        boolean bl = this.out instanceof PrintStream;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            PrintStream printStream = (PrintStream)this.out;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.checkError:()Z");
            return printStream.checkError();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    protected void clearError() {
        this.trouble = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        try {
            block5: {
                PrintStream printStream = this;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:(I)V");
                    this.out.write(n);
                    RuntimeCostAccounter.recordJump();
                    if (n != 10) break block5;
                    RuntimeCostAccounter.recordJump();
                    if (!this.autoFlush) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.flush:()V");
                    this.out.flush();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) {
        try {
            block5: {
                PrintStream printStream = this;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.write:([BII)V");
                    this.out.write(byArray, n, n2);
                    RuntimeCostAccounter.recordJump();
                    if (!this.autoFlush) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.flush:()V");
                    this.out.flush();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(char[] cArray) {
        try {
            block7: {
                PrintStream printStream = this;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.write:([C)V");
                    this.textOut.write(cArray);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.flushBuffer:()V");
                    this.textOut.flushBuffer();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.flushBuffer:()V");
                    this.charOut.flushBuffer();
                    RuntimeCostAccounter.recordJump();
                    if (!this.autoFlush) break block7;
                    int n = 0;
                    while (true) {
                        int n2 = cArray.length;
                        RuntimeCostAccounter.recordJump();
                        if (n >= n2) break;
                        char c = cArray[n];
                        RuntimeCostAccounter.recordJump();
                        if (c == '\n') {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.flush:()V");
                            this.out.flush();
                        }
                        ++n;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String string) {
        try {
            block5: {
                PrintStream printStream = this;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.write:(Ljava/lang/String;)V");
                    this.textOut.write(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.flushBuffer:()V");
                    this.textOut.flushBuffer();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.flushBuffer:()V");
                    this.charOut.flushBuffer();
                    RuntimeCostAccounter.recordJump();
                    if (!this.autoFlush) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.indexOf:(I)I");
                    int n = string.indexOf(10);
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.flush:()V");
                    this.out.flush();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            block5: {
                PrintStream printStream = this;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.newLine:()V");
                    this.textOut.newLine();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.flushBuffer:()V");
                    this.textOut.flushBuffer();
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStreamWriter.flushBuffer:()V");
                    this.charOut.flushBuffer();
                    RuntimeCostAccounter.recordJump();
                    if (!this.autoFlush) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.flush:()V");
                    this.out.flush();
                }
                catch (Throwable throwable) {
                    RuntimeCostAccounter.recordThrow();
                    throw throwable;
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
    }

    public void print(boolean bl) {
        String string;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            string = "true";
            RuntimeCostAccounter.recordJump();
        } else {
            string = "false";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(char c) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(C)Ljava/lang/String;");
        String string = String.valueOf(c);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(I)Ljava/lang/String;");
        String string = String.valueOf(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(J)Ljava/lang/String;");
        String string = String.valueOf(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(float f) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(F)Ljava/lang/String;");
        String string = String.valueOf(f);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(double d) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(D)Ljava/lang/String;");
        String string = String.valueOf(d);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(char[] cArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:([C)V");
        this.write(cArray);
    }

    public void print(String string) {
        RuntimeCostAccounter.recordJump();
        if (string == null) {
            string = "null";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void print(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(Ljava/lang/Object;)Ljava/lang/String;");
        String string = String.valueOf(object);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:(Ljava/lang/String;)V");
        this.write(string);
    }

    public void println() {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) {
        PrintStream printStream = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(Z)V");
            this.print(bl);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
            this.newLine();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        PrintStream printStream = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(C)V");
            this.print(c);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
            this.newLine();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n) {
        PrintStream printStream = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(I)V");
            this.print(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
            this.newLine();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        PrintStream printStream = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(J)V");
            this.print(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
            this.newLine();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) {
        PrintStream printStream = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(F)V");
            this.print(f);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
            this.newLine();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        PrintStream printStream = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(D)V");
            this.print(d);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
            this.newLine();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        PrintStream printStream = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:([C)V");
            this.print(cArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
            this.newLine();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        PrintStream printStream = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(Ljava/lang/String;)V");
            this.print(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
            this.newLine();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.valueOf:(Ljava/lang/Object;)Ljava/lang/String;");
        String string = String.valueOf(object);
        PrintStream printStream = this;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(Ljava/lang/String;)V");
            this.print(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.newLine:()V");
            this.newLine();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public PrintStream printf(String string, Object ... objectArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/io/PrintStream;");
        return this.format(string, objectArray);
    }

    public PrintStream printf(Locale locale, String string, Object ... objectArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.format:(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/io/PrintStream;");
        return this.format(locale, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream format(String string, Object ... objectArray) {
        try {
            PrintStream printStream = this;
            try {
                block9: {
                    block8: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.ensureOpen:()V");
                        this.ensureOpen();
                        RuntimeCostAccounter.recordJump();
                        if (this.formatter == null) break block8;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.locale:()Ljava/util/Locale;");
                        Locale locale = this.formatter.locale();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
                        Locale locale2 = Locale.getDefault();
                        RuntimeCostAccounter.recordJump();
                        if (locale == locale2) break block9;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Formatter");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.<init>:(Ljava/lang/Appendable;)V");
                    this.formatter = new Formatter((Appendable)this);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:()Ljava/util/Locale;");
                Locale locale = Locale.getDefault();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.format:(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/Formatter;");
                this.formatter.format(locale, string, objectArray);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintStream format(Locale locale, String string, Object ... objectArray) {
        try {
            PrintStream printStream = this;
            try {
                block9: {
                    block8: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.ensureOpen:()V");
                        this.ensureOpen();
                        RuntimeCostAccounter.recordJump();
                        if (this.formatter == null) break block8;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.locale:()Ljava/util/Locale;");
                        Locale locale2 = this.formatter.locale();
                        RuntimeCostAccounter.recordJump();
                        if (locale2 == locale) break block9;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/util/Formatter");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.<init>:(Ljava/lang/Appendable;Ljava/util/Locale;)V");
                    this.formatter = new Formatter(this, locale);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Formatter.format:(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/Formatter;");
                this.formatter.format(locale, string, objectArray);
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (InterruptedIOException interruptedIOException) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
            Thread thread = Thread.currentThread();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.interrupt:()V");
            thread.interrupt();
            RuntimeCostAccounter.recordJump();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        RuntimeCostAccounter.recordJump();
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence) {
        RuntimeCostAccounter.recordJump();
        if (charSequence == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(Ljava/lang/String;)V");
            this.print("null");
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
            String string = charSequence.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(Ljava/lang/String;)V");
            this.print(string);
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2;
        RuntimeCostAccounter.recordJump();
        if (charSequence == null) {
            charSequence2 = "null";
            RuntimeCostAccounter.recordJump();
        } else {
            charSequence2 = charSequence;
        }
        CharSequence charSequence3 = charSequence2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.subSequence:(II)Ljava/lang/CharSequence;");
        CharSequence charSequence4 = charSequence3.subSequence(n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
        String string = charSequence4.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.write:(Ljava/lang/String;)V");
        this.write(string);
        return this;
    }

    @Override
    public PrintStream append(char c) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PrintStream.print:(C)V");
        this.print(c);
        return this;
    }
}

