# Replay

The replay script is able to take a dumped genesis file and set up a new localnet directory for local replays.

Once the localnet is running (launched separately), it can also send to the localnet node a dumped tranaction trace, generated by `dump_tx`.

Prerequisites:

* `[PREREQ1]` path of a dumped genesis file representing a state (generated by `dump_state`, docs: https://github.com/near/nearcore/blob/master/tools/state-viewer/README.md)

* `[PREREQ2]` path of a dumped transaction trace (generated by `dump_tx`, docs: https://github.com/near/nearcore/blob/master/tools/state-viewer/README.md)

* `[PREREQ3]` a localnet home path containing directory `node0/`, under which a valid `config.json` file exists for localnet use


In order to set up and launch replay, we take the following steps:

Make sure you have the right enviroment variables:
```shell
export PYTHONPATH=./pytest/lib
```

First, build the binary.
```shell
cargo build -p neard --release
```

Second, run `generate`:
```shell
python3 pytest/tests/replay/replay.py generate --genesis [PREREQ1] --home-dir [PREREQ3]
```

Third, launch the localnet node using outputs from `generate` under `--home-dir`. Hints on the screen.

Fourth, run `send`:
```shell
python3 pytest/tests/replay/replay.py send --tx-json [PREREQ2] --home-dir [PREREQ3]
```

Now the localnet db contains a dense trace of the txs dumped, replayed on the dumped genesis.
