import { resolve } from 'node:path'
import { expect, it } from 'vitest'
import { getPackageExportsManifest } from 'vitest-package-exports'
import { rolldownVersion } from 'vitest/node'

it('exports snapshot', async ({ skip, task }) => {
  skip(task.file.pool !== 'threads', 'run only once inside threads')

  const manifest = await getPackageExportsManifest({
    importMode: 'package', // or 'dist' or 'package'
    cwd: resolve(import.meta.dirname, '../../../packages/vitest'),
    resolveExportEntries(entries) {
      return entries.filter(([key]) => key !== './browser')
    },
  })

  if (rolldownVersion) {
    expect(manifest.exports)
      .toMatchInlineSnapshot(`
      {
        ".": {
          "EvaluatedModules": "function",
          "afterAll": "function",
          "afterEach": "function",
          "assert": "function",
          "assertType": "function",
          "beforeAll": "function",
          "beforeEach": "function",
          "bench": "function",
          "chai": "object",
          "createExpect": "function",
          "describe": "function",
          "expect": "function",
          "expectTypeOf": "function",
          "inject": "function",
          "it": "function",
          "onTestFailed": "function",
          "onTestFinished": "function",
          "recordArtifact": "function",
          "should": "function",
          "suite": "function",
          "test": "function",
          "vi": "object",
          "vitest": "object",
        },
        "./config": {
          "configDefaults": "object",
          "coverageConfigDefaults": "object",
          "defaultBrowserPort": "number",
          "defaultExclude": "object",
          "defaultInclude": "object",
          "defineConfig": "function",
          "defineProject": "function",
          "mergeConfig": "function",
        },
        "./coverage": {
          "BaseCoverageProvider": "function",
        },
        "./environments": {
          "builtinEnvironments": "object",
          "populateGlobal": "function",
        },
        "./internal/browser": {
          "DecodedMap": "function",
          "SpyModule": "object",
          "__INTERNAL": "object",
          "collectTests": "function",
          "format": "function",
          "getOriginalPosition": "function",
          "getSafeTimers": "function",
          "getType": "function",
          "inspect": "function",
          "loadDiffConfig": "function",
          "loadSnapshotSerializers": "function",
          "processError": "function",
          "setSafeTimers": "function",
          "setupCommonEnv": "function",
          "startCoverageInsideWorker": "function",
          "startTests": "function",
          "stopCoverageInsideWorker": "function",
          "stringify": "function",
          "takeCoverageInsideWorker": "function",
        },
        "./internal/module-runner": {
          "VITEST_VM_CONTEXT_SYMBOL": "string",
          "VitestModuleEvaluator": "function",
          "VitestModuleRunner": "function",
          "getWorkerState": "function",
          "startVitestModuleRunner": "function",
        },
        "./mocker": {
          "AutomockedModule": "function",
          "AutospiedModule": "function",
          "ManualMockedModule": "function",
          "MockerRegistry": "function",
          "RedirectedModule": "function",
          "mockObject": "function",
        },
        "./node": {
          "BaseRuntime": "function",
          "BaseSequencer": "function",
          "ForksRuntime": "function",
          "GitNotFoundError": "function",
          "TestsNotFoundError": "function",
          "ThreadsRuntime": "function",
          "TypecheckRuntime": "function",
          "VitestPackageInstaller": "function",
          "VitestPlugin": "function",
          "VmForksRuntime": "function",
          "VmThreadsRuntime": "function",
          "createDebugger": "function",
          "createMethodsRPC": "function",
          "createViteLogger": "function",
          "createViteServer": "function",
          "createVitest": "function",
          "distDir": "string",
          "esbuildVersion": "string",
          "escapeTestName": "function",
          "experimental_getRunnerTask": "function",
          "generateFileHash": "function",
          "getFilePoolName": "function",
          "isCSSRequest": "function",
          "isFileServingAllowed": "function",
          "isValidApiRequest": "function",
          "parseAst": "function",
          "parseAstAsync": "function",
          "parseCLI": "function",
          "registerConsoleShortcuts": "function",
          "resolveApiServerConfig": "function",
          "resolveConfig": "function",
          "resolveFsAllow": "function",
          "rolldownVersion": "string",
          "rollupVersion": "string",
          "rootDir": "string",
          "startVitest": "function",
          "version": "string",
          "viteVersion": "string",
        },
        "./reporters": {
          "BenchmarkReporter": "function",
          "BenchmarkReportsMap": "object",
          "DefaultReporter": "function",
          "DotReporter": "function",
          "GithubActionsReporter": "function",
          "HangingProcessReporter": "function",
          "JUnitReporter": "function",
          "JsonReporter": "function",
          "ReportersMap": "object",
          "TapFlatReporter": "function",
          "TapReporter": "function",
          "VerboseBenchmarkReporter": "function",
          "VerboseReporter": "function",
        },
        "./runners": {
          "NodeBenchmarkRunner": "function",
          "VitestTestRunner": "function",
        },
        "./snapshot": {
          "VitestSnapshotEnvironment": "function",
        },
        "./suite": {
          "createChainable": "function",
          "createTaskCollector": "function",
          "getBenchFn": "function",
          "getBenchOptions": "function",
          "getCurrentSuite": "function",
          "getCurrentTest": "function",
          "getFn": "function",
          "getHooks": "function",
          "setFn": "function",
          "setHooks": "function",
        },
        "./workers": {
          "collectVitestWorkerTests": "function",
          "provideWorkerState": "function",
          "runBaseTests": "function",
          "runVitestWorker": "function",
          "runVmTests": "function",
        },
      }
    `)
  }
  else {
    expect(manifest.exports)
      .toMatchInlineSnapshot(`
        {
          ".": {
            "EvaluatedModules": "function",
            "afterAll": "function",
            "afterEach": "function",
            "assert": "function",
            "assertType": "function",
            "beforeAll": "function",
            "beforeEach": "function",
            "bench": "function",
            "chai": "object",
            "createExpect": "function",
            "describe": "function",
            "expect": "function",
            "expectTypeOf": "function",
            "inject": "function",
            "it": "function",
            "onTestFailed": "function",
            "onTestFinished": "function",
            "recordArtifact": "function",
            "should": "function",
            "suite": "function",
            "test": "function",
            "vi": "object",
            "vitest": "object",
          },
          "./config": {
            "configDefaults": "object",
            "coverageConfigDefaults": "object",
            "defaultBrowserPort": "number",
            "defaultExclude": "object",
            "defaultInclude": "object",
            "defineConfig": "function",
            "defineProject": "function",
            "mergeConfig": "function",
          },
          "./coverage": {
            "BaseCoverageProvider": "function",
          },
          "./environments": {
            "builtinEnvironments": "object",
            "populateGlobal": "function",
          },
          "./internal/browser": {
            "DecodedMap": "function",
            "SpyModule": "object",
            "__INTERNAL": "object",
            "collectTests": "function",
            "format": "function",
            "getOriginalPosition": "function",
            "getSafeTimers": "function",
            "getType": "function",
            "inspect": "function",
            "loadDiffConfig": "function",
            "loadSnapshotSerializers": "function",
            "processError": "function",
            "setSafeTimers": "function",
            "setupCommonEnv": "function",
            "startCoverageInsideWorker": "function",
            "startTests": "function",
            "stopCoverageInsideWorker": "function",
            "stringify": "function",
            "takeCoverageInsideWorker": "function",
          },
          "./internal/module-runner": {
            "VITEST_VM_CONTEXT_SYMBOL": "string",
            "VitestModuleEvaluator": "function",
            "VitestModuleRunner": "function",
            "getWorkerState": "function",
            "startVitestModuleRunner": "function",
          },
          "./mocker": {
            "AutomockedModule": "function",
            "AutospiedModule": "function",
            "ManualMockedModule": "function",
            "MockerRegistry": "function",
            "RedirectedModule": "function",
            "mockObject": "function",
          },
          "./node": {
            "BaseSequencer": "function",
            "ForksPoolWorker": "function",
            "GitNotFoundError": "function",
            "TestsNotFoundError": "function",
            "ThreadsPoolWorker": "function",
            "TypecheckPoolWorker": "function",
            "VitestPackageInstaller": "function",
            "VitestPlugin": "function",
            "VmForksPoolWorker": "function",
            "VmThreadsPoolWorker": "function",
            "createDebugger": "function",
            "createMethodsRPC": "function",
            "createViteLogger": "function",
            "createViteServer": "function",
            "createVitest": "function",
            "distDir": "string",
            "esbuildVersion": "string",
            "escapeTestName": "function",
            "experimental_getRunnerTask": "function",
            "generateFileHash": "function",
            "getFilePoolName": "function",
            "isCSSRequest": "function",
            "isFileServingAllowed": "function",
            "isValidApiRequest": "function",
            "parseAst": "function",
            "parseAstAsync": "function",
            "parseCLI": "function",
            "registerConsoleShortcuts": "function",
            "resolveApiServerConfig": "function",
            "resolveConfig": "function",
            "resolveFsAllow": "function",
            "rolldownVersion": "undefined",
            "rollupVersion": "string",
            "rootDir": "string",
            "startVitest": "function",
            "version": "string",
            "viteVersion": "string",
          },
          "./reporters": {
            "BenchmarkReporter": "function",
            "BenchmarkReportsMap": "object",
            "DefaultReporter": "function",
            "DotReporter": "function",
            "GithubActionsReporter": "function",
            "HangingProcessReporter": "function",
            "JUnitReporter": "function",
            "JsonReporter": "function",
            "ReportersMap": "object",
            "TapFlatReporter": "function",
            "TapReporter": "function",
            "VerboseBenchmarkReporter": "function",
            "VerboseReporter": "function",
          },
          "./runners": {
            "NodeBenchmarkRunner": "function",
            "VitestTestRunner": "function",
          },
          "./snapshot": {
            "VitestSnapshotEnvironment": "function",
          },
          "./suite": {
            "createChainable": "function",
            "createTaskCollector": "function",
            "getBenchFn": "function",
            "getBenchOptions": "function",
            "getCurrentSuite": "function",
            "getCurrentTest": "function",
            "getFn": "function",
            "getHooks": "function",
            "setFn": "function",
            "setHooks": "function",
          },
          "./worker": {
            "init": "function",
            "runBaseTests": "function",
          },
        }
      `)
  }
})
