# Changelog

All notable changes to this project will be documented in this file. See [standard-version](https://github.com/conventional-changelog/standard-version) for commit guidelines.

## v1.5.4

[compare changes](https://github.com/unjs/listhen/compare/v1.5.3...v1.5.4)

### 🩹 Fixes

- Use `localhost` when host is empty for `getURL` ([9ec7d77](https://github.com/unjs/listhen/commit/9ec7d77))

### 📖 Documentation

- Fix typo ([#127](https://github.com/unjs/listhen/pull/127))

### 🏡 Chore

- **release:** V1.5.3 ([c8d2ef9](https://github.com/unjs/listhen/commit/c8d2ef9))
- Remove unnecessary fallback ([e66b82b](https://github.com/unjs/listhen/commit/e66b82b))
- Update lockfile ([917abc1](https://github.com/unjs/listhen/commit/917abc1))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))
- Tech Genius

## v1.5.3

[compare changes](https://github.com/unjs/listhen/compare/v1.5.2...v1.5.3)

### 🩹 Fixes

- Correct private host warning message ([df5ff4d](https://github.com/unjs/listhen/commit/df5ff4d))
- Prefer explicit `hostname` option over `HOST` env ([0674d96](https://github.com/unjs/listhen/commit/0674d96))

### 🏡 Chore

- **release:** V1.5.2 ([1aab0dd](https://github.com/unjs/listhen/commit/1aab0dd))
- Revert to `codecov/codecov-action@v3` ([c911a1f](https://github.com/unjs/listhen/commit/c911a1f))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.5.2

[compare changes](https://github.com/unjs/listhen/compare/v1.5.1...v1.5.2)

### 🔥 Performance

- Imprve default host for windows, docker and wsl ([#126](https://github.com/unjs/listhen/pull/126))

### 💅 Refactors

- Use `std-env` for stackblitz detection ([933c0c3](https://github.com/unjs/listhen/commit/933c0c3))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.5.1

[compare changes](https://github.com/unjs/listhen/compare/v1.5.0...v1.5.1)

### 🩹 Fixes

- Open browser on wsl ([#124](https://github.com/unjs/listhen/pull/124))

### 🏡 Chore

- **release:** V1.5.0 ([da86eaa](https://github.com/unjs/listhen/commit/da86eaa))
- Update dependencies ([ca623b2](https://github.com/unjs/listhen/commit/ca623b2))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))
- Sacha Stafyniak <sacha.stafyniak@gmail.com>

## v1.5.0

[compare changes](https://github.com/unjs/listhen/compare/v1.4.8...v1.5.0)

### 🚀 Enhancements

- Trap `SIGINT`, `SIGTERM` and `SIGHUP` for autoclosing ([#108](https://github.com/unjs/listhen/pull/108))

### 🩹 Fixes

- Allow valid ipv6 as hostnames ([78dd4b7](https://github.com/unjs/listhen/commit/78dd4b7))

### 🏡 Chore

- Update deps ([7d34ab9](https://github.com/unjs/listhen/commit/7d34ab9))

### ❤️ Contributors

- Mastercuber <e4d33vb85@mozmail.com>
- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.4.8

[compare changes](https://github.com/unjs/listhen/compare/v1.4.7...v1.4.8)

### 🩹 Fixes

- Type and provide `listener.address` ([972fac7](https://github.com/unjs/listhen/commit/972fac7))

### 🏡 Chore

- Update get-port-please and jiti ([8be655c](https://github.com/unjs/listhen/commit/8be655c))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.4.7

[compare changes](https://github.com/unjs/listhen/compare/v1.4.6...v1.4.7)

### 🩹 Fixes

- Validate hostname after applying defaults ([e6c1b89](https://github.com/unjs/listhen/commit/e6c1b89))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.4.6

[compare changes](https://github.com/unjs/listhen/compare/v1.4.5...v1.4.6)

### 🩹 Fixes

- Validate input hostname and warn ([bfc8149](https://github.com/unjs/listhen/commit/bfc8149))

### 🏡 Chore

- Remove `console.log` ([aee15da](https://github.com/unjs/listhen/commit/aee15da))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.4.5

[compare changes](https://github.com/unjs/listhen/compare/v1.4.4...v1.4.5)

### 🩹 Fixes

- Update `get-port-please` and pass `public` flag ([3de5b10](https://github.com/unjs/listhen/commit/3de5b10))
- **cli:** Remove `default: false` for opt-in flag ([180c685](https://github.com/unjs/listhen/commit/180c685))

### 🏡 Chore

- **release:** V1.4.4 ([8972953](https://github.com/unjs/listhen/commit/8972953))
- Remove watcher github link ([bb2b9f1](https://github.com/unjs/listhen/commit/bb2b9f1))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.4.4

[compare changes](https://github.com/unjs/listhen/compare/v1.4.3...v1.4.4)

### 🩹 Fixes

- Use ipv4 for windows and wsl default hostname ([#119](https://github.com/unjs/listhen/pull/119))

### 💅 Refactors

- Tidy up `open`, `wsl`, and `docker` utils ([#118](https://github.com/unjs/listhen/pull/118))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.4.3

[compare changes](https://github.com/unjs/listhen/compare/v1.4.2...v1.4.3)

### 🩹 Fixes

- Prevent double brackets for ipv6 format ([2110e40](https://github.com/unjs/listhen/commit/2110e40))

### 🏡 Chore

- Update playground version ([f9f1be3](https://github.com/unjs/listhen/commit/f9f1be3))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.4.2

[compare changes](https://github.com/unjs/listhen/compare/v1.4.1...v1.4.2)

### 🩹 Fixes

- Better options handling for public host ([#112](https://github.com/unjs/listhen/pull/112))
- **cli:** Handle `--host` with boolean value ([#113](https://github.com/unjs/listhen/pull/113))
- Several bugfixes for generated urls ([#114](https://github.com/unjs/listhen/pull/114))

### 💅 Refactors

- Show qr code above listening urls ([#115](https://github.com/unjs/listhen/pull/115))

### 🏡 Chore

- **release:** V1.4.1 ([a5bf8db](https://github.com/unjs/listhen/commit/a5bf8db))
- Update playground versions ([e15fc57](https://github.com/unjs/listhen/commit/e15fc57))
- Update dependencies ([b8840f8](https://github.com/unjs/listhen/commit/b8840f8))
- Update lockfile ([d91d4ef](https://github.com/unjs/listhen/commit/d91d4ef))
- Remove emoji ([e4d0037](https://github.com/unjs/listhen/commit/e4d0037))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.4.1

[compare changes](https://github.com/unjs/listhen/compare/v1.4.0...v1.4.1)

### 🩹 Fixes

- **dev:** Update `@parcel/watcher-wasm` usage to 2.3.0 ([329230a](https://github.com/unjs/listhen/commit/329230a))

### 🏡 Chore

- Update dependencies ([b6b8a9c](https://github.com/unjs/listhen/commit/b6b8a9c))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.4.0

[compare changes](https://github.com/unjs/listhen/compare/v1.3.1...v1.4.0)

### 🚀 Enhancements

- **cli:** Expose `getArgs` and `parseArgs` ([#109](https://github.com/unjs/listhen/pull/109))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.3.1

[compare changes](https://github.com/unjs/listhen/compare/v1.3.0...v1.3.1)

### 🩹 Fixes

- Update qr code padding ([#105](https://github.com/unjs/listhen/pull/105))
- Use unicode char for network placeholder ([e80f658](https://github.com/unjs/listhen/commit/e80f658))

### 🏡 Chore

- Update dependencies ([f187156](https://github.com/unjs/listhen/commit/f187156))
- Lint ([275e6bc](https://github.com/unjs/listhen/commit/275e6bc))

### ❤️ Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))
- Anthony Fu <anthonyfu117@hotmail.com>

## v1.3.0

[compare changes](https://github.com/unjs/listhen/compare/v1.2.2...v1.3.0)

### 🚀 Enhancements

- Print qr code for public address ([#89](https://github.com/unjs/listhen/pull/89))
- `qr` and `publicURL` options and `--qr`, `--no-qr`, and `--public-url` cli flags ([#97](https://github.com/unjs/listhen/pull/97))
- `public` option and `--host` flag to disable network expose in development by default ([#98](https://github.com/unjs/listhen/pull/98))
- Stackblitz auto url detection (experimental) ([#99](https://github.com/unjs/listhen/pull/99))
- **cli:** Accept `https.*` options ([#93](https://github.com/unjs/listhen/pull/93))
- Tunnel support via `unjs/untun` and `cloudflared` (experimental) ([#102](https://github.com/unjs/listhen/pull/102))

### 🔥 Performance

- **dev:** Use `@parcel/watcher` whenever available ([#95](https://github.com/unjs/listhen/pull/95))

### 🩹 Fixes

- **dev:** Try to resolve h3 from user `node_modules` first ([#94](https://github.com/unjs/listhen/pull/94))
- **dev:** Show better error for when no compatible handler is exported ([#92](https://github.com/unjs/listhen/pull/92))

### 💅 Refactors

- Better watcher warning message ([ec92cf4](https://github.com/unjs/listhen/commit/ec92cf4))
- Fix option types and handling ([ad82a70](https://github.com/unjs/listhen/commit/ad82a70))
- Use consistent emojies ([4b26902](https://github.com/unjs/listhen/commit/4b26902))
- Simplify console output ([e741be0](https://github.com/unjs/listhen/commit/e741be0))

### 🏡 Chore

- **release:** V1.2.2 ([fb01a23](https://github.com/unjs/listhen/commit/fb01a23))
- Update readme ([4169f50](https://github.com/unjs/listhen/commit/4169f50))
- Update readme ([1a6eaac](https://github.com/unjs/listhen/commit/1a6eaac))
- **cli:** Fix typo and avoid exposing internal util ([0c55c9c](https://github.com/unjs/listhen/commit/0c55c9c))
- **cli:** Remove accidental console log ([bd2b5d6](https://github.com/unjs/listhen/commit/bd2b5d6))
- Update playground ([1dbb809](https://github.com/unjs/listhen/commit/1dbb809))
- Update readme ([b45be3f](https://github.com/unjs/listhen/commit/b45be3f))
- Update readme ([10ad172](https://github.com/unjs/listhen/commit/10ad172))

### ✅ Tests

- Fix order mismatch ([#90](https://github.com/unjs/listhen/pull/90))
- **setup:** Extend certificate generation to also write ca.pem, ca-key.pem and certificate chain to files ([#103](https://github.com/unjs/listhen/pull/103))

### ❤️  Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))
- Mastercuber <e4d33vb85@mozmail.com>
- Anthony Fu <anthonyfu117@hotmail.com>

## v1.2.2

[compare changes](https://github.com/unjs/listhen/compare/v1.2.1...v1.2.2)

### 🩹 Fixes

- **watcher:** Use `@parcel/watcher-wasm` for non node.js environment compatibility ([#85](https://github.com/unjs/listhen/pull/85))

### ❤️  Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.2.1

[compare changes](https://github.com/unjs/listhen/compare/v1.2.0...v1.2.1)

### 🩹 Fixes

- Avoid directly importing `availableParallelism` from os ([bdd8771](https://github.com/unjs/listhen/commit/bdd8771))

### ❤️  Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.2.0

[compare changes](https://github.com/unjs/listhen/compare/v1.1.2...v1.2.0)

### 🚀 Enhancements

- Improve watcher experience ([#82](https://github.com/unjs/listhen/pull/82))
- Dev server with serve static support ([#83](https://github.com/unjs/listhen/pull/83))
- **https:** Support using encrypted private key and pkcs12 (pfx) keystore ([#80](https://github.com/unjs/listhen/pull/80))

### 🩹 Fixes

- **watcher:** Resolve relative paths without leading dot ([c8388f1](https://github.com/unjs/listhen/commit/c8388f1))

### 🏡 Chore

- Update dependencies ([1a7a974](https://github.com/unjs/listhen/commit/1a7a974))
- Update playground ([028b5c9](https://github.com/unjs/listhen/commit/028b5c9))
- Update lockfile ([cd9f66a](https://github.com/unjs/listhen/commit/cd9f66a))
- Update usage to include h3 ([ede3999](https://github.com/unjs/listhen/commit/ede3999))

### 🤖 CI

- Use conventional commit for autofix action ([#79](https://github.com/unjs/listhen/pull/79))

### ❤️  Contributors

- Mastercuber <e4d33vb85@mozmail.com>
- Pooya Parsa ([@pi0](http://github.com/pi0))
- Daniel Roe <daniel@roe.dev>

## v1.1.2

[compare changes](https://github.com/unjs/listhen/compare/v1.1.1...v1.1.2)

### 📦 Build

- Fix bin entries ([c6dbc80](https://github.com/unjs/listhen/commit/c6dbc80))

### ❤️  Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.1.1

[compare changes](https://github.com/unjs/listhen/compare/v1.1.0...v1.1.1)

### 📦 Build

- Include `bin` in npm dist files ([03e66b0](https://github.com/unjs/listhen/commit/03e66b0))

### ❤️  Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))

## v1.1.0

[compare changes](https://github.com/unjs/listhen/compare/v1.0.4...v1.1.0)

### 🚀 Enhancements

- Support basic `listenAndWatch` ([#74](https://github.com/unjs/listhen/pull/74))
- `listhen` cli ([#75](https://github.com/unjs/listhen/pull/75))

### 💅 Refactors

- Split code ([c6fd01e](https://github.com/unjs/listhen/commit/c6fd01e))
- Use `consola/utils` for color utils ([f7a4f3b](https://github.com/unjs/listhen/commit/f7a4f3b))

### 📦 Build

- Remove non existing `cjs` dist from `exports` ([#69](https://github.com/unjs/listhen/pull/69))
- Move `types` field to the first ([5abd82c](https://github.com/unjs/listhen/commit/5abd82c))
- Fix cjs compatibility ([65d667c](https://github.com/unjs/listhen/commit/65d667c))

### 🏡 Chore

- Update dependencies ([92e94fb](https://github.com/unjs/listhen/commit/92e94fb))
- Format code ([5590480](https://github.com/unjs/listhen/commit/5590480))
- Add autofix ci ([c2e6b85](https://github.com/unjs/listhen/commit/c2e6b85))
- Add missing type import ([448d3c9](https://github.com/unjs/listhen/commit/448d3c9))
- Fix type import ([174e9fe](https://github.com/unjs/listhen/commit/174e9fe))

### ❤️  Contributors

- Pooya Parsa ([@pi0](http://github.com/pi0))
- Daniel Roe <daniel@roe.dev>

## v1.0.4

[compare changes](https://github.com/unjs/listhen/compare/v1.0.3...v1.0.4)


### 🩹 Fixes

  - Add default port range ([#63](https://github.com/unjs/listhen/pull/63))

### 📖 Documentation

  - Update badges and content ([b7cf9ad](https://github.com/unjs/listhen/commit/b7cf9ad))

### 🏡 Chore

  - Remove extra badges ([767c9ed](https://github.com/unjs/listhen/commit/767c9ed))

### ❤️  Contributors

- Sébastien Chopin ([@Atinux](http://github.com/Atinux))

## v1.0.3

[compare changes](https://github.com/unjs/listhen/compare/v1.0.2...v1.0.3)


### 🏡 Chore

  - Update ufo and other dependencies ([d3db211](https://github.com/unjs/listhen/commit/d3db211))

### ❤️  Contributors

- Pooya Parsa <pooya@pi0.io>

## v1.0.2

[compare changes](https://github.com/unjs/listhen/compare/v1.0.1...v1.0.2)


### 🏡 Chore

  - Upgrade deps ([#55](https://github.com/unjs/listhen/pull/55))
  - Update deps ([18d7542](https://github.com/unjs/listhen/commit/18d7542))
  - Switch to changelogen for release ([7c1bf04](https://github.com/unjs/listhen/commit/7c1bf04))

### 🎨 Styles

  - Format with prettier ([bb2aa4d](https://github.com/unjs/listhen/commit/bb2aa4d))

### ❤️  Contributors

- Pooya Parsa <pooya@pi0.io>
- Farnabaz <farnabaz@gmail.com>

### [1.0.1](https://github.com/unjs/listhen/compare/v1.0.0...v1.0.1) (2022-11-28)


### Bug Fixes

* pass port options object to `getPort` ([#47](https://github.com/unjs/listhen/issues/47)) ([8cc07e0](https://github.com/unjs/listhen/commit/8cc07e0adc82260e52454e64b090b333c6a65e94))

## [1.0.0](https://github.com/unjs/listhen/compare/v0.3.5...v1.0.0) (2022-11-15)

### [0.3.5](https://github.com/unjs/listhen/compare/v0.3.4...v0.3.5) (2022-11-02)


### Bug Fixes

* respect hostname when opening url ([#40](https://github.com/unjs/listhen/issues/40)) ([d1e985d](https://github.com/unjs/listhen/commit/d1e985dc6c28f30283593811a285ce7796bbcc88))

### [0.3.4](https://github.com/unjs/listhen/compare/v0.3.3...v0.3.4) (2022-09-20)


### Bug Fixes

* add custom hostname to alternative domains ([d7ffa58](https://github.com/unjs/listhen/commit/d7ffa582fc931e4753557e3082a11e657ce6ab37))
* fix type for `https` only for listener instead of options ([59a2c76](https://github.com/unjs/listhen/commit/59a2c7654089c5157b95f85269acba51025fbb43))

### [0.3.3](https://github.com/unjs/listhen/compare/v0.3.2...v0.3.3) (2022-09-20)


### Bug Fixes

* narrow down listener.https type ([c8279e2](https://github.com/unjs/listhen/commit/c8279e230865236781e428ece49c01fe523f90b7))

### [0.3.2](https://github.com/unjs/listhen/compare/v0.3.1...v0.3.2) (2022-09-20)


### Features

* expose resolve https options ([84023f4](https://github.com/unjs/listhen/commit/84023f471635fd76696f62a66b2d22534c4194aa))


### Bug Fixes

* display provided hostname ([ee1df6d](https://github.com/unjs/listhen/commit/ee1df6d622f172a351e897db7597f1c62a47a8cd))

### [0.3.1](https://github.com/unjs/listhen/compare/v0.3.0...v0.3.1) (2022-09-15)


### Features

* ipv6 support ([eb9f5ef](https://github.com/unjs/listhen/commit/eb9f5ef436be6dc0242bcf2f560c7713fcda736f))

## [0.3.0](https://github.com/unjs/listhen/compare/v0.2.15...v0.3.0) (2022-09-15)


### ⚠ BREAKING CHANGES

* `certificate` and `selfsigned` options are merged with `https`

### Features

* improved ssl support ([71256e6](https://github.com/unjs/listhen/commit/71256e6980af11c510c2bcde72534bb400a37098))

### [0.2.15](https://github.com/unjs/listhen/compare/v0.2.14...v0.2.15) (2022-08-08)


### Bug Fixes

* **deps:** update get-port please ([d0267d8](https://github.com/unjs/listhen/commit/d0267d8008f2bc0b97bfa3273f1ac8b5c6f2b8c4))

### [0.2.14](https://github.com/unjs/listhen/compare/v0.2.13...v0.2.14) (2022-08-08)


### Features

* update ger-port-please with verbose error ([8e6f023](https://github.com/unjs/listhen/commit/8e6f023489a58929dcf88c35d1cc26731727a9fb))


### Bug Fixes

* pass hostname to `getPort` as well ([#34](https://github.com/unjs/listhen/issues/34)) ([0ced0a4](https://github.com/unjs/listhen/commit/0ced0a46937ff8d19613ff9905f078a6b0643d5c))

### [0.2.13](https://github.com/unjs/listhen/compare/v0.2.12...v0.2.13) (2022-06-15)


### Bug Fixes

* avoid double `//` at end of url ([#30](https://github.com/unjs/listhen/issues/30)) ([2322064](https://github.com/unjs/listhen/commit/23220641333237a2b8df8983ed33ec4231386557))

### [0.2.12](https://github.com/unjs/listhen/compare/v0.2.11...v0.2.12) (2022-06-13)


### Features

* option to show baseURL in `showURL` ([#28](https://github.com/unjs/listhen/issues/28)) ([4ce9347](https://github.com/unjs/listhen/commit/4ce93479f2767647cd7b2fb68ed7e2923f245b19))

### [0.2.11](https://github.com/unjs/listhen/compare/v0.2.10...v0.2.11) (2022-04-25)


### Bug Fixes

* properly invoke isWsl as a function ([#22](https://github.com/unjs/listhen/issues/22)) ([2951376](https://github.com/unjs/listhen/commit/295137644b50f8d3a909091f88bdcb232d060157)), closes [nuxt/framework#4495](https://github.com/nuxt/framework/issues/4495)

### [0.2.10](https://github.com/unjs/listhen/compare/v0.2.9...v0.2.10) (2022-04-16)


### Bug Fixes

* bundle `xdg-open` as an async chunk ([890a4a9](https://github.com/unjs/listhen/commit/890a4a9b2569401b86e14b85e2d0b1d6d0e91d7e))

### [0.2.9](https://github.com/unjs/listhen/compare/v0.2.8...v0.2.9) (2022-04-15)


### Bug Fixes

* inline `open` package for esm bundling support ([3c2948f](https://github.com/unjs/listhen/commit/3c2948f7432fb29c7cb9d020c20a7bb5cd83b253)), closes [nuxt/framework#4352](https://github.com/nuxt/framework/issues/4352)
* use `options.hostname` for listening ([#19](https://github.com/unjs/listhen/issues/19)) ([10164d5](https://github.com/unjs/listhen/commit/10164d5931fd5511298f84b0f786dcdc2138856a))

### [0.2.8](https://github.com/unjs/listhen/compare/v0.2.7...v0.2.8) (2022-04-07)

### [0.2.7](https://github.com/unjs/listhen/compare/v0.2.6...v0.2.7) (2022-04-07)


### Bug Fixes

* update ssl keySize to 2048 ([f63967b](https://github.com/unjs/listhen/commit/f63967bfee8444f1d72c86d3e995d7be01e3279c))

### [0.2.6](https://github.com/unjs/listhen/compare/v0.2.5...v0.2.6) (2022-01-13)


### Features

* update dependencies ([4a25d12](https://github.com/unjs/listhen/commit/4a25d12906de30fa077ad9bdf6a208027deff85a))

### [0.2.5](https://github.com/unjs/listhen/compare/v0.2.4...v0.2.5) (2021-10-14)


### Bug Fixes

* use defu for defaults ([f866a61](https://github.com/unjs/listhen/commit/f866a6134f068bda1e20619a896a2b792c96e315))

### [0.2.4](https://github.com/unjs/listhen/compare/v0.2.3...v0.2.4) (2021-04-13)


### Features

* allow recalling showURL ([cd00e79](https://github.com/unjs/listhen/commit/cd00e7911f35773ff4904b73e6fcd8ef36044f50))

### [0.2.3](https://github.com/unjs/listhen/compare/v0.2.2...v0.2.3) (2021-04-05)


### Bug Fixes

* add \n to surrounding of listen message ([b4b1300](https://github.com/unjs/listhen/commit/b4b13005833232798d1d50b1b8208a560968834d))

### [0.2.2](https://github.com/unjs/listhen/compare/v0.2.1...v0.2.2) (2021-04-05)


### Bug Fixes

* add empty line to listening message ([8381c49](https://github.com/unjs/listhen/commit/8381c49a10f852418a007d1d242442efc0ca39fd))

### [0.2.1](https://github.com/unjs/listhen/compare/v0.2.0...v0.2.1) (2021-04-05)


### Features

* allow deferred open ([2b4a3f8](https://github.com/unjs/listhen/commit/2b4a3f8c3d77bbee2abf021854959a2475a46e05))

## [0.2.0](https://github.com/unjs/listhen/compare/v0.1.4...v0.2.0) (2021-04-05)


### ⚠ BREAKING CHANGES

* improve perf and dx

### Features

* improve perf and dx ([6834809](https://github.com/unjs/listhen/commit/6834809e77a804801a629165b711ffc5df8f2b1e))

### [0.1.4](https://github.com/unjs/listhen/compare/v0.1.3...v0.1.4) (2021-02-22)


### Features

* expose $fetch utility ([38e6b2c](https://github.com/unjs/listhen/commit/38e6b2c2e021adcdabc4a5e45a31b4c21fba618d))

### [0.1.3](https://github.com/unjs/listhen/compare/v0.1.2...v0.1.3) (2021-02-18)

### [0.1.2](https://github.com/unjs/listhen/compare/v0.1.1...v0.1.2) (2020-12-07)


### Bug Fixes

* graceful shutdown ([#6](https://github.com/unjs/listhen/issues/6)) ([3e1e001](https://github.com/unjs/listhen/commit/3e1e0019539f9e988ba9fd14fb366fcb79d18193))

### [0.1.1](https://github.com/unjs/listhen/compare/v0.1.0...v0.1.1) (2020-12-07)


### Features

* **types:** expose Listener type ([6ccb5e2](https://github.com/unjs/listhen/commit/6ccb5e2eca71c5370a3ed1f0911620a4b29761c7))

## [0.1.0](https://github.com/unjs/listhen/compare/v0.0.4...v0.1.0) (2020-12-05)


### ⚠ BREAKING CHANGES

* unsupport jest as is unstable

### Features

* unsupport jest as is unstable ([5ec0d07](https://github.com/unjs/listhen/commit/5ec0d078facad58bfbe0843d9c75d776160cce09))

### [0.0.4](https://github.com/unjs/listhen/compare/v0.0.3...v0.0.4) (2020-12-05)


### Features

* baseURL ([99d5471](https://github.com/unjs/listhen/commit/99d5471df4fa736a58e4f365999b07f0ff45f095))
* getURL utility ([1fa41a0](https://github.com/unjs/listhen/commit/1fa41a0719666ab70579dc9567502c498f031fdf))

### [0.0.3](https://github.com/unjs/listhen/compare/v0.0.2...v0.0.3) (2020-12-05)


### Features

* auto detect prod and test envs ([d43b130](https://github.com/unjs/listhen/commit/d43b130705c3473fadd7f22e7a9abffd767b13bf))
* clipboard and open ([b4ae5b6](https://github.com/unjs/listhen/commit/b4ae5b6dabdd293410ad9bafca6c01607fe526ca))
* guard against multiple close calls ([f9c0315](https://github.com/unjs/listhen/commit/f9c03155901b77218ec231d11e4630b5d69f1119))
* support custom certificate ([d462ba5](https://github.com/unjs/listhen/commit/d462ba59e71100951b267acd179bee76683b2f65))
* support graceful shutdown ([69d6d17](https://github.com/unjs/listhen/commit/69d6d1777c183a717fc5ecc374d523082a9ddcc6))


### Bug Fixes

* silently ignore clipboard and open errors ([b78a6c4](https://github.com/unjs/listhen/commit/b78a6c4cda700afbaeaa20266ebaac328549675a))

### 0.0.2 (2020-12-04)

### 0.0.1 (2020-12-04)
