# Design considerations regarding a new umbrella-based dev-env

## Technology

- Still using Tilt as the core Technology for the dev-env.
  - Because it fits our feature-set well.
  - We have built a lot of knowledge about it in the team.
  - We understand how to customize, extend, maintain and debug it.
  - We have invested in many customizations, like the edit-mode,

  which we can continue to benefit from.

## Features

### Independent components

The new dev-env deploys each component chart as an independent Tilt component,
just like the old dev-env.
But it now does that through the templating of the umbrella chart.
This is implemented by disabling all components in the `values-common.yaml`
and then re-enabling them in the component-specific values files.

### container image edit-mode

Tilt can be configured to build the container-images locally.

Tilt builds them using docker and uploads them to a registry
or injects them directly into the cluster nodes.
It tags them with a generated image tag
and sets the same tags as part of the `helm upgrade --install` command.
In the new umbrella-based dev-env, this works exactly the same as in the old dev-env.
The only difference is the slightly different helm value
to override the image tag in the charts.

### helm chart edit-mode

We also want to optionally deploy not the charts downloaded from the OCI registry,
but instead, a chart from a local git checkout of a component repository.

This part is more complicated for the umbrella-based dev-env,
because the component charts are deployed as sub-charts of the umbrella chart.

Helm edit-mode means that we now need to swap out the downloaded subchart
with the same chart artifact generated from the git checkout of the component repository.

#### Considered options

##### helm package (chosen option)

The downloaded subchart is located in the `charts` directory as a `.tgz` file.

`helm package` can be used to replace this tar archive
with a chart archive of a local chart.

The filename of the `.tgz` file is not relevant
and we should add a signifier to the archive name
to identify it as an artifact generated by the helm edit-mode mechanism.

However, this generated subchart is only used by Helm
if the subchart version in it's `Chart.yaml`
matches the dependency chart version
specified in the `Chart.yaml` of the umbrella chart.

Two options to handle this:

- edit the subchart version with a regex as part of the edit-mode.
- extend the semantic versioning pipeline to update the subchart versions automatically.

(The container image versions should be included in the same commit.)

##### symlink the subchart directory (dismissed option)

We tried to just copy or symlink the subchart directory
into the `charts` directory of the umbrella chart.
This should work but helm has subtle differences in behavior
when including a subchart directory and a subchart as a `.tar` archive.
These differences will cause bugs and unexpected behavior,
which disqualifies this option.

##### file-based chart repository (dismissed option)

Helm has the option to define a local repository as the dependency location.
We could use `file://../` instead of `oci://artifacts`
in the umbrella charts `Chart.yaml` file
to achieve a Helm edit-mode.
But with this method the sub-chart is only updated
when `helm dependency update` is executed.

Making it just a more complicated alternative to the first option.

## Umbrella dev-env spike results

### Valuable functionality of the old standalone dev-env

The features we want to keep from the old dev-env

1. Interact with components independently

    1. re-deploy stack-data from the Tilt UI

    2. re-deploy the provisioning stack from the Tilt UI
2. Deploy only parts of the stack.
e.g. `tilt up stack-data-ums keycloak ldap-server udm-rest-api`
3. Container edit-mode: Optionally inject locally built containers into a component

    1. automatic rebuild and redeploy on code changes
4. Helm chart edit-mode: Optionally use the local git checkout of a component chart
instead of the remote OCI chart.

    1. automatic rebuild and redeploy on helm chart changes

5. Watch for changes and redeploy only a subset of components.
e.g. `tilt up` -> `Control-C` -> `tilt up stackdataums`

### Benefits of this new umbrella-based dev-env

- uses Univention Keycloak
- Much closer to the umbrella chart
- values duplication is still there, but less than in the dev-env
- not latest helm charts but inherits the chart versions from the umbrella chart

### downsides compared to the old standalone dev-env

- Slightly longer deploy times
- Custom helm edit mode necessary.

### Challenges / to-do's

- Update the versions in the components `Chart.yaml` as part of the release.

(Needed for the new helm edit-mode)

- Implement a new helm edit-mode based on the initial prototype of the spike.
  - hook into `helm_resource` and run `helm package` before every redeployment.
- port the tilt sections of all missing components to the new umbrella-based dev-env.
(2 - 3 PD)
- Get SAML login working / Fix Keycloak configuration. (1 - 2 PD)
- implement fixes for current hard-coded workarounds:
  - `stack-data-ums.udmApi.credentialSecret.name`
  - `nubusTemplates.ldapServer.ldap.connection.uri` / `nubusTemplates.ldapServer.ldap.connection.uri`
