# Nubus

This repository does contain a Helm chart which allows to install all the Nubus
components.


## Example usage

This repository is mainly concerned with the Helm chart for the stack. Please
take a look into the README file of the chart in `./helm/nubus/README.md`.


## Development setup

### Known limitations

- The values for a test deployment are currently in the file
  `example.yaml`, which you can use as a starting point.

### Preparation - Load dependencies

The dependencies can be loaded:

```sh
helm dependency build ./helm/nubus
```

### Fast feedback loop with `helm template`

Use `helm template` to have a fast feedback loop and inspect the rendered output
as YAML files. This also works if you don't have a Kubernetes cluster available:

```sh
helm template nubus ./helm/nubus

# Add custom values if you want to check specific scenarios
helm template --values your-values-file.yaml nubus ./helm/nubus
helm template --set example.key=value nubus ./helm/nubus

# Be aware, there are further options to set values on the command line,
# "helm template --help" will provide further details.
```


### Deployment into a Kubernetes cluster

If you want to verify changes in a real deployment, then you have to first make
sure to have a Kubernetes cluster available.

Deployments can be made with plain Helm or by using the CI setup via Helmfile in
the subfolder `./ci`. The CI setup is documented in
[./ci/README.md](./ci/README.md).


#### Plain Helm usage

Typically you would work with the sub-commands `install`, `upgrade` and
`uninstall`:

```sh
# Often the use of "upgrade" with the argument "--install" is useful
helm upgrade --install --values your-values-file.yaml nubus ./helm/nubus

# If you want to run the bootstrap job of Keycloak (required on initial deployment)
helm upgrade --install --values linter_values.yaml --set keycloak-bootstrap.enabled=true nubus ./
```


## Related and further information

- Helm project - <https://helm.sh/>
- Helm project documentation regarding umbrella charts -
  <https://helm.sh/docs/howto/charts_tips_and_tricks/#complex-charts-with-many-dependencies>


## Secrets testing

We need to prove two configuration scenarios:
- custom secret values
- existing secrets

### custom secret values

Ensure that all configuration options for custom secret values are documented.
A perfect configuration means that no autogenerated secret values are present.

How to test:
An `example-custom-secret-values.yaml` helm values file with all known custom secret values configuration options.
Helm template the umbrella chart twice. With the `example-custom-secret-values.yaml` and with different password seeds.
Diff the output. The only difference are remaining autogenerated secrets.
No diff means that no autogenerated secrets remain.

TODO:
Test that this does not break Nubus:
Deploy Nubus using and run the e2e tests on it.

### existing secrets

Ensure that all configuration options for existing secrets are documented.
A perfect configuration means that:
- The Nubus umbrella chart does not create any secrets (work in progress)
- No pods mount any secrets created by the Nubus umbrella chart.

How to test:
An `example-existing-secret.yaml` helm values file with all known existing secrets configuration options.
Helm template the umbrella chart twice:
1. Just `linter-values.yaml` and get a list of secret names `metadata.name`
2. With the `example-existing-secret.yaml` helm values.

Validate that the secret names from `1.` don't  appear anywhere in `2.`

Test that the description list in the public documentation is up to date with the `example-existing-secret.yaml`
Compare the jsonpaths of the `example-existing-secret.yaml` with the jsonpaths in the public documentation `secrets.rst`

TODO:
Test that this does not break Nubus:
Somehow deploy existing secrets that match the configured names and keys in `example-existing-secret.yaml`
Deploy Nubus using the `example-existing-secret.yaml` configuration and run the e2e tests on it.
