//  Copyright 2015 by Leipzig University Library, http://ub.uni-leipzig.de
//                 by The Finc Authors, http://finc.info
//                 by Martin Czygan, <martin.czygan@uni-leipzig.de>
//
// This file is part of some open source application.
//
// Some open source application is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation, either
// version 3 of the License, or (at your option) any later version.
//
// Some open source application is distributed in the hope that it will
// be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
// of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
//
// @license GPL-3.0+ <http://spdx.org/licenses/GPL-3.0+>
//
package jats

import (
	"encoding/xml"
	"strings"
	"testing"
)

const example = `
<article><front xmlns:xlink="http://www.w3.org/1999/xlink">
	<journal-meta>
		<journal-id journal-id-type="publisher-id">AKG</journal-id>
		<journal-title-group>
			<abbrev-journal-title abbrev-type="full">Archiv für Kulturgeschichte</abbrev-journal-title>
		</journal-title-group>
		<issn pub-type="epub">2194-3958</issn>
		<issn pub-type="ppub">0003-9233</issn>
		<publisher>
			<publisher-name>Böhlau Verlag GmbH &amp; CIE.</publisher-name>
		</publisher>
	</journal-meta>
	<article-meta>
		<article-id pub-id-type="publisher-id">akg.1969.51.2.183</article-id>
		<article-id pub-id-type="doi">10.7788/akg.1969.51.2.183</article-id>
		<article-categories />
		<title-group>
			<article-title>Die frühe Friesen- und Sachsenmission aus northumbrischer Sich</article-title>
			<subtitle>Das Zeugnisdes Baeda</subtitle>
		</title-group>
		<contrib-group>
			<contrib contrib-type="author">
				<name>
					<surname>Flaskamp</surname>
					<given-names>Franz</given-names>
				</name>
			</contrib>
		</contrib-group>
		<pub-date pub-type="ppub">
			<month>12</month>
			<year>1969</year>
			<string-date>December 1969</string-date>
		</pub-date>
		<volume>51</volume>
		<issue>2</issue>
		<fpage>183</fpage>
		<lpage>209</lpage>
		<permissions>
			<copyright-statement>© 2013 by Böhlau Verlag GmbH &amp; CIE.</copyright-statement>
			<copyright-year>2013</copyright-year>
		</permissions>
		<related-article related-article-type="pdf" xlink.href="akg.1969.51.2.183.pdf" /><post-process status="nothing-found">2014-01-22T23:23:05.719695+01:00</post-process><original type="pdf" xlink.href="akg.1969.51.2.183.pdf" />
	</article-meta>
</front><body><sec sec-type="index_only"><p>Die frühe Friesen- und Sachsenmission aus northumbrischer Sicht D a s Z e u g n i s des Baeda  von Franz  Flaskamp  Alles neuzeitlidie Geschehen von einigem öffentlichen Belang erfreut sich einer mehr oder minder regen Aufmerksamkeit und löst dann zumeist auch ein breiteres literarisches Echo aus. Ganz anders war es im Frühmittelalter. Damals mangelte es an einer vergleichbar reichen Beobachtung ebenso wie am benötigten Pergament und erst recht an federgeübten Händen. Von dem Wenigen aber, das trotzdem geschrieben wurde, ist nur ein bescheidener T e i l seinem Wortlaut nach überliefert, daher sogar von wichtigen Ereignissen nur eine geringe und ganz ungenügende Kunde verblieben. Die frühe Friesen- und Sachsenmission beispielsweise war gewiß ein zukunftweisendes Beginnen, bedeutete mehr eine geschichtliche Epoche als nur eine Episode deutschmittelalterlicher Entwicklung. W i e dürftig aber sind deren gerettete Zeugnisse! Im großen und ganzen handelt es sich um ein verstreutes Mancherlei ohne viel spürbaren Zusammenhang, abgesehen von dem zwar nicht ausgedehnten, so doch eine Kette der Begebenheiten ausweisenden Bericht von Baedas des Ehrwürdigen „Angelsächsischer Kirchengeschichte" Dieser wurde darum auch zum eigentlichen Grundstock des heutigen Wissens, wenigstens vom northumbrischen Anteil. Baedas Z e u g n i s ' gestattet nämlich eine Einordnung der verschiedensten annalistischen, biographischen sowie diplomatischen Einzelheiten und Kleinigkeiten zu einem halbwegs genügenden Bilde vom gewesenen Ganzen der geschichtlichen Wirklichkeit. Aus quellenkundlicher Erwägung ist daher Baedas Dienst an der frühen friesischen und sächsischen Missionsgeschichte ausnehmend dankenswert. Seine Zusteuer aus der Ferne hat festländisches Versagen oder doch Ungenügen einigermaßen wettgemacht, und das unter keineswegs günstigen Bedingungen. Zwar kann dieser 672/73 geborene und 735 gestorbene northumbrische E d e l i n g ' als „Zeitgenosse" gelten, wie man zu ' Venerabiiis Baedae opera historica, ed. Ch. P l u m m e r (2 Bde., Text und Kommentar, Oxford 1896, Neudr. 1946); fortan zitiert: Baeda. 2 Besonders I S. 298—303. ' Eigene Lebensskizze ebda. S. 357—360; dazu: C.F. B r o w n e , The venerable 1 Ardiiv für Kulturgeschidite i l / 2  184  Franz Flaskamp  sagen pflegt, wenn ein Lebenslauf und fremdes Tun in ebenderselben Jahresfolge sidi abspielten. Dodi war er, als die northumbrisdie Arbeit auf dem Festland anhub, nodi ein Kind und demnädist für lange Jahre als Zögling und dann Möndi im Großkloster Weannouth-Jarrow mit Lernen, Lehren und Kirdiendienst beschäftigt, später durA sdiulfadilidie, bibelkundlidie, patristisdie, hagiologisdie und dironologisdie Forsdiungen und Darstellungen ganz ungewöhnlichen Ausmaßes gebunden. Erst im Alter vernahm er den Ruf zur Beschäftigung mit der Geschichte seines Klosters und, davon fortsdireitend, mit der angelsächsischen Kirchengesdiichte im Rahmen der angelsächsischen Geschichte überhaupt. Er war nahezu sechzig Jahre alt, als er sein geschichtliches Hauptwerk, die „Historia ecclesiastica gentis Anglorum", abschloß*. Die biblischen Studien begründeten seinen frühen Ruhm®, die Kirchengeschichte gewährleistete seinen unverwelklichen Nachruhm. Aus northumbrischer Sicht war Baeda auch für das missionarische Wirken seiner Landsleute in Friesland und Sachsen interessiert, bei den „Altsachsen", wie man drüben die festländischen Stammesverwandten bezeichnete*. Er ließ sich unterrichten, so gut es anging, die weite EntBede, history, life and writings (London ^1928); A . H . T h o m p s o n , Bede, his life, time and writings, (Oxford 1935), darin (S. 111—151) W. L e v i s o n , Bede as historian, auÄ in L e v i s o n , Aus rheinisdier und fränkisdier Frühzeit (1948) S. 347—382. * Fristvermerk I S. 351, ebenso S. 356 die Zeittafel mit dem Tode Erzbischof Berhtwalds von Canterbury ( t 13. Januar 731) beschlossen. » Sdion Wynfreth-Bonifatius 746/47 an Erzbisdiof Ecgberht von York (ed. M. T a n g l , MG. Epp. seil. I, 1916, neu 1955, S. 158): Praeterea obsecro, ut mihi de opusculis Bedan lectoris aliquos tractatus conscribere et dirigere digneris, quem nuper, ut audimmus, divina gratia spiritali intellectu ditavit et in vestra provincia fulgere concessit, et ut candela, quam vobis Dominus largitus est, nos quoque fruamur; ebenso an Abt Huetberht von Wearmouth-Jarrow (ebd. S. 159): Interea rogamus, ut aliqua de opusculis sagacissimi investigatoris scripturarum Bedan monadii, quem nuper in domo Dei apud vos vice candellae aecclesiatice scientia scripturarum fulsisse audimmus, conscripta nobis transmittere dignemini. ' Baeda I S. 31: De Saxonibus, id est ea regione, quae nunc Antiquorum Saxonum cognominatur, uenere Orientales Saxones, Meridiani Saxones, Occidui Saxones; ebda. S. 302: a gente Antiquorum Saxonum-, audi nodi im Sadisenbrief Papst Gregors IIL (738), ed. T a n g 1, Epp. seil. I S. 35: Gregorius papa universo populo provinciae Altsaxonum; ebenso Bonifatius (746/47) an König Aethelbald von Mercien, ebd. S. 150: in Antiqua Saxonia, si virgo paternam domum cum adulterio maculaverit. Nachwirkend noch im Titel des 1473/75 bei Arnold ther Hoernen in Köln erschienenen Westfalenbuches des Kölner Kartäusers Werner R o l e v i n g (1425—1502), neu durdi H. B ü c k e r (1953) ediert: De laudibus Westpkaliae sive de laude Antiquae Saxoniae nunc Westphaliae dictae; ebenso im Titel des etwa 1517 vom Liesborner Benediktiner Bernhard W i t t e verfaßten, dodi erst 1778 durch Asdiendorff zu Münster gedruckten Westfalenbuches: Historia antiquae occidentalis Saxoniae seu nunc Westpkaliae anklingend.  Die frühe Friesen- und Sadisenmission  185  fernimg und die klösterlidie Abgesdilossenheit nicht im Wege standen. Dabei bedurfte er der Hilfe älterer und jüngerer Augen- und Ohrenzeugen', unmittelbarer und mittelbarer Nachrichten. Er dürfte mehr Handreichung erfahren haben, als sein Werk in diesem Felde verrät oder durchblicken läßt. Vornehmlich wird man an Bischof Wilfrith von York® und dessen Biographen Aeddi-Stephanus' zu denken haben. Selber nennt er Wilfriths Reisebegleiter Acca, den späteren Bischof von Hexham, als seinen Gewährsmann'". Wer von wissenschaftlicher Neugier angespornt wird, der erspäht auch in ödem und wüstem Gelände die erwünschten Quellen und weiß selbst kümmerliche Gelegenheiten ergiebig zu nutzen. Baeda spricht auch von älterem Schrifttum, das ihm dienlich gewesen sei". Aber gemeint sind dabei ausschließlich Zeugen und Zeugnisse der insularen Entwicklung, Mitteilungen über das Werden der insularen Heptarchie sowie zu ihrer Kirchen- und Klostergeschichte''. Auf das frühzeitliche rein festländische Geschehen hat er kaum geachtet. So blieb es ihm auch verborgen, daß längst vor dem Frieslandinteresse seiner northumbrischen Landsleute christliche Missionsarbeit in Friesland geleistet, das südliche Friesland schon einmal christlich gewesen war. Bereits in den Tagen König Chilperichs I. (561—84) hatte das von Rhein und Yssel abgeriegelte südfriesische Gebiet unter fränkischer Botmäßigkeit gestanden", daher auch unter christlicher Einwirkung. Das war also früher gewesen, als die Mönche des römischen Andreasklosters mit der Christianisierung Englands begonnen hatten. Für die Wende des 6. und 7. Jahrhunderts ist sogar schon die fränkische Martinskirche in Utrecht b e z e u g t K ö n i g Dagobert I. (623—39) hatte den Kölner Bischof ' Baeda 1 S. 357: uel ex traditione maiorum uel ex mea ipse cognitione scire potui. « Lebensdaten s. P l u m m e r s Baeda-Ausgabe U, S. 316—329; auch u. Anm. 24. ' Wobei sich allerdings nicht ausmachen läßt, was im einzelnen auf mündliche Information, was auf dessen Vita Wilfridi zurückgeht. S. u. Anm. 89. " Baeda I S. 357: uel ex Utteris antiquorum. " Besonders Gregorii L papae registrum epistolarum, ed. L. M. H a r t m a n n : MG. Epp. I/II, 1899; dazu A.W. H a d d a n und W . S t u b b s , Councils and ecclesiastical documents relating to Great Britain and Ireland, Bd. 3: English diurdi during the Anglo-Saxon period, 595—1066 (Oxford 1871). " Venantius Fortunatus, Carmina I X 1, v. 75f., ed. Fr. L e o : MG. Auct. ant. IV 1 (1881) S. 203: Terror [es] extremis Fresonibus atque Suebis, qui neque bella parant, sed tua frena rogant. Immunität König Pippins von Verberie 23. Mai 753, ed. E. M ü h l b a c h e r : MG. DD. Karol. I (1906) S. 8 nr. 5: eo quod antecessores nostri vel parentes Clotharius quondam rex [wohl Chlothar IL, 613—29] et Theodebertus quondam [sc. rex; wohl Theudebert IL, 595—612] per eorum auctoritates eorum manu subscriptas de villis ecclesiae sancti Martini... integra immunitate concessissent.  186  Franz Flaskamp  Kunibert föniilidi für Friesland v e r p f l i d i t e t D a m a l s war also wohl eine Angliedenmg zum Kölner Sprengel geplant gewesen, vielleicht sogar vereinbart worden. Wenigstens beansprudite Köln später (imi 753) Diözesanredite in Friesland und wußte diese audi einigermaßen zu vertreten In Dagoberts Tagen hatte allerdings audi Bischof Amandus von Maastricht an der Sdielde missioniert, sogar ein Kloster am Elno (St. Amand) gegründet", etwas später Bischof Eligius von Noyon an der W a a l " . Im ganizen mochte das eine lodcere, oberflächlidie, der einheitlichen Leitung bare, des Ausgleichs und der Vertiefung harrende Einwirkung sein, der Erfolg ebenso viel aus politischen Rücksichten wie aus Einsicht und freiem Entschlüsse sich ergeben haben. Umso leichter ist dieses frühe fränkische Christentum in Friesland wieder zusammengebrochen, als die Franken in der 2. Hälfte des 7. Jahrhunderts die Provinz Friesland nicht zu behaupten vörmochten. Dabei wurden auch die christlichen Kirdien und Kapellen zerstört, nicht nur die Martinskirche zu Utrecht*'. Aber dieser markant gewesene fränkisch-christliche Außenposten, das vorgeschobene Bollwerk, demonstrierte den folgenden Geschlechtern die einstige Macht. Dieser Verlust wurde deiher als ein so schmerzhaftes Trauma empfunden, daß man auch das spätere Missionswerk der Northumbrier schließlich wieder bei der neuerstandenen Utrechter Martinskirche ausklingen ließ " Bonifatius nach 23. Mai 753 an Papst Stephan IL, ed. T a n g l S. 235: Et [sc. Coloniensis episcopus] refert, quod ab antiquo rege Francorum Dagobercto castellum "Traiectum cum destructa aecclesia ad Colon[i]ensem parrodiiam [ = episcopatum] donatum in ea conditione fuisset, ut episcopus Colon[i]ensis gentem Fresorum ad fidem Christi converteret et eorum predicator esset. Quod et ipse non fecit; vgl. Fr. W . O e d i g e r , Die Regesten der Erzbisdiöfe von Köln im Mittelalter I (1961) S. 21. " Wodurdi zunächst die Frieslandabsiditen des Bonifatius gestört und 777 der Ansdiluß Frieslands zur Kölner Kirchenprovinz bewirkt wurde; vgl. W. F e i s t e r , Stand und Herkunft der Bischöfe der Kölner Kirchenprovinz im Mittelalter (1909) S. 43—64, auch RR. P o s t , Gesdiiedenis der Utrechtsdie bissdiopsverkiezingen tot 1535 (Utredit 1933). " Vita s. Amandi, ed. Br. K r u s c h : MG. SS. rer. Merov, V (1910) S. 395— 485, dazu W. L e v i s o n : ebd. VII (1920) S. 846f.; A. H a u c k , KG. Deutsdilands I, S. 322—328; H. v. S c h u b e r t , Gesehidite der diristlidien Kirdie im Frühmittelalter (1921) S. 295; H. C l a e y s , Sint Amand, apostel van Viaanderen (Thielt 1913); E. d e M o r e a u , Saint Amand, apötre de la Belgique et du nord de la France (Louvain 1927). " Vita s. Eligii, ed. Br. K r u s c h : MG. SS. rer. Merov. IV (1902) S. 634— 761, besonders S. 696. 700, dazu W. L e v i s o n : ebd. VII (1920) S. 842 ff.; H a u c k S. 328 f.; S c h u b e r t S. 295; P. P a r s y , Saint £loi (Paris n908; £. M o r e 1, fitude critique sur la vie de s. filoi (ebd. 1930). " Bonifatius nach 23. Mai 753 an Papst Stephan IL, ed. T a n g l S. 235: propter fundamenta cuiusdam destructae a paganis ecclesiolae, quam Uuilbrordus derutam usque ad solum in castello "Traiecto repperit. S. u. Anm. 108 f.  Die frühe Friesen- und Sadbsenmission  187  Von diesem frühen fränkischen Christentum in Friesland erfuhr der Westsadise W y n f r e t h " bei seinem friesischen Versuch 716 an Ort und Stelle", Baeda dagegen im sehr abgelegenen Wearmouth-Jarrow, soweit ersiditlich, rein nichts. Nadi seiner Information ging die Christianisierung Frieslands aussdiließlich auf seine northumbrisdien Landsleute zurüdk, hatte Bisdiof Wilfrith von York 678/79 die Möglichkeit erkannt und sich bereits erfolgreich bemüht, Ecgberht der Heilige das Begonnene fortsetzen wollen, aber wegen Mißgeschicks dies nicht vermocht, Wicgberht dann wirklich versucht, doch vergebens, Wilbrord indessen in einem langjährigen Wirken zu einem trefflichen Gelingen führen dürfen. So ist im Urteil Baedas Wilfrith der Pionier des Christentums in Friesland gewesen, Wilbrord dessen Vollender geworden". Über Wilbrords missionarische Anfänge und frühe Fortschritte sind offenbar, wenn auch nicht erschöpfende, so doch leidliche Nachrichten zum Kloster Wearmouth-Jarrow gelangt. Nach Wilfriths Lebensende (709) mag das Einvernehmen sich gelockert haben und mit der Zeit mehr imd mehr zusammengeschrumpft sein, wie Baedas Bericht spüren läßt. Doch blieb er zeitlebens aufmerksam. Von dem northumbrischen Vorstoß nach Sachsen mochten schon die in Friesland verbliebenen Missionare wenig Bestimmtes erfahren haben, wußte daher erst recht Baeda wenig Konkretes zu vermerken. Aber er verankerte auch die unsicheren Gerüchte und verhütete so ein volles Nichtwissen der Nachwelt. " So hat er selber sich genannt im Gedicht für den ehemaligen Klosterschüler Dud, nur der Akrostidionspielerei wegen als „Vynfreth" geschrieben; ed. E. D ü m m l e r : MG. Poetae lat. I (1881) S. 16 f. Vynfreth priscorum Duddo congesserat artem, viribus ille iugis iuvavit in arte magistrum. Wilbalds Vita s. Bonifatii, ed. W. L e v i s o n : SS. rer. Germ., (1905) S. 15 ff. Baeda I, S. 326: quod postmodum Uilbrord, reuerentissimus Christi pontifex, in magna deuotione conpleuit, ipse [sc. Uilfridus] primus ibi opus euangelicutn coepit; so aber sdion Aeddi-Stephanus, Vita Wilfridi, ed. W. L e v i s o n : MG. SS. rer. Merov. VI (1913) S. 220: quod adhuc superaedificat filius eins [sc. Wilfridi], in Hripis nutritus, gratia Dei Wilbrordus episcopus, multo labore desudans, cuius merces manet in eternum. Allerdings auch Bonifatius nadi 23. Mai 753 an Papst Stephan II., ed. T a n g l S. 236: pagana permansit gens Fresorum, usque quod venerandus pontifex Romanae sedis Sergius supradictum servum Dei Uuilbrordum episcopum ad predicandum supradictae genti transmisit, qui illam gentem, ut prefatus sum, ad fidem Christi convertit, was auf die Zwisdbenzeit (vom Zusammenbrudi des altfränkischen Christentums in Friesland bis zum Kommen Wilbrords) zu beziehen ist, allerdings auch durdi die eigenen Frieslandabsiditen des Bonifatius gefärbt wird. Zur Person vgl. W. L e v i s o n , Die Quellen zur Geschichte des hl. Willibrord, in: Willibrordus (Echternadier Festschrift, hg. v. N. Goetzinger, 1940) S. 5—65; d e r s . , St. Willibrord and his place in history: Durham University Journal 32 (1940) S. 23—41, beide auch in: Aus rhein. u. fränk. Frühzeit (1948) S. 304—329; G.H. V e r b i s t , Saint Willibrord, apotre des Pays-Bas et fondateur d'Editernach (Louvain 1939).  188  Franz Flaskamp  Das friesische Interesse Baedas ergab sich ungesucht aus dem Augenmerk für die heimisch-angelsädisisdie Kirchengeschichte. Die Brücke bildete die Romreise Bischof Wilfriths von York, unternommen zu dem Zwecke, seine Schwierigkeiten mit dem König Ecgfrith von Northumbrien (671—685) und dem Erzbischof Theodor von Canterbury (669—690) in Rom persönlich vorzutragen und dort eine Begünstigung seiner eigenen Kirchenpolitik zu erwirken Nachdem nämlich 634 Bischof Paulinus von York mehr durch Zufall als in einer planvollen Entwicklung das Palliimi erhalten hatte®', spielte man in York mit dem Gedanken einer vom Süden (Canterbury) abgesonderten anglischen Kirchenprovinz; deren Anwalt und Anwärter war besonders Wilfrith Er verzehrte sich deswegen in Reibereien, bereitete aber den Weg: 735 wurde Ecgberht von York wirklich Erzbischof und Metropolit Indem Wilfrith 678 seinen Weg durch Friesland nahm, trat Friesland in den northumbrischen Gesichtskreis. Der Friesenfürst Aldgisel gewährte dem vornehmen Besuch aus Übersee Gastfreundschaft, sogar Winterquartier. Diese Gunst nutzte Wilfrith zu neuer, aber freier, nicht durch fremde Politik belasteter Missionsarbeit. Es waren ihm auch merkliche Erfolge beschieden, vorab doch wohl, weil sich an Überreste der früheren fränkischen Mission anknüpfen ließ. Solche Möglichkeiten haben sich im Laufe der christlichen Missionsgeschichte audb anderswo ergeben Baeda berichtet summarisch®'. Mehr als ein Beobachten und FühlungVita Wilfridi, ed. L e v i s o n , S. 220: C.F. B r o w n e , Theodore and Wilfrith (London 1897); d e r s . , The English church in the eighth Century, its influence on the continent of Europa (ebd. 1897); S c h u b e r t , Frümittelalter (wie Anm. 17) S. 270ff.; J. J u n g - D i e f e n b a c h , Die Friesenbekehrung bis zum Martertode des hl. Bonifatius (1931); S.J. C r a w f o r d , Anglo-Saxon lufluence on Western Christendom (Oxford ®1966); W. L e v i s o n , England and the continent in the eighth Century (ebd. 1946); Th. S c h i e f f e r , Angelsachsen und Franken, Abhandl. der Mainzer Akad., geisteswiss. Kl., 1950, S. 1431—1539. « S. u. Anm. 132. " Deswegen von seinem Schüler Aeddi-Stephanus (Vita Wilfridi, ed. L e v i s o n , S. 210) sdion „Metropolit" genannt: beatae memoriae Vilfrido, episcopo metropolitano Eboracae civitatis constituto. " Baedae continuatio, ed. P l u m m e r , S. 361: Anno DCCXXXÜ... Ecgherctus episcopus, accepto ab apostolica sede pallio, primus post Paulinum in ardiiepiscopatum confirmatus est. Im Liher pontificalis (ed. L. D u c h e s n e , II, 1892) nidit erwähnt. So fanden die frühesten Steyler Chinamissionare Johann Baptist A n z e r und Joseph F r e i n a d e m e t z 1882 in einem Dorfe Puoli im äußersten Westen der Provinz Schantung 158 Christen, die aus viel früherer Missionsarbeit ohne jedwede fernere geistliche Betreuung sich behauptet hatten. Baeda I S. 326: praedicabat eis Christum, et multa eorum milia uerbo ueritatis instituens a peccatorum suorum sordibus fönte Salvatoris abluit; so, an Apostelgeschichte 8,5 anklingend, audi schon Vita Wilfridi, ed. L e v i s o n S. 220.  Die frühe Friesen- und Sadisenmission  189  nehmen dürfte es in der Tat nidit gewesen sein, immerhin so viel, daß Wilfrith eine christliche Missionsarbeit im nun nicht mehr fränkisch bevormundeten Friesland als aussiditsvoll erachten konnte. Ob Aldgisel einem solchen Vorhaben nicht sogar zugesprochen hätte, wenn es seiner Landeshoheit förderlich gewesen wäre? Die Könige halten immer zu den Göttern, die ihrer Herrschaft günstig sind. Wenn sich mit dem von Northumbrien ausgestrahlten Christentum audi angelsächsische politische Verbindungen zwecks Abwehr der fränkischen Eroberungsgelüste hätten gewinnen lassen? Was dann zunächst auf Wilfriths Reise folgte, mag Baeda ebenso erfahren haben wie A e d d i - S t e p h a n u s w a r ihm aber vielleicht im Hinblick auf seinen angelsächsischen Behuf nicht sonderlich erwähnenswert. Wilfrith berührte nämlich auch die Pfalz König Dagoberts II. (676—679) und führte sich so trefflich ein, daß man ihn den heimischen Verdrießlichkeiten entheben und mit dem alamannischen Bistum Straßburg versorgen wollte. Das wäre dann allerdings eine Verpflichtung für fränkische Kirchenpolitik gewesen und hätte später zu einer Mitwirkung an einer neuen fränkischen Reichsmission auf friesischem Boden werden können. Diese Gefahr einer doppelzüngigen Haltung Wilfriths war freilich zur Stunde nicht zu besorgen; deim man hatte im Frankenreiche einstweilen sattsam mit innerer Sicherheit zu tun, anstatt Eroberungen nach außen planen zu dürfen. So haben auch die verschiedenen demnächstigen angelsächsischen Ausblicke nach Friesland, Ecgberhts, Wicgberhts und noch 716 Wynfreths, nur auf eine freie, nicht wegen fränkischer Verbindungen ohne weiteres verdächtige Missionsarbeit reflektiert. Wilfrith aber ließ sich sowieso nicht fränkisch binden. Immerhin hatte er durch die gewonnene Fühlung mit dem austrasischen Majordom Pippin dem Mittleren auch der Friesenmission, wie sie später sich ergab, die Wege geebnet. Was Wilfrith als im freien Friesland möglich erkannt hatte, suchten Mönche des irischen Klosters Rathmelsigi zu verwirklichen, Ecgberht und Wicgberht. Beide waren aber gleichfalls Northumbrier. Darum waren sie auch für Baeda beachtenswert, und nur so, durch dessen Zeugnis, blieb ihr Dasein und ihr Missionseifer der Nadbwelt bekannt. Ecgberht hatte in Rathmelsigi als einziger des Klosters die böse Pest von 664 überstanden, wollte nun aber auch nicht mehr zeitlebens klösterlich geborgen bleiben, sondern dem Herrn zuliebe „im Elend" sein, d.h. in der vollen Fremde sich bewegen und wirken". Wann, wo und wie das zu erreichen sein möchte, ließ sich gewiß zur Stunde noch nicht absehen; denn seine nächste Aufgabe konnte nur die Sorge für den Vita Wilfridi, S. 221. " Baeda I S. 192ff.; d a z u H a u c k I, S. 432 ff.; S c h u b e r t , S. 296.  190  Franz Flaskamp  wirtsdiaftlidien Fortbestand seines Klosters und die Sammlung einer neuen Klostergemeinde sein. Als auch dies, sei es durdi Nadisdiub aus Northimibrien, sei es durdi Heranbildung aus irisdiem Zugang, in Jahrzehnten gelungen war, meldete sidi aber ein vorher kaum erwogener Außendienst, die durch Wilfriths Interesse empfohlene Frieslandmission. Ecgberht rüstete wirklich zu einer Frieslandreise. Doch zersdiellte das beladene S(hi£f in der Nacht vor der geplanten Ausfahrt. So berichtet Baeda", unverkennbar etwas legendenhaft, aber doch wohl als Zeugnis für die Tatsache, daß Ecgberht an eigene Frieslandmission gedacht und sich dafür vorbereitet hat, indessen nicht zu diesem Einsatz gekommen ist. Wohl zu einem anderen: im Irenkloster Hy-Jona warb er für Anschluß an den römischen Ostertermin". Doch hat Wicgberht, der als jüngerer Northumbrier nach Rathmelsigi gelangt und vielleicht schon für Ecgberhts geplante Fahrt vorgesehen war, mit einigen Gleichgesinnten die Missionsreise nach Friesland tatsächlich ausgeführt. Er landete, genoß den Schutz des neuen Friesenfürsten Ratbod, durfte missionieren, konnte gleichwohl in zweijährigem Mühen nichts Nennenswertes erreichen'^. Ratbod selber war dem Christentum gegenüber bedenklich. Es kann nicht überraschen, daß ein Fürst, der um seine Selbständigkeit, seine Unabhängigkeit bangen mußte, mit der fränkischen Religion sich so wenig einlassen wie mit den Franken selbst zu tun haben wollte. Wer das aber wußte, im gesellschaftlich belangvollen Friesland, d.h. im Adel, bei den freien und vermögenden Leuten, mied die landesfremden Missionare, als wenn dies verkappte fränkische Agenten gewesen wären. Zweifellos war diese Vorsicht jetzt viel mehr angebracht, geboten als in den Tagen Aldgisels. Das sollte sidi bald offenbaren. Demnächst nämlich änderte sich schon das fränkisch-friesische Nebeneinander. Der austrasische Majordom beseitigte durch die Schlacht bei Tertry (687) den neustrischen Majordom Ebroin und trug, so im Frankenreiche merklich erstarkt, um 689 die fränkische Macht wieder nach Friesland vor, und zwar für den gesamten Raum, der vordem frän«i Ebd. S. 296 ff. " E b d . S. 134f. 193f. 296f. 346ff.; zur Sache: Br. K r u s c h , Die Einführung des griechischen Paschalritus im Abendlande, Neues Archiv d. G. f. ä. A. Geschiditsk. 9 (1883) S. 99—169; J. S c h m i d , Die Osterfestberedinung auf den britisdien Inseln (1904); ders.. Die Osterfestberedinung in der abendländisdien Kirdie (1907); S c h u b e r t , Frühmittelalter, S. 268 f. Baeda I S. 298: duobus annis continuis genti Uli ac regt eins Rathbedo uerbum salutis praedicahat, neque aliquem tanti laboris fructum apud barharos inuenit auditores. 7um reuersus..anschließend Alkuins Vita s. Willibrordi, ed. L e v i s 0 n : MG. SS. rer. Merov. VII (1920) S. 118 f.  Die frühe Friesen- und Sadisemnission  191  kisdi gewesen war Diese Entwicklung wurde Anlaß zur Frieslandfahrt von Wilfriths geistigem Sohne W i l b r o r d " und zur Einleitung einer neuen Friesenmission", die nadi fünf Jahren schon zur Gründung eines eigenen friesisdien Bistums führte, zwar gelegentlidb nodi merklidb gestört wurde, aber dodi unter zunächst allein northumbrisdier, dann auch westsächsiseher, schließlidi fränkisdier und friesischer Betreuung eine dauernde diristliche Zukunft des „linksrheinischen" Friesland, später auch des Nordens gezeitigt hat. Zeuge dessen ist allerdings nicht Baeda allein geworden, wohl aber wesentlicher Gewährsmann für Wilbrords missionarische Anfänge und dessen früheste Ergebnisse. Wilbrord, Sohn eines northumbrischen Edelings Wilgils, war zunächst Zögling in Wilfriths Gunstkloster Ripon gewesen und 678 Mönch in Rathmelsigi geworden". Hier hatte er das Mißgesdiick Ecgberhts und Wicgberhts erlebt und sah sich nun vom Wandel der politischen Lage zu einer aussiditsvolleren Frieslandmission begünstigt". Die neuen politischen Maditverhältnisse führten nämlich zu einer Abkehr von der bisher erstrebten freien Frieseimiission, zu ihrem Einschwenken auf eine fränkische Reichsmission, wenn auch von Northumbriem vertreten. Das Ideal christlicher Verkündigung wurde schnell hintangestellt gegenüber den wirklichen Gegebenheiten, praktischen Möglichkeiten, Erfolgsaussichten und unsdiwer zu erzielenden Ergebnissen. Als greifbare Resultate wertete man die Reihen der Taufwilligen und die Anzahl der wirklidi gespendeten Taufen. Das genügte dem politischen Prinzip der Anpassung, entsprach auch der Größe einer beschleunigt zu lösenden Aufgabe, ein ganzes Volk, soweit noch nicht getauft, dem Christentum zuzuführen. In ähnlich kursorischer Arbeit hatte sich gewiß auch die frühere fränkische Frieslandmission abgespielt, nur mit dem Unterschiede, daß es damals an der Nacharbeit gemangelt hatte. Den Northumbriem dagegen wurde es ermöglicht, die zum Christentum „eingeschriebenen Mitglieder" nachträglich einzuführen, das Halbundhalb auszugleichen und die vielen Bedingtheiten dieser politisch belasteten Mission, die einer „Predigt des  » Fredegarii continuatio, ed. Br. K r u s c h : MG. SS. rer. Merov. II (1888) S. 172; B ö h m e r - M ü h l b a c h e r , Regesta imperii I' (1908) S. 6 nr. 5a. " S. o. Anm. 23. " Baeda I S. 299: et quia [sc. Pippinus dux] nuper citeriorem Fresiam expulso inde Rathbedo rege ceperat; das „diesseitige" Friesland aus northumbrisdier Sidit, mit (ebd. S. 303) Wiltenburg-Utredit als widitigstem Platz. " Vita Wilfridi, S. 220; Baeda I, S. 152. 299; Vita s. Willibrordi, S. 114. l i e f . 119. 137 f. " H. B ü t t n e r , Die Franken und die Ausbreitung des Christentums, Hessisdies Jahrbudi 1 (1951) S. 8—24.  192  Franz Flaskamp  Schwertes" ähnelte, nadi und nach zu überwinden. Aber nur, weil die fränkisdie Hoheit vorerst durch zweieinhalb Jahrzehnte verblieb. Das Jahr von Wilbrords Ausreise (690) ist durch dessen eigenhändigen Vermerk^^ im Editernadier Kalender^® verbürgt: In nomine Domini Clemens Uuillibrordus anno sexcentesimo nonagesimo ab incarnatione Christi ueniebat ultra mare in Francia. Baeda erzählt von dem Aufbrudi in voller Apostelzahl Aber nur wenige der Mitarbeiter hat er namentlich vermerkt": Suidberht«, Tilmon«, die beiden Eadwalde^^. Sie umfuhren den Süden der britischen Insel imd landeten an den Rheinmündungen, vielleicht in Duurstede*'. Alsdann bemühte sich Wilbrord zunächst um eine Begegnung mit dem fränkischen Majordom. Ob ihr Kommen durch Wilfrith vorbereitet, mit dem Majordom vereinbart war, ob sie erst durch seine oder andere Geleitbriefe empfohlen wurden? Sie konnten natürlich nicht als volle Fremdlinge und wie unbekannte Abenteurer sich einfinden. Auf jeden Fall: sie waren dem Majordom als kirchliche Helfer in seiner Frieslandpolitik willkommen und wurden bereitwillig in deren Dienst gestellt'". So der Huld des Majordoms versichert, soll Wilbrord dann noch über die Alpen gezogen und in Rom beim Papste Sergius (687—701) auch eine förmliche kirchliche Sendung " Wie die Translatio s. Liborii, ed. G.H. Pertz: MG. SS. IV, (1841) S. 151, die Sachsenmission Karls d. Gr. kennzeichnet: Quem [sc. Karolum regem] arbitror nostrum iure apostolum; quibus [sc. Saxonibus], ut ianuam fidei aperiret, ferrea quodammodo lingtia praedicavit. « So auA von W. L e v i s o n (MG. SS. rer. Merov. VII, S. 92) nadi dem „quamuis indignus" des weiteren Textes gefolgert, da nidit ein Fremder so hätte schreiben dürfen. « H. A. W i I s o n , The calendar of St. Willibrord (London 1918) Tafel 11. « Baeda I, S. 298 f. " Auch der durch Alkuin, Versus de sanctis Euboricensis ecclesiae, v. 1073, ed. E. D ü m m l e r : MG. Poetae lat. I (1881) S. 191 neben Suidberht genannte Vira sacerdos mag zu dieser Gemeinschaft gehört haben, doch gesagt ist das nicht. « Baeda I, S. 302. " Ebd. S. 301. " Ebd. S. 299 ff. Vita s. Willibrordi, S. 120: donec prospero cursu ad ostia Hreni fluminis vela deposuit; in Thiofrieds Vita s. Willibrord!, ed. A. P o n c e 1 e t , AA. SS. November III (1910) S. 463, ist ohne ersichtlichen Grund an Gravelingen gedadit. In Duurstede ist 716 Wynfreth gelandet; vgl. Wilbalds Vita s. Bonifatii, ed. L e v i s o n : SS. rer. Germ., S. 16; zur Lage s. J. H. H o 1 w e r d a , Dorestad: Bericht der Römisch-German. Kommission des Deutschen Archäolog. Instituts 16 (1927) S. 141—163. " Solche damals ebenso üblich wie angebracht; Beispiel der Geleitbrief Bischof Daniels von Winchester (718) für den ausreisenden Wynfreth (ed. T a n g l , S. 15 f.), päpstliche Geleitbriefe (722) für den heimkehrenden Bischof Bonifatius (ebd. S. 29—34). »« Baeda I, S. 299; audi Vita s. Willibrordi, S. 120 f.; zur Form vgl. Muntbrief Karl Martells (723) für Bonifatius, ed. T a n g l , S. 36ff., audi in Wilbalds Vita s. Bonifatii, ed. L e v i s o n , S. 21 f., erwähnt.  Die frühe Friesen- und Sadisenmission  193  erbeten sowie erhalten haben. Dies wird allerdings allein durdi Baeda bezeugt und mutet sdion darum etwas eigenartig an, weil es ein Sdiritt gewesen wäre, der dem Herkommen nidit entsprodien hätte; denn weder Wilfrith nodi Ecgberht nodi Wicgberht waren um eine päpstlidie Sendung besorgt gewesen, ebensowenig madite sich nodi Wynfreth gelegentlidi seiner frühen Frieslandfahrt (716) Gedanken wegen einer benötigten päpstlichen V o l l m a c h t S o f e r n Baedas Bericht verläßlidi ist, wird man eine Weisung Pippins zu vermuten haben, sei es zur Rüdcendedcung seiner Frieslandpolitik schlechthin, sei es zwecks Absicherung gegenüber den älteren Kölner Diözesanrechten in Friesland" und daraus zu befürchtendem Kölner Einspruch. In der geschiditlichen Urteilsbildung soll die Vermutung „für die Überlieferung streiten", daher audi überrasdiende Einzelzeugnisse gelten lassen, wenn sie nicht durch das Gewicht von Gegenzeugnissen entkräftet werden. Baedas Meldung von Wilbrords Romfahrt zwecks einzuholender päpstlicher Sendung ist aber nicht nur bedenklich, weil ein solches Bemühen in Rom damals keineswegs üblidi war, sondern auch wegen anderer Zeugnisse, die sidi schlecht dazu „reimen" lassen. Wilbrord selber hat im Editernacher Kalender wohl seine 690 erfolgte Reise „nach Franken" eine Romreise aber erst gelegentlich seiner 695 erfolgten römisdien Bisdiofsweihe vermerkt". Nadi Baedas Zeugnis wurde Wilbrord audi erst aus diesem Anlaß in Rom zu „Clemens" umbenannt", was sdion bei einer wirklich 690 erfolgten römisdien Sendung, wo dann doch audi Urkunden auszufertigen gewesen wären", hätte geschehen müssen und gewiß geschehen w ä r e " . Zwar beruft sich Bonifatius 753 in seinen Sdiwierigkeiten hinsiditlich der erstrebten Nachfolge Wilbrords in Utredit auf eine tatsächlich geschehene römische „Sendung" Wilbrords, aber erst anläßlidi der 695 erfolgten römischen Bisdiofsweihe™. Hätte Wilbrord schon vor Antritt seines friesisdien Dienstes sich in Rom bevollmächtigen lassen, so hätte es für Bonifatius nahegelegen, sogar zu dieser Stunde dringend sich empfohlen, dies betont zu erwähnen; denn damit hätte er seine Parallele Wilbrord-Wynfreth unterstreichen und seine Utrediter Ansprüdie bemerkenswert erhärten können. Auch sein Gegenzeugnis beweist, daß die Meldung Baedas kaum glaubwürdig ist. Überdies läßt sich eine von Baeda empfundene Sdiwierigkeit in der friesischen Missionsgeschidite ausmadien, die ihn zu der Meinung oder Überzeugung, Baeda I, S. 301 f., aber nidit in Alkuins Vita s. Willibrordi; zur eventuellen Form vgl. Sendung des Wynfreth-Bonifatius (719), ed. T a n g l , S. 17 f., audi Vita s. Bonifatii, S. 21 f. Wohl 718 bei seiner neuen Ausfahrt, im Hinblick auf die erstrebte Konkurrenz Wilbrords; aber in Rom damals noch als so ungewöhnlidi empfunden, wie der eigene Vermerk im Liber pontificalis c. 91 (Vita Gregorii), ed. L. D u c h e s n e , 2. Bd. (Paris 1892) S. 397, verrät: Hic in Germania per Bonifacium episcopum verbum salutis praedicavit et gentem illam sedentem in tenebris doctrina lucis convertit ad Christum, et maximam partem gentis eiusdem sancti baptismatis lavit unda. s» S. o. Anm. 15 f. " S. o. Anm. 42. « S. u. Anm. 65. " Baeda I, S. 303. " Analogon des Wynfreth-Bonifatius s. o. Anm. 51. " Über den rein praktischen Sinn, den römischen Kanzleibehuf, s. u. Anm. 76 f. S. o. Anm. 23.  194  Franz Flaskamp  Wilbrord sei nädist der Verständigung mit Pippin auch nadi Rom gegangen, bestimmt haben könnte  Durdi das Wohlwollen des Majordoms, also die Rüdcendedsung der fränkischen Madit, begünstigt, eröffnete Wilbrord in Friesland ein erfolgreiches Wirken*'. Die neue politische Lage ließ eine Fühlung mit den fremden Glaubensboten nicht mehr als fragwürdig erscheinen, nidit mehr Argwohn und Verfolgung befürditen, im Gegenteil staatliciies Wohlgefallen erhoffen. Vor allem wurde so dem Adel ein Anschluß nahegelegt". Wursing, Liudgers Großvater, ist daher gewiß nicht der einzige friesische Edeling gewesen, der sich früh durch Wilbrord gewinnen ließ Der Adel konnte sich damit billig „bei Hofe" empfehlen und audi in kirchlichen Anwartschaften (Bisdiofsstühlen, Domkapiteln, vornehmen Stiften und Klöstern) seine führende Stellung festigen und ausweiten. Dem Beispiel des Adels pflegten alsdann die sonstigen Freien zu folgen. Was schließlich noch übrigblieb, die Hörigen, Heuerlinge, Knechte und Mägde, konnte man im Gange des Geschehens unschwer „anpassen", assimilieren. So ist es überall bei staatlich gesteuerter Missionsarbeit gewesen, also nicht etwas Besonderes, daß die fränkische Mission „von oben nach unten" sich entwickelte. Ein „demokratisches" Aufbauen von unten her, mit den gesellschaftlich unbedeutenden Volksschichten beginnend, wäre überhaupt unmöglich gewesen, weil ohne weiteres als Demagogie empfunden und vom Adel abgelehnt worden Die aristokratisch begünstigte Frieslandmission Wilbrords zeitigte derart schnelle Fortschritte, daß schon nach fünf Jahren die Gründung eines eigenen Friesenbistums erwogen wurde, sogar die Weihe weiterer Bischöfe in Friesland, und als Abschluß wohl die Errichtung einer friesischen Kirchenprovinz mit der Metropole Utrecht geplant war. Bis dahin hatte man für Firmungen und die Weihe gottesdienstlicher Stätten oder wenigstens von Tragaltären wahrscheinlich bischöfliche Hilfe aus Northumbrien bestellt, sonst aus dem Frankenreiche. Jetzt aber wurde Wilbrord durch Pippin nach Rom geschickt; er sollte sich dort zum Bischof weihen und anschließend zum Erzbischof ernennen lassen". Die •» S. unten Anm. 129. •1 Baeda I, S. 299: unde factum est, opitulante gratia diuina, ut multos in breui ab idolatria ad fidem conuerterent Christi; anschließend Vita s. Willibrordi, S. 120. " A. S c h u l t e , Der Adel und die deutsdie Kirdie im Mittelalter (»1958). «» Altfrieds Vita s. Liudgeri, ed. W. D i e k a m p , Vitae s. Liudgeri (1881) S. 7; was mehr oder weniger lange vor Grimoalds Ermordung (im April 714 zu Lüttich; vgl. B ö h m e r - M ü h l b a c h e r , Regesta imperii 'I, S. 9 nr. 21a) geschehen war. " Wie beispielsweise die portugiesischen Jesuiten 1637 in ihrer als Wühlarbeit empfundenen Japanmission gesdieitert sind. Die Tatsache der römischen Weihe bezeugen außer Baeda (s. u. Anm. 67)  Die frühe Friesen- und Sadisenmission  195  Sendung nadi Rom war gewiß bewußt und gewollt. Man darf vermuten, daß der Majordom sidi in Friesland freie Hand gegenüber den älteren Kölner Diözesanrediten und zu befürditenden neuen Kölner Ansprüdien sichern, aber audi die langsame Ablösimg der northumbrisdien Mission von ihrem Ausgangsland und deren Angliederung zur fränkischen Reidiskirdie fördern wollte. Ohne des Majordoms ausdrüdclidie Weisung hätten die Frieslandmissionare, kaum zweifelhaft, die Weihe Wilbrords in Northumbrien nachgesucht. A m Caecilientage (22. November) wurde Wilbrord in der römischen Titelkirche der hl. Caecilia"' durch Papst Sergius zum Bischof geweiht"; alsdann wurde ihm auch das Pallium überreicht". Anläßlich dieser Bischofsweihe erst soll er in Rom anstatt seines dort befremdenden, als „barbarisch" empfundenen, weil schwer auszusprechenden, schwer einprägsamen, schwer zu schreibenden, auch nicht seinem northumbrischen Sinn gemäß verstandenen heimischen Namens den Namen des am 23. November gefeierten hl. Papstes Clemens erhalten haben, wie B a e d a " berichtet. Das Weihejahr 695 ist verbürgt durdi Wilbrords eigenhändigen Kalenderv e r m e r k E t in Dei nomine anno sexcentesimo nonagesimo quinto ab incarnatione Domini, quamuis indignus, fuit ordinatus in Romae episcopus ab apostolico viro, dom\i\no Sergio papa. Daher ist Baedas Datierung für 696 als irrig zu erachten. Weihetag und Weiheort bedingen sich gegenseitig, da der Papst am 22. November in seiner Titelkirche St. Caecilia amtierte'*. Hier ist der Liber ponficalis c. 86 (Vita Sergii), ed. Th. M o m m s e n : MG. Gesta pont. Rom. I (1898) S. 216; Baedas Vita Cudbercti prosaica c. 44, ed. J. S t e v e n s o n (London 1841) S. 132; Bonifatius nadi 23. Mai 753 an Papst Stephan II. (s. o. Anm. 23): Nam tempore Sergii, apostolicae sedis pontificis, venit ad limina sanctorum apostolorum presbiter quidam mirae abstinentiae et sanctitatis generis Saxonum, nomine Uuilbrord et alio nomine Clemens vocatus, quem prefatus papa episcopum ordinavit et ad predicandam paganam gentem Fresorum transmisit in litoribus Oceani occidui; Vita s. Willibrordi, S. 121 ff. •• H. G r i s a r , Gesdhidite Roms und der Päpste im Mittelalter 1 (1901) S. 150; V. B i a n c h i - C a g l i e s i , Santa Cacilia e la sua basilica nel Trastevere (Rom 1902); P.F. K e h r , Italia pontificia 1 (1906) S. 123f.; J. P. K i r s c h , Die römischen Titelkirdien im Altertum (1918) S. 113—116; über über das Caecilienfest vgl. C. E r b e s , Die hl. Caecilia usw., Zeitschr. f. Kirdiengesdi. 9 (1887) S. 1—66; J. P. K i r s c h , Die hl. Caecilia in der römischen Kirche des Altertums (1910). " Baeda I, S. 303: Ordinatus est autem in ecclesia sanctae martyris Ceciliae, die natalis eins. " Ebd. S. 302; dazu F. Z e h e t b a u e r . Das Kirdienredit bei Bonifatius (Wien 1910) S. 46—53. Ebd. S. 303: inposito sibi a papa memorato nomine Clementis. H.A. W i l s o n , The calendar of St. Willibrord (London 1918) Tafel 11; dazu o. Anm. 41. Beispiel vom Jahre 545 im Liber pontificalis c. 61 (Vita Vigilii), ed. Mommsen S. 151: Qui Anthemus scribon veniens Romae invenit eum [sc. Vigilium papam] in ecclesia sanctae Ciciliae X £aZ[endas] Decemb[Tts\; erat enim die natalis eins.  196  Franz Flaskamp  Baeda genau unterriditet gewesen. Gewiß wurde audi Bonifatius, da am Andreastag (30. November) 722, in der Titelkircbe St. A n d r e a s " g e w e i h t ' ' . Diese mit Titelkirdien bedachten Martyrerfeste gestatteten also eine römisdie Bisdiofsweihe audi an Nidit-Sonntagen Der besondere Editernadier Kalendervermerk'® Ordinatio dom\i\ni nostri Clementis zeugt nidit gegen den 22. November; er wurde nur, um den Raum neben dem Clemensfest (23. November) nidit zu belasten, im festlosen Felde zwischen dem 20. und 21. November begonnen und so lediglich bis zum 22. November herabgeführt. Die Umnennung Wilbrord-CIemens erfolgte allein zu praktischem Behuf der Römischen Kirche", nicht, wie man später hinsichtlich der Umnennung „Wynfreth-Bonifatius" vermutet hat, im Sinne einer Auszeichnung". Man hat sich daher auch in Rom die Namensuche nicht schwer gemacht: W y n f r e t h wurde nach dem Tagesheiligen seiner wohl am 14. Mai (719) und in der Titelkirche des altrömischen Märtyrers Bonifatius ausgesprochenen Sendung, benannt, Wilbrord nach dem männlichen Heiligen vom Folgetage der am Caecilienfest (695) vollzogenen Weihe. Über die Wirkung läßt sich nur halb und halb befinden. Wynfreth-Bonifatius hat, das erweist sein verbliebener mengenhafter Briefwechsel, fortan gegenüber vertrauten Landsleuten sich des Namendoppels bedient, im übrigen aber nur den „angenommenen" Namen verwertet. W i e aber Wilbrord verfahren ist? Die Zeugnisse sind zu gering an Zahl und zu wenig besagend, als daß ein bündiges Urteil anginge. Als „Wilbrord-CIemens'' hat er sich im Echternacher Kalender'®, so hat auch Bonifatius bei einmaliger Erwähnung ihn g e n a n n t " . Baeda spricht gleichfalls von „Uilbrord cognomento Clemens"^; dagegen war er f ü r das Kloster Echternach der „dominus noster Clemens"Darf man daraus mit einiger Wahrscheinlichkeit folgern, daß er mehr als Bonifatius auf seinen angestammten Namen d ü r f t e gehalten haben? — D a ß später bei dem einen der heimische Name schlechthin gebräuchlich blieb, bei dem anderen der neue Name durchaus sich einbürgerte, hatte seinen Grund im Biographischen: Baeda und seine Nachfolger schrieben „Wilbrord", der Mainzer Priester Wilbald und seine Nachfolger schrieben „Bonifatius".  Dem heimgekehrten Wilbrord-CIemens wies Pippin den befestigten Handelsplatz Wiltenburg-Utredit als Bischofssitz an®^ und bedachte den '2 K e h r , Italia pontificia 1, S. 56 f. " Wilbalds Vita s. Bonifatii, S. 29; die Weihebriefe, ed. T a n g l , S. 16 ff., sind vom folgenden Werktag (Dienstag, 1. Dezember) datiert, d . h . da ausgefertigt. " Th. M i c h e l s , Beiträge zur Geschichte des Bischofsweihetages im christlidien Altertum und im Mittelalter (1927) S. 52. '5 W i e oben Anm. 70. '» S. o. Anm. 58. " Von der vermeintlichen dignitas in Wilbalds Vita s. Bonifatii, S. 29 f., über Liudgers Vita Gregorii abbatis Traiectensis, ed. O. H o l d e r - E g g e r : MG. SS. X V 1 (1887) S. 72, und Vita et miracula s. Pirminii, ebd. S. 28f., und Radbods Vita s. Bonifatii, ed. L e v i s o n S. 64, und Vita tertia s. Bonifatii, ebd. S. 82, und Hukbalds Vita s. Lebuini, ed. M i g n e , PL. 132, Sp. 885, sdiließlich zur vermeintlich einwandfreien Erklärung als „Wohltäter" gediehen; vgl. F. F l a s k a m p , Der hl. Bonifatius im Blickfelde Luthers: Arch. f. Kulturgesch. 46 (1964) S. 219—226. '» S. 0. Anm. 42. '» S. o. Anm. 65. Baeda 1, S. 303. S. o. Anm. 75. S. u. Anm. 84.  Die frühe Friesen- und Sadisenmission  197  neuen Friesenbisdiof mit dem friesischen Zehnten Wilbrord errichtete in Utredit eine Erlöserbasilika als Bischofskirche und schloß ein S t i f t " mit Stiftssdiule " an. Zuvor gewiß hatte er die zerstörte Martinskirche wiederaufgebaut'^, mittlerweile auch schon mehr oder weniger zahlreiche neue Kirchen und Kapellen im weiten Missionsgebiet erstehen lassen''. Von diesen Einzelheiten war Baeda gleichfalls einigermaßen imterrichtet. Ihm allein ist aber noch eine recht beachtliche Mitteilung zu verdanken: daß der daheim umstrittene Bischof von York auf einer weiteren Romfahrt (703/04) zusammen mit seinem Vertrauensmann Acca den Friesenapostel Wilbrord in Friesland besucht habe " Worauf Zehntdiplom König Pippins, von Verberie 23. Mai 753, ed. E. M ü h I b a c h e r : MG. DD. Karol. I (1906) S. 6 f. nr. 4, verweist: ad illo episcopatu, ut omnem decimam de terra seu de mancipia aut de theloneo vel de negotio aut undecumque ad partihus fisci census sperare videbatur. ^ Baeda I, S. 303: Donauit autem ei Pippinus locum cathedrae episcopalis in castello suo inlustri, quod antiquo gentium illarum uerbo Uiltaburg, id est oppidum Uiltorum, lingua autem Gallica [sc. Latina] Traiectum uocatur; in quo aedificata ecclesia, reuerentissimus pontifex lange lateque uerbum fidei praedicans...; audi Bonifatius nach 23. Mai 753 an Papst Stephan IL, ed. T a n g l S. 235: et sedem episcopalem et aecclesiam in honore sancti Salvatoris constituens in loco et castello, quod dicitur Traiectum; et in illa sede et in aecclesia sancti Salvatoris, quam construxit, predicans usque ad debilem senectutem permansit; ebenso Altfrieds Vita s. Liudgeri, S. 21: Liudgerus igitur in ordine vicis suae nocturnis temporibus post psalmodiam et orationes speciales ... in solario aecclesiae sancti Salvatoris, quam sanctus Willibrordus construxerat, membra quieti dare solebat-, dafür auch Schenkung Karl Martells vom 9. Juli 726, ed. S. M u 11 e r , Het oudste cartularium van het stidit Utrecht (s'Gravenhage 1892) S. 6 nr. 2 (vgl. B ö h m e r - M ü h l b a c h e r , Reg. imp. ^I, S. 16 nr. 38, auch M u 11 e r , Regesten van het archief der bissdioppen van Utredit I (1917) S. 1 nr. 2): ad basilicam, quae est constructa in honore Salvatoris, domini nostri Jesu Christi. " Schenkung Karl Martells vom 1. Januar 722, ed. M u l l e r , Het oudste cartularium, S. 3 nr. 1 (vgl. B ö h m e r - M ü h l b a c h e r , Reg. imp. 'I, S. 14 nr. 34, audi M ü l l e r , Regesten, S. 1 nr. 1): ad monasterium, quod est infra muros Traiecto Castro situm constructum, ubi apostolicus vir, dom\i\nus et in Christo pater noster Uuillibrordus ardiiepiscopus sub sanctae conversationis caenobitali ordine custos preesse videtur. Sdiüler dortselbst wohl die Brüder Willibradit und Thiadbradit (Vita s. Liudgeri, S. 10), deren Neffe Liudger (ebd. S. 13 f.) nadi seinem eigenen Zeugnis (Vita Gregorii abbatis Traiectensis, S. 66): sermo iste de dom[i]no Gregorio, abbate et praeceptore meo ab infantia; auch ebd. S. 78: beatus abbas mens et praeceptor Gregorius. " Bonifatius nadi 23. Mai 753 an Papst Stephan IL, ed. T a n g l S. 235: et eam [sc. ecclesiolam' derutam] proprio labore a fundamento construxit et in honore sancti Martini consecravit. " Baeda I, S. 303: plures per illas regiones ecclesias... construxit; audi Bonifatius, ed. T a n g l S. 235: fana et dilubra destruxit et aecciesias construxit. " Ebd. S. 152: Denique reuerentissimus antistes Acca [seit 709 Bisdiof von Hexham] solet referre, quia, cum Romam uadens apud sanctissimum Fresonum gentis ardiiepiscopum Uuilbrordum cum suo antistite Uilfrido moraretur.  198  Franz Flaskamp  Das sowohl monasterium wie coenobium genannte Stift beherbergte zunächst northumbrisdie (vielleidit audi einige irisdie) Möndie stärker kolumbanischer Richtung, nicht Benediktiner, wandelte sieh aber mit der Zeit, durch den friesischen Nachwuchs, zu einem Heim weltgeistlicher Domherren. Zeugnis dieser Entwicklung ist der friesische Edeling Liudger": zunächst Schüler der Stiftsschule", dann Kleriker im Stift»2, 767 Diakon zu York»», 777 Priester zu Köln»^, 784—87 in Monte Cassino, dort im Ordenskleid mit der benediktinischen Lebensform bekannt geworden" und zur späteren Eigenklostergründung zu Werden (799) gerüstet", trotzdem Weltgeistlicher {canonicus) geblieben". Die altfundierte fränkische Martinskirche und die neue Erlöserbasilika samt Stift und Stiftsschule wurden einheitlich durch Wilbrord betreut, entsprechend gewiß auch durch dessen im Auftrage des Majordoms Karlmann berufenen Nachfolger D a d a n " . Die wirtschaftliche Ausstattung eben des Bischofs" gewährleistete den Bestand des Ganzen. Nach Dadans Tode trat aber eine Gliederung ein, und zwar aus dem Gegensatz und Gegeneinander privater, missionarischer, fränkisch-kirchlicher Interessen. Zunächst wurde der fränkische BonifatiusSchüler Gregor zum Abt des Stifts und Leiter der Stiftsschule bestellt"», Ende Mai 753 Bonifatius selber zum Treuhänder der Friesenmission berufen und mit der fundierten Martinskirche versorgt'", dessen Chorbischof Eoba mit der Erlöserbasilika bedacht"'. Nach dem Tode des Bonifatius und des crebro eum audierit de mirandis, quae ad reliquias eiusdem reuerentissimi regis [sc. Osualdi] in illa prouincia gesta fuerint, narrare. " Alois S c h r ö e r , Chronologische Untersuchung zum Leben Liudgers, in: Westfalia sacra 1 (1948) S. 85—138. " S. o. Anm. 86. Altfrieds Vita s. Liudgeri, S. 14: deposito saeculari habitu in Traiecto monasterio. " Ebd. S. 15. Ebd. S. 21, anläßlich der Bischofsweihe Alberichs; vgl. Fr. W. O e d i g e r , Die Regesten der Erzbischöfe von Köln im Mittelalter, 1961, S. 34 nr. 79. " Ebd. S. 25: penexit Romam et inde progrediens pervenit ad monasterium sancti Benedicti in regno Beneventino et illic in sancta conversatione consistens didicet regulam eiusdem sancti patris Benedicti. " Ebd. S. 37 f.; Niederrheinisches Urkundenbuch I, Nr. 2—28. " Ebd. S. 36: Cucullam eo, quod promissionem observationis monadiorum non fecerat, portare desivit. " Bonifatuis nach 23. Mai 753 an Papst Stephan IL, ed. T a n g ! S. 235: Princeps autem Francorum Carlmannus commendavit mihi sedem illam ad constituendum et ordinandum episcopum. Quod et feci. Ist also während der kurzen Regentschaft Karlmanns in Austrasien (741—47), doch, da schon auf dem Concilium Germanicum (742) begegnend, gleich anfangs geschehen; für die weitere Entwicklung fehlen alle Zeugnisse. Ob der Nachfolger Wilbrords in Utrecht wirklich bis zur 752 neu erörterten Sedisvakanz gelebt hat? " S. o. Anm. 83. Liudgers Vita Gregorii c. 1, S. 66; Altfrieds Vita s. Liudgeri I c. 10. 15, S. 15 f. 19. "" Diplome König Pippins von Verberie 23. Mai 753, ed. M ü h l b a c h e r : MG. DD. Karol. I, S. 6£f. nr. 4 f.; vgl. B ö h m e r - M ü h l b a c h e r , Reg. imp. ^I, S. 33 f. nr. 70 f., auch M u 11 e r , Regesten van het archief der bisschoppen van Utrecht, S. 1 nr. 3 f. Wilbalds Vita s. Bonifatii c. 8, ed. L e v i s o n S. 47: Et multa iam milia hominum, virorum ac mulierum, sed et parvulorum, cum commilitone suo diorepiscopo Eoban baptizavit; quem ad subveniendum suae senilis aetatis debilitati Fresonis, iniuncto sibi episcopio in urbe, qui vocatur Tredit, subrogavit.  Die frühe Friesen- und Sadisenmission  199  Eoba, beide am 5. Juni 754 bei Dokkum ermordet'"', übernahm Gregor neben seiner bisherigen Verwendung audi die Treuhändersdiaft für das friesische Missionswerk somit ingleichen die fundierte Martinskirdie, der neue, aus Northumbrien stammende Chorbischof Aluberht wieder die Erlöserbasilika"". Nach Gregors Tode (774) folgte in dessen Stellungen der fränkisdie Neffe Alberich'"', und dieser wurde nach auch wohl Aluberhts Tode 777 Diözesanbisdiof von Utrecht"", erlangte also wieder die umfassende Rechtsstellung Wilbrords. Zwischendurch war jedoch die altfundierte Martinskirche bereits zur Bischofskirche b e s t i m m t i n f o l g e d e s s e n glitt Wilbrords Erlöserbasilika zu einer Nebenkirche ab"". Dieser Wechsel in Äußerlichkeiten spiegelt aber auch einen Wandel in der Sache: die fremdländische Mission wurde zur fränkischen Reichskirche eingeschmolzen; man holte die altfränkische Martinskirche aus dem Abseits hervor, kennzeichnete so die altfränkische Frieslandmission als das Wesentliche, als die Epoche der friesischen Kirchengeschichte, das Wirken der Northumbrier als nur episodenhaftes Nach- und Zwischenspiel. Der literarische Streit wegen des Ranges der Utrechter Kirchen hätte nicht aufkommen können, wenn man weniger auf den Nimbus des Bonifatius, mehr auf die Nüchternheit fränkischer Kirchenpolitik geachtet hätte. Es war eine irrige Meinung, der fränkische Majordom Pippin der Jüngere sei in den Verhandlungen von Verberie (Mai 753) den Zuflüsterungen des Westsachsen Bonifatius erlegen, habe die Absichten dieses im fränkischen Episkopat sehr umstrittenen Ausländers unbedingt gelten lassen und den Widerspruch des Bischofs Hildegar von K ö l n ' " bündig verworfen; er habe den westsächsischen Bonifatius'»3 Ebd. S. 49f.; Eigils Vita s. Sturmi, ed. G . H . P e r t z : MG. SS. II (1829) S. 372; s. u. Anm. 159£f. " . . . Liudgers Vita Gregorii c. 10, S. 74 f.: Sed et hoc silentio minime tegendum est, ... quia post martyrium sancti magistri [sc. Bonifatii] . . . ipse quoque beatus Gregorius a Stephane, apostolicae sedis praesule, et ab illustri et religioso rege Pippino suscepit auctoritatem seminandi verbum Dei in Fresonia. w Ebd. S. 75: simul cum chorepiscopo et adiutore suo Aluberhto, qui de Britannia et gente Anglorum veniebat; seine Bischofsweihe 767 in York ist durch Northumbrisdie Jahrbücher, hg. von R. P a u l i , Forschungen z. dt. Gesch. 12 (1872) S. 151 bezeugt, auch Altfrieds Vita s. Liudgeri I 10, S. 15 f.; Aluberht ist aber offenbar niÄt der früheste Chorbischof Gregors gewesen, es sei denn, dieser habe sich solange der Hilfe anderer Bischöfe, besonders des kölnischen, bedient. " " Ebd. c. 15, S. 79: de tardatione electi filii eins Albrici; Altfrieds Vita s. Liudgeri I 15, S. 19: Sed et abbas Gregorius migravit ad Dominum, et suscepit curam pastoralem Albricus, nepos eius. Vita s. Liudgeri I 17, S. 31; dazu F r . W . O e d i g e r , Regesten d. Erzbischöfe v. Köln I, S. 34 nr. 79. Bezeugt durch Diplom König Karls von Nimwegen 8. Juni 777 für die Martinskirche, ed. M ü h l b a c h e r : MG. DD. Karol. I, S. 164 nr. 117: ad basilicam sancti Martini, quae est constructa Traiecto Veteri subtus Dorestato ubi venerabilis vir Albricus presbiter atque electus rector preesse videtur. " " Liudgers Vita Gregorii c. 15, S. 79: oratorium sancti Salvatoris. " " Begann mit S. M u l l e r , Die S. Salvatorskirche in Utrecht, Westdeutsche Zeitschr. 16 (1897) S. 256—292, und endete mit N. B. T e n h a e f f , Dom en oudmunster te Utrecht, Bijdragen voor vaderlandsche geschiedenis en oudheidkunde, 5. Reihe 2 (1915) S. 333—364. Bonifatius nach 23. Mai 753 an Papst Stephan IL, ed. T a n g l , S. 235: Nunc autem Colon[i]ensis episcopus illam sedem prefati episcopi Clementis a Sergio papa ordinati sibi usurpat et ad se pertinere dicit. 2 Ardiiv für Kulturgescfaidite 51/2  200  Franz Flaskamp  sdiüler Lul zum Bisdiof von Mainz ernannt und den so verfügbar gewordenen bisherigen Mainzer Bisdiof Bonifatius zum Bisdiof von Utredit, und das unbesdiadet der unbestreitbaren alten Kölner Anredite. So töridit aber waren die Arnulfinger nidit, daß sie Ausländerstimmen Gehör geliehen und heimisdie Leute ignoriert hätten. Pippin trug vielmehr in Verberie auf beiden Sdiultern und bahnte eine Übergangslösung an mit dem Hinblidc auf sein festes Ziel, eine kirdilidi-fränkisdie Zukunft Frieslands. Er beurlaubte den Bonifatius aus dessen Mainzer Diözesangesdiäften, gestattete die Annahme Luis als stellvertretenden Chorbisdiofs ermöglidite so dem Bonifatius die friesisdie Treuhändersdiaft, gewährte ihm aber nidit das Bistum Utredit. So wurde audi die Leidie des Bonifatius nidit in der Utrediter Erlöserbasilika aufgebahrt, sondern in der M a r t i n s k i r d i e D i e weitere Entwidtlung hat Pippin nidit mehr erlebt: daß (777) der Franke Alberidi Gesamterbe des von frühen Franken, dann Northumbriern, dann audi Westsadisen, sdiließlidi jüngeren Franken und dazu sdion friesisdiem Nadiwudis vertretenen Missionswerks in Friesland werden durfte Zusammenfassend kennzeidinet Baeda das Wirken Wilbrords als ein, wenn auch vielleicht nicht volles Gelingen, so doch überzeugendes Genügen: an Mitarbeitern habe es ihm dank andauerndem heimischen Interesse nicht gemangelt, einige seien jedoch mittlerweile gestorben; er habe viele Neuchristen gewonnen, viele Kirchen errichtet, auch einige Klöster gründen und sogar aus dem Kreise seiner Mitarbeiter neue Bischöfe berufen können"'. Man darf nicht annehmen, das seien ganz leere Worte im Legendenstil; dafür war Baeda doch zu sehr den geschichtlichen Tatsachen innerlich verpflichtet. Er mochte wirklich mehr an Einzelheiten erfahren haben, als der heutigen Beobachtung noch zugänglich ist. Manches, was er über Wilbrords Erfolge mitteilt, darf man sowieso angesichts seines langjährigen Mühens ohne weiteres gelten lassen, so die große Schar der Getauften, den aufgekommenen Bedarf an Kirchen und Kapellen. Von einem sehr gewachsenen Mitarbeiterkreis zeugt die urkundlich für 704 verbürgte Ausdehnung nach Thüringen"', Lul, seit 752 Chorbisdiof (Bonifatiusbriefe, S. 213 nr. 93), wurde erst nadi dem Tode des Bonifatius Bisdiof von Mainz und erst zwisdien 780 und 782 Erzbisdiof und Metropolit. Eigils Vita s. Sturmi c. 14, S. 372. S. o. Anm. 107. Baeda I, S. 303: reuerentissimus pontifex lange lateque uerbum fidei praedicans, multosque ab errore reuocans, plures per illas regiones ecclesias, sed et monasteria nonnulla construxit; nam non multo post alios quoque illis in regionibus ipse constituit antistites ex eorum numero fratrum, qui uel secum, uel post se illo ad praedicandum uenerant, ex quibus aliquanti iam dormierunt in Domino. Monumenta Epternacensia, ed. L. W e i l a n d : MG. SS. X X I I I (1874) S. 55 f., dazu O. D o b e n e c k e r , Regesta diplomatica necnon epistolaria historiae Thuringiae I (1896) S. 3 f. nr. 5, auch C. W a m p a c h , Geschidite der Grundherrsdiaft Edhternadi im Mittelalter I (1930) S. 113 ff.: der letzte Thüringerherzog Heden (über ihn auch Wilbalds Vita s. Bonifatii c. 6, S. 32 f. sowie MG. SS. rer. Merov. V S. 711—714) und dessen Gattin Theodrada sdienken  Die frühe Friesen- und Sadisenmission  201  auch die noch 724 daselbst begegnende Reihe northumbrisdier Geistlichen"'. Wilbrords festländisches Klosterinteresse läßt sich durch zwei Beispiele belegen, die 706 erfolgte Gründung des Großklosters Echtern a c h " ' und die 716 angebahnte Gründung zu Hammelburg"', sein Mühen um weitere Bischöfe freilich nur durch die Annahme eines Chorbischofs und die mögliche Berufung Theudberhts für Duurstede Baeda sdiließt 731 seinen Beridit mit einem Hinweis auf Wilbrords mittlerweile erreichtes hohes Alter und dessen nahende Vollendung'^'. Er wähnte wohl nicht, daß auch hier das Schicksal gegen die W a h r scheinlichkeit befinden sollte: Wilbrord hat, obwohl fünfzehn Jahre älter als Baeda, doch vier Jahre länger gelebt. Aber Baeda schrieb dem greisen Friesenmissionar einen Ehrentitel (venerabilis) zu, der später ihm selber verliehen ward, unter dem er selber in der Geistesgeschichte verankert wurde. In diesem letzten Blick nach Friesland überschlägt Baeda auch W i l brords 36 Bischofsjahre'^'. Dabei konnte er kaum dem Gedanken ausweichen, daß doch erheblich mehr, auch in belangvollen Dingen, zu melden gewesen wäre, wenn die friesische Mission sich nicht so wortkarg benommen hätte. Um nur zwei Neben- und Gegenentwicklungen am 1. Mai 704 auf der Feste Würzburg dem Bisdiof Wilbrord aus ihrem Grundbesitz bei Arnstadt, Mühlberg und zu Monra, der teilweise 726 (Dobenecker I, S. 7 nr. 15) dem Kloster Editernadi überlassen wird. Wilbalds Vita s. Bonifatii c. 6, ed. L e v i s o n S. 33: Torditwine et Berdithere, Eanberdit et Hunraed; diese allerdings, da zur Gesellsdiaft Wilbrords gehörend, von Bonifatius als „Irrlehrer" beanstandet. "8 MG. SS. rer. Merov. VII, 1920, S. 88 f.; A. H a l b e d e l , Fränkisdie Studien (1915) S. 16ff.; C. W a m p a c h , Grundherrsdiaft Editemadi (2 Bde. Luxemburg 1930/31). " ' Monumenta Epternacensia, S. 60, dazu D o b e n e c k e r , Regesta I, S. 6 nr. 7: Thüringerherzog Heden schenkt am 18. April 716 auf der Feste Hammelburg seinen gesamten dortigen Grundbesitz rechts der Fränkisdien Saale zum Zwecke einer geplanten Klostergründung an Wilbrord (ubi et cogito Dei misericordia per ipsius apostolici viri consilium monasterium construere); am 19. März 907 (Dobenecker I, S. 74 f. nr. 312) Besitztausdi zwischen Editernadi und Fulda. Bonifatius nadi 23. Mai 753 an Papst Stephan IL, ed T a n g l S. 235: Et sibi corepiscopum ad ministerium implendum substituit; Name nicht bekannt, muß aber (s.o. Anm. 98) vor der Berufung Dadans (741/42) gestorben sein. W. L e v i s o n , Willibrordiana, Neues Ardiiv 33 (1908) S. 517—525, audi: Aus rhein. u. fränk. Frühzeit S. 330—337. Baeda I, S. 303: Ipse autem Uilbrord cognomento Clemens adhuc superest, longa iam uenerabilis aetate, utpote tricesimum et sextum in episcopatu habens annum, et post multiplices militiae caelestis agones ad praemia remunerationis supernae tota mente suspirans. Baeda geht dabei von seinem terminus quo „696" (s. o. Anm. 70 f.) aus und gelangt durch Abzählen der Jahre (696. 97. 98. . . . 729. 30. 31) zu dieser Summe. Dieses Verfahren war indessen weder typisdi angelsädisisdi noch ausschließlich mittelalterlidi; daneben kannte man das Aufrechnen der Jahre, Monate und Tage. 2»  202  Franz Flaskamp  zu nennen, die sdion ihrer Eigenart und ihrer möglichen Folgen wegen eigentlidi gar nidit übersehen werden konnten und übergangen werden durften, nämlidi die erheblidie Störung des friesisdien Missionswerkes und beinahe Ausweglosigkeit Wilbrords nadi dem Tode Pippins (714) und während der so veranlaßten Maditkämpfe in Franken'" sowie die wohl damit zusammenhängende Ljindung (716) und dann bleibend lästige Konkurrenz Wynfreths Davon hat Baeda, wie es sdieint, nichts erfahren. Wohl umgekehrt: der westsächsische Gegenspieler Wilbrords gehörte zu den frühesten Baedazeugen, Vertretern von Baedas wissenschaftlichem Ansehen sogar auf dem Festland Aber für das Schicksal einer bestimmten Gruppe aus Wilbrords Schar blieb man in Wearmouth-Jarrow etwas aufmerksamer. Baeda verwertete sich als Anwalt ihrer Erinnerung, er allein. Was die Missions- und Kirchengeschichte noch einigermaßen tatsachenhaft, einigermaßen durchsichtig von Suidberht und den beiden Eadwalden zu melden weiß, geht auf Baedas Zeugnis zurück. Er hat gleichfalls nicht viel zu sagen vermocht, doch immerhin eine Entwicklung ausgewiesen, besser: angedeutet. Nach Baedas Worten vollzog sich Wilbrords Romreise zum Zwecie der Bischofsweihe in voller Einmütigkeit seiner damaligen friesischen Missionsgesellschaft"'. Wenn aber ein solcher Consens betont wird, so heißt das zugleich, dies sei nicht als selbstverständlich zu erachten, habe auch anders sein können, sei nicht immer so gewesen, obwohl man eigentlich hätte meinen mögen, eine solche isolierte Gemeinschaft auf vorgeschobenem Posten habe aus Sinn für Verantwortung jedwede Unstimmigkeit zu vermeiden gesucht und zu verhüten gewußt. Tatsächlich war vordem einmal eine böse Mißhelligkeit aufgekommen, unbeabsichtigt zwar, doch mit sehr peinlichen Verstriciungen. Die Frieslandmissionare hatten sich nämlich entschlossen, einen älteren Geistlichen ihres Kreises, Suidberht, zum Bischof weihen zu lassen, doch wohl, um fortan bei Firmungen und Kirchweihen nicht mehr fremder Hilfe zu bedürfen. Sie hatten diesen dann auch zum heimischen Northimfibrien geschickt, sich weihen B ö h m e r - M ü h l b a c h e r , Reg. imp. ^I, S. 12f. nr. 301 — 31f.; auch Wilbalds Vita s. Bonifatii c. 4, ed. L e v i s o n S. 16: gravi ingruente paganorum impetu hostilis exorta dissensio inter Carlum, principem gloriosumque ducem Frandiorum, et Redbodum, regem Fresonum, populos ex utraque parte perturbahat, maximaque iam pars ecclesiarum Christi, quae Frandiorum prius in Fresia subiectae erant imperio, Redbodi incumhente persecutione ac servorum Dei facta expulsione vastata erat et destructa, idulorum quoque cultura exstructis dilubrorum fanis lugubriter renovata. Fr. F l a s k a m p , Wilbrord-Clemens und Wynfrith-Bonifatius, in: Jubiläums-Festgabe „St. Bonifatius" (1954) S. 157—172. « • S. o. Anm. 5. Baeda I, S. 302: fauente omnium consensu.  Die frühe Friesen- und Sadisenmission  203  zu lassen; Bisdiof Wilfrith von York, damals flüditig in Mercien, hatte ihn geweiht"'. Daraus war aber den Friesenmissionaren eine arge Verlegenheit erwachsen, hatte sidi bei diesem gleidistrebenden Kreis eine Gruppenbildung ergeben. Suidberht war mit seinem unbedingten Anhang abgerüdct, Wilbrord mit dem wohl größeren Rest geblieben und er dann später — ohne Schwierigkeiten — Bisdiof geworden. Von dieser unerquidslidien Entwidmung hat audi Baeda erfahren, wohl nidit alle Einzelheiten und alle Fäden des Zusammenhanges, aber dodi soviel, daß er sidi sagte, bei mehr Vorsidit und Behutsamkeit habe sidi dieser üble Zwisdienfall nidit zu ereignen braudien. Er hat überlegt, wie es dazu gekommen sein mödite, was etwa inkorrekt gewesen sei. So stellt sidi ihm ein ethisdies und ein kirdienreditlidies Problem. Beiden ist er nadigegangen; das eine hat er jedodi unabhängig von dem anderen erwogen, infolgedessen das Gesdiehnis einmal so und das andere Mal durdiaus abweidiend datiert. Der eine Zeitvermerk ist gewiß falsdi, der andere mag riditig sein. Das ethisdie Problem: Baeda, in klösterlidier Disziplin groß geworden, im Würfelspiel der Politik nidit erfahren, stand vor dem Rätsel, wie man den untergeordneten Suidberht habe preisgeben, den verantwortlidien Missionsobern Wilbrord habe sdionen können. Er vermutet, behauptet geradezu, alles sei ohne Zutun Wilbrords gesdiehen, ohne sein Wissen und seine Beteiligung, sei also eine — man darf sagen — unverantwortlidie Eigenmäditigkeit der ihm unterstellten Leute gewesen, habe sidi eben bei längerem Fernsein Wilbrords abgespielt. Als soldie längere Abwesenheit betraditet er die angeblidie Romreise Wilbrords aus Anlaß der 690 eingeholten päpstlidien Sendung"'. So hat er die Wahl und Weihe Suidberhts auf 690 datiert. Das alles kann nidit zutreffen; denn eine derartige Eigenmäditigkeit ist den abhängigen Leuten nidit im mindesten zuzutrauen; überdies bestand damals, wo die friesisdie Arbeit erst beginnen sollte, keinerlei Anlaß zu einer Bisdiofswahl und Bisdiofsweihe. Nodi mehr: Wilfrith von York hätte gewiß keinen Anwärter geweiht, der ohne die üblidien Empfehlungsbriefe"", hier seines Vertrauensmannes Wilbrord, gekommen wäre. Es kann darum nidit zweifelhaft sein, daß Wilbrord ebenso beteiligt gewesen war wie die anderen, im Grunde mehr verantwortlidi als diese. Wenn aber nun der geweihte Suidberht das Ägernis darstellte, er als ein „Unmöglidi" politisdi 128 durdi Baeda hier bezeugt; über die gefählsdite Vita s. Swiberti des Pseudo-Marcellinus (hg. von N. S u r i u s , De probatis sanctorum historiis III, 1618, S. 3—16) vgl. W. D i e k a m p , Histor. Jahrbudi 2 (1881) S. 272—287, über den Fälsdier Theoderidi Pauli von Gorkum vgl. Jan R o m e i n , Gesdiiedenis van de Noord-Nederlandsdie gesdiiedsdirijving in de middeleeuwen (Haarlem 1932) S. 219fF. "» S. o. Anm. 51. S. o. Anm. 49.  204  Franz Flaskamp  beantstandet wurde, ließ sidi kaum ein anderer Ausweg finden als sein Sdieiden vom friesisdien Missionsfelde. Oder sollte man das ganze friesische Unternehmen preisgeben? Das kirdienreditlidie Problem: Suidberht war durch einen einzelnen »md einfachen Bisdiof geweiht, während nadi altkirdilidier Ordnung nur ein Erzbischof sollte weihen dürfen und audi er nur unter Assistenz (Zeugenschaft) zweier sdion geweihten Bischöfe"'. Baeda kannte zwar einen Praecedenzfall: im Jahre 627 hatte Bischof Paulinus von York, gleichfalls als einfacher Bischof und einzeln, in Lincoln den neugewählten Metropoliten Honorius von Canterbury konsekriert, was besonders inkorrekt gewesen und dadurch nicht korrekt geworden war, daß Papst Honorius I. (625—38) nadi einigen Jahren (634) beiden, dem Weihebischof ebenso wie dem Geweihten, das Pallium verliehen hatte"'. Das weiß auch Baeda. Daher beruft er sich nicht auf diesen Praecedenzfall, um Wilfriths Alleingang verständlich zu machen, zu entschuldigen. Er bedient sich einer anderen Erklärung: der neuberufene angelsächsische Metropolit Berchtwald von Canterbury sei seiner Weihe wegen zum Erzbischof Gottfried von Lyon unterwegs gewesen und nicht rechtzeitig heimgekehrt"'. Als wenn der Northumbrier Suidberht seine Weihe in Canterbury hätte nachsuchen wollen, als Mitglied der dem Bischof Wilfrith von York unbedingt ergebenen friesischen Missionsgesellschaft sich nach Canterbury habe wenden, den heimischen Erzbischof-Anwärter Wilfrith habe ignorieren dürfen! Inmmerhin hat Baeda so, mit dieser angeblichen Bedingtheit, die Weihe Suidberhts auf den Sommer 693 datiert; denn, soweit Baeda wußte, war Berhtwald am 1. Juli 692 gewählt, am 29. Juni 693 geweiht'" und am 31. August 693 wieder in Canterbury gelandet. Die Schwierigkeiten aber, die sich demnächst in Friesland einstellten und Suidberhts Abrücken veranlaßten, rührten niciit von den kirchenF. H i n s c h i u s , Kirdienrecht I (1869) S. 101 ff. Bonifatius bestellte daher für die Weihe des vorgesehenen Thüringerbischofs Wilbald, am 21./22. Oktober 741 zu Sülzenbrüdcen bei Erfurt vollzogen, die entfernten Bischöfe Witta von Buraburg und Burchard von Würzburg; vgl. Fr. F l a s k a m p , Das Bistum Erfurt, Westfäl. Zeitsdir. 83 (1925) S. 1—26. Baeda I, S. 119ff.; Ph. J a f f 6, Reg. pont. Rom. «I (1885) S.225 nr.2019f. Ebd. S. 302. Ebd. S. 295. Indessen vermerkt der Liber pontificalis c. 86 (Vita Sergii), ed. Th. M o m m s e n S. 216: Hic [sc. Sergius papa] ordinavit Bertoaldum, Britanniae ardiiepiscopum, atque dementem in gentem Frisonum, womit also Berhtwalds wie Wilbrords römische ordinatio behauptet, als gleichartig behandelt wird. Ob daneben wirklich Baedas Zeugnis von Berhtwalds in Lyon erfolgter Weihe bestehen kann? Ob man ein Versehen der Vita Sergii vermuten oder annehmen darf, der Verfasser habe die Verleihung der Pallien als ordinatio bezeichnet?  Die frühe Friesen- und Sachsenmission  205  reditlidien Mängeln seiner Weihe, sondern von seiner Wahl und Weihe überhaupt. Der selbstbewußte fränkisdie Majordom interessierte sidbi kaum für Formen und Formeln des römisdien Kirdienredits, um so mehr aber für die Weiten und Engen, Möglichkeiten und Grenzen, Fäden und Masdien des staatlidi-fränkisdien. Er mußte die ohne sein Einvernehmen erfolgte Wahl imd Weihe Suidberhts als eine gar nidit zu billigende Eigenmächtigkeit der im Geltungsbereidi des fränkischen Staatskirdienredits tätigen Northumbrier erachten, als einen dem fränkischen Staatskirchenrecht widerstrebenden Versuch, ohne Genehmigung der zuständigen und verantwortlichen Landeshoheit ein friesisches Missionsbistimi zu gestalten, oder sogar, ganz böse gedeutet, als ein Listenspiel, in dem man kirchlicherseits vollendete Tatsachen geschaffen hatte und alsdaim der Landeshoheit zumuten wollte, nolens-volens durch Bewilligung von Regalien das Geschehene gutzuheißen und dabei noch ein Praejudiz für die fernere kirchliche Entwicklung Frieslands in Kauf zu nehmen. Zwar war das kaum so gemeint gewesen und hinsichtlich derartiger Konsequenzen überlegt worden. Vielmehr hatten die northumbrischen Missionare wohl nur dem Bedarf der Stunde genügen und lediglich einen Weihebischof nach irisch-northumbrischer A r t " ' gewinnen, nicht schon einen Diözesanbischof einspielen wollen"'. Ihr Außendienst brachte es im ganzen mit sich, daß sie fort und fort nach eigenem Ermessen handeln, ohne Beihilfe der fränkischen Staatskirche neue Mitarbeiter in Northumbrien und Spenden der Heimat suchen mußten. Wie dem auch sei, für Pippin bedeutete die Wahl und Weihe Suidberhts einen üblen Verstoß gegen die im Frankenreiche gültige staatskirchenrechtliche Ordnimg, die dem Majordom ebenso die Errichtung neuer Bistümer und die Ernennung der Bischöfe zugestand, wie er durch Gewährung von Regalien die wirtschaftliche Existenz sichern mußte"'. Er konnte und wollte auch nicht einräumen, daß im Missionsgebiete, in der fränkischen Provinz Friesland, eine weniger profränkische kirchliche Ordnung sich anbahnte, als im fränkischen Kernlande üblich war. Dies um so weniger, da er ohnehin die Mission nur für ein unvermeidliches Einstweilen hielt, das nach Möglichkeit der fränkischen Staatskirche an"s H i n s C h i US, Kirdienredit II (1878) S. 162—169; Th. G o t t l o b , Der abendländische Chorepiskopat (1928). So audi H . A . W i l s o n , The calendar of St. Willibrord, (London 1918) S. 7: But there seems to he no reason for regarding it as an attempt to Substitute Suidbert for Willibrord as their head. They were no doubt accustomed by their experiences in Ireland to a system, by whidi the bishop in a monastic Community was subject to the rule of a presbyter abbot. " ' A . W e r m i n g h o f f , Verfassungsgeschidite der deutsdien Kirdie im Mittelalter (n913) S. 10—17; audi Fr. Z e h e t b a u e r , Das Kirdienredit bei Bonifatius (1910) S. 129—132.  206  Franz Flaskamp  zupassen und demnädist ihr voll zu assimilieren sei. E r hat daher die W a h l und W e i h e Suidberhts nicht anerkannt, f ü r Friesland nicht gelten lassen. Baeda meldet nidit, was und wie man d a n n innerhalb der friesischen Missionsgesellschaft beraten, was und wie m a n mit dem M a j o r dom verhandelt habe. E r beriditet nur von dem Ausgang und weiteren Verlauf: Suidberht sei abgerückt, Wilbrord nachher durch Pippin zum friesischen Diözesanbisdiof bestimmt. M a n möchte sagen, es sei nach den Spielregeln der Politik eine „ganz natürliche Entwidclung" gewesen; man habe den „Stein des Anstoßes" beseitigt und so den W e g wieder gangbar gemadit, den gestörten consensus^^ wiederhergestellt. Suidberht und die Seinen verließen aber nicht nur Friesland, sondern das fränkisdie Hoheitsgebiet überhaupt. Sie wandten sidi zu den „Brukterern" im sächsischen Grenzraum südlich der Lippe und begannen eine eigene Missionsarbeit. Grenzlandbewohner pflegen nie eingeschworene „Patrioten" zu sein, vielmehr nach beiden Seiten zu blicken, der Gunst und Abgunst beider Seiten gewärtig zu bleiben. So waren audi die Brukterer den harmlosen Fremdlingen nicht ohne weiteres abhold, ließen sich vielmehr deren Botschaft gefallen und eröffneten ihrem kühnen Versuch günstige Aussichten. Doch fehlte dieser verlockenden Neulandkultur die erwünschte und benötigte Dauer. Ein Überfall aus dem nördlichen sächsischen K e m l a n d machte alles zunichte. Die Missionare mußten flüchten und sahen ihr Mühen als gescheitert an. Sie hatten also schon in einem recht befristeten W a g n i s erkannt, was Wynfreth-Bonifatius zwei Menschenalter später als E r f a h r u n g eines langjährigen Wirkens aussprach: daß n u r unter dem Schutze fränkischer Macht christliche Missionsarbeit möglich sei I n solcher Verlegenheit erbat der kleine Suidberhtkreis Pippins N a d i sicht und erlangte auch — wie Baeda versichert: wesentlich dank der Fürsprache von des Majordoms Gattin Plektrud — auf einer Uferinsel (Werth) des Rheines eine Bleibe I n einem dort gebauten kleinen Kloster d u r f t e n sie ihr ferneres Dasein fristen. Suidberht selber hat in  S. o. Anm. 127. 0 . B r e m e r , Ethnographie der germanisdien Stämme III (^1900) S. 903f.; L. S c h m i d t , Gesdi. der deutsdien Stämme II (1919) S. 416—421; dazu u. Anm. 147. "» An Bisdiof Daniel von Windiester, ed. T a n g l S. 130: Sine patrocinio principis Francorum nec populum aecclesiae regere nec presbiteros vel clericos, monamos vel ancillas Dei defendere possum, nec ipsos paganorum ritus et sacrilegia idolorum in Germania sine illius mandato et timore prohibere valeo. Baeda I, S. 302: in insula quadam Hreni, quae lingua eorum vocatur ,in litore'. Die Senke des einstigen Rheinarmes, der die Insel vom Festlande abschloß, ist in den Wiesen nördlidi der heutigen Stadt Kaiserswerth verblieben.  Die frühe Friesen- und Sachsenmission  207  dieser Zurüdcgezogenheit nodi bis 713 gelebt"^. Zwar gebridit es an unmittelbaren Zeugnissen irgendeiner über die Trennung hinaus fortgesetzten Verbindung mit den Wilbrordleuten in Friesland. Dodi läßt vielleicht Baedas Wissen ein später wieder aufgelebtes Einvernehmen vermuten. Zu dem verewigten Suidberht hat das Wilbrordkloster Editernadi sich bekaimt; man trug seinen Namen, zum 1. März, dem Kalender der sonderlidi verehrten Heiligen ein'^. Später feierte der Wilbrordbiograph Alkuin audi Suidberht als erlauchten Glaubensboten Northumbriens'". Suidberhts Gründung aber hat, als späteres „Stift Kaiserswerth", nach der benachbarten Pfalz so bezeichnet, die Jahrhunderte überdauert"'. Im Echternaclier Kalender sind aber auch, zum 4. Oktober, die beiden Eadwalde vermerkt"" und so gleichfalls als vordem Angehörige des Wilbrordkreises in Friesland. Von ihnen hat Baeda allerdings noch viel weniger erfahren als von den Suidberhtleuten. Was er von den Eadwalden sagt, ihrem Wege und ihrem Mißgeschick'", liegt bereits zwischen Geschichte, Sage und frommer Legende. Von ihnen war offenbar redit wenig Greifbares bekannt geworden; den empfundenen Leerraum hatte man bereits mit vertrauten Motiven biblisdien xmd hagiologisdien Ursprungs zu füllen gesucht. Sie sollten auch zu den Sadisen gekommen sein, in einem sädisisdien Eschdorf Halt gemacht, auf dem adeligen Haupthof daselbst um eine Empfehlung beim zuständigen Häuptling (princeps) gebeten haben, doch, ehe der adelige Gutsherr (villicus) diese Verbindung habe vermitteln Annales s. Amandi, ed. G.H. P e r t z : MG. SS. I (1826) S. 6, ansdiließend Annales Petaviani: ebd. S. 7: 713. ... et depositio Suitberti episcopi. » " H . A . W i l s o n , The calendar of St. Willibrord, Tafel 3: Suidberht aepiscopus. Versus de sanctis Euboricensis ecclesiae, v. 1071—1076, ed. E. D ü m m 1 e r : MG. Poetae lat. I (1881) S. 193: At alii atque alii praefata ex gente ministri sermonis fuerant Ulis in partibus orbis. Ex quibus egregii Suidbert Viraque sacerdos temporibus fulsere suis, qui culmine clari virtutum fuerant. Nostro quos carmine cunctos längere non libuit. K. H e c k , Gesdiidite von Kaiserswerth (M925); P. G i e m e n , Kaiserswerth (1909); d e r s . , Kunstdenkmäler der Rheinprovinz III 1 (1894) S. 128—145; H. K e l l e t e r , Urkundenbuch des Stiftes Kaiserswerth (1905); G. P o t t h o f f , Inventar der Pfarrkirdie St. Suidbertus in Kaiserswerth (1961). H.A. W i l s o n , The calendar of St. Willibrord, Tafel 10: Natale sanctorum martyrum Heuualdi et Heuualdi; Baeda I, S. 299, hat sie nur mit der Formel „Horum secuti exempla" dem Wilbrordkreis angegliedert. Baeda I, S. 299f.; dazu H. W i e d e m a n n , Die Sadisenbekehrung (1932); bedingt H. R a d e m a c h e r , Die Anfänge der Sadisenmission südlidi der Lippe, in: Westfalia sacra 2 (1950) S. 133—186; Fr. F l a s k a m p , Der Bonifatiusbrief von Herford, Ardi. f. Kulturgesdi. 44 (1962) S. 315—334.  208  Franz Flaskamp  können, von den mißtrauisch gewordenen Bauersleuten ermordet sein. A n der Stätte aber, wo ihr Blut vergossen sei, habe der E r d b o d e n (socii), eine wertvolle Quelle g e s p e n d e t I h r e Leichen sollten von den „ G e f ä h r t e n " doch wohl die Kaiserswerther gemeint, aus dem Rheine geborgen und beerdigt, indessen auf Pippins Geheiß nadi K ö l n gebradit und dort geziemend bestattet sein. K ö l n (St. Klemens, später St. Kxmibert genannt) w a r also, als B a e d a 731 seine Kirdhengeschichte absdiloß, sdion zur eigentlidien Stätte des Ewaldenkults geworden Die verschiedenen späteren Versudie, den Ewaldenmord zu lokalisieren, lassen sidi als Vermutungen ohne tatsadienhafte Begründung erklären. Der Ewaldenkult zu Aplerbedc bei Dortmund geht gewiß auf den dortigen Grundbesitz der Kölner Benediktiner zurüdc; die Benediktiner von Deutz hatten das Patronatsredit der Pfarrkirdie. Spätestens im 14. Jahrhundert deutete man den örtlidien Gutshof „Mortmann" als „Mordhof", nämlidi als Stätte, wo die beiden Ewalde ermordet seien'". Im 15. Jahrhundert glaubte der Kölner Kartäuser Werner Roleving, sein Heimatkirdispiel Laer im Münsterisdien lasse sidi so erweisen, das nadi einer kirdilidien Stiftung an Ort und Stelle üblidierweise „Hilgenfeld" genannte Gelände sei als Kamp der hll. Ewalde zu verstehen und der unterhalb des Dorfes einer Abdadiung der Baumberge entfließende bemerkenswert wasserreiche Badi als die Ewaldenquelle*". Für den nun vermeintlidj als „zu Laer" gesdiehen „erwiesenen" Ewaldenmord entded(te man in der S.Hälfte des 19. Jahrhunderts nodi eine mehr empfehlenswerte, weil wirklidi rheinnahe Stätte, die Bauersdiaft Laar bei Ruhrort, und baute dort 1862 eine Ewaldenkapelle, 1891 zur heutigen Ewalden-Pfarrkirdie von Duisburg-Laar ausgeweitet W i l b r o r d s A l t e r n und vorauszusehendes Lebensende w a r aber nicht n u r für B a e d a bemerkenswert; ein anderer machte sidi noch interessierter darüber seine Gedanken, der Westsachse W y n f r e t h - B o n i f a t i u s . Dieser WicgFüllung w a r 7 1 6 in Friesland ebenso ergebnislos geblieben wie v o r d e m Beides mochte ihm eine quälende Erinnerung sein, ein der  berht und h a t t e 7 1 9 ein E i n v e r n e h m e n mit W i l b r o r d nicht e r r e i c h t " ' . harrendes vacuum. So plante er die Nachfolge W i l b r o r d s in Friesland, Über bemerkenswerte Quelle audi G. J a c o b , Ein arabischer Berichterstatter aus dem 10. Jahrhundert ('1896) S. 47 f.: „wunderbare Wasserquelle, Honigquelle genannt" in der Gegend von JUJaterbruna" (Paderborn). Dort audi der Irrtum „Brüder Ewalde" beheimatet, nämlich zu erklären als Mißverständnis der „fratres" im Testament des Erzbisciofs Bruno I., hg. von H. S c h r ö r s : Annalen d. Hist. Vereins f. d. Niederrhein 91 (1911) S. 121: Sancto Cuniberto [d. h. für dessen Altar] scutülae duae; sanctis Ewaldis duohus d . h . für deren Altar] pallia tria; fratribus [d.h. für die Stiftsherren vom : Cunibertstift] vasa duo, librae octo, mensale, scamnalia duo, tapete unum. " " J . M. L o h o f f , Kritische Untersuchung der Geschichte der beiden Ewalde unter besonderer Berüdcsichtigung der Aplerbecker Tradition, Beiträge zur Gesdiidite Dortmunds und der Grafsdiaft Mark 1 (1875) S. 106—126. » " Westfalenbudi, neu hg. von H. B ü c k e r (1953) S. 54—59. Akte Duisburg-Laar I in der (1945 verbrannten) Registratur des Generalvikariats Münster. S. 0. Anm. 125.  Die frühe Friesen- und Sadisenmission  209  sogar in wirklidikeitsfremder Zuversicht nodi mehr, nämlich die Ausweitung der Wilbrordmission zu den noch unabhängigen Nordfriesen rechts von Rhein und Yssel. Mit solchen Absichten hat er sich 738 in Rom hervorgewagt. Es bestand wirklich einiger Anlaß: im Jahre 734 hatte der Majordom Karl Martell die fränkische Macht in Friesland über den Rhein hinausgeführt"*. In Rom aber hielt man nicht viel von kühnen Plänen, bevorzugte vielmehr das Beharren in sicherer Arbeit, lehnte daher diese Frieslandgelüste bündig a b " ' . Auch die fränkischen Majordome mochten von soldlier Nachfolge Wilbrords nicht hören. Sie wußten, wie wenig Bonifatius beim fränkischen Episkopat gelitten war, und taten gewiß gut daran, ihn in seinen bisherigen Aufgaben zu belassen"'. Anderthalb Jahrzehnte später wurde ihm zwar die Betreuung von Wilbrords Werk als Altershonorar zugestanden. Wo er dann aber doch auch nodi Initiative entfalten wollte, im Vordringen nach Nordfriesland sogar recht weit den Bereich fränkisch gewährleisteter Sicherheit verließ, erfüllte sich sein Schicksal: am 5. Juni 754 verblutete er mit angeblich 53 Gefährten und Helfern"« bei Dokkum"». Davon hat man auch im fernen Wearmouth-Jarrow gehört. Baedas chronographischer Nachfolger verzeichnete zutreffend die Frist „754" und dazu manche Einzelheiten, nahm also vom Ausgang des Wilbrordkonkurrenten einige Notiz "S vom Lebensende Wilbrords dagegen überhaupt nicht und nur ganz bescheiden vom Tode Baedas B ö h m e r - M ü h l b a c h e r , Reg. imp. «I, S. 17 nr. 39d. Von Rom 738 an seine austrasischen Mitarbeiter, ed. T a n g l S. 66: apostolicus pontifex ... consilium et preceptum dedit, ut iterum ad vos revertamus et in certo labore persistamus. " ' Beweis: die Ernennung eines neuen Friesenbischofs durch Karlmann (s. o. Anm. 98). Über seine Mitwirkung beim Staatsstreich Pippins (751) vgl. M. T a n g l , Die Epodie Pippins, Neues Ardiiv 39 (1914) S. 257—277; E. P e r e i s , Pippins Erhebung zum König, Zeitsdir. f. Kirdiengesdi. 53 (1934) S. 400—416. Sollte diese Anzahl der 54 Märtyrer nicht dem Todesjahr 754 zugepaßt sein? "» S. o. Anm. 103. Darüber vgl. L. O e l s n e r , Jahrbücher des fränkischen Reiches unter König Pippin (1871) S. 489—494; M. T a n g l : Jahrbudi des Vereins für hessisdie Gesdiichte 37 (1903) S. 223—250; F. F l a s k a m p : Histor. Jahrbudi 47 (1927) S. 473—488. Ch. P l u m m e r , Venerabiiis Baedae opera historica I, S. 362: Anno DCCLIIII. Bonifactus, qui et Uinfridus, Francorum episcopus, cum quinquaginta tribus martyrio coronatur; et pro eo Redgerus [d.i. Chrodegang von Metz] consecratur arehiepiscopus a Stephane papa. Ebd. S. 361: Anno DCCXXXV. ...et Baeda presbyter obiit.  </p>
</sec></body>
</article>`

func TestSchema(t *testing.T) {
	var article Article
	err := xml.Unmarshal([]byte(example), &article)
	if err != nil {
		t.Errorf("got %v, want %v", err, nil)
	}
	if len(article.Front.Journal.ISSN) != 2 {
		t.Errorf("got %d, want %d", len(article.Front.Journal.ISSN), 2)
	}
	if article.Front.Article.PubDates[0].Year.Value != "1969" {
		t.Errorf("got %s, want %d", article.Front.Article.PubDates[0].Year.Value, 1969)
	}
	if article.Front.Article.TitleGroup.Subtitle.Value != "Das Zeugnisdes Baeda" {
		t.Errorf("got %s, want %s", article.Front.Article.TitleGroup.Subtitle.Value, "Das Zeugnisdes Baeda")
	}
	if article.Front.Article.Issue.Value != "2" {
		t.Errorf("got %s, want %d", article.Front.Article.Issue.Value, 2)
	}
	if article.Front.Article.Volume.Value != "51" {
		t.Errorf("got %s, want %d", article.Front.Article.Volume.Value, 51)
	}
	if article.Front.Article.Permissions.CopyrightYear.Value != "2013" {
		t.Errorf("got %s, want %s", article.Front.Article.Permissions.CopyrightYear.Value, "2013")
	}
	if !strings.HasPrefix(article.Body.Section.Value, "<p>Die frühe Friesen") {
		t.Errorf("got %+v, want %s", article.Body.Section.Value, "<p>Die frühe Friesen...")
	}

}
