---
id: migrating-3.x
title: Migrating from H3 version 3.x
sidebar_label: Migration guide
slug: /library/migrating-3.x
---

The H3 library introduced breaking changes in version 4.0.0, so applications developed against earlier versions
need to be updated before they can use the new library version. Most of the changes relate to function naming,
and some relate to the behavior of the functions.

The grid itself - the layout of cells, which cell an H3 index refers to, and the structure of an H3 index - is
not changed in 4.0.0. H3 indexes generated by 3.x will be understood the same by 4.0.0, and those generated by 4.0.0
will be understood the same in 3.x.

The areas where there are changes include:

# Function naming

Many [function names have changed](./migration-3.x/functions) between 3.x and 4.0.0. These follow the H3 [terminology](./terminology) reference,
and that document explains how each function name has been renamed. These changes were made to make the API more
consistent and predictable.

# Error codes

The C library is being changed to more consistently [report errors](./errors). This is done via the return code of
functions. Users of the C library will need to adjust some function calls to pass output parameters instead of
using the return value of a function.
