#!/usr/bin/env python
# file: compound.py
#===============================================================================
# Copyright 2019 Intel Corporation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#===============================================================================

# -*- coding: utf-8 -*-

#
# Generated Fri Apr 24 19:24:13 2020 by generateDS.py version 2.35.21.
# Python 3.6.10 |Anaconda, Inc.| (default, Mar 25 2020, 23:51:54)  [GCC 7.3.0]
#
# Command line options:
#   ('-o', './dalapi/compound_parser.py')
#
# Command line arguments:
#   ./doxygen/xml/compound.xsd
#
# Command line:
#   /root/miniconda3/envs/spec/bin/generateDS -o "./dalapi/compound_parser.py" ./doxygen/xml/compound.xsd
#
# Current working directory (os.getcwd()):
#   oneDAL
#

from six.moves import zip_longest
import os
import sys
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ImportError:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ImportError:

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ImportError:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer valuess')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            return ""


    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            return 'xs:string'
        return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class DoxAccessor(Enum):
    RETAIN='retain'
    COPY='copy'
    ASSIGN='assign'
    WEAK='weak'
    STRONG='strong'
    UNRETAINED='unretained'


class DoxBool(Enum):
    YES='yes'
    NO='no'


class DoxCompoundKind(Enum):
    CLASS='class'
    STRUCT='struct'
    UNION='union'
    INTERFACE='interface'
    PROTOCOL='protocol'
    CATEGORY='category'
    EXCEPTION='exception'
    SERVICE='service'
    SINGLETON='singleton'
    MODULE='module'
    TYPE='type'
    FILE='file'
    NAMESPACE='namespace'
    GROUP='group'
    PAGE='page'
    EXAMPLE='example'
    DIR='dir'


class DoxGraphRelation(Enum):
    INCLUDE='include'
    USAGE='usage'
    TEMPLATEINSTANCE='template-instance'
    PUBLICINHERITANCE='public-inheritance'
    PROTECTEDINHERITANCE='protected-inheritance'
    PRIVATEINHERITANCE='private-inheritance'


class DoxHighlightClass(Enum):
    COMMENT='comment'
    NORMAL='normal'
    PREPROCESSOR='preprocessor'
    KEYWORD='keyword'
    KEYWORDTYPE='keywordtype'
    KEYWORDFLOW='keywordflow'
    STRINGLITERAL='stringliteral'
    CHARLITERAL='charliteral'


class DoxImageKind(Enum):
    HTML='html'
    LATEX='latex'
    RTF='rtf'


class DoxMemberKind(Enum):
    DEFINE='define'
    PROPERTY='property'
    EVENT='event'
    VARIABLE='variable'
    TYPEDEF='typedef'
    ENUM='enum'
    FUNCTION='function'
    SIGNAL='signal'
    PROTOTYPE='prototype'
    FRIEND='friend'
    DCOP='dcop'
    SLOT='slot'
    INTERFACE='interface'
    SERVICE='service'


class DoxParamDir(Enum):
    IN='in'
    OUT='out'
    INOUT='inout'


class DoxParamListKind(Enum):
    PARAM='param'
    RETVAL='retval'
    EXCEPTION='exception'
    TEMPLATEPARAM='templateparam'


class DoxProtectionKind(Enum):
    PUBLIC='public'
    PROTECTED='protected'
    PRIVATE='private'
    PACKAGE='package'


class DoxRefKind(Enum):
    COMPOUND='compound'
    MEMBER='member'


class DoxSectionKind(Enum):
    USERDEFINED='user-defined'
    PUBLICTYPE='public-type'
    PUBLICFUNC='public-func'
    PUBLICATTRIB='public-attrib'
    PUBLICSLOT='public-slot'
    SIGNAL='signal'
    DCOPFUNC='dcop-func'
    PROPERTY='property'
    EVENT='event'
    PUBLICSTATICFUNC='public-static-func'
    PUBLICSTATICATTRIB='public-static-attrib'
    PROTECTEDTYPE='protected-type'
    PROTECTEDFUNC='protected-func'
    PROTECTEDATTRIB='protected-attrib'
    PROTECTEDSLOT='protected-slot'
    PROTECTEDSTATICFUNC='protected-static-func'
    PROTECTEDSTATICATTRIB='protected-static-attrib'
    PACKAGETYPE='package-type'
    PACKAGEFUNC='package-func'
    PACKAGEATTRIB='package-attrib'
    PACKAGESTATICFUNC='package-static-func'
    PACKAGESTATICATTRIB='package-static-attrib'
    PRIVATETYPE='private-type'
    PRIVATEFUNC='private-func'
    PRIVATEATTRIB='private-attrib'
    PRIVATESLOT='private-slot'
    PRIVATESTATICFUNC='private-static-func'
    PRIVATESTATICATTRIB='private-static-attrib'
    FRIEND='friend'
    RELATED='related'
    DEFINE='define'
    PROTOTYPE='prototype'
    TYPEDEF='typedef'
    ENUM='enum'
    FUNC='func'
    VAR='var'


class DoxSimpleSectKind(Enum):
    SEE='see'
    RETURN='return'
    AUTHOR='author'
    AUTHORS='authors'
    VERSION='version'
    SINCE='since'
    DATE='date'
    NOTE='note'
    WARNING='warning'
    PRE='pre'
    POST='post'
    COPYRIGHT='copyright'
    INVARIANT='invariant'
    REMARK='remark'
    ATTENTION='attention'
    PAR='par'
    RCS='rcs'


class DoxVirtualKind(Enum):
    NONVIRTUAL='non-virtual'
    VIRTUAL='virtual'
    PUREVIRTUAL='pure-virtual'


class DoxygenType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, version=None, compounddef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.version = _cast(None, version)
        self.version_nsprefix_ = None
        if compounddef is None:
            self.compounddef = []
        else:
            self.compounddef = compounddef
        self.compounddef_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DoxygenType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DoxygenType.subclass:
            return DoxygenType.subclass(*args_, **kwargs_)
        return DoxygenType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_compounddef(self):
        return self.compounddef
    def set_compounddef(self, compounddef):
        self.compounddef = compounddef
    def add_compounddef(self, value):
        self.compounddef.append(value)
    def insert_compounddef_at(self, index, value):
        self.compounddef.insert(index, value)
    def replace_compounddef_at(self, index, value):
        self.compounddef[index] = value
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def validate_DoxVersionNumber(self, value):
        # Validate type DoxVersionNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_DoxVersionNumber_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_DoxVersionNumber_patterns_, ))
    validate_DoxVersionNumber_patterns_ = [['^(\\d+\\.\\d+.*)$']]
    def hasContent_(self):
        if (
            self.compounddef
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DoxygenType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DoxygenType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DoxygenType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DoxygenType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DoxygenType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DoxygenType'):
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.version), input_name='version')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DoxygenType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for compounddef_ in self.compounddef:
            namespaceprefix_ = self.compounddef_nsprefix_ + ':' if (UseCapturedNS_ and self.compounddef_nsprefix_) else ''
            compounddef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='compounddef', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
            self.validate_DoxVersionNumber(self.version)    # validate type DoxVersionNumber
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'compounddef':
            obj_ = compounddefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.compounddef.append(obj_)
            obj_.original_tagname_ = 'compounddef'
# end class DoxygenType


class compounddefType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, kind=None, prot=None, final=None, sealed=None, abstract=None, compoundname=None, title=None, basecompoundref=None, derivedcompoundref=None, includes=None, includedby=None, incdepgraph=None, invincdepgraph=None, innerdir=None, innerfile=None, innerclass=None, innernamespace=None, innerpage=None, innergroup=None, templateparamlist=None, sectiondef=None, briefdescription=None, detaileddescription=None, inheritancegraph=None, collaborationgraph=None, programlisting=None, location=None, listofallmembers=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.kind = _cast(None, kind)
        self.kind_nsprefix_ = None
        self.prot = _cast(None, prot)
        self.prot_nsprefix_ = None
        self.final = _cast(None, final)
        self.final_nsprefix_ = None
        self.sealed = _cast(None, sealed)
        self.sealed_nsprefix_ = None
        self.abstract = _cast(None, abstract)
        self.abstract_nsprefix_ = None
        self.compoundname = compoundname
        self.compoundname_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if basecompoundref is None:
            self.basecompoundref = []
        else:
            self.basecompoundref = basecompoundref
        self.basecompoundref_nsprefix_ = None
        if derivedcompoundref is None:
            self.derivedcompoundref = []
        else:
            self.derivedcompoundref = derivedcompoundref
        self.derivedcompoundref_nsprefix_ = None
        if includes is None:
            self.includes = []
        else:
            self.includes = includes
        self.includes_nsprefix_ = None
        if includedby is None:
            self.includedby = []
        else:
            self.includedby = includedby
        self.includedby_nsprefix_ = None
        self.incdepgraph = incdepgraph
        self.incdepgraph_nsprefix_ = None
        self.invincdepgraph = invincdepgraph
        self.invincdepgraph_nsprefix_ = None
        if innerdir is None:
            self.innerdir = []
        else:
            self.innerdir = innerdir
        self.innerdir_nsprefix_ = None
        if innerfile is None:
            self.innerfile = []
        else:
            self.innerfile = innerfile
        self.innerfile_nsprefix_ = None
        if innerclass is None:
            self.innerclass = []
        else:
            self.innerclass = innerclass
        self.innerclass_nsprefix_ = None
        if innernamespace is None:
            self.innernamespace = []
        else:
            self.innernamespace = innernamespace
        self.innernamespace_nsprefix_ = None
        if innerpage is None:
            self.innerpage = []
        else:
            self.innerpage = innerpage
        self.innerpage_nsprefix_ = None
        if innergroup is None:
            self.innergroup = []
        else:
            self.innergroup = innergroup
        self.innergroup_nsprefix_ = None
        self.templateparamlist = templateparamlist
        self.templateparamlist_nsprefix_ = None
        if sectiondef is None:
            self.sectiondef = []
        else:
            self.sectiondef = sectiondef
        self.sectiondef_nsprefix_ = None
        self.briefdescription = briefdescription
        self.briefdescription_nsprefix_ = None
        self.detaileddescription = detaileddescription
        self.detaileddescription_nsprefix_ = None
        self.inheritancegraph = inheritancegraph
        self.inheritancegraph_nsprefix_ = None
        self.collaborationgraph = collaborationgraph
        self.collaborationgraph_nsprefix_ = None
        self.programlisting = programlisting
        self.programlisting_nsprefix_ = None
        self.location = location
        self.location_nsprefix_ = None
        self.listofallmembers = listofallmembers
        self.listofallmembers_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, compounddefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if compounddefType.subclass:
            return compounddefType.subclass(*args_, **kwargs_)
        return compounddefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_compoundname(self):
        return self.compoundname
    def set_compoundname(self, compoundname):
        self.compoundname = compoundname
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_basecompoundref(self):
        return self.basecompoundref
    def set_basecompoundref(self, basecompoundref):
        self.basecompoundref = basecompoundref
    def add_basecompoundref(self, value):
        self.basecompoundref.append(value)
    def insert_basecompoundref_at(self, index, value):
        self.basecompoundref.insert(index, value)
    def replace_basecompoundref_at(self, index, value):
        self.basecompoundref[index] = value
    def get_derivedcompoundref(self):
        return self.derivedcompoundref
    def set_derivedcompoundref(self, derivedcompoundref):
        self.derivedcompoundref = derivedcompoundref
    def add_derivedcompoundref(self, value):
        self.derivedcompoundref.append(value)
    def insert_derivedcompoundref_at(self, index, value):
        self.derivedcompoundref.insert(index, value)
    def replace_derivedcompoundref_at(self, index, value):
        self.derivedcompoundref[index] = value
    def get_includes(self):
        return self.includes
    def set_includes(self, includes):
        self.includes = includes
    def add_includes(self, value):
        self.includes.append(value)
    def insert_includes_at(self, index, value):
        self.includes.insert(index, value)
    def replace_includes_at(self, index, value):
        self.includes[index] = value
    def get_includedby(self):
        return self.includedby
    def set_includedby(self, includedby):
        self.includedby = includedby
    def add_includedby(self, value):
        self.includedby.append(value)
    def insert_includedby_at(self, index, value):
        self.includedby.insert(index, value)
    def replace_includedby_at(self, index, value):
        self.includedby[index] = value
    def get_incdepgraph(self):
        return self.incdepgraph
    def set_incdepgraph(self, incdepgraph):
        self.incdepgraph = incdepgraph
    def get_invincdepgraph(self):
        return self.invincdepgraph
    def set_invincdepgraph(self, invincdepgraph):
        self.invincdepgraph = invincdepgraph
    def get_innerdir(self):
        return self.innerdir
    def set_innerdir(self, innerdir):
        self.innerdir = innerdir
    def add_innerdir(self, value):
        self.innerdir.append(value)
    def insert_innerdir_at(self, index, value):
        self.innerdir.insert(index, value)
    def replace_innerdir_at(self, index, value):
        self.innerdir[index] = value
    def get_innerfile(self):
        return self.innerfile
    def set_innerfile(self, innerfile):
        self.innerfile = innerfile
    def add_innerfile(self, value):
        self.innerfile.append(value)
    def insert_innerfile_at(self, index, value):
        self.innerfile.insert(index, value)
    def replace_innerfile_at(self, index, value):
        self.innerfile[index] = value
    def get_innerclass(self):
        return self.innerclass
    def set_innerclass(self, innerclass):
        self.innerclass = innerclass
    def add_innerclass(self, value):
        self.innerclass.append(value)
    def insert_innerclass_at(self, index, value):
        self.innerclass.insert(index, value)
    def replace_innerclass_at(self, index, value):
        self.innerclass[index] = value
    def get_innernamespace(self):
        return self.innernamespace
    def set_innernamespace(self, innernamespace):
        self.innernamespace = innernamespace
    def add_innernamespace(self, value):
        self.innernamespace.append(value)
    def insert_innernamespace_at(self, index, value):
        self.innernamespace.insert(index, value)
    def replace_innernamespace_at(self, index, value):
        self.innernamespace[index] = value
    def get_innerpage(self):
        return self.innerpage
    def set_innerpage(self, innerpage):
        self.innerpage = innerpage
    def add_innerpage(self, value):
        self.innerpage.append(value)
    def insert_innerpage_at(self, index, value):
        self.innerpage.insert(index, value)
    def replace_innerpage_at(self, index, value):
        self.innerpage[index] = value
    def get_innergroup(self):
        return self.innergroup
    def set_innergroup(self, innergroup):
        self.innergroup = innergroup
    def add_innergroup(self, value):
        self.innergroup.append(value)
    def insert_innergroup_at(self, index, value):
        self.innergroup.insert(index, value)
    def replace_innergroup_at(self, index, value):
        self.innergroup[index] = value
    def get_templateparamlist(self):
        return self.templateparamlist
    def set_templateparamlist(self, templateparamlist):
        self.templateparamlist = templateparamlist
    def get_sectiondef(self):
        return self.sectiondef
    def set_sectiondef(self, sectiondef):
        self.sectiondef = sectiondef
    def add_sectiondef(self, value):
        self.sectiondef.append(value)
    def insert_sectiondef_at(self, index, value):
        self.sectiondef.insert(index, value)
    def replace_sectiondef_at(self, index, value):
        self.sectiondef[index] = value
    def get_briefdescription(self):
        return self.briefdescription
    def set_briefdescription(self, briefdescription):
        self.briefdescription = briefdescription
    def get_detaileddescription(self):
        return self.detaileddescription
    def set_detaileddescription(self, detaileddescription):
        self.detaileddescription = detaileddescription
    def get_inheritancegraph(self):
        return self.inheritancegraph
    def set_inheritancegraph(self, inheritancegraph):
        self.inheritancegraph = inheritancegraph
    def get_collaborationgraph(self):
        return self.collaborationgraph
    def set_collaborationgraph(self, collaborationgraph):
        self.collaborationgraph = collaborationgraph
    def get_programlisting(self):
        return self.programlisting
    def set_programlisting(self, programlisting):
        self.programlisting = programlisting
    def get_location(self):
        return self.location
    def set_location(self, location):
        self.location = location
    def get_listofallmembers(self):
        return self.listofallmembers
    def set_listofallmembers(self, listofallmembers):
        self.listofallmembers = listofallmembers
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_kind(self):
        return self.kind
    def set_kind(self, kind):
        self.kind = kind
    def get_prot(self):
        return self.prot
    def set_prot(self, prot):
        self.prot = prot
    def get_final(self):
        return self.final
    def set_final(self, final):
        self.final = final
    def get_sealed(self):
        return self.sealed
    def set_sealed(self, sealed):
        self.sealed = sealed
    def get_abstract(self):
        return self.abstract
    def set_abstract(self, abstract):
        self.abstract = abstract
    def validate_DoxCompoundKind(self, value):
        # Validate type DoxCompoundKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['class', 'struct', 'union', 'interface', 'protocol', 'category', 'exception', 'service', 'singleton', 'module', 'type', 'file', 'namespace', 'group', 'page', 'example', 'dir']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxCompoundKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_DoxProtectionKind(self, value):
        # Validate type DoxProtectionKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['public', 'protected', 'private', 'package']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxProtectionKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_DoxBool(self, value):
        # Validate type DoxBool, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['yes', 'no']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxBool' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.compoundname is not None or
            self.title is not None or
            self.basecompoundref or
            self.derivedcompoundref or
            self.includes or
            self.includedby or
            self.incdepgraph is not None or
            self.invincdepgraph is not None or
            self.innerdir or
            self.innerfile or
            self.innerclass or
            self.innernamespace or
            self.innerpage or
            self.innergroup or
            self.templateparamlist is not None or
            self.sectiondef or
            self.briefdescription is not None or
            self.detaileddescription is not None or
            self.inheritancegraph is not None or
            self.collaborationgraph is not None or
            self.programlisting is not None or
            self.location is not None or
            self.listofallmembers is not None
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='compounddefType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('compounddefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'compounddefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='compounddefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='compounddefType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='compounddefType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.kind is not None and 'kind' not in already_processed:
            already_processed.add('kind')
            outfile.write(' kind=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.kind), input_name='kind')), ))
        if self.prot is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            outfile.write(' prot=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.prot), input_name='prot')), ))
        if self.final is not None and 'final' not in already_processed:
            already_processed.add('final')
            outfile.write(' final=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.final), input_name='final')), ))
        if self.sealed is not None and 'sealed' not in already_processed:
            already_processed.add('sealed')
            outfile.write(' sealed=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.sealed), input_name='sealed')), ))
        if self.abstract is not None and 'abstract' not in already_processed:
            already_processed.add('abstract')
            outfile.write(' abstract=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.abstract), input_name='abstract')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='compounddefType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.compoundname is not None:
            namespaceprefix_ = self.compoundname_nsprefix_ + ':' if (UseCapturedNS_ and self.compoundname_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scompoundname>%s</%scompoundname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.compoundname), input_name='compoundname')), namespaceprefix_ , eol_))
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for basecompoundref_ in self.basecompoundref:
            namespaceprefix_ = self.basecompoundref_nsprefix_ + ':' if (UseCapturedNS_ and self.basecompoundref_nsprefix_) else ''
            basecompoundref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='basecompoundref', pretty_print=pretty_print)
        for derivedcompoundref_ in self.derivedcompoundref:
            namespaceprefix_ = self.derivedcompoundref_nsprefix_ + ':' if (UseCapturedNS_ and self.derivedcompoundref_nsprefix_) else ''
            derivedcompoundref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='derivedcompoundref', pretty_print=pretty_print)
        for includes_ in self.includes:
            namespaceprefix_ = self.includes_nsprefix_ + ':' if (UseCapturedNS_ and self.includes_nsprefix_) else ''
            includes_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='includes', pretty_print=pretty_print)
        for includedby_ in self.includedby:
            namespaceprefix_ = self.includedby_nsprefix_ + ':' if (UseCapturedNS_ and self.includedby_nsprefix_) else ''
            includedby_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='includedby', pretty_print=pretty_print)
        if self.incdepgraph is not None:
            namespaceprefix_ = self.incdepgraph_nsprefix_ + ':' if (UseCapturedNS_ and self.incdepgraph_nsprefix_) else ''
            self.incdepgraph.export(outfile, level, namespaceprefix_, namespacedef_='', name_='incdepgraph', pretty_print=pretty_print)
        if self.invincdepgraph is not None:
            namespaceprefix_ = self.invincdepgraph_nsprefix_ + ':' if (UseCapturedNS_ and self.invincdepgraph_nsprefix_) else ''
            self.invincdepgraph.export(outfile, level, namespaceprefix_, namespacedef_='', name_='invincdepgraph', pretty_print=pretty_print)
        for innerdir_ in self.innerdir:
            namespaceprefix_ = self.innerdir_nsprefix_ + ':' if (UseCapturedNS_ and self.innerdir_nsprefix_) else ''
            innerdir_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='innerdir', pretty_print=pretty_print)
        for innerfile_ in self.innerfile:
            namespaceprefix_ = self.innerfile_nsprefix_ + ':' if (UseCapturedNS_ and self.innerfile_nsprefix_) else ''
            innerfile_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='innerfile', pretty_print=pretty_print)
        for innerclass_ in self.innerclass:
            namespaceprefix_ = self.innerclass_nsprefix_ + ':' if (UseCapturedNS_ and self.innerclass_nsprefix_) else ''
            innerclass_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='innerclass', pretty_print=pretty_print)
        for innernamespace_ in self.innernamespace:
            namespaceprefix_ = self.innernamespace_nsprefix_ + ':' if (UseCapturedNS_ and self.innernamespace_nsprefix_) else ''
            innernamespace_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='innernamespace', pretty_print=pretty_print)
        for innerpage_ in self.innerpage:
            namespaceprefix_ = self.innerpage_nsprefix_ + ':' if (UseCapturedNS_ and self.innerpage_nsprefix_) else ''
            innerpage_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='innerpage', pretty_print=pretty_print)
        for innergroup_ in self.innergroup:
            namespaceprefix_ = self.innergroup_nsprefix_ + ':' if (UseCapturedNS_ and self.innergroup_nsprefix_) else ''
            innergroup_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='innergroup', pretty_print=pretty_print)
        if self.templateparamlist is not None:
            namespaceprefix_ = self.templateparamlist_nsprefix_ + ':' if (UseCapturedNS_ and self.templateparamlist_nsprefix_) else ''
            self.templateparamlist.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateparamlist', pretty_print=pretty_print)
        for sectiondef_ in self.sectiondef:
            namespaceprefix_ = self.sectiondef_nsprefix_ + ':' if (UseCapturedNS_ and self.sectiondef_nsprefix_) else ''
            sectiondef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sectiondef', pretty_print=pretty_print)
        if self.briefdescription is not None:
            namespaceprefix_ = self.briefdescription_nsprefix_ + ':' if (UseCapturedNS_ and self.briefdescription_nsprefix_) else ''
            self.briefdescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='briefdescription', pretty_print=pretty_print)
        if self.detaileddescription is not None:
            namespaceprefix_ = self.detaileddescription_nsprefix_ + ':' if (UseCapturedNS_ and self.detaileddescription_nsprefix_) else ''
            self.detaileddescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='detaileddescription', pretty_print=pretty_print)
        if self.inheritancegraph is not None:
            namespaceprefix_ = self.inheritancegraph_nsprefix_ + ':' if (UseCapturedNS_ and self.inheritancegraph_nsprefix_) else ''
            self.inheritancegraph.export(outfile, level, namespaceprefix_, namespacedef_='', name_='inheritancegraph', pretty_print=pretty_print)
        if self.collaborationgraph is not None:
            namespaceprefix_ = self.collaborationgraph_nsprefix_ + ':' if (UseCapturedNS_ and self.collaborationgraph_nsprefix_) else ''
            self.collaborationgraph.export(outfile, level, namespaceprefix_, namespacedef_='', name_='collaborationgraph', pretty_print=pretty_print)
        if self.programlisting is not None:
            namespaceprefix_ = self.programlisting_nsprefix_ + ':' if (UseCapturedNS_ and self.programlisting_nsprefix_) else ''
            self.programlisting.export(outfile, level, namespaceprefix_, namespacedef_='', name_='programlisting', pretty_print=pretty_print)
        if self.location is not None:
            namespaceprefix_ = self.location_nsprefix_ + ':' if (UseCapturedNS_ and self.location_nsprefix_) else ''
            self.location.export(outfile, level, namespaceprefix_, namespacedef_='', name_='location', pretty_print=pretty_print)
        if self.listofallmembers is not None:
            namespaceprefix_ = self.listofallmembers_nsprefix_ + ':' if (UseCapturedNS_ and self.listofallmembers_nsprefix_) else ''
            self.listofallmembers.export(outfile, level, namespaceprefix_, namespacedef_='', name_='listofallmembers', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('kind', node)
        if value is not None and 'kind' not in already_processed:
            already_processed.add('kind')
            self.kind = value
            self.validate_DoxCompoundKind(self.kind)    # validate type DoxCompoundKind
        value = find_attr_value_('prot', node)
        if value is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            self.prot = value
            self.validate_DoxProtectionKind(self.prot)    # validate type DoxProtectionKind
        value = find_attr_value_('final', node)
        if value is not None and 'final' not in already_processed:
            already_processed.add('final')
            self.final = value
            self.validate_DoxBool(self.final)    # validate type DoxBool
        value = find_attr_value_('sealed', node)
        if value is not None and 'sealed' not in already_processed:
            already_processed.add('sealed')
            self.sealed = value
            self.validate_DoxBool(self.sealed)    # validate type DoxBool
        value = find_attr_value_('abstract', node)
        if value is not None and 'abstract' not in already_processed:
            already_processed.add('abstract')
            self.abstract = value
            self.validate_DoxBool(self.abstract)    # validate type DoxBool
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'compoundname':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'compoundname')
            value_ = self.gds_validate_string(value_, node, 'compoundname')
            self.compoundname = value_
            self.compoundname_nsprefix_ = child_.prefix
        elif nodeName_ == 'title':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'title')
            value_ = self.gds_validate_string(value_, node, 'title')
            self.title = value_
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'basecompoundref':
            obj_ = compoundRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.basecompoundref.append(obj_)
            obj_.original_tagname_ = 'basecompoundref'
        elif nodeName_ == 'derivedcompoundref':
            obj_ = compoundRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.derivedcompoundref.append(obj_)
            obj_.original_tagname_ = 'derivedcompoundref'
        elif nodeName_ == 'includes':
            obj_ = incType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.includes.append(obj_)
            obj_.original_tagname_ = 'includes'
        elif nodeName_ == 'includedby':
            obj_ = incType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.includedby.append(obj_)
            obj_.original_tagname_ = 'includedby'
        elif nodeName_ == 'incdepgraph':
            obj_ = graphType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.incdepgraph = obj_
            obj_.original_tagname_ = 'incdepgraph'
        elif nodeName_ == 'invincdepgraph':
            obj_ = graphType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.invincdepgraph = obj_
            obj_.original_tagname_ = 'invincdepgraph'
        elif nodeName_ == 'innerdir':
            obj_ = refType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.innerdir.append(obj_)
            obj_.original_tagname_ = 'innerdir'
        elif nodeName_ == 'innerfile':
            obj_ = refType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.innerfile.append(obj_)
            obj_.original_tagname_ = 'innerfile'
        elif nodeName_ == 'innerclass':
            obj_ = refType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.innerclass.append(obj_)
            obj_.original_tagname_ = 'innerclass'
        elif nodeName_ == 'innernamespace':
            obj_ = refType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.innernamespace.append(obj_)
            obj_.original_tagname_ = 'innernamespace'
        elif nodeName_ == 'innerpage':
            obj_ = refType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.innerpage.append(obj_)
            obj_.original_tagname_ = 'innerpage'
        elif nodeName_ == 'innergroup':
            obj_ = refType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.innergroup.append(obj_)
            obj_.original_tagname_ = 'innergroup'
        elif nodeName_ == 'templateparamlist':
            obj_ = templateparamlistType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateparamlist = obj_
            obj_.original_tagname_ = 'templateparamlist'
        elif nodeName_ == 'sectiondef':
            obj_ = sectiondefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sectiondef.append(obj_)
            obj_.original_tagname_ = 'sectiondef'
        elif nodeName_ == 'briefdescription':
            obj_ = descriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.briefdescription = obj_
            obj_.original_tagname_ = 'briefdescription'
        elif nodeName_ == 'detaileddescription':
            obj_ = descriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.detaileddescription = obj_
            obj_.original_tagname_ = 'detaileddescription'
        elif nodeName_ == 'inheritancegraph':
            obj_ = graphType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inheritancegraph = obj_
            obj_.original_tagname_ = 'inheritancegraph'
        elif nodeName_ == 'collaborationgraph':
            obj_ = graphType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.collaborationgraph = obj_
            obj_.original_tagname_ = 'collaborationgraph'
        elif nodeName_ == 'programlisting':
            obj_ = listingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.programlisting = obj_
            obj_.original_tagname_ = 'programlisting'
        elif nodeName_ == 'location':
            obj_ = locationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.location = obj_
            obj_.original_tagname_ = 'location'
        elif nodeName_ == 'listofallmembers':
            obj_ = listofallmembersType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.listofallmembers = obj_
            obj_.original_tagname_ = 'listofallmembers'
# end class compounddefType


class listofallmembersType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, member=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if member is None:
            self.member = []
        else:
            self.member = member
        self.member_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, listofallmembersType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if listofallmembersType.subclass:
            return listofallmembersType.subclass(*args_, **kwargs_)
        return listofallmembersType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_member(self):
        return self.member
    def set_member(self, member):
        self.member = member
    def add_member(self, value):
        self.member.append(value)
    def insert_member_at(self, index, value):
        self.member.insert(index, value)
    def replace_member_at(self, index, value):
        self.member[index] = value
    def hasContent_(self):
        if (
            self.member
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='listofallmembersType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('listofallmembersType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'listofallmembersType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='listofallmembersType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='listofallmembersType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='listofallmembersType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='listofallmembersType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for member_ in self.member:
            namespaceprefix_ = self.member_nsprefix_ + ':' if (UseCapturedNS_ and self.member_nsprefix_) else ''
            member_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='member', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'member':
            obj_ = memberRefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.member.append(obj_)
            obj_.original_tagname_ = 'member'
# end class listofallmembersType


class memberRefType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, refid=None, prot=None, virt=None, ambiguityscope=None, scope=None, name=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.prot = _cast(None, prot)
        self.prot_nsprefix_ = None
        self.virt = _cast(None, virt)
        self.virt_nsprefix_ = None
        self.ambiguityscope = _cast(None, ambiguityscope)
        self.ambiguityscope_nsprefix_ = None
        self.scope = scope
        self.scope_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, memberRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if memberRefType.subclass:
            return memberRefType.subclass(*args_, **kwargs_)
        return memberRefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_scope(self):
        return self.scope
    def set_scope(self, scope):
        self.scope = scope
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_prot(self):
        return self.prot
    def set_prot(self, prot):
        self.prot = prot
    def get_virt(self):
        return self.virt
    def set_virt(self, virt):
        self.virt = virt
    def get_ambiguityscope(self):
        return self.ambiguityscope
    def set_ambiguityscope(self, ambiguityscope):
        self.ambiguityscope = ambiguityscope
    def validate_DoxProtectionKind(self, value):
        # Validate type DoxProtectionKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['public', 'protected', 'private', 'package']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxProtectionKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_DoxVirtualKind(self, value):
        # Validate type DoxVirtualKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['non-virtual', 'virtual', 'pure-virtual']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxVirtualKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.scope is not None or
            self.name is not None
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='memberRefType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('memberRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'memberRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='memberRefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='memberRefType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='memberRefType'):
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
        if self.prot is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            outfile.write(' prot=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.prot), input_name='prot')), ))
        if self.virt is not None and 'virt' not in already_processed:
            already_processed.add('virt')
            outfile.write(' virt=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.virt), input_name='virt')), ))
        if self.ambiguityscope is not None and 'ambiguityscope' not in already_processed:
            already_processed.add('ambiguityscope')
            outfile.write(' ambiguityscope=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.ambiguityscope), input_name='ambiguityscope')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='memberRefType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.scope is not None:
            namespaceprefix_ = self.scope_nsprefix_ + ':' if (UseCapturedNS_ and self.scope_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sscope>%s</%sscope>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.scope), input_name='scope')), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
        value = find_attr_value_('prot', node)
        if value is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            self.prot = value
            self.validate_DoxProtectionKind(self.prot)    # validate type DoxProtectionKind
        value = find_attr_value_('virt', node)
        if value is not None and 'virt' not in already_processed:
            already_processed.add('virt')
            self.virt = value
            self.validate_DoxVirtualKind(self.virt)    # validate type DoxVirtualKind
        value = find_attr_value_('ambiguityscope', node)
        if value is not None and 'ambiguityscope' not in already_processed:
            already_processed.add('ambiguityscope')
            self.ambiguityscope = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'scope':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'scope')
            value_ = self.gds_validate_string(value_, node, 'scope')
            self.scope = value_
            self.scope_nsprefix_ = child_.prefix
        elif nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
# end class memberRefType


class scope(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, scope)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if scope.subclass:
            return scope.subclass(*args_, **kwargs_)
        return scope(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='scope', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('scope')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'scope':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='scope')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='scope', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='scope'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='scope', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class scope


class name(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, name)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if name.subclass:
            return name.subclass(*args_, **kwargs_)
        return name(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='name', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('name')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'name':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='name')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='name', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='name'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='name', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class name


class compoundRefType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, refid=None, prot=None, virt=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.prot = _cast(None, prot)
        self.prot_nsprefix_ = None
        self.virt = _cast(None, virt)
        self.virt_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, compoundRefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if compoundRefType.subclass:
            return compoundRefType.subclass(*args_, **kwargs_)
        return compoundRefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_prot(self):
        return self.prot
    def set_prot(self, prot):
        self.prot = prot
    def get_virt(self):
        return self.virt
    def set_virt(self, virt):
        self.virt = virt
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_DoxProtectionKind(self, value):
        # Validate type DoxProtectionKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['public', 'protected', 'private', 'package']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxProtectionKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_DoxVirtualKind(self, value):
        # Validate type DoxVirtualKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['non-virtual', 'virtual', 'pure-virtual']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxVirtualKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='compoundRefType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('compoundRefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'compoundRefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='compoundRefType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='compoundRefType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='compoundRefType'):
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
        if self.prot is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            outfile.write(' prot=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.prot), input_name='prot')), ))
        if self.virt is not None and 'virt' not in already_processed:
            already_processed.add('virt')
            outfile.write(' virt=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.virt), input_name='virt')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='compoundRefType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
        value = find_attr_value_('prot', node)
        if value is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            self.prot = value
            self.validate_DoxProtectionKind(self.prot)    # validate type DoxProtectionKind
        value = find_attr_value_('virt', node)
        if value is not None and 'virt' not in already_processed:
            already_processed.add('virt')
            self.virt = value
            self.validate_DoxVirtualKind(self.virt)    # validate type DoxVirtualKind
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class compoundRefType


class reimplementType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, refid=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, reimplementType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if reimplementType.subclass:
            return reimplementType.subclass(*args_, **kwargs_)
        return reimplementType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='reimplementType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('reimplementType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'reimplementType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='reimplementType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='reimplementType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='reimplementType'):
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='reimplementType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class reimplementType


class incType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, refid=None, local=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.local = _cast(None, local)
        self.local_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, incType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if incType.subclass:
            return incType.subclass(*args_, **kwargs_)
        return incType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_local(self):
        return self.local
    def set_local(self, local):
        self.local = local
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_DoxBool(self, value):
        # Validate type DoxBool, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['yes', 'no']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxBool' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='incType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('incType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'incType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='incType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='incType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='incType'):
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
        if self.local is not None and 'local' not in already_processed:
            already_processed.add('local')
            outfile.write(' local=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.local), input_name='local')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='incType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
        value = find_attr_value_('local', node)
        if value is not None and 'local' not in already_processed:
            already_processed.add('local')
            self.local = value
            self.validate_DoxBool(self.local)    # validate type DoxBool
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class incType


class refType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, refid=None, prot=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.prot = _cast(None, prot)
        self.prot_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, refType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refType.subclass:
            return refType.subclass(*args_, **kwargs_)
        return refType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_prot(self):
        return self.prot
    def set_prot(self, prot):
        self.prot = prot
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_DoxProtectionKind(self, value):
        # Validate type DoxProtectionKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['public', 'protected', 'private', 'package']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxProtectionKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('refType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'refType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='refType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='refType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='refType'):
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
        if self.prot is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            outfile.write(' prot=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.prot), input_name='prot')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
        value = find_attr_value_('prot', node)
        if value is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            self.prot = value
            self.validate_DoxProtectionKind(self.prot)    # validate type DoxProtectionKind
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class refType


class refTextType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, refid=None, kindref=None, external=None, tooltip=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.kindref = _cast(None, kindref)
        self.kindref_nsprefix_ = None
        self.external = _cast(None, external)
        self.external_nsprefix_ = None
        self.tooltip = _cast(None, tooltip)
        self.tooltip_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, refTextType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if refTextType.subclass:
            return refTextType.subclass(*args_, **kwargs_)
        return refTextType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_kindref(self):
        return self.kindref
    def set_kindref(self, kindref):
        self.kindref = kindref
    def get_external(self):
        return self.external
    def set_external(self, external):
        self.external = external
    def get_tooltip(self):
        return self.tooltip
    def set_tooltip(self, tooltip):
        self.tooltip = tooltip
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_DoxRefKind(self, value):
        # Validate type DoxRefKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['compound', 'member']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxRefKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refTextType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('refTextType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'refTextType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='refTextType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='refTextType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='refTextType'):
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
        if self.kindref is not None and 'kindref' not in already_processed:
            already_processed.add('kindref')
            outfile.write(' kindref=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.kindref), input_name='kindref')), ))
        if self.external is not None and 'external' not in already_processed:
            already_processed.add('external')
            outfile.write(' external=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.external), input_name='external')), ))
        if self.tooltip is not None and 'tooltip' not in already_processed:
            already_processed.add('tooltip')
            outfile.write(' tooltip=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.tooltip), input_name='tooltip')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='refTextType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
        value = find_attr_value_('kindref', node)
        if value is not None and 'kindref' not in already_processed:
            already_processed.add('kindref')
            self.kindref = value
            self.validate_DoxRefKind(self.kindref)    # validate type DoxRefKind
        value = find_attr_value_('external', node)
        if value is not None and 'external' not in already_processed:
            already_processed.add('external')
            self.external = value
        value = find_attr_value_('tooltip', node)
        if value is not None and 'tooltip' not in already_processed:
            already_processed.add('tooltip')
            self.tooltip = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class refTextType


class sectiondefType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, kind=None, header=None, description=None, memberdef=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.kind = _cast(None, kind)
        self.kind_nsprefix_ = None
        self.header = header
        self.header_nsprefix_ = None
        self.description = description
        self.description_nsprefix_ = None
        if memberdef is None:
            self.memberdef = []
        else:
            self.memberdef = memberdef
        self.memberdef_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sectiondefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sectiondefType.subclass:
            return sectiondefType.subclass(*args_, **kwargs_)
        return sectiondefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_header(self):
        return self.header
    def set_header(self, header):
        self.header = header
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_memberdef(self):
        return self.memberdef
    def set_memberdef(self, memberdef):
        self.memberdef = memberdef
    def add_memberdef(self, value):
        self.memberdef.append(value)
    def insert_memberdef_at(self, index, value):
        self.memberdef.insert(index, value)
    def replace_memberdef_at(self, index, value):
        self.memberdef[index] = value
    def get_kind(self):
        return self.kind
    def set_kind(self, kind):
        self.kind = kind
    def validate_DoxSectionKind(self, value):
        # Validate type DoxSectionKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['user-defined', 'public-type', 'public-func', 'public-attrib', 'public-slot', 'signal', 'dcop-func', 'property', 'event', 'public-static-func', 'public-static-attrib', 'protected-type', 'protected-func', 'protected-attrib', 'protected-slot', 'protected-static-func', 'protected-static-attrib', 'package-type', 'package-func', 'package-attrib', 'package-static-func', 'package-static-attrib', 'private-type', 'private-func', 'private-attrib', 'private-slot', 'private-static-func', 'private-static-attrib', 'friend', 'related', 'define', 'prototype', 'typedef', 'enum', 'func', 'var']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxSectionKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.header is not None or
            self.description is not None or
            self.memberdef
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sectiondefType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sectiondefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'sectiondefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='sectiondefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='sectiondefType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='sectiondefType'):
        if self.kind is not None and 'kind' not in already_processed:
            already_processed.add('kind')
            outfile.write(' kind=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.kind), input_name='kind')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sectiondefType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.header is not None:
            namespaceprefix_ = self.header_nsprefix_ + ':' if (UseCapturedNS_ and self.header_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sheader>%s</%sheader>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.header), input_name='header')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            self.description.export(outfile, level, namespaceprefix_, namespacedef_='', name_='description', pretty_print=pretty_print)
        for memberdef_ in self.memberdef:
            namespaceprefix_ = self.memberdef_nsprefix_ + ':' if (UseCapturedNS_ and self.memberdef_nsprefix_) else ''
            memberdef_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='memberdef', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('kind', node)
        if value is not None and 'kind' not in already_processed:
            already_processed.add('kind')
            self.kind = value
            self.validate_DoxSectionKind(self.kind)    # validate type DoxSectionKind
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'header':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'header')
            value_ = self.gds_validate_string(value_, node, 'header')
            self.header = value_
            self.header_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            obj_ = descriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.description = obj_
            obj_.original_tagname_ = 'description'
        elif nodeName_ == 'memberdef':
            obj_ = memberdefType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.memberdef.append(obj_)
            obj_.original_tagname_ = 'memberdef'
# end class sectiondefType


class memberdefType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, kind=None, id=None, prot=None, static=None, const=None, explicit=None, inline=None, virt=None, volatile=None, mutable=None, readable=None, writable=None, initonly=None, settable=None, gettable=None, final=None, sealed=None, new=None, add=None, remove=None, raise_=None, optional=None, required=None, accessor=None, attribute=None, property=None, readonly=None, bound=None, removable=None, contrained=None, transient=None, maybevoid=None, maybedefault=None, maybeambiguous=None, templateparamlist=None, type_=None, definition=None, argsstring=None, name=None, read=None, write=None, bitfield=None, reimplements=None, reimplementedby=None, param=None, enumvalue=None, initializer=None, exceptions=None, briefdescription=None, detaileddescription=None, inbodydescription=None, location=None, references=None, referencedby=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.kind = _cast(None, kind)
        self.kind_nsprefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.prot = _cast(None, prot)
        self.prot_nsprefix_ = None
        self.static = _cast(None, static)
        self.static_nsprefix_ = None
        self.const = _cast(None, const)
        self.const_nsprefix_ = None
        self.explicit = _cast(None, explicit)
        self.explicit_nsprefix_ = None
        self.inline = _cast(None, inline)
        self.inline_nsprefix_ = None
        self.virt = _cast(None, virt)
        self.virt_nsprefix_ = None
        self.volatile = _cast(None, volatile)
        self.volatile_nsprefix_ = None
        self.mutable = _cast(None, mutable)
        self.mutable_nsprefix_ = None
        self.readable = _cast(None, readable)
        self.readable_nsprefix_ = None
        self.writable = _cast(None, writable)
        self.writable_nsprefix_ = None
        self.initonly = _cast(None, initonly)
        self.initonly_nsprefix_ = None
        self.settable = _cast(None, settable)
        self.settable_nsprefix_ = None
        self.gettable = _cast(None, gettable)
        self.gettable_nsprefix_ = None
        self.final = _cast(None, final)
        self.final_nsprefix_ = None
        self.sealed = _cast(None, sealed)
        self.sealed_nsprefix_ = None
        self.new = _cast(None, new)
        self.new_nsprefix_ = None
        self.add = _cast(None, add)
        self.add_nsprefix_ = None
        self.remove = _cast(None, remove)
        self.remove_nsprefix_ = None
        self.raise_ = _cast(None, raise_)
        self.raise__nsprefix_ = None
        self.optional = _cast(None, optional)
        self.optional_nsprefix_ = None
        self.required = _cast(None, required)
        self.required_nsprefix_ = None
        self.accessor = _cast(None, accessor)
        self.accessor_nsprefix_ = None
        self.attribute = _cast(None, attribute)
        self.attribute_nsprefix_ = None
        self.property = _cast(None, property)
        self.property_nsprefix_ = None
        self.readonly = _cast(None, readonly)
        self.readonly_nsprefix_ = None
        self.bound = _cast(None, bound)
        self.bound_nsprefix_ = None
        self.removable = _cast(None, removable)
        self.removable_nsprefix_ = None
        self.contrained = _cast(None, contrained)
        self.contrained_nsprefix_ = None
        self.transient = _cast(None, transient)
        self.transient_nsprefix_ = None
        self.maybevoid = _cast(None, maybevoid)
        self.maybevoid_nsprefix_ = None
        self.maybedefault = _cast(None, maybedefault)
        self.maybedefault_nsprefix_ = None
        self.maybeambiguous = _cast(None, maybeambiguous)
        self.maybeambiguous_nsprefix_ = None
        self.templateparamlist = templateparamlist
        self.templateparamlist_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.definition = definition
        self.definition_nsprefix_ = None
        self.argsstring = argsstring
        self.argsstring_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.read = read
        self.read_nsprefix_ = None
        self.write = write
        self.write_nsprefix_ = None
        self.bitfield = bitfield
        self.bitfield_nsprefix_ = None
        if reimplements is None:
            self.reimplements = []
        else:
            self.reimplements = reimplements
        self.reimplements_nsprefix_ = None
        if reimplementedby is None:
            self.reimplementedby = []
        else:
            self.reimplementedby = reimplementedby
        self.reimplementedby_nsprefix_ = None
        if param is None:
            self.param = []
        else:
            self.param = param
        self.param_nsprefix_ = None
        if enumvalue is None:
            self.enumvalue = []
        else:
            self.enumvalue = enumvalue
        self.enumvalue_nsprefix_ = None
        self.initializer = initializer
        self.initializer_nsprefix_ = None
        self.exceptions = exceptions
        self.exceptions_nsprefix_ = None
        self.briefdescription = briefdescription
        self.briefdescription_nsprefix_ = None
        self.detaileddescription = detaileddescription
        self.detaileddescription_nsprefix_ = None
        self.inbodydescription = inbodydescription
        self.inbodydescription_nsprefix_ = None
        self.location = location
        self.location_nsprefix_ = None
        if references is None:
            self.references = []
        else:
            self.references = references
        self.references_nsprefix_ = None
        if referencedby is None:
            self.referencedby = []
        else:
            self.referencedby = referencedby
        self.referencedby_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, memberdefType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if memberdefType.subclass:
            return memberdefType.subclass(*args_, **kwargs_)
        return memberdefType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_templateparamlist(self):
        return self.templateparamlist
    def set_templateparamlist(self, templateparamlist):
        self.templateparamlist = templateparamlist
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_definition(self):
        return self.definition
    def set_definition(self, definition):
        self.definition = definition
    def get_argsstring(self):
        return self.argsstring
    def set_argsstring(self, argsstring):
        self.argsstring = argsstring
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_read(self):
        return self.read
    def set_read(self, read):
        self.read = read
    def get_write(self):
        return self.write
    def set_write(self, write):
        self.write = write
    def get_bitfield(self):
        return self.bitfield
    def set_bitfield(self, bitfield):
        self.bitfield = bitfield
    def get_reimplements(self):
        return self.reimplements
    def set_reimplements(self, reimplements):
        self.reimplements = reimplements
    def add_reimplements(self, value):
        self.reimplements.append(value)
    def insert_reimplements_at(self, index, value):
        self.reimplements.insert(index, value)
    def replace_reimplements_at(self, index, value):
        self.reimplements[index] = value
    def get_reimplementedby(self):
        return self.reimplementedby
    def set_reimplementedby(self, reimplementedby):
        self.reimplementedby = reimplementedby
    def add_reimplementedby(self, value):
        self.reimplementedby.append(value)
    def insert_reimplementedby_at(self, index, value):
        self.reimplementedby.insert(index, value)
    def replace_reimplementedby_at(self, index, value):
        self.reimplementedby[index] = value
    def get_param(self):
        return self.param
    def set_param(self, param):
        self.param = param
    def add_param(self, value):
        self.param.append(value)
    def insert_param_at(self, index, value):
        self.param.insert(index, value)
    def replace_param_at(self, index, value):
        self.param[index] = value
    def get_enumvalue(self):
        return self.enumvalue
    def set_enumvalue(self, enumvalue):
        self.enumvalue = enumvalue
    def add_enumvalue(self, value):
        self.enumvalue.append(value)
    def insert_enumvalue_at(self, index, value):
        self.enumvalue.insert(index, value)
    def replace_enumvalue_at(self, index, value):
        self.enumvalue[index] = value
    def get_initializer(self):
        return self.initializer
    def set_initializer(self, initializer):
        self.initializer = initializer
    def get_exceptions(self):
        return self.exceptions
    def set_exceptions(self, exceptions):
        self.exceptions = exceptions
    def get_briefdescription(self):
        return self.briefdescription
    def set_briefdescription(self, briefdescription):
        self.briefdescription = briefdescription
    def get_detaileddescription(self):
        return self.detaileddescription
    def set_detaileddescription(self, detaileddescription):
        self.detaileddescription = detaileddescription
    def get_inbodydescription(self):
        return self.inbodydescription
    def set_inbodydescription(self, inbodydescription):
        self.inbodydescription = inbodydescription
    def get_location(self):
        return self.location
    def set_location(self, location):
        self.location = location
    def get_references(self):
        return self.references
    def set_references(self, references):
        self.references = references
    def add_references(self, value):
        self.references.append(value)
    def insert_references_at(self, index, value):
        self.references.insert(index, value)
    def replace_references_at(self, index, value):
        self.references[index] = value
    def get_referencedby(self):
        return self.referencedby
    def set_referencedby(self, referencedby):
        self.referencedby = referencedby
    def add_referencedby(self, value):
        self.referencedby.append(value)
    def insert_referencedby_at(self, index, value):
        self.referencedby.insert(index, value)
    def replace_referencedby_at(self, index, value):
        self.referencedby[index] = value
    def get_kind(self):
        return self.kind
    def set_kind(self, kind):
        self.kind = kind
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_prot(self):
        return self.prot
    def set_prot(self, prot):
        self.prot = prot
    def get_static(self):
        return self.static
    def set_static(self, static):
        self.static = static
    def get_const(self):
        return self.const
    def set_const(self, const):
        self.const = const
    def get_explicit(self):
        return self.explicit
    def set_explicit(self, explicit):
        self.explicit = explicit
    def get_inline(self):
        return self.inline
    def set_inline(self, inline):
        self.inline = inline
    def get_virt(self):
        return self.virt
    def set_virt(self, virt):
        self.virt = virt
    def get_volatile(self):
        return self.volatile
    def set_volatile(self, volatile):
        self.volatile = volatile
    def get_mutable(self):
        return self.mutable
    def set_mutable(self, mutable):
        self.mutable = mutable
    def get_readable(self):
        return self.readable
    def set_readable(self, readable):
        self.readable = readable
    def get_writable(self):
        return self.writable
    def set_writable(self, writable):
        self.writable = writable
    def get_initonly(self):
        return self.initonly
    def set_initonly(self, initonly):
        self.initonly = initonly
    def get_settable(self):
        return self.settable
    def set_settable(self, settable):
        self.settable = settable
    def get_gettable(self):
        return self.gettable
    def set_gettable(self, gettable):
        self.gettable = gettable
    def get_final(self):
        return self.final
    def set_final(self, final):
        self.final = final
    def get_sealed(self):
        return self.sealed
    def set_sealed(self, sealed):
        self.sealed = sealed
    def get_new(self):
        return self.new
    def set_new(self, new):
        self.new = new
    def get_add(self):
        return self.add
    def set_add(self, add):
        self.add = add
    def get_remove(self):
        return self.remove
    def set_remove(self, remove):
        self.remove = remove
    def get_raise(self):
        return self.raise_
    def set_raise(self, raise_):
        self.raise_ = raise_
    def get_optional(self):
        return self.optional
    def set_optional(self, optional):
        self.optional = optional
    def get_required(self):
        return self.required
    def set_required(self, required):
        self.required = required
    def get_accessor(self):
        return self.accessor
    def set_accessor(self, accessor):
        self.accessor = accessor
    def get_attribute(self):
        return self.attribute
    def set_attribute(self, attribute):
        self.attribute = attribute
    def get_property(self):
        return self.property
    def set_property(self, property):
        self.property = property
    def get_readonly(self):
        return self.readonly
    def set_readonly(self, readonly):
        self.readonly = readonly
    def get_bound(self):
        return self.bound
    def set_bound(self, bound):
        self.bound = bound
    def get_removable(self):
        return self.removable
    def set_removable(self, removable):
        self.removable = removable
    def get_contrained(self):
        return self.contrained
    def set_contrained(self, contrained):
        self.contrained = contrained
    def get_transient(self):
        return self.transient
    def set_transient(self, transient):
        self.transient = transient
    def get_maybevoid(self):
        return self.maybevoid
    def set_maybevoid(self, maybevoid):
        self.maybevoid = maybevoid
    def get_maybedefault(self):
        return self.maybedefault
    def set_maybedefault(self, maybedefault):
        self.maybedefault = maybedefault
    def get_maybeambiguous(self):
        return self.maybeambiguous
    def set_maybeambiguous(self, maybeambiguous):
        self.maybeambiguous = maybeambiguous
    def validate_DoxMemberKind(self, value):
        # Validate type DoxMemberKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['define', 'property', 'event', 'variable', 'typedef', 'enum', 'function', 'signal', 'prototype', 'friend', 'dcop', 'slot', 'interface', 'service']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxMemberKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_DoxProtectionKind(self, value):
        # Validate type DoxProtectionKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['public', 'protected', 'private', 'package']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxProtectionKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_DoxBool(self, value):
        # Validate type DoxBool, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['yes', 'no']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxBool' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_DoxVirtualKind(self, value):
        # Validate type DoxVirtualKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['non-virtual', 'virtual', 'pure-virtual']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxVirtualKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_DoxAccessor(self, value):
        # Validate type DoxAccessor, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['retain', 'copy', 'assign', 'weak', 'strong', 'unretained']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxAccessor' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.templateparamlist is not None or
            self.type_ is not None or
            self.definition is not None or
            self.argsstring is not None or
            self.name is not None or
            self.read is not None or
            self.write is not None or
            self.bitfield is not None or
            self.reimplements or
            self.reimplementedby or
            self.param or
            self.enumvalue or
            self.initializer is not None or
            self.exceptions is not None or
            self.briefdescription is not None or
            self.detaileddescription is not None or
            self.inbodydescription is not None or
            self.location is not None or
            self.references or
            self.referencedby
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='memberdefType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('memberdefType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'memberdefType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='memberdefType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='memberdefType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='memberdefType'):
        if self.kind is not None and 'kind' not in already_processed:
            already_processed.add('kind')
            outfile.write(' kind=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.kind), input_name='kind')), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.prot is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            outfile.write(' prot=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.prot), input_name='prot')), ))
        if self.static is not None and 'static' not in already_processed:
            already_processed.add('static')
            outfile.write(' static=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.static), input_name='static')), ))
        if self.const is not None and 'const' not in already_processed:
            already_processed.add('const')
            outfile.write(' const=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.const), input_name='const')), ))
        if self.explicit is not None and 'explicit' not in already_processed:
            already_processed.add('explicit')
            outfile.write(' explicit=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.explicit), input_name='explicit')), ))
        if self.inline is not None and 'inline' not in already_processed:
            already_processed.add('inline')
            outfile.write(' inline=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.inline), input_name='inline')), ))
        if self.virt is not None and 'virt' not in already_processed:
            already_processed.add('virt')
            outfile.write(' virt=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.virt), input_name='virt')), ))
        if self.volatile is not None and 'volatile' not in already_processed:
            already_processed.add('volatile')
            outfile.write(' volatile=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.volatile), input_name='volatile')), ))
        if self.mutable is not None and 'mutable' not in already_processed:
            already_processed.add('mutable')
            outfile.write(' mutable=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.mutable), input_name='mutable')), ))
        if self.readable is not None and 'readable' not in already_processed:
            already_processed.add('readable')
            outfile.write(' readable=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.readable), input_name='readable')), ))
        if self.writable is not None and 'writable' not in already_processed:
            already_processed.add('writable')
            outfile.write(' writable=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.writable), input_name='writable')), ))
        if self.initonly is not None and 'initonly' not in already_processed:
            already_processed.add('initonly')
            outfile.write(' initonly=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.initonly), input_name='initonly')), ))
        if self.settable is not None and 'settable' not in already_processed:
            already_processed.add('settable')
            outfile.write(' settable=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.settable), input_name='settable')), ))
        if self.gettable is not None and 'gettable' not in already_processed:
            already_processed.add('gettable')
            outfile.write(' gettable=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.gettable), input_name='gettable')), ))
        if self.final is not None and 'final' not in already_processed:
            already_processed.add('final')
            outfile.write(' final=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.final), input_name='final')), ))
        if self.sealed is not None and 'sealed' not in already_processed:
            already_processed.add('sealed')
            outfile.write(' sealed=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.sealed), input_name='sealed')), ))
        if self.new is not None and 'new' not in already_processed:
            already_processed.add('new')
            outfile.write(' new=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.new), input_name='new')), ))
        if self.add is not None and 'add' not in already_processed:
            already_processed.add('add')
            outfile.write(' add=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.add), input_name='add')), ))
        if self.remove is not None and 'remove' not in already_processed:
            already_processed.add('remove')
            outfile.write(' remove=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.remove), input_name='remove')), ))
        if self.raise_ is not None and 'raise_' not in already_processed:
            already_processed.add('raise_')
            outfile.write(' raise=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.raise_), input_name='raise')), ))
        if self.optional is not None and 'optional' not in already_processed:
            already_processed.add('optional')
            outfile.write(' optional=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.optional), input_name='optional')), ))
        if self.required is not None and 'required' not in already_processed:
            already_processed.add('required')
            outfile.write(' required=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.required), input_name='required')), ))
        if self.accessor is not None and 'accessor' not in already_processed:
            already_processed.add('accessor')
            outfile.write(' accessor=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.accessor), input_name='accessor')), ))
        if self.attribute is not None and 'attribute' not in already_processed:
            already_processed.add('attribute')
            outfile.write(' attribute=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.attribute), input_name='attribute')), ))
        if self.property is not None and 'property' not in already_processed:
            already_processed.add('property')
            outfile.write(' property=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.property), input_name='property')), ))
        if self.readonly is not None and 'readonly' not in already_processed:
            already_processed.add('readonly')
            outfile.write(' readonly=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.readonly), input_name='readonly')), ))
        if self.bound is not None and 'bound' not in already_processed:
            already_processed.add('bound')
            outfile.write(' bound=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.bound), input_name='bound')), ))
        if self.removable is not None and 'removable' not in already_processed:
            already_processed.add('removable')
            outfile.write(' removable=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.removable), input_name='removable')), ))
        if self.contrained is not None and 'contrained' not in already_processed:
            already_processed.add('contrained')
            outfile.write(' contrained=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.contrained), input_name='contrained')), ))
        if self.transient is not None and 'transient' not in already_processed:
            already_processed.add('transient')
            outfile.write(' transient=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.transient), input_name='transient')), ))
        if self.maybevoid is not None and 'maybevoid' not in already_processed:
            already_processed.add('maybevoid')
            outfile.write(' maybevoid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.maybevoid), input_name='maybevoid')), ))
        if self.maybedefault is not None and 'maybedefault' not in already_processed:
            already_processed.add('maybedefault')
            outfile.write(' maybedefault=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.maybedefault), input_name='maybedefault')), ))
        if self.maybeambiguous is not None and 'maybeambiguous' not in already_processed:
            already_processed.add('maybeambiguous')
            outfile.write(' maybeambiguous=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.maybeambiguous), input_name='maybeambiguous')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='memberdefType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.templateparamlist is not None:
            namespaceprefix_ = self.templateparamlist_nsprefix_ + ':' if (UseCapturedNS_ and self.templateparamlist_nsprefix_) else ''
            self.templateparamlist.export(outfile, level, namespaceprefix_, namespacedef_='', name_='templateparamlist', pretty_print=pretty_print)
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.definition is not None:
            namespaceprefix_ = self.definition_nsprefix_ + ':' if (UseCapturedNS_ and self.definition_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdefinition>%s</%sdefinition>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.definition), input_name='definition')), namespaceprefix_ , eol_))
        if self.argsstring is not None:
            namespaceprefix_ = self.argsstring_nsprefix_ + ':' if (UseCapturedNS_ and self.argsstring_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sargsstring>%s</%sargsstring>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.argsstring), input_name='argsstring')), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.read is not None:
            namespaceprefix_ = self.read_nsprefix_ + ':' if (UseCapturedNS_ and self.read_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sread>%s</%sread>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.read), input_name='read')), namespaceprefix_ , eol_))
        if self.write is not None:
            namespaceprefix_ = self.write_nsprefix_ + ':' if (UseCapturedNS_ and self.write_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swrite>%s</%swrite>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.write), input_name='write')), namespaceprefix_ , eol_))
        if self.bitfield is not None:
            namespaceprefix_ = self.bitfield_nsprefix_ + ':' if (UseCapturedNS_ and self.bitfield_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbitfield>%s</%sbitfield>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.bitfield), input_name='bitfield')), namespaceprefix_ , eol_))
        for reimplements_ in self.reimplements:
            namespaceprefix_ = self.reimplements_nsprefix_ + ':' if (UseCapturedNS_ and self.reimplements_nsprefix_) else ''
            reimplements_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reimplements', pretty_print=pretty_print)
        for reimplementedby_ in self.reimplementedby:
            namespaceprefix_ = self.reimplementedby_nsprefix_ + ':' if (UseCapturedNS_ and self.reimplementedby_nsprefix_) else ''
            reimplementedby_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reimplementedby', pretty_print=pretty_print)
        for param_ in self.param:
            namespaceprefix_ = self.param_nsprefix_ + ':' if (UseCapturedNS_ and self.param_nsprefix_) else ''
            param_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='param', pretty_print=pretty_print)
        for enumvalue_ in self.enumvalue:
            namespaceprefix_ = self.enumvalue_nsprefix_ + ':' if (UseCapturedNS_ and self.enumvalue_nsprefix_) else ''
            enumvalue_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='enumvalue', pretty_print=pretty_print)
        if self.initializer is not None:
            namespaceprefix_ = self.initializer_nsprefix_ + ':' if (UseCapturedNS_ and self.initializer_nsprefix_) else ''
            self.initializer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='initializer', pretty_print=pretty_print)
        if self.exceptions is not None:
            namespaceprefix_ = self.exceptions_nsprefix_ + ':' if (UseCapturedNS_ and self.exceptions_nsprefix_) else ''
            self.exceptions.export(outfile, level, namespaceprefix_, namespacedef_='', name_='exceptions', pretty_print=pretty_print)
        if self.briefdescription is not None:
            namespaceprefix_ = self.briefdescription_nsprefix_ + ':' if (UseCapturedNS_ and self.briefdescription_nsprefix_) else ''
            self.briefdescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='briefdescription', pretty_print=pretty_print)
        if self.detaileddescription is not None:
            namespaceprefix_ = self.detaileddescription_nsprefix_ + ':' if (UseCapturedNS_ and self.detaileddescription_nsprefix_) else ''
            self.detaileddescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='detaileddescription', pretty_print=pretty_print)
        if self.inbodydescription is not None:
            namespaceprefix_ = self.inbodydescription_nsprefix_ + ':' if (UseCapturedNS_ and self.inbodydescription_nsprefix_) else ''
            self.inbodydescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='inbodydescription', pretty_print=pretty_print)
        if self.location is not None:
            namespaceprefix_ = self.location_nsprefix_ + ':' if (UseCapturedNS_ and self.location_nsprefix_) else ''
            self.location.export(outfile, level, namespaceprefix_, namespacedef_='', name_='location', pretty_print=pretty_print)
        for references_ in self.references:
            namespaceprefix_ = self.references_nsprefix_ + ':' if (UseCapturedNS_ and self.references_nsprefix_) else ''
            references_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='references', pretty_print=pretty_print)
        for referencedby_ in self.referencedby:
            namespaceprefix_ = self.referencedby_nsprefix_ + ':' if (UseCapturedNS_ and self.referencedby_nsprefix_) else ''
            referencedby_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='referencedby', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('kind', node)
        if value is not None and 'kind' not in already_processed:
            already_processed.add('kind')
            self.kind = value
            self.validate_DoxMemberKind(self.kind)    # validate type DoxMemberKind
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('prot', node)
        if value is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            self.prot = value
            self.validate_DoxProtectionKind(self.prot)    # validate type DoxProtectionKind
        value = find_attr_value_('static', node)
        if value is not None and 'static' not in already_processed:
            already_processed.add('static')
            self.static = value
            self.validate_DoxBool(self.static)    # validate type DoxBool
        value = find_attr_value_('const', node)
        if value is not None and 'const' not in already_processed:
            already_processed.add('const')
            self.const = value
            self.validate_DoxBool(self.const)    # validate type DoxBool
        value = find_attr_value_('explicit', node)
        if value is not None and 'explicit' not in already_processed:
            already_processed.add('explicit')
            self.explicit = value
            self.validate_DoxBool(self.explicit)    # validate type DoxBool
        value = find_attr_value_('inline', node)
        if value is not None and 'inline' not in already_processed:
            already_processed.add('inline')
            self.inline = value
            self.validate_DoxBool(self.inline)    # validate type DoxBool
        value = find_attr_value_('virt', node)
        if value is not None and 'virt' not in already_processed:
            already_processed.add('virt')
            self.virt = value
            self.validate_DoxVirtualKind(self.virt)    # validate type DoxVirtualKind
        value = find_attr_value_('volatile', node)
        if value is not None and 'volatile' not in already_processed:
            already_processed.add('volatile')
            self.volatile = value
            self.validate_DoxBool(self.volatile)    # validate type DoxBool
        value = find_attr_value_('mutable', node)
        if value is not None and 'mutable' not in already_processed:
            already_processed.add('mutable')
            self.mutable = value
            self.validate_DoxBool(self.mutable)    # validate type DoxBool
        value = find_attr_value_('readable', node)
        if value is not None and 'readable' not in already_processed:
            already_processed.add('readable')
            self.readable = value
            self.validate_DoxBool(self.readable)    # validate type DoxBool
        value = find_attr_value_('writable', node)
        if value is not None and 'writable' not in already_processed:
            already_processed.add('writable')
            self.writable = value
            self.validate_DoxBool(self.writable)    # validate type DoxBool
        value = find_attr_value_('initonly', node)
        if value is not None and 'initonly' not in already_processed:
            already_processed.add('initonly')
            self.initonly = value
            self.validate_DoxBool(self.initonly)    # validate type DoxBool
        value = find_attr_value_('settable', node)
        if value is not None and 'settable' not in already_processed:
            already_processed.add('settable')
            self.settable = value
            self.validate_DoxBool(self.settable)    # validate type DoxBool
        value = find_attr_value_('gettable', node)
        if value is not None and 'gettable' not in already_processed:
            already_processed.add('gettable')
            self.gettable = value
            self.validate_DoxBool(self.gettable)    # validate type DoxBool
        value = find_attr_value_('final', node)
        if value is not None and 'final' not in already_processed:
            already_processed.add('final')
            self.final = value
            self.validate_DoxBool(self.final)    # validate type DoxBool
        value = find_attr_value_('sealed', node)
        if value is not None and 'sealed' not in already_processed:
            already_processed.add('sealed')
            self.sealed = value
            self.validate_DoxBool(self.sealed)    # validate type DoxBool
        value = find_attr_value_('new', node)
        if value is not None and 'new' not in already_processed:
            already_processed.add('new')
            self.new = value
            self.validate_DoxBool(self.new)    # validate type DoxBool
        value = find_attr_value_('add', node)
        if value is not None and 'add' not in already_processed:
            already_processed.add('add')
            self.add = value
            self.validate_DoxBool(self.add)    # validate type DoxBool
        value = find_attr_value_('remove', node)
        if value is not None and 'remove' not in already_processed:
            already_processed.add('remove')
            self.remove = value
            self.validate_DoxBool(self.remove)    # validate type DoxBool
        value = find_attr_value_('raise', node)
        if value is not None and 'raise' not in already_processed:
            already_processed.add('raise')
            self.raise_ = value
            self.validate_DoxBool(self.raise_)    # validate type DoxBool
        value = find_attr_value_('optional', node)
        if value is not None and 'optional' not in already_processed:
            already_processed.add('optional')
            self.optional = value
            self.validate_DoxBool(self.optional)    # validate type DoxBool
        value = find_attr_value_('required', node)
        if value is not None and 'required' not in already_processed:
            already_processed.add('required')
            self.required = value
            self.validate_DoxBool(self.required)    # validate type DoxBool
        value = find_attr_value_('accessor', node)
        if value is not None and 'accessor' not in already_processed:
            already_processed.add('accessor')
            self.accessor = value
            self.validate_DoxAccessor(self.accessor)    # validate type DoxAccessor
        value = find_attr_value_('attribute', node)
        if value is not None and 'attribute' not in already_processed:
            already_processed.add('attribute')
            self.attribute = value
            self.validate_DoxBool(self.attribute)    # validate type DoxBool
        value = find_attr_value_('property', node)
        if value is not None and 'property' not in already_processed:
            already_processed.add('property')
            self.property = value
            self.validate_DoxBool(self.property)    # validate type DoxBool
        value = find_attr_value_('readonly', node)
        if value is not None and 'readonly' not in already_processed:
            already_processed.add('readonly')
            self.readonly = value
            self.validate_DoxBool(self.readonly)    # validate type DoxBool
        value = find_attr_value_('bound', node)
        if value is not None and 'bound' not in already_processed:
            already_processed.add('bound')
            self.bound = value
            self.validate_DoxBool(self.bound)    # validate type DoxBool
        value = find_attr_value_('removable', node)
        if value is not None and 'removable' not in already_processed:
            already_processed.add('removable')
            self.removable = value
            self.validate_DoxBool(self.removable)    # validate type DoxBool
        value = find_attr_value_('contrained', node)
        if value is not None and 'contrained' not in already_processed:
            already_processed.add('contrained')
            self.contrained = value
            self.validate_DoxBool(self.contrained)    # validate type DoxBool
        value = find_attr_value_('transient', node)
        if value is not None and 'transient' not in already_processed:
            already_processed.add('transient')
            self.transient = value
            self.validate_DoxBool(self.transient)    # validate type DoxBool
        value = find_attr_value_('maybevoid', node)
        if value is not None and 'maybevoid' not in already_processed:
            already_processed.add('maybevoid')
            self.maybevoid = value
            self.validate_DoxBool(self.maybevoid)    # validate type DoxBool
        value = find_attr_value_('maybedefault', node)
        if value is not None and 'maybedefault' not in already_processed:
            already_processed.add('maybedefault')
            self.maybedefault = value
            self.validate_DoxBool(self.maybedefault)    # validate type DoxBool
        value = find_attr_value_('maybeambiguous', node)
        if value is not None and 'maybeambiguous' not in already_processed:
            already_processed.add('maybeambiguous')
            self.maybeambiguous = value
            self.validate_DoxBool(self.maybeambiguous)    # validate type DoxBool
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'templateparamlist':
            obj_ = templateparamlistType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.templateparamlist = obj_
            obj_.original_tagname_ = 'templateparamlist'
        elif nodeName_ == 'type':
            obj_ = linkedTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'definition':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'definition')
            value_ = self.gds_validate_string(value_, node, 'definition')
            self.definition = value_
            self.definition_nsprefix_ = child_.prefix
        elif nodeName_ == 'argsstring':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'argsstring')
            value_ = self.gds_validate_string(value_, node, 'argsstring')
            self.argsstring = value_
            self.argsstring_nsprefix_ = child_.prefix
        elif nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'read':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'read')
            value_ = self.gds_validate_string(value_, node, 'read')
            self.read = value_
            self.read_nsprefix_ = child_.prefix
        elif nodeName_ == 'write':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'write')
            value_ = self.gds_validate_string(value_, node, 'write')
            self.write = value_
            self.write_nsprefix_ = child_.prefix
        elif nodeName_ == 'bitfield':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'bitfield')
            value_ = self.gds_validate_string(value_, node, 'bitfield')
            self.bitfield = value_
            self.bitfield_nsprefix_ = child_.prefix
        elif nodeName_ == 'reimplements':
            obj_ = reimplementType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reimplements.append(obj_)
            obj_.original_tagname_ = 'reimplements'
        elif nodeName_ == 'reimplementedby':
            obj_ = reimplementType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reimplementedby.append(obj_)
            obj_.original_tagname_ = 'reimplementedby'
        elif nodeName_ == 'param':
            obj_ = paramType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.param.append(obj_)
            obj_.original_tagname_ = 'param'
        elif nodeName_ == 'enumvalue':
            obj_ = enumvalueType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.enumvalue.append(obj_)
            obj_.original_tagname_ = 'enumvalue'
        elif nodeName_ == 'initializer':
            obj_ = linkedTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.initializer = obj_
            obj_.original_tagname_ = 'initializer'
        elif nodeName_ == 'exceptions':
            obj_ = linkedTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.exceptions = obj_
            obj_.original_tagname_ = 'exceptions'
        elif nodeName_ == 'briefdescription':
            obj_ = descriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.briefdescription = obj_
            obj_.original_tagname_ = 'briefdescription'
        elif nodeName_ == 'detaileddescription':
            obj_ = descriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.detaileddescription = obj_
            obj_.original_tagname_ = 'detaileddescription'
        elif nodeName_ == 'inbodydescription':
            obj_ = descriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inbodydescription = obj_
            obj_.original_tagname_ = 'inbodydescription'
        elif nodeName_ == 'location':
            obj_ = locationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.location = obj_
            obj_.original_tagname_ = 'location'
        elif nodeName_ == 'references':
            obj_ = referenceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.references.append(obj_)
            obj_.original_tagname_ = 'references'
        elif nodeName_ == 'referencedby':
            obj_ = referenceType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.referencedby.append(obj_)
            obj_.original_tagname_ = 'referencedby'
# end class memberdefType


class definition(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, definition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if definition.subclass:
            return definition.subclass(*args_, **kwargs_)
        return definition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='definition', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('definition')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'definition':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='definition')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='definition', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='definition'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='definition', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class definition


class argsstring(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, argsstring)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if argsstring.subclass:
            return argsstring.subclass(*args_, **kwargs_)
        return argsstring(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='argsstring', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('argsstring')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'argsstring':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='argsstring')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='argsstring', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='argsstring'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='argsstring', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class argsstring


class read(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, read)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if read.subclass:
            return read.subclass(*args_, **kwargs_)
        return read(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='read', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('read')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'read':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='read')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='read', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='read'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='read', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class read


class write(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, write)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if write.subclass:
            return write.subclass(*args_, **kwargs_)
        return write(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='write', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('write')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'write':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='write')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='write', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='write'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='write', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class write


class bitfield(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, bitfield)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if bitfield.subclass:
            return bitfield.subclass(*args_, **kwargs_)
        return bitfield(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='bitfield', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('bitfield')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'bitfield':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='bitfield')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='bitfield', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='bitfield'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='bitfield', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class bitfield


class descriptionType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, title=None, para=None, sect1=None, internal=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if sect1 is None:
            self.sect1 = []
        else:
            self.sect1 = sect1
        self.sect1_nsprefix_ = None
        self.internal = internal
        self.internal_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, descriptionType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if descriptionType.subclass:
            return descriptionType.subclass(*args_, **kwargs_)
        return descriptionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_sect1(self):
        return self.sect1
    def set_sect1(self, sect1):
        self.sect1 = sect1
    def add_sect1(self, value):
        self.sect1.append(value)
    def insert_sect1_at(self, index, value):
        self.sect1.insert(index, value)
    def replace_sect1_at(self, index, value):
        self.sect1[index] = value
    def get_internal(self):
        return self.internal
    def set_internal(self, internal):
        self.internal = internal
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.title is not None or
            self.para or
            self.sect1 or
            self.internal is not None or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='descriptionType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('descriptionType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'descriptionType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='descriptionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='descriptionType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='descriptionType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='descriptionType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for sect1_ in self.sect1:
            namespaceprefix_ = self.sect1_nsprefix_ + ':' if (UseCapturedNS_ and self.sect1_nsprefix_) else ''
            sect1_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect1', pretty_print=pretty_print)
        if self.internal is not None:
            namespaceprefix_ = self.internal_nsprefix_ + ':' if (UseCapturedNS_ and self.internal_nsprefix_) else ''
            self.internal.export(outfile, level, namespaceprefix_, namespacedef_='', name_='internal', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'title')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'title')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'title', valuestr_)
            self.content_.append(obj_)
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'sect1':
            obj_ = docSect1Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect1', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect1'):
              self.add_sect1(obj_.value)
            elif hasattr(self, 'set_sect1'):
              self.set_sect1(obj_.value)
        elif nodeName_ == 'internal':
            obj_ = docInternalType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'internal', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_internal'):
              self.add_internal(obj_.value)
            elif hasattr(self, 'set_internal'):
              self.set_internal(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class descriptionType


class enumvalueType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, prot=None, name=None, initializer=None, briefdescription=None, detaileddescription=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.prot = _cast(None, prot)
        self.prot_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.initializer = initializer
        self.initializer_nsprefix_ = None
        self.briefdescription = briefdescription
        self.briefdescription_nsprefix_ = None
        self.detaileddescription = detaileddescription
        self.detaileddescription_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, enumvalueType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if enumvalueType.subclass:
            return enumvalueType.subclass(*args_, **kwargs_)
        return enumvalueType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_initializer(self):
        return self.initializer
    def set_initializer(self, initializer):
        self.initializer = initializer
    def get_briefdescription(self):
        return self.briefdescription
    def set_briefdescription(self, briefdescription):
        self.briefdescription = briefdescription
    def get_detaileddescription(self):
        return self.detaileddescription
    def set_detaileddescription(self, detaileddescription):
        self.detaileddescription = detaileddescription
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_prot(self):
        return self.prot
    def set_prot(self, prot):
        self.prot = prot
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_DoxProtectionKind(self, value):
        # Validate type DoxProtectionKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['public', 'protected', 'private', 'package']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxProtectionKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.name is not None or
            self.initializer is not None or
            self.briefdescription is not None or
            self.detaileddescription is not None or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='enumvalueType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('enumvalueType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'enumvalueType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='enumvalueType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='enumvalueType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='enumvalueType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.prot is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            outfile.write(' prot=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.prot), input_name='prot')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='enumvalueType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.initializer is not None:
            namespaceprefix_ = self.initializer_nsprefix_ + ':' if (UseCapturedNS_ and self.initializer_nsprefix_) else ''
            self.initializer.export(outfile, level, namespaceprefix_, namespacedef_='', name_='initializer', pretty_print=pretty_print)
        if self.briefdescription is not None:
            namespaceprefix_ = self.briefdescription_nsprefix_ + ':' if (UseCapturedNS_ and self.briefdescription_nsprefix_) else ''
            self.briefdescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='briefdescription', pretty_print=pretty_print)
        if self.detaileddescription is not None:
            namespaceprefix_ = self.detaileddescription_nsprefix_ + ':' if (UseCapturedNS_ and self.detaileddescription_nsprefix_) else ''
            self.detaileddescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='detaileddescription', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
        value = find_attr_value_('prot', node)
        if value is not None and 'prot' not in already_processed:
            already_processed.add('prot')
            self.prot = value
            self.validate_DoxProtectionKind(self.prot)    # validate type DoxProtectionKind
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'name')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'name')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'name', valuestr_)
            self.content_.append(obj_)
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'initializer':
            obj_ = linkedTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'initializer', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_initializer'):
              self.add_initializer(obj_.value)
            elif hasattr(self, 'set_initializer'):
              self.set_initializer(obj_.value)
        elif nodeName_ == 'briefdescription':
            obj_ = descriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'briefdescription', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_briefdescription'):
              self.add_briefdescription(obj_.value)
            elif hasattr(self, 'set_briefdescription'):
              self.set_briefdescription(obj_.value)
        elif nodeName_ == 'detaileddescription':
            obj_ = descriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'detaileddescription', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_detaileddescription'):
              self.add_detaileddescription(obj_.value)
            elif hasattr(self, 'set_detaileddescription'):
              self.set_detaileddescription(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class enumvalueType


class templateparamlistType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, param=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if param is None:
            self.param = []
        else:
            self.param = param
        self.param_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, templateparamlistType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if templateparamlistType.subclass:
            return templateparamlistType.subclass(*args_, **kwargs_)
        return templateparamlistType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_param(self):
        return self.param
    def set_param(self, param):
        self.param = param
    def add_param(self, value):
        self.param.append(value)
    def insert_param_at(self, index, value):
        self.param.insert(index, value)
    def replace_param_at(self, index, value):
        self.param[index] = value
    def hasContent_(self):
        if (
            self.param
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='templateparamlistType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('templateparamlistType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'templateparamlistType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='templateparamlistType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='templateparamlistType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='templateparamlistType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='templateparamlistType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for param_ in self.param:
            namespaceprefix_ = self.param_nsprefix_ + ':' if (UseCapturedNS_ and self.param_nsprefix_) else ''
            param_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='param', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'param':
            obj_ = paramType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.param.append(obj_)
            obj_.original_tagname_ = 'param'
# end class templateparamlistType


class paramType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, type_=None, declname=None, defname=None, array=None, defval=None, briefdescription=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.declname = declname
        self.declname_nsprefix_ = None
        self.defname = defname
        self.defname_nsprefix_ = None
        self.array = array
        self.array_nsprefix_ = None
        self.defval = defval
        self.defval_nsprefix_ = None
        self.briefdescription = briefdescription
        self.briefdescription_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, paramType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if paramType.subclass:
            return paramType.subclass(*args_, **kwargs_)
        return paramType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_declname(self):
        return self.declname
    def set_declname(self, declname):
        self.declname = declname
    def get_defname(self):
        return self.defname
    def set_defname(self, defname):
        self.defname = defname
    def get_array(self):
        return self.array
    def set_array(self, array):
        self.array = array
    def get_defval(self):
        return self.defval
    def set_defval(self, defval):
        self.defval = defval
    def get_briefdescription(self):
        return self.briefdescription
    def set_briefdescription(self, briefdescription):
        self.briefdescription = briefdescription
    def hasContent_(self):
        if (
            self.type_ is not None or
            self.declname is not None or
            self.defname is not None or
            self.array is not None or
            self.defval is not None or
            self.briefdescription is not None
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='paramType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('paramType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'paramType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='paramType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='paramType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='paramType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='paramType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.declname is not None:
            namespaceprefix_ = self.declname_nsprefix_ + ':' if (UseCapturedNS_ and self.declname_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdeclname>%s</%sdeclname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.declname), input_name='declname')), namespaceprefix_ , eol_))
        if self.defname is not None:
            namespaceprefix_ = self.defname_nsprefix_ + ':' if (UseCapturedNS_ and self.defname_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdefname>%s</%sdefname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.defname), input_name='defname')), namespaceprefix_ , eol_))
        if self.array is not None:
            namespaceprefix_ = self.array_nsprefix_ + ':' if (UseCapturedNS_ and self.array_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sarray>%s</%sarray>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.array), input_name='array')), namespaceprefix_ , eol_))
        if self.defval is not None:
            namespaceprefix_ = self.defval_nsprefix_ + ':' if (UseCapturedNS_ and self.defval_nsprefix_) else ''
            self.defval.export(outfile, level, namespaceprefix_, namespacedef_='', name_='defval', pretty_print=pretty_print)
        if self.briefdescription is not None:
            namespaceprefix_ = self.briefdescription_nsprefix_ + ':' if (UseCapturedNS_ and self.briefdescription_nsprefix_) else ''
            self.briefdescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='briefdescription', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'type':
            obj_ = linkedTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'declname':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'declname')
            value_ = self.gds_validate_string(value_, node, 'declname')
            self.declname = value_
            self.declname_nsprefix_ = child_.prefix
        elif nodeName_ == 'defname':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'defname')
            value_ = self.gds_validate_string(value_, node, 'defname')
            self.defname = value_
            self.defname_nsprefix_ = child_.prefix
        elif nodeName_ == 'array':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'array')
            value_ = self.gds_validate_string(value_, node, 'array')
            self.array = value_
            self.array_nsprefix_ = child_.prefix
        elif nodeName_ == 'defval':
            obj_ = linkedTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.defval = obj_
            obj_.original_tagname_ = 'defval'
        elif nodeName_ == 'briefdescription':
            obj_ = descriptionType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.briefdescription = obj_
            obj_.original_tagname_ = 'briefdescription'
# end class paramType


class declname(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, declname)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if declname.subclass:
            return declname.subclass(*args_, **kwargs_)
        return declname(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='declname', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('declname')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'declname':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='declname')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='declname', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='declname'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='declname', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class declname


class defname(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, defname)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if defname.subclass:
            return defname.subclass(*args_, **kwargs_)
        return defname(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='defname', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('defname')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'defname':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='defname')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='defname', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='defname'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='defname', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class defname


class array(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, array)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if array.subclass:
            return array.subclass(*args_, **kwargs_)
        return array(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='array', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('array')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'array':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='array')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='array', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='array'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='array', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class array


class linkedTextType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ref=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ref is None:
            self.ref = []
        else:
            self.ref = ref
        self.ref_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, linkedTextType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if linkedTextType.subclass:
            return linkedTextType.subclass(*args_, **kwargs_)
        return linkedTextType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ref(self):
        return self.ref
    def set_ref(self, ref):
        self.ref = ref
    def add_ref(self, value):
        self.ref.append(value)
    def insert_ref_at(self, index, value):
        self.ref.insert(index, value)
    def replace_ref_at(self, index, value):
        self.ref[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.ref or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='linkedTextType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('linkedTextType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'linkedTextType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='linkedTextType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='linkedTextType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='linkedTextType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='linkedTextType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ref_ in self.ref:
            namespaceprefix_ = self.ref_nsprefix_ + ':' if (UseCapturedNS_ and self.ref_nsprefix_) else ''
            ref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ref', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ref':
            obj_ = refTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ref', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ref'):
              self.add_ref(obj_.value)
            elif hasattr(self, 'set_ref'):
              self.set_ref(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class linkedTextType


class graphType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, node=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if node is None:
            self.node = []
        else:
            self.node = node
        self.node_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, graphType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if graphType.subclass:
            return graphType.subclass(*args_, **kwargs_)
        return graphType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_node(self):
        return self.node
    def set_node(self, node):
        self.node = node
    def add_node(self, value):
        self.node.append(value)
    def insert_node_at(self, index, value):
        self.node.insert(index, value)
    def replace_node_at(self, index, value):
        self.node[index] = value
    def hasContent_(self):
        if (
            self.node
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='graphType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('graphType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'graphType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='graphType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='graphType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='graphType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='graphType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for node_ in self.node:
            namespaceprefix_ = self.node_nsprefix_ + ':' if (UseCapturedNS_ and self.node_nsprefix_) else ''
            node_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='node', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'node':
            obj_ = nodeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.node.append(obj_)
            obj_.original_tagname_ = 'node'
# end class graphType


class nodeType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, label=None, link=None, childnode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.label = label
        self.label_nsprefix_ = None
        self.link = link
        self.link_nsprefix_ = None
        if childnode is None:
            self.childnode = []
        else:
            self.childnode = childnode
        self.childnode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, nodeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if nodeType.subclass:
            return nodeType.subclass(*args_, **kwargs_)
        return nodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_label(self):
        return self.label
    def set_label(self, label):
        self.label = label
    def get_link(self):
        return self.link
    def set_link(self, link):
        self.link = link
    def get_childnode(self):
        return self.childnode
    def set_childnode(self, childnode):
        self.childnode = childnode
    def add_childnode(self, value):
        self.childnode.append(value)
    def insert_childnode_at(self, index, value):
        self.childnode.insert(index, value)
    def replace_childnode_at(self, index, value):
        self.childnode[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def hasContent_(self):
        if (
            self.label is not None or
            self.link is not None or
            self.childnode
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='nodeType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('nodeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'nodeType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='nodeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='nodeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='nodeType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='nodeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.label is not None:
            namespaceprefix_ = self.label_nsprefix_ + ':' if (UseCapturedNS_ and self.label_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabel>%s</%slabel>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.label), input_name='label')), namespaceprefix_ , eol_))
        if self.link is not None:
            namespaceprefix_ = self.link_nsprefix_ + ':' if (UseCapturedNS_ and self.link_nsprefix_) else ''
            self.link.export(outfile, level, namespaceprefix_, namespacedef_='', name_='link', pretty_print=pretty_print)
        for childnode_ in self.childnode:
            namespaceprefix_ = self.childnode_nsprefix_ + ':' if (UseCapturedNS_ and self.childnode_nsprefix_) else ''
            childnode_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='childnode', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'label':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'label')
            value_ = self.gds_validate_string(value_, node, 'label')
            self.label = value_
            self.label_nsprefix_ = child_.prefix
        elif nodeName_ == 'link':
            obj_ = linkType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.link = obj_
            obj_.original_tagname_ = 'link'
        elif nodeName_ == 'childnode':
            obj_ = childnodeType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.childnode.append(obj_)
            obj_.original_tagname_ = 'childnode'
# end class nodeType


class label(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, label)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if label.subclass:
            return label.subclass(*args_, **kwargs_)
        return label(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='label', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('label')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'label':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='label')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='label', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='label'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='label', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class label


class childnodeType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, refid=None, relation=None, edgelabel=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.relation = _cast(None, relation)
        self.relation_nsprefix_ = None
        if edgelabel is None:
            self.edgelabel = []
        else:
            self.edgelabel = edgelabel
        self.edgelabel_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, childnodeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if childnodeType.subclass:
            return childnodeType.subclass(*args_, **kwargs_)
        return childnodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_edgelabel(self):
        return self.edgelabel
    def set_edgelabel(self, edgelabel):
        self.edgelabel = edgelabel
    def add_edgelabel(self, value):
        self.edgelabel.append(value)
    def insert_edgelabel_at(self, index, value):
        self.edgelabel.insert(index, value)
    def replace_edgelabel_at(self, index, value):
        self.edgelabel[index] = value
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_relation(self):
        return self.relation
    def set_relation(self, relation):
        self.relation = relation
    def validate_DoxGraphRelation(self, value):
        # Validate type DoxGraphRelation, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['include', 'usage', 'template-instance', 'public-inheritance', 'protected-inheritance', 'private-inheritance']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxGraphRelation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.edgelabel
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='childnodeType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('childnodeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'childnodeType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='childnodeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='childnodeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='childnodeType'):
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
        if self.relation is not None and 'relation' not in already_processed:
            already_processed.add('relation')
            outfile.write(' relation=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.relation), input_name='relation')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='childnodeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for edgelabel_ in self.edgelabel:
            namespaceprefix_ = self.edgelabel_nsprefix_ + ':' if (UseCapturedNS_ and self.edgelabel_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sedgelabel>%s</%sedgelabel>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(edgelabel_), input_name='edgelabel')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
        value = find_attr_value_('relation', node)
        if value is not None and 'relation' not in already_processed:
            already_processed.add('relation')
            self.relation = value
            self.validate_DoxGraphRelation(self.relation)    # validate type DoxGraphRelation
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'edgelabel':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'edgelabel')
            value_ = self.gds_validate_string(value_, node, 'edgelabel')
            self.edgelabel.append(value_)
            self.edgelabel_nsprefix_ = child_.prefix
# end class childnodeType


class edgelabel(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, edgelabel)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if edgelabel.subclass:
            return edgelabel.subclass(*args_, **kwargs_)
        return edgelabel(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='edgelabel', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('edgelabel')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'edgelabel':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='edgelabel')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='edgelabel', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='edgelabel'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='edgelabel', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class edgelabel


class linkType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, refid=None, external=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.external = _cast(None, external)
        self.external_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, linkType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if linkType.subclass:
            return linkType.subclass(*args_, **kwargs_)
        return linkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_external(self):
        return self.external
    def set_external(self, external):
        self.external = external
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='linkType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('linkType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'linkType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='linkType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='linkType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='linkType'):
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
        if self.external is not None and 'external' not in already_processed:
            already_processed.add('external')
            outfile.write(' external=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.external), input_name='external')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='linkType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
        value = find_attr_value_('external', node)
        if value is not None and 'external' not in already_processed:
            already_processed.add('external')
            self.external = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class linkType


class listingType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, codeline=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if codeline is None:
            self.codeline = []
        else:
            self.codeline = codeline
        self.codeline_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, listingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if listingType.subclass:
            return listingType.subclass(*args_, **kwargs_)
        return listingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_codeline(self):
        return self.codeline
    def set_codeline(self, codeline):
        self.codeline = codeline
    def add_codeline(self, value):
        self.codeline.append(value)
    def insert_codeline_at(self, index, value):
        self.codeline.insert(index, value)
    def replace_codeline_at(self, index, value):
        self.codeline[index] = value
    def hasContent_(self):
        if (
            self.codeline
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='listingType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('listingType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'listingType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='listingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='listingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='listingType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='listingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for codeline_ in self.codeline:
            namespaceprefix_ = self.codeline_nsprefix_ + ':' if (UseCapturedNS_ and self.codeline_nsprefix_) else ''
            codeline_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='codeline', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'codeline':
            obj_ = codelineType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.codeline.append(obj_)
            obj_.original_tagname_ = 'codeline'
# end class listingType


class codelineType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, lineno=None, refid=None, refkind=None, external=None, highlight=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.lineno = _cast(int, lineno)
        self.lineno_nsprefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.refkind = _cast(None, refkind)
        self.refkind_nsprefix_ = None
        self.external = _cast(None, external)
        self.external_nsprefix_ = None
        if highlight is None:
            self.highlight = []
        else:
            self.highlight = highlight
        self.highlight_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, codelineType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if codelineType.subclass:
            return codelineType.subclass(*args_, **kwargs_)
        return codelineType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_highlight(self):
        return self.highlight
    def set_highlight(self, highlight):
        self.highlight = highlight
    def add_highlight(self, value):
        self.highlight.append(value)
    def insert_highlight_at(self, index, value):
        self.highlight.insert(index, value)
    def replace_highlight_at(self, index, value):
        self.highlight[index] = value
    def get_lineno(self):
        return self.lineno
    def set_lineno(self, lineno):
        self.lineno = lineno
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_refkind(self):
        return self.refkind
    def set_refkind(self, refkind):
        self.refkind = refkind
    def get_external(self):
        return self.external
    def set_external(self, external):
        self.external = external
    def validate_DoxRefKind(self, value):
        # Validate type DoxRefKind, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['compound', 'member']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxRefKind' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_DoxBool(self, value):
        # Validate type DoxBool, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['yes', 'no']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxBool' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.highlight
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='codelineType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('codelineType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'codelineType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='codelineType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='codelineType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='codelineType'):
        if self.lineno is not None and 'lineno' not in already_processed:
            already_processed.add('lineno')
            outfile.write(' lineno="%s"' % self.gds_format_integer(self.lineno, input_name='lineno'))
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
        if self.refkind is not None and 'refkind' not in already_processed:
            already_processed.add('refkind')
            outfile.write(' refkind=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refkind), input_name='refkind')), ))
        if self.external is not None and 'external' not in already_processed:
            already_processed.add('external')
            outfile.write(' external=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.external), input_name='external')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='codelineType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for highlight_ in self.highlight:
            namespaceprefix_ = self.highlight_nsprefix_ + ':' if (UseCapturedNS_ and self.highlight_nsprefix_) else ''
            highlight_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='highlight', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('lineno', node)
        if value is not None and 'lineno' not in already_processed:
            already_processed.add('lineno')
            self.lineno = self.gds_parse_integer(value, node, 'lineno')
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
        value = find_attr_value_('refkind', node)
        if value is not None and 'refkind' not in already_processed:
            already_processed.add('refkind')
            self.refkind = value
            self.validate_DoxRefKind(self.refkind)    # validate type DoxRefKind
        value = find_attr_value_('external', node)
        if value is not None and 'external' not in already_processed:
            already_processed.add('external')
            self.external = value
            self.validate_DoxBool(self.external)    # validate type DoxBool
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'highlight':
            obj_ = highlightType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.highlight.append(obj_)
            obj_.original_tagname_ = 'highlight'
# end class codelineType


class highlightType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, class_=None, sp=None, ref=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.class_ = _cast(None, class_)
        self.class__nsprefix_ = None
        if sp is None:
            self.sp = []
        else:
            self.sp = sp
        self.sp_nsprefix_ = None
        if ref is None:
            self.ref = []
        else:
            self.ref = ref
        self.ref_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, highlightType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if highlightType.subclass:
            return highlightType.subclass(*args_, **kwargs_)
        return highlightType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_sp(self):
        return self.sp
    def set_sp(self, sp):
        self.sp = sp
    def add_sp(self, value):
        self.sp.append(value)
    def insert_sp_at(self, index, value):
        self.sp.insert(index, value)
    def replace_sp_at(self, index, value):
        self.sp[index] = value
    def get_ref(self):
        return self.ref
    def set_ref(self, ref):
        self.ref = ref
    def add_ref(self, value):
        self.ref.append(value)
    def insert_ref_at(self, index, value):
        self.ref.insert(index, value)
    def replace_ref_at(self, index, value):
        self.ref[index] = value
    def get_class(self):
        return self.class_
    def set_class(self, class_):
        self.class_ = class_
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_DoxHighlightClass(self, value):
        # Validate type DoxHighlightClass, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['comment', 'normal', 'preprocessor', 'keyword', 'keywordtype', 'keywordflow', 'stringliteral', 'charliteral']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoxHighlightClass' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (
            self.sp or
            self.ref or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='highlightType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('highlightType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'highlightType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='highlightType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='highlightType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='highlightType'):
        if self.class_ is not None and 'class_' not in already_processed:
            already_processed.add('class_')
            outfile.write(' class=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.class_), input_name='class')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='highlightType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for sp_ in self.sp:
            namespaceprefix_ = self.sp_nsprefix_ + ':' if (UseCapturedNS_ and self.sp_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssp>%s</%ssp>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(sp_), input_name='sp')), namespaceprefix_ , eol_))
        for ref_ in self.ref:
            namespaceprefix_ = self.ref_nsprefix_ + ':' if (UseCapturedNS_ and self.ref_nsprefix_) else ''
            ref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ref', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('class', node)
        if value is not None and 'class' not in already_processed:
            already_processed.add('class')
            self.class_ = value
            self.validate_DoxHighlightClass(self.class_)    # validate type DoxHighlightClass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'sp' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'sp')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'sp')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'sp', valuestr_)
            self.content_.append(obj_)
            self.sp_nsprefix_ = child_.prefix
        elif nodeName_ == 'ref':
            obj_ = refTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ref', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ref'):
              self.add_ref(obj_.value)
            elif hasattr(self, 'set_ref'):
              self.set_ref(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class highlightType


class sp(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, sp)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if sp.subclass:
            return sp.subclass(*args_, **kwargs_)
        return sp(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sp', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('sp')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'sp':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='sp')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='sp', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='sp'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='sp', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class sp


class referenceType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, refid=None, compoundref=None, startline=None, endline=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.refid = _cast(None, refid)
        self.refid_nsprefix_ = None
        self.compoundref = _cast(None, compoundref)
        self.compoundref_nsprefix_ = None
        self.startline = _cast(int, startline)
        self.startline_nsprefix_ = None
        self.endline = _cast(int, endline)
        self.endline_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, referenceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if referenceType.subclass:
            return referenceType.subclass(*args_, **kwargs_)
        return referenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_refid(self):
        return self.refid
    def set_refid(self, refid):
        self.refid = refid
    def get_compoundref(self):
        return self.compoundref
    def set_compoundref(self, compoundref):
        self.compoundref = compoundref
    def get_startline(self):
        return self.startline
    def set_startline(self, startline):
        self.startline = startline
    def get_endline(self):
        return self.endline
    def set_endline(self, endline):
        self.endline = endline
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='referenceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('referenceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'referenceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='referenceType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_, pretty_print=pretty_print)
        outfile.write(self.convert_unicode(self.valueOf_))
        outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='referenceType'):
        if self.refid is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            outfile.write(' refid=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.refid), input_name='refid')), ))
        if self.compoundref is not None and 'compoundref' not in already_processed:
            already_processed.add('compoundref')
            outfile.write(' compoundref=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.compoundref), input_name='compoundref')), ))
        if self.startline is not None and 'startline' not in already_processed:
            already_processed.add('startline')
            outfile.write(' startline="%s"' % self.gds_format_integer(self.startline, input_name='startline'))
        if self.endline is not None and 'endline' not in already_processed:
            already_processed.add('endline')
            outfile.write(' endline="%s"' % self.gds_format_integer(self.endline, input_name='endline'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='referenceType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refid', node)
        if value is not None and 'refid' not in already_processed:
            already_processed.add('refid')
            self.refid = value
        value = find_attr_value_('compoundref', node)
        if value is not None and 'compoundref' not in already_processed:
            already_processed.add('compoundref')
            self.compoundref = value
        value = find_attr_value_('startline', node)
        if value is not None and 'startline' not in already_processed:
            already_processed.add('startline')
            self.startline = self.gds_parse_integer(value, node, 'startline')
        value = find_attr_value_('endline', node)
        if value is not None and 'endline' not in already_processed:
            already_processed.add('endline')
            self.endline = self.gds_parse_integer(value, node, 'endline')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class referenceType


class locationType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, file=None, line=None, column=None, bodyfile=None, bodystart=None, bodyend=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.file = _cast(None, file)
        self.file_nsprefix_ = None
        self.line = _cast(int, line)
        self.line_nsprefix_ = None
        self.column = _cast(int, column)
        self.column_nsprefix_ = None
        self.bodyfile = _cast(None, bodyfile)
        self.bodyfile_nsprefix_ = None
        self.bodystart = _cast(int, bodystart)
        self.bodystart_nsprefix_ = None
        self.bodyend = _cast(int, bodyend)
        self.bodyend_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, locationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if locationType.subclass:
            return locationType.subclass(*args_, **kwargs_)
        return locationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_file(self):
        return self.file
    def set_file(self, file):
        self.file = file
    def get_line(self):
        return self.line
    def set_line(self, line):
        self.line = line
    def get_column(self):
        return self.column
    def set_column(self, column):
        self.column = column
    def get_bodyfile(self):
        return self.bodyfile
    def set_bodyfile(self, bodyfile):
        self.bodyfile = bodyfile
    def get_bodystart(self):
        return self.bodystart
    def set_bodystart(self, bodystart):
        self.bodystart = bodystart
    def get_bodyend(self):
        return self.bodyend
    def set_bodyend(self, bodyend):
        self.bodyend = bodyend
    def hasContent_(self):
        if (

        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='locationType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('locationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'locationType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='locationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='locationType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='locationType'):
        if self.file is not None and 'file' not in already_processed:
            already_processed.add('file')
            outfile.write(' file=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.file), input_name='file')), ))
        if self.line is not None and 'line' not in already_processed:
            already_processed.add('line')
            outfile.write(' line="%s"' % self.gds_format_integer(self.line, input_name='line'))
        if self.column is not None and 'column' not in already_processed:
            already_processed.add('column')
            outfile.write(' column="%s"' % self.gds_format_integer(self.column, input_name='column'))
        if self.bodyfile is not None and 'bodyfile' not in already_processed:
            already_processed.add('bodyfile')
            outfile.write(' bodyfile=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.bodyfile), input_name='bodyfile')), ))
        if self.bodystart is not None and 'bodystart' not in already_processed:
            already_processed.add('bodystart')
            outfile.write(' bodystart="%s"' % self.gds_format_integer(self.bodystart, input_name='bodystart'))
        if self.bodyend is not None and 'bodyend' not in already_processed:
            already_processed.add('bodyend')
            outfile.write(' bodyend="%s"' % self.gds_format_integer(self.bodyend, input_name='bodyend'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='locationType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('file', node)
        if value is not None and 'file' not in already_processed:
            already_processed.add('file')
            self.file = value
        value = find_attr_value_('line', node)
        if value is not None and 'line' not in already_processed:
            already_processed.add('line')
            self.line = self.gds_parse_integer(value, node, 'line')
        value = find_attr_value_('column', node)
        if value is not None and 'column' not in already_processed:
            already_processed.add('column')
            self.column = self.gds_parse_integer(value, node, 'column')
        value = find_attr_value_('bodyfile', node)
        if value is not None and 'bodyfile' not in already_processed:
            already_processed.add('bodyfile')
            self.bodyfile = value
        value = find_attr_value_('bodystart', node)
        if value is not None and 'bodystart' not in already_processed:
            already_processed.add('bodystart')
            self.bodystart = self.gds_parse_integer(value, node, 'bodystart')
        value = find_attr_value_('bodyend', node)
        if value is not None and 'bodyend' not in already_processed:
            already_processed.add('bodyend')
            self.bodyend = self.gds_parse_integer(value, node, 'bodyend')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class locationType


class docSect1Type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, title=None, para=None, sect2=None, internal=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if sect2 is None:
            self.sect2 = []
        else:
            self.sect2 = sect2
        self.sect2_nsprefix_ = None
        self.internal = internal
        self.internal_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docSect1Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docSect1Type.subclass:
            return docSect1Type.subclass(*args_, **kwargs_)
        return docSect1Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_sect2(self):
        return self.sect2
    def set_sect2(self, sect2):
        self.sect2 = sect2
    def add_sect2(self, value):
        self.sect2.append(value)
    def insert_sect2_at(self, index, value):
        self.sect2.insert(index, value)
    def replace_sect2_at(self, index, value):
        self.sect2[index] = value
    def get_internal(self):
        return self.internal
    def set_internal(self, internal):
        self.internal = internal
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.title is not None or
            self.para or
            self.sect2 or
            self.internal is not None or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docSect1Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docSect1Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docSect1Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docSect1Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docSect1Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docSect1Type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docSect1Type', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for sect2_ in self.sect2:
            namespaceprefix_ = self.sect2_nsprefix_ + ':' if (UseCapturedNS_ and self.sect2_nsprefix_) else ''
            sect2_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect2', pretty_print=pretty_print)
        if self.internal is not None:
            namespaceprefix_ = self.internal_nsprefix_ + ':' if (UseCapturedNS_ and self.internal_nsprefix_) else ''
            self.internal.export(outfile, level, namespaceprefix_, namespacedef_='', name_='internal', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'title')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'title')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'title', valuestr_)
            self.content_.append(obj_)
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'sect2':
            obj_ = docSect2Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect2', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect2'):
              self.add_sect2(obj_.value)
            elif hasattr(self, 'set_sect2'):
              self.set_sect2(obj_.value)
        elif nodeName_ == 'internal':
            obj_ = docInternalS1Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'internal', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_internal'):
              self.add_internal(obj_.value)
            elif hasattr(self, 'set_internal'):
              self.set_internal(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docSect1Type


class docSect2Type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, title=None, para=None, sect3=None, internal=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if sect3 is None:
            self.sect3 = []
        else:
            self.sect3 = sect3
        self.sect3_nsprefix_ = None
        self.internal = internal
        self.internal_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docSect2Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docSect2Type.subclass:
            return docSect2Type.subclass(*args_, **kwargs_)
        return docSect2Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_sect3(self):
        return self.sect3
    def set_sect3(self, sect3):
        self.sect3 = sect3
    def add_sect3(self, value):
        self.sect3.append(value)
    def insert_sect3_at(self, index, value):
        self.sect3.insert(index, value)
    def replace_sect3_at(self, index, value):
        self.sect3[index] = value
    def get_internal(self):
        return self.internal
    def set_internal(self, internal):
        self.internal = internal
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.title is not None or
            self.para or
            self.sect3 or
            self.internal is not None or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docSect2Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docSect2Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docSect2Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docSect2Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docSect2Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docSect2Type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docSect2Type', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for sect3_ in self.sect3:
            namespaceprefix_ = self.sect3_nsprefix_ + ':' if (UseCapturedNS_ and self.sect3_nsprefix_) else ''
            sect3_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect3', pretty_print=pretty_print)
        if self.internal is not None:
            namespaceprefix_ = self.internal_nsprefix_ + ':' if (UseCapturedNS_ and self.internal_nsprefix_) else ''
            self.internal.export(outfile, level, namespaceprefix_, namespacedef_='', name_='internal', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'title')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'title')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'title', valuestr_)
            self.content_.append(obj_)
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'sect3':
            obj_ = docSect3Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect3', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect3'):
              self.add_sect3(obj_.value)
            elif hasattr(self, 'set_sect3'):
              self.set_sect3(obj_.value)
        elif nodeName_ == 'internal':
            obj_ = docInternalS2Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'internal', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_internal'):
              self.add_internal(obj_.value)
            elif hasattr(self, 'set_internal'):
              self.set_internal(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docSect2Type


class docSect3Type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, title=None, para=None, sect4=None, internal=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if sect4 is None:
            self.sect4 = []
        else:
            self.sect4 = sect4
        self.sect4_nsprefix_ = None
        self.internal = internal
        self.internal_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docSect3Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docSect3Type.subclass:
            return docSect3Type.subclass(*args_, **kwargs_)
        return docSect3Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_sect4(self):
        return self.sect4
    def set_sect4(self, sect4):
        self.sect4 = sect4
    def add_sect4(self, value):
        self.sect4.append(value)
    def insert_sect4_at(self, index, value):
        self.sect4.insert(index, value)
    def replace_sect4_at(self, index, value):
        self.sect4[index] = value
    def get_internal(self):
        return self.internal
    def set_internal(self, internal):
        self.internal = internal
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.title is not None or
            self.para or
            self.sect4 or
            self.internal is not None or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docSect3Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docSect3Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docSect3Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docSect3Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docSect3Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docSect3Type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docSect3Type', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for sect4_ in self.sect4:
            namespaceprefix_ = self.sect4_nsprefix_ + ':' if (UseCapturedNS_ and self.sect4_nsprefix_) else ''
            sect4_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect4', pretty_print=pretty_print)
        if self.internal is not None:
            namespaceprefix_ = self.internal_nsprefix_ + ':' if (UseCapturedNS_ and self.internal_nsprefix_) else ''
            self.internal.export(outfile, level, namespaceprefix_, namespacedef_='', name_='internal', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'title')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'title')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'title', valuestr_)
            self.content_.append(obj_)
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'sect4':
            obj_ = docSect4Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect4', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect4'):
              self.add_sect4(obj_.value)
            elif hasattr(self, 'set_sect4'):
              self.set_sect4(obj_.value)
        elif nodeName_ == 'internal':
            obj_ = docInternalS3Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'internal', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_internal'):
              self.add_internal(obj_.value)
            elif hasattr(self, 'set_internal'):
              self.set_internal(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docSect3Type


class docSect4Type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, title=None, para=None, internal=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        self.internal = internal
        self.internal_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docSect4Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docSect4Type.subclass:
            return docSect4Type.subclass(*args_, **kwargs_)
        return docSect4Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_internal(self):
        return self.internal
    def set_internal(self, internal):
        self.internal = internal
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.title is not None or
            self.para or
            self.internal is not None or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docSect4Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docSect4Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docSect4Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docSect4Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docSect4Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docSect4Type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docSect4Type', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.title), input_name='title')), namespaceprefix_ , eol_))
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        if self.internal is not None:
            namespaceprefix_ = self.internal_nsprefix_ + ':' if (UseCapturedNS_ and self.internal_nsprefix_) else ''
            self.internal.export(outfile, level, namespaceprefix_, namespacedef_='', name_='internal', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'title' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'title')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'title')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'title', valuestr_)
            self.content_.append(obj_)
            self.title_nsprefix_ = child_.prefix
        elif nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'internal':
            obj_ = docInternalS4Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'internal', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_internal'):
              self.add_internal(obj_.value)
            elif hasattr(self, 'set_internal'):
              self.set_internal(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docSect4Type


class docInternalType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, para=None, sect1=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if sect1 is None:
            self.sect1 = []
        else:
            self.sect1 = sect1
        self.sect1_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docInternalType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docInternalType.subclass:
            return docInternalType.subclass(*args_, **kwargs_)
        return docInternalType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_sect1(self):
        return self.sect1
    def set_sect1(self, sect1):
        self.sect1 = sect1
    def add_sect1(self, value):
        self.sect1.append(value)
    def insert_sect1_at(self, index, value):
        self.sect1.insert(index, value)
    def replace_sect1_at(self, index, value):
        self.sect1[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.para or
            self.sect1 or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docInternalType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docInternalType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docInternalType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docInternalType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docInternalType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for sect1_ in self.sect1:
            namespaceprefix_ = self.sect1_nsprefix_ + ':' if (UseCapturedNS_ and self.sect1_nsprefix_) else ''
            sect1_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect1', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'sect1':
            obj_ = docSect1Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect1', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect1'):
              self.add_sect1(obj_.value)
            elif hasattr(self, 'set_sect1'):
              self.set_sect1(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docInternalType


class docInternalS1Type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, para=None, sect2=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if sect2 is None:
            self.sect2 = []
        else:
            self.sect2 = sect2
        self.sect2_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docInternalS1Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docInternalS1Type.subclass:
            return docInternalS1Type.subclass(*args_, **kwargs_)
        return docInternalS1Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_sect2(self):
        return self.sect2
    def set_sect2(self, sect2):
        self.sect2 = sect2
    def add_sect2(self, value):
        self.sect2.append(value)
    def insert_sect2_at(self, index, value):
        self.sect2.insert(index, value)
    def replace_sect2_at(self, index, value):
        self.sect2[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.para or
            self.sect2 or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalS1Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docInternalS1Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docInternalS1Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docInternalS1Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docInternalS1Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docInternalS1Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalS1Type', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for sect2_ in self.sect2:
            namespaceprefix_ = self.sect2_nsprefix_ + ':' if (UseCapturedNS_ and self.sect2_nsprefix_) else ''
            sect2_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect2', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'sect2':
            obj_ = docSect2Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect2', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect2'):
              self.add_sect2(obj_.value)
            elif hasattr(self, 'set_sect2'):
              self.set_sect2(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docInternalS1Type


class docInternalS2Type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, para=None, sect3=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if sect3 is None:
            self.sect3 = []
        else:
            self.sect3 = sect3
        self.sect3_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docInternalS2Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docInternalS2Type.subclass:
            return docInternalS2Type.subclass(*args_, **kwargs_)
        return docInternalS2Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_sect3(self):
        return self.sect3
    def set_sect3(self, sect3):
        self.sect3 = sect3
    def add_sect3(self, value):
        self.sect3.append(value)
    def insert_sect3_at(self, index, value):
        self.sect3.insert(index, value)
    def replace_sect3_at(self, index, value):
        self.sect3[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.para or
            self.sect3 or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalS2Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docInternalS2Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docInternalS2Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docInternalS2Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docInternalS2Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docInternalS2Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalS2Type', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for sect3_ in self.sect3:
            namespaceprefix_ = self.sect3_nsprefix_ + ':' if (UseCapturedNS_ and self.sect3_nsprefix_) else ''
            sect3_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect3', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'sect3':
            obj_ = docSect3Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect3', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect3'):
              self.add_sect3(obj_.value)
            elif hasattr(self, 'set_sect3'):
              self.set_sect3(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docInternalS2Type


class docInternalS3Type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, para=None, sect3=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        if sect3 is None:
            self.sect3 = []
        else:
            self.sect3 = sect3
        self.sect3_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docInternalS3Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docInternalS3Type.subclass:
            return docInternalS3Type.subclass(*args_, **kwargs_)
        return docInternalS3Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_sect3(self):
        return self.sect3
    def set_sect3(self, sect3):
        self.sect3 = sect3
    def add_sect3(self, value):
        self.sect3.append(value)
    def insert_sect3_at(self, index, value):
        self.sect3.insert(index, value)
    def replace_sect3_at(self, index, value):
        self.sect3[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.para or
            self.sect3 or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalS3Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docInternalS3Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docInternalS3Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docInternalS3Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docInternalS3Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docInternalS3Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalS3Type', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
        for sect3_ in self.sect3:
            namespaceprefix_ = self.sect3_nsprefix_ + ':' if (UseCapturedNS_ and self.sect3_nsprefix_) else ''
            sect3_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect3', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        elif nodeName_ == 'sect3':
            obj_ = docSect4Type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect3', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect3'):
              self.add_sect3(obj_.value)
            elif hasattr(self, 'set_sect3'):
              self.set_sect3(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docInternalS3Type


class docInternalS4Type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, para=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if para is None:
            self.para = []
        else:
            self.para = para
        self.para_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docInternalS4Type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docInternalS4Type.subclass:
            return docInternalS4Type.subclass(*args_, **kwargs_)
        return docInternalS4Type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_para(self):
        return self.para
    def set_para(self, para):
        self.para = para
    def add_para(self, value):
        self.para.append(value)
    def insert_para_at(self, index, value):
        self.para.insert(index, value)
    def replace_para_at(self, index, value):
        self.para[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.para or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalS4Type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docInternalS4Type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docInternalS4Type':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docInternalS4Type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docInternalS4Type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docInternalS4Type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docInternalS4Type', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for para_ in self.para:
            namespaceprefix_ = self.para_nsprefix_ + ':' if (UseCapturedNS_ and self.para_nsprefix_) else ''
            para_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='para', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'para':
            obj_ = docParaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'para', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_para'):
              self.add_para(obj_.value)
            elif hasattr(self, 'set_para'):
              self.set_para(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docInternalS4Type


class docTitleType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ulink=None, bold=None, emphasis=None, computeroutput=None, subscript=None, superscript=None, center=None, small=None, htmlonly=None, manonly=None, xmlonly=None, rtfonly=None, latexonly=None, dot=None, msc=None, anchor=None, formula=None, ref=None, copy=None, trademark=None, registered=None, lsquo=None, rsquo=None, ldquo=None, rdquo=None, ndash=None, mdash=None, umlaut=None, acute=None, grave=None, circ=None, slash=None, tilde=None, cedil=None, ring=None, szlig=None, nonbreakablespace=None, aelig=None, AElig=None, Gamma=None, Delta=None, Theta=None, Lambda=None, Xi=None, Pi=None, Sigma=None, Upsilon=None, Phi=None, Psi=None, Omega=None, alpha=None, beta=None, gamma=None, delta=None, epsilon=None, zeta=None, eta=None, theta=None, iota=None, kappa=None, lambda_=None, mu=None, nu=None, xi=None, pi=None, rho=None, sigma=None, tau=None, upsilon=None, phi=None, chi=None, psi=None, omega=None, sigmaf=None, sect=None, deg=None, prime=None, Prime=None, infin=None, empty=None, plusmn=None, times=None, minus=None, sdot=None, part=None, nabla=None, radic=None, perp=None, sum=None, int=None, prod=None, sim=None, asymp=None, ne=None, equiv=None, prop=None, le=None, ge=None, larr=None, rarr=None, isin=None, notin=None, lceil=None, rceil=None, lfloor=None, rfloor=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ulink is None:
            self.ulink = []
        else:
            self.ulink = ulink
        self.ulink_nsprefix_ = None
        if bold is None:
            self.bold = []
        else:
            self.bold = bold
        self.bold_nsprefix_ = None
        if emphasis is None:
            self.emphasis = []
        else:
            self.emphasis = emphasis
        self.emphasis_nsprefix_ = None
        if computeroutput is None:
            self.computeroutput = []
        else:
            self.computeroutput = computeroutput
        self.computeroutput_nsprefix_ = None
        if subscript is None:
            self.subscript = []
        else:
            self.subscript = subscript
        self.subscript_nsprefix_ = None
        if superscript is None:
            self.superscript = []
        else:
            self.superscript = superscript
        self.superscript_nsprefix_ = None
        if center is None:
            self.center = []
        else:
            self.center = center
        self.center_nsprefix_ = None
        if small is None:
            self.small = []
        else:
            self.small = small
        self.small_nsprefix_ = None
        if htmlonly is None:
            self.htmlonly = []
        else:
            self.htmlonly = htmlonly
        self.htmlonly_nsprefix_ = None
        if manonly is None:
            self.manonly = []
        else:
            self.manonly = manonly
        self.manonly_nsprefix_ = None
        if xmlonly is None:
            self.xmlonly = []
        else:
            self.xmlonly = xmlonly
        self.xmlonly_nsprefix_ = None
        if rtfonly is None:
            self.rtfonly = []
        else:
            self.rtfonly = rtfonly
        self.rtfonly_nsprefix_ = None
        if latexonly is None:
            self.latexonly = []
        else:
            self.latexonly = latexonly
        self.latexonly_nsprefix_ = None
        if dot is None:
            self.dot = []
        else:
            self.dot = dot
        self.dot_nsprefix_ = None
        if msc is None:
            self.msc = []
        else:
            self.msc = msc
        self.msc_nsprefix_ = None
        if anchor is None:
            self.anchor = []
        else:
            self.anchor = anchor
        self.anchor_nsprefix_ = None
        if formula is None:
            self.formula = []
        else:
            self.formula = formula
        self.formula_nsprefix_ = None
        if ref is None:
            self.ref = []
        else:
            self.ref = ref
        self.ref_nsprefix_ = None
        if copy is None:
            self.copy = []
        else:
            self.copy = copy
        self.copy_nsprefix_ = None
        if trademark is None:
            self.trademark = []
        else:
            self.trademark = trademark
        self.trademark_nsprefix_ = None
        if registered is None:
            self.registered = []
        else:
            self.registered = registered
        self.registered_nsprefix_ = None
        if lsquo is None:
            self.lsquo = []
        else:
            self.lsquo = lsquo
        self.lsquo_nsprefix_ = None
        if rsquo is None:
            self.rsquo = []
        else:
            self.rsquo = rsquo
        self.rsquo_nsprefix_ = None
        if ldquo is None:
            self.ldquo = []
        else:
            self.ldquo = ldquo
        self.ldquo_nsprefix_ = None
        if rdquo is None:
            self.rdquo = []
        else:
            self.rdquo = rdquo
        self.rdquo_nsprefix_ = None
        if ndash is None:
            self.ndash = []
        else:
            self.ndash = ndash
        self.ndash_nsprefix_ = None
        if mdash is None:
            self.mdash = []
        else:
            self.mdash = mdash
        self.mdash_nsprefix_ = None
        if umlaut is None:
            self.umlaut = []
        else:
            self.umlaut = umlaut
        self.umlaut_nsprefix_ = None
        if acute is None:
            self.acute = []
        else:
            self.acute = acute
        self.acute_nsprefix_ = None
        if grave is None:
            self.grave = []
        else:
            self.grave = grave
        self.grave_nsprefix_ = None
        if circ is None:
            self.circ = []
        else:
            self.circ = circ
        self.circ_nsprefix_ = None
        if slash is None:
            self.slash = []
        else:
            self.slash = slash
        self.slash_nsprefix_ = None
        if tilde is None:
            self.tilde = []
        else:
            self.tilde = tilde
        self.tilde_nsprefix_ = None
        if cedil is None:
            self.cedil = []
        else:
            self.cedil = cedil
        self.cedil_nsprefix_ = None
        if ring is None:
            self.ring = []
        else:
            self.ring = ring
        self.ring_nsprefix_ = None
        if szlig is None:
            self.szlig = []
        else:
            self.szlig = szlig
        self.szlig_nsprefix_ = None
        if nonbreakablespace is None:
            self.nonbreakablespace = []
        else:
            self.nonbreakablespace = nonbreakablespace
        self.nonbreakablespace_nsprefix_ = None
        if aelig is None:
            self.aelig = []
        else:
            self.aelig = aelig
        self.aelig_nsprefix_ = None
        if AElig is None:
            self.AElig = []
        else:
            self.AElig = AElig
        self.AElig_nsprefix_ = None
        if Gamma is None:
            self.Gamma = []
        else:
            self.Gamma = Gamma
        self.Gamma_nsprefix_ = None
        if Delta is None:
            self.Delta = []
        else:
            self.Delta = Delta
        self.Delta_nsprefix_ = None
        if Theta is None:
            self.Theta = []
        else:
            self.Theta = Theta
        self.Theta_nsprefix_ = None
        if Lambda is None:
            self.Lambda = []
        else:
            self.Lambda = Lambda
        self.Lambda_nsprefix_ = None
        if Xi is None:
            self.Xi = []
        else:
            self.Xi = Xi
        self.Xi_nsprefix_ = None
        if Pi is None:
            self.Pi = []
        else:
            self.Pi = Pi
        self.Pi_nsprefix_ = None
        if Sigma is None:
            self.Sigma = []
        else:
            self.Sigma = Sigma
        self.Sigma_nsprefix_ = None
        if Upsilon is None:
            self.Upsilon = []
        else:
            self.Upsilon = Upsilon
        self.Upsilon_nsprefix_ = None
        if Phi is None:
            self.Phi = []
        else:
            self.Phi = Phi
        self.Phi_nsprefix_ = None
        if Psi is None:
            self.Psi = []
        else:
            self.Psi = Psi
        self.Psi_nsprefix_ = None
        if Omega is None:
            self.Omega = []
        else:
            self.Omega = Omega
        self.Omega_nsprefix_ = None
        if alpha is None:
            self.alpha = []
        else:
            self.alpha = alpha
        self.alpha_nsprefix_ = None
        if beta is None:
            self.beta = []
        else:
            self.beta = beta
        self.beta_nsprefix_ = None
        if gamma is None:
            self.gamma = []
        else:
            self.gamma = gamma
        self.gamma_nsprefix_ = None
        if delta is None:
            self.delta = []
        else:
            self.delta = delta
        self.delta_nsprefix_ = None
        if epsilon is None:
            self.epsilon = []
        else:
            self.epsilon = epsilon
        self.epsilon_nsprefix_ = None
        if zeta is None:
            self.zeta = []
        else:
            self.zeta = zeta
        self.zeta_nsprefix_ = None
        if eta is None:
            self.eta = []
        else:
            self.eta = eta
        self.eta_nsprefix_ = None
        if theta is None:
            self.theta = []
        else:
            self.theta = theta
        self.theta_nsprefix_ = None
        if iota is None:
            self.iota = []
        else:
            self.iota = iota
        self.iota_nsprefix_ = None
        if kappa is None:
            self.kappa = []
        else:
            self.kappa = kappa
        self.kappa_nsprefix_ = None
        if lambda_ is None:
            self.lambda_ = []
        else:
            self.lambda_ = lambda_
        self.lambda__nsprefix_ = None
        if mu is None:
            self.mu = []
        else:
            self.mu = mu
        self.mu_nsprefix_ = None
        if nu is None:
            self.nu = []
        else:
            self.nu = nu
        self.nu_nsprefix_ = None
        if xi is None:
            self.xi = []
        else:
            self.xi = xi
        self.xi_nsprefix_ = None
        if pi is None:
            self.pi = []
        else:
            self.pi = pi
        self.pi_nsprefix_ = None
        if rho is None:
            self.rho = []
        else:
            self.rho = rho
        self.rho_nsprefix_ = None
        if sigma is None:
            self.sigma = []
        else:
            self.sigma = sigma
        self.sigma_nsprefix_ = None
        if tau is None:
            self.tau = []
        else:
            self.tau = tau
        self.tau_nsprefix_ = None
        if upsilon is None:
            self.upsilon = []
        else:
            self.upsilon = upsilon
        self.upsilon_nsprefix_ = None
        if phi is None:
            self.phi = []
        else:
            self.phi = phi
        self.phi_nsprefix_ = None
        if chi is None:
            self.chi = []
        else:
            self.chi = chi
        self.chi_nsprefix_ = None
        if psi is None:
            self.psi = []
        else:
            self.psi = psi
        self.psi_nsprefix_ = None
        if omega is None:
            self.omega = []
        else:
            self.omega = omega
        self.omega_nsprefix_ = None
        if sigmaf is None:
            self.sigmaf = []
        else:
            self.sigmaf = sigmaf
        self.sigmaf_nsprefix_ = None
        if sect is None:
            self.sect = []
        else:
            self.sect = sect
        self.sect_nsprefix_ = None
        if deg is None:
            self.deg = []
        else:
            self.deg = deg
        self.deg_nsprefix_ = None
        if prime is None:
            self.prime = []
        else:
            self.prime = prime
        self.prime_nsprefix_ = None
        if Prime is None:
            self.Prime = []
        else:
            self.Prime = Prime
        self.Prime_nsprefix_ = None
        if infin is None:
            self.infin = []
        else:
            self.infin = infin
        self.infin_nsprefix_ = None
        if empty is None:
            self.empty = []
        else:
            self.empty = empty
        self.empty_nsprefix_ = None
        if plusmn is None:
            self.plusmn = []
        else:
            self.plusmn = plusmn
        self.plusmn_nsprefix_ = None
        if times is None:
            self.times = []
        else:
            self.times = times
        self.times_nsprefix_ = None
        if minus is None:
            self.minus = []
        else:
            self.minus = minus
        self.minus_nsprefix_ = None
        if sdot is None:
            self.sdot = []
        else:
            self.sdot = sdot
        self.sdot_nsprefix_ = None
        if part is None:
            self.part = []
        else:
            self.part = part
        self.part_nsprefix_ = None
        if nabla is None:
            self.nabla = []
        else:
            self.nabla = nabla
        self.nabla_nsprefix_ = None
        if radic is None:
            self.radic = []
        else:
            self.radic = radic
        self.radic_nsprefix_ = None
        if perp is None:
            self.perp = []
        else:
            self.perp = perp
        self.perp_nsprefix_ = None
        if sum is None:
            self.sum = []
        else:
            self.sum = sum
        self.sum_nsprefix_ = None
        if int is None:
            self.int = []
        else:
            self.int = int
        self.int_nsprefix_ = None
        if prod is None:
            self.prod = []
        else:
            self.prod = prod
        self.prod_nsprefix_ = None
        if sim is None:
            self.sim = []
        else:
            self.sim = sim
        self.sim_nsprefix_ = None
        if asymp is None:
            self.asymp = []
        else:
            self.asymp = asymp
        self.asymp_nsprefix_ = None
        if ne is None:
            self.ne = []
        else:
            self.ne = ne
        self.ne_nsprefix_ = None
        if equiv is None:
            self.equiv = []
        else:
            self.equiv = equiv
        self.equiv_nsprefix_ = None
        if prop is None:
            self.prop = []
        else:
            self.prop = prop
        self.prop_nsprefix_ = None
        if le is None:
            self.le = []
        else:
            self.le = le
        self.le_nsprefix_ = None
        if ge is None:
            self.ge = []
        else:
            self.ge = ge
        self.ge_nsprefix_ = None
        if larr is None:
            self.larr = []
        else:
            self.larr = larr
        self.larr_nsprefix_ = None
        if rarr is None:
            self.rarr = []
        else:
            self.rarr = rarr
        self.rarr_nsprefix_ = None
        if isin is None:
            self.isin = []
        else:
            self.isin = isin
        self.isin_nsprefix_ = None
        if notin is None:
            self.notin = []
        else:
            self.notin = notin
        self.notin_nsprefix_ = None
        if lceil is None:
            self.lceil = []
        else:
            self.lceil = lceil
        self.lceil_nsprefix_ = None
        if rceil is None:
            self.rceil = []
        else:
            self.rceil = rceil
        self.rceil_nsprefix_ = None
        if lfloor is None:
            self.lfloor = []
        else:
            self.lfloor = lfloor
        self.lfloor_nsprefix_ = None
        if rfloor is None:
            self.rfloor = []
        else:
            self.rfloor = rfloor
        self.rfloor_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docTitleType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docTitleType.subclass:
            return docTitleType.subclass(*args_, **kwargs_)
        return docTitleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ulink(self):
        return self.ulink
    def set_ulink(self, ulink):
        self.ulink = ulink
    def add_ulink(self, value):
        self.ulink.append(value)
    def insert_ulink_at(self, index, value):
        self.ulink.insert(index, value)
    def replace_ulink_at(self, index, value):
        self.ulink[index] = value
    def get_bold(self):
        return self.bold
    def set_bold(self, bold):
        self.bold = bold
    def add_bold(self, value):
        self.bold.append(value)
    def insert_bold_at(self, index, value):
        self.bold.insert(index, value)
    def replace_bold_at(self, index, value):
        self.bold[index] = value
    def get_emphasis(self):
        return self.emphasis
    def set_emphasis(self, emphasis):
        self.emphasis = emphasis
    def add_emphasis(self, value):
        self.emphasis.append(value)
    def insert_emphasis_at(self, index, value):
        self.emphasis.insert(index, value)
    def replace_emphasis_at(self, index, value):
        self.emphasis[index] = value
    def get_computeroutput(self):
        return self.computeroutput
    def set_computeroutput(self, computeroutput):
        self.computeroutput = computeroutput
    def add_computeroutput(self, value):
        self.computeroutput.append(value)
    def insert_computeroutput_at(self, index, value):
        self.computeroutput.insert(index, value)
    def replace_computeroutput_at(self, index, value):
        self.computeroutput[index] = value
    def get_subscript(self):
        return self.subscript
    def set_subscript(self, subscript):
        self.subscript = subscript
    def add_subscript(self, value):
        self.subscript.append(value)
    def insert_subscript_at(self, index, value):
        self.subscript.insert(index, value)
    def replace_subscript_at(self, index, value):
        self.subscript[index] = value
    def get_superscript(self):
        return self.superscript
    def set_superscript(self, superscript):
        self.superscript = superscript
    def add_superscript(self, value):
        self.superscript.append(value)
    def insert_superscript_at(self, index, value):
        self.superscript.insert(index, value)
    def replace_superscript_at(self, index, value):
        self.superscript[index] = value
    def get_center(self):
        return self.center
    def set_center(self, center):
        self.center = center
    def add_center(self, value):
        self.center.append(value)
    def insert_center_at(self, index, value):
        self.center.insert(index, value)
    def replace_center_at(self, index, value):
        self.center[index] = value
    def get_small(self):
        return self.small
    def set_small(self, small):
        self.small = small
    def add_small(self, value):
        self.small.append(value)
    def insert_small_at(self, index, value):
        self.small.insert(index, value)
    def replace_small_at(self, index, value):
        self.small[index] = value
    def get_htmlonly(self):
        return self.htmlonly
    def set_htmlonly(self, htmlonly):
        self.htmlonly = htmlonly
    def add_htmlonly(self, value):
        self.htmlonly.append(value)
    def insert_htmlonly_at(self, index, value):
        self.htmlonly.insert(index, value)
    def replace_htmlonly_at(self, index, value):
        self.htmlonly[index] = value
    def get_manonly(self):
        return self.manonly
    def set_manonly(self, manonly):
        self.manonly = manonly
    def add_manonly(self, value):
        self.manonly.append(value)
    def insert_manonly_at(self, index, value):
        self.manonly.insert(index, value)
    def replace_manonly_at(self, index, value):
        self.manonly[index] = value
    def get_xmlonly(self):
        return self.xmlonly
    def set_xmlonly(self, xmlonly):
        self.xmlonly = xmlonly
    def add_xmlonly(self, value):
        self.xmlonly.append(value)
    def insert_xmlonly_at(self, index, value):
        self.xmlonly.insert(index, value)
    def replace_xmlonly_at(self, index, value):
        self.xmlonly[index] = value
    def get_rtfonly(self):
        return self.rtfonly
    def set_rtfonly(self, rtfonly):
        self.rtfonly = rtfonly
    def add_rtfonly(self, value):
        self.rtfonly.append(value)
    def insert_rtfonly_at(self, index, value):
        self.rtfonly.insert(index, value)
    def replace_rtfonly_at(self, index, value):
        self.rtfonly[index] = value
    def get_latexonly(self):
        return self.latexonly
    def set_latexonly(self, latexonly):
        self.latexonly = latexonly
    def add_latexonly(self, value):
        self.latexonly.append(value)
    def insert_latexonly_at(self, index, value):
        self.latexonly.insert(index, value)
    def replace_latexonly_at(self, index, value):
        self.latexonly[index] = value
    def get_dot(self):
        return self.dot
    def set_dot(self, dot):
        self.dot = dot
    def add_dot(self, value):
        self.dot.append(value)
    def insert_dot_at(self, index, value):
        self.dot.insert(index, value)
    def replace_dot_at(self, index, value):
        self.dot[index] = value
    def get_msc(self):
        return self.msc
    def set_msc(self, msc):
        self.msc = msc
    def add_msc(self, value):
        self.msc.append(value)
    def insert_msc_at(self, index, value):
        self.msc.insert(index, value)
    def replace_msc_at(self, index, value):
        self.msc[index] = value
    def get_anchor(self):
        return self.anchor
    def set_anchor(self, anchor):
        self.anchor = anchor
    def add_anchor(self, value):
        self.anchor.append(value)
    def insert_anchor_at(self, index, value):
        self.anchor.insert(index, value)
    def replace_anchor_at(self, index, value):
        self.anchor[index] = value
    def get_formula(self):
        return self.formula
    def set_formula(self, formula):
        self.formula = formula
    def add_formula(self, value):
        self.formula.append(value)
    def insert_formula_at(self, index, value):
        self.formula.insert(index, value)
    def replace_formula_at(self, index, value):
        self.formula[index] = value
    def get_ref(self):
        return self.ref
    def set_ref(self, ref):
        self.ref = ref
    def add_ref(self, value):
        self.ref.append(value)
    def insert_ref_at(self, index, value):
        self.ref.insert(index, value)
    def replace_ref_at(self, index, value):
        self.ref[index] = value
    def get_copy(self):
        return self.copy
    def set_copy(self, copy):
        self.copy = copy
    def add_copy(self, value):
        self.copy.append(value)
    def insert_copy_at(self, index, value):
        self.copy.insert(index, value)
    def replace_copy_at(self, index, value):
        self.copy[index] = value
    def get_trademark(self):
        return self.trademark
    def set_trademark(self, trademark):
        self.trademark = trademark
    def add_trademark(self, value):
        self.trademark.append(value)
    def insert_trademark_at(self, index, value):
        self.trademark.insert(index, value)
    def replace_trademark_at(self, index, value):
        self.trademark[index] = value
    def get_registered(self):
        return self.registered
    def set_registered(self, registered):
        self.registered = registered
    def add_registered(self, value):
        self.registered.append(value)
    def insert_registered_at(self, index, value):
        self.registered.insert(index, value)
    def replace_registered_at(self, index, value):
        self.registered[index] = value
    def get_lsquo(self):
        return self.lsquo
    def set_lsquo(self, lsquo):
        self.lsquo = lsquo
    def add_lsquo(self, value):
        self.lsquo.append(value)
    def insert_lsquo_at(self, index, value):
        self.lsquo.insert(index, value)
    def replace_lsquo_at(self, index, value):
        self.lsquo[index] = value
    def get_rsquo(self):
        return self.rsquo
    def set_rsquo(self, rsquo):
        self.rsquo = rsquo
    def add_rsquo(self, value):
        self.rsquo.append(value)
    def insert_rsquo_at(self, index, value):
        self.rsquo.insert(index, value)
    def replace_rsquo_at(self, index, value):
        self.rsquo[index] = value
    def get_ldquo(self):
        return self.ldquo
    def set_ldquo(self, ldquo):
        self.ldquo = ldquo
    def add_ldquo(self, value):
        self.ldquo.append(value)
    def insert_ldquo_at(self, index, value):
        self.ldquo.insert(index, value)
    def replace_ldquo_at(self, index, value):
        self.ldquo[index] = value
    def get_rdquo(self):
        return self.rdquo
    def set_rdquo(self, rdquo):
        self.rdquo = rdquo
    def add_rdquo(self, value):
        self.rdquo.append(value)
    def insert_rdquo_at(self, index, value):
        self.rdquo.insert(index, value)
    def replace_rdquo_at(self, index, value):
        self.rdquo[index] = value
    def get_ndash(self):
        return self.ndash
    def set_ndash(self, ndash):
        self.ndash = ndash
    def add_ndash(self, value):
        self.ndash.append(value)
    def insert_ndash_at(self, index, value):
        self.ndash.insert(index, value)
    def replace_ndash_at(self, index, value):
        self.ndash[index] = value
    def get_mdash(self):
        return self.mdash
    def set_mdash(self, mdash):
        self.mdash = mdash
    def add_mdash(self, value):
        self.mdash.append(value)
    def insert_mdash_at(self, index, value):
        self.mdash.insert(index, value)
    def replace_mdash_at(self, index, value):
        self.mdash[index] = value
    def get_umlaut(self):
        return self.umlaut
    def set_umlaut(self, umlaut):
        self.umlaut = umlaut
    def add_umlaut(self, value):
        self.umlaut.append(value)
    def insert_umlaut_at(self, index, value):
        self.umlaut.insert(index, value)
    def replace_umlaut_at(self, index, value):
        self.umlaut[index] = value
    def get_acute(self):
        return self.acute
    def set_acute(self, acute):
        self.acute = acute
    def add_acute(self, value):
        self.acute.append(value)
    def insert_acute_at(self, index, value):
        self.acute.insert(index, value)
    def replace_acute_at(self, index, value):
        self.acute[index] = value
    def get_grave(self):
        return self.grave
    def set_grave(self, grave):
        self.grave = grave
    def add_grave(self, value):
        self.grave.append(value)
    def insert_grave_at(self, index, value):
        self.grave.insert(index, value)
    def replace_grave_at(self, index, value):
        self.grave[index] = value
    def get_circ(self):
        return self.circ
    def set_circ(self, circ):
        self.circ = circ
    def add_circ(self, value):
        self.circ.append(value)
    def insert_circ_at(self, index, value):
        self.circ.insert(index, value)
    def replace_circ_at(self, index, value):
        self.circ[index] = value
    def get_slash(self):
        return self.slash
    def set_slash(self, slash):
        self.slash = slash
    def add_slash(self, value):
        self.slash.append(value)
    def insert_slash_at(self, index, value):
        self.slash.insert(index, value)
    def replace_slash_at(self, index, value):
        self.slash[index] = value
    def get_tilde(self):
        return self.tilde
    def set_tilde(self, tilde):
        self.tilde = tilde
    def add_tilde(self, value):
        self.tilde.append(value)
    def insert_tilde_at(self, index, value):
        self.tilde.insert(index, value)
    def replace_tilde_at(self, index, value):
        self.tilde[index] = value
    def get_cedil(self):
        return self.cedil
    def set_cedil(self, cedil):
        self.cedil = cedil
    def add_cedil(self, value):
        self.cedil.append(value)
    def insert_cedil_at(self, index, value):
        self.cedil.insert(index, value)
    def replace_cedil_at(self, index, value):
        self.cedil[index] = value
    def get_ring(self):
        return self.ring
    def set_ring(self, ring):
        self.ring = ring
    def add_ring(self, value):
        self.ring.append(value)
    def insert_ring_at(self, index, value):
        self.ring.insert(index, value)
    def replace_ring_at(self, index, value):
        self.ring[index] = value
    def get_szlig(self):
        return self.szlig
    def set_szlig(self, szlig):
        self.szlig = szlig
    def add_szlig(self, value):
        self.szlig.append(value)
    def insert_szlig_at(self, index, value):
        self.szlig.insert(index, value)
    def replace_szlig_at(self, index, value):
        self.szlig[index] = value
    def get_nonbreakablespace(self):
        return self.nonbreakablespace
    def set_nonbreakablespace(self, nonbreakablespace):
        self.nonbreakablespace = nonbreakablespace
    def add_nonbreakablespace(self, value):
        self.nonbreakablespace.append(value)
    def insert_nonbreakablespace_at(self, index, value):
        self.nonbreakablespace.insert(index, value)
    def replace_nonbreakablespace_at(self, index, value):
        self.nonbreakablespace[index] = value
    def get_aelig(self):
        return self.aelig
    def set_aelig(self, aelig):
        self.aelig = aelig
    def add_aelig(self, value):
        self.aelig.append(value)
    def insert_aelig_at(self, index, value):
        self.aelig.insert(index, value)
    def replace_aelig_at(self, index, value):
        self.aelig[index] = value
    def get_AElig(self):
        return self.AElig
    def set_AElig(self, AElig):
        self.AElig = AElig
    def add_AElig(self, value):
        self.AElig.append(value)
    def insert_AElig_at(self, index, value):
        self.AElig.insert(index, value)
    def replace_AElig_at(self, index, value):
        self.AElig[index] = value
    def get_Gamma(self):
        return self.Gamma
    def set_Gamma(self, Gamma):
        self.Gamma = Gamma
    def add_Gamma(self, value):
        self.Gamma.append(value)
    def insert_Gamma_at(self, index, value):
        self.Gamma.insert(index, value)
    def replace_Gamma_at(self, index, value):
        self.Gamma[index] = value
    def get_Delta(self):
        return self.Delta
    def set_Delta(self, Delta):
        self.Delta = Delta
    def add_Delta(self, value):
        self.Delta.append(value)
    def insert_Delta_at(self, index, value):
        self.Delta.insert(index, value)
    def replace_Delta_at(self, index, value):
        self.Delta[index] = value
    def get_Theta(self):
        return self.Theta
    def set_Theta(self, Theta):
        self.Theta = Theta
    def add_Theta(self, value):
        self.Theta.append(value)
    def insert_Theta_at(self, index, value):
        self.Theta.insert(index, value)
    def replace_Theta_at(self, index, value):
        self.Theta[index] = value
    def get_Lambda(self):
        return self.Lambda
    def set_Lambda(self, Lambda):
        self.Lambda = Lambda
    def add_Lambda(self, value):
        self.Lambda.append(value)
    def insert_Lambda_at(self, index, value):
        self.Lambda.insert(index, value)
    def replace_Lambda_at(self, index, value):
        self.Lambda[index] = value
    def get_Xi(self):
        return self.Xi
    def set_Xi(self, Xi):
        self.Xi = Xi
    def add_Xi(self, value):
        self.Xi.append(value)
    def insert_Xi_at(self, index, value):
        self.Xi.insert(index, value)
    def replace_Xi_at(self, index, value):
        self.Xi[index] = value
    def get_Pi(self):
        return self.Pi
    def set_Pi(self, Pi):
        self.Pi = Pi
    def add_Pi(self, value):
        self.Pi.append(value)
    def insert_Pi_at(self, index, value):
        self.Pi.insert(index, value)
    def replace_Pi_at(self, index, value):
        self.Pi[index] = value
    def get_Sigma(self):
        return self.Sigma
    def set_Sigma(self, Sigma):
        self.Sigma = Sigma
    def add_Sigma(self, value):
        self.Sigma.append(value)
    def insert_Sigma_at(self, index, value):
        self.Sigma.insert(index, value)
    def replace_Sigma_at(self, index, value):
        self.Sigma[index] = value
    def get_Upsilon(self):
        return self.Upsilon
    def set_Upsilon(self, Upsilon):
        self.Upsilon = Upsilon
    def add_Upsilon(self, value):
        self.Upsilon.append(value)
    def insert_Upsilon_at(self, index, value):
        self.Upsilon.insert(index, value)
    def replace_Upsilon_at(self, index, value):
        self.Upsilon[index] = value
    def get_Phi(self):
        return self.Phi
    def set_Phi(self, Phi):
        self.Phi = Phi
    def add_Phi(self, value):
        self.Phi.append(value)
    def insert_Phi_at(self, index, value):
        self.Phi.insert(index, value)
    def replace_Phi_at(self, index, value):
        self.Phi[index] = value
    def get_Psi(self):
        return self.Psi
    def set_Psi(self, Psi):
        self.Psi = Psi
    def add_Psi(self, value):
        self.Psi.append(value)
    def insert_Psi_at(self, index, value):
        self.Psi.insert(index, value)
    def replace_Psi_at(self, index, value):
        self.Psi[index] = value
    def get_Omega(self):
        return self.Omega
    def set_Omega(self, Omega):
        self.Omega = Omega
    def add_Omega(self, value):
        self.Omega.append(value)
    def insert_Omega_at(self, index, value):
        self.Omega.insert(index, value)
    def replace_Omega_at(self, index, value):
        self.Omega[index] = value
    def get_alpha(self):
        return self.alpha
    def set_alpha(self, alpha):
        self.alpha = alpha
    def add_alpha(self, value):
        self.alpha.append(value)
    def insert_alpha_at(self, index, value):
        self.alpha.insert(index, value)
    def replace_alpha_at(self, index, value):
        self.alpha[index] = value
    def get_beta(self):
        return self.beta
    def set_beta(self, beta):
        self.beta = beta
    def add_beta(self, value):
        self.beta.append(value)
    def insert_beta_at(self, index, value):
        self.beta.insert(index, value)
    def replace_beta_at(self, index, value):
        self.beta[index] = value
    def get_gamma(self):
        return self.gamma
    def set_gamma(self, gamma):
        self.gamma = gamma
    def add_gamma(self, value):
        self.gamma.append(value)
    def insert_gamma_at(self, index, value):
        self.gamma.insert(index, value)
    def replace_gamma_at(self, index, value):
        self.gamma[index] = value
    def get_delta(self):
        return self.delta
    def set_delta(self, delta):
        self.delta = delta
    def add_delta(self, value):
        self.delta.append(value)
    def insert_delta_at(self, index, value):
        self.delta.insert(index, value)
    def replace_delta_at(self, index, value):
        self.delta[index] = value
    def get_epsilon(self):
        return self.epsilon
    def set_epsilon(self, epsilon):
        self.epsilon = epsilon
    def add_epsilon(self, value):
        self.epsilon.append(value)
    def insert_epsilon_at(self, index, value):
        self.epsilon.insert(index, value)
    def replace_epsilon_at(self, index, value):
        self.epsilon[index] = value
    def get_zeta(self):
        return self.zeta
    def set_zeta(self, zeta):
        self.zeta = zeta
    def add_zeta(self, value):
        self.zeta.append(value)
    def insert_zeta_at(self, index, value):
        self.zeta.insert(index, value)
    def replace_zeta_at(self, index, value):
        self.zeta[index] = value
    def get_eta(self):
        return self.eta
    def set_eta(self, eta):
        self.eta = eta
    def add_eta(self, value):
        self.eta.append(value)
    def insert_eta_at(self, index, value):
        self.eta.insert(index, value)
    def replace_eta_at(self, index, value):
        self.eta[index] = value
    def get_theta(self):
        return self.theta
    def set_theta(self, theta):
        self.theta = theta
    def add_theta(self, value):
        self.theta.append(value)
    def insert_theta_at(self, index, value):
        self.theta.insert(index, value)
    def replace_theta_at(self, index, value):
        self.theta[index] = value
    def get_iota(self):
        return self.iota
    def set_iota(self, iota):
        self.iota = iota
    def add_iota(self, value):
        self.iota.append(value)
    def insert_iota_at(self, index, value):
        self.iota.insert(index, value)
    def replace_iota_at(self, index, value):
        self.iota[index] = value
    def get_kappa(self):
        return self.kappa
    def set_kappa(self, kappa):
        self.kappa = kappa
    def add_kappa(self, value):
        self.kappa.append(value)
    def insert_kappa_at(self, index, value):
        self.kappa.insert(index, value)
    def replace_kappa_at(self, index, value):
        self.kappa[index] = value
    def get_lambda(self):
        return self.lambda_
    def set_lambda(self, lambda_):
        self.lambda_ = lambda_
    def add_lambda(self, value):
        self.lambda_.append(value)
    def insert_lambda_at(self, index, value):
        self.lambda_.insert(index, value)
    def replace_lambda_at(self, index, value):
        self.lambda_[index] = value
    def get_mu(self):
        return self.mu
    def set_mu(self, mu):
        self.mu = mu
    def add_mu(self, value):
        self.mu.append(value)
    def insert_mu_at(self, index, value):
        self.mu.insert(index, value)
    def replace_mu_at(self, index, value):
        self.mu[index] = value
    def get_nu(self):
        return self.nu
    def set_nu(self, nu):
        self.nu = nu
    def add_nu(self, value):
        self.nu.append(value)
    def insert_nu_at(self, index, value):
        self.nu.insert(index, value)
    def replace_nu_at(self, index, value):
        self.nu[index] = value
    def get_xi(self):
        return self.xi
    def set_xi(self, xi):
        self.xi = xi
    def add_xi(self, value):
        self.xi.append(value)
    def insert_xi_at(self, index, value):
        self.xi.insert(index, value)
    def replace_xi_at(self, index, value):
        self.xi[index] = value
    def get_pi(self):
        return self.pi
    def set_pi(self, pi):
        self.pi = pi
    def add_pi(self, value):
        self.pi.append(value)
    def insert_pi_at(self, index, value):
        self.pi.insert(index, value)
    def replace_pi_at(self, index, value):
        self.pi[index] = value
    def get_rho(self):
        return self.rho
    def set_rho(self, rho):
        self.rho = rho
    def add_rho(self, value):
        self.rho.append(value)
    def insert_rho_at(self, index, value):
        self.rho.insert(index, value)
    def replace_rho_at(self, index, value):
        self.rho[index] = value
    def get_sigma(self):
        return self.sigma
    def set_sigma(self, sigma):
        self.sigma = sigma
    def add_sigma(self, value):
        self.sigma.append(value)
    def insert_sigma_at(self, index, value):
        self.sigma.insert(index, value)
    def replace_sigma_at(self, index, value):
        self.sigma[index] = value
    def get_tau(self):
        return self.tau
    def set_tau(self, tau):
        self.tau = tau
    def add_tau(self, value):
        self.tau.append(value)
    def insert_tau_at(self, index, value):
        self.tau.insert(index, value)
    def replace_tau_at(self, index, value):
        self.tau[index] = value
    def get_upsilon(self):
        return self.upsilon
    def set_upsilon(self, upsilon):
        self.upsilon = upsilon
    def add_upsilon(self, value):
        self.upsilon.append(value)
    def insert_upsilon_at(self, index, value):
        self.upsilon.insert(index, value)
    def replace_upsilon_at(self, index, value):
        self.upsilon[index] = value
    def get_phi(self):
        return self.phi
    def set_phi(self, phi):
        self.phi = phi
    def add_phi(self, value):
        self.phi.append(value)
    def insert_phi_at(self, index, value):
        self.phi.insert(index, value)
    def replace_phi_at(self, index, value):
        self.phi[index] = value
    def get_chi(self):
        return self.chi
    def set_chi(self, chi):
        self.chi = chi
    def add_chi(self, value):
        self.chi.append(value)
    def insert_chi_at(self, index, value):
        self.chi.insert(index, value)
    def replace_chi_at(self, index, value):
        self.chi[index] = value
    def get_psi(self):
        return self.psi
    def set_psi(self, psi):
        self.psi = psi
    def add_psi(self, value):
        self.psi.append(value)
    def insert_psi_at(self, index, value):
        self.psi.insert(index, value)
    def replace_psi_at(self, index, value):
        self.psi[index] = value
    def get_omega(self):
        return self.omega
    def set_omega(self, omega):
        self.omega = omega
    def add_omega(self, value):
        self.omega.append(value)
    def insert_omega_at(self, index, value):
        self.omega.insert(index, value)
    def replace_omega_at(self, index, value):
        self.omega[index] = value
    def get_sigmaf(self):
        return self.sigmaf
    def set_sigmaf(self, sigmaf):
        self.sigmaf = sigmaf
    def add_sigmaf(self, value):
        self.sigmaf.append(value)
    def insert_sigmaf_at(self, index, value):
        self.sigmaf.insert(index, value)
    def replace_sigmaf_at(self, index, value):
        self.sigmaf[index] = value
    def get_sect(self):
        return self.sect
    def set_sect(self, sect):
        self.sect = sect
    def add_sect(self, value):
        self.sect.append(value)
    def insert_sect_at(self, index, value):
        self.sect.insert(index, value)
    def replace_sect_at(self, index, value):
        self.sect[index] = value
    def get_deg(self):
        return self.deg
    def set_deg(self, deg):
        self.deg = deg
    def add_deg(self, value):
        self.deg.append(value)
    def insert_deg_at(self, index, value):
        self.deg.insert(index, value)
    def replace_deg_at(self, index, value):
        self.deg[index] = value
    def get_prime(self):
        return self.prime
    def set_prime(self, prime):
        self.prime = prime
    def add_prime(self, value):
        self.prime.append(value)
    def insert_prime_at(self, index, value):
        self.prime.insert(index, value)
    def replace_prime_at(self, index, value):
        self.prime[index] = value
    def get_Prime(self):
        return self.Prime
    def set_Prime(self, Prime):
        self.Prime = Prime
    def add_Prime(self, value):
        self.Prime.append(value)
    def insert_Prime_at(self, index, value):
        self.Prime.insert(index, value)
    def replace_Prime_at(self, index, value):
        self.Prime[index] = value
    def get_infin(self):
        return self.infin
    def set_infin(self, infin):
        self.infin = infin
    def add_infin(self, value):
        self.infin.append(value)
    def insert_infin_at(self, index, value):
        self.infin.insert(index, value)
    def replace_infin_at(self, index, value):
        self.infin[index] = value
    def get_empty(self):
        return self.empty
    def set_empty(self, empty):
        self.empty = empty
    def add_empty(self, value):
        self.empty.append(value)
    def insert_empty_at(self, index, value):
        self.empty.insert(index, value)
    def replace_empty_at(self, index, value):
        self.empty[index] = value
    def get_plusmn(self):
        return self.plusmn
    def set_plusmn(self, plusmn):
        self.plusmn = plusmn
    def add_plusmn(self, value):
        self.plusmn.append(value)
    def insert_plusmn_at(self, index, value):
        self.plusmn.insert(index, value)
    def replace_plusmn_at(self, index, value):
        self.plusmn[index] = value
    def get_times(self):
        return self.times
    def set_times(self, times):
        self.times = times
    def add_times(self, value):
        self.times.append(value)
    def insert_times_at(self, index, value):
        self.times.insert(index, value)
    def replace_times_at(self, index, value):
        self.times[index] = value
    def get_minus(self):
        return self.minus
    def set_minus(self, minus):
        self.minus = minus
    def add_minus(self, value):
        self.minus.append(value)
    def insert_minus_at(self, index, value):
        self.minus.insert(index, value)
    def replace_minus_at(self, index, value):
        self.minus[index] = value
    def get_sdot(self):
        return self.sdot
    def set_sdot(self, sdot):
        self.sdot = sdot
    def add_sdot(self, value):
        self.sdot.append(value)
    def insert_sdot_at(self, index, value):
        self.sdot.insert(index, value)
    def replace_sdot_at(self, index, value):
        self.sdot[index] = value
    def get_part(self):
        return self.part
    def set_part(self, part):
        self.part = part
    def add_part(self, value):
        self.part.append(value)
    def insert_part_at(self, index, value):
        self.part.insert(index, value)
    def replace_part_at(self, index, value):
        self.part[index] = value
    def get_nabla(self):
        return self.nabla
    def set_nabla(self, nabla):
        self.nabla = nabla
    def add_nabla(self, value):
        self.nabla.append(value)
    def insert_nabla_at(self, index, value):
        self.nabla.insert(index, value)
    def replace_nabla_at(self, index, value):
        self.nabla[index] = value
    def get_radic(self):
        return self.radic
    def set_radic(self, radic):
        self.radic = radic
    def add_radic(self, value):
        self.radic.append(value)
    def insert_radic_at(self, index, value):
        self.radic.insert(index, value)
    def replace_radic_at(self, index, value):
        self.radic[index] = value
    def get_perp(self):
        return self.perp
    def set_perp(self, perp):
        self.perp = perp
    def add_perp(self, value):
        self.perp.append(value)
    def insert_perp_at(self, index, value):
        self.perp.insert(index, value)
    def replace_perp_at(self, index, value):
        self.perp[index] = value
    def get_sum(self):
        return self.sum
    def set_sum(self, sum):
        self.sum = sum
    def add_sum(self, value):
        self.sum.append(value)
    def insert_sum_at(self, index, value):
        self.sum.insert(index, value)
    def replace_sum_at(self, index, value):
        self.sum[index] = value
    def get_int(self):
        return self.int
    def set_int(self, int):
        self.int = int
    def add_int(self, value):
        self.int.append(value)
    def insert_int_at(self, index, value):
        self.int.insert(index, value)
    def replace_int_at(self, index, value):
        self.int[index] = value
    def get_prod(self):
        return self.prod
    def set_prod(self, prod):
        self.prod = prod
    def add_prod(self, value):
        self.prod.append(value)
    def insert_prod_at(self, index, value):
        self.prod.insert(index, value)
    def replace_prod_at(self, index, value):
        self.prod[index] = value
    def get_sim(self):
        return self.sim
    def set_sim(self, sim):
        self.sim = sim
    def add_sim(self, value):
        self.sim.append(value)
    def insert_sim_at(self, index, value):
        self.sim.insert(index, value)
    def replace_sim_at(self, index, value):
        self.sim[index] = value
    def get_asymp(self):
        return self.asymp
    def set_asymp(self, asymp):
        self.asymp = asymp
    def add_asymp(self, value):
        self.asymp.append(value)
    def insert_asymp_at(self, index, value):
        self.asymp.insert(index, value)
    def replace_asymp_at(self, index, value):
        self.asymp[index] = value
    def get_ne(self):
        return self.ne
    def set_ne(self, ne):
        self.ne = ne
    def add_ne(self, value):
        self.ne.append(value)
    def insert_ne_at(self, index, value):
        self.ne.insert(index, value)
    def replace_ne_at(self, index, value):
        self.ne[index] = value
    def get_equiv(self):
        return self.equiv
    def set_equiv(self, equiv):
        self.equiv = equiv
    def add_equiv(self, value):
        self.equiv.append(value)
    def insert_equiv_at(self, index, value):
        self.equiv.insert(index, value)
    def replace_equiv_at(self, index, value):
        self.equiv[index] = value
    def get_prop(self):
        return self.prop
    def set_prop(self, prop):
        self.prop = prop
    def add_prop(self, value):
        self.prop.append(value)
    def insert_prop_at(self, index, value):
        self.prop.insert(index, value)
    def replace_prop_at(self, index, value):
        self.prop[index] = value
    def get_le(self):
        return self.le
    def set_le(self, le):
        self.le = le
    def add_le(self, value):
        self.le.append(value)
    def insert_le_at(self, index, value):
        self.le.insert(index, value)
    def replace_le_at(self, index, value):
        self.le[index] = value
    def get_ge(self):
        return self.ge
    def set_ge(self, ge):
        self.ge = ge
    def add_ge(self, value):
        self.ge.append(value)
    def insert_ge_at(self, index, value):
        self.ge.insert(index, value)
    def replace_ge_at(self, index, value):
        self.ge[index] = value
    def get_larr(self):
        return self.larr
    def set_larr(self, larr):
        self.larr = larr
    def add_larr(self, value):
        self.larr.append(value)
    def insert_larr_at(self, index, value):
        self.larr.insert(index, value)
    def replace_larr_at(self, index, value):
        self.larr[index] = value
    def get_rarr(self):
        return self.rarr
    def set_rarr(self, rarr):
        self.rarr = rarr
    def add_rarr(self, value):
        self.rarr.append(value)
    def insert_rarr_at(self, index, value):
        self.rarr.insert(index, value)
    def replace_rarr_at(self, index, value):
        self.rarr[index] = value
    def get_isin(self):
        return self.isin
    def set_isin(self, isin):
        self.isin = isin
    def add_isin(self, value):
        self.isin.append(value)
    def insert_isin_at(self, index, value):
        self.isin.insert(index, value)
    def replace_isin_at(self, index, value):
        self.isin[index] = value
    def get_notin(self):
        return self.notin
    def set_notin(self, notin):
        self.notin = notin
    def add_notin(self, value):
        self.notin.append(value)
    def insert_notin_at(self, index, value):
        self.notin.insert(index, value)
    def replace_notin_at(self, index, value):
        self.notin[index] = value
    def get_lceil(self):
        return self.lceil
    def set_lceil(self, lceil):
        self.lceil = lceil
    def add_lceil(self, value):
        self.lceil.append(value)
    def insert_lceil_at(self, index, value):
        self.lceil.insert(index, value)
    def replace_lceil_at(self, index, value):
        self.lceil[index] = value
    def get_rceil(self):
        return self.rceil
    def set_rceil(self, rceil):
        self.rceil = rceil
    def add_rceil(self, value):
        self.rceil.append(value)
    def insert_rceil_at(self, index, value):
        self.rceil.insert(index, value)
    def replace_rceil_at(self, index, value):
        self.rceil[index] = value
    def get_lfloor(self):
        return self.lfloor
    def set_lfloor(self, lfloor):
        self.lfloor = lfloor
    def add_lfloor(self, value):
        self.lfloor.append(value)
    def insert_lfloor_at(self, index, value):
        self.lfloor.insert(index, value)
    def replace_lfloor_at(self, index, value):
        self.lfloor[index] = value
    def get_rfloor(self):
        return self.rfloor
    def set_rfloor(self, rfloor):
        self.rfloor = rfloor
    def add_rfloor(self, value):
        self.rfloor.append(value)
    def insert_rfloor_at(self, index, value):
        self.rfloor.insert(index, value)
    def replace_rfloor_at(self, index, value):
        self.rfloor[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.ulink or
            self.bold or
            self.emphasis or
            self.computeroutput or
            self.subscript or
            self.superscript or
            self.center or
            self.small or
            self.htmlonly or
            self.manonly or
            self.xmlonly or
            self.rtfonly or
            self.latexonly or
            self.dot or
            self.msc or
            self.anchor or
            self.formula or
            self.ref or
            self.copy or
            self.trademark or
            self.registered or
            self.lsquo or
            self.rsquo or
            self.ldquo or
            self.rdquo or
            self.ndash or
            self.mdash or
            self.umlaut or
            self.acute or
            self.grave or
            self.circ or
            self.slash or
            self.tilde or
            self.cedil or
            self.ring or
            self.szlig or
            self.nonbreakablespace or
            self.aelig or
            self.AElig or
            self.Gamma or
            self.Delta or
            self.Theta or
            self.Lambda or
            self.Xi or
            self.Pi or
            self.Sigma or
            self.Upsilon or
            self.Phi or
            self.Psi or
            self.Omega or
            self.alpha or
            self.beta or
            self.gamma or
            self.delta or
            self.epsilon or
            self.zeta or
            self.eta or
            self.theta or
            self.iota or
            self.kappa or
            self.lambda_ or
            self.mu or
            self.nu or
            self.xi or
            self.pi or
            self.rho or
            self.sigma or
            self.tau or
            self.upsilon or
            self.phi or
            self.chi or
            self.psi or
            self.omega or
            self.sigmaf or
            self.sect or
            self.deg or
            self.prime or
            self.Prime or
            self.infin or
            self.empty or
            self.plusmn or
            self.times or
            self.minus or
            self.sdot or
            self.part or
            self.nabla or
            self.radic or
            self.perp or
            self.sum or
            self.int or
            self.prod or
            self.sim or
            self.asymp or
            self.ne or
            self.equiv or
            self.prop or
            self.le or
            self.ge or
            self.larr or
            self.rarr or
            self.isin or
            self.notin or
            self.lceil or
            self.rceil or
            self.lfloor or
            self.rfloor or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docTitleType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docTitleType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docTitleType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docTitleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docTitleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docTitleType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docTitleType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ulink_ in self.ulink:
            namespaceprefix_ = self.ulink_nsprefix_ + ':' if (UseCapturedNS_ and self.ulink_nsprefix_) else ''
            ulink_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ulink', pretty_print=pretty_print)
        for bold_ in self.bold:
            namespaceprefix_ = self.bold_nsprefix_ + ':' if (UseCapturedNS_ and self.bold_nsprefix_) else ''
            bold_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bold', pretty_print=pretty_print)
        for emphasis_ in self.emphasis:
            namespaceprefix_ = self.emphasis_nsprefix_ + ':' if (UseCapturedNS_ and self.emphasis_nsprefix_) else ''
            emphasis_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='emphasis', pretty_print=pretty_print)
        for computeroutput_ in self.computeroutput:
            namespaceprefix_ = self.computeroutput_nsprefix_ + ':' if (UseCapturedNS_ and self.computeroutput_nsprefix_) else ''
            computeroutput_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='computeroutput', pretty_print=pretty_print)
        for subscript_ in self.subscript:
            namespaceprefix_ = self.subscript_nsprefix_ + ':' if (UseCapturedNS_ and self.subscript_nsprefix_) else ''
            subscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subscript', pretty_print=pretty_print)
        for superscript_ in self.superscript:
            namespaceprefix_ = self.superscript_nsprefix_ + ':' if (UseCapturedNS_ and self.superscript_nsprefix_) else ''
            superscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='superscript', pretty_print=pretty_print)
        for center_ in self.center:
            namespaceprefix_ = self.center_nsprefix_ + ':' if (UseCapturedNS_ and self.center_nsprefix_) else ''
            center_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='center', pretty_print=pretty_print)
        for small_ in self.small:
            namespaceprefix_ = self.small_nsprefix_ + ':' if (UseCapturedNS_ and self.small_nsprefix_) else ''
            small_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='small', pretty_print=pretty_print)
        for htmlonly_ in self.htmlonly:
            namespaceprefix_ = self.htmlonly_nsprefix_ + ':' if (UseCapturedNS_ and self.htmlonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shtmlonly>%s</%shtmlonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(htmlonly_), input_name='htmlonly')), namespaceprefix_ , eol_))
        for manonly_ in self.manonly:
            namespaceprefix_ = self.manonly_nsprefix_ + ':' if (UseCapturedNS_ and self.manonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanonly>%s</%smanonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(manonly_), input_name='manonly')), namespaceprefix_ , eol_))
        for xmlonly_ in self.xmlonly:
            namespaceprefix_ = self.xmlonly_nsprefix_ + ':' if (UseCapturedNS_ and self.xmlonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxmlonly>%s</%sxmlonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(xmlonly_), input_name='xmlonly')), namespaceprefix_ , eol_))
        for rtfonly_ in self.rtfonly:
            namespaceprefix_ = self.rtfonly_nsprefix_ + ':' if (UseCapturedNS_ and self.rtfonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srtfonly>%s</%srtfonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(rtfonly_), input_name='rtfonly')), namespaceprefix_ , eol_))
        for latexonly_ in self.latexonly:
            namespaceprefix_ = self.latexonly_nsprefix_ + ':' if (UseCapturedNS_ and self.latexonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slatexonly>%s</%slatexonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(latexonly_), input_name='latexonly')), namespaceprefix_ , eol_))
        for dot_ in self.dot:
            namespaceprefix_ = self.dot_nsprefix_ + ':' if (UseCapturedNS_ and self.dot_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdot>%s</%sdot>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(dot_), input_name='dot')), namespaceprefix_ , eol_))
        for msc_ in self.msc:
            namespaceprefix_ = self.msc_nsprefix_ + ':' if (UseCapturedNS_ and self.msc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smsc>%s</%smsc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(msc_), input_name='msc')), namespaceprefix_ , eol_))
        for anchor_ in self.anchor:
            namespaceprefix_ = self.anchor_nsprefix_ + ':' if (UseCapturedNS_ and self.anchor_nsprefix_) else ''
            anchor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='anchor', pretty_print=pretty_print)
        for formula_ in self.formula:
            namespaceprefix_ = self.formula_nsprefix_ + ':' if (UseCapturedNS_ and self.formula_nsprefix_) else ''
            formula_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='formula', pretty_print=pretty_print)
        for ref_ in self.ref:
            namespaceprefix_ = self.ref_nsprefix_ + ':' if (UseCapturedNS_ and self.ref_nsprefix_) else ''
            ref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ref', pretty_print=pretty_print)
        for copy_ in self.copy:
            namespaceprefix_ = self.copy_nsprefix_ + ':' if (UseCapturedNS_ and self.copy_nsprefix_) else ''
            copy_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='copy', pretty_print=pretty_print)
        for trademark_ in self.trademark:
            namespaceprefix_ = self.trademark_nsprefix_ + ':' if (UseCapturedNS_ and self.trademark_nsprefix_) else ''
            trademark_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='trademark', pretty_print=pretty_print)
        for registered_ in self.registered:
            namespaceprefix_ = self.registered_nsprefix_ + ':' if (UseCapturedNS_ and self.registered_nsprefix_) else ''
            registered_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='registered', pretty_print=pretty_print)
        for lsquo_ in self.lsquo:
            namespaceprefix_ = self.lsquo_nsprefix_ + ':' if (UseCapturedNS_ and self.lsquo_nsprefix_) else ''
            lsquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lsquo', pretty_print=pretty_print)
        for rsquo_ in self.rsquo:
            namespaceprefix_ = self.rsquo_nsprefix_ + ':' if (UseCapturedNS_ and self.rsquo_nsprefix_) else ''
            rsquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rsquo', pretty_print=pretty_print)
        for ldquo_ in self.ldquo:
            namespaceprefix_ = self.ldquo_nsprefix_ + ':' if (UseCapturedNS_ and self.ldquo_nsprefix_) else ''
            ldquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ldquo', pretty_print=pretty_print)
        for rdquo_ in self.rdquo:
            namespaceprefix_ = self.rdquo_nsprefix_ + ':' if (UseCapturedNS_ and self.rdquo_nsprefix_) else ''
            rdquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rdquo', pretty_print=pretty_print)
        for ndash_ in self.ndash:
            namespaceprefix_ = self.ndash_nsprefix_ + ':' if (UseCapturedNS_ and self.ndash_nsprefix_) else ''
            ndash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ndash', pretty_print=pretty_print)
        for mdash_ in self.mdash:
            namespaceprefix_ = self.mdash_nsprefix_ + ':' if (UseCapturedNS_ and self.mdash_nsprefix_) else ''
            mdash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mdash', pretty_print=pretty_print)
        for umlaut_ in self.umlaut:
            namespaceprefix_ = self.umlaut_nsprefix_ + ':' if (UseCapturedNS_ and self.umlaut_nsprefix_) else ''
            umlaut_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='umlaut', pretty_print=pretty_print)
        for acute_ in self.acute:
            namespaceprefix_ = self.acute_nsprefix_ + ':' if (UseCapturedNS_ and self.acute_nsprefix_) else ''
            acute_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acute', pretty_print=pretty_print)
        for grave_ in self.grave:
            namespaceprefix_ = self.grave_nsprefix_ + ':' if (UseCapturedNS_ and self.grave_nsprefix_) else ''
            grave_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='grave', pretty_print=pretty_print)
        for circ_ in self.circ:
            namespaceprefix_ = self.circ_nsprefix_ + ':' if (UseCapturedNS_ and self.circ_nsprefix_) else ''
            circ_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='circ', pretty_print=pretty_print)
        for slash_ in self.slash:
            namespaceprefix_ = self.slash_nsprefix_ + ':' if (UseCapturedNS_ and self.slash_nsprefix_) else ''
            slash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='slash', pretty_print=pretty_print)
        for tilde_ in self.tilde:
            namespaceprefix_ = self.tilde_nsprefix_ + ':' if (UseCapturedNS_ and self.tilde_nsprefix_) else ''
            tilde_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tilde', pretty_print=pretty_print)
        for cedil_ in self.cedil:
            namespaceprefix_ = self.cedil_nsprefix_ + ':' if (UseCapturedNS_ and self.cedil_nsprefix_) else ''
            cedil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cedil', pretty_print=pretty_print)
        for ring_ in self.ring:
            namespaceprefix_ = self.ring_nsprefix_ + ':' if (UseCapturedNS_ and self.ring_nsprefix_) else ''
            ring_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ring', pretty_print=pretty_print)
        for szlig_ in self.szlig:
            namespaceprefix_ = self.szlig_nsprefix_ + ':' if (UseCapturedNS_ and self.szlig_nsprefix_) else ''
            szlig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='szlig', pretty_print=pretty_print)
        for nonbreakablespace_ in self.nonbreakablespace:
            namespaceprefix_ = self.nonbreakablespace_nsprefix_ + ':' if (UseCapturedNS_ and self.nonbreakablespace_nsprefix_) else ''
            nonbreakablespace_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nonbreakablespace', pretty_print=pretty_print)
        for aelig_ in self.aelig:
            namespaceprefix_ = self.aelig_nsprefix_ + ':' if (UseCapturedNS_ and self.aelig_nsprefix_) else ''
            aelig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='aelig', pretty_print=pretty_print)
        for AElig_ in self.AElig:
            namespaceprefix_ = self.AElig_nsprefix_ + ':' if (UseCapturedNS_ and self.AElig_nsprefix_) else ''
            AElig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AElig', pretty_print=pretty_print)
        for Gamma_ in self.Gamma:
            namespaceprefix_ = self.Gamma_nsprefix_ + ':' if (UseCapturedNS_ and self.Gamma_nsprefix_) else ''
            Gamma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Gamma', pretty_print=pretty_print)
        for Delta_ in self.Delta:
            namespaceprefix_ = self.Delta_nsprefix_ + ':' if (UseCapturedNS_ and self.Delta_nsprefix_) else ''
            Delta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Delta', pretty_print=pretty_print)
        for Theta_ in self.Theta:
            namespaceprefix_ = self.Theta_nsprefix_ + ':' if (UseCapturedNS_ and self.Theta_nsprefix_) else ''
            Theta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Theta', pretty_print=pretty_print)
        for Lambda_ in self.Lambda:
            namespaceprefix_ = self.Lambda_nsprefix_ + ':' if (UseCapturedNS_ and self.Lambda_nsprefix_) else ''
            Lambda_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Lambda', pretty_print=pretty_print)
        for Xi_ in self.Xi:
            namespaceprefix_ = self.Xi_nsprefix_ + ':' if (UseCapturedNS_ and self.Xi_nsprefix_) else ''
            Xi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Xi', pretty_print=pretty_print)
        for Pi_ in self.Pi:
            namespaceprefix_ = self.Pi_nsprefix_ + ':' if (UseCapturedNS_ and self.Pi_nsprefix_) else ''
            Pi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Pi', pretty_print=pretty_print)
        for Sigma_ in self.Sigma:
            namespaceprefix_ = self.Sigma_nsprefix_ + ':' if (UseCapturedNS_ and self.Sigma_nsprefix_) else ''
            Sigma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Sigma', pretty_print=pretty_print)
        for Upsilon_ in self.Upsilon:
            namespaceprefix_ = self.Upsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.Upsilon_nsprefix_) else ''
            Upsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Upsilon', pretty_print=pretty_print)
        for Phi_ in self.Phi:
            namespaceprefix_ = self.Phi_nsprefix_ + ':' if (UseCapturedNS_ and self.Phi_nsprefix_) else ''
            Phi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Phi', pretty_print=pretty_print)
        for Psi_ in self.Psi:
            namespaceprefix_ = self.Psi_nsprefix_ + ':' if (UseCapturedNS_ and self.Psi_nsprefix_) else ''
            Psi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Psi', pretty_print=pretty_print)
        for Omega_ in self.Omega:
            namespaceprefix_ = self.Omega_nsprefix_ + ':' if (UseCapturedNS_ and self.Omega_nsprefix_) else ''
            Omega_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Omega', pretty_print=pretty_print)
        for alpha_ in self.alpha:
            namespaceprefix_ = self.alpha_nsprefix_ + ':' if (UseCapturedNS_ and self.alpha_nsprefix_) else ''
            alpha_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alpha', pretty_print=pretty_print)
        for beta_ in self.beta:
            namespaceprefix_ = self.beta_nsprefix_ + ':' if (UseCapturedNS_ and self.beta_nsprefix_) else ''
            beta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='beta', pretty_print=pretty_print)
        for gamma_ in self.gamma:
            namespaceprefix_ = self.gamma_nsprefix_ + ':' if (UseCapturedNS_ and self.gamma_nsprefix_) else ''
            gamma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='gamma', pretty_print=pretty_print)
        for delta_ in self.delta:
            namespaceprefix_ = self.delta_nsprefix_ + ':' if (UseCapturedNS_ and self.delta_nsprefix_) else ''
            delta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='delta', pretty_print=pretty_print)
        for epsilon_ in self.epsilon:
            namespaceprefix_ = self.epsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.epsilon_nsprefix_) else ''
            epsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='epsilon', pretty_print=pretty_print)
        for zeta_ in self.zeta:
            namespaceprefix_ = self.zeta_nsprefix_ + ':' if (UseCapturedNS_ and self.zeta_nsprefix_) else ''
            zeta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='zeta', pretty_print=pretty_print)
        for eta_ in self.eta:
            namespaceprefix_ = self.eta_nsprefix_ + ':' if (UseCapturedNS_ and self.eta_nsprefix_) else ''
            eta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='eta', pretty_print=pretty_print)
        for theta_ in self.theta:
            namespaceprefix_ = self.theta_nsprefix_ + ':' if (UseCapturedNS_ and self.theta_nsprefix_) else ''
            theta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='theta', pretty_print=pretty_print)
        for iota_ in self.iota:
            namespaceprefix_ = self.iota_nsprefix_ + ':' if (UseCapturedNS_ and self.iota_nsprefix_) else ''
            iota_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='iota', pretty_print=pretty_print)
        for kappa_ in self.kappa:
            namespaceprefix_ = self.kappa_nsprefix_ + ':' if (UseCapturedNS_ and self.kappa_nsprefix_) else ''
            kappa_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='kappa', pretty_print=pretty_print)
        for lambda_ in self.lambda_:
            namespaceprefix_ = self.lambda__nsprefix_ + ':' if (UseCapturedNS_ and self.lambda__nsprefix_) else ''
            lambda_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lambda', pretty_print=pretty_print)
        for mu_ in self.mu:
            namespaceprefix_ = self.mu_nsprefix_ + ':' if (UseCapturedNS_ and self.mu_nsprefix_) else ''
            mu_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mu', pretty_print=pretty_print)
        for nu_ in self.nu:
            namespaceprefix_ = self.nu_nsprefix_ + ':' if (UseCapturedNS_ and self.nu_nsprefix_) else ''
            nu_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nu', pretty_print=pretty_print)
        for xi_ in self.xi:
            namespaceprefix_ = self.xi_nsprefix_ + ':' if (UseCapturedNS_ and self.xi_nsprefix_) else ''
            xi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='xi', pretty_print=pretty_print)
        for pi_ in self.pi:
            namespaceprefix_ = self.pi_nsprefix_ + ':' if (UseCapturedNS_ and self.pi_nsprefix_) else ''
            pi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pi', pretty_print=pretty_print)
        for rho_ in self.rho:
            namespaceprefix_ = self.rho_nsprefix_ + ':' if (UseCapturedNS_ and self.rho_nsprefix_) else ''
            rho_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rho', pretty_print=pretty_print)
        for sigma_ in self.sigma:
            namespaceprefix_ = self.sigma_nsprefix_ + ':' if (UseCapturedNS_ and self.sigma_nsprefix_) else ''
            sigma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sigma', pretty_print=pretty_print)
        for tau_ in self.tau:
            namespaceprefix_ = self.tau_nsprefix_ + ':' if (UseCapturedNS_ and self.tau_nsprefix_) else ''
            tau_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tau', pretty_print=pretty_print)
        for upsilon_ in self.upsilon:
            namespaceprefix_ = self.upsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.upsilon_nsprefix_) else ''
            upsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='upsilon', pretty_print=pretty_print)
        for phi_ in self.phi:
            namespaceprefix_ = self.phi_nsprefix_ + ':' if (UseCapturedNS_ and self.phi_nsprefix_) else ''
            phi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='phi', pretty_print=pretty_print)
        for chi_ in self.chi:
            namespaceprefix_ = self.chi_nsprefix_ + ':' if (UseCapturedNS_ and self.chi_nsprefix_) else ''
            chi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='chi', pretty_print=pretty_print)
        for psi_ in self.psi:
            namespaceprefix_ = self.psi_nsprefix_ + ':' if (UseCapturedNS_ and self.psi_nsprefix_) else ''
            psi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='psi', pretty_print=pretty_print)
        for omega_ in self.omega:
            namespaceprefix_ = self.omega_nsprefix_ + ':' if (UseCapturedNS_ and self.omega_nsprefix_) else ''
            omega_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='omega', pretty_print=pretty_print)
        for sigmaf_ in self.sigmaf:
            namespaceprefix_ = self.sigmaf_nsprefix_ + ':' if (UseCapturedNS_ and self.sigmaf_nsprefix_) else ''
            sigmaf_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sigmaf', pretty_print=pretty_print)
        for sect_ in self.sect:
            namespaceprefix_ = self.sect_nsprefix_ + ':' if (UseCapturedNS_ and self.sect_nsprefix_) else ''
            sect_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect', pretty_print=pretty_print)
        for deg_ in self.deg:
            namespaceprefix_ = self.deg_nsprefix_ + ':' if (UseCapturedNS_ and self.deg_nsprefix_) else ''
            deg_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='deg', pretty_print=pretty_print)
        for prime_ in self.prime:
            namespaceprefix_ = self.prime_nsprefix_ + ':' if (UseCapturedNS_ and self.prime_nsprefix_) else ''
            prime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prime', pretty_print=pretty_print)
        for Prime_ in self.Prime:
            namespaceprefix_ = self.Prime_nsprefix_ + ':' if (UseCapturedNS_ and self.Prime_nsprefix_) else ''
            Prime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Prime', pretty_print=pretty_print)
        for infin_ in self.infin:
            namespaceprefix_ = self.infin_nsprefix_ + ':' if (UseCapturedNS_ and self.infin_nsprefix_) else ''
            infin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infin', pretty_print=pretty_print)
        for empty_ in self.empty:
            namespaceprefix_ = self.empty_nsprefix_ + ':' if (UseCapturedNS_ and self.empty_nsprefix_) else ''
            empty_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='empty', pretty_print=pretty_print)
        for plusmn_ in self.plusmn:
            namespaceprefix_ = self.plusmn_nsprefix_ + ':' if (UseCapturedNS_ and self.plusmn_nsprefix_) else ''
            plusmn_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='plusmn', pretty_print=pretty_print)
        for times_ in self.times:
            namespaceprefix_ = self.times_nsprefix_ + ':' if (UseCapturedNS_ and self.times_nsprefix_) else ''
            times_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='times', pretty_print=pretty_print)
        for minus_ in self.minus:
            namespaceprefix_ = self.minus_nsprefix_ + ':' if (UseCapturedNS_ and self.minus_nsprefix_) else ''
            minus_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='minus', pretty_print=pretty_print)
        for sdot_ in self.sdot:
            namespaceprefix_ = self.sdot_nsprefix_ + ':' if (UseCapturedNS_ and self.sdot_nsprefix_) else ''
            sdot_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sdot', pretty_print=pretty_print)
        for part_ in self.part:
            namespaceprefix_ = self.part_nsprefix_ + ':' if (UseCapturedNS_ and self.part_nsprefix_) else ''
            part_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='part', pretty_print=pretty_print)
        for nabla_ in self.nabla:
            namespaceprefix_ = self.nabla_nsprefix_ + ':' if (UseCapturedNS_ and self.nabla_nsprefix_) else ''
            nabla_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nabla', pretty_print=pretty_print)
        for radic_ in self.radic:
            namespaceprefix_ = self.radic_nsprefix_ + ':' if (UseCapturedNS_ and self.radic_nsprefix_) else ''
            radic_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='radic', pretty_print=pretty_print)
        for perp_ in self.perp:
            namespaceprefix_ = self.perp_nsprefix_ + ':' if (UseCapturedNS_ and self.perp_nsprefix_) else ''
            perp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='perp', pretty_print=pretty_print)
        for sum_ in self.sum:
            namespaceprefix_ = self.sum_nsprefix_ + ':' if (UseCapturedNS_ and self.sum_nsprefix_) else ''
            sum_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sum', pretty_print=pretty_print)
        for int_ in self.int:
            namespaceprefix_ = self.int_nsprefix_ + ':' if (UseCapturedNS_ and self.int_nsprefix_) else ''
            int_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='int', pretty_print=pretty_print)
        for prod_ in self.prod:
            namespaceprefix_ = self.prod_nsprefix_ + ':' if (UseCapturedNS_ and self.prod_nsprefix_) else ''
            prod_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prod', pretty_print=pretty_print)
        for sim_ in self.sim:
            namespaceprefix_ = self.sim_nsprefix_ + ':' if (UseCapturedNS_ and self.sim_nsprefix_) else ''
            sim_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sim', pretty_print=pretty_print)
        for asymp_ in self.asymp:
            namespaceprefix_ = self.asymp_nsprefix_ + ':' if (UseCapturedNS_ and self.asymp_nsprefix_) else ''
            asymp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='asymp', pretty_print=pretty_print)
        for ne_ in self.ne:
            namespaceprefix_ = self.ne_nsprefix_ + ':' if (UseCapturedNS_ and self.ne_nsprefix_) else ''
            ne_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ne', pretty_print=pretty_print)
        for equiv_ in self.equiv:
            namespaceprefix_ = self.equiv_nsprefix_ + ':' if (UseCapturedNS_ and self.equiv_nsprefix_) else ''
            equiv_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='equiv', pretty_print=pretty_print)
        for prop_ in self.prop:
            namespaceprefix_ = self.prop_nsprefix_ + ':' if (UseCapturedNS_ and self.prop_nsprefix_) else ''
            prop_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prop', pretty_print=pretty_print)
        for le_ in self.le:
            namespaceprefix_ = self.le_nsprefix_ + ':' if (UseCapturedNS_ and self.le_nsprefix_) else ''
            le_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='le', pretty_print=pretty_print)
        for ge_ in self.ge:
            namespaceprefix_ = self.ge_nsprefix_ + ':' if (UseCapturedNS_ and self.ge_nsprefix_) else ''
            ge_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ge', pretty_print=pretty_print)
        for larr_ in self.larr:
            namespaceprefix_ = self.larr_nsprefix_ + ':' if (UseCapturedNS_ and self.larr_nsprefix_) else ''
            larr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='larr', pretty_print=pretty_print)
        for rarr_ in self.rarr:
            namespaceprefix_ = self.rarr_nsprefix_ + ':' if (UseCapturedNS_ and self.rarr_nsprefix_) else ''
            rarr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rarr', pretty_print=pretty_print)
        for isin_ in self.isin:
            namespaceprefix_ = self.isin_nsprefix_ + ':' if (UseCapturedNS_ and self.isin_nsprefix_) else ''
            isin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='isin', pretty_print=pretty_print)
        for notin_ in self.notin:
            namespaceprefix_ = self.notin_nsprefix_ + ':' if (UseCapturedNS_ and self.notin_nsprefix_) else ''
            notin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='notin', pretty_print=pretty_print)
        for lceil_ in self.lceil:
            namespaceprefix_ = self.lceil_nsprefix_ + ':' if (UseCapturedNS_ and self.lceil_nsprefix_) else ''
            lceil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lceil', pretty_print=pretty_print)
        for rceil_ in self.rceil:
            namespaceprefix_ = self.rceil_nsprefix_ + ':' if (UseCapturedNS_ and self.rceil_nsprefix_) else ''
            rceil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rceil', pretty_print=pretty_print)
        for lfloor_ in self.lfloor:
            namespaceprefix_ = self.lfloor_nsprefix_ + ':' if (UseCapturedNS_ and self.lfloor_nsprefix_) else ''
            lfloor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lfloor', pretty_print=pretty_print)
        for rfloor_ in self.rfloor:
            namespaceprefix_ = self.rfloor_nsprefix_ + ':' if (UseCapturedNS_ and self.rfloor_nsprefix_) else ''
            rfloor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rfloor', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ulink':
            obj_ = docURLLink.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ulink', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ulink'):
              self.add_ulink(obj_.value)
            elif hasattr(self, 'set_ulink'):
              self.set_ulink(obj_.value)
        elif nodeName_ == 'bold':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'bold', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_bold'):
              self.add_bold(obj_.value)
            elif hasattr(self, 'set_bold'):
              self.set_bold(obj_.value)
        elif nodeName_ == 'emphasis':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'emphasis', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_emphasis'):
              self.add_emphasis(obj_.value)
            elif hasattr(self, 'set_emphasis'):
              self.set_emphasis(obj_.value)
        elif nodeName_ == 'computeroutput':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'computeroutput', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_computeroutput'):
              self.add_computeroutput(obj_.value)
            elif hasattr(self, 'set_computeroutput'):
              self.set_computeroutput(obj_.value)
        elif nodeName_ == 'subscript':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'subscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_subscript'):
              self.add_subscript(obj_.value)
            elif hasattr(self, 'set_subscript'):
              self.set_subscript(obj_.value)
        elif nodeName_ == 'superscript':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'superscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_superscript'):
              self.add_superscript(obj_.value)
            elif hasattr(self, 'set_superscript'):
              self.set_superscript(obj_.value)
        elif nodeName_ == 'center':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'center', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_center'):
              self.add_center(obj_.value)
            elif hasattr(self, 'set_center'):
              self.set_center(obj_.value)
        elif nodeName_ == 'small':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'small', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_small'):
              self.add_small(obj_.value)
            elif hasattr(self, 'set_small'):
              self.set_small(obj_.value)
        elif nodeName_ == 'htmlonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'htmlonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'htmlonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'htmlonly', valuestr_)
            self.content_.append(obj_)
            self.htmlonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'manonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'manonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'manonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'manonly', valuestr_)
            self.content_.append(obj_)
            self.manonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'xmlonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'xmlonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'xmlonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'xmlonly', valuestr_)
            self.content_.append(obj_)
            self.xmlonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'rtfonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'rtfonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'rtfonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'rtfonly', valuestr_)
            self.content_.append(obj_)
            self.rtfonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'latexonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'latexonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'latexonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'latexonly', valuestr_)
            self.content_.append(obj_)
            self.latexonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'dot' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'dot')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'dot')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'dot', valuestr_)
            self.content_.append(obj_)
            self.dot_nsprefix_ = child_.prefix
        elif nodeName_ == 'msc' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'msc')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'msc')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'msc', valuestr_)
            self.content_.append(obj_)
            self.msc_nsprefix_ = child_.prefix
        elif nodeName_ == 'anchor':
            obj_ = docAnchorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'anchor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_anchor'):
              self.add_anchor(obj_.value)
            elif hasattr(self, 'set_anchor'):
              self.set_anchor(obj_.value)
        elif nodeName_ == 'formula':
            obj_ = docFormulaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'formula', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_formula'):
              self.add_formula(obj_.value)
            elif hasattr(self, 'set_formula'):
              self.set_formula(obj_.value)
        elif nodeName_ == 'ref':
            obj_ = docRefTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ref', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ref'):
              self.add_ref(obj_.value)
            elif hasattr(self, 'set_ref'):
              self.set_ref(obj_.value)
        elif nodeName_ == 'copy':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'copy', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_copy'):
              self.add_copy(obj_.value)
            elif hasattr(self, 'set_copy'):
              self.set_copy(obj_.value)
        elif nodeName_ == 'trademark':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'trademark', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_trademark'):
              self.add_trademark(obj_.value)
            elif hasattr(self, 'set_trademark'):
              self.set_trademark(obj_.value)
        elif nodeName_ == 'registered':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'registered', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_registered'):
              self.add_registered(obj_.value)
            elif hasattr(self, 'set_registered'):
              self.set_registered(obj_.value)
        elif nodeName_ == 'lsquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lsquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lsquo'):
              self.add_lsquo(obj_.value)
            elif hasattr(self, 'set_lsquo'):
              self.set_lsquo(obj_.value)
        elif nodeName_ == 'rsquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rsquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rsquo'):
              self.add_rsquo(obj_.value)
            elif hasattr(self, 'set_rsquo'):
              self.set_rsquo(obj_.value)
        elif nodeName_ == 'ldquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ldquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ldquo'):
              self.add_ldquo(obj_.value)
            elif hasattr(self, 'set_ldquo'):
              self.set_ldquo(obj_.value)
        elif nodeName_ == 'rdquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rdquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rdquo'):
              self.add_rdquo(obj_.value)
            elif hasattr(self, 'set_rdquo'):
              self.set_rdquo(obj_.value)
        elif nodeName_ == 'ndash':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ndash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ndash'):
              self.add_ndash(obj_.value)
            elif hasattr(self, 'set_ndash'):
              self.set_ndash(obj_.value)
        elif nodeName_ == 'mdash':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'mdash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_mdash'):
              self.add_mdash(obj_.value)
            elif hasattr(self, 'set_mdash'):
              self.set_mdash(obj_.value)
        elif nodeName_ == 'umlaut':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'umlaut', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_umlaut'):
              self.add_umlaut(obj_.value)
            elif hasattr(self, 'set_umlaut'):
              self.set_umlaut(obj_.value)
        elif nodeName_ == 'acute':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'acute', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_acute'):
              self.add_acute(obj_.value)
            elif hasattr(self, 'set_acute'):
              self.set_acute(obj_.value)
        elif nodeName_ == 'grave':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'grave', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_grave'):
              self.add_grave(obj_.value)
            elif hasattr(self, 'set_grave'):
              self.set_grave(obj_.value)
        elif nodeName_ == 'circ':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'circ', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_circ'):
              self.add_circ(obj_.value)
            elif hasattr(self, 'set_circ'):
              self.set_circ(obj_.value)
        elif nodeName_ == 'slash':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'slash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_slash'):
              self.add_slash(obj_.value)
            elif hasattr(self, 'set_slash'):
              self.set_slash(obj_.value)
        elif nodeName_ == 'tilde':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tilde', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tilde'):
              self.add_tilde(obj_.value)
            elif hasattr(self, 'set_tilde'):
              self.set_tilde(obj_.value)
        elif nodeName_ == 'cedil':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'cedil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_cedil'):
              self.add_cedil(obj_.value)
            elif hasattr(self, 'set_cedil'):
              self.set_cedil(obj_.value)
        elif nodeName_ == 'ring':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ring', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ring'):
              self.add_ring(obj_.value)
            elif hasattr(self, 'set_ring'):
              self.set_ring(obj_.value)
        elif nodeName_ == 'szlig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'szlig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_szlig'):
              self.add_szlig(obj_.value)
            elif hasattr(self, 'set_szlig'):
              self.set_szlig(obj_.value)
        elif nodeName_ == 'nonbreakablespace':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nonbreakablespace', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nonbreakablespace'):
              self.add_nonbreakablespace(obj_.value)
            elif hasattr(self, 'set_nonbreakablespace'):
              self.set_nonbreakablespace(obj_.value)
        elif nodeName_ == 'aelig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'aelig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_aelig'):
              self.add_aelig(obj_.value)
            elif hasattr(self, 'set_aelig'):
              self.set_aelig(obj_.value)
        elif nodeName_ == 'AElig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'AElig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_AElig'):
              self.add_AElig(obj_.value)
            elif hasattr(self, 'set_AElig'):
              self.set_AElig(obj_.value)
        elif nodeName_ == 'Gamma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Gamma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Gamma'):
              self.add_Gamma(obj_.value)
            elif hasattr(self, 'set_Gamma'):
              self.set_Gamma(obj_.value)
        elif nodeName_ == 'Delta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Delta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Delta'):
              self.add_Delta(obj_.value)
            elif hasattr(self, 'set_Delta'):
              self.set_Delta(obj_.value)
        elif nodeName_ == 'Theta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Theta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Theta'):
              self.add_Theta(obj_.value)
            elif hasattr(self, 'set_Theta'):
              self.set_Theta(obj_.value)
        elif nodeName_ == 'Lambda':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Lambda', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Lambda'):
              self.add_Lambda(obj_.value)
            elif hasattr(self, 'set_Lambda'):
              self.set_Lambda(obj_.value)
        elif nodeName_ == 'Xi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Xi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Xi'):
              self.add_Xi(obj_.value)
            elif hasattr(self, 'set_Xi'):
              self.set_Xi(obj_.value)
        elif nodeName_ == 'Pi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Pi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Pi'):
              self.add_Pi(obj_.value)
            elif hasattr(self, 'set_Pi'):
              self.set_Pi(obj_.value)
        elif nodeName_ == 'Sigma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Sigma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Sigma'):
              self.add_Sigma(obj_.value)
            elif hasattr(self, 'set_Sigma'):
              self.set_Sigma(obj_.value)
        elif nodeName_ == 'Upsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Upsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Upsilon'):
              self.add_Upsilon(obj_.value)
            elif hasattr(self, 'set_Upsilon'):
              self.set_Upsilon(obj_.value)
        elif nodeName_ == 'Phi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Phi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Phi'):
              self.add_Phi(obj_.value)
            elif hasattr(self, 'set_Phi'):
              self.set_Phi(obj_.value)
        elif nodeName_ == 'Psi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Psi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Psi'):
              self.add_Psi(obj_.value)
            elif hasattr(self, 'set_Psi'):
              self.set_Psi(obj_.value)
        elif nodeName_ == 'Omega':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Omega', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Omega'):
              self.add_Omega(obj_.value)
            elif hasattr(self, 'set_Omega'):
              self.set_Omega(obj_.value)
        elif nodeName_ == 'alpha':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'alpha', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_alpha'):
              self.add_alpha(obj_.value)
            elif hasattr(self, 'set_alpha'):
              self.set_alpha(obj_.value)
        elif nodeName_ == 'beta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'beta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_beta'):
              self.add_beta(obj_.value)
            elif hasattr(self, 'set_beta'):
              self.set_beta(obj_.value)
        elif nodeName_ == 'gamma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'gamma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_gamma'):
              self.add_gamma(obj_.value)
            elif hasattr(self, 'set_gamma'):
              self.set_gamma(obj_.value)
        elif nodeName_ == 'delta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'delta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_delta'):
              self.add_delta(obj_.value)
            elif hasattr(self, 'set_delta'):
              self.set_delta(obj_.value)
        elif nodeName_ == 'epsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'epsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_epsilon'):
              self.add_epsilon(obj_.value)
            elif hasattr(self, 'set_epsilon'):
              self.set_epsilon(obj_.value)
        elif nodeName_ == 'zeta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'zeta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_zeta'):
              self.add_zeta(obj_.value)
            elif hasattr(self, 'set_zeta'):
              self.set_zeta(obj_.value)
        elif nodeName_ == 'eta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'eta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_eta'):
              self.add_eta(obj_.value)
            elif hasattr(self, 'set_eta'):
              self.set_eta(obj_.value)
        elif nodeName_ == 'theta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'theta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_theta'):
              self.add_theta(obj_.value)
            elif hasattr(self, 'set_theta'):
              self.set_theta(obj_.value)
        elif nodeName_ == 'iota':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'iota', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_iota'):
              self.add_iota(obj_.value)
            elif hasattr(self, 'set_iota'):
              self.set_iota(obj_.value)
        elif nodeName_ == 'kappa':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'kappa', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_kappa'):
              self.add_kappa(obj_.value)
            elif hasattr(self, 'set_kappa'):
              self.set_kappa(obj_.value)
        elif nodeName_ == 'lambda':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lambda', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lambda'):
              self.add_lambda(obj_.value)
            elif hasattr(self, 'set_lambda'):
              self.set_lambda(obj_.value)
        elif nodeName_ == 'mu':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'mu', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_mu'):
              self.add_mu(obj_.value)
            elif hasattr(self, 'set_mu'):
              self.set_mu(obj_.value)
        elif nodeName_ == 'nu':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nu', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nu'):
              self.add_nu(obj_.value)
            elif hasattr(self, 'set_nu'):
              self.set_nu(obj_.value)
        elif nodeName_ == 'xi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'xi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_xi'):
              self.add_xi(obj_.value)
            elif hasattr(self, 'set_xi'):
              self.set_xi(obj_.value)
        elif nodeName_ == 'pi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'pi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_pi'):
              self.add_pi(obj_.value)
            elif hasattr(self, 'set_pi'):
              self.set_pi(obj_.value)
        elif nodeName_ == 'rho':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rho', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rho'):
              self.add_rho(obj_.value)
            elif hasattr(self, 'set_rho'):
              self.set_rho(obj_.value)
        elif nodeName_ == 'sigma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sigma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sigma'):
              self.add_sigma(obj_.value)
            elif hasattr(self, 'set_sigma'):
              self.set_sigma(obj_.value)
        elif nodeName_ == 'tau':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tau', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tau'):
              self.add_tau(obj_.value)
            elif hasattr(self, 'set_tau'):
              self.set_tau(obj_.value)
        elif nodeName_ == 'upsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'upsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_upsilon'):
              self.add_upsilon(obj_.value)
            elif hasattr(self, 'set_upsilon'):
              self.set_upsilon(obj_.value)
        elif nodeName_ == 'phi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'phi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_phi'):
              self.add_phi(obj_.value)
            elif hasattr(self, 'set_phi'):
              self.set_phi(obj_.value)
        elif nodeName_ == 'chi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'chi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_chi'):
              self.add_chi(obj_.value)
            elif hasattr(self, 'set_chi'):
              self.set_chi(obj_.value)
        elif nodeName_ == 'psi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'psi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_psi'):
              self.add_psi(obj_.value)
            elif hasattr(self, 'set_psi'):
              self.set_psi(obj_.value)
        elif nodeName_ == 'omega':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'omega', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_omega'):
              self.add_omega(obj_.value)
            elif hasattr(self, 'set_omega'):
              self.set_omega(obj_.value)
        elif nodeName_ == 'sigmaf':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sigmaf', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sigmaf'):
              self.add_sigmaf(obj_.value)
            elif hasattr(self, 'set_sigmaf'):
              self.set_sigmaf(obj_.value)
        elif nodeName_ == 'sect':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect'):
              self.add_sect(obj_.value)
            elif hasattr(self, 'set_sect'):
              self.set_sect(obj_.value)
        elif nodeName_ == 'deg':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'deg', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_deg'):
              self.add_deg(obj_.value)
            elif hasattr(self, 'set_deg'):
              self.set_deg(obj_.value)
        elif nodeName_ == 'prime':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'prime', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_prime'):
              self.add_prime(obj_.value)
            elif hasattr(self, 'set_prime'):
              self.set_prime(obj_.value)
        elif nodeName_ == 'Prime':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Prime', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Prime'):
              self.add_Prime(obj_.value)
            elif hasattr(self, 'set_Prime'):
              self.set_Prime(obj_.value)
        elif nodeName_ == 'infin':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'infin', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_infin'):
              self.add_infin(obj_.value)
            elif hasattr(self, 'set_infin'):
              self.set_infin(obj_.value)
        elif nodeName_ == 'empty':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'empty', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_empty'):
              self.add_empty(obj_.value)
            elif hasattr(self, 'set_empty'):
              self.set_empty(obj_.value)
        elif nodeName_ == 'plusmn':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'plusmn', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_plusmn'):
              self.add_plusmn(obj_.value)
            elif hasattr(self, 'set_plusmn'):
              self.set_plusmn(obj_.value)
        elif nodeName_ == 'times':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'times', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_times'):
              self.add_times(obj_.value)
            elif hasattr(self, 'set_times'):
              self.set_times(obj_.value)
        elif nodeName_ == 'minus':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'minus', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_minus'):
              self.add_minus(obj_.value)
            elif hasattr(self, 'set_minus'):
              self.set_minus(obj_.value)
        elif nodeName_ == 'sdot':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sdot', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sdot'):
              self.add_sdot(obj_.value)
            elif hasattr(self, 'set_sdot'):
              self.set_sdot(obj_.value)
        elif nodeName_ == 'part':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'part', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_part'):
              self.add_part(obj_.value)
            elif hasattr(self, 'set_part'):
              self.set_part(obj_.value)
        elif nodeName_ == 'nabla':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nabla', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nabla'):
              self.add_nabla(obj_.value)
            elif hasattr(self, 'set_nabla'):
              self.set_nabla(obj_.value)
        elif nodeName_ == 'radic':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'radic', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_radic'):
              self.add_radic(obj_.value)
            elif hasattr(self, 'set_radic'):
              self.set_radic(obj_.value)
        elif nodeName_ == 'perp':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'perp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_perp'):
              self.add_perp(obj_.value)
            elif hasattr(self, 'set_perp'):
              self.set_perp(obj_.value)
        elif nodeName_ == 'sum':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sum', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sum'):
              self.add_sum(obj_.value)
            elif hasattr(self, 'set_sum'):
              self.set_sum(obj_.value)
        elif nodeName_ == 'int':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'int', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_int'):
              self.add_int(obj_.value)
            elif hasattr(self, 'set_int'):
              self.set_int(obj_.value)
        elif nodeName_ == 'prod':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'prod', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_prod'):
              self.add_prod(obj_.value)
            elif hasattr(self, 'set_prod'):
              self.set_prod(obj_.value)
        elif nodeName_ == 'sim':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sim', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sim'):
              self.add_sim(obj_.value)
            elif hasattr(self, 'set_sim'):
              self.set_sim(obj_.value)
        elif nodeName_ == 'asymp':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'asymp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_asymp'):
              self.add_asymp(obj_.value)
            elif hasattr(self, 'set_asymp'):
              self.set_asymp(obj_.value)
        elif nodeName_ == 'ne':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ne', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ne'):
              self.add_ne(obj_.value)
            elif hasattr(self, 'set_ne'):
              self.set_ne(obj_.value)
        elif nodeName_ == 'equiv':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'equiv', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_equiv'):
              self.add_equiv(obj_.value)
            elif hasattr(self, 'set_equiv'):
              self.set_equiv(obj_.value)
        elif nodeName_ == 'prop':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'prop', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_prop'):
              self.add_prop(obj_.value)
            elif hasattr(self, 'set_prop'):
              self.set_prop(obj_.value)
        elif nodeName_ == 'le':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'le', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_le'):
              self.add_le(obj_.value)
            elif hasattr(self, 'set_le'):
              self.set_le(obj_.value)
        elif nodeName_ == 'ge':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ge', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ge'):
              self.add_ge(obj_.value)
            elif hasattr(self, 'set_ge'):
              self.set_ge(obj_.value)
        elif nodeName_ == 'larr':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'larr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_larr'):
              self.add_larr(obj_.value)
            elif hasattr(self, 'set_larr'):
              self.set_larr(obj_.value)
        elif nodeName_ == 'rarr':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rarr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rarr'):
              self.add_rarr(obj_.value)
            elif hasattr(self, 'set_rarr'):
              self.set_rarr(obj_.value)
        elif nodeName_ == 'isin':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'isin', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_isin'):
              self.add_isin(obj_.value)
            elif hasattr(self, 'set_isin'):
              self.set_isin(obj_.value)
        elif nodeName_ == 'notin':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'notin', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_notin'):
              self.add_notin(obj_.value)
            elif hasattr(self, 'set_notin'):
              self.set_notin(obj_.value)
        elif nodeName_ == 'lceil':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lceil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lceil'):
              self.add_lceil(obj_.value)
            elif hasattr(self, 'set_lceil'):
              self.set_lceil(obj_.value)
        elif nodeName_ == 'rceil':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rceil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rceil'):
              self.add_rceil(obj_.value)
            elif hasattr(self, 'set_rceil'):
              self.set_rceil(obj_.value)
        elif nodeName_ == 'lfloor':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lfloor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lfloor'):
              self.add_lfloor(obj_.value)
            elif hasattr(self, 'set_lfloor'):
              self.set_lfloor(obj_.value)
        elif nodeName_ == 'rfloor':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rfloor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rfloor'):
              self.add_rfloor(obj_.value)
            elif hasattr(self, 'set_rfloor'):
              self.set_rfloor(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docTitleType


class docParaType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ulink=None, bold=None, emphasis=None, computeroutput=None, subscript=None, superscript=None, center=None, small=None, htmlonly=None, manonly=None, xmlonly=None, rtfonly=None, latexonly=None, dot=None, msc=None, anchor=None, formula=None, ref=None, copy=None, trademark=None, registered=None, lsquo=None, rsquo=None, ldquo=None, rdquo=None, ndash=None, mdash=None, umlaut=None, acute=None, grave=None, circ=None, slash=None, tilde=None, cedil=None, ring=None, szlig=None, nonbreakablespace=None, aelig=None, AElig=None, Gamma=None, Delta=None, Theta=None, Lambda=None, Xi=None, Pi=None, Sigma=None, Upsilon=None, Phi=None, Psi=None, Omega=None, alpha=None, beta=None, gamma=None, delta=None, epsilon=None, zeta=None, eta=None, theta=None, iota=None, kappa=None, lambda_=None, mu=None, nu=None, xi=None, pi=None, rho=None, sigma=None, tau=None, upsilon=None, phi=None, chi=None, psi=None, omega=None, sigmaf=None, sect=None, deg=None, prime=None, Prime=None, infin=None, empty=None, plusmn=None, times=None, minus=None, sdot=None, part=None, nabla=None, radic=None, perp=None, sum=None, int=None, prod=None, sim=None, asymp=None, ne=None, equiv=None, prop=None, le=None, ge=None, larr=None, rarr=None, isin=None, notin=None, lceil=None, rceil=None, lfloor=None, rfloor=None, linebreak=None, hruler=None, preformatted=None, programlisting=None, verbatim=None, indexentry=None, orderedlist=None, itemizedlist=None, simplesect=None, title=None, variablelist=None, table=None, heading=None, image=None, dotfile=None, mscfile=None, diafile=None, toclist=None, language=None, parameterlist=None, xrefsect=None, copydoc=None, blockquote=None, parblock=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ulink is None:
            self.ulink = []
        else:
            self.ulink = ulink
        self.ulink_nsprefix_ = None
        if bold is None:
            self.bold = []
        else:
            self.bold = bold
        self.bold_nsprefix_ = None
        if emphasis is None:
            self.emphasis = []
        else:
            self.emphasis = emphasis
        self.emphasis_nsprefix_ = None
        if computeroutput is None:
            self.computeroutput = []
        else:
            self.computeroutput = computeroutput
        self.computeroutput_nsprefix_ = None
        if subscript is None:
            self.subscript = []
        else:
            self.subscript = subscript
        self.subscript_nsprefix_ = None
        if superscript is None:
            self.superscript = []
        else:
            self.superscript = superscript
        self.superscript_nsprefix_ = None
        if center is None:
            self.center = []
        else:
            self.center = center
        self.center_nsprefix_ = None
        if small is None:
            self.small = []
        else:
            self.small = small
        self.small_nsprefix_ = None
        if htmlonly is None:
            self.htmlonly = []
        else:
            self.htmlonly = htmlonly
        self.htmlonly_nsprefix_ = None
        if manonly is None:
            self.manonly = []
        else:
            self.manonly = manonly
        self.manonly_nsprefix_ = None
        if xmlonly is None:
            self.xmlonly = []
        else:
            self.xmlonly = xmlonly
        self.xmlonly_nsprefix_ = None
        if rtfonly is None:
            self.rtfonly = []
        else:
            self.rtfonly = rtfonly
        self.rtfonly_nsprefix_ = None
        if latexonly is None:
            self.latexonly = []
        else:
            self.latexonly = latexonly
        self.latexonly_nsprefix_ = None
        if dot is None:
            self.dot = []
        else:
            self.dot = dot
        self.dot_nsprefix_ = None
        if msc is None:
            self.msc = []
        else:
            self.msc = msc
        self.msc_nsprefix_ = None
        if anchor is None:
            self.anchor = []
        else:
            self.anchor = anchor
        self.anchor_nsprefix_ = None
        if formula is None:
            self.formula = []
        else:
            self.formula = formula
        self.formula_nsprefix_ = None
        if ref is None:
            self.ref = []
        else:
            self.ref = ref
        self.ref_nsprefix_ = None
        if copy is None:
            self.copy = []
        else:
            self.copy = copy
        self.copy_nsprefix_ = None
        if trademark is None:
            self.trademark = []
        else:
            self.trademark = trademark
        self.trademark_nsprefix_ = None
        if registered is None:
            self.registered = []
        else:
            self.registered = registered
        self.registered_nsprefix_ = None
        if lsquo is None:
            self.lsquo = []
        else:
            self.lsquo = lsquo
        self.lsquo_nsprefix_ = None
        if rsquo is None:
            self.rsquo = []
        else:
            self.rsquo = rsquo
        self.rsquo_nsprefix_ = None
        if ldquo is None:
            self.ldquo = []
        else:
            self.ldquo = ldquo
        self.ldquo_nsprefix_ = None
        if rdquo is None:
            self.rdquo = []
        else:
            self.rdquo = rdquo
        self.rdquo_nsprefix_ = None
        if ndash is None:
            self.ndash = []
        else:
            self.ndash = ndash
        self.ndash_nsprefix_ = None
        if mdash is None:
            self.mdash = []
        else:
            self.mdash = mdash
        self.mdash_nsprefix_ = None
        if umlaut is None:
            self.umlaut = []
        else:
            self.umlaut = umlaut
        self.umlaut_nsprefix_ = None
        if acute is None:
            self.acute = []
        else:
            self.acute = acute
        self.acute_nsprefix_ = None
        if grave is None:
            self.grave = []
        else:
            self.grave = grave
        self.grave_nsprefix_ = None
        if circ is None:
            self.circ = []
        else:
            self.circ = circ
        self.circ_nsprefix_ = None
        if slash is None:
            self.slash = []
        else:
            self.slash = slash
        self.slash_nsprefix_ = None
        if tilde is None:
            self.tilde = []
        else:
            self.tilde = tilde
        self.tilde_nsprefix_ = None
        if cedil is None:
            self.cedil = []
        else:
            self.cedil = cedil
        self.cedil_nsprefix_ = None
        if ring is None:
            self.ring = []
        else:
            self.ring = ring
        self.ring_nsprefix_ = None
        if szlig is None:
            self.szlig = []
        else:
            self.szlig = szlig
        self.szlig_nsprefix_ = None
        if nonbreakablespace is None:
            self.nonbreakablespace = []
        else:
            self.nonbreakablespace = nonbreakablespace
        self.nonbreakablespace_nsprefix_ = None
        if aelig is None:
            self.aelig = []
        else:
            self.aelig = aelig
        self.aelig_nsprefix_ = None
        if AElig is None:
            self.AElig = []
        else:
            self.AElig = AElig
        self.AElig_nsprefix_ = None
        if Gamma is None:
            self.Gamma = []
        else:
            self.Gamma = Gamma
        self.Gamma_nsprefix_ = None
        if Delta is None:
            self.Delta = []
        else:
            self.Delta = Delta
        self.Delta_nsprefix_ = None
        if Theta is None:
            self.Theta = []
        else:
            self.Theta = Theta
        self.Theta_nsprefix_ = None
        if Lambda is None:
            self.Lambda = []
        else:
            self.Lambda = Lambda
        self.Lambda_nsprefix_ = None
        if Xi is None:
            self.Xi = []
        else:
            self.Xi = Xi
        self.Xi_nsprefix_ = None
        if Pi is None:
            self.Pi = []
        else:
            self.Pi = Pi
        self.Pi_nsprefix_ = None
        if Sigma is None:
            self.Sigma = []
        else:
            self.Sigma = Sigma
        self.Sigma_nsprefix_ = None
        if Upsilon is None:
            self.Upsilon = []
        else:
            self.Upsilon = Upsilon
        self.Upsilon_nsprefix_ = None
        if Phi is None:
            self.Phi = []
        else:
            self.Phi = Phi
        self.Phi_nsprefix_ = None
        if Psi is None:
            self.Psi = []
        else:
            self.Psi = Psi
        self.Psi_nsprefix_ = None
        if Omega is None:
            self.Omega = []
        else:
            self.Omega = Omega
        self.Omega_nsprefix_ = None
        if alpha is None:
            self.alpha = []
        else:
            self.alpha = alpha
        self.alpha_nsprefix_ = None
        if beta is None:
            self.beta = []
        else:
            self.beta = beta
        self.beta_nsprefix_ = None
        if gamma is None:
            self.gamma = []
        else:
            self.gamma = gamma
        self.gamma_nsprefix_ = None
        if delta is None:
            self.delta = []
        else:
            self.delta = delta
        self.delta_nsprefix_ = None
        if epsilon is None:
            self.epsilon = []
        else:
            self.epsilon = epsilon
        self.epsilon_nsprefix_ = None
        if zeta is None:
            self.zeta = []
        else:
            self.zeta = zeta
        self.zeta_nsprefix_ = None
        if eta is None:
            self.eta = []
        else:
            self.eta = eta
        self.eta_nsprefix_ = None
        if theta is None:
            self.theta = []
        else:
            self.theta = theta
        self.theta_nsprefix_ = None
        if iota is None:
            self.iota = []
        else:
            self.iota = iota
        self.iota_nsprefix_ = None
        if kappa is None:
            self.kappa = []
        else:
            self.kappa = kappa
        self.kappa_nsprefix_ = None
        if lambda_ is None:
            self.lambda_ = []
        else:
            self.lambda_ = lambda_
        self.lambda__nsprefix_ = None
        if mu is None:
            self.mu = []
        else:
            self.mu = mu
        self.mu_nsprefix_ = None
        if nu is None:
            self.nu = []
        else:
            self.nu = nu
        self.nu_nsprefix_ = None
        if xi is None:
            self.xi = []
        else:
            self.xi = xi
        self.xi_nsprefix_ = None
        if pi is None:
            self.pi = []
        else:
            self.pi = pi
        self.pi_nsprefix_ = None
        if rho is None:
            self.rho = []
        else:
            self.rho = rho
        self.rho_nsprefix_ = None
        if sigma is None:
            self.sigma = []
        else:
            self.sigma = sigma
        self.sigma_nsprefix_ = None
        if tau is None:
            self.tau = []
        else:
            self.tau = tau
        self.tau_nsprefix_ = None
        if upsilon is None:
            self.upsilon = []
        else:
            self.upsilon = upsilon
        self.upsilon_nsprefix_ = None
        if phi is None:
            self.phi = []
        else:
            self.phi = phi
        self.phi_nsprefix_ = None
        if chi is None:
            self.chi = []
        else:
            self.chi = chi
        self.chi_nsprefix_ = None
        if psi is None:
            self.psi = []
        else:
            self.psi = psi
        self.psi_nsprefix_ = None
        if omega is None:
            self.omega = []
        else:
            self.omega = omega
        self.omega_nsprefix_ = None
        if sigmaf is None:
            self.sigmaf = []
        else:
            self.sigmaf = sigmaf
        self.sigmaf_nsprefix_ = None
        if sect is None:
            self.sect = []
        else:
            self.sect = sect
        self.sect_nsprefix_ = None
        if deg is None:
            self.deg = []
        else:
            self.deg = deg
        self.deg_nsprefix_ = None
        if prime is None:
            self.prime = []
        else:
            self.prime = prime
        self.prime_nsprefix_ = None
        if Prime is None:
            self.Prime = []
        else:
            self.Prime = Prime
        self.Prime_nsprefix_ = None
        if infin is None:
            self.infin = []
        else:
            self.infin = infin
        self.infin_nsprefix_ = None
        if empty is None:
            self.empty = []
        else:
            self.empty = empty
        self.empty_nsprefix_ = None
        if plusmn is None:
            self.plusmn = []
        else:
            self.plusmn = plusmn
        self.plusmn_nsprefix_ = None
        if times is None:
            self.times = []
        else:
            self.times = times
        self.times_nsprefix_ = None
        if minus is None:
            self.minus = []
        else:
            self.minus = minus
        self.minus_nsprefix_ = None
        if sdot is None:
            self.sdot = []
        else:
            self.sdot = sdot
        self.sdot_nsprefix_ = None
        if part is None:
            self.part = []
        else:
            self.part = part
        self.part_nsprefix_ = None
        if nabla is None:
            self.nabla = []
        else:
            self.nabla = nabla
        self.nabla_nsprefix_ = None
        if radic is None:
            self.radic = []
        else:
            self.radic = radic
        self.radic_nsprefix_ = None
        if perp is None:
            self.perp = []
        else:
            self.perp = perp
        self.perp_nsprefix_ = None
        if sum is None:
            self.sum = []
        else:
            self.sum = sum
        self.sum_nsprefix_ = None
        if int is None:
            self.int = []
        else:
            self.int = int
        self.int_nsprefix_ = None
        if prod is None:
            self.prod = []
        else:
            self.prod = prod
        self.prod_nsprefix_ = None
        if sim is None:
            self.sim = []
        else:
            self.sim = sim
        self.sim_nsprefix_ = None
        if asymp is None:
            self.asymp = []
        else:
            self.asymp = asymp
        self.asymp_nsprefix_ = None
        if ne is None:
            self.ne = []
        else:
            self.ne = ne
        self.ne_nsprefix_ = None
        if equiv is None:
            self.equiv = []
        else:
            self.equiv = equiv
        self.equiv_nsprefix_ = None
        if prop is None:
            self.prop = []
        else:
            self.prop = prop
        self.prop_nsprefix_ = None
        if le is None:
            self.le = []
        else:
            self.le = le
        self.le_nsprefix_ = None
        if ge is None:
            self.ge = []
        else:
            self.ge = ge
        self.ge_nsprefix_ = None
        if larr is None:
            self.larr = []
        else:
            self.larr = larr
        self.larr_nsprefix_ = None
        if rarr is None:
            self.rarr = []
        else:
            self.rarr = rarr
        self.rarr_nsprefix_ = None
        if isin is None:
            self.isin = []
        else:
            self.isin = isin
        self.isin_nsprefix_ = None
        if notin is None:
            self.notin = []
        else:
            self.notin = notin
        self.notin_nsprefix_ = None
        if lceil is None:
            self.lceil = []
        else:
            self.lceil = lceil
        self.lceil_nsprefix_ = None
        if rceil is None:
            self.rceil = []
        else:
            self.rceil = rceil
        self.rceil_nsprefix_ = None
        if lfloor is None:
            self.lfloor = []
        else:
            self.lfloor = lfloor
        self.lfloor_nsprefix_ = None
        if rfloor is None:
            self.rfloor = []
        else:
            self.rfloor = rfloor
        self.rfloor_nsprefix_ = None
        if linebreak is None:
            self.linebreak = []
        else:
            self.linebreak = linebreak
        self.linebreak_nsprefix_ = None
        if hruler is None:
            self.hruler = []
        else:
            self.hruler = hruler
        self.hruler_nsprefix_ = None
        if preformatted is None:
            self.preformatted = []
        else:
            self.preformatted = preformatted
        self.preformatted_nsprefix_ = None
        if programlisting is None:
            self.programlisting = []
        else:
            self.programlisting = programlisting
        self.programlisting_nsprefix_ = None
        if verbatim is None:
            self.verbatim = []
        else:
            self.verbatim = verbatim
        self.verbatim_nsprefix_ = None
        if indexentry is None:
            self.indexentry = []
        else:
            self.indexentry = indexentry
        self.indexentry_nsprefix_ = None
        if orderedlist is None:
            self.orderedlist = []
        else:
            self.orderedlist = orderedlist
        self.orderedlist_nsprefix_ = None
        if itemizedlist is None:
            self.itemizedlist = []
        else:
            self.itemizedlist = itemizedlist
        self.itemizedlist_nsprefix_ = None
        if simplesect is None:
            self.simplesect = []
        else:
            self.simplesect = simplesect
        self.simplesect_nsprefix_ = None
        if title is None:
            self.title = []
        else:
            self.title = title
        self.title_nsprefix_ = None
        if variablelist is None:
            self.variablelist = []
        else:
            self.variablelist = variablelist
        self.variablelist_nsprefix_ = None
        if table is None:
            self.table = []
        else:
            self.table = table
        self.table_nsprefix_ = None
        if heading is None:
            self.heading = []
        else:
            self.heading = heading
        self.heading_nsprefix_ = None
        if image is None:
            self.image = []
        else:
            self.image = image
        self.image_nsprefix_ = None
        if dotfile is None:
            self.dotfile = []
        else:
            self.dotfile = dotfile
        self.dotfile_nsprefix_ = None
        if mscfile is None:
            self.mscfile = []
        else:
            self.mscfile = mscfile
        self.mscfile_nsprefix_ = None
        if diafile is None:
            self.diafile = []
        else:
            self.diafile = diafile
        self.diafile_nsprefix_ = None
        if toclist is None:
            self.toclist = []
        else:
            self.toclist = toclist
        self.toclist_nsprefix_ = None
        if language is None:
            self.language = []
        else:
            self.language = language
        self.language_nsprefix_ = None
        if parameterlist is None:
            self.parameterlist = []
        else:
            self.parameterlist = parameterlist
        self.parameterlist_nsprefix_ = None
        if xrefsect is None:
            self.xrefsect = []
        else:
            self.xrefsect = xrefsect
        self.xrefsect_nsprefix_ = None
        if copydoc is None:
            self.copydoc = []
        else:
            self.copydoc = copydoc
        self.copydoc_nsprefix_ = None
        if blockquote is None:
            self.blockquote = []
        else:
            self.blockquote = blockquote
        self.blockquote_nsprefix_ = None
        if parblock is None:
            self.parblock = []
        else:
            self.parblock = parblock
        self.parblock_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docParaType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docParaType.subclass:
            return docParaType.subclass(*args_, **kwargs_)
        return docParaType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ulink(self):
        return self.ulink
    def set_ulink(self, ulink):
        self.ulink = ulink
    def add_ulink(self, value):
        self.ulink.append(value)
    def insert_ulink_at(self, index, value):
        self.ulink.insert(index, value)
    def replace_ulink_at(self, index, value):
        self.ulink[index] = value
    def get_bold(self):
        return self.bold
    def set_bold(self, bold):
        self.bold = bold
    def add_bold(self, value):
        self.bold.append(value)
    def insert_bold_at(self, index, value):
        self.bold.insert(index, value)
    def replace_bold_at(self, index, value):
        self.bold[index] = value
    def get_emphasis(self):
        return self.emphasis
    def set_emphasis(self, emphasis):
        self.emphasis = emphasis
    def add_emphasis(self, value):
        self.emphasis.append(value)
    def insert_emphasis_at(self, index, value):
        self.emphasis.insert(index, value)
    def replace_emphasis_at(self, index, value):
        self.emphasis[index] = value
    def get_computeroutput(self):
        return self.computeroutput
    def set_computeroutput(self, computeroutput):
        self.computeroutput = computeroutput
    def add_computeroutput(self, value):
        self.computeroutput.append(value)
    def insert_computeroutput_at(self, index, value):
        self.computeroutput.insert(index, value)
    def replace_computeroutput_at(self, index, value):
        self.computeroutput[index] = value
    def get_subscript(self):
        return self.subscript
    def set_subscript(self, subscript):
        self.subscript = subscript
    def add_subscript(self, value):
        self.subscript.append(value)
    def insert_subscript_at(self, index, value):
        self.subscript.insert(index, value)
    def replace_subscript_at(self, index, value):
        self.subscript[index] = value
    def get_superscript(self):
        return self.superscript
    def set_superscript(self, superscript):
        self.superscript = superscript
    def add_superscript(self, value):
        self.superscript.append(value)
    def insert_superscript_at(self, index, value):
        self.superscript.insert(index, value)
    def replace_superscript_at(self, index, value):
        self.superscript[index] = value
    def get_center(self):
        return self.center
    def set_center(self, center):
        self.center = center
    def add_center(self, value):
        self.center.append(value)
    def insert_center_at(self, index, value):
        self.center.insert(index, value)
    def replace_center_at(self, index, value):
        self.center[index] = value
    def get_small(self):
        return self.small
    def set_small(self, small):
        self.small = small
    def add_small(self, value):
        self.small.append(value)
    def insert_small_at(self, index, value):
        self.small.insert(index, value)
    def replace_small_at(self, index, value):
        self.small[index] = value
    def get_htmlonly(self):
        return self.htmlonly
    def set_htmlonly(self, htmlonly):
        self.htmlonly = htmlonly
    def add_htmlonly(self, value):
        self.htmlonly.append(value)
    def insert_htmlonly_at(self, index, value):
        self.htmlonly.insert(index, value)
    def replace_htmlonly_at(self, index, value):
        self.htmlonly[index] = value
    def get_manonly(self):
        return self.manonly
    def set_manonly(self, manonly):
        self.manonly = manonly
    def add_manonly(self, value):
        self.manonly.append(value)
    def insert_manonly_at(self, index, value):
        self.manonly.insert(index, value)
    def replace_manonly_at(self, index, value):
        self.manonly[index] = value
    def get_xmlonly(self):
        return self.xmlonly
    def set_xmlonly(self, xmlonly):
        self.xmlonly = xmlonly
    def add_xmlonly(self, value):
        self.xmlonly.append(value)
    def insert_xmlonly_at(self, index, value):
        self.xmlonly.insert(index, value)
    def replace_xmlonly_at(self, index, value):
        self.xmlonly[index] = value
    def get_rtfonly(self):
        return self.rtfonly
    def set_rtfonly(self, rtfonly):
        self.rtfonly = rtfonly
    def add_rtfonly(self, value):
        self.rtfonly.append(value)
    def insert_rtfonly_at(self, index, value):
        self.rtfonly.insert(index, value)
    def replace_rtfonly_at(self, index, value):
        self.rtfonly[index] = value
    def get_latexonly(self):
        return self.latexonly
    def set_latexonly(self, latexonly):
        self.latexonly = latexonly
    def add_latexonly(self, value):
        self.latexonly.append(value)
    def insert_latexonly_at(self, index, value):
        self.latexonly.insert(index, value)
    def replace_latexonly_at(self, index, value):
        self.latexonly[index] = value
    def get_dot(self):
        return self.dot
    def set_dot(self, dot):
        self.dot = dot
    def add_dot(self, value):
        self.dot.append(value)
    def insert_dot_at(self, index, value):
        self.dot.insert(index, value)
    def replace_dot_at(self, index, value):
        self.dot[index] = value
    def get_msc(self):
        return self.msc
    def set_msc(self, msc):
        self.msc = msc
    def add_msc(self, value):
        self.msc.append(value)
    def insert_msc_at(self, index, value):
        self.msc.insert(index, value)
    def replace_msc_at(self, index, value):
        self.msc[index] = value
    def get_anchor(self):
        return self.anchor
    def set_anchor(self, anchor):
        self.anchor = anchor
    def add_anchor(self, value):
        self.anchor.append(value)
    def insert_anchor_at(self, index, value):
        self.anchor.insert(index, value)
    def replace_anchor_at(self, index, value):
        self.anchor[index] = value
    def get_formula(self):
        return self.formula
    def set_formula(self, formula):
        self.formula = formula
    def add_formula(self, value):
        self.formula.append(value)
    def insert_formula_at(self, index, value):
        self.formula.insert(index, value)
    def replace_formula_at(self, index, value):
        self.formula[index] = value
    def get_ref(self):
        return self.ref
    def set_ref(self, ref):
        self.ref = ref
    def add_ref(self, value):
        self.ref.append(value)
    def insert_ref_at(self, index, value):
        self.ref.insert(index, value)
    def replace_ref_at(self, index, value):
        self.ref[index] = value
    def get_copy(self):
        return self.copy
    def set_copy(self, copy):
        self.copy = copy
    def add_copy(self, value):
        self.copy.append(value)
    def insert_copy_at(self, index, value):
        self.copy.insert(index, value)
    def replace_copy_at(self, index, value):
        self.copy[index] = value
    def get_trademark(self):
        return self.trademark
    def set_trademark(self, trademark):
        self.trademark = trademark
    def add_trademark(self, value):
        self.trademark.append(value)
    def insert_trademark_at(self, index, value):
        self.trademark.insert(index, value)
    def replace_trademark_at(self, index, value):
        self.trademark[index] = value
    def get_registered(self):
        return self.registered
    def set_registered(self, registered):
        self.registered = registered
    def add_registered(self, value):
        self.registered.append(value)
    def insert_registered_at(self, index, value):
        self.registered.insert(index, value)
    def replace_registered_at(self, index, value):
        self.registered[index] = value
    def get_lsquo(self):
        return self.lsquo
    def set_lsquo(self, lsquo):
        self.lsquo = lsquo
    def add_lsquo(self, value):
        self.lsquo.append(value)
    def insert_lsquo_at(self, index, value):
        self.lsquo.insert(index, value)
    def replace_lsquo_at(self, index, value):
        self.lsquo[index] = value
    def get_rsquo(self):
        return self.rsquo
    def set_rsquo(self, rsquo):
        self.rsquo = rsquo
    def add_rsquo(self, value):
        self.rsquo.append(value)
    def insert_rsquo_at(self, index, value):
        self.rsquo.insert(index, value)
    def replace_rsquo_at(self, index, value):
        self.rsquo[index] = value
    def get_ldquo(self):
        return self.ldquo
    def set_ldquo(self, ldquo):
        self.ldquo = ldquo
    def add_ldquo(self, value):
        self.ldquo.append(value)
    def insert_ldquo_at(self, index, value):
        self.ldquo.insert(index, value)
    def replace_ldquo_at(self, index, value):
        self.ldquo[index] = value
    def get_rdquo(self):
        return self.rdquo
    def set_rdquo(self, rdquo):
        self.rdquo = rdquo
    def add_rdquo(self, value):
        self.rdquo.append(value)
    def insert_rdquo_at(self, index, value):
        self.rdquo.insert(index, value)
    def replace_rdquo_at(self, index, value):
        self.rdquo[index] = value
    def get_ndash(self):
        return self.ndash
    def set_ndash(self, ndash):
        self.ndash = ndash
    def add_ndash(self, value):
        self.ndash.append(value)
    def insert_ndash_at(self, index, value):
        self.ndash.insert(index, value)
    def replace_ndash_at(self, index, value):
        self.ndash[index] = value
    def get_mdash(self):
        return self.mdash
    def set_mdash(self, mdash):
        self.mdash = mdash
    def add_mdash(self, value):
        self.mdash.append(value)
    def insert_mdash_at(self, index, value):
        self.mdash.insert(index, value)
    def replace_mdash_at(self, index, value):
        self.mdash[index] = value
    def get_umlaut(self):
        return self.umlaut
    def set_umlaut(self, umlaut):
        self.umlaut = umlaut
    def add_umlaut(self, value):
        self.umlaut.append(value)
    def insert_umlaut_at(self, index, value):
        self.umlaut.insert(index, value)
    def replace_umlaut_at(self, index, value):
        self.umlaut[index] = value
    def get_acute(self):
        return self.acute
    def set_acute(self, acute):
        self.acute = acute
    def add_acute(self, value):
        self.acute.append(value)
    def insert_acute_at(self, index, value):
        self.acute.insert(index, value)
    def replace_acute_at(self, index, value):
        self.acute[index] = value
    def get_grave(self):
        return self.grave
    def set_grave(self, grave):
        self.grave = grave
    def add_grave(self, value):
        self.grave.append(value)
    def insert_grave_at(self, index, value):
        self.grave.insert(index, value)
    def replace_grave_at(self, index, value):
        self.grave[index] = value
    def get_circ(self):
        return self.circ
    def set_circ(self, circ):
        self.circ = circ
    def add_circ(self, value):
        self.circ.append(value)
    def insert_circ_at(self, index, value):
        self.circ.insert(index, value)
    def replace_circ_at(self, index, value):
        self.circ[index] = value
    def get_slash(self):
        return self.slash
    def set_slash(self, slash):
        self.slash = slash
    def add_slash(self, value):
        self.slash.append(value)
    def insert_slash_at(self, index, value):
        self.slash.insert(index, value)
    def replace_slash_at(self, index, value):
        self.slash[index] = value
    def get_tilde(self):
        return self.tilde
    def set_tilde(self, tilde):
        self.tilde = tilde
    def add_tilde(self, value):
        self.tilde.append(value)
    def insert_tilde_at(self, index, value):
        self.tilde.insert(index, value)
    def replace_tilde_at(self, index, value):
        self.tilde[index] = value
    def get_cedil(self):
        return self.cedil
    def set_cedil(self, cedil):
        self.cedil = cedil
    def add_cedil(self, value):
        self.cedil.append(value)
    def insert_cedil_at(self, index, value):
        self.cedil.insert(index, value)
    def replace_cedil_at(self, index, value):
        self.cedil[index] = value
    def get_ring(self):
        return self.ring
    def set_ring(self, ring):
        self.ring = ring
    def add_ring(self, value):
        self.ring.append(value)
    def insert_ring_at(self, index, value):
        self.ring.insert(index, value)
    def replace_ring_at(self, index, value):
        self.ring[index] = value
    def get_szlig(self):
        return self.szlig
    def set_szlig(self, szlig):
        self.szlig = szlig
    def add_szlig(self, value):
        self.szlig.append(value)
    def insert_szlig_at(self, index, value):
        self.szlig.insert(index, value)
    def replace_szlig_at(self, index, value):
        self.szlig[index] = value
    def get_nonbreakablespace(self):
        return self.nonbreakablespace
    def set_nonbreakablespace(self, nonbreakablespace):
        self.nonbreakablespace = nonbreakablespace
    def add_nonbreakablespace(self, value):
        self.nonbreakablespace.append(value)
    def insert_nonbreakablespace_at(self, index, value):
        self.nonbreakablespace.insert(index, value)
    def replace_nonbreakablespace_at(self, index, value):
        self.nonbreakablespace[index] = value
    def get_aelig(self):
        return self.aelig
    def set_aelig(self, aelig):
        self.aelig = aelig
    def add_aelig(self, value):
        self.aelig.append(value)
    def insert_aelig_at(self, index, value):
        self.aelig.insert(index, value)
    def replace_aelig_at(self, index, value):
        self.aelig[index] = value
    def get_AElig(self):
        return self.AElig
    def set_AElig(self, AElig):
        self.AElig = AElig
    def add_AElig(self, value):
        self.AElig.append(value)
    def insert_AElig_at(self, index, value):
        self.AElig.insert(index, value)
    def replace_AElig_at(self, index, value):
        self.AElig[index] = value
    def get_Gamma(self):
        return self.Gamma
    def set_Gamma(self, Gamma):
        self.Gamma = Gamma
    def add_Gamma(self, value):
        self.Gamma.append(value)
    def insert_Gamma_at(self, index, value):
        self.Gamma.insert(index, value)
    def replace_Gamma_at(self, index, value):
        self.Gamma[index] = value
    def get_Delta(self):
        return self.Delta
    def set_Delta(self, Delta):
        self.Delta = Delta
    def add_Delta(self, value):
        self.Delta.append(value)
    def insert_Delta_at(self, index, value):
        self.Delta.insert(index, value)
    def replace_Delta_at(self, index, value):
        self.Delta[index] = value
    def get_Theta(self):
        return self.Theta
    def set_Theta(self, Theta):
        self.Theta = Theta
    def add_Theta(self, value):
        self.Theta.append(value)
    def insert_Theta_at(self, index, value):
        self.Theta.insert(index, value)
    def replace_Theta_at(self, index, value):
        self.Theta[index] = value
    def get_Lambda(self):
        return self.Lambda
    def set_Lambda(self, Lambda):
        self.Lambda = Lambda
    def add_Lambda(self, value):
        self.Lambda.append(value)
    def insert_Lambda_at(self, index, value):
        self.Lambda.insert(index, value)
    def replace_Lambda_at(self, index, value):
        self.Lambda[index] = value
    def get_Xi(self):
        return self.Xi
    def set_Xi(self, Xi):
        self.Xi = Xi
    def add_Xi(self, value):
        self.Xi.append(value)
    def insert_Xi_at(self, index, value):
        self.Xi.insert(index, value)
    def replace_Xi_at(self, index, value):
        self.Xi[index] = value
    def get_Pi(self):
        return self.Pi
    def set_Pi(self, Pi):
        self.Pi = Pi
    def add_Pi(self, value):
        self.Pi.append(value)
    def insert_Pi_at(self, index, value):
        self.Pi.insert(index, value)
    def replace_Pi_at(self, index, value):
        self.Pi[index] = value
    def get_Sigma(self):
        return self.Sigma
    def set_Sigma(self, Sigma):
        self.Sigma = Sigma
    def add_Sigma(self, value):
        self.Sigma.append(value)
    def insert_Sigma_at(self, index, value):
        self.Sigma.insert(index, value)
    def replace_Sigma_at(self, index, value):
        self.Sigma[index] = value
    def get_Upsilon(self):
        return self.Upsilon
    def set_Upsilon(self, Upsilon):
        self.Upsilon = Upsilon
    def add_Upsilon(self, value):
        self.Upsilon.append(value)
    def insert_Upsilon_at(self, index, value):
        self.Upsilon.insert(index, value)
    def replace_Upsilon_at(self, index, value):
        self.Upsilon[index] = value
    def get_Phi(self):
        return self.Phi
    def set_Phi(self, Phi):
        self.Phi = Phi
    def add_Phi(self, value):
        self.Phi.append(value)
    def insert_Phi_at(self, index, value):
        self.Phi.insert(index, value)
    def replace_Phi_at(self, index, value):
        self.Phi[index] = value
    def get_Psi(self):
        return self.Psi
    def set_Psi(self, Psi):
        self.Psi = Psi
    def add_Psi(self, value):
        self.Psi.append(value)
    def insert_Psi_at(self, index, value):
        self.Psi.insert(index, value)
    def replace_Psi_at(self, index, value):
        self.Psi[index] = value
    def get_Omega(self):
        return self.Omega
    def set_Omega(self, Omega):
        self.Omega = Omega
    def add_Omega(self, value):
        self.Omega.append(value)
    def insert_Omega_at(self, index, value):
        self.Omega.insert(index, value)
    def replace_Omega_at(self, index, value):
        self.Omega[index] = value
    def get_alpha(self):
        return self.alpha
    def set_alpha(self, alpha):
        self.alpha = alpha
    def add_alpha(self, value):
        self.alpha.append(value)
    def insert_alpha_at(self, index, value):
        self.alpha.insert(index, value)
    def replace_alpha_at(self, index, value):
        self.alpha[index] = value
    def get_beta(self):
        return self.beta
    def set_beta(self, beta):
        self.beta = beta
    def add_beta(self, value):
        self.beta.append(value)
    def insert_beta_at(self, index, value):
        self.beta.insert(index, value)
    def replace_beta_at(self, index, value):
        self.beta[index] = value
    def get_gamma(self):
        return self.gamma
    def set_gamma(self, gamma):
        self.gamma = gamma
    def add_gamma(self, value):
        self.gamma.append(value)
    def insert_gamma_at(self, index, value):
        self.gamma.insert(index, value)
    def replace_gamma_at(self, index, value):
        self.gamma[index] = value
    def get_delta(self):
        return self.delta
    def set_delta(self, delta):
        self.delta = delta
    def add_delta(self, value):
        self.delta.append(value)
    def insert_delta_at(self, index, value):
        self.delta.insert(index, value)
    def replace_delta_at(self, index, value):
        self.delta[index] = value
    def get_epsilon(self):
        return self.epsilon
    def set_epsilon(self, epsilon):
        self.epsilon = epsilon
    def add_epsilon(self, value):
        self.epsilon.append(value)
    def insert_epsilon_at(self, index, value):
        self.epsilon.insert(index, value)
    def replace_epsilon_at(self, index, value):
        self.epsilon[index] = value
    def get_zeta(self):
        return self.zeta
    def set_zeta(self, zeta):
        self.zeta = zeta
    def add_zeta(self, value):
        self.zeta.append(value)
    def insert_zeta_at(self, index, value):
        self.zeta.insert(index, value)
    def replace_zeta_at(self, index, value):
        self.zeta[index] = value
    def get_eta(self):
        return self.eta
    def set_eta(self, eta):
        self.eta = eta
    def add_eta(self, value):
        self.eta.append(value)
    def insert_eta_at(self, index, value):
        self.eta.insert(index, value)
    def replace_eta_at(self, index, value):
        self.eta[index] = value
    def get_theta(self):
        return self.theta
    def set_theta(self, theta):
        self.theta = theta
    def add_theta(self, value):
        self.theta.append(value)
    def insert_theta_at(self, index, value):
        self.theta.insert(index, value)
    def replace_theta_at(self, index, value):
        self.theta[index] = value
    def get_iota(self):
        return self.iota
    def set_iota(self, iota):
        self.iota = iota
    def add_iota(self, value):
        self.iota.append(value)
    def insert_iota_at(self, index, value):
        self.iota.insert(index, value)
    def replace_iota_at(self, index, value):
        self.iota[index] = value
    def get_kappa(self):
        return self.kappa
    def set_kappa(self, kappa):
        self.kappa = kappa
    def add_kappa(self, value):
        self.kappa.append(value)
    def insert_kappa_at(self, index, value):
        self.kappa.insert(index, value)
    def replace_kappa_at(self, index, value):
        self.kappa[index] = value
    def get_lambda(self):
        return self.lambda_
    def set_lambda(self, lambda_):
        self.lambda_ = lambda_
    def add_lambda(self, value):
        self.lambda_.append(value)
    def insert_lambda_at(self, index, value):
        self.lambda_.insert(index, value)
    def replace_lambda_at(self, index, value):
        self.lambda_[index] = value
    def get_mu(self):
        return self.mu
    def set_mu(self, mu):
        self.mu = mu
    def add_mu(self, value):
        self.mu.append(value)
    def insert_mu_at(self, index, value):
        self.mu.insert(index, value)
    def replace_mu_at(self, index, value):
        self.mu[index] = value
    def get_nu(self):
        return self.nu
    def set_nu(self, nu):
        self.nu = nu
    def add_nu(self, value):
        self.nu.append(value)
    def insert_nu_at(self, index, value):
        self.nu.insert(index, value)
    def replace_nu_at(self, index, value):
        self.nu[index] = value
    def get_xi(self):
        return self.xi
    def set_xi(self, xi):
        self.xi = xi
    def add_xi(self, value):
        self.xi.append(value)
    def insert_xi_at(self, index, value):
        self.xi.insert(index, value)
    def replace_xi_at(self, index, value):
        self.xi[index] = value
    def get_pi(self):
        return self.pi
    def set_pi(self, pi):
        self.pi = pi
    def add_pi(self, value):
        self.pi.append(value)
    def insert_pi_at(self, index, value):
        self.pi.insert(index, value)
    def replace_pi_at(self, index, value):
        self.pi[index] = value
    def get_rho(self):
        return self.rho
    def set_rho(self, rho):
        self.rho = rho
    def add_rho(self, value):
        self.rho.append(value)
    def insert_rho_at(self, index, value):
        self.rho.insert(index, value)
    def replace_rho_at(self, index, value):
        self.rho[index] = value
    def get_sigma(self):
        return self.sigma
    def set_sigma(self, sigma):
        self.sigma = sigma
    def add_sigma(self, value):
        self.sigma.append(value)
    def insert_sigma_at(self, index, value):
        self.sigma.insert(index, value)
    def replace_sigma_at(self, index, value):
        self.sigma[index] = value
    def get_tau(self):
        return self.tau
    def set_tau(self, tau):
        self.tau = tau
    def add_tau(self, value):
        self.tau.append(value)
    def insert_tau_at(self, index, value):
        self.tau.insert(index, value)
    def replace_tau_at(self, index, value):
        self.tau[index] = value
    def get_upsilon(self):
        return self.upsilon
    def set_upsilon(self, upsilon):
        self.upsilon = upsilon
    def add_upsilon(self, value):
        self.upsilon.append(value)
    def insert_upsilon_at(self, index, value):
        self.upsilon.insert(index, value)
    def replace_upsilon_at(self, index, value):
        self.upsilon[index] = value
    def get_phi(self):
        return self.phi
    def set_phi(self, phi):
        self.phi = phi
    def add_phi(self, value):
        self.phi.append(value)
    def insert_phi_at(self, index, value):
        self.phi.insert(index, value)
    def replace_phi_at(self, index, value):
        self.phi[index] = value
    def get_chi(self):
        return self.chi
    def set_chi(self, chi):
        self.chi = chi
    def add_chi(self, value):
        self.chi.append(value)
    def insert_chi_at(self, index, value):
        self.chi.insert(index, value)
    def replace_chi_at(self, index, value):
        self.chi[index] = value
    def get_psi(self):
        return self.psi
    def set_psi(self, psi):
        self.psi = psi
    def add_psi(self, value):
        self.psi.append(value)
    def insert_psi_at(self, index, value):
        self.psi.insert(index, value)
    def replace_psi_at(self, index, value):
        self.psi[index] = value
    def get_omega(self):
        return self.omega
    def set_omega(self, omega):
        self.omega = omega
    def add_omega(self, value):
        self.omega.append(value)
    def insert_omega_at(self, index, value):
        self.omega.insert(index, value)
    def replace_omega_at(self, index, value):
        self.omega[index] = value
    def get_sigmaf(self):
        return self.sigmaf
    def set_sigmaf(self, sigmaf):
        self.sigmaf = sigmaf
    def add_sigmaf(self, value):
        self.sigmaf.append(value)
    def insert_sigmaf_at(self, index, value):
        self.sigmaf.insert(index, value)
    def replace_sigmaf_at(self, index, value):
        self.sigmaf[index] = value
    def get_sect(self):
        return self.sect
    def set_sect(self, sect):
        self.sect = sect
    def add_sect(self, value):
        self.sect.append(value)
    def insert_sect_at(self, index, value):
        self.sect.insert(index, value)
    def replace_sect_at(self, index, value):
        self.sect[index] = value
    def get_deg(self):
        return self.deg
    def set_deg(self, deg):
        self.deg = deg
    def add_deg(self, value):
        self.deg.append(value)
    def insert_deg_at(self, index, value):
        self.deg.insert(index, value)
    def replace_deg_at(self, index, value):
        self.deg[index] = value
    def get_prime(self):
        return self.prime
    def set_prime(self, prime):
        self.prime = prime
    def add_prime(self, value):
        self.prime.append(value)
    def insert_prime_at(self, index, value):
        self.prime.insert(index, value)
    def replace_prime_at(self, index, value):
        self.prime[index] = value
    def get_Prime(self):
        return self.Prime
    def set_Prime(self, Prime):
        self.Prime = Prime
    def add_Prime(self, value):
        self.Prime.append(value)
    def insert_Prime_at(self, index, value):
        self.Prime.insert(index, value)
    def replace_Prime_at(self, index, value):
        self.Prime[index] = value
    def get_infin(self):
        return self.infin
    def set_infin(self, infin):
        self.infin = infin
    def add_infin(self, value):
        self.infin.append(value)
    def insert_infin_at(self, index, value):
        self.infin.insert(index, value)
    def replace_infin_at(self, index, value):
        self.infin[index] = value
    def get_empty(self):
        return self.empty
    def set_empty(self, empty):
        self.empty = empty
    def add_empty(self, value):
        self.empty.append(value)
    def insert_empty_at(self, index, value):
        self.empty.insert(index, value)
    def replace_empty_at(self, index, value):
        self.empty[index] = value
    def get_plusmn(self):
        return self.plusmn
    def set_plusmn(self, plusmn):
        self.plusmn = plusmn
    def add_plusmn(self, value):
        self.plusmn.append(value)
    def insert_plusmn_at(self, index, value):
        self.plusmn.insert(index, value)
    def replace_plusmn_at(self, index, value):
        self.plusmn[index] = value
    def get_times(self):
        return self.times
    def set_times(self, times):
        self.times = times
    def add_times(self, value):
        self.times.append(value)
    def insert_times_at(self, index, value):
        self.times.insert(index, value)
    def replace_times_at(self, index, value):
        self.times[index] = value
    def get_minus(self):
        return self.minus
    def set_minus(self, minus):
        self.minus = minus
    def add_minus(self, value):
        self.minus.append(value)
    def insert_minus_at(self, index, value):
        self.minus.insert(index, value)
    def replace_minus_at(self, index, value):
        self.minus[index] = value
    def get_sdot(self):
        return self.sdot
    def set_sdot(self, sdot):
        self.sdot = sdot
    def add_sdot(self, value):
        self.sdot.append(value)
    def insert_sdot_at(self, index, value):
        self.sdot.insert(index, value)
    def replace_sdot_at(self, index, value):
        self.sdot[index] = value
    def get_part(self):
        return self.part
    def set_part(self, part):
        self.part = part
    def add_part(self, value):
        self.part.append(value)
    def insert_part_at(self, index, value):
        self.part.insert(index, value)
    def replace_part_at(self, index, value):
        self.part[index] = value
    def get_nabla(self):
        return self.nabla
    def set_nabla(self, nabla):
        self.nabla = nabla
    def add_nabla(self, value):
        self.nabla.append(value)
    def insert_nabla_at(self, index, value):
        self.nabla.insert(index, value)
    def replace_nabla_at(self, index, value):
        self.nabla[index] = value
    def get_radic(self):
        return self.radic
    def set_radic(self, radic):
        self.radic = radic
    def add_radic(self, value):
        self.radic.append(value)
    def insert_radic_at(self, index, value):
        self.radic.insert(index, value)
    def replace_radic_at(self, index, value):
        self.radic[index] = value
    def get_perp(self):
        return self.perp
    def set_perp(self, perp):
        self.perp = perp
    def add_perp(self, value):
        self.perp.append(value)
    def insert_perp_at(self, index, value):
        self.perp.insert(index, value)
    def replace_perp_at(self, index, value):
        self.perp[index] = value
    def get_sum(self):
        return self.sum
    def set_sum(self, sum):
        self.sum = sum
    def add_sum(self, value):
        self.sum.append(value)
    def insert_sum_at(self, index, value):
        self.sum.insert(index, value)
    def replace_sum_at(self, index, value):
        self.sum[index] = value
    def get_int(self):
        return self.int
    def set_int(self, int):
        self.int = int
    def add_int(self, value):
        self.int.append(value)
    def insert_int_at(self, index, value):
        self.int.insert(index, value)
    def replace_int_at(self, index, value):
        self.int[index] = value
    def get_prod(self):
        return self.prod
    def set_prod(self, prod):
        self.prod = prod
    def add_prod(self, value):
        self.prod.append(value)
    def insert_prod_at(self, index, value):
        self.prod.insert(index, value)
    def replace_prod_at(self, index, value):
        self.prod[index] = value
    def get_sim(self):
        return self.sim
    def set_sim(self, sim):
        self.sim = sim
    def add_sim(self, value):
        self.sim.append(value)
    def insert_sim_at(self, index, value):
        self.sim.insert(index, value)
    def replace_sim_at(self, index, value):
        self.sim[index] = value
    def get_asymp(self):
        return self.asymp
    def set_asymp(self, asymp):
        self.asymp = asymp
    def add_asymp(self, value):
        self.asymp.append(value)
    def insert_asymp_at(self, index, value):
        self.asymp.insert(index, value)
    def replace_asymp_at(self, index, value):
        self.asymp[index] = value
    def get_ne(self):
        return self.ne
    def set_ne(self, ne):
        self.ne = ne
    def add_ne(self, value):
        self.ne.append(value)
    def insert_ne_at(self, index, value):
        self.ne.insert(index, value)
    def replace_ne_at(self, index, value):
        self.ne[index] = value
    def get_equiv(self):
        return self.equiv
    def set_equiv(self, equiv):
        self.equiv = equiv
    def add_equiv(self, value):
        self.equiv.append(value)
    def insert_equiv_at(self, index, value):
        self.equiv.insert(index, value)
    def replace_equiv_at(self, index, value):
        self.equiv[index] = value
    def get_prop(self):
        return self.prop
    def set_prop(self, prop):
        self.prop = prop
    def add_prop(self, value):
        self.prop.append(value)
    def insert_prop_at(self, index, value):
        self.prop.insert(index, value)
    def replace_prop_at(self, index, value):
        self.prop[index] = value
    def get_le(self):
        return self.le
    def set_le(self, le):
        self.le = le
    def add_le(self, value):
        self.le.append(value)
    def insert_le_at(self, index, value):
        self.le.insert(index, value)
    def replace_le_at(self, index, value):
        self.le[index] = value
    def get_ge(self):
        return self.ge
    def set_ge(self, ge):
        self.ge = ge
    def add_ge(self, value):
        self.ge.append(value)
    def insert_ge_at(self, index, value):
        self.ge.insert(index, value)
    def replace_ge_at(self, index, value):
        self.ge[index] = value
    def get_larr(self):
        return self.larr
    def set_larr(self, larr):
        self.larr = larr
    def add_larr(self, value):
        self.larr.append(value)
    def insert_larr_at(self, index, value):
        self.larr.insert(index, value)
    def replace_larr_at(self, index, value):
        self.larr[index] = value
    def get_rarr(self):
        return self.rarr
    def set_rarr(self, rarr):
        self.rarr = rarr
    def add_rarr(self, value):
        self.rarr.append(value)
    def insert_rarr_at(self, index, value):
        self.rarr.insert(index, value)
    def replace_rarr_at(self, index, value):
        self.rarr[index] = value
    def get_isin(self):
        return self.isin
    def set_isin(self, isin):
        self.isin = isin
    def add_isin(self, value):
        self.isin.append(value)
    def insert_isin_at(self, index, value):
        self.isin.insert(index, value)
    def replace_isin_at(self, index, value):
        self.isin[index] = value
    def get_notin(self):
        return self.notin
    def set_notin(self, notin):
        self.notin = notin
    def add_notin(self, value):
        self.notin.append(value)
    def insert_notin_at(self, index, value):
        self.notin.insert(index, value)
    def replace_notin_at(self, index, value):
        self.notin[index] = value
    def get_lceil(self):
        return self.lceil
    def set_lceil(self, lceil):
        self.lceil = lceil
    def add_lceil(self, value):
        self.lceil.append(value)
    def insert_lceil_at(self, index, value):
        self.lceil.insert(index, value)
    def replace_lceil_at(self, index, value):
        self.lceil[index] = value
    def get_rceil(self):
        return self.rceil
    def set_rceil(self, rceil):
        self.rceil = rceil
    def add_rceil(self, value):
        self.rceil.append(value)
    def insert_rceil_at(self, index, value):
        self.rceil.insert(index, value)
    def replace_rceil_at(self, index, value):
        self.rceil[index] = value
    def get_lfloor(self):
        return self.lfloor
    def set_lfloor(self, lfloor):
        self.lfloor = lfloor
    def add_lfloor(self, value):
        self.lfloor.append(value)
    def insert_lfloor_at(self, index, value):
        self.lfloor.insert(index, value)
    def replace_lfloor_at(self, index, value):
        self.lfloor[index] = value
    def get_rfloor(self):
        return self.rfloor
    def set_rfloor(self, rfloor):
        self.rfloor = rfloor
    def add_rfloor(self, value):
        self.rfloor.append(value)
    def insert_rfloor_at(self, index, value):
        self.rfloor.insert(index, value)
    def replace_rfloor_at(self, index, value):
        self.rfloor[index] = value
    def get_linebreak(self):
        return self.linebreak
    def set_linebreak(self, linebreak):
        self.linebreak = linebreak
    def add_linebreak(self, value):
        self.linebreak.append(value)
    def insert_linebreak_at(self, index, value):
        self.linebreak.insert(index, value)
    def replace_linebreak_at(self, index, value):
        self.linebreak[index] = value
    def get_hruler(self):
        return self.hruler
    def set_hruler(self, hruler):
        self.hruler = hruler
    def add_hruler(self, value):
        self.hruler.append(value)
    def insert_hruler_at(self, index, value):
        self.hruler.insert(index, value)
    def replace_hruler_at(self, index, value):
        self.hruler[index] = value
    def get_preformatted(self):
        return self.preformatted
    def set_preformatted(self, preformatted):
        self.preformatted = preformatted
    def add_preformatted(self, value):
        self.preformatted.append(value)
    def insert_preformatted_at(self, index, value):
        self.preformatted.insert(index, value)
    def replace_preformatted_at(self, index, value):
        self.preformatted[index] = value
    def get_programlisting(self):
        return self.programlisting
    def set_programlisting(self, programlisting):
        self.programlisting = programlisting
    def add_programlisting(self, value):
        self.programlisting.append(value)
    def insert_programlisting_at(self, index, value):
        self.programlisting.insert(index, value)
    def replace_programlisting_at(self, index, value):
        self.programlisting[index] = value
    def get_verbatim(self):
        return self.verbatim
    def set_verbatim(self, verbatim):
        self.verbatim = verbatim
    def add_verbatim(self, value):
        self.verbatim.append(value)
    def insert_verbatim_at(self, index, value):
        self.verbatim.insert(index, value)
    def replace_verbatim_at(self, index, value):
        self.verbatim[index] = value
    def get_indexentry(self):
        return self.indexentry
    def set_indexentry(self, indexentry):
        self.indexentry = indexentry
    def add_indexentry(self, value):
        self.indexentry.append(value)
    def insert_indexentry_at(self, index, value):
        self.indexentry.insert(index, value)
    def replace_indexentry_at(self, index, value):
        self.indexentry[index] = value
    def get_orderedlist(self):
        return self.orderedlist
    def set_orderedlist(self, orderedlist):
        self.orderedlist = orderedlist
    def add_orderedlist(self, value):
        self.orderedlist.append(value)
    def insert_orderedlist_at(self, index, value):
        self.orderedlist.insert(index, value)
    def replace_orderedlist_at(self, index, value):
        self.orderedlist[index] = value
    def get_itemizedlist(self):
        return self.itemizedlist
    def set_itemizedlist(self, itemizedlist):
        self.itemizedlist = itemizedlist
    def add_itemizedlist(self, value):
        self.itemizedlist.append(value)
    def insert_itemizedlist_at(self, index, value):
        self.itemizedlist.insert(index, value)
    def replace_itemizedlist_at(self, index, value):
        self.itemizedlist[index] = value
    def get_simplesect(self):
        return self.simplesect
    def set_simplesect(self, simplesect):
        self.simplesect = simplesect
    def add_simplesect(self, value):
        self.simplesect.append(value)
    def insert_simplesect_at(self, index, value):
        self.simplesect.insert(index, value)
    def replace_simplesect_at(self, index, value):
        self.simplesect[index] = value
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def add_title(self, value):
        self.title.append(value)
    def insert_title_at(self, index, value):
        self.title.insert(index, value)
    def replace_title_at(self, index, value):
        self.title[index] = value
    def get_variablelist(self):
        return self.variablelist
    def set_variablelist(self, variablelist):
        self.variablelist = variablelist
    def add_variablelist(self, value):
        self.variablelist.append(value)
    def insert_variablelist_at(self, index, value):
        self.variablelist.insert(index, value)
    def replace_variablelist_at(self, index, value):
        self.variablelist[index] = value
    def get_table(self):
        return self.table
    def set_table(self, table):
        self.table = table
    def add_table(self, value):
        self.table.append(value)
    def insert_table_at(self, index, value):
        self.table.insert(index, value)
    def replace_table_at(self, index, value):
        self.table[index] = value
    def get_heading(self):
        return self.heading
    def set_heading(self, heading):
        self.heading = heading
    def add_heading(self, value):
        self.heading.append(value)
    def insert_heading_at(self, index, value):
        self.heading.insert(index, value)
    def replace_heading_at(self, index, value):
        self.heading[index] = value
    def get_image(self):
        return self.image
    def set_image(self, image):
        self.image = image
    def add_image(self, value):
        self.image.append(value)
    def insert_image_at(self, index, value):
        self.image.insert(index, value)
    def replace_image_at(self, index, value):
        self.image[index] = value
    def get_dotfile(self):
        return self.dotfile
    def set_dotfile(self, dotfile):
        self.dotfile = dotfile
    def add_dotfile(self, value):
        self.dotfile.append(value)
    def insert_dotfile_at(self, index, value):
        self.dotfile.insert(index, value)
    def replace_dotfile_at(self, index, value):
        self.dotfile[index] = value
    def get_mscfile(self):
        return self.mscfile
    def set_mscfile(self, mscfile):
        self.mscfile = mscfile
    def add_mscfile(self, value):
        self.mscfile.append(value)
    def insert_mscfile_at(self, index, value):
        self.mscfile.insert(index, value)
    def replace_mscfile_at(self, index, value):
        self.mscfile[index] = value
    def get_diafile(self):
        return self.diafile
    def set_diafile(self, diafile):
        self.diafile = diafile
    def add_diafile(self, value):
        self.diafile.append(value)
    def insert_diafile_at(self, index, value):
        self.diafile.insert(index, value)
    def replace_diafile_at(self, index, value):
        self.diafile[index] = value
    def get_toclist(self):
        return self.toclist
    def set_toclist(self, toclist):
        self.toclist = toclist
    def add_toclist(self, value):
        self.toclist.append(value)
    def insert_toclist_at(self, index, value):
        self.toclist.insert(index, value)
    def replace_toclist_at(self, index, value):
        self.toclist[index] = value
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def add_language(self, value):
        self.language.append(value)
    def insert_language_at(self, index, value):
        self.language.insert(index, value)
    def replace_language_at(self, index, value):
        self.language[index] = value
    def get_parameterlist(self):
        return self.parameterlist
    def set_parameterlist(self, parameterlist):
        self.parameterlist = parameterlist
    def add_parameterlist(self, value):
        self.parameterlist.append(value)
    def insert_parameterlist_at(self, index, value):
        self.parameterlist.insert(index, value)
    def replace_parameterlist_at(self, index, value):
        self.parameterlist[index] = value
    def get_xrefsect(self):
        return self.xrefsect
    def set_xrefsect(self, xrefsect):
        self.xrefsect = xrefsect
    def add_xrefsect(self, value):
        self.xrefsect.append(value)
    def insert_xrefsect_at(self, index, value):
        self.xrefsect.insert(index, value)
    def replace_xrefsect_at(self, index, value):
        self.xrefsect[index] = value
    def get_copydoc(self):
        return self.copydoc
    def set_copydoc(self, copydoc):
        self.copydoc = copydoc
    def add_copydoc(self, value):
        self.copydoc.append(value)
    def insert_copydoc_at(self, index, value):
        self.copydoc.insert(index, value)
    def replace_copydoc_at(self, index, value):
        self.copydoc[index] = value
    def get_blockquote(self):
        return self.blockquote
    def set_blockquote(self, blockquote):
        self.blockquote = blockquote
    def add_blockquote(self, value):
        self.blockquote.append(value)
    def insert_blockquote_at(self, index, value):
        self.blockquote.insert(index, value)
    def replace_blockquote_at(self, index, value):
        self.blockquote[index] = value
    def get_parblock(self):
        return self.parblock
    def set_parblock(self, parblock):
        self.parblock = parblock
    def add_parblock(self, value):
        self.parblock.append(value)
    def insert_parblock_at(self, index, value):
        self.parblock.insert(index, value)
    def replace_parblock_at(self, index, value):
        self.parblock[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.ulink or
            self.bold or
            self.emphasis or
            self.computeroutput or
            self.subscript or
            self.superscript or
            self.center or
            self.small or
            self.htmlonly or
            self.manonly or
            self.xmlonly or
            self.rtfonly or
            self.latexonly or
            self.dot or
            self.msc or
            self.anchor or
            self.formula or
            self.ref or
            self.copy or
            self.trademark or
            self.registered or
            self.lsquo or
            self.rsquo or
            self.ldquo or
            self.rdquo or
            self.ndash or
            self.mdash or
            self.umlaut or
            self.acute or
            self.grave or
            self.circ or
            self.slash or
            self.tilde or
            self.cedil or
            self.ring or
            self.szlig or
            self.nonbreakablespace or
            self.aelig or
            self.AElig or
            self.Gamma or
            self.Delta or
            self.Theta or
            self.Lambda or
            self.Xi or
            self.Pi or
            self.Sigma or
            self.Upsilon or
            self.Phi or
            self.Psi or
            self.Omega or
            self.alpha or
            self.beta or
            self.gamma or
            self.delta or
            self.epsilon or
            self.zeta or
            self.eta or
            self.theta or
            self.iota or
            self.kappa or
            self.lambda_ or
            self.mu or
            self.nu or
            self.xi or
            self.pi or
            self.rho or
            self.sigma or
            self.tau or
            self.upsilon or
            self.phi or
            self.chi or
            self.psi or
            self.omega or
            self.sigmaf or
            self.sect or
            self.deg or
            self.prime or
            self.Prime or
            self.infin or
            self.empty or
            self.plusmn or
            self.times or
            self.minus or
            self.sdot or
            self.part or
            self.nabla or
            self.radic or
            self.perp or
            self.sum or
            self.int or
            self.prod or
            self.sim or
            self.asymp or
            self.ne or
            self.equiv or
            self.prop or
            self.le or
            self.ge or
            self.larr or
            self.rarr or
            self.isin or
            self.notin or
            self.lceil or
            self.rceil or
            self.lfloor or
            self.rfloor or
            self.linebreak or
            self.hruler or
            self.preformatted or
            self.programlisting or
            self.verbatim or
            self.indexentry or
            self.orderedlist or
            self.itemizedlist or
            self.simplesect or
            self.title or
            self.variablelist or
            self.table or
            self.heading or
            self.image or
            self.dotfile or
            self.mscfile or
            self.diafile or
            self.toclist or
            self.language or
            self.parameterlist or
            self.xrefsect or
            self.copydoc or
            self.blockquote or
            self.parblock or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docParaType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docParaType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docParaType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docParaType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docParaType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docParaType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docParaType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ulink_ in self.ulink:
            namespaceprefix_ = self.ulink_nsprefix_ + ':' if (UseCapturedNS_ and self.ulink_nsprefix_) else ''
            ulink_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ulink', pretty_print=pretty_print)
        for bold_ in self.bold:
            namespaceprefix_ = self.bold_nsprefix_ + ':' if (UseCapturedNS_ and self.bold_nsprefix_) else ''
            bold_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bold', pretty_print=pretty_print)
        for emphasis_ in self.emphasis:
            namespaceprefix_ = self.emphasis_nsprefix_ + ':' if (UseCapturedNS_ and self.emphasis_nsprefix_) else ''
            emphasis_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='emphasis', pretty_print=pretty_print)
        for computeroutput_ in self.computeroutput:
            namespaceprefix_ = self.computeroutput_nsprefix_ + ':' if (UseCapturedNS_ and self.computeroutput_nsprefix_) else ''
            computeroutput_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='computeroutput', pretty_print=pretty_print)
        for subscript_ in self.subscript:
            namespaceprefix_ = self.subscript_nsprefix_ + ':' if (UseCapturedNS_ and self.subscript_nsprefix_) else ''
            subscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subscript', pretty_print=pretty_print)
        for superscript_ in self.superscript:
            namespaceprefix_ = self.superscript_nsprefix_ + ':' if (UseCapturedNS_ and self.superscript_nsprefix_) else ''
            superscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='superscript', pretty_print=pretty_print)
        for center_ in self.center:
            namespaceprefix_ = self.center_nsprefix_ + ':' if (UseCapturedNS_ and self.center_nsprefix_) else ''
            center_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='center', pretty_print=pretty_print)
        for small_ in self.small:
            namespaceprefix_ = self.small_nsprefix_ + ':' if (UseCapturedNS_ and self.small_nsprefix_) else ''
            small_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='small', pretty_print=pretty_print)
        for htmlonly_ in self.htmlonly:
            namespaceprefix_ = self.htmlonly_nsprefix_ + ':' if (UseCapturedNS_ and self.htmlonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shtmlonly>%s</%shtmlonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(htmlonly_), input_name='htmlonly')), namespaceprefix_ , eol_))
        for manonly_ in self.manonly:
            namespaceprefix_ = self.manonly_nsprefix_ + ':' if (UseCapturedNS_ and self.manonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanonly>%s</%smanonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(manonly_), input_name='manonly')), namespaceprefix_ , eol_))
        for xmlonly_ in self.xmlonly:
            namespaceprefix_ = self.xmlonly_nsprefix_ + ':' if (UseCapturedNS_ and self.xmlonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxmlonly>%s</%sxmlonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(xmlonly_), input_name='xmlonly')), namespaceprefix_ , eol_))
        for rtfonly_ in self.rtfonly:
            namespaceprefix_ = self.rtfonly_nsprefix_ + ':' if (UseCapturedNS_ and self.rtfonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srtfonly>%s</%srtfonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(rtfonly_), input_name='rtfonly')), namespaceprefix_ , eol_))
        for latexonly_ in self.latexonly:
            namespaceprefix_ = self.latexonly_nsprefix_ + ':' if (UseCapturedNS_ and self.latexonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slatexonly>%s</%slatexonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(latexonly_), input_name='latexonly')), namespaceprefix_ , eol_))
        for dot_ in self.dot:
            namespaceprefix_ = self.dot_nsprefix_ + ':' if (UseCapturedNS_ and self.dot_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdot>%s</%sdot>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(dot_), input_name='dot')), namespaceprefix_ , eol_))
        for msc_ in self.msc:
            namespaceprefix_ = self.msc_nsprefix_ + ':' if (UseCapturedNS_ and self.msc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smsc>%s</%smsc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(msc_), input_name='msc')), namespaceprefix_ , eol_))
        for anchor_ in self.anchor:
            namespaceprefix_ = self.anchor_nsprefix_ + ':' if (UseCapturedNS_ and self.anchor_nsprefix_) else ''
            anchor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='anchor', pretty_print=pretty_print)
        for formula_ in self.formula:
            namespaceprefix_ = self.formula_nsprefix_ + ':' if (UseCapturedNS_ and self.formula_nsprefix_) else ''
            formula_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='formula', pretty_print=pretty_print)
        for ref_ in self.ref:
            namespaceprefix_ = self.ref_nsprefix_ + ':' if (UseCapturedNS_ and self.ref_nsprefix_) else ''
            ref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ref', pretty_print=pretty_print)
        for copy_ in self.copy:
            namespaceprefix_ = self.copy_nsprefix_ + ':' if (UseCapturedNS_ and self.copy_nsprefix_) else ''
            copy_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='copy', pretty_print=pretty_print)
        for trademark_ in self.trademark:
            namespaceprefix_ = self.trademark_nsprefix_ + ':' if (UseCapturedNS_ and self.trademark_nsprefix_) else ''
            trademark_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='trademark', pretty_print=pretty_print)
        for registered_ in self.registered:
            namespaceprefix_ = self.registered_nsprefix_ + ':' if (UseCapturedNS_ and self.registered_nsprefix_) else ''
            registered_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='registered', pretty_print=pretty_print)
        for lsquo_ in self.lsquo:
            namespaceprefix_ = self.lsquo_nsprefix_ + ':' if (UseCapturedNS_ and self.lsquo_nsprefix_) else ''
            lsquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lsquo', pretty_print=pretty_print)
        for rsquo_ in self.rsquo:
            namespaceprefix_ = self.rsquo_nsprefix_ + ':' if (UseCapturedNS_ and self.rsquo_nsprefix_) else ''
            rsquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rsquo', pretty_print=pretty_print)
        for ldquo_ in self.ldquo:
            namespaceprefix_ = self.ldquo_nsprefix_ + ':' if (UseCapturedNS_ and self.ldquo_nsprefix_) else ''
            ldquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ldquo', pretty_print=pretty_print)
        for rdquo_ in self.rdquo:
            namespaceprefix_ = self.rdquo_nsprefix_ + ':' if (UseCapturedNS_ and self.rdquo_nsprefix_) else ''
            rdquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rdquo', pretty_print=pretty_print)
        for ndash_ in self.ndash:
            namespaceprefix_ = self.ndash_nsprefix_ + ':' if (UseCapturedNS_ and self.ndash_nsprefix_) else ''
            ndash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ndash', pretty_print=pretty_print)
        for mdash_ in self.mdash:
            namespaceprefix_ = self.mdash_nsprefix_ + ':' if (UseCapturedNS_ and self.mdash_nsprefix_) else ''
            mdash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mdash', pretty_print=pretty_print)
        for umlaut_ in self.umlaut:
            namespaceprefix_ = self.umlaut_nsprefix_ + ':' if (UseCapturedNS_ and self.umlaut_nsprefix_) else ''
            umlaut_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='umlaut', pretty_print=pretty_print)
        for acute_ in self.acute:
            namespaceprefix_ = self.acute_nsprefix_ + ':' if (UseCapturedNS_ and self.acute_nsprefix_) else ''
            acute_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acute', pretty_print=pretty_print)
        for grave_ in self.grave:
            namespaceprefix_ = self.grave_nsprefix_ + ':' if (UseCapturedNS_ and self.grave_nsprefix_) else ''
            grave_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='grave', pretty_print=pretty_print)
        for circ_ in self.circ:
            namespaceprefix_ = self.circ_nsprefix_ + ':' if (UseCapturedNS_ and self.circ_nsprefix_) else ''
            circ_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='circ', pretty_print=pretty_print)
        for slash_ in self.slash:
            namespaceprefix_ = self.slash_nsprefix_ + ':' if (UseCapturedNS_ and self.slash_nsprefix_) else ''
            slash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='slash', pretty_print=pretty_print)
        for tilde_ in self.tilde:
            namespaceprefix_ = self.tilde_nsprefix_ + ':' if (UseCapturedNS_ and self.tilde_nsprefix_) else ''
            tilde_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tilde', pretty_print=pretty_print)
        for cedil_ in self.cedil:
            namespaceprefix_ = self.cedil_nsprefix_ + ':' if (UseCapturedNS_ and self.cedil_nsprefix_) else ''
            cedil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cedil', pretty_print=pretty_print)
        for ring_ in self.ring:
            namespaceprefix_ = self.ring_nsprefix_ + ':' if (UseCapturedNS_ and self.ring_nsprefix_) else ''
            ring_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ring', pretty_print=pretty_print)
        for szlig_ in self.szlig:
            namespaceprefix_ = self.szlig_nsprefix_ + ':' if (UseCapturedNS_ and self.szlig_nsprefix_) else ''
            szlig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='szlig', pretty_print=pretty_print)
        for nonbreakablespace_ in self.nonbreakablespace:
            namespaceprefix_ = self.nonbreakablespace_nsprefix_ + ':' if (UseCapturedNS_ and self.nonbreakablespace_nsprefix_) else ''
            nonbreakablespace_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nonbreakablespace', pretty_print=pretty_print)
        for aelig_ in self.aelig:
            namespaceprefix_ = self.aelig_nsprefix_ + ':' if (UseCapturedNS_ and self.aelig_nsprefix_) else ''
            aelig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='aelig', pretty_print=pretty_print)
        for AElig_ in self.AElig:
            namespaceprefix_ = self.AElig_nsprefix_ + ':' if (UseCapturedNS_ and self.AElig_nsprefix_) else ''
            AElig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AElig', pretty_print=pretty_print)
        for Gamma_ in self.Gamma:
            namespaceprefix_ = self.Gamma_nsprefix_ + ':' if (UseCapturedNS_ and self.Gamma_nsprefix_) else ''
            Gamma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Gamma', pretty_print=pretty_print)
        for Delta_ in self.Delta:
            namespaceprefix_ = self.Delta_nsprefix_ + ':' if (UseCapturedNS_ and self.Delta_nsprefix_) else ''
            Delta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Delta', pretty_print=pretty_print)
        for Theta_ in self.Theta:
            namespaceprefix_ = self.Theta_nsprefix_ + ':' if (UseCapturedNS_ and self.Theta_nsprefix_) else ''
            Theta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Theta', pretty_print=pretty_print)
        for Lambda_ in self.Lambda:
            namespaceprefix_ = self.Lambda_nsprefix_ + ':' if (UseCapturedNS_ and self.Lambda_nsprefix_) else ''
            Lambda_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Lambda', pretty_print=pretty_print)
        for Xi_ in self.Xi:
            namespaceprefix_ = self.Xi_nsprefix_ + ':' if (UseCapturedNS_ and self.Xi_nsprefix_) else ''
            Xi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Xi', pretty_print=pretty_print)
        for Pi_ in self.Pi:
            namespaceprefix_ = self.Pi_nsprefix_ + ':' if (UseCapturedNS_ and self.Pi_nsprefix_) else ''
            Pi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Pi', pretty_print=pretty_print)
        for Sigma_ in self.Sigma:
            namespaceprefix_ = self.Sigma_nsprefix_ + ':' if (UseCapturedNS_ and self.Sigma_nsprefix_) else ''
            Sigma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Sigma', pretty_print=pretty_print)
        for Upsilon_ in self.Upsilon:
            namespaceprefix_ = self.Upsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.Upsilon_nsprefix_) else ''
            Upsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Upsilon', pretty_print=pretty_print)
        for Phi_ in self.Phi:
            namespaceprefix_ = self.Phi_nsprefix_ + ':' if (UseCapturedNS_ and self.Phi_nsprefix_) else ''
            Phi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Phi', pretty_print=pretty_print)
        for Psi_ in self.Psi:
            namespaceprefix_ = self.Psi_nsprefix_ + ':' if (UseCapturedNS_ and self.Psi_nsprefix_) else ''
            Psi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Psi', pretty_print=pretty_print)
        for Omega_ in self.Omega:
            namespaceprefix_ = self.Omega_nsprefix_ + ':' if (UseCapturedNS_ and self.Omega_nsprefix_) else ''
            Omega_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Omega', pretty_print=pretty_print)
        for alpha_ in self.alpha:
            namespaceprefix_ = self.alpha_nsprefix_ + ':' if (UseCapturedNS_ and self.alpha_nsprefix_) else ''
            alpha_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alpha', pretty_print=pretty_print)
        for beta_ in self.beta:
            namespaceprefix_ = self.beta_nsprefix_ + ':' if (UseCapturedNS_ and self.beta_nsprefix_) else ''
            beta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='beta', pretty_print=pretty_print)
        for gamma_ in self.gamma:
            namespaceprefix_ = self.gamma_nsprefix_ + ':' if (UseCapturedNS_ and self.gamma_nsprefix_) else ''
            gamma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='gamma', pretty_print=pretty_print)
        for delta_ in self.delta:
            namespaceprefix_ = self.delta_nsprefix_ + ':' if (UseCapturedNS_ and self.delta_nsprefix_) else ''
            delta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='delta', pretty_print=pretty_print)
        for epsilon_ in self.epsilon:
            namespaceprefix_ = self.epsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.epsilon_nsprefix_) else ''
            epsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='epsilon', pretty_print=pretty_print)
        for zeta_ in self.zeta:
            namespaceprefix_ = self.zeta_nsprefix_ + ':' if (UseCapturedNS_ and self.zeta_nsprefix_) else ''
            zeta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='zeta', pretty_print=pretty_print)
        for eta_ in self.eta:
            namespaceprefix_ = self.eta_nsprefix_ + ':' if (UseCapturedNS_ and self.eta_nsprefix_) else ''
            eta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='eta', pretty_print=pretty_print)
        for theta_ in self.theta:
            namespaceprefix_ = self.theta_nsprefix_ + ':' if (UseCapturedNS_ and self.theta_nsprefix_) else ''
            theta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='theta', pretty_print=pretty_print)
        for iota_ in self.iota:
            namespaceprefix_ = self.iota_nsprefix_ + ':' if (UseCapturedNS_ and self.iota_nsprefix_) else ''
            iota_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='iota', pretty_print=pretty_print)
        for kappa_ in self.kappa:
            namespaceprefix_ = self.kappa_nsprefix_ + ':' if (UseCapturedNS_ and self.kappa_nsprefix_) else ''
            kappa_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='kappa', pretty_print=pretty_print)
        for lambda_ in self.lambda_:
            namespaceprefix_ = self.lambda__nsprefix_ + ':' if (UseCapturedNS_ and self.lambda__nsprefix_) else ''
            lambda_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lambda', pretty_print=pretty_print)
        for mu_ in self.mu:
            namespaceprefix_ = self.mu_nsprefix_ + ':' if (UseCapturedNS_ and self.mu_nsprefix_) else ''
            mu_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mu', pretty_print=pretty_print)
        for nu_ in self.nu:
            namespaceprefix_ = self.nu_nsprefix_ + ':' if (UseCapturedNS_ and self.nu_nsprefix_) else ''
            nu_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nu', pretty_print=pretty_print)
        for xi_ in self.xi:
            namespaceprefix_ = self.xi_nsprefix_ + ':' if (UseCapturedNS_ and self.xi_nsprefix_) else ''
            xi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='xi', pretty_print=pretty_print)
        for pi_ in self.pi:
            namespaceprefix_ = self.pi_nsprefix_ + ':' if (UseCapturedNS_ and self.pi_nsprefix_) else ''
            pi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pi', pretty_print=pretty_print)
        for rho_ in self.rho:
            namespaceprefix_ = self.rho_nsprefix_ + ':' if (UseCapturedNS_ and self.rho_nsprefix_) else ''
            rho_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rho', pretty_print=pretty_print)
        for sigma_ in self.sigma:
            namespaceprefix_ = self.sigma_nsprefix_ + ':' if (UseCapturedNS_ and self.sigma_nsprefix_) else ''
            sigma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sigma', pretty_print=pretty_print)
        for tau_ in self.tau:
            namespaceprefix_ = self.tau_nsprefix_ + ':' if (UseCapturedNS_ and self.tau_nsprefix_) else ''
            tau_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tau', pretty_print=pretty_print)
        for upsilon_ in self.upsilon:
            namespaceprefix_ = self.upsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.upsilon_nsprefix_) else ''
            upsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='upsilon', pretty_print=pretty_print)
        for phi_ in self.phi:
            namespaceprefix_ = self.phi_nsprefix_ + ':' if (UseCapturedNS_ and self.phi_nsprefix_) else ''
            phi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='phi', pretty_print=pretty_print)
        for chi_ in self.chi:
            namespaceprefix_ = self.chi_nsprefix_ + ':' if (UseCapturedNS_ and self.chi_nsprefix_) else ''
            chi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='chi', pretty_print=pretty_print)
        for psi_ in self.psi:
            namespaceprefix_ = self.psi_nsprefix_ + ':' if (UseCapturedNS_ and self.psi_nsprefix_) else ''
            psi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='psi', pretty_print=pretty_print)
        for omega_ in self.omega:
            namespaceprefix_ = self.omega_nsprefix_ + ':' if (UseCapturedNS_ and self.omega_nsprefix_) else ''
            omega_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='omega', pretty_print=pretty_print)
        for sigmaf_ in self.sigmaf:
            namespaceprefix_ = self.sigmaf_nsprefix_ + ':' if (UseCapturedNS_ and self.sigmaf_nsprefix_) else ''
            sigmaf_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sigmaf', pretty_print=pretty_print)
        for sect_ in self.sect:
            namespaceprefix_ = self.sect_nsprefix_ + ':' if (UseCapturedNS_ and self.sect_nsprefix_) else ''
            sect_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect', pretty_print=pretty_print)
        for deg_ in self.deg:
            namespaceprefix_ = self.deg_nsprefix_ + ':' if (UseCapturedNS_ and self.deg_nsprefix_) else ''
            deg_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='deg', pretty_print=pretty_print)
        for prime_ in self.prime:
            namespaceprefix_ = self.prime_nsprefix_ + ':' if (UseCapturedNS_ and self.prime_nsprefix_) else ''
            prime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prime', pretty_print=pretty_print)
        for Prime_ in self.Prime:
            namespaceprefix_ = self.Prime_nsprefix_ + ':' if (UseCapturedNS_ and self.Prime_nsprefix_) else ''
            Prime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Prime', pretty_print=pretty_print)
        for infin_ in self.infin:
            namespaceprefix_ = self.infin_nsprefix_ + ':' if (UseCapturedNS_ and self.infin_nsprefix_) else ''
            infin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infin', pretty_print=pretty_print)
        for empty_ in self.empty:
            namespaceprefix_ = self.empty_nsprefix_ + ':' if (UseCapturedNS_ and self.empty_nsprefix_) else ''
            empty_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='empty', pretty_print=pretty_print)
        for plusmn_ in self.plusmn:
            namespaceprefix_ = self.plusmn_nsprefix_ + ':' if (UseCapturedNS_ and self.plusmn_nsprefix_) else ''
            plusmn_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='plusmn', pretty_print=pretty_print)
        for times_ in self.times:
            namespaceprefix_ = self.times_nsprefix_ + ':' if (UseCapturedNS_ and self.times_nsprefix_) else ''
            times_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='times', pretty_print=pretty_print)
        for minus_ in self.minus:
            namespaceprefix_ = self.minus_nsprefix_ + ':' if (UseCapturedNS_ and self.minus_nsprefix_) else ''
            minus_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='minus', pretty_print=pretty_print)
        for sdot_ in self.sdot:
            namespaceprefix_ = self.sdot_nsprefix_ + ':' if (UseCapturedNS_ and self.sdot_nsprefix_) else ''
            sdot_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sdot', pretty_print=pretty_print)
        for part_ in self.part:
            namespaceprefix_ = self.part_nsprefix_ + ':' if (UseCapturedNS_ and self.part_nsprefix_) else ''
            part_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='part', pretty_print=pretty_print)
        for nabla_ in self.nabla:
            namespaceprefix_ = self.nabla_nsprefix_ + ':' if (UseCapturedNS_ and self.nabla_nsprefix_) else ''
            nabla_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nabla', pretty_print=pretty_print)
        for radic_ in self.radic:
            namespaceprefix_ = self.radic_nsprefix_ + ':' if (UseCapturedNS_ and self.radic_nsprefix_) else ''
            radic_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='radic', pretty_print=pretty_print)
        for perp_ in self.perp:
            namespaceprefix_ = self.perp_nsprefix_ + ':' if (UseCapturedNS_ and self.perp_nsprefix_) else ''
            perp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='perp', pretty_print=pretty_print)
        for sum_ in self.sum:
            namespaceprefix_ = self.sum_nsprefix_ + ':' if (UseCapturedNS_ and self.sum_nsprefix_) else ''
            sum_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sum', pretty_print=pretty_print)
        for int_ in self.int:
            namespaceprefix_ = self.int_nsprefix_ + ':' if (UseCapturedNS_ and self.int_nsprefix_) else ''
            int_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='int', pretty_print=pretty_print)
        for prod_ in self.prod:
            namespaceprefix_ = self.prod_nsprefix_ + ':' if (UseCapturedNS_ and self.prod_nsprefix_) else ''
            prod_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prod', pretty_print=pretty_print)
        for sim_ in self.sim:
            namespaceprefix_ = self.sim_nsprefix_ + ':' if (UseCapturedNS_ and self.sim_nsprefix_) else ''
            sim_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sim', pretty_print=pretty_print)
        for asymp_ in self.asymp:
            namespaceprefix_ = self.asymp_nsprefix_ + ':' if (UseCapturedNS_ and self.asymp_nsprefix_) else ''
            asymp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='asymp', pretty_print=pretty_print)
        for ne_ in self.ne:
            namespaceprefix_ = self.ne_nsprefix_ + ':' if (UseCapturedNS_ and self.ne_nsprefix_) else ''
            ne_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ne', pretty_print=pretty_print)
        for equiv_ in self.equiv:
            namespaceprefix_ = self.equiv_nsprefix_ + ':' if (UseCapturedNS_ and self.equiv_nsprefix_) else ''
            equiv_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='equiv', pretty_print=pretty_print)
        for prop_ in self.prop:
            namespaceprefix_ = self.prop_nsprefix_ + ':' if (UseCapturedNS_ and self.prop_nsprefix_) else ''
            prop_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prop', pretty_print=pretty_print)
        for le_ in self.le:
            namespaceprefix_ = self.le_nsprefix_ + ':' if (UseCapturedNS_ and self.le_nsprefix_) else ''
            le_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='le', pretty_print=pretty_print)
        for ge_ in self.ge:
            namespaceprefix_ = self.ge_nsprefix_ + ':' if (UseCapturedNS_ and self.ge_nsprefix_) else ''
            ge_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ge', pretty_print=pretty_print)
        for larr_ in self.larr:
            namespaceprefix_ = self.larr_nsprefix_ + ':' if (UseCapturedNS_ and self.larr_nsprefix_) else ''
            larr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='larr', pretty_print=pretty_print)
        for rarr_ in self.rarr:
            namespaceprefix_ = self.rarr_nsprefix_ + ':' if (UseCapturedNS_ and self.rarr_nsprefix_) else ''
            rarr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rarr', pretty_print=pretty_print)
        for isin_ in self.isin:
            namespaceprefix_ = self.isin_nsprefix_ + ':' if (UseCapturedNS_ and self.isin_nsprefix_) else ''
            isin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='isin', pretty_print=pretty_print)
        for notin_ in self.notin:
            namespaceprefix_ = self.notin_nsprefix_ + ':' if (UseCapturedNS_ and self.notin_nsprefix_) else ''
            notin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='notin', pretty_print=pretty_print)
        for lceil_ in self.lceil:
            namespaceprefix_ = self.lceil_nsprefix_ + ':' if (UseCapturedNS_ and self.lceil_nsprefix_) else ''
            lceil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lceil', pretty_print=pretty_print)
        for rceil_ in self.rceil:
            namespaceprefix_ = self.rceil_nsprefix_ + ':' if (UseCapturedNS_ and self.rceil_nsprefix_) else ''
            rceil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rceil', pretty_print=pretty_print)
        for lfloor_ in self.lfloor:
            namespaceprefix_ = self.lfloor_nsprefix_ + ':' if (UseCapturedNS_ and self.lfloor_nsprefix_) else ''
            lfloor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lfloor', pretty_print=pretty_print)
        for rfloor_ in self.rfloor:
            namespaceprefix_ = self.rfloor_nsprefix_ + ':' if (UseCapturedNS_ and self.rfloor_nsprefix_) else ''
            rfloor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rfloor', pretty_print=pretty_print)
        for linebreak_ in self.linebreak:
            namespaceprefix_ = self.linebreak_nsprefix_ + ':' if (UseCapturedNS_ and self.linebreak_nsprefix_) else ''
            linebreak_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='linebreak', pretty_print=pretty_print)
        for hruler_ in self.hruler:
            namespaceprefix_ = self.hruler_nsprefix_ + ':' if (UseCapturedNS_ and self.hruler_nsprefix_) else ''
            hruler_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='hruler', pretty_print=pretty_print)
        for preformatted_ in self.preformatted:
            namespaceprefix_ = self.preformatted_nsprefix_ + ':' if (UseCapturedNS_ and self.preformatted_nsprefix_) else ''
            preformatted_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='preformatted', pretty_print=pretty_print)
        for programlisting_ in self.programlisting:
            namespaceprefix_ = self.programlisting_nsprefix_ + ':' if (UseCapturedNS_ and self.programlisting_nsprefix_) else ''
            programlisting_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='programlisting', pretty_print=pretty_print)
        for verbatim_ in self.verbatim:
            namespaceprefix_ = self.verbatim_nsprefix_ + ':' if (UseCapturedNS_ and self.verbatim_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sverbatim>%s</%sverbatim>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(verbatim_), input_name='verbatim')), namespaceprefix_ , eol_))
        for indexentry_ in self.indexentry:
            namespaceprefix_ = self.indexentry_nsprefix_ + ':' if (UseCapturedNS_ and self.indexentry_nsprefix_) else ''
            indexentry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='indexentry', pretty_print=pretty_print)
        for orderedlist_ in self.orderedlist:
            namespaceprefix_ = self.orderedlist_nsprefix_ + ':' if (UseCapturedNS_ and self.orderedlist_nsprefix_) else ''
            orderedlist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='orderedlist', pretty_print=pretty_print)
        for itemizedlist_ in self.itemizedlist:
            namespaceprefix_ = self.itemizedlist_nsprefix_ + ':' if (UseCapturedNS_ and self.itemizedlist_nsprefix_) else ''
            itemizedlist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='itemizedlist', pretty_print=pretty_print)
        for simplesect_ in self.simplesect:
            namespaceprefix_ = self.simplesect_nsprefix_ + ':' if (UseCapturedNS_ and self.simplesect_nsprefix_) else ''
            simplesect_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='simplesect', pretty_print=pretty_print)
        for title_ in self.title:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            title_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        for variablelist_ in self.variablelist:
            namespaceprefix_ = self.variablelist_nsprefix_ + ':' if (UseCapturedNS_ and self.variablelist_nsprefix_) else ''
            variablelist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='variablelist', pretty_print=pretty_print)
        for table_ in self.table:
            namespaceprefix_ = self.table_nsprefix_ + ':' if (UseCapturedNS_ and self.table_nsprefix_) else ''
            table_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='table', pretty_print=pretty_print)
        for heading_ in self.heading:
            namespaceprefix_ = self.heading_nsprefix_ + ':' if (UseCapturedNS_ and self.heading_nsprefix_) else ''
            heading_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='heading', pretty_print=pretty_print)
        for image_ in self.image:
            namespaceprefix_ = self.image_nsprefix_ + ':' if (UseCapturedNS_ and self.image_nsprefix_) else ''
            image_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='image', pretty_print=pretty_print)
        for dotfile_ in self.dotfile:
            namespaceprefix_ = self.dotfile_nsprefix_ + ':' if (UseCapturedNS_ and self.dotfile_nsprefix_) else ''
            dotfile_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dotfile', pretty_print=pretty_print)
        for mscfile_ in self.mscfile:
            namespaceprefix_ = self.mscfile_nsprefix_ + ':' if (UseCapturedNS_ and self.mscfile_nsprefix_) else ''
            mscfile_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mscfile', pretty_print=pretty_print)
        for diafile_ in self.diafile:
            namespaceprefix_ = self.diafile_nsprefix_ + ':' if (UseCapturedNS_ and self.diafile_nsprefix_) else ''
            diafile_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='diafile', pretty_print=pretty_print)
        for toclist_ in self.toclist:
            namespaceprefix_ = self.toclist_nsprefix_ + ':' if (UseCapturedNS_ and self.toclist_nsprefix_) else ''
            toclist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='toclist', pretty_print=pretty_print)
        for language_ in self.language:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            language_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
        for parameterlist_ in self.parameterlist:
            namespaceprefix_ = self.parameterlist_nsprefix_ + ':' if (UseCapturedNS_ and self.parameterlist_nsprefix_) else ''
            parameterlist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='parameterlist', pretty_print=pretty_print)
        for xrefsect_ in self.xrefsect:
            namespaceprefix_ = self.xrefsect_nsprefix_ + ':' if (UseCapturedNS_ and self.xrefsect_nsprefix_) else ''
            xrefsect_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='xrefsect', pretty_print=pretty_print)
        for copydoc_ in self.copydoc:
            namespaceprefix_ = self.copydoc_nsprefix_ + ':' if (UseCapturedNS_ and self.copydoc_nsprefix_) else ''
            copydoc_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='copydoc', pretty_print=pretty_print)
        for blockquote_ in self.blockquote:
            namespaceprefix_ = self.blockquote_nsprefix_ + ':' if (UseCapturedNS_ and self.blockquote_nsprefix_) else ''
            blockquote_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='blockquote', pretty_print=pretty_print)
        for parblock_ in self.parblock:
            namespaceprefix_ = self.parblock_nsprefix_ + ':' if (UseCapturedNS_ and self.parblock_nsprefix_) else ''
            parblock_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='parblock', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ulink':
            obj_ = docURLLink.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ulink', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ulink'):
              self.add_ulink(obj_.value)
            elif hasattr(self, 'set_ulink'):
              self.set_ulink(obj_.value)
        elif nodeName_ == 'bold':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'bold', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_bold'):
              self.add_bold(obj_.value)
            elif hasattr(self, 'set_bold'):
              self.set_bold(obj_.value)
        elif nodeName_ == 'emphasis':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'emphasis', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_emphasis'):
              self.add_emphasis(obj_.value)
            elif hasattr(self, 'set_emphasis'):
              self.set_emphasis(obj_.value)
        elif nodeName_ == 'computeroutput':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'computeroutput', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_computeroutput'):
              self.add_computeroutput(obj_.value)
            elif hasattr(self, 'set_computeroutput'):
              self.set_computeroutput(obj_.value)
        elif nodeName_ == 'subscript':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'subscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_subscript'):
              self.add_subscript(obj_.value)
            elif hasattr(self, 'set_subscript'):
              self.set_subscript(obj_.value)
        elif nodeName_ == 'superscript':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'superscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_superscript'):
              self.add_superscript(obj_.value)
            elif hasattr(self, 'set_superscript'):
              self.set_superscript(obj_.value)
        elif nodeName_ == 'center':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'center', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_center'):
              self.add_center(obj_.value)
            elif hasattr(self, 'set_center'):
              self.set_center(obj_.value)
        elif nodeName_ == 'small':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'small', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_small'):
              self.add_small(obj_.value)
            elif hasattr(self, 'set_small'):
              self.set_small(obj_.value)
        elif nodeName_ == 'htmlonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'htmlonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'htmlonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'htmlonly', valuestr_)
            self.content_.append(obj_)
            self.htmlonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'manonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'manonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'manonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'manonly', valuestr_)
            self.content_.append(obj_)
            self.manonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'xmlonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'xmlonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'xmlonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'xmlonly', valuestr_)
            self.content_.append(obj_)
            self.xmlonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'rtfonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'rtfonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'rtfonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'rtfonly', valuestr_)
            self.content_.append(obj_)
            self.rtfonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'latexonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'latexonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'latexonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'latexonly', valuestr_)
            self.content_.append(obj_)
            self.latexonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'dot' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'dot')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'dot')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'dot', valuestr_)
            self.content_.append(obj_)
            self.dot_nsprefix_ = child_.prefix
        elif nodeName_ == 'msc' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'msc')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'msc')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'msc', valuestr_)
            self.content_.append(obj_)
            self.msc_nsprefix_ = child_.prefix
        elif nodeName_ == 'anchor':
            obj_ = docAnchorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'anchor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_anchor'):
              self.add_anchor(obj_.value)
            elif hasattr(self, 'set_anchor'):
              self.set_anchor(obj_.value)
        elif nodeName_ == 'formula':
            obj_ = docFormulaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'formula', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_formula'):
              self.add_formula(obj_.value)
            elif hasattr(self, 'set_formula'):
              self.set_formula(obj_.value)
        elif nodeName_ == 'ref':
            obj_ = docRefTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ref', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ref'):
              self.add_ref(obj_.value)
            elif hasattr(self, 'set_ref'):
              self.set_ref(obj_.value)
        elif nodeName_ == 'copy':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'copy', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_copy'):
              self.add_copy(obj_.value)
            elif hasattr(self, 'set_copy'):
              self.set_copy(obj_.value)
        elif nodeName_ == 'trademark':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'trademark', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_trademark'):
              self.add_trademark(obj_.value)
            elif hasattr(self, 'set_trademark'):
              self.set_trademark(obj_.value)
        elif nodeName_ == 'registered':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'registered', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_registered'):
              self.add_registered(obj_.value)
            elif hasattr(self, 'set_registered'):
              self.set_registered(obj_.value)
        elif nodeName_ == 'lsquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lsquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lsquo'):
              self.add_lsquo(obj_.value)
            elif hasattr(self, 'set_lsquo'):
              self.set_lsquo(obj_.value)
        elif nodeName_ == 'rsquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rsquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rsquo'):
              self.add_rsquo(obj_.value)
            elif hasattr(self, 'set_rsquo'):
              self.set_rsquo(obj_.value)
        elif nodeName_ == 'ldquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ldquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ldquo'):
              self.add_ldquo(obj_.value)
            elif hasattr(self, 'set_ldquo'):
              self.set_ldquo(obj_.value)
        elif nodeName_ == 'rdquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rdquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rdquo'):
              self.add_rdquo(obj_.value)
            elif hasattr(self, 'set_rdquo'):
              self.set_rdquo(obj_.value)
        elif nodeName_ == 'ndash':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ndash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ndash'):
              self.add_ndash(obj_.value)
            elif hasattr(self, 'set_ndash'):
              self.set_ndash(obj_.value)
        elif nodeName_ == 'mdash':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'mdash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_mdash'):
              self.add_mdash(obj_.value)
            elif hasattr(self, 'set_mdash'):
              self.set_mdash(obj_.value)
        elif nodeName_ == 'umlaut':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'umlaut', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_umlaut'):
              self.add_umlaut(obj_.value)
            elif hasattr(self, 'set_umlaut'):
              self.set_umlaut(obj_.value)
        elif nodeName_ == 'acute':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'acute', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_acute'):
              self.add_acute(obj_.value)
            elif hasattr(self, 'set_acute'):
              self.set_acute(obj_.value)
        elif nodeName_ == 'grave':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'grave', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_grave'):
              self.add_grave(obj_.value)
            elif hasattr(self, 'set_grave'):
              self.set_grave(obj_.value)
        elif nodeName_ == 'circ':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'circ', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_circ'):
              self.add_circ(obj_.value)
            elif hasattr(self, 'set_circ'):
              self.set_circ(obj_.value)
        elif nodeName_ == 'slash':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'slash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_slash'):
              self.add_slash(obj_.value)
            elif hasattr(self, 'set_slash'):
              self.set_slash(obj_.value)
        elif nodeName_ == 'tilde':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tilde', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tilde'):
              self.add_tilde(obj_.value)
            elif hasattr(self, 'set_tilde'):
              self.set_tilde(obj_.value)
        elif nodeName_ == 'cedil':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'cedil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_cedil'):
              self.add_cedil(obj_.value)
            elif hasattr(self, 'set_cedil'):
              self.set_cedil(obj_.value)
        elif nodeName_ == 'ring':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ring', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ring'):
              self.add_ring(obj_.value)
            elif hasattr(self, 'set_ring'):
              self.set_ring(obj_.value)
        elif nodeName_ == 'szlig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'szlig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_szlig'):
              self.add_szlig(obj_.value)
            elif hasattr(self, 'set_szlig'):
              self.set_szlig(obj_.value)
        elif nodeName_ == 'nonbreakablespace':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nonbreakablespace', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nonbreakablespace'):
              self.add_nonbreakablespace(obj_.value)
            elif hasattr(self, 'set_nonbreakablespace'):
              self.set_nonbreakablespace(obj_.value)
        elif nodeName_ == 'aelig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'aelig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_aelig'):
              self.add_aelig(obj_.value)
            elif hasattr(self, 'set_aelig'):
              self.set_aelig(obj_.value)
        elif nodeName_ == 'AElig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'AElig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_AElig'):
              self.add_AElig(obj_.value)
            elif hasattr(self, 'set_AElig'):
              self.set_AElig(obj_.value)
        elif nodeName_ == 'Gamma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Gamma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Gamma'):
              self.add_Gamma(obj_.value)
            elif hasattr(self, 'set_Gamma'):
              self.set_Gamma(obj_.value)
        elif nodeName_ == 'Delta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Delta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Delta'):
              self.add_Delta(obj_.value)
            elif hasattr(self, 'set_Delta'):
              self.set_Delta(obj_.value)
        elif nodeName_ == 'Theta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Theta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Theta'):
              self.add_Theta(obj_.value)
            elif hasattr(self, 'set_Theta'):
              self.set_Theta(obj_.value)
        elif nodeName_ == 'Lambda':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Lambda', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Lambda'):
              self.add_Lambda(obj_.value)
            elif hasattr(self, 'set_Lambda'):
              self.set_Lambda(obj_.value)
        elif nodeName_ == 'Xi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Xi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Xi'):
              self.add_Xi(obj_.value)
            elif hasattr(self, 'set_Xi'):
              self.set_Xi(obj_.value)
        elif nodeName_ == 'Pi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Pi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Pi'):
              self.add_Pi(obj_.value)
            elif hasattr(self, 'set_Pi'):
              self.set_Pi(obj_.value)
        elif nodeName_ == 'Sigma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Sigma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Sigma'):
              self.add_Sigma(obj_.value)
            elif hasattr(self, 'set_Sigma'):
              self.set_Sigma(obj_.value)
        elif nodeName_ == 'Upsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Upsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Upsilon'):
              self.add_Upsilon(obj_.value)
            elif hasattr(self, 'set_Upsilon'):
              self.set_Upsilon(obj_.value)
        elif nodeName_ == 'Phi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Phi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Phi'):
              self.add_Phi(obj_.value)
            elif hasattr(self, 'set_Phi'):
              self.set_Phi(obj_.value)
        elif nodeName_ == 'Psi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Psi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Psi'):
              self.add_Psi(obj_.value)
            elif hasattr(self, 'set_Psi'):
              self.set_Psi(obj_.value)
        elif nodeName_ == 'Omega':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Omega', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Omega'):
              self.add_Omega(obj_.value)
            elif hasattr(self, 'set_Omega'):
              self.set_Omega(obj_.value)
        elif nodeName_ == 'alpha':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'alpha', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_alpha'):
              self.add_alpha(obj_.value)
            elif hasattr(self, 'set_alpha'):
              self.set_alpha(obj_.value)
        elif nodeName_ == 'beta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'beta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_beta'):
              self.add_beta(obj_.value)
            elif hasattr(self, 'set_beta'):
              self.set_beta(obj_.value)
        elif nodeName_ == 'gamma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'gamma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_gamma'):
              self.add_gamma(obj_.value)
            elif hasattr(self, 'set_gamma'):
              self.set_gamma(obj_.value)
        elif nodeName_ == 'delta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'delta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_delta'):
              self.add_delta(obj_.value)
            elif hasattr(self, 'set_delta'):
              self.set_delta(obj_.value)
        elif nodeName_ == 'epsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'epsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_epsilon'):
              self.add_epsilon(obj_.value)
            elif hasattr(self, 'set_epsilon'):
              self.set_epsilon(obj_.value)
        elif nodeName_ == 'zeta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'zeta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_zeta'):
              self.add_zeta(obj_.value)
            elif hasattr(self, 'set_zeta'):
              self.set_zeta(obj_.value)
        elif nodeName_ == 'eta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'eta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_eta'):
              self.add_eta(obj_.value)
            elif hasattr(self, 'set_eta'):
              self.set_eta(obj_.value)
        elif nodeName_ == 'theta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'theta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_theta'):
              self.add_theta(obj_.value)
            elif hasattr(self, 'set_theta'):
              self.set_theta(obj_.value)
        elif nodeName_ == 'iota':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'iota', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_iota'):
              self.add_iota(obj_.value)
            elif hasattr(self, 'set_iota'):
              self.set_iota(obj_.value)
        elif nodeName_ == 'kappa':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'kappa', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_kappa'):
              self.add_kappa(obj_.value)
            elif hasattr(self, 'set_kappa'):
              self.set_kappa(obj_.value)
        elif nodeName_ == 'lambda':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lambda', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lambda'):
              self.add_lambda(obj_.value)
            elif hasattr(self, 'set_lambda'):
              self.set_lambda(obj_.value)
        elif nodeName_ == 'mu':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'mu', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_mu'):
              self.add_mu(obj_.value)
            elif hasattr(self, 'set_mu'):
              self.set_mu(obj_.value)
        elif nodeName_ == 'nu':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nu', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nu'):
              self.add_nu(obj_.value)
            elif hasattr(self, 'set_nu'):
              self.set_nu(obj_.value)
        elif nodeName_ == 'xi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'xi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_xi'):
              self.add_xi(obj_.value)
            elif hasattr(self, 'set_xi'):
              self.set_xi(obj_.value)
        elif nodeName_ == 'pi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'pi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_pi'):
              self.add_pi(obj_.value)
            elif hasattr(self, 'set_pi'):
              self.set_pi(obj_.value)
        elif nodeName_ == 'rho':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rho', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rho'):
              self.add_rho(obj_.value)
            elif hasattr(self, 'set_rho'):
              self.set_rho(obj_.value)
        elif nodeName_ == 'sigma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sigma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sigma'):
              self.add_sigma(obj_.value)
            elif hasattr(self, 'set_sigma'):
              self.set_sigma(obj_.value)
        elif nodeName_ == 'tau':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tau', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tau'):
              self.add_tau(obj_.value)
            elif hasattr(self, 'set_tau'):
              self.set_tau(obj_.value)
        elif nodeName_ == 'upsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'upsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_upsilon'):
              self.add_upsilon(obj_.value)
            elif hasattr(self, 'set_upsilon'):
              self.set_upsilon(obj_.value)
        elif nodeName_ == 'phi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'phi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_phi'):
              self.add_phi(obj_.value)
            elif hasattr(self, 'set_phi'):
              self.set_phi(obj_.value)
        elif nodeName_ == 'chi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'chi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_chi'):
              self.add_chi(obj_.value)
            elif hasattr(self, 'set_chi'):
              self.set_chi(obj_.value)
        elif nodeName_ == 'psi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'psi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_psi'):
              self.add_psi(obj_.value)
            elif hasattr(self, 'set_psi'):
              self.set_psi(obj_.value)
        elif nodeName_ == 'omega':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'omega', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_omega'):
              self.add_omega(obj_.value)
            elif hasattr(self, 'set_omega'):
              self.set_omega(obj_.value)
        elif nodeName_ == 'sigmaf':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sigmaf', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sigmaf'):
              self.add_sigmaf(obj_.value)
            elif hasattr(self, 'set_sigmaf'):
              self.set_sigmaf(obj_.value)
        elif nodeName_ == 'sect':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect'):
              self.add_sect(obj_.value)
            elif hasattr(self, 'set_sect'):
              self.set_sect(obj_.value)
        elif nodeName_ == 'deg':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'deg', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_deg'):
              self.add_deg(obj_.value)
            elif hasattr(self, 'set_deg'):
              self.set_deg(obj_.value)
        elif nodeName_ == 'prime':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'prime', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_prime'):
              self.add_prime(obj_.value)
            elif hasattr(self, 'set_prime'):
              self.set_prime(obj_.value)
        elif nodeName_ == 'Prime':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Prime', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Prime'):
              self.add_Prime(obj_.value)
            elif hasattr(self, 'set_Prime'):
              self.set_Prime(obj_.value)
        elif nodeName_ == 'infin':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'infin', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_infin'):
              self.add_infin(obj_.value)
            elif hasattr(self, 'set_infin'):
              self.set_infin(obj_.value)
        elif nodeName_ == 'empty':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'empty', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_empty'):
              self.add_empty(obj_.value)
            elif hasattr(self, 'set_empty'):
              self.set_empty(obj_.value)
        elif nodeName_ == 'plusmn':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'plusmn', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_plusmn'):
              self.add_plusmn(obj_.value)
            elif hasattr(self, 'set_plusmn'):
              self.set_plusmn(obj_.value)
        elif nodeName_ == 'times':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'times', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_times'):
              self.add_times(obj_.value)
            elif hasattr(self, 'set_times'):
              self.set_times(obj_.value)
        elif nodeName_ == 'minus':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'minus', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_minus'):
              self.add_minus(obj_.value)
            elif hasattr(self, 'set_minus'):
              self.set_minus(obj_.value)
        elif nodeName_ == 'sdot':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sdot', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sdot'):
              self.add_sdot(obj_.value)
            elif hasattr(self, 'set_sdot'):
              self.set_sdot(obj_.value)
        elif nodeName_ == 'part':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'part', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_part'):
              self.add_part(obj_.value)
            elif hasattr(self, 'set_part'):
              self.set_part(obj_.value)
        elif nodeName_ == 'nabla':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nabla', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nabla'):
              self.add_nabla(obj_.value)
            elif hasattr(self, 'set_nabla'):
              self.set_nabla(obj_.value)
        elif nodeName_ == 'radic':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'radic', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_radic'):
              self.add_radic(obj_.value)
            elif hasattr(self, 'set_radic'):
              self.set_radic(obj_.value)
        elif nodeName_ == 'perp':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'perp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_perp'):
              self.add_perp(obj_.value)
            elif hasattr(self, 'set_perp'):
              self.set_perp(obj_.value)
        elif nodeName_ == 'sum':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sum', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sum'):
              self.add_sum(obj_.value)
            elif hasattr(self, 'set_sum'):
              self.set_sum(obj_.value)
        elif nodeName_ == 'int':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'int', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_int'):
              self.add_int(obj_.value)
            elif hasattr(self, 'set_int'):
              self.set_int(obj_.value)
        elif nodeName_ == 'prod':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'prod', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_prod'):
              self.add_prod(obj_.value)
            elif hasattr(self, 'set_prod'):
              self.set_prod(obj_.value)
        elif nodeName_ == 'sim':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sim', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sim'):
              self.add_sim(obj_.value)
            elif hasattr(self, 'set_sim'):
              self.set_sim(obj_.value)
        elif nodeName_ == 'asymp':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'asymp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_asymp'):
              self.add_asymp(obj_.value)
            elif hasattr(self, 'set_asymp'):
              self.set_asymp(obj_.value)
        elif nodeName_ == 'ne':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ne', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ne'):
              self.add_ne(obj_.value)
            elif hasattr(self, 'set_ne'):
              self.set_ne(obj_.value)
        elif nodeName_ == 'equiv':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'equiv', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_equiv'):
              self.add_equiv(obj_.value)
            elif hasattr(self, 'set_equiv'):
              self.set_equiv(obj_.value)
        elif nodeName_ == 'prop':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'prop', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_prop'):
              self.add_prop(obj_.value)
            elif hasattr(self, 'set_prop'):
              self.set_prop(obj_.value)
        elif nodeName_ == 'le':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'le', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_le'):
              self.add_le(obj_.value)
            elif hasattr(self, 'set_le'):
              self.set_le(obj_.value)
        elif nodeName_ == 'ge':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ge', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ge'):
              self.add_ge(obj_.value)
            elif hasattr(self, 'set_ge'):
              self.set_ge(obj_.value)
        elif nodeName_ == 'larr':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'larr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_larr'):
              self.add_larr(obj_.value)
            elif hasattr(self, 'set_larr'):
              self.set_larr(obj_.value)
        elif nodeName_ == 'rarr':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rarr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rarr'):
              self.add_rarr(obj_.value)
            elif hasattr(self, 'set_rarr'):
              self.set_rarr(obj_.value)
        elif nodeName_ == 'isin':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'isin', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_isin'):
              self.add_isin(obj_.value)
            elif hasattr(self, 'set_isin'):
              self.set_isin(obj_.value)
        elif nodeName_ == 'notin':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'notin', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_notin'):
              self.add_notin(obj_.value)
            elif hasattr(self, 'set_notin'):
              self.set_notin(obj_.value)
        elif nodeName_ == 'lceil':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lceil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lceil'):
              self.add_lceil(obj_.value)
            elif hasattr(self, 'set_lceil'):
              self.set_lceil(obj_.value)
        elif nodeName_ == 'rceil':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rceil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rceil'):
              self.add_rceil(obj_.value)
            elif hasattr(self, 'set_rceil'):
              self.set_rceil(obj_.value)
        elif nodeName_ == 'lfloor':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lfloor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lfloor'):
              self.add_lfloor(obj_.value)
            elif hasattr(self, 'set_lfloor'):
              self.set_lfloor(obj_.value)
        elif nodeName_ == 'rfloor':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rfloor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rfloor'):
              self.add_rfloor(obj_.value)
            elif hasattr(self, 'set_rfloor'):
              self.set_rfloor(obj_.value)
        elif nodeName_ == 'linebreak':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linebreak', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linebreak'):
              self.add_linebreak(obj_.value)
            elif hasattr(self, 'set_linebreak'):
              self.set_linebreak(obj_.value)
        elif nodeName_ == 'hruler':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'hruler', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_hruler'):
              self.add_hruler(obj_.value)
            elif hasattr(self, 'set_hruler'):
              self.set_hruler(obj_.value)
        elif nodeName_ == 'preformatted':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'preformatted', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_preformatted'):
              self.add_preformatted(obj_.value)
            elif hasattr(self, 'set_preformatted'):
              self.set_preformatted(obj_.value)
        elif nodeName_ == 'programlisting':
            obj_ = listingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'programlisting', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_programlisting'):
              self.add_programlisting(obj_.value)
            elif hasattr(self, 'set_programlisting'):
              self.set_programlisting(obj_.value)
        elif nodeName_ == 'verbatim' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'verbatim')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'verbatim')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'verbatim', valuestr_)
            self.content_.append(obj_)
            self.verbatim_nsprefix_ = child_.prefix
        elif nodeName_ == 'indexentry':
            obj_ = docIndexEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'indexentry', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_indexentry'):
              self.add_indexentry(obj_.value)
            elif hasattr(self, 'set_indexentry'):
              self.set_indexentry(obj_.value)
        elif nodeName_ == 'orderedlist':
            obj_ = docListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'orderedlist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_orderedlist'):
              self.add_orderedlist(obj_.value)
            elif hasattr(self, 'set_orderedlist'):
              self.set_orderedlist(obj_.value)
        elif nodeName_ == 'itemizedlist':
            obj_ = docListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'itemizedlist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_itemizedlist'):
              self.add_itemizedlist(obj_.value)
            elif hasattr(self, 'set_itemizedlist'):
              self.set_itemizedlist(obj_.value)
        elif nodeName_ == 'simplesect':
            obj_ = docSimpleSectType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'simplesect', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_simplesect'):
              self.add_simplesect(obj_.value)
            elif hasattr(self, 'set_simplesect'):
              self.set_simplesect(obj_.value)
        elif nodeName_ == 'title':
            obj_ = docTitleType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'title', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_title'):
              self.add_title(obj_.value)
            elif hasattr(self, 'set_title'):
              self.set_title(obj_.value)
        elif nodeName_ == 'variablelist':
            obj_ = docVariableListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'variablelist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_variablelist'):
              self.add_variablelist(obj_.value)
            elif hasattr(self, 'set_variablelist'):
              self.set_variablelist(obj_.value)
        elif nodeName_ == 'table':
            obj_ = docTableType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'table', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_table'):
              self.add_table(obj_.value)
            elif hasattr(self, 'set_table'):
              self.set_table(obj_.value)
        elif nodeName_ == 'heading':
            obj_ = docHeadingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'heading', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_heading'):
              self.add_heading(obj_.value)
            elif hasattr(self, 'set_heading'):
              self.set_heading(obj_.value)
        elif nodeName_ == 'image':
            obj_ = docImageType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'image', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_image'):
              self.add_image(obj_.value)
            elif hasattr(self, 'set_image'):
              self.set_image(obj_.value)
        elif nodeName_ == 'dotfile':
            obj_ = docFileType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'dotfile', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_dotfile'):
              self.add_dotfile(obj_.value)
            elif hasattr(self, 'set_dotfile'):
              self.set_dotfile(obj_.value)
        elif nodeName_ == 'mscfile':
            obj_ = docFileType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'mscfile', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_mscfile'):
              self.add_mscfile(obj_.value)
            elif hasattr(self, 'set_mscfile'):
              self.set_mscfile(obj_.value)
        elif nodeName_ == 'diafile':
            obj_ = docFileType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'diafile', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_diafile'):
              self.add_diafile(obj_.value)
            elif hasattr(self, 'set_diafile'):
              self.set_diafile(obj_.value)
        elif nodeName_ == 'toclist':
            obj_ = docTocListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'toclist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_toclist'):
              self.add_toclist(obj_.value)
            elif hasattr(self, 'set_toclist'):
              self.set_toclist(obj_.value)
        elif nodeName_ == 'language':
            obj_ = docLanguageType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'language', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_language'):
              self.add_language(obj_.value)
            elif hasattr(self, 'set_language'):
              self.set_language(obj_.value)
        elif nodeName_ == 'parameterlist':
            obj_ = docParamListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'parameterlist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_parameterlist'):
              self.add_parameterlist(obj_.value)
            elif hasattr(self, 'set_parameterlist'):
              self.set_parameterlist(obj_.value)
        elif nodeName_ == 'xrefsect':
            obj_ = docXRefSectType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'xrefsect', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_xrefsect'):
              self.add_xrefsect(obj_.value)
            elif hasattr(self, 'set_xrefsect'):
              self.set_xrefsect(obj_.value)
        elif nodeName_ == 'copydoc':
            obj_ = docCopyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'copydoc', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_copydoc'):
              self.add_copydoc(obj_.value)
            elif hasattr(self, 'set_copydoc'):
              self.set_copydoc(obj_.value)
        elif nodeName_ == 'blockquote':
            obj_ = docBlockQuoteType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'blockquote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_blockquote'):
              self.add_blockquote(obj_.value)
            elif hasattr(self, 'set_blockquote'):
              self.set_blockquote(obj_.value)
        elif nodeName_ == 'parblock':
            obj_ = docParBlockType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'parblock', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_parblock'):
              self.add_parblock(obj_.value)
            elif hasattr(self, 'set_parblock'):
              self.set_parblock(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docParaType


class docMarkupType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ulink=None, bold=None, emphasis=None, computeroutput=None, subscript=None, superscript=None, center=None, small=None, htmlonly=None, manonly=None, xmlonly=None, rtfonly=None, latexonly=None, dot=None, msc=None, anchor=None, formula=None, ref=None, copy=None, trademark=None, registered=None, lsquo=None, rsquo=None, ldquo=None, rdquo=None, ndash=None, mdash=None, umlaut=None, acute=None, grave=None, circ=None, slash=None, tilde=None, cedil=None, ring=None, szlig=None, nonbreakablespace=None, aelig=None, AElig=None, Gamma=None, Delta=None, Theta=None, Lambda=None, Xi=None, Pi=None, Sigma=None, Upsilon=None, Phi=None, Psi=None, Omega=None, alpha=None, beta=None, gamma=None, delta=None, epsilon=None, zeta=None, eta=None, theta=None, iota=None, kappa=None, lambda_=None, mu=None, nu=None, xi=None, pi=None, rho=None, sigma=None, tau=None, upsilon=None, phi=None, chi=None, psi=None, omega=None, sigmaf=None, sect=None, deg=None, prime=None, Prime=None, infin=None, empty=None, plusmn=None, times=None, minus=None, sdot=None, part=None, nabla=None, radic=None, perp=None, sum=None, int=None, prod=None, sim=None, asymp=None, ne=None, equiv=None, prop=None, le=None, ge=None, larr=None, rarr=None, isin=None, notin=None, lceil=None, rceil=None, lfloor=None, rfloor=None, linebreak=None, hruler=None, preformatted=None, programlisting=None, verbatim=None, indexentry=None, orderedlist=None, itemizedlist=None, simplesect=None, title=None, variablelist=None, table=None, heading=None, image=None, dotfile=None, mscfile=None, diafile=None, toclist=None, language=None, parameterlist=None, xrefsect=None, copydoc=None, blockquote=None, parblock=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ulink is None:
            self.ulink = []
        else:
            self.ulink = ulink
        self.ulink_nsprefix_ = None
        if bold is None:
            self.bold = []
        else:
            self.bold = bold
        self.bold_nsprefix_ = None
        if emphasis is None:
            self.emphasis = []
        else:
            self.emphasis = emphasis
        self.emphasis_nsprefix_ = None
        if computeroutput is None:
            self.computeroutput = []
        else:
            self.computeroutput = computeroutput
        self.computeroutput_nsprefix_ = None
        if subscript is None:
            self.subscript = []
        else:
            self.subscript = subscript
        self.subscript_nsprefix_ = None
        if superscript is None:
            self.superscript = []
        else:
            self.superscript = superscript
        self.superscript_nsprefix_ = None
        if center is None:
            self.center = []
        else:
            self.center = center
        self.center_nsprefix_ = None
        if small is None:
            self.small = []
        else:
            self.small = small
        self.small_nsprefix_ = None
        if htmlonly is None:
            self.htmlonly = []
        else:
            self.htmlonly = htmlonly
        self.htmlonly_nsprefix_ = None
        if manonly is None:
            self.manonly = []
        else:
            self.manonly = manonly
        self.manonly_nsprefix_ = None
        if xmlonly is None:
            self.xmlonly = []
        else:
            self.xmlonly = xmlonly
        self.xmlonly_nsprefix_ = None
        if rtfonly is None:
            self.rtfonly = []
        else:
            self.rtfonly = rtfonly
        self.rtfonly_nsprefix_ = None
        if latexonly is None:
            self.latexonly = []
        else:
            self.latexonly = latexonly
        self.latexonly_nsprefix_ = None
        if dot is None:
            self.dot = []
        else:
            self.dot = dot
        self.dot_nsprefix_ = None
        if msc is None:
            self.msc = []
        else:
            self.msc = msc
        self.msc_nsprefix_ = None
        if anchor is None:
            self.anchor = []
        else:
            self.anchor = anchor
        self.anchor_nsprefix_ = None
        if formula is None:
            self.formula = []
        else:
            self.formula = formula
        self.formula_nsprefix_ = None
        if ref is None:
            self.ref = []
        else:
            self.ref = ref
        self.ref_nsprefix_ = None
        if copy is None:
            self.copy = []
        else:
            self.copy = copy
        self.copy_nsprefix_ = None
        if trademark is None:
            self.trademark = []
        else:
            self.trademark = trademark
        self.trademark_nsprefix_ = None
        if registered is None:
            self.registered = []
        else:
            self.registered = registered
        self.registered_nsprefix_ = None
        if lsquo is None:
            self.lsquo = []
        else:
            self.lsquo = lsquo
        self.lsquo_nsprefix_ = None
        if rsquo is None:
            self.rsquo = []
        else:
            self.rsquo = rsquo
        self.rsquo_nsprefix_ = None
        if ldquo is None:
            self.ldquo = []
        else:
            self.ldquo = ldquo
        self.ldquo_nsprefix_ = None
        if rdquo is None:
            self.rdquo = []
        else:
            self.rdquo = rdquo
        self.rdquo_nsprefix_ = None
        if ndash is None:
            self.ndash = []
        else:
            self.ndash = ndash
        self.ndash_nsprefix_ = None
        if mdash is None:
            self.mdash = []
        else:
            self.mdash = mdash
        self.mdash_nsprefix_ = None
        if umlaut is None:
            self.umlaut = []
        else:
            self.umlaut = umlaut
        self.umlaut_nsprefix_ = None
        if acute is None:
            self.acute = []
        else:
            self.acute = acute
        self.acute_nsprefix_ = None
        if grave is None:
            self.grave = []
        else:
            self.grave = grave
        self.grave_nsprefix_ = None
        if circ is None:
            self.circ = []
        else:
            self.circ = circ
        self.circ_nsprefix_ = None
        if slash is None:
            self.slash = []
        else:
            self.slash = slash
        self.slash_nsprefix_ = None
        if tilde is None:
            self.tilde = []
        else:
            self.tilde = tilde
        self.tilde_nsprefix_ = None
        if cedil is None:
            self.cedil = []
        else:
            self.cedil = cedil
        self.cedil_nsprefix_ = None
        if ring is None:
            self.ring = []
        else:
            self.ring = ring
        self.ring_nsprefix_ = None
        if szlig is None:
            self.szlig = []
        else:
            self.szlig = szlig
        self.szlig_nsprefix_ = None
        if nonbreakablespace is None:
            self.nonbreakablespace = []
        else:
            self.nonbreakablespace = nonbreakablespace
        self.nonbreakablespace_nsprefix_ = None
        if aelig is None:
            self.aelig = []
        else:
            self.aelig = aelig
        self.aelig_nsprefix_ = None
        if AElig is None:
            self.AElig = []
        else:
            self.AElig = AElig
        self.AElig_nsprefix_ = None
        if Gamma is None:
            self.Gamma = []
        else:
            self.Gamma = Gamma
        self.Gamma_nsprefix_ = None
        if Delta is None:
            self.Delta = []
        else:
            self.Delta = Delta
        self.Delta_nsprefix_ = None
        if Theta is None:
            self.Theta = []
        else:
            self.Theta = Theta
        self.Theta_nsprefix_ = None
        if Lambda is None:
            self.Lambda = []
        else:
            self.Lambda = Lambda
        self.Lambda_nsprefix_ = None
        if Xi is None:
            self.Xi = []
        else:
            self.Xi = Xi
        self.Xi_nsprefix_ = None
        if Pi is None:
            self.Pi = []
        else:
            self.Pi = Pi
        self.Pi_nsprefix_ = None
        if Sigma is None:
            self.Sigma = []
        else:
            self.Sigma = Sigma
        self.Sigma_nsprefix_ = None
        if Upsilon is None:
            self.Upsilon = []
        else:
            self.Upsilon = Upsilon
        self.Upsilon_nsprefix_ = None
        if Phi is None:
            self.Phi = []
        else:
            self.Phi = Phi
        self.Phi_nsprefix_ = None
        if Psi is None:
            self.Psi = []
        else:
            self.Psi = Psi
        self.Psi_nsprefix_ = None
        if Omega is None:
            self.Omega = []
        else:
            self.Omega = Omega
        self.Omega_nsprefix_ = None
        if alpha is None:
            self.alpha = []
        else:
            self.alpha = alpha
        self.alpha_nsprefix_ = None
        if beta is None:
            self.beta = []
        else:
            self.beta = beta
        self.beta_nsprefix_ = None
        if gamma is None:
            self.gamma = []
        else:
            self.gamma = gamma
        self.gamma_nsprefix_ = None
        if delta is None:
            self.delta = []
        else:
            self.delta = delta
        self.delta_nsprefix_ = None
        if epsilon is None:
            self.epsilon = []
        else:
            self.epsilon = epsilon
        self.epsilon_nsprefix_ = None
        if zeta is None:
            self.zeta = []
        else:
            self.zeta = zeta
        self.zeta_nsprefix_ = None
        if eta is None:
            self.eta = []
        else:
            self.eta = eta
        self.eta_nsprefix_ = None
        if theta is None:
            self.theta = []
        else:
            self.theta = theta
        self.theta_nsprefix_ = None
        if iota is None:
            self.iota = []
        else:
            self.iota = iota
        self.iota_nsprefix_ = None
        if kappa is None:
            self.kappa = []
        else:
            self.kappa = kappa
        self.kappa_nsprefix_ = None
        if lambda_ is None:
            self.lambda_ = []
        else:
            self.lambda_ = lambda_
        self.lambda__nsprefix_ = None
        if mu is None:
            self.mu = []
        else:
            self.mu = mu
        self.mu_nsprefix_ = None
        if nu is None:
            self.nu = []
        else:
            self.nu = nu
        self.nu_nsprefix_ = None
        if xi is None:
            self.xi = []
        else:
            self.xi = xi
        self.xi_nsprefix_ = None
        if pi is None:
            self.pi = []
        else:
            self.pi = pi
        self.pi_nsprefix_ = None
        if rho is None:
            self.rho = []
        else:
            self.rho = rho
        self.rho_nsprefix_ = None
        if sigma is None:
            self.sigma = []
        else:
            self.sigma = sigma
        self.sigma_nsprefix_ = None
        if tau is None:
            self.tau = []
        else:
            self.tau = tau
        self.tau_nsprefix_ = None
        if upsilon is None:
            self.upsilon = []
        else:
            self.upsilon = upsilon
        self.upsilon_nsprefix_ = None
        if phi is None:
            self.phi = []
        else:
            self.phi = phi
        self.phi_nsprefix_ = None
        if chi is None:
            self.chi = []
        else:
            self.chi = chi
        self.chi_nsprefix_ = None
        if psi is None:
            self.psi = []
        else:
            self.psi = psi
        self.psi_nsprefix_ = None
        if omega is None:
            self.omega = []
        else:
            self.omega = omega
        self.omega_nsprefix_ = None
        if sigmaf is None:
            self.sigmaf = []
        else:
            self.sigmaf = sigmaf
        self.sigmaf_nsprefix_ = None
        if sect is None:
            self.sect = []
        else:
            self.sect = sect
        self.sect_nsprefix_ = None
        if deg is None:
            self.deg = []
        else:
            self.deg = deg
        self.deg_nsprefix_ = None
        if prime is None:
            self.prime = []
        else:
            self.prime = prime
        self.prime_nsprefix_ = None
        if Prime is None:
            self.Prime = []
        else:
            self.Prime = Prime
        self.Prime_nsprefix_ = None
        if infin is None:
            self.infin = []
        else:
            self.infin = infin
        self.infin_nsprefix_ = None
        if empty is None:
            self.empty = []
        else:
            self.empty = empty
        self.empty_nsprefix_ = None
        if plusmn is None:
            self.plusmn = []
        else:
            self.plusmn = plusmn
        self.plusmn_nsprefix_ = None
        if times is None:
            self.times = []
        else:
            self.times = times
        self.times_nsprefix_ = None
        if minus is None:
            self.minus = []
        else:
            self.minus = minus
        self.minus_nsprefix_ = None
        if sdot is None:
            self.sdot = []
        else:
            self.sdot = sdot
        self.sdot_nsprefix_ = None
        if part is None:
            self.part = []
        else:
            self.part = part
        self.part_nsprefix_ = None
        if nabla is None:
            self.nabla = []
        else:
            self.nabla = nabla
        self.nabla_nsprefix_ = None
        if radic is None:
            self.radic = []
        else:
            self.radic = radic
        self.radic_nsprefix_ = None
        if perp is None:
            self.perp = []
        else:
            self.perp = perp
        self.perp_nsprefix_ = None
        if sum is None:
            self.sum = []
        else:
            self.sum = sum
        self.sum_nsprefix_ = None
        if int is None:
            self.int = []
        else:
            self.int = int
        self.int_nsprefix_ = None
        if prod is None:
            self.prod = []
        else:
            self.prod = prod
        self.prod_nsprefix_ = None
        if sim is None:
            self.sim = []
        else:
            self.sim = sim
        self.sim_nsprefix_ = None
        if asymp is None:
            self.asymp = []
        else:
            self.asymp = asymp
        self.asymp_nsprefix_ = None
        if ne is None:
            self.ne = []
        else:
            self.ne = ne
        self.ne_nsprefix_ = None
        if equiv is None:
            self.equiv = []
        else:
            self.equiv = equiv
        self.equiv_nsprefix_ = None
        if prop is None:
            self.prop = []
        else:
            self.prop = prop
        self.prop_nsprefix_ = None
        if le is None:
            self.le = []
        else:
            self.le = le
        self.le_nsprefix_ = None
        if ge is None:
            self.ge = []
        else:
            self.ge = ge
        self.ge_nsprefix_ = None
        if larr is None:
            self.larr = []
        else:
            self.larr = larr
        self.larr_nsprefix_ = None
        if rarr is None:
            self.rarr = []
        else:
            self.rarr = rarr
        self.rarr_nsprefix_ = None
        if isin is None:
            self.isin = []
        else:
            self.isin = isin
        self.isin_nsprefix_ = None
        if notin is None:
            self.notin = []
        else:
            self.notin = notin
        self.notin_nsprefix_ = None
        if lceil is None:
            self.lceil = []
        else:
            self.lceil = lceil
        self.lceil_nsprefix_ = None
        if rceil is None:
            self.rceil = []
        else:
            self.rceil = rceil
        self.rceil_nsprefix_ = None
        if lfloor is None:
            self.lfloor = []
        else:
            self.lfloor = lfloor
        self.lfloor_nsprefix_ = None
        if rfloor is None:
            self.rfloor = []
        else:
            self.rfloor = rfloor
        self.rfloor_nsprefix_ = None
        if linebreak is None:
            self.linebreak = []
        else:
            self.linebreak = linebreak
        self.linebreak_nsprefix_ = None
        if hruler is None:
            self.hruler = []
        else:
            self.hruler = hruler
        self.hruler_nsprefix_ = None
        if preformatted is None:
            self.preformatted = []
        else:
            self.preformatted = preformatted
        self.preformatted_nsprefix_ = None
        if programlisting is None:
            self.programlisting = []
        else:
            self.programlisting = programlisting
        self.programlisting_nsprefix_ = None
        if verbatim is None:
            self.verbatim = []
        else:
            self.verbatim = verbatim
        self.verbatim_nsprefix_ = None
        if indexentry is None:
            self.indexentry = []
        else:
            self.indexentry = indexentry
        self.indexentry_nsprefix_ = None
        if orderedlist is None:
            self.orderedlist = []
        else:
            self.orderedlist = orderedlist
        self.orderedlist_nsprefix_ = None
        if itemizedlist is None:
            self.itemizedlist = []
        else:
            self.itemizedlist = itemizedlist
        self.itemizedlist_nsprefix_ = None
        if simplesect is None:
            self.simplesect = []
        else:
            self.simplesect = simplesect
        self.simplesect_nsprefix_ = None
        if title is None:
            self.title = []
        else:
            self.title = title
        self.title_nsprefix_ = None
        if variablelist is None:
            self.variablelist = []
        else:
            self.variablelist = variablelist
        self.variablelist_nsprefix_ = None
        if table is None:
            self.table = []
        else:
            self.table = table
        self.table_nsprefix_ = None
        if heading is None:
            self.heading = []
        else:
            self.heading = heading
        self.heading_nsprefix_ = None
        if image is None:
            self.image = []
        else:
            self.image = image
        self.image_nsprefix_ = None
        if dotfile is None:
            self.dotfile = []
        else:
            self.dotfile = dotfile
        self.dotfile_nsprefix_ = None
        if mscfile is None:
            self.mscfile = []
        else:
            self.mscfile = mscfile
        self.mscfile_nsprefix_ = None
        if diafile is None:
            self.diafile = []
        else:
            self.diafile = diafile
        self.diafile_nsprefix_ = None
        if toclist is None:
            self.toclist = []
        else:
            self.toclist = toclist
        self.toclist_nsprefix_ = None
        if language is None:
            self.language = []
        else:
            self.language = language
        self.language_nsprefix_ = None
        if parameterlist is None:
            self.parameterlist = []
        else:
            self.parameterlist = parameterlist
        self.parameterlist_nsprefix_ = None
        if xrefsect is None:
            self.xrefsect = []
        else:
            self.xrefsect = xrefsect
        self.xrefsect_nsprefix_ = None
        if copydoc is None:
            self.copydoc = []
        else:
            self.copydoc = copydoc
        self.copydoc_nsprefix_ = None
        if blockquote is None:
            self.blockquote = []
        else:
            self.blockquote = blockquote
        self.blockquote_nsprefix_ = None
        if parblock is None:
            self.parblock = []
        else:
            self.parblock = parblock
        self.parblock_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docMarkupType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docMarkupType.subclass:
            return docMarkupType.subclass(*args_, **kwargs_)
        return docMarkupType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ulink(self):
        return self.ulink
    def set_ulink(self, ulink):
        self.ulink = ulink
    def add_ulink(self, value):
        self.ulink.append(value)
    def insert_ulink_at(self, index, value):
        self.ulink.insert(index, value)
    def replace_ulink_at(self, index, value):
        self.ulink[index] = value
    def get_bold(self):
        return self.bold
    def set_bold(self, bold):
        self.bold = bold
    def add_bold(self, value):
        self.bold.append(value)
    def insert_bold_at(self, index, value):
        self.bold.insert(index, value)
    def replace_bold_at(self, index, value):
        self.bold[index] = value
    def get_emphasis(self):
        return self.emphasis
    def set_emphasis(self, emphasis):
        self.emphasis = emphasis
    def add_emphasis(self, value):
        self.emphasis.append(value)
    def insert_emphasis_at(self, index, value):
        self.emphasis.insert(index, value)
    def replace_emphasis_at(self, index, value):
        self.emphasis[index] = value
    def get_computeroutput(self):
        return self.computeroutput
    def set_computeroutput(self, computeroutput):
        self.computeroutput = computeroutput
    def add_computeroutput(self, value):
        self.computeroutput.append(value)
    def insert_computeroutput_at(self, index, value):
        self.computeroutput.insert(index, value)
    def replace_computeroutput_at(self, index, value):
        self.computeroutput[index] = value
    def get_subscript(self):
        return self.subscript
    def set_subscript(self, subscript):
        self.subscript = subscript
    def add_subscript(self, value):
        self.subscript.append(value)
    def insert_subscript_at(self, index, value):
        self.subscript.insert(index, value)
    def replace_subscript_at(self, index, value):
        self.subscript[index] = value
    def get_superscript(self):
        return self.superscript
    def set_superscript(self, superscript):
        self.superscript = superscript
    def add_superscript(self, value):
        self.superscript.append(value)
    def insert_superscript_at(self, index, value):
        self.superscript.insert(index, value)
    def replace_superscript_at(self, index, value):
        self.superscript[index] = value
    def get_center(self):
        return self.center
    def set_center(self, center):
        self.center = center
    def add_center(self, value):
        self.center.append(value)
    def insert_center_at(self, index, value):
        self.center.insert(index, value)
    def replace_center_at(self, index, value):
        self.center[index] = value
    def get_small(self):
        return self.small
    def set_small(self, small):
        self.small = small
    def add_small(self, value):
        self.small.append(value)
    def insert_small_at(self, index, value):
        self.small.insert(index, value)
    def replace_small_at(self, index, value):
        self.small[index] = value
    def get_htmlonly(self):
        return self.htmlonly
    def set_htmlonly(self, htmlonly):
        self.htmlonly = htmlonly
    def add_htmlonly(self, value):
        self.htmlonly.append(value)
    def insert_htmlonly_at(self, index, value):
        self.htmlonly.insert(index, value)
    def replace_htmlonly_at(self, index, value):
        self.htmlonly[index] = value
    def get_manonly(self):
        return self.manonly
    def set_manonly(self, manonly):
        self.manonly = manonly
    def add_manonly(self, value):
        self.manonly.append(value)
    def insert_manonly_at(self, index, value):
        self.manonly.insert(index, value)
    def replace_manonly_at(self, index, value):
        self.manonly[index] = value
    def get_xmlonly(self):
        return self.xmlonly
    def set_xmlonly(self, xmlonly):
        self.xmlonly = xmlonly
    def add_xmlonly(self, value):
        self.xmlonly.append(value)
    def insert_xmlonly_at(self, index, value):
        self.xmlonly.insert(index, value)
    def replace_xmlonly_at(self, index, value):
        self.xmlonly[index] = value
    def get_rtfonly(self):
        return self.rtfonly
    def set_rtfonly(self, rtfonly):
        self.rtfonly = rtfonly
    def add_rtfonly(self, value):
        self.rtfonly.append(value)
    def insert_rtfonly_at(self, index, value):
        self.rtfonly.insert(index, value)
    def replace_rtfonly_at(self, index, value):
        self.rtfonly[index] = value
    def get_latexonly(self):
        return self.latexonly
    def set_latexonly(self, latexonly):
        self.latexonly = latexonly
    def add_latexonly(self, value):
        self.latexonly.append(value)
    def insert_latexonly_at(self, index, value):
        self.latexonly.insert(index, value)
    def replace_latexonly_at(self, index, value):
        self.latexonly[index] = value
    def get_dot(self):
        return self.dot
    def set_dot(self, dot):
        self.dot = dot
    def add_dot(self, value):
        self.dot.append(value)
    def insert_dot_at(self, index, value):
        self.dot.insert(index, value)
    def replace_dot_at(self, index, value):
        self.dot[index] = value
    def get_msc(self):
        return self.msc
    def set_msc(self, msc):
        self.msc = msc
    def add_msc(self, value):
        self.msc.append(value)
    def insert_msc_at(self, index, value):
        self.msc.insert(index, value)
    def replace_msc_at(self, index, value):
        self.msc[index] = value
    def get_anchor(self):
        return self.anchor
    def set_anchor(self, anchor):
        self.anchor = anchor
    def add_anchor(self, value):
        self.anchor.append(value)
    def insert_anchor_at(self, index, value):
        self.anchor.insert(index, value)
    def replace_anchor_at(self, index, value):
        self.anchor[index] = value
    def get_formula(self):
        return self.formula
    def set_formula(self, formula):
        self.formula = formula
    def add_formula(self, value):
        self.formula.append(value)
    def insert_formula_at(self, index, value):
        self.formula.insert(index, value)
    def replace_formula_at(self, index, value):
        self.formula[index] = value
    def get_ref(self):
        return self.ref
    def set_ref(self, ref):
        self.ref = ref
    def add_ref(self, value):
        self.ref.append(value)
    def insert_ref_at(self, index, value):
        self.ref.insert(index, value)
    def replace_ref_at(self, index, value):
        self.ref[index] = value
    def get_copy(self):
        return self.copy
    def set_copy(self, copy):
        self.copy = copy
    def add_copy(self, value):
        self.copy.append(value)
    def insert_copy_at(self, index, value):
        self.copy.insert(index, value)
    def replace_copy_at(self, index, value):
        self.copy[index] = value
    def get_trademark(self):
        return self.trademark
    def set_trademark(self, trademark):
        self.trademark = trademark
    def add_trademark(self, value):
        self.trademark.append(value)
    def insert_trademark_at(self, index, value):
        self.trademark.insert(index, value)
    def replace_trademark_at(self, index, value):
        self.trademark[index] = value
    def get_registered(self):
        return self.registered
    def set_registered(self, registered):
        self.registered = registered
    def add_registered(self, value):
        self.registered.append(value)
    def insert_registered_at(self, index, value):
        self.registered.insert(index, value)
    def replace_registered_at(self, index, value):
        self.registered[index] = value
    def get_lsquo(self):
        return self.lsquo
    def set_lsquo(self, lsquo):
        self.lsquo = lsquo
    def add_lsquo(self, value):
        self.lsquo.append(value)
    def insert_lsquo_at(self, index, value):
        self.lsquo.insert(index, value)
    def replace_lsquo_at(self, index, value):
        self.lsquo[index] = value
    def get_rsquo(self):
        return self.rsquo
    def set_rsquo(self, rsquo):
        self.rsquo = rsquo
    def add_rsquo(self, value):
        self.rsquo.append(value)
    def insert_rsquo_at(self, index, value):
        self.rsquo.insert(index, value)
    def replace_rsquo_at(self, index, value):
        self.rsquo[index] = value
    def get_ldquo(self):
        return self.ldquo
    def set_ldquo(self, ldquo):
        self.ldquo = ldquo
    def add_ldquo(self, value):
        self.ldquo.append(value)
    def insert_ldquo_at(self, index, value):
        self.ldquo.insert(index, value)
    def replace_ldquo_at(self, index, value):
        self.ldquo[index] = value
    def get_rdquo(self):
        return self.rdquo
    def set_rdquo(self, rdquo):
        self.rdquo = rdquo
    def add_rdquo(self, value):
        self.rdquo.append(value)
    def insert_rdquo_at(self, index, value):
        self.rdquo.insert(index, value)
    def replace_rdquo_at(self, index, value):
        self.rdquo[index] = value
    def get_ndash(self):
        return self.ndash
    def set_ndash(self, ndash):
        self.ndash = ndash
    def add_ndash(self, value):
        self.ndash.append(value)
    def insert_ndash_at(self, index, value):
        self.ndash.insert(index, value)
    def replace_ndash_at(self, index, value):
        self.ndash[index] = value
    def get_mdash(self):
        return self.mdash
    def set_mdash(self, mdash):
        self.mdash = mdash
    def add_mdash(self, value):
        self.mdash.append(value)
    def insert_mdash_at(self, index, value):
        self.mdash.insert(index, value)
    def replace_mdash_at(self, index, value):
        self.mdash[index] = value
    def get_umlaut(self):
        return self.umlaut
    def set_umlaut(self, umlaut):
        self.umlaut = umlaut
    def add_umlaut(self, value):
        self.umlaut.append(value)
    def insert_umlaut_at(self, index, value):
        self.umlaut.insert(index, value)
    def replace_umlaut_at(self, index, value):
        self.umlaut[index] = value
    def get_acute(self):
        return self.acute
    def set_acute(self, acute):
        self.acute = acute
    def add_acute(self, value):
        self.acute.append(value)
    def insert_acute_at(self, index, value):
        self.acute.insert(index, value)
    def replace_acute_at(self, index, value):
        self.acute[index] = value
    def get_grave(self):
        return self.grave
    def set_grave(self, grave):
        self.grave = grave
    def add_grave(self, value):
        self.grave.append(value)
    def insert_grave_at(self, index, value):
        self.grave.insert(index, value)
    def replace_grave_at(self, index, value):
        self.grave[index] = value
    def get_circ(self):
        return self.circ
    def set_circ(self, circ):
        self.circ = circ
    def add_circ(self, value):
        self.circ.append(value)
    def insert_circ_at(self, index, value):
        self.circ.insert(index, value)
    def replace_circ_at(self, index, value):
        self.circ[index] = value
    def get_slash(self):
        return self.slash
    def set_slash(self, slash):
        self.slash = slash
    def add_slash(self, value):
        self.slash.append(value)
    def insert_slash_at(self, index, value):
        self.slash.insert(index, value)
    def replace_slash_at(self, index, value):
        self.slash[index] = value
    def get_tilde(self):
        return self.tilde
    def set_tilde(self, tilde):
        self.tilde = tilde
    def add_tilde(self, value):
        self.tilde.append(value)
    def insert_tilde_at(self, index, value):
        self.tilde.insert(index, value)
    def replace_tilde_at(self, index, value):
        self.tilde[index] = value
    def get_cedil(self):
        return self.cedil
    def set_cedil(self, cedil):
        self.cedil = cedil
    def add_cedil(self, value):
        self.cedil.append(value)
    def insert_cedil_at(self, index, value):
        self.cedil.insert(index, value)
    def replace_cedil_at(self, index, value):
        self.cedil[index] = value
    def get_ring(self):
        return self.ring
    def set_ring(self, ring):
        self.ring = ring
    def add_ring(self, value):
        self.ring.append(value)
    def insert_ring_at(self, index, value):
        self.ring.insert(index, value)
    def replace_ring_at(self, index, value):
        self.ring[index] = value
    def get_szlig(self):
        return self.szlig
    def set_szlig(self, szlig):
        self.szlig = szlig
    def add_szlig(self, value):
        self.szlig.append(value)
    def insert_szlig_at(self, index, value):
        self.szlig.insert(index, value)
    def replace_szlig_at(self, index, value):
        self.szlig[index] = value
    def get_nonbreakablespace(self):
        return self.nonbreakablespace
    def set_nonbreakablespace(self, nonbreakablespace):
        self.nonbreakablespace = nonbreakablespace
    def add_nonbreakablespace(self, value):
        self.nonbreakablespace.append(value)
    def insert_nonbreakablespace_at(self, index, value):
        self.nonbreakablespace.insert(index, value)
    def replace_nonbreakablespace_at(self, index, value):
        self.nonbreakablespace[index] = value
    def get_aelig(self):
        return self.aelig
    def set_aelig(self, aelig):
        self.aelig = aelig
    def add_aelig(self, value):
        self.aelig.append(value)
    def insert_aelig_at(self, index, value):
        self.aelig.insert(index, value)
    def replace_aelig_at(self, index, value):
        self.aelig[index] = value
    def get_AElig(self):
        return self.AElig
    def set_AElig(self, AElig):
        self.AElig = AElig
    def add_AElig(self, value):
        self.AElig.append(value)
    def insert_AElig_at(self, index, value):
        self.AElig.insert(index, value)
    def replace_AElig_at(self, index, value):
        self.AElig[index] = value
    def get_Gamma(self):
        return self.Gamma
    def set_Gamma(self, Gamma):
        self.Gamma = Gamma
    def add_Gamma(self, value):
        self.Gamma.append(value)
    def insert_Gamma_at(self, index, value):
        self.Gamma.insert(index, value)
    def replace_Gamma_at(self, index, value):
        self.Gamma[index] = value
    def get_Delta(self):
        return self.Delta
    def set_Delta(self, Delta):
        self.Delta = Delta
    def add_Delta(self, value):
        self.Delta.append(value)
    def insert_Delta_at(self, index, value):
        self.Delta.insert(index, value)
    def replace_Delta_at(self, index, value):
        self.Delta[index] = value
    def get_Theta(self):
        return self.Theta
    def set_Theta(self, Theta):
        self.Theta = Theta
    def add_Theta(self, value):
        self.Theta.append(value)
    def insert_Theta_at(self, index, value):
        self.Theta.insert(index, value)
    def replace_Theta_at(self, index, value):
        self.Theta[index] = value
    def get_Lambda(self):
        return self.Lambda
    def set_Lambda(self, Lambda):
        self.Lambda = Lambda
    def add_Lambda(self, value):
        self.Lambda.append(value)
    def insert_Lambda_at(self, index, value):
        self.Lambda.insert(index, value)
    def replace_Lambda_at(self, index, value):
        self.Lambda[index] = value
    def get_Xi(self):
        return self.Xi
    def set_Xi(self, Xi):
        self.Xi = Xi
    def add_Xi(self, value):
        self.Xi.append(value)
    def insert_Xi_at(self, index, value):
        self.Xi.insert(index, value)
    def replace_Xi_at(self, index, value):
        self.Xi[index] = value
    def get_Pi(self):
        return self.Pi
    def set_Pi(self, Pi):
        self.Pi = Pi
    def add_Pi(self, value):
        self.Pi.append(value)
    def insert_Pi_at(self, index, value):
        self.Pi.insert(index, value)
    def replace_Pi_at(self, index, value):
        self.Pi[index] = value
    def get_Sigma(self):
        return self.Sigma
    def set_Sigma(self, Sigma):
        self.Sigma = Sigma
    def add_Sigma(self, value):
        self.Sigma.append(value)
    def insert_Sigma_at(self, index, value):
        self.Sigma.insert(index, value)
    def replace_Sigma_at(self, index, value):
        self.Sigma[index] = value
    def get_Upsilon(self):
        return self.Upsilon
    def set_Upsilon(self, Upsilon):
        self.Upsilon = Upsilon
    def add_Upsilon(self, value):
        self.Upsilon.append(value)
    def insert_Upsilon_at(self, index, value):
        self.Upsilon.insert(index, value)
    def replace_Upsilon_at(self, index, value):
        self.Upsilon[index] = value
    def get_Phi(self):
        return self.Phi
    def set_Phi(self, Phi):
        self.Phi = Phi
    def add_Phi(self, value):
        self.Phi.append(value)
    def insert_Phi_at(self, index, value):
        self.Phi.insert(index, value)
    def replace_Phi_at(self, index, value):
        self.Phi[index] = value
    def get_Psi(self):
        return self.Psi
    def set_Psi(self, Psi):
        self.Psi = Psi
    def add_Psi(self, value):
        self.Psi.append(value)
    def insert_Psi_at(self, index, value):
        self.Psi.insert(index, value)
    def replace_Psi_at(self, index, value):
        self.Psi[index] = value
    def get_Omega(self):
        return self.Omega
    def set_Omega(self, Omega):
        self.Omega = Omega
    def add_Omega(self, value):
        self.Omega.append(value)
    def insert_Omega_at(self, index, value):
        self.Omega.insert(index, value)
    def replace_Omega_at(self, index, value):
        self.Omega[index] = value
    def get_alpha(self):
        return self.alpha
    def set_alpha(self, alpha):
        self.alpha = alpha
    def add_alpha(self, value):
        self.alpha.append(value)
    def insert_alpha_at(self, index, value):
        self.alpha.insert(index, value)
    def replace_alpha_at(self, index, value):
        self.alpha[index] = value
    def get_beta(self):
        return self.beta
    def set_beta(self, beta):
        self.beta = beta
    def add_beta(self, value):
        self.beta.append(value)
    def insert_beta_at(self, index, value):
        self.beta.insert(index, value)
    def replace_beta_at(self, index, value):
        self.beta[index] = value
    def get_gamma(self):
        return self.gamma
    def set_gamma(self, gamma):
        self.gamma = gamma
    def add_gamma(self, value):
        self.gamma.append(value)
    def insert_gamma_at(self, index, value):
        self.gamma.insert(index, value)
    def replace_gamma_at(self, index, value):
        self.gamma[index] = value
    def get_delta(self):
        return self.delta
    def set_delta(self, delta):
        self.delta = delta
    def add_delta(self, value):
        self.delta.append(value)
    def insert_delta_at(self, index, value):
        self.delta.insert(index, value)
    def replace_delta_at(self, index, value):
        self.delta[index] = value
    def get_epsilon(self):
        return self.epsilon
    def set_epsilon(self, epsilon):
        self.epsilon = epsilon
    def add_epsilon(self, value):
        self.epsilon.append(value)
    def insert_epsilon_at(self, index, value):
        self.epsilon.insert(index, value)
    def replace_epsilon_at(self, index, value):
        self.epsilon[index] = value
    def get_zeta(self):
        return self.zeta
    def set_zeta(self, zeta):
        self.zeta = zeta
    def add_zeta(self, value):
        self.zeta.append(value)
    def insert_zeta_at(self, index, value):
        self.zeta.insert(index, value)
    def replace_zeta_at(self, index, value):
        self.zeta[index] = value
    def get_eta(self):
        return self.eta
    def set_eta(self, eta):
        self.eta = eta
    def add_eta(self, value):
        self.eta.append(value)
    def insert_eta_at(self, index, value):
        self.eta.insert(index, value)
    def replace_eta_at(self, index, value):
        self.eta[index] = value
    def get_theta(self):
        return self.theta
    def set_theta(self, theta):
        self.theta = theta
    def add_theta(self, value):
        self.theta.append(value)
    def insert_theta_at(self, index, value):
        self.theta.insert(index, value)
    def replace_theta_at(self, index, value):
        self.theta[index] = value
    def get_iota(self):
        return self.iota
    def set_iota(self, iota):
        self.iota = iota
    def add_iota(self, value):
        self.iota.append(value)
    def insert_iota_at(self, index, value):
        self.iota.insert(index, value)
    def replace_iota_at(self, index, value):
        self.iota[index] = value
    def get_kappa(self):
        return self.kappa
    def set_kappa(self, kappa):
        self.kappa = kappa
    def add_kappa(self, value):
        self.kappa.append(value)
    def insert_kappa_at(self, index, value):
        self.kappa.insert(index, value)
    def replace_kappa_at(self, index, value):
        self.kappa[index] = value
    def get_lambda(self):
        return self.lambda_
    def set_lambda(self, lambda_):
        self.lambda_ = lambda_
    def add_lambda(self, value):
        self.lambda_.append(value)
    def insert_lambda_at(self, index, value):
        self.lambda_.insert(index, value)
    def replace_lambda_at(self, index, value):
        self.lambda_[index] = value
    def get_mu(self):
        return self.mu
    def set_mu(self, mu):
        self.mu = mu
    def add_mu(self, value):
        self.mu.append(value)
    def insert_mu_at(self, index, value):
        self.mu.insert(index, value)
    def replace_mu_at(self, index, value):
        self.mu[index] = value
    def get_nu(self):
        return self.nu
    def set_nu(self, nu):
        self.nu = nu
    def add_nu(self, value):
        self.nu.append(value)
    def insert_nu_at(self, index, value):
        self.nu.insert(index, value)
    def replace_nu_at(self, index, value):
        self.nu[index] = value
    def get_xi(self):
        return self.xi
    def set_xi(self, xi):
        self.xi = xi
    def add_xi(self, value):
        self.xi.append(value)
    def insert_xi_at(self, index, value):
        self.xi.insert(index, value)
    def replace_xi_at(self, index, value):
        self.xi[index] = value
    def get_pi(self):
        return self.pi
    def set_pi(self, pi):
        self.pi = pi
    def add_pi(self, value):
        self.pi.append(value)
    def insert_pi_at(self, index, value):
        self.pi.insert(index, value)
    def replace_pi_at(self, index, value):
        self.pi[index] = value
    def get_rho(self):
        return self.rho
    def set_rho(self, rho):
        self.rho = rho
    def add_rho(self, value):
        self.rho.append(value)
    def insert_rho_at(self, index, value):
        self.rho.insert(index, value)
    def replace_rho_at(self, index, value):
        self.rho[index] = value
    def get_sigma(self):
        return self.sigma
    def set_sigma(self, sigma):
        self.sigma = sigma
    def add_sigma(self, value):
        self.sigma.append(value)
    def insert_sigma_at(self, index, value):
        self.sigma.insert(index, value)
    def replace_sigma_at(self, index, value):
        self.sigma[index] = value
    def get_tau(self):
        return self.tau
    def set_tau(self, tau):
        self.tau = tau
    def add_tau(self, value):
        self.tau.append(value)
    def insert_tau_at(self, index, value):
        self.tau.insert(index, value)
    def replace_tau_at(self, index, value):
        self.tau[index] = value
    def get_upsilon(self):
        return self.upsilon
    def set_upsilon(self, upsilon):
        self.upsilon = upsilon
    def add_upsilon(self, value):
        self.upsilon.append(value)
    def insert_upsilon_at(self, index, value):
        self.upsilon.insert(index, value)
    def replace_upsilon_at(self, index, value):
        self.upsilon[index] = value
    def get_phi(self):
        return self.phi
    def set_phi(self, phi):
        self.phi = phi
    def add_phi(self, value):
        self.phi.append(value)
    def insert_phi_at(self, index, value):
        self.phi.insert(index, value)
    def replace_phi_at(self, index, value):
        self.phi[index] = value
    def get_chi(self):
        return self.chi
    def set_chi(self, chi):
        self.chi = chi
    def add_chi(self, value):
        self.chi.append(value)
    def insert_chi_at(self, index, value):
        self.chi.insert(index, value)
    def replace_chi_at(self, index, value):
        self.chi[index] = value
    def get_psi(self):
        return self.psi
    def set_psi(self, psi):
        self.psi = psi
    def add_psi(self, value):
        self.psi.append(value)
    def insert_psi_at(self, index, value):
        self.psi.insert(index, value)
    def replace_psi_at(self, index, value):
        self.psi[index] = value
    def get_omega(self):
        return self.omega
    def set_omega(self, omega):
        self.omega = omega
    def add_omega(self, value):
        self.omega.append(value)
    def insert_omega_at(self, index, value):
        self.omega.insert(index, value)
    def replace_omega_at(self, index, value):
        self.omega[index] = value
    def get_sigmaf(self):
        return self.sigmaf
    def set_sigmaf(self, sigmaf):
        self.sigmaf = sigmaf
    def add_sigmaf(self, value):
        self.sigmaf.append(value)
    def insert_sigmaf_at(self, index, value):
        self.sigmaf.insert(index, value)
    def replace_sigmaf_at(self, index, value):
        self.sigmaf[index] = value
    def get_sect(self):
        return self.sect
    def set_sect(self, sect):
        self.sect = sect
    def add_sect(self, value):
        self.sect.append(value)
    def insert_sect_at(self, index, value):
        self.sect.insert(index, value)
    def replace_sect_at(self, index, value):
        self.sect[index] = value
    def get_deg(self):
        return self.deg
    def set_deg(self, deg):
        self.deg = deg
    def add_deg(self, value):
        self.deg.append(value)
    def insert_deg_at(self, index, value):
        self.deg.insert(index, value)
    def replace_deg_at(self, index, value):
        self.deg[index] = value
    def get_prime(self):
        return self.prime
    def set_prime(self, prime):
        self.prime = prime
    def add_prime(self, value):
        self.prime.append(value)
    def insert_prime_at(self, index, value):
        self.prime.insert(index, value)
    def replace_prime_at(self, index, value):
        self.prime[index] = value
    def get_Prime(self):
        return self.Prime
    def set_Prime(self, Prime):
        self.Prime = Prime
    def add_Prime(self, value):
        self.Prime.append(value)
    def insert_Prime_at(self, index, value):
        self.Prime.insert(index, value)
    def replace_Prime_at(self, index, value):
        self.Prime[index] = value
    def get_infin(self):
        return self.infin
    def set_infin(self, infin):
        self.infin = infin
    def add_infin(self, value):
        self.infin.append(value)
    def insert_infin_at(self, index, value):
        self.infin.insert(index, value)
    def replace_infin_at(self, index, value):
        self.infin[index] = value
    def get_empty(self):
        return self.empty
    def set_empty(self, empty):
        self.empty = empty
    def add_empty(self, value):
        self.empty.append(value)
    def insert_empty_at(self, index, value):
        self.empty.insert(index, value)
    def replace_empty_at(self, index, value):
        self.empty[index] = value
    def get_plusmn(self):
        return self.plusmn
    def set_plusmn(self, plusmn):
        self.plusmn = plusmn
    def add_plusmn(self, value):
        self.plusmn.append(value)
    def insert_plusmn_at(self, index, value):
        self.plusmn.insert(index, value)
    def replace_plusmn_at(self, index, value):
        self.plusmn[index] = value
    def get_times(self):
        return self.times
    def set_times(self, times):
        self.times = times
    def add_times(self, value):
        self.times.append(value)
    def insert_times_at(self, index, value):
        self.times.insert(index, value)
    def replace_times_at(self, index, value):
        self.times[index] = value
    def get_minus(self):
        return self.minus
    def set_minus(self, minus):
        self.minus = minus
    def add_minus(self, value):
        self.minus.append(value)
    def insert_minus_at(self, index, value):
        self.minus.insert(index, value)
    def replace_minus_at(self, index, value):
        self.minus[index] = value
    def get_sdot(self):
        return self.sdot
    def set_sdot(self, sdot):
        self.sdot = sdot
    def add_sdot(self, value):
        self.sdot.append(value)
    def insert_sdot_at(self, index, value):
        self.sdot.insert(index, value)
    def replace_sdot_at(self, index, value):
        self.sdot[index] = value
    def get_part(self):
        return self.part
    def set_part(self, part):
        self.part = part
    def add_part(self, value):
        self.part.append(value)
    def insert_part_at(self, index, value):
        self.part.insert(index, value)
    def replace_part_at(self, index, value):
        self.part[index] = value
    def get_nabla(self):
        return self.nabla
    def set_nabla(self, nabla):
        self.nabla = nabla
    def add_nabla(self, value):
        self.nabla.append(value)
    def insert_nabla_at(self, index, value):
        self.nabla.insert(index, value)
    def replace_nabla_at(self, index, value):
        self.nabla[index] = value
    def get_radic(self):
        return self.radic
    def set_radic(self, radic):
        self.radic = radic
    def add_radic(self, value):
        self.radic.append(value)
    def insert_radic_at(self, index, value):
        self.radic.insert(index, value)
    def replace_radic_at(self, index, value):
        self.radic[index] = value
    def get_perp(self):
        return self.perp
    def set_perp(self, perp):
        self.perp = perp
    def add_perp(self, value):
        self.perp.append(value)
    def insert_perp_at(self, index, value):
        self.perp.insert(index, value)
    def replace_perp_at(self, index, value):
        self.perp[index] = value
    def get_sum(self):
        return self.sum
    def set_sum(self, sum):
        self.sum = sum
    def add_sum(self, value):
        self.sum.append(value)
    def insert_sum_at(self, index, value):
        self.sum.insert(index, value)
    def replace_sum_at(self, index, value):
        self.sum[index] = value
    def get_int(self):
        return self.int
    def set_int(self, int):
        self.int = int
    def add_int(self, value):
        self.int.append(value)
    def insert_int_at(self, index, value):
        self.int.insert(index, value)
    def replace_int_at(self, index, value):
        self.int[index] = value
    def get_prod(self):
        return self.prod
    def set_prod(self, prod):
        self.prod = prod
    def add_prod(self, value):
        self.prod.append(value)
    def insert_prod_at(self, index, value):
        self.prod.insert(index, value)
    def replace_prod_at(self, index, value):
        self.prod[index] = value
    def get_sim(self):
        return self.sim
    def set_sim(self, sim):
        self.sim = sim
    def add_sim(self, value):
        self.sim.append(value)
    def insert_sim_at(self, index, value):
        self.sim.insert(index, value)
    def replace_sim_at(self, index, value):
        self.sim[index] = value
    def get_asymp(self):
        return self.asymp
    def set_asymp(self, asymp):
        self.asymp = asymp
    def add_asymp(self, value):
        self.asymp.append(value)
    def insert_asymp_at(self, index, value):
        self.asymp.insert(index, value)
    def replace_asymp_at(self, index, value):
        self.asymp[index] = value
    def get_ne(self):
        return self.ne
    def set_ne(self, ne):
        self.ne = ne
    def add_ne(self, value):
        self.ne.append(value)
    def insert_ne_at(self, index, value):
        self.ne.insert(index, value)
    def replace_ne_at(self, index, value):
        self.ne[index] = value
    def get_equiv(self):
        return self.equiv
    def set_equiv(self, equiv):
        self.equiv = equiv
    def add_equiv(self, value):
        self.equiv.append(value)
    def insert_equiv_at(self, index, value):
        self.equiv.insert(index, value)
    def replace_equiv_at(self, index, value):
        self.equiv[index] = value
    def get_prop(self):
        return self.prop
    def set_prop(self, prop):
        self.prop = prop
    def add_prop(self, value):
        self.prop.append(value)
    def insert_prop_at(self, index, value):
        self.prop.insert(index, value)
    def replace_prop_at(self, index, value):
        self.prop[index] = value
    def get_le(self):
        return self.le
    def set_le(self, le):
        self.le = le
    def add_le(self, value):
        self.le.append(value)
    def insert_le_at(self, index, value):
        self.le.insert(index, value)
    def replace_le_at(self, index, value):
        self.le[index] = value
    def get_ge(self):
        return self.ge
    def set_ge(self, ge):
        self.ge = ge
    def add_ge(self, value):
        self.ge.append(value)
    def insert_ge_at(self, index, value):
        self.ge.insert(index, value)
    def replace_ge_at(self, index, value):
        self.ge[index] = value
    def get_larr(self):
        return self.larr
    def set_larr(self, larr):
        self.larr = larr
    def add_larr(self, value):
        self.larr.append(value)
    def insert_larr_at(self, index, value):
        self.larr.insert(index, value)
    def replace_larr_at(self, index, value):
        self.larr[index] = value
    def get_rarr(self):
        return self.rarr
    def set_rarr(self, rarr):
        self.rarr = rarr
    def add_rarr(self, value):
        self.rarr.append(value)
    def insert_rarr_at(self, index, value):
        self.rarr.insert(index, value)
    def replace_rarr_at(self, index, value):
        self.rarr[index] = value
    def get_isin(self):
        return self.isin
    def set_isin(self, isin):
        self.isin = isin
    def add_isin(self, value):
        self.isin.append(value)
    def insert_isin_at(self, index, value):
        self.isin.insert(index, value)
    def replace_isin_at(self, index, value):
        self.isin[index] = value
    def get_notin(self):
        return self.notin
    def set_notin(self, notin):
        self.notin = notin
    def add_notin(self, value):
        self.notin.append(value)
    def insert_notin_at(self, index, value):
        self.notin.insert(index, value)
    def replace_notin_at(self, index, value):
        self.notin[index] = value
    def get_lceil(self):
        return self.lceil
    def set_lceil(self, lceil):
        self.lceil = lceil
    def add_lceil(self, value):
        self.lceil.append(value)
    def insert_lceil_at(self, index, value):
        self.lceil.insert(index, value)
    def replace_lceil_at(self, index, value):
        self.lceil[index] = value
    def get_rceil(self):
        return self.rceil
    def set_rceil(self, rceil):
        self.rceil = rceil
    def add_rceil(self, value):
        self.rceil.append(value)
    def insert_rceil_at(self, index, value):
        self.rceil.insert(index, value)
    def replace_rceil_at(self, index, value):
        self.rceil[index] = value
    def get_lfloor(self):
        return self.lfloor
    def set_lfloor(self, lfloor):
        self.lfloor = lfloor
    def add_lfloor(self, value):
        self.lfloor.append(value)
    def insert_lfloor_at(self, index, value):
        self.lfloor.insert(index, value)
    def replace_lfloor_at(self, index, value):
        self.lfloor[index] = value
    def get_rfloor(self):
        return self.rfloor
    def set_rfloor(self, rfloor):
        self.rfloor = rfloor
    def add_rfloor(self, value):
        self.rfloor.append(value)
    def insert_rfloor_at(self, index, value):
        self.rfloor.insert(index, value)
    def replace_rfloor_at(self, index, value):
        self.rfloor[index] = value
    def get_linebreak(self):
        return self.linebreak
    def set_linebreak(self, linebreak):
        self.linebreak = linebreak
    def add_linebreak(self, value):
        self.linebreak.append(value)
    def insert_linebreak_at(self, index, value):
        self.linebreak.insert(index, value)
    def replace_linebreak_at(self, index, value):
        self.linebreak[index] = value
    def get_hruler(self):
        return self.hruler
    def set_hruler(self, hruler):
        self.hruler = hruler
    def add_hruler(self, value):
        self.hruler.append(value)
    def insert_hruler_at(self, index, value):
        self.hruler.insert(index, value)
    def replace_hruler_at(self, index, value):
        self.hruler[index] = value
    def get_preformatted(self):
        return self.preformatted
    def set_preformatted(self, preformatted):
        self.preformatted = preformatted
    def add_preformatted(self, value):
        self.preformatted.append(value)
    def insert_preformatted_at(self, index, value):
        self.preformatted.insert(index, value)
    def replace_preformatted_at(self, index, value):
        self.preformatted[index] = value
    def get_programlisting(self):
        return self.programlisting
    def set_programlisting(self, programlisting):
        self.programlisting = programlisting
    def add_programlisting(self, value):
        self.programlisting.append(value)
    def insert_programlisting_at(self, index, value):
        self.programlisting.insert(index, value)
    def replace_programlisting_at(self, index, value):
        self.programlisting[index] = value
    def get_verbatim(self):
        return self.verbatim
    def set_verbatim(self, verbatim):
        self.verbatim = verbatim
    def add_verbatim(self, value):
        self.verbatim.append(value)
    def insert_verbatim_at(self, index, value):
        self.verbatim.insert(index, value)
    def replace_verbatim_at(self, index, value):
        self.verbatim[index] = value
    def get_indexentry(self):
        return self.indexentry
    def set_indexentry(self, indexentry):
        self.indexentry = indexentry
    def add_indexentry(self, value):
        self.indexentry.append(value)
    def insert_indexentry_at(self, index, value):
        self.indexentry.insert(index, value)
    def replace_indexentry_at(self, index, value):
        self.indexentry[index] = value
    def get_orderedlist(self):
        return self.orderedlist
    def set_orderedlist(self, orderedlist):
        self.orderedlist = orderedlist
    def add_orderedlist(self, value):
        self.orderedlist.append(value)
    def insert_orderedlist_at(self, index, value):
        self.orderedlist.insert(index, value)
    def replace_orderedlist_at(self, index, value):
        self.orderedlist[index] = value
    def get_itemizedlist(self):
        return self.itemizedlist
    def set_itemizedlist(self, itemizedlist):
        self.itemizedlist = itemizedlist
    def add_itemizedlist(self, value):
        self.itemizedlist.append(value)
    def insert_itemizedlist_at(self, index, value):
        self.itemizedlist.insert(index, value)
    def replace_itemizedlist_at(self, index, value):
        self.itemizedlist[index] = value
    def get_simplesect(self):
        return self.simplesect
    def set_simplesect(self, simplesect):
        self.simplesect = simplesect
    def add_simplesect(self, value):
        self.simplesect.append(value)
    def insert_simplesect_at(self, index, value):
        self.simplesect.insert(index, value)
    def replace_simplesect_at(self, index, value):
        self.simplesect[index] = value
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def add_title(self, value):
        self.title.append(value)
    def insert_title_at(self, index, value):
        self.title.insert(index, value)
    def replace_title_at(self, index, value):
        self.title[index] = value
    def get_variablelist(self):
        return self.variablelist
    def set_variablelist(self, variablelist):
        self.variablelist = variablelist
    def add_variablelist(self, value):
        self.variablelist.append(value)
    def insert_variablelist_at(self, index, value):
        self.variablelist.insert(index, value)
    def replace_variablelist_at(self, index, value):
        self.variablelist[index] = value
    def get_table(self):
        return self.table
    def set_table(self, table):
        self.table = table
    def add_table(self, value):
        self.table.append(value)
    def insert_table_at(self, index, value):
        self.table.insert(index, value)
    def replace_table_at(self, index, value):
        self.table[index] = value
    def get_heading(self):
        return self.heading
    def set_heading(self, heading):
        self.heading = heading
    def add_heading(self, value):
        self.heading.append(value)
    def insert_heading_at(self, index, value):
        self.heading.insert(index, value)
    def replace_heading_at(self, index, value):
        self.heading[index] = value
    def get_image(self):
        return self.image
    def set_image(self, image):
        self.image = image
    def add_image(self, value):
        self.image.append(value)
    def insert_image_at(self, index, value):
        self.image.insert(index, value)
    def replace_image_at(self, index, value):
        self.image[index] = value
    def get_dotfile(self):
        return self.dotfile
    def set_dotfile(self, dotfile):
        self.dotfile = dotfile
    def add_dotfile(self, value):
        self.dotfile.append(value)
    def insert_dotfile_at(self, index, value):
        self.dotfile.insert(index, value)
    def replace_dotfile_at(self, index, value):
        self.dotfile[index] = value
    def get_mscfile(self):
        return self.mscfile
    def set_mscfile(self, mscfile):
        self.mscfile = mscfile
    def add_mscfile(self, value):
        self.mscfile.append(value)
    def insert_mscfile_at(self, index, value):
        self.mscfile.insert(index, value)
    def replace_mscfile_at(self, index, value):
        self.mscfile[index] = value
    def get_diafile(self):
        return self.diafile
    def set_diafile(self, diafile):
        self.diafile = diafile
    def add_diafile(self, value):
        self.diafile.append(value)
    def insert_diafile_at(self, index, value):
        self.diafile.insert(index, value)
    def replace_diafile_at(self, index, value):
        self.diafile[index] = value
    def get_toclist(self):
        return self.toclist
    def set_toclist(self, toclist):
        self.toclist = toclist
    def add_toclist(self, value):
        self.toclist.append(value)
    def insert_toclist_at(self, index, value):
        self.toclist.insert(index, value)
    def replace_toclist_at(self, index, value):
        self.toclist[index] = value
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def add_language(self, value):
        self.language.append(value)
    def insert_language_at(self, index, value):
        self.language.insert(index, value)
    def replace_language_at(self, index, value):
        self.language[index] = value
    def get_parameterlist(self):
        return self.parameterlist
    def set_parameterlist(self, parameterlist):
        self.parameterlist = parameterlist
    def add_parameterlist(self, value):
        self.parameterlist.append(value)
    def insert_parameterlist_at(self, index, value):
        self.parameterlist.insert(index, value)
    def replace_parameterlist_at(self, index, value):
        self.parameterlist[index] = value
    def get_xrefsect(self):
        return self.xrefsect
    def set_xrefsect(self, xrefsect):
        self.xrefsect = xrefsect
    def add_xrefsect(self, value):
        self.xrefsect.append(value)
    def insert_xrefsect_at(self, index, value):
        self.xrefsect.insert(index, value)
    def replace_xrefsect_at(self, index, value):
        self.xrefsect[index] = value
    def get_copydoc(self):
        return self.copydoc
    def set_copydoc(self, copydoc):
        self.copydoc = copydoc
    def add_copydoc(self, value):
        self.copydoc.append(value)
    def insert_copydoc_at(self, index, value):
        self.copydoc.insert(index, value)
    def replace_copydoc_at(self, index, value):
        self.copydoc[index] = value
    def get_blockquote(self):
        return self.blockquote
    def set_blockquote(self, blockquote):
        self.blockquote = blockquote
    def add_blockquote(self, value):
        self.blockquote.append(value)
    def insert_blockquote_at(self, index, value):
        self.blockquote.insert(index, value)
    def replace_blockquote_at(self, index, value):
        self.blockquote[index] = value
    def get_parblock(self):
        return self.parblock
    def set_parblock(self, parblock):
        self.parblock = parblock
    def add_parblock(self, value):
        self.parblock.append(value)
    def insert_parblock_at(self, index, value):
        self.parblock.insert(index, value)
    def replace_parblock_at(self, index, value):
        self.parblock[index] = value
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.ulink or
            self.bold or
            self.emphasis or
            self.computeroutput or
            self.subscript or
            self.superscript or
            self.center or
            self.small or
            self.htmlonly or
            self.manonly or
            self.xmlonly or
            self.rtfonly or
            self.latexonly or
            self.dot or
            self.msc or
            self.anchor or
            self.formula or
            self.ref or
            self.copy or
            self.trademark or
            self.registered or
            self.lsquo or
            self.rsquo or
            self.ldquo or
            self.rdquo or
            self.ndash or
            self.mdash or
            self.umlaut or
            self.acute or
            self.grave or
            self.circ or
            self.slash or
            self.tilde or
            self.cedil or
            self.ring or
            self.szlig or
            self.nonbreakablespace or
            self.aelig or
            self.AElig or
            self.Gamma or
            self.Delta or
            self.Theta or
            self.Lambda or
            self.Xi or
            self.Pi or
            self.Sigma or
            self.Upsilon or
            self.Phi or
            self.Psi or
            self.Omega or
            self.alpha or
            self.beta or
            self.gamma or
            self.delta or
            self.epsilon or
            self.zeta or
            self.eta or
            self.theta or
            self.iota or
            self.kappa or
            self.lambda_ or
            self.mu or
            self.nu or
            self.xi or
            self.pi or
            self.rho or
            self.sigma or
            self.tau or
            self.upsilon or
            self.phi or
            self.chi or
            self.psi or
            self.omega or
            self.sigmaf or
            self.sect or
            self.deg or
            self.prime or
            self.Prime or
            self.infin or
            self.empty or
            self.plusmn or
            self.times or
            self.minus or
            self.sdot or
            self.part or
            self.nabla or
            self.radic or
            self.perp or
            self.sum or
            self.int or
            self.prod or
            self.sim or
            self.asymp or
            self.ne or
            self.equiv or
            self.prop or
            self.le or
            self.ge or
            self.larr or
            self.rarr or
            self.isin or
            self.notin or
            self.lceil or
            self.rceil or
            self.lfloor or
            self.rfloor or
            self.linebreak or
            self.hruler or
            self.preformatted or
            self.programlisting or
            self.verbatim or
            self.indexentry or
            self.orderedlist or
            self.itemizedlist or
            self.simplesect or
            self.title or
            self.variablelist or
            self.table or
            self.heading or
            self.image or
            self.dotfile or
            self.mscfile or
            self.diafile or
            self.toclist or
            self.language or
            self.parameterlist or
            self.xrefsect or
            self.copydoc or
            self.blockquote or
            self.parblock or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docMarkupType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docMarkupType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docMarkupType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docMarkupType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docMarkupType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docMarkupType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docMarkupType', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ulink_ in self.ulink:
            namespaceprefix_ = self.ulink_nsprefix_ + ':' if (UseCapturedNS_ and self.ulink_nsprefix_) else ''
            ulink_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ulink', pretty_print=pretty_print)
        for bold_ in self.bold:
            namespaceprefix_ = self.bold_nsprefix_ + ':' if (UseCapturedNS_ and self.bold_nsprefix_) else ''
            bold_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bold', pretty_print=pretty_print)
        for emphasis_ in self.emphasis:
            namespaceprefix_ = self.emphasis_nsprefix_ + ':' if (UseCapturedNS_ and self.emphasis_nsprefix_) else ''
            emphasis_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='emphasis', pretty_print=pretty_print)
        for computeroutput_ in self.computeroutput:
            namespaceprefix_ = self.computeroutput_nsprefix_ + ':' if (UseCapturedNS_ and self.computeroutput_nsprefix_) else ''
            computeroutput_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='computeroutput', pretty_print=pretty_print)
        for subscript_ in self.subscript:
            namespaceprefix_ = self.subscript_nsprefix_ + ':' if (UseCapturedNS_ and self.subscript_nsprefix_) else ''
            subscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subscript', pretty_print=pretty_print)
        for superscript_ in self.superscript:
            namespaceprefix_ = self.superscript_nsprefix_ + ':' if (UseCapturedNS_ and self.superscript_nsprefix_) else ''
            superscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='superscript', pretty_print=pretty_print)
        for center_ in self.center:
            namespaceprefix_ = self.center_nsprefix_ + ':' if (UseCapturedNS_ and self.center_nsprefix_) else ''
            center_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='center', pretty_print=pretty_print)
        for small_ in self.small:
            namespaceprefix_ = self.small_nsprefix_ + ':' if (UseCapturedNS_ and self.small_nsprefix_) else ''
            small_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='small', pretty_print=pretty_print)
        for htmlonly_ in self.htmlonly:
            namespaceprefix_ = self.htmlonly_nsprefix_ + ':' if (UseCapturedNS_ and self.htmlonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shtmlonly>%s</%shtmlonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(htmlonly_), input_name='htmlonly')), namespaceprefix_ , eol_))
        for manonly_ in self.manonly:
            namespaceprefix_ = self.manonly_nsprefix_ + ':' if (UseCapturedNS_ and self.manonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanonly>%s</%smanonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(manonly_), input_name='manonly')), namespaceprefix_ , eol_))
        for xmlonly_ in self.xmlonly:
            namespaceprefix_ = self.xmlonly_nsprefix_ + ':' if (UseCapturedNS_ and self.xmlonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxmlonly>%s</%sxmlonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(xmlonly_), input_name='xmlonly')), namespaceprefix_ , eol_))
        for rtfonly_ in self.rtfonly:
            namespaceprefix_ = self.rtfonly_nsprefix_ + ':' if (UseCapturedNS_ and self.rtfonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srtfonly>%s</%srtfonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(rtfonly_), input_name='rtfonly')), namespaceprefix_ , eol_))
        for latexonly_ in self.latexonly:
            namespaceprefix_ = self.latexonly_nsprefix_ + ':' if (UseCapturedNS_ and self.latexonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slatexonly>%s</%slatexonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(latexonly_), input_name='latexonly')), namespaceprefix_ , eol_))
        for dot_ in self.dot:
            namespaceprefix_ = self.dot_nsprefix_ + ':' if (UseCapturedNS_ and self.dot_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdot>%s</%sdot>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(dot_), input_name='dot')), namespaceprefix_ , eol_))
        for msc_ in self.msc:
            namespaceprefix_ = self.msc_nsprefix_ + ':' if (UseCapturedNS_ and self.msc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smsc>%s</%smsc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(msc_), input_name='msc')), namespaceprefix_ , eol_))
        for anchor_ in self.anchor:
            namespaceprefix_ = self.anchor_nsprefix_ + ':' if (UseCapturedNS_ and self.anchor_nsprefix_) else ''
            anchor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='anchor', pretty_print=pretty_print)
        for formula_ in self.formula:
            namespaceprefix_ = self.formula_nsprefix_ + ':' if (UseCapturedNS_ and self.formula_nsprefix_) else ''
            formula_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='formula', pretty_print=pretty_print)
        for ref_ in self.ref:
            namespaceprefix_ = self.ref_nsprefix_ + ':' if (UseCapturedNS_ and self.ref_nsprefix_) else ''
            ref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ref', pretty_print=pretty_print)
        for copy_ in self.copy:
            namespaceprefix_ = self.copy_nsprefix_ + ':' if (UseCapturedNS_ and self.copy_nsprefix_) else ''
            copy_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='copy', pretty_print=pretty_print)
        for trademark_ in self.trademark:
            namespaceprefix_ = self.trademark_nsprefix_ + ':' if (UseCapturedNS_ and self.trademark_nsprefix_) else ''
            trademark_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='trademark', pretty_print=pretty_print)
        for registered_ in self.registered:
            namespaceprefix_ = self.registered_nsprefix_ + ':' if (UseCapturedNS_ and self.registered_nsprefix_) else ''
            registered_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='registered', pretty_print=pretty_print)
        for lsquo_ in self.lsquo:
            namespaceprefix_ = self.lsquo_nsprefix_ + ':' if (UseCapturedNS_ and self.lsquo_nsprefix_) else ''
            lsquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lsquo', pretty_print=pretty_print)
        for rsquo_ in self.rsquo:
            namespaceprefix_ = self.rsquo_nsprefix_ + ':' if (UseCapturedNS_ and self.rsquo_nsprefix_) else ''
            rsquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rsquo', pretty_print=pretty_print)
        for ldquo_ in self.ldquo:
            namespaceprefix_ = self.ldquo_nsprefix_ + ':' if (UseCapturedNS_ and self.ldquo_nsprefix_) else ''
            ldquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ldquo', pretty_print=pretty_print)
        for rdquo_ in self.rdquo:
            namespaceprefix_ = self.rdquo_nsprefix_ + ':' if (UseCapturedNS_ and self.rdquo_nsprefix_) else ''
            rdquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rdquo', pretty_print=pretty_print)
        for ndash_ in self.ndash:
            namespaceprefix_ = self.ndash_nsprefix_ + ':' if (UseCapturedNS_ and self.ndash_nsprefix_) else ''
            ndash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ndash', pretty_print=pretty_print)
        for mdash_ in self.mdash:
            namespaceprefix_ = self.mdash_nsprefix_ + ':' if (UseCapturedNS_ and self.mdash_nsprefix_) else ''
            mdash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mdash', pretty_print=pretty_print)
        for umlaut_ in self.umlaut:
            namespaceprefix_ = self.umlaut_nsprefix_ + ':' if (UseCapturedNS_ and self.umlaut_nsprefix_) else ''
            umlaut_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='umlaut', pretty_print=pretty_print)
        for acute_ in self.acute:
            namespaceprefix_ = self.acute_nsprefix_ + ':' if (UseCapturedNS_ and self.acute_nsprefix_) else ''
            acute_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acute', pretty_print=pretty_print)
        for grave_ in self.grave:
            namespaceprefix_ = self.grave_nsprefix_ + ':' if (UseCapturedNS_ and self.grave_nsprefix_) else ''
            grave_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='grave', pretty_print=pretty_print)
        for circ_ in self.circ:
            namespaceprefix_ = self.circ_nsprefix_ + ':' if (UseCapturedNS_ and self.circ_nsprefix_) else ''
            circ_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='circ', pretty_print=pretty_print)
        for slash_ in self.slash:
            namespaceprefix_ = self.slash_nsprefix_ + ':' if (UseCapturedNS_ and self.slash_nsprefix_) else ''
            slash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='slash', pretty_print=pretty_print)
        for tilde_ in self.tilde:
            namespaceprefix_ = self.tilde_nsprefix_ + ':' if (UseCapturedNS_ and self.tilde_nsprefix_) else ''
            tilde_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tilde', pretty_print=pretty_print)
        for cedil_ in self.cedil:
            namespaceprefix_ = self.cedil_nsprefix_ + ':' if (UseCapturedNS_ and self.cedil_nsprefix_) else ''
            cedil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cedil', pretty_print=pretty_print)
        for ring_ in self.ring:
            namespaceprefix_ = self.ring_nsprefix_ + ':' if (UseCapturedNS_ and self.ring_nsprefix_) else ''
            ring_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ring', pretty_print=pretty_print)
        for szlig_ in self.szlig:
            namespaceprefix_ = self.szlig_nsprefix_ + ':' if (UseCapturedNS_ and self.szlig_nsprefix_) else ''
            szlig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='szlig', pretty_print=pretty_print)
        for nonbreakablespace_ in self.nonbreakablespace:
            namespaceprefix_ = self.nonbreakablespace_nsprefix_ + ':' if (UseCapturedNS_ and self.nonbreakablespace_nsprefix_) else ''
            nonbreakablespace_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nonbreakablespace', pretty_print=pretty_print)
        for aelig_ in self.aelig:
            namespaceprefix_ = self.aelig_nsprefix_ + ':' if (UseCapturedNS_ and self.aelig_nsprefix_) else ''
            aelig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='aelig', pretty_print=pretty_print)
        for AElig_ in self.AElig:
            namespaceprefix_ = self.AElig_nsprefix_ + ':' if (UseCapturedNS_ and self.AElig_nsprefix_) else ''
            AElig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AElig', pretty_print=pretty_print)
        for Gamma_ in self.Gamma:
            namespaceprefix_ = self.Gamma_nsprefix_ + ':' if (UseCapturedNS_ and self.Gamma_nsprefix_) else ''
            Gamma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Gamma', pretty_print=pretty_print)
        for Delta_ in self.Delta:
            namespaceprefix_ = self.Delta_nsprefix_ + ':' if (UseCapturedNS_ and self.Delta_nsprefix_) else ''
            Delta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Delta', pretty_print=pretty_print)
        for Theta_ in self.Theta:
            namespaceprefix_ = self.Theta_nsprefix_ + ':' if (UseCapturedNS_ and self.Theta_nsprefix_) else ''
            Theta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Theta', pretty_print=pretty_print)
        for Lambda_ in self.Lambda:
            namespaceprefix_ = self.Lambda_nsprefix_ + ':' if (UseCapturedNS_ and self.Lambda_nsprefix_) else ''
            Lambda_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Lambda', pretty_print=pretty_print)
        for Xi_ in self.Xi:
            namespaceprefix_ = self.Xi_nsprefix_ + ':' if (UseCapturedNS_ and self.Xi_nsprefix_) else ''
            Xi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Xi', pretty_print=pretty_print)
        for Pi_ in self.Pi:
            namespaceprefix_ = self.Pi_nsprefix_ + ':' if (UseCapturedNS_ and self.Pi_nsprefix_) else ''
            Pi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Pi', pretty_print=pretty_print)
        for Sigma_ in self.Sigma:
            namespaceprefix_ = self.Sigma_nsprefix_ + ':' if (UseCapturedNS_ and self.Sigma_nsprefix_) else ''
            Sigma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Sigma', pretty_print=pretty_print)
        for Upsilon_ in self.Upsilon:
            namespaceprefix_ = self.Upsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.Upsilon_nsprefix_) else ''
            Upsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Upsilon', pretty_print=pretty_print)
        for Phi_ in self.Phi:
            namespaceprefix_ = self.Phi_nsprefix_ + ':' if (UseCapturedNS_ and self.Phi_nsprefix_) else ''
            Phi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Phi', pretty_print=pretty_print)
        for Psi_ in self.Psi:
            namespaceprefix_ = self.Psi_nsprefix_ + ':' if (UseCapturedNS_ and self.Psi_nsprefix_) else ''
            Psi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Psi', pretty_print=pretty_print)
        for Omega_ in self.Omega:
            namespaceprefix_ = self.Omega_nsprefix_ + ':' if (UseCapturedNS_ and self.Omega_nsprefix_) else ''
            Omega_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Omega', pretty_print=pretty_print)
        for alpha_ in self.alpha:
            namespaceprefix_ = self.alpha_nsprefix_ + ':' if (UseCapturedNS_ and self.alpha_nsprefix_) else ''
            alpha_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alpha', pretty_print=pretty_print)
        for beta_ in self.beta:
            namespaceprefix_ = self.beta_nsprefix_ + ':' if (UseCapturedNS_ and self.beta_nsprefix_) else ''
            beta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='beta', pretty_print=pretty_print)
        for gamma_ in self.gamma:
            namespaceprefix_ = self.gamma_nsprefix_ + ':' if (UseCapturedNS_ and self.gamma_nsprefix_) else ''
            gamma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='gamma', pretty_print=pretty_print)
        for delta_ in self.delta:
            namespaceprefix_ = self.delta_nsprefix_ + ':' if (UseCapturedNS_ and self.delta_nsprefix_) else ''
            delta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='delta', pretty_print=pretty_print)
        for epsilon_ in self.epsilon:
            namespaceprefix_ = self.epsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.epsilon_nsprefix_) else ''
            epsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='epsilon', pretty_print=pretty_print)
        for zeta_ in self.zeta:
            namespaceprefix_ = self.zeta_nsprefix_ + ':' if (UseCapturedNS_ and self.zeta_nsprefix_) else ''
            zeta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='zeta', pretty_print=pretty_print)
        for eta_ in self.eta:
            namespaceprefix_ = self.eta_nsprefix_ + ':' if (UseCapturedNS_ and self.eta_nsprefix_) else ''
            eta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='eta', pretty_print=pretty_print)
        for theta_ in self.theta:
            namespaceprefix_ = self.theta_nsprefix_ + ':' if (UseCapturedNS_ and self.theta_nsprefix_) else ''
            theta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='theta', pretty_print=pretty_print)
        for iota_ in self.iota:
            namespaceprefix_ = self.iota_nsprefix_ + ':' if (UseCapturedNS_ and self.iota_nsprefix_) else ''
            iota_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='iota', pretty_print=pretty_print)
        for kappa_ in self.kappa:
            namespaceprefix_ = self.kappa_nsprefix_ + ':' if (UseCapturedNS_ and self.kappa_nsprefix_) else ''
            kappa_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='kappa', pretty_print=pretty_print)
        for lambda_ in self.lambda_:
            namespaceprefix_ = self.lambda__nsprefix_ + ':' if (UseCapturedNS_ and self.lambda__nsprefix_) else ''
            lambda_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lambda', pretty_print=pretty_print)
        for mu_ in self.mu:
            namespaceprefix_ = self.mu_nsprefix_ + ':' if (UseCapturedNS_ and self.mu_nsprefix_) else ''
            mu_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mu', pretty_print=pretty_print)
        for nu_ in self.nu:
            namespaceprefix_ = self.nu_nsprefix_ + ':' if (UseCapturedNS_ and self.nu_nsprefix_) else ''
            nu_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nu', pretty_print=pretty_print)
        for xi_ in self.xi:
            namespaceprefix_ = self.xi_nsprefix_ + ':' if (UseCapturedNS_ and self.xi_nsprefix_) else ''
            xi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='xi', pretty_print=pretty_print)
        for pi_ in self.pi:
            namespaceprefix_ = self.pi_nsprefix_ + ':' if (UseCapturedNS_ and self.pi_nsprefix_) else ''
            pi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pi', pretty_print=pretty_print)
        for rho_ in self.rho:
            namespaceprefix_ = self.rho_nsprefix_ + ':' if (UseCapturedNS_ and self.rho_nsprefix_) else ''
            rho_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rho', pretty_print=pretty_print)
        for sigma_ in self.sigma:
            namespaceprefix_ = self.sigma_nsprefix_ + ':' if (UseCapturedNS_ and self.sigma_nsprefix_) else ''
            sigma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sigma', pretty_print=pretty_print)
        for tau_ in self.tau:
            namespaceprefix_ = self.tau_nsprefix_ + ':' if (UseCapturedNS_ and self.tau_nsprefix_) else ''
            tau_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tau', pretty_print=pretty_print)
        for upsilon_ in self.upsilon:
            namespaceprefix_ = self.upsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.upsilon_nsprefix_) else ''
            upsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='upsilon', pretty_print=pretty_print)
        for phi_ in self.phi:
            namespaceprefix_ = self.phi_nsprefix_ + ':' if (UseCapturedNS_ and self.phi_nsprefix_) else ''
            phi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='phi', pretty_print=pretty_print)
        for chi_ in self.chi:
            namespaceprefix_ = self.chi_nsprefix_ + ':' if (UseCapturedNS_ and self.chi_nsprefix_) else ''
            chi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='chi', pretty_print=pretty_print)
        for psi_ in self.psi:
            namespaceprefix_ = self.psi_nsprefix_ + ':' if (UseCapturedNS_ and self.psi_nsprefix_) else ''
            psi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='psi', pretty_print=pretty_print)
        for omega_ in self.omega:
            namespaceprefix_ = self.omega_nsprefix_ + ':' if (UseCapturedNS_ and self.omega_nsprefix_) else ''
            omega_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='omega', pretty_print=pretty_print)
        for sigmaf_ in self.sigmaf:
            namespaceprefix_ = self.sigmaf_nsprefix_ + ':' if (UseCapturedNS_ and self.sigmaf_nsprefix_) else ''
            sigmaf_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sigmaf', pretty_print=pretty_print)
        for sect_ in self.sect:
            namespaceprefix_ = self.sect_nsprefix_ + ':' if (UseCapturedNS_ and self.sect_nsprefix_) else ''
            sect_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect', pretty_print=pretty_print)
        for deg_ in self.deg:
            namespaceprefix_ = self.deg_nsprefix_ + ':' if (UseCapturedNS_ and self.deg_nsprefix_) else ''
            deg_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='deg', pretty_print=pretty_print)
        for prime_ in self.prime:
            namespaceprefix_ = self.prime_nsprefix_ + ':' if (UseCapturedNS_ and self.prime_nsprefix_) else ''
            prime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prime', pretty_print=pretty_print)
        for Prime_ in self.Prime:
            namespaceprefix_ = self.Prime_nsprefix_ + ':' if (UseCapturedNS_ and self.Prime_nsprefix_) else ''
            Prime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Prime', pretty_print=pretty_print)
        for infin_ in self.infin:
            namespaceprefix_ = self.infin_nsprefix_ + ':' if (UseCapturedNS_ and self.infin_nsprefix_) else ''
            infin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infin', pretty_print=pretty_print)
        for empty_ in self.empty:
            namespaceprefix_ = self.empty_nsprefix_ + ':' if (UseCapturedNS_ and self.empty_nsprefix_) else ''
            empty_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='empty', pretty_print=pretty_print)
        for plusmn_ in self.plusmn:
            namespaceprefix_ = self.plusmn_nsprefix_ + ':' if (UseCapturedNS_ and self.plusmn_nsprefix_) else ''
            plusmn_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='plusmn', pretty_print=pretty_print)
        for times_ in self.times:
            namespaceprefix_ = self.times_nsprefix_ + ':' if (UseCapturedNS_ and self.times_nsprefix_) else ''
            times_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='times', pretty_print=pretty_print)
        for minus_ in self.minus:
            namespaceprefix_ = self.minus_nsprefix_ + ':' if (UseCapturedNS_ and self.minus_nsprefix_) else ''
            minus_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='minus', pretty_print=pretty_print)
        for sdot_ in self.sdot:
            namespaceprefix_ = self.sdot_nsprefix_ + ':' if (UseCapturedNS_ and self.sdot_nsprefix_) else ''
            sdot_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sdot', pretty_print=pretty_print)
        for part_ in self.part:
            namespaceprefix_ = self.part_nsprefix_ + ':' if (UseCapturedNS_ and self.part_nsprefix_) else ''
            part_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='part', pretty_print=pretty_print)
        for nabla_ in self.nabla:
            namespaceprefix_ = self.nabla_nsprefix_ + ':' if (UseCapturedNS_ and self.nabla_nsprefix_) else ''
            nabla_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nabla', pretty_print=pretty_print)
        for radic_ in self.radic:
            namespaceprefix_ = self.radic_nsprefix_ + ':' if (UseCapturedNS_ and self.radic_nsprefix_) else ''
            radic_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='radic', pretty_print=pretty_print)
        for perp_ in self.perp:
            namespaceprefix_ = self.perp_nsprefix_ + ':' if (UseCapturedNS_ and self.perp_nsprefix_) else ''
            perp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='perp', pretty_print=pretty_print)
        for sum_ in self.sum:
            namespaceprefix_ = self.sum_nsprefix_ + ':' if (UseCapturedNS_ and self.sum_nsprefix_) else ''
            sum_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sum', pretty_print=pretty_print)
        for int_ in self.int:
            namespaceprefix_ = self.int_nsprefix_ + ':' if (UseCapturedNS_ and self.int_nsprefix_) else ''
            int_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='int', pretty_print=pretty_print)
        for prod_ in self.prod:
            namespaceprefix_ = self.prod_nsprefix_ + ':' if (UseCapturedNS_ and self.prod_nsprefix_) else ''
            prod_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prod', pretty_print=pretty_print)
        for sim_ in self.sim:
            namespaceprefix_ = self.sim_nsprefix_ + ':' if (UseCapturedNS_ and self.sim_nsprefix_) else ''
            sim_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sim', pretty_print=pretty_print)
        for asymp_ in self.asymp:
            namespaceprefix_ = self.asymp_nsprefix_ + ':' if (UseCapturedNS_ and self.asymp_nsprefix_) else ''
            asymp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='asymp', pretty_print=pretty_print)
        for ne_ in self.ne:
            namespaceprefix_ = self.ne_nsprefix_ + ':' if (UseCapturedNS_ and self.ne_nsprefix_) else ''
            ne_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ne', pretty_print=pretty_print)
        for equiv_ in self.equiv:
            namespaceprefix_ = self.equiv_nsprefix_ + ':' if (UseCapturedNS_ and self.equiv_nsprefix_) else ''
            equiv_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='equiv', pretty_print=pretty_print)
        for prop_ in self.prop:
            namespaceprefix_ = self.prop_nsprefix_ + ':' if (UseCapturedNS_ and self.prop_nsprefix_) else ''
            prop_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prop', pretty_print=pretty_print)
        for le_ in self.le:
            namespaceprefix_ = self.le_nsprefix_ + ':' if (UseCapturedNS_ and self.le_nsprefix_) else ''
            le_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='le', pretty_print=pretty_print)
        for ge_ in self.ge:
            namespaceprefix_ = self.ge_nsprefix_ + ':' if (UseCapturedNS_ and self.ge_nsprefix_) else ''
            ge_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ge', pretty_print=pretty_print)
        for larr_ in self.larr:
            namespaceprefix_ = self.larr_nsprefix_ + ':' if (UseCapturedNS_ and self.larr_nsprefix_) else ''
            larr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='larr', pretty_print=pretty_print)
        for rarr_ in self.rarr:
            namespaceprefix_ = self.rarr_nsprefix_ + ':' if (UseCapturedNS_ and self.rarr_nsprefix_) else ''
            rarr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rarr', pretty_print=pretty_print)
        for isin_ in self.isin:
            namespaceprefix_ = self.isin_nsprefix_ + ':' if (UseCapturedNS_ and self.isin_nsprefix_) else ''
            isin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='isin', pretty_print=pretty_print)
        for notin_ in self.notin:
            namespaceprefix_ = self.notin_nsprefix_ + ':' if (UseCapturedNS_ and self.notin_nsprefix_) else ''
            notin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='notin', pretty_print=pretty_print)
        for lceil_ in self.lceil:
            namespaceprefix_ = self.lceil_nsprefix_ + ':' if (UseCapturedNS_ and self.lceil_nsprefix_) else ''
            lceil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lceil', pretty_print=pretty_print)
        for rceil_ in self.rceil:
            namespaceprefix_ = self.rceil_nsprefix_ + ':' if (UseCapturedNS_ and self.rceil_nsprefix_) else ''
            rceil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rceil', pretty_print=pretty_print)
        for lfloor_ in self.lfloor:
            namespaceprefix_ = self.lfloor_nsprefix_ + ':' if (UseCapturedNS_ and self.lfloor_nsprefix_) else ''
            lfloor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lfloor', pretty_print=pretty_print)
        for rfloor_ in self.rfloor:
            namespaceprefix_ = self.rfloor_nsprefix_ + ':' if (UseCapturedNS_ and self.rfloor_nsprefix_) else ''
            rfloor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rfloor', pretty_print=pretty_print)
        for linebreak_ in self.linebreak:
            namespaceprefix_ = self.linebreak_nsprefix_ + ':' if (UseCapturedNS_ and self.linebreak_nsprefix_) else ''
            linebreak_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='linebreak', pretty_print=pretty_print)
        for hruler_ in self.hruler:
            namespaceprefix_ = self.hruler_nsprefix_ + ':' if (UseCapturedNS_ and self.hruler_nsprefix_) else ''
            hruler_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='hruler', pretty_print=pretty_print)
        for preformatted_ in self.preformatted:
            namespaceprefix_ = self.preformatted_nsprefix_ + ':' if (UseCapturedNS_ and self.preformatted_nsprefix_) else ''
            preformatted_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='preformatted', pretty_print=pretty_print)
        for programlisting_ in self.programlisting:
            namespaceprefix_ = self.programlisting_nsprefix_ + ':' if (UseCapturedNS_ and self.programlisting_nsprefix_) else ''
            programlisting_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='programlisting', pretty_print=pretty_print)
        for verbatim_ in self.verbatim:
            namespaceprefix_ = self.verbatim_nsprefix_ + ':' if (UseCapturedNS_ and self.verbatim_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sverbatim>%s</%sverbatim>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(verbatim_), input_name='verbatim')), namespaceprefix_ , eol_))
        for indexentry_ in self.indexentry:
            namespaceprefix_ = self.indexentry_nsprefix_ + ':' if (UseCapturedNS_ and self.indexentry_nsprefix_) else ''
            indexentry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='indexentry', pretty_print=pretty_print)
        for orderedlist_ in self.orderedlist:
            namespaceprefix_ = self.orderedlist_nsprefix_ + ':' if (UseCapturedNS_ and self.orderedlist_nsprefix_) else ''
            orderedlist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='orderedlist', pretty_print=pretty_print)
        for itemizedlist_ in self.itemizedlist:
            namespaceprefix_ = self.itemizedlist_nsprefix_ + ':' if (UseCapturedNS_ and self.itemizedlist_nsprefix_) else ''
            itemizedlist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='itemizedlist', pretty_print=pretty_print)
        for simplesect_ in self.simplesect:
            namespaceprefix_ = self.simplesect_nsprefix_ + ':' if (UseCapturedNS_ and self.simplesect_nsprefix_) else ''
            simplesect_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='simplesect', pretty_print=pretty_print)
        for title_ in self.title:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            title_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        for variablelist_ in self.variablelist:
            namespaceprefix_ = self.variablelist_nsprefix_ + ':' if (UseCapturedNS_ and self.variablelist_nsprefix_) else ''
            variablelist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='variablelist', pretty_print=pretty_print)
        for table_ in self.table:
            namespaceprefix_ = self.table_nsprefix_ + ':' if (UseCapturedNS_ and self.table_nsprefix_) else ''
            table_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='table', pretty_print=pretty_print)
        for heading_ in self.heading:
            namespaceprefix_ = self.heading_nsprefix_ + ':' if (UseCapturedNS_ and self.heading_nsprefix_) else ''
            heading_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='heading', pretty_print=pretty_print)
        for image_ in self.image:
            namespaceprefix_ = self.image_nsprefix_ + ':' if (UseCapturedNS_ and self.image_nsprefix_) else ''
            image_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='image', pretty_print=pretty_print)
        for dotfile_ in self.dotfile:
            namespaceprefix_ = self.dotfile_nsprefix_ + ':' if (UseCapturedNS_ and self.dotfile_nsprefix_) else ''
            dotfile_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dotfile', pretty_print=pretty_print)
        for mscfile_ in self.mscfile:
            namespaceprefix_ = self.mscfile_nsprefix_ + ':' if (UseCapturedNS_ and self.mscfile_nsprefix_) else ''
            mscfile_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mscfile', pretty_print=pretty_print)
        for diafile_ in self.diafile:
            namespaceprefix_ = self.diafile_nsprefix_ + ':' if (UseCapturedNS_ and self.diafile_nsprefix_) else ''
            diafile_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='diafile', pretty_print=pretty_print)
        for toclist_ in self.toclist:
            namespaceprefix_ = self.toclist_nsprefix_ + ':' if (UseCapturedNS_ and self.toclist_nsprefix_) else ''
            toclist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='toclist', pretty_print=pretty_print)
        for language_ in self.language:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            language_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
        for parameterlist_ in self.parameterlist:
            namespaceprefix_ = self.parameterlist_nsprefix_ + ':' if (UseCapturedNS_ and self.parameterlist_nsprefix_) else ''
            parameterlist_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='parameterlist', pretty_print=pretty_print)
        for xrefsect_ in self.xrefsect:
            namespaceprefix_ = self.xrefsect_nsprefix_ + ':' if (UseCapturedNS_ and self.xrefsect_nsprefix_) else ''
            xrefsect_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='xrefsect', pretty_print=pretty_print)
        for copydoc_ in self.copydoc:
            namespaceprefix_ = self.copydoc_nsprefix_ + ':' if (UseCapturedNS_ and self.copydoc_nsprefix_) else ''
            copydoc_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='copydoc', pretty_print=pretty_print)
        for blockquote_ in self.blockquote:
            namespaceprefix_ = self.blockquote_nsprefix_ + ':' if (UseCapturedNS_ and self.blockquote_nsprefix_) else ''
            blockquote_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='blockquote', pretty_print=pretty_print)
        for parblock_ in self.parblock:
            namespaceprefix_ = self.parblock_nsprefix_ + ':' if (UseCapturedNS_ and self.parblock_nsprefix_) else ''
            parblock_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='parblock', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ulink':
            obj_ = docURLLink.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ulink', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ulink'):
              self.add_ulink(obj_.value)
            elif hasattr(self, 'set_ulink'):
              self.set_ulink(obj_.value)
        elif nodeName_ == 'bold':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'bold', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_bold'):
              self.add_bold(obj_.value)
            elif hasattr(self, 'set_bold'):
              self.set_bold(obj_.value)
        elif nodeName_ == 'emphasis':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'emphasis', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_emphasis'):
              self.add_emphasis(obj_.value)
            elif hasattr(self, 'set_emphasis'):
              self.set_emphasis(obj_.value)
        elif nodeName_ == 'computeroutput':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'computeroutput', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_computeroutput'):
              self.add_computeroutput(obj_.value)
            elif hasattr(self, 'set_computeroutput'):
              self.set_computeroutput(obj_.value)
        elif nodeName_ == 'subscript':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'subscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_subscript'):
              self.add_subscript(obj_.value)
            elif hasattr(self, 'set_subscript'):
              self.set_subscript(obj_.value)
        elif nodeName_ == 'superscript':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'superscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_superscript'):
              self.add_superscript(obj_.value)
            elif hasattr(self, 'set_superscript'):
              self.set_superscript(obj_.value)
        elif nodeName_ == 'center':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'center', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_center'):
              self.add_center(obj_.value)
            elif hasattr(self, 'set_center'):
              self.set_center(obj_.value)
        elif nodeName_ == 'small':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'small', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_small'):
              self.add_small(obj_.value)
            elif hasattr(self, 'set_small'):
              self.set_small(obj_.value)
        elif nodeName_ == 'htmlonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'htmlonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'htmlonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'htmlonly', valuestr_)
            self.content_.append(obj_)
            self.htmlonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'manonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'manonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'manonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'manonly', valuestr_)
            self.content_.append(obj_)
            self.manonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'xmlonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'xmlonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'xmlonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'xmlonly', valuestr_)
            self.content_.append(obj_)
            self.xmlonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'rtfonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'rtfonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'rtfonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'rtfonly', valuestr_)
            self.content_.append(obj_)
            self.rtfonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'latexonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'latexonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'latexonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'latexonly', valuestr_)
            self.content_.append(obj_)
            self.latexonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'dot' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'dot')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'dot')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'dot', valuestr_)
            self.content_.append(obj_)
            self.dot_nsprefix_ = child_.prefix
        elif nodeName_ == 'msc' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'msc')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'msc')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'msc', valuestr_)
            self.content_.append(obj_)
            self.msc_nsprefix_ = child_.prefix
        elif nodeName_ == 'anchor':
            obj_ = docAnchorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'anchor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_anchor'):
              self.add_anchor(obj_.value)
            elif hasattr(self, 'set_anchor'):
              self.set_anchor(obj_.value)
        elif nodeName_ == 'formula':
            obj_ = docFormulaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'formula', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_formula'):
              self.add_formula(obj_.value)
            elif hasattr(self, 'set_formula'):
              self.set_formula(obj_.value)
        elif nodeName_ == 'ref':
            obj_ = docRefTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ref', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ref'):
              self.add_ref(obj_.value)
            elif hasattr(self, 'set_ref'):
              self.set_ref(obj_.value)
        elif nodeName_ == 'copy':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'copy', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_copy'):
              self.add_copy(obj_.value)
            elif hasattr(self, 'set_copy'):
              self.set_copy(obj_.value)
        elif nodeName_ == 'trademark':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'trademark', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_trademark'):
              self.add_trademark(obj_.value)
            elif hasattr(self, 'set_trademark'):
              self.set_trademark(obj_.value)
        elif nodeName_ == 'registered':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'registered', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_registered'):
              self.add_registered(obj_.value)
            elif hasattr(self, 'set_registered'):
              self.set_registered(obj_.value)
        elif nodeName_ == 'lsquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lsquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lsquo'):
              self.add_lsquo(obj_.value)
            elif hasattr(self, 'set_lsquo'):
              self.set_lsquo(obj_.value)
        elif nodeName_ == 'rsquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rsquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rsquo'):
              self.add_rsquo(obj_.value)
            elif hasattr(self, 'set_rsquo'):
              self.set_rsquo(obj_.value)
        elif nodeName_ == 'ldquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ldquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ldquo'):
              self.add_ldquo(obj_.value)
            elif hasattr(self, 'set_ldquo'):
              self.set_ldquo(obj_.value)
        elif nodeName_ == 'rdquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rdquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rdquo'):
              self.add_rdquo(obj_.value)
            elif hasattr(self, 'set_rdquo'):
              self.set_rdquo(obj_.value)
        elif nodeName_ == 'ndash':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ndash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ndash'):
              self.add_ndash(obj_.value)
            elif hasattr(self, 'set_ndash'):
              self.set_ndash(obj_.value)
        elif nodeName_ == 'mdash':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'mdash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_mdash'):
              self.add_mdash(obj_.value)
            elif hasattr(self, 'set_mdash'):
              self.set_mdash(obj_.value)
        elif nodeName_ == 'umlaut':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'umlaut', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_umlaut'):
              self.add_umlaut(obj_.value)
            elif hasattr(self, 'set_umlaut'):
              self.set_umlaut(obj_.value)
        elif nodeName_ == 'acute':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'acute', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_acute'):
              self.add_acute(obj_.value)
            elif hasattr(self, 'set_acute'):
              self.set_acute(obj_.value)
        elif nodeName_ == 'grave':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'grave', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_grave'):
              self.add_grave(obj_.value)
            elif hasattr(self, 'set_grave'):
              self.set_grave(obj_.value)
        elif nodeName_ == 'circ':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'circ', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_circ'):
              self.add_circ(obj_.value)
            elif hasattr(self, 'set_circ'):
              self.set_circ(obj_.value)
        elif nodeName_ == 'slash':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'slash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_slash'):
              self.add_slash(obj_.value)
            elif hasattr(self, 'set_slash'):
              self.set_slash(obj_.value)
        elif nodeName_ == 'tilde':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tilde', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tilde'):
              self.add_tilde(obj_.value)
            elif hasattr(self, 'set_tilde'):
              self.set_tilde(obj_.value)
        elif nodeName_ == 'cedil':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'cedil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_cedil'):
              self.add_cedil(obj_.value)
            elif hasattr(self, 'set_cedil'):
              self.set_cedil(obj_.value)
        elif nodeName_ == 'ring':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ring', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ring'):
              self.add_ring(obj_.value)
            elif hasattr(self, 'set_ring'):
              self.set_ring(obj_.value)
        elif nodeName_ == 'szlig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'szlig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_szlig'):
              self.add_szlig(obj_.value)
            elif hasattr(self, 'set_szlig'):
              self.set_szlig(obj_.value)
        elif nodeName_ == 'nonbreakablespace':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nonbreakablespace', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nonbreakablespace'):
              self.add_nonbreakablespace(obj_.value)
            elif hasattr(self, 'set_nonbreakablespace'):
              self.set_nonbreakablespace(obj_.value)
        elif nodeName_ == 'aelig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'aelig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_aelig'):
              self.add_aelig(obj_.value)
            elif hasattr(self, 'set_aelig'):
              self.set_aelig(obj_.value)
        elif nodeName_ == 'AElig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'AElig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_AElig'):
              self.add_AElig(obj_.value)
            elif hasattr(self, 'set_AElig'):
              self.set_AElig(obj_.value)
        elif nodeName_ == 'Gamma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Gamma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Gamma'):
              self.add_Gamma(obj_.value)
            elif hasattr(self, 'set_Gamma'):
              self.set_Gamma(obj_.value)
        elif nodeName_ == 'Delta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Delta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Delta'):
              self.add_Delta(obj_.value)
            elif hasattr(self, 'set_Delta'):
              self.set_Delta(obj_.value)
        elif nodeName_ == 'Theta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Theta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Theta'):
              self.add_Theta(obj_.value)
            elif hasattr(self, 'set_Theta'):
              self.set_Theta(obj_.value)
        elif nodeName_ == 'Lambda':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Lambda', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Lambda'):
              self.add_Lambda(obj_.value)
            elif hasattr(self, 'set_Lambda'):
              self.set_Lambda(obj_.value)
        elif nodeName_ == 'Xi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Xi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Xi'):
              self.add_Xi(obj_.value)
            elif hasattr(self, 'set_Xi'):
              self.set_Xi(obj_.value)
        elif nodeName_ == 'Pi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Pi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Pi'):
              self.add_Pi(obj_.value)
            elif hasattr(self, 'set_Pi'):
              self.set_Pi(obj_.value)
        elif nodeName_ == 'Sigma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Sigma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Sigma'):
              self.add_Sigma(obj_.value)
            elif hasattr(self, 'set_Sigma'):
              self.set_Sigma(obj_.value)
        elif nodeName_ == 'Upsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Upsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Upsilon'):
              self.add_Upsilon(obj_.value)
            elif hasattr(self, 'set_Upsilon'):
              self.set_Upsilon(obj_.value)
        elif nodeName_ == 'Phi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Phi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Phi'):
              self.add_Phi(obj_.value)
            elif hasattr(self, 'set_Phi'):
              self.set_Phi(obj_.value)
        elif nodeName_ == 'Psi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Psi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Psi'):
              self.add_Psi(obj_.value)
            elif hasattr(self, 'set_Psi'):
              self.set_Psi(obj_.value)
        elif nodeName_ == 'Omega':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Omega', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Omega'):
              self.add_Omega(obj_.value)
            elif hasattr(self, 'set_Omega'):
              self.set_Omega(obj_.value)
        elif nodeName_ == 'alpha':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'alpha', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_alpha'):
              self.add_alpha(obj_.value)
            elif hasattr(self, 'set_alpha'):
              self.set_alpha(obj_.value)
        elif nodeName_ == 'beta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'beta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_beta'):
              self.add_beta(obj_.value)
            elif hasattr(self, 'set_beta'):
              self.set_beta(obj_.value)
        elif nodeName_ == 'gamma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'gamma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_gamma'):
              self.add_gamma(obj_.value)
            elif hasattr(self, 'set_gamma'):
              self.set_gamma(obj_.value)
        elif nodeName_ == 'delta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'delta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_delta'):
              self.add_delta(obj_.value)
            elif hasattr(self, 'set_delta'):
              self.set_delta(obj_.value)
        elif nodeName_ == 'epsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'epsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_epsilon'):
              self.add_epsilon(obj_.value)
            elif hasattr(self, 'set_epsilon'):
              self.set_epsilon(obj_.value)
        elif nodeName_ == 'zeta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'zeta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_zeta'):
              self.add_zeta(obj_.value)
            elif hasattr(self, 'set_zeta'):
              self.set_zeta(obj_.value)
        elif nodeName_ == 'eta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'eta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_eta'):
              self.add_eta(obj_.value)
            elif hasattr(self, 'set_eta'):
              self.set_eta(obj_.value)
        elif nodeName_ == 'theta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'theta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_theta'):
              self.add_theta(obj_.value)
            elif hasattr(self, 'set_theta'):
              self.set_theta(obj_.value)
        elif nodeName_ == 'iota':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'iota', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_iota'):
              self.add_iota(obj_.value)
            elif hasattr(self, 'set_iota'):
              self.set_iota(obj_.value)
        elif nodeName_ == 'kappa':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'kappa', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_kappa'):
              self.add_kappa(obj_.value)
            elif hasattr(self, 'set_kappa'):
              self.set_kappa(obj_.value)
        elif nodeName_ == 'lambda':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lambda', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lambda'):
              self.add_lambda(obj_.value)
            elif hasattr(self, 'set_lambda'):
              self.set_lambda(obj_.value)
        elif nodeName_ == 'mu':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'mu', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_mu'):
              self.add_mu(obj_.value)
            elif hasattr(self, 'set_mu'):
              self.set_mu(obj_.value)
        elif nodeName_ == 'nu':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nu', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nu'):
              self.add_nu(obj_.value)
            elif hasattr(self, 'set_nu'):
              self.set_nu(obj_.value)
        elif nodeName_ == 'xi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'xi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_xi'):
              self.add_xi(obj_.value)
            elif hasattr(self, 'set_xi'):
              self.set_xi(obj_.value)
        elif nodeName_ == 'pi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'pi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_pi'):
              self.add_pi(obj_.value)
            elif hasattr(self, 'set_pi'):
              self.set_pi(obj_.value)
        elif nodeName_ == 'rho':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rho', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rho'):
              self.add_rho(obj_.value)
            elif hasattr(self, 'set_rho'):
              self.set_rho(obj_.value)
        elif nodeName_ == 'sigma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sigma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sigma'):
              self.add_sigma(obj_.value)
            elif hasattr(self, 'set_sigma'):
              self.set_sigma(obj_.value)
        elif nodeName_ == 'tau':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tau', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tau'):
              self.add_tau(obj_.value)
            elif hasattr(self, 'set_tau'):
              self.set_tau(obj_.value)
        elif nodeName_ == 'upsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'upsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_upsilon'):
              self.add_upsilon(obj_.value)
            elif hasattr(self, 'set_upsilon'):
              self.set_upsilon(obj_.value)
        elif nodeName_ == 'phi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'phi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_phi'):
              self.add_phi(obj_.value)
            elif hasattr(self, 'set_phi'):
              self.set_phi(obj_.value)
        elif nodeName_ == 'chi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'chi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_chi'):
              self.add_chi(obj_.value)
            elif hasattr(self, 'set_chi'):
              self.set_chi(obj_.value)
        elif nodeName_ == 'psi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'psi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_psi'):
              self.add_psi(obj_.value)
            elif hasattr(self, 'set_psi'):
              self.set_psi(obj_.value)
        elif nodeName_ == 'omega':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'omega', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_omega'):
              self.add_omega(obj_.value)
            elif hasattr(self, 'set_omega'):
              self.set_omega(obj_.value)
        elif nodeName_ == 'sigmaf':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sigmaf', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sigmaf'):
              self.add_sigmaf(obj_.value)
            elif hasattr(self, 'set_sigmaf'):
              self.set_sigmaf(obj_.value)
        elif nodeName_ == 'sect':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sect', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sect'):
              self.add_sect(obj_.value)
            elif hasattr(self, 'set_sect'):
              self.set_sect(obj_.value)
        elif nodeName_ == 'deg':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'deg', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_deg'):
              self.add_deg(obj_.value)
            elif hasattr(self, 'set_deg'):
              self.set_deg(obj_.value)
        elif nodeName_ == 'prime':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'prime', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_prime'):
              self.add_prime(obj_.value)
            elif hasattr(self, 'set_prime'):
              self.set_prime(obj_.value)
        elif nodeName_ == 'Prime':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Prime', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Prime'):
              self.add_Prime(obj_.value)
            elif hasattr(self, 'set_Prime'):
              self.set_Prime(obj_.value)
        elif nodeName_ == 'infin':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'infin', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_infin'):
              self.add_infin(obj_.value)
            elif hasattr(self, 'set_infin'):
              self.set_infin(obj_.value)
        elif nodeName_ == 'empty':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'empty', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_empty'):
              self.add_empty(obj_.value)
            elif hasattr(self, 'set_empty'):
              self.set_empty(obj_.value)
        elif nodeName_ == 'plusmn':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'plusmn', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_plusmn'):
              self.add_plusmn(obj_.value)
            elif hasattr(self, 'set_plusmn'):
              self.set_plusmn(obj_.value)
        elif nodeName_ == 'times':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'times', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_times'):
              self.add_times(obj_.value)
            elif hasattr(self, 'set_times'):
              self.set_times(obj_.value)
        elif nodeName_ == 'minus':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'minus', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_minus'):
              self.add_minus(obj_.value)
            elif hasattr(self, 'set_minus'):
              self.set_minus(obj_.value)
        elif nodeName_ == 'sdot':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sdot', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sdot'):
              self.add_sdot(obj_.value)
            elif hasattr(self, 'set_sdot'):
              self.set_sdot(obj_.value)
        elif nodeName_ == 'part':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'part', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_part'):
              self.add_part(obj_.value)
            elif hasattr(self, 'set_part'):
              self.set_part(obj_.value)
        elif nodeName_ == 'nabla':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nabla', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nabla'):
              self.add_nabla(obj_.value)
            elif hasattr(self, 'set_nabla'):
              self.set_nabla(obj_.value)
        elif nodeName_ == 'radic':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'radic', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_radic'):
              self.add_radic(obj_.value)
            elif hasattr(self, 'set_radic'):
              self.set_radic(obj_.value)
        elif nodeName_ == 'perp':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'perp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_perp'):
              self.add_perp(obj_.value)
            elif hasattr(self, 'set_perp'):
              self.set_perp(obj_.value)
        elif nodeName_ == 'sum':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sum', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sum'):
              self.add_sum(obj_.value)
            elif hasattr(self, 'set_sum'):
              self.set_sum(obj_.value)
        elif nodeName_ == 'int':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'int', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_int'):
              self.add_int(obj_.value)
            elif hasattr(self, 'set_int'):
              self.set_int(obj_.value)
        elif nodeName_ == 'prod':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'prod', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_prod'):
              self.add_prod(obj_.value)
            elif hasattr(self, 'set_prod'):
              self.set_prod(obj_.value)
        elif nodeName_ == 'sim':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'sim', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_sim'):
              self.add_sim(obj_.value)
            elif hasattr(self, 'set_sim'):
              self.set_sim(obj_.value)
        elif nodeName_ == 'asymp':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'asymp', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_asymp'):
              self.add_asymp(obj_.value)
            elif hasattr(self, 'set_asymp'):
              self.set_asymp(obj_.value)
        elif nodeName_ == 'ne':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ne', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ne'):
              self.add_ne(obj_.value)
            elif hasattr(self, 'set_ne'):
              self.set_ne(obj_.value)
        elif nodeName_ == 'equiv':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'equiv', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_equiv'):
              self.add_equiv(obj_.value)
            elif hasattr(self, 'set_equiv'):
              self.set_equiv(obj_.value)
        elif nodeName_ == 'prop':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'prop', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_prop'):
              self.add_prop(obj_.value)
            elif hasattr(self, 'set_prop'):
              self.set_prop(obj_.value)
        elif nodeName_ == 'le':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'le', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_le'):
              self.add_le(obj_.value)
            elif hasattr(self, 'set_le'):
              self.set_le(obj_.value)
        elif nodeName_ == 'ge':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ge', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ge'):
              self.add_ge(obj_.value)
            elif hasattr(self, 'set_ge'):
              self.set_ge(obj_.value)
        elif nodeName_ == 'larr':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'larr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_larr'):
              self.add_larr(obj_.value)
            elif hasattr(self, 'set_larr'):
              self.set_larr(obj_.value)
        elif nodeName_ == 'rarr':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rarr', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rarr'):
              self.add_rarr(obj_.value)
            elif hasattr(self, 'set_rarr'):
              self.set_rarr(obj_.value)
        elif nodeName_ == 'isin':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'isin', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_isin'):
              self.add_isin(obj_.value)
            elif hasattr(self, 'set_isin'):
              self.set_isin(obj_.value)
        elif nodeName_ == 'notin':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'notin', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_notin'):
              self.add_notin(obj_.value)
            elif hasattr(self, 'set_notin'):
              self.set_notin(obj_.value)
        elif nodeName_ == 'lceil':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lceil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lceil'):
              self.add_lceil(obj_.value)
            elif hasattr(self, 'set_lceil'):
              self.set_lceil(obj_.value)
        elif nodeName_ == 'rceil':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rceil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rceil'):
              self.add_rceil(obj_.value)
            elif hasattr(self, 'set_rceil'):
              self.set_rceil(obj_.value)
        elif nodeName_ == 'lfloor':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lfloor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lfloor'):
              self.add_lfloor(obj_.value)
            elif hasattr(self, 'set_lfloor'):
              self.set_lfloor(obj_.value)
        elif nodeName_ == 'rfloor':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rfloor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rfloor'):
              self.add_rfloor(obj_.value)
            elif hasattr(self, 'set_rfloor'):
              self.set_rfloor(obj_.value)
        elif nodeName_ == 'linebreak':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'linebreak', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_linebreak'):
              self.add_linebreak(obj_.value)
            elif hasattr(self, 'set_linebreak'):
              self.set_linebreak(obj_.value)
        elif nodeName_ == 'hruler':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'hruler', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_hruler'):
              self.add_hruler(obj_.value)
            elif hasattr(self, 'set_hruler'):
              self.set_hruler(obj_.value)
        elif nodeName_ == 'preformatted':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'preformatted', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_preformatted'):
              self.add_preformatted(obj_.value)
            elif hasattr(self, 'set_preformatted'):
              self.set_preformatted(obj_.value)
        elif nodeName_ == 'programlisting':
            obj_ = listingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'programlisting', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_programlisting'):
              self.add_programlisting(obj_.value)
            elif hasattr(self, 'set_programlisting'):
              self.set_programlisting(obj_.value)
        elif nodeName_ == 'verbatim' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'verbatim')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'verbatim')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'verbatim', valuestr_)
            self.content_.append(obj_)
            self.verbatim_nsprefix_ = child_.prefix
        elif nodeName_ == 'indexentry':
            obj_ = docIndexEntryType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'indexentry', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_indexentry'):
              self.add_indexentry(obj_.value)
            elif hasattr(self, 'set_indexentry'):
              self.set_indexentry(obj_.value)
        elif nodeName_ == 'orderedlist':
            obj_ = docListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'orderedlist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_orderedlist'):
              self.add_orderedlist(obj_.value)
            elif hasattr(self, 'set_orderedlist'):
              self.set_orderedlist(obj_.value)
        elif nodeName_ == 'itemizedlist':
            obj_ = docListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'itemizedlist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_itemizedlist'):
              self.add_itemizedlist(obj_.value)
            elif hasattr(self, 'set_itemizedlist'):
              self.set_itemizedlist(obj_.value)
        elif nodeName_ == 'simplesect':
            obj_ = docSimpleSectType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'simplesect', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_simplesect'):
              self.add_simplesect(obj_.value)
            elif hasattr(self, 'set_simplesect'):
              self.set_simplesect(obj_.value)
        elif nodeName_ == 'title':
            obj_ = docTitleType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'title', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_title'):
              self.add_title(obj_.value)
            elif hasattr(self, 'set_title'):
              self.set_title(obj_.value)
        elif nodeName_ == 'variablelist':
            obj_ = docVariableListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'variablelist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_variablelist'):
              self.add_variablelist(obj_.value)
            elif hasattr(self, 'set_variablelist'):
              self.set_variablelist(obj_.value)
        elif nodeName_ == 'table':
            obj_ = docTableType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'table', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_table'):
              self.add_table(obj_.value)
            elif hasattr(self, 'set_table'):
              self.set_table(obj_.value)
        elif nodeName_ == 'heading':
            obj_ = docHeadingType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'heading', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_heading'):
              self.add_heading(obj_.value)
            elif hasattr(self, 'set_heading'):
              self.set_heading(obj_.value)
        elif nodeName_ == 'image':
            obj_ = docImageType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'image', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_image'):
              self.add_image(obj_.value)
            elif hasattr(self, 'set_image'):
              self.set_image(obj_.value)
        elif nodeName_ == 'dotfile':
            obj_ = docFileType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'dotfile', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_dotfile'):
              self.add_dotfile(obj_.value)
            elif hasattr(self, 'set_dotfile'):
              self.set_dotfile(obj_.value)
        elif nodeName_ == 'mscfile':
            obj_ = docFileType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'mscfile', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_mscfile'):
              self.add_mscfile(obj_.value)
            elif hasattr(self, 'set_mscfile'):
              self.set_mscfile(obj_.value)
        elif nodeName_ == 'diafile':
            obj_ = docFileType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'diafile', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_diafile'):
              self.add_diafile(obj_.value)
            elif hasattr(self, 'set_diafile'):
              self.set_diafile(obj_.value)
        elif nodeName_ == 'toclist':
            obj_ = docTocListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'toclist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_toclist'):
              self.add_toclist(obj_.value)
            elif hasattr(self, 'set_toclist'):
              self.set_toclist(obj_.value)
        elif nodeName_ == 'language':
            obj_ = docLanguageType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'language', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_language'):
              self.add_language(obj_.value)
            elif hasattr(self, 'set_language'):
              self.set_language(obj_.value)
        elif nodeName_ == 'parameterlist':
            obj_ = docParamListType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'parameterlist', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_parameterlist'):
              self.add_parameterlist(obj_.value)
            elif hasattr(self, 'set_parameterlist'):
              self.set_parameterlist(obj_.value)
        elif nodeName_ == 'xrefsect':
            obj_ = docXRefSectType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'xrefsect', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_xrefsect'):
              self.add_xrefsect(obj_.value)
            elif hasattr(self, 'set_xrefsect'):
              self.set_xrefsect(obj_.value)
        elif nodeName_ == 'copydoc':
            obj_ = docCopyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'copydoc', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_copydoc'):
              self.add_copydoc(obj_.value)
            elif hasattr(self, 'set_copydoc'):
              self.set_copydoc(obj_.value)
        elif nodeName_ == 'blockquote':
            obj_ = docBlockQuoteType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'blockquote', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_blockquote'):
              self.add_blockquote(obj_.value)
            elif hasattr(self, 'set_blockquote'):
              self.set_blockquote(obj_.value)
        elif nodeName_ == 'parblock':
            obj_ = docParBlockType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'parblock', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_parblock'):
              self.add_parblock(obj_.value)
            elif hasattr(self, 'set_parblock'):
              self.set_parblock(obj_.value)
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
# end class docMarkupType


class docURLLink(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, url=None, ulink=None, bold=None, emphasis=None, computeroutput=None, subscript=None, superscript=None, center=None, small=None, htmlonly=None, manonly=None, xmlonly=None, rtfonly=None, latexonly=None, dot=None, msc=None, anchor=None, formula=None, ref=None, copy=None, trademark=None, registered=None, lsquo=None, rsquo=None, ldquo=None, rdquo=None, ndash=None, mdash=None, umlaut=None, acute=None, grave=None, circ=None, slash=None, tilde=None, cedil=None, ring=None, szlig=None, nonbreakablespace=None, aelig=None, AElig=None, Gamma=None, Delta=None, Theta=None, Lambda=None, Xi=None, Pi=None, Sigma=None, Upsilon=None, Phi=None, Psi=None, Omega=None, alpha=None, beta=None, gamma=None, delta=None, epsilon=None, zeta=None, eta=None, theta=None, iota=None, kappa=None, lambda_=None, mu=None, nu=None, xi=None, pi=None, rho=None, sigma=None, tau=None, upsilon=None, phi=None, chi=None, psi=None, omega=None, sigmaf=None, sect=None, deg=None, prime=None, Prime=None, infin=None, empty=None, plusmn=None, times=None, minus=None, sdot=None, part=None, nabla=None, radic=None, perp=None, sum=None, int=None, prod=None, sim=None, asymp=None, ne=None, equiv=None, prop=None, le=None, ge=None, larr=None, rarr=None, isin=None, notin=None, lceil=None, rceil=None, lfloor=None, rfloor=None, valueOf_=None, mixedclass_=None, content_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.url = _cast(None, url)
        self.url_nsprefix_ = None
        if ulink is None:
            self.ulink = []
        else:
            self.ulink = ulink
        self.ulink_nsprefix_ = None
        if bold is None:
            self.bold = []
        else:
            self.bold = bold
        self.bold_nsprefix_ = None
        if emphasis is None:
            self.emphasis = []
        else:
            self.emphasis = emphasis
        self.emphasis_nsprefix_ = None
        if computeroutput is None:
            self.computeroutput = []
        else:
            self.computeroutput = computeroutput
        self.computeroutput_nsprefix_ = None
        if subscript is None:
            self.subscript = []
        else:
            self.subscript = subscript
        self.subscript_nsprefix_ = None
        if superscript is None:
            self.superscript = []
        else:
            self.superscript = superscript
        self.superscript_nsprefix_ = None
        if center is None:
            self.center = []
        else:
            self.center = center
        self.center_nsprefix_ = None
        if small is None:
            self.small = []
        else:
            self.small = small
        self.small_nsprefix_ = None
        if htmlonly is None:
            self.htmlonly = []
        else:
            self.htmlonly = htmlonly
        self.htmlonly_nsprefix_ = None
        if manonly is None:
            self.manonly = []
        else:
            self.manonly = manonly
        self.manonly_nsprefix_ = None
        if xmlonly is None:
            self.xmlonly = []
        else:
            self.xmlonly = xmlonly
        self.xmlonly_nsprefix_ = None
        if rtfonly is None:
            self.rtfonly = []
        else:
            self.rtfonly = rtfonly
        self.rtfonly_nsprefix_ = None
        if latexonly is None:
            self.latexonly = []
        else:
            self.latexonly = latexonly
        self.latexonly_nsprefix_ = None
        if dot is None:
            self.dot = []
        else:
            self.dot = dot
        self.dot_nsprefix_ = None
        if msc is None:
            self.msc = []
        else:
            self.msc = msc
        self.msc_nsprefix_ = None
        if anchor is None:
            self.anchor = []
        else:
            self.anchor = anchor
        self.anchor_nsprefix_ = None
        if formula is None:
            self.formula = []
        else:
            self.formula = formula
        self.formula_nsprefix_ = None
        if ref is None:
            self.ref = []
        else:
            self.ref = ref
        self.ref_nsprefix_ = None
        if copy is None:
            self.copy = []
        else:
            self.copy = copy
        self.copy_nsprefix_ = None
        if trademark is None:
            self.trademark = []
        else:
            self.trademark = trademark
        self.trademark_nsprefix_ = None
        if registered is None:
            self.registered = []
        else:
            self.registered = registered
        self.registered_nsprefix_ = None
        if lsquo is None:
            self.lsquo = []
        else:
            self.lsquo = lsquo
        self.lsquo_nsprefix_ = None
        if rsquo is None:
            self.rsquo = []
        else:
            self.rsquo = rsquo
        self.rsquo_nsprefix_ = None
        if ldquo is None:
            self.ldquo = []
        else:
            self.ldquo = ldquo
        self.ldquo_nsprefix_ = None
        if rdquo is None:
            self.rdquo = []
        else:
            self.rdquo = rdquo
        self.rdquo_nsprefix_ = None
        if ndash is None:
            self.ndash = []
        else:
            self.ndash = ndash
        self.ndash_nsprefix_ = None
        if mdash is None:
            self.mdash = []
        else:
            self.mdash = mdash
        self.mdash_nsprefix_ = None
        if umlaut is None:
            self.umlaut = []
        else:
            self.umlaut = umlaut
        self.umlaut_nsprefix_ = None
        if acute is None:
            self.acute = []
        else:
            self.acute = acute
        self.acute_nsprefix_ = None
        if grave is None:
            self.grave = []
        else:
            self.grave = grave
        self.grave_nsprefix_ = None
        if circ is None:
            self.circ = []
        else:
            self.circ = circ
        self.circ_nsprefix_ = None
        if slash is None:
            self.slash = []
        else:
            self.slash = slash
        self.slash_nsprefix_ = None
        if tilde is None:
            self.tilde = []
        else:
            self.tilde = tilde
        self.tilde_nsprefix_ = None
        if cedil is None:
            self.cedil = []
        else:
            self.cedil = cedil
        self.cedil_nsprefix_ = None
        if ring is None:
            self.ring = []
        else:
            self.ring = ring
        self.ring_nsprefix_ = None
        if szlig is None:
            self.szlig = []
        else:
            self.szlig = szlig
        self.szlig_nsprefix_ = None
        if nonbreakablespace is None:
            self.nonbreakablespace = []
        else:
            self.nonbreakablespace = nonbreakablespace
        self.nonbreakablespace_nsprefix_ = None
        if aelig is None:
            self.aelig = []
        else:
            self.aelig = aelig
        self.aelig_nsprefix_ = None
        if AElig is None:
            self.AElig = []
        else:
            self.AElig = AElig
        self.AElig_nsprefix_ = None
        if Gamma is None:
            self.Gamma = []
        else:
            self.Gamma = Gamma
        self.Gamma_nsprefix_ = None
        if Delta is None:
            self.Delta = []
        else:
            self.Delta = Delta
        self.Delta_nsprefix_ = None
        if Theta is None:
            self.Theta = []
        else:
            self.Theta = Theta
        self.Theta_nsprefix_ = None
        if Lambda is None:
            self.Lambda = []
        else:
            self.Lambda = Lambda
        self.Lambda_nsprefix_ = None
        if Xi is None:
            self.Xi = []
        else:
            self.Xi = Xi
        self.Xi_nsprefix_ = None
        if Pi is None:
            self.Pi = []
        else:
            self.Pi = Pi
        self.Pi_nsprefix_ = None
        if Sigma is None:
            self.Sigma = []
        else:
            self.Sigma = Sigma
        self.Sigma_nsprefix_ = None
        if Upsilon is None:
            self.Upsilon = []
        else:
            self.Upsilon = Upsilon
        self.Upsilon_nsprefix_ = None
        if Phi is None:
            self.Phi = []
        else:
            self.Phi = Phi
        self.Phi_nsprefix_ = None
        if Psi is None:
            self.Psi = []
        else:
            self.Psi = Psi
        self.Psi_nsprefix_ = None
        if Omega is None:
            self.Omega = []
        else:
            self.Omega = Omega
        self.Omega_nsprefix_ = None
        if alpha is None:
            self.alpha = []
        else:
            self.alpha = alpha
        self.alpha_nsprefix_ = None
        if beta is None:
            self.beta = []
        else:
            self.beta = beta
        self.beta_nsprefix_ = None
        if gamma is None:
            self.gamma = []
        else:
            self.gamma = gamma
        self.gamma_nsprefix_ = None
        if delta is None:
            self.delta = []
        else:
            self.delta = delta
        self.delta_nsprefix_ = None
        if epsilon is None:
            self.epsilon = []
        else:
            self.epsilon = epsilon
        self.epsilon_nsprefix_ = None
        if zeta is None:
            self.zeta = []
        else:
            self.zeta = zeta
        self.zeta_nsprefix_ = None
        if eta is None:
            self.eta = []
        else:
            self.eta = eta
        self.eta_nsprefix_ = None
        if theta is None:
            self.theta = []
        else:
            self.theta = theta
        self.theta_nsprefix_ = None
        if iota is None:
            self.iota = []
        else:
            self.iota = iota
        self.iota_nsprefix_ = None
        if kappa is None:
            self.kappa = []
        else:
            self.kappa = kappa
        self.kappa_nsprefix_ = None
        if lambda_ is None:
            self.lambda_ = []
        else:
            self.lambda_ = lambda_
        self.lambda__nsprefix_ = None
        if mu is None:
            self.mu = []
        else:
            self.mu = mu
        self.mu_nsprefix_ = None
        if nu is None:
            self.nu = []
        else:
            self.nu = nu
        self.nu_nsprefix_ = None
        if xi is None:
            self.xi = []
        else:
            self.xi = xi
        self.xi_nsprefix_ = None
        if pi is None:
            self.pi = []
        else:
            self.pi = pi
        self.pi_nsprefix_ = None
        if rho is None:
            self.rho = []
        else:
            self.rho = rho
        self.rho_nsprefix_ = None
        if sigma is None:
            self.sigma = []
        else:
            self.sigma = sigma
        self.sigma_nsprefix_ = None
        if tau is None:
            self.tau = []
        else:
            self.tau = tau
        self.tau_nsprefix_ = None
        if upsilon is None:
            self.upsilon = []
        else:
            self.upsilon = upsilon
        self.upsilon_nsprefix_ = None
        if phi is None:
            self.phi = []
        else:
            self.phi = phi
        self.phi_nsprefix_ = None
        if chi is None:
            self.chi = []
        else:
            self.chi = chi
        self.chi_nsprefix_ = None
        if psi is None:
            self.psi = []
        else:
            self.psi = psi
        self.psi_nsprefix_ = None
        if omega is None:
            self.omega = []
        else:
            self.omega = omega
        self.omega_nsprefix_ = None
        if sigmaf is None:
            self.sigmaf = []
        else:
            self.sigmaf = sigmaf
        self.sigmaf_nsprefix_ = None
        if sect is None:
            self.sect = []
        else:
            self.sect = sect
        self.sect_nsprefix_ = None
        if deg is None:
            self.deg = []
        else:
            self.deg = deg
        self.deg_nsprefix_ = None
        if prime is None:
            self.prime = []
        else:
            self.prime = prime
        self.prime_nsprefix_ = None
        if Prime is None:
            self.Prime = []
        else:
            self.Prime = Prime
        self.Prime_nsprefix_ = None
        if infin is None:
            self.infin = []
        else:
            self.infin = infin
        self.infin_nsprefix_ = None
        if empty is None:
            self.empty = []
        else:
            self.empty = empty
        self.empty_nsprefix_ = None
        if plusmn is None:
            self.plusmn = []
        else:
            self.plusmn = plusmn
        self.plusmn_nsprefix_ = None
        if times is None:
            self.times = []
        else:
            self.times = times
        self.times_nsprefix_ = None
        if minus is None:
            self.minus = []
        else:
            self.minus = minus
        self.minus_nsprefix_ = None
        if sdot is None:
            self.sdot = []
        else:
            self.sdot = sdot
        self.sdot_nsprefix_ = None
        if part is None:
            self.part = []
        else:
            self.part = part
        self.part_nsprefix_ = None
        if nabla is None:
            self.nabla = []
        else:
            self.nabla = nabla
        self.nabla_nsprefix_ = None
        if radic is None:
            self.radic = []
        else:
            self.radic = radic
        self.radic_nsprefix_ = None
        if perp is None:
            self.perp = []
        else:
            self.perp = perp
        self.perp_nsprefix_ = None
        if sum is None:
            self.sum = []
        else:
            self.sum = sum
        self.sum_nsprefix_ = None
        if int is None:
            self.int = []
        else:
            self.int = int
        self.int_nsprefix_ = None
        if prod is None:
            self.prod = []
        else:
            self.prod = prod
        self.prod_nsprefix_ = None
        if sim is None:
            self.sim = []
        else:
            self.sim = sim
        self.sim_nsprefix_ = None
        if asymp is None:
            self.asymp = []
        else:
            self.asymp = asymp
        self.asymp_nsprefix_ = None
        if ne is None:
            self.ne = []
        else:
            self.ne = ne
        self.ne_nsprefix_ = None
        if equiv is None:
            self.equiv = []
        else:
            self.equiv = equiv
        self.equiv_nsprefix_ = None
        if prop is None:
            self.prop = []
        else:
            self.prop = prop
        self.prop_nsprefix_ = None
        if le is None:
            self.le = []
        else:
            self.le = le
        self.le_nsprefix_ = None
        if ge is None:
            self.ge = []
        else:
            self.ge = ge
        self.ge_nsprefix_ = None
        if larr is None:
            self.larr = []
        else:
            self.larr = larr
        self.larr_nsprefix_ = None
        if rarr is None:
            self.rarr = []
        else:
            self.rarr = rarr
        self.rarr_nsprefix_ = None
        if isin is None:
            self.isin = []
        else:
            self.isin = isin
        self.isin_nsprefix_ = None
        if notin is None:
            self.notin = []
        else:
            self.notin = notin
        self.notin_nsprefix_ = None
        if lceil is None:
            self.lceil = []
        else:
            self.lceil = lceil
        self.lceil_nsprefix_ = None
        if rceil is None:
            self.rceil = []
        else:
            self.rceil = rceil
        self.rceil_nsprefix_ = None
        if lfloor is None:
            self.lfloor = []
        else:
            self.lfloor = lfloor
        self.lfloor_nsprefix_ = None
        if rfloor is None:
            self.rfloor = []
        else:
            self.rfloor = rfloor
        self.rfloor_nsprefix_ = None
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, docURLLink)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if docURLLink.subclass:
            return docURLLink.subclass(*args_, **kwargs_)
        return docURLLink(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ulink(self):
        return self.ulink
    def set_ulink(self, ulink):
        self.ulink = ulink
    def add_ulink(self, value):
        self.ulink.append(value)
    def insert_ulink_at(self, index, value):
        self.ulink.insert(index, value)
    def replace_ulink_at(self, index, value):
        self.ulink[index] = value
    def get_bold(self):
        return self.bold
    def set_bold(self, bold):
        self.bold = bold
    def add_bold(self, value):
        self.bold.append(value)
    def insert_bold_at(self, index, value):
        self.bold.insert(index, value)
    def replace_bold_at(self, index, value):
        self.bold[index] = value
    def get_emphasis(self):
        return self.emphasis
    def set_emphasis(self, emphasis):
        self.emphasis = emphasis
    def add_emphasis(self, value):
        self.emphasis.append(value)
    def insert_emphasis_at(self, index, value):
        self.emphasis.insert(index, value)
    def replace_emphasis_at(self, index, value):
        self.emphasis[index] = value
    def get_computeroutput(self):
        return self.computeroutput
    def set_computeroutput(self, computeroutput):
        self.computeroutput = computeroutput
    def add_computeroutput(self, value):
        self.computeroutput.append(value)
    def insert_computeroutput_at(self, index, value):
        self.computeroutput.insert(index, value)
    def replace_computeroutput_at(self, index, value):
        self.computeroutput[index] = value
    def get_subscript(self):
        return self.subscript
    def set_subscript(self, subscript):
        self.subscript = subscript
    def add_subscript(self, value):
        self.subscript.append(value)
    def insert_subscript_at(self, index, value):
        self.subscript.insert(index, value)
    def replace_subscript_at(self, index, value):
        self.subscript[index] = value
    def get_superscript(self):
        return self.superscript
    def set_superscript(self, superscript):
        self.superscript = superscript
    def add_superscript(self, value):
        self.superscript.append(value)
    def insert_superscript_at(self, index, value):
        self.superscript.insert(index, value)
    def replace_superscript_at(self, index, value):
        self.superscript[index] = value
    def get_center(self):
        return self.center
    def set_center(self, center):
        self.center = center
    def add_center(self, value):
        self.center.append(value)
    def insert_center_at(self, index, value):
        self.center.insert(index, value)
    def replace_center_at(self, index, value):
        self.center[index] = value
    def get_small(self):
        return self.small
    def set_small(self, small):
        self.small = small
    def add_small(self, value):
        self.small.append(value)
    def insert_small_at(self, index, value):
        self.small.insert(index, value)
    def replace_small_at(self, index, value):
        self.small[index] = value
    def get_htmlonly(self):
        return self.htmlonly
    def set_htmlonly(self, htmlonly):
        self.htmlonly = htmlonly
    def add_htmlonly(self, value):
        self.htmlonly.append(value)
    def insert_htmlonly_at(self, index, value):
        self.htmlonly.insert(index, value)
    def replace_htmlonly_at(self, index, value):
        self.htmlonly[index] = value
    def get_manonly(self):
        return self.manonly
    def set_manonly(self, manonly):
        self.manonly = manonly
    def add_manonly(self, value):
        self.manonly.append(value)
    def insert_manonly_at(self, index, value):
        self.manonly.insert(index, value)
    def replace_manonly_at(self, index, value):
        self.manonly[index] = value
    def get_xmlonly(self):
        return self.xmlonly
    def set_xmlonly(self, xmlonly):
        self.xmlonly = xmlonly
    def add_xmlonly(self, value):
        self.xmlonly.append(value)
    def insert_xmlonly_at(self, index, value):
        self.xmlonly.insert(index, value)
    def replace_xmlonly_at(self, index, value):
        self.xmlonly[index] = value
    def get_rtfonly(self):
        return self.rtfonly
    def set_rtfonly(self, rtfonly):
        self.rtfonly = rtfonly
    def add_rtfonly(self, value):
        self.rtfonly.append(value)
    def insert_rtfonly_at(self, index, value):
        self.rtfonly.insert(index, value)
    def replace_rtfonly_at(self, index, value):
        self.rtfonly[index] = value
    def get_latexonly(self):
        return self.latexonly
    def set_latexonly(self, latexonly):
        self.latexonly = latexonly
    def add_latexonly(self, value):
        self.latexonly.append(value)
    def insert_latexonly_at(self, index, value):
        self.latexonly.insert(index, value)
    def replace_latexonly_at(self, index, value):
        self.latexonly[index] = value
    def get_dot(self):
        return self.dot
    def set_dot(self, dot):
        self.dot = dot
    def add_dot(self, value):
        self.dot.append(value)
    def insert_dot_at(self, index, value):
        self.dot.insert(index, value)
    def replace_dot_at(self, index, value):
        self.dot[index] = value
    def get_msc(self):
        return self.msc
    def set_msc(self, msc):
        self.msc = msc
    def add_msc(self, value):
        self.msc.append(value)
    def insert_msc_at(self, index, value):
        self.msc.insert(index, value)
    def replace_msc_at(self, index, value):
        self.msc[index] = value
    def get_anchor(self):
        return self.anchor
    def set_anchor(self, anchor):
        self.anchor = anchor
    def add_anchor(self, value):
        self.anchor.append(value)
    def insert_anchor_at(self, index, value):
        self.anchor.insert(index, value)
    def replace_anchor_at(self, index, value):
        self.anchor[index] = value
    def get_formula(self):
        return self.formula
    def set_formula(self, formula):
        self.formula = formula
    def add_formula(self, value):
        self.formula.append(value)
    def insert_formula_at(self, index, value):
        self.formula.insert(index, value)
    def replace_formula_at(self, index, value):
        self.formula[index] = value
    def get_ref(self):
        return self.ref
    def set_ref(self, ref):
        self.ref = ref
    def add_ref(self, value):
        self.ref.append(value)
    def insert_ref_at(self, index, value):
        self.ref.insert(index, value)
    def replace_ref_at(self, index, value):
        self.ref[index] = value
    def get_copy(self):
        return self.copy
    def set_copy(self, copy):
        self.copy = copy
    def add_copy(self, value):
        self.copy.append(value)
    def insert_copy_at(self, index, value):
        self.copy.insert(index, value)
    def replace_copy_at(self, index, value):
        self.copy[index] = value
    def get_trademark(self):
        return self.trademark
    def set_trademark(self, trademark):
        self.trademark = trademark
    def add_trademark(self, value):
        self.trademark.append(value)
    def insert_trademark_at(self, index, value):
        self.trademark.insert(index, value)
    def replace_trademark_at(self, index, value):
        self.trademark[index] = value
    def get_registered(self):
        return self.registered
    def set_registered(self, registered):
        self.registered = registered
    def add_registered(self, value):
        self.registered.append(value)
    def insert_registered_at(self, index, value):
        self.registered.insert(index, value)
    def replace_registered_at(self, index, value):
        self.registered[index] = value
    def get_lsquo(self):
        return self.lsquo
    def set_lsquo(self, lsquo):
        self.lsquo = lsquo
    def add_lsquo(self, value):
        self.lsquo.append(value)
    def insert_lsquo_at(self, index, value):
        self.lsquo.insert(index, value)
    def replace_lsquo_at(self, index, value):
        self.lsquo[index] = value
    def get_rsquo(self):
        return self.rsquo
    def set_rsquo(self, rsquo):
        self.rsquo = rsquo
    def add_rsquo(self, value):
        self.rsquo.append(value)
    def insert_rsquo_at(self, index, value):
        self.rsquo.insert(index, value)
    def replace_rsquo_at(self, index, value):
        self.rsquo[index] = value
    def get_ldquo(self):
        return self.ldquo
    def set_ldquo(self, ldquo):
        self.ldquo = ldquo
    def add_ldquo(self, value):
        self.ldquo.append(value)
    def insert_ldquo_at(self, index, value):
        self.ldquo.insert(index, value)
    def replace_ldquo_at(self, index, value):
        self.ldquo[index] = value
    def get_rdquo(self):
        return self.rdquo
    def set_rdquo(self, rdquo):
        self.rdquo = rdquo
    def add_rdquo(self, value):
        self.rdquo.append(value)
    def insert_rdquo_at(self, index, value):
        self.rdquo.insert(index, value)
    def replace_rdquo_at(self, index, value):
        self.rdquo[index] = value
    def get_ndash(self):
        return self.ndash
    def set_ndash(self, ndash):
        self.ndash = ndash
    def add_ndash(self, value):
        self.ndash.append(value)
    def insert_ndash_at(self, index, value):
        self.ndash.insert(index, value)
    def replace_ndash_at(self, index, value):
        self.ndash[index] = value
    def get_mdash(self):
        return self.mdash
    def set_mdash(self, mdash):
        self.mdash = mdash
    def add_mdash(self, value):
        self.mdash.append(value)
    def insert_mdash_at(self, index, value):
        self.mdash.insert(index, value)
    def replace_mdash_at(self, index, value):
        self.mdash[index] = value
    def get_umlaut(self):
        return self.umlaut
    def set_umlaut(self, umlaut):
        self.umlaut = umlaut
    def add_umlaut(self, value):
        self.umlaut.append(value)
    def insert_umlaut_at(self, index, value):
        self.umlaut.insert(index, value)
    def replace_umlaut_at(self, index, value):
        self.umlaut[index] = value
    def get_acute(self):
        return self.acute
    def set_acute(self, acute):
        self.acute = acute
    def add_acute(self, value):
        self.acute.append(value)
    def insert_acute_at(self, index, value):
        self.acute.insert(index, value)
    def replace_acute_at(self, index, value):
        self.acute[index] = value
    def get_grave(self):
        return self.grave
    def set_grave(self, grave):
        self.grave = grave
    def add_grave(self, value):
        self.grave.append(value)
    def insert_grave_at(self, index, value):
        self.grave.insert(index, value)
    def replace_grave_at(self, index, value):
        self.grave[index] = value
    def get_circ(self):
        return self.circ
    def set_circ(self, circ):
        self.circ = circ
    def add_circ(self, value):
        self.circ.append(value)
    def insert_circ_at(self, index, value):
        self.circ.insert(index, value)
    def replace_circ_at(self, index, value):
        self.circ[index] = value
    def get_slash(self):
        return self.slash
    def set_slash(self, slash):
        self.slash = slash
    def add_slash(self, value):
        self.slash.append(value)
    def insert_slash_at(self, index, value):
        self.slash.insert(index, value)
    def replace_slash_at(self, index, value):
        self.slash[index] = value
    def get_tilde(self):
        return self.tilde
    def set_tilde(self, tilde):
        self.tilde = tilde
    def add_tilde(self, value):
        self.tilde.append(value)
    def insert_tilde_at(self, index, value):
        self.tilde.insert(index, value)
    def replace_tilde_at(self, index, value):
        self.tilde[index] = value
    def get_cedil(self):
        return self.cedil
    def set_cedil(self, cedil):
        self.cedil = cedil
    def add_cedil(self, value):
        self.cedil.append(value)
    def insert_cedil_at(self, index, value):
        self.cedil.insert(index, value)
    def replace_cedil_at(self, index, value):
        self.cedil[index] = value
    def get_ring(self):
        return self.ring
    def set_ring(self, ring):
        self.ring = ring
    def add_ring(self, value):
        self.ring.append(value)
    def insert_ring_at(self, index, value):
        self.ring.insert(index, value)
    def replace_ring_at(self, index, value):
        self.ring[index] = value
    def get_szlig(self):
        return self.szlig
    def set_szlig(self, szlig):
        self.szlig = szlig
    def add_szlig(self, value):
        self.szlig.append(value)
    def insert_szlig_at(self, index, value):
        self.szlig.insert(index, value)
    def replace_szlig_at(self, index, value):
        self.szlig[index] = value
    def get_nonbreakablespace(self):
        return self.nonbreakablespace
    def set_nonbreakablespace(self, nonbreakablespace):
        self.nonbreakablespace = nonbreakablespace
    def add_nonbreakablespace(self, value):
        self.nonbreakablespace.append(value)
    def insert_nonbreakablespace_at(self, index, value):
        self.nonbreakablespace.insert(index, value)
    def replace_nonbreakablespace_at(self, index, value):
        self.nonbreakablespace[index] = value
    def get_aelig(self):
        return self.aelig
    def set_aelig(self, aelig):
        self.aelig = aelig
    def add_aelig(self, value):
        self.aelig.append(value)
    def insert_aelig_at(self, index, value):
        self.aelig.insert(index, value)
    def replace_aelig_at(self, index, value):
        self.aelig[index] = value
    def get_AElig(self):
        return self.AElig
    def set_AElig(self, AElig):
        self.AElig = AElig
    def add_AElig(self, value):
        self.AElig.append(value)
    def insert_AElig_at(self, index, value):
        self.AElig.insert(index, value)
    def replace_AElig_at(self, index, value):
        self.AElig[index] = value
    def get_Gamma(self):
        return self.Gamma
    def set_Gamma(self, Gamma):
        self.Gamma = Gamma
    def add_Gamma(self, value):
        self.Gamma.append(value)
    def insert_Gamma_at(self, index, value):
        self.Gamma.insert(index, value)
    def replace_Gamma_at(self, index, value):
        self.Gamma[index] = value
    def get_Delta(self):
        return self.Delta
    def set_Delta(self, Delta):
        self.Delta = Delta
    def add_Delta(self, value):
        self.Delta.append(value)
    def insert_Delta_at(self, index, value):
        self.Delta.insert(index, value)
    def replace_Delta_at(self, index, value):
        self.Delta[index] = value
    def get_Theta(self):
        return self.Theta
    def set_Theta(self, Theta):
        self.Theta = Theta
    def add_Theta(self, value):
        self.Theta.append(value)
    def insert_Theta_at(self, index, value):
        self.Theta.insert(index, value)
    def replace_Theta_at(self, index, value):
        self.Theta[index] = value
    def get_Lambda(self):
        return self.Lambda
    def set_Lambda(self, Lambda):
        self.Lambda = Lambda
    def add_Lambda(self, value):
        self.Lambda.append(value)
    def insert_Lambda_at(self, index, value):
        self.Lambda.insert(index, value)
    def replace_Lambda_at(self, index, value):
        self.Lambda[index] = value
    def get_Xi(self):
        return self.Xi
    def set_Xi(self, Xi):
        self.Xi = Xi
    def add_Xi(self, value):
        self.Xi.append(value)
    def insert_Xi_at(self, index, value):
        self.Xi.insert(index, value)
    def replace_Xi_at(self, index, value):
        self.Xi[index] = value
    def get_Pi(self):
        return self.Pi
    def set_Pi(self, Pi):
        self.Pi = Pi
    def add_Pi(self, value):
        self.Pi.append(value)
    def insert_Pi_at(self, index, value):
        self.Pi.insert(index, value)
    def replace_Pi_at(self, index, value):
        self.Pi[index] = value
    def get_Sigma(self):
        return self.Sigma
    def set_Sigma(self, Sigma):
        self.Sigma = Sigma
    def add_Sigma(self, value):
        self.Sigma.append(value)
    def insert_Sigma_at(self, index, value):
        self.Sigma.insert(index, value)
    def replace_Sigma_at(self, index, value):
        self.Sigma[index] = value
    def get_Upsilon(self):
        return self.Upsilon
    def set_Upsilon(self, Upsilon):
        self.Upsilon = Upsilon
    def add_Upsilon(self, value):
        self.Upsilon.append(value)
    def insert_Upsilon_at(self, index, value):
        self.Upsilon.insert(index, value)
    def replace_Upsilon_at(self, index, value):
        self.Upsilon[index] = value
    def get_Phi(self):
        return self.Phi
    def set_Phi(self, Phi):
        self.Phi = Phi
    def add_Phi(self, value):
        self.Phi.append(value)
    def insert_Phi_at(self, index, value):
        self.Phi.insert(index, value)
    def replace_Phi_at(self, index, value):
        self.Phi[index] = value
    def get_Psi(self):
        return self.Psi
    def set_Psi(self, Psi):
        self.Psi = Psi
    def add_Psi(self, value):
        self.Psi.append(value)
    def insert_Psi_at(self, index, value):
        self.Psi.insert(index, value)
    def replace_Psi_at(self, index, value):
        self.Psi[index] = value
    def get_Omega(self):
        return self.Omega
    def set_Omega(self, Omega):
        self.Omega = Omega
    def add_Omega(self, value):
        self.Omega.append(value)
    def insert_Omega_at(self, index, value):
        self.Omega.insert(index, value)
    def replace_Omega_at(self, index, value):
        self.Omega[index] = value
    def get_alpha(self):
        return self.alpha
    def set_alpha(self, alpha):
        self.alpha = alpha
    def add_alpha(self, value):
        self.alpha.append(value)
    def insert_alpha_at(self, index, value):
        self.alpha.insert(index, value)
    def replace_alpha_at(self, index, value):
        self.alpha[index] = value
    def get_beta(self):
        return self.beta
    def set_beta(self, beta):
        self.beta = beta
    def add_beta(self, value):
        self.beta.append(value)
    def insert_beta_at(self, index, value):
        self.beta.insert(index, value)
    def replace_beta_at(self, index, value):
        self.beta[index] = value
    def get_gamma(self):
        return self.gamma
    def set_gamma(self, gamma):
        self.gamma = gamma
    def add_gamma(self, value):
        self.gamma.append(value)
    def insert_gamma_at(self, index, value):
        self.gamma.insert(index, value)
    def replace_gamma_at(self, index, value):
        self.gamma[index] = value
    def get_delta(self):
        return self.delta
    def set_delta(self, delta):
        self.delta = delta
    def add_delta(self, value):
        self.delta.append(value)
    def insert_delta_at(self, index, value):
        self.delta.insert(index, value)
    def replace_delta_at(self, index, value):
        self.delta[index] = value
    def get_epsilon(self):
        return self.epsilon
    def set_epsilon(self, epsilon):
        self.epsilon = epsilon
    def add_epsilon(self, value):
        self.epsilon.append(value)
    def insert_epsilon_at(self, index, value):
        self.epsilon.insert(index, value)
    def replace_epsilon_at(self, index, value):
        self.epsilon[index] = value
    def get_zeta(self):
        return self.zeta
    def set_zeta(self, zeta):
        self.zeta = zeta
    def add_zeta(self, value):
        self.zeta.append(value)
    def insert_zeta_at(self, index, value):
        self.zeta.insert(index, value)
    def replace_zeta_at(self, index, value):
        self.zeta[index] = value
    def get_eta(self):
        return self.eta
    def set_eta(self, eta):
        self.eta = eta
    def add_eta(self, value):
        self.eta.append(value)
    def insert_eta_at(self, index, value):
        self.eta.insert(index, value)
    def replace_eta_at(self, index, value):
        self.eta[index] = value
    def get_theta(self):
        return self.theta
    def set_theta(self, theta):
        self.theta = theta
    def add_theta(self, value):
        self.theta.append(value)
    def insert_theta_at(self, index, value):
        self.theta.insert(index, value)
    def replace_theta_at(self, index, value):
        self.theta[index] = value
    def get_iota(self):
        return self.iota
    def set_iota(self, iota):
        self.iota = iota
    def add_iota(self, value):
        self.iota.append(value)
    def insert_iota_at(self, index, value):
        self.iota.insert(index, value)
    def replace_iota_at(self, index, value):
        self.iota[index] = value
    def get_kappa(self):
        return self.kappa
    def set_kappa(self, kappa):
        self.kappa = kappa
    def add_kappa(self, value):
        self.kappa.append(value)
    def insert_kappa_at(self, index, value):
        self.kappa.insert(index, value)
    def replace_kappa_at(self, index, value):
        self.kappa[index] = value
    def get_lambda(self):
        return self.lambda_
    def set_lambda(self, lambda_):
        self.lambda_ = lambda_
    def add_lambda(self, value):
        self.lambda_.append(value)
    def insert_lambda_at(self, index, value):
        self.lambda_.insert(index, value)
    def replace_lambda_at(self, index, value):
        self.lambda_[index] = value
    def get_mu(self):
        return self.mu
    def set_mu(self, mu):
        self.mu = mu
    def add_mu(self, value):
        self.mu.append(value)
    def insert_mu_at(self, index, value):
        self.mu.insert(index, value)
    def replace_mu_at(self, index, value):
        self.mu[index] = value
    def get_nu(self):
        return self.nu
    def set_nu(self, nu):
        self.nu = nu
    def add_nu(self, value):
        self.nu.append(value)
    def insert_nu_at(self, index, value):
        self.nu.insert(index, value)
    def replace_nu_at(self, index, value):
        self.nu[index] = value
    def get_xi(self):
        return self.xi
    def set_xi(self, xi):
        self.xi = xi
    def add_xi(self, value):
        self.xi.append(value)
    def insert_xi_at(self, index, value):
        self.xi.insert(index, value)
    def replace_xi_at(self, index, value):
        self.xi[index] = value
    def get_pi(self):
        return self.pi
    def set_pi(self, pi):
        self.pi = pi
    def add_pi(self, value):
        self.pi.append(value)
    def insert_pi_at(self, index, value):
        self.pi.insert(index, value)
    def replace_pi_at(self, index, value):
        self.pi[index] = value
    def get_rho(self):
        return self.rho
    def set_rho(self, rho):
        self.rho = rho
    def add_rho(self, value):
        self.rho.append(value)
    def insert_rho_at(self, index, value):
        self.rho.insert(index, value)
    def replace_rho_at(self, index, value):
        self.rho[index] = value
    def get_sigma(self):
        return self.sigma
    def set_sigma(self, sigma):
        self.sigma = sigma
    def add_sigma(self, value):
        self.sigma.append(value)
    def insert_sigma_at(self, index, value):
        self.sigma.insert(index, value)
    def replace_sigma_at(self, index, value):
        self.sigma[index] = value
    def get_tau(self):
        return self.tau
    def set_tau(self, tau):
        self.tau = tau
    def add_tau(self, value):
        self.tau.append(value)
    def insert_tau_at(self, index, value):
        self.tau.insert(index, value)
    def replace_tau_at(self, index, value):
        self.tau[index] = value
    def get_upsilon(self):
        return self.upsilon
    def set_upsilon(self, upsilon):
        self.upsilon = upsilon
    def add_upsilon(self, value):
        self.upsilon.append(value)
    def insert_upsilon_at(self, index, value):
        self.upsilon.insert(index, value)
    def replace_upsilon_at(self, index, value):
        self.upsilon[index] = value
    def get_phi(self):
        return self.phi
    def set_phi(self, phi):
        self.phi = phi
    def add_phi(self, value):
        self.phi.append(value)
    def insert_phi_at(self, index, value):
        self.phi.insert(index, value)
    def replace_phi_at(self, index, value):
        self.phi[index] = value
    def get_chi(self):
        return self.chi
    def set_chi(self, chi):
        self.chi = chi
    def add_chi(self, value):
        self.chi.append(value)
    def insert_chi_at(self, index, value):
        self.chi.insert(index, value)
    def replace_chi_at(self, index, value):
        self.chi[index] = value
    def get_psi(self):
        return self.psi
    def set_psi(self, psi):
        self.psi = psi
    def add_psi(self, value):
        self.psi.append(value)
    def insert_psi_at(self, index, value):
        self.psi.insert(index, value)
    def replace_psi_at(self, index, value):
        self.psi[index] = value
    def get_omega(self):
        return self.omega
    def set_omega(self, omega):
        self.omega = omega
    def add_omega(self, value):
        self.omega.append(value)
    def insert_omega_at(self, index, value):
        self.omega.insert(index, value)
    def replace_omega_at(self, index, value):
        self.omega[index] = value
    def get_sigmaf(self):
        return self.sigmaf
    def set_sigmaf(self, sigmaf):
        self.sigmaf = sigmaf
    def add_sigmaf(self, value):
        self.sigmaf.append(value)
    def insert_sigmaf_at(self, index, value):
        self.sigmaf.insert(index, value)
    def replace_sigmaf_at(self, index, value):
        self.sigmaf[index] = value
    def get_sect(self):
        return self.sect
    def set_sect(self, sect):
        self.sect = sect
    def add_sect(self, value):
        self.sect.append(value)
    def insert_sect_at(self, index, value):
        self.sect.insert(index, value)
    def replace_sect_at(self, index, value):
        self.sect[index] = value
    def get_deg(self):
        return self.deg
    def set_deg(self, deg):
        self.deg = deg
    def add_deg(self, value):
        self.deg.append(value)
    def insert_deg_at(self, index, value):
        self.deg.insert(index, value)
    def replace_deg_at(self, index, value):
        self.deg[index] = value
    def get_prime(self):
        return self.prime
    def set_prime(self, prime):
        self.prime = prime
    def add_prime(self, value):
        self.prime.append(value)
    def insert_prime_at(self, index, value):
        self.prime.insert(index, value)
    def replace_prime_at(self, index, value):
        self.prime[index] = value
    def get_Prime(self):
        return self.Prime
    def set_Prime(self, Prime):
        self.Prime = Prime
    def add_Prime(self, value):
        self.Prime.append(value)
    def insert_Prime_at(self, index, value):
        self.Prime.insert(index, value)
    def replace_Prime_at(self, index, value):
        self.Prime[index] = value
    def get_infin(self):
        return self.infin
    def set_infin(self, infin):
        self.infin = infin
    def add_infin(self, value):
        self.infin.append(value)
    def insert_infin_at(self, index, value):
        self.infin.insert(index, value)
    def replace_infin_at(self, index, value):
        self.infin[index] = value
    def get_empty(self):
        return self.empty
    def set_empty(self, empty):
        self.empty = empty
    def add_empty(self, value):
        self.empty.append(value)
    def insert_empty_at(self, index, value):
        self.empty.insert(index, value)
    def replace_empty_at(self, index, value):
        self.empty[index] = value
    def get_plusmn(self):
        return self.plusmn
    def set_plusmn(self, plusmn):
        self.plusmn = plusmn
    def add_plusmn(self, value):
        self.plusmn.append(value)
    def insert_plusmn_at(self, index, value):
        self.plusmn.insert(index, value)
    def replace_plusmn_at(self, index, value):
        self.plusmn[index] = value
    def get_times(self):
        return self.times
    def set_times(self, times):
        self.times = times
    def add_times(self, value):
        self.times.append(value)
    def insert_times_at(self, index, value):
        self.times.insert(index, value)
    def replace_times_at(self, index, value):
        self.times[index] = value
    def get_minus(self):
        return self.minus
    def set_minus(self, minus):
        self.minus = minus
    def add_minus(self, value):
        self.minus.append(value)
    def insert_minus_at(self, index, value):
        self.minus.insert(index, value)
    def replace_minus_at(self, index, value):
        self.minus[index] = value
    def get_sdot(self):
        return self.sdot
    def set_sdot(self, sdot):
        self.sdot = sdot
    def add_sdot(self, value):
        self.sdot.append(value)
    def insert_sdot_at(self, index, value):
        self.sdot.insert(index, value)
    def replace_sdot_at(self, index, value):
        self.sdot[index] = value
    def get_part(self):
        return self.part
    def set_part(self, part):
        self.part = part
    def add_part(self, value):
        self.part.append(value)
    def insert_part_at(self, index, value):
        self.part.insert(index, value)
    def replace_part_at(self, index, value):
        self.part[index] = value
    def get_nabla(self):
        return self.nabla
    def set_nabla(self, nabla):
        self.nabla = nabla
    def add_nabla(self, value):
        self.nabla.append(value)
    def insert_nabla_at(self, index, value):
        self.nabla.insert(index, value)
    def replace_nabla_at(self, index, value):
        self.nabla[index] = value
    def get_radic(self):
        return self.radic
    def set_radic(self, radic):
        self.radic = radic
    def add_radic(self, value):
        self.radic.append(value)
    def insert_radic_at(self, index, value):
        self.radic.insert(index, value)
    def replace_radic_at(self, index, value):
        self.radic[index] = value
    def get_perp(self):
        return self.perp
    def set_perp(self, perp):
        self.perp = perp
    def add_perp(self, value):
        self.perp.append(value)
    def insert_perp_at(self, index, value):
        self.perp.insert(index, value)
    def replace_perp_at(self, index, value):
        self.perp[index] = value
    def get_sum(self):
        return self.sum
    def set_sum(self, sum):
        self.sum = sum
    def add_sum(self, value):
        self.sum.append(value)
    def insert_sum_at(self, index, value):
        self.sum.insert(index, value)
    def replace_sum_at(self, index, value):
        self.sum[index] = value
    def get_int(self):
        return self.int
    def set_int(self, int):
        self.int = int
    def add_int(self, value):
        self.int.append(value)
    def insert_int_at(self, index, value):
        self.int.insert(index, value)
    def replace_int_at(self, index, value):
        self.int[index] = value
    def get_prod(self):
        return self.prod
    def set_prod(self, prod):
        self.prod = prod
    def add_prod(self, value):
        self.prod.append(value)
    def insert_prod_at(self, index, value):
        self.prod.insert(index, value)
    def replace_prod_at(self, index, value):
        self.prod[index] = value
    def get_sim(self):
        return self.sim
    def set_sim(self, sim):
        self.sim = sim
    def add_sim(self, value):
        self.sim.append(value)
    def insert_sim_at(self, index, value):
        self.sim.insert(index, value)
    def replace_sim_at(self, index, value):
        self.sim[index] = value
    def get_asymp(self):
        return self.asymp
    def set_asymp(self, asymp):
        self.asymp = asymp
    def add_asymp(self, value):
        self.asymp.append(value)
    def insert_asymp_at(self, index, value):
        self.asymp.insert(index, value)
    def replace_asymp_at(self, index, value):
        self.asymp[index] = value
    def get_ne(self):
        return self.ne
    def set_ne(self, ne):
        self.ne = ne
    def add_ne(self, value):
        self.ne.append(value)
    def insert_ne_at(self, index, value):
        self.ne.insert(index, value)
    def replace_ne_at(self, index, value):
        self.ne[index] = value
    def get_equiv(self):
        return self.equiv
    def set_equiv(self, equiv):
        self.equiv = equiv
    def add_equiv(self, value):
        self.equiv.append(value)
    def insert_equiv_at(self, index, value):
        self.equiv.insert(index, value)
    def replace_equiv_at(self, index, value):
        self.equiv[index] = value
    def get_prop(self):
        return self.prop
    def set_prop(self, prop):
        self.prop = prop
    def add_prop(self, value):
        self.prop.append(value)
    def insert_prop_at(self, index, value):
        self.prop.insert(index, value)
    def replace_prop_at(self, index, value):
        self.prop[index] = value
    def get_le(self):
        return self.le
    def set_le(self, le):
        self.le = le
    def add_le(self, value):
        self.le.append(value)
    def insert_le_at(self, index, value):
        self.le.insert(index, value)
    def replace_le_at(self, index, value):
        self.le[index] = value
    def get_ge(self):
        return self.ge
    def set_ge(self, ge):
        self.ge = ge
    def add_ge(self, value):
        self.ge.append(value)
    def insert_ge_at(self, index, value):
        self.ge.insert(index, value)
    def replace_ge_at(self, index, value):
        self.ge[index] = value
    def get_larr(self):
        return self.larr
    def set_larr(self, larr):
        self.larr = larr
    def add_larr(self, value):
        self.larr.append(value)
    def insert_larr_at(self, index, value):
        self.larr.insert(index, value)
    def replace_larr_at(self, index, value):
        self.larr[index] = value
    def get_rarr(self):
        return self.rarr
    def set_rarr(self, rarr):
        self.rarr = rarr
    def add_rarr(self, value):
        self.rarr.append(value)
    def insert_rarr_at(self, index, value):
        self.rarr.insert(index, value)
    def replace_rarr_at(self, index, value):
        self.rarr[index] = value
    def get_isin(self):
        return self.isin
    def set_isin(self, isin):
        self.isin = isin
    def add_isin(self, value):
        self.isin.append(value)
    def insert_isin_at(self, index, value):
        self.isin.insert(index, value)
    def replace_isin_at(self, index, value):
        self.isin[index] = value
    def get_notin(self):
        return self.notin
    def set_notin(self, notin):
        self.notin = notin
    def add_notin(self, value):
        self.notin.append(value)
    def insert_notin_at(self, index, value):
        self.notin.insert(index, value)
    def replace_notin_at(self, index, value):
        self.notin[index] = value
    def get_lceil(self):
        return self.lceil
    def set_lceil(self, lceil):
        self.lceil = lceil
    def add_lceil(self, value):
        self.lceil.append(value)
    def insert_lceil_at(self, index, value):
        self.lceil.insert(index, value)
    def replace_lceil_at(self, index, value):
        self.lceil[index] = value
    def get_rceil(self):
        return self.rceil
    def set_rceil(self, rceil):
        self.rceil = rceil
    def add_rceil(self, value):
        self.rceil.append(value)
    def insert_rceil_at(self, index, value):
        self.rceil.insert(index, value)
    def replace_rceil_at(self, index, value):
        self.rceil[index] = value
    def get_lfloor(self):
        return self.lfloor
    def set_lfloor(self, lfloor):
        self.lfloor = lfloor
    def add_lfloor(self, value):
        self.lfloor.append(value)
    def insert_lfloor_at(self, index, value):
        self.lfloor.insert(index, value)
    def replace_lfloor_at(self, index, value):
        self.lfloor[index] = value
    def get_rfloor(self):
        return self.rfloor
    def set_rfloor(self, rfloor):
        self.rfloor = rfloor
    def add_rfloor(self, value):
        self.rfloor.append(value)
    def insert_rfloor_at(self, index, value):
        self.rfloor.insert(index, value)
    def replace_rfloor_at(self, index, value):
        self.rfloor[index] = value
    def get_url(self):
        return self.url
    def set_url(self, url):
        self.url = url
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.ulink or
            self.bold or
            self.emphasis or
            self.computeroutput or
            self.subscript or
            self.superscript or
            self.center or
            self.small or
            self.htmlonly or
            self.manonly or
            self.xmlonly or
            self.rtfonly or
            self.latexonly or
            self.dot or
            self.msc or
            self.anchor or
            self.formula or
            self.ref or
            self.copy or
            self.trademark or
            self.registered or
            self.lsquo or
            self.rsquo or
            self.ldquo or
            self.rdquo or
            self.ndash or
            self.mdash or
            self.umlaut or
            self.acute or
            self.grave or
            self.circ or
            self.slash or
            self.tilde or
            self.cedil or
            self.ring or
            self.szlig or
            self.nonbreakablespace or
            self.aelig or
            self.AElig or
            self.Gamma or
            self.Delta or
            self.Theta or
            self.Lambda or
            self.Xi or
            self.Pi or
            self.Sigma or
            self.Upsilon or
            self.Phi or
            self.Psi or
            self.Omega or
            self.alpha or
            self.beta or
            self.gamma or
            self.delta or
            self.epsilon or
            self.zeta or
            self.eta or
            self.theta or
            self.iota or
            self.kappa or
            self.lambda_ or
            self.mu or
            self.nu or
            self.xi or
            self.pi or
            self.rho or
            self.sigma or
            self.tau or
            self.upsilon or
            self.phi or
            self.chi or
            self.psi or
            self.omega or
            self.sigmaf or
            self.sect or
            self.deg or
            self.prime or
            self.Prime or
            self.infin or
            self.empty or
            self.plusmn or
            self.times or
            self.minus or
            self.sdot or
            self.part or
            self.nabla or
            self.radic or
            self.perp or
            self.sum or
            self.int or
            self.prod or
            self.sim or
            self.asymp or
            self.ne or
            self.equiv or
            self.prop or
            self.le or
            self.ge or
            self.larr or
            self.rarr or
            self.isin or
            self.notin or
            self.lceil or
            self.rceil or
            self.lfloor or
            self.rfloor or
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_) or
            self.content_
        ):
            return True
        return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docURLLink', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('docURLLink')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'docURLLink':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='docURLLink')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='docURLLink', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='docURLLink'):
        if self.url is not None and 'url' not in already_processed:
            already_processed.add('url')
            outfile.write(' url=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.url), input_name='url')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='docURLLink', fromsubclass_=False, pretty_print=True):
        if not fromsubclass_:
            for item_ in self.content_:
                item_.export(outfile, level, item_.name, namespaceprefix_, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ulink_ in self.ulink:
            namespaceprefix_ = self.ulink_nsprefix_ + ':' if (UseCapturedNS_ and self.ulink_nsprefix_) else ''
            ulink_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ulink', pretty_print=pretty_print)
        for bold_ in self.bold:
            namespaceprefix_ = self.bold_nsprefix_ + ':' if (UseCapturedNS_ and self.bold_nsprefix_) else ''
            bold_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bold', pretty_print=pretty_print)
        for emphasis_ in self.emphasis:
            namespaceprefix_ = self.emphasis_nsprefix_ + ':' if (UseCapturedNS_ and self.emphasis_nsprefix_) else ''
            emphasis_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='emphasis', pretty_print=pretty_print)
        for computeroutput_ in self.computeroutput:
            namespaceprefix_ = self.computeroutput_nsprefix_ + ':' if (UseCapturedNS_ and self.computeroutput_nsprefix_) else ''
            computeroutput_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='computeroutput', pretty_print=pretty_print)
        for subscript_ in self.subscript:
            namespaceprefix_ = self.subscript_nsprefix_ + ':' if (UseCapturedNS_ and self.subscript_nsprefix_) else ''
            subscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subscript', pretty_print=pretty_print)
        for superscript_ in self.superscript:
            namespaceprefix_ = self.superscript_nsprefix_ + ':' if (UseCapturedNS_ and self.superscript_nsprefix_) else ''
            superscript_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='superscript', pretty_print=pretty_print)
        for center_ in self.center:
            namespaceprefix_ = self.center_nsprefix_ + ':' if (UseCapturedNS_ and self.center_nsprefix_) else ''
            center_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='center', pretty_print=pretty_print)
        for small_ in self.small:
            namespaceprefix_ = self.small_nsprefix_ + ':' if (UseCapturedNS_ and self.small_nsprefix_) else ''
            small_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='small', pretty_print=pretty_print)
        for htmlonly_ in self.htmlonly:
            namespaceprefix_ = self.htmlonly_nsprefix_ + ':' if (UseCapturedNS_ and self.htmlonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shtmlonly>%s</%shtmlonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(htmlonly_), input_name='htmlonly')), namespaceprefix_ , eol_))
        for manonly_ in self.manonly:
            namespaceprefix_ = self.manonly_nsprefix_ + ':' if (UseCapturedNS_ and self.manonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smanonly>%s</%smanonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(manonly_), input_name='manonly')), namespaceprefix_ , eol_))
        for xmlonly_ in self.xmlonly:
            namespaceprefix_ = self.xmlonly_nsprefix_ + ':' if (UseCapturedNS_ and self.xmlonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sxmlonly>%s</%sxmlonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(xmlonly_), input_name='xmlonly')), namespaceprefix_ , eol_))
        for rtfonly_ in self.rtfonly:
            namespaceprefix_ = self.rtfonly_nsprefix_ + ':' if (UseCapturedNS_ and self.rtfonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srtfonly>%s</%srtfonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(rtfonly_), input_name='rtfonly')), namespaceprefix_ , eol_))
        for latexonly_ in self.latexonly:
            namespaceprefix_ = self.latexonly_nsprefix_ + ':' if (UseCapturedNS_ and self.latexonly_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slatexonly>%s</%slatexonly>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(latexonly_), input_name='latexonly')), namespaceprefix_ , eol_))
        for dot_ in self.dot:
            namespaceprefix_ = self.dot_nsprefix_ + ':' if (UseCapturedNS_ and self.dot_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdot>%s</%sdot>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(dot_), input_name='dot')), namespaceprefix_ , eol_))
        for msc_ in self.msc:
            namespaceprefix_ = self.msc_nsprefix_ + ':' if (UseCapturedNS_ and self.msc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smsc>%s</%smsc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(msc_), input_name='msc')), namespaceprefix_ , eol_))
        for anchor_ in self.anchor:
            namespaceprefix_ = self.anchor_nsprefix_ + ':' if (UseCapturedNS_ and self.anchor_nsprefix_) else ''
            anchor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='anchor', pretty_print=pretty_print)
        for formula_ in self.formula:
            namespaceprefix_ = self.formula_nsprefix_ + ':' if (UseCapturedNS_ and self.formula_nsprefix_) else ''
            formula_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='formula', pretty_print=pretty_print)
        for ref_ in self.ref:
            namespaceprefix_ = self.ref_nsprefix_ + ':' if (UseCapturedNS_ and self.ref_nsprefix_) else ''
            ref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ref', pretty_print=pretty_print)
        for copy_ in self.copy:
            namespaceprefix_ = self.copy_nsprefix_ + ':' if (UseCapturedNS_ and self.copy_nsprefix_) else ''
            copy_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='copy', pretty_print=pretty_print)
        for trademark_ in self.trademark:
            namespaceprefix_ = self.trademark_nsprefix_ + ':' if (UseCapturedNS_ and self.trademark_nsprefix_) else ''
            trademark_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='trademark', pretty_print=pretty_print)
        for registered_ in self.registered:
            namespaceprefix_ = self.registered_nsprefix_ + ':' if (UseCapturedNS_ and self.registered_nsprefix_) else ''
            registered_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='registered', pretty_print=pretty_print)
        for lsquo_ in self.lsquo:
            namespaceprefix_ = self.lsquo_nsprefix_ + ':' if (UseCapturedNS_ and self.lsquo_nsprefix_) else ''
            lsquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lsquo', pretty_print=pretty_print)
        for rsquo_ in self.rsquo:
            namespaceprefix_ = self.rsquo_nsprefix_ + ':' if (UseCapturedNS_ and self.rsquo_nsprefix_) else ''
            rsquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rsquo', pretty_print=pretty_print)
        for ldquo_ in self.ldquo:
            namespaceprefix_ = self.ldquo_nsprefix_ + ':' if (UseCapturedNS_ and self.ldquo_nsprefix_) else ''
            ldquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ldquo', pretty_print=pretty_print)
        for rdquo_ in self.rdquo:
            namespaceprefix_ = self.rdquo_nsprefix_ + ':' if (UseCapturedNS_ and self.rdquo_nsprefix_) else ''
            rdquo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rdquo', pretty_print=pretty_print)
        for ndash_ in self.ndash:
            namespaceprefix_ = self.ndash_nsprefix_ + ':' if (UseCapturedNS_ and self.ndash_nsprefix_) else ''
            ndash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ndash', pretty_print=pretty_print)
        for mdash_ in self.mdash:
            namespaceprefix_ = self.mdash_nsprefix_ + ':' if (UseCapturedNS_ and self.mdash_nsprefix_) else ''
            mdash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mdash', pretty_print=pretty_print)
        for umlaut_ in self.umlaut:
            namespaceprefix_ = self.umlaut_nsprefix_ + ':' if (UseCapturedNS_ and self.umlaut_nsprefix_) else ''
            umlaut_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='umlaut', pretty_print=pretty_print)
        for acute_ in self.acute:
            namespaceprefix_ = self.acute_nsprefix_ + ':' if (UseCapturedNS_ and self.acute_nsprefix_) else ''
            acute_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='acute', pretty_print=pretty_print)
        for grave_ in self.grave:
            namespaceprefix_ = self.grave_nsprefix_ + ':' if (UseCapturedNS_ and self.grave_nsprefix_) else ''
            grave_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='grave', pretty_print=pretty_print)
        for circ_ in self.circ:
            namespaceprefix_ = self.circ_nsprefix_ + ':' if (UseCapturedNS_ and self.circ_nsprefix_) else ''
            circ_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='circ', pretty_print=pretty_print)
        for slash_ in self.slash:
            namespaceprefix_ = self.slash_nsprefix_ + ':' if (UseCapturedNS_ and self.slash_nsprefix_) else ''
            slash_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='slash', pretty_print=pretty_print)
        for tilde_ in self.tilde:
            namespaceprefix_ = self.tilde_nsprefix_ + ':' if (UseCapturedNS_ and self.tilde_nsprefix_) else ''
            tilde_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tilde', pretty_print=pretty_print)
        for cedil_ in self.cedil:
            namespaceprefix_ = self.cedil_nsprefix_ + ':' if (UseCapturedNS_ and self.cedil_nsprefix_) else ''
            cedil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='cedil', pretty_print=pretty_print)
        for ring_ in self.ring:
            namespaceprefix_ = self.ring_nsprefix_ + ':' if (UseCapturedNS_ and self.ring_nsprefix_) else ''
            ring_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ring', pretty_print=pretty_print)
        for szlig_ in self.szlig:
            namespaceprefix_ = self.szlig_nsprefix_ + ':' if (UseCapturedNS_ and self.szlig_nsprefix_) else ''
            szlig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='szlig', pretty_print=pretty_print)
        for nonbreakablespace_ in self.nonbreakablespace:
            namespaceprefix_ = self.nonbreakablespace_nsprefix_ + ':' if (UseCapturedNS_ and self.nonbreakablespace_nsprefix_) else ''
            nonbreakablespace_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nonbreakablespace', pretty_print=pretty_print)
        for aelig_ in self.aelig:
            namespaceprefix_ = self.aelig_nsprefix_ + ':' if (UseCapturedNS_ and self.aelig_nsprefix_) else ''
            aelig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='aelig', pretty_print=pretty_print)
        for AElig_ in self.AElig:
            namespaceprefix_ = self.AElig_nsprefix_ + ':' if (UseCapturedNS_ and self.AElig_nsprefix_) else ''
            AElig_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AElig', pretty_print=pretty_print)
        for Gamma_ in self.Gamma:
            namespaceprefix_ = self.Gamma_nsprefix_ + ':' if (UseCapturedNS_ and self.Gamma_nsprefix_) else ''
            Gamma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Gamma', pretty_print=pretty_print)
        for Delta_ in self.Delta:
            namespaceprefix_ = self.Delta_nsprefix_ + ':' if (UseCapturedNS_ and self.Delta_nsprefix_) else ''
            Delta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Delta', pretty_print=pretty_print)
        for Theta_ in self.Theta:
            namespaceprefix_ = self.Theta_nsprefix_ + ':' if (UseCapturedNS_ and self.Theta_nsprefix_) else ''
            Theta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Theta', pretty_print=pretty_print)
        for Lambda_ in self.Lambda:
            namespaceprefix_ = self.Lambda_nsprefix_ + ':' if (UseCapturedNS_ and self.Lambda_nsprefix_) else ''
            Lambda_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Lambda', pretty_print=pretty_print)
        for Xi_ in self.Xi:
            namespaceprefix_ = self.Xi_nsprefix_ + ':' if (UseCapturedNS_ and self.Xi_nsprefix_) else ''
            Xi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Xi', pretty_print=pretty_print)
        for Pi_ in self.Pi:
            namespaceprefix_ = self.Pi_nsprefix_ + ':' if (UseCapturedNS_ and self.Pi_nsprefix_) else ''
            Pi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Pi', pretty_print=pretty_print)
        for Sigma_ in self.Sigma:
            namespaceprefix_ = self.Sigma_nsprefix_ + ':' if (UseCapturedNS_ and self.Sigma_nsprefix_) else ''
            Sigma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Sigma', pretty_print=pretty_print)
        for Upsilon_ in self.Upsilon:
            namespaceprefix_ = self.Upsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.Upsilon_nsprefix_) else ''
            Upsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Upsilon', pretty_print=pretty_print)
        for Phi_ in self.Phi:
            namespaceprefix_ = self.Phi_nsprefix_ + ':' if (UseCapturedNS_ and self.Phi_nsprefix_) else ''
            Phi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Phi', pretty_print=pretty_print)
        for Psi_ in self.Psi:
            namespaceprefix_ = self.Psi_nsprefix_ + ':' if (UseCapturedNS_ and self.Psi_nsprefix_) else ''
            Psi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Psi', pretty_print=pretty_print)
        for Omega_ in self.Omega:
            namespaceprefix_ = self.Omega_nsprefix_ + ':' if (UseCapturedNS_ and self.Omega_nsprefix_) else ''
            Omega_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Omega', pretty_print=pretty_print)
        for alpha_ in self.alpha:
            namespaceprefix_ = self.alpha_nsprefix_ + ':' if (UseCapturedNS_ and self.alpha_nsprefix_) else ''
            alpha_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='alpha', pretty_print=pretty_print)
        for beta_ in self.beta:
            namespaceprefix_ = self.beta_nsprefix_ + ':' if (UseCapturedNS_ and self.beta_nsprefix_) else ''
            beta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='beta', pretty_print=pretty_print)
        for gamma_ in self.gamma:
            namespaceprefix_ = self.gamma_nsprefix_ + ':' if (UseCapturedNS_ and self.gamma_nsprefix_) else ''
            gamma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='gamma', pretty_print=pretty_print)
        for delta_ in self.delta:
            namespaceprefix_ = self.delta_nsprefix_ + ':' if (UseCapturedNS_ and self.delta_nsprefix_) else ''
            delta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='delta', pretty_print=pretty_print)
        for epsilon_ in self.epsilon:
            namespaceprefix_ = self.epsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.epsilon_nsprefix_) else ''
            epsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='epsilon', pretty_print=pretty_print)
        for zeta_ in self.zeta:
            namespaceprefix_ = self.zeta_nsprefix_ + ':' if (UseCapturedNS_ and self.zeta_nsprefix_) else ''
            zeta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='zeta', pretty_print=pretty_print)
        for eta_ in self.eta:
            namespaceprefix_ = self.eta_nsprefix_ + ':' if (UseCapturedNS_ and self.eta_nsprefix_) else ''
            eta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='eta', pretty_print=pretty_print)
        for theta_ in self.theta:
            namespaceprefix_ = self.theta_nsprefix_ + ':' if (UseCapturedNS_ and self.theta_nsprefix_) else ''
            theta_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='theta', pretty_print=pretty_print)
        for iota_ in self.iota:
            namespaceprefix_ = self.iota_nsprefix_ + ':' if (UseCapturedNS_ and self.iota_nsprefix_) else ''
            iota_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='iota', pretty_print=pretty_print)
        for kappa_ in self.kappa:
            namespaceprefix_ = self.kappa_nsprefix_ + ':' if (UseCapturedNS_ and self.kappa_nsprefix_) else ''
            kappa_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='kappa', pretty_print=pretty_print)
        for lambda_ in self.lambda_:
            namespaceprefix_ = self.lambda__nsprefix_ + ':' if (UseCapturedNS_ and self.lambda__nsprefix_) else ''
            lambda_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lambda', pretty_print=pretty_print)
        for mu_ in self.mu:
            namespaceprefix_ = self.mu_nsprefix_ + ':' if (UseCapturedNS_ and self.mu_nsprefix_) else ''
            mu_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mu', pretty_print=pretty_print)
        for nu_ in self.nu:
            namespaceprefix_ = self.nu_nsprefix_ + ':' if (UseCapturedNS_ and self.nu_nsprefix_) else ''
            nu_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nu', pretty_print=pretty_print)
        for xi_ in self.xi:
            namespaceprefix_ = self.xi_nsprefix_ + ':' if (UseCapturedNS_ and self.xi_nsprefix_) else ''
            xi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='xi', pretty_print=pretty_print)
        for pi_ in self.pi:
            namespaceprefix_ = self.pi_nsprefix_ + ':' if (UseCapturedNS_ and self.pi_nsprefix_) else ''
            pi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='pi', pretty_print=pretty_print)
        for rho_ in self.rho:
            namespaceprefix_ = self.rho_nsprefix_ + ':' if (UseCapturedNS_ and self.rho_nsprefix_) else ''
            rho_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rho', pretty_print=pretty_print)
        for sigma_ in self.sigma:
            namespaceprefix_ = self.sigma_nsprefix_ + ':' if (UseCapturedNS_ and self.sigma_nsprefix_) else ''
            sigma_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sigma', pretty_print=pretty_print)
        for tau_ in self.tau:
            namespaceprefix_ = self.tau_nsprefix_ + ':' if (UseCapturedNS_ and self.tau_nsprefix_) else ''
            tau_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tau', pretty_print=pretty_print)
        for upsilon_ in self.upsilon:
            namespaceprefix_ = self.upsilon_nsprefix_ + ':' if (UseCapturedNS_ and self.upsilon_nsprefix_) else ''
            upsilon_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='upsilon', pretty_print=pretty_print)
        for phi_ in self.phi:
            namespaceprefix_ = self.phi_nsprefix_ + ':' if (UseCapturedNS_ and self.phi_nsprefix_) else ''
            phi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='phi', pretty_print=pretty_print)
        for chi_ in self.chi:
            namespaceprefix_ = self.chi_nsprefix_ + ':' if (UseCapturedNS_ and self.chi_nsprefix_) else ''
            chi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='chi', pretty_print=pretty_print)
        for psi_ in self.psi:
            namespaceprefix_ = self.psi_nsprefix_ + ':' if (UseCapturedNS_ and self.psi_nsprefix_) else ''
            psi_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='psi', pretty_print=pretty_print)
        for omega_ in self.omega:
            namespaceprefix_ = self.omega_nsprefix_ + ':' if (UseCapturedNS_ and self.omega_nsprefix_) else ''
            omega_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='omega', pretty_print=pretty_print)
        for sigmaf_ in self.sigmaf:
            namespaceprefix_ = self.sigmaf_nsprefix_ + ':' if (UseCapturedNS_ and self.sigmaf_nsprefix_) else ''
            sigmaf_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sigmaf', pretty_print=pretty_print)
        for sect_ in self.sect:
            namespaceprefix_ = self.sect_nsprefix_ + ':' if (UseCapturedNS_ and self.sect_nsprefix_) else ''
            sect_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sect', pretty_print=pretty_print)
        for deg_ in self.deg:
            namespaceprefix_ = self.deg_nsprefix_ + ':' if (UseCapturedNS_ and self.deg_nsprefix_) else ''
            deg_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='deg', pretty_print=pretty_print)
        for prime_ in self.prime:
            namespaceprefix_ = self.prime_nsprefix_ + ':' if (UseCapturedNS_ and self.prime_nsprefix_) else ''
            prime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prime', pretty_print=pretty_print)
        for Prime_ in self.Prime:
            namespaceprefix_ = self.Prime_nsprefix_ + ':' if (UseCapturedNS_ and self.Prime_nsprefix_) else ''
            Prime_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Prime', pretty_print=pretty_print)
        for infin_ in self.infin:
            namespaceprefix_ = self.infin_nsprefix_ + ':' if (UseCapturedNS_ and self.infin_nsprefix_) else ''
            infin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='infin', pretty_print=pretty_print)
        for empty_ in self.empty:
            namespaceprefix_ = self.empty_nsprefix_ + ':' if (UseCapturedNS_ and self.empty_nsprefix_) else ''
            empty_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='empty', pretty_print=pretty_print)
        for plusmn_ in self.plusmn:
            namespaceprefix_ = self.plusmn_nsprefix_ + ':' if (UseCapturedNS_ and self.plusmn_nsprefix_) else ''
            plusmn_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='plusmn', pretty_print=pretty_print)
        for times_ in self.times:
            namespaceprefix_ = self.times_nsprefix_ + ':' if (UseCapturedNS_ and self.times_nsprefix_) else ''
            times_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='times', pretty_print=pretty_print)
        for minus_ in self.minus:
            namespaceprefix_ = self.minus_nsprefix_ + ':' if (UseCapturedNS_ and self.minus_nsprefix_) else ''
            minus_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='minus', pretty_print=pretty_print)
        for sdot_ in self.sdot:
            namespaceprefix_ = self.sdot_nsprefix_ + ':' if (UseCapturedNS_ and self.sdot_nsprefix_) else ''
            sdot_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sdot', pretty_print=pretty_print)
        for part_ in self.part:
            namespaceprefix_ = self.part_nsprefix_ + ':' if (UseCapturedNS_ and self.part_nsprefix_) else ''
            part_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='part', pretty_print=pretty_print)
        for nabla_ in self.nabla:
            namespaceprefix_ = self.nabla_nsprefix_ + ':' if (UseCapturedNS_ and self.nabla_nsprefix_) else ''
            nabla_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='nabla', pretty_print=pretty_print)
        for radic_ in self.radic:
            namespaceprefix_ = self.radic_nsprefix_ + ':' if (UseCapturedNS_ and self.radic_nsprefix_) else ''
            radic_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='radic', pretty_print=pretty_print)
        for perp_ in self.perp:
            namespaceprefix_ = self.perp_nsprefix_ + ':' if (UseCapturedNS_ and self.perp_nsprefix_) else ''
            perp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='perp', pretty_print=pretty_print)
        for sum_ in self.sum:
            namespaceprefix_ = self.sum_nsprefix_ + ':' if (UseCapturedNS_ and self.sum_nsprefix_) else ''
            sum_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sum', pretty_print=pretty_print)
        for int_ in self.int:
            namespaceprefix_ = self.int_nsprefix_ + ':' if (UseCapturedNS_ and self.int_nsprefix_) else ''
            int_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='int', pretty_print=pretty_print)
        for prod_ in self.prod:
            namespaceprefix_ = self.prod_nsprefix_ + ':' if (UseCapturedNS_ and self.prod_nsprefix_) else ''
            prod_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prod', pretty_print=pretty_print)
        for sim_ in self.sim:
            namespaceprefix_ = self.sim_nsprefix_ + ':' if (UseCapturedNS_ and self.sim_nsprefix_) else ''
            sim_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sim', pretty_print=pretty_print)
        for asymp_ in self.asymp:
            namespaceprefix_ = self.asymp_nsprefix_ + ':' if (UseCapturedNS_ and self.asymp_nsprefix_) else ''
            asymp_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='asymp', pretty_print=pretty_print)
        for ne_ in self.ne:
            namespaceprefix_ = self.ne_nsprefix_ + ':' if (UseCapturedNS_ and self.ne_nsprefix_) else ''
            ne_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ne', pretty_print=pretty_print)
        for equiv_ in self.equiv:
            namespaceprefix_ = self.equiv_nsprefix_ + ':' if (UseCapturedNS_ and self.equiv_nsprefix_) else ''
            equiv_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='equiv', pretty_print=pretty_print)
        for prop_ in self.prop:
            namespaceprefix_ = self.prop_nsprefix_ + ':' if (UseCapturedNS_ and self.prop_nsprefix_) else ''
            prop_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prop', pretty_print=pretty_print)
        for le_ in self.le:
            namespaceprefix_ = self.le_nsprefix_ + ':' if (UseCapturedNS_ and self.le_nsprefix_) else ''
            le_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='le', pretty_print=pretty_print)
        for ge_ in self.ge:
            namespaceprefix_ = self.ge_nsprefix_ + ':' if (UseCapturedNS_ and self.ge_nsprefix_) else ''
            ge_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ge', pretty_print=pretty_print)
        for larr_ in self.larr:
            namespaceprefix_ = self.larr_nsprefix_ + ':' if (UseCapturedNS_ and self.larr_nsprefix_) else ''
            larr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='larr', pretty_print=pretty_print)
        for rarr_ in self.rarr:
            namespaceprefix_ = self.rarr_nsprefix_ + ':' if (UseCapturedNS_ and self.rarr_nsprefix_) else ''
            rarr_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rarr', pretty_print=pretty_print)
        for isin_ in self.isin:
            namespaceprefix_ = self.isin_nsprefix_ + ':' if (UseCapturedNS_ and self.isin_nsprefix_) else ''
            isin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='isin', pretty_print=pretty_print)
        for notin_ in self.notin:
            namespaceprefix_ = self.notin_nsprefix_ + ':' if (UseCapturedNS_ and self.notin_nsprefix_) else ''
            notin_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='notin', pretty_print=pretty_print)
        for lceil_ in self.lceil:
            namespaceprefix_ = self.lceil_nsprefix_ + ':' if (UseCapturedNS_ and self.lceil_nsprefix_) else ''
            lceil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lceil', pretty_print=pretty_print)
        for rceil_ in self.rceil:
            namespaceprefix_ = self.rceil_nsprefix_ + ':' if (UseCapturedNS_ and self.rceil_nsprefix_) else ''
            rceil_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rceil', pretty_print=pretty_print)
        for lfloor_ in self.lfloor:
            namespaceprefix_ = self.lfloor_nsprefix_ + ':' if (UseCapturedNS_ and self.lfloor_nsprefix_) else ''
            lfloor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lfloor', pretty_print=pretty_print)
        for rfloor_ in self.rfloor:
            namespaceprefix_ = self.rfloor_nsprefix_ + ':' if (UseCapturedNS_ and self.rfloor_nsprefix_) else ''
            rfloor_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rfloor', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('url', node)
        if value is not None and 'url' not in already_processed:
            already_processed.add('url')
            self.url = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ulink':
            obj_ = docURLLink.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ulink', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ulink'):
              self.add_ulink(obj_.value)
            elif hasattr(self, 'set_ulink'):
              self.set_ulink(obj_.value)
        elif nodeName_ == 'bold':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'bold', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_bold'):
              self.add_bold(obj_.value)
            elif hasattr(self, 'set_bold'):
              self.set_bold(obj_.value)
        elif nodeName_ == 'emphasis':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'emphasis', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_emphasis'):
              self.add_emphasis(obj_.value)
            elif hasattr(self, 'set_emphasis'):
              self.set_emphasis(obj_.value)
        elif nodeName_ == 'computeroutput':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'computeroutput', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_computeroutput'):
              self.add_computeroutput(obj_.value)
            elif hasattr(self, 'set_computeroutput'):
              self.set_computeroutput(obj_.value)
        elif nodeName_ == 'subscript':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'subscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_subscript'):
              self.add_subscript(obj_.value)
            elif hasattr(self, 'set_subscript'):
              self.set_subscript(obj_.value)
        elif nodeName_ == 'superscript':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'superscript', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_superscript'):
              self.add_superscript(obj_.value)
            elif hasattr(self, 'set_superscript'):
              self.set_superscript(obj_.value)
        elif nodeName_ == 'center':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'center', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_center'):
              self.add_center(obj_.value)
            elif hasattr(self, 'set_center'):
              self.set_center(obj_.value)
        elif nodeName_ == 'small':
            obj_ = docMarkupType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'small', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_small'):
              self.add_small(obj_.value)
            elif hasattr(self, 'set_small'):
              self.set_small(obj_.value)
        elif nodeName_ == 'htmlonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'htmlonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'htmlonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'htmlonly', valuestr_)
            self.content_.append(obj_)
            self.htmlonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'manonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'manonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'manonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'manonly', valuestr_)
            self.content_.append(obj_)
            self.manonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'xmlonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'xmlonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'xmlonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'xmlonly', valuestr_)
            self.content_.append(obj_)
            self.xmlonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'rtfonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'rtfonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'rtfonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'rtfonly', valuestr_)
            self.content_.append(obj_)
            self.rtfonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'latexonly' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'latexonly')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'latexonly')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'latexonly', valuestr_)
            self.content_.append(obj_)
            self.latexonly_nsprefix_ = child_.prefix
        elif nodeName_ == 'dot' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'dot')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'dot')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'dot', valuestr_)
            self.content_.append(obj_)
            self.dot_nsprefix_ = child_.prefix
        elif nodeName_ == 'msc' and child_.text is not None:
            valuestr_ = child_.text
            valuestr_ = self.gds_parse_string(valuestr_, node, 'msc')
            valuestr_ = self.gds_validate_string(valuestr_, node, 'msc')
            obj_ = self.mixedclass_(MixedContainer.CategorySimple,
                MixedContainer.TypeString, 'msc', valuestr_)
            self.content_.append(obj_)
            self.msc_nsprefix_ = child_.prefix
        elif nodeName_ == 'anchor':
            obj_ = docAnchorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'anchor', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_anchor'):
              self.add_anchor(obj_.value)
            elif hasattr(self, 'set_anchor'):
              self.set_anchor(obj_.value)
        elif nodeName_ == 'formula':
            obj_ = docFormulaType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'formula', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_formula'):
              self.add_formula(obj_.value)
            elif hasattr(self, 'set_formula'):
              self.set_formula(obj_.value)
        elif nodeName_ == 'ref':
            obj_ = docRefTextType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ref', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ref'):
              self.add_ref(obj_.value)
            elif hasattr(self, 'set_ref'):
              self.set_ref(obj_.value)
        elif nodeName_ == 'copy':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'copy', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_copy'):
              self.add_copy(obj_.value)
            elif hasattr(self, 'set_copy'):
              self.set_copy(obj_.value)
        elif nodeName_ == 'trademark':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'trademark', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_trademark'):
              self.add_trademark(obj_.value)
            elif hasattr(self, 'set_trademark'):
              self.set_trademark(obj_.value)
        elif nodeName_ == 'registered':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'registered', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_registered'):
              self.add_registered(obj_.value)
            elif hasattr(self, 'set_registered'):
              self.set_registered(obj_.value)
        elif nodeName_ == 'lsquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'lsquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_lsquo'):
              self.add_lsquo(obj_.value)
            elif hasattr(self, 'set_lsquo'):
              self.set_lsquo(obj_.value)
        elif nodeName_ == 'rsquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rsquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rsquo'):
              self.add_rsquo(obj_.value)
            elif hasattr(self, 'set_rsquo'):
              self.set_rsquo(obj_.value)
        elif nodeName_ == 'ldquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ldquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ldquo'):
              self.add_ldquo(obj_.value)
            elif hasattr(self, 'set_ldquo'):
              self.set_ldquo(obj_.value)
        elif nodeName_ == 'rdquo':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'rdquo', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_rdquo'):
              self.add_rdquo(obj_.value)
            elif hasattr(self, 'set_rdquo'):
              self.set_rdquo(obj_.value)
        elif nodeName_ == 'ndash':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ndash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ndash'):
              self.add_ndash(obj_.value)
            elif hasattr(self, 'set_ndash'):
              self.set_ndash(obj_.value)
        elif nodeName_ == 'mdash':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'mdash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_mdash'):
              self.add_mdash(obj_.value)
            elif hasattr(self, 'set_mdash'):
              self.set_mdash(obj_.value)
        elif nodeName_ == 'umlaut':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'umlaut', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_umlaut'):
              self.add_umlaut(obj_.value)
            elif hasattr(self, 'set_umlaut'):
              self.set_umlaut(obj_.value)
        elif nodeName_ == 'acute':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'acute', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_acute'):
              self.add_acute(obj_.value)
            elif hasattr(self, 'set_acute'):
              self.set_acute(obj_.value)
        elif nodeName_ == 'grave':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'grave', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_grave'):
              self.add_grave(obj_.value)
            elif hasattr(self, 'set_grave'):
              self.set_grave(obj_.value)
        elif nodeName_ == 'circ':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'circ', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_circ'):
              self.add_circ(obj_.value)
            elif hasattr(self, 'set_circ'):
              self.set_circ(obj_.value)
        elif nodeName_ == 'slash':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'slash', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_slash'):
              self.add_slash(obj_.value)
            elif hasattr(self, 'set_slash'):
              self.set_slash(obj_.value)
        elif nodeName_ == 'tilde':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'tilde', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_tilde'):
              self.add_tilde(obj_.value)
            elif hasattr(self, 'set_tilde'):
              self.set_tilde(obj_.value)
        elif nodeName_ == 'cedil':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'cedil', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_cedil'):
              self.add_cedil(obj_.value)
            elif hasattr(self, 'set_cedil'):
              self.set_cedil(obj_.value)
        elif nodeName_ == 'ring':
            obj_ = docCharType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'ring', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_ring'):
              self.add_ring(obj_.value)
            elif hasattr(self, 'set_ring'):
              self.set_ring(obj_.value)
        elif nodeName_ == 'szlig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'szlig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_szlig'):
              self.add_szlig(obj_.value)
            elif hasattr(self, 'set_szlig'):
              self.set_szlig(obj_.value)
        elif nodeName_ == 'nonbreakablespace':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'nonbreakablespace', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_nonbreakablespace'):
              self.add_nonbreakablespace(obj_.value)
            elif hasattr(self, 'set_nonbreakablespace'):
              self.set_nonbreakablespace(obj_.value)
        elif nodeName_ == 'aelig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'aelig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_aelig'):
              self.add_aelig(obj_.value)
            elif hasattr(self, 'set_aelig'):
              self.set_aelig(obj_.value)
        elif nodeName_ == 'AElig':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'AElig', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_AElig'):
              self.add_AElig(obj_.value)
            elif hasattr(self, 'set_AElig'):
              self.set_AElig(obj_.value)
        elif nodeName_ == 'Gamma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Gamma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Gamma'):
              self.add_Gamma(obj_.value)
            elif hasattr(self, 'set_Gamma'):
              self.set_Gamma(obj_.value)
        elif nodeName_ == 'Delta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Delta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Delta'):
              self.add_Delta(obj_.value)
            elif hasattr(self, 'set_Delta'):
              self.set_Delta(obj_.value)
        elif nodeName_ == 'Theta':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Theta', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Theta'):
              self.add_Theta(obj_.value)
            elif hasattr(self, 'set_Theta'):
              self.set_Theta(obj_.value)
        elif nodeName_ == 'Lambda':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Lambda', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Lambda'):
              self.add_Lambda(obj_.value)
            elif hasattr(self, 'set_Lambda'):
              self.set_Lambda(obj_.value)
        elif nodeName_ == 'Xi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Xi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Xi'):
              self.add_Xi(obj_.value)
            elif hasattr(self, 'set_Xi'):
              self.set_Xi(obj_.value)
        elif nodeName_ == 'Pi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Pi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Pi'):
              self.add_Pi(obj_.value)
            elif hasattr(self, 'set_Pi'):
              self.set_Pi(obj_.value)
        elif nodeName_ == 'Sigma':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Sigma', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Sigma'):
              self.add_Sigma(obj_.value)
            elif hasattr(self, 'set_Sigma'):
              self.set_Sigma(obj_.value)
        elif nodeName_ == 'Upsilon':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Upsilon', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Upsilon'):
              self.add_Upsilon(obj_.value)
            elif hasattr(self, 'set_Upsilon'):
              self.set_Upsilon(obj_.value)
        elif nodeName_ == 'Phi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Phi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Phi'):
              self.add_Phi(obj_.value)
            elif hasattr(self, 'set_Phi'):
              self.set_Phi(obj_.value)
        elif nodeName_ == 'Psi':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Psi', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Psi'):
              self.add_Psi(obj_.value)
            elif hasattr(self, 'set_Psi'):
              self.set_Psi(obj_.value)
        elif nodeName_ == 'Omega':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'Omega', obj_)
            self.content_.append(obj_)
            if hasattr(self, 'add_Omega'):
              self.add_Omega(obj_.value)
            elif hasattr(self, 'set_Omega'):
              self.set_Omega(obj_.value)
        elif nodeName_ == 'alpha':
            obj_ = docEmptyType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            obj_ = self.mixedclass_(MixedContainer.CategoryComplex,
                MixedContainer.TypeNone, 'alpha', obj_)
  