#!/bin/bash

function install {
  # create service directory
  mkdir -p /srv/epaath

  # create yml(s)
  {
    echo "version: '3'"
    echo "services:"
    echo "  epaath:"
    echo "    image: olenepal/epaath:arm"
    echo "    ports:"
    echo "      - 8100:80"
  } > /srv/epaath/epaath.yml

  # add autorun
  {
    echo "epaath_autorun=true"
    echo
    echo "if [ \"\$_autorun\" = true ]; then"
    echo "  treehouses services epaath up"
    echo "fi"
    echo
    echo
  } > /srv/epaath/autorun
}

# environment var
function uses_env {
  echo false
}

# add supported arch(es)
function supported_arches {
  echo "armv7l"
}

# add port(s)
function get_ports {
  echo "8100"
}

# add size (in MB)
function get_size {
  echo "5555"
}

# add description
function get_description {
  echo "E-Paath is a collection of digital interactive learning activities for grade 1 - 8. \"epaath\" "
}

# add info
function get_info {
  echo
  echo "E-Paath is a collection of digital interactive learning activities for grade 1 - 8"
}

# add svg icon
function get_icon {
  cat <<EOF
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 331 331" style="enable-background:new 0 0 331 331" xml:space="preserve">
  <path d="M216.05 2.88c3.84-3.84 10.07-3.84 13.91 0s3.84 10.07 0 13.91l-.01.01-.03-.03c-14.46 14.46-22.63 32.4-24.15 49.69-1.16 13.19 1.6 25.97 8.44 36.36l25.13-25.13c-5.9-11.72-3.95-26.38 5.83-36.17 12.22-12.22 32.03-12.22 44.25 0 12.22 12.22 12.22 32.03 0 44.24-9.79 9.78-24.44 11.73-36.17 5.83l-25.13 25.13c10.4 6.85 23.18 9.6 36.37 8.44 17.29-1.52 35.23-9.69 49.68-24.15l-.03-.03.01-.01c3.84-3.84 10.07-3.84 13.91 0s3.84 10.07 0 13.91l-.01.01-.03-.03c-17.85 17.84-40.16 27.95-61.8 29.85-22.27 1.96-43.91-4.68-59.62-20.39l-.03.03-.01-.01.03-.03C190.9 108.63 184.26 87 186.21 64.72c1.9-21.64 12.01-43.96 29.86-61.81l-.02-.03z" style="fill:#da282d"/>
  <path d="M328.12 216.05c3.84 3.84 3.84 10.07 0 13.91s-10.07 3.84-13.91 0l-.01-.01.03-.03c-14.46-14.46-32.4-22.63-49.69-24.15-13.19-1.16-25.97 1.6-36.37 8.44l25.13 25.13c11.72-5.89 26.38-3.95 36.17 5.83 12.22 12.22 12.22 32.03 0 44.24-12.22 12.22-32.03 12.22-44.24 0-9.78-9.79-11.73-24.44-5.83-36.17l-25.13-25.13c-6.85 10.4-9.6 23.18-8.45 36.37 1.52 17.3 9.69 35.23 24.15 49.68l.03-.03.02.01c3.84 3.84 3.84 10.07 0 13.91s-10.07 3.84-13.91 0l-.01-.01.03-.03c-17.85-17.85-27.95-40.16-29.85-61.8-1.96-22.27 4.68-43.91 20.39-59.62l-.03-.03.01-.01.03.03c15.71-15.71 37.35-22.35 59.62-20.39 21.64 1.9 43.96 12.01 61.81 29.86h.01z" style="fill:#0094d9"/>
  <path d="M114.95 328.12c-3.84 3.84-10.07 3.84-13.91 0s-3.84-10.07 0-13.91l.03.03c14.46-14.46 22.63-32.4 24.15-49.69 1.16-13.19-1.6-25.97-8.44-36.36L91.65 253.3c5.89 11.72 3.95 26.38-5.84 36.17-12.21 12.22-32.03 12.22-44.24 0s-12.21-32.03 0-44.25c9.79-9.78 24.44-11.73 36.17-5.83l25.13-25.13c-10.4-6.85-23.18-9.6-36.37-8.44-17.29 1.52-35.22 9.69-49.68 24.15l.03.03-.01.01c-3.84 3.84-10.07 3.84-13.91 0s-3.84-10.07 0-13.91l.01-.01.03.03c17.85-17.85 40.16-27.95 61.8-29.85 22.27-1.96 43.91 4.68 59.62 20.39l.03-.03v.01l-.03.03c15.71 15.71 22.35 37.35 20.39 59.62-1.9 21.64-12.01 43.96-29.86 61.81l.03.02z" style="fill:#00a551"/>
  <path d="M2.88 114.95c-3.84-3.84-3.84-10.07 0-13.91s10.07-3.84 13.91 0h.01l-.03.03c14.46 14.46 32.4 22.63 49.69 24.15 13.19 1.16 25.97-1.6 36.36-8.44L77.7 91.65c-11.72 5.89-26.38 3.95-36.17-5.84-12.22-12.21-12.22-32.03 0-44.24s32.03-12.21 44.24 0c9.78 9.79 11.73 24.44 5.83 36.17l25.13 25.13c6.85-10.4 9.6-23.18 8.44-36.37-1.52-17.29-9.69-35.22-24.15-49.68l-.03.03.01-.02c-3.84-3.84-3.84-10.07 0-13.91s10.07-3.84 13.91 0l.02.01-.03.03c17.84 17.85 27.95 40.16 29.85 61.8 1.96 22.27-4.68 43.91-20.39 59.62l.03.03h-.01v.01l-.03-.03c-15.71 15.71-37.34 22.35-59.62 20.39-21.64-1.9-43.96-12.01-61.81-29.86l-.04.03z" style="fill:#f7bf21"/>
  <path d="M184.48 167.61v-29.26h-5.4V134h27.81v4.35h-12.13v52.72c0 1.23.2 2.33.59 3.29.4.97.99 1.84 1.78 2.63 1.84 1.85 4 2.77 6.46 2.77h-27.02c2.37-.26 4.28-1.27 5.73-3.03 1.45-1.76 2.18-3.65 2.18-5.67v-18.71h-4.75c0 7.56-2.06 13.88-6.19 18.98-4.57 5.62-10.59 8.44-18.06 8.44-11.07 0-19.46-4.39-25.17-13.18-4.13-6.33-6.19-13-6.19-20.03v-2.63l10.81-2.63c-.09.35-.16.81-.2 1.38-.05.57-.07 1.34-.07 2.31 0 7.64 1.1 14.1 3.29 19.37 3.52 8.35 9.36 12.52 17.53 12.52 4.65 0 8.26-2.33 10.81-6.99 2.11-3.87 3.16-8.65 3.16-14.37 0-4.92-1.14-8.76-3.43-11.53-2.29-2.77-5.97-4.37-11.07-4.81-2.99 0-5.71.7-8.17 2.11v-6.33c1.32.62 2.57 1.03 3.76 1.25 1.19.22 2.66.33 4.41.33 3.51 0 6.63-1.14 9.36-3.43 2.73-2.29 4.09-5.01 4.09-8.17 0-2.9-1.08-5.25-3.23-7.05-2.15-1.8-4.86-2.7-8.1-2.7-3.43 0-6.61 1.3-9.56 3.89-2.94 2.59-4.41 5.34-4.41 8.24l-7.12-5.8c1.93-2.81 4.61-5.14 8.04-6.98 4.04-2.2 8.39-3.3 13.05-3.3 5.18 0 9.84 1.36 13.97 4.09 4.75 3.08 7.12 7.07 7.12 11.99 0 2.46-.59 4.59-1.78 6.39-1.19 1.8-2.88 3.45-5.07 4.94.62.44 1.27.83 1.98 1.19 1.23.79 2.15 1.89 2.77 3.29.17.35.57 1.03 1.19 2.04.61 1.01 1.05 1.82 1.32 2.44h5.91z" style="fill-rule:evenodd;clip-rule:evenodd;fill:#231f20"/>
</svg>
EOF
}
