"""Constants for AccuWeather integration."""
from __future__ import annotations

from typing import Final

from homeassistant.components.sensor import SensorDeviceClass, SensorStateClass
from homeassistant.components.weather import (
    ATTR_CONDITION_CLEAR_NIGHT,
    ATTR_CONDITION_CLOUDY,
    ATTR_CONDITION_EXCEPTIONAL,
    ATTR_CONDITION_FOG,
    ATTR_CONDITION_HAIL,
    ATTR_CONDITION_LIGHTNING,
    ATTR_CONDITION_LIGHTNING_RAINY,
    ATTR_CONDITION_PARTLYCLOUDY,
    ATTR_CONDITION_POURING,
    ATTR_CONDITION_RAINY,
    ATTR_CONDITION_SNOWY,
    ATTR_CONDITION_SNOWY_RAINY,
    ATTR_CONDITION_SUNNY,
    ATTR_CONDITION_WINDY,
)
from homeassistant.const import (
    CONCENTRATION_PARTS_PER_CUBIC_METER,
    LENGTH_FEET,
    LENGTH_INCHES,
    LENGTH_METERS,
    LENGTH_MILLIMETERS,
    PERCENTAGE,
    SPEED_KILOMETERS_PER_HOUR,
    SPEED_MILES_PER_HOUR,
    TEMP_CELSIUS,
    TEMP_FAHRENHEIT,
    TIME_HOURS,
    UV_INDEX,
)

from .model import AccuWeatherSensorDescription

API_IMPERIAL: Final = "Imperial"
API_METRIC: Final = "Metric"
ATTRIBUTION: Final = "Data provided by AccuWeather"
ATTR_FORECAST: Final = "forecast"
CONF_FORECAST: Final = "forecast"
DOMAIN: Final = "accuweather"
MANUFACTURER: Final = "AccuWeather, Inc."
MAX_FORECAST_DAYS: Final = 4
NAME: Final = "AccuWeather"

CONDITION_CLASSES: Final[dict[str, list[int]]] = {
    ATTR_CONDITION_CLEAR_NIGHT: [33, 34, 37],
    ATTR_CONDITION_CLOUDY: [7, 8, 38],
    ATTR_CONDITION_EXCEPTIONAL: [24, 30, 31],
    ATTR_CONDITION_FOG: [11],
    ATTR_CONDITION_HAIL: [25],
    ATTR_CONDITION_LIGHTNING: [15],
    ATTR_CONDITION_LIGHTNING_RAINY: [16, 17, 41, 42],
    ATTR_CONDITION_PARTLYCLOUDY: [3, 4, 6, 35, 36],
    ATTR_CONDITION_POURING: [18],
    ATTR_CONDITION_RAINY: [12, 13, 14, 26, 39, 40],
    ATTR_CONDITION_SNOWY: [19, 20, 21, 22, 23, 43, 44],
    ATTR_CONDITION_SNOWY_RAINY: [29],
    ATTR_CONDITION_SUNNY: [1, 2, 5],
    ATTR_CONDITION_WINDY: [32],
}

FORECAST_SENSOR_TYPES: Final[tuple[AccuWeatherSensorDescription, ...]] = (
    AccuWeatherSensorDescription(
        key="CloudCoverDay",
        icon="mdi:weather-cloudy",
        name="Cloud Cover Day",
        unit_metric=PERCENTAGE,
        unit_imperial=PERCENTAGE,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="CloudCoverNight",
        icon="mdi:weather-cloudy",
        name="Cloud Cover Night",
        unit_metric=PERCENTAGE,
        unit_imperial=PERCENTAGE,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="Grass",
        icon="mdi:grass",
        name="Grass Pollen",
        unit_metric=CONCENTRATION_PARTS_PER_CUBIC_METER,
        unit_imperial=CONCENTRATION_PARTS_PER_CUBIC_METER,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="HoursOfSun",
        icon="mdi:weather-partly-cloudy",
        name="Hours Of Sun",
        unit_metric=TIME_HOURS,
        unit_imperial=TIME_HOURS,
    ),
    AccuWeatherSensorDescription(
        key="Mold",
        icon="mdi:blur",
        name="Mold Pollen",
        unit_metric=CONCENTRATION_PARTS_PER_CUBIC_METER,
        unit_imperial=CONCENTRATION_PARTS_PER_CUBIC_METER,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="Ozone",
        icon="mdi:vector-triangle",
        name="Ozone",
        unit_metric=None,
        unit_imperial=None,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="Ragweed",
        icon="mdi:sprout",
        name="Ragweed Pollen",
        unit_metric=CONCENTRATION_PARTS_PER_CUBIC_METER,
        unit_imperial=CONCENTRATION_PARTS_PER_CUBIC_METER,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="RealFeelTemperatureMax",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="RealFeel Temperature Max",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
    ),
    AccuWeatherSensorDescription(
        key="RealFeelTemperatureMin",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="RealFeel Temperature Min",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
    ),
    AccuWeatherSensorDescription(
        key="RealFeelTemperatureShadeMax",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="RealFeel Temperature Shade Max",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="RealFeelTemperatureShadeMin",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="RealFeel Temperature Shade Min",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="ThunderstormProbabilityDay",
        icon="mdi:weather-lightning",
        name="Thunderstorm Probability Day",
        unit_metric=PERCENTAGE,
        unit_imperial=PERCENTAGE,
    ),
    AccuWeatherSensorDescription(
        key="ThunderstormProbabilityNight",
        icon="mdi:weather-lightning",
        name="Thunderstorm Probability Night",
        unit_metric=PERCENTAGE,
        unit_imperial=PERCENTAGE,
    ),
    AccuWeatherSensorDescription(
        key="Tree",
        icon="mdi:tree-outline",
        name="Tree Pollen",
        unit_metric=CONCENTRATION_PARTS_PER_CUBIC_METER,
        unit_imperial=CONCENTRATION_PARTS_PER_CUBIC_METER,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="UVIndex",
        icon="mdi:weather-sunny",
        name="UV Index",
        unit_metric=UV_INDEX,
        unit_imperial=UV_INDEX,
    ),
    AccuWeatherSensorDescription(
        key="WindGustDay",
        icon="mdi:weather-windy",
        name="Wind Gust Day",
        unit_metric=SPEED_KILOMETERS_PER_HOUR,
        unit_imperial=SPEED_MILES_PER_HOUR,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="WindGustNight",
        icon="mdi:weather-windy",
        name="Wind Gust Night",
        unit_metric=SPEED_KILOMETERS_PER_HOUR,
        unit_imperial=SPEED_MILES_PER_HOUR,
        entity_registry_enabled_default=False,
    ),
    AccuWeatherSensorDescription(
        key="WindDay",
        icon="mdi:weather-windy",
        name="Wind Day",
        unit_metric=SPEED_KILOMETERS_PER_HOUR,
        unit_imperial=SPEED_MILES_PER_HOUR,
    ),
    AccuWeatherSensorDescription(
        key="WindNight",
        icon="mdi:weather-windy",
        name="Wind Night",
        unit_metric=SPEED_KILOMETERS_PER_HOUR,
        unit_imperial=SPEED_MILES_PER_HOUR,
    ),
)

SENSOR_TYPES: Final[tuple[AccuWeatherSensorDescription, ...]] = (
    AccuWeatherSensorDescription(
        key="ApparentTemperature",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="Apparent Temperature",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
        entity_registry_enabled_default=False,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="Ceiling",
        icon="mdi:weather-fog",
        name="Cloud Ceiling",
        unit_metric=LENGTH_METERS,
        unit_imperial=LENGTH_FEET,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="CloudCover",
        icon="mdi:weather-cloudy",
        name="Cloud Cover",
        unit_metric=PERCENTAGE,
        unit_imperial=PERCENTAGE,
        entity_registry_enabled_default=False,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="DewPoint",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="Dew Point",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
        entity_registry_enabled_default=False,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="RealFeelTemperature",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="RealFeel Temperature",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="RealFeelTemperatureShade",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="RealFeel Temperature Shade",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
        entity_registry_enabled_default=False,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="Precipitation",
        icon="mdi:weather-rainy",
        name="Precipitation",
        unit_metric=LENGTH_MILLIMETERS,
        unit_imperial=LENGTH_INCHES,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="PressureTendency",
        device_class="accuweather__pressure_tendency",
        icon="mdi:gauge",
        name="Pressure Tendency",
        unit_metric=None,
        unit_imperial=None,
    ),
    AccuWeatherSensorDescription(
        key="UVIndex",
        icon="mdi:weather-sunny",
        name="UV Index",
        unit_metric=UV_INDEX,
        unit_imperial=UV_INDEX,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="WetBulbTemperature",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="Wet Bulb Temperature",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
        entity_registry_enabled_default=False,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="WindChillTemperature",
        device_class=SensorDeviceClass.TEMPERATURE,
        name="Wind Chill Temperature",
        unit_metric=TEMP_CELSIUS,
        unit_imperial=TEMP_FAHRENHEIT,
        entity_registry_enabled_default=False,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="Wind",
        icon="mdi:weather-windy",
        name="Wind",
        unit_metric=SPEED_KILOMETERS_PER_HOUR,
        unit_imperial=SPEED_MILES_PER_HOUR,
        state_class=SensorStateClass.MEASUREMENT,
    ),
    AccuWeatherSensorDescription(
        key="WindGust",
        icon="mdi:weather-windy",
        name="Wind Gust",
        unit_metric=SPEED_KILOMETERS_PER_HOUR,
        unit_imperial=SPEED_MILES_PER_HOUR,
        entity_registry_enabled_default=False,
        state_class=SensorStateClass.MEASUREMENT,
    ),
)
