"""Test RainMachine diagnostics."""
from homeassistant.components.diagnostics import REDACTED

from tests.components.diagnostics import get_diagnostics_for_config_entry


async def test_entry_diagnostics(hass, config_entry, hass_client, setup_rainmachine):
    """Test config entry diagnostics."""
    assert await get_diagnostics_for_config_entry(hass, hass_client, config_entry) == {
        "entry": {
            "title": "Mock Title",
            "data": {
                "ip_address": "192.168.1.100",
                "password": REDACTED,
                "port": 8080,
                "ssl": True,
            },
            "options": {},
        },
        "data": {
            "coordinator": {
                "programs": [
                    {
                        "uid": 1,
                        "name": "Morning",
                        "active": True,
                        "startTime": "06:00",
                        "cycles": 0,
                        "soak": 0,
                        "cs_on": False,
                        "delay": 0,
                        "delay_on": False,
                        "status": 0,
                        "startTimeParams": {
                            "offsetSign": 0,
                            "type": 0,
                            "offsetMinutes": 0,
                        },
                        "frequency": {"type": 0, "param": "0"},
                        "coef": 0,
                        "ignoreInternetWeather": False,
                        "futureField1": 0,
                        "freq_modified": 0,
                        "useWaterSense": False,
                        "nextRun": "2018-06-04",
                        "startDate": "2018-04-28",
                        "endDate": None,
                        "yearlyRecurring": True,
                        "simulationExpired": False,
                        "wateringTimes": [
                            {
                                "id": 1,
                                "order": -1,
                                "name": "Landscaping",
                                "duration": 0,
                                "active": True,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 2,
                                "order": -1,
                                "name": "Flower Box",
                                "duration": 0,
                                "active": True,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 3,
                                "order": -1,
                                "name": "TEST",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 4,
                                "order": -1,
                                "name": "Zone 4",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 5,
                                "order": -1,
                                "name": "Zone 5",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 6,
                                "order": -1,
                                "name": "Zone 6",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 7,
                                "order": -1,
                                "name": "Zone 7",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 8,
                                "order": -1,
                                "name": "Zone 8",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 9,
                                "order": -1,
                                "name": "Zone 9",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 10,
                                "order": -1,
                                "name": "Zone 10",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 11,
                                "order": -1,
                                "name": "Zone 11",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 12,
                                "order": -1,
                                "name": "Zone 12",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                        ],
                    },
                    {
                        "uid": 2,
                        "name": "Evening",
                        "active": False,
                        "startTime": "06:00",
                        "cycles": 0,
                        "soak": 0,
                        "cs_on": False,
                        "delay": 0,
                        "delay_on": False,
                        "status": 0,
                        "startTimeParams": {
                            "offsetSign": 0,
                            "type": 0,
                            "offsetMinutes": 0,
                        },
                        "frequency": {"type": 0, "param": "0"},
                        "coef": 0,
                        "ignoreInternetWeather": False,
                        "futureField1": 0,
                        "freq_modified": 0,
                        "useWaterSense": False,
                        "nextRun": "2018-06-04",
                        "startDate": "2018-04-28",
                        "endDate": None,
                        "yearlyRecurring": True,
                        "simulationExpired": False,
                        "wateringTimes": [
                            {
                                "id": 1,
                                "order": -1,
                                "name": "Landscaping",
                                "duration": 0,
                                "active": True,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 2,
                                "order": -1,
                                "name": "Flower Box",
                                "duration": 0,
                                "active": True,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 3,
                                "order": -1,
                                "name": "TEST",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 4,
                                "order": -1,
                                "name": "Zone 4",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 5,
                                "order": -1,
                                "name": "Zone 5",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 6,
                                "order": -1,
                                "name": "Zone 6",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 7,
                                "order": -1,
                                "name": "Zone 7",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 8,
                                "order": -1,
                                "name": "Zone 8",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 9,
                                "order": -1,
                                "name": "Zone 9",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 10,
                                "order": -1,
                                "name": "Zone 10",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 11,
                                "order": -1,
                                "name": "Zone 11",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                            {
                                "id": 12,
                                "order": -1,
                                "name": "Zone 12",
                                "duration": 0,
                                "active": False,
                                "userPercentage": 1,
                                "minRuntimeCoef": 1,
                            },
                        ],
                    },
                ],
                "provision.settings": {
                    "system": {
                        "httpEnabled": True,
                        "rainSensorSnoozeDuration": 0,
                        "uiUnitsMetric": False,
                        "programZonesShowInactive": False,
                        "programSingleSchedule": False,
                        "standaloneMode": False,
                        "masterValveAfter": 0,
                        "touchSleepTimeout": 10,
                        "selfTest": False,
                        "useSoftwareRainSensor": False,
                        "defaultZoneWateringDuration": 300,
                        "maxLEDBrightness": 40,
                        "simulatorHistorySize": 0,
                        "vibration": False,
                        "masterValveBefore": 0,
                        "touchProgramToRun": None,
                        "useRainSensor": False,
                        "wizardHasRun": True,
                        "waterLogHistorySize": 365,
                        "netName": "Home",
                        "softwareRainSensorMinQPF": 5,
                        "touchAdvanced": False,
                        "useBonjourService": True,
                        "hardwareVersion": 3,
                        "touchLongPressTimeout": 3,
                        "showRestrictionsOnLed": False,
                        "parserDataSizeInDays": 6,
                        "programListShowInactive": True,
                        "parserHistorySize": 365,
                        "allowAlexaDiscovery": False,
                        "automaticUpdates": True,
                        "minLEDBrightness": 0,
                        "minWateringDurationThreshold": 0,
                        "localValveCount": 12,
                        "touchAuthAPSeconds": 60,
                        "useCommandLineArguments": False,
                        "databasePath": "/rainmachine-app/DB/Default",
                        "touchCyclePrograms": True,
                        "zoneListShowInactive": True,
                        "rainSensorRainStart": None,
                        "zoneDuration": [
                            300,
                            300,
                            300,
                            300,
                            300,
                            300,
                            300,
                            300,
                            300,
                            300,
                            300,
                            300,
                        ],
                        "rainSensorIsNormallyClosed": True,
                        "useCorrectionForPast": True,
                        "useMasterValve": False,
                        "runParsersBeforePrograms": True,
                        "maxWateringCoef": 2,
                        "mixerHistorySize": 365,
                    },
                    "location": {
                        "elevation": 1593.45141602,
                        "doyDownloaded": True,
                        "zip": None,
                        "windSensitivity": 0.5,
                        "krs": 0.16,
                        "stationID": 9172,
                        "stationSource": "station",
                        "et0Average": 6.578,
                        "latitude": REDACTED,
                        "state": "Default",
                        "stationName": "MY STATION",
                        "wsDays": 2,
                        "stationDownloaded": True,
                        "address": "Default",
                        "rainSensitivity": 0.8,
                        "timezone": "America/Los Angeles",
                        "longitude": REDACTED,
                        "name": "Home",
                    },
                },
                "restrictions.current": {
                    "hourly": False,
                    "freeze": False,
                    "month": False,
                    "weekDay": False,
                    "rainDelay": False,
                    "rainDelayCounter": -1,
                    "rainSensor": False,
                },
                "restrictions.universal": {
                    "hotDaysExtraWatering": False,
                    "freezeProtectEnabled": True,
                    "freezeProtectTemp": 2,
                    "noWaterInWeekDays": "0000000",
                    "noWaterInMonths": "000000000000",
                    "rainDelayStartTime": 1524854551,
                    "rainDelayDuration": 0,
                },
                "zones": [
                    {
                        "uid": 1,
                        "name": "Landscaping",
                        "state": 0,
                        "active": True,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 4,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 2,
                        "name": "Flower Box",
                        "state": 0,
                        "active": True,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 5,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 3,
                        "name": "TEST",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 9,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 4,
                        "name": "Zone 4",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 2,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 5,
                        "name": "Zone 5",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 2,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 6,
                        "name": "Zone 6",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 2,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 7,
                        "name": "Zone 7",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 2,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 8,
                        "name": "Zone 8",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 2,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 9,
                        "name": "Zone 9",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 2,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 10,
                        "name": "Zone 10",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 2,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 11,
                        "name": "Zone 11",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 2,
                        "master": False,
                        "waterSense": False,
                    },
                    {
                        "uid": 12,
                        "name": "Zone 12",
                        "state": 0,
                        "active": False,
                        "userDuration": 0,
                        "machineDuration": 0,
                        "remaining": 0,
                        "cycle": 0,
                        "noOfCycles": 0,
                        "restriction": False,
                        "type": 2,
                        "master": False,
                        "waterSense": False,
                    },
                ],
            },
            "controller": {
                "api_version": "4.5.0",
                "hardware_version": 3,
                "name": "My RainMachine",
                "software_version": "4.0.925",
            },
        },
    }
