/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.win32.OS;

class Relation {
    Accessible accessible;
    COMObject objIAccessibleRelation;
    int refCount;
    int type;
    Accessible[] targets;
    static final String[] relationTypeString = new String[]{"controlledBy", "controllerFor", "describedBy", "descriptionFor", "embeddedBy", "embeds", "flowsFrom", "flowsTo", "labelFor", "labelledBy", "memberOf", "nodeChildOf", "parentWindowOf", "popupFor", "subwindowOf"};
    static final String[] localizedRelationTypeString = new String[]{SWT.getMessage("SWT_Controlled_By"), SWT.getMessage("SWT_Controller_For"), SWT.getMessage("SWT_Described_By"), SWT.getMessage("SWT_Description_For"), SWT.getMessage("SWT_Embedded_By"), SWT.getMessage("SWT_Embeds"), SWT.getMessage("SWT_Flows_From"), SWT.getMessage("SWT_Flows_To"), SWT.getMessage("SWT_Label_For"), SWT.getMessage("SWT_Labelled_By"), SWT.getMessage("SWT_Member_Of"), SWT.getMessage("SWT_Node_Child_Of"), SWT.getMessage("SWT_Parent_Window_Of"), SWT.getMessage("SWT_Popup_For"), SWT.getMessage("SWT_Subwindow_Of")};

    Relation(Accessible accessible, int n) {
        this.accessible = accessible;
        this.type = n;
        this.targets = new Accessible[0];
        this.AddRef();
    }

    int getAddress() {
        if (this.objIAccessibleRelation == null) {
            this.createIAccessibleRelation();
        }
        return this.objIAccessibleRelation.getAddress();
    }

    void createIAccessibleRelation() {
        this.objIAccessibleRelation = new COMObject(new int[]{2, 0, 0, 1, 1, 1, 2, 3}){

            @Override
            public int method0(int[] nArray) {
                return Relation.this.QueryInterface(nArray[0], nArray[1]);
            }

            @Override
            public int method1(int[] nArray) {
                return Relation.this.AddRef();
            }

            @Override
            public int method2(int[] nArray) {
                return Relation.this.Release();
            }

            @Override
            public int method3(int[] nArray) {
                return Relation.this.get_relationType(nArray[0]);
            }

            @Override
            public int method4(int[] nArray) {
                return Relation.this.get_localizedRelationType(nArray[0]);
            }

            @Override
            public int method5(int[] nArray) {
                return Relation.this.get_nTargets(nArray[0]);
            }

            @Override
            public int method6(int[] nArray) {
                return Relation.this.get_target(nArray[0], nArray[1]);
            }

            @Override
            public int method7(int[] nArray) {
                return Relation.this.get_targets(nArray[0], nArray[1], nArray[2]);
            }
        };
    }

    int QueryInterface(int n, int n2) {
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIAccessibleRelation)) {
            COM.MoveMemory(n2, new int[]{this.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessibleRelation != null) {
                this.objIAccessibleRelation.dispose();
            }
            this.objIAccessibleRelation = null;
        }
        return this.refCount;
    }

    int get_relationType(int n) {
        this.setString(n, relationTypeString[this.type]);
        return 0;
    }

    int get_localizedRelationType(int n) {
        this.setString(n, localizedRelationTypeString[this.type]);
        return 0;
    }

    int get_nTargets(int n) {
        COM.MoveMemory(n, new int[]{this.targets.length}, 4);
        return 0;
    }

    int get_target(int n, int n2) {
        if (n < 0 || n >= this.targets.length) {
            return -2147024809;
        }
        Accessible accessible = this.targets[n];
        accessible.AddRef();
        COM.MoveMemory(n2, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_targets(int n, int n2, int n3) {
        int n4 = Math.min(this.targets.length, n);
        for (int i = 0; i < n4; ++i) {
            Accessible accessible = this.targets[i];
            accessible.AddRef();
            COM.MoveMemory(n2 + i * OS.PTR_SIZEOF, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        }
        COM.MoveMemory(n3, new int[]{n4}, 4);
        return 0;
    }

    void addTarget(Accessible accessible) {
        if (this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, accessibleArray, 0, this.targets.length);
        accessibleArray[this.targets.length] = accessible;
        this.targets = accessibleArray;
    }

    boolean containsTarget(Accessible accessible) {
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != accessible) continue;
            return true;
        }
        return false;
    }

    void removeTarget(Accessible accessible) {
        if (!this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length - 1];
        int n = 0;
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] == accessible) continue;
            accessibleArray[n++] = this.targets[i];
        }
        this.targets = accessibleArray;
    }

    boolean hasTargets() {
        return this.targets.length > 0;
    }

    void setString(int n, String string) {
        char[] cArray = (string + "\u0000").toCharArray();
        int n2 = COM.SysAllocString(cArray);
        COM.MoveMemory(n, new int[]{n2}, OS.PTR_SIZEOF);
    }
}

