/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.HDHITTESTINFO;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMLISTVIEW;
import org.eclipse.swt.internal.win32.NMLVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMLVDISPINFO;
import org.eclipse.swt.internal.win32.NMLVODSTATECHANGE;
import org.eclipse.swt.internal.win32.NMTTCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.SHDRAGIMAGE;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    TableItem[] items;
    int[] keys;
    TableColumn[] columns;
    int columnCount;
    int customCount;
    int keyCount;
    ImageList imageList;
    ImageList headerImageList;
    TableItem currentItem;
    TableColumn sortColumn;
    RECT focusRect;
    boolean[] columnVisible;
    long headerToolTipHandle;
    long hwndHeader;
    boolean ignoreCustomDraw;
    boolean ignoreDrawForeground;
    boolean ignoreDrawBackground;
    boolean ignoreDrawFocus;
    boolean ignoreDrawSelection;
    boolean ignoreDrawHot;
    boolean customDraw;
    boolean dragStarted;
    boolean explorerTheme;
    boolean firstColumnImage;
    boolean fixScrollWidth;
    boolean tipRequested;
    boolean wasSelected;
    boolean wasResized;
    boolean painted;
    boolean ignoreActivate;
    boolean ignoreSelect;
    boolean ignoreShrink;
    boolean ignoreResize;
    boolean ignoreColumnMove;
    boolean ignoreColumnResize;
    boolean fullRowSelect;
    boolean settingItemHeight;
    boolean headerItemDragging;
    int itemHeight;
    int lastIndexOf;
    int lastWidth;
    int sortDirection;
    int resizeCount;
    int selectionForeground;
    int hotIndex;
    int headerBackground = -1;
    int headerForeground = -1;
    static long HeaderProc;
    static final int INSET = 4;
    static final int GRID_WIDTH = 1;
    static final int SORT_WIDTH = 10;
    static final int HEADER_MARGIN = 12;
    static final int HEADER_EXTRA = 3;
    static final int VISTA_EXTRA = 2;
    static final int EXPLORER_EXTRA = 2;
    static final int H_SCROLL_LIMIT = 32;
    static final int V_SCROLL_LIMIT = 16;
    static final int DRAG_IMAGE_SIZE = 301;
    static boolean COMPRESS_ITEMS;
    static final long TableProc;
    static final TCHAR TableClass;
    static final TCHAR HeaderClass;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    @Override
    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        switch (eventType) {
            case 40: 
            case 41: 
            case 42: {
                this.setCustomDraw(true);
                this.setBackgroundTransparent(true);
            }
        }
    }

    boolean _checkGrow(int count) {
        if (this.keys == null) {
            if (count == this.items.length) {
                boolean small = this.getDrawing() && OS.IsWindowVisible(this.handle);
                int length = small ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
                TableItem[] newItems = new TableItem[length];
                System.arraycopy(this.items, 0, newItems, 0, this.items.length);
                this.items = newItems;
            }
        } else {
            if (!this.ignoreShrink && this.keyCount > count / 2) {
                boolean small = this.getDrawing() && OS.IsWindowVisible(this.handle);
                int length = small ? count + 4 : Math.max(4, count * 3 / 2);
                TableItem[] newItems = new TableItem[length];
                for (int i = 0; i < this.keyCount; ++i) {
                    newItems[this.keys[i]] = this.items[i];
                }
                this.items = newItems;
                this.keys = null;
                this.keyCount = 0;
                return true;
            }
            if (this.keyCount == this.keys.length) {
                boolean small = this.getDrawing() && OS.IsWindowVisible(this.handle);
                int length = small ? this.keys.length + 4 : Math.max(4, this.keys.length * 3 / 2);
                int[] newKeys = new int[length];
                System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
                this.keys = newKeys;
                TableItem[] newItems = new TableItem[length];
                System.arraycopy(this.items, 0, newItems, 0, this.items.length);
                this.items = newItems;
            }
        }
        return false;
    }

    void _checkShrink() {
        if (this.keys == null) {
            if (!this.ignoreShrink) {
                int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
                if (count == 0 && this.items.length > 4) {
                    while (count < this.items.length && this.items[count] != null && !this.items[count].isDisposed()) {
                        ++count;
                    }
                }
                if (this.items.length > 4 && this.items.length - count > 3) {
                    int length = Math.max(4, (count + 3) / 4 * 4);
                    TableItem[] newItems = new TableItem[length];
                    System.arraycopy(this.items, 0, newItems, 0, count);
                    this.items = newItems;
                }
            }
        } else if (!this.ignoreShrink && this.keys.length > 4 && this.keys.length - this.keyCount > 3) {
            int length = Math.max(4, (this.keyCount + 3) / 4 * 4);
            int[] newKeys = new int[length];
            System.arraycopy(this.keys, 0, newKeys, 0, this.keyCount);
            this.keys = newKeys;
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.keyCount);
            this.items = newItems;
        }
    }

    void _clearItems() {
        this.items = null;
        this.keys = null;
        this.keyCount = 0;
    }

    TableItem _getItem(int index) {
        return this._getItem(index, true);
    }

    TableItem _getItem(int index, boolean create) {
        return this._getItem(index, create, -1);
    }

    TableItem _getItem(int index, boolean create, int count) {
        if (this.keys == null) {
            if (index >= this.items.length) {
                return null;
            }
            if ((this.style & 0x10000000) == 0 || !create) {
                return this.items[index];
            }
            if (this.items[index] != null) {
                return this.items[index];
            }
            this.items[index] = new TableItem(this, 0, -1, false);
            return this.items[index];
        }
        if ((this.style & 0x10000000) == 0 || !create) {
            if (this.keyCount == 0) {
                return null;
            }
            if (index > this.keys[this.keyCount - 1]) {
                return null;
            }
        }
        int keyIndex = this.binarySearch(this.keys, 0, this.keyCount, index);
        if ((this.style & 0x10000000) == 0 || !create) {
            return keyIndex < 0 ? null : this.items[keyIndex];
        }
        if (keyIndex < 0) {
            if (count == -1) {
                count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            }
            if (this._checkGrow(count)) {
                if (this.items[index] != null) {
                    return this.items[index];
                }
                this.items[index] = new TableItem(this, 0, -1, false);
                return this.items[index];
            }
            if ((keyIndex = -keyIndex - 1) < this.keyCount) {
                System.arraycopy(this.keys, keyIndex, this.keys, keyIndex + 1, this.keyCount - keyIndex);
                System.arraycopy(this.items, keyIndex, this.items, keyIndex + 1, this.keyCount - keyIndex);
            }
            ++this.keyCount;
            this.keys[keyIndex] = index;
        } else if (this.items[keyIndex] != null) {
            return this.items[keyIndex];
        }
        this.items[keyIndex] = new TableItem(this, 0, -1, false);
        return this.items[keyIndex];
    }

    void _getItems(TableItem[] result, int count) {
        if (this.keys == null) {
            System.arraycopy(this.items, 0, result, 0, count);
        } else {
            for (int i = 0; i < this.keyCount && this.keys[i] < count; ++i) {
                result[this.keys[i]] = this.items[this.keys[i]];
            }
        }
    }

    boolean _hasItems() {
        return this.items != null;
    }

    void _initItems() {
        this.items = new TableItem[4];
        if (COMPRESS_ITEMS && (this.style & 0x10000000) != 0) {
            this.keyCount = 0;
            this.keys = new int[4];
        }
    }

    void _insertItem(int index, TableItem item, int count) {
        if (this.keys == null) {
            System.arraycopy(this.items, index, this.items, index + 1, count - index);
            this.items[index] = item;
        } else {
            int keyIndex = this.binarySearch(this.keys, 0, this.keyCount, index);
            if (keyIndex < 0) {
                keyIndex = -keyIndex - 1;
            }
            System.arraycopy(this.keys, keyIndex, this.keys, keyIndex + 1, this.keyCount - keyIndex);
            this.keys[keyIndex] = index;
            System.arraycopy(this.items, keyIndex, this.items, keyIndex + 1, this.keyCount - keyIndex);
            this.items[keyIndex] = item;
            ++this.keyCount;
            int i = keyIndex + 1;
            while (i < this.keyCount) {
                int n = i++;
                this.keys[n] = this.keys[n] + 1;
            }
        }
    }

    void _removeItem(int index, int count) {
        if (this.keys == null) {
            System.arraycopy(this.items, index + 1, this.items, index, --count - index);
            this.items[count] = null;
        } else {
            int keyIndex = this.binarySearch(this.keys, 0, this.keyCount, index);
            if (keyIndex < 0) {
                keyIndex = -keyIndex - 1;
            } else {
                --this.keyCount;
                System.arraycopy(this.keys, keyIndex + 1, this.keys, keyIndex, this.keyCount - keyIndex);
                this.keys[this.keyCount] = 0;
                System.arraycopy(this.items, keyIndex + 1, this.items, keyIndex, this.keyCount - keyIndex);
                this.items[this.keyCount] = null;
            }
            int i = keyIndex;
            while (i < this.keyCount) {
                int n = i++;
                this.keys[n] = this.keys[n] - 1;
            }
        }
    }

    void _removeItems(int start, int index, int count) {
        if (this.keys == null) {
            System.arraycopy(this.items, index, this.items, start, count - index);
            for (int i = count - (index - start); i < count; ++i) {
                this.items[i] = null;
            }
        } else {
            int i;
            int right;
            int end = index;
            int left = this.binarySearch(this.keys, 0, this.keyCount, start);
            if (left < 0) {
                left = -left - 1;
            }
            if ((right = this.binarySearch(this.keys, left, this.keyCount, end)) < 0) {
                right = -right - 1;
            }
            System.arraycopy(this.keys, right, this.keys, left, this.keyCount - right);
            for (i = this.keyCount - (right - left); i < this.keyCount; ++i) {
                this.keys[i] = 0;
            }
            System.arraycopy(this.items, right, this.items, left, this.keyCount - right);
            for (i = this.keyCount - (right - left); i < this.keyCount; ++i) {
                this.items[i] = null;
            }
            this.keyCount -= right - left;
            i = left;
            while (i < this.keyCount) {
                int n = i++;
                this.keys[n] = this.keys[n] - (right - left);
            }
        }
    }

    void _setItemCount(int count, int itemCount) {
        if (this.keys == null) {
            int length = Math.max(4, (count + 3) / 4 * 4);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, Math.min(count, itemCount));
            this.items = newItems;
        } else {
            int index = Math.min(count, itemCount);
            this.keyCount = this.binarySearch(this.keys, 0, this.keyCount, index);
            if (this.keyCount < 0) {
                this.keyCount = -this.keyCount - 1;
            }
            int length = Math.max(4, (this.keyCount + 3) / 4 * 4);
            int[] newKeys = new int[length];
            System.arraycopy(this.keys, 0, newKeys, 0, this.keyCount);
            this.keys = newKeys;
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.keyCount);
            this.items = newItems;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        return this.callWindowProc(hwnd, msg, wParam, lParam, false);
    }

    long callWindowProc(long hwnd, int msg, long wParam, long lParam, boolean forceSelect) {
        int bits0;
        if (this.handle == 0L) {
            return 0L;
        }
        if (this.hwndHeader != 0L && hwnd == this.hwndHeader) {
            return OS.CallWindowProc(HeaderProc, hwnd, msg, wParam, lParam);
        }
        int topIndex = 0;
        boolean checkSelection = false;
        boolean checkActivate = false;
        boolean redraw = false;
        switch (msg) {
            case 256: {
                checkActivate = true;
            }
            case 71: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                boolean bl = redraw = this.findImageControl() != null && this.getDrawing() && OS.IsWindowVisible(this.handle);
                if (redraw) {
                    OS.DefWindowProc(this.handle, 11, 0L, 0L);
                    OS.SendMessage(this.handle, 4097, 0L, 0xFFFFFFL);
                }
            }
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                checkSelection = true;
            }
            case 48: 
            case 275: {
                if (this.findImageControl() == null) break;
                topIndex = (int)OS.SendMessage(this.handle, 4135, 0L, 0L);
            }
        }
        boolean oldSelected = this.wasSelected;
        if (checkSelection) {
            this.wasSelected = false;
        }
        if (checkActivate) {
            this.ignoreActivate = true;
        }
        boolean fixPaint = false;
        if (msg == 15 && ((bits0 = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0) {
            long hwndParent = OS.GetParent(this.handle);
            long hwndOwner = 0L;
            while (hwndParent != 0L) {
                int bits1 = OS.GetWindowLong(hwndParent, -20);
                if ((bits1 & 0x2000000) != 0) {
                    fixPaint = true;
                    break;
                }
                hwndOwner = OS.GetWindow(hwndParent, 4);
                if (hwndOwner != 0L) break;
                hwndParent = OS.GetParent(hwndParent);
            }
        }
        boolean fixScroll = false;
        if ((this.style & 0x100) == 0 || (this.style & 0x200) == 0) {
            switch (msg) {
                case 15: 
                case 70: 
                case 133: {
                    int bits = OS.GetWindowLong(hwnd, -16);
                    if ((this.style & 0x100) == 0 && (bits & 0x100000) != 0) {
                        fixScroll = true;
                        bits &= 0xFFEFFFFF;
                    }
                    if ((this.style & 0x200) == 0 && (bits & 0x200000) != 0) {
                        fixScroll = true;
                        bits &= 0xFFDFFFFF;
                    }
                    if (!fixScroll) break;
                    OS.SetWindowLong(this.handle, -16, bits);
                }
            }
        }
        long code = 0L;
        if (fixPaint) {
            PAINTSTRUCT ps = new PAINTSTRUCT();
            long hDC = OS.BeginPaint(hwnd, ps);
            code = OS.CallWindowProc(TableProc, hwnd, 15, hDC, lParam);
            OS.EndPaint(hwnd, ps);
        } else {
            code = OS.CallWindowProc(TableProc, hwnd, msg, wParam, lParam);
        }
        if (fixScroll) {
            int flags = 1025;
            OS.RedrawWindow(this.handle, null, 0L, flags);
        }
        if (checkActivate) {
            this.ignoreActivate = false;
        }
        if (checkSelection) {
            if (this.wasSelected || forceSelect) {
                Event event = new Event();
                int index = (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
                if (index != -1) {
                    event.item = this._getItem(index);
                }
                this.sendSelectionEvent(13, event, false);
            }
            this.wasSelected = oldSelected;
        }
        switch (msg) {
            case 71: 
            case 256: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                if (redraw) {
                    OS.SendMessage(this.handle, 4097, 0L, -1L);
                    OS.DefWindowProc(this.handle, 11, 1L, 0L);
                    OS.InvalidateRect(this.handle, null, true);
                    long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
                    if (hwndHeader != 0L) {
                        OS.InvalidateRect(hwndHeader, null, true);
                    }
                }
            }
            case 48: 
            case 275: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                if (this.findImageControl() == null || (long)topIndex == OS.SendMessage(this.handle, 4135, 0L, 0L)) break;
                OS.InvalidateRect(this.handle, null, true);
                break;
            }
            case 15: {
                this.painted = true;
            }
        }
        return code;
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Table.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    LRESULT CDDS_ITEMPOSTPAINT(NMLVCUSTOMDRAW nmcd, long wParam, long lParam) {
        int uiState;
        int dwExStyle;
        long hDC = nmcd.hdc;
        if (this.explorerTheme && !this.ignoreCustomDraw) {
            this.hotIndex = -1;
            if (this.hooks(40) && nmcd.left != nmcd.right) {
                OS.RestoreDC(hDC, -1);
            }
        }
        if (!this.ignoreCustomDraw && !this.ignoreDrawFocus && nmcd.left != nmcd.right && OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 && ((dwExStyle = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) == 0 && OS.SendMessage(this.handle, 4108, -1L, 1L) == nmcd.dwItemSpec && this.handle == OS.GetFocus() && ((uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) == 0) {
            RECT rect = new RECT();
            rect.left = 0;
            boolean oldIgnore = this.ignoreCustomDraw;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4110, nmcd.dwItemSpec, rect);
            long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
            int index = (int)OS.SendMessage(hwndHeader, 4623, 0L, 0L);
            RECT itemRect = new RECT();
            if (index == 0) {
                itemRect.left = 2;
                OS.SendMessage(this.handle, 4110, (long)index, itemRect);
            } else {
                itemRect.top = index;
                itemRect.left = 1;
                OS.SendMessage(this.handle, 4152, nmcd.dwItemSpec, itemRect);
            }
            this.ignoreCustomDraw = oldIgnore;
            rect.left = itemRect.left;
            OS.DrawFocusRect(nmcd.hdc, rect);
        }
        return null;
    }

    LRESULT CDDS_ITEMPREPAINT(NMLVCUSTOMDRAW nmcd, long wParam, long lParam) {
        int dwExStyle;
        if (!this.ignoreCustomDraw && OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 && ((dwExStyle = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) == 0 && (nmcd.uItemState & 0x10) != 0) {
            nmcd.uItemState &= 0xFFFFFFEF;
            OS.MoveMemory(lParam, nmcd, NMLVCUSTOMDRAW.sizeof);
        }
        if (this.explorerTheme && !this.ignoreCustomDraw) {
            int n = this.hotIndex = (nmcd.uItemState & 0x40) != 0 ? (int)nmcd.dwItemSpec : -1;
            if (this.hooks(40) && nmcd.left != nmcd.right) {
                OS.SaveDC(nmcd.hdc);
                long hrgn = OS.CreateRectRgn(0, 0, 0, 0);
                OS.SelectClipRgn(nmcd.hdc, hrgn);
                OS.DeleteObject(hrgn);
            }
        }
        return new LRESULT(48L);
    }

    LRESULT CDDS_POSTPAINT(NMLVCUSTOMDRAW nmcd, long wParam, long lParam) {
        int dwExStyle;
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (--this.customCount == 0 && OS.IsWindowVisible(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 && ((dwExStyle = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) == 0) {
            int bits = 32;
            long hwndToolTip = OS.SendMessage(this.handle, 4170, 0L, 0L);
            long rgn = OS.CreateRectRgn(0, 0, 0, 0);
            int result = OS.GetUpdateRgn(this.handle, rgn, true);
            OS.SendMessage(this.handle, 4150, (long)bits, bits);
            OS.ValidateRect(this.handle, null);
            if (result != 1) {
                OS.InvalidateRgn(this.handle, rgn, true);
            }
            OS.DeleteObject(rgn);
            hwndToolTip = OS.SendMessage(this.handle, 4170, hwndToolTip, hwndToolTip);
        }
        return null;
    }

    LRESULT CDDS_PREPAINT(NMLVCUSTOMDRAW nmcd, long wParam, long lParam) {
        int dwExStyle;
        if (this.ignoreCustomDraw) {
            return new LRESULT(48L);
        }
        if (this.customCount++ == 0 && OS.IsWindowVisible(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 && ((dwExStyle = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) != 0) {
            int bits = 32;
            long hwndToolTip = OS.SendMessage(this.handle, 4170, 0L, 0L);
            long rgn = OS.CreateRectRgn(0, 0, 0, 0);
            int result = OS.GetUpdateRgn(this.handle, rgn, true);
            OS.SendMessage(this.handle, 4150, (long)bits, 0L);
            OS.ValidateRect(this.handle, null);
            if (result != 1) {
                OS.InvalidateRgn(this.handle, rgn, true);
            }
            OS.DeleteObject(rgn);
            hwndToolTip = OS.SendMessage(this.handle, 4170, hwndToolTip, hwndToolTip);
        }
        if (OS.IsWindowVisible(this.handle)) {
            RECT rect = new RECT();
            OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
            if (this.explorerTheme && this.columnCount == 0) {
                long hDC = nmcd.hdc;
                if (OS.IsWindowEnabled(this.handle) || this.findImageControl() != null) {
                    this.drawBackground(hDC, rect);
                } else {
                    this.fillBackground(hDC, OS.GetSysColor(15), rect);
                }
            } else {
                Control control = this.findBackgroundControl();
                if (control != null && control.backgroundImage != null) {
                    this.fillImageBackground(nmcd.hdc, control, rect, 0, 0);
                } else {
                    boolean enabled = OS.IsWindowEnabled(this.handle);
                    if (enabled && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 || !enabled && this.hasCustomBackground()) {
                        int index;
                        if (control == null) {
                            control = this;
                        }
                        this.fillBackground(nmcd.hdc, control.getBackgroundPixel(), rect);
                        if (OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && (index = this.indexOf(this.sortColumn)) != -1) {
                            this.parent.forceResize();
                            int clrSortBk = this.getSortColumnPixel();
                            RECT columnRect = new RECT();
                            RECT headerRect = new RECT();
                            OS.GetClientRect(this.handle, columnRect);
                            long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
                            if (OS.SendMessage(hwndHeader, 4615, (long)index, headerRect) != 0L) {
                                OS.MapWindowPoints(hwndHeader, this.handle, headerRect, 2);
                                columnRect.left = headerRect.left;
                                columnRect.right = headerRect.right;
                                if (OS.IntersectRect(columnRect, columnRect, rect)) {
                                    this.fillBackground(nmcd.hdc, clrSortBk, columnRect);
                                }
                            }
                        }
                    }
                }
            }
        }
        return new LRESULT(48L);
    }

    LRESULT CDDS_SUBITEMPOSTPAINT(NMLVCUSTOMDRAW nmcd, long wParam, long lParam) {
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (nmcd.left == nmcd.right) {
            return new LRESULT(0L);
        }
        long hDC = nmcd.hdc;
        if (this.ignoreDrawForeground) {
            OS.RestoreDC(hDC, -1);
        }
        if (OS.IsWindowVisible(this.handle)) {
            int oldColumn;
            if ((int)OS.SendMessage(this.handle, 4096, 0L, 0L) != -1 && (this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && (oldColumn = (int)OS.SendMessage(this.handle, 4270, 0L, 0L)) == -1) {
                int newColumn = this.indexOf(this.sortColumn);
                long rgn = OS.CreateRectRgn(0, 0, 0, 0);
                int result = OS.GetUpdateRgn(this.handle, rgn, true);
                OS.SendMessage(this.handle, 4236, (long)newColumn, 0L);
                OS.ValidateRect(this.handle, null);
                if (result != 1) {
                    OS.InvalidateRgn(this.handle, rgn, true);
                }
                OS.DeleteObject(rgn);
            }
            if (this.hooks(42)) {
                TableItem item = this._getItem((int)nmcd.dwItemSpec);
                this.sendPaintItemEvent(item, nmcd);
            }
            if (!this.ignoreDrawFocus && this.focusRect != null) {
                OS.SetTextColor(nmcd.hdc, 0);
                OS.SetBkColor(nmcd.hdc, 0xFFFFFF);
                OS.DrawFocusRect(nmcd.hdc, this.focusRect);
                this.focusRect = null;
            }
        }
        return null;
    }

    LRESULT CDDS_SUBITEMPREPAINT(NMLVCUSTOMDRAW nmcd, long wParam, long lParam) {
        int oldColumn;
        int bits;
        int clrTextBk;
        int clrText;
        TableItem item;
        long hDC = nmcd.hdc;
        if (this.explorerTheme && !this.ignoreCustomDraw && this.hooks(40) && nmcd.left != nmcd.right) {
            OS.RestoreDC(hDC, -1);
        }
        if ((item = this._getItem((int)nmcd.dwItemSpec)) == null || item.isDisposed()) {
            return null;
        }
        long hFont = item.fontHandle(nmcd.iSubItem);
        if (hFont != -1L) {
            OS.SelectObject(hDC, hFont);
        }
        if (this.ignoreCustomDraw || nmcd.left == nmcd.right) {
            return new LRESULT(hFont == -1L ? 0L : 2L);
        }
        int code = 0;
        this.selectionForeground = -1;
        this.ignoreDrawBackground = false;
        this.ignoreDrawFocus = false;
        this.ignoreDrawSelection = false;
        this.ignoreDrawForeground = false;
        if (OS.IsWindowVisible(this.handle)) {
            Event measureEvent = null;
            if (this.hooks(41)) {
                measureEvent = this.sendMeasureItemEvent(item, (int)nmcd.dwItemSpec, nmcd.iSubItem, nmcd.hdc);
                if (this.isDisposed() || item.isDisposed()) {
                    return null;
                }
            }
            if (this.hooks(40)) {
                this.sendEraseItemEvent(item, nmcd, lParam, measureEvent);
                if (this.isDisposed() || item.isDisposed()) {
                    return null;
                }
                code |= 0x10;
            }
            if (this.ignoreDrawForeground || this.hooks(42)) {
                code |= 0x10;
            }
        }
        int n = clrText = item.cellForeground != null ? item.cellForeground[nmcd.iSubItem] : -1;
        if (clrText == -1) {
            clrText = item.foreground;
        }
        int n2 = clrTextBk = item.cellBackground != null ? item.cellBackground[nmcd.iSubItem] : -1;
        if (clrTextBk == -1) {
            clrTextBk = item.background;
        }
        if (this.selectionForeground != -1) {
            clrText = this.selectionForeground;
        }
        boolean enabled = OS.IsWindowEnabled(this.handle);
        if (OS.IsWindowVisible(this.handle) && enabled && !this.explorerTheme && !this.ignoreDrawSelection && (this.style & 0x10000) != 0 && ((bits = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) == 0) {
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 8;
            lvItem.stateMask = 2;
            lvItem.iItem = (int)nmcd.dwItemSpec;
            long result = OS.SendMessage(this.handle, 4171, 0L, lvItem);
            if (result != 0L && (lvItem.state & 2) != 0) {
                int clrSelection = -1;
                if (nmcd.iSubItem == 0) {
                    if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                        clrSelection = OS.GetSysColor(13);
                    } else if ((this.style & 0x8000) == 0) {
                        clrSelection = OS.GetSysColor(15);
                    }
                } else if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    clrText = OS.GetSysColor(14);
                    clrTextBk = clrSelection = OS.GetSysColor(13);
                } else if ((this.style & 0x8000) == 0) {
                    clrTextBk = clrSelection = OS.GetSysColor(15);
                }
                if (clrSelection != -1) {
                    RECT rect = item.getBounds((int)nmcd.dwItemSpec, nmcd.iSubItem, true, nmcd.iSubItem != 0, true, false, hDC);
                    this.fillBackground(hDC, clrSelection, rect);
                }
            }
        }
        if (!this.ignoreDrawForeground) {
            int count;
            boolean hasAttributes = true;
            if (hFont == -1L && clrText == -1 && clrTextBk == -1 && item.cellForeground == null && item.cellBackground == null && item.cellFont == null && (count = (int)OS.SendMessage(this.hwndHeader, 4608, 0L, 0L)) == 1) {
                hasAttributes = false;
            }
            if (hasAttributes) {
                if (hFont == -1L) {
                    hFont = OS.SendMessage(this.handle, 49, 0L, 0L);
                }
                OS.SelectObject(hDC, hFont);
                if (enabled) {
                    int n3 = nmcd.clrText = clrText == -1 ? this.getForegroundPixel() : clrText;
                    if (clrTextBk == -1) {
                        nmcd.clrTextBk = -1;
                        if (this.selectionForeground == -1) {
                            Control control = this.findBackgroundControl();
                            if (control == null) {
                                control = this;
                            }
                            if (control.backgroundImage == null && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) != -1) {
                                nmcd.clrTextBk = control.getBackgroundPixel();
                            }
                        }
                    } else {
                        nmcd.clrTextBk = this.selectionForeground != -1 ? -1 : clrTextBk;
                    }
                    OS.MoveMemory(lParam, nmcd, NMLVCUSTOMDRAW.sizeof);
                }
                code |= 2;
            }
        }
        if ((enabled && clrTextBk != -1 || !enabled && this.hasCustomBackground()) && (oldColumn = (int)OS.SendMessage(this.handle, 4270, 0L, 0L)) != -1 && oldColumn == nmcd.iSubItem) {
            long rgn = OS.CreateRectRgn(0, 0, 0, 0);
            int result = OS.GetUpdateRgn(this.handle, rgn, true);
            OS.SendMessage(this.handle, 4236, -1L, 0L);
            OS.ValidateRect(this.handle, null);
            if (result != 1) {
                OS.InvalidateRgn(this.handle, rgn, true);
            }
            OS.DeleteObject(rgn);
            code |= 0x10;
        }
        if (!enabled) {
            nmcd.clrText = OS.GetSysColor(17);
            if (this.findImageControl() != null || this.hasCustomBackground()) {
                nmcd.clrTextBk = -1;
            }
            nmcd.uItemState &= 0xFFFFFFFE;
            OS.MoveMemory(lParam, nmcd, NMLVCUSTOMDRAW.sizeof);
            code |= 2;
        }
        return new LRESULT(code);
    }

    @Override
    void checkBuffered() {
        super.checkBuffered();
        this.style |= 0x20000000;
    }

    boolean checkData(TableItem item, boolean redraw) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        return this.checkData(item, this.indexOf(item), redraw);
    }

    boolean checkData(TableItem item, int index, boolean redraw) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!item.cached) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = index;
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw && !this.setScrollWidth(item, false)) {
                item.redraw();
            }
        }
        return true;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (0 > index || index >= count) {
            this.error(6);
        }
        if ((item = this._getItem(index, false)) != null) {
            if (item != this.currentItem) {
                item.clear();
            }
            if ((this.style & 0x10000000) == 0 && item.cached) {
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 17;
                lvItem.pszText = -1L;
                lvItem.iItem = index;
                OS.SendMessage(this.handle, 4172, 0L, lvItem);
                item.cached = false;
            }
            if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, (long)index, index);
            }
            this.setScrollWidth(item, false);
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (0 > start || start > end || end >= count) {
            this.error(6);
        }
        if (start == 0 && end == count - 1) {
            this.clearAll();
        } else {
            LVITEM lvItem = null;
            boolean cleared = false;
            for (int i = start; i <= end; ++i) {
                TableItem item = this._getItem(i, false);
                if (item == null) continue;
                if (item != this.currentItem) {
                    cleared = true;
                    item.clear();
                }
                if ((this.style & 0x10000000) != 0 || !item.cached) continue;
                if (lvItem == null) {
                    lvItem = new LVITEM();
                    lvItem.mask = 17;
                    lvItem.pszText = -1L;
                }
                lvItem.iItem = i;
                OS.SendMessage(this.handle, 4172, 0L, lvItem);
                item.cached = false;
            }
            if (cleared) {
                if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, (long)start, end);
                }
                TableItem item = start == end ? this._getItem(start, false) : null;
                this.setScrollWidth(item, false);
            }
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        for (int i = 0; i < indices.length; ++i) {
            if (0 <= indices[i] && indices[i] < count) continue;
            this.error(6);
        }
        LVITEM lvItem = null;
        boolean cleared = false;
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            TableItem item = this._getItem(index, false);
            if (item == null) continue;
            if (item != this.currentItem) {
                cleared = true;
                item.clear();
            }
            if ((this.style & 0x10000000) == 0 && item.cached) {
                if (lvItem == null) {
                    lvItem = new LVITEM();
                    lvItem.mask = 17;
                    lvItem.pszText = -1L;
                }
                lvItem.iItem = i;
                OS.SendMessage(this.handle, 4172, 0L, lvItem);
                item.cached = false;
            }
            if (this.currentItem != null || !this.getDrawing() || !OS.IsWindowVisible(this.handle)) continue;
            OS.SendMessage(this.handle, 4117, (long)index, index);
        }
        if (cleared) {
            this.setScrollWidth(null, false);
        }
    }

    public void clearAll() {
        this.checkWidget();
        LVITEM lvItem = null;
        boolean cleared = false;
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        for (int i = 0; i < count; ++i) {
            TableItem item = this._getItem(i, false);
            if (item == null) continue;
            if (item != this.currentItem) {
                cleared = true;
                item.clear();
            }
            if ((this.style & 0x10000000) != 0 || !item.cached) continue;
            if (lvItem == null) {
                lvItem = new LVITEM();
                lvItem.mask = 17;
                lvItem.pszText = -1L;
            }
            lvItem.iItem = i;
            OS.SendMessage(this.handle, 4172, 0L, lvItem);
            item.cached = false;
        }
        if (cleared) {
            if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, 0L, count - 1);
            }
            this.setScrollWidth(null, false);
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.hwndHeader, rect);
        int height = rect.bottom - rect.top;
        int bits = 0;
        if (wHint != -1) {
            bits |= wHint & 0xFFFF;
        } else {
            int width = 0;
            int count = (int)OS.SendMessage(this.hwndHeader, 4608, 0L, 0L);
            for (int i = 0; i < count; ++i) {
                width = (int)((long)width + OS.SendMessage(this.handle, 4125, (long)i, 0L));
            }
            bits |= width & 0xFFFF;
        }
        long result = OS.SendMessage(this.handle, 4160, -1L, OS.MAKELPARAM(bits, 65535));
        int width = OS.LOWORD(result);
        long empty = OS.SendMessage(this.handle, 4160, 0L, 0L);
        long oneItem = OS.SendMessage(this.handle, 4160, 1L, 0L);
        int itemHeight = OS.HIWORD(oneItem) - OS.HIWORD(empty);
        height += (int)OS.SendMessage(this.handle, 4100, 0L, 0L) * itemHeight;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidthInPixels();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            height += OS.GetSystemMetrics(3);
        }
        return new Point(width, height);
    }

    @Override
    void createHandle() {
        long pszText;
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (OS.IsAppThemed()) {
            this.explorerTheme = true;
            OS.SetWindowTheme(this.handle, this.display.getExplorerTheme(), null);
        }
        this.hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
        if ((this.style & 0x20) != 0) {
            int width;
            long empty = OS.SendMessage(this.handle, 4160, 0L, 0L);
            long oneItem = OS.SendMessage(this.handle, 4160, 1L, 0L);
            int height = width = OS.HIWORD(oneItem) - OS.HIWORD(empty);
            this.setCheckboxImageList(width, height, false);
            OS.SendMessage(this.handle, 4107, 61440L, 0L);
        }
        long hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0L);
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 6;
        long hHeap = OS.GetProcessHeap();
        lvColumn.pszText = pszText = OS.HeapAlloc(hHeap, 8, 2);
        OS.SendMessage(this.handle, 4193, 0L, lvColumn);
        OS.HeapFree(hHeap, 0, pszText);
        int bits1 = 81920;
        if ((this.style & 0x10000) != 0) {
            bits1 |= 0x20;
        }
        OS.SendMessage(this.handle, 4150, (long)bits1, bits1);
        if ((this.style & 0x4000000) != 0) {
            int bits2 = OS.GetWindowLong(this.hwndHeader, -20);
            OS.SetWindowLong(this.hwndHeader, -20, bits2 | 0x400000);
            long hwndTooltop = OS.SendMessage(this.handle, 4174, 0L, 0L);
            int bits3 = OS.GetWindowLong(hwndTooltop, -20);
            OS.SetWindowLong(hwndTooltop, -20, bits3 | 0x400000);
        }
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    void createHeaderToolTips() {
        if (this.headerToolTipHandle != 0L) {
            return;
        }
        int bits = 0;
        if ((this.style & 0x4000000) != 0) {
            bits |= 0x400000;
        }
        this.headerToolTipHandle = OS.CreateWindowEx(bits, new TCHAR(0, "tooltips_class32", true), null, 2, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0L, OS.GetModuleHandle(null), null);
        if (this.headerToolTipHandle == 0L) {
            this.error(2);
        }
        OS.SendMessage(this.headerToolTipHandle, 1048, 0L, 32767L);
    }

    void createItem(TableColumn column, int index) {
        RECT rect;
        int oldColumn;
        if (0 > index || index > this.columnCount) {
            this.error(6);
        }
        if ((oldColumn = (int)OS.SendMessage(this.handle, 4270, 0L, 0L)) >= index) {
            OS.SendMessage(this.handle, 4236, (long)(oldColumn + 1), 0L);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        int itemCount = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        for (int i = 0; i < itemCount; ++i) {
            Object[] temp;
            Image[] images;
            TableItem item = this._getItem(i, false);
            if (item == null) continue;
            String[] strings = item.strings;
            if (strings != null) {
                String[] temp2 = new String[this.columnCount + 1];
                System.arraycopy(strings, 0, temp2, 0, index);
                System.arraycopy(strings, index, temp2, index + 1, this.columnCount - index);
                item.strings = temp2;
            }
            if ((images = item.images) != null) {
                Image[] temp3 = new Image[this.columnCount + 1];
                System.arraycopy(images, 0, temp3, 0, index);
                System.arraycopy(images, index, temp3, index + 1, this.columnCount - index);
                item.images = temp3;
            }
            if (index == 0 && this.columnCount != 0) {
                if (strings == null) {
                    item.strings = new String[this.columnCount + 1];
                    item.strings[1] = item.text;
                }
                item.text = "";
                if (images == null) {
                    item.images = new Image[this.columnCount + 1];
                    item.images[1] = item.image;
                }
                item.image = null;
            }
            if (item.cellBackground != null) {
                int[] cellBackground = item.cellBackground;
                temp = new int[this.columnCount + 1];
                System.arraycopy(cellBackground, 0, temp, 0, index);
                System.arraycopy(cellBackground, index, temp, index + 1, this.columnCount - index);
                temp[index] = -1;
                item.cellBackground = temp;
            }
            if (item.cellForeground != null) {
                int[] cellForeground = item.cellForeground;
                temp = new int[this.columnCount + 1];
                System.arraycopy(cellForeground, 0, temp, 0, index);
                System.arraycopy(cellForeground, index, temp, index + 1, this.columnCount - index);
                temp[index] = -1;
                item.cellForeground = temp;
            }
            if (item.cellFont == null) continue;
            Font[] cellFont = item.cellFont;
            temp = new Font[this.columnCount + 1];
            System.arraycopy(cellFont, 0, temp, 0, index);
            System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index);
            item.cellFont = (Font[])temp;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        this.ignoreColumnResize = true;
        if (index == 0) {
            if (this.columnCount > 1) {
                LVCOLUMN lvColumn = new LVCOLUMN();
                lvColumn.mask = 2;
                OS.SendMessage(this.handle, 4193, 1L, lvColumn);
                OS.SendMessage(this.handle, 4191, 1L, lvColumn);
                int width = lvColumn.cx;
                int cchTextMax = 1024;
                long hHeap = OS.GetProcessHeap();
                int byteCount = cchTextMax * 2;
                long pszText = OS.HeapAlloc(hHeap, 8, byteCount);
                lvColumn.mask = 23;
                lvColumn.pszText = pszText;
                lvColumn.cchTextMax = cchTextMax;
                OS.SendMessage(this.handle, 4191, 0L, lvColumn);
                OS.SendMessage(this.handle, 4192, 1L, lvColumn);
                lvColumn.fmt = 2048;
                lvColumn.cx = width;
                lvColumn.iImage = -2;
                lvColumn.cchTextMax = 0;
                lvColumn.pszText = 0;
                OS.SendMessage(this.handle, 4192, 0L, lvColumn);
                lvColumn.mask = 1;
                lvColumn.fmt = 0;
                OS.SendMessage(this.handle, 4192, 0L, lvColumn);
                if (pszText != 0L) {
                    OS.HeapFree(hHeap, 0, pszText);
                }
            } else {
                OS.SendMessage(this.handle, 4126, 0L, 0L);
            }
            if ((this.style & 0x10000000) == 0) {
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 3;
                lvItem.pszText = -1L;
                lvItem.iImage = -1;
                int i = 0;
                while (i < itemCount) {
                    lvItem.iItem = i++;
                    OS.SendMessage(this.handle, 4172, 0L, lvItem);
                }
            }
        } else {
            int fmt = 0;
            if ((column.style & 0x1000000) == 0x1000000) {
                fmt = 2;
            }
            if ((column.style & 0x20000) == 131072) {
                fmt = 1;
            }
            LVCOLUMN lvColumn = new LVCOLUMN();
            lvColumn.mask = 3;
            lvColumn.fmt = fmt;
            OS.SendMessage(this.handle, 4193, (long)index, lvColumn);
        }
        this.ignoreColumnResize = false;
        if (this.headerToolTipHandle != 0L && OS.SendMessage(this.hwndHeader, 4615, (long)index, rect = new RECT()) != 0L) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            lpti.uFlags = 16;
            lpti.hwnd = this.hwndHeader;
            column.id = this.display.nextToolTipId++;
            lpti.uId = column.id;
            lpti.left = rect.left;
            lpti.top = rect.top;
            lpti.right = rect.right;
            lpti.bottom = rect.bottom;
            lpti.lpszText = -1L;
            OS.SendMessage(this.headerToolTipHandle, 1074, 0L, lpti);
        }
    }

    void createItem(TableItem item, int index) {
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (0 > index || index > count) {
            this.error(6);
        }
        this._checkGrow(count);
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 3;
        lvItem.iItem = index;
        lvItem.pszText = -1L;
        lvItem.iImage = -1;
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int result = (int)OS.SendMessage(this.handle, 4173, 0L, lvItem);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (result == -1) {
            this.error(14);
        }
        this._insertItem(index, item, count);
        this.setDeferResize(false);
        if (count == 0) {
            this.setScrollWidth(item, false);
        }
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.hotIndex = -1;
        this.itemHeight = -1;
        this._initItems();
        this.columns = new TableColumn[4];
    }

    private boolean customHeaderDrawing() {
        return this.headerBackground != -1 || this.headerForeground != -1;
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(5);
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.hwndHeader != 0L) {
            this.display.removeControl(this.hwndHeader);
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.stateMask = 2;
        for (int index : indices) {
            if (index < 0) continue;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, (long)index, lvItem);
            this.ignoreSelect = false;
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, (long)index, lvItem);
        this.ignoreSelect = false;
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (start == 0 && end == count - 1) {
            this.deselectAll();
        } else {
            LVITEM lvItem = new LVITEM();
            lvItem.stateMask = 2;
            for (int i = start = Math.max(0, start); i <= end; ++i) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, (long)i, lvItem);
                this.ignoreSelect = false;
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1L, lvItem);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn column) {
        int orderIndex;
        int index;
        for (index = 0; index < this.columnCount && this.columns[index] != column; ++index) {
        }
        int oldColumn = (int)OS.SendMessage(this.handle, 4270, 0L, 0L);
        if (oldColumn == index) {
            OS.SendMessage(this.handle, 4236, -1L, 0L);
        } else if (oldColumn > index) {
            OS.SendMessage(this.handle, 4236, (long)(oldColumn - 1), 0L);
        }
        int[] oldOrder = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, (long)this.columnCount, oldOrder);
        for (orderIndex = 0; orderIndex < this.columnCount && oldOrder[orderIndex] != index; ++orderIndex) {
        }
        this.ignoreColumnResize = true;
        boolean first = false;
        if (index == 0) {
            first = true;
            this.setRedraw(false);
            if (this.columnCount > 1) {
                index = 1;
                int cchTextMax = 1024;
                long hHeap = OS.GetProcessHeap();
                int byteCount = cchTextMax * 2;
                long pszText = OS.HeapAlloc(hHeap, 8, byteCount);
                LVCOLUMN lvColumn = new LVCOLUMN();
                lvColumn.mask = 23;
                lvColumn.pszText = pszText;
                lvColumn.cchTextMax = cchTextMax;
                OS.SendMessage(this.handle, 4191, 1L, lvColumn);
                lvColumn.fmt &= 0xFFFFFFFC;
                lvColumn.fmt |= 0;
                OS.SendMessage(this.handle, 4192, 0L, lvColumn);
                if (pszText != 0L) {
                    OS.HeapFree(hHeap, 0, pszText);
                }
            } else {
                long hHeap = OS.GetProcessHeap();
                long pszText = OS.HeapAlloc(hHeap, 8, 2);
                LVCOLUMN lvColumn = new LVCOLUMN();
                lvColumn.mask = 23;
                lvColumn.pszText = pszText;
                lvColumn.iImage = -2;
                lvColumn.fmt = 0;
                OS.SendMessage(this.handle, 4192, 0L, lvColumn);
                if (pszText != 0L) {
                    OS.HeapFree(hHeap, 0, pszText);
                }
                HDITEM hdItem = new HDITEM();
                hdItem.mask = 4;
                hdItem.fmt = 0;
                long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
                OS.SendMessage(hwndHeader, 4620, (long)index, hdItem);
            }
            this.setRedraw(true);
            if ((this.style & 0x10000000) == 0) {
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 3;
                lvItem.pszText = -1L;
                lvItem.iImage = -1;
                int itemCount = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
                int i = 0;
                while (i < itemCount) {
                    lvItem.iItem = i++;
                    OS.SendMessage(this.handle, 4172, 0L, lvItem);
                }
            }
        }
        if (this.columnCount > 1 && OS.SendMessage(this.handle, 4124, (long)index, 0L) == 0L) {
            this.error(15);
        }
        if (first) {
            index = 0;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        int itemCount = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        for (int i = 0; i < itemCount; ++i) {
            TableItem item = this._getItem(i, false);
            if (item == null) continue;
            if (this.columnCount == 0) {
                item.strings = null;
                item.images = null;
                item.cellBackground = null;
                item.cellForeground = null;
                item.cellFont = null;
                continue;
            }
            if (item.strings != null) {
                String[] strings = item.strings;
                if (index == 0) {
                    item.text = strings[1] != null ? strings[1] : "";
                }
                String[] temp = new String[this.columnCount];
                System.arraycopy(strings, 0, temp, 0, index);
                System.arraycopy(strings, index + 1, temp, index, this.columnCount - index);
                item.strings = temp;
            } else if (index == 0) {
                item.text = "";
            }
            if (item.images != null) {
                Image[] images = item.images;
                if (index == 0) {
                    item.image = images[1];
                }
                Image[] temp = new Image[this.columnCount];
                System.arraycopy(images, 0, temp, 0, index);
                System.arraycopy(images, index + 1, temp, index, this.columnCount - index);
                item.images = temp;
            } else if (index == 0) {
                item.image = null;
            }
            if (item.cellBackground != null) {
                int[] cellBackground = item.cellBackground;
                int[] temp = new int[this.columnCount];
                System.arraycopy(cellBackground, 0, temp, 0, index);
                System.arraycopy(cellBackground, index + 1, temp, index, this.columnCount - index);
                item.cellBackground = temp;
            }
            if (item.cellForeground != null) {
                int[] cellForeground = item.cellForeground;
                int[] temp = new int[this.columnCount];
                System.arraycopy(cellForeground, 0, temp, 0, index);
                System.arraycopy(cellForeground, index + 1, temp, index, this.columnCount - index);
                item.cellForeground = temp;
            }
            if (item.cellFont == null) continue;
            Font[] cellFont = item.cellFont;
            Font[] temp = new Font[this.columnCount];
            System.arraycopy(cellFont, 0, temp, 0, index);
            System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - index);
            item.cellFont = temp;
        }
        if (this.columnCount == 0) {
            this.setScrollWidth(null, true);
        }
        this.updateMoveable();
        this.ignoreColumnResize = false;
        if (this.columnCount != 0) {
            int j;
            int count = 0;
            int oldIndex = oldOrder[orderIndex];
            int[] newOrder = new int[this.columnCount];
            for (int element : oldOrder) {
                if (element == oldIndex) continue;
                int newIndex = element <= oldIndex ? element : element - 1;
                newOrder[count++] = newIndex;
            }
            OS.SendMessage(this.handle, 4155, (long)this.columnCount, oldOrder);
            for (j = 0; j < newOrder.length && oldOrder[j] == newOrder[j]; ++j) {
            }
            if (j != newOrder.length) {
                OS.SendMessage(this.handle, 4154, (long)newOrder.length, newOrder);
                OS.InvalidateRect(this.handle, null, true);
            }
            TableColumn[] newColumns = new TableColumn[this.columnCount - orderIndex];
            for (int i = orderIndex; i < newOrder.length; ++i) {
                newColumns[i - orderIndex] = this.columns[newOrder[i]];
                newColumns[i - orderIndex].updateToolTip(newOrder[i]);
            }
            for (TableColumn newColumn : newColumns) {
                if (newColumn.isDisposed()) continue;
                newColumn.sendEvent(10);
            }
        }
        if (this.headerToolTipHandle != 0L) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            lpti.uId = column.id;
            lpti.hwnd = OS.SendMessage(this.handle, 4127, 0L, 0L);
            OS.SendMessage(this.headerToolTipHandle, 1075, 0L, lpti);
        }
    }

    void destroyItem(TableItem item) {
        int index;
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        for (index = 0; index < count && this._getItem(index, false) != item; ++index) {
        }
        if (index == count) {
            return;
        }
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        long code = OS.SendMessage(this.handle, 4104, (long)index, 0L);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (code == 0L) {
            this.error(15);
        }
        this._removeItem(index, count);
        if (--count == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    void fixCheckboxImageList(boolean fixScroll) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        long hImageList = OS.SendMessage(this.handle, 4098, 1L, 0L);
        if (hImageList == 0L) {
            return;
        }
        int[] cx = new int[1];
        int[] cy = new int[1];
        OS.ImageList_GetIconSize(hImageList, cx, cy);
        long hStateList = OS.SendMessage(this.handle, 4098, 2L, 0L);
        if (hStateList == 0L) {
            return;
        }
        int[] stateCx = new int[1];
        int[] stateCy = new int[1];
        OS.ImageList_GetIconSize(hStateList, stateCx, stateCy);
        if (cx[0] == stateCx[0] && cy[0] == stateCy[0]) {
            return;
        }
        this.setCheckboxImageList(cx[0], cy[0], fixScroll);
    }

    void fixCheckboxImageListColor(boolean fixScroll) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        long hStateList = OS.SendMessage(this.handle, 4098, 2L, 0L);
        if (hStateList == 0L) {
            return;
        }
        int[] cx = new int[1];
        int[] cy = new int[1];
        OS.ImageList_GetIconSize(hStateList, cx, cy);
        this.setCheckboxImageList(cx[0], cy[0], fixScroll);
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        if (0 > index || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        int[] order = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, (long)this.columnCount, order);
        return order;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] result = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    int getFocusIndex() {
        return (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getGridLineWidthInPixels());
    }

    int getGridLineWidthInPixels() {
        return 1;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getHeaderBackgroundPixel());
    }

    private int getHeaderBackgroundPixel() {
        return this.headerBackground != -1 ? this.headerBackground : this.defaultBackground();
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getHeaderForegroundPixel());
    }

    private int getHeaderForegroundPixel() {
        return this.headerForeground != -1 ? this.headerForeground : this.defaultForeground();
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        if (this.hwndHeader == 0L) {
            return 0;
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.hwndHeader, rect);
        return rect.bottom - rect.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        int bits = OS.GetWindowLong(this.handle, -16);
        return (bits & 0x4000) == 0;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (0 > index || index >= count) {
            this.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    TableItem getItemInPixels(Point point) {
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (count == 0) {
            return null;
        }
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = point.x;
        pinfo.y = point.y;
        if ((this.style & 0x10000) == 0 && this.hooks(41)) {
            if (OS.SendMessage(this.handle, 4153, 0L, pinfo) < 0L) {
                RECT rect = new RECT();
                rect.left = 1;
                this.ignoreCustomDraw = true;
                long code = OS.SendMessage(this.handle, 4110, 0L, rect);
                this.ignoreCustomDraw = false;
                if (code != 0L) {
                    pinfo.x = rect.left;
                    OS.SendMessage(this.handle, 4153, 0L, pinfo);
                    if (pinfo.iItem < 0) {
                        pinfo.iItem = -1;
                    }
                }
            }
            if (pinfo.iItem != -1 && pinfo.iSubItem == 0 && this.hitTestSelection(pinfo.iItem, pinfo.x, pinfo.y)) {
                return this._getItem(pinfo.iItem);
            }
            return null;
        }
        OS.SendMessage(this.handle, 4114, 0L, pinfo);
        if (pinfo.iItem != -1) {
            int bits;
            if (pinfo.iItem == 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0 && this.hwndHeader != 0L) {
                RECT rect = new RECT();
                OS.GetWindowRect(this.hwndHeader, rect);
                POINT pt = new POINT();
                pt.x = pinfo.x;
                pt.y = pinfo.y;
                OS.MapWindowPoints(this.handle, 0L, pt, 1);
                if (OS.PtInRect(rect, pt)) {
                    return null;
                }
            }
            return this._getItem(pinfo.iItem);
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        if (!this.painted && this.hooks(41)) {
            this.hitTestSelection(0, 0, 0);
        }
        long empty = OS.SendMessage(this.handle, 4160, 0L, 0L);
        long oneItem = OS.SendMessage(this.handle, 4160, 1L, 0L);
        return OS.HIWORD(oneItem) - OS.HIWORD(empty);
    }

    public TableItem[] getItems() {
        this.checkWidget();
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        TableItem[] result = new TableItem[count];
        if ((this.style & 0x10000000) != 0) {
            for (int i = 0; i < count; ++i) {
                result[i] = this._getItem(i);
            }
        } else {
            this._getItems(result, count);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this._getLinesVisible();
    }

    private boolean _getLinesVisible() {
        int bits = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
        return (bits & 1) != 0;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int i = -1;
        int j = 0;
        int count = (int)OS.SendMessage(this.handle, 4146, 0L, 0L);
        TableItem[] result = new TableItem[count];
        while ((i = (int)OS.SendMessage(this.handle, 4108, (long)i, 2L)) != -1) {
            result[j++] = this._getItem(i);
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 4146, 0L, 0L);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int focusIndex = (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
        int selectedIndex = (int)OS.SendMessage(this.handle, 4108, -1L, 2L);
        if (focusIndex == selectedIndex) {
            return selectedIndex;
        }
        int i = -1;
        while ((i = (int)OS.SendMessage(this.handle, 4108, (long)i, 2L)) != -1) {
            if (i != focusIndex) continue;
            return i;
        }
        return selectedIndex;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int i = -1;
        int j = 0;
        int count = (int)OS.SendMessage(this.handle, 4146, 0L, 0L);
        int[] result = new int[count];
        while ((i = (int)OS.SendMessage(this.handle, 4108, (long)i, 2L)) != -1) {
            result[j++] = i;
        }
        return result;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    int getSortColumnPixel() {
        int pixel = OS.IsWindowEnabled(this.handle) || this.hasCustomBackground() ? this.getBackgroundPixel() : OS.GetSysColor(15);
        return this.getSlightlyDifferentBackgroundColor(pixel);
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        return Math.max(0, (int)OS.SendMessage(this.handle, 4135, 0L, 0L));
    }

    boolean hasChildren() {
        long hwndChild = OS.GetWindow(this.handle, 5);
        while (hwndChild != 0L) {
            if (hwndChild != this.hwndHeader) {
                return true;
            }
            hwndChild = OS.GetWindow(hwndChild, 2);
        }
        return false;
    }

    boolean hitTestSelection(int index, int x, int y) {
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (count == 0) {
            return false;
        }
        if (!this.hooks(41)) {
            return false;
        }
        boolean result = false;
        if (0 <= index && index < count) {
            Event event;
            long hFont;
            TableItem item = this._getItem(index);
            long hDC = OS.GetDC(this.handle);
            long oldFont = 0L;
            long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (newFont != 0L) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            if ((hFont = item.fontHandle(0)) != -1L) {
                hFont = OS.SelectObject(hDC, hFont);
            }
            if ((event = this.sendMeasureItemEvent(item, index, 0, hDC)).getBoundsInPixels().contains(x, y)) {
                result = true;
            }
            if (hFont != -1L) {
                hFont = OS.SelectObject(hDC, hFont);
            }
            if (newFont != 0L) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        }
        return result;
    }

    int imageIndex(Image image, int column) {
        if (image == null) {
            return -2;
        }
        if (column == 0) {
            this.firstColumnImage = true;
        } else {
            this.setSubImagesVisible(true);
        }
        if (this.imageList == null) {
            Rectangle bounds = image.getBoundsInPixels();
            this.imageList = this.display.getImageList(this.style & 0x4000000, bounds.width, bounds.height);
            int index = this.imageList.indexOf(image);
            if (index == -1) {
                index = this.imageList.add(image);
            }
            long hImageList = this.imageList.getHandle();
            int topIndex = this.getTopIndex();
            if (topIndex != 0) {
                this.setRedraw(false);
                this.setTopIndex(0);
            }
            OS.SendMessage(this.handle, 4099, 1L, hImageList);
            if (this.headerImageList != null) {
                long hHeaderImageList = this.headerImageList.getHandle();
                OS.SendMessage(this.hwndHeader, 4616, 0L, hHeaderImageList);
            }
            this.fixCheckboxImageList(false);
            this.setItemHeight(false);
            if (topIndex != 0) {
                this.setTopIndex(topIndex);
                this.setRedraw(true);
            }
            return index;
        }
        int index = this.imageList.indexOf(image);
        if (index != -1) {
            return index;
        }
        return this.imageList.add(image);
    }

    int imageIndexHeader(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.headerImageList == null) {
            Rectangle bounds = image.getBoundsInPixels();
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, bounds.width, bounds.height);
            int index = this.headerImageList.indexOf(image);
            if (index == -1) {
                index = this.headerImageList.add(image);
            }
            long hImageList = this.headerImageList.getHandle();
            OS.SendMessage(this.hwndHeader, 4616, 0L, hImageList);
            return index;
        }
        int index = this.headerImageList.indexOf(image);
        if (index != -1) {
            return index;
        }
        return this.headerImageList.add(image);
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != column) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (this.keys == null) {
            int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            if (1 <= this.lastIndexOf && this.lastIndexOf < count - 1) {
                if (this._getItem(this.lastIndexOf, false) == item) {
                    return this.lastIndexOf;
                }
                if (this._getItem(this.lastIndexOf + 1, false) == item) {
                    return ++this.lastIndexOf;
                }
                if (this._getItem(this.lastIndexOf - 1, false) == item) {
                    return --this.lastIndexOf;
                }
            }
            if (this.lastIndexOf < count / 2) {
                for (int i = 0; i < count; ++i) {
                    if (this._getItem(i, false) != item) continue;
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
            } else {
                for (int i = count - 1; i >= 0; --i) {
                    if (this._getItem(i, false) != item) continue;
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
            }
        } else {
            for (int i = 0; i < this.keyCount; ++i) {
                if (this.items[i] != item) continue;
                return this.keys[i];
            }
        }
        return -1;
    }

    boolean isCustomToolTip() {
        return this.hooks(41);
    }

    boolean isOptimizedRedraw() {
        if ((this.style & 0x100) == 0 || (this.style & 0x200) == 0) {
            return false;
        }
        return !this.hasChildren() && !this.hooks(9) && !this.filters(9) && !this.customHeaderDrawing();
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        lvItem.iItem = index;
        long result = OS.SendMessage(this.handle, 4171, 0L, lvItem);
        return result != 0L && (lvItem.state & 2) != 0;
    }

    @Override
    void register() {
        super.register();
        if (this.hwndHeader != 0L) {
            this.display.addControl(this.hwndHeader, this);
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this._hasItems()) {
            TableItem item;
            int i;
            int itemCount = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            if (this.keys == null) {
                for (i = 0; i < itemCount; ++i) {
                    item = this._getItem(i, false);
                    if (item == null || item.isDisposed()) continue;
                    item.release(false);
                }
            } else {
                for (i = 0; i < this.keyCount; ++i) {
                    item = this.items[i];
                    if (item == null || item.isDisposed()) continue;
                    item.release(false);
                }
            }
            this._clearItems();
        }
        if (this.columns != null) {
            for (int i = 0; i < this.columnCount; ++i) {
                TableColumn column = this.columns[i];
                if (column.isDisposed()) continue;
                column.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.customDraw = false;
        this.currentItem = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4099, 1L, 0L);
            this.display.releaseImageList(this.imageList);
        }
        if (this.headerImageList != null) {
            OS.SendMessage(this.hwndHeader, 4616, 0L, 0L);
            this.display.releaseImageList(this.headerImageList);
        }
        this.headerImageList = null;
        this.imageList = null;
        long hStateList = OS.SendMessage(this.handle, 4098, 2L, 0L);
        OS.SendMessage(this.handle, 4099, 2L, 0L);
        if (hStateList != 0L) {
            OS.ImageList_Destroy(hStateList);
        }
        if (this.headerToolTipHandle != 0L) {
            OS.DestroyWindow(this.headerToolTipHandle);
        }
        this.headerToolTipHandle = 0L;
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (0 > start || start > end || end >= count) {
            this.error(6);
        }
        this.setDeferResize(true);
        int last = -1;
        for (int index : newIndices) {
            if (index == last) continue;
            TableItem item = this._getItem(index, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            this.ignoreShrink = true;
            this.ignoreSelect = true;
            long code = OS.SendMessage(this.handle, 4104, (long)index, 0L);
            this.ignoreShrink = false;
            this.ignoreSelect = false;
            if (code == 0L) {
                this.error(15);
            }
            this._removeItem(index, count);
            --count;
            last = index;
        }
        if (count == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    public void remove(int index) {
        TableItem item;
        this.checkWidget();
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (0 > index || index >= count) {
            this.error(6);
        }
        if ((item = this._getItem(index, false)) != null && !item.isDisposed()) {
            item.release(false);
        }
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        long code = OS.SendMessage(this.handle, 4104, (long)index, 0L);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (code == 0L) {
            this.error(15);
        }
        this._removeItem(index, count);
        if (--count == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (0 > start || start > end || end >= count) {
            this.error(6);
        }
        if (start == 0 && end == count - 1) {
            this.removeAll();
        } else {
            int index;
            this.setDeferResize(true);
            for (index = start; index <= end; ++index) {
                TableItem item = this._getItem(index, false);
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                long code = OS.SendMessage(this.handle, 4104, (long)start, 0L);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (code == 0L) break;
            }
            this._removeItems(start, index, count);
            if (index <= end) {
                this.error(15);
            }
            this.setDeferResize(false);
        }
    }

    public void removeAll() {
        this.checkWidget();
        int itemCount = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        for (int i = 0; i < itemCount; ++i) {
            TableItem item = this._getItem(i, false);
            if (item == null || item.isDisposed()) continue;
            item.release(false);
        }
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        long code = OS.SendMessage(this.handle, 4105, 0L, 0L);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (code == 0L) {
            this.error(15);
        }
        this.setTableEmpty();
        this.setDeferResize(false);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.state = 2;
        lvItem.stateMask = 2;
        for (int i = length - 1; i >= 0; --i) {
            if (indices[i] < 0) continue;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, (long)indices[i], lvItem);
            this.ignoreSelect = false;
        }
    }

    @Override
    void reskinChildren(int flags) {
        if (this._hasItems()) {
            int itemCount = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            for (int i = 0; i < itemCount; ++i) {
                TableItem item = this._getItem(i, false);
                if (item == null) continue;
                item.reskin(flags);
            }
        }
        if (this.columns != null) {
            for (int i = 0; i < this.columnCount; ++i) {
                TableColumn column = this.columns[i];
                if (column.isDisposed()) continue;
                column.reskin(flags);
            }
        }
        super.reskinChildren(flags);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.state = 2;
        lvItem.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, (long)index, lvItem);
        this.ignoreSelect = false;
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if (start == 0 && end == count - 1) {
            this.selectAll();
        } else {
            LVITEM lvItem = new LVITEM();
            lvItem.state = 2;
            lvItem.stateMask = 2;
            for (int i = start; i <= end; ++i) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, (long)i, lvItem);
                this.ignoreSelect = false;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.state = 2;
        lvItem.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1L, lvItem);
        this.ignoreSelect = false;
    }

    void sendEraseItemEvent(TableItem item, NMLVCUSTOMDRAW nmcd, long lParam, Event measureEvent) {
        boolean firstColumn;
        boolean focused;
        int uiState;
        int clrText;
        long hDC = nmcd.hdc;
        int n = clrText = item.cellForeground != null ? item.cellForeground[nmcd.iSubItem] : -1;
        if (clrText == -1) {
            clrText = item.foreground;
        }
        int clrTextBk = -1;
        if (OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null && this.indexOf(this.sortColumn) == nmcd.iSubItem) {
            clrTextBk = this.getSortColumnPixel();
        }
        int n2 = clrTextBk = item.cellBackground != null ? item.cellBackground[nmcd.iSubItem] : -1;
        if (clrTextBk == -1) {
            clrTextBk = item.background;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        lvItem.iItem = (int)nmcd.dwItemSpec;
        long result = OS.SendMessage(this.handle, 4171, 0L, lvItem);
        boolean selected = result != 0L && (lvItem.state & 2) != 0;
        GCData data = new GCData();
        data.device = this.display;
        int clrSelectionBk = -1;
        boolean drawSelected = false;
        boolean drawBackground = false;
        boolean drawHot = false;
        boolean drawDrophilited = false;
        if (nmcd.iSubItem == 0 || (this.style & 0x10000) != 0) {
            drawHot = (long)this.hotIndex == nmcd.dwItemSpec;
            boolean bl = drawDrophilited = (nmcd.uItemState & 0x1000) != 0;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (selected && (nmcd.iSubItem == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    drawSelected = true;
                    data.foreground = OS.GetSysColor(14);
                    data.background = clrSelectionBk = OS.GetSysColor(13);
                } else {
                    drawSelected = (this.style & 0x8000) == 0;
                    data.foreground = OS.GetTextColor(hDC);
                    data.background = clrSelectionBk = OS.GetSysColor(15);
                }
                if (this.explorerTheme) {
                    data.foreground = clrText != -1 ? clrText : this.getForegroundPixel();
                }
            } else {
                boolean bl = drawBackground = clrTextBk != -1;
                if (clrText == -1 || clrTextBk == -1) {
                    Control control = this.findBackgroundControl();
                    if (control == null) {
                        control = this;
                    }
                    if (clrText == -1) {
                        clrText = control.getForegroundPixel();
                    }
                    if (clrTextBk == -1) {
                        clrTextBk = control.getBackgroundPixel();
                    }
                }
                data.foreground = clrText != -1 ? clrText : OS.GetTextColor(hDC);
                data.background = clrTextBk != -1 ? clrTextBk : OS.GetBkColor(hDC);
            }
        } else {
            data.foreground = OS.GetSysColor(17);
            data.background = OS.GetSysColor(15);
            if (selected) {
                clrSelectionBk = data.background;
            }
        }
        data.font = item.getFont(nmcd.iSubItem);
        data.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        int nSavedDC = OS.SaveDC(hDC);
        GC gc = GC.win32_new(hDC, data);
        RECT cellRect = item.getBounds((int)nmcd.dwItemSpec, nmcd.iSubItem, true, true, true, true, hDC);
        Event event = new Event();
        event.item = item;
        event.gc = gc;
        event.index = nmcd.iSubItem;
        event.detail |= 0x10;
        if (OS.SendMessage(this.handle, 4108, -1L, 1L) == nmcd.dwItemSpec && (nmcd.iSubItem == 0 || (this.style & 0x10000) != 0) && this.handle == OS.GetFocus() && ((uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) == 0) {
            event.detail |= 4;
        }
        boolean bl = focused = (event.detail & 4) != 0;
        if (drawHot) {
            event.detail |= 0x20;
        }
        if (drawSelected) {
            event.detail |= 2;
        }
        if (drawBackground) {
            event.detail |= 8;
        }
        Rectangle boundsInPixels = new Rectangle(cellRect.left, cellRect.top, cellRect.right - cellRect.left, cellRect.bottom - cellRect.top);
        event.setBoundsInPixels(boundsInPixels);
        gc.setClipping(DPIUtil.autoScaleDown(boundsInPixels));
        this.sendEvent(40, event);
        event.gc = null;
        int clrSelectionText = data.foreground;
        gc.dispose();
        OS.RestoreDC(hDC, nSavedDC);
        if (this.isDisposed() || item.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.ignoreDrawForeground = (event.detail & 0x10) == 0;
            this.ignoreDrawBackground = (event.detail & 8) == 0;
            this.ignoreDrawSelection = (event.detail & 2) == 0;
            this.ignoreDrawFocus = (event.detail & 4) == 0;
            this.ignoreDrawHot = (event.detail & 0x20) == 0;
        } else {
            this.ignoreDrawHot = true;
            this.ignoreDrawFocus = true;
            this.ignoreDrawSelection = true;
            this.ignoreDrawBackground = true;
            this.ignoreDrawForeground = true;
        }
        if (drawSelected) {
            if (this.ignoreDrawSelection) {
                this.ignoreDrawHot = true;
                if (nmcd.iSubItem == 0 || (this.style & 0x10000) != 0) {
                    this.selectionForeground = clrSelectionText;
                }
                nmcd.uItemState &= 0xFFFFFFFE;
                OS.MoveMemory(lParam, nmcd, NMLVCUSTOMDRAW.sizeof);
            }
        } else if (this.ignoreDrawSelection) {
            nmcd.uItemState |= 1;
            OS.MoveMemory(lParam, nmcd, NMLVCUSTOMDRAW.sizeof);
        }
        boolean bl2 = firstColumn = (long)nmcd.iSubItem == OS.SendMessage(this.hwndHeader, 4623, 0L, 0L);
        if (this.ignoreDrawForeground && this.ignoreDrawHot && !drawDrophilited && !this.ignoreDrawBackground && drawBackground) {
            RECT backgroundRect = item.getBounds((int)nmcd.dwItemSpec, nmcd.iSubItem, true, false, true, false, hDC);
            this.fillBackground(hDC, clrTextBk, backgroundRect);
        }
        this.focusRect = null;
        if (!this.ignoreDrawHot || !this.ignoreDrawSelection || !this.ignoreDrawFocus || drawDrophilited) {
            boolean fullText = (this.style & 0x10000) != 0 || !firstColumn;
            RECT textRect = item.getBounds((int)nmcd.dwItemSpec, nmcd.iSubItem, true, false, fullText, false, hDC);
            if ((this.style & 0x10000) == 0) {
                if (measureEvent != null) {
                    Rectangle boundInPixels = measureEvent.getBoundsInPixels();
                    textRect.right = Math.min(cellRect.right, boundInPixels.x + boundInPixels.width);
                }
                if (!this.ignoreDrawFocus) {
                    nmcd.uItemState &= 0xFFFFFFEF;
                    OS.MoveMemory(lParam, nmcd, NMLVCUSTOMDRAW.sizeof);
                    this.focusRect = textRect;
                }
            }
            if (this.explorerTheme) {
                if (!this.ignoreDrawHot || drawDrophilited || !this.ignoreDrawSelection && clrSelectionBk != -1) {
                    int iStateId;
                    RECT pClipRect = new RECT();
                    OS.SetRect(pClipRect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                    RECT rect = new RECT();
                    OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                    if ((this.style & 0x10000) != 0) {
                        int count = (int)OS.SendMessage(this.hwndHeader, 4608, 0L, 0L);
                        int index = (int)OS.SendMessage(this.hwndHeader, 4623, (long)(count - 1), 0L);
                        RECT headerRect = new RECT();
                        OS.SendMessage(this.hwndHeader, 4615, (long)index, headerRect);
                        OS.MapWindowPoints(this.hwndHeader, this.handle, headerRect, 2);
                        rect.right = headerRect.right;
                        index = (int)OS.SendMessage(this.hwndHeader, 4623, 0L, 0L);
                        OS.SendMessage(this.hwndHeader, 4615, (long)index, headerRect);
                        OS.MapWindowPoints(this.hwndHeader, this.handle, headerRect, 2);
                        rect.left = headerRect.left;
                        pClipRect.left = cellRect.left;
                        pClipRect.right += 2;
                    } else {
                        rect.right += 2;
                        pClipRect.right += 2;
                    }
                    long hTheme = OS.OpenThemeData(this.handle, Display.LISTVIEW);
                    int n3 = iStateId = selected ? 3 : 2;
                    if (OS.GetFocus() != this.handle && selected && !drawHot) {
                        iStateId = 5;
                    }
                    if (drawDrophilited) {
                        iStateId = 3;
                    }
                    OS.DrawThemeBackground(hTheme, hDC, 1, iStateId, rect, pClipRect);
                    OS.CloseThemeData(hTheme);
                }
            } else if (!this.ignoreDrawSelection && clrSelectionBk != -1) {
                this.fillBackground(hDC, clrSelectionBk, textRect);
            }
        }
        if (focused && this.ignoreDrawFocus) {
            nmcd.uItemState &= 0xFFFFFFEF;
            OS.MoveMemory(lParam, nmcd, NMLVCUSTOMDRAW.sizeof);
        }
        if (this.ignoreDrawForeground) {
            RECT clipRect = item.getBounds((int)nmcd.dwItemSpec, nmcd.iSubItem, true, true, true, false, hDC);
            OS.SaveDC(hDC);
            OS.SelectClipRgn(hDC, 0L);
            OS.ExcludeClipRect(hDC, clipRect.left, clipRect.top, clipRect.right, clipRect.bottom);
        }
    }

    Event sendEraseItemEvent(TableItem item, NMTTCUSTOMDRAW nmcd, int column, RECT cellRect) {
        int nSavedDC = OS.SaveDC(nmcd.hdc);
        RECT insetRect = this.toolTipInset(cellRect);
        OS.SetWindowOrgEx(nmcd.hdc, insetRect.left, insetRect.top, null);
        GCData data = new GCData();
        data.device = this.display;
        data.foreground = OS.GetTextColor(nmcd.hdc);
        data.background = OS.GetBkColor(nmcd.hdc);
        data.font = item.getFont(column);
        data.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        GC gc = GC.win32_new(nmcd.hdc, data);
        Event event = new Event();
        event.item = item;
        event.index = column;
        event.gc = gc;
        event.detail |= 0x10;
        event.setBoundsInPixels(new Rectangle(cellRect.left, cellRect.top, cellRect.right - cellRect.left, cellRect.bottom - cellRect.top));
        this.sendEvent(40, event);
        event.gc = null;
        gc.dispose();
        OS.RestoreDC(nmcd.hdc, nSavedDC);
        return event;
    }

    Event sendMeasureItemEvent(TableItem item, int row, int column, long hDC) {
        GCData data = new GCData();
        data.device = this.display;
        data.font = item.getFont(column);
        int nSavedDC = OS.SaveDC(hDC);
        GC gc = GC.win32_new(hDC, data);
        RECT itemRect = item.getBounds(row, column, true, true, false, false, hDC);
        Event event = new Event();
        event.item = item;
        event.gc = gc;
        event.index = column;
        event.setBoundsInPixels(new Rectangle(itemRect.left, itemRect.top, itemRect.right - itemRect.left, itemRect.bottom - itemRect.top));
        boolean drawSelected = false;
        if (OS.IsWindowEnabled(this.handle)) {
            boolean selected;
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 8;
            lvItem.stateMask = 2;
            lvItem.iItem = row;
            long result = OS.SendMessage(this.handle, 4171, 0L, lvItem);
            boolean bl = selected = result != 0L && (lvItem.state & 2) != 0;
            if (selected && (column == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    drawSelected = true;
                } else {
                    boolean bl2 = drawSelected = (this.style & 0x8000) == 0;
                }
            }
        }
        if (drawSelected) {
            event.detail |= 2;
        }
        this.sendEvent(41, event);
        event.gc = null;
        gc.dispose();
        OS.RestoreDC(hDC, nSavedDC);
        if (!this.isDisposed() && !item.isDisposed()) {
            int width;
            Rectangle boundsInPixels = event.getBoundsInPixels();
            if (this.columnCount == 0 && boundsInPixels.x + boundsInPixels.width > (width = (int)OS.SendMessage(this.handle, 4125, 0L, 0L))) {
                this.setScrollWidth(boundsInPixels.x + boundsInPixels.width);
            }
            long empty = OS.SendMessage(this.handle, 4160, 0L, 0L);
            long oneItem = OS.SendMessage(this.handle, 4160, 1L, 0L);
            int itemHeight = OS.HIWORD(oneItem) - OS.HIWORD(empty);
            if (!this.settingItemHeight && boundsInPixels.height > itemHeight) {
                this.settingItemHeight = true;
                this.setItemHeight(boundsInPixels.height);
                this.settingItemHeight = false;
            }
        }
        return event;
    }

    LRESULT sendMouseDownEvent(int type, int button, int msg, long wParam, long lParam) {
        boolean dragDetect;
        Display display = this.display;
        display.captureChanged = false;
        if (!this.sendMouseEvent(type, button, this.handle, msg, wParam, lParam)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = OS.GET_X_LPARAM(lParam);
        pinfo.y = OS.GET_Y_LPARAM(lParam);
        OS.SendMessage(this.handle, 4114, 0L, pinfo);
        if ((this.style & 0x10000) == 0 && this.hooks(41)) {
            if (OS.SendMessage(this.handle, 4153, 0L, pinfo) < 0L) {
                int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
                if (count != 0) {
                    RECT rect = new RECT();
                    rect.left = 1;
                    this.ignoreCustomDraw = true;
                    long code = OS.SendMessage(this.handle, 4110, 0L, rect);
                    this.ignoreCustomDraw = false;
                    if (code != 0L) {
                        pinfo.x = rect.left;
                        OS.SendMessage(this.handle, 4153, 0L, pinfo);
                        if (pinfo.iItem < 0) {
                            pinfo.iItem = -1;
                        }
                        pinfo.flags &= 0xFFFFFFF9;
                    }
                }
            } else if (pinfo.iSubItem != 0) {
                pinfo.iItem = -1;
            }
        }
        OS.SetFocus(this.handle);
        if (((this.style & 4) != 0 || this.hooks(3) || this.hooks(4)) && pinfo.iItem == -1) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        boolean forceSelect = false;
        int count = (int)OS.SendMessage(this.handle, 4146, 0L, 0L);
        if (count == 1 && pinfo.iItem != -1) {
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 8;
            lvItem.stateMask = 2;
            lvItem.iItem = pinfo.iItem;
            OS.SendMessage(this.handle, 4171, 0L, lvItem);
            if ((lvItem.state & 2) != 0) {
                forceSelect = true;
            }
        }
        this.fullRowSelect = false;
        if (pinfo.iItem != -1 && (this.style & 0x10000) == 0 && this.hooks(41)) {
            int flags;
            this.fullRowSelect = this.hitTestSelection(pinfo.iItem, pinfo.x, pinfo.y);
            if (this.fullRowSelect && (pinfo.flags & (flags = 6)) != 0) {
                this.fullRowSelect = false;
            }
        }
        boolean bl = dragDetect = (this.state & 0x8000) != 0 && this.hooks(29);
        if (!dragDetect) {
            int flags = 6;
            boolean bl2 = dragDetect = pinfo.iItem == -1 || (pinfo.flags & flags) == 0;
            if (this.fullRowSelect) {
                dragDetect = true;
            }
        }
        if (this.fullRowSelect) {
            OS.UpdateWindow(this.handle);
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
            OS.SendMessage(this.handle, 4150, 32L, 32L);
        }
        this.dragStarted = false;
        display.dragCancelled = false;
        if (!dragDetect) {
            display.runDragDrop = false;
        }
        long code = this.callWindowProc(this.handle, msg, wParam, lParam, forceSelect);
        if (!dragDetect) {
            display.runDragDrop = true;
        }
        if (this.fullRowSelect) {
            this.fullRowSelect = false;
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            OS.SendMessage(this.handle, 4150, 32L, 0L);
        }
        if (this.dragStarted || display.dragCancelled) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
        } else {
            boolean fakeMouseUp;
            int flags = 6;
            boolean bl3 = fakeMouseUp = (pinfo.flags & flags) != 0;
            if (!fakeMouseUp && (this.style & 2) != 0) {
                boolean bl4 = fakeMouseUp = (pinfo.flags & 8) == 0;
            }
            if (fakeMouseUp) {
                this.sendMouseEvent(4, button, this.handle, msg, wParam, lParam);
            }
        }
        return new LRESULT(code);
    }

    void sendPaintItemEvent(TableItem item, NMLVCUSTOMDRAW nmcd) {
        int uiState;
        long hDC = nmcd.hdc;
        GCData data = new GCData();
        data.device = this.display;
        data.font = item.getFont(nmcd.iSubItem);
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        lvItem.iItem = (int)nmcd.dwItemSpec;
        long result = OS.SendMessage(this.handle, 4171, 0L, lvItem);
        boolean selected = result != 0L && (lvItem.state & 2) != 0;
        boolean drawSelected = false;
        boolean drawBackground = false;
        boolean drawHot = false;
        if (nmcd.iSubItem == 0 || (this.style & 0x10000) != 0) {
            boolean bl = drawHot = (long)this.hotIndex == nmcd.dwItemSpec;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            int clrText;
            if (selected && (nmcd.iSubItem == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    drawSelected = true;
                    data.foreground = this.selectionForeground != -1 ? this.selectionForeground : OS.GetSysColor(14);
                    data.background = OS.GetSysColor(13);
                } else {
                    drawSelected = (this.style & 0x8000) == 0;
                    data.foreground = OS.GetTextColor(hDC);
                    data.background = OS.GetSysColor(15);
                }
                if (this.explorerTheme && this.selectionForeground == -1) {
                    int n = clrText = item.cellForeground != null ? item.cellForeground[nmcd.iSubItem] : -1;
                    if (clrText == -1) {
                        clrText = item.foreground;
                    }
                    data.foreground = clrText != -1 ? clrText : this.getForegroundPixel();
                }
            } else {
                int clrTextBk;
                int n = clrText = item.cellForeground != null ? item.cellForeground[nmcd.iSubItem] : -1;
                if (clrText == -1) {
                    clrText = item.foreground;
                }
                int n2 = clrTextBk = item.cellBackground != null ? item.cellBackground[nmcd.iSubItem] : -1;
                if (clrTextBk == -1) {
                    clrTextBk = item.background;
                }
                boolean bl = drawBackground = clrTextBk != -1;
                if (clrText == -1 || clrTextBk == -1) {
                    Control control = this.findBackgroundControl();
                    if (control == null) {
                        control = this;
                    }
                    if (clrText == -1) {
                        clrText = control.getForegroundPixel();
                    }
                    if (clrTextBk == -1) {
                        clrTextBk = control.getBackgroundPixel();
                    }
                }
                data.foreground = clrText != -1 ? clrText : OS.GetTextColor(hDC);
                data.background = clrTextBk != -1 ? clrTextBk : OS.GetBkColor(hDC);
            }
        } else {
            data.foreground = OS.GetSysColor(17);
            data.background = OS.GetSysColor(15);
        }
        data.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        int nSavedDC = OS.SaveDC(hDC);
        GC gc = GC.win32_new(hDC, data);
        RECT itemRect = item.getBounds((int)nmcd.dwItemSpec, nmcd.iSubItem, true, true, false, false, hDC);
        Event event = new Event();
        event.item = item;
        event.gc = gc;
        event.index = nmcd.iSubItem;
        event.detail |= 0x10;
        if (OS.SendMessage(this.handle, 4108, -1L, 1L) == nmcd.dwItemSpec && (nmcd.iSubItem == 0 || (this.style & 0x10000) != 0) && this.handle == OS.GetFocus() && ((uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) == 0) {
            event.detail |= 4;
        }
        if (drawHot) {
            event.detail |= 0x20;
        }
        if (drawSelected) {
            event.detail |= 2;
        }
        if (drawBackground) {
            event.detail |= 8;
        }
        event.setBoundsInPixels(new Rectangle(itemRect.left, itemRect.top, itemRect.right - itemRect.left, itemRect.bottom - itemRect.top));
        RECT cellRect = item.getBounds((int)nmcd.dwItemSpec, nmcd.iSubItem, true, true, true, true, hDC);
        int cellWidth = cellRect.right - cellRect.left;
        int cellHeight = cellRect.bottom - cellRect.top;
        gc.setClipping(DPIUtil.autoScaleDown(new Rectangle(cellRect.left, cellRect.top, cellWidth, cellHeight)));
        this.sendEvent(42, event);
        if (data.focusDrawn) {
            this.focusRect = null;
        }
        event.gc = null;
        gc.dispose();
        OS.RestoreDC(hDC, nSavedDC);
    }

    Event sendPaintItemEvent(TableItem item, NMTTCUSTOMDRAW nmcd, int column, RECT itemRect) {
        int nSavedDC = OS.SaveDC(nmcd.hdc);
        RECT insetRect = this.toolTipInset(itemRect);
        OS.SetWindowOrgEx(nmcd.hdc, insetRect.left, insetRect.top, null);
        GCData data = new GCData();
        data.device = this.display;
        data.font = item.getFont(column);
        data.foreground = OS.GetTextColor(nmcd.hdc);
        data.background = OS.GetBkColor(nmcd.hdc);
        data.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        GC gc = GC.win32_new(nmcd.hdc, data);
        Event event = new Event();
        event.item = item;
        event.index = column;
        event.gc = gc;
        event.detail |= 0x10;
        event.setBoundsInPixels(new Rectangle(itemRect.left, itemRect.top, itemRect.right - itemRect.left, itemRect.bottom - itemRect.top));
        this.sendEvent(42, event);
        event.gc = null;
        gc.dispose();
        OS.RestoreDC(nmcd.hdc, nSavedDC);
        return event;
    }

    @Override
    void setBackgroundImage(long hBitmap) {
        super.setBackgroundImage(hBitmap);
        if (hBitmap != 0L) {
            this.setBackgroundTransparent(true);
        } else if (!(this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            this.setBackgroundTransparent(false);
        }
    }

    @Override
    void setBackgroundPixel(int newPixel) {
        int oldPixel = (int)OS.SendMessage(this.handle, 4096, 0L, 0L);
        if (oldPixel != -1) {
            if (this.findImageControl() != null) {
                return;
            }
            if (newPixel == -1) {
                newPixel = this.defaultBackground();
            }
            if (oldPixel != newPixel) {
                OS.SendMessage(this.handle, 4097, 0L, newPixel);
                OS.SendMessage(this.handle, 4134, 0L, newPixel);
                if ((this.style & 0x20) != 0) {
                    this.fixCheckboxImageListColor(true);
                }
            }
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    void setBackgroundTransparent(boolean transparent) {
        int oldPixel = (int)OS.SendMessage(this.handle, 4096, 0L, 0L);
        if (transparent) {
            if (oldPixel != -1) {
                OS.SendMessage(this.handle, 4097, 0L, -1L);
                OS.SendMessage(this.handle, 4134, 0L, -1L);
                OS.InvalidateRect(this.handle, null, true);
                if (!this.explorerTheme && (this.style & 0x10000) != 0) {
                    int bits = 32;
                    OS.SendMessage(this.handle, 4150, (long)bits, 0L);
                }
                if ((this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed()) {
                    OS.SendMessage(this.handle, 4236, -1L, 0L);
                    OS.InvalidateRect(this.handle, null, true);
                }
            }
        } else if (oldPixel == -1) {
            int column;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                int newPixel = control.getBackgroundPixel();
                OS.SendMessage(this.handle, 4097, 0L, newPixel);
                OS.SendMessage(this.handle, 4134, 0L, newPixel);
                if ((this.style & 0x20) != 0) {
                    this.fixCheckboxImageListColor(true);
                }
                OS.InvalidateRect(this.handle, null, true);
            }
            if (!(this.explorerTheme || (this.style & 0x10000) == 0 || this.hooks(40) || this.hooks(42))) {
                int bits = 32;
                OS.SendMessage(this.handle, 4150, (long)bits, bits);
            }
            if ((this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && (column = this.indexOf(this.sortColumn)) != -1) {
                OS.SendMessage(this.handle, 4236, (long)column, 0L);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
    }

    @Override
    void setBoundsInPixels(int x, int y, int width, int height, int flags, boolean defer) {
        this.setDeferResize(true);
        super.setBoundsInPixels(x, y, width, height, flags, false);
        this.setDeferResize(false);
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length != 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        int[] oldOrder = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, (long)this.columnCount, oldOrder);
        boolean reorder = false;
        boolean[] seen = new boolean[this.columnCount];
        for (int i = 0; i < order.length; ++i) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(6);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (index == oldOrder[i]) continue;
            reorder = true;
        }
        if (reorder) {
            RECT[] oldRects = new RECT[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                oldRects[i] = new RECT();
                OS.SendMessage(this.hwndHeader, 4615, (long)i, oldRects[i]);
            }
            OS.SendMessage(this.handle, 4154, (long)order.length, order);
            OS.InvalidateRect(this.handle, null, true);
            TableColumn[] newColumns = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
            RECT newRect = new RECT();
            for (int i = 0; i < this.columnCount; ++i) {
                TableColumn column = newColumns[i];
                if (column.isDisposed()) continue;
                OS.SendMessage(this.hwndHeader, 4615, (long)i, newRect);
                if (newRect.left == oldRects[i].left) continue;
                column.updateToolTip(i);
                column.sendEvent(10);
            }
        }
    }

    void setCustomDraw(boolean customDraw) {
        if (this.customDraw == customDraw) {
            return;
        }
        if (!this.customDraw && customDraw && this.currentItem != null) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.customDraw = customDraw;
    }

    void setDeferResize(boolean defer) {
        if (defer) {
            if (this.resizeCount++ == 0) {
                this.wasResized = false;
                if ((this.hooks(41) || this.hooks(40) || this.hooks(42)) && this.drawCount++ == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.DefWindowProc(this.handle, 11, 0L, 0L);
                    OS.SendMessage(this.handle, 4097, 0L, 0xFFFFFFL);
                }
            }
        } else if (--this.resizeCount == 0) {
            if ((this.hooks(41) || this.hooks(40) || this.hooks(42)) && --this.drawCount == 0) {
                OS.SendMessage(this.handle, 4097, 0L, -1L);
                OS.DefWindowProc(this.handle, 11, 1L, 0L);
                int flags = 1157;
                OS.RedrawWindow(this.handle, null, 0L, flags);
            }
            if (this.wasResized) {
                this.wasResized = false;
                this.setResizeChildren(false);
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false, false);
                }
                this.setResizeChildren(true);
            }
        }
    }

    void setCheckboxImageList(int width, int height, boolean fixScroll) {
        int clrBackground;
        if ((this.style & 0x20) == 0) {
            return;
        }
        int count = 8;
        int flags = 32;
        if ((this.style & 0x4000000) != 0) {
            flags |= 0x2000;
        }
        if (!OS.IsAppThemed()) {
            flags |= 1;
        }
        long hStateList = OS.ImageList_Create(width, height, flags, count, count);
        long hDC = OS.GetDC(this.handle);
        long memDC = OS.CreateCompatibleDC(hDC);
        long hBitmap = OS.CreateCompatibleBitmap(hDC, width * count, height);
        long hOldBitmap = OS.SelectObject(memDC, hBitmap);
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, width * count, height);
        if (OS.IsAppThemed()) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            clrBackground = control.getBackgroundPixel();
        } else {
            clrBackground = 0x20000FF;
            if ((clrBackground & 0xFFFFFF) == OS.GetSysColor(5)) {
                clrBackground = 0x200FF00;
            }
        }
        long hBrush = OS.CreateSolidBrush(clrBackground);
        OS.FillRect(memDC, rect, hBrush);
        OS.DeleteObject(hBrush);
        long oldFont = OS.SelectObject(hDC, this.defaultFont());
        TEXTMETRIC tm = new TEXTMETRIC();
        OS.GetTextMetrics(hDC, tm);
        OS.SelectObject(hDC, oldFont);
        int itemWidth = Math.min(tm.tmHeight, width);
        int itemHeight = Math.min(tm.tmHeight, height);
        if (OS.IsAppThemed()) {
            SIZE size = new SIZE();
            OS.GetThemePartSize(this.display.hButtonTheme(), memDC, 3, 0, null, 1, size);
            itemWidth = Math.min(size.cx, itemWidth);
            itemHeight = Math.min(size.cy, itemHeight);
        }
        int left = (width - itemWidth) / 2;
        int top = (height - itemHeight) / 2;
        OS.SetRect(rect, left, top, left + itemWidth, top + itemHeight);
        if (OS.IsAppThemed()) {
            long hTheme = this.display.hButtonTheme();
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 5, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 9, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 4, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 8, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 4, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 12, rect, null);
        } else {
            OS.DrawFrameControl(memDC, rect, 4, 16384);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17408);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 16640);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17664);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 16384);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17408);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 16640);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17664);
        }
        OS.SelectObject(memDC, hOldBitmap);
        OS.DeleteDC(memDC);
        OS.ReleaseDC(this.handle, hDC);
        if (OS.IsAppThemed()) {
            OS.ImageList_Add(hStateList, hBitmap, 0L);
        } else {
            OS.ImageList_AddMasked(hStateList, hBitmap, clrBackground);
        }
        OS.DeleteObject(hBitmap);
        int topIndex = this.getTopIndex();
        if (fixScroll && topIndex != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        long hOldStateList = OS.SendMessage(this.handle, 4098, 2L, 0L);
        OS.SendMessage(this.handle, 4099, 2L, hStateList);
        if (hOldStateList != 0L) {
            OS.ImageList_Destroy(hOldStateList);
        }
        long hImageList = OS.SendMessage(this.handle, 4098, 1L, 0L);
        OS.SendMessage(this.handle, 4099, 1L, hImageList);
        if (fixScroll && topIndex != 0) {
            this.setTopIndex(topIndex);
            this.setRedraw(true);
        }
    }

    void setFocusIndex(int index) {
        if (index < 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.state = 1;
        lvItem.stateMask = 1;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, (long)index, lvItem);
        this.ignoreSelect = false;
        OS.SendMessage(this.handle, 4163, 0L, index);
    }

    @Override
    public void setFont(Font font) {
        int bits;
        this.checkWidget();
        int topIndex = this.getTopIndex();
        if (topIndex != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (this.itemHeight != -1) {
            bits = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, bits | 0x400);
        }
        super.setFont(font);
        if (this.itemHeight != -1) {
            bits = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, bits & 0xFFFFFBFF);
        }
        this.setScrollWidth(null, true);
        if (topIndex != 0) {
            this.setTopIndex(topIndex);
            this.setRedraw(true);
        }
        OS.InvalidateRect(this.hwndHeader, null, true);
    }

    @Override
    void setForegroundPixel(int pixel) {
        if (pixel == -1) {
            pixel = -16777216;
        }
        OS.SendMessage(this.handle, 4132, 0L, pixel);
        OS.InvalidateRect(this.handle, null, true);
        OS.InvalidateRect(this.hwndHeader, null, true);
    }

    public void setHeaderBackground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
        }
        if (pixel == this.headerBackground) {
            return;
        }
        this.headerBackground = pixel;
        if (this.getHeaderVisible()) {
            OS.InvalidateRect(this.hwndHeader, null, true);
        }
    }

    public void setHeaderForeground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
        }
        if (pixel == this.headerForeground) {
            return;
        }
        this.headerForeground = pixel;
        if (this.getHeaderVisible()) {
            OS.InvalidateRect(this.hwndHeader, null, true);
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        int newBits = OS.GetWindowLong(this.handle, -16);
        newBits &= 0xFFFFBFFF;
        if (!show) {
            newBits |= 0x4000;
        }
        int oldIndex = this.getTopIndex();
        OS.SetWindowLong(this.handle, -16, newBits);
        int newIndex = this.getTopIndex();
        if (newIndex != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        this.setTopIndex(oldIndex);
        if (newIndex != 0) {
            this.setRedraw(true);
        }
        this.updateHeaderToolTips();
    }

    public void setItemCount(int count) {
        int index;
        boolean isVirtual;
        this.checkWidget();
        count = Math.max(0, count);
        int itemCount = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (count == itemCount) {
            return;
        }
        this.setDeferResize(true);
        boolean bl = isVirtual = (this.style & 0x10000000) != 0;
        if (!isVirtual) {
            this.setRedraw(false);
        }
        for (index = count; index < itemCount; ++index) {
            TableItem item = this._getItem(index, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            if (isVirtual) continue;
            this.ignoreShrink = true;
            this.ignoreSelect = true;
            long code = OS.SendMessage(this.handle, 4104, (long)count, 0L);
            this.ignoreShrink = false;
            this.ignoreSelect = false;
            if (code == 0L) break;
        }
        if (index < itemCount) {
            this.error(15);
        }
        this._setItemCount(count, itemCount);
        if (isVirtual) {
            int flags = 3;
            OS.SendMessage(this.handle, 4143, (long)count, flags);
            if (count == 0 && itemCount != 0) {
                OS.InvalidateRect(this.handle, null, true);
            }
        } else {
            for (int i = itemCount; i < count; ++i) {
                new TableItem(this, 0, i, true);
            }
        }
        if (!isVirtual) {
            this.setRedraw(true);
        }
        if (itemCount == 0) {
            this.setScrollWidth(null, false);
        }
        this.setDeferResize(false);
    }

    void setItemHeight(boolean fixScroll) {
        int topIndex = this.getTopIndex();
        if (fixScroll && topIndex != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (this.itemHeight == -1) {
            long hFont = OS.SendMessage(this.handle, 49, 0L, 0L);
            OS.SendMessage(this.handle, 48, hFont, 0L);
        } else {
            this.forceResize();
            RECT rect = new RECT();
            OS.GetWindowRect(this.handle, rect);
            int width = rect.right - rect.left;
            int height = rect.bottom - rect.top;
            int bits = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, bits | 0x400);
            int flags = 30;
            this.ignoreResize = true;
            OS.SetWindowPos(this.handle, 0L, 0, 0, width, height + 1, flags);
            OS.SetWindowPos(this.handle, 0L, 0, 0, width, height, flags);
            this.ignoreResize = false;
            OS.SetWindowLong(this.handle, -16, bits);
        }
        if (fixScroll && topIndex != 0) {
            this.setTopIndex(topIndex);
            this.setRedraw(true);
        }
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
        if (itemHeight < -1) {
            this.error(5);
        }
        this.itemHeight = itemHeight;
        this.setItemHeight(true);
        this.setScrollWidth(null, true);
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        int newBits = show ? 1 : 0;
        OS.SendMessage(this.handle, 4150, 1L, newBits);
        OS.InvalidateRect(this.hwndHeader, null, true);
    }

    @Override
    public void setRedraw(boolean redraw) {
        int bits;
        this.checkWidget();
        if (this.drawCount == 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (redraw) {
            if (--this.drawCount == 0) {
                this.setScrollWidth(null, true);
                this.setDeferResize(true);
                OS.SendMessage(this.handle, 11, 1L, 0L);
                if (this.hwndHeader != 0L) {
                    OS.SendMessage(this.hwndHeader, 11, 1L, 0L);
                }
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(this.handle, 0);
                } else {
                    int flags = 1157;
                    OS.RedrawWindow(this.handle, null, 0L, flags);
                }
                this.setDeferResize(false);
            }
        } else if (this.drawCount++ == 0) {
            OS.SendMessage(this.handle, 11, 0L, 0L);
            if (this.hwndHeader != 0L) {
                OS.SendMessage(this.hwndHeader, 11, 0L, 0L);
            }
        }
    }

    void setScrollWidth(int width) {
        if (width != (int)OS.SendMessage(this.handle, 4125, 0L, 0L)) {
            boolean redraw = false;
            if (this.hooks(41)) {
                boolean bl = redraw = this.getDrawing() && OS.IsWindowVisible(this.handle);
            }
            if (redraw) {
                OS.DefWindowProc(this.handle, 11, 0L, 0L);
            }
            OS.SendMessage(this.handle, 4126, 0L, width);
            if (redraw) {
                OS.DefWindowProc(this.handle, 11, 1L, 0L);
                int flags = 1157;
                OS.RedrawWindow(this.handle, null, 0L, flags);
            }
        }
    }

    boolean setScrollWidth(TableItem item, boolean force) {
        if (this.currentItem != null) {
            if (this.currentItem != item) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        if (!(force || this.getDrawing() && OS.IsWindowVisible(this.handle))) {
            this.fixScrollWidth = true;
            return false;
        }
        this.fixScrollWidth = false;
        if (this.columnCount == 0) {
            long hImageList;
            long hStateList;
            int newWidth = 0;
            int imageIndent = 0;
            int itemCount = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            for (int index = 0; index < itemCount; ++index) {
                String string = null;
                long hFont = -1L;
                if (item != null) {
                    string = item.text;
                    imageIndent = Math.max(imageIndent, item.imageIndent);
                    hFont = item.fontHandle(0);
                } else {
                    TableItem tableItem = this._getItem(index, false);
                    if (tableItem != null) {
                        string = tableItem.text;
                        imageIndent = Math.max(imageIndent, tableItem.imageIndent);
                        hFont = tableItem.fontHandle(0);
                    }
                }
                if (string != null && string.length() != 0) {
                    if (hFont != -1L) {
                        long hDC = OS.GetDC(this.handle);
                        long oldFont = OS.SelectObject(hDC, hFont);
                        int flags = 3104;
                        char[] buffer = string.toCharArray();
                        RECT rect = new RECT();
                        OS.DrawText(hDC, buffer, buffer.length, rect, flags);
                        OS.SelectObject(hDC, oldFont);
                        OS.ReleaseDC(this.handle, hDC);
                        newWidth = Math.max(newWidth, rect.right - rect.left);
                    } else {
                        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
                        newWidth = Math.max(newWidth, (int)OS.SendMessage(this.handle, 4183, 0L, buffer));
                    }
                }
                if (item != null) break;
            }
            if (newWidth == 0) {
                char[] buffer = new char[]{' ', '\u0000'};
                newWidth = Math.max(newWidth, (int)OS.SendMessage(this.handle, 4183, 0L, buffer));
            }
            if ((hStateList = OS.SendMessage(this.handle, 4098, 2L, 0L)) != 0L) {
                int[] cx = new int[1];
                int[] cy = new int[1];
                OS.ImageList_GetIconSize(hStateList, cx, cy);
                newWidth += cx[0] + 4;
            }
            if ((hImageList = OS.SendMessage(this.handle, 4098, 1L, 0L)) != 0L) {
                int[] cx = new int[1];
                int[] cy = new int[1];
                OS.ImageList_GetIconSize(hImageList, cx, cy);
                newWidth += (imageIndent + 1) * cx[0];
            } else {
                ++newWidth;
            }
            int oldWidth = (int)OS.SendMessage(this.handle, 4125, 0L, 0L);
            if ((newWidth += 10) > oldWidth) {
                this.setScrollWidth(newWidth);
                return true;
            }
        }
        return false;
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices);
        int focusIndex = indices[0];
        if (focusIndex != -1) {
            this.setFocusIndex(focusIndex);
        }
        this.showSelection();
    }

    public void setSelection(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{item});
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int focusIndex = -1;
        for (int i = length - 1; i >= 0; --i) {
            int index = this.indexOf(items[i]);
            if (index == -1) continue;
            focusIndex = index;
            this.select(focusIndex);
        }
        if (focusIndex != -1) {
            this.setFocusIndex(focusIndex);
        }
        this.showSelection();
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.select(index);
        if (index != -1) {
            this.setFocusIndex(index);
        }
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        this.select(start, end);
        this.setFocusIndex(start);
        this.showSelection();
    }

    public void setSortColumn(TableColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = column;
        if (this.sortColumn != null && this.sortDirection != 0) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if ((direction & 0x480) == 0 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(direction);
        }
    }

    void setSubImagesVisible(boolean visible) {
        int dwExStyle = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
        if ((dwExStyle & 2) != 0 == visible) {
            return;
        }
        int bits = visible ? 2 : 0;
        OS.SendMessage(this.handle, 4150, 2L, bits);
    }

    void setTableEmpty() {
        if (this.imageList != null) {
            long hImageList = OS.ImageList_Create(1, 1, 0, 0, 0);
            OS.SendMessage(this.handle, 4099, 1L, hImageList);
            OS.SendMessage(this.handle, 4099, 1L, 0L);
            if (this.headerImageList != null) {
                long hHeaderImageList = this.headerImageList.getHandle();
                long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
                OS.SendMessage(hwndHeader, 4616, 0L, hHeaderImageList);
            }
            OS.ImageList_Destroy(hImageList);
            this.display.releaseImageList(this.imageList);
            this.imageList = null;
            if (this.itemHeight != -1) {
                this.setItemHeight(false);
            }
        }
        if (!(this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                this.setCustomDraw(false);
                this.setBackgroundTransparent(false);
            }
        }
        this._initItems();
        if (this.columnCount == 0) {
            OS.SendMessage(this.handle, 4126, 0L, 0L);
            this.setScrollWidth(null, false);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        int topIndex = (int)OS.SendMessage(this.handle, 4135, 0L, 0L);
        if (index == topIndex) {
            return;
        }
        if (!this.painted && this.hooks(41)) {
            this.hitTestSelection(index, 0, 0);
        }
        if (OS.SendMessage(this.handle, 4136, 0L, 0L) <= 0L) {
            OS.SendMessage(this.handle, 4115, (long)index, 1L);
            if ((long)index != OS.SendMessage(this.handle, 4135, 0L, 0L)) {
                OS.SendMessage(this.handle, 4115, (long)index, 1L);
            }
            return;
        }
        RECT rect = new RECT();
        rect.left = 0;
        this.ignoreCustomDraw = true;
        OS.SendMessage(this.handle, 4110, 0L, rect);
        this.ignoreCustomDraw = false;
        int dy = (index - topIndex) * (rect.bottom - rect.top);
        OS.SendMessage(this.handle, 4116, 0L, dy);
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (0 > index || index >= this.columnCount) {
            return;
        }
        RECT itemRect = new RECT();
        itemRect.left = 0;
        if (index == 0) {
            itemRect.top = 1;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4152, -1L, itemRect);
            this.ignoreCustomDraw = false;
            itemRect.right = itemRect.left;
            int width = (int)OS.SendMessage(this.handle, 4125, 0L, 0L);
            itemRect.left = itemRect.right - width;
        } else {
            itemRect.top = index;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4152, -1L, itemRect);
            this.ignoreCustomDraw = false;
        }
        int oldPos = 0;
        if (this._getLinesVisible()) {
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = SCROLLINFO.sizeof;
            info.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, info);
            oldPos = info.nPos;
        }
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        if (itemRect.left < rect.left) {
            int dx = itemRect.left - rect.left;
            OS.SendMessage(this.handle, 4116, (long)dx, 0L);
        } else {
            int width = Math.min(rect.right - rect.left, itemRect.right - itemRect.left);
            if (itemRect.left + width > rect.right) {
                int dx = itemRect.left + width - rect.right;
                OS.SendMessage(this.handle, 4116, (long)dx, 0L);
            }
        }
        if (this._getLinesVisible()) {
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = SCROLLINFO.sizeof;
            info.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, info);
            int newPos = info.nPos;
            if (newPos < oldPos) {
                rect.right = oldPos - newPos + 1;
                OS.InvalidateRect(this.handle, rect, true);
            }
        }
    }

    void showItem(int index) {
        long counterPage;
        if (!this.painted && this.hooks(41)) {
            this.hitTestSelection(index, 0, 0);
        }
        if ((counterPage = OS.SendMessage(this.handle, 4136, 0L, 0L)) <= 0L) {
            OS.SendMessage(this.handle, 4115, (long)index, 1L);
            if ((long)index != OS.SendMessage(this.handle, 4135, 0L, 0L)) {
                OS.SendMessage(this.handle, 4115, (long)index, 1L);
            }
        } else {
            long topIndex = OS.SendMessage(this.handle, 4135, 0L, 0L);
            if (topIndex > (long)index || (long)index >= topIndex + counterPage) {
                OS.SendMessage(this.handle, 4115, (long)index, 0L);
            }
        }
    }

    public void showItem(TableItem item) {
        int index;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((index = this.indexOf(item)) != -1) {
            this.showItem(index);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int index = (int)OS.SendMessage(this.handle, 4108, -1L, 2L);
        if (index != -1) {
            if (!(this.display.getActiveShell() != this.getShell() || (this.style & 0x10) != 0 || this.verticalBar != null && this.verticalBar.isVisible())) {
                this.showItem(0);
            } else {
                this.showItem(index);
            }
        }
    }

    void sort() {
        this.checkWidget();
    }

    @Override
    void subclass() {
        super.subclass();
        if (HeaderProc != 0L) {
            OS.SetWindowLongPtr(this.hwndHeader, -4, this.display.windowProc);
        }
    }

    RECT toolTipInset(RECT rect) {
        RECT insetRect = new RECT();
        OS.SetRect(insetRect, rect.left - 1, rect.top - 1, rect.right + 1, rect.bottom + 1);
        return insetRect;
    }

    RECT toolTipRect(RECT rect) {
        RECT toolRect = new RECT();
        OS.SetRect(toolRect, rect.left - 1, rect.top - 1, rect.right + 1, rect.bottom + 1);
        return toolRect;
    }

    @Override
    String toolTipText(NMTTDISPINFO hdr) {
        long hwndToolTip = OS.SendMessage(this.handle, 4174, 0L, 0L);
        if (hwndToolTip == hdr.hwndFrom && this.toolTipText != null) {
            return "";
        }
        if (this.headerToolTipHandle == hdr.hwndFrom) {
            for (int i = 0; i < this.columnCount; ++i) {
                TableColumn column = this.columns[i];
                if ((long)column.id != hdr.idFrom) continue;
                return column.toolTipText;
            }
        }
        return super.toolTipText(hdr);
    }

    @Override
    void unsubclass() {
        super.unsubclass();
        if (HeaderProc != 0L) {
            OS.SetWindowLongPtr(this.hwndHeader, -4, HeaderProc);
        }
    }

    @Override
    void update(boolean all) {
        long oldHeaderProc = 0L;
        long oldTableProc = 0L;
        boolean fixSubclass = this.isOptimizedRedraw();
        if (fixSubclass) {
            oldTableProc = OS.SetWindowLongPtr(this.handle, -4, TableProc);
            oldHeaderProc = OS.SetWindowLongPtr(this.hwndHeader, -4, HeaderProc);
        }
        super.update(all);
        if (fixSubclass) {
            OS.SetWindowLongPtr(this.handle, -4, oldTableProc);
            OS.SetWindowLongPtr(this.hwndHeader, -4, oldHeaderProc);
        }
    }

    void updateHeaderToolTips() {
        if (this.headerToolTipHandle == 0L) {
            return;
        }
        long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
        RECT rect = new RECT();
        TOOLINFO lpti = new TOOLINFO();
        lpti.cbSize = TOOLINFO.sizeof;
        lpti.uFlags = 16;
        lpti.hwnd = hwndHeader;
        lpti.lpszText = -1L;
        for (int i = 0; i < this.columnCount; ++i) {
            TableColumn column = this.columns[i];
            if (OS.SendMessage(hwndHeader, 4615, (long)i, rect) == 0L) continue;
            ++this.display.nextToolTipId;
            column.id = column.id;
            lpti.uId = column.id;
            lpti.left = rect.left;
            lpti.top = rect.top;
            lpti.right = rect.right;
            lpti.bottom = rect.bottom;
            OS.SendMessage(this.headerToolTipHandle, 1074, 0L, lpti);
        }
    }

    @Override
    void updateMenuLocation(Event event) {
        Rectangle clientArea = this.getClientAreaInPixels();
        int x = clientArea.x;
        int y = clientArea.y;
        int focusIndex = this.getFocusIndex();
        if (focusIndex != -1) {
            TableItem focusItem = this.getItem(focusIndex);
            Rectangle bounds = focusItem.getBoundsInPixels(0);
            if (focusItem.text != null && focusItem.text.length() != 0) {
                bounds = focusItem.getBoundsInPixels();
            }
            x = Math.max(x, bounds.x + bounds.width / 2);
            x = Math.min(x, clientArea.x + clientArea.width);
            y = Math.max(y, bounds.y + bounds.height);
            y = Math.min(y, clientArea.y + clientArea.height);
        }
        Point pt = this.toDisplayInPixels(x, y);
        event.setLocationInPixels(pt.x, pt.y);
    }

    void updateMoveable() {
        int index;
        for (index = 0; index < this.columnCount && !this.columns[index].moveable; ++index) {
        }
        int newBits = index < this.columnCount ? 16 : 0;
        OS.SendMessage(this.handle, 4150, 16L, newBits);
    }

    @Override
    void updateOrientation() {
        int index;
        super.updateOrientation();
        long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
        if (hwndHeader != 0L) {
            int bits = OS.GetWindowLong(hwndHeader, -20);
            bits = (this.style & 0x4000000) != 0 ? (bits |= 0x400000) : (bits &= 0xFFBFFFFF);
            OS.SetWindowLong(hwndHeader, -20, bits &= 0xFFFFDFFF);
            OS.InvalidateRect(hwndHeader, null, true);
            RECT rect = new RECT();
            OS.GetWindowRect(this.handle, rect);
            int width = rect.right - rect.left;
            int height = rect.bottom - rect.top;
            OS.SetWindowPos(this.handle, 0L, 0, 0, width - 1, height - 1, 6);
            OS.SetWindowPos(this.handle, 0L, 0, 0, width, height, 6);
        }
        if ((this.style & 0x20) != 0) {
            this.fixCheckboxImageListColor(false);
        }
        if (this.imageList != null) {
            Point size = this.imageList.getImageSize();
            this.display.releaseImageList(this.imageList);
            this.imageList = this.display.getImageList(this.style & 0x4000000, size.x, size.y);
            int count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            for (int i = 0; i < count; ++i) {
                Image image;
                TableItem item = this._getItem(i, false);
                if (item == null || (image = item.image) == null || (index = this.imageList.indexOf(image)) != -1) continue;
                this.imageList.add(image);
            }
            long hImageList = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4099, 1L, hImageList);
        }
        if (hwndHeader != 0L && this.headerImageList != null) {
            Point size = this.headerImageList.getImageSize();
            this.display.releaseImageList(this.headerImageList);
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, size.x, size.y);
            if (this.columns != null) {
                for (int i = 0; i < this.columns.length; ++i) {
                    Image image;
                    TableColumn column = this.columns[i];
                    if (column == null || (image = column.image) == null) continue;
                    LVCOLUMN lvColumn = new LVCOLUMN();
                    lvColumn.mask = 1;
                    OS.SendMessage(hwndHeader, 4191, (long)i, lvColumn);
                    if ((lvColumn.fmt & 0x800) == 0) continue;
                    index = this.headerImageList.indexOf(image);
                    if (index == -1) {
                        this.headerImageList.add(image);
                    }
                    lvColumn.iImage = index;
                    lvColumn.mask = 16;
                    OS.SendMessage(hwndHeader, 4192, (long)i, lvColumn);
                }
            }
            long hHeaderImageList = this.headerImageList.getHandle();
            OS.SendMessage(hwndHeader, 4616, 0L, hHeaderImageList);
        }
    }

    @Override
    boolean updateTextDirection(int textDirection) {
        if (super.updateTextDirection(textDirection)) {
            if (textDirection == 0x6000000 || (this.state & 0x400000) != 0) {
                for (TableItem item : this.items) {
                    if (item == null) continue;
                    item.updateTextDirection(textDirection == 0x6000000 ? 0x6000000 : this.style & Integer.MIN_VALUE);
                }
            }
            OS.InvalidateRect(this.handle, null, true);
            return true;
        }
        return false;
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle() | 0x40;
        if ((this.style & 0x8000) == 0) {
            bits |= 8;
        }
        if ((this.style & 4) != 0) {
            bits |= 4;
        }
        bits |= 0x4001;
        if ((this.style & 0x10000000) != 0) {
            bits |= 0x1000;
        }
        return bits;
    }

    @Override
    TCHAR windowClass() {
        return TableClass;
    }

    @Override
    long windowProc() {
        return TableProc;
    }

    @Override
    long windowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (hwnd != this.handle) {
            switch (msg) {
                case 123: {
                    LRESULT result = this.wmContextMenu(hwnd, wParam, lParam);
                    if (result == null) break;
                    return result.value;
                }
                case 675: {
                    this.updateHeaderToolTips();
                    this.updateHeaderToolTips();
                    break;
                }
                case 78: {
                    NMHDR hdr = new NMHDR();
                    OS.MoveMemory(hdr, lParam, NMHDR.sizeof);
                    switch (hdr.code) {
                        case -530: 
                        case -522: 
                        case -521: {
                            return OS.SendMessage(this.handle, msg, wParam, lParam);
                        }
                    }
                    break;
                }
                case 32: {
                    short hitTest;
                    if (wParam != hwnd || (hitTest = (short)OS.LOWORD(lParam)) != 1) break;
                    HDHITTESTINFO pinfo = new HDHITTESTINFO();
                    int pos = OS.GetMessagePos();
                    POINT pt = new POINT();
                    OS.POINTSTOPOINT(pt, pos);
                    OS.ScreenToClient(hwnd, pt);
                    pinfo.x = pt.x;
                    pinfo.y = pt.y;
                    long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
                    int index = (int)OS.SendMessage(hwndHeader, 4614, 0L, pinfo);
                    if (0 > index || index >= this.columnCount || this.columns[index].resizable || (pinfo.flags & 0xC) == 0) break;
                    OS.SetCursor(OS.LoadCursor(0L, 32512L));
                    return 1L;
                }
            }
            return this.callWindowProc(hwnd, msg, wParam, lParam);
        }
        if (msg == Display.DI_GETDRAGIMAGE) {
            int topIndex = (int)OS.SendMessage(this.handle, 4135, 0L, 0L);
            int selection = (int)OS.SendMessage(this.handle, 4108, (long)(topIndex - 1), 2L);
            if (selection == -1) {
                return 0L;
            }
            POINT mousePos = new POINT();
            OS.POINTSTOPOINT(mousePos, OS.GetMessagePos());
            OS.MapWindowPoints(0L, this.handle, mousePos, 1);
            RECT clientRect = new RECT();
            OS.GetClientRect(this.handle, clientRect);
            TableItem item = this._getItem(selection);
            RECT rect = item.getBounds(selection, 0, true, true, true);
            if ((this.style & 0x10000) != 0) {
                int width = 301;
                rect.left = Math.max(clientRect.left, mousePos.x - width / 2);
                if (clientRect.right > rect.left + width) {
                    rect.right = rect.left + width;
                } else {
                    rect.right = clientRect.right;
                    rect.left = Math.max(clientRect.left, rect.right - width);
                }
            }
            long hRgn = OS.CreateRectRgn(rect.left, rect.top, rect.right, rect.bottom);
            while ((selection = (int)OS.SendMessage(this.handle, 4108, (long)selection, 2L)) != -1 && rect.bottom - rect.top <= 301 && rect.bottom <= clientRect.bottom) {
                RECT itemRect = item.getBounds(selection, 0, true, true, true);
                long rectRgn = OS.CreateRectRgn(rect.left, itemRect.top, rect.right, itemRect.bottom);
                OS.CombineRgn(hRgn, hRgn, rectRgn, 2);
                OS.DeleteObject(rectRgn);
                rect.bottom = itemRect.bottom;
            }
            OS.GetRgnBox(hRgn, rect);
            long hdc = OS.GetDC(this.handle);
            long memHdc = OS.CreateCompatibleDC(hdc);
            BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
            bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
            bmiHeader.biWidth = rect.right - rect.left;
            bmiHeader.biHeight = -(rect.bottom - rect.top);
            bmiHeader.biPlanes = 1;
            bmiHeader.biBitCount = (short)32;
            bmiHeader.biCompression = 0;
            byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
            OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
            long[] pBits = new long[1];
            long memDib = OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
            if (memDib == 0L) {
                this.error(2);
            }
            long oldMemBitmap = OS.SelectObject(memHdc, memDib);
            int colorKey = 253;
            POINT pt = new POINT();
            OS.SetWindowOrgEx(memHdc, rect.left, rect.top, pt);
            OS.FillRect(memHdc, rect, this.findBrush(colorKey, 0));
            OS.OffsetRgn(hRgn, -rect.left, -rect.top);
            OS.SelectClipRgn(memHdc, hRgn);
            OS.PrintWindow(this.handle, memHdc, 0);
            OS.SetWindowOrgEx(memHdc, pt.x, pt.y, null);
            OS.SelectObject(memHdc, oldMemBitmap);
            OS.DeleteDC(memHdc);
            OS.ReleaseDC(0L, hdc);
            OS.DeleteObject(hRgn);
            SHDRAGIMAGE shdi = new SHDRAGIMAGE();
            shdi.hbmpDragImage = memDib;
            shdi.crColorKey = colorKey;
            shdi.sizeDragImage.cx = bmiHeader.biWidth;
            shdi.sizeDragImage.cy = -bmiHeader.biHeight;
            shdi.ptOffset.x = mousePos.x - rect.left;
            shdi.ptOffset.y = mousePos.y - rect.top;
            if ((this.style & 0x8000000) != 0) {
                shdi.ptOffset.x = shdi.sizeDragImage.cx - shdi.ptOffset.x;
            }
            OS.MoveMemory(lParam, shdi, SHDRAGIMAGE.sizeof);
            return 1L;
        }
        return super.windowProc(hwnd, msg, wParam, lParam);
    }

    @Override
    LRESULT WM_CHAR(long wParam, long lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch ((int)wParam) {
            case 32: {
                if ((this.style & 0x20) != 0) {
                    int index = -1;
                    while ((index = (int)OS.SendMessage(this.handle, 4108, (long)index, 2L)) != -1) {
                        TableItem item;
                        item.setChecked(!(item = this._getItem(index)).getChecked(), true);
                        OS.NotifyWinEvent(32773, this.handle, -4, index + 1);
                    }
                }
                long code = this.callWindowProc(this.handle, 256, wParam, lParam);
                return new LRESULT(code);
            }
            case 13: {
                int index = (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
                if (index != -1) {
                    Event event = new Event();
                    event.item = this._getItem(index);
                    this.sendSelectionEvent(14, event, false);
                }
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    @Override
    LRESULT WM_CONTEXTMENU(long wParam, long lParam) {
        if (!this.display.runDragDrop) {
            return LRESULT.ZERO;
        }
        return super.WM_CONTEXTMENU(wParam, lParam);
    }

    @Override
    LRESULT WM_ERASEBKGND(long wParam, long lParam) {
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if (this.findImageControl() != null) {
            return LRESULT.ONE;
        }
        return result;
    }

    @Override
    LRESULT WM_GETOBJECT(long wParam, long lParam) {
        if ((this.style & 0x20) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(wParam, lParam);
    }

    @Override
    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch ((int)wParam) {
            case 32: {
                return LRESULT.ZERO;
            }
            case 107: {
                int index;
                if (OS.GetKeyState(17) >= 0) break;
                for (index = 0; index < this.columnCount && this.columns[index].getResizable(); ++index) {
                }
                if (index == this.columnCount && !this.hooks(41)) break;
                TableColumn[] newColumns = new TableColumn[this.columnCount];
                System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
                for (TableColumn column : newColumns) {
                    if (column.isDisposed() || !column.getResizable()) continue;
                    column.pack();
                }
                return LRESULT.ZERO;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                long code;
                long oldHeaderProc = 0L;
                long oldTableProc = 0L;
                long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
                boolean fixSubclass = this.isOptimizedRedraw();
                if (fixSubclass) {
                    oldTableProc = OS.SetWindowLongPtr(this.handle, -4, TableProc);
                    oldHeaderProc = OS.SetWindowLongPtr(hwndHeader, -4, HeaderProc);
                }
                LRESULT lRESULT = result = (code = this.callWindowProc(this.handle, 256, wParam, lParam)) == 0L ? LRESULT.ZERO : new LRESULT(code);
                if (fixSubclass) {
                    OS.SetWindowLongPtr(this.handle, -4, oldTableProc);
                    OS.SetWindowLongPtr(hwndHeader, -4, oldHeaderProc);
                }
            }
            case 38: 
            case 40: {
                OS.SendMessage(this.handle, 295, 3L, 0L);
            }
        }
        return result;
    }

    @Override
    LRESULT WM_KILLFOCUS(long wParam, long lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if (this.imageList != null || (this.style & 0x20) != 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
        return result;
    }

    @Override
    LRESULT WM_LBUTTONDBLCLK(long wParam, long lParam) {
        TableItem item;
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = OS.GET_X_LPARAM(lParam);
        pinfo.y = OS.GET_Y_LPARAM(lParam);
        int index = (int)OS.SendMessage(this.handle, 4114, 0L, pinfo);
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
        if (!this.sendMouseEvent(8, 1, this.handle, 515, wParam, lParam)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        if (pinfo.iItem != -1) {
            this.callWindowProc(this.handle, 515, wParam, lParam);
        }
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if ((this.style & 0x20) != 0 && index != -1 && pinfo.flags == 8 && (item = this._getItem(index)) != null && !item.isDisposed()) {
            item.setChecked(!item.getChecked(), true);
            OS.NotifyWinEvent(32773, this.handle, -4, index + 1);
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        LRESULT result = this.sendMouseDownEvent(3, 1, 513, wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        if ((this.style & 0x20) != 0) {
            TableItem item;
            LVHITTESTINFO pinfo = new LVHITTESTINFO();
            pinfo.x = OS.GET_X_LPARAM(lParam);
            pinfo.y = OS.GET_Y_LPARAM(lParam);
            int index = (int)OS.SendMessage(this.handle, 4114, 0L, pinfo);
            if (index != -1 && pinfo.flags == 8 && (item = this._getItem(index)) != null && !item.isDisposed()) {
                item.setChecked(!item.getChecked(), true);
                OS.NotifyWinEvent(32773, this.handle, -4, index + 1);
            }
        }
        return result;
    }

    @Override
    LRESULT WM_MOUSEHOVER(long wParam, long lParam) {
        int mask;
        LRESULT result = super.WM_MOUSEHOVER(wParam, lParam);
        int bits = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
        if ((bits & (mask = 200)) != 0) {
            return result;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PAINT(long wParam, long lParam) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        this._checkShrink();
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        return super.WM_PAINT(wParam, lParam);
    }

    @Override
    LRESULT WM_RBUTTONDBLCLK(long wParam, long lParam) {
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = OS.GET_X_LPARAM(lParam);
        pinfo.y = OS.GET_Y_LPARAM(lParam);
        OS.SendMessage(this.handle, 4114, 0L, pinfo);
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 3, this.handle, 516, wParam, lParam);
        if (this.sendMouseEvent(8, 3, this.handle, 518, wParam, lParam) && pinfo.iItem != -1) {
            this.callWindowProc(this.handle, 518, wParam, lParam);
        }
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_RBUTTONDOWN(long wParam, long lParam) {
        return this.sendMouseDownEvent(3, 3, 516, wParam, lParam);
    }

    @Override
    LRESULT WM_SETFOCUS(long wParam, long lParam) {
        int count;
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if (this.imageList != null || (this.style & 0x20) != 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
        if ((count = (int)OS.SendMessage(this.handle, 4100, 0L, 0L)) == 0) {
            return result;
        }
        int index = (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
        if (index == -1) {
            LVITEM lvItem = new LVITEM();
            lvItem.state = 1;
            lvItem.stateMask = 1;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, 0L, lvItem);
            this.ignoreSelect = false;
        }
        return result;
    }

    @Override
    LRESULT WM_SETFONT(long wParam, long lParam) {
        LRESULT result = super.WM_SETFONT(wParam, lParam);
        if (result != null) {
            return result;
        }
        OS.SendMessage(this.hwndHeader, 48, 0L, lParam);
        if (this.headerToolTipHandle != 0L) {
            OS.SendMessage(this.headerToolTipHandle, 48, wParam, lParam);
        }
        return result;
    }

    @Override
    LRESULT WM_SETREDRAW(long wParam, long lParam) {
        LRESULT result = super.WM_SETREDRAW(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (wParam == 1L && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) != -1 && (this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            OS.SendMessage(this.handle, 4097, 0L, -1L);
        }
        OS.DefWindowProc(this.handle, 11, wParam, lParam);
        long code = this.callWindowProc(this.handle, 11, wParam, lParam);
        if (wParam == 0L && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1) {
            OS.SendMessage(this.handle, 4097, 0L, 0xFFFFFFL);
        }
        return code == 0L ? LRESULT.ZERO : new LRESULT(code);
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        if (this.ignoreResize) {
            return null;
        }
        if (this.hooks(40) || this.hooks(42)) {
            OS.InvalidateRect(this.handle, null, true);
        }
        if (this.resizeCount != 0) {
            this.wasResized = true;
            return null;
        }
        return super.WM_SIZE(wParam, lParam);
    }

    @Override
    LRESULT WM_SYSCOLORCHANGE(long wParam, long lParam) {
        LRESULT result = super.WM_SYSCOLORCHANGE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.findBackgroundControl() == null) {
            this.setBackgroundPixel(this.defaultBackground());
        } else {
            int oldPixel = (int)OS.SendMessage(this.handle, 4096, 0L, 0L);
            if (oldPixel != -1 && this.findImageControl() == null && (this.style & 0x20) != 0) {
                this.fixCheckboxImageListColor(true);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LRESULT WM_HSCROLL(long wParam, long lParam) {
        RECT rect;
        int rowCount;
        int oldPos = 0;
        if (this._getLinesVisible()) {
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = SCROLLINFO.sizeof;
            info.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, info);
            oldPos = info.nPos;
        }
        long oldHeaderProc = 0L;
        long oldTableProc = 0L;
        long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
        boolean fixSubclass = this.isOptimizedRedraw();
        if (fixSubclass) {
            oldTableProc = OS.SetWindowLongPtr(this.handle, -4, TableProc);
            oldHeaderProc = OS.SetWindowLongPtr(hwndHeader, -4, HeaderProc);
        }
        boolean fixScroll = false;
        if (OS.LOWORD(wParam) != 8 && this.columnCount > 32 && (rowCount = (int)OS.SendMessage(this.handle, 4136, 0L, 0L)) > 16) {
            boolean bl = fixScroll = this.getDrawing() && OS.IsWindowVisible(this.handle);
        }
        if (fixScroll) {
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
        }
        LRESULT result = super.WM_HSCROLL(wParam, lParam);
        if (fixScroll) {
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            int flags = 1157;
            OS.RedrawWindow(this.handle, null, 0L, flags);
            if (OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                RECT headerRect = new RECT();
                rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                boolean[] visible = new boolean[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    visible[i] = true;
                    headerRect.top = i;
                    headerRect.left = 0;
                    if (OS.SendMessage(this.handle, 4152, 0L, headerRect) == 0L) continue;
                    headerRect.top = rect.top;
                    headerRect.bottom = rect.bottom;
                    visible[i] = OS.IntersectRect(headerRect, rect, headerRect);
                }
                try {
                    this.columnVisible = visible;
                    OS.UpdateWindow(this.handle);
                }
                finally {
                    this.columnVisible = null;
                }
            }
        }
        if (fixSubclass) {
            OS.SetWindowLongPtr(this.handle, -4, oldTableProc);
            OS.SetWindowLongPtr(hwndHeader, -4, oldHeaderProc);
        }
        if (this._getLinesVisible()) {
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = SCROLLINFO.sizeof;
            info.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, info);
            int newPos = info.nPos;
            if (newPos < oldPos) {
                rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                rect.right = oldPos - newPos + 1;
                OS.InvalidateRect(this.handle, rect, true);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LRESULT WM_VSCROLL(long wParam, long lParam) {
        int rowCount;
        long oldHeaderProc = 0L;
        long oldTableProc = 0L;
        long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
        boolean fixSubclass = this.isOptimizedRedraw();
        if (fixSubclass) {
            oldTableProc = OS.SetWindowLongPtr(this.handle, -4, TableProc);
            oldHeaderProc = OS.SetWindowLongPtr(hwndHeader, -4, HeaderProc);
        }
        boolean fixScroll = false;
        if (OS.LOWORD(wParam) != 8 && this.columnCount > 32 && (rowCount = (int)OS.SendMessage(this.handle, 4136, 0L, 0L)) > 16) {
            boolean bl = fixScroll = this.getDrawing() && OS.IsWindowVisible(this.handle);
        }
        if (fixScroll) {
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
        }
        LRESULT result = super.WM_VSCROLL(wParam, lParam);
        if (fixScroll) {
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            int flags = 1157;
            OS.RedrawWindow(this.handle, null, 0L, flags);
            if (OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                RECT headerRect = new RECT();
                RECT rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                boolean[] visible = new boolean[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    visible[i] = true;
                    headerRect.top = i;
                    headerRect.left = 0;
                    if (OS.SendMessage(this.handle, 4152, 0L, headerRect) == 0L) continue;
                    headerRect.top = rect.top;
                    headerRect.bottom = rect.bottom;
                    visible[i] = OS.IntersectRect(headerRect, rect, headerRect);
                }
                try {
                    this.columnVisible = visible;
                    OS.UpdateWindow(this.handle);
                }
                finally {
                    this.columnVisible = null;
                }
            }
        }
        if (fixSubclass) {
            OS.SetWindowLongPtr(this.handle, -4, oldTableProc);
            OS.SetWindowLongPtr(hwndHeader, -4, oldHeaderProc);
        }
        if (this._getLinesVisible()) {
            int code = OS.LOWORD(wParam);
            switch (code) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 0: 
                case 1: {
                    RECT rect = new RECT();
                    OS.GetWindowRect(hwndHeader, rect);
                    int headerHeight = rect.bottom - rect.top;
                    RECT clientRect = new RECT();
                    OS.GetClientRect(this.handle, clientRect);
                    clientRect.top += headerHeight;
                    long empty = OS.SendMessage(this.handle, 4160, 0L, 0L);
                    long oneItem = OS.SendMessage(this.handle, 4160, 1L, 0L);
                    int itemHeight = OS.HIWORD(oneItem) - OS.HIWORD(empty);
                    if (code == 1) {
                        clientRect.top = clientRect.bottom - itemHeight - 1;
                    } else {
                        clientRect.bottom = clientRect.top + itemHeight + 1;
                    }
                    OS.InvalidateRect(this.handle, clientRect, true);
                    break;
                }
                case 2: 
                case 3: {
                    OS.InvalidateRect(this.handle, null, true);
                }
            }
        }
        return result;
    }

    @Override
    LRESULT wmMeasureChild(long wParam, long lParam) {
        MEASUREITEMSTRUCT struct = new MEASUREITEMSTRUCT();
        OS.MoveMemory(struct, lParam, MEASUREITEMSTRUCT.sizeof);
        if (this.itemHeight == -1) {
            long empty = OS.SendMessage(this.handle, 4160, 0L, 0L);
            long oneItem = OS.SendMessage(this.handle, 4160, 1L, 0L);
            struct.itemHeight = OS.HIWORD(oneItem) - OS.HIWORD(empty);
        } else {
            struct.itemHeight = this.itemHeight;
        }
        OS.MoveMemory(lParam, struct, MEASUREITEMSTRUCT.sizeof);
        return null;
    }

    @Override
    LRESULT wmNotify(NMHDR hdr, long wParam, long lParam) {
        LRESULT result;
        long hwndToolTip = OS.SendMessage(this.handle, 4174, 0L, 0L);
        if (hdr.hwndFrom == hwndToolTip && (result = this.wmNotifyToolTip(hdr, wParam, lParam)) != null) {
            return result;
        }
        if (hdr.hwndFrom == this.hwndHeader && (result = this.wmNotifyHeader(hdr, wParam, lParam)) != null) {
            return result;
        }
        return super.wmNotify(hdr, wParam, lParam);
    }

    @Override
    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -179: {
                if ((this.style & 0x10000000) == 0) break;
                return new LRESULT(-1L);
            }
            case -115: {
                boolean newSelected;
                if ((this.style & 0x10000000) == 0 || this.ignoreSelect) break;
                NMLVODSTATECHANGE lpStateChange = new NMLVODSTATECHANGE();
                OS.MoveMemory(lpStateChange, lParam, NMLVODSTATECHANGE.sizeof);
                boolean oldSelected = (lpStateChange.uOldState & 2) != 0;
                boolean bl = newSelected = (lpStateChange.uNewState & 2) != 0;
                if (oldSelected == newSelected) break;
                this.wasSelected = true;
                break;
            }
            case -177: {
                TableItem item;
                NMLVDISPINFO plvfi = new NMLVDISPINFO();
                OS.MoveMemory(plvfi, lParam, NMLVDISPINFO.sizeof);
                if (this.columnVisible != null && !this.columnVisible[plvfi.iSubItem] || (item = this._getItem(plvfi.iItem)) == null) break;
                if (this.ignoreShrink) {
                    if (OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                        RECT rect = new RECT();
                        rect.left = 0;
                        this.ignoreCustomDraw = true;
                        long code = OS.SendMessage(this.handle, 4110, (long)plvfi.iItem, rect);
                        this.ignoreCustomDraw = false;
                        if (code == 0L) break;
                        OS.InvalidateRect(this.handle, rect, true);
                        break;
                    }
                    if ((this.style & 0x10000000) != 0 && !item.cached) {
                        OS.SendMessage(this.handle, 4117, (long)plvfi.iItem, plvfi.iItem);
                        break;
                    }
                }
                if (!item.cached) {
                    if ((this.style & 0x10000000) != 0) {
                        TableItem newItem;
                        this.lastIndexOf = plvfi.iItem;
                        if (!this.checkData(item, this.lastIndexOf, false)) break;
                        TableItem tableItem = newItem = this.fixScrollWidth ? null : item;
                        if (this.setScrollWidth(newItem, true)) {
                            OS.InvalidateRect(this.handle, null, true);
                        }
                    }
                    item.cached = true;
                }
                if ((plvfi.mask & 1) != 0) {
                    String string = null;
                    if (plvfi.iSubItem == 0) {
                        string = item.text;
                    } else {
                        String[] strings = item.strings;
                        if (strings != null && plvfi.iSubItem < strings.length) {
                            string = strings[plvfi.iSubItem];
                        }
                    }
                    if (string != null) {
                        char[] buffer;
                        int length = Math.min(string.length(), Math.max(0, plvfi.cchTextMax - 1));
                        if (!this.tipRequested && plvfi.iSubItem == 0 && length == 0) {
                            string = " ";
                            length = 1;
                        }
                        if (length > 1 && (this.state & 0x400000) != 0) {
                            switch (BidiUtil.resolveTextDirection(string)) {
                                case 0x2000000: {
                                    string = '\u202a' + string;
                                    ++length;
                                    break;
                                }
                                case 0x4000000: {
                                    string = '\u202b' + string;
                                    ++length;
                                }
                            }
                        }
                        if ((buffer = this.display.tableBuffer) == null || plvfi.cchTextMax > buffer.length) {
                            buffer = this.display.tableBuffer = new char[plvfi.cchTextMax];
                        }
                        string.getChars(0, length, buffer, 0);
                        if (this.tipRequested) {
                            int shift = 0;
                            block26: for (int i = 0; i < length; ++i) {
                                switch (buffer[i]) {
                                    case '\n': 
                                    case '\r': {
                                        ++shift;
                                        continue block26;
                                    }
                                    default: {
                                        if (shift == 0) continue block26;
                                        buffer[i - shift] = buffer[i];
                                    }
                                }
                            }
                            length -= shift;
                        }
                        buffer[length++] = '\u0000';
                        OS.MoveMemory(plvfi.pszText, buffer, length * 2);
                    }
                }
                boolean move = false;
                if ((plvfi.mask & 2) != 0) {
                    Image image = null;
                    if (plvfi.iSubItem == 0) {
                        image = item.image;
                    } else {
                        Image[] images = item.images;
                        if (images != null && plvfi.iSubItem < images.length) {
                            image = images[plvfi.iSubItem];
                        }
                    }
                    if (image != null) {
                        plvfi.iImage = this.imageIndex(image, plvfi.iSubItem);
                        move = true;
                    }
                }
                if ((plvfi.mask & 8) != 0 && plvfi.iSubItem == 0) {
                    int state = 1;
                    if (item.checked) {
                        ++state;
                    }
                    if (item.grayed) {
                        state += 2;
                    }
                    if (!OS.IsWindowEnabled(this.handle)) {
                        state += 4;
                    }
                    plvfi.state = state << 12;
                    plvfi.stateMask = 61440;
                    move = true;
                }
                if ((plvfi.mask & 0x10) != 0 && plvfi.iSubItem == 0) {
                    plvfi.iIndent = item.imageIndent;
                    move = true;
                }
                if (!move) break;
                OS.MoveMemory(lParam, plvfi, NMLVDISPINFO.sizeof);
                break;
            }
            case -12: {
                long hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L);
                if (hdr.hwndFrom == hwndHeader || !this.customDraw && this.findImageControl() == null && OS.IsWindowEnabled(this.handle) && (!this.explorerTheme || this.columnCount != 0)) break;
                NMLVCUSTOMDRAW nmcd = new NMLVCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMLVCUSTOMDRAW.sizeof);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        return this.CDDS_PREPAINT(nmcd, wParam, lParam);
                    }
                    case 65537: {
                        return this.CDDS_ITEMPREPAINT(nmcd, wParam, lParam);
                    }
                    case 65538: {
                        return this.CDDS_ITEMPOSTPAINT(nmcd, wParam, lParam);
                    }
                    case 196609: {
                        return this.CDDS_SUBITEMPREPAINT(nmcd, wParam, lParam);
                    }
                    case 196610: {
                        return this.CDDS_SUBITEMPOSTPAINT(nmcd, wParam, lParam);
                    }
                    case 2: {
                        return this.CDDS_POSTPAINT(nmcd, wParam, lParam);
                    }
                }
                break;
            }
            case -156: {
                if ((this.style & 4) != 0) {
                    return LRESULT.ONE;
                }
                if (this.hooks(3) || this.hooks(4)) {
                    return LRESULT.ONE;
                }
                if ((this.style & 0x4000000) == 0 || this.findImageControl() == null) break;
                return LRESULT.ONE;
            }
            case -111: 
            case -109: {
                if (OS.GetKeyState(1) >= 0) break;
                this.dragStarted = true;
                if (hdr.code != -109) break;
                int pos = OS.GetMessagePos();
                POINT pt = new POINT();
                OS.POINTSTOPOINT(pt, pos);
                OS.ScreenToClient(this.handle, pt);
                this.sendDragEvent(1, pt.x, pt.y);
                break;
            }
            case -108: {
                NMLISTVIEW pnmlv = new NMLISTVIEW();
                OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                TableColumn column = this.columns[pnmlv.iSubItem];
                if (column == null) break;
                column.sendSelectionEvent(13);
                break;
            }
            case -114: {
                if (this.ignoreActivate) break;
                NMLISTVIEW pnmlv = new NMLISTVIEW();
                OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                if (pnmlv.iItem == -1) break;
                Event event = new Event();
                event.item = this._getItem(pnmlv.iItem);
                this.sendSelectionEvent(14, event, false);
                break;
            }
            case -101: {
                long hwndHeader;
                int count;
                if (this.fullRowSelect) {
                    this.fullRowSelect = false;
                    OS.DefWindowProc(this.handle, 11, 1L, 0L);
                    OS.SendMessage(this.handle, 4150, 32L, 0L);
                }
                if (!this.ignoreSelect) {
                    NMLISTVIEW pnmlv = new NMLISTVIEW();
                    OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                    if ((pnmlv.uChanged & 8) != 0) {
                        if (pnmlv.iItem == -1) {
                            this.wasSelected = true;
                        } else {
                            boolean newSelected;
                            boolean oldSelected = (pnmlv.uOldState & 2) != 0;
                            boolean bl = newSelected = (pnmlv.uNewState & 2) != 0;
                            if (oldSelected != newSelected) {
                                this.wasSelected = true;
                            }
                        }
                    }
                }
                if (!this.hooks(40) && !this.hooks(42) || (count = (int)OS.SendMessage(hwndHeader = OS.SendMessage(this.handle, 4127, 0L, 0L), 4608, 0L, 0L)) == 0) break;
                this.forceResize();
                RECT rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                NMLISTVIEW pnmlv = new NMLISTVIEW();
                OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                if (pnmlv.iItem == -1) break;
                RECT itemRect = new RECT();
                itemRect.left = 0;
                this.ignoreCustomDraw = true;
                OS.SendMessage(this.handle, 4110, (long)pnmlv.iItem, itemRect);
                this.ignoreCustomDraw = false;
                RECT headerRect = new RECT();
                int index = (int)OS.SendMessage(hwndHeader, 4623, (long)(count - 1), 0L);
                OS.SendMessage(hwndHeader, 4615, (long)index, headerRect);
                OS.MapWindowPoints(hwndHeader, this.handle, headerRect, 2);
                rect.left = headerRect.right;
                rect.top = itemRect.top;
                rect.bottom = itemRect.bottom;
                OS.InvalidateRect(this.handle, rect, true);
            }
        }
        return super.wmNotifyChild(hdr, wParam, lParam);
    }

    LRESULT wmNotifyHeader(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -326: 
            case -325: {
                if (this.columnCount == 0) {
                    return LRESULT.ONE;
                }
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                TableColumn column = this.columns[phdn.iItem];
                if (column != null && !column.getResizable()) {
                    return LRESULT.ONE;
                }
                this.ignoreColumnMove = true;
                if (hdr.code != -325 || column == null || !this.hooks(41)) break;
                column.pack();
                return LRESULT.ONE;
            }
            case -12: {
                NMCUSTOMDRAW nmcd = new NMCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMCUSTOMDRAW.sizeof);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        return new LRESULT(this.customHeaderDrawing() ? 48L : 0L);
                    }
                    case 65537: {
                        RECT rect = new RECT();
                        OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                        int pixel = this.getHeaderBackgroundPixel();
                        if ((nmcd.uItemState & 1) != 0) {
                            pixel = this.getDifferentColor(pixel);
                        } else if (this.columns[(int)nmcd.dwItemSpec] == this.sortColumn && this.sortDirection != 0) {
                            pixel = this.getSlightlyDifferentColor(pixel);
                        }
                        long brush = OS.CreateSolidBrush(pixel);
                        OS.FillRect(nmcd.hdc, rect, brush);
                        OS.DeleteObject(brush);
                        return new LRESULT(4L);
                    }
                    case 2: {
                        POINT cursorPos = new POINT();
                        OS.GetCursorPos(cursorPos);
                        OS.MapWindowPoints(0L, this.hwndHeader, cursorPos, 1);
                        int highlightedHeaderDividerX = -1;
                        int lastColumnRight = -1;
                        RECT[] rects = new RECT[this.columnCount];
                        for (int i = 0; i < this.columnCount; ++i) {
                            long oldPen;
                            long pen;
                            rects[i] = new RECT();
                            OS.SendMessage(this.hwndHeader, 4615, (long)i, rects[i]);
                            if (rects[i].right > lastColumnRight) {
                                lastColumnRight = rects[i].right;
                            }
                            if (this.columns[i] == this.sortColumn && this.sortDirection != 0) {
                                pen = OS.CreatePen(0, 1, this.getHeaderForegroundPixel());
                                oldPen = OS.SelectObject(nmcd.hdc, pen);
                                int center = rects[i].left + (rects[i].right - rects[i].left) / 2;
                                int leg = DPIUtil.autoScaleUpUsingNativeDPI(3);
                                if (this.sortDirection == 128) {
                                    OS.Polyline(nmcd.hdc, new int[]{center - leg, 1 + leg, center + 1, 0}, 2);
                                    OS.Polyline(nmcd.hdc, new int[]{center + leg, 1 + leg, center - 1, 0}, 2);
                                } else if (this.sortDirection == 1024) {
                                    OS.Polyline(nmcd.hdc, new int[]{center - leg, 1, center + 1, 1 + leg + 1}, 2);
                                    OS.Polyline(nmcd.hdc, new int[]{center + leg, 1, center - 1, 1 + leg + 1}, 2);
                                }
                                OS.SelectObject(nmcd.hdc, oldPen);
                                OS.DeleteObject(pen);
                            }
                            pen = OS.CreatePen(0, this.getGridLineWidthInPixels(), this.getSlightlyDifferentColor(this.getHeaderBackgroundPixel()));
                            oldPen = OS.SelectObject(nmcd.hdc, pen);
                            int alignmentCorrection = this._getLinesVisible() ? 0 : 1;
                            OS.Polyline(nmcd.hdc, new int[]{rects[i].right - alignmentCorrection, rects[i].top, rects[i].right - alignmentCorrection, rects[i].bottom}, 2);
                            OS.SelectObject(nmcd.hdc, oldPen);
                            OS.DeleteObject(pen);
                            pen = OS.CreatePen(0, this.getGridLineWidthInPixels(), OS.GetSysColor(15));
                            oldPen = OS.SelectObject(nmcd.hdc, pen);
                            OS.Polyline(nmcd.hdc, new int[]{rects[i].right - alignmentCorrection, rects[i].top, rects[i].right - alignmentCorrection, rects[i].bottom}, 2);
                            if (i == 0) {
                                OS.Polyline(nmcd.hdc, new int[]{nmcd.left, nmcd.bottom - 1, nmcd.right + 1, nmcd.bottom - 1}, 2);
                            }
                            OS.SelectObject(nmcd.hdc, oldPen);
                            OS.DeleteObject(pen);
                            if (this.headerItemDragging && highlightedHeaderDividerX == -1) {
                                int distanceToLeftBorder = cursorPos.x - rects[i].left;
                                int distanceToRightBorder = rects[i].right - cursorPos.x;
                                if (distanceToLeftBorder >= 0 && distanceToRightBorder >= 0) {
                                    highlightedHeaderDividerX = distanceToLeftBorder <= distanceToRightBorder ? rects[i].left - 1 : rects[i].right;
                                }
                            }
                            int x = rects[i].left + 4 + 2;
                            if (this.columns[i].image != null) {
                                GCData data = new GCData();
                                data.device = this.display;
                                GC gc = GC.win32_new(nmcd.hdc, data);
                                int y = Math.max(0, (nmcd.bottom - this.columns[i].image.getBoundsInPixels().height) / 2);
                                gc.drawImage(this.columns[i].image, DPIUtil.autoScaleDown(x), DPIUtil.autoScaleDown(y));
                                x += this.columns[i].image.getBoundsInPixels().width + 12;
                                gc.dispose();
                            }
                            if (this.columns[i].text == null) continue;
                            int flags = 2084;
                            if ((this.columns[i].style & 0x1000000) != 0) {
                                flags |= 1;
                            }
                            if ((this.columns[i].style & 0x20000) != 0) {
                                flags |= 2;
                            }
                            char[] buffer = this.columns[i].text.toCharArray();
                            OS.SetBkMode(nmcd.hdc, 1);
                            OS.SetTextColor(nmcd.hdc, this.getHeaderForegroundPixel());
                            RECT textRect = new RECT();
                            textRect.left = x;
                            textRect.top = rects[i].top;
                            textRect.right = rects[i].right - (x - rects[i].left);
                            textRect.bottom = rects[i].bottom;
                            OS.DrawText(nmcd.hdc, buffer, buffer.length, textRect, flags);
                        }
                        if (lastColumnRight < nmcd.right) {
                            RECT rect = new RECT();
                            OS.SetRect(rect, lastColumnRight += this._getLinesVisible() ? 1 : 0, nmcd.top, nmcd.right, nmcd.bottom - 1);
                            long brush = OS.CreateSolidBrush(this.getHeaderBackgroundPixel());
                            OS.FillRect(nmcd.hdc, rect, brush);
                            OS.DeleteObject(brush);
                        }
                        if (highlightedHeaderDividerX != -1) {
                            long pen = OS.CreatePen(0, 4, OS.GetSysColor(13));
                            long oldPen = OS.SelectObject(nmcd.hdc, pen);
                            OS.Polyline(nmcd.hdc, new int[]{highlightedHeaderDividerX, nmcd.top, highlightedHeaderDividerX, nmcd.bottom}, 2);
                            OS.SelectObject(nmcd.hdc, oldPen);
                            OS.DeleteObject(pen);
                        }
                        return new LRESULT(0L);
                    }
                }
                break;
            }
            case -16: {
                if (!this.ignoreColumnMove) {
                    for (int i = 0; i < this.columnCount; ++i) {
                        TableColumn column = this.columns[i];
                        column.updateToolTip(i);
                    }
                }
                this.ignoreColumnMove = false;
                break;
            }
            case -310: {
                TableColumn column;
                if (this.ignoreColumnMove) {
                    return LRESULT.ONE;
                }
                int bits = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
                if ((bits & 0x10) == 0) break;
                if (this.columnCount == 0) {
                    return LRESULT.ONE;
                }
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                if (phdn.iItem != -1 && (column = this.columns[phdn.iItem]) != null && !column.getMoveable()) {
                    this.ignoreColumnMove = true;
                    return LRESULT.ONE;
                }
                this.headerItemDragging = true;
                break;
            }
            case -311: {
                int index;
                this.headerItemDragging = false;
                int bits = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
                if ((bits & 0x10) == 0) break;
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                if (phdn.iItem == -1 || phdn.pitem == 0L) break;
                HDITEM pitem = new HDITEM();
                OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                if ((pitem.mask & 0x80) == 0 || pitem.iOrder == -1 || this.columnCount == 0) break;
                int[] order = new int[this.columnCount];
                OS.SendMessage(this.handle, 4155, (long)this.columnCount, order);
                for (index = 0; index < order.length && order[index] != phdn.iItem; ++index) {
                }
                if (index == order.length) {
                    index = 0;
                }
                if (index == pitem.iOrder) break;
                int start = Math.min(index, pitem.iOrder);
                int end = Math.max(index, pitem.iOrder);
                this.ignoreColumnMove = false;
                for (int i = start; i <= end; ++i) {
                    TableColumn column = this.columns[order[i]];
                    if (column.isDisposed()) continue;
                    column.postEvent(10);
                }
                break;
            }
            case -321: {
                TableColumn column;
                int width = (int)OS.SendMessage(this.handle, 4125, 0L, 0L);
                if (this.lastWidth == 0 && width > 0 && this._getLinesVisible()) {
                    RECT rect = new RECT();
                    OS.GetClientRect(this.handle, rect);
                    rect.right = rect.left + width;
                    OS.InvalidateRect(this.handle, rect, true);
                }
                this.lastWidth = width;
                if (this.ignoreColumnResize) break;
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                if (phdn.pitem == 0L) break;
                HDITEM pitem = new HDITEM();
                OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                if ((pitem.mask & 1) == 0 || (column = this.columns[phdn.iItem]) == null) break;
                column.updateToolTip(phdn.iItem);
                column.sendEvent(11);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                TableColumn[] newColumns = new TableColumn[this.columnCount];
                System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
                int[] order = new int[this.columnCount];
                OS.SendMessage(this.handle, 4155, (long)this.columnCount, order);
                boolean moved = false;
                for (int i = 0; i < this.columnCount; ++i) {
                    TableColumn nextColumn = newColumns[order[i]];
                    if (moved && !nextColumn.isDisposed()) {
                        nextColumn.updateToolTip(order[i]);
                        nextColumn.sendEvent(10);
                    }
                    if (nextColumn != column) continue;
                    moved = true;
                }
                break;
            }
            case -323: {
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                TableColumn column = this.columns[phdn.iItem];
                if (column == null) break;
                column.sendSelectionEvent(14);
                break;
            }
        }
        return null;
    }

    LRESULT wmNotifyToolTip(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -12: {
                if (this.toolTipText != null || !this.isCustomToolTip()) break;
                NMTTCUSTOMDRAW nmcd = new NMTTCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMTTCUSTOMDRAW.sizeof);
                return this.wmNotifyToolTip(nmcd, lParam);
            }
            case -530: 
            case -521: {
                LRESULT result = super.wmNotify(hdr, wParam, lParam);
                if (result != null) {
                    return result;
                }
                if (hdr.code != -521) {
                    this.tipRequested = true;
                }
                long code = this.callWindowProc(this.handle, 78, wParam, lParam);
                if (hdr.code != -521) {
                    this.tipRequested = false;
                }
                if (this.toolTipText != null) break;
                if (this.isCustomToolTip()) {
                    LVHITTESTINFO pinfo = new LVHITTESTINFO();
                    int pos = OS.GetMessagePos();
                    POINT pt = new POINT();
                    OS.POINTSTOPOINT(pt, pos);
                    OS.ScreenToClient(this.handle, pt);
                    pinfo.x = pt.x;
                    pinfo.y = pt.y;
                    if (OS.SendMessage(this.handle, 4153, 0L, pinfo) >= 0L) {
                        long hFont;
                        TableItem item = this._getItem(pinfo.iItem);
                        long hDC = OS.GetDC(this.handle);
                        long oldFont = 0L;
                        long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
                        if (newFont != 0L) {
                            oldFont = OS.SelectObject(hDC, newFont);
                        }
                        if ((hFont = item.fontHandle(pinfo.iSubItem)) != -1L) {
                            hFont = OS.SelectObject(hDC, hFont);
                        }
                        Event event = this.sendMeasureItemEvent(item, pinfo.iItem, pinfo.iSubItem, hDC);
                        if (!this.isDisposed() && !item.isDisposed()) {
                            RECT itemRect = new RECT();
                            Rectangle boundsInPixels = event.getBoundsInPixels();
                            OS.SetRect(itemRect, boundsInPixels.x, boundsInPixels.y, boundsInPixels.x + boundsInPixels.width, boundsInPixels.y + boundsInPixels.height);
                            if (hdr.code == -521) {
                                RECT toolRect = this.toolTipRect(itemRect);
                                OS.MapWindowPoints(this.handle, 0L, toolRect, 2);
                                long hwndToolTip = OS.SendMessage(this.handle, 4174, 0L, 0L);
                                int flags = 20;
                                int width = toolRect.right - toolRect.left;
                                int height = toolRect.bottom - toolRect.top;
                                OS.SetWindowPos(hwndToolTip, 0L, toolRect.left, toolRect.top, width, height, flags);
                            } else {
                                String string;
                                NMTTDISPINFO lpnmtdi = new NMTTDISPINFO();
                                OS.MoveMemory(lpnmtdi, lParam, NMTTDISPINFO.sizeof);
                                if (lpnmtdi.lpszText != 0L) {
                                    OS.MoveMemory(lpnmtdi.lpszText, new char[1], 2);
                                    OS.MoveMemory(lParam, lpnmtdi, NMTTDISPINFO.sizeof);
                                }
                                RECT cellRect = item.getBounds(pinfo.iItem, pinfo.iSubItem, true, true, true, true, hDC);
                                RECT clientRect = new RECT();
                                OS.GetClientRect(this.handle, clientRect);
                                if ((itemRect.right > cellRect.right || itemRect.right > clientRect.right) && (string = " ") != null) {
                                    Shell shell = this.getShell();
                                    char[] chars = new char[string.length() + 1];
                                    string.getChars(0, string.length(), chars, 0);
                                    shell.setToolTipText(lpnmtdi, chars);
                                    OS.MoveMemory(lParam, lpnmtdi, NMTTDISPINFO.sizeof);
                                }
                            }
                        }
                        if (hFont != -1L) {
                            hFont = OS.SelectObject(hDC, hFont);
                        }
                        if (newFont != 0L) {
                            OS.SelectObject(hDC, oldFont);
                        }
                        OS.ReleaseDC(this.handle, hDC);
                    }
                }
                return new LRESULT(code);
            }
        }
        return null;
    }

    LRESULT wmNotifyToolTip(NMTTCUSTOMDRAW nmcd, long lParam) {
        switch (nmcd.dwDrawStage) {
            case 1: {
                if (!this.isCustomToolTip()) break;
                return new LRESULT(18L);
            }
            case 2: {
                LVHITTESTINFO pinfo = new LVHITTESTINFO();
                int pos = OS.GetMessagePos();
                POINT pt = new POINT();
                OS.POINTSTOPOINT(pt, pos);
                OS.ScreenToClient(this.handle, pt);
                pinfo.x = pt.x;
                pinfo.y = pt.y;
                if (OS.SendMessage(this.handle, 4153, 0L, pinfo) < 0L) break;
                TableItem item = this._getItem(pinfo.iItem);
                long hDC = OS.GetDC(this.handle);
                long hFont = item.fontHandle(pinfo.iSubItem);
                if (hFont == -1L) {
                    hFont = OS.SendMessage(this.handle, 49, 0L, 0L);
                }
                long oldFont = OS.SelectObject(hDC, hFont);
                boolean drawForeground = true;
                RECT cellRect = item.getBounds(pinfo.iItem, pinfo.iSubItem, true, true, false, false, hDC);
                if (this.hooks(40)) {
                    Event event = this.sendEraseItemEvent(item, nmcd, pinfo.iSubItem, cellRect);
                    if (this.isDisposed() || item.isDisposed()) break;
                    drawForeground = event.doit ? (event.detail & 0x10) != 0 : false;
                }
                if (drawForeground) {
                    Image image;
                    int nSavedDC = OS.SaveDC(nmcd.hdc);
                    int gridWidth = this.getLinesVisible() ? 1 : 0;
                    RECT insetRect = this.toolTipInset(cellRect);
                    OS.SetWindowOrgEx(nmcd.hdc, insetRect.left, insetRect.top, null);
                    GCData data = new GCData();
                    data.device = this.display;
                    data.foreground = OS.GetTextColor(nmcd.hdc);
                    data.background = OS.GetBkColor(nmcd.hdc);
                    data.font = Font.win32_new(this.display, hFont);
                    GC gc = GC.win32_new(nmcd.hdc, data);
                    int x = cellRect.left;
                    if (pinfo.iSubItem != 0) {
                        x -= gridWidth;
                    }
                    if ((image = item.getImage(pinfo.iSubItem)) != null) {
                        Rectangle rect = image.getBoundsInPixels();
                        RECT imageRect = item.getBounds(pinfo.iItem, pinfo.iSubItem, false, true, false, false, hDC);
                        Point size = this.imageList == null ? new Point(rect.width, rect.height) : this.imageList.getImageSize();
                        int y = imageRect.top + Math.max(0, (imageRect.bottom - imageRect.top - size.y) / 2);
                        rect = DPIUtil.autoScaleDown(rect);
                        gc.drawImage(image, rect.x, rect.y, rect.width, rect.height, DPIUtil.autoScaleDown(x), DPIUtil.autoScaleDown(y), DPIUtil.autoScaleDown(size.x), DPIUtil.autoScaleDown(size.y));
                        x += size.x + 4 + (pinfo.iSubItem == 0 ? -2 : 4);
                    } else {
                        x += 6;
                    }
                    String string = item.getText(pinfo.iSubItem);
                    if (string != null) {
                        TableColumn column;
                        int flags = 2084;
                        TableColumn tableColumn = column = this.columns != null ? this.columns[pinfo.iSubItem] : null;
                        if (column != null) {
                            if ((column.style & 0x1000000) != 0) {
                                flags |= 1;
                            }
                            if ((column.style & 0x20000) != 0) {
                                flags |= 2;
                            }
                        }
                        char[] buffer = string.toCharArray();
                        RECT textRect = new RECT();
                        OS.SetRect(textRect, x, cellRect.top, cellRect.right, cellRect.bottom);
                        OS.DrawText(nmcd.hdc, buffer, buffer.length, textRect, flags);
                    }
                    gc.dispose();
                    OS.RestoreDC(nmcd.hdc, nSavedDC);
                }
                if (this.hooks(42)) {
                    RECT itemRect = item.getBounds(pinfo.iItem, pinfo.iSubItem, true, true, false, false, hDC);
                    this.sendPaintItemEvent(item, nmcd, pinfo.iSubItem, itemRect);
                }
                OS.SelectObject(hDC, oldFont);
                OS.ReleaseDC(this.handle, hDC);
            }
        }
        return null;
    }

    static {
        COMPRESS_ITEMS = true;
        TableClass = new TCHAR(0, "SysListView32", true);
        HeaderClass = new TCHAR(0, "SysHeader32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, TableClass, lpWndClass);
        TableProc = lpWndClass.lpfnWndProc;
        OS.GetClassInfo(0L, HeaderClass, lpWndClass);
        HeaderProc = lpWndClass.lpfnWndProc;
    }
}

