<p align="center">
  <a href="https://reactrouter.com/">
    <img alt="react-router" src="https://reactrouter.com/android-chrome-144x144.png" width="144">
  </a>
</p>

<h3 align="center">
  React Router
</h3>

<p align="center">
  Declarative routing for <a href="https://facebook.github.io/react">React</a>
</p>

<p align="center">
  <a href="https://www.npmjs.com/package/react-router"><img src="https://img.shields.io/npm/v/react-router?style=flat-square"></a>
  <a href="https://www.npmjs.com/package/react-router"><img src="https://img.shields.io/npm/dm/react-router?style=flat-square"></a>
  <a href="https://travis-ci.com/ReactTraining/react-router"><img src="https://img.shields.io/travis/com/ReactTraining/react-router/master?style=flat-square"></a>
</p>

**Note: You're currently viewing the `v5` branch for React Router version 4 and 5. You can find the source code for version 6 on [the `main` branch](https://github.com/remix-run/react-router).**

## Docs

**[View the docs for 4.x/5.x here](https://v5.reactrouter.com)**

[Migrating from 2.x/3.x?](/packages/react-router/docs/guides/migrating.md)

[3.x docs](https://github.com/remix-run/react-router/blob/v3/docs)

[2.x docs](https://github.com/remix-run/react-router/blob/v2.8.1/docs)

## Packages

This repository is a monorepo that we manage using [Lerna](https://github.com/lerna/lerna). That means that we actually publish [several packages](/packages) to npm from the same codebase, including:

| Package                                                | Version                                                                                                                             | Docs                                                                                                                                                                                                                                                           | Description                                                                        |
| ------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------- |
| [`react-router`](/packages/react-router)               | [![npm](https://img.shields.io/npm/v/react-router.svg?style=flat-square)](https://www.npmjs.com/package/react-router)               | [![](https://img.shields.io/badge/API%20Docs-site-green.svg?style=flat-square)](https://reactrouter.com/core/guides/quick-start) [![](https://img.shields.io/badge/API%20Docs-markdown-lightgrey.svg?style=flat-square)](/packages/react-router/docs)          | The core of React Router                                                           |
| [`react-router-dom`](/packages/react-router-dom)       | [![npm](https://img.shields.io/npm/v/react-router-dom.svg?style=flat-square)](https://www.npmjs.com/package/react-router-dom)       | [![](https://img.shields.io/badge/API%20Docs-site-green.svg?style=flat-square)](https://reactrouter.com/web/guides/quick-start) [![](https://img.shields.io/badge/API%20Docs-markdown-lightgrey.svg?style=flat-square)](/packages/react-router-dom/docs)       | DOM bindings for React Router                                                      |
| [`react-router-native`](/packages/react-router-native) | [![npm](https://img.shields.io/npm/v/react-router-native.svg?style=flat-square)](https://www.npmjs.com/package/react-router-native) | [![](https://img.shields.io/badge/API%20Docs-site-green.svg?style=flat-square)](https://reactrouter.com/native/guides/quick-start) [![](https://img.shields.io/badge/API%20Docs-markdown-lightgrey.svg?style=flat-square)](/packages/react-router-native/docs) | [React Native](https://facebook.github.io/react-native/) bindings for React Router |
| [`react-router-config`](/packages/react-router-config) | [![npm](https://img.shields.io/npm/v/react-router-config.svg?style=flat-square)](https://www.npmjs.com/package/react-router-config) | [![](https://img.shields.io/badge/API%20Docs-readme-orange.svg?style=flat-square)](/packages/react-router-config/#readme)                                                                                                                                      | Static route config helpers                                                        |

> **Redux users:** The [`react-router-redux` package](https://github.com/remix-run/react-router/tree/5345a820818c8d43ac923558670538a479ac2234/packages/react-router-redux) is now deprecated. See [Redux Integration](https://reactrouter.com/web/guides/deep-redux-integration) for a better approach.

## Changes

Detailed release notes for a given version can be found [on our releases page](https://github.com/remix-run/react-router/releases).

For change notes prior to version 4, please see [the CHANGES.md file](https://github.com/remix-run/react-router/blob/8365d4b2e91084265a1da7de911766169fb9e96e/CHANGES.md).

## Funding

You may provide financial support for this project by donating [via Open Collective](https://opencollective.com/react-router), attending [one of our workshops](https://reacttraining.com/workshops/), or purchasing [one of our online courses](https://reacttraining.com/courses/). Thank you for your support!

## About

React Router is developed and maintained by [Remix](https://remix.run) and many [amazing contributors](https://github.com/remix-run/react-router/graphs/contributors).
