package cmd

// Code generated by github.com/tinylib/msgp DO NOT EDIT.

import (
	"github.com/minio/minio/internal/bucket/replication"
	"github.com/tinylib/msgp/msgp"
)

// MarshalMsg implements msgp.Marshaler
func (z BackendType) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendInt(o, int(z))
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BackendType) UnmarshalMsg(bts []byte) (o []byte, err error) {
	{
		var zb0001 int
		zb0001, bts, err = msgp.ReadIntBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = BackendType(zb0001)
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z BackendType) Msgsize() (s int) {
	s = msgp.IntSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *BucketInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "Name"
	o = append(o, 0x85, 0xa4, 0x4e, 0x61, 0x6d, 0x65)
	o = msgp.AppendString(o, z.Name)
	// string "Created"
	o = append(o, 0xa7, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64)
	o = msgp.AppendTime(o, z.Created)
	// string "Deleted"
	o = append(o, 0xa7, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64)
	o = msgp.AppendTime(o, z.Deleted)
	// string "Versioning"
	o = append(o, 0xaa, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67)
	o = msgp.AppendBool(o, z.Versioning)
	// string "ObjectLocking"
	o = append(o, 0xad, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67)
	o = msgp.AppendBool(o, z.ObjectLocking)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BucketInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Name":
			z.Name, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Name")
				return
			}
		case "Created":
			z.Created, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Created")
				return
			}
		case "Deleted":
			z.Deleted, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Deleted")
				return
			}
		case "Versioning":
			z.Versioning, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Versioning")
				return
			}
		case "ObjectLocking":
			z.ObjectLocking, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ObjectLocking")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BucketInfo) Msgsize() (s int) {
	s = 1 + 5 + msgp.StringPrefixSize + len(z.Name) + 8 + msgp.TimeSize + 8 + msgp.TimeSize + 11 + msgp.BoolSize + 14 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *CompleteMultipartUpload) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "Parts"
	o = append(o, 0x81, 0xa5, 0x50, 0x61, 0x72, 0x74, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Parts)))
	for za0001 := range z.Parts {
		o, err = z.Parts[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Parts", za0001)
			return
		}
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CompleteMultipartUpload) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Parts":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Parts")
				return
			}
			if cap(z.Parts) >= int(zb0002) {
				z.Parts = (z.Parts)[:zb0002]
			} else {
				z.Parts = make([]CompletePart, zb0002)
			}
			for za0001 := range z.Parts {
				bts, err = z.Parts[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Parts", za0001)
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *CompleteMultipartUpload) Msgsize() (s int) {
	s = 1 + 6 + msgp.ArrayHeaderSize
	for za0001 := range z.Parts {
		s += z.Parts[za0001].Msgsize()
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *CompletePart) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 6
	// string "PartNumber"
	o = append(o, 0x86, 0xaa, 0x50, 0x61, 0x72, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72)
	o = msgp.AppendInt(o, z.PartNumber)
	// string "ETag"
	o = append(o, 0xa4, 0x45, 0x54, 0x61, 0x67)
	o = msgp.AppendString(o, z.ETag)
	// string "ChecksumCRC32"
	o = append(o, 0xad, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x43, 0x52, 0x43, 0x33, 0x32)
	o = msgp.AppendString(o, z.ChecksumCRC32)
	// string "ChecksumCRC32C"
	o = append(o, 0xae, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x43, 0x52, 0x43, 0x33, 0x32, 0x43)
	o = msgp.AppendString(o, z.ChecksumCRC32C)
	// string "ChecksumSHA1"
	o = append(o, 0xac, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x53, 0x48, 0x41, 0x31)
	o = msgp.AppendString(o, z.ChecksumSHA1)
	// string "ChecksumSHA256"
	o = append(o, 0xae, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36)
	o = msgp.AppendString(o, z.ChecksumSHA256)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CompletePart) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "PartNumber":
			z.PartNumber, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "PartNumber")
				return
			}
		case "ETag":
			z.ETag, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ETag")
				return
			}
		case "ChecksumCRC32":
			z.ChecksumCRC32, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumCRC32")
				return
			}
		case "ChecksumCRC32C":
			z.ChecksumCRC32C, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumCRC32C")
				return
			}
		case "ChecksumSHA1":
			z.ChecksumSHA1, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumSHA1")
				return
			}
		case "ChecksumSHA256":
			z.ChecksumSHA256, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumSHA256")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *CompletePart) Msgsize() (s int) {
	s = 1 + 11 + msgp.IntSize + 5 + msgp.StringPrefixSize + len(z.ETag) + 14 + msgp.StringPrefixSize + len(z.ChecksumCRC32) + 15 + msgp.StringPrefixSize + len(z.ChecksumCRC32C) + 13 + msgp.StringPrefixSize + len(z.ChecksumSHA1) + 15 + msgp.StringPrefixSize + len(z.ChecksumSHA256)
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *DeletedObjectInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "Bucket"
	o = append(o, 0x85, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	o = msgp.AppendString(o, z.Bucket)
	// string "Name"
	o = append(o, 0xa4, 0x4e, 0x61, 0x6d, 0x65)
	o = msgp.AppendString(o, z.Name)
	// string "ModTime"
	o = append(o, 0xa7, 0x4d, 0x6f, 0x64, 0x54, 0x69, 0x6d, 0x65)
	o = msgp.AppendTime(o, z.ModTime)
	// string "VersionID"
	o = append(o, 0xa9, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44)
	o = msgp.AppendString(o, z.VersionID)
	// string "IsLatest"
	o = append(o, 0xa8, 0x49, 0x73, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74)
	o = msgp.AppendBool(o, z.IsLatest)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DeletedObjectInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Bucket":
			z.Bucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Name":
			z.Name, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Name")
				return
			}
		case "ModTime":
			z.ModTime, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ModTime")
				return
			}
		case "VersionID":
			z.VersionID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "VersionID")
				return
			}
		case "IsLatest":
			z.IsLatest, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IsLatest")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *DeletedObjectInfo) Msgsize() (s int) {
	s = 1 + 7 + msgp.StringPrefixSize + len(z.Bucket) + 5 + msgp.StringPrefixSize + len(z.Name) + 8 + msgp.TimeSize + 10 + msgp.StringPrefixSize + len(z.VersionID) + 9 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ListMultipartsInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 11
	// string "KeyMarker"
	o = append(o, 0x8b, 0xa9, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendString(o, z.KeyMarker)
	// string "UploadIDMarker"
	o = append(o, 0xae, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x44, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendString(o, z.UploadIDMarker)
	// string "NextKeyMarker"
	o = append(o, 0xad, 0x4e, 0x65, 0x78, 0x74, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendString(o, z.NextKeyMarker)
	// string "NextUploadIDMarker"
	o = append(o, 0xb2, 0x4e, 0x65, 0x78, 0x74, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x44, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendString(o, z.NextUploadIDMarker)
	// string "MaxUploads"
	o = append(o, 0xaa, 0x4d, 0x61, 0x78, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x73)
	o = msgp.AppendInt(o, z.MaxUploads)
	// string "IsTruncated"
	o = append(o, 0xab, 0x49, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64)
	o = msgp.AppendBool(o, z.IsTruncated)
	// string "Uploads"
	o = append(o, 0xa7, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Uploads)))
	for za0001 := range z.Uploads {
		o, err = z.Uploads[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Uploads", za0001)
			return
		}
	}
	// string "Prefix"
	o = append(o, 0xa6, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78)
	o = msgp.AppendString(o, z.Prefix)
	// string "Delimiter"
	o = append(o, 0xa9, 0x44, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72)
	o = msgp.AppendString(o, z.Delimiter)
	// string "CommonPrefixes"
	o = append(o, 0xae, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.CommonPrefixes)))
	for za0002 := range z.CommonPrefixes {
		o = msgp.AppendString(o, z.CommonPrefixes[za0002])
	}
	// string "EncodingType"
	o = append(o, 0xac, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65)
	o = msgp.AppendString(o, z.EncodingType)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ListMultipartsInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "KeyMarker":
			z.KeyMarker, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "KeyMarker")
				return
			}
		case "UploadIDMarker":
			z.UploadIDMarker, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UploadIDMarker")
				return
			}
		case "NextKeyMarker":
			z.NextKeyMarker, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NextKeyMarker")
				return
			}
		case "NextUploadIDMarker":
			z.NextUploadIDMarker, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NextUploadIDMarker")
				return
			}
		case "MaxUploads":
			z.MaxUploads, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "MaxUploads")
				return
			}
		case "IsTruncated":
			z.IsTruncated, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IsTruncated")
				return
			}
		case "Uploads":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Uploads")
				return
			}
			if cap(z.Uploads) >= int(zb0002) {
				z.Uploads = (z.Uploads)[:zb0002]
			} else {
				z.Uploads = make([]MultipartInfo, zb0002)
			}
			for za0001 := range z.Uploads {
				bts, err = z.Uploads[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Uploads", za0001)
					return
				}
			}
		case "Prefix":
			z.Prefix, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Prefix")
				return
			}
		case "Delimiter":
			z.Delimiter, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Delimiter")
				return
			}
		case "CommonPrefixes":
			var zb0003 uint32
			zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "CommonPrefixes")
				return
			}
			if cap(z.CommonPrefixes) >= int(zb0003) {
				z.CommonPrefixes = (z.CommonPrefixes)[:zb0003]
			} else {
				z.CommonPrefixes = make([]string, zb0003)
			}
			for za0002 := range z.CommonPrefixes {
				z.CommonPrefixes[za0002], bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "CommonPrefixes", za0002)
					return
				}
			}
		case "EncodingType":
			z.EncodingType, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "EncodingType")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ListMultipartsInfo) Msgsize() (s int) {
	s = 1 + 10 + msgp.StringPrefixSize + len(z.KeyMarker) + 15 + msgp.StringPrefixSize + len(z.UploadIDMarker) + 14 + msgp.StringPrefixSize + len(z.NextKeyMarker) + 19 + msgp.StringPrefixSize + len(z.NextUploadIDMarker) + 11 + msgp.IntSize + 12 + msgp.BoolSize + 8 + msgp.ArrayHeaderSize
	for za0001 := range z.Uploads {
		s += z.Uploads[za0001].Msgsize()
	}
	s += 7 + msgp.StringPrefixSize + len(z.Prefix) + 10 + msgp.StringPrefixSize + len(z.Delimiter) + 15 + msgp.ArrayHeaderSize
	for za0002 := range z.CommonPrefixes {
		s += msgp.StringPrefixSize + len(z.CommonPrefixes[za0002])
	}
	s += 13 + msgp.StringPrefixSize + len(z.EncodingType)
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ListObjectVersionsInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "IsTruncated"
	o = append(o, 0x85, 0xab, 0x49, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64)
	o = msgp.AppendBool(o, z.IsTruncated)
	// string "NextMarker"
	o = append(o, 0xaa, 0x4e, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendString(o, z.NextMarker)
	// string "NextVersionIDMarker"
	o = append(o, 0xb3, 0x4e, 0x65, 0x78, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendString(o, z.NextVersionIDMarker)
	// string "Objects"
	o = append(o, 0xa7, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Objects)))
	for za0001 := range z.Objects {
		o, err = z.Objects[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Objects", za0001)
			return
		}
	}
	// string "Prefixes"
	o = append(o, 0xa8, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Prefixes)))
	for za0002 := range z.Prefixes {
		o = msgp.AppendString(o, z.Prefixes[za0002])
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ListObjectVersionsInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "IsTruncated":
			z.IsTruncated, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IsTruncated")
				return
			}
		case "NextMarker":
			z.NextMarker, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NextMarker")
				return
			}
		case "NextVersionIDMarker":
			z.NextVersionIDMarker, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NextVersionIDMarker")
				return
			}
		case "Objects":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Objects")
				return
			}
			if cap(z.Objects) >= int(zb0002) {
				z.Objects = (z.Objects)[:zb0002]
			} else {
				z.Objects = make([]ObjectInfo, zb0002)
			}
			for za0001 := range z.Objects {
				bts, err = z.Objects[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Objects", za0001)
					return
				}
			}
		case "Prefixes":
			var zb0003 uint32
			zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Prefixes")
				return
			}
			if cap(z.Prefixes) >= int(zb0003) {
				z.Prefixes = (z.Prefixes)[:zb0003]
			} else {
				z.Prefixes = make([]string, zb0003)
			}
			for za0002 := range z.Prefixes {
				z.Prefixes[za0002], bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Prefixes", za0002)
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ListObjectVersionsInfo) Msgsize() (s int) {
	s = 1 + 12 + msgp.BoolSize + 11 + msgp.StringPrefixSize + len(z.NextMarker) + 20 + msgp.StringPrefixSize + len(z.NextVersionIDMarker) + 8 + msgp.ArrayHeaderSize
	for za0001 := range z.Objects {
		s += z.Objects[za0001].Msgsize()
	}
	s += 9 + msgp.ArrayHeaderSize
	for za0002 := range z.Prefixes {
		s += msgp.StringPrefixSize + len(z.Prefixes[za0002])
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ListObjectsInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "IsTruncated"
	o = append(o, 0x84, 0xab, 0x49, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64)
	o = msgp.AppendBool(o, z.IsTruncated)
	// string "NextMarker"
	o = append(o, 0xaa, 0x4e, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendString(o, z.NextMarker)
	// string "Objects"
	o = append(o, 0xa7, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Objects)))
	for za0001 := range z.Objects {
		o, err = z.Objects[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Objects", za0001)
			return
		}
	}
	// string "Prefixes"
	o = append(o, 0xa8, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Prefixes)))
	for za0002 := range z.Prefixes {
		o = msgp.AppendString(o, z.Prefixes[za0002])
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ListObjectsInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "IsTruncated":
			z.IsTruncated, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IsTruncated")
				return
			}
		case "NextMarker":
			z.NextMarker, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NextMarker")
				return
			}
		case "Objects":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Objects")
				return
			}
			if cap(z.Objects) >= int(zb0002) {
				z.Objects = (z.Objects)[:zb0002]
			} else {
				z.Objects = make([]ObjectInfo, zb0002)
			}
			for za0001 := range z.Objects {
				bts, err = z.Objects[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Objects", za0001)
					return
				}
			}
		case "Prefixes":
			var zb0003 uint32
			zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Prefixes")
				return
			}
			if cap(z.Prefixes) >= int(zb0003) {
				z.Prefixes = (z.Prefixes)[:zb0003]
			} else {
				z.Prefixes = make([]string, zb0003)
			}
			for za0002 := range z.Prefixes {
				z.Prefixes[za0002], bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Prefixes", za0002)
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ListObjectsInfo) Msgsize() (s int) {
	s = 1 + 12 + msgp.BoolSize + 11 + msgp.StringPrefixSize + len(z.NextMarker) + 8 + msgp.ArrayHeaderSize
	for za0001 := range z.Objects {
		s += z.Objects[za0001].Msgsize()
	}
	s += 9 + msgp.ArrayHeaderSize
	for za0002 := range z.Prefixes {
		s += msgp.StringPrefixSize + len(z.Prefixes[za0002])
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ListObjectsV2Info) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "IsTruncated"
	o = append(o, 0x85, 0xab, 0x49, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64)
	o = msgp.AppendBool(o, z.IsTruncated)
	// string "ContinuationToken"
	o = append(o, 0xb1, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e)
	o = msgp.AppendString(o, z.ContinuationToken)
	// string "NextContinuationToken"
	o = append(o, 0xb5, 0x4e, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e)
	o = msgp.AppendString(o, z.NextContinuationToken)
	// string "Objects"
	o = append(o, 0xa7, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Objects)))
	for za0001 := range z.Objects {
		o, err = z.Objects[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Objects", za0001)
			return
		}
	}
	// string "Prefixes"
	o = append(o, 0xa8, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Prefixes)))
	for za0002 := range z.Prefixes {
		o = msgp.AppendString(o, z.Prefixes[za0002])
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ListObjectsV2Info) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "IsTruncated":
			z.IsTruncated, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IsTruncated")
				return
			}
		case "ContinuationToken":
			z.ContinuationToken, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ContinuationToken")
				return
			}
		case "NextContinuationToken":
			z.NextContinuationToken, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NextContinuationToken")
				return
			}
		case "Objects":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Objects")
				return
			}
			if cap(z.Objects) >= int(zb0002) {
				z.Objects = (z.Objects)[:zb0002]
			} else {
				z.Objects = make([]ObjectInfo, zb0002)
			}
			for za0001 := range z.Objects {
				bts, err = z.Objects[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Objects", za0001)
					return
				}
			}
		case "Prefixes":
			var zb0003 uint32
			zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Prefixes")
				return
			}
			if cap(z.Prefixes) >= int(zb0003) {
				z.Prefixes = (z.Prefixes)[:zb0003]
			} else {
				z.Prefixes = make([]string, zb0003)
			}
			for za0002 := range z.Prefixes {
				z.Prefixes[za0002], bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Prefixes", za0002)
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ListObjectsV2Info) Msgsize() (s int) {
	s = 1 + 12 + msgp.BoolSize + 18 + msgp.StringPrefixSize + len(z.ContinuationToken) + 22 + msgp.StringPrefixSize + len(z.NextContinuationToken) + 8 + msgp.ArrayHeaderSize
	for za0001 := range z.Objects {
		s += z.Objects[za0001].Msgsize()
	}
	s += 9 + msgp.ArrayHeaderSize
	for za0002 := range z.Prefixes {
		s += msgp.StringPrefixSize + len(z.Prefixes[za0002])
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ListPartsInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 11
	// string "Bucket"
	o = append(o, 0x8b, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	o = msgp.AppendString(o, z.Bucket)
	// string "Object"
	o = append(o, 0xa6, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74)
	o = msgp.AppendString(o, z.Object)
	// string "UploadID"
	o = append(o, 0xa8, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x44)
	o = msgp.AppendString(o, z.UploadID)
	// string "StorageClass"
	o = append(o, 0xac, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73)
	o = msgp.AppendString(o, z.StorageClass)
	// string "PartNumberMarker"
	o = append(o, 0xb0, 0x50, 0x61, 0x72, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendInt(o, z.PartNumberMarker)
	// string "NextPartNumberMarker"
	o = append(o, 0xb4, 0x4e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x72, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendInt(o, z.NextPartNumberMarker)
	// string "MaxParts"
	o = append(o, 0xa8, 0x4d, 0x61, 0x78, 0x50, 0x61, 0x72, 0x74, 0x73)
	o = msgp.AppendInt(o, z.MaxParts)
	// string "IsTruncated"
	o = append(o, 0xab, 0x49, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64)
	o = msgp.AppendBool(o, z.IsTruncated)
	// string "Parts"
	o = append(o, 0xa5, 0x50, 0x61, 0x72, 0x74, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Parts)))
	for za0001 := range z.Parts {
		o, err = z.Parts[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Parts", za0001)
			return
		}
	}
	// string "UserDefined"
	o = append(o, 0xab, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64)
	o = msgp.AppendMapHeader(o, uint32(len(z.UserDefined)))
	for za0002, za0003 := range z.UserDefined {
		o = msgp.AppendString(o, za0002)
		o = msgp.AppendString(o, za0003)
	}
	// string "ChecksumAlgorithm"
	o = append(o, 0xb1, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d)
	o = msgp.AppendString(o, z.ChecksumAlgorithm)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ListPartsInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Bucket":
			z.Bucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Object":
			z.Object, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Object")
				return
			}
		case "UploadID":
			z.UploadID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UploadID")
				return
			}
		case "StorageClass":
			z.StorageClass, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "StorageClass")
				return
			}
		case "PartNumberMarker":
			z.PartNumberMarker, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "PartNumberMarker")
				return
			}
		case "NextPartNumberMarker":
			z.NextPartNumberMarker, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NextPartNumberMarker")
				return
			}
		case "MaxParts":
			z.MaxParts, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "MaxParts")
				return
			}
		case "IsTruncated":
			z.IsTruncated, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IsTruncated")
				return
			}
		case "Parts":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Parts")
				return
			}
			if cap(z.Parts) >= int(zb0002) {
				z.Parts = (z.Parts)[:zb0002]
			} else {
				z.Parts = make([]PartInfo, zb0002)
			}
			for za0001 := range z.Parts {
				bts, err = z.Parts[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Parts", za0001)
					return
				}
			}
		case "UserDefined":
			var zb0003 uint32
			zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UserDefined")
				return
			}
			if z.UserDefined == nil {
				z.UserDefined = make(map[string]string, zb0003)
			} else if len(z.UserDefined) > 0 {
				for key := range z.UserDefined {
					delete(z.UserDefined, key)
				}
			}
			for zb0003 > 0 {
				var za0002 string
				var za0003 string
				zb0003--
				za0002, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UserDefined")
					return
				}
				za0003, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UserDefined", za0002)
					return
				}
				z.UserDefined[za0002] = za0003
			}
		case "ChecksumAlgorithm":
			z.ChecksumAlgorithm, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumAlgorithm")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ListPartsInfo) Msgsize() (s int) {
	s = 1 + 7 + msgp.StringPrefixSize + len(z.Bucket) + 7 + msgp.StringPrefixSize + len(z.Object) + 9 + msgp.StringPrefixSize + len(z.UploadID) + 13 + msgp.StringPrefixSize + len(z.StorageClass) + 17 + msgp.IntSize + 21 + msgp.IntSize + 9 + msgp.IntSize + 12 + msgp.BoolSize + 6 + msgp.ArrayHeaderSize
	for za0001 := range z.Parts {
		s += z.Parts[za0001].Msgsize()
	}
	s += 12 + msgp.MapHeaderSize
	if z.UserDefined != nil {
		for za0002, za0003 := range z.UserDefined {
			_ = za0003
			s += msgp.StringPrefixSize + len(za0002) + msgp.StringPrefixSize + len(za0003)
		}
	}
	s += 18 + msgp.StringPrefixSize + len(z.ChecksumAlgorithm)
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *MultipartInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "Bucket"
	o = append(o, 0x85, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	o = msgp.AppendString(o, z.Bucket)
	// string "Object"
	o = append(o, 0xa6, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74)
	o = msgp.AppendString(o, z.Object)
	// string "UploadID"
	o = append(o, 0xa8, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x44)
	o = msgp.AppendString(o, z.UploadID)
	// string "Initiated"
	o = append(o, 0xa9, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x65, 0x64)
	o = msgp.AppendTime(o, z.Initiated)
	// string "UserDefined"
	o = append(o, 0xab, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64)
	o = msgp.AppendMapHeader(o, uint32(len(z.UserDefined)))
	for za0001, za0002 := range z.UserDefined {
		o = msgp.AppendString(o, za0001)
		o = msgp.AppendString(o, za0002)
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *MultipartInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Bucket":
			z.Bucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Object":
			z.Object, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Object")
				return
			}
		case "UploadID":
			z.UploadID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UploadID")
				return
			}
		case "Initiated":
			z.Initiated, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Initiated")
				return
			}
		case "UserDefined":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UserDefined")
				return
			}
			if z.UserDefined == nil {
				z.UserDefined = make(map[string]string, zb0002)
			} else if len(z.UserDefined) > 0 {
				for key := range z.UserDefined {
					delete(z.UserDefined, key)
				}
			}
			for zb0002 > 0 {
				var za0001 string
				var za0002 string
				zb0002--
				za0001, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UserDefined")
					return
				}
				za0002, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UserDefined", za0001)
					return
				}
				z.UserDefined[za0001] = za0002
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *MultipartInfo) Msgsize() (s int) {
	s = 1 + 7 + msgp.StringPrefixSize + len(z.Bucket) + 7 + msgp.StringPrefixSize + len(z.Object) + 9 + msgp.StringPrefixSize + len(z.UploadID) + 10 + msgp.TimeSize + 12 + msgp.MapHeaderSize
	if z.UserDefined != nil {
		for za0001, za0002 := range z.UserDefined {
			_ = za0002
			s += msgp.StringPrefixSize + len(za0001) + msgp.StringPrefixSize + len(za0002)
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z NewMultipartUploadResult) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "UploadID"
	o = append(o, 0x82, 0xa8, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x44)
	o = msgp.AppendString(o, z.UploadID)
	// string "ChecksumAlgo"
	o = append(o, 0xac, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x41, 0x6c, 0x67, 0x6f)
	o = msgp.AppendString(o, z.ChecksumAlgo)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *NewMultipartUploadResult) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "UploadID":
			z.UploadID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UploadID")
				return
			}
		case "ChecksumAlgo":
			z.ChecksumAlgo, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumAlgo")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z NewMultipartUploadResult) Msgsize() (s int) {
	s = 1 + 9 + msgp.StringPrefixSize + len(z.UploadID) + 13 + msgp.StringPrefixSize + len(z.ChecksumAlgo)
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ObjectInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 33
	// string "Bucket"
	o = append(o, 0xde, 0x0, 0x21, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	o = msgp.AppendString(o, z.Bucket)
	// string "Name"
	o = append(o, 0xa4, 0x4e, 0x61, 0x6d, 0x65)
	o = msgp.AppendString(o, z.Name)
	// string "ModTime"
	o = append(o, 0xa7, 0x4d, 0x6f, 0x64, 0x54, 0x69, 0x6d, 0x65)
	o = msgp.AppendTime(o, z.ModTime)
	// string "Size"
	o = append(o, 0xa4, 0x53, 0x69, 0x7a, 0x65)
	o = msgp.AppendInt64(o, z.Size)
	// string "ActualSize"
	o = append(o, 0xaa, 0x41, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65)
	if z.ActualSize == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendInt64(o, *z.ActualSize)
	}
	// string "IsDir"
	o = append(o, 0xa5, 0x49, 0x73, 0x44, 0x69, 0x72)
	o = msgp.AppendBool(o, z.IsDir)
	// string "ETag"
	o = append(o, 0xa4, 0x45, 0x54, 0x61, 0x67)
	o = msgp.AppendString(o, z.ETag)
	// string "VersionID"
	o = append(o, 0xa9, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44)
	o = msgp.AppendString(o, z.VersionID)
	// string "IsLatest"
	o = append(o, 0xa8, 0x49, 0x73, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74)
	o = msgp.AppendBool(o, z.IsLatest)
	// string "DeleteMarker"
	o = append(o, 0xac, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendBool(o, z.DeleteMarker)
	// string "TransitionedObject"
	o = append(o, 0xb2, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74)
	o, err = z.TransitionedObject.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "TransitionedObject")
		return
	}
	// string "RestoreExpires"
	o = append(o, 0xae, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73)
	o = msgp.AppendTime(o, z.RestoreExpires)
	// string "RestoreOngoing"
	o = append(o, 0xae, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x67)
	o = msgp.AppendBool(o, z.RestoreOngoing)
	// string "ContentType"
	o = append(o, 0xab, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65)
	o = msgp.AppendString(o, z.ContentType)
	// string "ContentEncoding"
	o = append(o, 0xaf, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67)
	o = msgp.AppendString(o, z.ContentEncoding)
	// string "Expires"
	o = append(o, 0xa7, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73)
	o = msgp.AppendTime(o, z.Expires)
	// string "CacheControl"
	o = append(o, 0xac, 0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c)
	o = msgp.AppendString(o, z.CacheControl)
	// string "StorageClass"
	o = append(o, 0xac, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73)
	o = msgp.AppendString(o, z.StorageClass)
	// string "ReplicationStatusInternal"
	o = append(o, 0xb9, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c)
	o = msgp.AppendString(o, z.ReplicationStatusInternal)
	// string "ReplicationStatus"
	o = append(o, 0xb1, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73)
	o, err = z.ReplicationStatus.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "ReplicationStatus")
		return
	}
	// string "UserDefined"
	o = append(o, 0xab, 0x55, 0x73, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64)
	o = msgp.AppendMapHeader(o, uint32(len(z.UserDefined)))
	for za0001, za0002 := range z.UserDefined {
		o = msgp.AppendString(o, za0001)
		o = msgp.AppendString(o, za0002)
	}
	// string "UserTags"
	o = append(o, 0xa8, 0x55, 0x73, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73)
	o = msgp.AppendString(o, z.UserTags)
	// string "Parts"
	o = append(o, 0xa5, 0x50, 0x61, 0x72, 0x74, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Parts)))
	for za0003 := range z.Parts {
		o, err = z.Parts[za0003].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Parts", za0003)
			return
		}
	}
	// string "AccTime"
	o = append(o, 0xa7, 0x41, 0x63, 0x63, 0x54, 0x69, 0x6d, 0x65)
	o = msgp.AppendTime(o, z.AccTime)
	// string "Legacy"
	o = append(o, 0xa6, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79)
	o = msgp.AppendBool(o, z.Legacy)
	// string "VersionPurgeStatusInternal"
	o = append(o, 0xba, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c)
	o = msgp.AppendString(o, z.VersionPurgeStatusInternal)
	// string "VersionPurgeStatus"
	o = append(o, 0xb2, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73)
	o, err = z.VersionPurgeStatus.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "VersionPurgeStatus")
		return
	}
	// string "NumVersions"
	o = append(o, 0xab, 0x4e, 0x75, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73)
	o = msgp.AppendInt(o, z.NumVersions)
	// string "SuccessorModTime"
	o = append(o, 0xb0, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x4d, 0x6f, 0x64, 0x54, 0x69, 0x6d, 0x65)
	o = msgp.AppendTime(o, z.SuccessorModTime)
	// string "Checksum"
	o = append(o, 0xa8, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d)
	o = msgp.AppendBytes(o, z.Checksum)
	// string "Inlined"
	o = append(o, 0xa7, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x64)
	o = msgp.AppendBool(o, z.Inlined)
	// string "DataBlocks"
	o = append(o, 0xaa, 0x44, 0x61, 0x74, 0x61, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73)
	o = msgp.AppendInt(o, z.DataBlocks)
	// string "ParityBlocks"
	o = append(o, 0xac, 0x50, 0x61, 0x72, 0x69, 0x74, 0x79, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73)
	o = msgp.AppendInt(o, z.ParityBlocks)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ObjectInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Bucket":
			z.Bucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "Name":
			z.Name, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Name")
				return
			}
		case "ModTime":
			z.ModTime, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ModTime")
				return
			}
		case "Size":
			z.Size, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Size")
				return
			}
		case "ActualSize":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.ActualSize = nil
			} else {
				if z.ActualSize == nil {
					z.ActualSize = new(int64)
				}
				*z.ActualSize, bts, err = msgp.ReadInt64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ActualSize")
					return
				}
			}
		case "IsDir":
			z.IsDir, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IsDir")
				return
			}
		case "ETag":
			z.ETag, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ETag")
				return
			}
		case "VersionID":
			z.VersionID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "VersionID")
				return
			}
		case "IsLatest":
			z.IsLatest, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IsLatest")
				return
			}
		case "DeleteMarker":
			z.DeleteMarker, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DeleteMarker")
				return
			}
		case "TransitionedObject":
			bts, err = z.TransitionedObject.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "TransitionedObject")
				return
			}
		case "RestoreExpires":
			z.RestoreExpires, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "RestoreExpires")
				return
			}
		case "RestoreOngoing":
			z.RestoreOngoing, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "RestoreOngoing")
				return
			}
		case "ContentType":
			z.ContentType, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ContentType")
				return
			}
		case "ContentEncoding":
			z.ContentEncoding, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ContentEncoding")
				return
			}
		case "Expires":
			z.Expires, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Expires")
				return
			}
		case "CacheControl":
			z.CacheControl, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "CacheControl")
				return
			}
		case "StorageClass":
			z.StorageClass, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "StorageClass")
				return
			}
		case "ReplicationStatusInternal":
			z.ReplicationStatusInternal, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ReplicationStatusInternal")
				return
			}
		case "ReplicationStatus":
			bts, err = z.ReplicationStatus.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "ReplicationStatus")
				return
			}
		case "UserDefined":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UserDefined")
				return
			}
			if z.UserDefined == nil {
				z.UserDefined = make(map[string]string, zb0002)
			} else if len(z.UserDefined) > 0 {
				for key := range z.UserDefined {
					delete(z.UserDefined, key)
				}
			}
			for zb0002 > 0 {
				var za0001 string
				var za0002 string
				zb0002--
				za0001, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UserDefined")
					return
				}
				za0002, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UserDefined", za0001)
					return
				}
				z.UserDefined[za0001] = za0002
			}
		case "UserTags":
			z.UserTags, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UserTags")
				return
			}
		case "Parts":
			var zb0003 uint32
			zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Parts")
				return
			}
			if cap(z.Parts) >= int(zb0003) {
				z.Parts = (z.Parts)[:zb0003]
			} else {
				z.Parts = make([]ObjectPartInfo, zb0003)
			}
			for za0003 := range z.Parts {
				bts, err = z.Parts[za0003].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Parts", za0003)
					return
				}
			}
		case "AccTime":
			z.AccTime, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AccTime")
				return
			}
		case "Legacy":
			z.Legacy, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Legacy")
				return
			}
		case "VersionPurgeStatusInternal":
			z.VersionPurgeStatusInternal, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "VersionPurgeStatusInternal")
				return
			}
		case "VersionPurgeStatus":
			bts, err = z.VersionPurgeStatus.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "VersionPurgeStatus")
				return
			}
		case "NumVersions":
			z.NumVersions, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "NumVersions")
				return
			}
		case "SuccessorModTime":
			z.SuccessorModTime, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SuccessorModTime")
				return
			}
		case "Checksum":
			z.Checksum, bts, err = msgp.ReadBytesBytes(bts, z.Checksum)
			if err != nil {
				err = msgp.WrapError(err, "Checksum")
				return
			}
		case "Inlined":
			z.Inlined, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Inlined")
				return
			}
		case "DataBlocks":
			z.DataBlocks, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DataBlocks")
				return
			}
		case "ParityBlocks":
			z.ParityBlocks, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ParityBlocks")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ObjectInfo) Msgsize() (s int) {
	s = 3 + 7 + msgp.StringPrefixSize + len(z.Bucket) + 5 + msgp.StringPrefixSize + len(z.Name) + 8 + msgp.TimeSize + 5 + msgp.Int64Size + 11
	if z.ActualSize == nil {
		s += msgp.NilSize
	} else {
		s += msgp.Int64Size
	}
	s += 6 + msgp.BoolSize + 5 + msgp.StringPrefixSize + len(z.ETag) + 10 + msgp.StringPrefixSize + len(z.VersionID) + 9 + msgp.BoolSize + 13 + msgp.BoolSize + 19 + z.TransitionedObject.Msgsize() + 15 + msgp.TimeSize + 15 + msgp.BoolSize + 12 + msgp.StringPrefixSize + len(z.ContentType) + 16 + msgp.StringPrefixSize + len(z.ContentEncoding) + 8 + msgp.TimeSize + 13 + msgp.StringPrefixSize + len(z.CacheControl) + 13 + msgp.StringPrefixSize + len(z.StorageClass) + 26 + msgp.StringPrefixSize + len(z.ReplicationStatusInternal) + 18 + z.ReplicationStatus.Msgsize() + 12 + msgp.MapHeaderSize
	if z.UserDefined != nil {
		for za0001, za0002 := range z.UserDefined {
			_ = za0002
			s += msgp.StringPrefixSize + len(za0001) + msgp.StringPrefixSize + len(za0002)
		}
	}
	s += 9 + msgp.StringPrefixSize + len(z.UserTags) + 6 + msgp.ArrayHeaderSize
	for za0003 := range z.Parts {
		s += z.Parts[za0003].Msgsize()
	}
	s += 8 + msgp.TimeSize + 7 + msgp.BoolSize + 27 + msgp.StringPrefixSize + len(z.VersionPurgeStatusInternal) + 19 + z.VersionPurgeStatus.Msgsize() + 12 + msgp.IntSize + 17 + msgp.TimeSize + 9 + msgp.BytesPrefixSize + len(z.Checksum) + 8 + msgp.BoolSize + 11 + msgp.IntSize + 13 + msgp.IntSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *PartInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 9
	// string "PartNumber"
	o = append(o, 0x89, 0xaa, 0x50, 0x61, 0x72, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72)
	o = msgp.AppendInt(o, z.PartNumber)
	// string "LastModified"
	o = append(o, 0xac, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64)
	o = msgp.AppendTime(o, z.LastModified)
	// string "ETag"
	o = append(o, 0xa4, 0x45, 0x54, 0x61, 0x67)
	o = msgp.AppendString(o, z.ETag)
	// string "Size"
	o = append(o, 0xa4, 0x53, 0x69, 0x7a, 0x65)
	o = msgp.AppendInt64(o, z.Size)
	// string "ActualSize"
	o = append(o, 0xaa, 0x41, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65)
	o = msgp.AppendInt64(o, z.ActualSize)
	// string "ChecksumCRC32"
	o = append(o, 0xad, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x43, 0x52, 0x43, 0x33, 0x32)
	o = msgp.AppendString(o, z.ChecksumCRC32)
	// string "ChecksumCRC32C"
	o = append(o, 0xae, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x43, 0x52, 0x43, 0x33, 0x32, 0x43)
	o = msgp.AppendString(o, z.ChecksumCRC32C)
	// string "ChecksumSHA1"
	o = append(o, 0xac, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x53, 0x48, 0x41, 0x31)
	o = msgp.AppendString(o, z.ChecksumSHA1)
	// string "ChecksumSHA256"
	o = append(o, 0xae, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36)
	o = msgp.AppendString(o, z.ChecksumSHA256)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *PartInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "PartNumber":
			z.PartNumber, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "PartNumber")
				return
			}
		case "LastModified":
			z.LastModified, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "LastModified")
				return
			}
		case "ETag":
			z.ETag, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ETag")
				return
			}
		case "Size":
			z.Size, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Size")
				return
			}
		case "ActualSize":
			z.ActualSize, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ActualSize")
				return
			}
		case "ChecksumCRC32":
			z.ChecksumCRC32, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumCRC32")
				return
			}
		case "ChecksumCRC32C":
			z.ChecksumCRC32C, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumCRC32C")
				return
			}
		case "ChecksumSHA1":
			z.ChecksumSHA1, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumSHA1")
				return
			}
		case "ChecksumSHA256":
			z.ChecksumSHA256, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ChecksumSHA256")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *PartInfo) Msgsize() (s int) {
	s = 1 + 11 + msgp.IntSize + 13 + msgp.TimeSize + 5 + msgp.StringPrefixSize + len(z.ETag) + 5 + msgp.Int64Size + 11 + msgp.Int64Size + 14 + msgp.StringPrefixSize + len(z.ChecksumCRC32) + 15 + msgp.StringPrefixSize + len(z.ChecksumCRC32C) + 13 + msgp.StringPrefixSize + len(z.ChecksumSHA1) + 15 + msgp.StringPrefixSize + len(z.ChecksumSHA256)
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ReplicateObjectInfo) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 26
	// string "Name"
	o = append(o, 0xde, 0x0, 0x1a, 0xa4, 0x4e, 0x61, 0x6d, 0x65)
	o = msgp.AppendString(o, z.Name)
	// string "Bucket"
	o = append(o, 0xa6, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74)
	o = msgp.AppendString(o, z.Bucket)
	// string "VersionID"
	o = append(o, 0xa9, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44)
	o = msgp.AppendString(o, z.VersionID)
	// string "ETag"
	o = append(o, 0xa4, 0x45, 0x54, 0x61, 0x67)
	o = msgp.AppendString(o, z.ETag)
	// string "Size"
	o = append(o, 0xa4, 0x53, 0x69, 0x7a, 0x65)
	o = msgp.AppendInt64(o, z.Size)
	// string "ActualSize"
	o = append(o, 0xaa, 0x41, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65)
	o = msgp.AppendInt64(o, z.ActualSize)
	// string "ModTime"
	o = append(o, 0xa7, 0x4d, 0x6f, 0x64, 0x54, 0x69, 0x6d, 0x65)
	o = msgp.AppendTime(o, z.ModTime)
	// string "UserTags"
	o = append(o, 0xa8, 0x55, 0x73, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73)
	o = msgp.AppendString(o, z.UserTags)
	// string "SSEC"
	o = append(o, 0xa4, 0x53, 0x53, 0x45, 0x43)
	o = msgp.AppendBool(o, z.SSEC)
	// string "ReplicationStatus"
	o = append(o, 0xb1, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73)
	o, err = z.ReplicationStatus.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "ReplicationStatus")
		return
	}
	// string "ReplicationStatusInternal"
	o = append(o, 0xb9, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c)
	o = msgp.AppendString(o, z.ReplicationStatusInternal)
	// string "VersionPurgeStatusInternal"
	o = append(o, 0xba, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c)
	o = msgp.AppendString(o, z.VersionPurgeStatusInternal)
	// string "VersionPurgeStatus"
	o = append(o, 0xb2, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73)
	o, err = z.VersionPurgeStatus.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "VersionPurgeStatus")
		return
	}
	// string "ReplicationState"
	o = append(o, 0xb0, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65)
	o, err = z.ReplicationState.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "ReplicationState")
		return
	}
	// string "DeleteMarker"
	o = append(o, 0xac, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72)
	o = msgp.AppendBool(o, z.DeleteMarker)
	// string "OpType"
	o = append(o, 0xa6, 0x4f, 0x70, 0x54, 0x79, 0x70, 0x65)
	o, err = z.OpType.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "OpType")
		return
	}
	// string "EventType"
	o = append(o, 0xa9, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65)
	o = msgp.AppendString(o, z.EventType)
	// string "RetryCount"
	o = append(o, 0xaa, 0x52, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74)
	o = msgp.AppendUint32(o, z.RetryCount)
	// string "ResetID"
	o = append(o, 0xa7, 0x52, 0x65, 0x73, 0x65, 0x74, 0x49, 0x44)
	o = msgp.AppendString(o, z.ResetID)
	// string "Dsc"
	o = append(o, 0xa3, 0x44, 0x73, 0x63)
	o, err = z.Dsc.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "Dsc")
		return
	}
	// string "ExistingObjResync"
	o = append(o, 0xb1, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x52, 0x65, 0x73, 0x79, 0x6e, 0x63)
	o, err = z.ExistingObjResync.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "ExistingObjResync")
		return
	}
	// string "TargetArn"
	o = append(o, 0xa9, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x72, 0x6e)
	o = msgp.AppendString(o, z.TargetArn)
	// string "TargetStatuses"
	o = append(o, 0xae, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73)
	o = msgp.AppendMapHeader(o, uint32(len(z.TargetStatuses)))
	for za0001, za0002 := range z.TargetStatuses {
		o = msgp.AppendString(o, za0001)
		o, err = za0002.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "TargetStatuses", za0001)
			return
		}
	}
	// string "TargetPurgeStatuses"
	o = append(o, 0xb3, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x75, 0x72, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73)
	o = msgp.AppendMapHeader(o, uint32(len(z.TargetPurgeStatuses)))
	for za0003, za0004 := range z.TargetPurgeStatuses {
		o = msgp.AppendString(o, za0003)
		o, err = za0004.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "TargetPurgeStatuses", za0003)
			return
		}
	}
	// string "ReplicationTimestamp"
	o = append(o, 0xb4, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70)
	o = msgp.AppendTime(o, z.ReplicationTimestamp)
	// string "Checksum"
	o = append(o, 0xa8, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d)
	o = msgp.AppendBytes(o, z.Checksum)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ReplicateObjectInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Name":
			z.Name, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Name")
				return
			}
		case "Bucket":
			z.Bucket, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Bucket")
				return
			}
		case "VersionID":
			z.VersionID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "VersionID")
				return
			}
		case "ETag":
			z.ETag, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ETag")
				return
			}
		case "Size":
			z.Size, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Size")
				return
			}
		case "ActualSize":
			z.ActualSize, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ActualSize")
				return
			}
		case "ModTime":
			z.ModTime, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ModTime")
				return
			}
		case "UserTags":
			z.UserTags, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "UserTags")
				return
			}
		case "SSEC":
			z.SSEC, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SSEC")
				return
			}
		case "ReplicationStatus":
			bts, err = z.ReplicationStatus.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "ReplicationStatus")
				return
			}
		case "ReplicationStatusInternal":
			z.ReplicationStatusInternal, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ReplicationStatusInternal")
				return
			}
		case "VersionPurgeStatusInternal":
			z.VersionPurgeStatusInternal, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "VersionPurgeStatusInternal")
				return
			}
		case "VersionPurgeStatus":
			bts, err = z.VersionPurgeStatus.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "VersionPurgeStatus")
				return
			}
		case "ReplicationState":
			bts, err = z.ReplicationState.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "ReplicationState")
				return
			}
		case "DeleteMarker":
			z.DeleteMarker, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DeleteMarker")
				return
			}
		case "OpType":
			bts, err = z.OpType.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "OpType")
				return
			}
		case "EventType":
			z.EventType, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "EventType")
				return
			}
		case "RetryCount":
			z.RetryCount, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "RetryCount")
				return
			}
		case "ResetID":
			z.ResetID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ResetID")
				return
			}
		case "Dsc":
			bts, err = z.Dsc.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "Dsc")
				return
			}
		case "ExistingObjResync":
			bts, err = z.ExistingObjResync.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "ExistingObjResync")
				return
			}
		case "TargetArn":
			z.TargetArn, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TargetArn")
				return
			}
		case "TargetStatuses":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TargetStatuses")
				return
			}
			if z.TargetStatuses == nil {
				z.TargetStatuses = make(map[string]replication.StatusType, zb0002)
			} else if len(z.TargetStatuses) > 0 {
				for key := range z.TargetStatuses {
					delete(z.TargetStatuses, key)
				}
			}
			for zb0002 > 0 {
				var za0001 string
				var za0002 replication.StatusType
				zb0002--
				za0001, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TargetStatuses")
					return
				}
				bts, err = za0002.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "TargetStatuses", za0001)
					return
				}
				z.TargetStatuses[za0001] = za0002
			}
		case "TargetPurgeStatuses":
			var zb0003 uint32
			zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TargetPurgeStatuses")
				return
			}
			if z.TargetPurgeStatuses == nil {
				z.TargetPurgeStatuses = make(map[string]VersionPurgeStatusType, zb0003)
			} else if len(z.TargetPurgeStatuses) > 0 {
				for key := range z.TargetPurgeStatuses {
					delete(z.TargetPurgeStatuses, key)
				}
			}
			for zb0003 > 0 {
				var za0003 string
				var za0004 VersionPurgeStatusType
				zb0003--
				za0003, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TargetPurgeStatuses")
					return
				}
				bts, err = za0004.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "TargetPurgeStatuses", za0003)
					return
				}
				z.TargetPurgeStatuses[za0003] = za0004
			}
		case "ReplicationTimestamp":
			z.ReplicationTimestamp, bts, err = msgp.ReadTimeBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ReplicationTimestamp")
				return
			}
		case "Checksum":
			z.Checksum, bts, err = msgp.ReadBytesBytes(bts, z.Checksum)
			if err != nil {
				err = msgp.WrapError(err, "Checksum")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ReplicateObjectInfo) Msgsize() (s int) {
	s = 3 + 5 + msgp.StringPrefixSize + len(z.Name) + 7 + msgp.StringPrefixSize + len(z.Bucket) + 10 + msgp.StringPrefixSize + len(z.VersionID) + 5 + msgp.StringPrefixSize + len(z.ETag) + 5 + msgp.Int64Size + 11 + msgp.Int64Size + 8 + msgp.TimeSize + 9 + msgp.StringPrefixSize + len(z.UserTags) + 5 + msgp.BoolSize + 18 + z.ReplicationStatus.Msgsize() + 26 + msgp.StringPrefixSize + len(z.ReplicationStatusInternal) + 27 + msgp.StringPrefixSize + len(z.VersionPurgeStatusInternal) + 19 + z.VersionPurgeStatus.Msgsize() + 17 + z.ReplicationState.Msgsize() + 13 + msgp.BoolSize + 7 + z.OpType.Msgsize() + 10 + msgp.StringPrefixSize + len(z.EventType) + 11 + msgp.Uint32Size + 8 + msgp.StringPrefixSize + len(z.ResetID) + 4 + z.Dsc.Msgsize() + 18 + z.ExistingObjResync.Msgsize() + 10 + msgp.StringPrefixSize + len(z.TargetArn) + 15 + msgp.MapHeaderSize
	if z.TargetStatuses != nil {
		for za0001, za0002 := range z.TargetStatuses {
			_ = za0002
			s += msgp.StringPrefixSize + len(za0001) + za0002.Msgsize()
		}
	}
	s += 20 + msgp.MapHeaderSize
	if z.TargetPurgeStatuses != nil {
		for za0003, za0004 := range z.TargetPurgeStatuses {
			_ = za0004
			s += msgp.StringPrefixSize + len(za0003) + za0004.Msgsize()
		}
	}
	s += 21 + msgp.TimeSize + 9 + msgp.BytesPrefixSize + len(z.Checksum)
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TransitionedObject) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "Name"
	o = append(o, 0x85, 0xa4, 0x4e, 0x61, 0x6d, 0x65)
	o = msgp.AppendString(o, z.Name)
	// string "VersionID"
	o = append(o, 0xa9, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x44)
	o = msgp.AppendString(o, z.VersionID)
	// string "Tier"
	o = append(o, 0xa4, 0x54, 0x69, 0x65, 0x72)
	o = msgp.AppendString(o, z.Tier)
	// string "FreeVersion"
	o = append(o, 0xab, 0x46, 0x72, 0x65, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e)
	o = msgp.AppendBool(o, z.FreeVersion)
	// string "Status"
	o = append(o, 0xa6, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73)
	o = msgp.AppendString(o, z.Status)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TransitionedObject) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "Name":
			z.Name, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Name")
				return
			}
		case "VersionID":
			z.VersionID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "VersionID")
				return
			}
		case "Tier":
			z.Tier, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Tier")
				return
			}
		case "FreeVersion":
			z.FreeVersion, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "FreeVersion")
				return
			}
		case "Status":
			z.Status, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Status")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TransitionedObject) Msgsize() (s int) {
	s = 1 + 5 + msgp.StringPrefixSize + len(z.Name) + 10 + msgp.StringPrefixSize + len(z.VersionID) + 5 + msgp.StringPrefixSize + len(z.Tier) + 12 + msgp.BoolSize + 7 + msgp.StringPrefixSize + len(z.Status)
	return
}
