"no use strict";

var console = {
    log: function(msgs) {
        postMessage({type: "log", data: arguments.join(" ")});
    }
};
var window = {
    console: console
};

var normalizeModule = function(parentId, moduleName) {
    // normalize plugin requires
    if (moduleName.indexOf("!") !== -1) {
        var chunks = moduleName.split("!");
        return normalizeModule(parentId, chunks[0]) + "!" + normalizeModule(parentId, chunks[1]);
    }
    // normalize relative requires
    if (moduleName.charAt(0) == ".") {
        var base = parentId.split("/").slice(0, -1).join("/");
        var moduleName = base + "/" + moduleName;
        
        while(moduleName.indexOf(".") !== -1 && previous != moduleName) {
            var previous = moduleName;
            var moduleName = moduleName.replace(/\/\.\//, "/").replace(/[^\/]+\/\.\.\//, "");
        }
    }
    
    return moduleName;
};

var require = function(parentId, id) {
    if (!id.charAt)
        throw new Error("worker.js require() accepts only (parentId, id) as arguments");

    var id = normalizeModule(parentId, id);
    
    var module = require.modules[id];
    if (module) {
        if (!module.initialized) {
            module.initialized = true;
            module.exports = module.factory().exports;
        }
        return module.exports;
    }
    
    var chunks = id.split("/");
    chunks[0] = require.tlns[chunks[0]] || chunks[0];
    var path = chunks.join("/") + ".js";
    
    require.id = id;
    importScripts(path);
    return require(parentId, id);    
};

require.modules = {};
require.tlns = {};

var define = function(id, deps, factory) {
    if (arguments.length == 2) {
        factory = deps;
        if (typeof id != "string") {
            deps = id;
            id = require.id;
        }
    } else if (arguments.length == 1) {
        factory = id;
        id = require.id;
    }

    if (id.indexOf("text!") === 0) 
        return;
    
    var req = function(deps, factory) {
        return require(id, deps, factory);
    };

    require.modules[id] = {
        factory: function() {
            var module = {
                exports: {}
            };
            var returnExports = factory(req, module.exports, module);
            if (returnExports)
                module.exports = returnExports;
            return module;
        }
    };
};

function initBaseUrls(topLevelNamespaces) {
    require.tlns = topLevelNamespaces;
}

function initSender() {

    var EventEmitter = require(null, "ace/lib/event_emitter").EventEmitter;
    var oop = require(null, "ace/lib/oop");
    
    var Sender = function() {};
    
    (function() {
        
        oop.implement(this, EventEmitter);
                
        this.callback = function(data, callbackId) {
            postMessage({
                type: "call",
                id: callbackId,
                data: data
            });
        };
    
        this.emit = function(name, data) {
            postMessage({
                type: "event",
                name: name,
                data: data
            });
        };
        
    }).call(Sender.prototype);
    
    return new Sender();
}

var main;
var sender;

onmessage = function(e) {
    var msg = e.data;
    if (msg.command) {
        main[msg.command].apply(main, msg.args);
    }
    else if (msg.init) {        
        initBaseUrls(msg.tlns);
        require(null, "ace/lib/fixoldbrowsers");
        sender = initSender();
        var clazz = require(null, msg.module)[msg.classname];
        main = new clazz(sender);
    } 
    else if (msg.event && sender) {
        sender._emit(msg.event, msg.data);
    }
};
// vim:set ts=4 sts=4 sw=4 st:
// -- kriskowal Kris Kowal Copyright (C) 2009-2010 MIT License
// -- tlrobinson Tom Robinson Copyright (C) 2009-2010 MIT License (Narwhal Project)
// -- dantman Daniel Friesen Copyright(C) 2010 XXX No License Specified
// -- fschaefer Florian Schäfer Copyright (C) 2010 MIT License
// -- Irakli Gozalishvili Copyright (C) 2010 MIT License

/*!
    Copyright (c) 2009, 280 North Inc. http://280north.com/
    MIT License. http://github.com/280north/narwhal/blob/master/README.md
*/

define('ace/lib/fixoldbrowsers', ['require', 'exports', 'module' , 'ace/lib/regexp', 'ace/lib/es5-shim'], function(require, exports, module) {


require("./regexp");
require("./es5-shim");

});
 
define('ace/lib/regexp', ['require', 'exports', 'module' ], function(require, exports, module) {


    //---------------------------------
    //  Private variables
    //---------------------------------

    var real = {
            exec: RegExp.prototype.exec,
            test: RegExp.prototype.test,
            match: String.prototype.match,
            replace: String.prototype.replace,
            split: String.prototype.split
        },
        compliantExecNpcg = real.exec.call(/()??/, "")[1] === undefined, // check `exec` handling of nonparticipating capturing groups
        compliantLastIndexIncrement = function () {
            var x = /^/g;
            real.test.call(x, "");
            return !x.lastIndex;
        }();

    if (compliantLastIndexIncrement && compliantExecNpcg)
        return;

    //---------------------------------
    //  Overriden native methods
    //---------------------------------

    // Adds named capture support (with backreferences returned as `result.name`), and fixes two
    // cross-browser issues per ES3:
    // - Captured values for nonparticipating capturing groups should be returned as `undefined`,
    //   rather than the empty string.
    // - `lastIndex` should not be incremented after zero-length matches.
    RegExp.prototype.exec = function (str) {
        var match = real.exec.apply(this, arguments),
            name, r2;
        if ( typeof(str) == 'string' && match) {
            // Fix browsers whose `exec` methods don't consistently return `undefined` for
            // nonparticipating capturing groups
            if (!compliantExecNpcg && match.length > 1 && indexOf(match, "") > -1) {
                r2 = RegExp(this.source, real.replace.call(getNativeFlags(this), "g", ""));
                // Using `str.slice(match.index)` rather than `match[0]` in case lookahead allowed
                // matching due to characters outside the match
                real.replace.call(str.slice(match.index), r2, function () {
                    for (var i = 1; i < arguments.length - 2; i++) {
                        if (arguments[i] === undefined)
                            match[i] = undefined;
                    }
                });
            }
            // Attach named capture properties
            if (this._xregexp && this._xregexp.captureNames) {
                for (var i = 1; i < match.length; i++) {
                    name = this._xregexp.captureNames[i - 1];
                    if (name)
                       match[name] = match[i];
                }
            }
            // Fix browsers that increment `lastIndex` after zero-length matches
            if (!compliantLastIndexIncrement && this.global && !match[0].length && (this.lastIndex > match.index))
                this.lastIndex--;
        }
        return match;
    };

    // Don't override `test` if it won't change anything
    if (!compliantLastIndexIncrement) {
        // Fix browser bug in native method
        RegExp.prototype.test = function (str) {
            // Use the native `exec` to skip some processing overhead, even though the overriden
            // `exec` would take care of the `lastIndex` fix
            var match = real.exec.call(this, str);
            // Fix browsers that increment `lastIndex` after zero-length matches
            if (match && this.global && !match[0].length && (this.lastIndex > match.index))
                this.lastIndex--;
            return !!match;
        };
    }

    //---------------------------------
    //  Private helper functions
    //---------------------------------

    function getNativeFlags (regex) {
        return (regex.global     ? "g" : "") +
               (regex.ignoreCase ? "i" : "") +
               (regex.multiline  ? "m" : "") +
               (regex.extended   ? "x" : "") + // Proposed for ES4; included in AS3
               (regex.sticky     ? "y" : "");
    }

    function indexOf (array, item, from) {
        if (Array.prototype.indexOf) // Use the native array method if available
            return array.indexOf(item, from);
        for (var i = from || 0; i < array.length; i++) {
            if (array[i] === item)
                return i;
        }
        return -1;
    }

});
// vim: ts=4 sts=4 sw=4 expandtab
// -- kriskowal Kris Kowal Copyright (C) 2009-2011 MIT License
// -- tlrobinson Tom Robinson Copyright (C) 2009-2010 MIT License (Narwhal Project)
// -- dantman Daniel Friesen Copyright (C) 2010 XXX TODO License or CLA
// -- fschaefer Florian Schäfer Copyright (C) 2010 MIT License
// -- Gozala Irakli Gozalishvili Copyright (C) 2010 MIT License
// -- kitcambridge Kit Cambridge Copyright (C) 2011 MIT License
// -- kossnocorp Sasha Koss XXX TODO License or CLA
// -- bryanforbes Bryan Forbes XXX TODO License or CLA
// -- killdream Quildreen Motta Copyright (C) 2011 MIT Licence
// -- michaelficarra Michael Ficarra Copyright (C) 2011 3-clause BSD License
// -- sharkbrainguy Gerard Paapu Copyright (C) 2011 MIT License
// -- bbqsrc Brendan Molloy (C) 2011 Creative Commons Zero (public domain)
// -- iwyg XXX TODO License or CLA
// -- DomenicDenicola Domenic Denicola Copyright (C) 2011 MIT License
// -- xavierm02 Montillet Xavier XXX TODO License or CLA
// -- Raynos Raynos XXX TODO License or CLA
// -- samsonjs Sami Samhuri Copyright (C) 2010 MIT License
// -- rwldrn Rick Waldron Copyright (C) 2011 MIT License
// -- lexer Alexey Zakharov XXX TODO License or CLA

/*!
    Copyright (c) 2009, 280 North Inc. http://280north.com/
    MIT License. http://github.com/280north/narwhal/blob/master/README.md
*/

define('ace/lib/es5-shim', ['require', 'exports', 'module' ], function(require, exports, module) {

/*
 * Brings an environment as close to ECMAScript 5 compliance
 * as is possible with the facilities of erstwhile engines.
 *
 * Annotated ES5: http://es5.github.com/ (specific links below)
 * ES5 Spec: http://www.ecma-international.org/publications/files/ECMA-ST/Ecma-262.pdf
 *
 * @module
 */

/*whatsupdoc*/

//
// Function
// ========
//

// ES-5 15.3.4.5
// http://es5.github.com/#x15.3.4.5

if (!Function.prototype.bind) {
    Function.prototype.bind = function bind(that) { // .length is 1
        // 1. Let Target be the this value.
        var target = this;
        // 2. If IsCallable(Target) is false, throw a TypeError exception.
        if (typeof target != "function")
            throw new TypeError(); // TODO message
        // 3. Let A be a new (possibly empty) internal list of all of the
        //   argument values provided after thisArg (arg1, arg2 etc), in order.
        // XXX slicedArgs will stand in for "A" if used
        var args = slice.call(arguments, 1); // for normal call
        // 4. Let F be a new native ECMAScript object.
        // 11. Set the [[Prototype]] internal property of F to the standard
        //   built-in Function prototype object as specified in 15.3.3.1.
        // 12. Set the [[Call]] internal property of F as described in
        //   15.3.4.5.1.
        // 13. Set the [[Construct]] internal property of F as described in
        //   15.3.4.5.2.
        // 14. Set the [[HasInstance]] internal property of F as described in
        //   15.3.4.5.3.
        var bound = function () {

            if (this instanceof bound) {
                // 15.3.4.5.2 [[Construct]]
                // When the [[Construct]] internal method of a function object,
                // F that was created using the bind function is called with a
                // list of arguments ExtraArgs, the following steps are taken:
                // 1. Let target be the value of F's [[TargetFunction]]
                //   internal property.
                // 2. If target has no [[Construct]] internal method, a
                //   TypeError exception is thrown.
                // 3. Let boundArgs be the value of F's [[BoundArgs]] internal
                //   property.
                // 4. Let args be a new list containing the same values as the
                //   list boundArgs in the same order followed by the same
                //   values as the list ExtraArgs in the same order.
                // 5. Return the result of calling the [[Construct]] internal 
                //   method of target providing args as the arguments.

                var F = function(){};
                F.prototype = target.prototype;
                var self = new F;

                var result = target.apply(
                    self,
                    args.concat(slice.call(arguments))
                );
                if (result !== null && Object(result) === result)
                    return result;
                return self;

            } else {
                // 15.3.4.5.1 [[Call]]
                // When the [[Call]] internal method of a function object, F,
                // which was created using the bind function is called with a
                // this value and a list of arguments ExtraArgs, the following
                // steps are taken:
                // 1. Let boundArgs be the value of F's [[BoundArgs]] internal
                //   property.
                // 2. Let boundThis be the value of F's [[BoundThis]] internal
                //   property.
                // 3. Let target be the value of F's [[TargetFunction]] internal
                //   property.
                // 4. Let args be a new list containing the same values as the 
                //   list boundArgs in the same order followed by the same 
                //   values as the list ExtraArgs in the same order.
                // 5. Return the result of calling the [[Call]] internal method 
                //   of target providing boundThis as the this value and 
                //   providing args as the arguments.

                // equiv: target.call(this, ...boundArgs, ...args)
                return target.apply(
                    that,
                    args.concat(slice.call(arguments))
                );

            }

        };
        // XXX bound.length is never writable, so don't even try
        //
        // 15. If the [[Class]] internal property of Target is "Function", then
        //     a. Let L be the length property of Target minus the length of A.
        //     b. Set the length own property of F to either 0 or L, whichever is 
        //       larger.
        // 16. Else set the length own property of F to 0.
        // 17. Set the attributes of the length own property of F to the values
        //   specified in 15.3.5.1.

        // TODO
        // 18. Set the [[Extensible]] internal property of F to true.
        
        // TODO
        // 19. Let thrower be the [[ThrowTypeError]] function Object (13.2.3).
        // 20. Call the [[DefineOwnProperty]] internal method of F with 
        //   arguments "caller", PropertyDescriptor {[[Get]]: thrower, [[Set]]:
        //   thrower, [[Enumerable]]: false, [[Configurable]]: false}, and 
        //   false.
        // 21. Call the [[DefineOwnProperty]] internal method of F with 
        //   arguments "arguments", PropertyDescriptor {[[Get]]: thrower, 
        //   [[Set]]: thrower, [[Enumerable]]: false, [[Configurable]]: false},
        //   and false.

        // TODO
        // NOTE Function objects created using Function.prototype.bind do not 
        // have a prototype property or the [[Code]], [[FormalParameters]], and
        // [[Scope]] internal properties.
        // XXX can't delete prototype in pure-js.

        // 22. Return F.
        return bound;
    };
}

// Shortcut to an often accessed properties, in order to avoid multiple
// dereference that costs universally.
// _Please note: Shortcuts are defined after `Function.prototype.bind` as we
// us it in defining shortcuts.
var call = Function.prototype.call;
var prototypeOfArray = Array.prototype;
var prototypeOfObject = Object.prototype;
var slice = prototypeOfArray.slice;
var toString = call.bind(prototypeOfObject.toString);
var owns = call.bind(prototypeOfObject.hasOwnProperty);

// If JS engine supports accessors creating shortcuts.
var defineGetter;
var defineSetter;
var lookupGetter;
var lookupSetter;
var supportsAccessors;
if ((supportsAccessors = owns(prototypeOfObject, "__defineGetter__"))) {
    defineGetter = call.bind(prototypeOfObject.__defineGetter__);
    defineSetter = call.bind(prototypeOfObject.__defineSetter__);
    lookupGetter = call.bind(prototypeOfObject.__lookupGetter__);
    lookupSetter = call.bind(prototypeOfObject.__lookupSetter__);
}

//
// Array
// =====
//

// ES5 15.4.3.2
// http://es5.github.com/#x15.4.3.2
// https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/isArray
if (!Array.isArray) {
    Array.isArray = function isArray(obj) {
        return toString(obj) == "[object Array]";
    };
}

// The IsCallable() check in the Array functions
// has been replaced with a strict check on the
// internal class of the object to trap cases where
// the provided function was actually a regular
// expression literal, which in V8 and
// JavaScriptCore is a typeof "function".  Only in
// V8 are regular expression literals permitted as
// reduce parameters, so it is desirable in the
// general case for the shim to match the more
// strict and common behavior of rejecting regular
// expressions.

// ES5 15.4.4.18
// http://es5.github.com/#x15.4.4.18
// https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/array/forEach
if (!Array.prototype.forEach) {
    Array.prototype.forEach = function forEach(fun /*, thisp*/) {
        var self = toObject(this),
            thisp = arguments[1],
            i = 0,
            length = self.length >>> 0;

        // If no callback function or if callback is not a callable function
        if (toString(fun) != "[object Function]") {
            throw new TypeError(); // TODO message
        }

        while (i < length) {
            if (i in self) {
                // Invoke the callback function with call, passing arguments:
                // context, property value, property key, thisArg object context
                fun.call(thisp, self[i], i, self);
            }
            i++;
        }
    };
}

// ES5 15.4.4.19
// http://es5.github.com/#x15.4.4.19
// https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/map
if (!Array.prototype.map) {
    Array.prototype.map = function map(fun /*, thisp*/) {
        var self = toObject(this),
            length = self.length >>> 0,
            result = Array(length),
            thisp = arguments[1];

        // If no callback function or if callback is not a callable function
        if (toString(fun) != "[object Function]") {
            throw new TypeError(); // TODO message
        }

        for (var i = 0; i < length; i++) {
            if (i in self)
                result[i] = fun.call(thisp, self[i], i, self);
        }
        return result;
    };
}

// ES5 15.4.4.20
// http://es5.github.com/#x15.4.4.20
// https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/filter
if (!Array.prototype.filter) {
    Array.prototype.filter = function filter(fun /*, thisp */) {
        var self = toObject(this),
            length = self.length >>> 0,
            result = [],
            thisp = arguments[1];

        // If no callback function or if callback is not a callable function
        if (toString(fun) != "[object Function]") {
            throw new TypeError(); // TODO message
        }

        for (var i = 0; i < length; i++) {
            if (i in self && fun.call(thisp, self[i], i, self))
                result.push(self[i]);
        }
        return result;
    };
}

// ES5 15.4.4.16
// http://es5.github.com/#x15.4.4.16
// https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/every
if (!Array.prototype.every) {
    Array.prototype.every = function every(fun /*, thisp */) {
        var self = toObject(this),
            length = self.length >>> 0,
            thisp = arguments[1];

        // If no callback function or if callback is not a callable function
        if (toString(fun) != "[object Function]") {
            throw new TypeError(); // TODO message
        }

        for (var i = 0; i < length; i++) {
            if (i in self && !fun.call(thisp, self[i], i, self))
                return false;
        }
        return true;
    };
}

// ES5 15.4.4.17
// http://es5.github.com/#x15.4.4.17
// https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/some
if (!Array.prototype.some) {
    Array.prototype.some = function some(fun /*, thisp */) {
        var self = toObject(this),
            length = self.length >>> 0,
            thisp = arguments[1];

        // If no callback function or if callback is not a callable function
        if (toString(fun) != "[object Function]") {
            throw new TypeError(); // TODO message
        }

        for (var i = 0; i < length; i++) {
            if (i in self && fun.call(thisp, self[i], i, self))
                return true;
        }
        return false;
    };
}

// ES5 15.4.4.21
// http://es5.github.com/#x15.4.4.21
// https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/reduce
if (!Array.prototype.reduce) {
    Array.prototype.reduce = function reduce(fun /*, initial*/) {
        var self = toObject(this),
            length = self.length >>> 0;

        // If no callback function or if callback is not a callable function
        if (toString(fun) != "[object Function]") {
            throw new TypeError(); // TODO message
        }

        // no value to return if no initial value and an empty array
        if (!length && arguments.length == 1)
            throw new TypeError(); // TODO message

        var i = 0;
        var result;
        if (arguments.length >= 2) {
            result = arguments[1];
        } else {
            do {
                if (i in self) {
                    result = self[i++];
                    break;
                }

                // if array contains no values, no initial value to return
                if (++i >= length)
                    throw new TypeError(); // TODO message
            } while (true);
        }

        for (; i < length; i++) {
            if (i in self)
                result = fun.call(void 0, result, self[i], i, self);
        }

        return result;
    };
}

// ES5 15.4.4.22
// http://es5.github.com/#x15.4.4.22
// https://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Objects/Array/reduceRight
if (!Array.prototype.reduceRight) {
    Array.prototype.reduceRight = function reduceRight(fun /*, initial*/) {
        var self = toObject(this),
            length = self.length >>> 0;

        // If no callback function or if callback is not a callable function
        if (toString(fun) != "[object Function]") {
            throw new TypeError(); // TODO message
        }

        // no value to return if no initial value, empty array
        if (!length && arguments.length == 1)
            throw new TypeError(); // TODO message

        var result, i = length - 1;
        if (arguments.length >= 2) {
            result = arguments[1];
        } else {
            do {
                if (i in self) {
                    result = self[i--];
                    break;
                }

                // if array contains no values, no initial value to return
                if (--i < 0)
                    throw new TypeError(); // TODO message
            } while (true);
        }

        do {
            if (i in this)
                result = fun.call(void 0, result, self[i], i, self);
        } while (i--);

        return result;
    };
}

// ES5 15.4.4.14
// http://es5.github.com/#x15.4.4.14
// https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/indexOf
if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function indexOf(sought /*, fromIndex */ ) {
        var self = toObject(this),
            length = self.length >>> 0;

        if (!length)
            return -1;

        var i = 0;
        if (arguments.length > 1)
            i = toInteger(arguments[1]);

        // handle negative indices
        i = i >= 0 ? i : Math.max(0, length + i);
        for (; i < length; i++) {
            if (i in self && self[i] === sought) {
                return i;
            }
        }
        return -1;
    };
}

// ES5 15.4.4.15
// http://es5.github.com/#x15.4.4.15
// https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/lastIndexOf
if (!Array.prototype.lastIndexOf) {
    Array.prototype.lastIndexOf = function lastIndexOf(sought /*, fromIndex */) {
        var self = toObject(this),
            length = self.length >>> 0;

        if (!length)
            return -1;
        var i = length - 1;
        if (arguments.length > 1)
            i = Math.min(i, toInteger(arguments[1]));
        // handle negative indices
        i = i >= 0 ? i : length - Math.abs(i);
        for (; i >= 0; i--) {
            if (i in self && sought === self[i])
                return i;
        }
        return -1;
    };
}

//
// Object
// ======
//

// ES5 15.2.3.2
// http://es5.github.com/#x15.2.3.2
if (!Object.getPrototypeOf) {
    // https://github.com/kriskowal/es5-shim/issues#issue/2
    // http://ejohn.org/blog/objectgetprototypeof/
    // recommended by fschaefer on github
    Object.getPrototypeOf = function getPrototypeOf(object) {
        return object.__proto__ || (
            object.constructor ?
            object.constructor.prototype :
            prototypeOfObject
        );
    };
}

// ES5 15.2.3.3
// http://es5.github.com/#x15.2.3.3
if (!Object.getOwnPropertyDescriptor) {
    var ERR_NON_OBJECT = "Object.getOwnPropertyDescriptor called on a " +
                         "non-object: ";
    Object.getOwnPropertyDescriptor = function getOwnPropertyDescriptor(object, property) {
        if ((typeof object != "object" && typeof object != "function") || object === null)
            throw new TypeError(ERR_NON_OBJECT + object);
        // If object does not owns property return undefined immediately.
        if (!owns(object, property))
            return;

        var descriptor, getter, setter;

        // If object has a property then it's for sure both `enumerable` and
        // `configurable`.
        descriptor =  { enumerable: true, configurable: true };

        // If JS engine supports accessor properties then property may be a
        // getter or setter.
        if (supportsAccessors) {
            // Unfortunately `__lookupGetter__` will return a getter even
            // if object has own non getter property along with a same named
            // inherited getter. To avoid misbehavior we temporary remove
            // `__proto__` so that `__lookupGetter__` will return getter only
            // if it's owned by an object.
            var prototype = object.__proto__;
            object.__proto__ = prototypeOfObject;

            var getter = lookupGetter(object, property);
            var setter = lookupSetter(object, property);

            // Once we have getter and setter we can put values back.
            object.__proto__ = prototype;

            if (getter || setter) {
                if (getter) descriptor.get = getter;
                if (setter) descriptor.set = setter;

                // If it was accessor property we're done and return here
                // in order to avoid adding `value` to the descriptor.
                return descriptor;
            }
        }

        // If we got this far we know that object has an own property that is
        // not an accessor so we set it as a value and return descriptor.
        descriptor.value = object[property];
        return descriptor;
    };
}

// ES5 15.2.3.4
// http://es5.github.com/#x15.2.3.4
if (!Object.getOwnPropertyNames) {
    Object.getOwnPropertyNames = function getOwnPropertyNames(object) {
        return Object.keys(object);
    };
}

// ES5 15.2.3.5
// http://es5.github.com/#x15.2.3.5
if (!Object.create) {
    Object.create = function create(prototype, properties) {
        var object;
        if (prototype === null) {
            object = { "__proto__": null };
        } else {
            if (typeof prototype != "object")
                throw new TypeError("typeof prototype["+(typeof prototype)+"] != 'object'");
            var Type = function () {};
            Type.prototype = prototype;
            object = new Type();
            // IE has no built-in implementation of `Object.getPrototypeOf`
            // neither `__proto__`, but this manually setting `__proto__` will
            // guarantee that `Object.getPrototypeOf` will work as expected with
            // objects created using `Object.create`
            object.__proto__ = prototype;
        }
        if (properties !== void 0)
            Object.defineProperties(object, properties);
        return object;
    };
}

// ES5 15.2.3.6
// http://es5.github.com/#x15.2.3.6

// Patch for WebKit and IE8 standard mode
// Designed by hax <hax.github.com>
// related issue: https://github.com/kriskowal/es5-shim/issues#issue/5
// IE8 Reference:
//     http://msdn.microsoft.com/en-us/library/dd282900.aspx
//     http://msdn.microsoft.com/en-us/library/dd229916.aspx
// WebKit Bugs:
//     https://bugs.webkit.org/show_bug.cgi?id=36423

function doesDefinePropertyWork(object) {
    try {
        Object.defineProperty(object, "sentinel", {});
        return "sentinel" in object;
    } catch (exception) {
        // returns falsy
    }
}

// check whether defineProperty works if it's given. Otherwise,
// shim partially.
if (Object.defineProperty) {
    var definePropertyWorksOnObject = doesDefinePropertyWork({});
    var definePropertyWorksOnDom = typeof document == "undefined" ||
        doesDefinePropertyWork(document.createElement("div"));
    if (!definePropertyWorksOnObject || !definePropertyWorksOnDom) {
        var definePropertyFallback = Object.defineProperty;
    }
}

if (!Object.defineProperty || definePropertyFallback) {
    var ERR_NON_OBJECT_DESCRIPTOR = "Property description must be an object: ";
    var ERR_NON_OBJECT_TARGET = "Object.defineProperty called on non-object: "
    var ERR_ACCESSORS_NOT_SUPPORTED = "getters & setters can not be defined " +
                                      "on this javascript engine";

    Object.defineProperty = function defineProperty(object, property, descriptor) {
        if ((typeof object != "object" && typeof object != "function") || object === null)
            throw new TypeError(ERR_NON_OBJECT_TARGET + object);
        if ((typeof descriptor != "object" && typeof descriptor != "function") || descriptor === null)
            throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR + descriptor);

        // make a valiant attempt to use the real defineProperty
        // for I8's DOM elements.
        if (definePropertyFallback) {
            try {
                return definePropertyFallback.call(Object, object, property, descriptor);
            } catch (exception) {
                // try the shim if the real one doesn't work
            }
        }

        // If it's a data property.
        if (owns(descriptor, "value")) {
            // fail silently if "writable", "enumerable", or "configurable"
            // are requested but not supported
            /*
            // alternate approach:
            if ( // can't implement these features; allow false but not true
                !(owns(descriptor, "writable") ? descriptor.writable : true) ||
                !(owns(descriptor, "enumerable") ? descriptor.enumerable : true) ||
                !(owns(descriptor, "configurable") ? descriptor.configurable : true)
            )
                throw new RangeError(
                    "This implementation of Object.defineProperty does not " +
                    "support configurable, enumerable, or writable."
                );
            */

            if (supportsAccessors && (lookupGetter(object, property) ||
                                      lookupSetter(object, property)))
            {
                // As accessors are supported only on engines implementing
                // `__proto__` we can safely override `__proto__` while defining
                // a property to make sure that we don't hit an inherited
                // accessor.
                var prototype = object.__proto__;
                object.__proto__ = prototypeOfObject;
                // Deleting a property anyway since getter / setter may be
                // defined on object itself.
                delete object[property];
                object[property] = descriptor.value;
                // Setting original `__proto__` back now.
                object.__proto__ = prototype;
            } else {
                object[property] = descriptor.value;
            }
        } else {
            if (!supportsAccessors)
                throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);
            // If we got that far then getters and setters can be defined !!
            if (owns(descriptor, "get"))
                defineGetter(object, property, descriptor.get);
            if (owns(descriptor, "set"))
                defineSetter(object, property, descriptor.set);
        }

        return object;
    };
}

// ES5 15.2.3.7
// http://es5.github.com/#x15.2.3.7
if (!Object.defineProperties) {
    Object.defineProperties = function defineProperties(object, properties) {
        for (var property in properties) {
            if (owns(properties, property))
                Object.defineProperty(object, property, properties[property]);
        }
        return object;
    };
}

// ES5 15.2.3.8
// http://es5.github.com/#x15.2.3.8
if (!Object.seal) {
    Object.seal = function seal(object) {
        // this is misleading and breaks feature-detection, but
        // allows "securable" code to "gracefully" degrade to working
        // but insecure code.
        return object;
    };
}

// ES5 15.2.3.9
// http://es5.github.com/#x15.2.3.9
if (!Object.freeze) {
    Object.freeze = function freeze(object) {
        // this is misleading and breaks feature-detection, but
        // allows "securable" code to "gracefully" degrade to working
        // but insecure code.
        return object;
    };
}

// detect a Rhino bug and patch it
try {
    Object.freeze(function () {});
} catch (exception) {
    Object.freeze = (function freeze(freezeObject) {
        return function freeze(object) {
            if (typeof object == "function") {
                return object;
            } else {
                return freezeObject(object);
            }
        };
    })(Object.freeze);
}

// ES5 15.2.3.10
// http://es5.github.com/#x15.2.3.10
if (!Object.preventExtensions) {
    Object.preventExtensions = function preventExtensions(object) {
        // this is misleading and breaks feature-detection, but
        // allows "securable" code to "gracefully" degrade to working
        // but insecure code.
        return object;
    };
}

// ES5 15.2.3.11
// http://es5.github.com/#x15.2.3.11
if (!Object.isSealed) {
    Object.isSealed = function isSealed(object) {
        return false;
    };
}

// ES5 15.2.3.12
// http://es5.github.com/#x15.2.3.12
if (!Object.isFrozen) {
    Object.isFrozen = function isFrozen(object) {
        return false;
    };
}

// ES5 15.2.3.13
// http://es5.github.com/#x15.2.3.13
if (!Object.isExtensible) {
    Object.isExtensible = function isExtensible(object) {
        // 1. If Type(O) is not Object throw a TypeError exception.
        if (Object(object) === object) {
            throw new TypeError(); // TODO message
        }
        // 2. Return the Boolean value of the [[Extensible]] internal property of O.
        var name = '';
        while (owns(object, name)) {
            name += '?';
        }
        object[name] = true;
        var returnValue = owns(object, name);
        delete object[name];
        return returnValue;
    };
}

// ES5 15.2.3.14
// http://es5.github.com/#x15.2.3.14
if (!Object.keys) {
    // http://whattheheadsaid.com/2010/10/a-safer-object-keys-compatibility-implementation
    var hasDontEnumBug = true,
        dontEnums = [
            "toString",
            "toLocaleString",
            "valueOf",
            "hasOwnProperty",
            "isPrototypeOf",
            "propertyIsEnumerable",
            "constructor"
        ],
        dontEnumsLength = dontEnums.length;

    for (var key in {"toString": null})
        hasDontEnumBug = false;

    Object.keys = function keys(object) {

        if ((typeof object != "object" && typeof object != "function") || object === null)
            throw new TypeError("Object.keys called on a non-object");

        var keys = [];
        for (var name in object) {
            if (owns(object, name)) {
                keys.push(name);
            }
        }

        if (hasDontEnumBug) {
            for (var i = 0, ii = dontEnumsLength; i < ii; i++) {
                var dontEnum = dontEnums[i];
                if (owns(object, dontEnum)) {
                    keys.push(dontEnum);
                }
            }
        }

        return keys;
    };

}

//
// Date
// ====
//

// ES5 15.9.5.43
// http://es5.github.com/#x15.9.5.43
// This function returns a String value represent the instance in time 
// represented by this Date object. The format of the String is the Date Time 
// string format defined in 15.9.1.15. All fields are present in the String. 
// The time zone is always UTC, denoted by the suffix Z. If the time value of 
// this object is not a finite Number a RangeError exception is thrown.
if (!Date.prototype.toISOString || (new Date(-62198755200000).toISOString().indexOf('-000001') === -1)) {
    Date.prototype.toISOString = function toISOString() {
        var result, length, value, year;
        if (!isFinite(this))
            throw new RangeError;

        // the date time string format is specified in 15.9.1.15.
        result = [this.getUTCMonth() + 1, this.getUTCDate(),
            this.getUTCHours(), this.getUTCMinutes(), this.getUTCSeconds()];
        year = this.getUTCFullYear();
        year = (year < 0 ? '-' : (year > 9999 ? '+' : '')) + ('00000' + Math.abs(year)).slice(0 <= year && year <= 9999 ? -4 : -6);

        length = result.length;
        while (length--) {
            value = result[length];
            // pad months, days, hours, minutes, and seconds to have two digits.
            if (value < 10)
                result[length] = "0" + value;
        }
        // pad milliseconds to have three digits.
        return year + "-" + result.slice(0, 2).join("-") + "T" + result.slice(2).join(":") + "." +
            ("000" + this.getUTCMilliseconds()).slice(-3) + "Z";
    }
}

// ES5 15.9.4.4
// http://es5.github.com/#x15.9.4.4
if (!Date.now) {
    Date.now = function now() {
        return new Date().getTime();
    };
}

// ES5 15.9.5.44
// http://es5.github.com/#x15.9.5.44
// This function provides a String representation of a Date object for use by 
// JSON.stringify (15.12.3).
if (!Date.prototype.toJSON) {
    Date.prototype.toJSON = function toJSON(key) {
        // When the toJSON method is called with argument key, the following 
        // steps are taken:

        // 1.  Let O be the result of calling ToObject, giving it the this
        // value as its argument.
        // 2. Let tv be ToPrimitive(O, hint Number).
        // 3. If tv is a Number and is not finite, return null.
        // XXX
        // 4. Let toISO be the result of calling the [[Get]] internal method of
        // O with argument "toISOString".
        // 5. If IsCallable(toISO) is false, throw a TypeError exception.
        if (typeof this.toISOString != "function")
            throw new TypeError(); // TODO message
        // 6. Return the result of calling the [[Call]] internal method of
        //  toISO with O as the this value and an empty argument list.
        return this.toISOString();

        // NOTE 1 The argument is ignored.

        // NOTE 2 The toJSON function is intentionally generic; it does not
        // require that its this value be a Date object. Therefore, it can be
        // transferred to other kinds of objects for use as a method. However,
        // it does require that any such object have a toISOString method. An
        // object is free to use the argument key to filter its
        // stringification.
    };
}

// ES5 15.9.4.2
// http://es5.github.com/#x15.9.4.2
// based on work shared by Daniel Friesen (dantman)
// http://gist.github.com/303249
if (Date.parse("+275760-09-13T00:00:00.000Z") !== 8.64e15) {
    // XXX global assignment won't work in embeddings that use
    // an alternate object for the context.
    Date = (function(NativeDate) {

        // Date.length === 7
        var Date = function Date(Y, M, D, h, m, s, ms) {
            var length = arguments.length;
            if (this instanceof NativeDate) {
                var date = length == 1 && String(Y) === Y ? // isString(Y)
                    // We explicitly pass it through parse:
                    new NativeDate(Date.parse(Y)) :
                    // We have to manually make calls depending on argument
                    // length here
                    length >= 7 ? new NativeDate(Y, M, D, h, m, s, ms) :
                    length >= 6 ? new NativeDate(Y, M, D, h, m, s) :
                    length >= 5 ? new NativeDate(Y, M, D, h, m) :
                    length >= 4 ? new NativeDate(Y, M, D, h) :
                    length >= 3 ? new NativeDate(Y, M, D) :
                    length >= 2 ? new NativeDate(Y, M) :
                    length >= 1 ? new NativeDate(Y) :
                                  new NativeDate();
                // Prevent mixups with unfixed Date object
                date.constructor = Date;
                return date;
            }
            return NativeDate.apply(this, arguments);
        };

        // 15.9.1.15 Date Time String Format.
        var isoDateExpression = new RegExp("^" +
            "(\\d{4}|[\+\-]\\d{6})" + // four-digit year capture or sign + 6-digit extended year
            "(?:-(\\d{2})" + // optional month capture
            "(?:-(\\d{2})" + // optional day capture
            "(?:" + // capture hours:minutes:seconds.milliseconds
                "T(\\d{2})" + // hours capture
                ":(\\d{2})" + // minutes capture
                "(?:" + // optional :seconds.milliseconds
                    ":(\\d{2})" + // seconds capture
                    "(?:\\.(\\d{3}))?" + // milliseconds capture
                ")?" +
            "(?:" + // capture UTC offset component
                "Z|" + // UTC capture
                "(?:" + // offset specifier +/-hours:minutes
                    "([-+])" + // sign capture
                    "(\\d{2})" + // hours offset capture
                    ":(\\d{2})" + // minutes offset capture
                ")" +
            ")?)?)?)?" +
        "$");

        // Copy any custom methods a 3rd party library may have added
        for (var key in NativeDate)
            Date[key] = NativeDate[key];

        // Copy "native" methods explicitly; they may be non-enumerable
        Date.now = NativeDate.now;
        Date.UTC = NativeDate.UTC;
        Date.prototype = NativeDate.prototype;
        Date.prototype.constructor = Date;

        // Upgrade Date.parse to handle simplified ISO 8601 strings
        Date.parse = function parse(string) {
            var match = isoDateExpression.exec(string);
            if (match) {
                match.shift(); // kill match[0], the full match
                // parse months, days, hours, minutes, seconds, and milliseconds
                for (var i = 1; i < 7; i++) {
                    // provide default values if necessary
                    match[i] = +(match[i] || (i < 3 ? 1 : 0));
                    // match[1] is the month. Months are 0-11 in JavaScript
                    // `Date` objects, but 1-12 in ISO notation, so we
                    // decrement.
                    if (i == 1)
                        match[i]--;
                }

                // parse the UTC offset component
                var minuteOffset = +match.pop(), hourOffset = +match.pop(), sign = match.pop();

                // compute the explicit time zone offset if specified
                var offset = 0;
                if (sign) {
                    // detect invalid offsets and return early
                    if (hourOffset > 23 || minuteOffset > 59)
                        return NaN;

                    // express the provided time zone offset in minutes. The offset is
                    // negative for time zones west of UTC; positive otherwise.
                    offset = (hourOffset * 60 + minuteOffset) * 6e4 * (sign == "+" ? -1 : 1);
                }

                // Date.UTC for years between 0 and 99 converts year to 1900 + year
                // The Gregorian calendar has a 400-year cycle, so 
                // to Date.UTC(year + 400, .... ) - 12622780800000 == Date.UTC(year, ...),
                // where 12622780800000 - number of milliseconds in Gregorian calendar 400 years
                var year = +match[0];
                if (0 <= year && year <= 99) {
                    match[0] = year + 400;
                    return NativeDate.UTC.apply(this, match) + offset - 12622780800000;
                }

                // compute a new UTC date value, accounting for the optional offset
                return NativeDate.UTC.apply(this, match) + offset;
            }
            return NativeDate.parse.apply(this, arguments);
        };

        return Date;
    })(Date);
}

//
// String
// ======
//

// ES5 15.5.4.20
// http://es5.github.com/#x15.5.4.20
var ws = "\x09\x0A\x0B\x0C\x0D\x20\xA0\u1680\u180E\u2000\u2001\u2002\u2003" +
    "\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028" +
    "\u2029\uFEFF";
if (!String.prototype.trim || ws.trim()) {
    // http://blog.stevenlevithan.com/archives/faster-trim-javascript
    // http://perfectionkills.com/whitespace-deviations/
    ws = "[" + ws + "]";
    var trimBeginRegexp = new RegExp("^" + ws + ws + "*"),
        trimEndRegexp = new RegExp(ws + ws + "*$");
    String.prototype.trim = function trim() {
        return String(this).replace(trimBeginRegexp, "").replace(trimEndRegexp, "");
    };
}

//
// Util
// ======
//

// ES5 9.4
// http://es5.github.com/#x9.4
// http://jsperf.com/to-integer
var toInteger = function (n) {
    n = +n;
    if (n !== n) // isNaN
        n = 0;
    else if (n !== 0 && n !== (1/0) && n !== -(1/0))
        n = (n > 0 || -1) * Math.floor(Math.abs(n));
    return n;
};

var prepareString = "a"[0] != "a",
    // ES5 9.9
    // http://es5.github.com/#x9.9
    toObject = function (o) {
        if (o == null) { // this matches both null and undefined
            throw new TypeError(); // TODO message
        }
        // If the implementation doesn't support by-index access of
        // string characters (ex. IE < 7), split the string
        if (prepareString && typeof o == "string" && o) {
            return o.split("");
        }
        return Object(o);
    };
});

define('ace/lib/event_emitter', ['require', 'exports', 'module' ], function(require, exports, module) {


var EventEmitter = {};

EventEmitter._emit =
EventEmitter._dispatchEvent = function(eventName, e) {
    this._eventRegistry = this._eventRegistry || {};
    this._defaultHandlers = this._defaultHandlers || {};

    var listeners = this._eventRegistry[eventName] || [];
    var defaultHandler = this._defaultHandlers[eventName];
    if (!listeners.length && !defaultHandler)
        return;

    if (typeof e != "object" || !e)
        e = {};

    if (!e.type)
        e.type = eventName;
    
    if (!e.stopPropagation) {
        e.stopPropagation = function() {
            this.propagationStopped = true;
        };
    }
    
    if (!e.preventDefault) {
        e.preventDefault = function() {
            this.defaultPrevented = true;
        };
    }

    for (var i=0; i<listeners.length; i++) {
        listeners[i](e);
        if (e.propagationStopped)
            break;
    }
    
    if (defaultHandler && !e.defaultPrevented)
        return defaultHandler(e);
};

EventEmitter.setDefaultHandler = function(eventName, callback) {
    this._defaultHandlers = this._defaultHandlers || {};
    
    if (this._defaultHandlers[eventName])
        throw new Error("The default handler for '" + eventName + "' is already set");
        
    this._defaultHandlers[eventName] = callback;
};

EventEmitter.on =
EventEmitter.addEventListener = function(eventName, callback) {
    this._eventRegistry = this._eventRegistry || {};

    var listeners = this._eventRegistry[eventName];
    if (!listeners)
        listeners = this._eventRegistry[eventName] = [];

    if (listeners.indexOf(callback) == -1)
        listeners.push(callback);
};

EventEmitter.removeListener =
EventEmitter.removeEventListener = function(eventName, callback) {
    this._eventRegistry = this._eventRegistry || {};

    var listeners = this._eventRegistry[eventName];
    if (!listeners)
        return;

    var index = listeners.indexOf(callback);
    if (index !== -1)
        listeners.splice(index, 1);
};

EventEmitter.removeAllListeners = function(eventName) {
    if (this._eventRegistry) this._eventRegistry[eventName] = [];
};

exports.EventEmitter = EventEmitter;

});

define('ace/lib/oop', ['require', 'exports', 'module' ], function(require, exports, module) {


exports.inherits = (function() {
    var tempCtor = function() {};
    return function(ctor, superCtor) {
        tempCtor.prototype = superCtor.prototype;
        ctor.super_ = superCtor.prototype;
        ctor.prototype = new tempCtor();
        ctor.prototype.constructor = ctor;
    };
}());

exports.mixin = function(obj, mixin) {
    for (var key in mixin) {
        obj[key] = mixin[key];
    }
};

exports.implement = function(proto, mixin) {
    exports.mixin(proto, mixin);
};

});
 
define('ace/mode/xquery_worker', ['require', 'exports', 'module' , 'ace/lib/oop', 'ace/worker/mirror', 'ace/mode/xquery/xquery', 'ace/tokenizer', 'ace/mode/xquery_highlight_rules'], function(require, exports, module) {

    
var oop = require("../lib/oop");
var Mirror = require("../worker/mirror").Mirror;
var xquery = require("../mode/xquery/xquery");
var Tokenizer = require("../tokenizer").Tokenizer;
var XQueryHighlightRules = require("./xquery_highlight_rules").XQueryHighlightRules;

window.addEventListener = function() {};


var XQueryWorker = exports.XQueryWorker = function(sender) {
    Mirror.call(this, sender);
    this.setTimeout(200);
};

oop.inherits(XQueryWorker, Mirror);

(function() {
    
  this.onUpdate = function() {
    this.sender.emit("start");
    var value = this.doc.getValue();    
    var parser = xquery.getParser(value);
    var ast = parser.p_Module();
    if(parser.hasErrors()) {
		  var errors = parser.getErrors();
	    var i = 0;
      for(i in errors) {
	      var error = errors[i];
	      this.sender.emit("error", {
	        row: error.line,
          column: error.column,
	        text: error.message,
	        type: "error"
       });
      }	
    } else {
     this.sender.emit("ok");
    }
    parser.highlighter.tokenizer = new Tokenizer(new XQueryHighlightRules().getRules());
    var tokens = parser.highlighter.getTokens();
    this.sender.emit("highlight", tokens);
  };
    
}).call(XQueryWorker.prototype);

});
define('ace/worker/mirror', ['require', 'exports', 'module' , 'ace/document', 'ace/lib/lang'], function(require, exports, module) {


var Document = require("../document").Document;
var lang = require("../lib/lang");
    
var Mirror = exports.Mirror = function(sender) {
    this.sender = sender;
    var doc = this.doc = new Document("");
    
    var deferredUpdate = this.deferredUpdate = lang.deferredCall(this.onUpdate.bind(this));
    
    var _self = this;
    sender.on("change", function(e) {
        doc.applyDeltas([e.data]);        
        deferredUpdate.schedule(_self.$timeout);
    });
};

(function() {
    
    this.$timeout = 500;
    
    this.setTimeout = function(timeout) {
        this.$timeout = timeout;
    };
    
    this.setValue = function(value) {
        this.doc.setValue(value);
        this.deferredUpdate.schedule(this.$timeout);
    };
    
    this.getValue = function(callbackId) {
        this.sender.callback(this.doc.getValue(), callbackId);
    };
    
    this.onUpdate = function() {
        // abstract method
    };
    
}).call(Mirror.prototype);

});

define('ace/document', ['require', 'exports', 'module' , 'ace/lib/oop', 'ace/lib/event_emitter', 'ace/range', 'ace/anchor'], function(require, exports, module) {


var oop = require("./lib/oop");
var EventEmitter = require("./lib/event_emitter").EventEmitter;
var Range = require("./range").Range;
var Anchor = require("./anchor").Anchor;

 /**
 * new Document([text])
 * - text (String | Array): The starting text
 *
 * Creates a new `Document`. If `text` is included, the `Document` contains those strings; otherwise, it's empty.
 *
 **/

var Document = function(text) {
    this.$lines = [];

    // There has to be one line at least in the document. If you pass an empty
    // string to the insert function, nothing will happen. Workaround.
    if (text.length == 0) {
        this.$lines = [""];
    } else if (Array.isArray(text)) {
        this.insertLines(0, text);
    } else {
        this.insert({row: 0, column:0}, text);
    }
};

(function() {

    oop.implement(this, EventEmitter);
    this.setValue = function(text) {
        var len = this.getLength();
        this.remove(new Range(0, 0, len, this.getLine(len-1).length));
        this.insert({row: 0, column:0}, text);
    };
    this.getValue = function() {
        return this.getAllLines().join(this.getNewLineCharacter());
    };
    this.createAnchor = function(row, column) {
        return new Anchor(this, row, column);
    };

    // check for IE split bug
    if ("aaa".split(/a/).length == 0)
        this.$split = function(text) {
            return text.replace(/\r\n|\r/g, "\n").split("\n");
        }
    else
        this.$split = function(text) {
            return text.split(/\r\n|\r|\n/);
        };
    this.$detectNewLine = function(text) {
        var match = text.match(/^.*?(\r\n|\r|\n)/m);
        if (match) {
            this.$autoNewLine = match[1];
        } else {
            this.$autoNewLine = "\n";
        }
    };
    this.getNewLineCharacter = function() {
      switch (this.$newLineMode) {
          case "windows":
              return "\r\n";

          case "unix":
              return "\n";

          case "auto":
              return this.$autoNewLine;
      }
    };

    this.$autoNewLine = "\n";
    this.$newLineMode = "auto";
    this.setNewLineMode = function(newLineMode) {
        if (this.$newLineMode === newLineMode)
            return;

        this.$newLineMode = newLineMode;
    };
    this.getNewLineMode = function() {
        return this.$newLineMode;
    };
    this.isNewLine = function(text) {
        return (text == "\r\n" || text == "\r" || text == "\n");
    };
    this.getLine = function(row) {
        return this.$lines[row] || "";
    };
    this.getLines = function(firstRow, lastRow) {
        return this.$lines.slice(firstRow, lastRow + 1);
    };
    this.getAllLines = function() {
        return this.getLines(0, this.getLength());
    };
    this.getLength = function() {
        return this.$lines.length;
    };
    this.getTextRange = function(range) {
        if (range.start.row == range.end.row) {
            return this.$lines[range.start.row].substring(range.start.column,
                                                         range.end.column);
        }
        else {
            var lines = this.getLines(range.start.row+1, range.end.row-1);
            lines.unshift((this.$lines[range.start.row] || "").substring(range.start.column));
            lines.push((this.$lines[range.end.row] || "").substring(0, range.end.column));
            return lines.join(this.getNewLineCharacter());
        }
    };
    this.$clipPosition = function(position) {
        var length = this.getLength();
        if (position.row >= length) {
            position.row = Math.max(0, length - 1);
            position.column = this.getLine(length-1).length;
        }
        return position;
    };
    this.insert = function(position, text) {
        if (!text || text.length === 0)
            return position;

        position = this.$clipPosition(position);

        // only detect new lines if the document has no line break yet
        if (this.getLength() <= 1)
            this.$detectNewLine(text);

        var lines = this.$split(text);
        var firstLine = lines.splice(0, 1)[0];
        var lastLine = lines.length == 0 ? null : lines.splice(lines.length - 1, 1)[0];

        position = this.insertInLine(position, firstLine);
        if (lastLine !== null) {
            position = this.insertNewLine(position); // terminate first line
            position = this.insertLines(position.row, lines);
            position = this.insertInLine(position, lastLine || "");
        }
        return position;
    };
    /**
     * Document@change(e)
     * - e (Object): Contains at least one property called `"action"`. `"action"` indicates the action that triggered the change. Each action also has a set of additional properties.
     *
     * Fires whenever the document changes.
     *
     * Several methods trigger different `"change"` events. Below is a list of each action type, followed by each property that's also available:
     *
     *  * `"insertLines"` (emitted by [[Document.insertLines]])
     *    * `range`: the [[Range]] of the change within the document
     *    * `lines`: the lines in the document that are changing
     *  * `"insertText"` (emitted by [[Document.insertNewLine]])
     *    * `range`: the [[Range]] of the change within the document
     *    * `text`: the text that's being added
     *  * `"removeLines"` (emitted by [[Document.insertLines]])
     *    * `range`: the [[Range]] of the change within the document
     *    * `lines`: the lines in the document that were removed
     *    * `nl`: the new line character (as defined by [[Document.getNewLineCharacter]])
     *  * `"removeText"` (emitted by [[Document.removeInLine]] and [[Document.removeNewLine]])
     *    * `range`: the [[Range]] of the change within the document
     *    * `text`: the text that's being removed
     *
     **/
    this.insertLines = function(row, lines) {
        if (lines.length == 0)
            return {row: row, column: 0};

        // apply doesn't work for big arrays (smallest threshold is on safari 0xFFFF)
        // to circumvent that we have to break huge inserts into smaller chunks here
        if (lines.length > 0xFFFF) {
            var end = this.insertLines(row, lines.slice(0xFFFF));
            lines = lines.slice(0, 0xFFFF);
        }

        var args = [row, 0];
        args.push.apply(args, lines);
        this.$lines.splice.apply(this.$lines, args);

        var range = new Range(row, 0, row + lines.length, 0);
        var delta = {
            action: "insertLines",
            range: range,
            lines: lines
        };
        this._emit("change", { data: delta });
        return end || range.end;
    };
    this.insertNewLine = function(position) {
        position = this.$clipPosition(position);
        var line = this.$lines[position.row] || "";

        this.$lines[position.row] = line.substring(0, position.column);
        this.$lines.splice(position.row + 1, 0, line.substring(position.column, line.length));

        var end = {
            row : position.row + 1,
            column : 0
        };

        var delta = {
            action: "insertText",
            range: Range.fromPoints(position, end),
            text: this.getNewLineCharacter()
        };
        this._emit("change", { data: delta });

        return end;
    };
    this.insertInLine = function(position, text) {
        if (text.length == 0)
            return position;

        var line = this.$lines[position.row] || "";

        this.$lines[position.row] = line.substring(0, position.column) + text
                + line.substring(position.column);

        var end = {
            row : position.row,
            column : position.column + text.length
        };

        var delta = {
            action: "insertText",
            range: Range.fromPoints(position, end),
            text: text
        };
        this._emit("change", { data: delta });

        return end;
    };
    this.remove = function(range) {
        // clip to document
        range.start = this.$clipPosition(range.start);
        range.end = this.$clipPosition(range.end);

        if (range.isEmpty())
            return range.start;

        var firstRow = range.start.row;
        var lastRow = range.end.row;

        if (range.isMultiLine()) {
            var firstFullRow = range.start.column == 0 ? firstRow : firstRow + 1;
            var lastFullRow = lastRow - 1;

            if (range.end.column > 0)
                this.removeInLine(lastRow, 0, range.end.column);

            if (lastFullRow >= firstFullRow)
                this.removeLines(firstFullRow, lastFullRow);

            if (firstFullRow != firstRow) {
                this.removeInLine(firstRow, range.start.column, this.getLine(firstRow).length);
                this.removeNewLine(range.start.row);
            }
        }
        else {
            this.removeInLine(firstRow, range.start.column, range.end.column);
        }
        return range.start;
    };
    this.removeInLine = function(row, startColumn, endColumn) {
        if (startColumn == endColumn)
            return;

        var range = new Range(row, startColumn, row, endColumn);
        var line = this.getLine(row);
        var removed = line.substring(startColumn, endColumn);
        var newLine = line.substring(0, startColumn) + line.substring(endColumn, line.length);
        this.$lines.splice(row, 1, newLine);

        var delta = {
            action: "removeText",
            range: range,
            text: removed
        };
        this._emit("change", { data: delta });
        return range.start;
    };
    this.removeLines = function(firstRow, lastRow) {
        var range = new Range(firstRow, 0, lastRow + 1, 0);
        var removed = this.$lines.splice(firstRow, lastRow - firstRow + 1);

        var delta = {
            action: "removeLines",
            range: range,
            nl: this.getNewLineCharacter(),
            lines: removed
        };
        this._emit("change", { data: delta });
        return removed;
    };
    this.removeNewLine = function(row) {
        var firstLine = this.getLine(row);
        var secondLine = this.getLine(row+1);

        var range = new Range(row, firstLine.length, row+1, 0);
        var line = firstLine + secondLine;

        this.$lines.splice(row, 2, line);

        var delta = {
            action: "removeText",
            range: range,
            text: this.getNewLineCharacter()
        };
        this._emit("change", { data: delta });
    };
    this.replace = function(range, text) {
        if (text.length == 0 && range.isEmpty())
            return range.start;

        // Shortcut: If the text we want to insert is the same as it is already
        // in the document, we don't have to replace anything.
        if (text == this.getTextRange(range))
            return range.end;

        this.remove(range);
        if (text) {
            var end = this.insert(range.start, text);
        }
        else {
            end = range.start;
        }

        return end;
    };
    this.applyDeltas = function(deltas) {
        for (var i=0; i<deltas.length; i++) {
            var delta = deltas[i];
            var range = Range.fromPoints(delta.range.start, delta.range.end);

            if (delta.action == "insertLines")
                this.insertLines(range.start.row, delta.lines);
            else if (delta.action == "insertText")
                this.insert(range.start, delta.text);
            else if (delta.action == "removeLines")
                this.removeLines(range.start.row, range.end.row - 1);
            else if (delta.action == "removeText")
                this.remove(range);
        }
    };
    this.revertDeltas = function(deltas) {
        for (var i=deltas.length-1; i>=0; i--) {
            var delta = deltas[i];

            var range = Range.fromPoints(delta.range.start, delta.range.end);

            if (delta.action == "insertLines")
                this.removeLines(range.start.row, range.end.row - 1);
            else if (delta.action == "insertText")
                this.remove(range);
            else if (delta.action == "removeLines")
                this.insertLines(range.start.row, delta.lines);
            else if (delta.action == "removeText")
                this.insert(range.start, delta.text);
        }
    };

}).call(Document.prototype);

exports.Document = Document;
});

define('ace/range', ['require', 'exports', 'module' ], function(require, exports, module) {


/**
 * class Range
 *
 * This object is used in various places to indicate a region within the editor. To better visualize how this works, imagine a rectangle. Each quadrant of the rectangle is analogus to a range, as ranges contain a starting row and starting column, and an ending row, and ending column.
 *
 **/

/**
 * new Range(startRow, startColumn, endRow, endColumn)
 * - startRow (Number): The starting row
 * - startColumn (Number): The starting column
 * - endRow (Number): The ending row
 * - endColumn (Number): The ending column
 *
 * Creates a new `Range` object with the given starting and ending row and column points.
 *
 **/
var Range = function(startRow, startColumn, endRow, endColumn) {
    this.start = {
        row: startRow,
        column: startColumn
    };

    this.end = {
        row: endRow,
        column: endColumn
    };
};

(function() {
    /**
     * Range.isEqual(range) -> Boolean
     * - range (Range): A range to check against
     *
     * Returns `true` if and only if the starting row and column, and ending tow and column, are equivalent to those given by `range`.
     *
     **/ 
    this.isEqual = function(range) {
        return this.start.row == range.start.row &&
            this.end.row == range.end.row &&
            this.start.column == range.start.column &&
            this.end.column == range.end.column
    }; 
    this.toString = function() {
        return ("Range: [" + this.start.row + "/" + this.start.column +
            "] -> [" + this.end.row + "/" + this.end.column + "]");
    }; 

    this.contains = function(row, column) {
        return this.compare(row, column) == 0;
    }; 
    this.compareRange = function(range) {
        var cmp,
            end = range.end,
            start = range.start;

        cmp = this.compare(end.row, end.column);
        if (cmp == 1) {
            cmp = this.compare(start.row, start.column);
            if (cmp == 1) {
                return 2;
            } else if (cmp == 0) {
                return 1;
            } else {
                return 0;
            }
        } else if (cmp == -1) {
            return -2;
        } else {
            cmp = this.compare(start.row, start.column);
            if (cmp == -1) {
                return -1;
            } else if (cmp == 1) {
                return 42;
            } else {
                return 0;
            }
        }
    }

    /** related to: Range.compare
     * Range.comparePoint(p) -> Number
     * - p (Range): A point to compare with
     * + (Number): This method returns one of the following numbers:<br/>
     * * `0` if the two points are exactly equal<br/>
     * * `-1` if `p.row` is less then the calling range<br/>
     * * `1` if `p.row` is greater than the calling range<br/>
     * <br/>
     * If the starting row of the calling range is equal to `p.row`, and:<br/>
     * * `p.column` is greater than or equal to the calling range's starting column, this returns `0`<br/>
     * * Otherwise, it returns -1<br/>
     *<br/>
     * If the ending row of the calling range is equal to `p.row`, and:<br/>
     * * `p.column` is less than or equal to the calling range's ending column, this returns `0`<br/>
     * * Otherwise, it returns 1<br/>
     *
     * Checks the row and column points of `p` with the row and column points of the calling range.
     *
     * 
     *
     **/ 
    this.comparePoint = function(p) {
        return this.compare(p.row, p.column);
    }

    /** related to: Range.comparePoint
     * Range.containsRange(range) -> Boolean
     * - range (Range): A range to compare with
     *
     * Checks the start and end points of `range` and compares them to the calling range. Returns `true` if the `range` is contained within the caller's range.
     *
     **/ 
    this.containsRange = function(range) {
        return this.comparePoint(range.start) == 0 && this.comparePoint(range.end) == 0;
    }

    /**
     * Range.intersects(range) -> Boolean
     * - range (Range): A range to compare with
     *
     * Returns `true` if passed in `range` intersects with the one calling this method.
     *
     **/
    this.intersects = function(range) {
        var cmp = this.compareRange(range);
        return (cmp == -1 || cmp == 0 || cmp == 1);
    }

    /**
     * Range.isEnd(row, column) -> Boolean
     * - row (Number): A row point to compare with
     * - column (Number): A column point to compare with
     *
     * Returns `true` if the caller's ending row point is the same as `row`, and if the caller's ending column is the same as `column`.
     *
     **/
    this.isEnd = function(row, column) {
        return this.end.row == row && this.end.column == column;
    }

    /**
     * Range.isStart(row, column) -> Boolean
     * - row (Number): A row point to compare with
     * - column (Number): A column point to compare with
     *
     * Returns `true` if the caller's starting row point is the same as `row`, and if the caller's starting column is the same as `column`.
     *
     **/ 
    this.isStart = function(row, column) {
        return this.start.row == row && this.start.column == column;
    }

    /**
     * Range.setStart(row, column)
     * - row (Number): A row point to set
     * - column (Number): A column point to set
     *
     * Sets the starting row and column for the range.
     *
     **/ 
    this.setStart = function(row, column) {
        if (typeof row == "object") {
            this.start.column = row.column;
            this.start.row = row.row;
        } else {
            this.start.row = row;
            this.start.column = column;
        }
    }

    /**
     * Range.setEnd(row, column)
     * - row (Number): A row point to set
     * - column (Number): A column point to set
     *
     * Sets the starting row and column for the range.
     *
     **/ 
    this.setEnd = function(row, column) {
        if (typeof row == "object") {
            this.end.column = row.column;
            this.end.row = row.row;
        } else {
            this.end.row = row;
            this.end.column = column;
        }
    }

    /** related to: Range.compare
     * Range.inside(row, column) -> Boolean
     * - row (Number): A row point to compare with
     * - column (Number): A column point to compare with
     *
     * Returns `true` if the `row` and `column` are within the given range.
     *
     **/ 
    this.inside = function(row, column) {
        if (this.compare(row, column) == 0) {
            if (this.isEnd(row, column) || this.isStart(row, column)) {
                return false;
            } else {
                return true;
            }
        }
        return false;
    }

    /** related to: Range.compare
     * Range.insideStart(row, column) -> Boolean
     * - row (Number): A row point to compare with
     * - column (Number): A column point to compare with
     *
     * Returns `true` if the `row` and `column` are within the given range's starting points.
     *
     **/ 
    this.insideStart = function(row, column) {
        if (this.compare(row, column) == 0) {
            if (this.isEnd(row, column)) {
                return false;
            } else {
                return true;
            }
        }
        return false;
    }

    /** related to: Range.compare
     * Range.insideEnd(row, column) -> Boolean
     * - row (Number): A row point to compare with
     * - column (Number): A column point to compare with
     *
     * Returns `true` if the `row` and `column` are within the given range's ending points.
     *
     **/ 
    this.insideEnd = function(row, column) {
        if (this.compare(row, column) == 0) {
            if (this.isStart(row, column)) {
                return false;
            } else {
                return true;
            }
        }
        return false;
    }

    /** 
     * Range.compare(row, column) -> Number
     * - row (Number): A row point to compare with
     * - column (Number): A column point to compare with
     * + (Number): This method returns one of the following numbers:<br/>
     * * `0` if the two points are exactly equal <br/>
     * * `-1` if `p.row` is less then the calling range <br/>
     * * `1` if `p.row` is greater than the calling range <br/>
     *  <br/>
     * If the starting row of the calling range is equal to `p.row`, and: <br/>
     * * `p.column` is greater than or equal to the calling range's starting column, this returns `0`<br/>
     * * Otherwise, it returns -1<br/>
     * <br/>
     * If the ending row of the calling range is equal to `p.row`, and: <br/>
     * * `p.column` is less than or equal to the calling range's ending column, this returns `0` <br/>
     * * Otherwise, it returns 1
     *
     * Checks the row and column points with the row and column points of the calling range.
     *
     *
     **/
    this.compare = function(row, column) {
        if (!this.isMultiLine()) {
            if (row === this.start.row) {
                return column < this.start.column ? -1 : (column > this.end.column ? 1 : 0);
            };
        }

        if (row < this.start.row)
            return -1;

        if (row > this.end.row)
            return 1;

        if (this.start.row === row)
            return column >= this.start.column ? 0 : -1;

        if (this.end.row === row)
            return column <= this.end.column ? 0 : 1;

        return 0;
    };
    this.compareStart = function(row, column) {
        if (this.start.row == row && this.start.column == column) {
            return -1;
        } else {
            return this.compare(row, column);
        }
    }

    /**
     * Range.compareEnd(row, column) -> Number
     * - row (Number): A row point to compare with
     * - column (Number): A column point to compare with
     * + (Number): This method returns one of the following numbers:<br/>
     * * `0` if the two points are exactly equal<br/>
     * * `-1` if `p.row` is less then the calling range<br/>
     * * `1` if `p.row` is greater than the calling range, or if `isEnd` is `true.<br/>
     * <br/>
     * If the starting row of the calling range is equal to `p.row`, and:<br/>
     * * `p.column` is greater than or equal to the calling range's starting column, this returns `0`<br/>
     * * Otherwise, it returns -1<br/>
     *<br/>
     * If the ending row of the calling range is equal to `p.row`, and:<br/>
     * * `p.column` is less than or equal to the calling range's ending column, this returns `0`<br/>
     * * Otherwise, it returns 1
     *
     * Checks the row and column points with the row and column points of the calling range.
     *
     *
     **/
    this.compareEnd = function(row, column) {
        if (this.end.row == row && this.end.column == column) {
            return 1;
        } else {
            return this.compare(row, column);
        }
    }

    /** 
     * Range.compareInside(row, column) -> Number
     * - row (Number): A row point to compare with
     * - column (Number): A column point to compare with
     * + (Number): This method returns one of the following numbers:<br/>
     * * `1` if the ending row of the calling range is equal to `row`, and the ending column of the calling range is equal to `column`<br/>
     * * `-1` if the starting row of the calling range is equal to `row`, and the starting column of the calling range is equal to `column`<br/>
     * <br/>
     * Otherwise, it returns the value after calling [[Range.compare `compare()`]].
     *
     * Checks the row and column points with the row and column points of the calling range.
     *
     *
     *
     **/
    this.compareInside = function(row, column) {
        if (this.end.row == row && this.end.column == column) {
            return 1;
        } else if (this.start.row == row && this.start.column == column) {
            return -1;
        } else {
            return this.compare(row, column);
        }
    }

    /** 
     * Range.clipRows(firstRow, lastRow) -> Range
     * - firstRow (Number): The starting row
     * - lastRow (Number): The ending row
     *
     * Returns the part of the current `Range` that occurs within the boundaries of `firstRow` and `lastRow` as a new `Range` object.
     *
    **/
    this.clipRows = function(firstRow, lastRow) {
        if (this.end.row > lastRow) {
            var end = {
                row: lastRow+1,
                column: 0
            };
        }

        if (this.start.row > lastRow) {
            var start = {
                row: lastRow+1,
                column: 0
            };
        }

        if (this.start.row < firstRow) {
            var start = {
                row: firstRow,
                column: 0
            };
        }

        if (this.end.row < firstRow) {
            var end = {
                row: firstRow,
                column: 0
            };
        }
        return Range.fromPoints(start || this.start, end || this.end);
    };
    this.extend = function(row, column) {
        var cmp = this.compare(row, column);

        if (cmp == 0)
            return this;
        else if (cmp == -1)
            var start = {row: row, column: column};
        else
            var end = {row: row, column: column};

        return Range.fromPoints(start || this.start, end || this.end);
    };

    this.isEmpty = function() {
        return (this.start.row == this.end.row && this.start.column == this.end.column);
    };
    this.isMultiLine = function() {
        return (this.start.row !== this.end.row);
    };
    this.clone = function() {
        return Range.fromPoints(this.start, this.end);
    };
    this.collapseRows = function() {
        if (this.end.column == 0)
            return new Range(this.start.row, 0, Math.max(this.start.row, this.end.row-1), 0)
        else
            return new Range(this.start.row, 0, this.end.row, 0)
    };
    this.toScreenRange = function(session) {
        var screenPosStart =
            session.documentToScreenPosition(this.start);
        var screenPosEnd =
            session.documentToScreenPosition(this.end);

        return new Range(
            screenPosStart.row, screenPosStart.column,
            screenPosEnd.row, screenPosEnd.column
        );
    };

}).call(Range.prototype);
Range.fromPoints = function(start, end) {
    return new Range(start.row, start.column, end.row, end.column);
};

exports.Range = Range;
});

define('ace/anchor', ['require', 'exports', 'module' , 'ace/lib/oop', 'ace/lib/event_emitter'], function(require, exports, module) {


var oop = require("./lib/oop");
var EventEmitter = require("./lib/event_emitter").EventEmitter;

/**
 * new Anchor(doc, row, column)
 * - doc (Document): The document to associate with the anchor
 * - row (Number): The starting row position
 * - column (Number): The starting column position
 *
 * Creates a new `Anchor` and associates it with a document.
 *
 **/

var Anchor = exports.Anchor = function(doc, row, column) {
    this.document = doc;
    
    if (typeof column == "undefined")
        this.setPosition(row.row, row.column);
    else
        this.setPosition(row, column);

    this.$onChange = this.onChange.bind(this);
    doc.on("change", this.$onChange);
};

(function() {

    oop.implement(this, EventEmitter);

    this.getPosition = function() {
        return this.$clipPositionToDocument(this.row, this.column);
    };
        
    this.getDocument = function() {
        return this.document;
    };

    this.onChange = function(e) {
        var delta = e.data;
        var range = delta.range;
            
        if (range.start.row == range.end.row && range.start.row != this.row)
            return;
            
        if (range.start.row > this.row)
            return;
            
        if (range.start.row == this.row && range.start.column > this.column)
            return;
    
        var row = this.row;
        var column = this.column;
        
        if (delta.action === "insertText") {
            if (range.start.row === row && range.start.column <= column) {
                if (range.start.row === range.end.row) {
                    column += range.end.column - range.start.column;
                }
                else {
                    column -= range.start.column;
                    row += range.end.row - range.start.row;
                }
            }
            else if (range.start.row !== range.end.row && range.start.row < row) {
                row += range.end.row - range.start.row;
            }
        } else if (delta.action === "insertLines") {
            if (range.start.row <= row) {
                row += range.end.row - range.start.row;
            }
        }
        else if (delta.action == "removeText") {
            if (range.start.row == row && range.start.column < column) {
                if (range.end.column >= column)
                    column = range.start.column;
                else
                    column = Math.max(0, column - (range.end.column - range.start.column));
                
            } else if (range.start.row !== range.end.row && range.start.row < row) {
                if (range.end.row == row) {
                    column = Math.max(0, column - range.end.column) + range.start.column;
                }
                row -= (range.end.row - range.start.row);
            }
            else if (range.end.row == row) {
                row -= range.end.row - range.start.row;
                column = Math.max(0, column - range.end.column) + range.start.column;
            }
        } else if (delta.action == "removeLines") {
            if (range.start.row <= row) {
                if (range.end.row <= row)
                    row -= range.end.row - range.start.row;
                else {
                    row = range.start.row;
                    column = 0;
                }
            }
        }

        this.setPosition(row, column, true);
    };

    this.setPosition = function(row, column, noClip) {
        var pos;
        if (noClip) {
            pos = {
                row: row,
                column: column
            };
        }
        else {
            pos = this.$clipPositionToDocument(row, column);
        }
        
        if (this.row == pos.row && this.column == pos.column)
            return;
            
        var old = {
            row: this.row,
            column: this.column
        };
        
        this.row = pos.row;
        this.column = pos.column;
        this._emit("change", {
            old: old,
            value: pos
        });
    };

    this.detach = function() {
        this.document.removeEventListener("change", this.$onChange);
    };

    this.$clipPositionToDocument = function(row, column) {
        var pos = {};
    
        if (row >= this.document.getLength()) {
            pos.row = Math.max(0, this.document.getLength() - 1);
            pos.column = this.document.getLine(pos.row).length;
        }
        else if (row < 0) {
            pos.row = 0;
            pos.column = 0;
        }
        else {
            pos.row = row;
            pos.column = Math.min(this.document.getLine(pos.row).length, Math.max(0, column));
        }
        
        if (column < 0)
            pos.column = 0;
            
        return pos;
    };
    
}).call(Anchor.prototype);

});

define('ace/lib/lang', ['require', 'exports', 'module' ], function(require, exports, module) {


exports.stringReverse = function(string) {
    return string.split("").reverse().join("");
};

exports.stringRepeat = function (string, count) {
     return new Array(count + 1).join(string);
};

var trimBeginRegexp = /^\s\s*/;
var trimEndRegexp = /\s\s*$/;

exports.stringTrimLeft = function (string) {
    return string.replace(trimBeginRegexp, '');
};

exports.stringTrimRight = function (string) {
    return string.replace(trimEndRegexp, '');
};

exports.copyObject = function(obj) {
    var copy = {};
    for (var key in obj) {
        copy[key] = obj[key];
    }
    return copy;
};

exports.copyArray = function(array){
    var copy = [];
    for (var i=0, l=array.length; i<l; i++) {
        if (array[i] && typeof array[i] == "object")
            copy[i] = this.copyObject( array[i] );
        else 
            copy[i] = array[i];
    }
    return copy;
};

exports.deepCopy = function (obj) {
    if (typeof obj != "object") {
        return obj;
    }
    
    var copy = obj.constructor();
    for (var key in obj) {
        if (typeof obj[key] == "object") {
            copy[key] = this.deepCopy(obj[key]);
        } else {
            copy[key] = obj[key];
        }
    }
    return copy;
};

exports.arrayToMap = function(arr) {
    var map = {};
    for (var i=0; i<arr.length; i++) {
        map[arr[i]] = 1;
    }
    return map;

};

exports.createMap = function(props) {
    var map = Object.create(null);
    for (var i in props) {
        map[i] = props[i];
    }
    return map;
};
exports.arrayRemove = function(array, value) {
  for (var i = 0; i <= array.length; i++) {
    if (value === array[i]) {
      array.splice(i, 1);
    }
  }
};

exports.escapeRegExp = function(str) {
    return str.replace(/([.*+?^${}()|[\]\/\\])/g, '\\$1');
};

exports.getMatchOffsets = function(string, regExp) {
    var matches = [];

    string.replace(regExp, function(str) {
        matches.push({
            offset: arguments[arguments.length-2],
            length: str.length
        });
    });

    return matches;
};


exports.deferredCall = function(fcn) {

    var timer = null;
    var callback = function() {
        timer = null;
        fcn();
    };

    var deferred = function(timeout) {
        deferred.cancel();
        timer = setTimeout(callback, timeout || 0);
        return deferred;
    };

    deferred.schedule = deferred;

    deferred.call = function() {
        this.cancel();
        fcn();
        return deferred;
    };

    deferred.cancel = function() {
        clearTimeout(timer);
        timer = null;
        return deferred;
    };

    return deferred;
};

});
 
define('ace/mode/xquery/xquery', ['require', 'exports', 'module' , 'ace/mode/xquery/antlr3-all', 'ace/mode/xquery/XQueryLexer', 'ace/mode/xquery/XQueryParser'], function(require, exports, module) {

  var antlr = require("./antlr3-all");
  var org =  antlr.org;
  var NewLazyTokenStream = antlr.NewLazyTokenStream;
  var XQueryLexer   = require("./XQueryLexer").XQueryLexer;
  var XQueryParser  = require("./XQueryParser").XQueryParser;

  exports.getParser = function(code) {
    var cstream = new org.antlr.runtime.ANTLRStringStream(code);
    var lexer = new XQueryLexer(cstream);
    var tstream = new NewLazyTokenStream(lexer);
    tstream.jumpToFirstValidToken();
    var parser = new XQueryParser(tstream);
    parser.setSource(cstream);
    return parser;
  };
});
/*
Some portions:
Copyright (c) 2008, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.net/yui/license.txt
version: 2.5.1
*/
define('ace/mode/xquery/antlr3-all', ['require', 'exports', 'module' ], function(require, exports, module) {
var NewLazyTokenStream = exports.NewLazyTokenStream = function(tokenSource) {

  this.tokenSource = tokenSource;
  this.tokens = [];
  this.isWsExplicit = false;
  this.p = 0;
  this.channel = org.antlr.runtime.Token.DEFAULT_CHANNEL;
  
  this.LT = function(k) {
    if (k == 0)
      return null;
    if (k < 0)
      return this.readReverseNthGoodToken(-k);

    return this.readNthGoodToken(k);
  };

  this.get = function(i) {
    if (i >= this.tokens.length)
      return org.antlr.runtime.Token.EOF_TOKEN;
    else
      return this.tokens[i];
  };

  this.getTokenSource = function() {
    return this.tokenSource;
  };

  this.toString = function(start, stop) {
     if(start == undefined) {
       return this.toString(0, this.tokens.length - 1);
     } else
     if(start instanceof org.antlr.runtime.Token) {
       return this.toString(start.getTokenIndex(), stop.getTokenIndex());
     } else {
      if (start < 0)
        start = 0;
      if (this.p <= stop) {
        this.readNTokens(stop - this.p + 1);
      }

          var sb = "";
          for (var i = start; i <= stop && i < this.tokens.length; i++) {
              sb += this.tokens[i].getText();
          }
          return sb;
      }
    };

    this.LA = function(i) {
        return this.LT(i).getType();
    };

    this.done = false;

    this.consume = function() {
        if (this.done) {
          return;
        }
        this.p++;
        if (!this.isWsExplicit) {
            this.jumpToFirstValidToken();
        }
    };

    this.getSourceName = function() {
      return this.getTokenSource().getSourceName();
    };

    this.index = function() {
        return this.p;
    };

    this.mark = function() {
        this.lastMarker = this.index();
        return this.lastMarker;
    };

    this.release = function(marker) {
    };

    this.rewind = function(marker) {
      if(arguments.length == 1) {
        this.seek(marker);
      } else {
        this.seek(this.lastMarker);
      }
    };

    this.seek = function(index) {
        this.p = index;
        this.done = false;
    };

    this.size = function() {
        return this.tokens.length;
    };

    this.setTokenSource = function(source) {
        this.tokenSource = source;
        this.setWsExplicit(source.isWsExplicit);
        // un-read the unused tokens
        // they are different for the new source
        if (this.p < this.tokens.length) {
            var rIndex = this.p > 0 ? this.tokens[this.p - 1].getStopIndex() : 0;
            this.tokenSource.rewindToIndex(rIndex + 1);
            for (var i = this.tokens.length - 1; i >= this.p; i--) {
                this.tokens.splice(i, 1);
            }
        }

        // if we ignore WS, jump to next token
        if (!this.isWsExplicit) {
            this.jumpToFirstValidToken();
        }
    };

    this.setWsExplicit = function(explicit) {
        this.isWsExplicit = explicit;
        if (!explicit) {
          this.jumpToFirstValidToken();
        }
    };

    this.readNthGoodToken = function(n) {
        var count = this.tokens.length;
        // number of buffered tokens available
        var avt = count - this.p;
        // i counts good tokens, j counts all tokens
        var i = 1, j = 0;
        var t = null;
        while (i <= n) {
            if (j < avt) // read from buffer
                t = this.tokens[this.p + j];
            else { // read from source
                t = this.tokenSource.nextToken();
                if (t == org.antlr.runtime.Token.EOF_TOKEN) {
                    return t;
                }
                t.setTokenIndex(count++);
                this.tokens.push(t);
            }
            if (this.isWsExplicit || t.getChannel() == this.channel) {
               i++;
            }
            j++;
        }
        return t;
    };

    this.readReverseNthGoodToken = function(n) {
        if (n == 0 || (this.p - n) < 0)
            return null;

        // i counts good tokens, j counts all tokens
        var i = 1, j = 0;
        var t = null;
        while (this.p - 1 - j >= 0) {
            t = this.get(this.p - 1 - j);

            if (this.isWsExplicit || t.getChannel() == this.channel) {
                if (i++ == n)
                    return t;
            }
            j++;
        }
        return null;
    };

    this.readNTokens = function(n) {
        var t = null;
        for (var i = 0; i < n; i++) {
            if (this.tokens.length > this.p + i)
                continue;

            t = this.tokenSource.nextToken();
            if (t == org.antlr.runtime.Token.EOF_TOKEN)
                return;
            
            t.setTokenIndex(this.p + i);
            this.tokens.push(t);
        }
    };

    this.jumpToFirstValidToken = function() {
        var t = this.LT(1);
        if (t != org.antlr.runtime.Token.EOF_TOKEN) {
            this.done = false;
            this.p = t.getTokenIndex();
        }
    }; 
};

// create org.antlr module
if (typeof org == "undefined" || !org) {
    var org = {};
}
if (typeof org.antlr == "undefined" || !org.antlr) {
    /**
     * The org.antlr global namespace object.  If antlr is already defined, the
     * existing antlr object will not be overwritten so that defined
     * namespaces are preserved.
     * @namespace org.antlr
     */
    org.antlr = {};
}

/**
 * The global JavaScript object.
 */
org.antlr.global = (function() {
    return this;
}).call(null);
org.antlr.namespace = function() {
    var a=arguments, o=null, i, j, d;
    for (i=0; i<a.length; i=i+1) {
        d=a[i].split(".");
        o=org.antlr.global;

        // ANTLR is implied, so it is ignored if it is included
        for (j=0; j<d.length; j=j+1) {
            o[d[j]]=o[d[j]] || {};
            o=o[d[j]];
        }
    }

    return o;
};
org.antlr.env = org.antlr.env || {};
/**
 * JavaScript runtime library tree parser code.
 * @name org.antlr.runtime.tree
 * @namespace
 */
org.antlr.namespace("org.antlr.runtime.tree");
org.antlr.lang = org.antlr.lang || /** @lends org.antlr.lang */ {
    /**
     * Determines whether or not the provided object is an array.
     * Testing typeof/instanceof/constructor of arrays across frame 
     * boundaries isn't possible in Safari unless you have a reference
     * to the other frame to test against its Array prototype.  To
     * handle this case, we test well-known array properties instead.
     * properties.
     * @param {any} o The object being testing
     * @return {boolean} the result
     */
    isArray: function(o) { 
        if (o) {
           var l = org.antlr.lang;
           return l.isNumber(o.length) && l.isFunction(o.splice);
        }
        return false;
    },

    /**
     * Determines whether or not the provided object is a boolean
     * @param {any} o The object being testing
     * @return {boolean} the result
     */
    isBoolean: function(o) {
        return typeof o === 'boolean';
    },
    
    /**
     * Determines whether or not the provided object is a function
     * @param {any} o The object being testing
     * @return {boolean} the result
     */
    isFunction: function(o) {
        return typeof o === 'function';
    },
        
    /**
     * Determines whether or not the provided object is null
     * @param {any} o The object being testing
     * @return {boolean} the result
     */
    isNull: function(o) {
        return o === null;
    },
        
    /**
     * Determines whether or not the provided object is a legal number
     * @param {any} o The object being testing
     * @return {boolean} the result
     */
    isNumber: function(o) {
        return typeof o === 'number' && isFinite(o);
    },
      
    /**
     * Determines whether or not the provided object is of type object
     * or function
     * @param {any} o The object being testing
     * @return {boolean} the result
     */  
    isObject: function(o) {
return (o && (typeof o === 'object' || org.antlr.lang.isFunction(o))) || false;
    },
        
    /**
     * Determines whether or not the provided object is a string
     * @param {any} o The object being testing
     * @return {boolean} the result
     */
    isString: function(o) {
        return typeof o === 'string';
    },
        
    /**
     * Determines whether or not the provided object is undefined
     * @param {any} o The object being testing
     * @return {boolean} the result
     */
    isUndefined: function(o) {
        return typeof o === 'undefined';
    },
    
    /**
     * IE will not enumerate native functions in a derived object even if the
     * function was overridden.  This is a workaround for specific functions 
     * we care about on the Object prototype. 
     * @param {Function} r  the object to receive the augmentation
     * @param {Function} s  the object that supplies the properties to augment
     * @private
     */
    _IEEnumFix: function(r, s) {
        if (false) {
            var add=["toString", "valueOf"], i;
            for (i=0;i<add.length;i=i+1) {
                var fname=add[i],f=s[fname];
                if (org.antlr.lang.isFunction(f) && f!=Object.prototype[fname]) {
                    r[fname]=f;
                }
            }
        }
    },
       
    /**
     * Utility to set up the prototype, constructor and superclass properties to
     * support an inheritance strategy that can chain constructors and methods.
     * Static members will not be inherited.
     *
     * @method extend
     * @static
     * @param {Function} subc   the object to modify
     * @param {Function} superc the object to inherit
     * @param {Object} [overrides]  additional properties/methods to add to the
     *                              subclass prototype.  These will override the
     *                              matching items obtained from the superclass 
     *                              if present.
     */
    extend: function(subc, superc, overrides) {
        if (!superc||!subc) {
            throw new Error("org.antlr.lang.extend failed, please check that " +
                            "all dependencies are included.");
        }
        var F = function() {};
        F.prototype=superc.prototype;
        subc.prototype=new F();
        subc.prototype.constructor=subc;
        subc.superclass=superc.prototype;
        if (superc.prototype.constructor == Object.prototype.constructor) {
            superc.prototype.constructor=superc;
        }
    
        if (overrides) {
            for (var i in overrides) {
                subc.prototype[i]=overrides[i];
            }

            org.antlr.lang._IEEnumFix(subc.prototype, overrides);
        }
    },
   
    /**
     * Applies all properties in the supplier to the receiver if the
     * receiver does not have these properties yet.  Optionally, one or 
     * more methods/properties can be specified (as additional 
     * parameters).  This option will overwrite the property if receiver 
     * has it already.  If true is passed as the third parameter, all 
     * properties will be applied and _will_ overwrite properties in 
     * the receiver.
     *
     * @param {Function} r  the object to receive the augmentation
     * @param {Function} s  the object that supplies the properties to augment
     * @param {String*|boolean}  [arguments] zero or more properties methods 
     *        to augment the receiver with.  If none specified, everything
     *        in the supplier will be used unless it would
     *        overwrite an existing property in the receiver. If true
     *        is specified as the third parameter, all properties will
     *        be applied and will overwrite an existing property in
     *        the receiver
     */
    augmentObject: function(r, s) {
        if (!s||!r) {
            throw new Error("Absorb failed, verify dependencies.");
        }
        var a=arguments, i, p, override=a[2];
        if (override && override!==true) { // only absorb the specified properties
            for (i=2; i<a.length; i=i+1) {
                r[a[i]] = s[a[i]];
            }
        } else { // take everything, overwriting only if the third parameter is true
            for (p in s) { 
                if (override || !r[p]) {
                    r[p] = s[p];
                }
            }
            
            org.antlr.lang._IEEnumFix(r, s);
        }
    },
 
    /**
     * Same as org.antlr.lang.augmentObject, except it only applies prototype properties
     * @see org.antlr.lang.augmentObject
     * @param {Function} r  the object to receive the augmentation
     * @param {Function} s  the object that supplies the properties to augment
     * @param {String*|boolean}  [arguments] zero or more properties methods 
     *        to augment the receiver with.  If none specified, everything 
     *        in the supplier will be used unless it would overwrite an existing 
     *        property in the receiver.  if true is specified as the third 
     *        parameter, all properties will be applied and will overwrite an 
     *        existing property in the receiver
     */
    augmentProto: function(r, s) {
        if (!s||!r) {
            throw new Error("Augment failed, verify dependencies.");
        }
        //var a=[].concat(arguments);
        var a=[r.prototype,s.prototype];
        for (var i=2;i<arguments.length;i=i+1) {
            a.push(arguments[i]);
        }
        org.antlr.lang.augmentObject.apply(this, a);
    },

    /**
     * Returns a new object containing all of the properties of
     * all the supplied objects.  The properties from later objects
     * will overwrite those in earlier objects.
     * @param arguments {Object*} the objects to merge
     * @return the new merged object
     */
    merge: function() {
        var o={}, a=arguments;
        for (var i=0, l=a.length; i<l; i=i+1) {
            org.antlr.lang.augmentObject(o, a[i], true);
        }
        return o;
    },

    /**
     * A convenience method for detecting a legitimate non-null value.
     * Returns false for null/undefined/NaN, true for other values, 
     * including 0/false/''
     * @param o {any} the item to test
     * @return {boolean} true if it is not null/undefined/NaN || false
     */
    isValue: function(o) {
        var l = org.antlr.lang;
return (l.isObject(o) || l.isString(o) || l.isNumber(o) || l.isBoolean(o));
    },

    /** @namespace org.antlr.lang.array Array convenience methods. */
    array: /** @lends org.antlr.lang.array */ {
        /**
         * Retrieve the last element of an array. Throws an error if a is not
         * an array or empty.
         * @param a {Array} the array stack to peek in
         * @return the last element of the array
         */
         peek: function(a) {
            if (!org.antlr.lang.isArray(a)) {
                throw new Error("org.antlr.lang.array.peek: a is not an array.");
            }
            var l = a.length;
            if (l<=0) {
                throw new Error("org.antlr.lang.array.peek: a is empty.");
            }
            return a[l-1];
        }
    }
};
org.antlr.runtime = {};
org.antlr.runtime.RecognizerSharedState = function() {
    /** Track the set of token types that can follow any rule invocation.
     *  Stack grows upwards.  When it hits the max, it grows 2x in size
     *  and keeps going.
     */
    this.following = [];

    this._fsp = -1;
    this.errorRecovery = false;
    this.lastErrorIndex = -1;
    this.failed = false;
    this.syntaxErrors = 0;
    this.backtracking = 0;
    this.ruleMemo = null;


    // LEXER FIELDS (must be in same state object to avoid casting
    //               constantly in generated code and Lexer object) :(


    /** The goal of all lexer rules/methods is to create a token object.
     *  This is an instance variable as multiple rules may collaborate to
     *  create a single token.  nextToken will return this object after
     *  matching lexer rule(s).  If you subclass to allow multiple token
     *  emissions, then set this to the last token to be matched or
     *  something nonnull so that the auto token emit mechanism will not
     *  emit another token.
     */
    this.token = null;
    this.tokenStartCharIndex = -1;
    // this.tokenStartLine;
    // this.tokenStartCharPositionInLine;
    // this.channel;
    // this.type;
    this.text = null;
};
org.antlr.runtime.IndexOutOfBoundsException = function(m) {
    org.antlr.runtime.IndexOutOfBoundsException.superclass.constructor.call(this, m);
};

org.antlr.lang.extend(org.antlr.runtime.IndexOutOfBoundsException, Error, {
    name: "org.antlr.runtime.IndexOutOfBoundsException"
});
org.antlr.runtime.RecognitionException = function(input) {
    org.antlr.runtime.RecognitionException.superclass.constructor.call(this);
    this.input = input;
    this.index = input.index();
    if ( input instanceof NewLazyTokenStream ) {//org.antlr.runtime.CommonTokenStream ) {
        this.token = input.LT(1);
        this.line = this.token.getLine();
        this.charPositionInLine = this.token.getCharPositionInLine();
    }
    if ( input instanceof org.antlr.runtime.tree.TreeNodeStream ) {
        this.extractInformationFromTreeNodeStream(input);
    }
    else if ( input instanceof org.antlr.runtime.ANTLRStringStream ) {
        // Note: removed CharStream from hierarchy in JS port so checking for
        // StringStream instead
        this.c = input.LA(1);
        this.line = input.getLine();
        this.charPositionInLine = input.getCharPositionInLine();
    }
    else {
        this.c = input.LA(1);
    }

    this.message = this.toString();
};

org.antlr.lang.extend(org.antlr.runtime.RecognitionException, Error,
/** @lends org.antlr.runtime.RecognitionException.prototype */
{
	/**
     * What input stream did the error occur in?
     */
    input: null,

    /** What is index of token/char were we looking at when the error occurred?
     *  @type Number
     */
	index: null,

	/** The current Token when an error occurred.  Since not all streams
	 *  can retrieve the ith Token, we have to track the Token object.
	 *  For parsers.  Even when it's a tree parser, token might be set.
     *  @type org.antlr.runtime.CommonToken
	 */
	token: null,

	/** If this is a tree parser exception, node is set to the node with
	 *  the problem.
     *  @type Object
	 */
	node: null,

	/** The current char when an error occurred. For lexers.
     *  @type Number
     */
	c: null,

	/** Track the line at which the error occurred in case this is
	 *  generated from a lexer.  We need to track this since the
	 *  unexpected char doesn't carry the line info.
     *  @type Number
	 */
	line: null,

    /** The exception's class name.
     *  @type String
     */
    name: "org.antlr.runtime.RecognitionException",

    /** Position in the line where exception occurred.
     *  @type Number
     */
	charPositionInLine: null,

	/** If you are parsing a tree node stream, you will encounter som
	 *  imaginary nodes w/o line/col info.  We now search backwards looking
	 *  for most recent token with line/col info, but notify getErrorHeader()
	 *  that info is approximate.
     *  @type Boolean
	 */
	approximateLineInfo: null,

    /** Gather exception information from input stream.
     *  @param {org.antlr.runtime.CommonTokenStream|org.antlr.runtime.tree.TreeNodeStream|org.antlr.runtime.ANTLRStringStream} input input stream that has an exception.
     */
	extractInformationFromTreeNodeStream: function(input) {
		var nodes = input,
            priorNode,
            priorPayLoad,
            type,
            text,
            i;

		this.node = nodes.LT(1);
		var adaptor = nodes.getTreeAdaptor(),
		    payload = adaptor.getToken(this.node);
		if ( payload ) {
			this.token = payload;
			if ( payload.getLine()<= 0 ) {
				// imaginary node; no line/pos info; scan backwards
				i = -1;
				priorNode = nodes.LT(i);
				while ( priorNode ) {
					priorPayload = adaptor.getToken(priorNode);
					if ( priorPayload && priorPayload.getLine()>0 ) {
						// we found the most recent real line / pos info
						this.line = priorPayload.getLine();
						this.charPositionInLine = priorPayload.getCharPositionInLine();
						this.approximateLineInfo = true;
						break;
					}
					--i;
					priorNode = nodes.LT(i);
				}
			}
			else { // node created from real token
				this.line = payload.getLine();
				this.charPositionInLine = payload.getCharPositionInLine();
			}
		}
		else if ( this.node instanceof org.antlr.runtime.tree.CommonTree) {
			this.line = this.node.getLine();
			this.charPositionInLine = this.node.getCharPositionInLine();
			if ( this.node instanceof org.antlr.runtime.tree.CommonTree) {
				this.token = this.node.token;
			}
		}
		else {
			type = adaptor.getType(this.node);
			text = adaptor.getText(this.node);
			this.token = new org.antlr.runtime.CommonToken(type, text);
		}
	},

	/** Return the token type or char of the unexpected input element
     *  @return {Number} type of the unexpected input element.
     */
    getUnexpectedType: function() {
		if ( this.input instanceof NewLazyTokenStream) {//org.antlr.runtime.CommonTokenStream ) {
			return this.token.getType();
		}
		else if ( this.input instanceof org.antlr.runtime.tree.TreeNodeStream ) {
			var nodes = this.input;
			var adaptor = nodes.getTreeAdaptor();
			return adaptor.getType(this.node);
		}
		else {
			return this.c;
		}
	}
});
org.antlr.runtime.MismatchedTokenException = function(expecting, input) {
    if (arguments.length===0) {
        this.expecting = org.antlr.runtime.Token.INVALID_TOKEN_TYPE;
    } else {
        org.antlr.runtime.MismatchedTokenException.superclass.constructor.call(
                this, input);
        this.expecting = expecting;
    }
};

org.antlr.lang.extend(
    org.antlr.runtime.MismatchedTokenException,
    org.antlr.runtime.RecognitionException, {
    toString: function() {
        return "MismatchedTokenException(" +
                this.getUnexpectedType() + "!=" + this.expecting + ")";
    },
    name: "org.antlr.runtime.MismatchedTokenException"
});
org.antlr.runtime.UnwantedTokenException = function(expecting, input) {
    if (arguments.length>0) {
        org.antlr.runtime.UnwantedTokenException.superclass.constructor.call(
                this, expecting, input);
    }
};

org.antlr.lang.extend(
    org.antlr.runtime.UnwantedTokenException,
    org.antlr.runtime.MismatchedTokenException, {
    getUnexpectedToken: function() {
        return this.token;
    },
    toString: function() {
        var exp = ", expected "+this.expecting;
        if ( this.expecting===org.antlr.runtime.Token.INVALID_TOKEN_TYPE ) {
            exp = "";
        }
        if ( !org.antlr.lang.isValue(this.token) ) {
            return "UnwantedTokenException(found="+exp+")";
        }
        return "UnwantedTokenException(found="+this.token.getText()+exp+")";
    },
    name: "org.antlr.runtime.UnwantedTokenException"
});
org.antlr.runtime.MissingTokenException = function(expecting, input, inserted) {
    if (arguments.length>0) {
        org.antlr.runtime.MissingTokenException.superclass.constructor.call(
                this, expecting, input);
        this.inserted = inserted;
    }
};

org.antlr.lang.extend(
    org.antlr.runtime.MissingTokenException,
    org.antlr.runtime.MismatchedTokenException, {
    getMissingType: function() {
        return this.expecting;
    },

    toString: function() {
        if (org.antlr.lang.isValue(this.inserted) &&
            org.antlr.lang.isValue(this.token))
        {
            return "MissingTokenException(inserted "+this.inserted+" at "+this.token.getText()+")";
        }
        if ( org.antlr.lang.isValue(this.token) ) {
            return "MissingTokenException(at "+this.token.getText()+")";
        }
        return "MissingTokenException";
    },
    name: "org.antlr.runtime.MissingTokenException"
});
org.antlr.runtime.NoViableAltException = function(grammarDecisionDescription,
                                            decisionNumber,
                                            stateNumber,
                                            input)
{
    org.antlr.runtime.NoViableAltException.superclass.constructor.call(this, input);
    this.grammarDecisionDescription = grammarDecisionDescription;
    this.decisionNumber = decisionNumber;
    this.stateNumber = stateNumber;
};

org.antlr.lang.extend(
    org.antlr.runtime.NoViableAltException,
    org.antlr.runtime.RecognitionException, {
    toString: function() {
        if ( this.input instanceof org.antlr.runtime.ANTLRStringStream ) {
            return "NoViableAltException('"+this.getUnexpectedType()+"'@["+this.grammarDecisionDescription+"])";
        }
        else {
            return "NoViableAltException("+this.getUnexpectedType()+"@["+this.grammarDecisionDescription+"])";
        }
    },
    name: "org.antlr.runtime.NoViableAltException"
});
org.antlr.runtime.EarlyExitException = function(decisionNumber, input) {
    org.antlr.runtime.EarlyExitException.superclass.constructor.call(
            this, input);
    this.decisionNumber = decisionNumber;
};

org.antlr.lang.extend(
    org.antlr.runtime.EarlyExitException,
    org.antlr.runtime.RecognitionException,
/** @lends org.antlr.runtime.EarlyExitException.prototype */
{
    /** Name of this class.
     *  @type String
     */
    name: "org.antlr.runtime.EarlyExitException"
});
org.antlr.runtime.MismatchedSetException = function(expecting, input) {
    org.antlr.runtime.MismatchedSetException.superclass.constructor.call(
            this, input);
    this.expecting = expecting;
};

org.antlr.lang.extend(
    org.antlr.runtime.MismatchedSetException,
    org.antlr.runtime.RecognitionException, {
    toString: function() {
        return "MismatchedSetException(" +
                this.getUnexpectedType() + "!=" + this.expecting + ")";
    },
    name: "org.antlr.runtime.MismatchedSetException"
});
org.antlr.runtime.MismatchedNotSetException = function(expecting, input) {
    org.antlr.runtime.MismatchedNotSetException.superclass.constructor.call(this, expecting, input);
};

org.antlr.lang.extend(
    org.antlr.runtime.MismatchedNotSetException,
    org.antlr.runtime.MismatchedSetException, {
    toString: function() {
        return "MismatchedNotSetException(" +
                this.getUnexpectedType() + "!=" + this.expecting + ")";
    },
    name: "org.antlr.runtime.MismatchedNotSetException"
});
org.antlr.runtime.MismatchedRangeException = function(a, b, input) {
    if (arguments.length===0) {
        return this;
    }

    org.antlr.runtime.MismatchedRangeException.superclass.constructor.call(
            this, input);
    this.a = a;
    this.b = b;
};

org.antlr.lang.extend(
    org.antlr.runtime.MismatchedRangeException,
    org.antlr.runtime.RecognitionException, {
    toString: function() {
        return "MismatchedRangeException(" +
                this.getUnexpectedType()+" not in ["+this.a+","+this.b+"])";
    },
    name: "org.antlr.runtime.MismatchedRangeException"
});
org.antlr.runtime.FailedPredicateException = function(input, ruleName, predicateText){
    org.antlr.runtime.FailedPredicateException.superclass.constructor.call(this, input);
    this.ruleName = ruleName;
    this.predicateText = predicateText;
};

org.antlr.lang.extend(
    org.antlr.runtime.FailedPredicateException,
    org.antlr.runtime.RecognitionException,
/** @lends org.antlr.runtime.FailedPredicateException.prototype */
{
    /** Create a string representation of this exception.
     *  @returns {String}
     */ 
    toString: function() {
        return "FailedPredicateException("+this.ruleName+",{"+this.predicateText+"}?)";
    },

    /** Name of this class.
     *  @type String
     */
    name: "org.antlr.runtime.FailedPredicateException"
});
org.antlr.runtime.BitSet = function(bits) {
    if (!bits) {
        bits = org.antlr.runtime.BitSet.BITS;
    }

    if (org.antlr.lang.isArray(bits)) {
        /**
         * An array of Numbers representing the BitSet.
         * @type Array
         */
        this.bits = bits;
    } else if(org.antlr.lang.isNumber(bits)) {
        this.bits = [];
    }
};

org.antlr.lang.augmentObject(org.antlr.runtime.BitSet, {
    /**
     * Number of bits in each number.
     * @constant
     * @memberOf org.antlr.runtime.BitSet
     */
    BITS: 32,

    /**
     * Log (base 2) of the number of bits in each number.
     * @constant
     * @memberOf org.antlr.runtime.BitSet
     */
    LOG_BITS: 5,  // 2^5 == 32 

    /**
     * We will often need to do a mod operator (i mod nbits).  Its
     * turns out that, for powers of two, this mod operation is
     * same as (i & (nbits-1)).  Since mod is slow, we use a
     * precomputed mod mask to do the mod instead.
     * @constant
     * @memberOf org.antlr.runtime.BitSet
     */
    MOD_MASK: 31, // BITS - 1

    /**
     * Create mask for bit modded to fit in a single word.
     * @example
     * bitmask(35) => 00000000000000000000000000000100
     * bitmask(3)  => 00000000000000000000000000000100
     * @param {Number} bitNumber the bit to create a mask for.
     * @returns {Number} the bitmask.
     * @memberOf org.antlr.runtime.BitSet
     * @private
     */
    bitMask: function(bitNumber) {
        var bitPosition = bitNumber & org.antlr.runtime.BitSet.MOD_MASK;
        return 1 << bitPosition;
    },

    /**
     * Calculate the minimum number of bits needed to represent el.
     * @param {Number} el a number to be included in the BitSet.
     * @returns {Number} the number of bits need to create a BitSet with member
     *                   el.
     * @memberOf org.antlr.runtime.BitSet
     * @private
     */
    numWordsToHold: function(el) {
        return (el >> org.antlr.runtime.BitSet.LOG_BITS) + 1;
    },

    /**
     * @param {Number} bit a number to be included in the BitSet
     * @returns {Number} the index of the word in the field bits that would
     *                   hold bit.
     * @memberOf org.antlr.runtime.BitSet
     * @private
     */
    wordNumber: function(bit) {
        return bit >> org.antlr.runtime.BitSet.LOG_BITS; // bit / BITS
    },

    /**
     * BitSet factory method.
     * 
     * <p>Operates in a number of modes:
     * <ul>
     * <li>If el is a number create the BitSet containing that number.</li>
     * <li>If el is an array create the BitSet containing each number in the
     * array.</li>
     * <li>If el is a BitSet return el.</li>
     * <li>If el is an Object create the BitSet containing each numeric value
     * in el.</li>
     * <li>If el is a number and el2 is a number return a BitSet containing
     * the numbers between el and el2 (inclusive).</li>
     * </ul>
     * </p>
     * @param {Number|Array|org.antlr.runtime.BitSet|Object} el
     * @param {Number} el2
     * @returns {org.antlr.runtime.BitSet}
     * @memberOf org.antlr.runtime.BitSet
     */
    of: function(el, el2) {
        var i, n, s, keys;

        if (org.antlr.lang.isNumber(el)) {
            if (org.antlr.lang.isNumber(el2)) {
                s = new org.antlr.runtime.BitSet(el2 + 1);
                for (i = el; i <= el2; i++) {
                    n = org.antlr.runtime.BitSet.wordNumber(i);
                    s.bits[n] |= org.antlr.runtime.BitSet.bitMask(i);
                }
                return s;
            } else {
                s = new org.antlr.runtime.BitSet(el + 1);
                s.add(el);
                return s;
            }
        } else if(org.antlr.lang.isArray(el)) {
            s = new org.antlr.runtime.BitSet();
            for (i=el.length-1; i>=0; i--) {
                s.add(el[i]);
            }
            return s;
        } else if (el instanceof org.antlr.runtime.BitSet) {
            if (!el) {
                return null;
            }
            return el;
        } else if (el instanceof org.antlr.runtime.IntervalSet) {
            if (!el) {
                return null;
            }
            s = new org.antlr.runtime.BitSet();
            s.addAll(el);
            return s;
        } else if (org.antlr.lang.isObject(el)) {
            keys = [];
            for (i in el) {
                if (org.antlr.lang.isNumber(i)) {
                    keys.push(i);
                }
            }
            return org.antlr.runtime.BitSet.of(keys);
        }
    }
});



org.antlr.runtime.BitSet.prototype = {
    /**
     * Add el into this set.
     * @param {Number} el the number to add to the set.
     */
    add: function(el) {
        var n = org.antlr.runtime.BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        this.bits[n] |= org.antlr.runtime.BitSet.bitMask(el);
    },

    /**
     * Add multiple elements into this set.
     * @param {Array|org.antlr.runtime.BitSet} elements the elements to be added to
     *                                           this set.
     */
    addAll: function(elements) {
        var other,
            i,
            e;

        if ( elements instanceof org.antlr.runtime.BitSet ) {
            this.orInPlace(elements);
        }
		else if ( elements instanceof org.antlr.runtime.IntervalSet ) {
			other = elements;
			// walk set and add each interval
            /* @todo after implementing intervalset
			for (Iterator iter = other.intervals.iterator(); iter.hasNext();) {
				Interval I = (Interval) iter.next();
				this.orInPlace(BitSet.range(I.a,I.b));
			}*/
		} else if (org.antlr.lang.isArray(elements)) {
    		for (i = 0; i < elements.length; i++) {
	    		e = elements[i];
		    	this.add(e);
    		}
        } else {
            return;
        }
	},

    /**
     * Clone this BitSet and then {@link #andInPlace} with a.
     * @param {org.antlr.runtime.BitSet} a a bit set.
     * @returns {org.antlr.runtime.BitSet}
     */
    and: function(a) {
        var s = this.clone();
        s.andInPlace(a);
        return s;
    },

    /**
     * Perform a logical AND of this target BitSet with the argument BitSet.
     *
     * This bit set is modified so that each bit in it has the value true if 
     * and only if it both initially had the value true and the corresponding 
     * bit in the bit set argument also had the value true. 
     * @param {org.antlr.runtime.BitSet} a a bit set.
     * @returns {org.antlr.runtime.BitSet}
     */
    andInPlace: function(a) {
        var min = Math.min(this.bits.length, a.bits.length),
            i;
        for (i = min - 1; i >= 0; i--) {
            this.bits[i] &= a.bits[i];
        }
        // clear all bits in this not present in a (if this bigger than a).
        for (i = min; i < this.bits.length; i++) {
            this.bits[i] = 0;
        }
    },

    /**
     * Clear all bits or a specific bit.
     *
     * If no arguments given, sets all of the bits in this BitSet to false.
     * If one argument given, sets the bit specified by the index to false.
     * @param {Number} [el] the index of the bit to be cleared.
     */
    clear: function(el) {
        if (arguments.length===0) {
            var i;
            for (i = this.bits.length - 1; i >= 0; i--) {
                this.bits[i] = 0;
            }
            return;
        }

        var n = org.antlr.runtime.BitSet.wordNumber(el);
        if (n >= this.bits.length) {	// grow as necessary to accommodate
            this.growToInclude(el);
        }
        this.bits[n] &= ~org.antlr.runtime.BitSet.bitMask(el);
    },

    /**
     * Cloning this BitSet produces a new BitSet  that is equal to it. 
     *
     * The clone of the bit set is another bit set that has exactly the same
     * bit set to true as this bit set. 
     * @returns {org.antlr.runtime.BitSet} a clone of this BitSet.
     */
    clone: function() {
        var i, len, b=[];
        for (i=0, len=this.bits.length; i<len; i++) {
            b[i] = this.bits[i];
        }
        return new org.antlr.runtime.BitSet(b);
    },

    /**
     * Returns the number of bits of space actually in use by this BitSet to 
     * represent bit values.
     *
     * The maximum element in the set is the size - 1st element. 
     * @returns {Number} the number of bits currently in this bit set.
     */
    size: function() {
        var deg = 0, i, word, bit;
        for (i = this.bits.length - 1; i >= 0; i--) {
            word = this.bits[i];
            if (word !== 0) {
                for (bit = org.antlr.runtime.BitSet.BITS - 1; bit >= 0; bit--) {
                    if ((word & (1 << bit)) !== 0) {
                        deg++;
                    }
                }
            }
        }
        return deg;
    },

    /**
     * Compares this object against the specified object.
     *
     * The result is true if and only if the argument is not null and is a
     * BitSet object that has exactly the same set of bits set to true as
     * this bit set. That is, for every nonnegative int index k,
     * <pre><code>
     * ((BitSet)obj).get(k) == this.get(k)
     * </code></pre>
     * must be true. The current sizes of the two bit sets are not compared.
     * @param {Object} other the object to compare with.
     * @returns {Boolean} if the objects are the same; false otherwise.
     */
    equals: function(other) {
        if ( !other || !(other instanceof org.antlr.runtime.BitSet) ) {
            return false;
        }

        var otherSet = other,
            i,
            n = Math.min(this.bits.length, otherSet.bits.length);

        // for any bits in common, compare
        for (i=0; i<n; i++) {
            if (this.bits[i] != otherSet.bits[i]) {
                return false;
            }
        }

        // make sure any extra bits are off

        if (this.bits.length > n) {
            for (i = n+1; i<this.bits.length; i++) {
                if (this.bits[i] !== 0) {
                    return false;
                }
            }
        }
        else if (otherSet.bits.length > n) {
            for (i = n+1; i<otherSet.bits.length; i++) {
                if (otherSet.bits[i] !== 0) {
                    return false;
                }
            }
        }

        return true;
    },

    /**
     * Grows the set to a larger number of bits.
     * @param {Number} bit element that must fit in set
     * @private
     */
    growToInclude: function(bit) {
        var newSize = Math.max(this.bits.length << 1, org.antlr.runtime.BitSet.numWordsToHold(bit)),
            newbits = [], //new Array(newSize),
            i;
        for (i=0, len=this.bits.length; i<len; i++) {
            newbits[i] = this.bits[i];
        }
        this.bits = newbits;
    },

    /**
     * Returns the value of the bit with the specified index.
     *
     * The value is true if the bit with the index el is currently set 
     * in this BitSet; otherwise, the result is false.
     * @param {Number} el the bit index.
     * @returns {Boolean} the value of the bit with the specified index.
     */
    member: function(el) {
        var n = org.antlr.runtime.BitSet.wordNumber(el);
        if (n >= this.bits.length) { return false; }
        return (this.bits[n] & org.antlr.runtime.BitSet.bitMask(el)) !== 0;
    },

    /**
     * Returns the index of the first bit that is set to true.
     * If no such bit exists then -1 is returned.
     * @returns {Number} the index of the next set bit.
     */
    getSingleElement: function() {
        var i;
        for (i = 0; i < (this.bits.length << org.antlr.runtime.BitSet.LOG_BITS); i++) {
            if (this.member(i)) {
                return i;
            }
        }
        return -1; //Label.INVALID;
    },

    /**
     * Returns true if this BitSet contains no bits that are set to true.
     * @returns {Boolean} boolean indicating whether this BitSet is empty.
     */
    isNil: function() {
        var i;
        for (i = this.bits.length - 1; i >= 0; i--) {
            if (this.bits[i] !== 0) {
                return false;
            }
        }
        return true;
    },

    /**
     * If a bit set argument is passed performs a {@link #subtract} of this bit
     * set with the argument bit set.  If no argument is passed, clone this bit
     * set and {@link #notInPlace}.
     * @param {org.antlr.runtime.BitSet} [set]
     * @returns {org.antlr.runtime.BitSet}
     */
    complement: function(set) {
        if (set) {
            return set.subtract(this);
        } else {
            var s = this.clone();
            s.notInPlace();
            return s;
        }
    },

    /**
     * If no arguments are passed sets all bits to the complement of their
     * current values.  If one argument is passed sets each bit from the
     * beginning of the bit set to index1 (inclusive) to the complement of its
     * current value.  If two arguments are passed sets each bit from the
     * specified index1 (inclusive) to the sepcified index2 (inclusive) to the
     * complement of its current value.
     * @param {Number} index1
     * @param {Number} index2
     */
    notInPlace: function() {
        var minBit, maxBit, i, n;
        if (arguments.length===0) {
            for (i = this.bits.length - 1; i >= 0; i--) {
                this.bits[i] = ~this.bits[i];
            }
        } else {
            if (arguments.length===1) {
                minBit = 0;
                maxBit = arguments[0];
            } else {
                minBit = arguments[0];
                maxBit = arguments[1];
            }
            // make sure that we have room for maxBit
            this.growToInclude(maxBit);
            for (i = minBit; i <= maxBit; i++) {
                n = org.antlr.runtime.BitSet.wordNumber(i);
                this.bits[n] ^= org.antlr.runtime.BitSet.bitMask(i);
            }
        }

    },

    /**
     * Performs a logical OR of this bit set with the bit set argument.
     * If no argument is passed, return this bit set.  Otherwise a clone of
     * this bit set is modified so that a bit in it has the value true if and
     * only if it either already had the value true or the corresponding bit
     * in the bit set argument has the value true.
     * @param {org.antlr.runtime.BitSet} [a] a bit set.
     * @returns {org.antlr.runtime.BitSet}
     */
    or: function(a) {
		if ( !a ) {
			return this;
		}
        var s = this.clone();
        s.orInPlace(a);
        return s;
    },

    /**
     * Performs a logical {@link #or} in place.
     * @param {org.antlr.runtime.BitSet} [a]
     * @returns {org.antlr.runtime.BitSet}
     */
    orInPlace: function(a) {
		if ( !a ) {
			return;
		}
        // If this is smaller than a, grow this first
        if (a.bits.length > this.bits.length) {
            this.setSize(a.bits.length);
        }
        var min = Math.min(this.bits.length, a.bits.length),
            i;
        for (i = min - 1; i >= 0; i--) {
            this.bits[i] |= a.bits[i];
        }
    },

    /**
     * Sets the bit specified by the index to false.
     * @param {Number} bitIndex the index of the bit to be cleared.
     */
    remove: function(el) {
        var n = org.antlr.runtime.BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        this.bits[n] &= ~org.antlr.runtime.BitSet.bitMask(el);
    },

    /**
     * Grows the internal bits array to include at least nwords numbers.
     * @private
     * @param {Number} nwords how many words the new set should be
     * @private
     */
    setSize: function(nwords) {
        var n = nwords - this.bits.length;
        while (n>=0) {
            this.bits.push(0);
            n--;
        }
    },

    /**
     * Returns the number of bits capable of being represented by this bit set
     * given its current size.
     * @returns {Number} the maximum number of bits that can be represented at
     *                   the moment.
     * @private
     */
    numBits: function() {
        return this.bits.length << org.antlr.runtime.BitSet.LOG_BITS; // num words * bits per word
    },

    /**
     * Return how much space is being used by the bits array not
     * how many actually have member bits on.
     * @returns {Number} the length of the internal bits array.
     * @private
     */
    lengthInLongWords: function() {
        return this.bits.length;
    },

    /**
     * Is this bit set contained within a?
     * @param {org.antlr.runtime.BitSet} a bit set
     * @returns {Boolean} true if and only if a is a subset of this bit set.
     */
    subset: function(a) {
        if (!a) { return false; }
        return this.and(a).equals(this);
    },

    /**
     * Subtract the elements of the argument bit set from this bit set in place.
     * That is, for each set bit in the argument bit set, set the corresponding
     * bit in this bit set to false.
     * @param {org.antlr.runtime.BitSet} a bit set.
     */
    subtractInPlace: function(a) {
        if (!a) { return; }
        // for all words of 'a', turn off corresponding bits of 'this'
        var i;
        for (i = 0; i < this.bits.length && i < a.bits.length; i++) {
            this.bits[i] &= ~a.bits[i];
        }
    },

    /**
     * Perform a {@link #subtractInPlace} on a clone of this bit set.
     * @param {org.antlr.runtime.BitSet} a bit set.
     * @returns {org.antlr.runtime.BitSet} the new bit set.
     */
    subtract: function(a) {
        if (!a || !(a instanceof org.antlr.runtime.BitSet)) { return null; }

        var s = this.clone();
        s.subtractInPlace(a);
        return s;
    },

    /* antlr-java needs this to make its class hierarchy happy . . .
    toList: function() {
		throw new Error("BitSet.toList() unimplemented");
	},
    */

    /**
     * Creates an array of the indexes of each bit set in this bit set.
     * @returns {Array}
     */
    toArray: function() {
        var elems = [], //new Array(this.size()),
            i,
            en = 0;
        for (i = 0; i < (this.bits.length << org.antlr.runtime.BitSet.LOG_BITS); i++) {
            if (this.member(i)) {
                elems[en++] = i;
            }
        }
        return elems;
    },

    /**
     * Returns the internal representation of this bit set.
     * This representation is an array of numbers, each representing 32 bits.
     * @returns {Array}
     */
    toPackedArray: function() {
        return this.bits;
    },

    /**
     * Returns a string representation of this bit set.
     * <p>For every index for which this BitSet contains a bit in the set state,
     * the decimal representation of that index is included in the result.
     * Such indices are listed in order from lowest to highest, separated by
     * ", " (a comma and a space) and surrounded by braces, resulting in the
     * usual mathematical notation for a set of integers.</p>
     * 
     * <p>If a grammar g is passed, print g.getTokenDisplayName(i) for each set
     * index instead of the numerical index.</p>
     *
     * <>If two arguments are passed, the first will be used as a custom
     * separator string.  The second argument is an array whose i-th element
     * will be added if the corresponding bit is set.</p>
     *
     * @param {Object|String} [arg1] an Object with function property
     *      getTokenDispalyName or a String that will be used as a list
     *      separator.
     * @param {Array} [vocabulary] array from which the i-th value will be
     *      drawn if the corresponding bit is set.  Must pass a string as the
     *      first argument if using this option.
     * @return A commma-separated list of values
     */
    toString: function() {
        if (arguments.length===0) {
            return this.toString1(null);
        } else {
            if (org.antlr.lang.isString(arguments[0])) {
                if (!org.antlr.lang.isValue(arguments[1])) {
                    return this.toString1(null);
                } else {
                    return this.toString2(arguments[0], arguments[1]);
                }
            } else {
                return this.toString1(arguments[0]);
            }
        }
    },

    /**
     * Transform a bit set into a string by formatting each element as an
     * integer separator The string to put in between elements
     * @private
     * @return A commma-separated list of values
     */
    toString1: function(g) {
        var buf = "{",
            separator = ",",
            i,
		    havePrintedAnElement = false;

        for (i = 0; i < (this.bits.length << org.antlr.runtime.BitSet.LOG_BITS); i++) {
            if (this.member(i)) {
                if (i > 0 && havePrintedAnElement ) {
                    buf += separator;
                }
                if ( g ) {
                    buf += g.getTokenDisplayName(i);
                }
                else {
                    buf += i.toString();
                }
				havePrintedAnElement = true;
            }
        }
        return buf + "}";
    },

    /**
     * Create a string representation where instead of integer elements, the
     * ith element of vocabulary is displayed instead.  Vocabulary is a Vector
     * of Strings.
     * separator The string to put in between elements
     * @private
     * @return A commma-separated list of character constants.
     */
    toString2: function(separator, vocabulary) {
        var str = "",
            i;
        for (i = 0; i < (this.bits.length << org.antlr.runtime.BitSet.LOG_BITS); i++) {
            if (this.member(i)) {
                if (str.length > 0) {
                    str += separator;
                }
                if (i >= vocabulary.size()) {
                    str += "'" + i + "'";
                }
                else if (!org.antlr.lang.isValue(vocabulary.get(i))) {
                    str += "'" + i + "'";
                }
                else {
                    str += vocabulary.get(i);
                }
            }
        }
        return str;
    }

    /*
     * Dump a comma-separated list of the words making up the bit set.
     * Split each 32 bit number into two more manageable 16 bit numbers.
     * @returns {String} comma separated list view of the this.bits property.
     *
    toStringOfHalfWords: function() {
        var s = "",
            tmp,
            i;
        for (i = 0; i < this.bits.length; i++) {
            if (i !== 0) {
                s+=", ";
            }
            tmp = this.bits[i];
            tmp &= 0xFFFF;
            s += tmp + "UL, ";
            tmp = this.bits[i] >> 16;
            tmp &= 0xFFFF;
            s += tmp+"UL";
        }
		return s;
    },
    */

    /*
     * Dump a comma-separated list of the words making up the bit set.
     * This generates a comma-separated list of Java-like long int constants.
     *
    toStringOfWords: function() {
        var s="",
            i;
        for (i = 0; i < this.bits.length; i++) {
            if (i !== 0) {
                s+=", ";
            }
            s += this.bits[i]+"L";
        }
        return s;
    },

    toStringWithRanges: function() {
        return this.toString();
    }
    */
};
org.antlr.runtime.CharStream = {
    EOF: -1
};
org.antlr.runtime.CommonToken = function() {
    var oldToken;

    this.charPositionInLine = -1; // set to invalid position
    this.channel = 0; // org.antlr.runtime.CommonToken.DEFAULT_CHANNEL
    this.index = -1;

    if (arguments.length == 1) {
        if (org.antlr.lang.isNumber(arguments[0])) {
            this.type = arguments[0];
        } else {
            oldToken = arguments[0];
            this.text = oldToken.getText();
            this.type = oldToken.getType();
            this.line = oldToken.getLine();
            this.index = oldToken.getTokenIndex();
            this.charPositionInLine = oldToken.getCharPositionInLine();
            this.channel = oldToken.getChannel();
            if ( oldToken instanceof org.antlr.runtime.CommonToken ) {
                this.start = oldToken.start;
                this.stop = oldToken.stop;
            }
        }
    } else if (arguments.length == 2) {
        this.type = arguments[0];
        this.text = arguments[1];
        this.channel = 0; // org.antlr.runtime.CommonToken.DEFAULT_CHANNEL
    } else if (arguments.length == 5) {
        this.input = arguments[0];
        this.type = arguments[1];
        this.channel = arguments[2];
        this.start = arguments[3];
        this.stop = arguments[4];
    }
};

org.antlr.runtime.CommonToken.prototype = {
    getType: function() {
        return this.type;
    },

    setLine: function(line) {
        this.line = line;
    },

    getText: function() {
        if ( org.antlr.lang.isString(this.text) ) {
            return this.text;
        }
        if ( !this.input ) {
            return null;
        }
        this.text = this.input.substring(this.start,this.stop);
        return this.text;
    },

    /** Override the text for this token.  getText() will return this text
     *  rather than pulling from the buffer.  Note that this does not mean
     *  that start/stop indexes are not valid.  It means that that input
     *  was converted to a new string in the token object.
     */
    setText: function(text) {
        this.text = text;
    },

    getLine: function() {
        return this.line;
    },

    getCharPositionInLine: function() {
        return this.charPositionInLine;
    },

    setCharPositionInLine: function(charPositionInLine) {
        this.charPositionInLine = charPositionInLine;
    },

    getChannel: function() {
        return this.channel;
    },

    setChannel: function(channel) {
        this.channel = channel;
    },

    setType: function(type) {
        this.type = type;
    },

    getStartIndex: function() {
        return this.start;
    },

    setStartIndex: function(start) {
        this.start = start;
    },

    getStopIndex: function() {
        return this.stop;
    },

    setStopIndex: function(stop) {
        this.stop = stop;
    },

    getTokenIndex: function() {
        return this.index;
    },

    setTokenIndex: function(index) {
        this.index = index;
    },

    getInputStream: function() {
        return this.input;
    },

    setInputStream: function(input) {
        this.input = input;
    },

    toString: function() {
        var channelStr = "";
        if ( this.channel>0 ) {
            channelStr=",channel="+this.channel;
        }
        var txt = this.getText();
        if ( !org.antlr.lang.isNull(txt) ) {
            txt = txt.replace(/\n/g,"\\\\n");
            txt = txt.replace(/\r/g,"\\\\r");
            txt = txt.replace(/\t/g,"\\\\t");
        }
        else {
            txt = "<no text>";
        }
        return "[@"+this.getTokenIndex()+","+this.start+":"+this.stop+"='"+txt+"',<"+this.type+">"+channelStr+","+this.line+":"+this.getCharPositionInLine()+"]";
    }
};
// NB: Because Token has static members of type CommonToken, the Token dummy
// constructor is defined in CommonToken.  All methods and vars of Token are
// defined here.  Token is an interface, not a subclass in the Java runtime.

/**
 * @class Abstract base class of all token types.
 * @name Token
 * @memberOf org.antlr.runtime
 */
org.antlr.runtime.Token = function() {};
org.antlr.lang.augmentObject(org.antlr.runtime.Token, /** @lends Token */ {
    EOR_TOKEN_TYPE: 1,

    /** imaginary tree navigation type; traverse "get child" link */
    DOWN: 2,
    /** imaginary tree navigation type; finish with a child list */
    UP: 3,

    MIN_TOKEN_TYPE: 4, // UP+1,

    EOF: org.antlr.runtime.CharStream.EOF,
    EOF_TOKEN: new org.antlr.runtime.CommonToken(org.antlr.runtime.CharStream.EOF),

    INVALID_TOKEN_TYPE: 0,
    INVALID_TOKEN: new org.antlr.runtime.CommonToken(0),

    /** In an action, a lexer rule can set token to this SKIP_TOKEN and ANTLR
     *  will avoid creating a token for this symbol and try to fetch another.
     */
    SKIP_TOKEN: new org.antlr.runtime.CommonToken(0),

    /** All tokens go to the parser (unless skip() is called in that rule)
     *  on a particular "channel".  The parser tunes to a particular channel
     *  so that whitespace etc... can go to the parser on a "hidden" channel.
     */
    DEFAULT_CHANNEL: 0,

    /** Anything on different channel than DEFAULT_CHANNEL is not parsed
     *  by parser.
     */
    HIDDEN_CHANNEL: 99
});

org.antlr.lang.augmentObject(org.antlr.runtime.CommonToken, org.antlr.runtime.Token);
org.antlr.runtime.tree = {};
org.antlr.runtime.tree.RewriteCardinalityException = function(elementDescription) {
    this.elementDescription = elementDescription;
};
org.antlr.lang.extend(org.antlr.runtime.tree.RewriteCardinalityException, Error, {
    getMessage: function() {
		if ( org.antlr.lang.isString(this.elementDescription) ) {
			return this.elementDescription;
		}
		return null;
	},
    name: function() {
        return "org.antlr.runtime.tree.RewriteCardinalityException";
    }
});
org.antlr.runtime.tree.RewriteEmptyStreamException = function(elementDescription) {
    var sup = org.antlr.runtime.tree.RewriteEmptyStreamException.superclass; 
    sup.constructor.call(this, elementDescription);
};

org.antlr.lang.extend(org.antlr.runtime.tree.RewriteEmptyStreamException,
                  org.antlr.runtime.tree.RewriteCardinalityException, {
    name: function() {
        return "org.antlr.runtime.tree.RewriteEmptyStreamException";
    }
});
org.antlr.runtime.tree.RewriteEarlyExitException = function(elementDescription) {
    var sup = org.antlr.runtime.tree.RewriteEarlyExitException.superclass;
    if (org.antlr.lang.isUndefined(elementDescription)) {
        elementDescription = null;
    }
    sup.constructor.call(this, elementDescription);
};

org.antlr.lang.extend(org.antlr.runtime.tree.RewriteEarlyExitException,
                  org.antlr.runtime.tree.RewriteCardinalityException, {
    name: function() {
        return "org.antlr.runtime.tree.RewriteEarlyExitException";
    }    
});
org.antlr.runtime.MismatchedTreeNodeException = function(expecting, input) {
    if (expecting && input) {
        org.antlr.runtime.MismatchedTreeNodeException.superclass.constructor.call(
                this, input);
        this.expecting = expecting;
    }
};

org.antlr.lang.extend(
    org.antlr.runtime.MismatchedTreeNodeException,
    org.antlr.runtime.RecognitionException, {
    toString: function() {
        return "MismatchedTreeNodeException(" +
                this.getUnexpectedType() + "!=" + this.expecting + ")";
    },
    name: "org.antlr.runtime.MismatchedTreeNodeException"
});
org.antlr.runtime.tree.BaseTree = function() {};

org.antlr.runtime.tree.BaseTree.prototype = {
    getChild: function(i) {
        if ( !this.children || i>=this.children.length ) {
            return null;
        }
        return this.children[i];
    },

    /** Get the children internal List; note that if you directly mess with
     *  the list, do so at your own risk.
     */
    getChildren: function() {
        return this.children;
    },

    getFirstChildWithType: function(type) {
        var i, t;
        for (i = 0; this.children && i < this.children.length; i++) {
            t = this.children[i];
            if ( t.getType()===type ) {
                return t;
            }
        }    
        return null;
    },

    getChildCount: function() {
        if ( !this.children ) {
            return 0;
        }
        return this.children.length;
    },

    /** Add t as child of this node.
     *
     *  Warning: if t has no children, but child does
     *  and child isNil then this routine moves children to t via
     *  t.children = child.children; i.e., without copying the array.
     */
    addChild: function(t) {
        if ( !org.antlr.lang.isValue(t) ) {
            return; // do nothing upon addChild(null)
        }
        var childTree = t, n, i, c;
        if ( childTree.isNil() ) { // t is an empty node possibly with children
            if ( this.children && this.children == childTree.children ) {
                throw new Error("attempt to add child list to itself");
            }
            // just add all of childTree's children to this
            if ( childTree.children ) {
                if ( this.children ) { // must copy, this has children already
                    n = childTree.children.length;
                    for (i = 0; i < n; i++) {
                        c = childTree.children[i];
                        this.children.push(c);
                        // handle double-link stuff for each child of nil root
                        c.setParent(this);
                        c.setChildIndex(this.children.length-1);
                    }
                }
                else {
                    // no children for this but t has children; just set pointer
                    // call general freshener routine
                    this.children = childTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        }
        else { // child is not nil (don't care about children)
            if ( !this.children ) {
                this.children = this.createChildrenList(); // create children list on demand
            }
            this.children.push(t);
            childTree.setParent(this);
            childTree.setChildIndex(this.children.length-1);
        }
    },

    /** Add all elements of kids list as children of this node */
    addChildren: function(kids) {
        var i, t;
        for (i = 0; i < kids.length; i++) {
            t = kids[i];
            this.addChild(t);
        }
    },

    setChild: function(i, t) {
        if ( !t ) {
            return;
        }
        if ( t.isNil() ) {
            throw new Error("Can't set single child to a list");
        }
        if ( !this.children ) {
            this.children = this.createChildrenList();
        }
        this.children[i] = t;
        t.setParent(this);
        t.setChildIndex(i);
    },

    deleteChild: function(i) {
        if ( !this.children ) {
            return null;
        }
        if (i<0 || i>=this.children.length) {
            throw new Error("Index out of bounds.");
        }
        var killed = this.children.splice(i, 1)[0];
        // walk rest and decrement their child indexes
        this.freshenParentAndChildIndexes(i);
        return killed;
    },

    /** Delete children from start to stop and replace with t even if t is
     *  a list (nil-root tree).  num of children can increase or decrease.
     *  For huge child lists, inserting children can force walking rest of
     *  children to set their childindex; could be slow.
     */
    replaceChildren: function(startChildIndex, stopChildIndex, t) {
        if ( !this.children ) {
            throw new Error("indexes invalid; no children in list");
        }
        var replacingHowMany = stopChildIndex - startChildIndex + 1;
        var replacingWithHowMany;
        var newTree = t;
        var newChildren = null;
        // normalize to a list of children to add: newChildren
        if ( newTree.isNil() ) {
            newChildren = newTree.children;
        }
        else {
            newChildren = [];
            newChildren.push(newTree);
        }
        replacingWithHowMany = newChildren.length;
        var numNewChildren = newChildren.length;
        var delta = replacingHowMany - replacingWithHowMany;
        var j, i, child, indexToDelete, c, killed, numToInsert;
        // if same number of nodes, do direct replace
        if ( delta === 0 ) {
            j = 0; // index into new children
            for (i=startChildIndex; i<=stopChildIndex; i++) {
                child = newChildren[j];
                this.children[i] = child;
                child.setParent(this);
                child.setChildIndex(i);
                j++;
            }
        }
        else if ( delta > 0 ) { // fewer new nodes than there were
            // set children and then delete extra
            for (j=0; j<numNewChildren; j++) {
                this.children[startChildIndex+j] = newChildren[j];
            }
            indexToDelete = startChildIndex+numNewChildren;
            for (c=indexToDelete; c<=stopChildIndex; c++) {
                // delete same index, shifting everybody down each time
                killed = this.children.splice(indexToDelete, 1)[0];
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        }
        else { // more new nodes than were there before
            // fill in as many children as we can (replacingHowMany) w/o moving data
            for (j=0; j<replacingHowMany; j++) {
                this.children[startChildIndex+j] = newChildren[j];
            }
            numToInsert = replacingWithHowMany-replacingHowMany;
            for (j=replacingHowMany; j<replacingWithHowMany; j++) {
                this.children.splice(startChildIndex+j, 0, newChildren[j]);
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        }
    },

    /** Override in a subclass to change the impl of children list */
    createChildrenList: function() {
        return [];
    },

    isNil: function() {
        return false;
    },

    freshenParentAndChildIndexes: function(offset) {
        if (!org.antlr.lang.isNumber(offset)) {
            offset = 0;
        }
        var n = this.getChildCount(),
            c,
            child;
        for (c = offset; c < n; c++) {
            child = this.getChild(c);
            child.setChildIndex(c);
            child.setParent(this);
        }
    },

    sanityCheckParentAndChildIndexes: function(parent, i) {
        if (arguments.length===0) {
            parent = null;
            i = -1;
        }

        if ( parent!==this.getParent() ) {
            throw new Error("parents don't match; expected "+parent+" found "+this.getParent());
        }
        if ( i!==this.getChildIndex() ) {
            throw new Error("child indexes don't match; expected "+i+" found "+this.getChildIndex());
        }
        var n = this.getChildCount(),
            c,
            child;
        for (c = 0; c < n; c++) {
            child = this.getChild(c);
            child.sanityCheckParentAndChildIndexes(this, c);
        }
    },

    /** BaseTree doesn't track child indexes. */
    getChildIndex: function() {
        return 0;
    },
    setChildIndex: function(index) {
    },

    /** BaseTree doesn't track parent pointers. */
    getParent: function() {
        return null;
    },
    setParent: function(t) {
    },

    getTree: function() {
        return this;
    },

    /** Print out a whole tree not just a node */
    toStringTree: function() {
        if ( !this.children || this.children.length===0 ) {
            return this.toString();
        }
        var buf = "",
            i,
            t;
        if ( !this.isNil() ) {
            buf += "(";
            buf += this.toString();
            buf += ' ';
        }
        for (i = 0; this.children && i < this.children.length; i++) {
            t = this.children[i];
            if ( i>0 ) {
                buf += ' ';
            }
            buf += t.toStringTree();
        }
        if ( !this.isNil() ) {
            buf += ")";
        }
        return buf;
    },

    getLine: function() {
        return 0;
    },

    getCharPositionInLine: function() {
        return 0;
    }
};
org.antlr.runtime.tree.CommonTree = function(node) {
    /** What token indexes bracket all tokens associated with this node
     *  and below?
     */
    this.startIndex = -1;
    this.stopIndex = -1;
    this.childIndex = -1;
    this.parent = null;
    this.token = null;

    if (node instanceof org.antlr.runtime.tree.CommonTree) {
        org.antlr.runtime.tree.CommonTree.superclass.constructor.call(this, node);
        this.token = node.token;
        this.startIndex = node.startIndex;
        this.stopIndex = node.stopIndex;
    } else if (node instanceof org.antlr.runtime.CommonToken) {
        this.token = node;
    }
};
org.antlr.lang.extend(org.antlr.runtime.tree.CommonTree, org.antlr.runtime.tree.BaseTree, {
    getToken: function() {
        return this.token;
    },

    dupNode: function() {
        return new org.antlr.runtime.tree.CommonTree(this);
    },

    isNil: function() {
        return !this.token;
    },

    getType: function() {
        if ( !this.token ) {
            return org.antlr.runtime.Token.INVALID_TOKEN_TYPE;
        }
        return this.token.getType();
    },

    getText: function() {
        if ( !this.token ) {
            return null;
        }
        return this.token.getText();
    },

    getLine: function() {
        if ( !this.token || this.token.getLine()===0 ) {
            if ( this.getChildCount()>0 ) {
                return this.getChild(0).getLine();
            }
            return 0;
        }
        return this.token.getLine();
    },

    getCharPositionInLine: function() {
        if ( !this.token || this.token.getCharPositionInLine()===-1 ) {
            if ( this.getChildCount()>0 ) {
                return this.getChild(0).getCharPositionInLine();
            }
            return 0;
        }
        return this.token.getCharPositionInLine();
    },

    getTokenStartIndex: function() {
        if ( this.token ) {
            return this.token.getTokenIndex();
        }
        return this.startIndex;
    },

    setTokenStartIndex: function(index) {
        this.startIndex = index;
    },

    getTokenStopIndex: function() {
        if ( this.token ) {
            return this.token.getTokenIndex();
        }
        return this.stopIndex;
    },

    setTokenStopIndex: function(index) {
        this.stopIndex = index;
    },

    getChildIndex: function() {
        return this.childIndex;
    },

    getParent: function() {
        return this.parent;
    },

    setParent: function(t) {
        this.parent = t;
    },

    setChildIndex: function(index) {
        this.childIndex = index;
    },

    toString: function() {
        if ( this.isNil() ) {
            return "nil";
        }
        if ( this.getType()===org.antlr.runtime.Token.INVALID_TOKEN_TYPE ) {
            return "<errornode>";
        }
        if ( !this.token ) {
            return null;
        }
        return this.token.getText();
    }
});
org.antlr.runtime.tree.Tree = {
    INVALID_NODE: new org.antlr.runtime.tree.CommonTree(org.antlr.runtime.Token.INVALID_TOKEN)
};
org.antlr.runtime.tree.CommonErrorNode = function(input, start, stop, e) {
    if ( !stop ||
            (stop.getTokenIndex() < start.getTokenIndex() &&
             stop.getType()!=org.antlr.runtime.Token.EOF) )
    {
        // sometimes resync does not consume a token (when LT(1) is
        // in follow set.  So, stop will be 1 to left to start. adjust.
        // Also handle case where start is the first token and no token
        // is consumed during recovery; LT(-1) will return null.
        stop = start;
    }
    this.input = input;
    this.start = start;
    this.stop = stop;
    this.trappedException = e;
};

org.antlr.lang.extend(org.antlr.runtime.tree.CommonErrorNode, org.antlr.runtime.tree.CommonTree, {
    isNil: function() {
        return false;
    },

    getType: function() {
        return org.antlr.runtime.Token.INVALID_TOKEN_TYPE;
    },

    getText: function() {
        var badText = null;
        if ( this.start instanceof org.antlr.runtime.CommonToken ) {
            var i = this.start.getTokenIndex();
            var j = this.stop.getTokenIndex();
            if ( this.stop.getType() === org.antlr.runtime.Token.EOF ) {
                j = this.input.size();
            }
            badText = this.input.toString(i, j);
        }
        else if ( this.start instanceof org.antlr.runtime.tree.CommonTree ) {
            badText = this.input.toString(this.start, this.stop);
        }
        else {
            // people should subclass if they alter the tree type so this
            // next one is for sure correct.
            badText = "<unknown>";
        }
        return badText;
    },

    toString: function() {
        if ( this.trappedException instanceof org.antlr.runtime.MissingTokenException ) {
            return "<missing type: "+
                   this.trappedException.getMissingType()+
                   ">";
        }
        else if ( this.trappedException instanceof org.antlr.runtime.UnwantedTokenException ) {
            return "<extraneous: "+
                   this.trappedException.getUnexpectedToken()+
                   ", resync="+this.getText()+">";
        }
        else if ( this.trappedException instanceof org.antlr.runtime.MismatchedTokenException ) {
            return "<mismatched token: "+this.trappedException.token+", resync="+this.getText()+">";
        }
        else if ( this.trappedException instanceof org.antlr.runtime.NoViableAltException ) {
            return "<unexpected: "+this.trappedException.token+
                   ", resync="+this.getText()+">";
        }
        return "<error: "+this.getText()+">";
    }
});
org.antlr.runtime.tree.BaseTreeAdaptor = function() {
    this.uniqueNodeID = 1;
};

org.antlr.runtime.tree.BaseTreeAdaptor.prototype = {
    nil: function() {
        return this.create(null);
    },

    /** create tree node that holds the start and stop tokens associated
     *  with an error.
     *
     *  If you specify your own kind of tree nodes, you will likely have to
     *  override this method. CommonTree returns Token.INVALID_TOKEN_TYPE
     *  if no token payload but you might have to set token type for diff
     *  node type.
     */
    errorNode: function(input, start, stop, e) {
        var t = new org.antlr.runtime.tree.CommonErrorNode(input, start, stop, e);
        return t;
    },

    isNil: function(tree) {
        return tree.isNil();
    },

    /** This is generic in the sense that it will work with any kind of
     *  tree (not just Tree interface).  It invokes the adaptor routines
     *  not the tree node routines to do the construction.  
     */
    dupTree: function(t, parent) {
        if (arguments.length===1) {
            parent = null;
        }
        if ( !t ) {
            return null;
        }
        var newTree = this.dupNode(t);
        // ensure new subtree root has parent/child index set
        this.setChildIndex(newTree, this.getChildIndex(t)); // same index in new tree
        this.setParent(newTree, parent);
        var n = this.getChildCount(t),
            i, child, newSubTree;
        for (i = 0; i < n; i++) {
            child = this.getChild(t, i);
            newSubTree = this.dupTree(child, t);
            this.addChild(newTree, newSubTree);
        }
        return newTree;
    },

    /** Add a child to the tree t.  If child is a flat tree (a list), make all
     *  in list children of t.  Warning: if t has no children, but child does
     *  and child isNil then you can decide it is ok to move children to t via
     *  t.children = child.children; i.e., without copying the array.  Just
     *  make sure that this is consistent with have the user will build
     *  ASTs.
     */
    addChild: function(t, child) {
        if ( t && org.antlr.lang.isValue(child) ) {
            t.addChild(child);
        }
    },

    /** If oldRoot is a nil root, just copy or move the children to newRoot.
     *  If not a nil root, make oldRoot a child of newRoot.
     *
     *    old=^(nil a b c), new=r yields ^(r a b c)
     *    old=^(a b c), new=r yields ^(r ^(a b c))
     *
     *  If newRoot is a nil-rooted single child tree, use the single
     *  child as the new root node.
     *
     *    old=^(nil a b c), new=^(nil r) yields ^(r a b c)
     *    old=^(a b c), new=^(nil r) yields ^(r ^(a b c))
     *
     *  If oldRoot was null, it's ok, just return newRoot (even if isNil).
     *
     *    old=null, new=r yields r
     *    old=null, new=^(nil r) yields ^(nil r)
     *
     *  Return newRoot.  Throw an exception if newRoot is not a
     *  simple node or nil root with a single child node--it must be a root
     *  node.  If newRoot is ^(nil x) return x as newRoot.
     *
     *  Be advised that it's ok for newRoot to point at oldRoot's
     *  children; i.e., you don't have to copy the list.  We are
     *  constructing these nodes so we should have this control for
     *  efficiency.
     */
    becomeRoot: function(newRoot, oldRoot) {
        if (newRoot instanceof org.antlr.runtime.CommonToken || !newRoot) {
            newRoot = this.create(newRoot);
        }

        var newRootTree = newRoot,
            oldRootTree = oldRoot;
        if ( !oldRoot ) {
            return newRoot;
        }
        // handle ^(nil real-node)
        if ( newRootTree.isNil() ) {
            if ( newRootTree.getChildCount()>1 ) {
                // TODO: make tree run time exceptions hierarchy
                throw new Error("more than one node as root (TODO: make exception hierarchy)");
            }
            newRootTree = newRootTree.getChild(0);
        }
        // add oldRoot to newRoot; addChild takes care of case where oldRoot
        // is a flat list (i.e., nil-rooted tree).  All children of oldRoot
        // are added to newRoot.
        newRootTree.addChild(oldRootTree);
        return newRootTree;
    },

    /** Transform ^(nil x) to x */
    rulePostProcessing: function(root) {
        var r = root;
        if ( r && r.isNil() ) {
            if ( r.getChildCount()===0 ) {
                r = null;
            }
            else if ( r.getChildCount()===1 ) {
                r = r.getChild(0);
                // whoever invokes rule will set parent and child index
                r.setParent(null);
                r.setChildIndex(-1);
            }
        }
        return r;
    },

    create: function(tokenType, fromToken) {
        var text, t;
        if (arguments.length===2) {
            if (org.antlr.lang.isString(arguments[1])) {
                text = arguments[1];
                fromToken = this.createToken(tokenType, text);
                t = this.create(fromToken);
                return t;
            } else {
                fromToken = this.createToken(fromToken);
                fromToken.setType(tokenType);
                t = this.create(fromToken);
                return t;
            }
        } else if (arguments.length===3) {
            text = arguments[2];
            fromToken = this.createToken(fromToken);
            fromToken.setType(tokenType);
            fromToken.setText(text);
            t = this.create(fromToken);
            return t;
        }
    },

    getType: function(t) {
        t.getType();
        return 0;
    },

    setType: function(t, type) {
        throw new Error("don't know enough about Tree node");
    },

    getText: function(t) {
        return t.getText();
    },

    setText: function(t, text) {
        throw new Error("don't know enough about Tree node");
    },

    getChild: function(t, i) {
        return t.getChild(i);
    },

    setChild: function(t, i, child) {
        t.setChild(i, child);
    },

    deleteChild: function(t, i) {
        return t.deleteChild(i);
    },

    getChildCount: function(t) {
        return t.getChildCount();
    },

    getUniqueID: function(node) {
        if ( !this.treeToUniqueIDMap ) {
             this.treeToUniqueIDMap = {};
        }
        var prevID = this.treeToUniqueIDMap[node];
        if ( org.antlr.lang.isValue(prevID) ) {
            return prevID;
        }
        var ID = this.uniqueNodeID;
        this.treeToUniqueIDMap[node] = ID;
        this.uniqueNodeID++;
        return ID;
        // GC makes these nonunique:
        // return System.identityHashCode(node);
    }
};
org.antlr.runtime.tree.CommonTreeAdaptor = function() {};

org.antlr.lang.extend(org.antlr.runtime.tree.CommonTreeAdaptor,
                  org.antlr.runtime.tree.BaseTreeAdaptor, {
    /** Duplicate a node.  This is part of the factory;
     *    override if you want another kind of node to be built.
     *
     *  I could use reflection to prevent having to override this
     *  but reflection is slow.
     */
    dupNode: function(t) {
        if ( !org.antlr.lang.isValue(t) ) {
            return null;
        }
        return t.dupNode();
    },

    create: function(payload) {
        if (arguments.length>1) {
            return org.antlr.runtime.tree.CommonTreeAdaptor.superclass.create.apply(this, arguments);
        }
        return new org.antlr.runtime.tree.CommonTree(payload);
    },

    /** Tell me how to create a token for use with imaginary token nodes.
     *  For example, there is probably no input symbol associated with imaginary
     *  token DECL, but you need to create it as a payload or whatever for
     *  the DECL node as in ^(DECL type ID).
     *
     *  If you care what the token payload objects' type is, you should
     *  override this method and any other createToken variant.
     *
     * Tell me how to create a token for use with imaginary token nodes.
     *  For example, there is probably no input symbol associated with imaginary
     *  token DECL, but you need to create it as a payload or whatever for
     *  the DECL node as in ^(DECL type ID).
     *
     *  This is a variant of createToken where the new token is derived from
     *  an actual real input token.  Typically this is for converting '{'
     *  tokens to BLOCK etc...  You'll see
     *
     *    r : lc='{' ID+ '}' -> ^(BLOCK[$lc] ID+) ;
     *
     *  If you care what the token payload objects' type is, you should
     *  override this method and any other createToken variant.
     */
    createToken: function(fromToken) {
        if (arguments.length===2) {
            return new org.antlr.runtime.CommonToken(arguments[0], arguments[1]);
        } else {
            return new org.antlr.runtime.CommonToken(arguments[0]);
        }
    },

    /** Track start/stop token for subtree root created for a rule.
     *  Only works with Tree nodes.  For rules that match nothing,
     *  seems like this will yield start=i and stop=i-1 in a nil node.
     *  Might be useful info so I'll not force to be i..i.
     */
    setTokenBoundaries: function(t, startToken, stopToken) {
        if ( !org.antlr.lang.isValue(t) ) {
            return;
        }
        var start = 0,
            stop = 0;
        if ( org.antlr.lang.isValue(startToken) ) {
            if (startToken.getTokenIndex) {
                start = startToken.getTokenIndex();
            } else if (startToken.getStartIndex) {
                start = startToken.getStartIndex();
            } else {
                start = startToken.getTokenStartIndex();
            }
        }
        if ( org.antlr.lang.isValue(stopToken) ) {
            if (stop.getTokenIndex) {
                stop = stopToken.getTokenIndex();
            } else if (stopToken.getStopIndex) {
                stop = stopToken.getStopIndex();
            } else {
                stop = stopToken.getTokenStopIndex();
            }
        }
        t.setTokenStartIndex(start);
        t.setTokenStopIndex(stop);
    },

    getTokenStartIndex: function(t) {
        if (!t) {
            return -1;
        }
        return t.getTokenStartIndex();
    },

    getTokenStopIndex: function(t) {
        if (!t) {
            return -1;
        }
        return t.getTokenStopIndex();
    },

    getText: function(t) {
        if (!t) {
            return null;
        }
        return t.getText();
    },

    getType: function(t) {
        if (!t) {
            return org.antlr.runtime.Token.INVALID_TOKEN_TYPE;
        }
        return t.getType();
    },

    /** What is the Token associated with this node?  If
     *  you are not using CommonTree, then you must
     *  override this in your own adaptor.
     */
    getToken: function(t) {
        if ( t instanceof org.antlr.runtime.tree.CommonTree ) {
            return t.getToken();
        }
        return null; // no idea what to do
    },

    getChild: function(t, i) {
        if (!t) {
            return null;
        }
        return t.getChild(i);
    },

    getChildCount: function(t) {
        if (!t) {
            return 0;
        }
        return t.getChildCount();
    },

    getParent: function(t) {
        return t.getParent();
    },

    setParent: function(t, parent) {
        t.setParent(parent);
    },

    getChildIndex: function(t) {
        return t.getChildIndex();
    },

    setChildIndex: function(t, index) {
        t.setChildIndex(index);
    },

    replaceChildren: function(parent, startChildIndex, stopChildIndex, t) {
        if ( parent ) {
            parent.replaceChildren(startChildIndex, stopChildIndex, t);
        }
    }
});
org.antlr.runtime.ANTLRStringStream = function(data) {
    /**
     * Location in the stream.
     * Ranges from 0 to (stream length - 1).
     * @private
     * @type Number
     */
    this.p = 0;
    this.line = 1;
    this.charPositionInLine = 0;
    this.markDepth = 0;
    this.markers = null;
    this.lastMarker = null;
    this.data = data;
    this.n = data.length;
};

org.antlr.runtime.ANTLRStringStream.prototype = {
    /**
     * Reset the stream so that it's in the same state it was
     * when the object was created *except* the data array is not
     * touched.
     */
    reset: function() {
       this.p = 0;
       this.line = 1;
       this.charPositionInLine = 0;
       this.markDepth = 0;
    },

    /**
     * Consume the next character of data in the stream.
     */
    consume: function() {
        //console.log("prev p="+ this.p +", c="+ this.data.charAt(this.p));
        if ( this.p < this.n ) {
            this.charPositionInLine++;
            if ( this.data.charAt(this.p)==="\n" ) {
                this.line++;
                this.charPositionInLine=0;
            }
            this.p++;
            //console.log("p moves to " + this.p + " (c='"+ this.data.charAt(this.p) +"')");
        }
    },

    /**
     * Get character at current input pointer + i ahead where i=1 is next int.
     * Negative indexes are allowed.  LA(-1) is previous token (token
     * just matched).  LA(-i) where i is before first token should
     * yield -1, invalid char / EOF.
     * @param {Number} i non-zero amount of lookahead or lookback
     * @returns {String|Number} The charcter at the specified position or -1 if
     *      you fell off either end of the stream.
     */
    LA: function(i) {
        if ( i<0 ) {
            i++; // e.g., translate LA(-1) to use offset i=0; then data[p+0-1]
        }

        var new_pos = this.p+i-1;
        if (new_pos>=this.n || new_pos<0) {
            return org.antlr.runtime.CharStream.EOF;
        }
        return this.data.charAt(new_pos);
    },


    /**
     * Return the current input symbol index 0..n where n indicates the
     * last symbol has been read.  The index is the index of char to
     * be returned from LA(1) (i.e. the one about to be consumed).
     * @returns {Number} the index of the current input symbol
     */
    index: function() {
        return this.p;
    },

    /**
     * The length of this stream.
     * @returns {Number} the length of this stream.
     */
    size: function() {
        return this.n;
    },

    /**
     * Tell the stream to start buffering if it hasn't already.  Return
     * current input position, index(), or some other marker so that
     * when passed to rewind() you get back to the same spot.
     * rewind(mark()) should not affect the input cursor.  The Lexer
     * tracks line/col info as well as input index so its markers are
     * not pure input indexes.  Same for tree node streams.
     *
     * <p>Marking is a mechanism for storing the current position of a stream
     * in a stack.  This corresponds with the predictive look-ahead mechanism
     * used in Lexers.</p>
     * @returns {Number} the current size of the mark stack.
     */
    mark: function() {
        if ( !this.markers ) {
            this.markers = [];
            this.markers.push(null); // depth 0 means no backtracking, leave blank
        }
        this.markDepth++;
        var state = null;
        if ( this.markDepth>=this.markers.length ) {
            state = {};
            this.markers.push(state);
        }
        else {
            state = this.markers[this.markDepth];
        }
        state.p = this.p;
        state.line = this.line;
        state.charPositionInLine = this.charPositionInLine;
        this.lastMarker = this.markDepth;
        return this.markDepth;
    },

    /**
     * Rewind to the input position of the last marker.
     * Used currently only after a cyclic DFA and just
     * before starting a sem/syn predicate to get the
     * input position back to the start of the decision.
     * Do not "pop" the marker off the state.  mark(i)
     * and rewind(i) should balance still. It is
     * like invoking rewind(last marker) but it should not "pop"
     * the marker off.  It's like seek(last marker's input position).
     * @param {Number} [m] the index in the mark stack to load instead of the
     *      last.
     */
    rewind: function(m) {
        if (!org.antlr.lang.isNumber(m)) {
            m = this.lastMarker;
        }

        var state = this.markers[m];
        // restore stream state
        this.seek(state.p);
        this.line = state.line;
        this.charPositionInLine = state.charPositionInLine;
        this.release(m);
    },

    /**
     * You may want to commit to a backtrack but don't want to force the
     * stream to keep bookkeeping objects around for a marker that is
     * no longer necessary.  This will have the same behavior as
     * rewind() except it releases resources without the backward seek.
     * This must throw away resources for all markers back to the marker
     * argument.  So if you're nested 5 levels of mark(), and then release(2)
     * you have to release resources for depths 2..5.
     * @param {Number} marker the mark depth above which all mark states will
     *      be released.
     */
    release: function(marker) {
        // unwind any other markers made after m and release m
        this.markDepth = marker;
        // release this marker
        this.markDepth--;
    },

    /**
     * Set the input cursor to the position indicated by index.  This is
     * normally used to seek ahead in the input stream.  No buffering is
     * required to do this unless you know your stream will use seek to
     * move backwards such as when backtracking.
     *
     * <p>This is different from rewind in its multi-directional
     * requirement and in that its argument is strictly an input cursor
     * (index).</p>
     *
     * <p>For char streams, seeking forward must update the stream state such
     * as line number.  For seeking backwards, you will be presumably
     * backtracking using the mark/rewind mechanism that restores state and
     * so this method does not need to update state when seeking backwards.</p>
     *
     * <p>Currently, this method is only used for efficient backtracking using
     * memoization, but in the future it may be used for incremental
     * parsing.</p>
     *
     * <p>The index is 0..n-1.  A seek to position i means that LA(1) will
     * return the ith symbol.  So, seeking to 0 means LA(1) will return the
     * first element in the stream.</p>
     *
     * <p>Esentially this method method moves the input position,
     * {@link #consume}-ing data if necessary.</p>
     *
     * @param {Number} index the position to seek to.
     */
    seek: function(index) {
        if ( index<=this.p ) {
            this.p = index; // just jump; don't update stream state (line, ...)
            return;
        }
        // seek forward, consume until p hits index
        while ( this.p<index ) {
            this.consume();
        }
    },

    /**
     * Retrieve a substring from this stream.
     * @param {Number} start the starting index of the substring (inclusive).
     * @param {Number} stop the last index of the substring (inclusive).
     * @returns {String}
     */
    substring: function(start, stop) {
        return this.data.substr(start,stop-start+1);
    },

    /**
     * Return the current line position in the stream.
     * @returns {Number} the current line position in the stream (1..numlines).
     */
    getLine: function() {
        return this.line;
    },

    /**
     * Get the index of the character relative to the beginning of the line.
     * Ranges from 0 to (length of line - 1).
     * @returns {Number}
     */
    getCharPositionInLine: function() {
        return this.charPositionInLine;
    },

    /**
     * Set the current line in the input stream.
     * This is used internally when performing rewinds.
     * @param {Number} line
     * @private
     */
    setLine: function(line) {
        this.line = line;
    },

    /**
     * Set the index of the character relative to the beginning of the line.
     * Ranges from 0 to (length of line - 1).
     * @param {Number} pos
     * @private
     */
    setCharPositionInLine: function(pos) {
        this.charPositionInLine = pos;
    },

    /** Where are you getting symbols from? Normally, implementations will
     *  pass the buck all the way to the lexer who can ask its input stream
     *  for the file name or whatever.
     */
    getSourceName: function() {
        return null;
    }
};
org.antlr.runtime.ANTLRStringStream.LT = org.antlr.runtime.ANTLRStringStream.LA;
org.antlr.runtime.CommonTokenStream = function(tokenSource, channel) {
    this.p = -1;
    this.channel = org.antlr.runtime.Token.DEFAULT_CHANNEL;
    this.v_discardOffChannelTokens = false;

    this.tokens = [];
    if (arguments.length >= 2) {
        this.channel = channel;
    } else if (arguments.length === 1) {
        this.tokenSource = tokenSource;
    }
};

org.antlr.runtime.CommonTokenStream.prototype = {
    /** Reset this token stream by setting its token source. */
    setTokenSource: function(tokenSource) {
        this.tokenSource = tokenSource;
        this.tokens = [];
        this.p = -1;
        this.channel = org.antlr.runtime.Token.DEFAULT_CHANNEL;
    },

    /** Load all tokens from the token source and put in tokens.
     *  This is done upon first LT request because you might want to
     *  set some token type / channel overrides before filling buffer.
     */
    fillBuffer: function() {
        var index = 0,
            t = this.tokenSource.nextToken(),
            discard,
            channelI;
        while ( org.antlr.lang.isValue(t) && 
                t.getType()!=org.antlr.runtime.CharStream.EOF )
        {
            discard = false;
            // is there a channel override for token type?
            if ( this.channelOverrideMap ) {
                channelI = this.channelOverrideMap[t.getType()];
                if ( org.antlr.lang.isValue(channelI) ) {
                    t.setChannel(channelI);
                }
            }
            if ( this.discardSet && this.discardSet[t.getType()] )
            {
                discard = true;
            }
            else if ( this.v_discardOffChannelTokens &&
                    t.getChannel()!=this.channel )
            {
                discard = true;
            }
            if ( !discard )    {
                t.setTokenIndex(index);
                this.tokens.push(t);
                index++;
            }
            t = this.tokenSource.nextToken();
        }
        // leave p pointing at first token on channel
        this.p = 0;
        this.p = this.skipOffTokenChannels(this.p);
    },

    /** Move the input pointer to the next incoming token.  The stream
     *  must become active with LT(1) available.  consume() simply
     *  moves the input pointer so that LT(1) points at the next
     *  input symbol. Consume at least one token.
     *
     *  Walk past any token not on the channel the parser is listening to.
     */
    consume: function() {
        if ( this.p<this.tokens.length ) {
            this.p++;
            this.p = this.skipOffTokenChannels(this.p); // leave p on valid token
        }
    },

    /** Given a starting index, return the index of the first on-channel
     *  token.
     */
    skipOffTokenChannels: function(i) {
        var n = this.tokens.length;
        while ( i<n && (this.tokens[i]).getChannel()!=this.channel ) {
            i++;
        }
        return i;
    },

    skipOffTokenChannelsReverse: function(i) {
        while ( i>=0 && (this.tokens[i]).getChannel()!=this.channel ) {
            i--;
        }
        return i;
    },

    /** A simple filter mechanism whereby you can tell this token stream
     *  to force all tokens of type ttype to be on channel.  For example,
     *  when interpreting, we cannot exec actions so we need to tell
     *  the stream to force all WS and NEWLINE to be a different, ignored
     *  channel.
     */
    setTokenTypeChannel: function(ttype, channel) {
        if ( !this.channelOverrideMap ) {
            this.channelOverrideMap = {};
        }
        this.channelOverrideMap[ttype] = channel;
    },

    discardTokenType: function(ttype) {
        if ( !this.discardSet ) {
            this.discardSet = {};
        }
        this.discardSet[ttype] = true;
    },

    discardOffChannelTokens: function(b) {
        this.v_discardOffChannelTokens = b;
    },

    /** Given a start and stop index, return a List of all tokens in
     *  the token type BitSet.  Return null if no tokens were found.  This
     *  method looks at both on and off channel tokens.
     */
    getTokens: function(start, stop, types) {
        if ( this.p === -1 ) {
            this.fillBuffer();
        }

        if (arguments.length===0) {
            return this.tokens;
        }

        if (org.antlr.lang.isArray(types)) {
            types = new org.antlr.runtime.BitSet(types);
        } else if (org.antlr.lang.isNumber(types)) {
            types = org.antlr.runtime.BitSet.of(types);
        }

        if ( stop>=this.tokens.length ) {
            stop=this.tokens.length-1;
        }
        if ( start<0 ) {
            start=0;
        }
        if ( start>stop ) {
            return null;
        }

        // list = tokens[start:stop]:{Token t, t.getType() in types}
        var filteredTokens = [],
            i,
            t;
        for (i=start; i<=stop; i++) {
            t = this.tokens[i];
            if ( !this.types || types.member(t.getType()) ) {
                filteredTokens.push(t);
            }
        }
        if ( filteredTokens.length===0 ) {
            filteredTokens = null;
        }
        return filteredTokens;
    },

    /** Get the ith token from the current position 1..n where k=1 is the
     *  first symbol of lookahead.
     */
    LT: function(k) {
        if ( this.p === -1 ) {
            this.fillBuffer();
        }
        if ( k===0 ) {
            return null;
        }
        if ( k<0 ) {
            return this.LB(-1*k);
        }
        if ( (this.p+k-1) >= this.tokens.length ) {
            return org.antlr.runtime.Token.EOF_TOKEN;
        }
        var i = this.p,
            n = 1;
        // find k good tokens
        while ( n<k ) {
            // skip off-channel tokens
            i = this.skipOffTokenChannels(i+1); // leave p on valid token
            n++;
        }
        if ( i>=this.tokens.length ) {
            return org.antlr.runtime.Token.EOF_TOKEN;
        }
        return this.tokens[i];
    },

    /** Look backwards k tokens on-channel tokens */
    LB: function(k) {
        if ( this.p === -1 ) {
            this.fillBuffer();
        }
        if ( k===0 ) {
            return null;
        }
        if ( (this.p-k)<0 ) {
            return null;
        }

        var i = this.p,
            n = 1;
        // find k good tokens looking backwards
        while ( n<=k ) {
            // skip off-channel tokens
            i = this.skipOffTokenChannelsReverse(i-1); // leave p on valid token
            n++;
        }
        if ( i<0 ) {
            return null;
        }
        return this.tokens[i];
    },

    /** Return absolute token i; ignore which channel the tokens are on;
     *  that is, count all tokens not just on-channel tokens.
     */
    get: function(i) {
        return this.tokens[i];
    },

    LA: function(i) {
        return this.LT(i).getType();
    },

    mark: function() {
        if ( this.p === -1 ) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    },

    release: function(marker) {
        // no resources to release
    },

    size: function() {
        return this.tokens.length;
    },

    index: function() {
        return this.p;
    },

    rewind: function(marker) {
        if (!org.antlr.lang.isNumber(marker)) {
            marker = this.lastMarker;
        }
        this.seek(marker);
    },

    reset: function() {
        this.p = -1;
        this.lastMarker = 0;
    },

    seek: function(index) {
        this.p = index;
    },

    getTokenSource: function() {
        return this.tokenSource;
    },

    getSourceName: function() {
        return this.getTokenSource().getSourceName();
    },

    toString: function(start, stop) {
        if (arguments.length===0) {
            if ( this.p === -1 ) {
                this.fillBuffer();
            }
            start = 0;
            stop = this.tokens.length-1;
        }

        if (!org.antlr.lang.isNumber(start) && !org.antlr.lang.isNumber(stop)) {
            if ( org.antlr.lang.isValue(start) && org.antlr.lang.isValue(stop) ) {
                start = start.getTokenIndex();
                stop = stop.getTokenIndex();
            } else {
                return null;
            }
        }

        var buf = "",
            i;
 
        if ( start<0 || stop<0 ) {
            return null;
        }
        if ( this.p == -1 ) {
            this.fillBuffer();
        }
        if ( stop>=this.tokens.length ) {
            stop = this.tokens.length-1;
        }
        for (i = start; i <= stop; i++) {
            t = this.tokens[i];
            buf = buf + this.tokens[i].getText();
        }
        return buf;
    }
};

org.antlr.runtime.TokenRewriteStream = function() {
    var sup = org.antlr.runtime.TokenRewriteStream.superclass;
    this.programs = null;
    this.lastRewriteTokenIndexes = null;


    if (arguments.length===0) {
        this.init();
    } else {
        sup.constructor.apply(this, arguments);
        this.init();
    }
};

(function(){
var trs = org.antlr.runtime.TokenRewriteStream;

org.antlr.lang.augmentObject(trs, {
    DEFAULT_PROGRAM_NAME: "default",
    PROGRAM_INIT_SIZE: 100,
    MIN_TOKEN_INDEX: 0
});

//
// Define the rewrite operation hierarchy
//

trs.RewriteOperation = function(index, text) {
    this.index = index;
    this.text = text;
};
trs.RewriteOperation.prototype = {
    execute: function(buf) {
        return this.index;
    },
    toString: function() {
        /*String opName = getClass().getName();
        int $index = opName.indexOf('$');
        opName = opName.substring($index+1, opName.length());
        return opName+"@"+index+'"'+text+'"';*/
        return this.text;
    }
};

trs.InsertBeforeOp = function(index, text) {
    trs.InsertBeforeOp.superclass.constructor.call(this, index, text);
};
org.antlr.lang.extend(trs.InsertBeforeOp, trs.RewriteOperation, {
    execute: function(buf) {
        buf.push(this.text);
        return this.index;
    }
});
trs.ReplaceOp = function(from, to, text) {
    trs.ReplaceOp.superclass.constructor.call(this, from, text); 
    this.lastIndex = to;
};
org.antlr.lang.extend(trs.ReplaceOp, trs.RewriteOperation, {
    execute: function(buf) {
        if (org.antlr.lang.isValue(this.text)) {
            buf.push(this.text);
        }
        return this.lastIndex+1;
    }
});

trs.DeleteOp = function(from, to) {
    trs.DeleteOp.superclass.constructor.call(this, from, to); 
};
org.antlr.lang.extend(trs.DeleteOp, trs.ReplaceOp);

org.antlr.lang.extend(trs, org.antlr.runtime.CommonTokenStream, {
    init: function() {
        this.programs = {};
        this.programs[trs.DEFAULT_PROGRAM_NAME] = [];
        this.lastRewriteTokenIndexes = {};
    },

    /** Rollback the instruction stream for a program so that
     *  the indicated instruction (via instructionIndex) is no
     *  longer in the stream.  UNTESTED!
     */
    rollback: function() {
        var programName,
            instructionIndex;

        if (arguments.length===1) {
            programName = trs.DEFAULT_PROGRAM_NAME;
            instructionIndex = arguments[0];
        } else if (arguments.length===2) {
            programName = arguments[0];
            instructionIndex = arguments[1];
        }
        var is = this.programs[programName];
        if (is) {
            programs[programName] = is.slice(trs.MIN_TOKEN_INDEX, this.instructionIndex);
        }
    },

    /** Reset the program so that no instructions exist */
    deleteProgram: function(programName) {
        programName = programName || trs.DEFAULT_PROGRAM_NAME;
        this.rollback(programName, trs.MIN_TOKEN_INDEX);
    },

    /** Add an instruction to the rewrite instruction list ordered by
     *  the instruction number (use a binary search for efficiency).
     *  The list is ordered so that toString() can be done efficiently.
     *
     *  When there are multiple instructions at the same index, the instructions
     *  must be ordered to ensure proper behavior.  For example, a delete at
     *  index i must kill any replace operation at i.  Insert-before operations
     *  must come before any replace / delete instructions.  If there are
     *  multiple insert instructions for a single index, they are done in
     *  reverse insertion order so that "insert foo" then "insert bar" yields
     *  "foobar" in front rather than "barfoo".  This is convenient because
     *  I can insert new InsertOp instructions at the index returned by
     *  the binary search.  A ReplaceOp kills any previous replace op.  Since
     *  delete is the same as replace with null text, i can check for
     *  ReplaceOp and cover DeleteOp at same time. :)
     */
    addToSortedRewriteList: function() {
        var programName,
            op;
        if (arguments.length===1) {
            programName = trs.DEFAULT_PROGRAM_NAME;
            op = arguments[0];
        } else if (arguments.length===2) {
            programName = arguments[0];
            op = arguments[1];
        }

        var rewrites = this.getProgram(programName);
        var len, pos, searchOp, replaced, prevOp, i;
        for (pos=0, len=rewrites.length; pos<len; pos++) {
            searchOp = rewrites[pos];
            if (searchOp.index===op.index) {
                // now pos is the index in rewrites of first op with op.index

                // an instruction operating already on that index was found;
                // make this one happen after all the others
                if (op instanceof trs.ReplaceOp) {
                    replaced = false;
                    // look for an existing replace
                    for (i=pos; i<rewrites.length; i++) {
                        prevOp = rewrites[pos];
                        if (prevOp.index!==op.index) {
                            break;
                        }
                        if (prevOp instanceof trs.ReplaceOp) {
                            rewrites[pos] = op; // replace old with new
                            replaced=true;
                            break;
                        }
                        // keep going; must be an insert
                    }
                    if ( !replaced ) {
                        // add replace op to the end of all the inserts
                        rewrites.splice(i, 0, op);
                    }
                } else {
                    // inserts are added in front of existing inserts
                    rewrites.splice(pos, 0, op);
                }
                break;
            } else if (searchOp.index > op.index) {
                rewrites.splice(pos, 0, op);
                break;
            }
        }
        if (pos===len) {
            rewrites.push(op);
        }
    },

    insertAfter: function() {
        var index, programName, text;
        if (arguments.length===2) {
            programName = trs.DEFAULT_PROGRAM_NAME;
            index = arguments[0];
            text = arguments[1];
        } else if (arguments.length===3) {
            programName = arguments[0];
            index = arguments[1];
            text = arguments[2];
        }

        if (index instanceof org.antlr.runtime.CommonToken) {
            // index is a Token, grab it's stream index
            index = index.index; // that's ugly
        }

        // insert after is the same as insert before the next index
        this.insertBefore(programName, index+1, text);
    },

    insertBefore: function() {
        var index, programName, text;
        if (arguments.length===2) {
            programName = trs.DEFAULT_PROGRAM_NAME;
            index = arguments[0];
            text = arguments[1];
        } else if (arguments.length===3) {
            programName = arguments[0];
            index = arguments[1];
            text = arguments[2];
        }

        if (index instanceof org.antlr.runtime.CommonToken) {
            // index is a Token, grab it's stream index
            index = index.index; // that's ugly
        }

        this.addToSortedRewriteList(
                programName,
                new trs.InsertBeforeOp(index,text)
                );
    },

    replace: function() {
        var programName, first, last, text;
        if (arguments.length===2) {
            programName = trs.DEFAULT_PROGRAM_NAME;
            first = arguments[0];
            last = arguments[0];
            text = arguments[1];
        } else if (arguments.length===3) {
            programName = trs.DEFAULT_PROGRAM_NAME;
            first = arguments[0];
            last = arguments[1];
            text = arguments[2];
        } if (arguments.length===4) {
            programName = arguments[0];
            first = arguments[1];
            last = arguments[2];
            text = arguments[3];
        } 

        if (first instanceof org.antlr.runtime.CommonToken) {
            first = first.index;
        }

        if (last instanceof org.antlr.runtime.CommonToken) {
            last = last.index; // that's ugly
        }

        if ( first > last || last<0 || first<0 ) {
            return;
        }
        this.addToSortedRewriteList(
                programName,
                new trs.ReplaceOp(first, last, text));
    },

    // !!! API Break: delete is a JS keyword, so using remove instead.
    remove: function() {
        // convert arguments to a real array
        var args=[], i=arguments.length-1;
        while (i>=0) {
            args[i] = arguments[i];
            i--;
        }

        args.push("");
        this.replace.apply(this, args);
    },

    getLastRewriteTokenIndex: function(programName) {
        programName = programName || trs.DEFAULT_PROGRAM_NAME;
        return this.lastRewriteTokenIndexes[programName] || -1;
    },

    setLastRewriteTokenIndex: function(programName, i) {
        this.lastRewriteTokenIndexes[programName] = i;
    },

    getProgram: function(name) {
        var is = this.programs[name];
        if ( !is ) {
            is = this.initializeProgram(name);
        }
        return is;
    },

    initializeProgram: function(name) {
        var is = [];
        this.programs[name] = is;
        return is;
    },

    toOriginalString: function(start, end) {
        if (!org.antlr.lang.isNumber(start)) {
            start = trs.MIN_TOKEN_INDEX;
        }
        if (!org.antlr.lang.isNumber(end)) {
            end = this.size()-1;
        }

        var buf = [], i;
        for (i=start; i>=trs.MIN_TOKEN_INDEX && i<=end && i<this.tokens.length; i++) {
            buf.push(this.get(i).getText());
        }
        return buf.join("");
    },

    toString: function() {
        var programName, start, end;
        if (arguments.length===0) {
            programName = trs.DEFAULT_PROGRAM_NAME;
            start = trs.MIN_TOKEN_INDEX;
            end = this.size() - 1;
        } else if (arguments.length===1) {
            programName = arguments[0];
            start = trs.MIN_TOKEN_INDEX;
            end = this.size() - 1;
        } else if (arguments.length===2) {
            programName = trs.DEFAULT_PROGRAM_NAME;
            start = arguments[0];
            end = arguments[1];
        }

        var rewrites = this.programs[programName];
        if ( !rewrites || rewrites.length===0 ) {
            return this.toOriginalString(start,end);
        }

        /// Index of first rewrite we have not done
        var rewriteOpIndex = 0,
            tokenCursor=start,
            buf = [],
            op;
        while ( tokenCursor>=trs.MIN_TOKEN_INDEX &&
                tokenCursor<=end &&
                tokenCursor<this.tokens.length )
        {
            // execute instructions associated with this token index
            if ( rewriteOpIndex<rewrites.length ) {
                op = rewrites[rewriteOpIndex];

                // skip all ops at lower index
                while (op.index<tokenCursor && rewriteOpIndex<rewrites.length) {
                    rewriteOpIndex++;
                    if ( rewriteOpIndex<rewrites.length ) {
                        op = rewrites[rewriteOpIndex];
                    }
                }

                // while we have ops for this token index, exec them
                while (tokenCursor===op.index && rewriteOpIndex<rewrites.length) {
                    //System.out.println("execute "+op+" at instruction "+rewriteOpIndex);
                    tokenCursor = op.execute(buf);
                    //System.out.println("after execute tokenCursor = "+tokenCursor);
                    rewriteOpIndex++;
                    if ( rewriteOpIndex<rewrites.length ) {
                        op = rewrites[rewriteOpIndex];
                    }
                }
            }
            // dump the token at this index
            if ( tokenCursor<=end ) {
                buf.push(this.get(tokenCursor).getText());
                tokenCursor++;
            }
        }
        // now see if there are operations (append) beyond last token index
        var opi;
        for (opi=rewriteOpIndex; opi<rewrites.length; opi++) {
            op = rewrites[opi];
            if ( op.index>=this.size() ) {
                op.execute(buf); // must be insertions if after last token
            }
        }

        return buf.join("");
    },

    toDebugString: function(start, end) {
        if (!org.antlr.lang.isNumber(start)) {
            start = trs.MIN_TOKEN_INDEX;
        }
        if (!org.antlr.lang.isNumber(end)) {
            end = this.size()-1;
        }

        var buf = [],
            i;
        for (i=start; i>=trs.MIN_TOKEN_INDEX && i<=end && i<this.tokens.length; i++) {
            buf.push(this.get(i));
        }
        return buf.join("");
    }
});

})();
org.antlr.runtime.tree.TreeNodeStream = function() {};
org.antlr.runtime.tree.CommonTreeNodeStream = function(adaptor,
                                                    tree,
                                                    initialBufferSize)
{
    if (arguments.length===1) {
        tree = adaptor;
        adaptor = new org.antlr.runtime.tree.CommonTreeAdaptor();
    }
    if (arguments.length <= 2) {
        initialBufferSize =
            org.antlr.runtime.tree.CommonTreeNodeStream.DEFAULT_INITIAL_BUFFER_SIZE;
    }

    /** Reuse same DOWN, UP navigation nodes unless this is true */
    this.uniqueNavigationNodes = false;
    this.p = -1;

    var Token = org.antlr.runtime.Token;
    this.root = tree;
    this.adaptor = adaptor;
    this.nodes = []; //new ArrayList(initialBufferSize);
    this.down = this.adaptor.create(Token.DOWN, "DOWN");
    this.up = this.adaptor.create(Token.UP, "UP");
    this.eof = this.adaptor.create(Token.EOF, "EOF");
};

org.antlr.lang.augmentObject(org.antlr.runtime.tree.CommonTreeNodeStream, {
    DEFAULT_INITIAL_BUFFER_SIZE: 100,
    INITIAL_CALL_STACK_SIZE: 10
});

org.antlr.lang.extend(org.antlr.runtime.tree.CommonTreeNodeStream,
                  org.antlr.runtime.tree.TreeNodeStream, 
{
    StreamIterator: function() {
        var i = 0,
            nodes = this.nodes,
            eof = this.eof;

        return {
            hasNext: function() {
                return i<nodes.length;
            },

            next: function() {
                var current = i;
                i++;
                if ( current < nodes.length ) {
                    return nodes[current];
                }
                return eof;
            },

            remove: function() {
                throw new Error("cannot remove nodes from stream");
            }
        };
    },

    /** Walk tree with depth-first-search and fill nodes buffer.
     *  Don't do DOWN, UP nodes if its a list (t is isNil).
     */
    fillBuffer: function(t) {
        var reset_p = false;
        if (org.antlr.lang.isUndefined(t)) {
            t = this.root;
            reset_p = true;
        }

        var nil = this.adaptor.isNil(t);
        if ( !nil ) {
            this.nodes.push(t); // add this node
        }
        // add DOWN node if t has children
        var n = this.adaptor.getChildCount(t);
        if ( !nil && n>0 ) {
            this.addNavigationNode(org.antlr.runtime.Token.DOWN);
        }
        // and now add all its children
        var c, child;
        for (c=0; c<n; c++) {
            child = this.adaptor.getChild(t,c);
            this.fillBuffer(child);
        }
        // add UP node if t has children
        if ( !nil && n>0 ) {
            this.addNavigationNode(org.antlr.runtime.Token.UP);
        }

        if (reset_p) {
            this.p = 0; // buffer of nodes intialized now
        }
    },

    getNodeIndex: function(node) {
        if ( this.p==-1 ) {
            this.fillBuffer();
        }
        var i, t;
        for (i=0; i<this.nodes.length; i++) {
            t = this.nodes[i];
            if ( t===node ) {
                return i;
            }
        }
        return -1;
    },

    /** As we flatten the tree, we use UP, DOWN nodes to represent
     *  the tree structure.  When debugging we need unique nodes
     *  so instantiate new ones when uniqueNavigationNodes is true.
     */
    addNavigationNode: function(ttype) {
        var navNode = null;
        if ( ttype===org.antlr.runtime.Token.DOWN ) {
            if ( this.hasUniqueNavigationNodes() ) {
                navNode = this.adaptor.create(org.antlr.runtime.Token.DOWN, "DOWN");
            }
            else {
                navNode = this.down;
            }
        }
        else {
            if ( this.hasUniqueNavigationNodes() ) {
                navNode = this.adaptor.create(org.antlr.runtime.Token.UP, "UP");
            }
            else {
                navNode = this.up;
            }
        }
        this.nodes.push(navNode);
    },

    get: function(i) {
        if ( this.p===-1 ) {
            this.fillBuffer();
        }
        return this.nodes[i];
    },

    LT: function(k) {
        if ( this.p===-1 ) {
            this.fillBuffer();
        }
        if ( k===0 ) {
            return null;
        }
        if ( k<0 ) {
            return this.LB(-1*k);
        }
        if ( (this.p+k-1) >= this.nodes.length ) {
            return this.eof;
        }
        return this.nodes[this.p+k-1];
    },

    getCurrentSymbol: function() { return this.LT(1); },

    /** Look backwards k nodes */
    LB: function(k) {
        if ( k===0 ) {
            return null;
        }
        if ( (this.p-k)<0 ) {
            return null;
        }
        return this.nodes[this.p-k];
    },

    getTreeSource: function() {
        return this.root;
    },

    getSourceName: function() {
        return this.getTokenStream().getSourceName();
    },

    getTokenStream: function() {
        return this.tokens;
    },

    setTokenStream: function(tokens) {
        this.tokens = tokens;
    },

    getTreeAdaptor: function() {
        return this.adaptor;
    },

    setTreeAdaptor: function(adaptor) {
        this.adaptor = adaptor;
    },

    hasUniqueNavigationNodes: function() {
        return this.uniqueNavigationNodes;
    },

    setUniqueNavigationNodes: function(uniqueNavigationNodes) {
        this.uniqueNavigationNodes = uniqueNavigationNodes;
    },

    consume: function() {
        if ( this.p===-1 ) {
            this.fillBuffer();
        }
        this.p++;
    },

    LA: function(i) {
        return this.adaptor.getType(this.LT(i));
    },

    mark: function() {
        if ( this.p===-1 ) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    },

    release: function(marker) {
        // no resources to release
    },

    index: function() {
        return this.p;
    },

    rewind: function(marker) {
        if (!org.antlr.lang.isNumber(marker)) {
            marker = this.lastMarker;
        }
        this.seek(marker);
    },

    seek: function(index) {
        if ( this.p===-1 ) {
            this.fillBuffer();
        }
        this.p = index;
    },

    /** Make stream jump to a new location, saving old location.
     *  Switch back with pop().
     */
    push: function(index) {
        if ( !this.calls ) {
            this.calls = [];
        }
        this.calls.push(this.p); // save current index
        this.seek(index);
    },

    /** Seek back to previous index saved during last push() call.
     *  Return top of stack (return index).
     */
    pop: function() {
        var ret = this.calls.pop();
        this.seek(ret);
        return ret;
    },

    reset: function() {
        this.p = -1;
        this.lastMarker = 0;
        if (this.calls) {
            this.calls = [];
        }
    },

    size: function() {
        if ( this.p===-1 ) {
            this.fillBuffer();
        }
        return this.nodes.length;
    },

    iterator: function() {
        if ( this.p===-1 ) {
            this.fillBuffer();
        }
        return this.StreamIterator();
    },

    replaceChildren: function(parent, startChildIndex, stopChildIndex, t) {
        if ( parent ) {
            this.adaptor.replaceChildren(parent, startChildIndex, stopChildIndex, t);
        }
    },

    /** Debugging */
    toTokenString: function(start, stop) {
        if ( this.p===-1 ) {
            this.fillBuffer();
        }
        var buf='', i, t;
        for (i = start; i < this.nodes.length && i <= stop; i++) {
            t = this.nodes[i];
            buf += " "+this.adaptor.getToken(t);
        }
        return buf;
    },

    /** Used for testing, just return the token type stream */
    toString: function(start, stop) {
        var buf = "",
            text,
            t,
            i;
        if (arguments.length===0) {
            if ( this.p===-1 ) {
                this.fillBuffer();
            }
            for (i = 0; i < this.nodes.length; i++) {
                t = this.nodes[i];
                buf += " ";
                buf += this.adaptor.getType(t);
            }
            return buf;
        } else {
            if ( !org.antlr.lang.isNumber(start) || !org.antlr.lang.isNumber(stop) ) {
                return null;
            }
            if ( this.p===-1 ) {
                this.fillBuffer();
            }
            //System.out.println("stop: "+stop);
            if ( start instanceof org.antlr.runtime.tree.CommonTree ) {
                //System.out.print("toString: "+((CommonTree)start).getToken()+", ");
            } else {
                //System.out.println(start);
            }
            if ( stop instanceof org.antlr.runtime.tree.CommonTree ) {
                //System.out.println(((CommonTree)stop).getToken());
            } else {
                //System.out.println(stop);
            }
            // if we have the token stream, use that to dump text in order
            var beginTokenIndex,
                endTokenIndex;
            if ( this.tokens ) {
                beginTokenIndex = this.adaptor.getTokenStartIndex(start);
                endTokenIndex = this.adaptor.getTokenStopIndex(stop);
                // if it's a tree, use start/stop index from start node
                // else use token range from start/stop nodes
                if ( this.adaptor.getType(stop)===org.antlr.runtime.Token.UP ) {
                    endTokenIndex = this.adaptor.getTokenStopIndex(start);
                }
                else if ( this.adaptor.getType(stop)==org.antlr.runtime.Token.EOF )
                {
                    endTokenIndex = this.size()-2; // don't use EOF
                }
                return this.tokens.toString(beginTokenIndex, endTokenIndex);
            }
            // walk nodes looking for start
            t = null;
            i = 0;
            for (; i < this.nodes.length; i++) {
                t = this.nodes[i];
                if ( t===start ) {
                    break;
                }
            }
            // now walk until we see stop, filling string buffer with text
            buf = text = "";
            t = this.nodes[i];
            while ( t!==stop ) {
                text = this.adaptor.getText(t);
                if ( !org.antlr.lang.isString(text) ) {
                    text = " "+this.adaptor.getType(t).toString();
                }
                buf += text;
                i++;
                t = nodes[i];
            }
            // include stop node too
            text = this.adaptor.getText(stop);
            if ( !org.antlr.lang.isString(text) ) {
                text = " "+this.adaptor.getType(stop).toString();
            }
            buf += text;
            return buf;
        }
    }
});
org.antlr.runtime.tree.RewriteRuleElementStream = function(adaptor, elementDescription, el) {
    /** Cursor 0..n-1.  If singleElement!=null, cursor is 0 until you next(),
     *  which bumps it to 1 meaning no more elements.
     */
    this.cursor = 0;
    this.dirty = false;

    this.elementDescription = elementDescription;
    this.adaptor = adaptor;
    if (el) {
        if (org.antlr.lang.isArray(el)) {
            this.singleElement = null;
            this.elements = el;
        } else {
            this.add(el);
        }
    }
};

org.antlr.runtime.tree.RewriteRuleElementStream.prototype = {
    /** Reset the condition of this stream so that it appears we have
     *  not consumed any of its elements.  Elements themselves are untouched.
     *  Once we reset the stream, any future use will need duplicates.  Set
     *  the dirty bit.
     */
    reset: function() {
        this.cursor = 0;
        this.dirty = true;
    },

    add: function(el) {
        if ( !org.antlr.lang.isValue(el) ) {
            return;
        }
        if ( this.elements ) { // if in list, just add
            this.elements.push(el);
            return;
        }
        if ( !org.antlr.lang.isValue(this.singleElement) ) { // no elements yet, track w/o list
            this.singleElement = el;
            return;
        }
        // adding 2nd element, move to list
        this.elements = [];
        this.elements.push(this.singleElement);
        this.singleElement = null;
        this.elements.push(el);
    },

    /** Return the next element in the stream.  If out of elements, throw
     *  an exception unless size()==1.  If size is 1, then return elements[0].
     *  Return a duplicate node/subtree if stream is out of elements and
     *  size==1.  If we've already used the element, dup (dirty bit set).
     */
    nextTree: function() {
        var n = this.size(),
            el;
        if ( this.dirty || (this.cursor>=n && n==1) ) {
            // if out of elements and size is 1, dup
            el = this._next();
            return this.dup(el);
        }
        // test size above then fetch
        el = this._next();
        return el;
    },

    /** do the work of getting the next element, making sure that it's
     *  a tree node or subtree.  Deal with the optimization of single-
     *  element list versus list of size > 1.  Throw an exception
     *  if the stream is empty or we're out of elements and size>1.
     *  protected so you can override in a subclass if necessary.
     */
    _next: function() {
        var n = this.size();
        if (n===0) {
            throw new org.antlr.runtime.tree.RewriteEmptyStreamException(this.elementDescription);
        }
        if ( this.cursor>= n) { // out of elements?
            if ( n===1 ) {  // if size is 1, it's ok; return and we'll dup
                return this.toTree(this.singleElement);
            }
            // out of elements and size was not 1, so we can't dup
            throw new org.antlr.runtime.tree.RewriteCardinalityException(this.elementDescription);
        }
        // we have elements
        if ( org.antlr.lang.isValue(this.singleElement) ) {
            this.cursor++; // move cursor even for single element list
            return this.toTree(this.singleElement);
        }
        // must have more than one in list, pull from elements
        var o = this.toTree(this.elements[this.cursor]);
        this.cursor++;
        return o;
    },

    /** Ensure stream emits trees; tokens must be converted to AST nodes.
     *  AST nodes can be passed through unmolested.
     */
    toTree: function(el) {
        if (el && el.getTree) {
            return el.getTree();
        }
        return el;
    },

    hasNext: function() {
         return (org.antlr.lang.isValue(this.singleElement) && this.cursor < 1) ||
               (this.elements && this.cursor < this.elements.length);
    },

    size: function() {
        var n = 0;
        if ( org.antlr.lang.isValue(this.singleElement) ) {
            n = 1;
        }
        if ( this.elements ) {
            return this.elements.length;
        }
        return n;
    },

    getDescription: function() {
        return this.elementDescription;
    }
};
org.antlr.runtime.tree.RewriteRuleNodeStream = function(adaptor, elementDescription, el) {
    org.antlr.runtime.tree.RewriteRuleNodeStream.superclass.constructor.apply(this, arguments);
};

org.antlr.lang.extend(org.antlr.runtime.tree.RewriteRuleNodeStream,
                  org.antlr.runtime.tree.RewriteRuleElementStream,
{
    nextNode: function() {
        return this._next();
    },

    toTree: function(el) {
        return this.adaptor.dupNode(el);
    },

    dup: function() {
        // we dup every node, so don't have to worry about calling dup; short-
        // circuited next() so it doesn't call.
        throw new Error("dup can't be called for a node stream.");
    }
});
org.antlr.runtime.tree.RewriteRuleTokenStream = function(adaptor, elementDescription, el) {
    var sup = org.antlr.runtime.tree.RewriteRuleTokenStream.superclass;
    sup.constructor.apply(this, arguments);
};

org.antlr.lang.extend(org.antlr.runtime.tree.RewriteRuleTokenStream,
                  org.antlr.runtime.tree.RewriteRuleElementStream, {
    /** Get next token from stream and make a node for it */
    nextNode: function() {
        var t = this._next();
        return this.adaptor.create(t);
    },

    nextToken: function() {
        return this._next();
    },

    /** Don't convert to a tree unless they explicitly call nextTree.
     *  This way we can do hetero tree nodes in rewrite.
     */
    toTree: function(el) {
        return el;
    },

    dup: function(el) {
        throw new Error("dup can't be called for a token stream.");
    }
});
org.antlr.runtime.tree.RewriteRuleSubtreeStream = function() {
    var sup = org.antlr.runtime.tree.RewriteRuleSubtreeStream.superclass;
    sup.constructor.apply(this, arguments);
};

org.antlr.lang.extend(org.antlr.runtime.tree.RewriteRuleSubtreeStream,
                  org.antlr.runtime.tree.RewriteRuleElementStream, {
	/** Treat next element as a single node even if it's a subtree.
	 *  This is used instead of next() when the result has to be a
	 *  tree root node.  Also prevents us from duplicating recently-added
	 *  children; e.g., ^(type ID)+ adds ID to type and then 2nd iteration
	 *  must dup the type node, but ID has been added.
	 *
	 *  Referencing a rule result twice is ok; dup entire tree as
	 *  we can't be adding trees as root; e.g., expr expr.
	 *
	 *  Hideous code duplication here with super.next().  Can't think of
	 *  a proper way to refactor.  This needs to always call dup node
	 *  and super.next() doesn't know which to call: dup node or dup tree.
	 */
    nextNode: function() {
		var n = this.size(),
            el;
		if ( this.dirty || (this.cursor>=n && n===1) ) {
			// if out of elements and size is 1, dup (at most a single node
			// since this is for making root nodes).
			el = this._next();
			return this.adaptor.dupNode(el);
		}
		// test size above then fetch
		el = this._next();
		return el;
	},

    dup: function(el) {
		return this.adaptor.dupTree(el);
	}
});
org.antlr.runtime.BaseRecognizer = function(state) {
    /** State of a lexer, parser, or tree parser are collected into a state
     *  object so the state can be shared.  This sharing is needed to
     *  have one grammar import others and share same error variables
     *  and other state variables.  It's a kind of explicit multiple
     *  inheritance via delegation of methods and shared state.
     */
    this.state = state || new org.antlr.runtime.RecognizerSharedState();
};
org.antlr.lang.augmentObject(org.antlr.runtime.BaseRecognizer, {
    MEMO_RULE_FAILED: -2,
    MEMO_RULE_UNKNOWN: -1,
    INITIAL_FOLLOW_STACK_SIZE: 100,
    MEMO_RULE_FAILED_I: -2,
    DEFAULT_TOKEN_CHANNEL: org.antlr.runtime.Token.DEFAULT_CHANNEL,
    HIDDEN: org.antlr.runtime.Token.HIDDEN_CHANNEL,
    NEXT_TOKEN_RULE_NAME: "nextToken"
});

org.antlr.runtime.BaseRecognizer.prototype = {
    /** Reset the parser's state.  Subclasses must rewinds the input stream */
    reset: function() {
        var i, len;

        // wack everything related to error recovery
        if (!this.state) {
            return; // no shared state work to do
        }
        this.state._fsp = -1;
        this.state.errorRecovery = false;
        this.state.lastErrorIndex = -1;
        this.state.failed = false;
        this.state.syntaxErrors = 0;
        // wack everything related to backtracking and memoization
        this.state.backtracking = 0;
        // wipe cache
        if (this.state.ruleMemo) {
            for (i=0, len=this.state.ruleMemo.length; i<len; i++) {
                this.state.ruleMemo[i] = null;
            }
        }
    },

    /** Match current input symbol against ttype.  Attempt
     *  single token insertion or deletion error recovery.  If
     *  that fails, throw {@link org.antlr.runtime.MismatchedTokenException}.
     *
     *  <p>To turn off single token insertion or deletion error
     *  recovery, override {@link #mismatchRecover} and have it call
     *  plain {@link #mismatch}, which does not recover.  Then any error
     *  in a rule will cause an exception and immediate exit from
     *  rule.  Rule would recover by resynchronizing to the set of
     *  symbols that can follow rule ref.</p>
     *
     *  @param {org.antlr.runtime.IntStream} input input stream to match against.
     *  @param {Number} ttype  input type to match.
     *  @param {org.antlr.runtime.BitSet} [follow] set of tokens that can follow the
     *      matched token.
     *  @returns {Object} the matched symbol
     */
    match: function(input, ttype, follow) {
        var matchedSymbol = this.getCurrentInputSymbol(input);
        if ( input.LA(1)===ttype ) {
            input.consume();
            this.state.errorRecovery = false;
            this.state.failed = false;
            return matchedSymbol;
        }
        if ( this.state.backtracking>0 ) {
            this.state.failed = true;
            return matchedSymbol;
        }
        matchedSymbol = this.recoverFromMismatchedToken(input, ttype, follow);
        return matchedSymbol;
    },

    /**
     * Match any token.
     * @param {org.antlr.runtime.IntStream} input input stream to match against.
     */
    matchAny: function(input) {
        this.state.errorRecovery = false;
        this.state.failed = false;
        input.consume();
    },

    /**
     * Is the following token (LA(2)) the unwanted type (ttype)?
     * @param {org.antlr.runtime.IntStream} input input stream to match against.
     * @param {Number} ttype the undesired token type.
     * @returns {Boolean} true if and only if the following token is the
     *      unwanted type.
     */
    mismatchIsUnwantedToken: function(input, ttype) {
        return input.LA(2)===ttype;
    },

    /**
     * Does the stream appear to be missing a single token?
     * @param {org.antlr.runtime.IntStream} input input stream to match against.
     * @param {org.antlr.runtime.BitSet} [follow] set of tokens that can follow the
     *      matched token.
     * @returns {Boolean} true if and only if it appears that the stream is
     *      missing a single token.
     */
    mismatchIsMissingToken: function(input, follow) {
        if ( !follow ) {
            // we have no information about the follow; we can only consume
            // a single token and hope for the best
            return false;
        }
        // compute what can follow this grammar element reference
        if ( follow.member(org.antlr.runtime.Token.EOR_TOKEN_TYPE) ) {
            if ( this.state._fsp>=0 ) { // remove EOR if we're not the start symbol
                follow.remove(org.antlr.runtime.Token.EOR_TOKEN_TYPE);
            }
            var viableTokensFollowingThisRule = this.computeContextSensitiveRuleFOLLOW();
            follow = follow.or(this.viableTokensFollowingThisRule);
        }
        // if current token is consistent with what could come after set
        // then we know we're missing a token; error recovery is free to
        // "insert" the missing token

        // BitSet cannot handle negative numbers like -1 (EOF) so I leave EOR
        // in follow set to indicate that the fall of the start symbol is
        // in the set (EOF can follow).
        if ( follow.member(input.LA(1)) ||
             follow.member(org.antlr.runtime.Token.EOR_TOKEN_TYPE) )
        {
            return true;
        }
        return false;
    },

    /** Factor out what to do upon token mismatch so tree parsers can behave
     *  differently.  Override and call {@link #mismatchRecover}
     *  to get single token insertion and deletion.
     *
     *  @param {org.antlr.runtime.IntStream} input input stream to match against.
     *  @param {Number} ttype  input type to match.
     *  @param {org.antlr.runtime.BitSet} [follow] set of tokens that can follow the
     *      matched token.
     */
    mismatch: function(input, ttype, follow) {
        if ( this.mismatchIsUnwantedToken(input, ttype) ) {
            throw new org.antlr.runtime.UnwantedTokenException(ttype, input);
        } else if ( this.mismatchIsMissingToken(input, follow) ) {
            throw new org.antlr.runtime.MissingTokenException(ttype, input, null);
        }
        throw new org.antlr.runtime.MismatchedTokenException(ttype, input);
    },

    /** Report a recognition problem.
     *
     *  <p>This method sets errorRecovery to indicate the parser is recovering
     *  not parsing.  Once in recovery mode, no errors are generated.
     *  To get out of recovery mode, the parser must successfully match
     *  a token (after a resync).  So it will go:</p>
     *  <ol>
     *      <li>error occurs</li>
     *      <li>enter recovery mode, report error</li>
     *      <li>consume until token found in resynch set</li>
     *      <li>try to resume parsing</li>
     *      <li>next match() will reset errorRecovery mode</li>
     *  </ol>
     *
     *  <p>If you override, make sure to update this.state.syntaxErrors if you
     *  care about that.</p>
     *  @param {org.antlr.runtime.RecognitionException} e the error to be reported.
     */
    reportError: function(e) {
      if(this.input.size() != 0) {
        var token = this.input.get(e.index);
        var errorMessage = "";
        var column = 0;
        var line = 0;
        if(token.getType() == -1) {
          token = this.input.get(this.input.size() - 1);
        }
        errorMessage = this.getErrorMessage(e, this.getTokenNames());
        column = token.getStartIndex();
        line = token.getLine() - 1;

        var error = {
          line: line,
          message: errorMessage,
          column: column
        };
        this.addError(error);
      }
        // if we've already reported an error and have not matched a token
        // yet successfully, don't report any errors.
        if ( this.state.errorRecovery ) {
            return;
        }
        this.state.syntaxErrors++;
        this.state.errorRecovery = true;

        this.displayRecognitionError(this.getTokenNames(), e);
    },

    /**
     * Assemble recognition error message.
     * @param {Array} tokenNames array of token names (strings).
     * @param {org.antlr.runtime.RecognitionException} e the error to be reported.
     */
    displayRecognitionError: function(tokenNames, e) {
        var hdr = this.getErrorHeader(e),
            msg = this.getErrorMessage(e, tokenNames);
        this.emitErrorMessage(hdr+" "+msg);
    },

    /**
     * Create error header message.  Format is <q>line
     * lineNumber:positionInLine</q>.
     * @param {org.antlr.runtime.RecognitionException} e the error to be reported.
     * @returns {String} The error header.
     */
    getErrorHeader: function(e) {
        /* handle null input */
        if (!org.antlr.lang.isNumber(e.line)) {
            e.line = 0;
        }
        return "line "+e.line+":"+e.charPositionInLine;
    },

    /**
     * Override this method to change where error messages go.
     * Defaults to "alert"-ing the error in browsers and "print"-ing the error
     * in other environments (e.g. Rhino, SpiderMonkey).
     * @param {String} msg the error message to be displayed.
     */
    emitErrorMessage: function(msg) {
      //throw msg;
      console.log(msg);
    },

    /** What error message should be generated for the various
     *  exception types?
     *
     *  <p>Not very object-oriented code, but I like having all error message
     *  generation within one method rather than spread among all of the
     *  exception classes. This also makes it much easier for the exception
     *  handling because the exception classes do not have to have pointers back
     *  to this object to access utility routines and so on. Also, changing
     *  the message for an exception type would be difficult because you
     *  would have to be subclassing exceptions, but then somehow get ANTLR
     *  to make those kinds of exception objects instead of the default.</p>
     *
     *  <p>For grammar debugging, you will want to override this to add
     *  more information such as the stack frame and no viable alts.</p>
     *
     *  <p>Override this to change the message generated for one or more
     *  exception types.</p>
     *
     * @param {Array} tokenNames array of token names (strings).
     * @param {org.antlr.runtime.RecognitionException} e the error to be reported.
     * @returns {String} the error message to be emitted.
     */
    getErrorMessage: function(e, tokenNames) {
        var msg = (e && e.getMessage) ? e.getMessage() : null,
            mte,
            tokenName;
        if ( e instanceof org.antlr.runtime.UnwantedTokenException ) {
            var ute = e;
            tokenName="<unknown>";
            if ( ute.expecting== org.antlr.runtime.Token.EOF ) {
                tokenName = "EOF";
            } else {
                tokenName = tokenNames[ute.expecting];
            }
            msg = "extraneous input "+this.getTokenErrorDisplay(ute.getUnexpectedToken())+
                " expecting "+tokenName;
        }
        else if ( e instanceof org.antlr.runtime.MissingTokenException ) {
            mte = e;
            tokenName="<unknown>";
            if ( mte.expecting== org.antlr.runtime.Token.EOF ) {
                tokenName = "EOF";
            } else {
                tokenName = tokenNames[mte.expecting];
            }
            msg = "missing "+tokenName+" at "+this.getTokenErrorDisplay(e.token);
        }
        else if ( e instanceof org.antlr.runtime.MismatchedTokenException ) {
            mte = e;
            tokenName="<unknown>";
            if ( mte.expecting== org.antlr.runtime.Token.EOF ) {
                tokenName = "EOF";
            }
            else {
                tokenName = tokenNames[mte.expecting];
            }
            msg = "mismatched input "+this.getTokenErrorDisplay(e.token)+
                " expecting "+tokenName;
        }
        else if ( e instanceof org.antlr.runtime.NoViableAltException ) {
            msg = "no viable alternative at input "+this.getTokenErrorDisplay(e.token);
        }
        else if ( e instanceof org.antlr.runtime.EarlyExitException ) {
            msg = "required (...)+ loop did not match anything at input "+
                this.getTokenErrorDisplay(e.token);
        }
        else if ( e instanceof org.antlr.runtime.MismatchedSetException ) {
            msg = "mismatched input "+this.getTokenErrorDisplay(e.token)+
                " expecting set "+e.expecting;
        }
        else if ( e instanceof org.antlr.runtime.MismatchedNotSetException ) {
            msg = "mismatched input "+this.getTokenErrorDisplay(e.token)+
                " expecting set "+e.expecting;
        }
        else if ( e instanceof org.antlr.runtime.FailedPredicateException ) {
            msg = "rule "+e.ruleName+" failed predicate: {"+
                e.predicateText+"}?";
        }
        return msg;
    },

    /** Get number of recognition errors (lexer, parser, tree parser).  Each
     *  recognizer tracks its own number.  So parser and lexer each have
     *  separate count.  Does not count the spurious errors found between
     *  an error and next valid token match
     *
     *  See also reportError()
     */
    getNumberOfSyntaxErrors: function() {
        return this.state.syntaxErrors;
    },

    /** How should a token be displayed in an error message? The default
     *  is to display just the text, but during development you might
     *  want to have a lot of information spit out.  Override in that case
     *  to use t.toString() (which, for CommonToken, dumps everything about
     *  the token). This is better than forcing you to override a method in
     *  your token objects because you don't have to go modify your lexer
     *  so that it creates a new Java type.
     */
    getTokenErrorDisplay: function(t) {
        var s = t.getText();
        if ( !org.antlr.lang.isValue(s) ) {
            if ( t.getType()==org.antlr.runtime.Token.EOF ) {
                s = "<EOF>";
            }
            else {
                s = "<"+t.getType()+">";
            }
        }
        s = s.replace(/\n/g,"\\n");
        s = s.replace(/\r/g,"\\r");
        s = s.replace(/\t/g,"\\t");
        return "'"+s+"'";
    },

    /** Recover from an error found on the input stream.  This is
     *  for NoViableAlt and mismatched symbol exceptions.  If you enable
     *  single token insertion and deletion, this will usually not
     *  handle mismatched symbol exceptions but there could be a mismatched
     *  token that the match() routine could not recover from.
     */
    recover: function(input, re) {
        if ( this.state.lastErrorIndex==input.index() ) {
            // uh oh, another error at same token index; must be a case
            // where LT(1) is in the recovery token set so nothing is
            // consumed; consume a single token so at least to prevent
            // an infinite loop; this is a failsafe.
            input.consume();
        }
        this.state.lastErrorIndex = input.index();
        var followSet = this.computeErrorRecoverySet();
        this.beginResync();
        this.consumeUntil(input, followSet);
        this.endResync();
    },

    /** A hook to listen in on the token consumption during error recovery.
     *  The DebugParser subclasses this to fire events to the listenter.
     */
    beginResync: function() {
    },

    endResync: function() {
    },

    /*  Compute the error recovery set for the current rule.  During
     *  rule invocation, the parser pushes the set of tokens that can
     *  follow that rule reference on the stack; this amounts to
     *  computing FIRST of what follows the rule reference in the
     *  enclosing rule. This local follow set only includes tokens
     *  from within the rule; i.e., the FIRST computation done by
     *  ANTLR stops at the end of a rule.
     *
     *  EXAMPLE
     *
     *  When you find a "no viable alt exception", the input is not
     *  consistent with any of the alternatives for rule r.  The best
     *  thing to do is to consume tokens until you see something that
     *  can legally follow a call to r *or* any rule that called r.
     *  You don't want the exact set of viable next tokens because the
     *  input might just be missing a token--you might consume the
     *  rest of the input looking for one of the missing tokens.
     *
     *  Consider grammar:
     *
     *  a : '[' b ']'
     *    | '(' b ')'
     *    ;
     *  b : c '^' INT ;
     *  c : ID
     *    | INT
     *    ;
     *
     *  At each rule invocation, the set of tokens that could follow
     *  that rule is pushed on a stack.  Here are the various "local"
     *  follow sets:
     *
     *  FOLLOW(b1_in_a) = FIRST(']') = ']'
     *  FOLLOW(b2_in_a) = FIRST(')') = ')'
     *  FOLLOW(c_in_b) = FIRST('^') = '^'
     *
     *  Upon erroneous input "[]", the call chain is
     *
     *  a -> b -> c
     *
     *  and, hence, the follow context stack is:
     *
     *  depth  local follow set     after call to rule
     *    0         <EOF>                    a (from main())
     *    1          ']'                     b
     *    3          '^'                     c
     *
     *  Notice that ')' is not included, because b would have to have
     *  been called from a different context in rule a for ')' to be
     *  included.
     *
     *  For error recovery, we cannot consider FOLLOW(c)
     *  (context-sensitive or otherwise).  We need the combined set of
     *  all context-sensitive FOLLOW sets--the set of all tokens that
     *  could follow any reference in the call chain.  We need to
     *  resync to one of those tokens.  Note that FOLLOW(c)='^' and if
     *  we resync'd to that token, we'd consume until EOF.  We need to
     *  sync to context-sensitive FOLLOWs for a, b, and c: {']','^'}.
     *  In this case, for input "[]", LA(1) is in this set so we would
     *  not consume anything and after printing an error rule c would
     *  return normally.  It would not find the required '^' though.
     *  At this point, it gets a mismatched token error and throws an
     *  exception (since LA(1) is not in the viable following token
     *  set).  The rule exception handler tries to recover, but finds
     *  the same recovery set and doesn't consume anything.  Rule b
     *  exits normally returning to rule a.  Now it finds the ']' (and
     *  with the successful match exits errorRecovery mode).
     *
     *  So, you cna see that the parser walks up call chain looking
     *  for the token that was a member of the recovery set.
     *
     *  Errors are not generated in errorRecovery mode.
     *
     *  ANTLR's error recovery mechanism is based upon original ideas:
     *
     *  "Algorithms + Data Structures = Programs" by Niklaus Wirth
     *
     *  and
     *
     *  "A note on error recovery in recursive descent parsers":
     *  http://portal.acm.org/citation.cfm?id=947902.947905
     *
     *  Later, Josef Grosch had some good ideas:
     *
     *  "Efficient and Comfortable Error Recovery in Recursive Descent
     *  Parsers":
     *  ftp://www.cocolab.com/products/cocktail/doca4.ps/ell.ps.zip
     *
     *  Like Grosch I implemented local FOLLOW sets that are combined
     *  at run-time upon error to avoid overhead during parsing.
     */
    computeErrorRecoverySet: function() {
        return this.combineFollows(false);
    },


    /** Compute the context-sensitive FOLLOW set for current rule.
     *  This is set of token types that can follow a specific rule
     *  reference given a specific call chain.  You get the set of
     *  viable tokens that can possibly come next (lookahead depth 1)
     *  given the current call chain.  Contrast this with the
     *  definition of plain FOLLOW for rule r:
     *
     *   FOLLOW(r)={x | S=>*alpha r beta in G and x in FIRST(beta)}
     *
     *  where x in T* and alpha, beta in V*; T is set of terminals and
     *  V is the set of terminals and nonterminals.  In other words,
     *  FOLLOW(r) is the set of all tokens that can possibly follow
     *  references to r in *any* sentential form (context).  At
     *  runtime, however, we know precisely which context applies as
     *  we have the call chain.  We may compute the exact (rather
     *  than covering superset) set of following tokens.
     *
     *  For example, consider grammar:
     *
     *  stat : ID '=' expr ';'      // FOLLOW(stat)=={EOF}
     *       | "return" expr '.'
     *       ;
     *  expr : atom ('+' atom)* ;   // FOLLOW(expr)=={';','.',')'}
     *  atom : INT                  // FOLLOW(atom)=={'+',')',';','.'}
     *       | '(' expr ')'
     *       ;
     *
     *  The FOLLOW sets are all inclusive whereas context-sensitive
     *  FOLLOW sets are precisely what could follow a rule reference.
     *  For input input "i=(3);", here is the derivation:
     *
     *  stat => ID '=' expr ';'
     *       => ID '=' atom ('+' atom)* ';'
     *       => ID '=' '(' expr ')' ('+' atom)* ';'
     *       => ID '=' '(' atom ')' ('+' atom)* ';'
     *       => ID '=' '(' INT ')' ('+' atom)* ';'
     *       => ID '=' '(' INT ')' ';'
     *
     *  At the "3" token, you'd have a call chain of
     *
     *    stat -> expr -> atom -> expr -> atom
     *
     *  What can follow that specific nested ref to atom?  Exactly ')'
     *  as you can see by looking at the derivation of this specific
     *  input.  Contrast this with the FOLLOW(atom)={'+',')',';','.'}.
     *
     *  You want the exact viable token set when recovering from a
     *  token mismatch.  Upon token mismatch, if LA(1) is member of
     *  the viable next token set, then you know there is most likely
     *  a missing token in the input stream.  "Insert" one by just not
     *  throwing an exception.
     */
    computeContextSensitiveRuleFOLLOW: function() {
        return this.combineFollows(true);
    },

    combineFollows: function(exact) {
        var top = this.state._fsp,
            i,
            localFollowSet,
            followSet = new org.antlr.runtime.BitSet();
        for (i=top; i>=0; i--) {
            localFollowSet = this.state.following[i];
            followSet.orInPlace(localFollowSet);
            if ( exact ) {
                // can we see end of rule?
                if ( localFollowSet.member(org.antlr.runtime.Token.EOR_TOKEN_TYPE) )
                {
                    // Only leave EOR in set if at top (start rule); this lets
                    // us know if have to include follow(start rule); i.e., EOF
                    if ( i>0 ) {
                        followSet.remove(org.antlr.runtime.Token.EOR_TOKEN_TYPE);
                    }
                }
                else { // can't see end of rule, quit
                    break;
                }
            }
        }
        return followSet;
    },

    /** Attempt to recover from a single missing or extra token.
     *
     *  EXTRA TOKEN
     *
     *  LA(1) is not what we are looking for.  If LA(2) has the right token,
     *  however, then assume LA(1) is some extra spurious token.  Delete it
     *  and LA(2) as if we were doing a normal match(), which advances the
     *  input.
     *
     *  MISSING TOKEN
     *
     *  If current token is consistent with what could come after
     *  ttype then it is ok to "insert" the missing token, else throw
     *  exception For example, Input "i=(3;" is clearly missing the
     *  ')'.  When the parser returns from the nested call to expr, it
     *  will have call chain:
     *
     *    stat -> expr -> atom
     *
     *  and it will be trying to match the ')' at this point in the
     *  derivation:
     *
     *       => ID '=' '(' INT ')' ('+' atom)* ';'
     *                          ^
     *  match() will see that ';' doesn't match ')' and report a
     *  mismatched token error.  To recover, it sees that LA(1)==';'
     *  is in the set of tokens that can follow the ')' token
     *  reference in rule atom.  It can assume that you forgot the ')'.
     */
    recoverFromMismatchedToken: function(input,
                                         ttype,
                                         follow)
    {
        var e = null;
        // if next token is what we are looking for then "delete" this token
        if ( this.mismatchIsUnwantedToken(input, ttype) ) {
            e = new org.antlr.runtime.UnwantedTokenException(ttype, input);
            this.beginResync();
            input.consume(); // simply delete extra token
            this.endResync();
            this.reportError(e);  // report after consuming so AW sees the token in the exception
            // we want to return the token we're actually matching
            var matchedSymbol = this.getCurrentInputSymbol(input);
            input.consume(); // move past ttype token as if all were ok
            return matchedSymbol;
        }
        // can't recover with single token deletion, try insertion
        if ( this.mismatchIsMissingToken(input, follow) ) {
            var inserted = this.getMissingSymbol(input, e, ttype, follow);
            e = new org.antlr.runtime.MissingTokenException(ttype, input, inserted);
            this.reportError(e);  // report after inserting so AW sees the token in the exception
            return inserted;
        }
        // even that didn't work; must throw the exception
        e = new org.antlr.runtime.MismatchedTokenException(ttype, input);
        throw e;
    },

    recoverFromMismatchedSet: function(input,
                                       e,
                                       follow)
    {
        if ( this.mismatchIsMissingToken(input, follow) ) {
            // System.out.println("missing token");
            this.reportError(e);
            // we don't know how to conjure up a token for sets yet
            return this.getMissingSymbol(input, e, org.antlr.runtime.Token.INVALID_TOKEN_TYPE, follow);
        }
        throw e;
    },

    /** Match needs to return the current input symbol, which gets put
     *  into the label for the associated token ref; e.g., x=ID.  Token
     *  and tree parsers need to return different objects. Rather than test
     *  for input stream type or change the IntStream interface, I use
     *  a simple method to ask the recognizer to tell me what the current
     *  input symbol is.
     * 
     *  This is ignored for lexers.
     */
    getCurrentInputSymbol: function(input) { return null; },

    /** Conjure up a missing token during error recovery.
     *
     *  The recognizer attempts to recover from single missing
     *  symbols. But, actions might refer to that missing symbol.
     *  For example, x=ID {f($x);}. The action clearly assumes
     *  that there has been an identifier matched previously and that
     *  $x points at that token. If that token is missing, but
     *  the next token in the stream is what we want we assume that
     *  this token is missing and we keep going. Because we
     *  have to return some token to replace the missing token,
     *  we have to conjure one up. This method gives the user control
     *  over the tokens returned for missing tokens. Mostly,
     *  you will want to create something special for identifier
     *  tokens. For literals such as '{' and ',', the default
     *  action in the parser or tree parser works. It simply creates
     *  a CommonToken of the appropriate type. The text will be the token.
     *  If you change what tokens must be created by the lexer,
     *  override this method to create the appropriate tokens.
     */
    getMissingSymbol: function(input,
                               e,
                               expectedTokenType,
                               follow)
    {
        return null;
    },


    /** Consume tokens until one matches the given token set */
    consumeUntil: function(input, set) {
        var ttype = input.LA(1);
        while (ttype != org.antlr.runtime.Token.EOF && !set.member(ttype) ) {
            input.consume();
            ttype = input.LA(1);
        }
    },

    /** Push a rule's follow set using our own hardcoded stack */
    pushFollow: function(fset) {
        if ( (this.state._fsp +1)>=this.state.following.length ) {
            var f = [];
            var i;
            for (i=this.state.following.length-1; i>=0; i--) {
                f[i] = this.state.following[i];
            }
            this.state.following = f;
        }
        this.state._fsp++;
        this.state.following[this.state._fsp] = fset;
    },

    /** Return List<String> of the rules in your parser instance
     *  leading up to a call to this method.  You could override if
     *  you want more details such as the file/line info of where
     *  in the parser java code a rule is invoked.
     *
     *  This is very useful for error messages and for context-sensitive
     *  error recovery.
     *
     *  A more general version of getRuleInvocationStack where you can
     *  pass in, for example, a RecognitionException to get it's rule
     *  stack trace.  This routine is shared with all recognizers, hence,
     *  static.
     *
     *  TODO: move to a utility class or something; weird having lexer call this
     *
     *  Most JS interpreters can't do real stack reflection.  See this
     *  spidermonkey bug, for example:
     *  https://bugzilla.mozilla.org/show_bug.cgi?id=332104
     *
     *  JS is supposed to get real stack traces in v4, at which time it would
     *  be easy to implement this function.
     *
     *  Until then I'll leave this unimplemented.  If there is enough clamor
     *  it would be possible to keep track of the invocation stack using an
     *  auxillary array, but that will definitely be a performance hit.
     */
    getRuleInvocationStack: function(e, recognizerClassName)
    {
        throw new Error("Not implemented.");
    },

    getBacktrackingLevel: function() {
        return this.state.backtracking;
    },

    /** Used to print out token names like ID during debugging and
     *  error reporting.  The generated parsers implement a method
     *  that overrides this to point to their String[] tokenNames.
     */
    getTokenNames: function() {
        return null;
    },

    /** For debugging and other purposes, might want the grammar name.
     *  Have ANTLR generate an implementation for this method.
     */
    getGrammarFileName: function() {
        return null;
    },

    /** A convenience method for use most often with template rewrites.
     *  Convert a List<Token> to List<String>
     */
    toStrings: function(tokens) {
        if ( !tokens ) {
            return null;
        }
        var strings = [];
        var i;
        for (i=0; i<tokens.length; i++) {
            strings.push(tokens[i].getText());
        }
        return strings;
    },

    /** Given a rule number and a start token index number, return
     *  MEMO_RULE_UNKNOWN if the rule has not parsed input starting from
     *  start index.  If this rule has parsed input starting from the
     *  start index before, then return where the rule stopped parsing.
     *  It returns the index of the last token matched by the rule.
     *
     *  For now we use a hashtable and just the slow Object-based one.
     *  Later, we can make a special one for ints and also one that
     *  tosses out data after we commit past input position i.
     */
    getRuleMemoization: function(ruleIndex, ruleStartIndex) {
        if ( !this.state.ruleMemo[ruleIndex] ) {
            this.state.ruleMemo[ruleIndex] = {};
        }
        var stopIndexI =
            this.state.ruleMemo[ruleIndex][ruleStartIndex];
        if ( !org.antlr.lang.isNumber(stopIndexI) ) {
            return org.antlr.runtime.BaseRecognizer.MEMO_RULE_UNKNOWN;
        }
        return stopIndexI;
    },

    /** Has this rule already parsed input at the current index in the
     *  input stream?  Return the stop token index or MEMO_RULE_UNKNOWN.
     *  If we attempted but failed to parse properly before, return
     *  MEMO_RULE_FAILED.
     *
     *  This method has a side-effect: if we have seen this input for
     *  this rule and successfully parsed before, then seek ahead to
     *  1 past the stop token matched for this rule last time.
     */
    alreadyParsedRule: function(input, ruleIndex) {
        var stopIndex = this.getRuleMemoization(ruleIndex, input.index());
        if ( stopIndex==org.antlr.runtime.BaseRecognizer.MEMO_RULE_UNKNOWN ) {
            return false;
        }
        if ( stopIndex==org.antlr.runtime.BaseRecognizer.MEMO_RULE_FAILED ) {
            //System.out.println("rule "+ruleIndex+" will never succeed");
            this.state.failed=true;
        }
        else {
            input.seek(stopIndex+1); // jump to one past stop token
        }
        return true;
    },

    /** Record whether or not this rule parsed the input at this position
     *  successfully.  Use a standard java hashtable for now.
     */
    memoize: function(input,
                      ruleIndex,
                      ruleStartIndex)
    {
        var stopTokenIndex = this.state.failed ? 
            org.antlr.runtime.BaseRecognizer.MEMO_RULE_FAILED : input.index()-1;
        if ( !org.antlr.lang.isValue(this.state.ruleMemo) ) {
            throw new Error("!!!!!!!!! memo array is null for "+ this.getGrammarFileName());
        }
        if ( ruleIndex >= this.state.ruleMemo.length ) {
            throw new Error("!!!!!!!!! memo size is "+this.state.ruleMemo.length+", but rule index is "+ruleIndex);
        }
        if ( org.antlr.lang.isValue(this.state.ruleMemo[ruleIndex]) ) {
            this.state.ruleMemo[ruleIndex][ruleStartIndex] = stopTokenIndex;
        }
    },

    /** return how many rule/input-index pairs there are in total.
     *  TODO: this includes synpreds.
     */
    getRuleMemoizationCacheSize: function() {
        var n = 0, i;
        for (i = 0; this.state.ruleMemo && i < this.state.ruleMemo.length; i++) {
            var ruleMap = this.state.ruleMemo[i];
            if ( ruleMap ) {
                // @todo need to get size of rulemap?
                n += ruleMap.length; // how many input indexes are recorded?
            }
        }
        return n;
    },

    traceIn: function(ruleName, ruleIndex, inputSymbol)  {
        this.emitErrorMessage("enter "+ruleName+" "+inputSymbol);
        if ( this.state.failed ) {
            this.emitErrorMessage(" failed="+this.failed);
        }
        if ( this.state.backtracking>0 ) {
            this.emitErrorMessage(" backtracking="+this.state.backtracking);
        }
        // System.out.println();
    },

    traceOut: function(ruleName, ruleIndex, inputSymbol) {
        this.emitErrorMessage("exit "+ruleName+" "+inputSymbol);
        if ( this.state.failed ) {
            this.emitErrorMessage(" failed="+this.state.failed);
        }
        if ( this.state.backtracking>0 ) {
            this.emitErrorMessage(" backtracking="+this.state.backtracking);
        }
    }
};
org.antlr.runtime.Lexer = function(input, state) {
    if (state) {
        org.antlr.runtime.Lexer.superclass.constructor.call(this, state);
    }
    if (input) {
        this.input = input;
    }
};

org.antlr.lang.extend(org.antlr.runtime.Lexer, org.antlr.runtime.BaseRecognizer, {
    reset: function() {
        // reset all recognizer state variables
        org.antlr.runtime.Lexer.superclass.reset.call(this);
        if ( org.antlr.lang.isValue(this.input) ) {
            this.input.seek(0); // rewind the input
        }
        if ( !org.antlr.lang.isValue(this.state) ) {
            return; // no shared state work to do
        }
        this.state.token = null;
        this.state.type = org.antlr.runtime.Token.INVALID_TOKEN_TYPE;
        this.state.channel = org.antlr.runtime.Token.DEFAULT_CHANNEL;
        this.state.tokenStartCharIndex = -1;
        this.state.tokenStartCharPositionInLine = -1;
        this.state.tokenStartLine = -1;
        this.state.text = null;
    },

    /** Return a token from this source; i.e., match a token on the char
     *  stream.
     */
    nextToken: function() {
        while (true) {
            this.state.token = null;
            this.state.channel = org.antlr.runtime.Token.DEFAULT_CHANNEL;
            this.state.tokenStartCharIndex = this.input.index();
            this.state.tokenStartCharPositionInLine = this.input.getCharPositionInLine();
            this.state.tokenStartLine = this.input.getLine();
            this.state.text = null;
            if ( this.input.LA(1)===org.antlr.runtime.CharStream.EOF ) {
                return org.antlr.runtime.Token.EOF_TOKEN;
            }
            try {
                this.mTokens();
                if ( !org.antlr.lang.isValue(this.state.token) ) {
                    this.emit();
                }
                else if ( this.state.token==org.antlr.runtime.Token.SKIP_TOKEN ) {
                    continue;
                }
                return this.state.token;
            }
            catch (re) {
                if (re instanceof org.antlr.runtime.NoViableAltException) {
                    this.reportError(re);
                    this.recover(re);
                } else if ( re instanceof org.antlr.runtime.RecognitionException ) {
                    this.reportError(re);
                } else {
                    throw re;
                }
            }
        }
    },

    /** Instruct the lexer to skip creating a token for current lexer rule
     *  and look for another token.  nextToken() knows to keep looking when
     *  a lexer rule finishes with token set to SKIP_TOKEN.  Recall that
     *  if token==null at end of any token rule, it creates one for you
     *  and emits it.
     */
    skip: function() {
        this.state.token = org.antlr.runtime.Token.SKIP_TOKEN;
    },

    /** Set the char stream and reset the lexer */
    setCharStream: function(input) {
        this.input = null;
        this.reset();
        this.input = input;
    },

    getCharStream: function() {
        return this.input;
    },

    getSourceName: function() {
        return this.input.getSourceName();
    },

    /** Currently does not support multiple emits per nextToken invocation
     *  for efficiency reasons.  Subclass and override this method and
     *  nextToken (to push tokens into a list and pull from that list rather
     *  than a single variable as this implementation does).
     *
     *  The standard method called to automatically emit a token at the
     *  outermost lexical rule.  The token object should point into the
     *  char buffer start..stop.  If there is a text override in 'text',
     *  use that to set the token's text.  Override this method to emit
     *  custom Token objects.
     *
     *  If you are building trees, then you should also override
     *  Parser or TreeParser.getMissingSymbol().
     */
    emit: function() {
        if (arguments.length===0) {
            var t = new org.antlr.runtime.CommonToken(this.input, this.state.type, this.state.channel, this.state.tokenStartCharIndex, this.getCharIndex()-1);
            t.setLine(this.state.tokenStartLine);
            t.setText(this.state.text);
            t.setCharPositionInLine(this.state.tokenStartCharPositionInLine);
            this.state.token = t;
            return t;
        } else {
            this.state.token = arguments[0];
        }
    },

    match: function(s) {
        var i = 0,
            mte;

        if (org.antlr.lang.isString(s)) {
            while ( i<s.length ) {
                if ( this.input.LA(1)!=s.charAt(i) ) {
                    if ( this.state.backtracking>0 ) {
                        this.state.failed = true;
                        return;
                    }
                    mte = new org.antlr.runtime.MismatchedTokenException(s.charAt(i), this.input);
                    this.recover(mte);
                    throw mte;
                }
                i++;
                this.input.consume();
                this.state.failed = false;
            }
        } else if (org.antlr.lang.isNumber(s)) {
            if ( this.input.LA(1)!=s ) {
                if ( this.state.backtracking>0 ) {
                    this.state.failed = true;
                    return;
                }
                mte = new org.antlr.runtime.MismatchedTokenException(s, this.input);
                this.recover(mte);
                throw mte;
            }
            this.input.consume();
            this.state.failed = false;
        }
    },

    matchAny: function() {
        this.input.consume();
    },

    matchRange: function(a, b) {
        if ( this.input.LA(1)<a || this.input.LA(1)>b ) {
            if ( this.state.backtracking>0 ) {
                this.state.failed = true;
                return;
            }
            mre = new org.antlr.runtime.MismatchedRangeException(a,b,this.input);
            this.recover(mre);
            throw mre;
        }
        this.input.consume();
        this.state.failed = false;
    },

    getLine: function() {
        return this.input.getLine();
    },

    getCharPositionInLine: function() {
        return this.input.getCharPositionInLine();
    },

    /** What is the index of the current character of lookahead? */
    getCharIndex: function() {
        return this.input.index();
    },

    /** Return the text matched so far for the current token or any
     *  text override.
     */
    getText: function() {
        if ( org.antlr.lang.isString(this.state.text) ) {
            return this.state.text;
        }
        return this.input.substring(this.state.tokenStartCharIndex,this.getCharIndex()-1);
    },

    /** Set the complete text of this token; it wipes any previous
     *  changes to the text.
     */
    setText: function(text) {
        this.state.text = text;
    },

    reportError: function(e) {
        /** TODO: not thought about recovery in lexer yet.
         *
        // if we've already reported an error and have not matched a token
        // yet successfully, don't report any errors.
        if ( errorRecovery ) {
            //System.err.print("[SPURIOUS] ");
            return;
        }
        errorRecovery = true;
         */

        this.displayRecognitionError(this.getTokenNames(), e);
    },

    getErrorMessage: function(e, tokenNames) {
        var msg = null;
        if ( e instanceof org.antlr.runtime.MismatchedTokenException ) {
            msg = "mismatched character "+this.getCharErrorDisplay(e.c)+" expecting "+this.getCharErrorDisplay(e.expecting);
        }
        else if ( e instanceof org.antlr.runtime.NoViableAltException ) {
            msg = "no viable alternative at character "+this.getCharErrorDisplay(e.c);
        }
        else if ( e instanceof org.antlr.runtime.EarlyExitException ) {
            msg = "required (...)+ loop did not match anything at character "+this.getCharErrorDisplay(e.c);
        }
        else if ( e instanceof org.antlr.runtime.MismatchedNotSetException ) {
            msg = "mismatched character "+this.getCharErrorDisplay(e.c)+" expecting set "+e.expecting;
        }
        else if ( e instanceof org.antlr.runtime.MismatchedSetException ) {
            msg = "mismatched character "+this.getCharErrorDisplay(e.c)+" expecting set "+e.expecting;
        }
        else if ( e instanceof org.antlr.runtime.MismatchedRangeException ) {
            msg = "mismatched character "+this.getCharErrorDisplay(e.c)+" expecting set "+
                this.getCharErrorDisplay(e.a)+".."+this.getCharErrorDisplay(e.b);
        }
        else {
            msg = org.antlr.runtime.Lexer.superclass.getErrorMessage.call(this, e, tokenNames);
        }
        return msg;
    },

    getCharErrorDisplay: function(c) {
        var s = c; //String.fromCharCode(c);
        switch ( s ) {
            case org.antlr.runtime.Token.EOF :
                s = "<EOF>";
                break;
            case "\n" :
                s = "\\n";
                break;
            case "\t" :
                s = "\\t";
                break;
            case "\r" :
                s = "\\r";
                break;
        }
        return "'"+s+"'";
    },

    /** Lexers can normally match any char in it's vocabulary after matching
     *  a token, so do the easy thing and just kill a character and hope
     *  it all works out.  You can instead use the rule invocation stack
     *  to do sophisticated error recovery if you are in a fragment rule.
     */
    recover: function(re) {
        this.input.consume();
    },

    traceIn: function(ruleName, ruleIndex)  {
        var inputSymbol = String.fromCharCode(this.input.LT(1))+" line="+this.getLine()+":"+this.getCharPositionInLine();
        org.antlr.runtime.Lexer.superclass.traceIn.call(this, ruleName, ruleIndex, inputSymbol);
    },

    traceOut: function(ruleName, ruleIndex)  {
		var inputSymbol = String.fromCharCode(this.input.LT(1))+" line="+this.getLine()+":"+this.getCharPositionInLine();
		org.antlr.runtime.Lexer.superclass.traceOut.call(this, ruleName, ruleIndex, inputSymbol);
	}
});
org.antlr.runtime.ParserRuleReturnScope = function() {};

org.antlr.runtime.ParserRuleReturnScope.prototype = {
    getStart: function() { return this.start; },
    getStop: function() { return this.stop; }
};
org.antlr.runtime.tree.TreeRuleReturnScope = function(){};

org.antlr.runtime.tree.TreeRuleReturnScope.prototype = {
    getStart: function() { return this.start; }
};
org.antlr.runtime.Parser = function(input, state) {
    org.antlr.runtime.Parser.superclass.constructor.call(this, state);
    this.setTokenStream(input);
};

org.antlr.lang.extend(org.antlr.runtime.Parser, org.antlr.runtime.BaseRecognizer, {
    reset: function() {
        // reset all recognizer state variables
		org.antlr.runtime.Parser.superclass.reset.call(this);
		if ( org.antlr.lang.isValue(this.input) ) {
			this.input.seek(0); // rewind the input
		}
	},

    getCurrentInputSymbol: function(input) {
        return input.LT(1);
    },

    getMissingSymbol: function(input,
                               e,
                               expectedTokenType,
                               follow)
    {
        var tokenText =
            "<missing "+this.getTokenNames()[expectedTokenType]+">";
        var t = new org.antlr.runtime.CommonToken(expectedTokenType, tokenText);
        var current = input.LT(1);
        var old_current;
        if ( current.getType() === org.antlr.runtime.Token.EOF ) {
            old_current = current;
            current = input.LT(-1);
            // handle edge case where there are no good tokens in the stream
            if (!current) {
                current = old_current;
            }
        }
        t.line = current.getLine();
        t.charPositionInLine = current.getCharPositionInLine();
        t.channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
        return t;
    },


	/** Set the token stream and reset the parser */
    setTokenStream: function(input) {
		this.input = null;
		this.reset();
		this.input = input;
	},

    getTokenStream: function() {
		return this.input;
	},

    getSourceName: function() {
        return this.input.getSourceName();
    },

    traceIn: function(ruleName, ruleIndex)  {
		org.antlr.runtime.Parser.superclass.traceIn.call(
                this, ruleName, ruleIndex, this.input.LT(1));
	},

    traceOut: function(ruleName, ruleIndex)  {
		org.antlr.runtime.Parser.superclass.traceOut.call(
                this, ruleName, ruleIndex, this.input.LT(1));
	}
});
org.antlr.runtime.DFA = function() {};

org.antlr.runtime.DFA.prototype = {
    /** From the input stream, predict what alternative will succeed
     *  using this DFA (representing the covering regular approximation
     *  to the underlying CFL).  Return an alternative number 1..n.  Throw
     *  an exception upon error.
     */
    predict: function(input) {
        var mark = input.mark(), // remember where decision started in input
            s = 0, // we always start at s0
            specialState,
            c,
            snext;

        try {
            while ( true ) {
                specialState = this.special[s];
                if ( specialState>=0 ) {
                    s = this.specialStateTransition(specialState,input);
                    if (s===-1) {
                        this.noViableAlt(s, input);
                        return 0;
                    }
                    input.consume();
                    continue;
                }
                if ( this.accept[s] >= 1 ) {
                    return this.accept[s];
                }
                // look for a normal char transition
                c = input.LA(1); // -1 == \uFFFF, all tokens fit in 65000 space

                if (c===org.antlr.runtime.Token.EOF) {
                    c = -1;
                } else if (org.antlr.lang.isString(c)) {
                    c = c.charCodeAt(0);
                }

                if (c>=this.min[s] && c<=this.max[s]) {
                    snext = this.transition[s][c-this.min[s]]; // move to next state
                    if ( snext < 0 ) {
                        // was in range but not a normal transition
                        // must check EOT, which is like the else clause.
                        // eot[s]>=0 indicates that an EOT edge goes to another
                        // state.
                        if ( this.eot[s]>=0 ) {  // EOT Transition to accept state?
                            s = this.eot[s];
                            input.consume();
                            // TODO: I had this as return accept[eot[s]]
                            // which assumed here that the EOT edge always
                            // went to an accept...faster to do this, but
                            // what about predicated edges coming from EOT
                            // target?
                            continue;
                        }
                        this.noViableAlt(s,input);
                        return 0;
                    }
                    s = snext;
                    input.consume();
                    continue;
                }
                if ( this.eot[s]>=0 ) {  // EOT Transition?
                    s = this.eot[s];
                    input.consume();
                    continue;
                }
                if ( c==org.antlr.runtime.Token.EOF && this.eof[s]>=0 ) {  // EOF Transition to accept state?
                    return this.accept[this.eof[s]];
                }
                // not in range and not EOF/EOT, must be invalid symbol
                this.noViableAlt(s,input);
                return 0;
            }
        }
        finally {
            input.rewind(mark);
        }
    },

    noViableAlt: function(s, input) {
        if (this.recognizer.state.backtracking>0) {
            this.recognizer.state.failed=true;
            return;
        }
        var nvae =
            new org.antlr.runtime.NoViableAltException(this.getDescription(),
                                     this.decisionNumber,
                                     s,
                                     input);
        this.error(nvae);
        throw nvae;
    },

    /** A hook for debugging interface */
    error: function(nvae) { },

    specialStateTransition: function(s, input) {
        return -1;
    },

    getDescription: function() {
        return "n/a";
    }
};

org.antlr.lang.augmentObject(org.antlr.runtime.DFA, {
    /** Given a String that has a run-length-encoding of some unsigned shorts
     *  like "\1\2\3\9", convert to short[] {2,9,9,9}.
     */
    unpackEncodedString: function(encodedString) {
        // walk first to find how big it is.
        var i,
            data = [],
            di = 0,
            n,
            v,
            j;
        for (i=0; i<encodedString.length; i+=2) {
            n = encodedString.charCodeAt(i);
            v = encodedString.charCodeAt(i+1);
            if (v===0xffff) {
                v = -1; // overflow at 16 bits
            }
            // add v n times to data
            for (j=1; j<=n; j++) {
                data[di++] = v;
            }
        }
        return data;
    },

    // alias
    unpackEncodedStringToUnsignedChars: function(encodedString) {
        return org.antlr.runtime.DFA.unpackEncodedString(encodedString);
    }
});
org.antlr.runtime.tree.TreeParser = function(input) {
    org.antlr.runtime.tree.TreeParser.superclass.constructor.call(this, arguments[1]);
    this.setTreeNodeStream(input);
};

(function(){
var TP = org.antlr.runtime.tree.TreeParser;

org.antlr.lang.augmentObject(TP, {
    DOWN: org.antlr.runtime.Token.DOWN,
    UP: org.antlr.runtime.Token.UP
});

org.antlr.lang.extend(TP, org.antlr.runtime.BaseRecognizer, {
    reset: function() {
        TP.superclass.reset.call(this); // reset all recognizer state variables
        if ( this.input ) {
            this.input.seek(0); // rewind the input
        }
    },

    /** Set the input stream */
    setTreeNodeStream: function(input) {
        this.input = input;
    },

    getTreeNodeStream: function() {
        return this.input;
    },

    getSourceName: function() {
        return this.input.getSourceName();
    },

    getCurrentInputSymbol: function(input) {
        return input.LT(1);
    },

    getMissingSymbol: function(input, e, expectedTokenType, follow) {
        var tokenText =
            "<missing "+this.getTokenNames()[expectedTokenType]+">";
        return new org.antlr.runtime.tree.CommonTree(new org.antlr.runtime.CommonToken(expectedTokenType, tokenText));
    },

    /** Match '.' in tree parser has special meaning.  Skip node or
     *  entire tree if node has children.  If children, scan until
     *  corresponding UP node.
     */
    matchAny: function(ignore) { // ignore stream, copy of this.input
        this.state.errorRecovery = false;
        this.state.failed = false;
        var look = this.input.LT(1);
        if ( this.input.getTreeAdaptor().getChildCount(look)===0 ) {
            this.input.consume(); // not subtree, consume 1 node and return
            return;
        }
        // current node is a subtree, skip to corresponding UP.
        // must count nesting level to get right UP
        var level=0,
            tokenType = this.input.getTreeAdaptor().getType(look);
        while ( tokenType!==org.antlr.runtime.Token.EOF &&
                !(tokenType===TP.UP && level===0) )
        {
            this.input.consume();
            look = this.input.LT(1);
            tokenType = this.input.getTreeAdaptor().getType(look);
            if ( tokenType === TP.DOWN ) {
                level++;
            }
            else if ( tokenType === TP.UP ) {
                level--;
            }
        }
        this.input.consume(); // consume UP
    },

    /** We have DOWN/UP nodes in the stream that have no line info; override.
     *  plus we want to alter the exception type.  Don't try to recover
     *       *  from tree parser errors inline...
     */
    mismatch: function(input, ttype, follow) {
        throw new org.antlr.runtime.MismatchedTreeNodeException(ttype, input);
    },

    /** Prefix error message with the grammar name because message is
     *  always intended for the programmer because the parser built
     *  the input tree not the user.
     */
    getErrorHeader: function(e) {
        return this.getGrammarFileName()+": node from "+
               (e.approximateLineInfo?"after ":"")+"line "+e.line+":"+e.charPositionInLine;
    },

    /** Tree parsers parse nodes they usually have a token object as
     *  payload. Set the exception token and do the default behavior.
     */
    getErrorMessage: function(e, tokenNames) {
        var adaptor;
        if ( this instanceof TP ) {
            adaptor = e.input.getTreeAdaptor();
            e.token = adaptor.getToken(e.node);
            if ( !org.antlr.lang.isValue(e.token) ) { // could be an UP/DOWN node
                e.token = new org.antlr.runtime.CommonToken(
                        adaptor.getType(e.node),
                        adaptor.getText(e.node));
            }
        }
        return TP.superclass.getErrorMessage.call(this, e, tokenNames);
    },

    traceIn: function(ruleName, ruleIndex) {
        TP.superclass.traceIn.call(this, ruleName, ruleIndex, this.input.LT(1));
    },

    traceOut: function(ruleName, ruleIndex) {
        TP.superclass.traceOut.call(this, ruleName, ruleIndex, this.input.LT(1));
    }
});

})();

exports.org = org;

});
define('ace/mode/xquery/XQueryLexer', ['require', 'exports', 'module' , 'ace/mode/xquery/antlr3-all', 'ace/mode/xquery/XQDTLexer'], function(require, exports, module) {// $ANTLR 3.3 Nov 30, 2010 12:50:56 /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g 2012-09-05 10:41:37

/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2010, Ajax.org B.V.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */
var org =  require("./antlr3-all").org;
var XQDTLexer   = require("./XQDTLexer").XQDTLexer;


var XQueryLexer = function(input, state) {
// alternate constructor @todo
// public XQueryLexer(CharStream input)
// public XQueryLexer(CharStream input, RecognizerSharedState state) {
    if (!state) {
        state = new org.antlr.runtime.RecognizerSharedState();
    }

    (function(){


        this.inStr = false;

        // dummy list for warning elimination
        //List<Stack<Object>> dummy = new ArrayList<Stack<Object>>();

        // when we start, the '<' has already been eaten by the other lexer
        //boolean inStr = false;
        //
        //public boolean isInString()
        //{
        //   return inStr;
        //}


    }).call(this);

    this.dfa19 = new XQueryLexer.DFA19(this);
    XQueryLexer.superclass.constructor.call(this, input, state);


};

org.antlr.lang.augmentObject(XQueryLexer, {
    EOF: -1,
    L_QuotAttrContentChar: 4,
    L_AposAttrContentChar: 5,
    L_ElementContentChar: 6,
    L_CDataSection: 7,
    L_PredefinedEntityRef: 8,
    L_CharRef: 9,
    ESCAPE_LBRACKET: 10,
    ESCAPE_RBRACKET: 11,
    ESCAPE_APOS: 12,
    ESCAPE_QUOT: 13,
    CDATA_START: 14,
    CDATA_END: 15,
    ANCESTOR: 16,
    ANCESTOR_OR_SELF: 17,
    AND: 18,
    AS: 19,
    ASCENDING: 20,
    AT: 21,
    ATTRIBUTE: 22,
    BASE_URI: 23,
    BOUNDARY_SPACE: 24,
    BY: 25,
    CASE: 26,
    CAST: 27,
    CASTABLE: 28,
    CHILD: 29,
    COLLATION: 30,
    COMMENT: 31,
    CONSTRUCTION: 32,
    COPY_NAMESPACES: 33,
    DECLARE: 34,
    DEFAULT: 35,
    DESCENDANT: 36,
    DESCENDANT_OR_SELF: 37,
    DESCENDING: 38,
    DIV: 39,
    DOCUMENT: 40,
    DOCUMENT_NODE: 41,
    ELEMENT: 42,
    ELSE: 43,
    EMPTY: 44,
    EMPTY_SEQUENCE: 45,
    ENCODING: 46,
    EQ: 47,
    EVERY: 48,
    EXCEPT: 49,
    EXTERNAL: 50,
    FOLLOWING: 51,
    FOLLOWING_SIBLING: 52,
    FOR: 53,
    FUNCTION: 54,
    GE: 55,
    GREATEST: 56,
    GT: 57,
    IDIV: 58,
    IF: 59,
    IMPORT: 60,
    IN: 61,
    INHERIT: 62,
    INSTANCE: 63,
    INTERSECT: 64,
    IS: 65,
    ITEM: 66,
    LAX: 67,
    LE: 68,
    LEAST: 69,
    LET: 70,
    LT: 71,
    MOD: 72,
    MODULE: 73,
    NAMESPACE: 74,
    NE: 75,
    NO_INHERIT: 76,
    NO_PRESERVE: 77,
    NODE: 78,
    JSON: 79,
    OF: 80,
    OPTION: 81,
    OR: 82,
    ORDER: 83,
    ORDERED: 84,
    ORDERING: 85,
    PARENT: 86,
    PRECEDING: 87,
    PRECEDING_SIBLING: 88,
    PRESERVE: 89,
    PROCESSING_INSTRUCTION: 90,
    STRUCTURED_ITEM: 91,
    JSON_ITEM: 92,
    OBJECT: 93,
    ARRAY: 94,
    RETURN: 95,
    SATISFIES: 96,
    SCHEMA: 97,
    SCHEMA_ATTRIBUTE: 98,
    SCHEMA_ELEMENT: 99,
    SELF: 100,
    SOME: 101,
    STABLE: 102,
    STRICT: 103,
    STRIP: 104,
    TEXT: 105,
    THEN: 106,
    TO: 107,
    TREAT: 108,
    TYPESWITCH: 109,
    UNION: 110,
    UNORDERED: 111,
    VALIDATE: 112,
    VARIABLE: 113,
    VERSION: 114,
    WHERE: 115,
    XQUERY: 116,
    ALLOWING: 117,
    CATCH: 118,
    CONTEXT: 119,
    COUNT: 120,
    DECIMAL_FORMAT: 121,
    DECIMAL_SEPARATOR: 122,
    DIGIT: 123,
    END: 124,
    GROUP: 125,
    GROUPING_SEPARATOR: 126,
    INFINITY: 127,
    MINUS_SIGN: 128,
    NAMESPACE_NODE: 129,
    NAN: 130,
    NEXT: 131,
    ONLY: 132,
    PATTERN_SEPARATOR: 133,
    PERCENT: 134,
    PER_MILLE: 135,
    PREVIOUS: 136,
    SLIDING: 137,
    START: 138,
    SWITCH: 139,
    TRY: 140,
    TUMBLING: 141,
    TYPE: 142,
    WHEN: 143,
    WINDOW: 144,
    ZERO_DIGIT: 145,
    AFTER: 146,
    BEFORE: 147,
    COPY: 148,
    DELETE: 149,
    FIRST: 150,
    INSERT: 151,
    INTO: 152,
    POSITION: 153,
    APPEND: 154,
    LAST: 155,
    MODIFY: 156,
    NODES: 157,
    RENAME: 158,
    REPLACE: 159,
    REVALIDATION: 160,
    SKIP: 161,
    UPDATING: 162,
    VALUE: 163,
    WITH: 164,
    ALL: 165,
    ANY: 166,
    CONTAINS: 167,
    CONTENT: 168,
    DIACRITICS: 169,
    DIFFERENT: 170,
    DISTANCE: 171,
    ENTIRE: 172,
    EXACTLY: 173,
    FROM: 174,
    FT_OPTION: 175,
    FTAND: 176,
    FTNOT: 177,
    FTOR: 178,
    INSENSITIVE: 179,
    LANGUAGE: 180,
    LEVELS: 181,
    LOWERCASE: 182,
    MOST: 183,
    NO: 184,
    NOT: 185,
    OCCURS: 186,
    PARAGRAPH: 187,
    PARAGRAPHS: 188,
    PHRASE: 189,
    RELATIONSHIP: 190,
    SAME: 191,
    SCORE: 192,
    SENSITIVE: 193,
    SENTENCE: 194,
    SENTENCES: 195,
    STEMMING: 196,
    STOP: 197,
    THESAURUS: 198,
    TIMES: 199,
    UPPERCASE: 200,
    USING: 201,
    WEIGHT: 202,
    WILDCARDS: 203,
    WITHOUT: 204,
    WORD: 205,
    WORDS: 206,
    BREAK: 207,
    CONTINUE: 208,
    EXIT: 209,
    LOOP: 210,
    RETURNING: 211,
    WHILE: 212,
    CHECK: 213,
    COLLECTION: 214,
    CONSTRAINT: 215,
    FOREACH: 216,
    FOREIGN: 217,
    INDEX: 218,
    INTEGRITY: 219,
    KEY: 220,
    ON: 221,
    UNIQUE: 222,
    AMP_ER: 223,
    APOS_ER: 224,
    QUOT_ER: 225,
    CONCAT: 226,
    LPAREN: 227,
    RPAREN: 228,
    DOLLAR: 229,
    L_UNION_BRACKET: 230,
    R_UNION_BRACKET: 231,
    LBRACKET: 232,
    RBRACKET: 233,
    LSQUARE: 234,
    RSQUARE: 235,
    EQUAL: 236,
    BIND: 237,
    NOTEQUAL: 238,
    ANN_PERCENT: 239,
    HASH: 240,
    AMP: 241,
    COMMA: 242,
    QUESTION: 243,
    STAR: 244,
    PLUS: 245,
    MINUS: 246,
    SMALLER: 247,
    GREATER: 248,
    SMALLEREQ: 249,
    GREATEREQ: 250,
    SMALLER_SMALLER: 251,
    GREATER_GREATER: 252,
    SLASH: 253,
    SLASH_SLASH: 254,
    BANG: 255,
    DOT: 256,
    DOT_DOT: 257,
    COLON: 258,
    COLON_COLON: 259,
    EMPTY_CLOSE_TAG: 260,
    CLOSE_TAG: 261,
    SEMICOLON: 262,
    VBAR: 263,
    PRAGMA_START: 264,
    PRAGMA_END: 265,
    XML_COMMENT_START: 266,
    XML_COMMENT_END: 267,
    PI_START: 268,
    PI_END: 269,
    ATTR_SIGN: 270,
    Q: 271,
    CHARREF_DEC: 272,
    CHARREF_HEX: 273,
    APOS: 274,
    QUOT: 275,
    NCNameStartChar: 276,
    NCNameChar: 277,
    L_NCName: 278,
    Letter: 279,
    HexLetter: 280,
    Digit: 281,
    Digits: 282,
    S: 283,
    SU: 284,
    L_Pragma: 285,
    L_DirCommentConstructor: 286,
    L_DirPIConstructor: 287,
    L_IntegerLiteral: 288,
    L_DecimalLiteral: 289,
    L_DoubleLiteral: 290,
    L_Comment: 291,
    L_AnyChar: 292
});

(function(){
var HIDDEN = org.antlr.runtime.Token.HIDDEN_CHANNEL,
    EOF = org.antlr.runtime.Token.EOF;
org.antlr.lang.extend(XQueryLexer, XQDTLexer, {
    EOF : -1,
    L_QuotAttrContentChar : 4,
    L_AposAttrContentChar : 5,
    L_ElementContentChar : 6,
    L_CDataSection : 7,
    L_PredefinedEntityRef : 8,
    L_CharRef : 9,
    ESCAPE_LBRACKET : 10,
    ESCAPE_RBRACKET : 11,
    ESCAPE_APOS : 12,
    ESCAPE_QUOT : 13,
    CDATA_START : 14,
    CDATA_END : 15,
    ANCESTOR : 16,
    ANCESTOR_OR_SELF : 17,
    AND : 18,
    AS : 19,
    ASCENDING : 20,
    AT : 21,
    ATTRIBUTE : 22,
    BASE_URI : 23,
    BOUNDARY_SPACE : 24,
    BY : 25,
    CASE : 26,
    CAST : 27,
    CASTABLE : 28,
    CHILD : 29,
    COLLATION : 30,
    COMMENT : 31,
    CONSTRUCTION : 32,
    COPY_NAMESPACES : 33,
    DECLARE : 34,
    DEFAULT : 35,
    DESCENDANT : 36,
    DESCENDANT_OR_SELF : 37,
    DESCENDING : 38,
    DIV : 39,
    DOCUMENT : 40,
    DOCUMENT_NODE : 41,
    ELEMENT : 42,
    ELSE : 43,
    EMPTY : 44,
    EMPTY_SEQUENCE : 45,
    ENCODING : 46,
    EQ : 47,
    EVERY : 48,
    EXCEPT : 49,
    EXTERNAL : 50,
    FOLLOWING : 51,
    FOLLOWING_SIBLING : 52,
    FOR : 53,
    FUNCTION : 54,
    GE : 55,
    GREATEST : 56,
    GT : 57,
    IDIV : 58,
    IF : 59,
    IMPORT : 60,
    IN : 61,
    INHERIT : 62,
    INSTANCE : 63,
    INTERSECT : 64,
    IS : 65,
    ITEM : 66,
    LAX : 67,
    LE : 68,
    LEAST : 69,
    LET : 70,
    LT : 71,
    MOD : 72,
    MODULE : 73,
    NAMESPACE : 74,
    NE : 75,
    NO_INHERIT : 76,
    NO_PRESERVE : 77,
    NODE : 78,
    JSON : 79,
    OF : 80,
    OPTION : 81,
    OR : 82,
    ORDER : 83,
    ORDERED : 84,
    ORDERING : 85,
    PARENT : 86,
    PRECEDING : 87,
    PRECEDING_SIBLING : 88,
    PRESERVE : 89,
    PROCESSING_INSTRUCTION : 90,
    STRUCTURED_ITEM : 91,
    JSON_ITEM : 92,
    OBJECT : 93,
    ARRAY : 94,
    RETURN : 95,
    SATISFIES : 96,
    SCHEMA : 97,
    SCHEMA_ATTRIBUTE : 98,
    SCHEMA_ELEMENT : 99,
    SELF : 100,
    SOME : 101,
    STABLE : 102,
    STRICT : 103,
    STRIP : 104,
    TEXT : 105,
    THEN : 106,
    TO : 107,
    TREAT : 108,
    TYPESWITCH : 109,
    UNION : 110,
    UNORDERED : 111,
    VALIDATE : 112,
    VARIABLE : 113,
    VERSION : 114,
    WHERE : 115,
    XQUERY : 116,
    ALLOWING : 117,
    CATCH : 118,
    CONTEXT : 119,
    COUNT : 120,
    DECIMAL_FORMAT : 121,
    DECIMAL_SEPARATOR : 122,
    DIGIT : 123,
    END : 124,
    GROUP : 125,
    GROUPING_SEPARATOR : 126,
    INFINITY : 127,
    MINUS_SIGN : 128,
    NAMESPACE_NODE : 129,
    NAN : 130,
    NEXT : 131,
    ONLY : 132,
    PATTERN_SEPARATOR : 133,
    PERCENT : 134,
    PER_MILLE : 135,
    PREVIOUS : 136,
    SLIDING : 137,
    START : 138,
    SWITCH : 139,
    TRY : 140,
    TUMBLING : 141,
    TYPE : 142,
    WHEN : 143,
    WINDOW : 144,
    ZERO_DIGIT : 145,
    AFTER : 146,
    BEFORE : 147,
    COPY : 148,
    DELETE : 149,
    FIRST : 150,
    INSERT : 151,
    INTO : 152,
    POSITION : 153,
    APPEND : 154,
    LAST : 155,
    MODIFY : 156,
    NODES : 157,
    RENAME : 158,
    REPLACE : 159,
    REVALIDATION : 160,
    SKIP : 161,
    UPDATING : 162,
    VALUE : 163,
    WITH : 164,
    ALL : 165,
    ANY : 166,
    CONTAINS : 167,
    CONTENT : 168,
    DIACRITICS : 169,
    DIFFERENT : 170,
    DISTANCE : 171,
    ENTIRE : 172,
    EXACTLY : 173,
    FROM : 174,
    FT_OPTION : 175,
    FTAND : 176,
    FTNOT : 177,
    FTOR : 178,
    INSENSITIVE : 179,
    LANGUAGE : 180,
    LEVELS : 181,
    LOWERCASE : 182,
    MOST : 183,
    NO : 184,
    NOT : 185,
    OCCURS : 186,
    PARAGRAPH : 187,
    PARAGRAPHS : 188,
    PHRASE : 189,
    RELATIONSHIP : 190,
    SAME : 191,
    SCORE : 192,
    SENSITIVE : 193,
    SENTENCE : 194,
    SENTENCES : 195,
    STEMMING : 196,
    STOP : 197,
    THESAURUS : 198,
    TIMES : 199,
    UPPERCASE : 200,
    USING : 201,
    WEIGHT : 202,
    WILDCARDS : 203,
    WITHOUT : 204,
    WORD : 205,
    WORDS : 206,
    BREAK : 207,
    CONTINUE : 208,
    EXIT : 209,
    LOOP : 210,
    RETURNING : 211,
    WHILE : 212,
    CHECK : 213,
    COLLECTION : 214,
    CONSTRAINT : 215,
    FOREACH : 216,
    FOREIGN : 217,
    INDEX : 218,
    INTEGRITY : 219,
    KEY : 220,
    ON : 221,
    UNIQUE : 222,
    AMP_ER : 223,
    APOS_ER : 224,
    QUOT_ER : 225,
    CONCAT : 226,
    LPAREN : 227,
    RPAREN : 228,
    DOLLAR : 229,
    L_UNION_BRACKET : 230,
    R_UNION_BRACKET : 231,
    LBRACKET : 232,
    RBRACKET : 233,
    LSQUARE : 234,
    RSQUARE : 235,
    EQUAL : 236,
    BIND : 237,
    NOTEQUAL : 238,
    ANN_PERCENT : 239,
    HASH : 240,
    AMP : 241,
    COMMA : 242,
    QUESTION : 243,
    STAR : 244,
    PLUS : 245,
    MINUS : 246,
    SMALLER : 247,
    GREATER : 248,
    SMALLEREQ : 249,
    GREATEREQ : 250,
    SMALLER_SMALLER : 251,
    GREATER_GREATER : 252,
    SLASH : 253,
    SLASH_SLASH : 254,
    BANG : 255,
    DOT : 256,
    DOT_DOT : 257,
    COLON : 258,
    COLON_COLON : 259,
    EMPTY_CLOSE_TAG : 260,
    CLOSE_TAG : 261,
    SEMICOLON : 262,
    VBAR : 263,
    PRAGMA_START : 264,
    PRAGMA_END : 265,
    XML_COMMENT_START : 266,
    XML_COMMENT_END : 267,
    PI_START : 268,
    PI_END : 269,
    ATTR_SIGN : 270,
    Q : 271,
    CHARREF_DEC : 272,
    CHARREF_HEX : 273,
    APOS : 274,
    QUOT : 275,
    NCNameStartChar : 276,
    NCNameChar : 277,
    L_NCName : 278,
    Letter : 279,
    HexLetter : 280,
    Digit : 281,
    Digits : 282,
    S : 283,
    SU : 284,
    L_Pragma : 285,
    L_DirCommentConstructor : 286,
    L_DirPIConstructor : 287,
    L_IntegerLiteral : 288,
    L_DecimalLiteral : 289,
    L_DoubleLiteral : 290,
    L_Comment : 291,
    L_AnyChar : 292,
    getGrammarFileName: function() { return "/Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g"; }
});
org.antlr.lang.augmentObject(XQueryLexer.prototype, {
    // $ANTLR start ANCESTOR
    mANCESTOR: function()  {
        try {
            var _type = this.ANCESTOR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:85:29: ( 'ancestor' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:85:31: 'ancestor'
            this.match("ancestor"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ANCESTOR",

    // $ANTLR start ANCESTOR_OR_SELF
    mANCESTOR_OR_SELF: function()  {
        try {
            var _type = this.ANCESTOR_OR_SELF;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:86:29: ( 'ancestor-or-self' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:86:31: 'ancestor-or-self'
            this.match("ancestor-or-self"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ANCESTOR_OR_SELF",

    // $ANTLR start AND
    mAND: function()  {
        try {
            var _type = this.AND;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:87:29: ( 'and' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:87:31: 'and'
            this.match("and"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "AND",

    // $ANTLR start AS
    mAS: function()  {
        try {
            var _type = this.AS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:88:29: ( 'as' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:88:31: 'as'
            this.match("as"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "AS",

    // $ANTLR start ASCENDING
    mASCENDING: function()  {
        try {
            var _type = this.ASCENDING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:89:29: ( 'ascending' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:89:31: 'ascending'
            this.match("ascending"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ASCENDING",

    // $ANTLR start AT
    mAT: function()  {
        try {
            var _type = this.AT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:90:29: ( 'at' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:90:31: 'at'
            this.match("at"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "AT",

    // $ANTLR start ATTRIBUTE
    mATTRIBUTE: function()  {
        try {
            var _type = this.ATTRIBUTE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:91:29: ( 'attribute' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:91:31: 'attribute'
            this.match("attribute"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ATTRIBUTE",

    // $ANTLR start BASE_URI
    mBASE_URI: function()  {
        try {
            var _type = this.BASE_URI;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:92:29: ( 'base-uri' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:92:31: 'base-uri'
            this.match("base-uri"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "BASE_URI",

    // $ANTLR start BOUNDARY_SPACE
    mBOUNDARY_SPACE: function()  {
        try {
            var _type = this.BOUNDARY_SPACE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:93:29: ( 'boundary-space' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:93:31: 'boundary-space'
            this.match("boundary-space"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "BOUNDARY_SPACE",

    // $ANTLR start BY
    mBY: function()  {
        try {
            var _type = this.BY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:94:29: ( 'by' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:94:31: 'by'
            this.match("by"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "BY",

    // $ANTLR start CASE
    mCASE: function()  {
        try {
            var _type = this.CASE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:95:29: ( 'case' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:95:31: 'case'
            this.match("case"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CASE",

    // $ANTLR start CAST
    mCAST: function()  {
        try {
            var _type = this.CAST;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:96:29: ( 'cast' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:96:31: 'cast'
            this.match("cast"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CAST",

    // $ANTLR start CASTABLE
    mCASTABLE: function()  {
        try {
            var _type = this.CASTABLE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:97:29: ( 'castable' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:97:31: 'castable'
            this.match("castable"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CASTABLE",

    // $ANTLR start CHILD
    mCHILD: function()  {
        try {
            var _type = this.CHILD;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:98:29: ( 'child' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:98:31: 'child'
            this.match("child"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CHILD",

    // $ANTLR start COLLATION
    mCOLLATION: function()  {
        try {
            var _type = this.COLLATION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:99:29: ( 'collation' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:99:31: 'collation'
            this.match("collation"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "COLLATION",

    // $ANTLR start COMMENT
    mCOMMENT: function()  {
        try {
            var _type = this.COMMENT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:100:29: ( 'comment' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:100:31: 'comment'
            this.match("comment"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "COMMENT",

    // $ANTLR start CONSTRUCTION
    mCONSTRUCTION: function()  {
        try {
            var _type = this.CONSTRUCTION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:101:29: ( 'construction' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:101:31: 'construction'
            this.match("construction"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CONSTRUCTION",

    // $ANTLR start COPY_NAMESPACES
    mCOPY_NAMESPACES: function()  {
        try {
            var _type = this.COPY_NAMESPACES;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:102:29: ( 'copy-namespaces' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:102:31: 'copy-namespaces'
            this.match("copy-namespaces"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "COPY_NAMESPACES",

    // $ANTLR start DECLARE
    mDECLARE: function()  {
        try {
            var _type = this.DECLARE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:103:29: ( 'declare' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:103:31: 'declare'
            this.match("declare"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DECLARE",

    // $ANTLR start DEFAULT
    mDEFAULT: function()  {
        try {
            var _type = this.DEFAULT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:104:29: ( 'default' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:104:31: 'default'
            this.match("default"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DEFAULT",

    // $ANTLR start DESCENDANT
    mDESCENDANT: function()  {
        try {
            var _type = this.DESCENDANT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:105:29: ( 'descendant' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:105:31: 'descendant'
            this.match("descendant"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DESCENDANT",

    // $ANTLR start DESCENDANT_OR_SELF
    mDESCENDANT_OR_SELF: function()  {
        try {
            var _type = this.DESCENDANT_OR_SELF;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:106:29: ( 'descendant-or-self' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:106:31: 'descendant-or-self'
            this.match("descendant-or-self"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DESCENDANT_OR_SELF",

    // $ANTLR start DESCENDING
    mDESCENDING: function()  {
        try {
            var _type = this.DESCENDING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:107:29: ( 'descending' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:107:31: 'descending'
            this.match("descending"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DESCENDING",

    // $ANTLR start DIV
    mDIV: function()  {
        try {
            var _type = this.DIV;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:108:29: ( 'div' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:108:31: 'div'
            this.match("div"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DIV",

    // $ANTLR start DOCUMENT
    mDOCUMENT: function()  {
        try {
            var _type = this.DOCUMENT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:109:29: ( 'document' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:109:31: 'document'
            this.match("document"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DOCUMENT",

    // $ANTLR start DOCUMENT_NODE
    mDOCUMENT_NODE: function()  {
        try {
            var _type = this.DOCUMENT_NODE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:110:29: ( 'document-node' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:110:31: 'document-node'
            this.match("document-node"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DOCUMENT_NODE",

    // $ANTLR start ELEMENT
    mELEMENT: function()  {
        try {
            var _type = this.ELEMENT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:111:29: ( 'element' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:111:31: 'element'
            this.match("element"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ELEMENT",

    // $ANTLR start ELSE
    mELSE: function()  {
        try {
            var _type = this.ELSE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:112:29: ( 'else' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:112:31: 'else'
            this.match("else"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ELSE",

    // $ANTLR start EMPTY
    mEMPTY: function()  {
        try {
            var _type = this.EMPTY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:113:29: ( 'empty' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:113:31: 'empty'
            this.match("empty"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EMPTY",

    // $ANTLR start EMPTY_SEQUENCE
    mEMPTY_SEQUENCE: function()  {
        try {
            var _type = this.EMPTY_SEQUENCE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:114:29: ( 'empty-sequence' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:114:31: 'empty-sequence'
            this.match("empty-sequence"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EMPTY_SEQUENCE",

    // $ANTLR start ENCODING
    mENCODING: function()  {
        try {
            var _type = this.ENCODING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:115:29: ( 'encoding' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:115:31: 'encoding'
            this.match("encoding"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ENCODING",

    // $ANTLR start EQ
    mEQ: function()  {
        try {
            var _type = this.EQ;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:116:29: ( 'eq' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:116:31: 'eq'
            this.match("eq"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EQ",

    // $ANTLR start EVERY
    mEVERY: function()  {
        try {
            var _type = this.EVERY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:117:29: ( 'every' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:117:31: 'every'
            this.match("every"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EVERY",

    // $ANTLR start EXCEPT
    mEXCEPT: function()  {
        try {
            var _type = this.EXCEPT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:118:29: ( 'except' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:118:31: 'except'
            this.match("except"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EXCEPT",

    // $ANTLR start EXTERNAL
    mEXTERNAL: function()  {
        try {
            var _type = this.EXTERNAL;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:119:29: ( 'external' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:119:31: 'external'
            this.match("external"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EXTERNAL",

    // $ANTLR start FOLLOWING
    mFOLLOWING: function()  {
        try {
            var _type = this.FOLLOWING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:120:29: ( 'following' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:120:31: 'following'
            this.match("following"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FOLLOWING",

    // $ANTLR start FOLLOWING_SIBLING
    mFOLLOWING_SIBLING: function()  {
        try {
            var _type = this.FOLLOWING_SIBLING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:121:29: ( 'following-sibling' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:121:31: 'following-sibling'
            this.match("following-sibling"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FOLLOWING_SIBLING",

    // $ANTLR start FOR
    mFOR: function()  {
        try {
            var _type = this.FOR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:122:29: ( 'for' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:122:31: 'for'
            this.match("for"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FOR",

    // $ANTLR start FUNCTION
    mFUNCTION: function()  {
        try {
            var _type = this.FUNCTION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:123:29: ( 'function' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:123:31: 'function'
            this.match("function"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FUNCTION",

    // $ANTLR start GE
    mGE: function()  {
        try {
            var _type = this.GE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:124:29: ( 'ge' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:124:31: 'ge'
            this.match("ge"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "GE",

    // $ANTLR start GREATEST
    mGREATEST: function()  {
        try {
            var _type = this.GREATEST;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:125:29: ( 'greatest' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:125:31: 'greatest'
            this.match("greatest"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "GREATEST",

    // $ANTLR start GT
    mGT: function()  {
        try {
            var _type = this.GT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:126:29: ( 'gt' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:126:31: 'gt'
            this.match("gt"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "GT",

    // $ANTLR start IDIV
    mIDIV: function()  {
        try {
            var _type = this.IDIV;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:127:29: ( 'idiv' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:127:31: 'idiv'
            this.match("idiv"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "IDIV",

    // $ANTLR start IF
    mIF: function()  {
        try {
            var _type = this.IF;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:128:29: ( 'if' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:128:31: 'if'
            this.match("if"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "IF",

    // $ANTLR start IMPORT
    mIMPORT: function()  {
        try {
            var _type = this.IMPORT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:129:29: ( 'import' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:129:31: 'import'
            this.match("import"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "IMPORT",

    // $ANTLR start IN
    mIN: function()  {
        try {
            var _type = this.IN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:130:29: ( 'in' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:130:31: 'in'
            this.match("in"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "IN",

    // $ANTLR start INHERIT
    mINHERIT: function()  {
        try {
            var _type = this.INHERIT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:131:29: ( 'inherit' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:131:31: 'inherit'
            this.match("inherit"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "INHERIT",

    // $ANTLR start INSTANCE
    mINSTANCE: function()  {
        try {
            var _type = this.INSTANCE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:132:29: ( 'instance' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:132:31: 'instance'
            this.match("instance"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "INSTANCE",

    // $ANTLR start INTERSECT
    mINTERSECT: function()  {
        try {
            var _type = this.INTERSECT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:133:29: ( 'intersect' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:133:31: 'intersect'
            this.match("intersect"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "INTERSECT",

    // $ANTLR start IS
    mIS: function()  {
        try {
            var _type = this.IS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:134:29: ( 'is' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:134:31: 'is'
            this.match("is"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "IS",

    // $ANTLR start ITEM
    mITEM: function()  {
        try {
            var _type = this.ITEM;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:135:29: ( 'item' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:135:31: 'item'
            this.match("item"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ITEM",

    // $ANTLR start LAX
    mLAX: function()  {
        try {
            var _type = this.LAX;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:136:29: ( 'lax' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:136:31: 'lax'
            this.match("lax"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LAX",

    // $ANTLR start LE
    mLE: function()  {
        try {
            var _type = this.LE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:137:29: ( 'le' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:137:31: 'le'
            this.match("le"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LE",

    // $ANTLR start LEAST
    mLEAST: function()  {
        try {
            var _type = this.LEAST;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:138:29: ( 'least' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:138:31: 'least'
            this.match("least"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LEAST",

    // $ANTLR start LET
    mLET: function()  {
        try {
            var _type = this.LET;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:139:29: ( 'let' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:139:31: 'let'
            this.match("let"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LET",

    // $ANTLR start LT
    mLT: function()  {
        try {
            var _type = this.LT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:140:29: ( 'lt' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:140:31: 'lt'
            this.match("lt"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LT",

    // $ANTLR start MOD
    mMOD: function()  {
        try {
            var _type = this.MOD;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:141:29: ( 'mod' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:141:31: 'mod'
            this.match("mod"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "MOD",

    // $ANTLR start MODULE
    mMODULE: function()  {
        try {
            var _type = this.MODULE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:142:29: ( 'module' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:142:31: 'module'
            this.match("module"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "MODULE",

    // $ANTLR start NAMESPACE
    mNAMESPACE: function()  {
        try {
            var _type = this.NAMESPACE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:143:29: ( 'namespace' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:143:31: 'namespace'
            this.match("namespace"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NAMESPACE",

    // $ANTLR start NE
    mNE: function()  {
        try {
            var _type = this.NE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:144:29: ( 'ne' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:144:31: 'ne'
            this.match("ne"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NE",

    // $ANTLR start NO_INHERIT
    mNO_INHERIT: function()  {
        try {
            var _type = this.NO_INHERIT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:145:29: ( 'no-inherit' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:145:31: 'no-inherit'
            this.match("no-inherit"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NO_INHERIT",

    // $ANTLR start NO_PRESERVE
    mNO_PRESERVE: function()  {
        try {
            var _type = this.NO_PRESERVE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:146:29: ( 'no-preserve' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:146:31: 'no-preserve'
            this.match("no-preserve"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NO_PRESERVE",

    // $ANTLR start NODE
    mNODE: function()  {
        try {
            var _type = this.NODE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:147:29: ( 'node' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:147:31: 'node'
            this.match("node"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NODE",

    // $ANTLR start JSON
    mJSON: function()  {
        try {
            var _type = this.JSON;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:148:29: ( 'json' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:148:31: 'json'
            this.match("json"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "JSON",

    // $ANTLR start OF
    mOF: function()  {
        try {
            var _type = this.OF;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:149:29: ( 'of' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:149:31: 'of'
            this.match("of"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "OF",

    // $ANTLR start OPTION
    mOPTION: function()  {
        try {
            var _type = this.OPTION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:150:29: ( 'option' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:150:31: 'option'
            this.match("option"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "OPTION",

    // $ANTLR start OR
    mOR: function()  {
        try {
            var _type = this.OR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:151:29: ( 'or' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:151:31: 'or'
            this.match("or"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "OR",

    // $ANTLR start ORDER
    mORDER: function()  {
        try {
            var _type = this.ORDER;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:152:29: ( 'order' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:152:31: 'order'
            this.match("order"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ORDER",

    // $ANTLR start ORDERED
    mORDERED: function()  {
        try {
            var _type = this.ORDERED;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:153:29: ( 'ordered' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:153:31: 'ordered'
            this.match("ordered"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ORDERED",

    // $ANTLR start ORDERING
    mORDERING: function()  {
        try {
            var _type = this.ORDERING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:154:29: ( 'ordering' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:154:31: 'ordering'
            this.match("ordering"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ORDERING",

    // $ANTLR start PARENT
    mPARENT: function()  {
        try {
            var _type = this.PARENT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:155:29: ( 'parent' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:155:31: 'parent'
            this.match("parent"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PARENT",

    // $ANTLR start PRECEDING
    mPRECEDING: function()  {
        try {
            var _type = this.PRECEDING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:156:29: ( 'preceding' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:156:31: 'preceding'
            this.match("preceding"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PRECEDING",

    // $ANTLR start PRECEDING_SIBLING
    mPRECEDING_SIBLING: function()  {
        try {
            var _type = this.PRECEDING_SIBLING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:157:29: ( 'preceding-sibling' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:157:31: 'preceding-sibling'
            this.match("preceding-sibling"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PRECEDING_SIBLING",

    // $ANTLR start PRESERVE
    mPRESERVE: function()  {
        try {
            var _type = this.PRESERVE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:158:29: ( 'preserve' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:158:31: 'preserve'
            this.match("preserve"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PRESERVE",

    // $ANTLR start PROCESSING_INSTRUCTION
    mPROCESSING_INSTRUCTION: function()  {
        try {
            var _type = this.PROCESSING_INSTRUCTION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:159:29: ( 'processing-instruction' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:159:31: 'processing-instruction'
            this.match("processing-instruction"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PROCESSING_INSTRUCTION",

    // $ANTLR start STRUCTURED_ITEM
    mSTRUCTURED_ITEM: function()  {
        try {
            var _type = this.STRUCTURED_ITEM;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:160:29: ( 'structured-item' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:160:31: 'structured-item'
            this.match("structured-item"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "STRUCTURED_ITEM",

    // $ANTLR start JSON_ITEM
    mJSON_ITEM: function()  {
        try {
            var _type = this.JSON_ITEM;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:161:29: ( 'json-item' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:161:31: 'json-item'
            this.match("json-item"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "JSON_ITEM",

    // $ANTLR start OBJECT
    mOBJECT: function()  {
        try {
            var _type = this.OBJECT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:162:29: ( 'object' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:162:31: 'object'
            this.match("object"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "OBJECT",

    // $ANTLR start ARRAY
    mARRAY: function()  {
        try {
            var _type = this.ARRAY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:163:29: ( 'array' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:163:31: 'array'
            this.match("array"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ARRAY",

    // $ANTLR start RETURN
    mRETURN: function()  {
        try {
            var _type = this.RETURN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:164:29: ( 'return' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:164:31: 'return'
            this.match("return"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "RETURN",

    // $ANTLR start SATISFIES
    mSATISFIES: function()  {
        try {
            var _type = this.SATISFIES;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:165:29: ( 'satisfies' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:165:31: 'satisfies'
            this.match("satisfies"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SATISFIES",

    // $ANTLR start SCHEMA
    mSCHEMA: function()  {
        try {
            var _type = this.SCHEMA;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:166:29: ( 'schema' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:166:31: 'schema'
            this.match("schema"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SCHEMA",

    // $ANTLR start SCHEMA_ATTRIBUTE
    mSCHEMA_ATTRIBUTE: function()  {
        try {
            var _type = this.SCHEMA_ATTRIBUTE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:167:29: ( 'schema-attribute' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:167:31: 'schema-attribute'
            this.match("schema-attribute"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SCHEMA_ATTRIBUTE",

    // $ANTLR start SCHEMA_ELEMENT
    mSCHEMA_ELEMENT: function()  {
        try {
            var _type = this.SCHEMA_ELEMENT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:168:29: ( 'schema-element' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:168:31: 'schema-element'
            this.match("schema-element"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SCHEMA_ELEMENT",

    // $ANTLR start SELF
    mSELF: function()  {
        try {
            var _type = this.SELF;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:169:29: ( 'self' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:169:31: 'self'
            this.match("self"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SELF",

    // $ANTLR start SOME
    mSOME: function()  {
        try {
            var _type = this.SOME;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:170:29: ( 'some' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:170:31: 'some'
            this.match("some"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SOME",

    // $ANTLR start STABLE
    mSTABLE: function()  {
        try {
            var _type = this.STABLE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:171:29: ( 'stable' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:171:31: 'stable'
            this.match("stable"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "STABLE",

    // $ANTLR start STRICT
    mSTRICT: function()  {
        try {
            var _type = this.STRICT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:172:29: ( 'strict' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:172:31: 'strict'
            this.match("strict"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "STRICT",

    // $ANTLR start STRIP
    mSTRIP: function()  {
        try {
            var _type = this.STRIP;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:173:29: ( 'strip' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:173:31: 'strip'
            this.match("strip"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "STRIP",

    // $ANTLR start TEXT
    mTEXT: function()  {
        try {
            var _type = this.TEXT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:174:29: ( 'text' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:174:31: 'text'
            this.match("text"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "TEXT",

    // $ANTLR start THEN
    mTHEN: function()  {
        try {
            var _type = this.THEN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:175:29: ( 'then' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:175:31: 'then'
            this.match("then"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "THEN",

    // $ANTLR start TO
    mTO: function()  {
        try {
            var _type = this.TO;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:176:29: ( 'to' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:176:31: 'to'
            this.match("to"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "TO",

    // $ANTLR start TREAT
    mTREAT: function()  {
        try {
            var _type = this.TREAT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:177:29: ( 'treat' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:177:31: 'treat'
            this.match("treat"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "TREAT",

    // $ANTLR start TYPESWITCH
    mTYPESWITCH: function()  {
        try {
            var _type = this.TYPESWITCH;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:178:29: ( 'typeswitch' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:178:31: 'typeswitch'
            this.match("typeswitch"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "TYPESWITCH",

    // $ANTLR start UNION
    mUNION: function()  {
        try {
            var _type = this.UNION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:179:29: ( 'union' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:179:31: 'union'
            this.match("union"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "UNION",

    // $ANTLR start UNORDERED
    mUNORDERED: function()  {
        try {
            var _type = this.UNORDERED;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:180:29: ( 'unordered' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:180:31: 'unordered'
            this.match("unordered"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "UNORDERED",

    // $ANTLR start VALIDATE
    mVALIDATE: function()  {
        try {
            var _type = this.VALIDATE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:181:29: ( 'validate' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:181:31: 'validate'
            this.match("validate"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "VALIDATE",

    // $ANTLR start VARIABLE
    mVARIABLE: function()  {
        try {
            var _type = this.VARIABLE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:182:29: ( 'variable' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:182:31: 'variable'
            this.match("variable"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "VARIABLE",

    // $ANTLR start VERSION
    mVERSION: function()  {
        try {
            var _type = this.VERSION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:183:29: ( 'version' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:183:31: 'version'
            this.match("version"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "VERSION",

    // $ANTLR start WHERE
    mWHERE: function()  {
        try {
            var _type = this.WHERE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:184:29: ( 'where' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:184:31: 'where'
            this.match("where"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WHERE",

    // $ANTLR start XQUERY
    mXQUERY: function()  {
        try {
            var _type = this.XQUERY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:185:29: ( 'xquery' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:185:31: 'xquery'
            this.match("xquery"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "XQUERY",

    // $ANTLR start ALLOWING
    mALLOWING: function()  {
        try {
            var _type = this.ALLOWING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:187:29: ( 'allowing' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:187:31: 'allowing'
            this.match("allowing"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ALLOWING",

    // $ANTLR start CATCH
    mCATCH: function()  {
        try {
            var _type = this.CATCH;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:188:29: ( 'catch' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:188:31: 'catch'
            this.match("catch"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CATCH",

    // $ANTLR start CONTEXT
    mCONTEXT: function()  {
        try {
            var _type = this.CONTEXT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:189:29: ( 'context' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:189:31: 'context'
            this.match("context"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CONTEXT",

    // $ANTLR start COUNT
    mCOUNT: function()  {
        try {
            var _type = this.COUNT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:190:29: ( 'count' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:190:31: 'count'
            this.match("count"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "COUNT",

    // $ANTLR start DECIMAL_FORMAT
    mDECIMAL_FORMAT: function()  {
        try {
            var _type = this.DECIMAL_FORMAT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:191:29: ( 'decimal-format' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:191:31: 'decimal-format'
            this.match("decimal-format"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DECIMAL_FORMAT",

    // $ANTLR start DECIMAL_SEPARATOR
    mDECIMAL_SEPARATOR: function()  {
        try {
            var _type = this.DECIMAL_SEPARATOR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:192:29: ( 'decimal-separator' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:192:31: 'decimal-separator'
            this.match("decimal-separator"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DECIMAL_SEPARATOR",

    // $ANTLR start DIGIT
    mDIGIT: function()  {
        try {
            var _type = this.DIGIT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:193:29: ( 'digit' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:193:31: 'digit'
            this.match("digit"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DIGIT",

    // $ANTLR start END
    mEND: function()  {
        try {
            var _type = this.END;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:194:29: ( 'end' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:194:31: 'end'
            this.match("end"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "END",

    // $ANTLR start GROUP
    mGROUP: function()  {
        try {
            var _type = this.GROUP;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:195:29: ( 'group' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:195:31: 'group'
            this.match("group"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "GROUP",

    // $ANTLR start GROUPING_SEPARATOR
    mGROUPING_SEPARATOR: function()  {
        try {
            var _type = this.GROUPING_SEPARATOR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:196:29: ( 'grouping-separator' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:196:31: 'grouping-separator'
            this.match("grouping-separator"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "GROUPING_SEPARATOR",

    // $ANTLR start INFINITY
    mINFINITY: function()  {
        try {
            var _type = this.INFINITY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:197:29: ( 'infinity' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:197:31: 'infinity'
            this.match("infinity"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "INFINITY",

    // $ANTLR start MINUS_SIGN
    mMINUS_SIGN: function()  {
        try {
            var _type = this.MINUS_SIGN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:198:29: ( 'minus-sign' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:198:31: 'minus-sign'
            this.match("minus-sign"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "MINUS_SIGN",

    // $ANTLR start NAMESPACE_NODE
    mNAMESPACE_NODE: function()  {
        try {
            var _type = this.NAMESPACE_NODE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:199:29: ( 'namespace-node' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:199:31: 'namespace-node'
            this.match("namespace-node"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NAMESPACE_NODE",

    // $ANTLR start NAN
    mNAN: function()  {
        try {
            var _type = this.NAN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:200:29: ( 'NaN' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:200:31: 'NaN'
            this.match("NaN"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NAN",

    // $ANTLR start NEXT
    mNEXT: function()  {
        try {
            var _type = this.NEXT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:201:29: ( 'next' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:201:31: 'next'
            this.match("next"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NEXT",

    // $ANTLR start ONLY
    mONLY: function()  {
        try {
            var _type = this.ONLY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:202:29: ( 'only' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:202:31: 'only'
            this.match("only"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ONLY",

    // $ANTLR start PATTERN_SEPARATOR
    mPATTERN_SEPARATOR: function()  {
        try {
            var _type = this.PATTERN_SEPARATOR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:203:29: ( 'pattern-separator' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:203:31: 'pattern-separator'
            this.match("pattern-separator"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PATTERN_SEPARATOR",

    // $ANTLR start PERCENT
    mPERCENT: function()  {
        try {
            var _type = this.PERCENT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:204:29: ( 'percent' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:204:31: 'percent'
            this.match("percent"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PERCENT",

    // $ANTLR start PER_MILLE
    mPER_MILLE: function()  {
        try {
            var _type = this.PER_MILLE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:205:29: ( 'per-mille' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:205:31: 'per-mille'
            this.match("per-mille"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PER_MILLE",

    // $ANTLR start PREVIOUS
    mPREVIOUS: function()  {
        try {
            var _type = this.PREVIOUS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:206:29: ( 'previous' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:206:31: 'previous'
            this.match("previous"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PREVIOUS",

    // $ANTLR start SLIDING
    mSLIDING: function()  {
        try {
            var _type = this.SLIDING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:207:29: ( 'sliding' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:207:31: 'sliding'
            this.match("sliding"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SLIDING",

    // $ANTLR start START
    mSTART: function()  {
        try {
            var _type = this.START;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:208:29: ( 'start' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:208:31: 'start'
            this.match("start"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "START",

    // $ANTLR start SWITCH
    mSWITCH: function()  {
        try {
            var _type = this.SWITCH;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:209:29: ( 'switch' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:209:31: 'switch'
            this.match("switch"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SWITCH",

    // $ANTLR start TRY
    mTRY: function()  {
        try {
            var _type = this.TRY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:210:29: ( 'try' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:210:31: 'try'
            this.match("try"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "TRY",

    // $ANTLR start TUMBLING
    mTUMBLING: function()  {
        try {
            var _type = this.TUMBLING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:211:29: ( 'tumbling' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:211:31: 'tumbling'
            this.match("tumbling"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "TUMBLING",

    // $ANTLR start TYPE
    mTYPE: function()  {
        try {
            var _type = this.TYPE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:212:29: ( 'type' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:212:31: 'type'
            this.match("type"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "TYPE",

    // $ANTLR start WHEN
    mWHEN: function()  {
        try {
            var _type = this.WHEN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:213:29: ( 'when' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:213:31: 'when'
            this.match("when"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WHEN",

    // $ANTLR start WINDOW
    mWINDOW: function()  {
        try {
            var _type = this.WINDOW;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:214:29: ( 'window' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:214:31: 'window'
            this.match("window"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WINDOW",

    // $ANTLR start ZERO_DIGIT
    mZERO_DIGIT: function()  {
        try {
            var _type = this.ZERO_DIGIT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:215:29: ( 'zero-digit' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:215:31: 'zero-digit'
            this.match("zero-digit"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ZERO_DIGIT",

    // $ANTLR start AFTER
    mAFTER: function()  {
        try {
            var _type = this.AFTER;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:217:29: ( 'after' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:217:31: 'after'
            this.match("after"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "AFTER",

    // $ANTLR start BEFORE
    mBEFORE: function()  {
        try {
            var _type = this.BEFORE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:218:29: ( 'before' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:218:31: 'before'
            this.match("before"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "BEFORE",

    // $ANTLR start COPY
    mCOPY: function()  {
        try {
            var _type = this.COPY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:219:29: ( 'copy' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:219:31: 'copy'
            this.match("copy"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "COPY",

    // $ANTLR start DELETE
    mDELETE: function()  {
        try {
            var _type = this.DELETE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:220:29: ( 'delete' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:220:31: 'delete'
            this.match("delete"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DELETE",

    // $ANTLR start FIRST
    mFIRST: function()  {
        try {
            var _type = this.FIRST;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:221:29: ( 'first' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:221:31: 'first'
            this.match("first"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FIRST",

    // $ANTLR start INSERT
    mINSERT: function()  {
        try {
            var _type = this.INSERT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:222:29: ( 'insert' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:222:31: 'insert'
            this.match("insert"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "INSERT",

    // $ANTLR start INTO
    mINTO: function()  {
        try {
            var _type = this.INTO;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:223:29: ( 'into' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:223:31: 'into'
            this.match("into"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "INTO",

    // $ANTLR start POSITION
    mPOSITION: function()  {
        try {
            var _type = this.POSITION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:224:29: ( 'position' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:224:31: 'position'
            this.match("position"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "POSITION",

    // $ANTLR start APPEND
    mAPPEND: function()  {
        try {
            var _type = this.APPEND;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:225:29: ( 'append' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:225:31: 'append'
            this.match("append"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "APPEND",

    // $ANTLR start LAST
    mLAST: function()  {
        try {
            var _type = this.LAST;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:226:29: ( 'last' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:226:31: 'last'
            this.match("last"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LAST",

    // $ANTLR start MODIFY
    mMODIFY: function()  {
        try {
            var _type = this.MODIFY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:227:29: ( 'modify' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:227:31: 'modify'
            this.match("modify"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "MODIFY",

    // $ANTLR start NODES
    mNODES: function()  {
        try {
            var _type = this.NODES;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:228:29: ( 'nodes' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:228:31: 'nodes'
            this.match("nodes"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NODES",

    // $ANTLR start RENAME
    mRENAME: function()  {
        try {
            var _type = this.RENAME;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:229:29: ( 'rename' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:229:31: 'rename'
            this.match("rename"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "RENAME",

    // $ANTLR start REPLACE
    mREPLACE: function()  {
        try {
            var _type = this.REPLACE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:230:29: ( 'replace' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:230:31: 'replace'
            this.match("replace"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "REPLACE",

    // $ANTLR start REVALIDATION
    mREVALIDATION: function()  {
        try {
            var _type = this.REVALIDATION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:231:29: ( 'revalidation' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:231:31: 'revalidation'
            this.match("revalidation"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "REVALIDATION",

    // $ANTLR start SKIP
    mSKIP: function()  {
        try {
            var _type = this.SKIP;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:232:29: ( 'skip' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:232:31: 'skip'
            this.match("skip"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SKIP",

    // $ANTLR start UPDATING
    mUPDATING: function()  {
        try {
            var _type = this.UPDATING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:233:29: ( 'updating' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:233:31: 'updating'
            this.match("updating"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "UPDATING",

    // $ANTLR start VALUE
    mVALUE: function()  {
        try {
            var _type = this.VALUE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:234:29: ( 'value' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:234:31: 'value'
            this.match("value"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "VALUE",

    // $ANTLR start WITH
    mWITH: function()  {
        try {
            var _type = this.WITH;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:235:29: ( 'with' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:235:31: 'with'
            this.match("with"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WITH",

    // $ANTLR start ALL
    mALL: function()  {
        try {
            var _type = this.ALL;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:237:29: ( 'all' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:237:31: 'all'
            this.match("all"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ALL",

    // $ANTLR start ANY
    mANY: function()  {
        try {
            var _type = this.ANY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:238:29: ( 'any' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:238:31: 'any'
            this.match("any"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ANY",

    // $ANTLR start CONTAINS
    mCONTAINS: function()  {
        try {
            var _type = this.CONTAINS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:239:29: ( 'contains' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:239:31: 'contains'
            this.match("contains"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CONTAINS",

    // $ANTLR start CONTENT
    mCONTENT: function()  {
        try {
            var _type = this.CONTENT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:240:29: ( 'content' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:240:31: 'content'
            this.match("content"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CONTENT",

    // $ANTLR start DIACRITICS
    mDIACRITICS: function()  {
        try {
            var _type = this.DIACRITICS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:241:29: ( 'diacritics' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:241:31: 'diacritics'
            this.match("diacritics"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DIACRITICS",

    // $ANTLR start DIFFERENT
    mDIFFERENT: function()  {
        try {
            var _type = this.DIFFERENT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:242:29: ( 'different' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:242:31: 'different'
            this.match("different"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DIFFERENT",

    // $ANTLR start DISTANCE
    mDISTANCE: function()  {
        try {
            var _type = this.DISTANCE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:243:29: ( 'distance' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:243:31: 'distance'
            this.match("distance"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DISTANCE",

    // $ANTLR start ENTIRE
    mENTIRE: function()  {
        try {
            var _type = this.ENTIRE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:244:29: ( 'entire' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:244:31: 'entire'
            this.match("entire"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ENTIRE",

    // $ANTLR start EXACTLY
    mEXACTLY: function()  {
        try {
            var _type = this.EXACTLY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:245:29: ( 'exactly' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:245:31: 'exactly'
            this.match("exactly"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EXACTLY",

    // $ANTLR start FROM
    mFROM: function()  {
        try {
            var _type = this.FROM;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:246:29: ( 'from' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:246:31: 'from'
            this.match("from"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FROM",

    // $ANTLR start FT_OPTION
    mFT_OPTION: function()  {
        try {
            var _type = this.FT_OPTION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:247:29: ( 'ft-option' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:247:31: 'ft-option'
            this.match("ft-option"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FT_OPTION",

    // $ANTLR start FTAND
    mFTAND: function()  {
        try {
            var _type = this.FTAND;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:248:29: ( 'ftand' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:248:31: 'ftand'
            this.match("ftand"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FTAND",

    // $ANTLR start FTNOT
    mFTNOT: function()  {
        try {
            var _type = this.FTNOT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:249:29: ( 'ftnot' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:249:31: 'ftnot'
            this.match("ftnot"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FTNOT",

    // $ANTLR start FTOR
    mFTOR: function()  {
        try {
            var _type = this.FTOR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:250:29: ( 'ftor' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:250:31: 'ftor'
            this.match("ftor"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FTOR",

    // $ANTLR start INSENSITIVE
    mINSENSITIVE: function()  {
        try {
            var _type = this.INSENSITIVE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:251:29: ( 'insensitive' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:251:31: 'insensitive'
            this.match("insensitive"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "INSENSITIVE",

    // $ANTLR start LANGUAGE
    mLANGUAGE: function()  {
        try {
            var _type = this.LANGUAGE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:252:29: ( 'language' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:252:31: 'language'
            this.match("language"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LANGUAGE",

    // $ANTLR start LEVELS
    mLEVELS: function()  {
        try {
            var _type = this.LEVELS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:253:29: ( 'levels' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:253:31: 'levels'
            this.match("levels"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LEVELS",

    // $ANTLR start LOWERCASE
    mLOWERCASE: function()  {
        try {
            var _type = this.LOWERCASE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:254:29: ( 'lowercase' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:254:31: 'lowercase'
            this.match("lowercase"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LOWERCASE",

    // $ANTLR start MOST
    mMOST: function()  {
        try {
            var _type = this.MOST;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:255:29: ( 'most' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:255:31: 'most'
            this.match("most"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "MOST",

    // $ANTLR start NO
    mNO: function()  {
        try {
            var _type = this.NO;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:256:29: ( 'no' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:256:31: 'no'
            this.match("no"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NO",

    // $ANTLR start NOT
    mNOT: function()  {
        try {
            var _type = this.NOT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:257:29: ( 'not' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:257:31: 'not'
            this.match("not"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NOT",

    // $ANTLR start OCCURS
    mOCCURS: function()  {
        try {
            var _type = this.OCCURS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:258:29: ( 'occurs' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:258:31: 'occurs'
            this.match("occurs"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "OCCURS",

    // $ANTLR start PARAGRAPH
    mPARAGRAPH: function()  {
        try {
            var _type = this.PARAGRAPH;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:259:29: ( 'paragraph' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:259:31: 'paragraph'
            this.match("paragraph"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PARAGRAPH",

    // $ANTLR start PARAGRAPHS
    mPARAGRAPHS: function()  {
        try {
            var _type = this.PARAGRAPHS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:260:29: ( 'paragraphs' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:260:31: 'paragraphs'
            this.match("paragraphs"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PARAGRAPHS",

    // $ANTLR start PHRASE
    mPHRASE: function()  {
        try {
            var _type = this.PHRASE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:261:29: ( 'phrase' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:261:31: 'phrase'
            this.match("phrase"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PHRASE",

    // $ANTLR start RELATIONSHIP
    mRELATIONSHIP: function()  {
        try {
            var _type = this.RELATIONSHIP;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:262:29: ( 'relationship' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:262:31: 'relationship'
            this.match("relationship"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "RELATIONSHIP",

    // $ANTLR start SAME
    mSAME: function()  {
        try {
            var _type = this.SAME;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:263:29: ( 'same' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:263:31: 'same'
            this.match("same"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SAME",

    // $ANTLR start SCORE
    mSCORE: function()  {
        try {
            var _type = this.SCORE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:264:29: ( 'score' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:264:31: 'score'
            this.match("score"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SCORE",

    // $ANTLR start SENSITIVE
    mSENSITIVE: function()  {
        try {
            var _type = this.SENSITIVE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:265:29: ( 'sensitive' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:265:31: 'sensitive'
            this.match("sensitive"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SENSITIVE",

    // $ANTLR start SENTENCE
    mSENTENCE: function()  {
        try {
            var _type = this.SENTENCE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:266:29: ( 'sentence' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:266:31: 'sentence'
            this.match("sentence"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SENTENCE",

    // $ANTLR start SENTENCES
    mSENTENCES: function()  {
        try {
            var _type = this.SENTENCES;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:267:29: ( 'sentences' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:267:31: 'sentences'
            this.match("sentences"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SENTENCES",

    // $ANTLR start STEMMING
    mSTEMMING: function()  {
        try {
            var _type = this.STEMMING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:268:29: ( 'stemming' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:268:31: 'stemming'
            this.match("stemming"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "STEMMING",

    // $ANTLR start STOP
    mSTOP: function()  {
        try {
            var _type = this.STOP;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:269:29: ( 'stop' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:269:31: 'stop'
            this.match("stop"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "STOP",

    // $ANTLR start THESAURUS
    mTHESAURUS: function()  {
        try {
            var _type = this.THESAURUS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:270:29: ( 'thesaurus' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:270:31: 'thesaurus'
            this.match("thesaurus"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "THESAURUS",

    // $ANTLR start TIMES
    mTIMES: function()  {
        try {
            var _type = this.TIMES;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:271:29: ( 'times' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:271:31: 'times'
            this.match("times"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "TIMES",

    // $ANTLR start UPPERCASE
    mUPPERCASE: function()  {
        try {
            var _type = this.UPPERCASE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:272:29: ( 'uppercase' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:272:31: 'uppercase'
            this.match("uppercase"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "UPPERCASE",

    // $ANTLR start USING
    mUSING: function()  {
        try {
            var _type = this.USING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:273:29: ( 'using' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:273:31: 'using'
            this.match("using"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "USING",

    // $ANTLR start WEIGHT
    mWEIGHT: function()  {
        try {
            var _type = this.WEIGHT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:274:29: ( 'weight' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:274:31: 'weight'
            this.match("weight"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WEIGHT",

    // $ANTLR start WILDCARDS
    mWILDCARDS: function()  {
        try {
            var _type = this.WILDCARDS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:275:29: ( 'wildcards' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:275:31: 'wildcards'
            this.match("wildcards"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WILDCARDS",

    // $ANTLR start WITHOUT
    mWITHOUT: function()  {
        try {
            var _type = this.WITHOUT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:276:29: ( 'without' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:276:31: 'without'
            this.match("without"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WITHOUT",

    // $ANTLR start WORD
    mWORD: function()  {
        try {
            var _type = this.WORD;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:277:29: ( 'word' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:277:31: 'word'
            this.match("word"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WORD",

    // $ANTLR start WORDS
    mWORDS: function()  {
        try {
            var _type = this.WORDS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:278:29: ( 'words' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:278:31: 'words'
            this.match("words"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WORDS",

    // $ANTLR start BREAK
    mBREAK: function()  {
        try {
            var _type = this.BREAK;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:280:29: ( 'break' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:280:31: 'break'
            this.match("break"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "BREAK",

    // $ANTLR start CONTINUE
    mCONTINUE: function()  {
        try {
            var _type = this.CONTINUE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:281:29: ( 'continue' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:281:31: 'continue'
            this.match("continue"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CONTINUE",

    // $ANTLR start EXIT
    mEXIT: function()  {
        try {
            var _type = this.EXIT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:282:29: ( 'exit' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:282:31: 'exit'
            this.match("exit"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EXIT",

    // $ANTLR start LOOP
    mLOOP: function()  {
        try {
            var _type = this.LOOP;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:283:29: ( 'loop' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:283:31: 'loop'
            this.match("loop"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LOOP",

    // $ANTLR start RETURNING
    mRETURNING: function()  {
        try {
            var _type = this.RETURNING;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:284:29: ( 'returning' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:284:31: 'returning'
            this.match("returning"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "RETURNING",

    // $ANTLR start WHILE
    mWHILE: function()  {
        try {
            var _type = this.WHILE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:285:29: ( 'while' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:285:31: 'while'
            this.match("while"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "WHILE",

    // $ANTLR start CHECK
    mCHECK: function()  {
        try {
            var _type = this.CHECK;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:287:29: ( 'check' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:287:31: 'check'
            this.match("check"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CHECK",

    // $ANTLR start COLLECTION
    mCOLLECTION: function()  {
        try {
            var _type = this.COLLECTION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:288:29: ( 'collection' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:288:31: 'collection'
            this.match("collection"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "COLLECTION",

    // $ANTLR start CONSTRAINT
    mCONSTRAINT: function()  {
        try {
            var _type = this.CONSTRAINT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:289:29: ( 'constraint' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:289:31: 'constraint'
            this.match("constraint"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CONSTRAINT",

    // $ANTLR start FOREACH
    mFOREACH: function()  {
        try {
            var _type = this.FOREACH;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:290:29: ( 'foreach' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:290:31: 'foreach'
            this.match("foreach"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FOREACH",

    // $ANTLR start FOREIGN
    mFOREIGN: function()  {
        try {
            var _type = this.FOREIGN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:291:29: ( 'foreign' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:291:31: 'foreign'
            this.match("foreign"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "FOREIGN",

    // $ANTLR start INDEX
    mINDEX: function()  {
        try {
            var _type = this.INDEX;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:292:29: ( 'index' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:292:31: 'index'
            this.match("index"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "INDEX",

    // $ANTLR start INTEGRITY
    mINTEGRITY: function()  {
        try {
            var _type = this.INTEGRITY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:293:29: ( 'integrity' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:293:31: 'integrity'
            this.match("integrity"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "INTEGRITY",

    // $ANTLR start KEY
    mKEY: function()  {
        try {
            var _type = this.KEY;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:294:29: ( 'key' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:294:31: 'key'
            this.match("key"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "KEY",

    // $ANTLR start ON
    mON: function()  {
        try {
            var _type = this.ON;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:295:29: ( 'on' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:295:31: 'on'
            this.match("on"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ON",

    // $ANTLR start UNIQUE
    mUNIQUE: function()  {
        try {
            var _type = this.UNIQUE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:296:29: ( 'unique' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:296:31: 'unique'
            this.match("unique"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "UNIQUE",

    // $ANTLR start AMP_ER
    mAMP_ER: function()  {
        try {
            var _type = this.AMP_ER;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:299:9: ( 'amp' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:299:11: 'amp'
            this.match("amp"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "AMP_ER",

    // $ANTLR start APOS_ER
    mAPOS_ER: function()  {
        try {
            var _type = this.APOS_ER;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:300:9: ( 'apos' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:300:11: 'apos'
            this.match("apos"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "APOS_ER",

    // $ANTLR start QUOT_ER
    mQUOT_ER: function()  {
        try {
            var _type = this.QUOT_ER;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:301:9: ( 'quot' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:301:11: 'quot'
            this.match("quot"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "QUOT_ER",

    // $ANTLR start CONCAT
    mCONCAT: function()  {
        try {
            var _type = this.CONCAT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:308:25: ( '||' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:308:27: '||'
            this.match("||"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CONCAT",

    // $ANTLR start LPAREN
    mLPAREN: function()  {
        try {
            var _type = this.LPAREN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:309:25: ( '(' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:309:27: '('
            this.match('('); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LPAREN",

    // $ANTLR start RPAREN
    mRPAREN: function()  {
        try {
            var _type = this.RPAREN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:310:25: ( ')' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:310:27: ')'
            this.match(')'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "RPAREN",

    // $ANTLR start DOLLAR
    mDOLLAR: function()  {
        try {
            var _type = this.DOLLAR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:311:25: ( '$' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:311:27: '$'
            this.match('$'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DOLLAR",

    // $ANTLR start L_UNION_BRACKET
    mL_UNION_BRACKET: function()  {
        try {
            var _type = this.L_UNION_BRACKET;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:312:25: ( '{|' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:312:27: '{|'
            this.match("{|"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_UNION_BRACKET",

    // $ANTLR start R_UNION_BRACKET
    mR_UNION_BRACKET: function()  {
        try {
            var _type = this.R_UNION_BRACKET;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:313:25: ( '|}' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:313:27: '|}'
            this.match("|}"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "R_UNION_BRACKET",

    // $ANTLR start LBRACKET
    mLBRACKET: function()  {
        try {
            var _type = this.LBRACKET;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:316:25: ( '{' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:316:27: '{'
            this.match('{'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LBRACKET",

    // $ANTLR start RBRACKET
    mRBRACKET: function()  {
        try {
            var _type = this.RBRACKET;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:317:25: ( '}' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:317:27: '}'
            this.match('}'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "RBRACKET",

    // $ANTLR start LSQUARE
    mLSQUARE: function()  {
        try {
            var _type = this.LSQUARE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:318:25: ( '[' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:318:27: '['
            this.match('['); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "LSQUARE",

    // $ANTLR start RSQUARE
    mRSQUARE: function()  {
        try {
            var _type = this.RSQUARE;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:319:25: ( ']' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:319:27: ']'
            this.match(']'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "RSQUARE",

    // $ANTLR start EQUAL
    mEQUAL: function()  {
        try {
            var _type = this.EQUAL;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:320:25: ( '=' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:320:27: '='
            this.match('='); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EQUAL",

    // $ANTLR start BIND
    mBIND: function()  {
        try {
            var _type = this.BIND;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:321:25: ( ':=' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:321:27: ':='
            this.match(":="); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "BIND",

    // $ANTLR start NOTEQUAL
    mNOTEQUAL: function()  {
        try {
            var _type = this.NOTEQUAL;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:322:25: ( '!=' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:322:27: '!='
            this.match("!="); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "NOTEQUAL",

    // $ANTLR start ANN_PERCENT
    mANN_PERCENT: function()  {
        try {
            var _type = this.ANN_PERCENT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:323:25: ( '%' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:323:27: '%'
            this.match('%'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ANN_PERCENT",

    // $ANTLR start HASH
    mHASH: function()  {
        try {
            var _type = this.HASH;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:324:25: ( '#' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:324:27: '#'
            this.match('#'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "HASH",

    // $ANTLR start AMP
    mAMP: function()  {
        try {
            var _type = this.AMP;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:325:25: ( '&' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:325:27: '&'
            this.match('&'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "AMP",

    // $ANTLR start COMMA
    mCOMMA: function()  {
        try {
            var _type = this.COMMA;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:326:25: ( ',' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:326:27: ','
            this.match(','); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "COMMA",

    // $ANTLR start QUESTION
    mQUESTION: function()  {
        try {
            var _type = this.QUESTION;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:327:25: ( '?' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:327:27: '?'
            this.match('?'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "QUESTION",

    // $ANTLR start STAR
    mSTAR: function()  {
        try {
            var _type = this.STAR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:328:25: ( '*' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:328:27: '*'
            this.match('*'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "STAR",

    // $ANTLR start PLUS
    mPLUS: function()  {
        try {
            var _type = this.PLUS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:329:25: ( '+' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:329:27: '+'
            this.match('+'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PLUS",

    // $ANTLR start MINUS
    mMINUS: function()  {
        try {
            var _type = this.MINUS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:330:25: ( '-' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:330:27: '-'
            this.match('-'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "MINUS",

    // $ANTLR start SMALLER
    mSMALLER: function()  {
        try {
            var _type = this.SMALLER;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:331:25: ( '<' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:331:27: '<'
            this.match('<'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SMALLER",

    // $ANTLR start GREATER
    mGREATER: function()  {
        try {
            var _type = this.GREATER;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:332:25: ( '>' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:332:27: '>'
            this.match('>'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "GREATER",

    // $ANTLR start SMALLEREQ
    mSMALLEREQ: function()  {
        try {
            var _type = this.SMALLEREQ;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:333:25: ( '<=' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:333:27: '<='
            this.match("<="); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SMALLEREQ",

    // $ANTLR start GREATEREQ
    mGREATEREQ: function()  {
        try {
            var _type = this.GREATEREQ;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:334:25: ( '>=' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:334:27: '>='
            this.match(">="); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "GREATEREQ",

    // $ANTLR start SMALLER_SMALLER
    mSMALLER_SMALLER: function()  {
        try {
            var _type = this.SMALLER_SMALLER;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:335:25: ( '<<' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:335:27: '<<'
            this.match("<<"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SMALLER_SMALLER",

    // $ANTLR start GREATER_GREATER
    mGREATER_GREATER: function()  {
        try {
            var _type = this.GREATER_GREATER;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:336:25: ( '>>' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:336:27: '>>'
            this.match(">>"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "GREATER_GREATER",

    // $ANTLR start SLASH
    mSLASH: function()  {
        try {
            var _type = this.SLASH;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:337:25: ( '/' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:337:27: '/'
            this.match('/'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SLASH",

    // $ANTLR start SLASH_SLASH
    mSLASH_SLASH: function()  {
        try {
            var _type = this.SLASH_SLASH;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:338:25: ( '//' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:338:27: '//'
            this.match("//"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SLASH_SLASH",

    // $ANTLR start BANG
    mBANG: function()  {
        try {
            var _type = this.BANG;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:339:25: ( '!' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:339:27: '!'
            this.match('!'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "BANG",

    // $ANTLR start DOT
    mDOT: function()  {
        try {
            var _type = this.DOT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:340:25: ( '.' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:340:27: '.'
            this.match('.'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DOT",

    // $ANTLR start DOT_DOT
    mDOT_DOT: function()  {
        try {
            var _type = this.DOT_DOT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:341:25: ( '..' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:341:27: '..'
            this.match(".."); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "DOT_DOT",

    // $ANTLR start COLON
    mCOLON: function()  {
        try {
            var _type = this.COLON;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:342:25: ( ':' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:342:27: ':'
            this.match(':'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "COLON",

    // $ANTLR start COLON_COLON
    mCOLON_COLON: function()  {
        try {
            var _type = this.COLON_COLON;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:343:25: ( '::' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:343:27: '::'
            this.match("::"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "COLON_COLON",

    // $ANTLR start EMPTY_CLOSE_TAG
    mEMPTY_CLOSE_TAG: function()  {
        try {
            var _type = this.EMPTY_CLOSE_TAG;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:344:25: ( '/>' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:344:27: '/>'
            this.match("/>"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "EMPTY_CLOSE_TAG",

    // $ANTLR start CLOSE_TAG
    mCLOSE_TAG: function()  {
        try {
            var _type = this.CLOSE_TAG;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:345:25: ( '</' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:345:27: '</'
            this.match("</"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CLOSE_TAG",

    // $ANTLR start SEMICOLON
    mSEMICOLON: function()  {
        try {
            var _type = this.SEMICOLON;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:346:25: ( ';' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:346:27: ';'
            this.match(';'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "SEMICOLON",

    // $ANTLR start VBAR
    mVBAR: function()  {
        try {
            var _type = this.VBAR;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:347:25: ( '|' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:347:27: '|'
            this.match('|'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "VBAR",

    // $ANTLR start PRAGMA_START
    mPRAGMA_START: function()  {
        try {
            var _type = this.PRAGMA_START;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:348:25: ( '(#' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:348:27: '(#'
            this.match("(#"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PRAGMA_START",

    // $ANTLR start PRAGMA_END
    mPRAGMA_END: function()  {
        try {
            var _type = this.PRAGMA_END;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:349:25: ( '#)' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:349:27: '#)'
            this.match("#)"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PRAGMA_END",

    // $ANTLR start XML_COMMENT_START
    mXML_COMMENT_START: function()  {
        try {
            var _type = this.XML_COMMENT_START;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:350:25: ( '<!--' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:350:27: '<!--'
            this.match("<!--"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "XML_COMMENT_START",

    // $ANTLR start XML_COMMENT_END
    mXML_COMMENT_END: function()  {
        try {
            var _type = this.XML_COMMENT_END;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:351:25: ( '-->' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:351:27: '-->'
            this.match("-->"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "XML_COMMENT_END",

    // $ANTLR start PI_START
    mPI_START: function()  {
        try {
            var _type = this.PI_START;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:352:25: ( '<?' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:352:27: '<?'
            this.match("<?"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PI_START",

    // $ANTLR start PI_END
    mPI_END: function()  {
        try {
            var _type = this.PI_END;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:353:25: ( '?>' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:353:27: '?>'
            this.match("?>"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "PI_END",

    // $ANTLR start ATTR_SIGN
    mATTR_SIGN: function()  {
        try {
            var _type = this.ATTR_SIGN;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:354:25: ( '@' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:354:27: '@'
            this.match('@'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "ATTR_SIGN",

    // $ANTLR start Q
    mQ: function()  {
        try {
            var _type = this.Q;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:355:25: ( 'Q' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:355:27: 'Q'
            this.match('Q'); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "Q",

    // $ANTLR start CHARREF_DEC
    mCHARREF_DEC: function()  {
        try {
            var _type = this.CHARREF_DEC;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:356:25: ( '&#' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:356:27: '&#'
            this.match("&#"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CHARREF_DEC",

    // $ANTLR start CHARREF_HEX
    mCHARREF_HEX: function()  {
        try {
            var _type = this.CHARREF_HEX;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:357:25: ( '&#x' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:357:27: '&#x'
            this.match("&#x"); 




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "CHARREF_HEX",

    // $ANTLR start APOS
    mAPOS: function()  {
        try {
            var _type = this.APOS;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:358:25: ( '\\'' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:358:27: '\\''
            this.match('\''); 
             if (!this.inStr) this.inStr = true; 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "APOS",

    // $ANTLR start QUOT
    mQUOT: function()  {
        try {
            var _type = this.QUOT;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:359:25: ( '\"' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:359:27: '\"'
            this.match('\"'); 
             if (!this.inStr) this.inStr = true; 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "QUOT",

    // $ANTLR start L_NCName
    mL_NCName: function()  {
        try {
            var _type = this.L_NCName;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:363:9: ( NCNameStartChar ( NCNameChar )* )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:363:13: NCNameStartChar ( NCNameChar )*
            this.mNCNameStartChar(); 
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:363:29: ( NCNameChar )*
            loop1:
            do {
                var alt1=2;
                var LA1_0 = this.input.LA(1);

                if ( ((LA1_0>='-' && LA1_0<='.')||(LA1_0>='0' && LA1_0<='9')||(LA1_0>='A' && LA1_0<='Z')||LA1_0=='_'||(LA1_0>='a' && LA1_0<='z')) ) {
                    alt1=1;
                }


                switch (alt1) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:363:29: NCNameChar
                    this.mNCNameChar(); 


                    break;

                default :
                    break loop1;
                }
            } while (true);




            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_NCName",

    // $ANTLR start Letter
    mLetter: function()  {
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:366:29: ( 'a' .. 'z' | 'A' .. 'Z' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:
            if ( (this.input.LA(1)>='A' && this.input.LA(1)<='Z')||(this.input.LA(1)>='a' && this.input.LA(1)<='z') ) {
                this.input.consume();

            }
            else {
                var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                this.recover(mse);
                throw mse;}




        }
        finally {
        }
    },
    // $ANTLR end "Letter",

    // $ANTLR start HexLetter
    mHexLetter: function()  {
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:367:29: ( 'a' .. 'f' | 'A' .. 'F' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:
            if ( (this.input.LA(1)>='A' && this.input.LA(1)<='F')||(this.input.LA(1)>='a' && this.input.LA(1)<='f') ) {
                this.input.consume();

            }
            else {
                var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                this.recover(mse);
                throw mse;}




        }
        finally {
        }
    },
    // $ANTLR end "HexLetter",

    // $ANTLR start Digit
    mDigit: function()  {
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:368:29: ( '0' .. '9' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:368:31: '0' .. '9'
            this.matchRange('0','9'); 



        }
        finally {
        }
    },
    // $ANTLR end "Digit",

    // $ANTLR start Digits
    mDigits: function()  {
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:369:29: ( ( Digit )+ )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:369:31: ( Digit )+
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:369:31: ( Digit )+
            var cnt2=0;
            loop2:
            do {
                var alt2=2;
                var LA2_0 = this.input.LA(1);

                if ( ((LA2_0>='0' && LA2_0<='9')) ) {
                    alt2=1;
                }


                switch (alt2) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:369:31: Digit
                    this.mDigit(); 


                    break;

                default :
                    if ( cnt2 >= 1 ) {
                        break loop2;
                    }
                        var eee = new org.antlr.runtime.EarlyExitException(2, this.input);
                        throw eee;
                }
                cnt2++;
            } while (true);




        }
        finally {
        }
    },
    // $ANTLR end "Digits",

    // $ANTLR start NCNameStartChar
    mNCNameStartChar: function()  {
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:371:29: ( Letter | '_' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:
            if ( (this.input.LA(1)>='A' && this.input.LA(1)<='Z')||this.input.LA(1)=='_'||(this.input.LA(1)>='a' && this.input.LA(1)<='z') ) {
                this.input.consume();

            }
            else {
                var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                this.recover(mse);
                throw mse;}




        }
        finally {
        }
    },
    // $ANTLR end "NCNameStartChar",

    // $ANTLR start NCNameChar
    mNCNameChar: function()  {
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:372:29: ( Letter | Digit | '.' | '-' | '_' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:
            if ( (this.input.LA(1)>='-' && this.input.LA(1)<='.')||(this.input.LA(1)>='0' && this.input.LA(1)<='9')||(this.input.LA(1)>='A' && this.input.LA(1)<='Z')||this.input.LA(1)=='_'||(this.input.LA(1)>='a' && this.input.LA(1)<='z') ) {
                this.input.consume();

            }
            else {
                var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                this.recover(mse);
                throw mse;}




        }
        finally {
        }
    },
    // $ANTLR end "NCNameChar",

    // $ANTLR start S
    mS: function()  {
        try {
            var _type = this.S;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:375:9: ( ( '\\t' | ' ' | '\\n' | '\\r' )+ )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:375:11: ( '\\t' | ' ' | '\\n' | '\\r' )+
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:375:11: ( '\\t' | ' ' | '\\n' | '\\r' )+
            var cnt3=0;
            loop3:
            do {
                var alt3=2;
                var LA3_0 = this.input.LA(1);

                if ( ((LA3_0>='\t' && LA3_0<='\n')||LA3_0=='\r'||LA3_0==' ') ) {
                    alt3=1;
                }


                switch (alt3) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:
                    if ( (this.input.LA(1)>='\t' && this.input.LA(1)<='\n')||this.input.LA(1)=='\r'||this.input.LA(1)==' ' ) {
                        this.input.consume();

                    }
                    else {
                        var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                        this.recover(mse);
                        throw mse;}



                    break;

                default :
                    if ( cnt3 >= 1 ) {
                        break loop3;
                    }
                        var eee = new org.antlr.runtime.EarlyExitException(3, this.input);
                        throw eee;
                }
                cnt3++;
            } while (true);

             _channel = HIDDEN; 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "S",

    // $ANTLR start SU
    mSU: function()  {
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:378:9: ( ( '\\t' | ' ' | '\\n' | '\\r' )+ )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:378:11: ( '\\t' | ' ' | '\\n' | '\\r' )+
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:378:11: ( '\\t' | ' ' | '\\n' | '\\r' )+
            var cnt4=0;
            loop4:
            do {
                var alt4=2;
                var LA4_0 = this.input.LA(1);

                if ( ((LA4_0>='\t' && LA4_0<='\n')||LA4_0=='\r'||LA4_0==' ') ) {
                    alt4=1;
                }


                switch (alt4) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:
                    if ( (this.input.LA(1)>='\t' && this.input.LA(1)<='\n')||this.input.LA(1)=='\r'||this.input.LA(1)==' ' ) {
                        this.input.consume();

                    }
                    else {
                        var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                        this.recover(mse);
                        throw mse;}



                    break;

                default :
                    if ( cnt4 >= 1 ) {
                        break loop4;
                    }
                        var eee = new org.antlr.runtime.EarlyExitException(4, this.input);
                        throw eee;
                }
                cnt4++;
            } while (true);




        }
        finally {
        }
    },
    // $ANTLR end "SU",

    // $ANTLR start L_Pragma
    mL_Pragma: function()  {
        try {
            var _type = this.L_Pragma;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:389:9: ( PRAGMA_START ( SU )? L_NCName COLON L_NCName ( SU ( options {greedy=false; } : . )* )? PRAGMA_END )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:389:11: PRAGMA_START ( SU )? L_NCName COLON L_NCName ( SU ( options {greedy=false; } : . )* )? PRAGMA_END
            this.mPRAGMA_START(); 
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:389:24: ( SU )?
            var alt5=2;
            var LA5_0 = this.input.LA(1);

            if ( ((LA5_0>='\t' && LA5_0<='\n')||LA5_0=='\r'||LA5_0==' ') ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:389:24: SU
                    this.mSU(); 


                    break;

            }

            this.mL_NCName(); 
            this.mCOLON(); 
            this.mL_NCName(); 
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:389:52: ( SU ( options {greedy=false; } : . )* )?
            var alt7=2;
            var LA7_0 = this.input.LA(1);

            if ( ((LA7_0>='\t' && LA7_0<='\n')||LA7_0=='\r'||LA7_0==' ') ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:389:53: SU ( options {greedy=false; } : . )*
                    this.mSU(); 
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:389:56: ( options {greedy=false; } : . )*
                    loop6:
                    do {
                        var alt6=2;
                        var LA6_0 = this.input.LA(1);

                        if ( (LA6_0=='#') ) {
                            var LA6_1 = this.input.LA(2);

                            if ( (LA6_1==')') ) {
                                alt6=2;
                            }
                            else if ( ((LA6_1>='\u0000' && LA6_1<='(')||(LA6_1>='*' && LA6_1<='\uFFFF')) ) {
                                alt6=1;
                            }


                        }
                        else if ( ((LA6_0>='\u0000' && LA6_0<='\"')||(LA6_0>='$' && LA6_0<='\uFFFF')) ) {
                            alt6=1;
                        }


                        switch (alt6) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:389:83: .
                            this.matchAny(); 


                            break;

                        default :
                            break loop6;
                        }
                    } while (true);



                    break;

            }

            this.mPRAGMA_END(); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_Pragma",

    // $ANTLR start L_DirCommentConstructor
    mL_DirCommentConstructor: function()  {
        try {
            var _type = this.L_DirCommentConstructor;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:399:9: ( XML_COMMENT_START ( options {greedy=false; } : ( . )* ) XML_COMMENT_END )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:399:11: XML_COMMENT_START ( options {greedy=false; } : ( . )* ) XML_COMMENT_END
            this.mXML_COMMENT_START(); 
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:399:29: ( options {greedy=false; } : ( . )* )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:399:56: ( . )*
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:399:56: ( . )*
            loop8:
            do {
                var alt8=2;
                var LA8_0 = this.input.LA(1);

                if ( (LA8_0=='-') ) {
                    var LA8_1 = this.input.LA(2);

                    if ( (LA8_1=='-') ) {
                        var LA8_3 = this.input.LA(3);

                        if ( (LA8_3=='>') ) {
                            alt8=2;
                        }
                        else if ( ((LA8_3>='\u0000' && LA8_3<='=')||(LA8_3>='?' && LA8_3<='\uFFFF')) ) {
                            alt8=1;
                        }


                    }
                    else if ( ((LA8_1>='\u0000' && LA8_1<=',')||(LA8_1>='.' && LA8_1<='\uFFFF')) ) {
                        alt8=1;
                    }


                }
                else if ( ((LA8_0>='\u0000' && LA8_0<=',')||(LA8_0>='.' && LA8_0<='\uFFFF')) ) {
                    alt8=1;
                }


                switch (alt8) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:399:56: .
                    this.matchAny(); 


                    break;

                default :
                    break loop8;
                }
            } while (true);




            this.mXML_COMMENT_END(); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_DirCommentConstructor",

    // $ANTLR start L_DirPIConstructor
    mL_DirPIConstructor: function()  {
        try {
            var _type = this.L_DirPIConstructor;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:9: ( PI_START ( SU )? L_NCName ( SU ( options {greedy=false; } : ( . )* ) )? PI_END )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:11: PI_START ( SU )? L_NCName ( SU ( options {greedy=false; } : ( . )* ) )? PI_END
            this.mPI_START(); 
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:20: ( SU )?
            var alt9=2;
            var LA9_0 = this.input.LA(1);

            if ( ((LA9_0>='\t' && LA9_0<='\n')||LA9_0=='\r'||LA9_0==' ') ) {
                alt9=1;
            }
            switch (alt9) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:20: SU
                    this.mSU(); 


                    break;

            }

            this.mL_NCName(); 
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:33: ( SU ( options {greedy=false; } : ( . )* ) )?
            var alt11=2;
            var LA11_0 = this.input.LA(1);

            if ( ((LA11_0>='\t' && LA11_0<='\n')||LA11_0=='\r'||LA11_0==' ') ) {
                alt11=1;
            }
            switch (alt11) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:34: SU ( options {greedy=false; } : ( . )* )
                    this.mSU(); 
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:36: ( options {greedy=false; } : ( . )* )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:63: ( . )*
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:63: ( . )*
                    loop10:
                    do {
                        var alt10=2;
                        var LA10_0 = this.input.LA(1);

                        if ( (LA10_0=='?') ) {
                            var LA10_1 = this.input.LA(2);

                            if ( (LA10_1=='>') ) {
                                alt10=2;
                            }
                            else if ( ((LA10_1>='\u0000' && LA10_1<='=')||(LA10_1>='?' && LA10_1<='\uFFFF')) ) {
                                alt10=1;
                            }


                        }
                        else if ( ((LA10_0>='\u0000' && LA10_0<='>')||(LA10_0>='@' && LA10_0<='\uFFFF')) ) {
                            alt10=1;
                        }


                        switch (alt10) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:408:63: .
                            this.matchAny(); 


                            break;

                        default :
                            break loop10;
                        }
                    } while (true);






                    break;

            }

            this.mPI_END(); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_DirPIConstructor",

    // $ANTLR start L_IntegerLiteral
    mL_IntegerLiteral: function()  {
        try {
            var _type = this.L_IntegerLiteral;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:416:9: ( Digits )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:416:13: Digits
            this.mDigits(); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_IntegerLiteral",

    // $ANTLR start L_DecimalLiteral
    mL_DecimalLiteral: function()  {
        try {
            var _type = this.L_DecimalLiteral;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:421:9: ( ( '.' Digits ) | ( Digits '.' ( Digit )* ) )
            var alt13=2;
            var LA13_0 = this.input.LA(1);

            if ( (LA13_0=='.') ) {
                alt13=1;
            }
            else if ( ((LA13_0>='0' && LA13_0<='9')) ) {
                alt13=2;
            }
            else {
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 13, 0, this.input);

                throw nvae;
            }
            switch (alt13) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:421:11: ( '.' Digits )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:421:11: ( '.' Digits )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:421:12: '.' Digits
                    this.match('.'); 
                    this.mDigits(); 





                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:421:26: ( Digits '.' ( Digit )* )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:421:26: ( Digits '.' ( Digit )* )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:421:27: Digits '.' ( Digit )*
                    this.mDigits(); 
                    this.match('.'); 
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:421:38: ( Digit )*
                    loop12:
                    do {
                        var alt12=2;
                        var LA12_0 = this.input.LA(1);

                        if ( ((LA12_0>='0' && LA12_0<='9')) ) {
                            alt12=1;
                        }


                        switch (alt12) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:421:38: Digit
                            this.mDigit(); 


                            break;

                        default :
                            break loop12;
                        }
                    } while (true);






                    break;

            }
            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_DecimalLiteral",

    // $ANTLR start L_DoubleLiteral
    mL_DoubleLiteral: function()  {
        try {
            var _type = this.L_DoubleLiteral;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:9: ( ( ( '.' Digits ) | ( Digits ( '.' ( Digit )* )? ) ) ( 'e' | 'E' ) ( '+' | '-' )? Digits )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:11: ( ( '.' Digits ) | ( Digits ( '.' ( Digit )* )? ) ) ( 'e' | 'E' ) ( '+' | '-' )? Digits
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:11: ( ( '.' Digits ) | ( Digits ( '.' ( Digit )* )? ) )
            var alt16=2;
            var LA16_0 = this.input.LA(1);

            if ( (LA16_0=='.') ) {
                alt16=1;
            }
            else if ( ((LA16_0>='0' && LA16_0<='9')) ) {
                alt16=2;
            }
            else {
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 16, 0, this.input);

                throw nvae;
            }
            switch (alt16) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:12: ( '.' Digits )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:12: ( '.' Digits )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:13: '.' Digits
                    this.match('.'); 
                    this.mDigits(); 





                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:27: ( Digits ( '.' ( Digit )* )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:27: ( Digits ( '.' ( Digit )* )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:28: Digits ( '.' ( Digit )* )?
                    this.mDigits(); 
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:35: ( '.' ( Digit )* )?
                    var alt15=2;
                    var LA15_0 = this.input.LA(1);

                    if ( (LA15_0=='.') ) {
                        alt15=1;
                    }
                    switch (alt15) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:36: '.' ( Digit )*
                            this.match('.'); 
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:40: ( Digit )*
                            loop14:
                            do {
                                var alt14=2;
                                var LA14_0 = this.input.LA(1);

                                if ( ((LA14_0>='0' && LA14_0<='9')) ) {
                                    alt14=1;
                                }


                                switch (alt14) {
                                case 1 :
                                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:40: Digit
                                    this.mDigit(); 


                                    break;

                                default :
                                    break loop14;
                                }
                            } while (true);



                            break;

                    }






                    break;

            }

            if ( this.input.LA(1)=='E'||this.input.LA(1)=='e' ) {
                this.input.consume();

            }
            else {
                var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                this.recover(mse);
                throw mse;}

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:426:63: ( '+' | '-' )?
            var alt17=2;
            var LA17_0 = this.input.LA(1);

            if ( (LA17_0=='+'||LA17_0=='-') ) {
                alt17=1;
            }
            switch (alt17) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:
                    if ( this.input.LA(1)=='+'||this.input.LA(1)=='-' ) {
                        this.input.consume();

                    }
                    else {
                        var mse = new org.antlr.runtime.MismatchedSetException(null,this.input);
                        this.recover(mse);
                        throw mse;}



                    break;

            }

            this.mDigits(); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_DoubleLiteral",

    // $ANTLR start L_Comment
    mL_Comment: function()  {
        try {
            var _type = this.L_Comment;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:431:9: ({...}? => '(:' ( options {greedy=false; } : L_Comment | . )* ':)' )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:431:11: {...}? => '(:' ( options {greedy=false; } : L_Comment | . )* ':)'
            if ( !((!this.inStr)) ) {
                throw new org.antlr.runtime.FailedPredicateException(this.input, "L_Comment", "!this.inStr");
            }
            this.match("(:"); 

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:431:33: ( options {greedy=false; } : L_Comment | . )*
            loop18:
            do {
                var alt18=3;
                var LA18_0 = this.input.LA(1);

                if ( (LA18_0==':') ) {
                    var LA18_1 = this.input.LA(2);

                    if ( (LA18_1==')') ) {
                        alt18=3;
                    }
                    else if ( ((LA18_1>='\u0000' && LA18_1<='(')||(LA18_1>='*' && LA18_1<='\uFFFF')) ) {
                        alt18=2;
                    }


                }
                else if ( (LA18_0=='(') ) {
                    var LA18_2 = this.input.LA(2);

                    if ( (LA18_2==':') ) {
                        var LA18_5 = this.input.LA(3);

                        if ( ((!this.inStr)) ) {
                            alt18=1;
                        }
                        else if ( (true) ) {
                            alt18=2;
                        }


                    }
                    else if ( ((LA18_2>='\u0000' && LA18_2<='9')||(LA18_2>=';' && LA18_2<='\uFFFF')) ) {
                        alt18=2;
                    }


                }
                else if ( ((LA18_0>='\u0000' && LA18_0<='\'')||(LA18_0>=')' && LA18_0<='9')||(LA18_0>=';' && LA18_0<='\uFFFF')) ) {
                    alt18=2;
                }


                switch (alt18) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:431:59: L_Comment
                    this.mL_Comment(); 


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:431:71: .
                    this.matchAny(); 


                    break;

                default :
                    break loop18;
                }
            } while (true);

            this.match(":)"); 

             _channel = HIDDEN; this.addComment(this.state.tokenStartCharIndex, (this.getCharIndex()-1)); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_Comment",

    // $ANTLR start L_AnyChar
    mL_AnyChar: function()  {
        try {
            var _type = this.L_AnyChar;
            var _channel = org.antlr.runtime.BaseRecognizer.DEFAULT_TOKEN_CHANNEL;
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:434:11: ( . )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:434:13: .
            this.matchAny(); 



            this.state.type = _type;
            this.state.channel = _channel;
        }
        finally {
        }
    },
    // $ANTLR end "L_AnyChar",

    mTokens: function() {
        // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:8: ( ANCESTOR | ANCESTOR_OR_SELF | AND | AS | ASCENDING | AT | ATTRIBUTE | BASE_URI | BOUNDARY_SPACE | BY | CASE | CAST | CASTABLE | CHILD | COLLATION | COMMENT | CONSTRUCTION | COPY_NAMESPACES | DECLARE | DEFAULT | DESCENDANT | DESCENDANT_OR_SELF | DESCENDING | DIV | DOCUMENT | DOCUMENT_NODE | ELEMENT | ELSE | EMPTY | EMPTY_SEQUENCE | ENCODING | EQ | EVERY | EXCEPT | EXTERNAL | FOLLOWING | FOLLOWING_SIBLING | FOR | FUNCTION | GE | GREATEST | GT | IDIV | IF | IMPORT | IN | INHERIT | INSTANCE | INTERSECT | IS | ITEM | LAX | LE | LEAST | LET | LT | MOD | MODULE | NAMESPACE | NE | NO_INHERIT | NO_PRESERVE | NODE | JSON | OF | OPTION | OR | ORDER | ORDERED | ORDERING | PARENT | PRECEDING | PRECEDING_SIBLING | PRESERVE | PROCESSING_INSTRUCTION | STRUCTURED_ITEM | JSON_ITEM | OBJECT | ARRAY | RETURN | SATISFIES | SCHEMA | SCHEMA_ATTRIBUTE | SCHEMA_ELEMENT | SELF | SOME | STABLE | STRICT | STRIP | TEXT | THEN | TO | TREAT | TYPESWITCH | UNION | UNORDERED | VALIDATE | VARIABLE | VERSION | WHERE | XQUERY | ALLOWING | CATCH | CONTEXT | COUNT | DECIMAL_FORMAT | DECIMAL_SEPARATOR | DIGIT | END | GROUP | GROUPING_SEPARATOR | INFINITY | MINUS_SIGN | NAMESPACE_NODE | NAN | NEXT | ONLY | PATTERN_SEPARATOR | PERCENT | PER_MILLE | PREVIOUS | SLIDING | START | SWITCH | TRY | TUMBLING | TYPE | WHEN | WINDOW | ZERO_DIGIT | AFTER | BEFORE | COPY | DELETE | FIRST | INSERT | INTO | POSITION | APPEND | LAST | MODIFY | NODES | RENAME | REPLACE | REVALIDATION | SKIP | UPDATING | VALUE | WITH | ALL | ANY | CONTAINS | CONTENT | DIACRITICS | DIFFERENT | DISTANCE | ENTIRE | EXACTLY | FROM | FT_OPTION | FTAND | FTNOT | FTOR | INSENSITIVE | LANGUAGE | LEVELS | LOWERCASE | MOST | NO | NOT | OCCURS | PARAGRAPH | PARAGRAPHS | PHRASE | RELATIONSHIP | SAME | SCORE | SENSITIVE | SENTENCE | SENTENCES | STEMMING | STOP | THESAURUS | TIMES | UPPERCASE | USING | WEIGHT | WILDCARDS | WITHOUT | WORD | WORDS | BREAK | CONTINUE | EXIT | LOOP | RETURNING | WHILE | CHECK | COLLECTION | CONSTRAINT | FOREACH | FOREIGN | INDEX | INTEGRITY | KEY | ON | UNIQUE | AMP_ER | APOS_ER | QUOT_ER | CONCAT | LPAREN | RPAREN | DOLLAR | L_UNION_BRACKET | R_UNION_BRACKET | LBRACKET | RBRACKET | LSQUARE | RSQUARE | EQUAL | BIND | NOTEQUAL | ANN_PERCENT | HASH | AMP | COMMA | QUESTION | STAR | PLUS | MINUS | SMALLER | GREATER | SMALLEREQ | GREATEREQ | SMALLER_SMALLER | GREATER_GREATER | SLASH | SLASH_SLASH | BANG | DOT | DOT_DOT | COLON | COLON_COLON | EMPTY_CLOSE_TAG | CLOSE_TAG | SEMICOLON | VBAR | PRAGMA_START | PRAGMA_END | XML_COMMENT_START | XML_COMMENT_END | PI_START | PI_END | ATTR_SIGN | Q | CHARREF_DEC | CHARREF_HEX | APOS | QUOT | L_NCName | S | L_Pragma | L_DirCommentConstructor | L_DirPIConstructor | L_IntegerLiteral | L_DecimalLiteral | L_DoubleLiteral | L_Comment | L_AnyChar )
        var alt19=270;
        alt19 = this.dfa19.predict(this.input);
        switch (alt19) {
            case 1 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:10: ANCESTOR
                this.mANCESTOR(); 


                break;
            case 2 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:19: ANCESTOR_OR_SELF
                this.mANCESTOR_OR_SELF(); 


                break;
            case 3 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:36: AND
                this.mAND(); 


                break;
            case 4 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:40: AS
                this.mAS(); 


                break;
            case 5 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:43: ASCENDING
                this.mASCENDING(); 


                break;
            case 6 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:53: AT
                this.mAT(); 


                break;
            case 7 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:56: ATTRIBUTE
                this.mATTRIBUTE(); 


                break;
            case 8 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:66: BASE_URI
                this.mBASE_URI(); 


                break;
            case 9 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:75: BOUNDARY_SPACE
                this.mBOUNDARY_SPACE(); 


                break;
            case 10 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:90: BY
                this.mBY(); 


                break;
            case 11 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:93: CASE
                this.mCASE(); 


                break;
            case 12 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:98: CAST
                this.mCAST(); 


                break;
            case 13 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:103: CASTABLE
                this.mCASTABLE(); 


                break;
            case 14 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:112: CHILD
                this.mCHILD(); 


                break;
            case 15 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:118: COLLATION
                this.mCOLLATION(); 


                break;
            case 16 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:128: COMMENT
                this.mCOMMENT(); 


                break;
            case 17 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:136: CONSTRUCTION
                this.mCONSTRUCTION(); 


                break;
            case 18 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:149: COPY_NAMESPACES
                this.mCOPY_NAMESPACES(); 


                break;
            case 19 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:165: DECLARE
                this.mDECLARE(); 


                break;
            case 20 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:173: DEFAULT
                this.mDEFAULT(); 


                break;
            case 21 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:181: DESCENDANT
                this.mDESCENDANT(); 


                break;
            case 22 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:192: DESCENDANT_OR_SELF
                this.mDESCENDANT_OR_SELF(); 


                break;
            case 23 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:211: DESCENDING
                this.mDESCENDING(); 


                break;
            case 24 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:222: DIV
                this.mDIV(); 


                break;
            case 25 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:226: DOCUMENT
                this.mDOCUMENT(); 


                break;
            case 26 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:235: DOCUMENT_NODE
                this.mDOCUMENT_NODE(); 


                break;
            case 27 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:249: ELEMENT
                this.mELEMENT(); 


                break;
            case 28 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:257: ELSE
                this.mELSE(); 


                break;
            case 29 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:262: EMPTY
                this.mEMPTY(); 


                break;
            case 30 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:268: EMPTY_SEQUENCE
                this.mEMPTY_SEQUENCE(); 


                break;
            case 31 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:283: ENCODING
                this.mENCODING(); 


                break;
            case 32 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:292: EQ
                this.mEQ(); 


                break;
            case 33 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:295: EVERY
                this.mEVERY(); 


                break;
            case 34 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:301: EXCEPT
                this.mEXCEPT(); 


                break;
            case 35 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:308: EXTERNAL
                this.mEXTERNAL(); 


                break;
            case 36 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:317: FOLLOWING
                this.mFOLLOWING(); 


                break;
            case 37 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:327: FOLLOWING_SIBLING
                this.mFOLLOWING_SIBLING(); 


                break;
            case 38 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:345: FOR
                this.mFOR(); 


                break;
            case 39 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:349: FUNCTION
                this.mFUNCTION(); 


                break;
            case 40 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:358: GE
                this.mGE(); 


                break;
            case 41 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:361: GREATEST
                this.mGREATEST(); 


                break;
            case 42 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:370: GT
                this.mGT(); 


                break;
            case 43 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:373: IDIV
                this.mIDIV(); 


                break;
            case 44 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:378: IF
                this.mIF(); 


                break;
            case 45 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:381: IMPORT
                this.mIMPORT(); 


                break;
            case 46 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:388: IN
                this.mIN(); 


                break;
            case 47 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:391: INHERIT
                this.mINHERIT(); 


                break;
            case 48 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:399: INSTANCE
                this.mINSTANCE(); 


                break;
            case 49 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:408: INTERSECT
                this.mINTERSECT(); 


                break;
            case 50 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:418: IS
                this.mIS(); 


                break;
            case 51 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:421: ITEM
                this.mITEM(); 


                break;
            case 52 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:426: LAX
                this.mLAX(); 


                break;
            case 53 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:430: LE
                this.mLE(); 


                break;
            case 54 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:433: LEAST
                this.mLEAST(); 


                break;
            case 55 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:439: LET
                this.mLET(); 


                break;
            case 56 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:443: LT
                this.mLT(); 


                break;
            case 57 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:446: MOD
                this.mMOD(); 


                break;
            case 58 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:450: MODULE
                this.mMODULE(); 


                break;
            case 59 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:457: NAMESPACE
                this.mNAMESPACE(); 


                break;
            case 60 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:467: NE
                this.mNE(); 


                break;
            case 61 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:470: NO_INHERIT
                this.mNO_INHERIT(); 


                break;
            case 62 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:481: NO_PRESERVE
                this.mNO_PRESERVE(); 


                break;
            case 63 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:493: NODE
                this.mNODE(); 


                break;
            case 64 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:498: JSON
                this.mJSON(); 


                break;
            case 65 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:503: OF
                this.mOF(); 


                break;
            case 66 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:506: OPTION
                this.mOPTION(); 


                break;
            case 67 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:513: OR
                this.mOR(); 


                break;
            case 68 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:516: ORDER
                this.mORDER(); 


                break;
            case 69 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:522: ORDERED
                this.mORDERED(); 


                break;
            case 70 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:530: ORDERING
                this.mORDERING(); 


                break;
            case 71 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:539: PARENT
                this.mPARENT(); 


                break;
            case 72 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:546: PRECEDING
                this.mPRECEDING(); 


                break;
            case 73 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:556: PRECEDING_SIBLING
                this.mPRECEDING_SIBLING(); 


                break;
            case 74 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:574: PRESERVE
                this.mPRESERVE(); 


                break;
            case 75 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:583: PROCESSING_INSTRUCTION
                this.mPROCESSING_INSTRUCTION(); 


                break;
            case 76 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:606: STRUCTURED_ITEM
                this.mSTRUCTURED_ITEM(); 


                break;
            case 77 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:622: JSON_ITEM
                this.mJSON_ITEM(); 


                break;
            case 78 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:632: OBJECT
                this.mOBJECT(); 


                break;
            case 79 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:639: ARRAY
                this.mARRAY(); 


                break;
            case 80 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:645: RETURN
                this.mRETURN(); 


                break;
            case 81 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:652: SATISFIES
                this.mSATISFIES(); 


                break;
            case 82 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:662: SCHEMA
                this.mSCHEMA(); 


                break;
            case 83 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:669: SCHEMA_ATTRIBUTE
                this.mSCHEMA_ATTRIBUTE(); 


                break;
            case 84 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:686: SCHEMA_ELEMENT
                this.mSCHEMA_ELEMENT(); 


                break;
            case 85 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:701: SELF
                this.mSELF(); 


                break;
            case 86 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:706: SOME
                this.mSOME(); 


                break;
            case 87 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:711: STABLE
                this.mSTABLE(); 


                break;
            case 88 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:718: STRICT
                this.mSTRICT(); 


                break;
            case 89 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:725: STRIP
                this.mSTRIP(); 


                break;
            case 90 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:731: TEXT
                this.mTEXT(); 


                break;
            case 91 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:736: THEN
                this.mTHEN(); 


                break;
            case 92 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:741: TO
                this.mTO(); 


                break;
            case 93 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:744: TREAT
                this.mTREAT(); 


                break;
            case 94 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:750: TYPESWITCH
                this.mTYPESWITCH(); 


                break;
            case 95 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:761: UNION
                this.mUNION(); 


                break;
            case 96 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:767: UNORDERED
                this.mUNORDERED(); 


                break;
            case 97 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:777: VALIDATE
                this.mVALIDATE(); 


                break;
            case 98 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:786: VARIABLE
                this.mVARIABLE(); 


                break;
            case 99 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:795: VERSION
                this.mVERSION(); 


                break;
            case 100 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:803: WHERE
                this.mWHERE(); 


                break;
            case 101 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:809: XQUERY
                this.mXQUERY(); 


                break;
            case 102 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:816: ALLOWING
                this.mALLOWING(); 


                break;
            case 103 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:825: CATCH
                this.mCATCH(); 


                break;
            case 104 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:831: CONTEXT
                this.mCONTEXT(); 


                break;
            case 105 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:839: COUNT
                this.mCOUNT(); 


                break;
            case 106 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:845: DECIMAL_FORMAT
                this.mDECIMAL_FORMAT(); 


                break;
            case 107 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:860: DECIMAL_SEPARATOR
                this.mDECIMAL_SEPARATOR(); 


                break;
            case 108 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:878: DIGIT
                this.mDIGIT(); 


                break;
            case 109 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:884: END
                this.mEND(); 


                break;
            case 110 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:888: GROUP
                this.mGROUP(); 


                break;
            case 111 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:894: GROUPING_SEPARATOR
                this.mGROUPING_SEPARATOR(); 


                break;
            case 112 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:913: INFINITY
                this.mINFINITY(); 


                break;
            case 113 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:922: MINUS_SIGN
                this.mMINUS_SIGN(); 


                break;
            case 114 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:933: NAMESPACE_NODE
                this.mNAMESPACE_NODE(); 


                break;
            case 115 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:948: NAN
                this.mNAN(); 


                break;
            case 116 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:952: NEXT
                this.mNEXT(); 


                break;
            case 117 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:957: ONLY
                this.mONLY(); 


                break;
            case 118 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:962: PATTERN_SEPARATOR
                this.mPATTERN_SEPARATOR(); 


                break;
            case 119 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:980: PERCENT
                this.mPERCENT(); 


                break;
            case 120 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:988: PER_MILLE
                this.mPER_MILLE(); 


                break;
            case 121 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:998: PREVIOUS
                this.mPREVIOUS(); 


                break;
            case 122 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1007: SLIDING
                this.mSLIDING(); 


                break;
            case 123 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1015: START
                this.mSTART(); 


                break;
            case 124 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1021: SWITCH
                this.mSWITCH(); 


                break;
            case 125 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1028: TRY
                this.mTRY(); 


                break;
            case 126 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1032: TUMBLING
                this.mTUMBLING(); 


                break;
            case 127 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1041: TYPE
                this.mTYPE(); 


                break;
            case 128 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1046: WHEN
                this.mWHEN(); 


                break;
            case 129 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1051: WINDOW
                this.mWINDOW(); 


                break;
            case 130 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1058: ZERO_DIGIT
                this.mZERO_DIGIT(); 


                break;
            case 131 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1069: AFTER
                this.mAFTER(); 


                break;
            case 132 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1075: BEFORE
                this.mBEFORE(); 


                break;
            case 133 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1082: COPY
                this.mCOPY(); 


                break;
            case 134 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1087: DELETE
                this.mDELETE(); 


                break;
            case 135 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1094: FIRST
                this.mFIRST(); 


                break;
            case 136 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1100: INSERT
                this.mINSERT(); 


                break;
            case 137 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1107: INTO
                this.mINTO(); 


                break;
            case 138 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1112: POSITION
                this.mPOSITION(); 


                break;
            case 139 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1121: APPEND
                this.mAPPEND(); 


                break;
            case 140 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1128: LAST
                this.mLAST(); 


                break;
            case 141 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1133: MODIFY
                this.mMODIFY(); 


                break;
            case 142 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1140: NODES
                this.mNODES(); 


                break;
            case 143 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1146: RENAME
                this.mRENAME(); 


                break;
            case 144 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1153: REPLACE
                this.mREPLACE(); 


                break;
            case 145 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1161: REVALIDATION
                this.mREVALIDATION(); 


                break;
            case 146 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1174: SKIP
                this.mSKIP(); 


                break;
            case 147 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1179: UPDATING
                this.mUPDATING(); 


                break;
            case 148 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1188: VALUE
                this.mVALUE(); 


                break;
            case 149 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1194: WITH
                this.mWITH(); 


                break;
            case 150 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1199: ALL
                this.mALL(); 


                break;
            case 151 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1203: ANY
                this.mANY(); 


                break;
            case 152 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1207: CONTAINS
                this.mCONTAINS(); 


                break;
            case 153 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1216: CONTENT
                this.mCONTENT(); 


                break;
            case 154 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1224: DIACRITICS
                this.mDIACRITICS(); 


                break;
            case 155 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1235: DIFFERENT
                this.mDIFFERENT(); 


                break;
            case 156 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1245: DISTANCE
                this.mDISTANCE(); 


                break;
            case 157 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1254: ENTIRE
                this.mENTIRE(); 


                break;
            case 158 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1261: EXACTLY
                this.mEXACTLY(); 


                break;
            case 159 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1269: FROM
                this.mFROM(); 


                break;
            case 160 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1274: FT_OPTION
                this.mFT_OPTION(); 


                break;
            case 161 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1284: FTAND
                this.mFTAND(); 


                break;
            case 162 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1290: FTNOT
                this.mFTNOT(); 


                break;
            case 163 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1296: FTOR
                this.mFTOR(); 


                break;
            case 164 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1301: INSENSITIVE
                this.mINSENSITIVE(); 


                break;
            case 165 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1313: LANGUAGE
                this.mLANGUAGE(); 


                break;
            case 166 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1322: LEVELS
                this.mLEVELS(); 


                break;
            case 167 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1329: LOWERCASE
                this.mLOWERCASE(); 


                break;
            case 168 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1339: MOST
                this.mMOST(); 


                break;
            case 169 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1344: NO
                this.mNO(); 


                break;
            case 170 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1347: NOT
                this.mNOT(); 


                break;
            case 171 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1351: OCCURS
                this.mOCCURS(); 


                break;
            case 172 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1358: PARAGRAPH
                this.mPARAGRAPH(); 


                break;
            case 173 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1368: PARAGRAPHS
                this.mPARAGRAPHS(); 


                break;
            case 174 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1379: PHRASE
                this.mPHRASE(); 


                break;
            case 175 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1386: RELATIONSHIP
                this.mRELATIONSHIP(); 


                break;
            case 176 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1399: SAME
                this.mSAME(); 


                break;
            case 177 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1404: SCORE
                this.mSCORE(); 


                break;
            case 178 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1410: SENSITIVE
                this.mSENSITIVE(); 


                break;
            case 179 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1420: SENTENCE
                this.mSENTENCE(); 


                break;
            case 180 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1429: SENTENCES
                this.mSENTENCES(); 


                break;
            case 181 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1439: STEMMING
                this.mSTEMMING(); 


                break;
            case 182 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1448: STOP
                this.mSTOP(); 


                break;
            case 183 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1453: THESAURUS
                this.mTHESAURUS(); 


                break;
            case 184 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1463: TIMES
                this.mTIMES(); 


                break;
            case 185 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1469: UPPERCASE
                this.mUPPERCASE(); 


                break;
            case 186 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1479: USING
                this.mUSING(); 


                break;
            case 187 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1485: WEIGHT
                this.mWEIGHT(); 


                break;
            case 188 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1492: WILDCARDS
                this.mWILDCARDS(); 


                break;
            case 189 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1502: WITHOUT
                this.mWITHOUT(); 


                break;
            case 190 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1510: WORD
                this.mWORD(); 


                break;
            case 191 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1515: WORDS
                this.mWORDS(); 


                break;
            case 192 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1521: BREAK
                this.mBREAK(); 


                break;
            case 193 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1527: CONTINUE
                this.mCONTINUE(); 


                break;
            case 194 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1536: EXIT
                this.mEXIT(); 


                break;
            case 195 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1541: LOOP
                this.mLOOP(); 


                break;
            case 196 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1546: RETURNING
                this.mRETURNING(); 


                break;
            case 197 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1556: WHILE
                this.mWHILE(); 


                break;
            case 198 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1562: CHECK
                this.mCHECK(); 


                break;
            case 199 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1568: COLLECTION
                this.mCOLLECTION(); 


                break;
            case 200 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1579: CONSTRAINT
                this.mCONSTRAINT(); 


                break;
            case 201 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1590: FOREACH
                this.mFOREACH(); 


                break;
            case 202 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1598: FOREIGN
                this.mFOREIGN(); 


                break;
            case 203 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1606: INDEX
                this.mINDEX(); 


                break;
            case 204 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1612: INTEGRITY
                this.mINTEGRITY(); 


                break;
            case 205 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1622: KEY
                this.mKEY(); 


                break;
            case 206 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1626: ON
                this.mON(); 


                break;
            case 207 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1629: UNIQUE
                this.mUNIQUE(); 


                break;
            case 208 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1636: AMP_ER
                this.mAMP_ER(); 


                break;
            case 209 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1643: APOS_ER
                this.mAPOS_ER(); 


                break;
            case 210 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1651: QUOT_ER
                this.mQUOT_ER(); 


                break;
            case 211 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1659: CONCAT
                this.mCONCAT(); 


                break;
            case 212 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1666: LPAREN
                this.mLPAREN(); 


                break;
            case 213 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1673: RPAREN
                this.mRPAREN(); 


                break;
            case 214 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1680: DOLLAR
                this.mDOLLAR(); 


                break;
            case 215 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1687: L_UNION_BRACKET
                this.mL_UNION_BRACKET(); 


                break;
            case 216 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1703: R_UNION_BRACKET
                this.mR_UNION_BRACKET(); 


                break;
            case 217 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1719: LBRACKET
                this.mLBRACKET(); 


                break;
            case 218 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1728: RBRACKET
                this.mRBRACKET(); 


                break;
            case 219 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1737: LSQUARE
                this.mLSQUARE(); 


                break;
            case 220 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1745: RSQUARE
                this.mRSQUARE(); 


                break;
            case 221 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1753: EQUAL
                this.mEQUAL(); 


                break;
            case 222 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1759: BIND
                this.mBIND(); 


                break;
            case 223 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1764: NOTEQUAL
                this.mNOTEQUAL(); 


                break;
            case 224 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1773: ANN_PERCENT
                this.mANN_PERCENT(); 


                break;
            case 225 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1785: HASH
                this.mHASH(); 


                break;
            case 226 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1790: AMP
                this.mAMP(); 


                break;
            case 227 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1794: COMMA
                this.mCOMMA(); 


                break;
            case 228 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1800: QUESTION
                this.mQUESTION(); 


                break;
            case 229 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1809: STAR
                this.mSTAR(); 


                break;
            case 230 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1814: PLUS
                this.mPLUS(); 


                break;
            case 231 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1819: MINUS
                this.mMINUS(); 


                break;
            case 232 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1825: SMALLER
                this.mSMALLER(); 


                break;
            case 233 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1833: GREATER
                this.mGREATER(); 


                break;
            case 234 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1841: SMALLEREQ
                this.mSMALLEREQ(); 


                break;
            case 235 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1851: GREATEREQ
                this.mGREATEREQ(); 


                break;
            case 236 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1861: SMALLER_SMALLER
                this.mSMALLER_SMALLER(); 


                break;
            case 237 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1877: GREATER_GREATER
                this.mGREATER_GREATER(); 


                break;
            case 238 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1893: SLASH
                this.mSLASH(); 


                break;
            case 239 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1899: SLASH_SLASH
                this.mSLASH_SLASH(); 


                break;
            case 240 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1911: BANG
                this.mBANG(); 


                break;
            case 241 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1916: DOT
                this.mDOT(); 


                break;
            case 242 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1920: DOT_DOT
                this.mDOT_DOT(); 


                break;
            case 243 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1928: COLON
                this.mCOLON(); 


                break;
            case 244 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1934: COLON_COLON
                this.mCOLON_COLON(); 


                break;
            case 245 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1946: EMPTY_CLOSE_TAG
                this.mEMPTY_CLOSE_TAG(); 


                break;
            case 246 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1962: CLOSE_TAG
                this.mCLOSE_TAG(); 


                break;
            case 247 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1972: SEMICOLON
                this.mSEMICOLON(); 


                break;
            case 248 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1982: VBAR
                this.mVBAR(); 


                break;
            case 249 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:1987: PRAGMA_START
                this.mPRAGMA_START(); 


                break;
            case 250 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2000: PRAGMA_END
                this.mPRAGMA_END(); 


                break;
            case 251 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2011: XML_COMMENT_START
                this.mXML_COMMENT_START(); 


                break;
            case 252 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2029: XML_COMMENT_END
                this.mXML_COMMENT_END(); 


                break;
            case 253 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2045: PI_START
                this.mPI_START(); 


                break;
            case 254 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2054: PI_END
                this.mPI_END(); 


                break;
            case 255 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2061: ATTR_SIGN
                this.mATTR_SIGN(); 


                break;
            case 256 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2071: Q
                this.mQ(); 


                break;
            case 257 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2073: CHARREF_DEC
                this.mCHARREF_DEC(); 


                break;
            case 258 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2085: CHARREF_HEX
                this.mCHARREF_HEX(); 


                break;
            case 259 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2097: APOS
                this.mAPOS(); 


                break;
            case 260 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2102: QUOT
                this.mQUOT(); 


                break;
            case 261 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2107: L_NCName
                this.mL_NCName(); 


                break;
            case 262 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2116: S
                this.mS(); 


                break;
            case 263 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2118: L_Pragma
                this.mL_Pragma(); 


                break;
            case 264 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2127: L_DirCommentConstructor
                this.mL_DirCommentConstructor(); 


                break;
            case 265 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2151: L_DirPIConstructor
                this.mL_DirPIConstructor(); 


                break;
            case 266 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2170: L_IntegerLiteral
                this.mL_IntegerLiteral(); 


                break;
            case 267 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2187: L_DecimalLiteral
                this.mL_DecimalLiteral(); 


                break;
            case 268 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2204: L_DoubleLiteral
                this.mL_DoubleLiteral(); 


                break;
            case 269 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2220: L_Comment
                this.mL_Comment(); 


                break;
            case 270 :
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryLexer.g:1:2230: L_AnyChar
                this.mL_AnyChar(); 


                break;

        }

    }

}, true); // important to pass true to overwrite default implementations

org.antlr.lang.augmentObject(XQueryLexer, {
    DFA19_eotS:
        "\u0001\uffff\u0019\u0042\u0001\u0097\u0001\u009a\u0002\uffff\u0001"+
    "\u009e\u0004\uffff\u0001\u00a5\u0001\u00a7\u0001\uffff\u0001\u00aa\u0001"+
    "\u00ac\u0001\uffff\u0001\u00af\u0002\uffff\u0001\u00b3\u0001\u00b9\u0001"+
    "\u00bc\u0001\u00bf\u0001\u00c1\u0002\uffff\u0001\u00c5\u0004\uffff\u0001"+
    "\u00c9\u0001\uffff\u0001\u0042\u0001\u00d1\u0001\u00d3\u0005\u0042\u0001"+
    "\uffff\u0002\u0042\u0001\u00dc\u000b\u0042\u0001\u00f8\u0007\u0042\u0001"+
    "\u0107\u0001\u0042\u0001\u010a\u0001\u0042\u0001\u010c\u0001\u0042\u0001"+
    "\u0113\u0001\u0114\u0002\u0042\u0001\u011c\u0001\u011d\u0004\u0042\u0001"+
    "\u0125\u0001\u0129\u0001\u0042\u0001\u012b\u0001\u0042\u0001\u012e\u0001"+
    "\u0042\u0001\u0131\u0011\u0042\u0001\u014f\u0012\u0042\u0003\uffff\u0001"+
    "\u0169\u0012\uffff\u0001\u016c\u000c\uffff\u0001\u016e\u0009\uffff\u0001"+
    "\u0170\u0007\uffff\u0001\u00c9\u0001\u0170\u0001\uffff\u0001\u0042\u0001"+
    "\u0173\u0001\u0174\u0001\u0042\u0001\uffff\u0001\u0042\u0001\uffff\u0001"+
    "\u0042\u0001\u0179\u0003\u0042\u0001\u017d\u0002\u0042\u0001\uffff\u000f"+
    "\u0042\u0001\u0192\u0009\u0042\u0001\u019c\u0001\u0042\u0001\uffff\u0006"+
    "\u0042\u0001\u01a5\u0007\u0042\u0001\uffff\u0002\u0042\u0001\uffff\u0001"+
    "\u0042\u0001\uffff\u0006\u0042\u0002\uffff\u0001\u0042\u0001\u01b9\u0003"+
    "\u0042\u0001\u01bd\u0001\u0042\u0002\uffff\u0002\u0042\u0001\u01c3\u0004"+
    "\u0042\u0001\uffff\u0002\u0042\u0001\u01cb\u0001\uffff\u0001\u0042\u0001"+
    "\uffff\u0002\u0042\u0001\uffff\u0002\u0042\u0001\uffff\u001d\u0042\u0001"+
    "\uffff\u0001\u0042\u0001\u01f7\u0013\u0042\u0001\u020e\u0001\u0042\u0001"+
    "\u0210\u0001\u0042\u0008\uffff\u0001\u0170\u0001\u0042\u0002\uffff\u0004"+
    "\u0042\u0001\uffff\u0002\u0042\u0001\u021a\u0001\uffff\u0004\u0042\u0001"+
    "\u021f\u0001\u0221\u0007\u0042\u0001\u022d\u0006\u0042\u0001\uffff\u0006"+
    "\u0042\u0001\u023a\u0002\u0042\u0001\uffff\u0005\u0042\u0001\u0242\u0002"+
    "\u0042\u0001\uffff\u0002\u0042\u0001\u0248\u0003\u0042\u0001\u024c\u0002"+
    "\u0042\u0001\u024f\u0005\u0042\u0001\u0257\u0002\u0042\u0001\u025a\u0001"+
    "\uffff\u0001\u025b\u0002\u0042\u0001\uffff\u0002\u0042\u0001\u0260\u0002"+
    "\u0042\u0001\uffff\u0001\u0263\u0002\u0042\u0001\u0266\u0002\u0042\u0001"+
    "\u026a\u0001\uffff\u0001\u026c\u0003\u0042\u0001\u0270\u0011\u0042\u0001"+
    "\u0283\u0001\u0042\u0001\u0285\u0002\u0042\u0001\u0288\u0002\u0042\u0001"+
    "\u028b\u0002\u0042\u0001\u028e\u0005\u0042\u0001\u0294\u0001\u0295\u0002"+
    "\u0042\u0001\uffff\u0001\u0299\u000d\u0042\u0001\u02a7\u0002\u0042\u0001"+
    "\u02ab\u0002\u0042\u0001\u02af\u0001\u0042\u0001\uffff\u0001\u0042\u0001"+
    "\uffff\u0001\u02b2\u0001\u02b3\u0003\u0042\u0001\u02b8\u0001\u0042\u0001"+
    "\u02ba\u0001\u0042\u0001\uffff\u0003\u0042\u0001\u02bf\u0001\uffff\u0001"+
    "\u0042\u0001\uffff\u0001\u02c1\u0001\u02c2\u0001\u02c3\u0008\u0042\u0001"+
    "\uffff\u0001\u02cd\u0005\u0042\u0001\u02d3\u0005\u0042\u0001\uffff\u0001"+
    "\u02da\u0002\u0042\u0001\u02dd\u0003\u0042\u0001\uffff\u0004\u0042\u0001"+
    "\u02e5\u0001\uffff\u0001\u0042\u0001\u02e7\u0001\u02e8\u0001\uffff\u0001"+
    "\u0042\u0001\u02eb\u0001\uffff\u0007\u0042\u0001\uffff\u0001\u0042\u0001"+
    "\u02f4\u0002\uffff\u0001\u0042\u0001\u02f6\u0002\u0042\u0001\uffff\u0002"+
    "\u0042\u0001\uffff\u0002\u0042\u0001\uffff\u0002\u0042\u0001\u02ff\u0001"+
    "\uffff\u0001\u0042\u0001\uffff\u0001\u0042\u0001\u0304\u0001\u0042\u0001"+
    "\uffff\u000e\u0042\u0001\u0314\u0001\u0042\u0001\u0316\u0001\u0042\u0001"+
    "\uffff\u0001\u0042\u0001\uffff\u0001\u0042\u0001\u031a\u0001\uffff\u0002"+
    "\u0042\u0001\uffff\u0002\u0042\u0001\uffff\u0005\u0042\u0002\uffff\u0001"+
    "\u0042\u0001\u0325\u0001\u0042\u0001\uffff\u0001\u0042\u0001\u0328\u0001"+
    "\u0329\u0004\u0042\u0001\u032e\u0001\u0042\u0001\u0330\u0002\u0042\u0001"+
    "\u0333\u0001\uffff\u0001\u0334\u0002\u0042\u0001\uffff\u0002\u0042\u0001"+
    "\u0339\u0001\uffff\u0002\u0042\u0003\uffff\u0003\u0042\u0001\uffff\u0001"+
    "\u0042\u0001\uffff\u0001\u0340\u0002\u0042\u0001\u0343\u0001\uffff\u0001"+
    "\u0042\u0003\uffff\u0009\u0042\u0001\uffff\u0004\u0042\u0001\u0353\u0001"+
    "\uffff\u0006\u0042\u0001\uffff\u0001\u0042\u0001\u035b\u0001\uffff\u0001"+
    "\u035c\u0006\u0042\u0001\uffff\u0001\u0042\u0002\uffff\u0002\u0042\u0001"+
    "\uffff\u0001\u0366\u0002\u0042\u0001\u0369\u0004\u0042\u0001\uffff\u0001"+
    "\u0042\u0001\uffff\u0001\u036f\u0001\u0042\u0001\u0371\u0001\u0372\u0004"+
    "\u0042\u0001\uffff\u0001\u0042\u0001\u0378\u0002\u0042\u0001\uffff\u0001"+
    "\u037b\u0001\u037c\u0001\u037d\u0009\u0042\u0001\u0387\u0001\u0042\u0001"+
    "\u0389\u0001\uffff\u0001\u038a\u0001\uffff\u0002\u0042\u0001\u038e\u0001"+
    "\uffff\u0003\u0042\u0001\u0392\u0001\u0394\u0001\u0395\u0004\u0042\u0001"+
    "\uffff\u0002\u0042\u0002\uffff\u0001\u039c\u0003\u0042\u0001\uffff\u0001"+
    "\u0042\u0001\uffff\u0002\u0042\u0002\uffff\u0001\u03a3\u0002\u0042\u0001"+
    "\u03a6\u0001\uffff\u0001\u03a7\u0005\u0042\u0001\uffff\u0002\u0042\u0001"+
    "\uffff\u0003\u0042\u0001\u03b2\u0002\u0042\u0001\u03b5\u0001\u03b6\u0003"+
    "\u0042\u0001\u03ba\u0001\u0042\u0001\u03bc\u0001\u0042\u0001\uffff\u0004"+
    "\u0042\u0001\u03c3\u0002\u0042\u0002\uffff\u0001\u0042\u0001\u03c7\u0001"+
    "\u0042\u0001\u03c9\u0001\u03ca\u0004\u0042\u0001\uffff\u0001\u03cf\u0001"+
    "\u0042\u0001\uffff\u0005\u0042\u0001\uffff\u0001\u0042\u0002\uffff\u0005"+
    "\u0042\u0001\uffff\u0001\u03dc\u0001\u0042\u0003\uffff\u0006\u0042\u0001"+
    "\u03e4\u0002\u0042\u0001\uffff\u0001\u0042\u0002\uffff\u0003\u0042\u0001"+
    "\uffff\u0002\u0042\u0001\u03ee\u0001\uffff\u0001\u0042\u0002\uffff\u0001"+
    "\u03f0\u0005\u0042\u0001\uffff\u0005\u0042\u0001\u03fb\u0001\uffff\u0001"+
    "\u03fc\u0001\u0042\u0002\uffff\u0001\u0042\u0001\u0400\u0002\u0042\u0001"+
    "\u0403\u0001\u0404\u0001\u0042\u0001\u0406\u0002\u0042\u0001\uffff\u0002"+
    "\u0042\u0002\uffff\u0001\u040b\u0001\u040c\u0001\u0042\u0001\uffff\u0001"+
    "\u0042\u0001\uffff\u0004\u0042\u0001\u0414\u0001\u0416\u0001\uffff\u0001"+
    "\u0042\u0001\u0418\u0001\u0419\u0001\uffff\u0001\u0042\u0002\uffff\u0001"+
    "\u041b\u0001\u0042\u0001\u041d\u0001\u0042\u0001\uffff\u0001\u041f\u0003"+
    "\u0042\u0001\u0423\u0001\u0424\u0006\u0042\u0001\uffff\u0001\u042b\u0003"+
    "\u0042\u0001\u042f\u0001\u0430\u0001\u0042\u0001\uffff\u0001\u0042\u0001"+
    "\u0433\u0001\u0042\u0001\u0435\u0004\u0042\u0001\u043b\u0001\uffff\u0001"+
    "\u0042\u0001\uffff\u0004\u0042\u0001\u0441\u0001\u0042\u0001\u0443\u0001"+
    "\u0042\u0001\u0445\u0001\u0446\u0002\uffff\u0003\u0042\u0001\uffff\u0001"+
    "\u044a\u0001\u044b\u0002\uffff\u0001\u0042\u0001\uffff\u0001\u044d\u0003"+
    "\u0042\u0002\uffff\u0006\u0042\u0001\u0457\u0001\uffff\u0001\u0042\u0001"+
    "\uffff\u0001\u0042\u0002\uffff\u0001\u045b\u0001\uffff\u0001\u045c\u0001"+
    "\uffff\u0001\u0042\u0001\uffff\u0001\u0042\u0001\u045f\u0001\u0460\u0002"+
    "\uffff\u0001\u0461\u0001\u0042\u0001\u0464\u0002\u0042\u0001\u0467\u0001"+
    "\uffff\u0001\u0469\u0001\u0042\u0001\u046c\u0002\uffff\u0001\u0042\u0001"+
    "\u046e\u0001\uffff\u0001\u0042\u0001\uffff\u0001\u0470\u0002\u0042\u0001"+
    "\u0473\u0001\u0474\u0001\uffff\u0001\u0475\u0002\u0042\u0001\u0478\u0001"+
    "\u0042\u0001\uffff\u0001\u047a\u0001\uffff\u0001\u047b\u0002\uffff\u0001"+
    "\u047c\u0002\u0042\u0002\uffff\u0001\u0042\u0001\uffff\u0001\u0480\u0001"+
    "\u0042\u0001\u0482\u0003\u0042\u0001\u0487\u0001\u0488\u0001\u0489\u0001"+
    "\uffff\u0003\u0042\u0002\uffff\u0002\u0042\u0003\uffff\u0001\u048f\u0001"+
    "\u0042\u0001\uffff\u0001\u0491\u0001\u0042\u0001\uffff\u0001\u0493\u0001"+
    "\uffff\u0002\u0042\u0001\uffff\u0001\u0042\u0001\uffff\u0001\u0042\u0001"+
    "\uffff\u0002\u0042\u0003\uffff\u0002\u0042\u0001\uffff\u0001\u049c\u0003"+
    "\uffff\u0001\u049d\u0002\u0042\u0001\uffff\u0001\u0042\u0001\uffff\u0004"+
    "\u0042\u0003\uffff\u0004\u0042\u0001\u04a9\u0001\uffff\u0001\u0042\u0001"+
    "\uffff\u0001\u04ab\u0001\uffff\u0008\u0042\u0002\uffff\u0002\u0042\u0001"+
    "\u04b6\u0008\u0042\u0001\uffff\u0001\u0042\u0001\uffff\u0006\u0042\u0001"+
    "\u04c6\u0001\u04c7\u0002\u0042\u0001\uffff\u0004\u0042\u0001\u04ce\u000a"+
    "\u0042\u0002\uffff\u0001\u0042\u0001\u04da\u0001\u0042\u0001\u04dc\u0002"+
    "\u0042\u0001\uffff\u0001\u04df\u0002\u0042\u0001\u04e2\u0005\u0042\u0001"+
    "\u04e8\u0001\u0042\u0001\uffff\u0001\u04ea\u0001\uffff\u0002\u0042\u0001"+
    "\uffff\u0002\u0042\u0001\uffff\u0003\u0042\u0001\u04f2\u0001\u0042\u0001"+
    "\uffff\u0001\u04f4\u0001\uffff\u0007\u0042\u0001\uffff\u0001\u04fc\u0001"+
    "\uffff\u0001\u04fd\u0001\u0042\u0001\u04ff\u0001\u0042\u0001\u0501\u0001"+
    "\u0502\u0001\u0042\u0002\uffff\u0001\u0504\u0001\uffff\u0001\u0505\u0002"+
    "\uffff\u0001\u0042\u0002\uffff\u0003\u0042\u0001\u050a\u0001\uffff",
    DFA19_eofS:
        "\u050b\uffff",
    DFA19_minS:
        "\u0001\u0000\u0001\u0066\u0002\u0061\u0001\u0065\u0001\u006c\u0001"+
    "\u0069\u0001\u0065\u0001\u0064\u0001\u0061\u0001\u0069\u0001\u0061\u0001"+
    "\u0073\u0001\u0062\u0002\u0061\u0002\u0065\u0001\u006e\u0001\u0061\u0001"+
    "\u0065\u0001\u0071\u0001\u0061\u0002\u0065\u0001\u0075\u0001\u007c\u0001"+
    "\u0023\u0002\uffff\u0001\u007c\u0004\uffff\u0001\u003a\u0001\u003d\u0001"+
    "\uffff\u0001\u0029\u0001\u0023\u0001\uffff\u0001\u003e\u0002\uffff\u0001"+
    "\u002d\u0001\u0021\u0001\u003d\u0001\u002f\u0001\u002e\u0002\uffff\u0001"+
    "\u002d\u0004\uffff\u0001\u002e\u0001\uffff\u0001\u0063\u0002\u002d\u0001"+
    "\u0072\u0001\u006c\u0001\u0074\u0001\u006f\u0001\u0070\u0001\uffff\u0001"+
    "\u0073\u0001\u0075\u0001\u002d\u0001\u0066\u0001\u0065\u0001\u0073\u0001"+
    "\u0065\u0001\u006c\u0001\u0063\u0001\u0061\u0001\u0063\u0001\u0065\u0001"+
    "\u0070\u0001\u0063\u0001\u002d\u0001\u0065\u0001\u0061\u0001\u006c\u0001"+
    "\u006e\u0001\u0072\u0001\u006f\u0002\u002d\u0001\u0065\u0001\u002d\u0001"+
    "\u0069\u0001\u002d\u0001\u0070\u0002\u002d\u0001\u0065\u0001\u006e\u0002"+
    "\u002d\u0001\u006f\u0001\u0064\u0001\u006e\u0001\u006d\u0002\u002d\u0001"+
    "\u006f\u0001\u002d\u0001\u0074\u0001\u002d\u0001\u006a\u0001\u002d\u0001"+
    "\u0063\u0001\u0072\u0001\u0065\u0001\u0072\u0001\u0073\u0001\u0072\u0001"+
    "\u0061\u0001\u006d\u0001\u0068\u0001\u006c\u0001\u006d\u0003\u0069\u0001"+
    "\u006c\u0001\u0078\u0001\u0065\u0001\u002d\u0001\u0065\u0001\u0070\u0002"+
    "\u006d\u0001\u0069\u0001\u0064\u0001\u0069\u0001\u006c\u0001\u0072\u0001"+
    "\u0065\u0001\u006c\u0001\u0069\u0001\u0072\u0001\u0075\u0001\u004e\u0001"+
    "\u0072\u0001\u0079\u0001\u006f\u0003\uffff\u0001\u0009\u0012\uffff\u0001"+
    "\u0078\u000b\uffff\u0001\u002d\u0001\u0009\u0009\uffff\u0001\u0030\u0007"+
    "\uffff\u0001\u002e\u0001\u0030\u0001\uffff\u0001\u0065\u0002\u002d\u0001"+
    "\u0065\u0001\uffff\u0001\u0072\u0001\uffff\u0001\u0061\u0001\u002d\u0002"+
    "\u0065\u0001\u0073\u0001\u002d\u0001\u0065\u0001\u006e\u0001\uffff\u0001"+
    "\u006f\u0001\u0061\u0001\u0065\u0001\u0063\u0001\u006c\u0001\u0063\u0001"+
    "\u006c\u0001\u006d\u0001\u0073\u0001\u0079\u0001\u006e\u0001\u0069\u0001"+
    "\u0061\u0001\u0063\u0001\u0065\u0001\u002d\u0001\u0069\u0001\u0063\u0001"+
    "\u0066\u0001\u0074\u0001\u0075\u0001\u006d\u0001\u0065\u0001\u0074\u0001"+
    "\u006f\u0001\u002d\u0001\u0069\u0001\uffff\u0001\u0072\u0002\u0065\u0001"+
    "\u0063\u0001\u0074\u0001\u006c\u0001\u002d\u0001\u0063\u0001\u0073\u0001"+
    "\u006d\u0001\u006f\u0001\u006e\u0001\u006f\u0001\u0072\u0001\uffff\u0001"+
    "\u0061\u0001\u0075\u0001\uffff\u0001\u0076\u0001\uffff\u0001\u006f\u0003"+
    "\u0065\u0001\u0069\u0001\u0065\u0002\uffff\u0001\u006d\u0001\u002d\u0001"+
    "\u0074\u0001\u0067\u0001\u0073\u0001\u002d\u0001\u0065\u0002\uffff\u0001"+
    "\u0065\u0001\u0070\u0001\u002d\u0001\u0074\u0001\u0075\u0001\u0065\u0001"+
    "\u0074\u0001\uffff\u0001\u0069\u0001\u0065\u0001\u002d\u0001\uffff\u0001"+
    "\u006e\u0001\uffff\u0001\u0069\u0001\u0065\u0001\uffff\u0001\u0065\u0001"+
    "\u0079\u0001\uffff\u0001\u0075\u0001\u0061\u0001\u0074\u0002\u0063\u0001"+
    "\u002d\u0001\u0069\u0001\u0061\u0001\u0069\u0001\u0062\u0001\u006d\u0001"+
    "\u0070\u0001\u0069\u0002\u0065\u0001\u0072\u0001\u0066\u0001\u0073\u0001"+
    "\u0065\u0001\u0064\u0001\u0074\u0001\u0070\u0001\u0075\u0001\u0061\u0001"+
    "\u006c\u0002\u0061\u0001\u0074\u0001\u006e\u0001\uffff\u0001\u0061\u0001"+
    "\u002d\u0001\u0065\u0001\u0062\u0001\u0065\u0001\u006f\u0001\u0072\u0001"+
    "\u0061\u0001\u0065\u0001\u006e\u0002\u0069\u0001\u0073\u0001\u006e\u0001"+
    "\u006c\u0001\u0064\u0001\u0068\u0001\u0064\u0001\u0067\u0001\u0064\u0001"+
    "\u0065\u0001\u002d\u0001\u006f\u0001\u002d\u0001\u0074\u0004\uffff\u0001"+
    "\u002d\u0003\uffff\u0001\u0030\u0001\u0073\u0002\uffff\u0001\u006e\u0001"+
    "\u0069\u0001\u0079\u0001\u0077\u0001\uffff\u0001\u0072\u0001\u006e\u0001"+
    "\u002d\u0001\uffff\u0001\u002d\u0001\u0064\u0001\u0072\u0001\u006b\u0002"+
    "\u002d\u0001\u0068\u0001\u0064\u0001\u006b\u0001\u0061\u0001\u0065\u0001"+
    "\u0074\u0001\u0061\u0001\u002d\u0001\u0074\u0001\u0061\u0001\u006d\u0001"+
    "\u0075\u0001\u0065\u0001\u0074\u0001\uffff\u0001\u0074\u0001\u0072\u0001"+
    "\u0065\u0001\u0061\u0001\u006d\u0001\u0065\u0001\u002d\u0001\u0079\u0001"+
    "\u0064\u0001\uffff\u0001\u0072\u0001\u0079\u0001\u0070\u0001\u0072\u0001"+
    "\u0074\u0001\u002d\u0001\u006f\u0001\u0061\u0001\uffff\u0002\u0074\u0001"+
    "\u002d\u0001\u0070\u0001\u0064\u0001\u0074\u0001\u002d\u0001\u0074\u0001"+
    "\u0070\u0001\u002d\u0002\u0072\u0001\u0061\u0001\u006e\u0001\u0067\u0001"+
    "\u002d\u0001\u006e\u0001\u0078\u0001\u002d\u0001\uffff\u0001\u002d\u0001"+
    "\u0075\u0001\u0074\u0001\uffff\u0001\u006c\u0001\u0072\u0001\u002d\u0001"+
    "\u006c\u0001\u0066\u0001\uffff\u0001\u002d\u0002\u0073\u0001\u002d\u0001"+
    "\u006e\u0001\u0072\u0001\u002d\u0001\uffff\u0001\u002d\u0001\u006f\u0001"+
    "\u0072\u0001\u0063\u0001\u002d\u0001\u0072\u0001\u006e\u0001\u0067\u0003"+
    "\u0065\u0001\u0069\u0002\u0065\u0001\u006d\u0001\u0074\u0001\u0073\u0002"+
    "\u0063\u0001\u006c\u0001\u0074\u0001\u006d\u0001\u002d\u0001\u0073\u0001"+
    "\u002d\u0001\u006d\u0001\u0065\u0001\u002d\u0001\u0069\u0001\u0065\u0001"+
    "\u002d\u0001\u0069\u0001\u0063\u0001\u002d\u0001\u0072\u0001\u006d\u0001"+
    "\u0061\u0001\u006c\u0001\u0074\u0002\u002d\u0001\u0061\u0001\u0074\u0001"+
    "\uffff\u0001\u002d\u0001\u006c\u0001\u0073\u0001\u006e\u0001\u0075\u0001"+
    "\u0064\u0001\u0074\u0001\u0072\u0001\u0067\u0001\u0064\u0001\u0065\u0001"+
    "\u0061\u0001\u0069\u0001\u0065\u0001\u002d\u0001\u0065\u0001\u006f\u0001"+
    "\u002d\u0001\u0063\u0001\u0068\u0001\u002d\u0001\u0072\u0001\uffff\u0001"+
    "\u002d\u0001\uffff\u0001\u002d\u0001\u0000\u0001\u0074\u0001\u0064\u0001"+
    "\u0062\u0001\u002d\u0001\u0069\u0001\u002d\u0001\u0064\u0001\uffff\u0001"+
    "\u0075\u0001\u0061\u0001\u0065\u0001\u002d\u0001\uffff\u0001\u0062\u0001"+
    "\uffff\u0003\u002d\u0001\u0074\u0001\u0063\u0001\u006e\u0001\u0072\u0001"+
    "\u006e\u0001\u0069\u0002\u006e\u0001\uffff\u0001\u002d\u0001\u0072\u0001"+
    "\u0061\u0001\u006c\u0001\u006e\u0001\u0065\u0001\u002d\u0001\u0069\u0001"+
    "\u0072\u0001\u006e\u0001\u0065\u0001\u006e\u0001\uffff\u0001\u002d\u0001"+
    "\u0069\u0001\u0065\u0001\u002d\u0001\u0074\u0001\u006e\u0001\u006c\u0001"+
    "\uffff\u0001\u0077\u0001\u0063\u0001\u0067\u0001\u0069\u0001\u002d\u0001"+
    "\uffff\u0001\u0074\u0002\u002d\u0001\uffff\u0001\u0065\u0001\u002d\u0001"+
    "\uffff\u0001\u0074\u0001\u0069\u0001\u006e\u0001\u0074\u0002\u0073\u0001"+
    "\u0072\u0001\uffff\u0001\u0069\u0001\u002d\u0002\uffff\u0001\u0061\u0001"+
    "\u002d\u0001\u0073\u0001\u0063\u0001\uffff\u0001\u0065\u0001\u0079\u0001"+
    "\uffff\u0001\u002d\u0001\u0070\u0001\uffff\u0001\u0068\u0001\u0065\u0001"+
    "\u002d\u0001\uffff\u0001\u0069\u0001\uffff\u0001\u006e\u0001\u002d\u0001"+
    "\u0074\u0001\uffff\u0001\u0073\u0001\u0074\u0002\u0072\u0001\u0064\u0001"+
    "\u0072\u0001\u006f\u0001\u0073\u0001\u006e\u0002\u0069\u0001\u0065\u0002"+
    "\u0074\u0001\u002d\u0001\u0065\u0001\u002d\u0001\u0069\u0001\uffff\u0001"+
    "\u0066\u0001\uffff\u0001\u0061\u0001\u002d\u0001\uffff\u0001\u0074\u0001"+
    "\u006e\u0001\uffff\u0001\u006e\u0001\u0068\u0001\uffff\u0001\u006e\u0001"+
    "\u0065\u0001\u0063\u0002\u0069\u0002\uffff\u0001\u0075\u0001\u002d\u0001"+
    "\u0077\u0001\uffff\u0001\u0069\u0002\u002d\u0002\u0065\u0001\u0069\u0001"+
    "\u0063\u0001\u002d\u0001\u0061\u0001\u002d\u0001\u0062\u0001\u006f\u0001"+
    "\u002d\u0001\uffff\u0001\u002d\u0001\u0077\u0001\u0075\u0001\uffff\u0001"+
    "\u0061\u0001\u0074\u0001\u002d\u0001\uffff\u0001\u0079\u0001\u0064\u0003"+
    "\uffff\u0001\u006f\u0001\u0069\u0001\u0075\u0001\uffff\u0001\u006e\u0001"+
    "\uffff\u0001\u002d\u0002\u0072\u0001\u002d\u0001\uffff\u0001\u006c\u0003"+
    "\uffff\u0001\u0069\u0002\u0074\u0001\u0061\u0002\u0074\u0001\u006e\u0001"+
    "\u0075\u0001\u0061\u0001\uffff\u0001\u0065\u0001\u006c\u0001\u0074\u0001"+
    "\u0064\u0001\u002d\u0001\uffff\u0001\u0074\u0001\u0065\u0001\u0063\u0001"+
    "\u006e\u0001\u0074\u0001\u0073\u0001\uffff\u0001\u006e\u0001\u002d\u0001"+
    "\uffff\u0001\u002d\u0001\u0061\u0001\u0079\u0001\u0069\u0001\u0068\u0001"+
    "\u006e\u0001\u006f\u0001\uffff\u0001\u0069\u0002\uffff\u0001\u0073\u0001"+
    "\u006e\u0001\uffff\u0001\u002d\u0001\u0074\u0001\u0063\u0001\u002d\u0001"+
    "\u0069\u0001\u0065\u0001\u0069\u0001\u0074\u0001\uffff\u0001\u0067\u0001"+
    "\uffff\u0001\u002d\u0001\u0061\u0002\u002d\u0001\u0073\u0001\u0061\u0001"+
    "\u0065\u0001\u0073\u0001\uffff\u0001\u0074\u0001\u002d\u0001\u0064\u0001"+
    "\u006e\u0001\uffff\u0003\u002d\u0001\u0061\u0001\u006e\u0001\u0069\u0001"+
    "\u0076\u0001\u0075\u0001\u0073\u0001\u0074\u0001\u006c\u0001\u006f\u0001"+
    "\u002d\u0001\u0075\u0001\u002d\u0001\uffff\u0001\u002d\u0001\uffff\u0001"+
    "\u006e\u0001\u0069\u0001\u002d\u0001\uffff\u0001\u0069\u0001\u0063\u0001"+
    "\u0067\u0003\u002d\u0001\u0065\u0001\u0064\u0001\u006f\u0001\u0072\u0001"+
    "\uffff\u0001\u0069\u0001\u006e\u0002\uffff\u0001\u002d\u0001\u0072\u0001"+
    "\u006e\u0001\u0061\u0001\uffff\u0001\u0074\u0001\uffff\u0001\u006c\u0001"+
    "\u006e\u0002\uffff\u0001\u002d\u0001\u0074\u0001\u0072\u0001\u002d\u0001"+
    "\uffff\u0001\u002d\u0001\u0069\u0001\u0072\u0001\u006e\u0001\u0074\u0001"+
    "\u0067\u0001\uffff\u0001\u0069\u0001\u0079\u0001\uffff\u0001\u0065\u0001"+
    "\u006f\u0001\u0069\u0001\u002d\u0001\u0063\u0001\u0069\u0002\u002d\u0001"+
    "\u0073\u0001\u0065\u0001\u006d\u0003\u002d\u0001\u0061\u0001\uffff\u0001"+
    "\u0069\u0001\u006e\u0001\u0065\u0001\u0074\u0001\u002d\u0001\u0065\u0001"+
    "\u0067\u0002\uffff\u0001\u006c\u0001\u002d\u0001\u006e\u0002\u002d\u0001"+
    "\u006e\u0001\u006f\u0001\u0074\u0001\u0067\u0001\uffff\u0001\u002d\u0001"+
    "\u0065\u0001\uffff\u0001\u0074\u0001\u0063\u0001\u0074\u0001\u0079\u0001"+
    "\u0065\u0001\uffff\u0001\u0073\u0002\uffff\u0001\u0069\u0001\u0063\u0001"+
    "\u0072\u0002\u0065\u0001\uffff\u0001\u002d\u0001\u0067\u0003\uffff\u0001"+
    "\u0070\u0001\u002d\u0001\u006e\u0001\u0065\u0001\u0073\u0001\u0069\u0001"+
    "\u002d\u0001\u006c\u0001\u006e\u0001\uffff\u0001\u0072\u0002\uffff\u0001"+
    "\u0067\u0001\u0065\u0001\u0061\u0001\uffff\u0001\u0076\u0001\u0065\u0001"+
    "\u002d\u0001\uffff\u0001\u006e\u0002\uffff\u0001\u002d\u0001\u0061\u0001"+
    "\u006e\u0001\u0075\u0001\u0074\u0001\u0067\u0001\uffff\u0001\u0065\u0001"+
    "\u0067\u0001\u0073\u0002\u0065\u0001\u002d\u0001\uffff\u0001\u002d\u0001"+
    "\u0064\u0002\uffff\u0001\u0067\u0001\u002d\u0001\u0067\u0001\u0065\u0004"+
    "\u002d\u0001\u006e\u0001\u006f\u0001\uffff\u0001\u0074\u0001\u006e\u0002"+
    "\uffff\u0002\u002d\u0001\u0065\u0001\uffff\u0001\u0066\u0001\uffff\u0002"+
    "\u006e\u0001\u0063\u0001\u0074\u0002\u002d\u0001\uffff\u0001\u0071\u0002"+
    "\u002d\u0001\uffff\u0001\u0067\u0002\uffff\u0001\u002d\u0001\u006e\u0002"+
    "\u002d\u0001\uffff\u0001\u002d\u0001\u0069\u0001\u0074\u0001\u0079\u0002"+
    "\u002d\u0001\u0065\u0001\u0067\u0001\u0065\u0001\u0069\u0001\u0072\u0001"+
    "\u006d\u0001\uffff\u0001\u002d\u0001\u0068\u0001\u0073\u0001\u0067\u0002"+
    "\u002d\u0001\u006e\u0001\uffff\u0001\u0065\u0001\u002d\u0001\u0065\u0001"+
    "\u002d\u0001\u0073\u0001\u0074\u0001\u006c\u0001\u0065\u0001\u002d\u0001"+
    "\uffff\u0001\u0067\u0001\uffff\u0001\u0074\u0002\u0073\u0001\u0063\u0001"+
    "\u002d\u0001\u0064\u0001\u002d\u0001\u0065\u0002\u002d\u0002\uffff\u0001"+
    "\u0073\u0001\u0069\u0001\u006f\u0001\uffff\u0002\u002d\u0002\uffff\u0001"+
    "\u0073\u0001\uffff\u0001\u002d\u0001\u006e\u0001\u0069\u0001\u0074\u0002"+
    "\uffff\u0001\u0073\u0001\u006f\u0001\u0065\u0001\u0074\u0001\u0067\u0001"+
    "\u0073\u0001\u002d\u0001\uffff\u0001\u006e\u0001\uffff\u0001\u0075\u0002"+
    "\uffff\u0001\u002d\u0001\uffff\u0001\u002d\u0001\uffff\u0001\u0073\u0001"+
    "\uffff\u0001\u0076\u0002\u002d\u0002\uffff\u0001\u002d\u0001\u006e\u0001"+
    "\u002d\u0001\u0074\u0001\u0076\u0001\u002d\u0001\uffff\u0001\u002d\u0001"+
    "\u0065\u0001\u002d\u0002\uffff\u0001\u0067\u0001\u002d\u0001\uffff\u0001"+
    "\u0064\u0001\uffff\u0001\u002d\u0001\u0074\u0001\u0065\u0002\u002d\u0001"+
    "\uffff\u0001\u002d\u0001\u0069\u0001\u0068\u0001\u002d\u0001\u0068\u0001"+
    "\uffff\u0001\u002d\u0001\uffff\u0001\u002d\u0002\uffff\u0001\u002d\u0001"+
    "\u0074\u0001\u0072\u0002\uffff\u0001\u0070\u0001\uffff\u0001\u002d\u0001"+
    "\u006f\u0001\u002d\u0001\u0070\u0001\u0072\u0001\u0070\u0003\u002d\u0001"+
    "\uffff\u0001\u006f\u0001\u0065\u0001\u0073\u0002\uffff\u0002\u0065\u0003"+
    "\uffff\u0001\u002d\u0001\u006e\u0001\uffff\u0001\u002d\u0001\u0065\u0001"+
    "\uffff\u0001\u002d\u0001\uffff\u0001\u0070\u0001\u0073\u0001\uffff\u0001"+
    "\u002d\u0001\uffff\u0001\u002d\u0001\uffff\u0001\u0072\u0001\u006d\u0003"+
    "\uffff\u0001\u006f\u0001\u0069\u0001\uffff\u0001\u002d\u0003\uffff\u0002"+
    "\u002d\u0001\u0061\u0001\uffff\u0001\u006e\u0001\uffff\u0001\u0061\u0001"+
    "\u006d\u0001\u0061\u0001\u006f\u0003\uffff\u0001\u0064\u0001\u006e\u0001"+
    "\u0069\u0001\u0070\u0001\u002d\u0001\uffff\u0001\u006f\u0001\uffff\u0001"+
    "\u002d\u0001\uffff\u0001\u0061\u0004\u0069\u0001\u0065\u0001\u006e\u0001"+
    "\u0070\u0002\uffff\u0001\u0073\u0001\u0063\u0001\u002d\u0001\u0063\u0001"+
    "\u0061\u0002\u0072\u0001\u0065\u0001\u0063\u0001\u0062\u0001\u0061\u0001"+
    "\uffff\u0001\u0064\u0001\uffff\u0001\u0072\u0001\u0062\u0001\u006e\u0001"+
    "\u0074\u0001\u0062\u0001\u006e\u0002\u002d\u0002\u0065\u0001\uffff\u0001"+
    "\u0065\u0001\u0074\u0001\u0061\u0002\u002d\u0001\u0065\u0001\u006c\u0001"+
    "\u0072\u0001\u0065\u0001\u0061\u0001\u006c\u0001\u0073\u0001\u0065\u0001"+
    "\u0075\u0001\u0074\u0002\uffff\u0001\u006c\u0001\u002d\u0001\u0073\u0001"+
    "\u002d\u0001\u0074\u0001\u0073\u0001\uffff\u0001\u002d\u0001\u0069\u0001"+
    "\u0061\u0001\u002d\u0001\u0074\u0001\u0069\u0001\u0074\u0001\u006d\u0001"+
    "\u0074\u0001\u002d\u0001\u0066\u0001\uffff\u0001\u002d\u0001\uffff\u0001"+
    "\u006f\u0001\u0065\u0001\uffff\u0001\u006e\u0001\u0074\u0001\uffff\u0001"+
    "\u006f\u0001\u006e\u0001\u0072\u0001\u002d\u0001\u0065\u0001\uffff\u0001"+
    "\u002d\u0001\uffff\u0001\u0072\u0001\u006c\u0001\u0067\u0001\u006f\u0001"+
    "\u0072\u0001\u0067\u0001\u0075\u0001\uffff\u0001\u002d\u0001\uffff\u0001"+
    "\u002d\u0001\u0066\u0001\u002d\u0001\u0072\u0002\u002d\u0001\u0063\u0002"+
    "\uffff\u0001\u002d\u0001\uffff\u0001\u002d\u0002\uffff\u0001\u0074\u0002"+
    "\uffff\u0001\u0069\u0001\u006f\u0001\u006e\u0001\u002d\u0001\uffff",
    DFA19_maxS:
        "\u0001\uffff\u0001\u0074\u0001\u0079\u0002\u006f\u0001\u0078\u0001"+
    "\u0075\u0003\u0074\u0002\u006f\u0001\u0073\u0002\u0072\u0001\u0077\u0001"+
    "\u0065\u0001\u0079\u0001\u0073\u0001\u0065\u0001\u006f\u0001\u0071\u0001"+
    "\u0061\u0002\u0065\u0001\u0075\u0001\u007d\u0001\u003a\u0002\uffff\u0001"+
    "\u007c\u0004\uffff\u0002\u003d\u0001\uffff\u0001\u0029\u0001\u0023\u0001"+
    "\uffff\u0001\u003e\u0002\uffff\u0001\u002d\u0001\u003f\u0002\u003e\u0001"+
    "\u0039\u0002\uffff\u0001\u007a\u0004\uffff\u0001\u0065\u0001\uffff\u0001"+
    "\u0079\u0002\u007a\u0001\u0072\u0001\u006c\u0001\u0074\u0002\u0070\u0001"+
    "\uffff\u0001\u0073\u0001\u0075\u0001\u007a\u0001\u0066\u0001\u0065\u0001"+
    "\u0074\u0001\u0069\u0001\u0075\u0001\u0073\u0001\u0076\u0001\u0063\u0001"+
    "\u0073\u0001\u0070\u0001\u0074\u0001\u007a\u0001\u0065\u0001\u0074\u0001"+
    "\u0072\u0001\u006e\u0001\u0072\u0002\u006f\u0001\u007a\u0001\u006f\u0001"+
    "\u007a\u0001\u0069\u0001\u007a\u0001\u0070\u0002\u007a\u0001\u0065\u0001"+
    "\u0078\u0002\u007a\u0001\u0077\u0001\u0073\u0001\u006e\u0001\u006d\u0002"+
    "\u007a\u0001\u006f\u0001\u007a\u0001\u0074\u0001\u007a\u0001\u006a\u0001"+
    "\u007a\u0001\u0063\u0001\u0074\u0001\u006f\u0001\u0072\u0001\u0073\u0002"+
    "\u0072\u0001\u0074\u0001\u006f\u0001\u006e\u0001\u006d\u0003\u0069\u0001"+
    "\u0076\u0001\u0078\u0001\u0065\u0001\u007a\u0001\u0079\u0001\u0070\u0002"+
    "\u006d\u0001\u006f\u0001\u0070\u0001\u0069\u0002\u0072\u0001\u0069\u0001"+
    "\u0074\u0001\u0069\u0001\u0072\u0001\u0075\u0001\u004e\u0001\u0072\u0001"+
    "\u0079\u0001\u006f\u0003\uffff\u0001\u007a\u0012\uffff\u0001\u0078\u000b"+
    "\uffff\u0001\u002d\u0001\u007a\u0009\uffff\u0001\u0065\u0007\uffff\u0002"+
    "\u0065\u0001\uffff\u0001\u0065\u0002\u007a\u0001\u0065\u0001\uffff\u0001"+
    "\u0072\u0001\uffff\u0001\u0061\u0001\u007a\u0002\u0065\u0001\u0073\u0001"+
    "\u007a\u0001\u0065\u0001\u006e\u0001\uffff\u0001\u006f\u0001\u0061\u0001"+
    "\u0074\u0001\u0063\u0001\u006c\u0001\u0063\u0001\u006c\u0001\u006d\u0001"+
    "\u0074\u0001\u0079\u0001\u006e\u0001\u006c\u0001\u0061\u0001\u0063\u0001"+
    "\u0065\u0001\u007a\u0001\u0069\u0001\u0063\u0001\u0066\u0001\u0074\u0001"+
    "\u0075\u0001\u006d\u0001\u0065\u0001\u0074\u0001\u006f\u0001\u007a\u0001"+
    "\u0069\u0001\uffff\u0001\u0072\u0002\u0065\u0001\u0063\u0001\u0074\u0001"+
    "\u006c\u0001\u007a\u0001\u0063\u0001\u0073\u0001\u006d\u0001\u006f\u0001"+
    "\u006e\u0001\u006f\u0001\u0072\u0001\uffff\u0001\u0061\u0001\u0075\u0001"+
    "\uffff\u0001\u0076\u0001\uffff\u0001\u006f\u0001\u0065\u0001\u0074\u0001"+
    "\u006f\u0001\u0069\u0001\u0065\u0002\uffff\u0001\u006d\u0001\u007a\u0001"+
    "\u0074\u0001\u0067\u0001\u0073\u0001\u007a\u0001\u0065\u0002\uffff\u0001"+
    "\u0065\u0001\u0070\u0001\u007a\u0001\u0074\u0001\u0075\u0001\u0065\u0001"+
    "\u0074\u0001\uffff\u0001\u0070\u0001\u0065\u0001\u007a\u0001\uffff\u0001"+
    "\u006e\u0001\uffff\u0001\u0069\u0001\u0065\u0001\uffff\u0001\u0065\u0001"+
    "\u0079\u0001\uffff\u0001\u0075\u0001\u0065\u0001\u0074\u0001\u0076\u0002"+
    "\u0063\u0001\u0069\u0001\u0061\u0001\u0075\u0001\u0072\u0001\u006d\u0001"+
    "\u0070\u0001\u0069\u0002\u0065\u0001\u0072\u0001\u0066\u0001\u0074\u0001"+
    "\u0065\u0001\u0064\u0001\u0074\u0001\u0070\u0001\u0075\u0001\u0061\u0001"+
    "\u006c\u0002\u0061\u0001\u0074\u0001\u0073\u0001\uffff\u0001\u0061\u0001"+
    "\u007a\u0001\u0065\u0001\u0062\u0001\u0065\u0001\u0071\u0001\u0072\u0001"+
    "\u0061\u0001\u0065\u0001\u006e\u0001\u0075\u0001\u0069\u0001\u0073\u0001"+
    "\u0072\u0001\u006c\u0001\u0064\u0001\u0068\u0001\u0064\u0001\u0067\u0001"+
    "\u0064\u0001\u0065\u0001\u007a\u0001\u006f\u0001\u007a\u0001\u0074\u0004"+
    "\uffff\u0001\u002d\u0003\uffff\u0001\u0065\u0001\u0073\u0002\uffff\u0001"+
    "\u006e\u0001\u0069\u0001\u0079\u0001\u0077\u0001\uffff\u0001\u0072\u0001"+
    "\u006e\u0001\u007a\u0001\uffff\u0001\u002d\u0001\u0064\u0001\u0072\u0001"+
    "\u006b\u0002\u007a\u0001\u0068\u0001\u0064\u0001\u006b\u0002\u0065\u0001"+
    "\u0074\u0001\u0069\u0001\u007a\u0001\u0074\u0001\u0061\u0001\u006d\u0001"+
    "\u0075\u0001\u0065\u0001\u0074\u0001\uffff\u0001\u0074\u0001\u0072\u0001"+
    "\u0065\u0001\u0061\u0001\u006d\u0001\u0065\u0001\u007a\u0001\u0079\u0001"+
    "\u0064\u0001\uffff\u0001\u0072\u0001\u0079\u0001\u0070\u0001\u0072\u0001"+
    "\u0074\u0001\u007a\u0001\u006f\u0001\u0069\u0001\uffff\u0002\u0074\u0001"+
    "\u007a\u0001\u0070\u0001\u0064\u0001\u0074\u0001\u007a\u0001\u0074\u0001"+
    "\u0070\u0001\u007a\u0002\u0072\u0001\u0061\u0002\u0072\u0001\u007a\u0001"+
    "\u006e\u0001\u0078\u0001\u007a\u0001\uffff\u0001\u007a\u0001\u0075\u0001"+
    "\u0074\u0001\uffff\u0001\u006c\u0001\u0072\u0001\u007a\u0001\u006c\u0001"+
    "\u0066\u0001\uffff\u0001\u007a\u0002\u0073\u0001\u007a\u0001\u006e\u0001"+
    "\u0072\u0001\u007a\u0001\uffff\u0001\u007a\u0001\u006f\u0001\u0072\u0001"+
    "\u0063\u0001\u007a\u0001\u0072\u0001\u006e\u0001\u0067\u0003\u0065\u0001"+
    "\u0069\u0002\u0065\u0001\u006d\u0001\u0074\u0001\u0073\u0001\u0063\u0001"+
    "\u0070\u0001\u006c\u0001\u0074\u0001\u006d\u0001\u007a\u0001\u0073\u0001"+
    "\u007a\u0001\u006d\u0001\u0065\u0001\u007a\u0001\u0069\u0001\u0065\u0001"+
    "\u007a\u0001\u0069\u0001\u0063\u0001\u007a\u0001\u0072\u0001\u006d\u0001"+
    "\u0061\u0001\u006c\u0001\u0074\u0002\u007a\u0001\u0061\u0001\u0074\u0001"+
    "\uffff\u0001\u007a\u0001\u006c\u0001\u0073\u0001\u006e\u0001\u0075\u0001"+
    "\u0064\u0001\u0074\u0001\u0072\u0001\u0067\u0001\u0064\u0001\u0065\u0001"+
    "\u0061\u0001\u0069\u0001\u0065\u0001\u007a\u0001\u0065\u0001\u006f\u0001"+
    "\u007a\u0001\u0063\u0001\u0068\u0001\u007a\u0001\u0072\u0001\uffff\u0001"+
    "\u002d\u0001\uffff\u0001\u007a\u0001\uffff\u0001\u0074\u0001\u0064\u0001"+
    "\u0062\u0001\u007a\u0001\u0069\u0001\u007a\u0001\u0064\u0001\uffff\u0001"+
    "\u0075\u0001\u0061\u0001\u0065\u0001\u007a\u0001\uffff\u0001\u0062\u0001"+
    "\uffff\u0003\u007a\u0001\u0074\u0001\u0063\u0001\u006e\u0001\u0072\u0001"+
    "\u0078\u0001\u0069\u0002\u006e\u0001\uffff\u0001\u007a\u0001\u0072\u0001"+
    "\u0061\u0001\u006c\u0001\u006e\u0001\u0065\u0001\u007a\u0001\u0069\u0001"+
    "\u0072\u0001\u006e\u0001\u0065\u0001\u006e\u0001\uffff\u0001\u007a\u0001"+
    "\u0069\u0001\u0065\u0001\u007a\u0001\u0074\u0001\u006e\u0001\u006c\u0001"+
    "\uffff\u0001\u0077\u0001\u0063\u0001\u0067\u0001\u0069\u0001\u007a\u0001"+
    "\uffff\u0001\u0074\u0002\u007a\u0001\uffff\u0001\u0065\u0001\u007a\u0001"+
    "\uffff\u0001\u0074\u0001\u0069\u0001\u006e\u0001\u0074\u0002\u0073\u0001"+
    "\u0072\u0001\uffff\u0001\u0069\u0001\u007a\u0002\uffff\u0001\u0061\u0001"+
    "\u007a\u0001\u0073\u0001\u0063\u0001\uffff\u0001\u0065\u0001\u0079\u0001"+
    "\uffff\u0001\u002d\u0001\u0070\u0001\uffff\u0001\u0068\u0001\u0065\u0001"+
    "\u007a\u0001\uffff\u0001\u0069\u0001\uffff\u0001\u006e\u0001\u007a\u0001"+
    "\u0074\u0001\uffff\u0001\u0073\u0001\u0074\u0002\u0072\u0001\u0064\u0001"+
    "\u0072\u0001\u006f\u0001\u0073\u0001\u006e\u0002\u0069\u0001\u0065\u0002"+
    "\u0074\u0001\u007a\u0001\u0065\u0001\u007a\u0001\u0069\u0001\uffff\u0001"+
    "\u0066\u0001\uffff\u0001\u0061\u0001\u007a\u0001\uffff\u0001\u0074\u0001"+
    "\u006e\u0001\uffff\u0001\u006e\u0001\u0068\u0001\uffff\u0001\u006e\u0001"+
    "\u0065\u0001\u0063\u0002\u0069\u0002\uffff\u0001\u0075\u0001\u007a\u0001"+
    "\u0077\u0001\uffff\u0001\u0069\u0002\u007a\u0002\u0065\u0001\u0069\u0001"+
    "\u0063\u0001\u007a\u0001\u0061\u0001\u007a\u0001\u0062\u0001\u006f\u0001"+
    "\u007a\u0001\uffff\u0001\u007a\u0001\u0077\u0001\u0075\u0001\uffff\u0001"+
    "\u0061\u0001\u0074\u0001\u007a\u0001\uffff\u0001\u0079\u0001\u0064\u0003"+
    "\uffff\u0001\u006f\u0001\u0069\u0001\u0075\u0001\uffff\u0001\u006e\u0001"+
    "\uffff\u0001\u007a\u0002\u0072\u0001\u007a\u0001\uffff\u0001\u006c\u0003"+
    "\uffff\u0001\u0069\u0002\u0074\u0001\u0075\u0002\u0074\u0001\u006e\u0001"+
    "\u0075\u0001\u0061\u0001\uffff\u0001\u0065\u0001\u006c\u0001\u0074\u0001"+
    "\u0064\u0001\u007a\u0001\uffff\u0001\u0074\u0001\u0065\u0001\u0063\u0001"+
    "\u006e\u0001\u0074\u0001\u0073\u0001\uffff\u0001\u006e\u0001\u007a\u0001"+
    "\uffff\u0001\u007a\u0001\u0061\u0001\u0079\u0001\u0069\u0001\u0068\u0001"+
    "\u006e\u0001\u006f\u0001\uffff\u0001\u0069\u0002\uffff\u0001\u0073\u0001"+
    "\u006e\u0001\uffff\u0001\u007a\u0001\u0074\u0001\u0063\u0001\u007a\u0001"+
    "\u0069\u0001\u0065\u0001\u0069\u0001\u0074\u0001\uffff\u0001\u0067\u0001"+
    "\uffff\u0001\u007a\u0001\u0061\u0002\u007a\u0001\u0073\u0001\u0061\u0001"+
    "\u0065\u0001\u0073\u0001\uffff\u0001\u0074\u0001\u007a\u0001\u0064\u0001"+
    "\u006e\u0001\uffff\u0003\u007a\u0001\u0061\u0001\u006e\u0001\u0069\u0001"+
    "\u0076\u0001\u0075\u0001\u0073\u0001\u0074\u0001\u006c\u0001\u006f\u0001"+
    "\u007a\u0001\u0075\u0001\u007a\u0001\uffff\u0001\u007a\u0001\uffff\u0001"+
    "\u006e\u0001\u0069\u0001\u007a\u0001\uffff\u0001\u0069\u0001\u0063\u0001"+
    "\u0067\u0003\u007a\u0001\u0065\u0001\u0064\u0001\u006f\u0001\u0072\u0001"+
    "\uffff\u0001\u0069\u0001\u006e\u0002\uffff\u0001\u007a\u0001\u0072\u0001"+
    "\u006e\u0001\u0061\u0001\uffff\u0001\u0074\u0001\uffff\u0001\u006c\u0001"+
    "\u006e\u0002\uffff\u0001\u007a\u0001\u0074\u0001\u0072\u0001\u007a\u0001"+
    "\uffff\u0001\u007a\u0001\u0069\u0001\u0072\u0001\u006e\u0001\u0074\u0001"+
    "\u0067\u0001\uffff\u0001\u0069\u0001\u0079\u0001\uffff\u0001\u0065\u0001"+
    "\u006f\u0001\u0069\u0001\u007a\u0001\u0063\u0001\u0069\u0002\u007a\u0001"+
    "\u0073\u0001\u0065\u0001\u006d\u0001\u007a\u0001\u002d\u0001\u007a\u0001"+
    "\u0069\u0001\uffff\u0001\u0069\u0001\u006e\u0001\u0065\u0001\u0074\u0001"+
    "\u007a\u0001\u0065\u0001\u0067\u0002\uffff\u0001\u006c\u0001\u007a\u0001"+
    "\u006e\u0002\u007a\u0001\u006e\u0001\u006f\u0001\u0074\u0001\u0067\u0001"+
    "\uffff\u0001\u007a\u0001\u0065\u0001\uffff\u0001\u0074\u0001\u0063\u0001"+
    "\u0074\u0001\u0079\u0001\u0065\u0001\uffff\u0001\u0073\u0002\uffff\u0001"+
    "\u0069\u0001\u0063\u0001\u0072\u0002\u0065\u0001\uffff\u0001\u007a\u0001"+
    "\u0067\u0003\uffff\u0001\u0070\u0001\u002d\u0001\u006e\u0001\u0065\u0001"+
    "\u0073\u0001\u0069\u0001\u007a\u0001\u006c\u0001\u006e\u0001\uffff\u0001"+
    "\u0072\u0002\uffff\u0001\u0067\u0002\u0065\u0001\uffff\u0001\u0076\u0001"+
    "\u0065\u0001\u007a\u0001\uffff\u0001\u006e\u0002\uffff\u0001\u007a\u0001"+
    "\u0061\u0001\u006e\u0001\u0075\u0001\u0074\u0001\u0067\u0001\uffff\u0001"+
    "\u0065\u0001\u0067\u0001\u0073\u0002\u0065\u0001\u007a\u0001\uffff\u0001"+
    "\u007a\u0001\u0064\u0002\uffff\u0001\u0067\u0001\u007a\u0001\u0067\u0001"+
    "\u0065\u0002\u007a\u0001\u002d\u0001\u007a\u0001\u006e\u0001\u006f\u0001"+
    "\uffff\u0001\u0074\u0001\u006e\u0002\uffff\u0002\u007a\u0001\u0065\u0001"+
    "\uffff\u0001\u0073\u0001\uffff\u0002\u006e\u0001\u0063\u0001\u0074\u0002"+
    "\u007a\u0001\uffff\u0001\u0071\u0002\u007a\u0001\uffff\u0001\u0067\u0002"+
    "\uffff\u0001\u007a\u0001\u006e\u0001\u007a\u0001\u002d\u0001\uffff\u0001"+
    "\u007a\u0001\u0069\u0001\u0074\u0001\u0079\u0002\u007a\u0001\u0065\u0001"+
    "\u0067\u0001\u0065\u0001\u0069\u0001\u0072\u0001\u006d\u0001\uffff\u0001"+
    "\u007a\u0001\u0068\u0001\u0073\u0001\u0067\u0002\u007a\u0001\u006e\u0001"+
    "\uffff\u0001\u0065\u0001\u007a\u0001\u0065\u0001\u007a\u0001\u0073\u0001"+
    "\u0074\u0001\u006c\u0001\u0065\u0001\u007a\u0001\uffff\u0001\u0067\u0001"+
    "\uffff\u0001\u0074\u0002\u0073\u0001\u0063\u0001\u007a\u0001\u0064\u0001"+
    "\u007a\u0001\u0065\u0002\u007a\u0002\uffff\u0001\u0073\u0001\u0069\u0001"+
    "\u006f\u0001\uffff\u0002\u007a\u0002\uffff\u0001\u0073\u0001\uffff\u0001"+
    "\u007a\u0001\u006e\u0001\u0069\u0001\u0074\u0002\uffff\u0001\u0073\u0001"+
    "\u006f\u0001\u0065\u0001\u0074\u0001\u0067\u0001\u0073\u0001\u007a\u0001"+
    "\uffff\u0001\u006e\u0001\uffff\u0001\u0075\u0002\uffff\u0001\u007a\u0001"+
    "\uffff\u0001\u007a\u0001\uffff\u0001\u0073\u0001\uffff\u0001\u0076\u0002"+
    "\u007a\u0002\uffff\u0001\u007a\u0001\u006e\u0001\u007a\u0001\u0074\u0001"+
    "\u0076\u0001\u007a\u0001\uffff\u0001\u007a\u0001\u0065\u0001\u007a\u0002"+
    "\uffff\u0001\u0067\u0001\u007a\u0001\uffff\u0001\u0064\u0001\uffff\u0001"+
    "\u007a\u0001\u0074\u0001\u0065\u0002\u007a\u0001\uffff\u0001\u007a\u0001"+
    "\u0069\u0001\u0068\u0001\u007a\u0001\u0068\u0001\uffff\u0001\u007a\u0001"+
    "\uffff\u0001\u007a\u0002\uffff\u0001\u007a\u0001\u0074\u0001\u0072\u0002"+
    "\uffff\u0001\u0070\u0001\uffff\u0001\u007a\u0001\u006f\u0001\u007a\u0001"+
    "\u0070\u0001\u0072\u0001\u0070\u0003\u007a\u0001\uffff\u0001\u006f\u0001"+
    "\u0065\u0001\u0073\u0002\uffff\u0002\u0065\u0003\uffff\u0001\u007a\u0001"+
    "\u006e\u0001\uffff\u0001\u007a\u0001\u0065\u0001\uffff\u0001\u007a\u0001"+
    "\uffff\u0001\u0070\u0001\u0073\u0001\uffff\u0001\u002d\u0001\uffff\u0001"+
    "\u002d\u0001\uffff\u0001\u0072\u0001\u006d\u0003\uffff\u0001\u006f\u0001"+
    "\u0069\u0001\uffff\u0001\u007a\u0003\uffff\u0001\u007a\u0001\u002d\u0001"+
    "\u0061\u0001\uffff\u0001\u006e\u0001\uffff\u0001\u0061\u0001\u006d\u0001"+
    "\u0061\u0001\u006f\u0003\uffff\u0001\u0064\u0001\u006e\u0001\u0069\u0001"+
    "\u0070\u0001\u007a\u0001\uffff\u0001\u006f\u0001\uffff\u0001\u007a\u0001"+
    "\uffff\u0001\u0061\u0004\u0069\u0001\u0065\u0001\u006e\u0001\u0070\u0002"+
    "\uffff\u0001\u0073\u0001\u0063\u0001\u007a\u0001\u0063\u0001\u0061\u0002"+
    "\u0072\u0001\u0065\u0001\u0063\u0001\u0062\u0001\u0061\u0001\uffff\u0001"+
    "\u0064\u0001\uffff\u0001\u0072\u0001\u0062\u0001\u006e\u0001\u0074\u0001"+
    "\u0062\u0001\u006e\u0002\u007a\u0002\u0065\u0001\uffff\u0001\u0065\u0001"+
    "\u0074\u0001\u0061\u0001\u002d\u0001\u007a\u0001\u0065\u0001\u006c\u0001"+
    "\u0072\u0001\u0065\u0001\u0061\u0001\u006c\u0001\u0073\u0001\u0065\u0001"+
    "\u0075\u0001\u0074\u0002\uffff\u0001\u006c\u0001\u007a\u0001\u0073\u0001"+
    "\u007a\u0001\u0074\u0001\u0073\u0001\uffff\u0001\u007a\u0001\u0069\u0001"+
    "\u0061\u0001\u007a\u0001\u0074\u0001\u0069\u0001\u0074\u0001\u006d\u0001"+
    "\u0074\u0001\u007a\u0001\u0066\u0001\uffff\u0001\u007a\u0001\uffff\u0001"+
    "\u006f\u0001\u0065\u0001\uffff\u0001\u006e\u0001\u0074\u0001\uffff\u0001"+
    "\u006f\u0001\u006e\u0001\u0072\u0001\u007a\u0001\u0065\u0001\uffff\u0001"+
    "\u007a\u0001\uffff\u0001\u0072\u0001\u006c\u0001\u0067\u0001\u006f\u0001"+
    "\u0072\u0001\u0067\u0001\u0075\u0001\uffff\u0001\u007a\u0001\uffff\u0001"+
    "\u007a\u0001\u0066\u0001\u007a\u0001\u0072\u0002\u007a\u0001\u0063\u0002"+
    "\uffff\u0001\u007a\u0001\uffff\u0001\u007a\u0002\uffff\u0001\u0074\u0002"+
    "\uffff\u0001\u0069\u0001\u006f\u0001\u006e\u0001\u007a\u0001\uffff",
    DFA19_acceptS:
        "\u001c\uffff\u0001\u00d5\u0001\u00d6\u0001\uffff\u0001\u00da\u0001"+
    "\u00db\u0001\u00dc\u0001\u00dd\u0002\uffff\u0001\u00e0\u0002\uffff\u0001"+
    "\u00e3\u0001\uffff\u0001\u00e5\u0001\u00e6\u0005\uffff\u0001\u00f7\u0001"+
    "\u00ff\u0001\uffff\u0001\u0103\u0001\u0104\u0001\u0105\u0001\u0106\u0001"+
    "\uffff\u0001\u010e\u0008\uffff\u0001\u0105\u0052\uffff\u0001\u00d3\u0001"+
    "\u00d8\u0001\u00f8\u0001\uffff\u0001\u010d\u0001\u00d4\u0001\u00d5\u0001"+
    "\u00d6\u0001\u00d7\u0001\u00d9\u0001\u00da\u0001\u00db\u0001\u00dc\u0001"+
    "\u00dd\u0001\u00de\u0001\u00f4\u0001\u00f3\u0001\u00df\u0001\u00f0\u0001"+
    "\u00e0\u0001\u00fa\u0001\u00e1\u0001\uffff\u0001\u00e2\u0001\u00e3\u0001"+
    "\u00fe\u0001\u00e4\u0001\u00e5\u0001\u00e6\u0001\u00fc\u0001\u00e7\u0001"+
    "\u00ea\u0001\u00ec\u0001\u00f6\u0002\uffff\u0001\u00e8\u0001\u00eb\u0001"+
    "\u00ed\u0001\u00e9\u0001\u00ef\u0001\u00f5\u0001\u00ee\u0001\u00f2\u0001"+
    "\u00f1\u0001\uffff\u0001\u00f7\u0001\u00ff\u0001\u0100\u0001\u0103\u0001"+
    "\u0104\u0001\u0106\u0001\u010a\u0002\uffff\u0001\u010c\u0004\uffff\u0001"+
    "\u0004\u0001\uffff\u0001\u0006\u0008\uffff\u0001\u000a\u001b\uffff\u0001"+
    "\u0020\u000e\uffff\u0001\u0028\u0002\uffff\u0001\u002a\u0001\uffff\u0001"+
    "\u002c\u0006\uffff\u0001\u002e\u0001\u0032\u0007\uffff\u0001\u0035\u0001"+
    "\u0038\u0007\uffff\u0001\u003c\u0003\uffff\u0001\u00a9\u0001\uffff\u0001"+
    "\u0041\u0002\uffff\u0001\u0043\u0002\uffff\u0001\u00ce\u001d\uffff\u0001"+
    "\u005c\u0019\uffff\u0001\u00f9\u0001\u0107\u0001\u0102\u0001\u0101\u0001"+
    "\uffff\u0001\u00fd\u0001\u0109\u0001\u010b\u0002\uffff\u0001\u0003\u0001"+
    "\u0097\u0004\uffff\u0001\u0096\u0003\uffff\u0001\u00d0\u0014\uffff\u0001"+
    "\u0018\u0009\uffff\u0001\u006d\u0008\uffff\u0001\u0026\u0013\uffff\u0001"+
    "\u0034\u0003\uffff\u0001\u0037\u0005\uffff\u0001\u0039\u0007\uffff\u0001"+
    "\u00aa\u002b\uffff\u0001\u007d\u0016\uffff\u0001\u0073\u0001\uffff\u0001"+
    "\u00cd\u0009\uffff\u0001\u00d1\u0004\uffff\u0001\u000b\u0001\uffff\u0001"+
    "\u000c\u000b\uffff\u0001\u0085\u000c\uffff\u0001\u001c\u0007\uffff\u0001"+
    "\u00c2\u0005\uffff\u0001\u009f\u0003\uffff\u0001\u00a3\u0002\uffff\u0001"+
    "\u002b\u0007\uffff\u0001\u0089\u0002\uffff\u0001\u0033\u0001\u008c\u0004"+
    "\uffff\u0001\u00c3\u0002\uffff\u0001\u00a8\u0002\uffff\u0001\u0074\u0003"+
    "\uffff\u0001\u003f\u0001\uffff\u0001\u0040\u0003\uffff\u0001\u0075\u0012"+
    "\uffff\u0001\u00b6\u0001\uffff\u0001\u00b0\u0002\uffff\u0001\u0055\u0002"+
    "\uffff\u0001\u0056\u0002\uffff\u0001\u0092\u0005\uffff\u0001\u005a\u0001"+
    "\u005b\u0003\uffff\u0001\u007f\u000d\uffff\u0001\u0080\u0003\uffff\u0001"+
    "\u0095\u0003\uffff\u0001\u00be\u0002\uffff\u0001\u00d2\u0001\u00fb\u0001"+
    "\u0108\u0003\uffff\u0001\u004f\u0001\uffff\u0001\u0083\u0004\uffff\u0001"+
    "\u00c0\u0001\uffff\u0001\u0067\u0001\u000e\u0001\u00c6\u0009\uffff\u0001"+
    "\u0069\u0005\uffff\u0001\u006c\u0006\uffff\u0001\u001d\u0002\uffff\u0001"+
    "\u0021\u0007\uffff\u0001\u0087\u0001\uffff\u0001\u00a1\u0001\u00a2\u0002"+
    "\uffff\u0001\u006e\u0008\uffff\u0001\u00cb\u0001\uffff\u0001\u0036\u0008"+
    "\uffff\u0001\u008e\u0004\uffff\u0001\u0044\u000f\uffff\u0001\u0059\u0001"+
    "\uffff\u0001\u007b\u0003\uffff\u0001\u00b1\u000a\uffff\u0001\u005d\u0002"+
    "\uffff\u0001\u00b8\u0001\u005f\u0004\uffff\u0001\u00ba\u0001\uffff\u0001"+
    "\u0094\u0002\uffff\u0001\u0064\u0001\u00c5\u0004\uffff\u0001\u00bf\u0006"+
    "\uffff\u0001\u008b\u0002\uffff\u0001\u0084\u000f\uffff\u0001\u0086\u0007"+
    "\uffff\u0001\u009d\u0001\u0022\u0009\uffff\u0001\u002d\u0002\uffff\u0001"+
    "\u0088\u0005\uffff\u0001\u00a6\u0001\uffff\u0001\u003a\u0001\u008d\u0005"+
    "\uffff\u0001\u0042\u0002\uffff\u0001\u004e\u0001\u00ab\u0001\u0047\u0009"+
    "\uffff\u0001\u00ae\u0001\uffff\u0001\u0058\u0001\u0057\u0003\uffff\u0001"+
    "\u0052\u0003\uffff\u0001\u007c\u0001\uffff\u0001\u0050\u0001\u008f\u0006"+
    "\uffff\u0001\u00cf\u0006\uffff\u0001\u0081\u0002\uffff\u0001\u00bb\u0001"+
    "\u0065\u000a\uffff\u0001\u0010\u0002\uffff\u0001\u0068\u0001\u0099\u0003"+
    "\uffff\u0001\u0013\u0001\uffff\u0001\u0014\u0006\uffff\u0001\u001b\u0003"+
    "\uffff\u0001\u009e\u0001\uffff\u0001\u00c9\u0001\u00ca\u0004\uffff\u0001"+
    "\u002f\u000c\uffff\u0001\u0045\u0007\uffff\u0001\u0077\u0009\uffff\u0001"+
    "\u007a\u0001\uffff\u0001\u0090\u000a\uffff\u0001\u0063\u0001\u00bd\u0003"+
    "\uffff\u0001\u0001\u0002\uffff\u0001\u0066\u0001\u0008\u0001\uffff\u0001"+
    "\u000d\u0004\uffff\u0001\u0098\u0001\u00c1\u0007\uffff\u0001\u009c\u0001"+
    "\uffff\u0001\u0019\u0001\uffff\u0001\u001f\u0001\u0023\u0001\uffff\u0001"+
    "\u0027\u0001\uffff\u0001\u0029\u0001\uffff\u0001\u0030\u0003\uffff\u0001"+
    "\u0070\u0001\u00a5\u0006\uffff\u0001\u0046\u0003\uffff\u0001\u004a\u0001"+
    "\u0079\u0002\uffff\u0001\u008a\u0001\uffff\u0001\u00b5\u0005\uffff\u0001"+
    "\u00b3\u0005\uffff\u0001\u007e\u0001\uffff\u0001\u0093\u0001\uffff\u0001"+
    "\u0061\u0001\u0062\u0003\uffff\u0001\u0005\u0001\u0007\u0001\uffff\u0001"+
    "\u000f\u0009\uffff\u0001\u009b\u0003\uffff\u0001\u0024\u0001\u00a0\u0002"+
    "\uffff\u0001\u0031\u0001\u00cc\u0001\u00a7\u0002\uffff\u0001\u003b\u0002"+
    "\uffff\u0001\u004d\u0001\uffff\u0001\u00ac\u0002\uffff\u0001\u0048\u0001"+
    "\uffff\u0001\u0078\u0001\uffff\u0001\u0051\u0002\uffff\u0001\u00b2\u0001"+
    "\u00b4\u0001\u00c4\u0002\uffff\u0001\u00b7\u0001\uffff\u0001\u0060\u0001"+
    "\u00b9\u0001\u00bc\u0003\uffff\u0001\u00c7\u0001\uffff\u0001\u00c8\u0004"+
    "\uffff\u0001\u0015\u0001\u0017\u0001\u009a\u0005\uffff\u0001\u0071\u0001"+
    "\uffff\u0001\u003d\u0001\uffff\u0001\u00ad\u0008\uffff\u0001\u005e\u0001"+
    "\u0082\u000b\uffff\u0001\u00a4\u0001\uffff\u0001\u003e\u000a\uffff\u0001"+
    "\u0011\u000f\uffff\u0001\u0091\u0001\u00af\u0006\uffff\u0001\u001a\u000b"+
    "\uffff\u0001\u0009\u0001\uffff\u0001\u006a\u0002\uffff\u0001\u001e\u0002"+
    "\uffff\u0001\u0072\u0005\uffff\u0001\u0054\u0001\uffff\u0001\u0012\u0007"+
    "\uffff\u0001\u004c\u0001\uffff\u0001\u0002\u0007\uffff\u0001\u0053\u0001"+
    "\u006b\u0001\uffff\u0001\u0025\u0001\uffff\u0001\u0076\u0001\u0049\u0001"+
    "\uffff\u0001\u0016\u0001\u006f\u0004\uffff\u0001\u004b",
    DFA19_specialS:
        "\u0001\u0001\u001a\uffff\u0001\u0002\u01f6\uffff\u0001\u0000\u02f8"+
    "\uffff}>",
    DFA19_transitionS: [
            "\u0009\u0039\u0002\u0037\u0002\u0039\u0001\u0037\u0012\u0039"+
            "\u0001\u0037\u0001\u0024\u0001\u0035\u0001\u0026\u0001\u001d"+
            "\u0001\u0025\u0001\u0027\u0001\u0034\u0001\u001b\u0001\u001c"+
            "\u0001\u002a\u0001\u002b\u0001\u0028\u0001\u002c\u0001\u0030"+
            "\u0001\u002f\u000a\u0038\u0001\u0023\u0001\u0031\u0001\u002d"+
            "\u0001\u0022\u0001\u002e\u0001\u0029\u0001\u0032\u000d\u0036"+
            "\u0001\u0016\u0002\u0036\u0001\u0033\u0009\u0036\u0001\u0020"+
            "\u0001\u0039\u0001\u0021\u0001\u0039\u0001\u0036\u0001\u0039"+
            "\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005"+
            "\u0001\u0006\u0001\u0007\u0001\u0036\u0001\u0008\u0001\u000c"+
            "\u0001\u0018\u0001\u0009\u0001\u000a\u0001\u000b\u0001\u000d"+
            "\u0001\u000e\u0001\u0019\u0001\u0010\u0001\u000f\u0001\u0011"+
            "\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0036"+
            "\u0001\u0017\u0001\u001e\u0001\u001a\u0001\u001f\uff82\u0039",
            "\u0001\u003f\u0005\uffff\u0001\u003e\u0001\u0041\u0001\u003a"+
            "\u0001\uffff\u0001\u0040\u0001\uffff\u0001\u003d\u0001\u003b"+
            "\u0001\u003c",
            "\u0001\u0043\u0003\uffff\u0001\u0046\u0009\uffff\u0001\u0044"+
            "\u0002\uffff\u0001\u0047\u0006\uffff\u0001\u0045",
            "\u0001\u0048\u0006\uffff\u0001\u0049\u0006\uffff\u0001\u004a",
            "\u0001\u004b\u0003\uffff\u0001\u004c\u0005\uffff\u0001\u004d",
            "\u0001\u004e\u0001\u004f\u0001\u0050\u0002\uffff\u0001\u0051"+
            "\u0004\uffff\u0001\u0052\u0001\uffff\u0001\u0053",
            "\u0001\u0056\u0005\uffff\u0001\u0054\u0002\uffff\u0001\u0057"+
            "\u0001\uffff\u0001\u0058\u0001\u0055",
            "\u0001\u0059\u000c\uffff\u0001\u005a\u0001\uffff\u0001\u005b",
            "\u0001\u005c\u0001\uffff\u0001\u005d\u0006\uffff\u0001\u005e"+
            "\u0001\u005f\u0004\uffff\u0001\u0060\u0001\u0061",
            "\u0001\u0062\u0003\uffff\u0001\u0063\u0009\uffff\u0001\u0065"+
            "\u0004\uffff\u0001\u0064",
            "\u0001\u0067\u0005\uffff\u0001\u0066",
            "\u0001\u0068\u0003\uffff\u0001\u0069\u0009\uffff\u0001\u006a",
            "\u0001\u006b",
            "\u0001\u006f\u0001\u0071\u0002\uffff\u0001\u006c\u0007\uffff"+
            "\u0001\u0070\u0001\uffff\u0001\u006d\u0001\uffff\u0001\u006e",
            "\u0001\u0072\u0003\uffff\u0001\u0074\u0002\uffff\u0001\u0076"+
            "\u0006\uffff\u0001\u0075\u0002\uffff\u0001\u0073",
            "\u0001\u0078\u0001\uffff\u0001\u0079\u0001\uffff\u0001\u007a"+
            "\u0005\uffff\u0001\u007e\u0001\u007c\u0002\uffff\u0001\u007b"+
            "\u0004\uffff\u0001\u0077\u0002\uffff\u0001\u007d",
            "\u0001\u007f",
            "\u0001\u0080\u0002\uffff\u0001\u0081\u0001\u0086\u0005\uffff"+
            "\u0001\u0082\u0002\uffff\u0001\u0083\u0002\uffff\u0001\u0085"+
            "\u0003\uffff\u0001\u0084",
            "\u0001\u0087\u0001\uffff\u0001\u0088\u0002\uffff\u0001\u0089",
            "\u0001\u008a\u0003\uffff\u0001\u008b",
            "\u0001\u008e\u0002\uffff\u0001\u008c\u0001\u008d\u0005\uffff"+
            "\u0001\u008f",
            "\u0001\u0090",
            "\u0001\u0091",
            "\u0001\u0092",
            "\u0001\u0093",
            "\u0001\u0094",
            "\u0001\u0095\u0001\u0096",
            "\u0001\u0098\u0016\uffff\u0001\u0099",
            "",
            "",
            "\u0001\u009d",
            "",
            "",
            "",
            "",
            "\u0001\u00a4\u0002\uffff\u0001\u00a3",
            "\u0001\u00a6",
            "",
            "\u0001\u00a9",
            "\u0001\u00ab",
            "",
            "\u0001\u00ae",
            "",
            "",
            "\u0001\u00b2",
            "\u0001\u00b7\u000d\uffff\u0001\u00b6\u000c\uffff\u0001\u00b5"+
            "\u0001\u00b4\u0001\uffff\u0001\u00b8",
            "\u0001\u00ba\u0001\u00bb",
            "\u0001\u00bd\u000e\uffff\u0001\u00be",
            "\u0001\u00c0\u0001\uffff\u000a\u00c2",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "",
            "",
            "",
            "\u0001\u00cb\u0001\uffff\u000a\u00ca\u000b\uffff\u0001\u00cc"+
            "\u001f\uffff\u0001\u00cc",
            "",
            "\u0001\u00cd\u0001\u00ce\u0014\uffff\u0001\u00cf",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0002\u0042\u0001\u00d0"+
            "\u0017\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0013\u0042\u0001\u00d2"+
            "\u0006\u0042",
            "\u0001\u00d4",
            "\u0001\u00d5",
            "\u0001\u00d6",
            "\u0001\u00d8\u0001\u00d7",
            "\u0001\u00d9",
            "",
            "\u0001\u00da",
            "\u0001\u00db",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u00dd",
            "\u0001\u00de",
            "\u0001\u00df\u0001\u00e0",
            "\u0001\u00e2\u0003\uffff\u0001\u00e1",
            "\u0001\u00e3\u0001\u00e4\u0001\u00e5\u0001\uffff\u0001\u00e6"+
            "\u0004\uffff\u0001\u00e7",
            "\u0001\u00e8\u0002\uffff\u0001\u00e9\u0005\uffff\u0001\u00eb"+
            "\u0006\uffff\u0001\u00ea",
            "\u0001\u00ee\u0004\uffff\u0001\u00ef\u0001\u00ed\u000b\uffff"+
            "\u0001\u00f0\u0002\uffff\u0001\u00ec",
            "\u0001\u00f1",
            "\u0001\u00f2\u000d\uffff\u0001\u00f3",
            "\u0001\u00f4",
            "\u0001\u00f5\u0001\u00f6\u000f\uffff\u0001\u00f7",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u00f9",
            "\u0001\u00fc\u0001\uffff\u0001\u00fa\u0005\uffff\u0001\u00fd"+
            "\u000a\uffff\u0001\u00fb",
            "\u0001\u00fe\u0005\uffff\u0001\u00ff",
            "\u0001\u0100",
            "\u0001\u0101",
            "\u0001\u0102",
            "\u0001\u0103\u0033\uffff\u0001\u0104\u000c\uffff\u0001\u0105"+
            "\u0001\u0106",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0108\u0009\uffff\u0001\u0109",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u010b",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u010d",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0003\u0042\u0001\u0112"+
            "\u0001\u0042\u0001\u0111\u0001\u0042\u0001\u010e\u000a\u0042"+
            "\u0001\u010f\u0001\u0110\u0006\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0115",
            "\u0001\u0118\u0004\uffff\u0001\u0117\u0004\uffff\u0001\u0116",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0001\u0119\u0012\u0042"+
            "\u0001\u011a\u0001\u0042\u0001\u011b\u0004\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u011f\u0007\uffff\u0001\u011e",
            "\u0001\u0120\u000e\uffff\u0001\u0121",
            "\u0001\u0122",
            "\u0001\u0123",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0017\u0042\u0001\u0124"+
            "\u0002\u0042",
            "\u0001\u0126\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u0003\u0042"+
            "\u0001\u0127\u000f\u0042\u0001\u0128\u0006\u0042",
            "\u0001\u012a",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u012c",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0003\u0042\u0001\u012d"+
            "\u0016\u0042",
            "\u0001\u012f",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u000b\u0042\u0001\u0130"+
            "\u000e\u0042",
            "\u0001\u0132",
            "\u0001\u0133\u0001\uffff\u0001\u0134",
            "\u0001\u0135\u0009\uffff\u0001\u0136",
            "\u0001\u0137",
            "\u0001\u0138",
            "\u0001\u0139",
            "\u0001\u013b\u0003\uffff\u0001\u013c\u0009\uffff\u0001\u013d"+
            "\u0002\uffff\u0001\u013a",
            "\u0001\u013f\u0006\uffff\u0001\u013e",
            "\u0001\u0140\u0006\uffff\u0001\u0141",
            "\u0001\u0142\u0001\uffff\u0001\u0143",
            "\u0001\u0144",
            "\u0001\u0145",
            "\u0001\u0146",
            "\u0001\u0147",
            "\u0001\u014c\u0001\uffff\u0001\u0149\u0001\uffff\u0001\u014a"+
            "\u0003\uffff\u0001\u0148\u0001\uffff\u0001\u014b",
            "\u0001\u014d",
            "\u0001\u014e",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0150\u0013\uffff\u0001\u0151",
            "\u0001\u0152",
            "\u0001\u0153",
            "\u0001\u0154",
            "\u0001\u0155\u0005\uffff\u0001\u0156",
            "\u0001\u0157\u000b\uffff\u0001\u0158",
            "\u0001\u0159",
            "\u0001\u015a\u0005\uffff\u0001\u015b",
            "\u0001\u015c",
            "\u0001\u015d\u0003\uffff\u0001\u015e",
            "\u0001\u0161\u0001\uffff\u0001\u015f\u0005\uffff\u0001\u0160",
            "\u0001\u0162",
            "\u0001\u0163",
            "\u0001\u0164",
            "\u0001\u0165",
            "\u0001\u0166",
            "\u0001\u0167",
            "\u0001\u0168",
            "",
            "",
            "",
            "\u0002\u016a\u0002\uffff\u0001\u016a\u0012\uffff\u0001\u016a"+
            "\u0020\uffff\u001a\u016a\u0004\uffff\u0001\u016a\u0001\uffff"+
            "\u001a\u016a",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\u0001\u016b",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\u0001\u016d",
            "\u0002\u016f\u0002\uffff\u0001\u016f\u0012\uffff\u0001\u016f"+
            "\u0020\uffff\u001a\u016f\u0004\uffff\u0001\u016f\u0001\uffff"+
            "\u001a\u016f",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\u000a\u00c2\u000b\uffff\u0001\u00cc\u001f\uffff\u0001\u00cc",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\u0001\u00cb\u0001\uffff\u000a\u00ca\u000b\uffff\u0001\u00cc"+
            "\u001f\uffff\u0001\u00cc",
            "\u000a\u0171\u000b\uffff\u0001\u00cc\u001f\uffff\u0001\u00cc",
            "",
            "\u0001\u0172",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0175",
            "",
            "\u0001\u0176",
            "",
            "\u0001\u0177",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u000e\u0042\u0001\u0178"+
            "\u000b\u0042",
            "\u0001\u017a",
            "\u0001\u017b",
            "\u0001\u017c",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u017e",
            "\u0001\u017f",
            "",
            "\u0001\u0180",
            "\u0001\u0181",
            "\u0001\u0182\u000e\uffff\u0001\u0183",
            "\u0001\u0184",
            "\u0001\u0185",
            "\u0001\u0186",
            "\u0001\u0187",
            "\u0001\u0188",
            "\u0001\u0189\u0001\u018a",
            "\u0001\u018b",
            "\u0001\u018c",
            "\u0001\u018e\u0002\uffff\u0001\u018d",
            "\u0001\u018f",
            "\u0001\u0190",
            "\u0001\u0191",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0193",
            "\u0001\u0194",
            "\u0001\u0195",
            "\u0001\u0196",
            "\u0001\u0197",
            "\u0001\u0198",
            "\u0001\u0199",
            "\u0001\u019a",
            "\u0001\u019b",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u019d",
            "",
            "\u0001\u019e",
            "\u0001\u019f",
            "\u0001\u01a0",
            "\u0001\u01a1",
            "\u0001\u01a2",
            "\u0001\u01a3",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0004\u0042\u0001\u01a4"+
            "\u0015\u0042",
            "\u0001\u01a6",
            "\u0001\u01a7",
            "\u0001\u01a8",
            "\u0001\u01a9",
            "\u0001\u01aa",
            "\u0001\u01ab",
            "\u0001\u01ac",
            "",
            "\u0001\u01ad",
            "\u0001\u01ae",
            "",
            "\u0001\u01af",
            "",
            "\u0001\u01b0",
            "\u0001\u01b1",
            "\u0001\u01b3\u000e\uffff\u0001\u01b2",
            "\u0001\u01b4\u0009\uffff\u0001\u01b5",
            "\u0001\u01b6",
            "\u0001\u01b7",
            "",
            "",
            "\u0001\u01b8",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u01ba",
            "\u0001\u01bb",
            "\u0001\u01bc",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u01be",
            "",
            "",
            "\u0001\u01bf",
            "\u0001\u01c0",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0008\u0042\u0001\u01c2"+
            "\u000b\u0042\u0001\u01c1\u0005\u0042",
            "\u0001\u01c4",
            "\u0001\u01c5",
            "\u0001\u01c6",
            "\u0001\u01c7",
            "",
            "\u0001\u01c8\u0006\uffff\u0001\u01c9",
            "\u0001\u01ca",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u01cc",
            "",
            "\u0001\u01cd",
            "\u0001\u01ce",
            "",
            "\u0001\u01cf",
            "\u0001\u01d0",
            "",
            "\u0001\u01d1",
            "\u0001\u01d3\u0003\uffff\u0001\u01d2",
            "\u0001\u01d4",
            "\u0001\u01d5\u000f\uffff\u0001\u01d6\u0002\uffff\u0001\u01d7",
            "\u0001\u01d8",
            "\u0001\u01da\u0035\uffff\u0001\u01d9",
            "\u0001\u01db",
            "\u0001\u01dc",
            "\u0001\u01de\u000b\uffff\u0001\u01dd",
            "\u0001\u01df\u000f\uffff\u0001\u01e0",
            "\u0001\u01e1",
            "\u0001\u01e2",
            "\u0001\u01e3",
            "\u0001\u01e4",
            "\u0001\u01e5",
            "\u0001\u01e6",
            "\u0001\u01e7",
            "\u0001\u01e8\u0001\u01e9",
            "\u0001\u01ea",
            "\u0001\u01eb",
            "\u0001\u01ec",
            "\u0001\u01ed",
            "\u0001\u01ee",
            "\u0001\u01ef",
            "\u0001\u01f0",
            "\u0001\u01f1",
            "\u0001\u01f2",
            "\u0001\u01f3",
            "\u0001\u01f4\u0004\uffff\u0001\u01f5",
            "",
            "\u0001\u01f6",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u01f8",
            "\u0001\u01f9",
            "\u0001\u01fa",
            "\u0001\u01fb\u0001\uffff\u0001\u01fc",
            "\u0001\u01fd",
            "\u0001\u01fe",
            "\u0001\u01ff",
            "\u0001\u0200",
            "\u0001\u0201\u000b\uffff\u0001\u0202",
            "\u0001\u0203",
            "\u0001\u0204",
            "\u0001\u0206\u0003\uffff\u0001\u0205",
            "\u0001\u0207",
            "\u0001\u0208",
            "\u0001\u0209",
            "\u0001\u020a",
            "\u0001\u020b",
            "\u0001\u020c",
            "\u0001\u020d",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u020f",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0211",
            "",
            "",
            "",
            "",
            "\u0001\u0212",
            "",
            "",
            "",
            "\u000a\u0171\u000b\uffff\u0001\u00cc\u001f\uffff\u0001\u00cc",
            "\u0001\u0213",
            "",
            "",
            "\u0001\u0214",
            "\u0001\u0215",
            "\u0001\u0216",
            "\u0001\u0217",
            "",
            "\u0001\u0218",
            "\u0001\u0219",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u021b",
            "\u0001\u021c",
            "\u0001\u021d",
            "\u0001\u021e",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0001\u0220\u0019\u0042",
            "\u0001\u0222",
            "\u0001\u0223",
            "\u0001\u0224",
            "\u0001\u0225\u0003\uffff\u0001\u0226",
            "\u0001\u0227",
            "\u0001\u0228",
            "\u0001\u022a\u0003\uffff\u0001\u0229\u0003\uffff\u0001\u022b",
            "\u0001\u022c\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u022e",
            "\u0001\u022f",
            "\u0001\u0230",
            "\u0001\u0231",
            "\u0001\u0232",
            "\u0001\u0233",
            "",
            "\u0001\u0234",
            "\u0001\u0235",
            "\u0001\u0236",
            "\u0001\u0237",
            "\u0001\u0238",
            "\u0001\u0239",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u023b",
            "\u0001\u023c",
            "",
            "\u0001\u023d",
            "\u0001\u023e",
            "\u0001\u023f",
            "\u0001\u0240",
            "\u0001\u0241",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0243",
            "\u0001\u0244\u0007\uffff\u0001\u0245",
            "",
            "\u0001\u0246",
            "\u0001\u0247",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0249",
            "\u0001\u024a",
            "\u0001\u024b",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u024d",
            "\u0001\u024e",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0250",
            "\u0001\u0251",
            "\u0001\u0252",
            "\u0001\u0254\u0003\uffff\u0001\u0253",
            "\u0001\u0256\u000a\uffff\u0001\u0255",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0258",
            "\u0001\u0259",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u025c",
            "\u0001\u025d",
            "",
            "\u0001\u025e",
            "\u0001\u025f",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0261",
            "\u0001\u0262",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0264",
            "\u0001\u0265",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0267",
            "\u0001\u0268",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0012\u0042\u0001\u0269"+
            "\u0007\u0042",
            "",
            "\u0001\u026b\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u026d",
            "\u0001\u026e",
            "\u0001\u026f",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0271",
            "\u0001\u0272",
            "\u0001\u0273",
            "\u0001\u0274",
            "\u0001\u0275",
            "\u0001\u0276",
            "\u0001\u0277",
            "\u0001\u0278",
            "\u0001\u0279",
            "\u0001\u027a",
            "\u0001\u027b",
            "\u0001\u027c",
            "\u0001\u027d",
            "\u0001\u027e\u000c\uffff\u0001\u027f",
            "\u0001\u0280",
            "\u0001\u0281",
            "\u0001\u0282",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0284",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0286",
            "\u0001\u0287",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0289",
            "\u0001\u028a",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u028c",
            "\u0001\u028d",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u028f",
            "\u0001\u0290",
            "\u0001\u0291",
            "\u0001\u0292",
            "\u0001\u0293",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0296",
            "\u0001\u0297",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0012\u0042\u0001\u0298"+
            "\u0007\u0042",
            "\u0001\u029a",
            "\u0001\u029b",
            "\u0001\u029c",
            "\u0001\u029d",
            "\u0001\u029e",
            "\u0001\u029f",
            "\u0001\u02a0",
            "\u0001\u02a1",
            "\u0001\u02a2",
            "\u0001\u02a3",
            "\u0001\u02a4",
            "\u0001\u02a5",
            "\u0001\u02a6",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u02a8",
            "\u0001\u02a9",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u000e\u0042\u0001\u02aa"+
            "\u000b\u0042",
            "\u0001\u02ac",
            "\u0001\u02ad",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0012\u0042\u0001\u02ae"+
            "\u0007\u0042",
            "\u0001\u02b0",
            "",
            "\u0001\u02b1",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0000\u02b4",
            "\u0001\u02b5",
            "\u0001\u02b6",
            "\u0001\u02b7",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u02b9",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u02bb",
            "",
            "\u0001\u02bc",
            "\u0001\u02bd",
            "\u0001\u02be",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u02c0",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u02c4",
            "\u0001\u02c5",
            "\u0001\u02c6",
            "\u0001\u02c7",
            "\u0001\u02c9\u0009\uffff\u0001\u02c8",
            "\u0001\u02ca",
            "\u0001\u02cb",
            "\u0001\u02cc",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u02ce",
            "\u0001\u02cf",
            "\u0001\u02d0",
            "\u0001\u02d1",
            "\u0001\u02d2",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u02d4",
            "\u0001\u02d5",
            "\u0001\u02d6",
            "\u0001\u02d7",
            "\u0001\u02d8",
            "",
            "\u0001\u02d9\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u02db",
            "\u0001\u02dc",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u02de",
            "\u0001\u02df",
            "\u0001\u02e0",
            "",
            "\u0001\u02e1",
            "\u0001\u02e2",
            "\u0001\u02e3",
            "\u0001\u02e4",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u02e6",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u02e9",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0008\u0042\u0001\u02ea"+
            "\u0011\u0042",
            "",
            "\u0001\u02ec",
            "\u0001\u02ed",
            "\u0001\u02ee",
            "\u0001\u02ef",
            "\u0001\u02f0",
            "\u0001\u02f1",
            "\u0001\u02f2",
            "",
            "\u0001\u02f3",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "",
            "\u0001\u02f5",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u02f7",
            "\u0001\u02f8",
            "",
            "\u0001\u02f9",
            "\u0001\u02fa",
            "",
            "\u0001\u02fb",
            "\u0001\u02fc",
            "",
            "\u0001\u02fd",
            "\u0001\u02fe",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u0300",
            "",
            "\u0001\u0301",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0004\u0042\u0001\u0302"+
            "\u0003\u0042\u0001\u0303\u0011\u0042",
            "\u0001\u0305",
            "",
            "\u0001\u0306",
            "\u0001\u0307",
            "\u0001\u0308",
            "\u0001\u0309",
            "\u0001\u030a",
            "\u0001\u030b",
            "\u0001\u030c",
            "\u0001\u030d",
            "\u0001\u030e",
            "\u0001\u030f",
            "\u0001\u0310",
            "\u0001\u0311",
            "\u0001\u0312",
            "\u0001\u0313",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0315",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0317",
            "",
            "\u0001\u0318",
            "",
            "\u0001\u0319",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u031b",
            "\u0001\u031c",
            "",
            "\u0001\u031d",
            "\u0001\u031e",
            "",
            "\u0001\u031f",
            "\u0001\u0320",
            "\u0001\u0321",
            "\u0001\u0322",
            "\u0001\u0323",
            "",
            "",
            "\u0001\u0324",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0326",
            "",
            "\u0001\u0327",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u032a",
            "\u0001\u032b",
            "\u0001\u032c",
            "\u0001\u032d",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u032f",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0331",
            "\u0001\u0332",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0335",
            "\u0001\u0336",
            "",
            "\u0001\u0337",
            "\u0001\u0338",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u033a",
            "\u0001\u033b",
            "",
            "",
            "",
            "\u0001\u033c",
            "\u0001\u033d",
            "\u0001\u033e",
            "",
            "\u0001\u033f",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0341",
            "\u0001\u0342",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u0344",
            "",
            "",
            "",
            "\u0001\u0345",
            "\u0001\u0346",
            "\u0001\u0347",
            "\u0001\u0349\u0013\uffff\u0001\u0348",
            "\u0001\u034a",
            "\u0001\u034b",
            "\u0001\u034c",
            "\u0001\u034d",
            "\u0001\u034e",
            "",
            "\u0001\u034f",
            "\u0001\u0350",
            "\u0001\u0351",
            "\u0001\u0352",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u0354",
            "\u0001\u0355",
            "\u0001\u0356",
            "\u0001\u0357",
            "\u0001\u0358",
            "\u0001\u0359",
            "",
            "\u0001\u035a",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u035d",
            "\u0001\u035e",
            "\u0001\u035f",
            "\u0001\u0360",
            "\u0001\u0361",
            "\u0001\u0362",
            "",
            "\u0001\u0363",
            "",
            "",
            "\u0001\u0364",
            "\u0001\u0365",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0367",
            "\u0001\u0368",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u036a",
            "\u0001\u036b",
            "\u0001\u036c",
            "\u0001\u036d",
            "",
            "\u0001\u036e",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0370",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0373",
            "\u0001\u0374",
            "\u0001\u0375",
            "\u0001\u0376",
            "",
            "\u0001\u0377",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0379",
            "\u0001\u037a",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u037e",
            "\u0001\u037f",
            "\u0001\u0380",
            "\u0001\u0381",
            "\u0001\u0382",
            "\u0001\u0383",
            "\u0001\u0384",
            "\u0001\u0385",
            "\u0001\u0386",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0388",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u038b",
            "\u0001\u038c",
            "\u0001\u038d\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u038f",
            "\u0001\u0390",
            "\u0001\u0391",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0008\u0042\u0001\u0393"+
            "\u0011\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0396",
            "\u0001\u0397",
            "\u0001\u0398",
            "\u0001\u0399",
            "",
            "\u0001\u039a",
            "\u0001\u039b",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u039d",
            "\u0001\u039e",
            "\u0001\u039f",
            "",
            "\u0001\u03a0",
            "",
            "\u0001\u03a1",
            "\u0001\u03a2",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03a4",
            "\u0001\u03a5",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03a8",
            "\u0001\u03a9",
            "\u0001\u03aa",
            "\u0001\u03ab",
            "\u0001\u03ac",
            "",
            "\u0001\u03ad",
            "\u0001\u03ae",
            "",
            "\u0001\u03af",
            "\u0001\u03b0",
            "\u0001\u03b1",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03b3",
            "\u0001\u03b4",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03b7",
            "\u0001\u03b8",
            "\u0001\u03b9",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03bb",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03bd\u0007\uffff\u0001\u03be",
            "",
            "\u0001\u03bf",
            "\u0001\u03c0",
            "\u0001\u03c1",
            "\u0001\u03c2",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03c4",
            "\u0001\u03c5",
            "",
            "",
            "\u0001\u03c6",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03c8",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03cb",
            "\u0001\u03cc",
            "\u0001\u03cd",
            "\u0001\u03ce",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03d0",
            "",
            "\u0001\u03d1",
            "\u0001\u03d2",
            "\u0001\u03d3",
            "\u0001\u03d4",
            "\u0001\u03d5",
            "",
            "\u0001\u03d6",
            "",
            "",
            "\u0001\u03d7",
            "\u0001\u03d8",
            "\u0001\u03d9",
            "\u0001\u03da",
            "\u0001\u03db",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03dd",
            "",
            "",
            "",
            "\u0001\u03de",
            "\u0001\u03df",
            "\u0001\u03e0",
            "\u0001\u03e1",
            "\u0001\u03e2",
            "\u0001\u03e3",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03e5",
            "\u0001\u03e6",
            "",
            "\u0001\u03e7",
            "",
            "",
            "\u0001\u03e8",
            "\u0001\u03e9",
            "\u0001\u03ea\u0003\uffff\u0001\u03eb",
            "",
            "\u0001\u03ec",
            "\u0001\u03ed",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u03ef",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03f1",
            "\u0001\u03f2",
            "\u0001\u03f3",
            "\u0001\u03f4",
            "\u0001\u03f5",
            "",
            "\u0001\u03f6",
            "\u0001\u03f7",
            "\u0001\u03f8",
            "\u0001\u03f9",
            "\u0001\u03fa",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u03fd",
            "",
            "",
            "\u0001\u03fe",
            "\u0001\u03ff\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0401",
            "\u0001\u0402",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0405",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0407",
            "\u0001\u0408",
            "",
            "\u0001\u0409",
            "\u0001\u040a",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u040d",
            "",
            "\u0001\u040e\u000c\uffff\u0001\u040f",
            "",
            "\u0001\u0410",
            "\u0001\u0411",
            "\u0001\u0412",
            "\u0001\u0413",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0415\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u0417",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u041a",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u041c",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u041e",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0420",
            "\u0001\u0421",
            "\u0001\u0422",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0425",
            "\u0001\u0426",
            "\u0001\u0427",
            "\u0001\u0428",
            "\u0001\u0429",
            "\u0001\u042a",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u042c",
            "\u0001\u042d",
            "\u0001\u042e",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0431",
            "",
            "\u0001\u0432",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0434",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0436",
            "\u0001\u0437",
            "\u0001\u0438",
            "\u0001\u0439",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0012\u0042\u0001\u043a"+
            "\u0007\u0042",
            "",
            "\u0001\u043c",
            "",
            "\u0001\u043d",
            "\u0001\u043e",
            "\u0001\u043f",
            "\u0001\u0440",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0442",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0444",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "",
            "\u0001\u0447",
            "\u0001\u0448",
            "\u0001\u0449",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "",
            "\u0001\u044c",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u044e",
            "\u0001\u044f",
            "\u0001\u0450",
            "",
            "",
            "\u0001\u0451",
            "\u0001\u0452",
            "\u0001\u0453",
            "\u0001\u0454",
            "\u0001\u0455",
            "\u0001\u0456",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u0458",
            "",
            "\u0001\u0459",
            "",
            "",
            "\u0001\u045a\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u045d",
            "",
            "\u0001\u045e",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0462",
            "\u0001\u0463\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0465",
            "\u0001\u0466",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u0012\u0042\u0001\u0468"+
            "\u0007\u0042",
            "\u0001\u046a",
            "\u0001\u046b\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "",
            "\u0001\u046d",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u046f",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0471",
            "\u0001\u0472",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0476",
            "\u0001\u0477",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0479",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u047d",
            "\u0001\u047e",
            "",
            "",
            "\u0001\u047f",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0481",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0483",
            "\u0001\u0484",
            "\u0001\u0485",
            "\u0001\u0486\u0001\u0042\u0001\uffff\u000a\u0042\u0007\uffff"+
            "\u001a\u0042\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u048a",
            "\u0001\u048b",
            "\u0001\u048c",
            "",
            "",
            "\u0001\u048d",
            "\u0001\u048e",
            "",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0490",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0492",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u0494",
            "\u0001\u0495",
            "",
            "\u0001\u0496",
            "",
            "\u0001\u0497",
            "",
            "\u0001\u0498",
            "\u0001\u0499",
            "",
            "",
            "",
            "\u0001\u049a",
            "\u0001\u049b",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u049e",
            "\u0001\u049f",
            "",
            "\u0001\u04a0",
            "",
            "\u0001\u04a1",
            "\u0001\u04a2",
            "\u0001\u04a3",
            "\u0001\u04a4",
            "",
            "",
            "",
            "\u0001\u04a5",
            "\u0001\u04a6",
            "\u0001\u04a7",
            "\u0001\u04a8",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u04aa",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u04ac",
            "\u0001\u04ad",
            "\u0001\u04ae",
            "\u0001\u04af",
            "\u0001\u04b0",
            "\u0001\u04b1",
            "\u0001\u04b2",
            "\u0001\u04b3",
            "",
            "",
            "\u0001\u04b4",
            "\u0001\u04b5",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04b7",
            "\u0001\u04b8",
            "\u0001\u04b9",
            "\u0001\u04ba",
            "\u0001\u04bb",
            "\u0001\u04bc",
            "\u0001\u04bd",
            "\u0001\u04be",
            "",
            "\u0001\u04bf",
            "",
            "\u0001\u04c0",
            "\u0001\u04c1",
            "\u0001\u04c2",
            "\u0001\u04c3",
            "\u0001\u04c4",
            "\u0001\u04c5",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04c8",
            "\u0001\u04c9",
            "",
            "\u0001\u04ca",
            "\u0001\u04cb",
            "\u0001\u04cc",
            "\u0001\u04cd",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04cf",
            "\u0001\u04d0",
            "\u0001\u04d1",
            "\u0001\u04d2",
            "\u0001\u04d3",
            "\u0001\u04d4",
            "\u0001\u04d5",
            "\u0001\u04d6",
            "\u0001\u04d7",
            "\u0001\u04d8",
            "",
            "",
            "\u0001\u04d9",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04db",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04dd",
            "\u0001\u04de",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04e0",
            "\u0001\u04e1",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04e3",
            "\u0001\u04e4",
            "\u0001\u04e5",
            "\u0001\u04e6",
            "\u0001\u04e7",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04e9",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u04eb",
            "\u0001\u04ec",
            "",
            "\u0001\u04ed",
            "\u0001\u04ee",
            "",
            "\u0001\u04ef",
            "\u0001\u04f0",
            "\u0001\u04f1",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04f3",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0001\u04f5",
            "\u0001\u04f6",
            "\u0001\u04f7",
            "\u0001\u04f8",
            "\u0001\u04f9",
            "\u0001\u04fa",
            "\u0001\u04fb",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u04fe",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0500",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "\u0001\u0503",
            "",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            "",
            "",
            "\u0001\u0506",
            "",
            "",
            "\u0001\u0507",
            "\u0001\u0508",
            "\u0001\u0509",
            "\u0002\u0042\u0001\uffff\u000a\u0042\u0007\uffff\u001a\u0042"+
            "\u0004\uffff\u0001\u0042\u0001\uffff\u001a\u0042",
            ""
    ]
});

org.antlr.lang.augmentObject(XQueryLexer, {
    DFA19_eot:
        org.antlr.runtime.DFA.unpackEncodedString(XQueryLexer.DFA19_eotS),
    DFA19_eof:
        org.antlr.runtime.DFA.unpackEncodedString(XQueryLexer.DFA19_eofS),
    DFA19_min:
        org.antlr.runtime.DFA.unpackEncodedStringToUnsignedChars(XQueryLexer.DFA19_minS),
    DFA19_max:
        org.antlr.runtime.DFA.unpackEncodedStringToUnsignedChars(XQueryLexer.DFA19_maxS),
    DFA19_accept:
        org.antlr.runtime.DFA.unpackEncodedString(XQueryLexer.DFA19_acceptS),
    DFA19_special:
        org.antlr.runtime.DFA.unpackEncodedString(XQueryLexer.DFA19_specialS),
    DFA19_transition: (function() {
        var a = [],
            i,
            numStates = XQueryLexer.DFA19_transitionS.length;
        for (i=0; i<numStates; i++) {
            a.push(org.antlr.runtime.DFA.unpackEncodedString(XQueryLexer.DFA19_transitionS[i]));
        }
        return a;
    })()
});

XQueryLexer.DFA19 = function(recognizer) {
    this.recognizer = recognizer;
    this.decisionNumber = 19;
    this.eot = XQueryLexer.DFA19_eot;
    this.eof = XQueryLexer.DFA19_eof;
    this.min = XQueryLexer.DFA19_min;
    this.max = XQueryLexer.DFA19_max;
    this.accept = XQueryLexer.DFA19_accept;
    this.special = XQueryLexer.DFA19_special;
    this.transition = XQueryLexer.DFA19_transition;
};

org.antlr.lang.extend(XQueryLexer.DFA19, org.antlr.runtime.DFA, {
    getDescription: function() {
        return "1:1: Tokens : ( ANCESTOR | ANCESTOR_OR_SELF | AND | AS | ASCENDING | AT | ATTRIBUTE | BASE_URI | BOUNDARY_SPACE | BY | CASE | CAST | CASTABLE | CHILD | COLLATION | COMMENT | CONSTRUCTION | COPY_NAMESPACES | DECLARE | DEFAULT | DESCENDANT | DESCENDANT_OR_SELF | DESCENDING | DIV | DOCUMENT | DOCUMENT_NODE | ELEMENT | ELSE | EMPTY | EMPTY_SEQUENCE | ENCODING | EQ | EVERY | EXCEPT | EXTERNAL | FOLLOWING | FOLLOWING_SIBLING | FOR | FUNCTION | GE | GREATEST | GT | IDIV | IF | IMPORT | IN | INHERIT | INSTANCE | INTERSECT | IS | ITEM | LAX | LE | LEAST | LET | LT | MOD | MODULE | NAMESPACE | NE | NO_INHERIT | NO_PRESERVE | NODE | JSON | OF | OPTION | OR | ORDER | ORDERED | ORDERING | PARENT | PRECEDING | PRECEDING_SIBLING | PRESERVE | PROCESSING_INSTRUCTION | STRUCTURED_ITEM | JSON_ITEM | OBJECT | ARRAY | RETURN | SATISFIES | SCHEMA | SCHEMA_ATTRIBUTE | SCHEMA_ELEMENT | SELF | SOME | STABLE | STRICT | STRIP | TEXT | THEN | TO | TREAT | TYPESWITCH | UNION | UNORDERED | VALIDATE | VARIABLE | VERSION | WHERE | XQUERY | ALLOWING | CATCH | CONTEXT | COUNT | DECIMAL_FORMAT | DECIMAL_SEPARATOR | DIGIT | END | GROUP | GROUPING_SEPARATOR | INFINITY | MINUS_SIGN | NAMESPACE_NODE | NAN | NEXT | ONLY | PATTERN_SEPARATOR | PERCENT | PER_MILLE | PREVIOUS | SLIDING | START | SWITCH | TRY | TUMBLING | TYPE | WHEN | WINDOW | ZERO_DIGIT | AFTER | BEFORE | COPY | DELETE | FIRST | INSERT | INTO | POSITION | APPEND | LAST | MODIFY | NODES | RENAME | REPLACE | REVALIDATION | SKIP | UPDATING | VALUE | WITH | ALL | ANY | CONTAINS | CONTENT | DIACRITICS | DIFFERENT | DISTANCE | ENTIRE | EXACTLY | FROM | FT_OPTION | FTAND | FTNOT | FTOR | INSENSITIVE | LANGUAGE | LEVELS | LOWERCASE | MOST | NO | NOT | OCCURS | PARAGRAPH | PARAGRAPHS | PHRASE | RELATIONSHIP | SAME | SCORE | SENSITIVE | SENTENCE | SENTENCES | STEMMING | STOP | THESAURUS | TIMES | UPPERCASE | USING | WEIGHT | WILDCARDS | WITHOUT | WORD | WORDS | BREAK | CONTINUE | EXIT | LOOP | RETURNING | WHILE | CHECK | COLLECTION | CONSTRAINT | FOREACH | FOREIGN | INDEX | INTEGRITY | KEY | ON | UNIQUE | AMP_ER | APOS_ER | QUOT_ER | CONCAT | LPAREN | RPAREN | DOLLAR | L_UNION_BRACKET | R_UNION_BRACKET | LBRACKET | RBRACKET | LSQUARE | RSQUARE | EQUAL | BIND | NOTEQUAL | ANN_PERCENT | HASH | AMP | COMMA | QUESTION | STAR | PLUS | MINUS | SMALLER | GREATER | SMALLEREQ | GREATEREQ | SMALLER_SMALLER | GREATER_GREATER | SLASH | SLASH_SLASH | BANG | DOT | DOT_DOT | COLON | COLON_COLON | EMPTY_CLOSE_TAG | CLOSE_TAG | SEMICOLON | VBAR | PRAGMA_START | PRAGMA_END | XML_COMMENT_START | XML_COMMENT_END | PI_START | PI_END | ATTR_SIGN | Q | CHARREF_DEC | CHARREF_HEX | APOS | QUOT | L_NCName | S | L_Pragma | L_DirCommentConstructor | L_DirPIConstructor | L_IntegerLiteral | L_DecimalLiteral | L_DoubleLiteral | L_Comment | L_AnyChar );";
    },
    specialStateTransition: function(s, input) {
        var _s = s;
        var retval = (function(s, input) {
            switch ( s ) {
                        case 0 : 
                            var LA19_530 = input.LA(1);

                            s = -1;
                            if ( ((LA19_530>='\u0000' && LA19_530<='\uFFFF')) ) {s = 692;}

                            else s = 691;

                            if ( s>=0 ) return s;
                            break;
                        case 1 : 
                            var LA19_0 = input.LA(1);

                            s = -1;
                            if ( (LA19_0=='a') ) {s = 1;}

                            else if ( (LA19_0=='b') ) {s = 2;}

                            else if ( (LA19_0=='c') ) {s = 3;}

                            else if ( (LA19_0=='d') ) {s = 4;}

                            else if ( (LA19_0=='e') ) {s = 5;}

                            else if ( (LA19_0=='f') ) {s = 6;}

                            else if ( (LA19_0=='g') ) {s = 7;}

                            else if ( (LA19_0=='i') ) {s = 8;}

                            else if ( (LA19_0=='l') ) {s = 9;}

                            else if ( (LA19_0=='m') ) {s = 10;}

                            else if ( (LA19_0=='n') ) {s = 11;}

                            else if ( (LA19_0=='j') ) {s = 12;}

                            else if ( (LA19_0=='o') ) {s = 13;}

                            else if ( (LA19_0=='p') ) {s = 14;}

                            else if ( (LA19_0=='s') ) {s = 15;}

                            else if ( (LA19_0=='r') ) {s = 16;}

                            else if ( (LA19_0=='t') ) {s = 17;}

                            else if ( (LA19_0=='u') ) {s = 18;}

                            else if ( (LA19_0=='v') ) {s = 19;}

                            else if ( (LA19_0=='w') ) {s = 20;}

                            else if ( (LA19_0=='x') ) {s = 21;}

                            else if ( (LA19_0=='N') ) {s = 22;}

                            else if ( (LA19_0=='z') ) {s = 23;}

                            else if ( (LA19_0=='k') ) {s = 24;}

                            else if ( (LA19_0=='q') ) {s = 25;}

                            else if ( (LA19_0=='|') ) {s = 26;}

                            else if ( (LA19_0=='(') ) {s = 27;}

                            else if ( (LA19_0==')') ) {s = 28;}

                            else if ( (LA19_0=='$') ) {s = 29;}

                            else if ( (LA19_0=='{') ) {s = 30;}

                            else if ( (LA19_0=='}') ) {s = 31;}

                            else if ( (LA19_0=='[') ) {s = 32;}

                            else if ( (LA19_0==']') ) {s = 33;}

                            else if ( (LA19_0=='=') ) {s = 34;}

                            else if ( (LA19_0==':') ) {s = 35;}

                            else if ( (LA19_0=='!') ) {s = 36;}

                            else if ( (LA19_0=='%') ) {s = 37;}

                            else if ( (LA19_0=='#') ) {s = 38;}

                            else if ( (LA19_0=='&') ) {s = 39;}

                            else if ( (LA19_0==',') ) {s = 40;}

                            else if ( (LA19_0=='?') ) {s = 41;}

                            else if ( (LA19_0=='*') ) {s = 42;}

                            else if ( (LA19_0=='+') ) {s = 43;}

                            else if ( (LA19_0=='-') ) {s = 44;}

                            else if ( (LA19_0=='<') ) {s = 45;}

                            else if ( (LA19_0=='>') ) {s = 46;}

                            else if ( (LA19_0=='/') ) {s = 47;}

                            else if ( (LA19_0=='.') ) {s = 48;}

                            else if ( (LA19_0==';') ) {s = 49;}

                            else if ( (LA19_0=='@') ) {s = 50;}

                            else if ( (LA19_0=='Q') ) {s = 51;}

                            else if ( (LA19_0=='\'') ) {s = 52;}

                            else if ( (LA19_0=='\"') ) {s = 53;}

                            else if ( ((LA19_0>='A' && LA19_0<='M')||(LA19_0>='O' && LA19_0<='P')||(LA19_0>='R' && LA19_0<='Z')||LA19_0=='_'||LA19_0=='h'||LA19_0=='y') ) {s = 54;}

                            else if ( ((LA19_0>='\t' && LA19_0<='\n')||LA19_0=='\r'||LA19_0==' ') ) {s = 55;}

                            else if ( ((LA19_0>='0' && LA19_0<='9')) ) {s = 56;}

                            else if ( ((LA19_0>='\u0000' && LA19_0<='\b')||(LA19_0>='\u000B' && LA19_0<='\f')||(LA19_0>='\u000E' && LA19_0<='\u001F')||LA19_0=='\\'||LA19_0=='^'||LA19_0=='`'||(LA19_0>='~' && LA19_0<='\uFFFF')) ) {s = 57;}

                            if ( s>=0 ) return s;
                            break;
                        case 2 : 
                            var LA19_27 = input.LA(1);

                             
                            var index19_27 = input.index();
                            input.rewind();
                            s = -1;
                            if ( (LA19_27=='#') ) {s = 152;}

                            else if ( (LA19_27==':') && ((!this.inStr))) {s = 153;}

                            else s = 154;

                             
                            input.seek(index19_27);
                            if ( s>=0 ) return s;
                            break;
            }
        }).call(this.recognizer, s, input);
        if (!org.antlr.lang.isUndefined(retval)) {
            return retval;
        }
        var nvae =
            new org.antlr.runtime.NoViableAltException(this.getDescription(), 19, _s, input);
        this.error(nvae);
        throw nvae;
    },
    dummy: null
});
 
})();
exports.XQueryLexer = XQueryLexer; });
define('ace/mode/xquery/XQDTLexer', ['require', 'exports', 'module' , 'ace/mode/xquery/antlr3-all'], function(require, exports, module) {

var org =  require("./antlr3-all").org;

var XQDTLexer = exports.XQDTLexer = function(input, state)
{
  XQDTLexer.superclass.constructor.call(this, input, state);
};

org.antlr.lang.extend(XQDTLexer, org.antlr.runtime.Lexer, {

  comments: [],

  addComment: function(start, stop){ this.comments.push({ start: start, stop: stop }); },

  isWsExplicit: false,

  setIsWsExplicit: function (wsExplicit) {
    //console.log("A WS: " + wsExplicit);
    this.isWsExplicit = wsExplicit;
    //console.log("B WS: " + wsExplicit);
  },

  addToStack: function (stack) {
    stack.push(this);
  },

  rewindToIndex: function(index) {
    var stream = this.input;
    stream.seek(index);
  }
});

});
define('ace/mode/xquery/XQueryParser', ['require', 'exports', 'module' , 'ace/mode/xquery/antlr3-all', 'ace/mode/xquery/StringLexer', 'ace/mode/xquery/XMLLexer', 'ace/mode/xquery/XQueryLexer', 'ace/mode/xquery/XQDTParser', 'ace/mode/xquery/Position'], function(require, exports, module) {// $ANTLR 3.3 Nov 30, 2010 12:50:56 /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g 2012-09-05 10:41:46

/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2010, Ajax.org B.V.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */
var org =  require("./antlr3-all").org;
var StringLexer   = require("./StringLexer").StringLexer;
var XMLLexer   = require("./XMLLexer").XMLLexer;
var XQueryLexer   = require("./XQueryLexer").XQueryLexer;
var XQDTParser = require("./XQDTParser").XQDTParser;
var Position = require("./Position").Position;
var Exception = function(){};

var XQS = true;
var XQU = true;
var ZORBA = true;



var XQueryParser = function(input, state) {
    if (!state) {
        state = new org.antlr.runtime.RecognizerSharedState();
    }

    (function(){


        this.isInAttr = false;

        this.errors = [];

        this.hasErrors = function(){
          return this.errors.length > 0;
        };

        this.addError = function(error){
          this.errors.push(error);
        };

        this.getErrors = function(){
          return this.errors;
        };

        this.source = null;
        this.setSource = function(s){
          this.source = s;
          this.highlighter.setSource(s);
        };

        this.lexerStack = new Array();

        this.lc = function(b){ return b; };
        this.popLexer = function (){
          //console.log("popLexer");
          if(this.lexerStack.length == 0) return;
          this.getTokenStream().mark();
          var oldLexer = this.getTokenStream().getTokenSource();
          var newLexer = this.lexerStack.pop();
          if(oldLexer instanceof StringLexer && newLexer instanceof XQueryLexer) {
            newLexer.inStr = false;
          }
          this.getTokenStream().setTokenSource(newLexer);
        };

        this.pushXQueryLexer = function() {
          xqueryLexer = new XQueryLexer(this.source);
          this.pushLexer(xqueryLexer);
        };

        this.pushStringLexer = function(isAposStr){
          //console.log("pushStringLexer");
          var stringLexer = new StringLexer(this.source);
          stringLexer.inAposStr = isAposStr;
          stringLexer.inQuotStr = !isAposStr;
          stringLexer.setIsWsExplicit(true);
          this.pushLexer(stringLexer);
        };

        this.pushXMLLexer = function(){
          //console.log("pushXMLLexer");
          var xmlLexer = new XMLLexer(this.source);
          xmlLexer.setIsWsExplicit(true);
          this.pushLexer(xmlLexer);
        };

        this.pushLexer = function(lexer){
          var oldLexer = this.getTokenStream().getTokenSource();
          oldLexer.addToStack(this.lexerStack);
          this.getTokenStream().setTokenSource(lexer);
        };

        this.setWsExplicit = function(isExplicit){
          this.getTokenStream().setWsExplicit(isExplicit);
        };

        this.ap = function(token)
        {
          this.addToken(token, "xml_pe");
        };

        this.ax = function(start, stop)
        {
          this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "xml_pe");
        };

        this.at = function(start, stop)
        {
          this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "meta.tag");
        };

        this.av = function(start, stop)
        {
          this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "variable");
        };

        this.af = function(start, stop)
        {
          this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "support.function");
        };

        this.ao = function(t)
        {
          this.addToken(t, "keyword.operator");
        };

        this.ak = function(t)
        {
          this.addToken(t, "keyword");
        };

        this.ad = function(t)
        {
          this.addToken(t, "constant");
        };

        this.addString = function(start, stop)
        {
         if(stop == undefined) {
           this.addToken(start, "string");
         } else {
           this.highlighter.addToken(start.getStartIndex(), stop.getStopIndex(), "string");
         }
        };

        this.ac = function(t)
        {
          this.addToken(t, "comment");
        };

        this.addToken = function(k, type){
          if(org.antlr.lang.isArray(k)){
            for(i in k)
            {
              this.highlighter.addToken(k[i].getStartIndex(), k[i].getStopIndex(), type);
            }
          } else if(k != null ) {
            this.highlighter.addToken(k.getStartIndex(), k.getStopIndex(), type); 
          }
        };


    }).call(this);

    XQueryParser.superclass.constructor.call(this, input, state);

    this.dfa1 = new XQueryParser.DFA1(this);
    this.dfa2 = new XQueryParser.DFA2(this);
    this.dfa6 = new XQueryParser.DFA6(this);
    this.dfa9 = new XQueryParser.DFA9(this);
    this.dfa44 = new XQueryParser.DFA44(this);
    this.dfa46 = new XQueryParser.DFA46(this);
    this.dfa119 = new XQueryParser.DFA119(this);
    this.dfa121 = new XQueryParser.DFA121(this);
    this.dfa123 = new XQueryParser.DFA123(this);
    this.dfa128 = new XQueryParser.DFA128(this);
    this.dfa129 = new XQueryParser.DFA129(this);
    this.dfa136 = new XQueryParser.DFA136(this);
    this.dfa172 = new XQueryParser.DFA172(this);
    this.dfa195 = new XQueryParser.DFA195(this);
    this.dfa230 = new XQueryParser.DFA230(this);
    this.dfa249 = new XQueryParser.DFA249(this);
    this.dfa265 = new XQueryParser.DFA265(this);
    this.adaptor = new org.antlr.runtime.tree.CommonTreeAdaptor();

};

org.antlr.lang.augmentObject(XQueryParser, {
    EOF: -1,
    L_QuotAttrContentChar: 4,
    L_AposAttrContentChar: 5,
    L_ElementContentChar: 6,
    L_CDataSection: 7,
    L_PredefinedEntityRef: 8,
    L_CharRef: 9,
    ESCAPE_LBRACKET: 10,
    ESCAPE_RBRACKET: 11,
    ESCAPE_APOS: 12,
    ESCAPE_QUOT: 13,
    CDATA_START: 14,
    CDATA_END: 15,
    ANCESTOR: 16,
    ANCESTOR_OR_SELF: 17,
    AND: 18,
    AS: 19,
    ASCENDING: 20,
    AT: 21,
    ATTRIBUTE: 22,
    BASE_URI: 23,
    BOUNDARY_SPACE: 24,
    BY: 25,
    CASE: 26,
    CAST: 27,
    CASTABLE: 28,
    CHILD: 29,
    COLLATION: 30,
    COMMENT: 31,
    CONSTRUCTION: 32,
    COPY_NAMESPACES: 33,
    DECLARE: 34,
    DEFAULT: 35,
    DESCENDANT: 36,
    DESCENDANT_OR_SELF: 37,
    DESCENDING: 38,
    DIV: 39,
    DOCUMENT: 40,
    DOCUMENT_NODE: 41,
    ELEMENT: 42,
    ELSE: 43,
    EMPTY: 44,
    EMPTY_SEQUENCE: 45,
    ENCODING: 46,
    EQ: 47,
    EVERY: 48,
    EXCEPT: 49,
    EXTERNAL: 50,
    FOLLOWING: 51,
    FOLLOWING_SIBLING: 52,
    FOR: 53,
    FUNCTION: 54,
    GE: 55,
    GREATEST: 56,
    GT: 57,
    IDIV: 58,
    IF: 59,
    IMPORT: 60,
    IN: 61,
    INHERIT: 62,
    INSTANCE: 63,
    INTERSECT: 64,
    IS: 65,
    ITEM: 66,
    LAX: 67,
    LE: 68,
    LEAST: 69,
    LET: 70,
    LT: 71,
    MOD: 72,
    MODULE: 73,
    NAMESPACE: 74,
    NE: 75,
    NO_INHERIT: 76,
    NO_PRESERVE: 77,
    NODE: 78,
    JSON: 79,
    OF: 80,
    OPTION: 81,
    OR: 82,
    ORDER: 83,
    ORDERED: 84,
    ORDERING: 85,
    PARENT: 86,
    PRECEDING: 87,
    PRECEDING_SIBLING: 88,
    PRESERVE: 89,
    PROCESSING_INSTRUCTION: 90,
    STRUCTURED_ITEM: 91,
    JSON_ITEM: 92,
    OBJECT: 93,
    ARRAY: 94,
    RETURN: 95,
    SATISFIES: 96,
    SCHEMA: 97,
    SCHEMA_ATTRIBUTE: 98,
    SCHEMA_ELEMENT: 99,
    SELF: 100,
    SOME: 101,
    STABLE: 102,
    STRICT: 103,
    STRIP: 104,
    TEXT: 105,
    THEN: 106,
    TO: 107,
    TREAT: 108,
    TYPESWITCH: 109,
    UNION: 110,
    UNORDERED: 111,
    VALIDATE: 112,
    VARIABLE: 113,
    VERSION: 114,
    WHERE: 115,
    XQUERY: 116,
    ALLOWING: 117,
    CATCH: 118,
    CONTEXT: 119,
    COUNT: 120,
    DECIMAL_FORMAT: 121,
    DECIMAL_SEPARATOR: 122,
    DIGIT: 123,
    END: 124,
    GROUP: 125,
    GROUPING_SEPARATOR: 126,
    INFINITY: 127,
    MINUS_SIGN: 128,
    NAMESPACE_NODE: 129,
    NAN: 130,
    NEXT: 131,
    ONLY: 132,
    PATTERN_SEPARATOR: 133,
    PERCENT: 134,
    PER_MILLE: 135,
    PREVIOUS: 136,
    SLIDING: 137,
    START: 138,
    SWITCH: 139,
    TRY: 140,
    TUMBLING: 141,
    TYPE: 142,
    WHEN: 143,
    WINDOW: 144,
    ZERO_DIGIT: 145,
    AFTER: 146,
    BEFORE: 147,
    COPY: 148,
    DELETE: 149,
    FIRST: 150,
    INSERT: 151,
    INTO: 152,
    POSITION: 153,
    APPEND: 154,
    LAST: 155,
    MODIFY: 156,
    NODES: 157,
    RENAME: 158,
    REPLACE: 159,
    REVALIDATION: 160,
    SKIP: 161,
    UPDATING: 162,
    VALUE: 163,
    WITH: 164,
    ALL: 165,
    ANY: 166,
    CONTAINS: 167,
    CONTENT: 168,
    DIACRITICS: 169,
    DIFFERENT: 170,
    DISTANCE: 171,
    ENTIRE: 172,
    EXACTLY: 173,
    FROM: 174,
    FT_OPTION: 175,
    FTAND: 176,
    FTNOT: 177,
    FTOR: 178,
    INSENSITIVE: 179,
    LANGUAGE: 180,
    LEVELS: 181,
    LOWERCASE: 182,
    MOST: 183,
    NO: 184,
    NOT: 185,
    OCCURS: 186,
    PARAGRAPH: 187,
    PARAGRAPHS: 188,
    PHRASE: 189,
    RELATIONSHIP: 190,
    SAME: 191,
    SCORE: 192,
    SENSITIVE: 193,
    SENTENCE: 194,
    SENTENCES: 195,
    STEMMING: 196,
    STOP: 197,
    THESAURUS: 198,
    TIMES: 199,
    UPPERCASE: 200,
    USING: 201,
    WEIGHT: 202,
    WILDCARDS: 203,
    WITHOUT: 204,
    WORD: 205,
    WORDS: 206,
    BREAK: 207,
    CONTINUE: 208,
    EXIT: 209,
    LOOP: 210,
    RETURNING: 211,
    WHILE: 212,
    CHECK: 213,
    COLLECTION: 214,
    CONSTRAINT: 215,
    FOREACH: 216,
    FOREIGN: 217,
    INDEX: 218,
    INTEGRITY: 219,
    KEY: 220,
    ON: 221,
    UNIQUE: 222,
    AMP_ER: 223,
    APOS_ER: 224,
    QUOT_ER: 225,
    CONCAT: 226,
    LPAREN: 227,
    RPAREN: 228,
    DOLLAR: 229,
    L_UNION_BRACKET: 230,
    R_UNION_BRACKET: 231,
    LBRACKET: 232,
    RBRACKET: 233,
    LSQUARE: 234,
    RSQUARE: 235,
    EQUAL: 236,
    BIND: 237,
    NOTEQUAL: 238,
    ANN_PERCENT: 239,
    HASH: 240,
    AMP: 241,
    COMMA: 242,
    QUESTION: 243,
    STAR: 244,
    PLUS: 245,
    MINUS: 246,
    SMALLER: 247,
    GREATER: 248,
    SMALLEREQ: 249,
    GREATEREQ: 250,
    SMALLER_SMALLER: 251,
    GREATER_GREATER: 252,
    SLASH: 253,
    SLASH_SLASH: 254,
    BANG: 255,
    DOT: 256,
    DOT_DOT: 257,
    COLON: 258,
    COLON_COLON: 259,
    EMPTY_CLOSE_TAG: 260,
    CLOSE_TAG: 261,
    SEMICOLON: 262,
    VBAR: 263,
    PRAGMA_START: 264,
    PRAGMA_END: 265,
    XML_COMMENT_START: 266,
    XML_COMMENT_END: 267,
    PI_START: 268,
    PI_END: 269,
    ATTR_SIGN: 270,
    Q: 271,
    CHARREF_DEC: 272,
    CHARREF_HEX: 273,
    APOS: 274,
    QUOT: 275,
    NCNameStartChar: 276,
    NCNameChar: 277,
    L_NCName: 278,
    Letter: 279,
    HexLetter: 280,
    Digit: 281,
    Digits: 282,
    S: 283,
    SU: 284,
    L_Pragma: 285,
    L_DirCommentConstructor: 286,
    L_DirPIConstructor: 287,
    L_IntegerLiteral: 288,
    L_DecimalLiteral: 289,
    L_DoubleLiteral: 290,
    L_Comment: 291,
    L_AnyChar: 292,
    L_QuotStringLiteralChar: 293,
    L_AposStringLiteralChar: 294,
    LibraryModule: 295,
    MainModule: 296,
    VersionDecl: 297,
    VersionDeclEncoding: 298,
    VersionDeclVersion: 299,
    ModuleDecl: 300,
    Prolog: 301,
    DefaultNamespaceDecls: 302,
    DefaultNamespaceDecl: 303,
    Setters: 304,
    Setter: 305,
    NamespaceDecls: 306,
    NamespaceDecl: 307,
    Imports: 308,
    FTOptionDecls: 309,
    SchemaImport: 310,
    SchemaPrefix: 311,
    NamespaceName: 312,
    DefaultElementNamespace: 313,
    AtHints: 314,
    ModuleImport: 315,
    BaseURIDecl: 316,
    OrderedDecls: 317,
    VarDecl: 318,
    VarType: 319,
    VarValue: 320,
    VarDefaultValue: 321,
    VarVariableDecl: 322,
    FunctionDecl: 323,
    ParamList: 324,
    ReturnType: 325,
    OptionDecl: 326,
    TypeDeclaration: 327,
    Param: 328,
    EnclosedExpr: 329,
    QueryBody: 330,
    UnaryExpr: 331,
    DirElemConstructor: 332,
    DirAttributeList: 333,
    DirAttributeValue: 334,
    DirElemContent: 335,
    CommonContent: 336,
    SequenceType: 337,
    EmptySequenceTest: 338,
    KindTest: 339,
    ItemTest: 340,
    FunctionTest: 341,
    AtomicType: 342,
    AtomicOrUnionType: 343,
    StringLiteral: 344,
    ElementContentChar: 345,
    AttributeValueChar: 346,
    QName: 347,
    BlockExpr: 348
});

(function(){
// public class variables
var EOF= -1,
    L_QuotAttrContentChar= 4,
    L_AposAttrContentChar= 5,
    L_ElementContentChar= 6,
    L_CDataSection= 7,
    L_PredefinedEntityRef= 8,
    L_CharRef= 9,
    ESCAPE_LBRACKET= 10,
    ESCAPE_RBRACKET= 11,
    ESCAPE_APOS= 12,
    ESCAPE_QUOT= 13,
    CDATA_START= 14,
    CDATA_END= 15,
    ANCESTOR= 16,
    ANCESTOR_OR_SELF= 17,
    AND= 18,
    AS= 19,
    ASCENDING= 20,
    AT= 21,
    ATTRIBUTE= 22,
    BASE_URI= 23,
    BOUNDARY_SPACE= 24,
    BY= 25,
    CASE= 26,
    CAST= 27,
    CASTABLE= 28,
    CHILD= 29,
    COLLATION= 30,
    COMMENT= 31,
    CONSTRUCTION= 32,
    COPY_NAMESPACES= 33,
    DECLARE= 34,
    DEFAULT= 35,
    DESCENDANT= 36,
    DESCENDANT_OR_SELF= 37,
    DESCENDING= 38,
    DIV= 39,
    DOCUMENT= 40,
    DOCUMENT_NODE= 41,
    ELEMENT= 42,
    ELSE= 43,
    EMPTY= 44,
    EMPTY_SEQUENCE= 45,
    ENCODING= 46,
    EQ= 47,
    EVERY= 48,
    EXCEPT= 49,
    EXTERNAL= 50,
    FOLLOWING= 51,
    FOLLOWING_SIBLING= 52,
    FOR= 53,
    FUNCTION= 54,
    GE= 55,
    GREATEST= 56,
    GT= 57,
    IDIV= 58,
    IF= 59,
    IMPORT= 60,
    IN= 61,
    INHERIT= 62,
    INSTANCE= 63,
    INTERSECT= 64,
    IS= 65,
    ITEM= 66,
    LAX= 67,
    LE= 68,
    LEAST= 69,
    LET= 70,
    LT= 71,
    MOD= 72,
    MODULE= 73,
    NAMESPACE= 74,
    NE= 75,
    NO_INHERIT= 76,
    NO_PRESERVE= 77,
    NODE= 78,
    JSON= 79,
    OF= 80,
    OPTION= 81,
    OR= 82,
    ORDER= 83,
    ORDERED= 84,
    ORDERING= 85,
    PARENT= 86,
    PRECEDING= 87,
    PRECEDING_SIBLING= 88,
    PRESERVE= 89,
    PROCESSING_INSTRUCTION= 90,
    STRUCTURED_ITEM= 91,
    JSON_ITEM= 92,
    OBJECT= 93,
    ARRAY= 94,
    RETURN= 95,
    SATISFIES= 96,
    SCHEMA= 97,
    SCHEMA_ATTRIBUTE= 98,
    SCHEMA_ELEMENT= 99,
    SELF= 100,
    SOME= 101,
    STABLE= 102,
    STRICT= 103,
    STRIP= 104,
    TEXT= 105,
    THEN= 106,
    TO= 107,
    TREAT= 108,
    TYPESWITCH= 109,
    UNION= 110,
    UNORDERED= 111,
    VALIDATE= 112,
    VARIABLE= 113,
    VERSION= 114,
    WHERE= 115,
    XQUERY= 116,
    ALLOWING= 117,
    CATCH= 118,
    CONTEXT= 119,
    COUNT= 120,
    DECIMAL_FORMAT= 121,
    DECIMAL_SEPARATOR= 122,
    DIGIT= 123,
    END= 124,
    GROUP= 125,
    GROUPING_SEPARATOR= 126,
    INFINITY= 127,
    MINUS_SIGN= 128,
    NAMESPACE_NODE= 129,
    NAN= 130,
    NEXT= 131,
    ONLY= 132,
    PATTERN_SEPARATOR= 133,
    PERCENT= 134,
    PER_MILLE= 135,
    PREVIOUS= 136,
    SLIDING= 137,
    START= 138,
    SWITCH= 139,
    TRY= 140,
    TUMBLING= 141,
    TYPE= 142,
    WHEN= 143,
    WINDOW= 144,
    ZERO_DIGIT= 145,
    AFTER= 146,
    BEFORE= 147,
    COPY= 148,
    DELETE= 149,
    FIRST= 150,
    INSERT= 151,
    INTO= 152,
    POSITION= 153,
    APPEND= 154,
    LAST= 155,
    MODIFY= 156,
    NODES= 157,
    RENAME= 158,
    REPLACE= 159,
    REVALIDATION= 160,
    SKIP= 161,
    UPDATING= 162,
    VALUE= 163,
    WITH= 164,
    ALL= 165,
    ANY= 166,
    CONTAINS= 167,
    CONTENT= 168,
    DIACRITICS= 169,
    DIFFERENT= 170,
    DISTANCE= 171,
    ENTIRE= 172,
    EXACTLY= 173,
    FROM= 174,
    FT_OPTION= 175,
    FTAND= 176,
    FTNOT= 177,
    FTOR= 178,
    INSENSITIVE= 179,
    LANGUAGE= 180,
    LEVELS= 181,
    LOWERCASE= 182,
    MOST= 183,
    NO= 184,
    NOT= 185,
    OCCURS= 186,
    PARAGRAPH= 187,
    PARAGRAPHS= 188,
    PHRASE= 189,
    RELATIONSHIP= 190,
    SAME= 191,
    SCORE= 192,
    SENSITIVE= 193,
    SENTENCE= 194,
    SENTENCES= 195,
    STEMMING= 196,
    STOP= 197,
    THESAURUS= 198,
    TIMES= 199,
    UPPERCASE= 200,
    USING= 201,
    WEIGHT= 202,
    WILDCARDS= 203,
    WITHOUT= 204,
    WORD= 205,
    WORDS= 206,
    BREAK= 207,
    CONTINUE= 208,
    EXIT= 209,
    LOOP= 210,
    RETURNING= 211,
    WHILE= 212,
    CHECK= 213,
    COLLECTION= 214,
    CONSTRAINT= 215,
    FOREACH= 216,
    FOREIGN= 217,
    INDEX= 218,
    INTEGRITY= 219,
    KEY= 220,
    ON= 221,
    UNIQUE= 222,
    AMP_ER= 223,
    APOS_ER= 224,
    QUOT_ER= 225,
    CONCAT= 226,
    LPAREN= 227,
    RPAREN= 228,
    DOLLAR= 229,
    L_UNION_BRACKET= 230,
    R_UNION_BRACKET= 231,
    LBRACKET= 232,
    RBRACKET= 233,
    LSQUARE= 234,
    RSQUARE= 235,
    EQUAL= 236,
    BIND= 237,
    NOTEQUAL= 238,
    ANN_PERCENT= 239,
    HASH= 240,
    AMP= 241,
    COMMA= 242,
    QUESTION= 243,
    STAR= 244,
    PLUS= 245,
    MINUS= 246,
    SMALLER= 247,
    GREATER= 248,
    SMALLEREQ= 249,
    GREATEREQ= 250,
    SMALLER_SMALLER= 251,
    GREATER_GREATER= 252,
    SLASH= 253,
    SLASH_SLASH= 254,
    BANG= 255,
    DOT= 256,
    DOT_DOT= 257,
    COLON= 258,
    COLON_COLON= 259,
    EMPTY_CLOSE_TAG= 260,
    CLOSE_TAG= 261,
    SEMICOLON= 262,
    VBAR= 263,
    PRAGMA_START= 264,
    PRAGMA_END= 265,
    XML_COMMENT_START= 266,
    XML_COMMENT_END= 267,
    PI_START= 268,
    PI_END= 269,
    ATTR_SIGN= 270,
    Q= 271,
    CHARREF_DEC= 272,
    CHARREF_HEX= 273,
    APOS= 274,
    QUOT= 275,
    NCNameStartChar= 276,
    NCNameChar= 277,
    L_NCName= 278,
    Letter= 279,
    HexLetter= 280,
    Digit= 281,
    Digits= 282,
    S= 283,
    SU= 284,
    L_Pragma= 285,
    L_DirCommentConstructor= 286,
    L_DirPIConstructor= 287,
    L_IntegerLiteral= 288,
    L_DecimalLiteral= 289,
    L_DoubleLiteral= 290,
    L_Comment= 291,
    L_AnyChar= 292,
    L_QuotStringLiteralChar= 293,
    L_AposStringLiteralChar= 294,
    LibraryModule= 295,
    MainModule= 296,
    VersionDecl= 297,
    VersionDeclEncoding= 298,
    VersionDeclVersion= 299,
    ModuleDecl= 300,
    Prolog= 301,
    DefaultNamespaceDecls= 302,
    DefaultNamespaceDecl= 303,
    Setters= 304,
    Setter= 305,
    NamespaceDecls= 306,
    NamespaceDecl= 307,
    Imports= 308,
    FTOptionDecls= 309,
    SchemaImport= 310,
    SchemaPrefix= 311,
    NamespaceName= 312,
    DefaultElementNamespace= 313,
    AtHints= 314,
    ModuleImport= 315,
    BaseURIDecl= 316,
    OrderedDecls= 317,
    VarDecl= 318,
    VarType= 319,
    VarValue= 320,
    VarDefaultValue= 321,
    VarVariableDecl= 322,
    FunctionDecl= 323,
    ParamList= 324,
    ReturnType= 325,
    OptionDecl= 326,
    TypeDeclaration= 327,
    Param= 328,
    EnclosedExpr= 329,
    QueryBody= 330,
    UnaryExpr= 331,
    DirElemConstructor= 332,
    DirAttributeList= 333,
    DirAttributeValue= 334,
    DirElemContent= 335,
    CommonContent= 336,
    SequenceType= 337,
    EmptySequenceTest= 338,
    KindTest= 339,
    ItemTest= 340,
    FunctionTest= 341,
    AtomicType= 342,
    AtomicOrUnionType= 343,
    StringLiteral= 344,
    ElementContentChar= 345,
    AttributeValueChar= 346,
    QName= 347,
    BlockExpr= 348;

// public instance methods/vars
org.antlr.lang.extend(XQueryParser, XQDTParser, {
        
    setTreeAdaptor: function(adaptor) {
        this.adaptor = adaptor;
    },
    getTreeAdaptor: function() {
        return this.adaptor;
    },

    getTokenNames: function() { return XQueryParser.tokenNames; },
    getGrammarFileName: function() { return "/Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g"; }
});
org.antlr.lang.augmentObject(XQueryParser.prototype, {

    // inline static return class
    p_Module_return: (function() {
        XQueryParser.p_Module_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Module_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:292:1: p_Module : (vd= p_VersionDecl )? (lm= p_LibraryModule[$vd.tree] -> | mm= p_MainModule[$vd.tree] ->) EOF ;
    // $ANTLR start "p_Module"
    p_Module: function() {
        var retval = new XQueryParser.p_Module_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var EOF1 = null;
         var vd = null;
         var lm = null;
         var mm = null;

        var EOF1_tree=null;
        var stream_EOF=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EOF");
        var stream_p_VersionDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_VersionDecl");
        var stream_p_LibraryModule=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_LibraryModule");
        var stream_p_MainModule=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_MainModule");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:293:9: ( (vd= p_VersionDecl )? (lm= p_LibraryModule[$vd.tree] -> | mm= p_MainModule[$vd.tree] ->) EOF )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:293:11: (vd= p_VersionDecl )? (lm= p_LibraryModule[$vd.tree] -> | mm= p_MainModule[$vd.tree] ->) EOF
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:293:13: (vd= p_VersionDecl )?
            var alt1=2;
            alt1 = this.dfa1.predict(this.input);
            switch (alt1) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:293:13: vd= p_VersionDecl
                    this.pushFollow(XQueryParser.FOLLOW_p_VersionDecl_in_p_Module503);
                    vd=this.p_VersionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_VersionDecl.add(vd.getTree());


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:294:13: (lm= p_LibraryModule[$vd.tree] -> | mm= p_MainModule[$vd.tree] ->)
            var alt2=2;
            alt2 = this.dfa2.predict(this.input);
            switch (alt2) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:295:15: lm= p_LibraryModule[$vd.tree]
                    this.pushFollow(XQueryParser.FOLLOW_p_LibraryModule_in_p_Module536);
                    lm=this.p_LibraryModule((vd?vd.tree:null));

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_LibraryModule.add(lm.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 295:44: ->
                    {
                        this.adaptor.addChild(root_0, (lm?lm.tree:null));

                    }

                    retval.tree = root_0;}

                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:296:15: mm= p_MainModule[$vd.tree]
                    this.pushFollow(XQueryParser.FOLLOW_p_MainModule_in_p_Module559);
                    mm=this.p_MainModule((vd?vd.tree:null));

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_MainModule.add(mm.getTree());


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 296:44: ->
                    {
                        this.adaptor.addChild(root_0, (mm?mm.tree:null));

                    }

                    retval.tree = root_0;}

                    break;

            }

            EOF1=this.match(this.input,EOF,XQueryParser.FOLLOW_EOF_in_p_Module583); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_EOF.add(EOF1);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VersionDecl_return: (function() {
        XQueryParser.p_VersionDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VersionDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:301:1: p_VersionDecl : k= XQUERY ( (k= ENCODING enc= p_StringLiteral ) | (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? ) ) SEMICOLON -> ^( VersionDecl ^( VersionDeclVersion ( $ver)? ) ^( VersionDeclEncoding ( $enc)? ) ) ;
    // $ANTLR start "p_VersionDecl"
    p_VersionDecl: function() {
        var retval = new XQueryParser.p_VersionDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON2 = null;
         var enc = null;
         var ver = null;

        var k_tree=null;
        var SEMICOLON2_tree=null;
        var stream_ENCODING=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token ENCODING");
        var stream_VERSION=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token VERSION");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_XQUERY=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token XQUERY");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:302:9: (k= XQUERY ( (k= ENCODING enc= p_StringLiteral ) | (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? ) ) SEMICOLON -> ^( VersionDecl ^( VersionDeclVersion ( $ver)? ) ^( VersionDeclEncoding ( $enc)? ) ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:302:11: k= XQUERY ( (k= ENCODING enc= p_StringLiteral ) | (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? ) ) SEMICOLON
            k=this.match(this.input,XQUERY,XQueryParser.FOLLOW_XQUERY_in_p_VersionDecl611); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_XQUERY.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:302:35: ( (k= ENCODING enc= p_StringLiteral ) | (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? ) )
            var alt4=2;
            var LA4_0 = this.input.LA(1);

            if ( (LA4_0==ENCODING) ) {
                alt4=1;
            }
            else if ( (LA4_0==VERSION) ) {
                alt4=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 4, 0, this.input);

                throw nvae;
            }
            switch (alt4) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:302:36: (k= ENCODING enc= p_StringLiteral )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:302:36: (k= ENCODING enc= p_StringLiteral )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:302:37: k= ENCODING enc= p_StringLiteral
                    k=this.match(this.input,ENCODING,XQueryParser.FOLLOW_ENCODING_in_p_VersionDecl619); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_ENCODING.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_VersionDecl625);
                    enc=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(enc.getTree());





                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:303:13: (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:303:13: (k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:303:14: k= VERSION ver= p_StringLiteral (k= ENCODING enc= p_StringLiteral )?
                    k=this.match(this.input,VERSION,XQueryParser.FOLLOW_VERSION_in_p_VersionDecl646); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_VERSION.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_VersionDecl652);
                    ver=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ver.getTree());
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:303:59: (k= ENCODING enc= p_StringLiteral )?
                    var alt3=2;
                    var LA3_0 = this.input.LA(1);

                    if ( (LA3_0==ENCODING) ) {
                        alt3=1;
                    }
                    switch (alt3) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:303:60: k= ENCODING enc= p_StringLiteral
                            k=this.match(this.input,ENCODING,XQueryParser.FOLLOW_ENCODING_in_p_VersionDecl657); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_ENCODING.add(k);

                            if ( this.state.backtracking===0 ) {
                              this.ak(k);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_VersionDecl663);
                            enc=this.p_StringLiteral();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(enc.getTree());


                            break;

                    }






                    break;

            }

            SEMICOLON2=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_p_VersionDecl669); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON2);



            // AST REWRITE
            // elements: ver, enc
            // token labels: 
            // rule labels: retval, ver, enc
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_ver=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token ver",ver!=null?ver.tree:null);
            var stream_enc=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token enc",enc!=null?enc.tree:null);

            root_0 = this.adaptor.nil();
            // 304:17: -> ^( VersionDecl ^( VersionDeclVersion ( $ver)? ) ^( VersionDeclEncoding ( $enc)? ) )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:304:20: ^( VersionDecl ^( VersionDeclVersion ( $ver)? ) ^( VersionDeclEncoding ( $enc)? ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(VersionDecl, "VersionDecl"), root_1);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:304:34: ^( VersionDeclVersion ( $ver)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(VersionDeclVersion, "VersionDeclVersion"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:304:55: ( $ver)?
                if ( stream_ver.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_ver.nextTree());

                }
                stream_ver.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:304:62: ^( VersionDeclEncoding ( $enc)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(VersionDeclEncoding, "VersionDeclEncoding"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:304:84: ( $enc)?
                if ( stream_enc.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_enc.nextTree());

                }
                stream_enc.reset();

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_MainModule_return: (function() {
        XQueryParser.p_MainModule_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_MainModule_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:308:1: p_MainModule[vd] : pm_Prolog pm_QueryBody -> ^( MainModule pm_Prolog ) ;
    // $ANTLR start "p_MainModule"
    p_MainModule: function(vd) {
        var retval = new XQueryParser.p_MainModule_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pm_Prolog3 = null;
         var pm_QueryBody4 = null;

        var stream_pm_QueryBody=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_QueryBody");
        var stream_pm_Prolog=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_Prolog");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:309:9: ( pm_Prolog pm_QueryBody -> ^( MainModule pm_Prolog ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:309:11: pm_Prolog pm_QueryBody
            this.pushFollow(XQueryParser.FOLLOW_pm_Prolog_in_p_MainModule735);
            pm_Prolog3=this.pm_Prolog();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_pm_Prolog.add(pm_Prolog3.getTree());
            this.pushFollow(XQueryParser.FOLLOW_pm_QueryBody_in_p_MainModule737);
            pm_QueryBody4=this.pm_QueryBody();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_pm_QueryBody.add(pm_QueryBody4.getTree());


            // AST REWRITE
            // elements: pm_Prolog
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 310:17: -> ^( MainModule pm_Prolog )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:310:20: ^( MainModule pm_Prolog )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(MainModule, "MainModule"), root_1);

                this.adaptor.addChild(root_1, vd);
                this.adaptor.addChild(root_1, stream_pm_Prolog.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_LibraryModule_return: (function() {
        XQueryParser.p_LibraryModule_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_LibraryModule_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:314:1: p_LibraryModule[vd] : p_ModuleDecl pm_Prolog -> ^( LibraryModule p_ModuleDecl pm_Prolog ) ;
    // $ANTLR start "p_LibraryModule"
    p_LibraryModule: function(vd) {
        var retval = new XQueryParser.p_LibraryModule_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ModuleDecl5 = null;
         var pm_Prolog6 = null;

        var stream_pm_Prolog=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_Prolog");
        var stream_p_ModuleDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_ModuleDecl");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:315:9: ( p_ModuleDecl pm_Prolog -> ^( LibraryModule p_ModuleDecl pm_Prolog ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:315:11: p_ModuleDecl pm_Prolog
            this.pushFollow(XQueryParser.FOLLOW_p_ModuleDecl_in_p_LibraryModule793);
            p_ModuleDecl5=this.p_ModuleDecl();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_ModuleDecl.add(p_ModuleDecl5.getTree());
            this.pushFollow(XQueryParser.FOLLOW_pm_Prolog_in_p_LibraryModule795);
            pm_Prolog6=this.pm_Prolog();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_pm_Prolog.add(pm_Prolog6.getTree());


            // AST REWRITE
            // elements: pm_Prolog, p_ModuleDecl
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 316:17: -> ^( LibraryModule p_ModuleDecl pm_Prolog )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:316:20: ^( LibraryModule p_ModuleDecl pm_Prolog )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(LibraryModule, "LibraryModule"), root_1);

                this.adaptor.addChild(root_1, vd);
                this.adaptor.addChild(root_1, stream_p_ModuleDecl.nextTree());
                this.adaptor.addChild(root_1, stream_pm_Prolog.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ModuleDecl_return: (function() {
        XQueryParser.p_ModuleDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ModuleDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:320:1: p_ModuleDecl : k+= MODULE k+= NAMESPACE p_NCName EQUAL p_StringLiteral SEMICOLON -> ^( ModuleDecl p_NCName p_StringLiteral ) ;
    // $ANTLR start "p_ModuleDecl"
    p_ModuleDecl: function() {
        var retval = new XQueryParser.p_ModuleDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var EQUAL8 = null;
        var SEMICOLON10 = null;
        var k = null;
        var list_k=null;
         var p_NCName7 = null;
         var p_StringLiteral9 = null;

        var EQUAL8_tree=null;
        var SEMICOLON10_tree=null;
        var k_tree=null;
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_MODULE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token MODULE");
        var stream_NAMESPACE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token NAMESPACE");
        var stream_EQUAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EQUAL");
        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:321:9: (k+= MODULE k+= NAMESPACE p_NCName EQUAL p_StringLiteral SEMICOLON -> ^( ModuleDecl p_NCName p_StringLiteral ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:321:11: k+= MODULE k+= NAMESPACE p_NCName EQUAL p_StringLiteral SEMICOLON
            k=this.match(this.input,MODULE,XQueryParser.FOLLOW_MODULE_in_p_ModuleDecl851); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_MODULE.add(k);

            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_p_ModuleDecl855); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

            if (org.antlr.lang.isNull(list_k)) list_k = [];
            list_k.push(k);

            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_p_ModuleDecl859);
            p_NCName7=this.p_NCName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_NCName.add(p_NCName7.getTree());
            EQUAL8=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_p_ModuleDecl861); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_EQUAL.add(EQUAL8);

            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_p_ModuleDecl863);
            p_StringLiteral9=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(p_StringLiteral9.getTree());
            SEMICOLON10=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_p_ModuleDecl865); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON10);



            // AST REWRITE
            // elements: p_NCName, p_StringLiteral
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 322:17: -> ^( ModuleDecl p_NCName p_StringLiteral )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:322:21: ^( ModuleDecl p_NCName p_StringLiteral )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(ModuleDecl, "ModuleDecl"), root_1);

                this.adaptor.addChild(root_1, stream_p_NCName.nextTree());
                this.adaptor.addChild(root_1, stream_p_StringLiteral.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_Prolog_return: (function() {
        XQueryParser.pm_Prolog_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_Prolog_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:328:1: pm_Prolog : ( (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl ) )* (od+= pg_OrderedDecl )* -> ^( Prolog ^( DefaultNamespaceDecls ( $dnd)* ) ^( Setters ( $s)* ) ^( NamespaceDecls ( $nd)* ) ^( Imports ( $i)* ) ^( FTOptionDecls ( $fto)* ) ^( OrderedDecls ( $od)* ) ) ;
    // $ANTLR start "pm_Prolog"
    pm_Prolog: function() {
        var retval = new XQueryParser.pm_Prolog_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var list_dnd=null;
        var list_s=null;
        var list_nd=null;
        var list_i=null;
        var list_fto=null;
        var list_od=null;
        var dnd = null;
        var s = null;
        var nd = null;
        var i = null;
        var fto = null;
        var od = null;
        var stream_pm_NamespaceDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_NamespaceDecl");
        var stream_p_Import=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_Import");
        var stream_p_Setter=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_Setter");
        var stream_pm_DefaultNamespaceDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_DefaultNamespaceDecl");
        var stream_pg_OrderedDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pg_OrderedDecl");
        var stream_pm_FTOptionDecl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pm_FTOptionDecl");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:9: ( ( (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl ) )* (od+= pg_OrderedDecl )* -> ^( Prolog ^( DefaultNamespaceDecls ( $dnd)* ) ^( Setters ( $s)* ) ^( NamespaceDecls ( $nd)* ) ^( Imports ( $i)* ) ^( FTOptionDecls ( $fto)* ) ^( OrderedDecls ( $od)* ) ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:11: ( (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl ) )* (od+= pg_OrderedDecl )*
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:11: ( (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl ) )*
            loop6:
            do {
                var alt6=2;
                alt6 = this.dfa6.predict(this.input);
                switch (alt6) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:12: (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:12: (dnd+= pm_DefaultNamespaceDecl | s+= p_Setter | nd+= pm_NamespaceDecl | i+= p_Import | fto+= pm_FTOptionDecl )
                    var alt5=5;
                    var LA5_0 = this.input.LA(1);

                    if ( (LA5_0==DECLARE) ) {
                        var LA5_1 = this.input.LA(2);

                        if ( (LA5_1==REVALIDATION) && ((this.lc(XQU)))) {
                            alt5=2;
                        }
                        else if ( (LA5_1==FT_OPTION) ) {
                            alt5=5;
                        }
                        else if ( (LA5_1==DEFAULT) ) {
                            var LA5_5 = this.input.LA(3);

                            if ( (LA5_5==ELEMENT||LA5_5==FUNCTION) ) {
                                alt5=1;
                            }
                            else if ( (LA5_5==COLLATION||LA5_5==ORDER||LA5_5==DECIMAL_FORMAT) ) {
                                alt5=2;
                            }
                            else {
                                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                                var nvae =
                                    new org.antlr.runtime.NoViableAltException("", 5, 5, this.input);

                                throw nvae;
                            }
                        }
                        else if ( ((LA5_1>=BASE_URI && LA5_1<=BOUNDARY_SPACE)||(LA5_1>=CONSTRUCTION && LA5_1<=COPY_NAMESPACES)||LA5_1==ORDERING||LA5_1==DECIMAL_FORMAT) ) {
                            alt5=2;
                        }
                        else if ( (LA5_1==NAMESPACE) ) {
                            alt5=3;
                        }
                        else {
                            if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                            var nvae =
                                new org.antlr.runtime.NoViableAltException("", 5, 1, this.input);

                            throw nvae;
                        }
                    }
                    else if ( (LA5_0==IMPORT) ) {
                        alt5=4;
                    }
                    else {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        var nvae =
                            new org.antlr.runtime.NoViableAltException("", 5, 0, this.input);

                        throw nvae;
                    }
                    switch (alt5) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:13: dnd+= pm_DefaultNamespaceDecl
                            this.pushFollow(XQueryParser.FOLLOW_pm_DefaultNamespaceDecl_in_pm_Prolog924);
                            dnd=this.pm_DefaultNamespaceDecl();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_pm_DefaultNamespaceDecl.add(dnd.getTree());
                            if (org.antlr.lang.isNull(list_dnd)) list_dnd = [];
                            list_dnd.push(dnd.getTree());



                            break;
                        case 2 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:44: s+= p_Setter
                            this.pushFollow(XQueryParser.FOLLOW_p_Setter_in_pm_Prolog930);
                            s=this.p_Setter();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_Setter.add(s.getTree());
                            if (org.antlr.lang.isNull(list_s)) list_s = [];
                            list_s.push(s.getTree());



                            break;
                        case 3 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:58: nd+= pm_NamespaceDecl
                            this.pushFollow(XQueryParser.FOLLOW_pm_NamespaceDecl_in_pm_Prolog936);
                            nd=this.pm_NamespaceDecl();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_pm_NamespaceDecl.add(nd.getTree());
                            if (org.antlr.lang.isNull(list_nd)) list_nd = [];
                            list_nd.push(nd.getTree());



                            break;
                        case 4 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:81: i+= p_Import
                            this.pushFollow(XQueryParser.FOLLOW_p_Import_in_pm_Prolog942);
                            i=this.p_Import();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_Import.add(i.getTree());
                            if (org.antlr.lang.isNull(list_i)) list_i = [];
                            list_i.push(i.getTree());



                            break;
                        case 5 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:95: fto+= pm_FTOptionDecl
                            this.pushFollow(XQueryParser.FOLLOW_pm_FTOptionDecl_in_pm_Prolog948);
                            fto=this.pm_FTOptionDecl();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_pm_FTOptionDecl.add(fto.getTree());
                            if (org.antlr.lang.isNull(list_fto)) list_fto = [];
                            list_fto.push(fto.getTree());



                            break;

                    }



                    break;

                default :
                    break loop6;
                }
            } while (true);

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:121: (od+= pg_OrderedDecl )*
            loop7:
            do {
                var alt7=2;
                var LA7_0 = this.input.LA(1);

                if ( (LA7_0==DECLARE) ) {
                    var LA7_3 = this.input.LA(2);

                    if ( (LA7_3==FUNCTION||LA7_3==OPTION||LA7_3==VARIABLE||LA7_3==CONTEXT||LA7_3==UPDATING||LA7_3==COLLECTION||(LA7_3>=INDEX && LA7_3<=INTEGRITY)||LA7_3==ANN_PERCENT) ) {
                        alt7=1;
                    }


                }


                switch (alt7) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:329:121: od+= pg_OrderedDecl
                    this.pushFollow(XQueryParser.FOLLOW_pg_OrderedDecl_in_pm_Prolog955);
                    od=this.pg_OrderedDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_pg_OrderedDecl.add(od.getTree());
                    if (org.antlr.lang.isNull(list_od)) list_od = [];
                    list_od.push(od.getTree());



                    break;

                default :
                    break loop7;
                }
            } while (true);



            // AST REWRITE
            // elements: fto, od, dnd, nd, i, s
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: od, s, fto, nd, dnd, i
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_od=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token od",list_od);
            var stream_s=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token s",list_s);
            var stream_fto=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token fto",list_fto);
            var stream_nd=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nd",list_nd);
            var stream_dnd=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token dnd",list_dnd);
            var stream_i=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token i",list_i);
            root_0 = this.adaptor.nil();
            // 330:17: -> ^( Prolog ^( DefaultNamespaceDecls ( $dnd)* ) ^( Setters ( $s)* ) ^( NamespaceDecls ( $nd)* ) ^( Imports ( $i)* ) ^( FTOptionDecls ( $fto)* ) ^( OrderedDecls ( $od)* ) )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:330:21: ^( Prolog ^( DefaultNamespaceDecls ( $dnd)* ) ^( Setters ( $s)* ) ^( NamespaceDecls ( $nd)* ) ^( Imports ( $i)* ) ^( FTOptionDecls ( $fto)* ) ^( OrderedDecls ( $od)* ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(Prolog, "Prolog"), root_1);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:331:33: ^( DefaultNamespaceDecls ( $dnd)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(DefaultNamespaceDecls, "DefaultNamespaceDecls"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:331:57: ( $dnd)*
                while ( stream_dnd.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_dnd.nextTree());

                }
                stream_dnd.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:332:33: ^( Setters ( $s)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(Setters, "Setters"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:332:43: ( $s)*
                while ( stream_s.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_s.nextTree());

                }
                stream_s.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:333:33: ^( NamespaceDecls ( $nd)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(NamespaceDecls, "NamespaceDecls"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:333:50: ( $nd)*
                while ( stream_nd.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_nd.nextTree());

                }
                stream_nd.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:334:33: ^( Imports ( $i)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(Imports, "Imports"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:334:43: ( $i)*
                while ( stream_i.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_i.nextTree());

                }
                stream_i.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:335:33: ^( FTOptionDecls ( $fto)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(FTOptionDecls, "FTOptionDecls"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:335:49: ( $fto)*
                while ( stream_fto.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_fto.nextTree());

                }
                stream_fto.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:336:33: ^( OrderedDecls ( $od)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(OrderedDecls, "OrderedDecls"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:336:48: ( $od)*
                while ( stream_od.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_od.nextTree());

                }
                stream_od.reset();

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pg_OrderedDecl_return: (function() {
        XQueryParser.pg_OrderedDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_OrderedDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:344:1: pg_OrderedDecl : ( pm_ContextItemDecl | pm_AnnotatedDecl | pm_OptionDecl );
    // $ANTLR start "pg_OrderedDecl"
    pg_OrderedDecl: function() {
        var retval = new XQueryParser.pg_OrderedDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pm_ContextItemDecl11 = null;
         var pm_AnnotatedDecl12 = null;
         var pm_OptionDecl13 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:345:9: ( pm_ContextItemDecl | pm_AnnotatedDecl | pm_OptionDecl )
            var alt8=3;
            var LA8_0 = this.input.LA(1);

            if ( (LA8_0==DECLARE) ) {
                switch ( this.input.LA(2) ) {
                case CONTEXT:
                    alt8=1;
                    break;
                case FUNCTION:
                case VARIABLE:
                case UPDATING:
                case COLLECTION:
                case INDEX:
                case INTEGRITY:
                case ANN_PERCENT:
                    alt8=2;
                    break;
                case OPTION:
                    alt8=3;
                    break;
                default:
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 8, 1, this.input);

                    throw nvae;
                }

            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 8, 0, this.input);

                throw nvae;
            }
            switch (alt8) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:345:11: pm_ContextItemDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_ContextItemDecl_in_pg_OrderedDecl1270);
                    pm_ContextItemDecl11=this.pm_ContextItemDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_ContextItemDecl11.getTree());


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:346:11: pm_AnnotatedDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_AnnotatedDecl_in_pg_OrderedDecl1282);
                    pm_AnnotatedDecl12=this.pm_AnnotatedDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_AnnotatedDecl12.getTree());


                    break;
                case 3 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:347:11: pm_OptionDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_OptionDecl_in_pg_OrderedDecl1294);
                    pm_OptionDecl13=this.pm_OptionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_OptionDecl13.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Setter_return: (function() {
        XQueryParser.p_Setter_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Setter_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:355:1: p_Setter : ( pm_BoundarySpaceDecl | pm_DefaultCollationDecl | pm_BaseURIDecl | pm_ConstructionDecl | pm_OrderingModeDecl | pm_EmptyOrderDecl | {...}? => pm_RevalidationDecl | pm_CopyNamespacesDecl | pm_DecimalFormatDecl );
    // $ANTLR start "p_Setter"
    p_Setter: function() {
        var retval = new XQueryParser.p_Setter_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pm_BoundarySpaceDecl14 = null;
         var pm_DefaultCollationDecl15 = null;
         var pm_BaseURIDecl16 = null;
         var pm_ConstructionDecl17 = null;
         var pm_OrderingModeDecl18 = null;
         var pm_EmptyOrderDecl19 = null;
         var pm_RevalidationDecl20 = null;
         var pm_CopyNamespacesDecl21 = null;
         var pm_DecimalFormatDecl22 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:356:9: ( pm_BoundarySpaceDecl | pm_DefaultCollationDecl | pm_BaseURIDecl | pm_ConstructionDecl | pm_OrderingModeDecl | pm_EmptyOrderDecl | {...}? => pm_RevalidationDecl | pm_CopyNamespacesDecl | pm_DecimalFormatDecl )
            var alt9=9;
            alt9 = this.dfa9.predict(this.input);
            switch (alt9) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:356:11: pm_BoundarySpaceDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_BoundarySpaceDecl_in_p_Setter1324);
                    pm_BoundarySpaceDecl14=this.pm_BoundarySpaceDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_BoundarySpaceDecl14.getTree());


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:357:11: pm_DefaultCollationDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_DefaultCollationDecl_in_p_Setter1336);
                    pm_DefaultCollationDecl15=this.pm_DefaultCollationDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_DefaultCollationDecl15.getTree());


                    break;
                case 3 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:358:11: pm_BaseURIDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_BaseURIDecl_in_p_Setter1348);
                    pm_BaseURIDecl16=this.pm_BaseURIDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_BaseURIDecl16.getTree());


                    break;
                case 4 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:359:11: pm_ConstructionDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_ConstructionDecl_in_p_Setter1360);
                    pm_ConstructionDecl17=this.pm_ConstructionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_ConstructionDecl17.getTree());


                    break;
                case 5 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:360:11: pm_OrderingModeDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_OrderingModeDecl_in_p_Setter1372);
                    pm_OrderingModeDecl18=this.pm_OrderingModeDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_OrderingModeDecl18.getTree());


                    break;
                case 6 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:361:11: pm_EmptyOrderDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_EmptyOrderDecl_in_p_Setter1384);
                    pm_EmptyOrderDecl19=this.pm_EmptyOrderDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_EmptyOrderDecl19.getTree());


                    break;
                case 7 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:362:11: {...}? => pm_RevalidationDecl
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(XQU))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "p_Setter", "this.lc(XQU)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_pm_RevalidationDecl_in_p_Setter1399);
                    pm_RevalidationDecl20=this.pm_RevalidationDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_RevalidationDecl20.getTree());


                    break;
                case 8 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:363:11: pm_CopyNamespacesDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_CopyNamespacesDecl_in_p_Setter1411);
                    pm_CopyNamespacesDecl21=this.pm_CopyNamespacesDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_CopyNamespacesDecl21.getTree());


                    break;
                case 9 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:364:11: pm_DecimalFormatDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_DecimalFormatDecl_in_p_Setter1423);
                    pm_DecimalFormatDecl22=this.pm_DecimalFormatDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_DecimalFormatDecl22.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_BoundarySpaceDecl_return: (function() {
        XQueryParser.pm_BoundarySpaceDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_BoundarySpaceDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:368:1: pm_BoundarySpaceDecl : k= DECLARE k= BOUNDARY_SPACE ( (k= PRESERVE ) | (k= STRIP ) ) SEMICOLON ;
    // $ANTLR start "pm_BoundarySpaceDecl"
    pm_BoundarySpaceDecl: function() {
        var retval = new XQueryParser.pm_BoundarySpaceDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON23 = null;

        var k_tree=null;
        var SEMICOLON23_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:369:9: (k= DECLARE k= BOUNDARY_SPACE ( (k= PRESERVE ) | (k= STRIP ) ) SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:369:11: k= DECLARE k= BOUNDARY_SPACE ( (k= PRESERVE ) | (k= STRIP ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_BoundarySpaceDecl1455); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,BOUNDARY_SPACE,XQueryParser.FOLLOW_BOUNDARY_SPACE_in_pm_BoundarySpaceDecl1461); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:369:68: ( (k= PRESERVE ) | (k= STRIP ) )
            var alt10=2;
            var LA10_0 = this.input.LA(1);

            if ( (LA10_0==PRESERVE) ) {
                alt10=1;
            }
            else if ( (LA10_0==STRIP) ) {
                alt10=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 10, 0, this.input);

                throw nvae;
            }
            switch (alt10) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:369:70: (k= PRESERVE )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:369:70: (k= PRESERVE )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:369:71: k= PRESERVE
                    k=this.match(this.input,PRESERVE,XQueryParser.FOLLOW_PRESERVE_in_pm_BoundarySpaceDecl1470); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }





                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:369:100: (k= STRIP )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:369:100: (k= STRIP )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:369:101: k= STRIP
                    k=this.match(this.input,STRIP,XQueryParser.FOLLOW_STRIP_in_pm_BoundarySpaceDecl1480); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }





                    break;

            }

            SEMICOLON23=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_BoundarySpaceDecl1487); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON23_tree = this.adaptor.create(SEMICOLON23);
            this.adaptor.addChild(root_0, SEMICOLON23_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_DefaultCollationDecl_return: (function() {
        XQueryParser.pm_DefaultCollationDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_DefaultCollationDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:373:1: pm_DefaultCollationDecl : k= DECLARE k= DEFAULT k= COLLATION p_StringLiteral SEMICOLON ;
    // $ANTLR start "pm_DefaultCollationDecl"
    pm_DefaultCollationDecl: function() {
        var retval = new XQueryParser.pm_DefaultCollationDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON25 = null;
         var p_StringLiteral24 = null;

        var k_tree=null;
        var SEMICOLON25_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:374:9: (k= DECLARE k= DEFAULT k= COLLATION p_StringLiteral SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:374:11: k= DECLARE k= DEFAULT k= COLLATION p_StringLiteral SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_DefaultCollationDecl1515); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_pm_DefaultCollationDecl1521); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,COLLATION,XQueryParser.FOLLOW_COLLATION_in_pm_DefaultCollationDecl1527); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_DefaultCollationDecl1531);
            p_StringLiteral24=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral24.getTree());
            SEMICOLON25=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_DefaultCollationDecl1533); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON25_tree = this.adaptor.create(SEMICOLON25);
            this.adaptor.addChild(root_0, SEMICOLON25_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_BaseURIDecl_return: (function() {
        XQueryParser.pm_BaseURIDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_BaseURIDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:378:1: pm_BaseURIDecl : k= DECLARE k= BASE_URI sl= p_StringLiteral SEMICOLON -> ^( BaseURIDecl $sl) ;
    // $ANTLR start "pm_BaseURIDecl"
    pm_BaseURIDecl: function() {
        var retval = new XQueryParser.pm_BaseURIDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON26 = null;
         var sl = null;

        var k_tree=null;
        var SEMICOLON26_tree=null;
        var stream_DECLARE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DECLARE");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_BASE_URI=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token BASE_URI");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:379:9: (k= DECLARE k= BASE_URI sl= p_StringLiteral SEMICOLON -> ^( BaseURIDecl $sl) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:379:11: k= DECLARE k= BASE_URI sl= p_StringLiteral SEMICOLON
            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_BaseURIDecl1569); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_DECLARE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,BASE_URI,XQueryParser.FOLLOW_BASE_URI_in_pm_BaseURIDecl1575); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_BASE_URI.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_BaseURIDecl1581);
            sl=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(sl.getTree());
            SEMICOLON26=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_BaseURIDecl1583); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON26);



            // AST REWRITE
            // elements: sl
            // token labels: 
            // rule labels: sl, retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_sl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token sl",sl!=null?sl.tree:null);
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 380:17: -> ^( BaseURIDecl $sl)
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:380:20: ^( BaseURIDecl $sl)
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(BaseURIDecl, "BaseURIDecl"), root_1);

                this.adaptor.addChild(root_1, stream_sl.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_ConstructionDecl_return: (function() {
        XQueryParser.pm_ConstructionDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_ConstructionDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:384:1: pm_ConstructionDecl : k= DECLARE k= CONSTRUCTION ( (k= STRIP | k= PRESERVE ) ) SEMICOLON ;
    // $ANTLR start "pm_ConstructionDecl"
    pm_ConstructionDecl: function() {
        var retval = new XQueryParser.pm_ConstructionDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON27 = null;

        var k_tree=null;
        var SEMICOLON27_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:385:9: (k= DECLARE k= CONSTRUCTION ( (k= STRIP | k= PRESERVE ) ) SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:385:11: k= DECLARE k= CONSTRUCTION ( (k= STRIP | k= PRESERVE ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_ConstructionDecl1636); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,CONSTRUCTION,XQueryParser.FOLLOW_CONSTRUCTION_in_pm_ConstructionDecl1642); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:385:66: ( (k= STRIP | k= PRESERVE ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:385:68: (k= STRIP | k= PRESERVE )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:385:68: (k= STRIP | k= PRESERVE )
            var alt11=2;
            var LA11_0 = this.input.LA(1);

            if ( (LA11_0==STRIP) ) {
                alt11=1;
            }
            else if ( (LA11_0==PRESERVE) ) {
                alt11=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 11, 0, this.input);

                throw nvae;
            }
            switch (alt11) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:385:69: k= STRIP
                    k=this.match(this.input,STRIP,XQueryParser.FOLLOW_STRIP_in_pm_ConstructionDecl1651); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:385:79: k= PRESERVE
                    k=this.match(this.input,PRESERVE,XQueryParser.FOLLOW_PRESERVE_in_pm_ConstructionDecl1657); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            SEMICOLON27=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_ConstructionDecl1664); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON27_tree = this.adaptor.create(SEMICOLON27);
            this.adaptor.addChild(root_0, SEMICOLON27_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_OrderingModeDecl_return: (function() {
        XQueryParser.pm_OrderingModeDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_OrderingModeDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:389:1: pm_OrderingModeDecl : k= DECLARE k= ORDERING ( (k= ORDERED | k= UNORDERED ) ) SEMICOLON ;
    // $ANTLR start "pm_OrderingModeDecl"
    pm_OrderingModeDecl: function() {
        var retval = new XQueryParser.pm_OrderingModeDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON28 = null;

        var k_tree=null;
        var SEMICOLON28_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:390:9: (k= DECLARE k= ORDERING ( (k= ORDERED | k= UNORDERED ) ) SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:390:11: k= DECLARE k= ORDERING ( (k= ORDERED | k= UNORDERED ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_OrderingModeDecl1692); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,ORDERING,XQueryParser.FOLLOW_ORDERING_in_pm_OrderingModeDecl1698); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:390:62: ( (k= ORDERED | k= UNORDERED ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:390:64: (k= ORDERED | k= UNORDERED )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:390:64: (k= ORDERED | k= UNORDERED )
            var alt12=2;
            var LA12_0 = this.input.LA(1);

            if ( (LA12_0==ORDERED) ) {
                alt12=1;
            }
            else if ( (LA12_0==UNORDERED) ) {
                alt12=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 12, 0, this.input);

                throw nvae;
            }
            switch (alt12) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:390:65: k= ORDERED
                    k=this.match(this.input,ORDERED,XQueryParser.FOLLOW_ORDERED_in_pm_OrderingModeDecl1707); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:390:77: k= UNORDERED
                    k=this.match(this.input,UNORDERED,XQueryParser.FOLLOW_UNORDERED_in_pm_OrderingModeDecl1713); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            SEMICOLON28=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_OrderingModeDecl1720); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON28_tree = this.adaptor.create(SEMICOLON28);
            this.adaptor.addChild(root_0, SEMICOLON28_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_EmptyOrderDecl_return: (function() {
        XQueryParser.pm_EmptyOrderDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_EmptyOrderDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:394:1: pm_EmptyOrderDecl : k= DECLARE k= DEFAULT k= ORDER k= EMPTY ( (k= GREATEST | k= LEAST ) ) SEMICOLON ;
    // $ANTLR start "pm_EmptyOrderDecl"
    pm_EmptyOrderDecl: function() {
        var retval = new XQueryParser.pm_EmptyOrderDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON29 = null;

        var k_tree=null;
        var SEMICOLON29_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:395:9: (k= DECLARE k= DEFAULT k= ORDER k= EMPTY ( (k= GREATEST | k= LEAST ) ) SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:395:11: k= DECLARE k= DEFAULT k= ORDER k= EMPTY ( (k= GREATEST | k= LEAST ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_EmptyOrderDecl1748); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_pm_EmptyOrderDecl1754); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,ORDER,XQueryParser.FOLLOW_ORDER_in_pm_EmptyOrderDecl1760); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,EMPTY,XQueryParser.FOLLOW_EMPTY_in_pm_EmptyOrderDecl1766); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:395:107: ( (k= GREATEST | k= LEAST ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:395:109: (k= GREATEST | k= LEAST )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:395:109: (k= GREATEST | k= LEAST )
            var alt13=2;
            var LA13_0 = this.input.LA(1);

            if ( (LA13_0==GREATEST) ) {
                alt13=1;
            }
            else if ( (LA13_0==LEAST) ) {
                alt13=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 13, 0, this.input);

                throw nvae;
            }
            switch (alt13) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:395:110: k= GREATEST
                    k=this.match(this.input,GREATEST,XQueryParser.FOLLOW_GREATEST_in_pm_EmptyOrderDecl1775); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:395:123: k= LEAST
                    k=this.match(this.input,LEAST,XQueryParser.FOLLOW_LEAST_in_pm_EmptyOrderDecl1781); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            SEMICOLON29=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_EmptyOrderDecl1788); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON29_tree = this.adaptor.create(SEMICOLON29);
            this.adaptor.addChild(root_0, SEMICOLON29_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_CopyNamespacesDecl_return: (function() {
        XQueryParser.pm_CopyNamespacesDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_CopyNamespacesDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:399:1: pm_CopyNamespacesDecl : k= DECLARE k= COPY_NAMESPACES p_PreserveMode COMMA p_InheritMode SEMICOLON ;
    // $ANTLR start "pm_CopyNamespacesDecl"
    pm_CopyNamespacesDecl: function() {
        var retval = new XQueryParser.pm_CopyNamespacesDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var COMMA31 = null;
        var SEMICOLON33 = null;
         var p_PreserveMode30 = null;
         var p_InheritMode32 = null;

        var k_tree=null;
        var COMMA31_tree=null;
        var SEMICOLON33_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:400:9: (k= DECLARE k= COPY_NAMESPACES p_PreserveMode COMMA p_InheritMode SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:400:11: k= DECLARE k= COPY_NAMESPACES p_PreserveMode COMMA p_InheritMode SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_CopyNamespacesDecl1816); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,COPY_NAMESPACES,XQueryParser.FOLLOW_COPY_NAMESPACES_in_pm_CopyNamespacesDecl1822); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_PreserveMode_in_pm_CopyNamespacesDecl1826);
            p_PreserveMode30=this.p_PreserveMode();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PreserveMode30.getTree());
            COMMA31=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_pm_CopyNamespacesDecl1828); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            COMMA31_tree = this.adaptor.create(COMMA31);
            this.adaptor.addChild(root_0, COMMA31_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_InheritMode_in_pm_CopyNamespacesDecl1830);
            p_InheritMode32=this.p_InheritMode();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InheritMode32.getTree());
            SEMICOLON33=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_CopyNamespacesDecl1832); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON33_tree = this.adaptor.create(SEMICOLON33);
            this.adaptor.addChild(root_0, SEMICOLON33_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PreserveMode_return: (function() {
        XQueryParser.p_PreserveMode_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PreserveMode_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:404:1: p_PreserveMode : (k+= PRESERVE | k+= NO_PRESERVE ) ;
    // $ANTLR start "p_PreserveMode"
    p_PreserveMode: function() {
        var retval = new XQueryParser.p_PreserveMode_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;

        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:405:9: ( (k+= PRESERVE | k+= NO_PRESERVE ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:405:11: (k+= PRESERVE | k+= NO_PRESERVE )
            root_0 = this.adaptor.nil();

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:405:11: (k+= PRESERVE | k+= NO_PRESERVE )
            var alt14=2;
            var LA14_0 = this.input.LA(1);

            if ( (LA14_0==PRESERVE) ) {
                alt14=1;
            }
            else if ( (LA14_0==NO_PRESERVE) ) {
                alt14=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 14, 0, this.input);

                throw nvae;
            }
            switch (alt14) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:405:12: k+= PRESERVE
                    k=this.match(this.input,PRESERVE,XQueryParser.FOLLOW_PRESERVE_in_p_PreserveMode1861); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:405:26: k+= NO_PRESERVE
                    k=this.match(this.input,NO_PRESERVE,XQueryParser.FOLLOW_NO_PRESERVE_in_p_PreserveMode1867); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_InheritMode_return: (function() {
        XQueryParser.p_InheritMode_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_InheritMode_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:409:1: p_InheritMode : (k+= INHERIT | k+= NO_INHERIT ) ;
    // $ANTLR start "p_InheritMode"
    p_InheritMode: function() {
        var retval = new XQueryParser.p_InheritMode_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var list_k=null;

        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:410:9: ( (k+= INHERIT | k+= NO_INHERIT ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:410:11: (k+= INHERIT | k+= NO_INHERIT )
            root_0 = this.adaptor.nil();

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:410:11: (k+= INHERIT | k+= NO_INHERIT )
            var alt15=2;
            var LA15_0 = this.input.LA(1);

            if ( (LA15_0==INHERIT) ) {
                alt15=1;
            }
            else if ( (LA15_0==NO_INHERIT) ) {
                alt15=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 15, 0, this.input);

                throw nvae;
            }
            switch (alt15) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:410:12: k+= INHERIT
                    k=this.match(this.input,INHERIT,XQueryParser.FOLLOW_INHERIT_in_p_InheritMode1899); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:410:25: k+= NO_INHERIT
                    k=this.match(this.input,NO_INHERIT,XQueryParser.FOLLOW_NO_INHERIT_in_p_InheritMode1905); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if (org.antlr.lang.isNull(list_k)) list_k = [];
                    list_k.push(k);



                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(list_k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_DecimalFormatDecl_return: (function() {
        XQueryParser.pm_DecimalFormatDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_DecimalFormatDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:414:1: pm_DecimalFormatDecl : k= DECLARE ( (k= DECIMAL_FORMAT p_EQName ) | (k= DEFAULT k= DECIMAL_FORMAT ) ) ( p_DFPropertyName EQUAL p_StringLiteral )* SEMICOLON ;
    // $ANTLR start "pm_DecimalFormatDecl"
    pm_DecimalFormatDecl: function() {
        var retval = new XQueryParser.pm_DecimalFormatDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var EQUAL36 = null;
        var SEMICOLON38 = null;
         var p_EQName34 = null;
         var p_DFPropertyName35 = null;
         var p_StringLiteral37 = null;

        var k_tree=null;
        var EQUAL36_tree=null;
        var SEMICOLON38_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:9: (k= DECLARE ( (k= DECIMAL_FORMAT p_EQName ) | (k= DEFAULT k= DECIMAL_FORMAT ) ) ( p_DFPropertyName EQUAL p_StringLiteral )* SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:11: k= DECLARE ( (k= DECIMAL_FORMAT p_EQName ) | (k= DEFAULT k= DECIMAL_FORMAT ) ) ( p_DFPropertyName EQUAL p_StringLiteral )* SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_DecimalFormatDecl1944); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:36: ( (k= DECIMAL_FORMAT p_EQName ) | (k= DEFAULT k= DECIMAL_FORMAT ) )
            var alt16=2;
            var LA16_0 = this.input.LA(1);

            if ( (LA16_0==DECIMAL_FORMAT) ) {
                alt16=1;
            }
            else if ( (LA16_0==DEFAULT) ) {
                alt16=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 16, 0, this.input);

                throw nvae;
            }
            switch (alt16) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:37: (k= DECIMAL_FORMAT p_EQName )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:37: (k= DECIMAL_FORMAT p_EQName )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:38: k= DECIMAL_FORMAT p_EQName
                    k=this.match(this.input,DECIMAL_FORMAT,XQueryParser.FOLLOW_DECIMAL_FORMAT_in_pm_DecimalFormatDecl1952); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_EQName_in_pm_DecimalFormatDecl1956);
                    p_EQName34=this.p_EQName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_EQName34.getTree());





                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:82: (k= DEFAULT k= DECIMAL_FORMAT )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:82: (k= DEFAULT k= DECIMAL_FORMAT )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:83: k= DEFAULT k= DECIMAL_FORMAT
                    k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_pm_DecimalFormatDecl1964); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,DECIMAL_FORMAT,XQueryParser.FOLLOW_DECIMAL_FORMAT_in_pm_DecimalFormatDecl1970); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }





                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:142: ( p_DFPropertyName EQUAL p_StringLiteral )*
            loop17:
            do {
                var alt17=2;
                var LA17_0 = this.input.LA(1);

                if ( ((LA17_0>=DECIMAL_SEPARATOR && LA17_0<=DIGIT)||(LA17_0>=GROUPING_SEPARATOR && LA17_0<=MINUS_SIGN)||LA17_0==NAN||(LA17_0>=PATTERN_SEPARATOR && LA17_0<=PER_MILLE)||LA17_0==ZERO_DIGIT) ) {
                    alt17=1;
                }


                switch (alt17) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:415:143: p_DFPropertyName EQUAL p_StringLiteral
                    this.pushFollow(XQueryParser.FOLLOW_p_DFPropertyName_in_pm_DecimalFormatDecl1977);
                    p_DFPropertyName35=this.p_DFPropertyName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_DFPropertyName35.getTree());
                    EQUAL36=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_pm_DecimalFormatDecl1979); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    EQUAL36_tree = this.adaptor.create(EQUAL36);
                    this.adaptor.addChild(root_0, EQUAL36_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_DecimalFormatDecl1981);
                    p_StringLiteral37=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral37.getTree());


                    break;

                default :
                    break loop17;
                }
            } while (true);

            SEMICOLON38=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_DecimalFormatDecl1985); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON38_tree = this.adaptor.create(SEMICOLON38);
            this.adaptor.addChild(root_0, SEMICOLON38_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_DFPropertyName_return: (function() {
        XQueryParser.p_DFPropertyName_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_DFPropertyName_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:419:1: p_DFPropertyName : (k= DECIMAL_SEPARATOR | k= GROUPING_SEPARATOR | k= INFINITY | k= MINUS_SIGN | k= NAN | k= PERCENT | k= PER_MILLE | k= ZERO_DIGIT | k= DIGIT | k= PATTERN_SEPARATOR ) ;
    // $ANTLR start "p_DFPropertyName"
    p_DFPropertyName: function() {
        var retval = new XQueryParser.p_DFPropertyName_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;

        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:9: ( (k= DECIMAL_SEPARATOR | k= GROUPING_SEPARATOR | k= INFINITY | k= MINUS_SIGN | k= NAN | k= PERCENT | k= PER_MILLE | k= ZERO_DIGIT | k= DIGIT | k= PATTERN_SEPARATOR ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:11: (k= DECIMAL_SEPARATOR | k= GROUPING_SEPARATOR | k= INFINITY | k= MINUS_SIGN | k= NAN | k= PERCENT | k= PER_MILLE | k= ZERO_DIGIT | k= DIGIT | k= PATTERN_SEPARATOR )
            root_0 = this.adaptor.nil();

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:11: (k= DECIMAL_SEPARATOR | k= GROUPING_SEPARATOR | k= INFINITY | k= MINUS_SIGN | k= NAN | k= PERCENT | k= PER_MILLE | k= ZERO_DIGIT | k= DIGIT | k= PATTERN_SEPARATOR )
            var alt18=10;
            switch ( this.input.LA(1) ) {
            case DECIMAL_SEPARATOR:
                alt18=1;
                break;
            case GROUPING_SEPARATOR:
                alt18=2;
                break;
            case INFINITY:
                alt18=3;
                break;
            case MINUS_SIGN:
                alt18=4;
                break;
            case NAN:
                alt18=5;
                break;
            case PERCENT:
                alt18=6;
                break;
            case PER_MILLE:
                alt18=7;
                break;
            case ZERO_DIGIT:
                alt18=8;
                break;
            case DIGIT:
                alt18=9;
                break;
            case PATTERN_SEPARATOR:
                alt18=10;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 18, 0, this.input);

                throw nvae;
            }

            switch (alt18) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:12: k= DECIMAL_SEPARATOR
                    k=this.match(this.input,DECIMAL_SEPARATOR,XQueryParser.FOLLOW_DECIMAL_SEPARATOR_in_p_DFPropertyName2014); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:34: k= GROUPING_SEPARATOR
                    k=this.match(this.input,GROUPING_SEPARATOR,XQueryParser.FOLLOW_GROUPING_SEPARATOR_in_p_DFPropertyName2020); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 3 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:57: k= INFINITY
                    k=this.match(this.input,INFINITY,XQueryParser.FOLLOW_INFINITY_in_p_DFPropertyName2026); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 4 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:70: k= MINUS_SIGN
                    k=this.match(this.input,MINUS_SIGN,XQueryParser.FOLLOW_MINUS_SIGN_in_p_DFPropertyName2032); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 5 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:85: k= NAN
                    k=this.match(this.input,NAN,XQueryParser.FOLLOW_NAN_in_p_DFPropertyName2038); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 6 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:93: k= PERCENT
                    k=this.match(this.input,PERCENT,XQueryParser.FOLLOW_PERCENT_in_p_DFPropertyName2044); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 7 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:105: k= PER_MILLE
                    k=this.match(this.input,PER_MILLE,XQueryParser.FOLLOW_PER_MILLE_in_p_DFPropertyName2050); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 8 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:119: k= ZERO_DIGIT
                    k=this.match(this.input,ZERO_DIGIT,XQueryParser.FOLLOW_ZERO_DIGIT_in_p_DFPropertyName2056); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 9 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:134: k= DIGIT
                    k=this.match(this.input,DIGIT,XQueryParser.FOLLOW_DIGIT_in_p_DFPropertyName2062); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 10 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:420:144: k= PATTERN_SEPARATOR
                    k=this.match(this.input,PATTERN_SEPARATOR,XQueryParser.FOLLOW_PATTERN_SEPARATOR_in_p_DFPropertyName2068); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Import_return: (function() {
        XQueryParser.p_Import_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Import_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:424:1: p_Import : ( pm_SchemaImport | pm_ModuleImport );
    // $ANTLR start "p_Import"
    p_Import: function() {
        var retval = new XQueryParser.p_Import_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var pm_SchemaImport39 = null;
         var pm_ModuleImport40 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:425:9: ( pm_SchemaImport | pm_ModuleImport )
            var alt19=2;
            var LA19_0 = this.input.LA(1);

            if ( (LA19_0==IMPORT) ) {
                var LA19_1 = this.input.LA(2);

                if ( (LA19_1==SCHEMA) ) {
                    alt19=1;
                }
                else if ( (LA19_1==MODULE) ) {
                    alt19=2;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 19, 1, this.input);

                    throw nvae;
                }
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 19, 0, this.input);

                throw nvae;
            }
            switch (alt19) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:425:11: pm_SchemaImport
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_SchemaImport_in_p_Import2097);
                    pm_SchemaImport39=this.pm_SchemaImport();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_SchemaImport39.getTree());


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:425:29: pm_ModuleImport
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_ModuleImport_in_p_Import2101);
                    pm_ModuleImport40=this.pm_ModuleImport();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_ModuleImport40.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_SchemaImport_return: (function() {
        XQueryParser.pm_SchemaImport_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_SchemaImport_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:429:1: pm_SchemaImport : k= IMPORT k= SCHEMA (sp= p_SchemaPrefix )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON -> ^( SchemaImport ^( SchemaPrefix ( $sp)? ) $us ^( AtHints ( $ah)* ) ) ;
    // $ANTLR start "pm_SchemaImport"
    pm_SchemaImport: function() {
        var retval = new XQueryParser.pm_SchemaImport_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var COMMA41 = null;
        var SEMICOLON42 = null;
        var list_ah=null;
         var sp = null;
         var us = null;
        var ah = null;
        var k_tree=null;
        var COMMA41_tree=null;
        var SEMICOLON42_tree=null;
        var stream_AT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token AT");
        var stream_IMPORT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token IMPORT");
        var stream_SCHEMA=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SCHEMA");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_COMMA=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token COMMA");
        var stream_p_SchemaPrefix=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_SchemaPrefix");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:430:9: (k= IMPORT k= SCHEMA (sp= p_SchemaPrefix )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON -> ^( SchemaImport ^( SchemaPrefix ( $sp)? ) $us ^( AtHints ( $ah)* ) ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:430:11: k= IMPORT k= SCHEMA (sp= p_SchemaPrefix )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON
            k=this.match(this.input,IMPORT,XQueryParser.FOLLOW_IMPORT_in_pm_SchemaImport2137); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_IMPORT.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,SCHEMA,XQueryParser.FOLLOW_SCHEMA_in_pm_SchemaImport2143); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SCHEMA.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:430:61: (sp= p_SchemaPrefix )?
            var alt20=2;
            var LA20_0 = this.input.LA(1);

            if ( (LA20_0==DEFAULT||LA20_0==NAMESPACE) ) {
                alt20=1;
            }
            switch (alt20) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:430:61: sp= p_SchemaPrefix
                    this.pushFollow(XQueryParser.FOLLOW_p_SchemaPrefix_in_pm_SchemaImport2149);
                    sp=this.p_SchemaPrefix();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_SchemaPrefix.add(sp.getTree());


                    break;

            }

            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_SchemaImport2154);
            us=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(us.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:430:97: (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )?
            var alt22=2;
            var LA22_0 = this.input.LA(1);

            if ( (LA22_0==AT) ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:430:98: k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )*
                    k=this.match(this.input,AT,XQueryParser.FOLLOW_AT_in_pm_SchemaImport2159); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_AT.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_SchemaImport2165);
                    ah=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ah.getTree());
                    if (org.antlr.lang.isNull(list_ah)) list_ah = [];
                    list_ah.push(ah.getTree());

                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:430:138: ( COMMA ah+= p_StringLiteral )*
                    loop21:
                    do {
                        var alt21=2;
                        var LA21_0 = this.input.LA(1);

                        if ( (LA21_0==COMMA) ) {
                            alt21=1;
                        }


                        switch (alt21) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:430:139: COMMA ah+= p_StringLiteral
                            COMMA41=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_pm_SchemaImport2168); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_COMMA.add(COMMA41);

                            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_SchemaImport2172);
                            ah=this.p_StringLiteral();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ah.getTree());
                            if (org.antlr.lang.isNull(list_ah)) list_ah = [];
                            list_ah.push(ah.getTree());



                            break;

                        default :
                            break loop21;
                        }
                    } while (true);



                    break;

            }

            SEMICOLON42=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_SchemaImport2178); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON42);



            // AST REWRITE
            // elements: us, ah, sp
            // token labels: 
            // rule labels: retval, sp, us
            // token list labels: 
            // rule list labels: ah
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_sp=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token sp",sp!=null?sp.tree:null);
            var stream_us=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token us",us!=null?us.tree:null);
            var stream_ah=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token ah",list_ah);
            root_0 = this.adaptor.nil();
            // 431:17: -> ^( SchemaImport ^( SchemaPrefix ( $sp)? ) $us ^( AtHints ( $ah)* ) )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:431:20: ^( SchemaImport ^( SchemaPrefix ( $sp)? ) $us ^( AtHints ( $ah)* ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(SchemaImport, "SchemaImport"), root_1);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:431:35: ^( SchemaPrefix ( $sp)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(SchemaPrefix, "SchemaPrefix"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:431:50: ( $sp)?
                if ( stream_sp.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_sp.nextTree());

                }
                stream_sp.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                this.adaptor.addChild(root_1, stream_us.nextTree());
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:431:60: ^( AtHints ( $ah)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(AtHints, "AtHints"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:431:70: ( $ah)*
                while ( stream_ah.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_ah.nextTree());

                }
                stream_ah.reset();

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SchemaPrefix_return: (function() {
        XQueryParser.p_SchemaPrefix_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SchemaPrefix_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:435:1: p_SchemaPrefix : (k= NAMESPACE nn= p_NCName EQUAL -> ^( NamespaceName $nn) | k= DEFAULT k= ELEMENT k= NAMESPACE -> DefaultElementNamespace );
    // $ANTLR start "p_SchemaPrefix"
    p_SchemaPrefix: function() {
        var retval = new XQueryParser.p_SchemaPrefix_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var EQUAL43 = null;
         var nn = null;

        var k_tree=null;
        var EQUAL43_tree=null;
        var stream_ELEMENT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token ELEMENT");
        var stream_NAMESPACE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token NAMESPACE");
        var stream_EQUAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EQUAL");
        var stream_DEFAULT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DEFAULT");
        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:436:9: (k= NAMESPACE nn= p_NCName EQUAL -> ^( NamespaceName $nn) | k= DEFAULT k= ELEMENT k= NAMESPACE -> DefaultElementNamespace )
            var alt23=2;
            var LA23_0 = this.input.LA(1);

            if ( (LA23_0==NAMESPACE) ) {
                alt23=1;
            }
            else if ( (LA23_0==DEFAULT) ) {
                alt23=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 23, 0, this.input);

                throw nvae;
            }
            switch (alt23) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:436:11: k= NAMESPACE nn= p_NCName EQUAL
                    k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_p_SchemaPrefix2248); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_p_SchemaPrefix2254);
                    nn=this.p_NCName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_NCName.add(nn.getTree());
                    EQUAL43=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_p_SchemaPrefix2256); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EQUAL.add(EQUAL43);



                    // AST REWRITE
                    // elements: nn
                    // token labels: 
                    // rule labels: retval, nn
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
                    var stream_nn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nn",nn!=null?nn.tree:null);

                    root_0 = this.adaptor.nil();
                    // 437:17: -> ^( NamespaceName $nn)
                    {
                        // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:437:20: ^( NamespaceName $nn)
                        {
                        var root_1 = this.adaptor.nil();
                        root_1 = this.adaptor.becomeRoot(this.adaptor.create(NamespaceName, "NamespaceName"), root_1);

                        this.adaptor.addChild(root_1, stream_nn.nextTree());

                        this.adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}

                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:438:11: k= DEFAULT k= ELEMENT k= NAMESPACE
                    k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_p_SchemaPrefix2295); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_DEFAULT.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,ELEMENT,XQueryParser.FOLLOW_ELEMENT_in_p_SchemaPrefix2301); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_ELEMENT.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_p_SchemaPrefix2307); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    if ( this.state.backtracking===0 ) {
                    retval.tree = root_0;
                    var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

                    root_0 = this.adaptor.nil();
                    // 439:17: -> DefaultElementNamespace
                    {
                        this.adaptor.addChild(root_0, this.adaptor.create(DefaultElementNamespace, "DefaultElementNamespace"));

                    }

                    retval.tree = root_0;}

                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_ModuleImport_return: (function() {
        XQueryParser.pm_ModuleImport_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_ModuleImport_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:443:1: pm_ModuleImport : k= IMPORT k= MODULE (k= NAMESPACE nn= p_NCName EQUAL )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON -> ^( ModuleImport ^( NamespaceName ( $nn)? ) $us ^( AtHints ( $ah)* ) ) ;
    // $ANTLR start "pm_ModuleImport"
    pm_ModuleImport: function() {
        var retval = new XQueryParser.pm_ModuleImport_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var EQUAL44 = null;
        var COMMA45 = null;
        var SEMICOLON46 = null;
        var list_ah=null;
         var nn = null;
         var us = null;
        var ah = null;
        var k_tree=null;
        var EQUAL44_tree=null;
        var COMMA45_tree=null;
        var SEMICOLON46_tree=null;
        var stream_AT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token AT");
        var stream_IMPORT=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token IMPORT");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_MODULE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token MODULE");
        var stream_COMMA=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token COMMA");
        var stream_NAMESPACE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token NAMESPACE");
        var stream_EQUAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EQUAL");
        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:444:9: (k= IMPORT k= MODULE (k= NAMESPACE nn= p_NCName EQUAL )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON -> ^( ModuleImport ^( NamespaceName ( $nn)? ) $us ^( AtHints ( $ah)* ) ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:444:11: k= IMPORT k= MODULE (k= NAMESPACE nn= p_NCName EQUAL )? us= p_StringLiteral (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )? SEMICOLON
            k=this.match(this.input,IMPORT,XQueryParser.FOLLOW_IMPORT_in_pm_ModuleImport2357); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_IMPORT.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,MODULE,XQueryParser.FOLLOW_MODULE_in_pm_ModuleImport2363); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_MODULE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:444:59: (k= NAMESPACE nn= p_NCName EQUAL )?
            var alt24=2;
            var LA24_0 = this.input.LA(1);

            if ( (LA24_0==NAMESPACE) ) {
                alt24=1;
            }
            switch (alt24) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:444:60: k= NAMESPACE nn= p_NCName EQUAL
                    k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_pm_ModuleImport2370); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_pm_ModuleImport2376);
                    nn=this.p_NCName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_NCName.add(nn.getTree());
                    EQUAL44=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_pm_ModuleImport2378); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EQUAL.add(EQUAL44);



                    break;

            }

            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_ModuleImport2384);
            us=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(us.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:444:126: (k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )* )?
            var alt26=2;
            var LA26_0 = this.input.LA(1);

            if ( (LA26_0==AT) ) {
                alt26=1;
            }
            switch (alt26) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:444:127: k= AT ah+= p_StringLiteral ( COMMA ah+= p_StringLiteral )*
                    k=this.match(this.input,AT,XQueryParser.FOLLOW_AT_in_pm_ModuleImport2389); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_AT.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_ModuleImport2395);
                    ah=this.p_StringLiteral();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ah.getTree());
                    if (org.antlr.lang.isNull(list_ah)) list_ah = [];
                    list_ah.push(ah.getTree());

                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:444:167: ( COMMA ah+= p_StringLiteral )*
                    loop25:
                    do {
                        var alt25=2;
                        var LA25_0 = this.input.LA(1);

                        if ( (LA25_0==COMMA) ) {
                            alt25=1;
                        }


                        switch (alt25) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:444:168: COMMA ah+= p_StringLiteral
                            COMMA45=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_pm_ModuleImport2398); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_COMMA.add(COMMA45);

                            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_ModuleImport2402);
                            ah=this.p_StringLiteral();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(ah.getTree());
                            if (org.antlr.lang.isNull(list_ah)) list_ah = [];
                            list_ah.push(ah.getTree());



                            break;

                        default :
                            break loop25;
                        }
                    } while (true);



                    break;

            }

            SEMICOLON46=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_ModuleImport2408); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON46);



            // AST REWRITE
            // elements: nn, us, ah
            // token labels: 
            // rule labels: retval, nn, us
            // token list labels: 
            // rule list labels: ah
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_nn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nn",nn!=null?nn.tree:null);
            var stream_us=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token us",us!=null?us.tree:null);
            var stream_ah=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token ah",list_ah);
            root_0 = this.adaptor.nil();
            // 445:17: -> ^( ModuleImport ^( NamespaceName ( $nn)? ) $us ^( AtHints ( $ah)* ) )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:445:20: ^( ModuleImport ^( NamespaceName ( $nn)? ) $us ^( AtHints ( $ah)* ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(ModuleImport, "ModuleImport"), root_1);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:445:35: ^( NamespaceName ( $nn)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(NamespaceName, "NamespaceName"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:445:51: ( $nn)?
                if ( stream_nn.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_nn.nextTree());

                }
                stream_nn.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                this.adaptor.addChild(root_1, stream_us.nextTree());
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:445:61: ^( AtHints ( $ah)* )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(AtHints, "AtHints"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:445:71: ( $ah)*
                while ( stream_ah.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_ah.nextTree());

                }
                stream_ah.reset();

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_NamespaceDecl_return: (function() {
        XQueryParser.pm_NamespaceDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_NamespaceDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:449:1: pm_NamespaceDecl : k= DECLARE k= NAMESPACE nn= p_NCName EQUAL us= p_StringLiteral SEMICOLON -> ^( NamespaceDecl $nn $us) ;
    // $ANTLR start "pm_NamespaceDecl"
    pm_NamespaceDecl: function() {
        var retval = new XQueryParser.pm_NamespaceDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var EQUAL47 = null;
        var SEMICOLON48 = null;
         var nn = null;
         var us = null;

        var k_tree=null;
        var EQUAL47_tree=null;
        var SEMICOLON48_tree=null;
        var stream_DECLARE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DECLARE");
        var stream_SEMICOLON=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token SEMICOLON");
        var stream_NAMESPACE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token NAMESPACE");
        var stream_EQUAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EQUAL");
        var stream_p_NCName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_NCName");
        var stream_p_StringLiteral=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StringLiteral");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:450:9: (k= DECLARE k= NAMESPACE nn= p_NCName EQUAL us= p_StringLiteral SEMICOLON -> ^( NamespaceDecl $nn $us) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:450:11: k= DECLARE k= NAMESPACE nn= p_NCName EQUAL us= p_StringLiteral SEMICOLON
            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_NamespaceDecl2477); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_DECLARE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_pm_NamespaceDecl2483); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_NAMESPACE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_NCName_in_pm_NamespaceDecl2489);
            nn=this.p_NCName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_NCName.add(nn.getTree());
            EQUAL47=this.match(this.input,EQUAL,XQueryParser.FOLLOW_EQUAL_in_pm_NamespaceDecl2491); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_EQUAL.add(EQUAL47);

            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_NamespaceDecl2495);
            us=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_StringLiteral.add(us.getTree());
            SEMICOLON48=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_NamespaceDecl2497); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_SEMICOLON.add(SEMICOLON48);



            // AST REWRITE
            // elements: nn, us
            // token labels: 
            // rule labels: retval, nn, us
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_nn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token nn",nn!=null?nn.tree:null);
            var stream_us=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token us",us!=null?us.tree:null);

            root_0 = this.adaptor.nil();
            // 451:17: -> ^( NamespaceDecl $nn $us)
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:451:20: ^( NamespaceDecl $nn $us)
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(NamespaceDecl, "NamespaceDecl"), root_1);

                this.adaptor.addChild(root_1, stream_nn.nextTree());
                this.adaptor.addChild(root_1, stream_us.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_DefaultNamespaceDecl_return: (function() {
        XQueryParser.pm_DefaultNamespaceDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_DefaultNamespaceDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:455:1: pm_DefaultNamespaceDecl : k= DECLARE k= DEFAULT (k= ELEMENT | k= FUNCTION ) k= NAMESPACE p_StringLiteral SEMICOLON ;
    // $ANTLR start "pm_DefaultNamespaceDecl"
    pm_DefaultNamespaceDecl: function() {
        var retval = new XQueryParser.pm_DefaultNamespaceDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON50 = null;
         var p_StringLiteral49 = null;

        var k_tree=null;
        var SEMICOLON50_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:456:9: (k= DECLARE k= DEFAULT (k= ELEMENT | k= FUNCTION ) k= NAMESPACE p_StringLiteral SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:456:11: k= DECLARE k= DEFAULT (k= ELEMENT | k= FUNCTION ) k= NAMESPACE p_StringLiteral SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_DefaultNamespaceDecl2554); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,DEFAULT,XQueryParser.FOLLOW_DEFAULT_in_pm_DefaultNamespaceDecl2560); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:456:61: (k= ELEMENT | k= FUNCTION )
            var alt27=2;
            var LA27_0 = this.input.LA(1);

            if ( (LA27_0==ELEMENT) ) {
                alt27=1;
            }
            else if ( (LA27_0==FUNCTION) ) {
                alt27=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 27, 0, this.input);

                throw nvae;
            }
            switch (alt27) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:456:62: k= ELEMENT
                    k=this.match(this.input,ELEMENT,XQueryParser.FOLLOW_ELEMENT_in_pm_DefaultNamespaceDecl2567); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:456:74: k= FUNCTION
                    k=this.match(this.input,FUNCTION,XQueryParser.FOLLOW_FUNCTION_in_pm_DefaultNamespaceDecl2573); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }


                    break;

            }

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,NAMESPACE,XQueryParser.FOLLOW_NAMESPACE_in_pm_DefaultNamespaceDecl2580); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_DefaultNamespaceDecl2584);
            p_StringLiteral49=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral49.getTree());
            SEMICOLON50=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_DefaultNamespaceDecl2586); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON50_tree = this.adaptor.create(SEMICOLON50);
            this.adaptor.addChild(root_0, SEMICOLON50_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_AnnotatedDecl_return: (function() {
        XQueryParser.pm_AnnotatedDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_AnnotatedDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:460:1: pm_AnnotatedDecl : k= DECLARE ( p_Annotation )* pg_AnnotatedDecl SEMICOLON ;
    // $ANTLR start "pm_AnnotatedDecl"
    pm_AnnotatedDecl: function() {
        var retval = new XQueryParser.pm_AnnotatedDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON53 = null;
         var p_Annotation51 = null;
         var pg_AnnotatedDecl52 = null;

        var k_tree=null;
        var SEMICOLON53_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:461:9: (k= DECLARE ( p_Annotation )* pg_AnnotatedDecl SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:461:11: k= DECLARE ( p_Annotation )* pg_AnnotatedDecl SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_AnnotatedDecl2614); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:461:36: ( p_Annotation )*
            loop28:
            do {
                var alt28=2;
                var LA28_0 = this.input.LA(1);

                if ( (LA28_0==ANN_PERCENT) ) {
                    alt28=1;
                }


                switch (alt28) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:461:36: p_Annotation
                    this.pushFollow(XQueryParser.FOLLOW_p_Annotation_in_pm_AnnotatedDecl2618);
                    p_Annotation51=this.p_Annotation();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Annotation51.getTree());


                    break;

                default :
                    break loop28;
                }
            } while (true);

            this.pushFollow(XQueryParser.FOLLOW_pg_AnnotatedDecl_in_pm_AnnotatedDecl2621);
            pg_AnnotatedDecl52=this.pg_AnnotatedDecl();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pg_AnnotatedDecl52.getTree());
            SEMICOLON53=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_AnnotatedDecl2623); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON53_tree = this.adaptor.create(SEMICOLON53);
            this.adaptor.addChild(root_0, SEMICOLON53_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pg_AnnotatedDecl_return: (function() {
        XQueryParser.pg_AnnotatedDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pg_AnnotatedDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:463:1: pg_AnnotatedDecl : ( p_VarDecl | pm_FunctionDecl | {...}? => p_CollectionDecl | {...}? => p_IndexDecl | {...}? => p_ICDecl );
    // $ANTLR start "pg_AnnotatedDecl"
    pg_AnnotatedDecl: function() {
        var retval = new XQueryParser.pg_AnnotatedDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_VarDecl54 = null;
         var pm_FunctionDecl55 = null;
         var p_CollectionDecl56 = null;
         var p_IndexDecl57 = null;
         var p_ICDecl58 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:464:9: ( p_VarDecl | pm_FunctionDecl | {...}? => p_CollectionDecl | {...}? => p_IndexDecl | {...}? => p_ICDecl )
            var alt29=5;
            var LA29_0 = this.input.LA(1);

            if ( (LA29_0==VARIABLE) ) {
                alt29=1;
            }
            else if ( (LA29_0==UPDATING) && ((this.lc(XQU)))) {
                alt29=2;
            }
            else if ( (LA29_0==FUNCTION) ) {
                alt29=2;
            }
            else if ( (LA29_0==COLLECTION) && ((this.lc(ZORBA)))) {
                alt29=3;
            }
            else if ( (LA29_0==INDEX) && ((this.lc(ZORBA)))) {
                alt29=4;
            }
            else if ( (LA29_0==INTEGRITY) && ((this.lc(ZORBA)))) {
                alt29=5;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 29, 0, this.input);

                throw nvae;
            }
            switch (alt29) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:464:11: p_VarDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_VarDecl_in_pg_AnnotatedDecl2647);
                    p_VarDecl54=this.p_VarDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_VarDecl54.getTree());


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:465:11: pm_FunctionDecl
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_pm_FunctionDecl_in_pg_AnnotatedDecl2659);
                    pm_FunctionDecl55=this.pm_FunctionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, pm_FunctionDecl55.getTree());


                    break;
                case 3 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:466:11: {...}? => p_CollectionDecl
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(ZORBA))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pg_AnnotatedDecl", "this.lc(ZORBA)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_CollectionDecl_in_pg_AnnotatedDecl2674);
                    p_CollectionDecl56=this.p_CollectionDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CollectionDecl56.getTree());


                    break;
                case 4 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:467:11: {...}? => p_IndexDecl
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(ZORBA))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pg_AnnotatedDecl", "this.lc(ZORBA)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_IndexDecl_in_pg_AnnotatedDecl2689);
                    p_IndexDecl57=this.p_IndexDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_IndexDecl57.getTree());


                    break;
                case 5 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:468:11: {...}? => p_ICDecl
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(ZORBA))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pg_AnnotatedDecl", "this.lc(ZORBA)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ICDecl_in_pg_AnnotatedDecl2704);
                    p_ICDecl58=this.p_ICDecl();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ICDecl58.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Annotation_return: (function() {
        XQueryParser.p_Annotation_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Annotation_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:472:1: p_Annotation : ANN_PERCENT p_EQName ( LPAREN p_Literal ( COMMA p_Literal )* RPAREN )? ;
    // $ANTLR start "p_Annotation"
    p_Annotation: function() {
        var retval = new XQueryParser.p_Annotation_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var ANN_PERCENT59 = null;
        var LPAREN61 = null;
        var COMMA63 = null;
        var RPAREN65 = null;
         var p_EQName60 = null;
         var p_Literal62 = null;
         var p_Literal64 = null;

        var ANN_PERCENT59_tree=null;
        var LPAREN61_tree=null;
        var COMMA63_tree=null;
        var RPAREN65_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:473:9: ( ANN_PERCENT p_EQName ( LPAREN p_Literal ( COMMA p_Literal )* RPAREN )? )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:473:11: ANN_PERCENT p_EQName ( LPAREN p_Literal ( COMMA p_Literal )* RPAREN )?
            root_0 = this.adaptor.nil();

            ANN_PERCENT59=this.match(this.input,ANN_PERCENT,XQueryParser.FOLLOW_ANN_PERCENT_in_p_Annotation2730); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            ANN_PERCENT59_tree = this.adaptor.create(ANN_PERCENT59);
            this.adaptor.addChild(root_0, ANN_PERCENT59_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_EQName_in_p_Annotation2732);
            p_EQName60=this.p_EQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_EQName60.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:473:32: ( LPAREN p_Literal ( COMMA p_Literal )* RPAREN )?
            var alt31=2;
            var LA31_0 = this.input.LA(1);

            if ( (LA31_0==LPAREN) ) {
                alt31=1;
            }
            switch (alt31) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:473:33: LPAREN p_Literal ( COMMA p_Literal )* RPAREN
                    LPAREN61=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_p_Annotation2735); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    LPAREN61_tree = this.adaptor.create(LPAREN61);
                    this.adaptor.addChild(root_0, LPAREN61_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_Literal_in_p_Annotation2737);
                    p_Literal62=this.p_Literal();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Literal62.getTree());
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:473:50: ( COMMA p_Literal )*
                    loop30:
                    do {
                        var alt30=2;
                        var LA30_0 = this.input.LA(1);

                        if ( (LA30_0==COMMA) ) {
                            alt30=1;
                        }


                        switch (alt30) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:473:51: COMMA p_Literal
                            COMMA63=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_Annotation2740); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            COMMA63_tree = this.adaptor.create(COMMA63);
                            this.adaptor.addChild(root_0, COMMA63_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_Literal_in_p_Annotation2742);
                            p_Literal64=this.p_Literal();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Literal64.getTree());


                            break;

                        default :
                            break loop30;
                        }
                    } while (true);

                    RPAREN65=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_p_Annotation2746); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    RPAREN65_tree = this.adaptor.create(RPAREN65);
                    this.adaptor.addChild(root_0, RPAREN65_tree);
                    }


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VarDecl_return: (function() {
        XQueryParser.p_VarDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VarDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:477:1: p_VarDecl : k= VARIABLE d= DOLLAR qn= p_EQName (td= p_TypeDeclaration )? ( ( BIND vv= p_VarValue ) | (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? ) ) -> ^( VarDecl $qn ^( VarType ( $td)? ) ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) ) ) ;
    // $ANTLR start "p_VarDecl"
    p_VarDecl: function() {
        var retval = new XQueryParser.p_VarDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
        var BIND66 = null;
        var BIND67 = null;
         var qn = null;
         var td = null;
         var vv = null;
         var vdv = null;

        var k_tree=null;
        var d_tree=null;
        var BIND66_tree=null;
        var BIND67_tree=null;
        var stream_DOLLAR=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DOLLAR");
        var stream_EXTERNAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EXTERNAL");
        var stream_VARIABLE=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token VARIABLE");
        var stream_BIND=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token BIND");
        var stream_p_TypeDeclaration=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_TypeDeclaration");
        var stream_p_VarDefaultValue=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_VarDefaultValue");
        var stream_p_VarValue=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_VarValue");
        var stream_p_EQName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_EQName");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:9: (k= VARIABLE d= DOLLAR qn= p_EQName (td= p_TypeDeclaration )? ( ( BIND vv= p_VarValue ) | (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? ) ) -> ^( VarDecl $qn ^( VarType ( $td)? ) ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) ) ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:11: k= VARIABLE d= DOLLAR qn= p_EQName (td= p_TypeDeclaration )? ( ( BIND vv= p_VarValue ) | (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? ) )
            k=this.match(this.input,VARIABLE,XQueryParser.FOLLOW_VARIABLE_in_p_VarDecl2776); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_VARIABLE.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_VarDecl2782); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_DOLLAR.add(d);

            this.pushFollow(XQueryParser.FOLLOW_p_EQName_in_p_VarDecl2786);
            qn=this.p_EQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_EQName.add(qn.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (qn?qn.stop:null)); 
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:87: (td= p_TypeDeclaration )?
            var alt32=2;
            var LA32_0 = this.input.LA(1);

            if ( (LA32_0==AS) ) {
                alt32=1;
            }
            switch (alt32) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:87: td= p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_VarDecl2792);
                    td=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_TypeDeclaration.add(td.getTree());


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:107: ( ( BIND vv= p_VarValue ) | (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? ) )
            var alt34=2;
            var LA34_0 = this.input.LA(1);

            if ( (LA34_0==BIND) ) {
                alt34=1;
            }
            else if ( (LA34_0==EXTERNAL) ) {
                alt34=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 34, 0, this.input);

                throw nvae;
            }
            switch (alt34) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:108: ( BIND vv= p_VarValue )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:108: ( BIND vv= p_VarValue )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:109: BIND vv= p_VarValue
                    BIND66=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_p_VarDecl2797); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_BIND.add(BIND66);

                    this.pushFollow(XQueryParser.FOLLOW_p_VarValue_in_p_VarDecl2801);
                    vv=this.p_VarValue();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_VarValue.add(vv.getTree());





                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:131: (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:131: (k= EXTERNAL ( BIND vdv= p_VarDefaultValue )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:132: k= EXTERNAL ( BIND vdv= p_VarDefaultValue )?
                    k=this.match(this.input,EXTERNAL,XQueryParser.FOLLOW_EXTERNAL_in_p_VarDecl2809); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EXTERNAL.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:158: ( BIND vdv= p_VarDefaultValue )?
                    var alt33=2;
                    var LA33_0 = this.input.LA(1);

                    if ( (LA33_0==BIND) ) {
                        alt33=1;
                    }
                    switch (alt33) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:478:159: BIND vdv= p_VarDefaultValue
                            BIND67=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_p_VarDecl2814); if (this.state.failed) return retval; 
                            if ( this.state.backtracking===0 ) stream_BIND.add(BIND67);

                            this.pushFollow(XQueryParser.FOLLOW_p_VarDefaultValue_in_p_VarDecl2818);
                            vdv=this.p_VarDefaultValue();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) stream_p_VarDefaultValue.add(vdv.getTree());


                            break;

                    }






                    break;

            }



            // AST REWRITE
            // elements: vv, qn, td, vdv
            // token labels: 
            // rule labels: qn, vv, retval, vdv, td
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_qn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token qn",qn!=null?qn.tree:null);
            var stream_vv=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token vv",vv!=null?vv.tree:null);
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_vdv=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token vdv",vdv!=null?vdv.tree:null);
            var stream_td=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token td",td!=null?td.tree:null);

            root_0 = this.adaptor.nil();
            // 479:17: -> ^( VarDecl $qn ^( VarType ( $td)? ) ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) ) )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:479:20: ^( VarDecl $qn ^( VarType ( $td)? ) ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) ) )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(VarDecl, "VarDecl"), root_1);

                this.adaptor.addChild(root_1, stream_qn.nextTree());
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:479:34: ^( VarType ( $td)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(VarType, "VarType"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:479:44: ( $td)?
                if ( stream_td.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_td.nextTree());

                }
                stream_td.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:479:50: ^( VarValue ( $vv)? ^( VarDefaultValue ( $vdv)? ) )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(VarValue, "VarValue"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:479:61: ( $vv)?
                if ( stream_vv.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_vv.nextTree());

                }
                stream_vv.reset();
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:479:66: ^( VarDefaultValue ( $vdv)? )
                {
                var root_3 = this.adaptor.nil();
                root_3 = this.adaptor.becomeRoot(this.adaptor.create(VarDefaultValue, "VarDefaultValue"), root_3);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:479:84: ( $vdv)?
                if ( stream_vdv.hasNext() ) {
                    this.adaptor.addChild(root_3, stream_vdv.nextTree());

                }
                stream_vdv.reset();

                this.adaptor.addChild(root_2, root_3);
                }

                this.adaptor.addChild(root_1, root_2);
                }

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VarValue_return: (function() {
        XQueryParser.p_VarValue_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VarValue_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:483:1: p_VarValue : p_ExprSingle[true] ;
    // $ANTLR start "p_VarValue"
    p_VarValue: function() {
        var retval = new XQueryParser.p_VarValue_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle68 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:484:9: ( p_ExprSingle[true] )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:484:11: p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_VarValue2897);
            p_ExprSingle68=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle68.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_VarDefaultValue_return: (function() {
        XQueryParser.p_VarDefaultValue_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_VarDefaultValue_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:488:1: p_VarDefaultValue : p_ExprSingle[true] ;
    // $ANTLR start "p_VarDefaultValue"
    p_VarDefaultValue: function() {
        var retval = new XQueryParser.p_VarDefaultValue_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ExprSingle69 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:489:9: ( p_ExprSingle[true] )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:489:11: p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_VarDefaultValue2924);
            p_ExprSingle69=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle69.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_ContextItemDecl_return: (function() {
        XQueryParser.pm_ContextItemDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_ContextItemDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:493:1: pm_ContextItemDecl : k= DECLARE k= CONTEXT k= ITEM (k= AS p_ItemType )? ( ( BIND p_VarValue ) | (k= EXTERNAL ( BIND p_VarDefaultValue )? ) ) SEMICOLON ;
    // $ANTLR start "pm_ContextItemDecl"
    pm_ContextItemDecl: function() {
        var retval = new XQueryParser.pm_ContextItemDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var BIND71 = null;
        var BIND73 = null;
        var SEMICOLON75 = null;
         var p_ItemType70 = null;
         var p_VarValue72 = null;
         var p_VarDefaultValue74 = null;

        var k_tree=null;
        var BIND71_tree=null;
        var BIND73_tree=null;
        var SEMICOLON75_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:9: (k= DECLARE k= CONTEXT k= ITEM (k= AS p_ItemType )? ( ( BIND p_VarValue ) | (k= EXTERNAL ( BIND p_VarDefaultValue )? ) ) SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:11: k= DECLARE k= CONTEXT k= ITEM (k= AS p_ItemType )? ( ( BIND p_VarValue ) | (k= EXTERNAL ( BIND p_VarDefaultValue )? ) ) SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_ContextItemDecl2953); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,CONTEXT,XQueryParser.FOLLOW_CONTEXT_in_pm_ContextItemDecl2959); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,ITEM,XQueryParser.FOLLOW_ITEM_in_pm_ContextItemDecl2965); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:83: (k= AS p_ItemType )?
            var alt35=2;
            var LA35_0 = this.input.LA(1);

            if ( (LA35_0==AS) ) {
                alt35=1;
            }
            switch (alt35) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:84: k= AS p_ItemType
                    k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_pm_ContextItemDecl2972); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ItemType_in_pm_ContextItemDecl2976);
                    p_ItemType70=this.p_ItemType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ItemType70.getTree());


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:117: ( ( BIND p_VarValue ) | (k= EXTERNAL ( BIND p_VarDefaultValue )? ) )
            var alt37=2;
            var LA37_0 = this.input.LA(1);

            if ( (LA37_0==BIND) ) {
                alt37=1;
            }
            else if ( (LA37_0==EXTERNAL) ) {
                alt37=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 37, 0, this.input);

                throw nvae;
            }
            switch (alt37) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:118: ( BIND p_VarValue )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:118: ( BIND p_VarValue )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:119: BIND p_VarValue
                    BIND71=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_pm_ContextItemDecl2982); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    BIND71_tree = this.adaptor.create(BIND71);
                    this.adaptor.addChild(root_0, BIND71_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_VarValue_in_pm_ContextItemDecl2984);
                    p_VarValue72=this.p_VarValue();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_VarValue72.getTree());





                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:138: (k= EXTERNAL ( BIND p_VarDefaultValue )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:138: (k= EXTERNAL ( BIND p_VarDefaultValue )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:139: k= EXTERNAL ( BIND p_VarDefaultValue )?
                    k=this.match(this.input,EXTERNAL,XQueryParser.FOLLOW_EXTERNAL_in_pm_ContextItemDecl2992); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:165: ( BIND p_VarDefaultValue )?
                    var alt36=2;
                    var LA36_0 = this.input.LA(1);

                    if ( (LA36_0==BIND) ) {
                        alt36=1;
                    }
                    switch (alt36) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:494:166: BIND p_VarDefaultValue
                            BIND73=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_pm_ContextItemDecl2997); if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) {
                            BIND73_tree = this.adaptor.create(BIND73);
                            this.adaptor.addChild(root_0, BIND73_tree);
                            }
                            this.pushFollow(XQueryParser.FOLLOW_p_VarDefaultValue_in_pm_ContextItemDecl2999);
                            p_VarDefaultValue74=this.p_VarDefaultValue();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_VarDefaultValue74.getTree());


                            break;

                    }






                    break;

            }

            SEMICOLON75=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_ContextItemDecl3005); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON75_tree = this.adaptor.create(SEMICOLON75);
            this.adaptor.addChild(root_0, SEMICOLON75_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_FunctionDecl_return: (function() {
        XQueryParser.pm_FunctionDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_FunctionDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:499:1: pm_FunctionDecl : ({...}? =>k= UPDATING )? k= FUNCTION qn= pg_FQName LPAREN (pl= p_ParamList )? RPAREN (k= AS st= p_SequenceType )? ( LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET | k= EXTERNAL ) -> ^( FunctionDecl $qn ^( ParamList ( $pl)? ) ^( ReturnType ( $st)? ) ( $soe)? ) ;
    // $ANTLR start "pm_FunctionDecl"
    pm_FunctionDecl: function() {
        var retval = new XQueryParser.pm_FunctionDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var LPAREN76 = null;
        var RPAREN77 = null;
        var LBRACKET78 = null;
        var RBRACKET79 = null;
         var qn = null;
         var pl = null;
         var st = null;
         var soe = null;

        var k_tree=null;
        var LPAREN76_tree=null;
        var RPAREN77_tree=null;
        var LBRACKET78_tree=null;
        var RBRACKET79_tree=null;
        var stream_FUNCTION=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token FUNCTION");
        var stream_LBRACKET=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token LBRACKET");
        var stream_AS=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token AS");
        var stream_RPAREN=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token RPAREN");
        var stream_EXTERNAL=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token EXTERNAL");
        var stream_RBRACKET=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token RBRACKET");
        var stream_LPAREN=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token LPAREN");
        var stream_UPDATING=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token UPDATING");
        var stream_p_StatementsAndOptionalExpr=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_StatementsAndOptionalExpr");
        var stream_p_ParamList=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_ParamList");
        var stream_pg_FQName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule pg_FQName");
        var stream_p_SequenceType=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_SequenceType");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:9: ( ({...}? =>k= UPDATING )? k= FUNCTION qn= pg_FQName LPAREN (pl= p_ParamList )? RPAREN (k= AS st= p_SequenceType )? ( LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET | k= EXTERNAL ) -> ^( FunctionDecl $qn ^( ParamList ( $pl)? ) ^( ReturnType ( $st)? ) ( $soe)? ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:11: ({...}? =>k= UPDATING )? k= FUNCTION qn= pg_FQName LPAREN (pl= p_ParamList )? RPAREN (k= AS st= p_SequenceType )? ( LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET | k= EXTERNAL )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:11: ({...}? =>k= UPDATING )?
            var alt38=2;
            var LA38_0 = this.input.LA(1);

            if ( (LA38_0==UPDATING) && ((this.lc(XQU)))) {
                alt38=1;
            }
            switch (alt38) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:12: {...}? =>k= UPDATING
                    if ( !((this.lc(XQU))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pm_FunctionDecl", "this.lc(XQU)");
                    }
                    k=this.match(this.input,UPDATING,XQueryParser.FOLLOW_UPDATING_in_pm_FunctionDecl3038); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_UPDATING.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    break;

            }

            k=this.match(this.input,FUNCTION,XQueryParser.FOLLOW_FUNCTION_in_pm_FunctionDecl3046); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_FUNCTION.add(k);

            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_pg_FQName_in_pm_FunctionDecl3052);
            qn=this.pg_FQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_pg_FQName.add(qn.getTree());
            LPAREN76=this.match(this.input,LPAREN,XQueryParser.FOLLOW_LPAREN_in_pm_FunctionDecl3054); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_LPAREN.add(LPAREN76);

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:106: (pl= p_ParamList )?
            var alt39=2;
            var LA39_0 = this.input.LA(1);

            if ( (LA39_0==DOLLAR) ) {
                alt39=1;
            }
            switch (alt39) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:106: pl= p_ParamList
                    this.pushFollow(XQueryParser.FOLLOW_p_ParamList_in_pm_FunctionDecl3058);
                    pl=this.p_ParamList();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_ParamList.add(pl.getTree());


                    break;

            }

            RPAREN77=this.match(this.input,RPAREN,XQueryParser.FOLLOW_RPAREN_in_pm_FunctionDecl3061); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_RPAREN.add(RPAREN77);

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:127: (k= AS st= p_SequenceType )?
            var alt40=2;
            var LA40_0 = this.input.LA(1);

            if ( (LA40_0==AS) ) {
                alt40=1;
            }
            switch (alt40) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:128: k= AS st= p_SequenceType
                    k=this.match(this.input,AS,XQueryParser.FOLLOW_AS_in_pm_FunctionDecl3066); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_AS.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_SequenceType_in_pm_FunctionDecl3072);
                    st=this.p_SequenceType();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_SequenceType.add(st.getTree());


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:168: ( LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET | k= EXTERNAL )
            var alt41=2;
            var LA41_0 = this.input.LA(1);

            if ( (LA41_0==LBRACKET) ) {
                alt41=1;
            }
            else if ( (LA41_0==EXTERNAL) ) {
                alt41=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 41, 0, this.input);

                throw nvae;
            }
            switch (alt41) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:169: LBRACKET soe= p_StatementsAndOptionalExpr RBRACKET
                    LBRACKET78=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_pm_FunctionDecl3077); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_LBRACKET.add(LBRACKET78);

                    this.pushFollow(XQueryParser.FOLLOW_p_StatementsAndOptionalExpr_in_pm_FunctionDecl3081);
                    soe=this.p_StatementsAndOptionalExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_StatementsAndOptionalExpr.add(soe.getTree());
                    RBRACKET79=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_pm_FunctionDecl3083); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_RBRACKET.add(RBRACKET79);



                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:500:221: k= EXTERNAL
                    k=this.match(this.input,EXTERNAL,XQueryParser.FOLLOW_EXTERNAL_in_pm_FunctionDecl3089); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_EXTERNAL.add(k);

                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    break;

            }



            // AST REWRITE
            // elements: soe, pl, st, qn
            // token labels: 
            // rule labels: qn, soe, retval, pl, st
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_qn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token qn",qn!=null?qn.tree:null);
            var stream_soe=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token soe",soe!=null?soe.tree:null);
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_pl=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token pl",pl!=null?pl.tree:null);
            var stream_st=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token st",st!=null?st.tree:null);

            root_0 = this.adaptor.nil();
            // 501:17: -> ^( FunctionDecl $qn ^( ParamList ( $pl)? ) ^( ReturnType ( $st)? ) ( $soe)? )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:501:20: ^( FunctionDecl $qn ^( ParamList ( $pl)? ) ^( ReturnType ( $st)? ) ( $soe)? )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(FunctionDecl, "FunctionDecl"), root_1);

                this.adaptor.addChild(root_1, stream_qn.nextTree());
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:501:39: ^( ParamList ( $pl)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(ParamList, "ParamList"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:501:51: ( $pl)?
                if ( stream_pl.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_pl.nextTree());

                }
                stream_pl.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:501:57: ^( ReturnType ( $st)? )
                {
                var root_2 = this.adaptor.nil();
                root_2 = this.adaptor.becomeRoot(this.adaptor.create(ReturnType, "ReturnType"), root_2);

                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:501:70: ( $st)?
                if ( stream_st.hasNext() ) {
                    this.adaptor.addChild(root_2, stream_st.nextTree());

                }
                stream_st.reset();

                this.adaptor.addChild(root_1, root_2);
                }
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:501:76: ( $soe)?
                if ( stream_soe.hasNext() ) {
                    this.adaptor.addChild(root_1, stream_soe.nextTree());

                }
                stream_soe.reset();

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ParamList_return: (function() {
        XQueryParser.p_ParamList_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ParamList_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:505:1: p_ParamList : p+= p_Param ( COMMA p+= p_Param )* -> ( $p)+ ;
    // $ANTLR start "p_ParamList"
    p_ParamList: function() {
        var retval = new XQueryParser.p_ParamList_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var COMMA80 = null;
        var list_p=null;
        var p = null;
        var COMMA80_tree=null;
        var stream_COMMA=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token COMMA");
        var stream_p_Param=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_Param");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:506:9: (p+= p_Param ( COMMA p+= p_Param )* -> ( $p)+ )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:506:11: p+= p_Param ( COMMA p+= p_Param )*
            this.pushFollow(XQueryParser.FOLLOW_p_Param_in_p_ParamList3166);
            p=this.p_Param();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_Param.add(p.getTree());
            if (org.antlr.lang.isNull(list_p)) list_p = [];
            list_p.push(p.getTree());

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:506:22: ( COMMA p+= p_Param )*
            loop42:
            do {
                var alt42=2;
                var LA42_0 = this.input.LA(1);

                if ( (LA42_0==COMMA) ) {
                    alt42=1;
                }


                switch (alt42) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:506:23: COMMA p+= p_Param
                    COMMA80=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_ParamList3169); if (this.state.failed) return retval; 
                    if ( this.state.backtracking===0 ) stream_COMMA.add(COMMA80);

                    this.pushFollow(XQueryParser.FOLLOW_p_Param_in_p_ParamList3173);
                    p=this.p_Param();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_Param.add(p.getTree());
                    if (org.antlr.lang.isNull(list_p)) list_p = [];
                    list_p.push(p.getTree());



                    break;

                default :
                    break loop42;
                }
            } while (true);



            // AST REWRITE
            // elements: p
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: p
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_p=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token p",list_p);
            root_0 = this.adaptor.nil();
            // 507:17: -> ( $p)+
            {
                if ( !(stream_p.hasNext()) ) {
                    throw new org.antlr.runtime.tree.RewriteEarlyExitException();
                }
                while ( stream_p.hasNext() ) {
                    this.adaptor.addChild(root_0, stream_p.nextTree());

                }
                stream_p.reset();

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Param_return: (function() {
        XQueryParser.p_Param_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Param_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:511:1: p_Param : d= DOLLAR qn= p_EQName (td= p_TypeDeclaration )? -> ^( Param $qn ( $td)? ) ;
    // $ANTLR start "p_Param"
    p_Param: function() {
        var retval = new XQueryParser.p_Param_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
         var qn = null;
         var td = null;

        var d_tree=null;
        var stream_DOLLAR=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token DOLLAR");
        var stream_p_TypeDeclaration=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_TypeDeclaration");
        var stream_p_EQName=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_EQName");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:512:9: (d= DOLLAR qn= p_EQName (td= p_TypeDeclaration )? -> ^( Param $qn ( $td)? ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:512:11: d= DOLLAR qn= p_EQName (td= p_TypeDeclaration )?
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_Param3233); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_DOLLAR.add(d);

            this.pushFollow(XQueryParser.FOLLOW_p_EQName_in_p_Param3237);
            qn=this.p_EQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_EQName.add(qn.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (qn?qn.stop:null)); 
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:512:61: (td= p_TypeDeclaration )?
            var alt43=2;
            var LA43_0 = this.input.LA(1);

            if ( (LA43_0==AS) ) {
                alt43=1;
            }
            switch (alt43) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:512:61: td= p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_Param3243);
                    td=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) stream_p_TypeDeclaration.add(td.getTree());


                    break;

            }



            // AST REWRITE
            // elements: qn, td
            // token labels: 
            // rule labels: qn, retval, td
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_qn=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token qn",qn!=null?qn.tree:null);
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);
            var stream_td=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token td",td!=null?td.tree:null);

            root_0 = this.adaptor.nil();
            // 513:17: -> ^( Param $qn ( $td)? )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:513:20: ^( Param $qn ( $td)? )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(Param, "Param"), root_1);

                this.adaptor.addChild(root_1, stream_qn.nextTree());
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:513:32: ( $td)?
                if ( stream_td.hasNext() ) {
                    this.adaptor.addChild(root_1, stream_td.nextTree());

                }
                stream_td.reset();

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_FunctionBody_return: (function() {
        XQueryParser.pm_FunctionBody_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_FunctionBody_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:517:1: pm_FunctionBody : p_EnclosedExpr ;
    // $ANTLR start "pm_FunctionBody"
    pm_FunctionBody: function() {
        var retval = new XQueryParser.pm_FunctionBody_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_EnclosedExpr81 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:518:9: ( p_EnclosedExpr )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:518:11: p_EnclosedExpr
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_EnclosedExpr_in_pm_FunctionBody3299);
            p_EnclosedExpr81=this.p_EnclosedExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_EnclosedExpr81.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_EnclosedExpr_return: (function() {
        XQueryParser.p_EnclosedExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_EnclosedExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:523:1: p_EnclosedExpr : LBRACKET p_Expr[true,true] RBRACKET -> ^( EnclosedExpr p_Expr ) ;
    // $ANTLR start "p_EnclosedExpr"
    p_EnclosedExpr: function() {
        var retval = new XQueryParser.p_EnclosedExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var LBRACKET82 = null;
        var RBRACKET84 = null;
         var p_Expr83 = null;

        var LBRACKET82_tree=null;
        var RBRACKET84_tree=null;
        var stream_LBRACKET=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token LBRACKET");
        var stream_RBRACKET=new org.antlr.runtime.tree.RewriteRuleTokenStream(this.adaptor,"token RBRACKET");
        var stream_p_Expr=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"rule p_Expr");
        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:524:9: ( LBRACKET p_Expr[true,true] RBRACKET -> ^( EnclosedExpr p_Expr ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:524:11: LBRACKET p_Expr[true,true] RBRACKET
            LBRACKET82=this.match(this.input,LBRACKET,XQueryParser.FOLLOW_LBRACKET_in_p_EnclosedExpr3326); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_LBRACKET.add(LBRACKET82);

            this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_p_EnclosedExpr3328);
            p_Expr83=this.p_Expr(true, true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) stream_p_Expr.add(p_Expr83.getTree());
            RBRACKET84=this.match(this.input,RBRACKET,XQueryParser.FOLLOW_RBRACKET_in_p_EnclosedExpr3331); if (this.state.failed) return retval; 
            if ( this.state.backtracking===0 ) stream_RBRACKET.add(RBRACKET84);



            // AST REWRITE
            // elements: p_Expr
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            if ( this.state.backtracking===0 ) {
            retval.tree = root_0;
            var stream_retval=new org.antlr.runtime.tree.RewriteRuleSubtreeStream(this.adaptor,"token retval",retval!=null?retval.tree:null);

            root_0 = this.adaptor.nil();
            // 525:17: -> ^( EnclosedExpr p_Expr )
            {
                // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:525:20: ^( EnclosedExpr p_Expr )
                {
                var root_1 = this.adaptor.nil();
                root_1 = this.adaptor.becomeRoot(this.adaptor.create(EnclosedExpr, "EnclosedExpr"), root_1);

                this.adaptor.addChild(root_1, stream_p_Expr.nextTree());

                this.adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}


            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_OptionDecl_return: (function() {
        XQueryParser.pm_OptionDecl_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_OptionDecl_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:529:1: pm_OptionDecl : k= DECLARE k= OPTION p_EQName p_StringLiteral SEMICOLON ;
    // $ANTLR start "pm_OptionDecl"
    pm_OptionDecl: function() {
        var retval = new XQueryParser.pm_OptionDecl_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var SEMICOLON87 = null;
         var p_EQName85 = null;
         var p_StringLiteral86 = null;

        var k_tree=null;
        var SEMICOLON87_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:530:9: (k= DECLARE k= OPTION p_EQName p_StringLiteral SEMICOLON )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:530:11: k= DECLARE k= OPTION p_EQName p_StringLiteral SEMICOLON
            root_0 = this.adaptor.nil();

            k=this.match(this.input,DECLARE,XQueryParser.FOLLOW_DECLARE_in_pm_OptionDecl3383); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,OPTION,XQueryParser.FOLLOW_OPTION_in_pm_OptionDecl3389); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_EQName_in_pm_OptionDecl3393);
            p_EQName85=this.p_EQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_EQName85.getTree());
            this.pushFollow(XQueryParser.FOLLOW_p_StringLiteral_in_pm_OptionDecl3395);
            p_StringLiteral86=this.p_StringLiteral();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_StringLiteral86.getTree());
            SEMICOLON87=this.match(this.input,SEMICOLON,XQueryParser.FOLLOW_SEMICOLON_in_pm_OptionDecl3397); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            SEMICOLON87_tree = this.adaptor.create(SEMICOLON87);
            this.adaptor.addChild(root_0, SEMICOLON87_tree);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    pm_QueryBody_return: (function() {
        XQueryParser.pm_QueryBody_return = function(){};
        org.antlr.lang.extend(XQueryParser.pm_QueryBody_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:534:1: pm_QueryBody : ({...}? => p_Program | p_Expr[true,true] );
    // $ANTLR start "pm_QueryBody"
    pm_QueryBody: function() {
        var retval = new XQueryParser.pm_QueryBody_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_Program88 = null;
         var p_Expr89 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:535:9: ({...}? => p_Program | p_Expr[true,true] )
            var alt44=2;
            alt44 = this.dfa44.predict(this.input);
            switch (alt44) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:535:11: {...}? => p_Program
                    root_0 = this.adaptor.nil();

                    if ( !((this.lc(XQS))) ) {
                        if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                        throw new org.antlr.runtime.FailedPredicateException(this.input, "pm_QueryBody", "this.lc(XQS)");
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_Program_in_pm_QueryBody3426);
                    p_Program88=this.p_Program();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Program88.getTree());


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:536:11: p_Expr[true,true]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_Expr_in_pm_QueryBody3438);
                    p_Expr89=this.p_Expr(true, true);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_Expr89.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_Expr_return: (function() {
        XQueryParser.p_Expr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_Expr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:546:1: p_Expr[strict, allowConcat] : es= p_ExprSingle[$strict] ( COMMA p_ExprSingle[$strict] )* ;
    // $ANTLR start "p_Expr"
    p_Expr: function(strict, allowConcat) {
        var retval = new XQueryParser.p_Expr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var COMMA90 = null;
         var es = null;
         var p_ExprSingle91 = null;

        var COMMA90_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:547:9: (es= p_ExprSingle[$strict] ( COMMA p_ExprSingle[$strict] )* )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:547:11: es= p_ExprSingle[$strict] ( COMMA p_ExprSingle[$strict] )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_Expr3474);
            es=this.p_ExprSingle(strict);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, es.getTree());
            if ( this.state.backtracking===0 ) {
               if (!allowConcat) throw new Exception(); 
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:548:11: ( COMMA p_ExprSingle[$strict] )*
            loop45:
            do {
                var alt45=2;
                var LA45_0 = this.input.LA(1);

                if ( (LA45_0==COMMA) ) {
                    alt45=1;
                }


                switch (alt45) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:548:12: COMMA p_ExprSingle[$strict]
                    COMMA90=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_Expr3490); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA90_tree = this.adaptor.create(COMMA90);
                    this.adaptor.addChild(root_0, COMMA90_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_Expr3492);
                    p_ExprSingle91=this.p_ExprSingle(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle91.getTree());


                    break;

                default :
                    break loop45;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (e) {

              if(e instanceof org.antlr.runtime.RecognitionException) {
                //console.log("catch1");
                reportError(e);
                recover(this.input, e);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), e);
              } else if(e instanceof Exception) {
                //console.log("catch2");
                root_0 = this.adaptor.nil();
                this.adaptor.addChild(root_0, es.getTree());
                retval.stop = this.input.LT(-1);
                retval.tree = this.adaptor.rulePostProcessing(root_0);
                this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
              } else {
                throw e;
              }

        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ExprSingle_return: (function() {
        XQueryParser.p_ExprSingle_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ExprSingle_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:570:1: p_ExprSingle[strict] : ( ( ( ( FOR | LET ) DOLLAR ) | ( FOR ( TUMBLING | SLIDING ) ) )=> p_FLWORHybrid[$strict] | ( IF LPAREN )=> p_IfHybrid[$strict] | ( SWITCH LPAREN )=> p_SwitchHybrid[$strict] | ( TYPESWITCH LPAREN )=> p_TypeswitchHybrid[$strict] | ( TRY LBRACKET )=> p_TryCatchHybrid[$strict] | p_ExprSimple );
    // $ANTLR start "p_ExprSingle"
    p_ExprSingle: function(strict) {
        var retval = new XQueryParser.p_ExprSingle_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_FLWORHybrid92 = null;
         var p_IfHybrid93 = null;
         var p_SwitchHybrid94 = null;
         var p_TypeswitchHybrid95 = null;
         var p_TryCatchHybrid96 = null;
         var p_ExprSimple97 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:571:9: ( ( ( ( FOR | LET ) DOLLAR ) | ( FOR ( TUMBLING | SLIDING ) ) )=> p_FLWORHybrid[$strict] | ( IF LPAREN )=> p_IfHybrid[$strict] | ( SWITCH LPAREN )=> p_SwitchHybrid[$strict] | ( TYPESWITCH LPAREN )=> p_TypeswitchHybrid[$strict] | ( TRY LBRACKET )=> p_TryCatchHybrid[$strict] | p_ExprSimple )
            var alt46=6;
            alt46 = this.dfa46.predict(this.input);
            switch (alt46) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:571:11: ( ( ( FOR | LET ) DOLLAR ) | ( FOR ( TUMBLING | SLIDING ) ) )=> p_FLWORHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_FLWORHybrid_in_p_ExprSingle3559);
                    p_FLWORHybrid92=this.p_FLWORHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_FLWORHybrid92.getTree());


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:572:11: ( IF LPAREN )=> p_IfHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_IfHybrid_in_p_ExprSingle3589);
                    p_IfHybrid93=this.p_IfHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_IfHybrid93.getTree());


                    break;
                case 3 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:573:11: ( SWITCH LPAREN )=> p_SwitchHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_SwitchHybrid_in_p_ExprSingle3615);
                    p_SwitchHybrid94=this.p_SwitchHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SwitchHybrid94.getTree());


                    break;
                case 4 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:574:11: ( TYPESWITCH LPAREN )=> p_TypeswitchHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_TypeswitchHybrid_in_p_ExprSingle3637);
                    p_TypeswitchHybrid95=this.p_TypeswitchHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeswitchHybrid95.getTree());


                    break;
                case 5 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:575:11: ( TRY LBRACKET )=> p_TryCatchHybrid[$strict]
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_TryCatchHybrid_in_p_ExprSingle3664);
                    p_TryCatchHybrid96=this.p_TryCatchHybrid(strict);

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TryCatchHybrid96.getTree());


                    break;
                case 6 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:576:11: p_ExprSimple
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ExprSimple_in_p_ExprSingle3677);
                    p_ExprSimple97=this.p_ExprSimple();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSimple97.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_FLWORHybrid_return: (function() {
        XQueryParser.p_FLWORHybrid_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_FLWORHybrid_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:580:1: p_FLWORHybrid[strict] : p_InitialClause ( p_IntermediateClause )* p_ReturnHybrid[$strict] ;
    // $ANTLR start "p_FLWORHybrid"
    p_FLWORHybrid: function(strict) {
        var retval = new XQueryParser.p_FLWORHybrid_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_InitialClause98 = null;
         var p_IntermediateClause99 = null;
         var p_ReturnHybrid100 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:581:9: ( p_InitialClause ( p_IntermediateClause )* p_ReturnHybrid[$strict] )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:581:11: p_InitialClause ( p_IntermediateClause )* p_ReturnHybrid[$strict]
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_InitialClause_in_p_FLWORHybrid3704);
            p_InitialClause98=this.p_InitialClause();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InitialClause98.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:581:27: ( p_IntermediateClause )*
            loop47:
            do {
                var alt47=2;
                var LA47_0 = this.input.LA(1);

                if ( (LA47_0==FOR||LA47_0==LET||LA47_0==ORDER||LA47_0==STABLE||LA47_0==WHERE||LA47_0==COUNT||LA47_0==GROUP) ) {
                    alt47=1;
                }


                switch (alt47) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:581:27: p_IntermediateClause
                    this.pushFollow(XQueryParser.FOLLOW_p_IntermediateClause_in_p_FLWORHybrid3706);
                    p_IntermediateClause99=this.p_IntermediateClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_IntermediateClause99.getTree());


                    break;

                default :
                    break loop47;
                }
            } while (true);

            this.pushFollow(XQueryParser.FOLLOW_p_ReturnHybrid_in_p_FLWORHybrid3709);
            p_ReturnHybrid100=this.p_ReturnHybrid(strict);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ReturnHybrid100.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_InitialClause_return: (function() {
        XQueryParser.p_InitialClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_InitialClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:585:1: p_InitialClause : ( p_ForClause | p_LetClause | p_WindowClause );
    // $ANTLR start "p_InitialClause"
    p_InitialClause: function() {
        var retval = new XQueryParser.p_InitialClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_ForClause101 = null;
         var p_LetClause102 = null;
         var p_WindowClause103 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:586:9: ( p_ForClause | p_LetClause | p_WindowClause )
            var alt48=3;
            var LA48_0 = this.input.LA(1);

            if ( (LA48_0==FOR) ) {
                var LA48_1 = this.input.LA(2);

                if ( (LA48_1==DOLLAR) ) {
                    alt48=1;
                }
                else if ( (LA48_1==SLIDING||LA48_1==TUMBLING) ) {
                    alt48=3;
                }
                else {
                    if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                    var nvae =
                        new org.antlr.runtime.NoViableAltException("", 48, 1, this.input);

                    throw nvae;
                }
            }
            else if ( (LA48_0==LET) ) {
                alt48=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 48, 0, this.input);

                throw nvae;
            }
            switch (alt48) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:586:11: p_ForClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_ForClause_in_p_InitialClause3736);
                    p_ForClause101=this.p_ForClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ForClause101.getTree());


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:586:25: p_LetClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_LetClause_in_p_InitialClause3740);
                    p_LetClause102=this.p_LetClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_LetClause102.getTree());


                    break;
                case 3 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:586:39: p_WindowClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_WindowClause_in_p_InitialClause3744);
                    p_WindowClause103=this.p_WindowClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowClause103.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_IntermediateClause_return: (function() {
        XQueryParser.p_IntermediateClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_IntermediateClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:590:1: p_IntermediateClause : ( p_InitialClause | p_WhereClause | p_GroupByClause | p_OrderByClause | p_CountClause );
    // $ANTLR start "p_IntermediateClause"
    p_IntermediateClause: function() {
        var retval = new XQueryParser.p_IntermediateClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_InitialClause104 = null;
         var p_WhereClause105 = null;
         var p_GroupByClause106 = null;
         var p_OrderByClause107 = null;
         var p_CountClause108 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:591:9: ( p_InitialClause | p_WhereClause | p_GroupByClause | p_OrderByClause | p_CountClause )
            var alt49=5;
            switch ( this.input.LA(1) ) {
            case FOR:
            case LET:
                alt49=1;
                break;
            case WHERE:
                alt49=2;
                break;
            case GROUP:
                alt49=3;
                break;
            case ORDER:
            case STABLE:
                alt49=4;
                break;
            case COUNT:
                alt49=5;
                break;
            default:
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 49, 0, this.input);

                throw nvae;
            }

            switch (alt49) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:591:11: p_InitialClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_InitialClause_in_p_IntermediateClause3770);
                    p_InitialClause104=this.p_InitialClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_InitialClause104.getTree());


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:591:29: p_WhereClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_WhereClause_in_p_IntermediateClause3774);
                    p_WhereClause105=this.p_WhereClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WhereClause105.getTree());


                    break;
                case 3 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:591:45: p_GroupByClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_GroupByClause_in_p_IntermediateClause3778);
                    p_GroupByClause106=this.p_GroupByClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_GroupByClause106.getTree());


                    break;
                case 4 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:591:63: p_OrderByClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_OrderByClause_in_p_IntermediateClause3782);
                    p_OrderByClause107=this.p_OrderByClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_OrderByClause107.getTree());


                    break;
                case 5 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:591:81: p_CountClause
                    root_0 = this.adaptor.nil();

                    this.pushFollow(XQueryParser.FOLLOW_p_CountClause_in_p_IntermediateClause3786);
                    p_CountClause108=this.p_CountClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_CountClause108.getTree());


                    break;

            }
            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_StringConcatExpr_return: (function() {
        XQueryParser.p_StringConcatExpr_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_StringConcatExpr_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:595:1: p_StringConcatExpr : p_RangeExpr (o= CONCAT p_RangeExpr )* ;
    // $ANTLR start "p_StringConcatExpr"
    p_StringConcatExpr: function() {
        var retval = new XQueryParser.p_StringConcatExpr_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var o = null;
         var p_RangeExpr109 = null;
         var p_RangeExpr110 = null;

        var o_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:596:4: ( p_RangeExpr (o= CONCAT p_RangeExpr )* )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:596:6: p_RangeExpr (o= CONCAT p_RangeExpr )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_RangeExpr_in_p_StringConcatExpr3807);
            p_RangeExpr109=this.p_RangeExpr();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_RangeExpr109.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:596:18: (o= CONCAT p_RangeExpr )*
            loop50:
            do {
                var alt50=2;
                var LA50_0 = this.input.LA(1);

                if ( (LA50_0==CONCAT) ) {
                    alt50=1;
                }


                switch (alt50) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:596:20: o= CONCAT p_RangeExpr
                    o=this.match(this.input,CONCAT,XQueryParser.FOLLOW_CONCAT_in_p_StringConcatExpr3813); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    o_tree = this.adaptor.create(o);
                    this.adaptor.addChild(root_0, o_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                       this.ao(o); 
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_RangeExpr_in_p_StringConcatExpr3817);
                    p_RangeExpr110=this.p_RangeExpr();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_RangeExpr110.getTree());


                    break;

                default :
                    break loop50;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ForClause_return: (function() {
        XQueryParser.p_ForClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ForClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:601:1: p_ForClause : k= FOR p_ForBinding ( COMMA p_ForBinding )* ;
    // $ANTLR start "p_ForClause"
    p_ForClause: function() {
        var retval = new XQueryParser.p_ForClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var COMMA112 = null;
         var p_ForBinding111 = null;
         var p_ForBinding113 = null;

        var k_tree=null;
        var COMMA112_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:602:9: (k= FOR p_ForBinding ( COMMA p_ForBinding )* )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:602:11: k= FOR p_ForBinding ( COMMA p_ForBinding )*
            root_0 = this.adaptor.nil();

            k=this.match(this.input,FOR,XQueryParser.FOLLOW_FOR_in_p_ForClause3844); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ForBinding_in_p_ForClause3848);
            p_ForBinding111=this.p_ForBinding();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ForBinding111.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:602:45: ( COMMA p_ForBinding )*
            loop51:
            do {
                var alt51=2;
                var LA51_0 = this.input.LA(1);

                if ( (LA51_0==COMMA) ) {
                    alt51=1;
                }


                switch (alt51) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:602:46: COMMA p_ForBinding
                    COMMA112=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_ForClause3851); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA112_tree = this.adaptor.create(COMMA112);
                    this.adaptor.addChild(root_0, COMMA112_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_ForBinding_in_p_ForClause3853);
                    p_ForBinding113=this.p_ForBinding();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ForBinding113.getTree());


                    break;

                default :
                    break loop51;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_ForBinding_return: (function() {
        XQueryParser.p_ForBinding_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_ForBinding_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:606:1: p_ForBinding : s= DOLLAR v= p_VarName ( p_TypeDeclaration )? ( p_AllowingEmpty )? ( p_PositionalVar )? ( p_FTScoreVar )? k= IN p_ExprSingle[true] ;
    // $ANTLR start "p_ForBinding"
    p_ForBinding: function() {
        var retval = new XQueryParser.p_ForBinding_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var s = null;
        var k = null;
         var v = null;
         var p_TypeDeclaration114 = null;
         var p_AllowingEmpty115 = null;
         var p_PositionalVar116 = null;
         var p_FTScoreVar117 = null;
         var p_ExprSingle118 = null;

        var s_tree=null;
        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:9: (s= DOLLAR v= p_VarName ( p_TypeDeclaration )? ( p_AllowingEmpty )? ( p_PositionalVar )? ( p_FTScoreVar )? k= IN p_ExprSingle[true] )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:11: s= DOLLAR v= p_VarName ( p_TypeDeclaration )? ( p_AllowingEmpty )? ( p_PositionalVar )? ( p_FTScoreVar )? k= IN p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            s=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_ForBinding3883); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            s_tree = this.adaptor.create(s);
            this.adaptor.addChild(root_0, s_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_ForBinding3887);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(s, (v?v.stop:null)); 
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:58: ( p_TypeDeclaration )?
            var alt52=2;
            var LA52_0 = this.input.LA(1);

            if ( (LA52_0==AS) ) {
                alt52=1;
            }
            switch (alt52) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:58: p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_ForBinding3891);
                    p_TypeDeclaration114=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration114.getTree());


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:77: ( p_AllowingEmpty )?
            var alt53=2;
            var LA53_0 = this.input.LA(1);

            if ( (LA53_0==ALLOWING) ) {
                alt53=1;
            }
            switch (alt53) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:77: p_AllowingEmpty
                    this.pushFollow(XQueryParser.FOLLOW_p_AllowingEmpty_in_p_ForBinding3894);
                    p_AllowingEmpty115=this.p_AllowingEmpty();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_AllowingEmpty115.getTree());


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:94: ( p_PositionalVar )?
            var alt54=2;
            var LA54_0 = this.input.LA(1);

            if ( (LA54_0==AT) ) {
                alt54=1;
            }
            switch (alt54) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:94: p_PositionalVar
                    this.pushFollow(XQueryParser.FOLLOW_p_PositionalVar_in_p_ForBinding3897);
                    p_PositionalVar116=this.p_PositionalVar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PositionalVar116.getTree());


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:111: ( p_FTScoreVar )?
            var alt55=2;
            var LA55_0 = this.input.LA(1);

            if ( (LA55_0==SCORE) ) {
                alt55=1;
            }
            switch (alt55) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:607:111: p_FTScoreVar
                    this.pushFollow(XQueryParser.FOLLOW_p_FTScoreVar_in_p_ForBinding3900);
                    p_FTScoreVar117=this.p_FTScoreVar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_FTScoreVar117.getTree());


                    break;

            }

            k=this.match(this.input,IN,XQueryParser.FOLLOW_IN_in_p_ForBinding3905); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_ForBinding3909);
            p_ExprSingle118=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle118.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_AllowingEmpty_return: (function() {
        XQueryParser.p_AllowingEmpty_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_AllowingEmpty_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:611:1: p_AllowingEmpty : k= ALLOWING k= EMPTY ;
    // $ANTLR start "p_AllowingEmpty"
    p_AllowingEmpty: function() {
        var retval = new XQueryParser.p_AllowingEmpty_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;

        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:612:9: (k= ALLOWING k= EMPTY )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:612:11: k= ALLOWING k= EMPTY
            root_0 = this.adaptor.nil();

            k=this.match(this.input,ALLOWING,XQueryParser.FOLLOW_ALLOWING_in_p_AllowingEmpty3938); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,EMPTY,XQueryParser.FOLLOW_EMPTY_in_p_AllowingEmpty3944); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PositionalVar_return: (function() {
        XQueryParser.p_PositionalVar_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PositionalVar_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:616:1: p_PositionalVar : k= AT d= DOLLAR v= p_VarName ;
    // $ANTLR start "p_PositionalVar"
    p_PositionalVar: function() {
        var retval = new XQueryParser.p_PositionalVar_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
         var v = null;

        var k_tree=null;
        var d_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:617:9: (k= AT d= DOLLAR v= p_VarName )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:617:11: k= AT d= DOLLAR v= p_VarName
            root_0 = this.adaptor.nil();

            k=this.match(this.input,AT,XQueryParser.FOLLOW_AT_in_p_PositionalVar3974); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_PositionalVar3980); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_PositionalVar3984);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_LetClause_return: (function() {
        XQueryParser.p_LetClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_LetClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:621:1: p_LetClause : k= LET p_LetBinding ( COMMA p_LetBinding )* ;
    // $ANTLR start "p_LetClause"
    p_LetClause: function() {
        var retval = new XQueryParser.p_LetClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var COMMA120 = null;
         var p_LetBinding119 = null;
         var p_LetBinding121 = null;

        var k_tree=null;
        var COMMA120_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:622:9: (k= LET p_LetBinding ( COMMA p_LetBinding )* )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:622:11: k= LET p_LetBinding ( COMMA p_LetBinding )*
            root_0 = this.adaptor.nil();

            k=this.match(this.input,LET,XQueryParser.FOLLOW_LET_in_p_LetClause4014); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_LetBinding_in_p_LetClause4018);
            p_LetBinding119=this.p_LetBinding();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_LetBinding119.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:622:45: ( COMMA p_LetBinding )*
            loop56:
            do {
                var alt56=2;
                var LA56_0 = this.input.LA(1);

                if ( (LA56_0==COMMA) ) {
                    alt56=1;
                }


                switch (alt56) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:622:46: COMMA p_LetBinding
                    COMMA120=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_LetClause4021); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA120_tree = this.adaptor.create(COMMA120);
                    this.adaptor.addChild(root_0, COMMA120_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_LetBinding_in_p_LetClause4023);
                    p_LetBinding121=this.p_LetBinding();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_LetBinding121.getTree());


                    break;

                default :
                    break loop56;
                }
            } while (true);




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_LetBinding_return: (function() {
        XQueryParser.p_LetBinding_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_LetBinding_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:627:1: p_LetBinding : ( (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? ) | p_FTScoreVar ) BIND p_ExprSingle[true] ;
    // $ANTLR start "p_LetBinding"
    p_LetBinding: function() {
        var retval = new XQueryParser.p_LetBinding_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
        var BIND124 = null;
         var v = null;
         var p_TypeDeclaration122 = null;
         var p_FTScoreVar123 = null;
         var p_ExprSingle125 = null;

        var d_tree=null;
        var BIND124_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:628:9: ( ( (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? ) | p_FTScoreVar ) BIND p_ExprSingle[true] )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:628:11: ( (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? ) | p_FTScoreVar ) BIND p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:628:11: ( (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? ) | p_FTScoreVar )
            var alt58=2;
            var LA58_0 = this.input.LA(1);

            if ( (LA58_0==DOLLAR) ) {
                alt58=1;
            }
            else if ( (LA58_0==SCORE) ) {
                alt58=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 58, 0, this.input);

                throw nvae;
            }
            switch (alt58) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:628:13: (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:628:13: (d= DOLLAR v= p_VarName ( p_TypeDeclaration )? )
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:628:14: d= DOLLAR v= p_VarName ( p_TypeDeclaration )?
                    d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_LetBinding4057); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    d_tree = this.adaptor.create(d);
                    this.adaptor.addChild(root_0, d_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_LetBinding4061);
                    v=this.p_VarName();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
                    if ( this.state.backtracking===0 ) {
                      this.av(d, (v?v.stop:null));
                    }
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:628:59: ( p_TypeDeclaration )?
                    var alt57=2;
                    var LA57_0 = this.input.LA(1);

                    if ( (LA57_0==AS) ) {
                        alt57=1;
                    }
                    switch (alt57) {
                        case 1 :
                            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:628:59: p_TypeDeclaration
                            this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_LetBinding4065);
                            p_TypeDeclaration122=this.p_TypeDeclaration();

                            this.state._fsp--;
                            if (this.state.failed) return retval;
                            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration122.getTree());


                            break;

                    }






                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:628:81: p_FTScoreVar
                    this.pushFollow(XQueryParser.FOLLOW_p_FTScoreVar_in_p_LetBinding4071);
                    p_FTScoreVar123=this.p_FTScoreVar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_FTScoreVar123.getTree());


                    break;

            }

            BIND124=this.match(this.input,BIND,XQueryParser.FOLLOW_BIND_in_p_LetBinding4075); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            BIND124_tree = this.adaptor.create(BIND124);
            this.adaptor.addChild(root_0, BIND124_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_LetBinding4077);
            p_ExprSingle125=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle125.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WindowClause_return: (function() {
        XQueryParser.p_WindowClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WindowClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:632:1: p_WindowClause : k= FOR ( p_TumblingWindowClause | p_SlidingWindowClause ) ;
    // $ANTLR start "p_WindowClause"
    p_WindowClause: function() {
        var retval = new XQueryParser.p_WindowClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_TumblingWindowClause126 = null;
         var p_SlidingWindowClause127 = null;

        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:633:9: (k= FOR ( p_TumblingWindowClause | p_SlidingWindowClause ) )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:633:11: k= FOR ( p_TumblingWindowClause | p_SlidingWindowClause )
            root_0 = this.adaptor.nil();

            k=this.match(this.input,FOR,XQueryParser.FOLLOW_FOR_in_p_WindowClause4106); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:633:32: ( p_TumblingWindowClause | p_SlidingWindowClause )
            var alt59=2;
            var LA59_0 = this.input.LA(1);

            if ( (LA59_0==TUMBLING) ) {
                alt59=1;
            }
            else if ( (LA59_0==SLIDING) ) {
                alt59=2;
            }
            else {
                if (this.state.backtracking>0) {this.state.failed=true; return retval;}
                var nvae =
                    new org.antlr.runtime.NoViableAltException("", 59, 0, this.input);

                throw nvae;
            }
            switch (alt59) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:633:33: p_TumblingWindowClause
                    this.pushFollow(XQueryParser.FOLLOW_p_TumblingWindowClause_in_p_WindowClause4111);
                    p_TumblingWindowClause126=this.p_TumblingWindowClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TumblingWindowClause126.getTree());


                    break;
                case 2 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:633:58: p_SlidingWindowClause
                    this.pushFollow(XQueryParser.FOLLOW_p_SlidingWindowClause_in_p_WindowClause4115);
                    p_SlidingWindowClause127=this.p_SlidingWindowClause();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_SlidingWindowClause127.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_TumblingWindowClause_return: (function() {
        XQueryParser.p_TumblingWindowClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_TumblingWindowClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:637:1: p_TumblingWindowClause : k= TUMBLING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )? ;
    // $ANTLR start "p_TumblingWindowClause"
    p_TumblingWindowClause: function() {
        var retval = new XQueryParser.p_TumblingWindowClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
         var v = null;
         var p_TypeDeclaration128 = null;
         var p_ExprSingle129 = null;
         var p_WindowStartCondition130 = null;
         var p_WindowEndCondition131 = null;

        var k_tree=null;
        var d_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:638:9: (k= TUMBLING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )? )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:638:11: k= TUMBLING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )?
            root_0 = this.adaptor.nil();

            k=this.match(this.input,TUMBLING,XQueryParser.FOLLOW_TUMBLING_in_p_TumblingWindowClause4152); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,WINDOW,XQueryParser.FOLLOW_WINDOW_in_p_TumblingWindowClause4158); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_TumblingWindowClause4164); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_TumblingWindowClause4168);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
              this.av(d, (v?v.stop:null));
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:638:106: ( p_TypeDeclaration )?
            var alt60=2;
            var LA60_0 = this.input.LA(1);

            if ( (LA60_0==AS) ) {
                alt60=1;
            }
            switch (alt60) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:638:106: p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_TumblingWindowClause4172);
                    p_TypeDeclaration128=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration128.getTree());


                    break;

            }

            k=this.match(this.input,IN,XQueryParser.FOLLOW_IN_in_p_TumblingWindowClause4177); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_TumblingWindowClause4181);
            p_ExprSingle129=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle129.getTree());
            this.pushFollow(XQueryParser.FOLLOW_p_WindowStartCondition_in_p_TumblingWindowClause4184);
            p_WindowStartCondition130=this.p_WindowStartCondition();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowStartCondition130.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:638:187: ( p_WindowEndCondition )?
            var alt61=2;
            var LA61_0 = this.input.LA(1);

            if ( (LA61_0==END||LA61_0==ONLY) ) {
                alt61=1;
            }
            switch (alt61) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:638:187: p_WindowEndCondition
                    this.pushFollow(XQueryParser.FOLLOW_p_WindowEndCondition_in_p_TumblingWindowClause4186);
                    p_WindowEndCondition131=this.p_WindowEndCondition();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowEndCondition131.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_SlidingWindowClause_return: (function() {
        XQueryParser.p_SlidingWindowClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_SlidingWindowClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:642:1: p_SlidingWindowClause : k= SLIDING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )? ;
    // $ANTLR start "p_SlidingWindowClause"
    p_SlidingWindowClause: function() {
        var retval = new XQueryParser.p_SlidingWindowClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
         var v = null;
         var p_TypeDeclaration132 = null;
         var p_ExprSingle133 = null;
         var p_WindowStartCondition134 = null;
         var p_WindowEndCondition135 = null;

        var k_tree=null;
        var d_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:643:9: (k= SLIDING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )? )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:643:11: k= SLIDING k= WINDOW d= DOLLAR v= p_VarName ( p_TypeDeclaration )? k= IN p_ExprSingle[true] p_WindowStartCondition ( p_WindowEndCondition )?
            root_0 = this.adaptor.nil();

            k=this.match(this.input,SLIDING,XQueryParser.FOLLOW_SLIDING_in_p_SlidingWindowClause4215); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,WINDOW,XQueryParser.FOLLOW_WINDOW_in_p_SlidingWindowClause4221); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_SlidingWindowClause4227); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_SlidingWindowClause4231);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:643:107: ( p_TypeDeclaration )?
            var alt62=2;
            var LA62_0 = this.input.LA(1);

            if ( (LA62_0==AS) ) {
                alt62=1;
            }
            switch (alt62) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:643:107: p_TypeDeclaration
                    this.pushFollow(XQueryParser.FOLLOW_p_TypeDeclaration_in_p_SlidingWindowClause4235);
                    p_TypeDeclaration132=this.p_TypeDeclaration();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_TypeDeclaration132.getTree());


                    break;

            }

            k=this.match(this.input,IN,XQueryParser.FOLLOW_IN_in_p_SlidingWindowClause4240); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_SlidingWindowClause4244);
            p_ExprSingle133=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle133.getTree());
            this.pushFollow(XQueryParser.FOLLOW_p_WindowStartCondition_in_p_SlidingWindowClause4247);
            p_WindowStartCondition134=this.p_WindowStartCondition();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowStartCondition134.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:643:188: ( p_WindowEndCondition )?
            var alt63=2;
            var LA63_0 = this.input.LA(1);

            if ( (LA63_0==END||LA63_0==ONLY) ) {
                alt63=1;
            }
            switch (alt63) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:643:188: p_WindowEndCondition
                    this.pushFollow(XQueryParser.FOLLOW_p_WindowEndCondition_in_p_SlidingWindowClause4249);
                    p_WindowEndCondition135=this.p_WindowEndCondition();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowEndCondition135.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WindowStartCondition_return: (function() {
        XQueryParser.p_WindowStartCondition_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WindowStartCondition_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:647:1: p_WindowStartCondition : k= START p_WindowVars k= WHEN p_ExprSingle[true] ;
    // $ANTLR start "p_WindowStartCondition"
    p_WindowStartCondition: function() {
        var retval = new XQueryParser.p_WindowStartCondition_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_WindowVars136 = null;
         var p_ExprSingle137 = null;

        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:648:9: (k= START p_WindowVars k= WHEN p_ExprSingle[true] )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:648:11: k= START p_WindowVars k= WHEN p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,START,XQueryParser.FOLLOW_START_in_p_WindowStartCondition4278); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_WindowVars_in_p_WindowStartCondition4282);
            p_WindowVars136=this.p_WindowVars();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowVars136.getTree());
            k=this.match(this.input,WHEN,XQueryParser.FOLLOW_WHEN_in_p_WindowStartCondition4286); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_WindowStartCondition4290);
            p_ExprSingle137=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle137.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WindowEndCondition_return: (function() {
        XQueryParser.p_WindowEndCondition_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WindowEndCondition_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:652:1: p_WindowEndCondition : (k= ONLY )? k= END p_WindowVars k= WHEN p_ExprSingle[true] ;
    // $ANTLR start "p_WindowEndCondition"
    p_WindowEndCondition: function() {
        var retval = new XQueryParser.p_WindowEndCondition_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_WindowVars138 = null;
         var p_ExprSingle139 = null;

        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:653:9: ( (k= ONLY )? k= END p_WindowVars k= WHEN p_ExprSingle[true] )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:653:11: (k= ONLY )? k= END p_WindowVars k= WHEN p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:653:11: (k= ONLY )?
            var alt64=2;
            var LA64_0 = this.input.LA(1);

            if ( (LA64_0==ONLY) ) {
                alt64=1;
            }
            switch (alt64) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:653:12: k= ONLY
                    k=this.match(this.input,ONLY,XQueryParser.FOLLOW_ONLY_in_p_WindowEndCondition4320); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }


                    break;

            }

            k=this.match(this.input,END,XQueryParser.FOLLOW_END_in_p_WindowEndCondition4328); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_WindowVars_in_p_WindowEndCondition4332);
            p_WindowVars138=this.p_WindowVars();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_WindowVars138.getTree());
            k=this.match(this.input,WHEN,XQueryParser.FOLLOW_WHEN_in_p_WindowEndCondition4336); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_WindowEndCondition4340);
            p_ExprSingle139=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle139.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WindowVars_return: (function() {
        XQueryParser.p_WindowVars_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WindowVars_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:657:1: p_WindowVars : (d= DOLLAR v= p_CurrentItem )? ( p_PositionalVar )? (k= PREVIOUS DOLLAR p_PreviousItem )? (k= NEXT DOLLAR p_NextItem )? ;
    // $ANTLR start "p_WindowVars"
    p_WindowVars: function() {
        var retval = new XQueryParser.p_WindowVars_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var d = null;
        var k = null;
        var DOLLAR141 = null;
        var DOLLAR143 = null;
         var v = null;
         var p_PositionalVar140 = null;
         var p_PreviousItem142 = null;
         var p_NextItem144 = null;

        var d_tree=null;
        var k_tree=null;
        var DOLLAR141_tree=null;
        var DOLLAR143_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:9: ( (d= DOLLAR v= p_CurrentItem )? ( p_PositionalVar )? (k= PREVIOUS DOLLAR p_PreviousItem )? (k= NEXT DOLLAR p_NextItem )? )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:11: (d= DOLLAR v= p_CurrentItem )? ( p_PositionalVar )? (k= PREVIOUS DOLLAR p_PreviousItem )? (k= NEXT DOLLAR p_NextItem )?
            root_0 = this.adaptor.nil();

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:11: (d= DOLLAR v= p_CurrentItem )?
            var alt65=2;
            var LA65_0 = this.input.LA(1);

            if ( (LA65_0==DOLLAR) ) {
                alt65=1;
            }
            switch (alt65) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:12: d= DOLLAR v= p_CurrentItem
                    d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_WindowVars4370); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    d_tree = this.adaptor.create(d);
                    this.adaptor.addChild(root_0, d_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_CurrentItem_in_p_WindowVars4374);
                    v=this.p_CurrentItem();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
                    if ( this.state.backtracking===0 ) {
                       this.av(d, (v?v.stop:null)); 
                    }


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:65: ( p_PositionalVar )?
            var alt66=2;
            var LA66_0 = this.input.LA(1);

            if ( (LA66_0==AT) ) {
                alt66=1;
            }
            switch (alt66) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:65: p_PositionalVar
                    this.pushFollow(XQueryParser.FOLLOW_p_PositionalVar_in_p_WindowVars4380);
                    p_PositionalVar140=this.p_PositionalVar();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PositionalVar140.getTree());


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:82: (k= PREVIOUS DOLLAR p_PreviousItem )?
            var alt67=2;
            var LA67_0 = this.input.LA(1);

            if ( (LA67_0==PREVIOUS) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:83: k= PREVIOUS DOLLAR p_PreviousItem
                    k=this.match(this.input,PREVIOUS,XQueryParser.FOLLOW_PREVIOUS_in_p_WindowVars4386); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    DOLLAR141=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_WindowVars4390); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    DOLLAR141_tree = this.adaptor.create(DOLLAR141);
                    this.adaptor.addChild(root_0, DOLLAR141_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_PreviousItem_in_p_WindowVars4392);
                    p_PreviousItem142=this.p_PreviousItem();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_PreviousItem142.getTree());


                    break;

            }

            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:133: (k= NEXT DOLLAR p_NextItem )?
            var alt68=2;
            var LA68_0 = this.input.LA(1);

            if ( (LA68_0==NEXT) ) {
                alt68=1;
            }
            switch (alt68) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:658:134: k= NEXT DOLLAR p_NextItem
                    k=this.match(this.input,NEXT,XQueryParser.FOLLOW_NEXT_in_p_WindowVars4399); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    k_tree = this.adaptor.create(k);
                    this.adaptor.addChild(root_0, k_tree);
                    }
                    if ( this.state.backtracking===0 ) {
                      this.ak(k);
                    }
                    DOLLAR143=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_WindowVars4403); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    DOLLAR143_tree = this.adaptor.create(DOLLAR143);
                    this.adaptor.addChild(root_0, DOLLAR143_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_NextItem_in_p_WindowVars4405);
                    p_NextItem144=this.p_NextItem();

                    this.state._fsp--;
                    if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_NextItem144.getTree());


                    break;

            }




            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CurrentItem_return: (function() {
        XQueryParser.p_CurrentItem_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CurrentItem_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:662:1: p_CurrentItem : p_EQName ;
    // $ANTLR start "p_CurrentItem"
    p_CurrentItem: function() {
        var retval = new XQueryParser.p_CurrentItem_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_EQName145 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:663:9: ( p_EQName )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:663:11: p_EQName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_EQName_in_p_CurrentItem4433);
            p_EQName145=this.p_EQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_EQName145.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_PreviousItem_return: (function() {
        XQueryParser.p_PreviousItem_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_PreviousItem_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:667:1: p_PreviousItem : p_EQName ;
    // $ANTLR start "p_PreviousItem"
    p_PreviousItem: function() {
        var retval = new XQueryParser.p_PreviousItem_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_EQName146 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:668:9: ( p_EQName )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:668:11: p_EQName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_EQName_in_p_PreviousItem4459);
            p_EQName146=this.p_EQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_EQName146.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_NextItem_return: (function() {
        XQueryParser.p_NextItem_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_NextItem_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:672:1: p_NextItem : p_EQName ;
    // $ANTLR start "p_NextItem"
    p_NextItem: function() {
        var retval = new XQueryParser.p_NextItem_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

         var p_EQName147 = null;


        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:673:9: ( p_EQName )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:673:11: p_EQName
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_EQName_in_p_NextItem4485);
            p_EQName147=this.p_EQName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_EQName147.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_CountClause_return: (function() {
        XQueryParser.p_CountClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_CountClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:677:1: p_CountClause : k= COUNT d= DOLLAR v= p_VarName ;
    // $ANTLR start "p_CountClause"
    p_CountClause: function() {
        var retval = new XQueryParser.p_CountClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
        var d = null;
         var v = null;

        var k_tree=null;
        var d_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:678:9: (k= COUNT d= DOLLAR v= p_VarName )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:678:11: k= COUNT d= DOLLAR v= p_VarName
            root_0 = this.adaptor.nil();

            k=this.match(this.input,COUNT,XQueryParser.FOLLOW_COUNT_in_p_CountClause4513); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            d=this.match(this.input,DOLLAR,XQueryParser.FOLLOW_DOLLAR_in_p_CountClause4519); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            d_tree = this.adaptor.create(d);
            this.adaptor.addChild(root_0, d_tree);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_VarName_in_p_CountClause4523);
            v=this.p_VarName();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, v.getTree());
            if ( this.state.backtracking===0 ) {
               this.av(d, (v?v.stop:null)); 
            }



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_WhereClause_return: (function() {
        XQueryParser.p_WhereClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_WhereClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:682:1: p_WhereClause : k= WHERE p_ExprSingle[true] ;
    // $ANTLR start "p_WhereClause"
    p_WhereClause: function() {
        var retval = new XQueryParser.p_WhereClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_ExprSingle148 = null;

        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:683:9: (k= WHERE p_ExprSingle[true] )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:683:11: k= WHERE p_ExprSingle[true]
            root_0 = this.adaptor.nil();

            k=this.match(this.input,WHERE,XQueryParser.FOLLOW_WHERE_in_p_WhereClause4561); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_ExprSingle_in_p_WhereClause4565);
            p_ExprSingle148=this.p_ExprSingle(true);

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_ExprSingle148.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_GroupByClause_return: (function() {
        XQueryParser.p_GroupByClause_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_GroupByClause_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:687:1: p_GroupByClause : k= GROUP k= BY p_GroupingSpecList ;
    // $ANTLR start "p_GroupByClause"
    p_GroupByClause: function() {
        var retval = new XQueryParser.p_GroupByClause_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var k = null;
         var p_GroupingSpecList149 = null;

        var k_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:688:9: (k= GROUP k= BY p_GroupingSpecList )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:688:11: k= GROUP k= BY p_GroupingSpecList
            root_0 = this.adaptor.nil();

            k=this.match(this.input,GROUP,XQueryParser.FOLLOW_GROUP_in_p_GroupByClause4594); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            k=this.match(this.input,BY,XQueryParser.FOLLOW_BY_in_p_GroupByClause4600); if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) {
            k_tree = this.adaptor.create(k);
            this.adaptor.addChild(root_0, k_tree);
            }
            if ( this.state.backtracking===0 ) {
              this.ak(k);
            }
            this.pushFollow(XQueryParser.FOLLOW_p_GroupingSpecList_in_p_GroupByClause4604);
            p_GroupingSpecList149=this.p_GroupingSpecList();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_GroupingSpecList149.getTree());



            retval.stop = this.input.LT(-1);

            if ( this.state.backtracking===0 ) {

            retval.tree = this.adaptor.rulePostProcessing(root_0);
            this.adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (re) {
            if (re instanceof org.antlr.runtime.RecognitionException) {
                this.reportError(re);
                this.recover(this.input,re);
                retval.tree = this.adaptor.errorNode(this.input, retval.start, this.input.LT(-1), re);
            } else {
                throw re;
            }
        }
        finally {
        }
        return retval;
    },

    // inline static return class
    p_GroupingSpecList_return: (function() {
        XQueryParser.p_GroupingSpecList_return = function(){};
        org.antlr.lang.extend(XQueryParser.p_GroupingSpecList_return,
                          org.antlr.runtime.ParserRuleReturnScope,
        {
            getTree: function() { return this.tree; }
        });
        return;
    })(),

    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:692:1: p_GroupingSpecList : p_GroupingSpec ( COMMA p_GroupingSpec )* ;
    // $ANTLR start "p_GroupingSpecList"
    p_GroupingSpecList: function() {
        var retval = new XQueryParser.p_GroupingSpecList_return();
        retval.start = this.input.LT(1);

        var root_0 = null;

        var COMMA151 = null;
         var p_GroupingSpec150 = null;
         var p_GroupingSpec152 = null;

        var COMMA151_tree=null;

        try {
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:693:9: ( p_GroupingSpec ( COMMA p_GroupingSpec )* )
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:693:11: p_GroupingSpec ( COMMA p_GroupingSpec )*
            root_0 = this.adaptor.nil();

            this.pushFollow(XQueryParser.FOLLOW_p_GroupingSpec_in_p_GroupingSpecList4630);
            p_GroupingSpec150=this.p_GroupingSpec();

            this.state._fsp--;
            if (this.state.failed) return retval;
            if ( this.state.backtracking===0 ) this.adaptor.addChild(root_0, p_GroupingSpec150.getTree());
            // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:693:26: ( COMMA p_GroupingSpec )*
            loop69:
            do {
                var alt69=2;
                var LA69_0 = this.input.LA(1);

                if ( (LA69_0==COMMA) ) {
                    alt69=1;
                }


                switch (alt69) {
                case 1 :
                    // /Users/wcandillon/28msec/xquery.js/xquery/XQueryParser.g:693:27: COMMA p_GroupingSpec
                    COMMA151=this.match(this.input,COMMA,XQueryParser.FOLLOW_COMMA_in_p_GroupingSpecList4633); if (this.state.failed) return retval;
                    if ( this.state.backtracking===0 ) {
                    COMMA151_tree = this.adaptor.create(COMMA151);
                    this.adaptor.addChild(root_0, COMMA151_tree);
                    }
                    this.pushFollow(XQueryParser.FOLLOW_p_GroupingSpec_in_p_GroupingSpecList4635);
                    p_GroupingSpec152=this.p_GroupingSpec();

                    this.state._