require 'spec_helper'

describe 'CLI', 'appraisal generate' do
  it 'generates the gemfiles' do
    build_gemfile <<-Gemfile
      source "https://rubygems.org"

      gem "appraisal", :path => "#{PROJECT_ROOT}"
    Gemfile

    build_appraisal_file <<-Appraisal
      appraise '1.0.0' do
        gem 'dummy', '1.0.0'
      end

      appraise '1.1.0' do
        gem 'dummy', '1.1.0'
      end
    Appraisal

    run 'appraisal generate'

    expect(file 'gemfiles/1.0.0.gemfile').to be_exists
    expect(file 'gemfiles/1.1.0.gemfile').to be_exists
    expect(content_of 'gemfiles/1.0.0.gemfile').to eq <<-gemfile.strip_heredoc
      # This file was generated by Appraisal

      source "https://rubygems.org"

      gem "appraisal", :path => "#{PROJECT_ROOT}"
      gem "dummy", "1.0.0"
    gemfile
  end
end
