# November 17, 2022

## Attendees
- Jase Williams (JWS)
- Richard Gibson (RGN)
- Philip Chimento (PFC)
- Philipp Dunkel (PDL)

## Agenda

### TC39 Temporal update ([draft slides](http://ptomato.name/talks/tc39-2022-11/))
- Is slide 11 a correct representation of the champions' opinion?
- Is slide 12 a correct representation of what we think the plan should be?
- JWS: I didn't notice the issue numbers in the corners until you mentioned it.
- **Page 12** (issue [#2195](https://github.com/tc39/proposal-temporal/issues/2195)): this is a complicated issue to communicate but I've tried to do it in one slide. I'd like to check if the line about the status quo is actually true?
- PDL: I think we have a consensus that making a change here isn't really sensible because no other solution is better than any other. To be honest my impression was it's less that we feel this is the "least worst" than we just simply don't think this is actually a real issue.
- PFC: Maybe the solution is we don't change anything but it could be a blocker that we have to convince implementors that there's not a better solution to this.
- PDL: There is no good solution and no single solution is any better than any other. Does that mean it will hold up to the statement? Any other solution we present will be just as much of a blocker.
- PFC: I can rephrase this based on our discussion here.
- PDL: If you feel that calling it the least worst solution will help us unblock this, help us get across our opinion, it then you can keep it in there and case closed.
- PFC: I do think that. I can remove the sentence about it being a blocker.
- 2/2: Should I just remove this slide?
- PDL: I would change the plan to invite stakeholders not to present but to provide a clear alternative, "we will listen to any alternative you present, but it has to be demonstrably clearly superior" but i don't think that's a possibility. If we make that the cut off point then the fallback is the status quo.
- **Page 14:** Before we go to stage 4 we should figure out where user code is called and remove unnecessary ones. 
- **Page 16:** This references the discussion about proposal champions giving a signal when a proposal is ready to ship. If we did make a change to duration arithmetic that would be quite substantial as well but everything else is quite minor and I think it would be no problem for browsers to ship Temporal (without a flag) and still solve those things.
- JWS: What was the other substantial issue?
- PFC: Strings for built in calendars, [#1808](https://github.com/tc39/proposal-temporal/issues/1808).
- PDL: I think it's fine. The signal that's expected is that there are no more normative issues. So that we have the feedback, we know where things are, we know 2 implementations are through giving their feedback and that's put back in. The signal isn't "shippability" its we're done with feedback and the future for normative is very small.
- PFC: That's how I see stage 4; but DE had an item on the agenda, signal to implementers that they can ship something unflagged.
The signal we need to send is "there may still be bugfixes but there are unlikely to be normative changes that will break the web, so you can ship it without a flag and it won't break the web anymore"
- **Page 17:** Test262 I think is ready for completion, we can't just dump the whole proposal into a pull request so we should probably discuss that with the editors, maybe come up with a plan to stage that in sections.
- JWS: Has everything been done on a branch?
- PFC: Everything's been done in the proposal repo, a couple of months ago I brought in some changes to ECMA-262 that staged some operations from Temporal. That went OK, but it took some time to get sign off from the editors. So I think we can stage that in chunks. 
- RGN: There are 262 contents that Temporal wants to expand in various ways and some of them have already been landed.
- Graphic shown: https://bug-223166-attachments.webkit.org/attachment.cgi?id=431399 
- JWS: Would we need to make a commitment to stage 4 in plenary if the topic is brought up?
- PFC: I wouldn't want to make a commitment to that. Maybe in January we get a bunch of feedback.
- PDL: I think we shouldn't make a statement about going for stage 4 in March, all it does is put pressure in the wrong spots. If we ask now it's literally asking for it now to be done by March. 

### TC39 agenda item about the scope of what 402 can add to 262
- PFC: Could someone take the lead of making slides?
- PDL: I don't understand what we're discussing yet.
- PFC: The deal is with issue [#2169](https://github.com/tc39/proposal-temporal/issues/2169), there's a disagreement about what the scope is for 402 to add features to 262.
- RGN: The question is whether or not it's acceptable for 402 to specify the addition of properties on objects that are generated by algorithms. Can 402 extend properties to the prototype added by 262?
- PDL: Why is that being questioned? Anybody can add anything to anything.
- RGN: It's not that simple. User code can overwrite any builtin of 262, but 402 is not allowed to do that. It's a gray area. 402 can't delete all properties from `String.prototype`, for example. Can 402 extend `String.prototype`, there is not currently precedent for it, but I'm expecting the discussion to be in favour.
- We'll put the item on the agenda, then early next week RGN or PFC will make the slides.

### Implementations progress
- PFC: Shane has said V8 is done except for the details of non ISO calendars.
- PFC: JSC I'm following the bug tracker, but I haven't been working on it myself, and I haven't seen anyone else making progress recently.
- PDL: What was the last status?
- PFC: Instant and Duration were done and there were stubs for TimeZone and Calendar.
- PFC: The Firefox patches are complete but I don't think they've been reviewed and they haven't been updated in a while. There's probably still holes in them.
- PDL: Once we get over the big discussion blocker and we send the next signal of "hey this is ready to go" we can create some renewed enthusiasm then we're not that far away from having Firefox and WebKit join in a somewhat complete implementation.

### `smallestUnit` in `round()` method ([#1876](https://github.com/tc39/proposal-temporal/issues/1876))
- PDL: Let's not close this for now.

### Optimize built-in calendars ([#1808](https://github.com/tc39/proposal-temporal/issues/1808))
- Remaining discussion: `getCalendar()`/`getTimeZone()` or no?
- PFC: If I'm the only one with concerns about this, I'm fine to drop it.
- PDL: The only way you should get near a timezone object or a calendar object is using `from()`. It's good that it's not discoverable.
- PDL: I raised the challenge which was never taken, of "I require some sort of evidence or proof that this is actually an ergonomic issue at all" beyond "we think it is".
