from talon import Context, actions, ui, Module, app

mod = Module()
mod.tag("messaging", desc="Tag for generic multi-channel messaging apps")


@mod.action_class
class messaging_actions:
    # Navigation and UI components

    def messaging_workspace_previous():
        """Move to previous workspace/server"""

    def messaging_workspace_next():
        """Move to next qorkspace/server"""

    def messaging_open_channel_picker():
        """Open channel picker"""

    def messaging_channel_previous():
        """Move to previous channel"""

    def messaging_channel_next():
        """Move to next channel"""

    def messaging_unread_previous():
        """Move to previous unread channel"""

    def messaging_unread_next():
        """Moved to next unread channel"""

    def messaging_open_search():
        """Open message search"""

    def messaging_mark_workspace_read():
        """Mark this workspace/server as read"""

    def messaging_mark_channel_read():
        """Mark this channel as read."""

    def messaging_upload_file():
        """Upload a file as a message"""
