export { enableFeatures, build } from "@/pipeline/build";
export { precompile } from "@/pipeline/precompile";
export {
    TactError,
    TactCompilationError,
    TactInternalCompilerError,
    TactConstEvalError,
    TactErrorCollection,
} from "@/error/errors";
export * from "@/config/parseConfig";

export { PackageFileFormat } from "@/packaging/fileFormat";

export { VirtualFileSystem } from "@/vfs/VirtualFileSystem";
export { createVirtualFileSystem } from "@/vfs/createVirtualFileSystem";

export * from "@/browser";
export * from "@/context/logger";
export * from "@/error/errors";
export { ItemOrigin } from "@/imports/source";

export * from "@/verify";

export * from "@/ast/ast-printer";
export * from "@/ast/ast";
export * from "@/context/context";
export * from "@/context/store";
export * from "@/grammar";
export * from "@/optimizer/constEval";
export * from "@/pipeline/build";
export * from "@/pipeline/precompile";
export * from "@/types/resolveDescriptors";
export * from "@/types/types";

export { files as stdLibFiles } from "@/stdlib/stdlib";
export * from "@/ast/ast-helpers";
export * from "@/ast/util";
export * from "@/imports/source";
export * from "@/imports/path";
export * from "@/grammar";
export * from "@/grammar/src-info";
export * from "@/optimizer/interpreter";
