// Generated by ts-to-zod
import { z } from "zod";
import type * as C from "@/config/config";

export const safetyOptionsSchema: z.ZodType<C.SafetyOptions> = z.object({
    nullChecks: z.boolean().optional(),
});

export const optimizationOptionsSchema: z.ZodType<C.OptimizationOptions> =
    z.object({
        alwaysSaveContractData: z.boolean().optional(),
        internalExternalReceiversOutsideMethodsMap: z.boolean().optional(),
    });

/**
 * Per-project configuration options
 *
 * Read more: https://docs.tact-lang.org/book/config#projects
 */
export const optionsSchema: z.ZodType<C.Options> = z.object({
    /**
     * If set to true, enables debug output of a contract and allows usage of `dump()` function,
     * which is useful for debugging purposes.
     *
     * Read more: https://docs.tact-lang.org/book/debug
     */
    debug: z.boolean().optional(),
    /**
     * If set to true, enables support of external message receivers.
     *
     * Read more: https://docs.tact-lang.org/book/external
     */
    external: z.boolean().optional(),
    /**
     * If set to true, enables generation of a getter with IPFS links describing the contract's ABI.
     *
     * Read more: https://docs.tact-lang.org/ref/evolution/otp-003
     */
    ipfsAbiGetter: z.boolean().optional(),
    /**
     * If set to true, enables generation of a getter with a list of interfaces provided by the contract.
     *
     * Read more: https://docs.tact-lang.org/book/contracts#interfaces
     */
    interfacesGetter: z.boolean().optional(),
    /**
     * Experimental options that might be removed in the future. Use with caution!
     */
    experimental: z
        .object({
            /**
             * If set to true, enables inlining of all functions in contracts.
             * This can reduce gas usage at the cost of bigger contracts.
             */
            inline: z.boolean().optional(),
        })
        .optional(),
    /**
     * Safety options for the contract.
     */
    safety: safetyOptionsSchema.optional(),
    /**
     * Optimization options for the contract.
     */
    optimizations: optimizationOptionsSchema.optional(),
    /**
     * If set to true, enables generation of `lazy_deployment_completed()` getter.
     * Does nothing if contract parameters are declared.
     */
    enableLazyDeploymentCompletedGetter: z.boolean().optional(),
});

export const modeSchema: z.ZodType<C.Mode> = z.union([
    z.literal("fullWithDecompilation"),
    z.literal("full"),
    z.literal("funcOnly"),
    z.literal("checkOnly"),
]);

/**
 * Per-project configuration options
 *
 * Read more: https://docs.tact-lang.org/book/config#projects
 */
export const projectSchema: z.ZodType<C.Project> = z.object({
    /**
     * Name of the project. All generated files are prefixed with it.
     *
     * Read more: https://docs.tact-lang.org/book/config#projects-name
     */
    name: z.string(),
    /**
     * Path to the project's Tact file. You can only specify one Tact file per project.
     *
     * Read more: https://docs.tact-lang.org/book/config#projects-path
     */
    path: z.string(),
    /**
     * Path to the directory where all generated files will be placed.
     *
     * Read more: https://docs.tact-lang.org/book/config#projects-output
     */
    output: z.string(),
    /**
     * Compilation options for the project.
     *
     * Read more: https://docs.tact-lang.org/book/config#projects-options
     */
    options: optionsSchema.optional(),
    /**
     * Compilation mode of the project.
     *
     * Read more: https://docs.tact-lang.org/book/config#projects-mode
     */
    mode: modeSchema.optional(),
    /**
     * Set verbosity level (higher = more details), default: 1
     */
    verbose: z.number().optional(),
});

/**
 * Compiler configuration schema
 *
 * Read more: https://docs.tact-lang.org/book/config
 */
export const configSchema: z.ZodType<C.Config> = z.object({
    /**
     * A property for specifying a path or URL to the JSON schema of tact.config.json
     *
     * Read more: https://docs.tact-lang.org/book/config#schema
     */
    $schema: z.string().optional(),
    /**
     * List of Tact projects with respective compilation options. Each .tact file represents its own Tact project.
     *
     * Read more: https://docs.tact-lang.org/book/config#projects
     */
    projects: z.array(projectSchema),
});
