import * as i from "@/asm/runtime/index";
import { instructions as jettonMinterInstructions } from "@/asm/runtime/test/testdata/jetton_minter_discoverable_JettonMinter.tasm";
import { instructions as escrowInstructions } from "@/asm/runtime/test/testdata/escrow_Escrow.tasm";
import { instructions as simpleCounterInstructions } from "@/asm/runtime/test/testdata/test_SimpleCounter.tasm";
import { instructions as someContractInstructions } from "@/asm/runtime/test/testdata/SomeContract.tasm";
import { instructions as someContract2Instructions } from "@/asm/runtime/test/testdata/SomeContract2.tasm";
import { instructions as pushIntLong130Instructions } from "@/asm/runtime/test/testdata/PUSHINT_LONG_130.tasm";
import { instructions as withExoticInstructions } from "@/asm/runtime/test/testdata/WithExotic.tasm";
import * as path from "node:path";
import * as fs from "node:fs";
import { Cell } from "@ton/core";
import { DefaultExoticCell, hex } from "@/asm/runtime/util";

const readBoc = (filename: string): Cell | undefined => {
    const filePath = path.join(__dirname, "testdata", filename);
    return Cell.fromBoc(fs.readFileSync(filePath))[0];
};

const readHex = (filename: string): Cell => {
    const filePath = path.join(__dirname, "testdata", filename);
    return Cell.fromHex(fs.readFileSync(filePath, "utf8").trim());
};

const test =
    (instructions: i.Instr[], expectedBoc: Cell | undefined): (() => void) =>
    () => {
        if (expectedBoc === undefined) {
            throw new Error("expectedBoc is undefined");
        }
        const compiled = i.compileCell(instructions);
        expect(compiled.toString()).toEqual(expectedBoc.toString());
    };

describe("tests", () => {
    it(
        "JettonMinter",
        test(
            jettonMinterInstructions,
            readBoc("jetton_minter_discoverable_JettonMinter.boc"),
        ),
    );

    it(
        "SimpleCounter",
        test(simpleCounterInstructions, readBoc("test_SimpleCounter.boc")),
    );
    it("Escrow", test(escrowInstructions, readBoc("escrow_Escrow.boc")));
    it(
        "SomeContract",
        test(someContractInstructions, readHex("SomeContract.hex")),
    );
    it(
        "SomeContract2",
        test(someContract2Instructions, readHex("SomeContract2.hex")),
    );
    it(
        "PUSHINT_LONG 130",
        test(pushIntLong130Instructions, readHex("PUSHINT_LONG_130.hex")),
    );

    it(
        "exotic",
        test(
            [
                i.PSEUDO_EXOTIC(
                    DefaultExoticCell(
                        hex(
                            "025E3B0EBFC424D34F7D55037A361D70D56902A9F2568603D0717CF4856240DA53",
                        ).asCell(),
                    ),
                ),
            ],
            Cell.fromHex(
                "b5ee9c72010101010023000842025e3b0ebfc424d34f7d55037a361d70d56902a9f2568603d0717cf4856240da53",
            ),
        ),
    );

    it(
        "exotic 2",
        test(
            withExoticInstructions,
            Cell.fromHex(
                "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",
            ),
        ),
    );
});
