// THIS IS AN AUTOGENERATED FILE. TO GENERATE IT AGAIN, EXECUTE yarn gen:make-funs

import type { FactoryAst } from "@/ast/ast-helpers";
import type * as Ast from "@/ast/ast";
import type { SrcInfo } from "@/grammar";
import type * as TonCore from "@ton/core";
import { getSrcInfo } from "@/grammar/src-info";

export const getMakeAst = (astF: FactoryAst) => {
    const emptySrcInfo = getSrcInfo(" ", 0, 0, null, "user");

    function makePrimitiveTypeDecl(
        p_name: Ast.Id,
        p_loc: SrcInfo,
    ): Ast.PrimitiveTypeDecl {
        return astF.createNode({
            kind: "primitive_type_decl",
            name: p_name,
            loc: p_loc,
        }) as Ast.PrimitiveTypeDecl;
    }

    function makeDummyPrimitiveTypeDecl(p_name: Ast.Id): Ast.PrimitiveTypeDecl {
        return astF.createNode({
            kind: "primitive_type_decl",
            name: p_name,
            loc: emptySrcInfo,
        }) as Ast.PrimitiveTypeDecl;
    }

    function makeFunctionDef(
        p_attributes: readonly Ast.FunctionAttribute[],
        p_name: Ast.Id,
        p_return: Ast.Type | undefined,
        p_params: readonly Ast.TypedParameter[],
        p_statements: readonly Ast.Statement[],
        p_loc: SrcInfo,
    ): Ast.FunctionDef {
        return astF.createNode({
            kind: "function_def",
            attributes: p_attributes,
            name: p_name,
            return: p_return,
            params: p_params,
            statements: p_statements,
            loc: p_loc,
        }) as Ast.FunctionDef;
    }

    function makeDummyFunctionDef(
        p_attributes: readonly Ast.FunctionAttribute[],
        p_name: Ast.Id,
        p_return: Ast.Type | undefined,
        p_params: readonly Ast.TypedParameter[],
        p_statements: readonly Ast.Statement[],
    ): Ast.FunctionDef {
        return astF.createNode({
            kind: "function_def",
            attributes: p_attributes,
            name: p_name,
            return: p_return,
            params: p_params,
            statements: p_statements,
            loc: emptySrcInfo,
        }) as Ast.FunctionDef;
    }

    function makeAsmFunctionDef(
        p_shuffle: Ast.AsmShuffle,
        p_attributes: readonly Ast.FunctionAttribute[],
        p_name: Ast.Id,
        p_return: Ast.Type | undefined,
        p_params: readonly Ast.TypedParameter[],
        p_instructions: readonly Ast.AsmInstruction[],
        p_loc: SrcInfo,
    ): Ast.AsmFunctionDef {
        return astF.createNode({
            kind: "asm_function_def",
            shuffle: p_shuffle,
            attributes: p_attributes,
            name: p_name,
            return: p_return,
            params: p_params,
            instructions: p_instructions,
            loc: p_loc,
        }) as Ast.AsmFunctionDef;
    }

    function makeDummyAsmFunctionDef(
        p_shuffle: Ast.AsmShuffle,
        p_attributes: readonly Ast.FunctionAttribute[],
        p_name: Ast.Id,
        p_return: Ast.Type | undefined,
        p_params: readonly Ast.TypedParameter[],
        p_instructions: readonly Ast.AsmInstruction[],
    ): Ast.AsmFunctionDef {
        return astF.createNode({
            kind: "asm_function_def",
            shuffle: p_shuffle,
            attributes: p_attributes,
            name: p_name,
            return: p_return,
            params: p_params,
            instructions: p_instructions,
            loc: emptySrcInfo,
        }) as Ast.AsmFunctionDef;
    }

    function makeNativeFunctionDecl(
        p_attributes: readonly Ast.FunctionAttribute[],
        p_name: Ast.Id,
        p_nativeName: Ast.FuncId,
        p_params: readonly Ast.TypedParameter[],
        p_return: Ast.Type | undefined,
        p_loc: SrcInfo,
    ): Ast.NativeFunctionDecl {
        return astF.createNode({
            kind: "native_function_decl",
            attributes: p_attributes,
            name: p_name,
            nativeName: p_nativeName,
            params: p_params,
            return: p_return,
            loc: p_loc,
        }) as Ast.NativeFunctionDecl;
    }

    function makeDummyNativeFunctionDecl(
        p_attributes: readonly Ast.FunctionAttribute[],
        p_name: Ast.Id,
        p_nativeName: Ast.FuncId,
        p_params: readonly Ast.TypedParameter[],
        p_return: Ast.Type | undefined,
    ): Ast.NativeFunctionDecl {
        return astF.createNode({
            kind: "native_function_decl",
            attributes: p_attributes,
            name: p_name,
            nativeName: p_nativeName,
            params: p_params,
            return: p_return,
            loc: emptySrcInfo,
        }) as Ast.NativeFunctionDecl;
    }

    function makeConstantDef(
        p_attributes: readonly Ast.ConstantAttribute[],
        p_name: Ast.Id,
        p_type: Ast.Type,
        p_initializer: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.ConstantDef {
        return astF.createNode({
            kind: "constant_def",
            attributes: p_attributes,
            name: p_name,
            type: p_type,
            initializer: p_initializer,
            loc: p_loc,
        }) as Ast.ConstantDef;
    }

    function makeDummyConstantDef(
        p_attributes: readonly Ast.ConstantAttribute[],
        p_name: Ast.Id,
        p_type: Ast.Type,
        p_initializer: Ast.Expression,
    ): Ast.ConstantDef {
        return astF.createNode({
            kind: "constant_def",
            attributes: p_attributes,
            name: p_name,
            type: p_type,
            initializer: p_initializer,
            loc: emptySrcInfo,
        }) as Ast.ConstantDef;
    }

    function makeStructDecl(
        p_name: Ast.Id,
        p_fields: readonly Ast.FieldDecl[],
        p_loc: SrcInfo,
    ): Ast.StructDecl {
        return astF.createNode({
            kind: "struct_decl",
            name: p_name,
            fields: p_fields,
            loc: p_loc,
        }) as Ast.StructDecl;
    }

    function makeDummyStructDecl(
        p_name: Ast.Id,
        p_fields: readonly Ast.FieldDecl[],
    ): Ast.StructDecl {
        return astF.createNode({
            kind: "struct_decl",
            name: p_name,
            fields: p_fields,
            loc: emptySrcInfo,
        }) as Ast.StructDecl;
    }

    function makeMessageDecl(
        p_name: Ast.Id,
        p_opcode: Ast.Expression | undefined,
        p_fields: readonly Ast.FieldDecl[],
        p_loc: SrcInfo,
    ): Ast.MessageDecl {
        return astF.createNode({
            kind: "message_decl",
            name: p_name,
            opcode: p_opcode,
            fields: p_fields,
            loc: p_loc,
        }) as Ast.MessageDecl;
    }

    function makeDummyMessageDecl(
        p_name: Ast.Id,
        p_opcode: Ast.Expression | undefined,
        p_fields: readonly Ast.FieldDecl[],
    ): Ast.MessageDecl {
        return astF.createNode({
            kind: "message_decl",
            name: p_name,
            opcode: p_opcode,
            fields: p_fields,
            loc: emptySrcInfo,
        }) as Ast.MessageDecl;
    }

    function makeContract(
        p_name: Ast.Id,
        p_traits: readonly Ast.Id[],
        p_attributes: readonly Ast.ContractAttribute[],
        p_params: undefined | readonly Ast.FieldDecl[],
        p_declarations: readonly Ast.ContractDeclaration[],
        p_loc: SrcInfo,
    ): Ast.Contract {
        return astF.createNode({
            kind: "contract",
            name: p_name,
            traits: p_traits,
            attributes: p_attributes,
            params: p_params,
            declarations: p_declarations,
            loc: p_loc,
        }) as Ast.Contract;
    }

    function makeDummyContract(
        p_name: Ast.Id,
        p_traits: readonly Ast.Id[],
        p_attributes: readonly Ast.ContractAttribute[],
        p_params: undefined | readonly Ast.FieldDecl[],
        p_declarations: readonly Ast.ContractDeclaration[],
    ): Ast.Contract {
        return astF.createNode({
            kind: "contract",
            name: p_name,
            traits: p_traits,
            attributes: p_attributes,
            params: p_params,
            declarations: p_declarations,
            loc: emptySrcInfo,
        }) as Ast.Contract;
    }

    function makeTrait(
        p_name: Ast.Id,
        p_traits: readonly Ast.Id[],
        p_attributes: readonly Ast.ContractAttribute[],
        p_declarations: readonly Ast.TraitDeclaration[],
        p_loc: SrcInfo,
    ): Ast.Trait {
        return astF.createNode({
            kind: "trait",
            name: p_name,
            traits: p_traits,
            attributes: p_attributes,
            declarations: p_declarations,
            loc: p_loc,
        }) as Ast.Trait;
    }

    function makeDummyTrait(
        p_name: Ast.Id,
        p_traits: readonly Ast.Id[],
        p_attributes: readonly Ast.ContractAttribute[],
        p_declarations: readonly Ast.TraitDeclaration[],
    ): Ast.Trait {
        return astF.createNode({
            kind: "trait",
            name: p_name,
            traits: p_traits,
            attributes: p_attributes,
            declarations: p_declarations,
            loc: emptySrcInfo,
        }) as Ast.Trait;
    }

    function makeFieldDecl(
        p_name: Ast.Id,
        p_type: Ast.Type,
        p_initializer: Ast.Expression | undefined,
        p_as: Ast.Id | undefined,
        p_loc: SrcInfo,
    ): Ast.FieldDecl {
        return astF.createNode({
            kind: "field_decl",
            name: p_name,
            type: p_type,
            initializer: p_initializer,
            as: p_as,
            loc: p_loc,
        }) as Ast.FieldDecl;
    }

    function makeDummyFieldDecl(
        p_name: Ast.Id,
        p_type: Ast.Type,
        p_initializer: Ast.Expression | undefined,
        p_as: Ast.Id | undefined,
    ): Ast.FieldDecl {
        return astF.createNode({
            kind: "field_decl",
            name: p_name,
            type: p_type,
            initializer: p_initializer,
            as: p_as,
            loc: emptySrcInfo,
        }) as Ast.FieldDecl;
    }

    function makeContractInit(
        p_params: readonly Ast.TypedParameter[],
        p_statements: readonly Ast.Statement[],
        p_loc: SrcInfo,
    ): Ast.ContractInit {
        return astF.createNode({
            kind: "contract_init",
            params: p_params,
            statements: p_statements,
            loc: p_loc,
        }) as Ast.ContractInit;
    }

    function makeDummyContractInit(
        p_params: readonly Ast.TypedParameter[],
        p_statements: readonly Ast.Statement[],
    ): Ast.ContractInit {
        return astF.createNode({
            kind: "contract_init",
            params: p_params,
            statements: p_statements,
            loc: emptySrcInfo,
        }) as Ast.ContractInit;
    }

    function makeReceiver(
        p_selector: Ast.ReceiverKind,
        p_statements: readonly Ast.Statement[],
        p_loc: SrcInfo,
    ): Ast.Receiver {
        return astF.createNode({
            kind: "receiver",
            selector: p_selector,
            statements: p_statements,
            loc: p_loc,
        }) as Ast.Receiver;
    }

    function makeDummyReceiver(
        p_selector: Ast.ReceiverKind,
        p_statements: readonly Ast.Statement[],
    ): Ast.Receiver {
        return astF.createNode({
            kind: "receiver",
            selector: p_selector,
            statements: p_statements,
            loc: emptySrcInfo,
        }) as Ast.Receiver;
    }

    function makeFunctionDecl(
        p_attributes: readonly Ast.FunctionAttribute[],
        p_name: Ast.Id,
        p_return: Ast.Type | undefined,
        p_params: readonly Ast.TypedParameter[],
        p_loc: SrcInfo,
    ): Ast.FunctionDecl {
        return astF.createNode({
            kind: "function_decl",
            attributes: p_attributes,
            name: p_name,
            return: p_return,
            params: p_params,
            loc: p_loc,
        }) as Ast.FunctionDecl;
    }

    function makeDummyFunctionDecl(
        p_attributes: readonly Ast.FunctionAttribute[],
        p_name: Ast.Id,
        p_return: Ast.Type | undefined,
        p_params: readonly Ast.TypedParameter[],
    ): Ast.FunctionDecl {
        return astF.createNode({
            kind: "function_decl",
            attributes: p_attributes,
            name: p_name,
            return: p_return,
            params: p_params,
            loc: emptySrcInfo,
        }) as Ast.FunctionDecl;
    }

    function makeConstantDecl(
        p_attributes: readonly Ast.ConstantAttribute[],
        p_name: Ast.Id,
        p_type: Ast.Type,
        p_loc: SrcInfo,
    ): Ast.ConstantDecl {
        return astF.createNode({
            kind: "constant_decl",
            attributes: p_attributes,
            name: p_name,
            type: p_type,
            loc: p_loc,
        }) as Ast.ConstantDecl;
    }

    function makeDummyConstantDecl(
        p_attributes: readonly Ast.ConstantAttribute[],
        p_name: Ast.Id,
        p_type: Ast.Type,
    ): Ast.ConstantDecl {
        return astF.createNode({
            kind: "constant_decl",
            attributes: p_attributes,
            name: p_name,
            type: p_type,
            loc: emptySrcInfo,
        }) as Ast.ConstantDecl;
    }

    function makeStatementLet(
        p_name: Ast.OptionalId,
        p_type: Ast.Type | undefined,
        p_expression: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.StatementLet {
        return astF.createNode({
            kind: "statement_let",
            name: p_name,
            type: p_type,
            expression: p_expression,
            loc: p_loc,
        }) as Ast.StatementLet;
    }

    function makeDummyStatementLet(
        p_name: Ast.OptionalId,
        p_type: Ast.Type | undefined,
        p_expression: Ast.Expression,
    ): Ast.StatementLet {
        return astF.createNode({
            kind: "statement_let",
            name: p_name,
            type: p_type,
            expression: p_expression,
            loc: emptySrcInfo,
        }) as Ast.StatementLet;
    }

    function makeStatementReturn(
        p_expression: Ast.Expression | undefined,
        p_loc: SrcInfo,
    ): Ast.StatementReturn {
        return astF.createNode({
            kind: "statement_return",
            expression: p_expression,
            loc: p_loc,
        }) as Ast.StatementReturn;
    }

    function makeDummyStatementReturn(
        p_expression: Ast.Expression | undefined,
    ): Ast.StatementReturn {
        return astF.createNode({
            kind: "statement_return",
            expression: p_expression,
            loc: emptySrcInfo,
        }) as Ast.StatementReturn;
    }

    function makeStatementExpression(
        p_expression: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.StatementExpression {
        return astF.createNode({
            kind: "statement_expression",
            expression: p_expression,
            loc: p_loc,
        }) as Ast.StatementExpression;
    }

    function makeDummyStatementExpression(
        p_expression: Ast.Expression,
    ): Ast.StatementExpression {
        return astF.createNode({
            kind: "statement_expression",
            expression: p_expression,
            loc: emptySrcInfo,
        }) as Ast.StatementExpression;
    }

    function makeStatementAssign(
        p_path: Ast.Expression,
        p_expression: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.StatementAssign {
        return astF.createNode({
            kind: "statement_assign",
            path: p_path,
            expression: p_expression,
            loc: p_loc,
        }) as Ast.StatementAssign;
    }

    function makeDummyStatementAssign(
        p_path: Ast.Expression,
        p_expression: Ast.Expression,
    ): Ast.StatementAssign {
        return astF.createNode({
            kind: "statement_assign",
            path: p_path,
            expression: p_expression,
            loc: emptySrcInfo,
        }) as Ast.StatementAssign;
    }

    function makeStatementAugmentedAssign(
        p_op: Ast.AugmentedAssignOperation,
        p_path: Ast.Expression,
        p_expression: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.StatementAugmentedAssign {
        return astF.createNode({
            kind: "statement_augmentedassign",
            op: p_op,
            path: p_path,
            expression: p_expression,
            loc: p_loc,
        }) as Ast.StatementAugmentedAssign;
    }

    function makeDummyStatementAugmentedAssign(
        p_op: Ast.AugmentedAssignOperation,
        p_path: Ast.Expression,
        p_expression: Ast.Expression,
    ): Ast.StatementAugmentedAssign {
        return astF.createNode({
            kind: "statement_augmentedassign",
            op: p_op,
            path: p_path,
            expression: p_expression,
            loc: emptySrcInfo,
        }) as Ast.StatementAugmentedAssign;
    }

    function makeStatementCondition(
        p_condition: Ast.Expression,
        p_trueStatements: readonly Ast.Statement[],
        p_falseStatements: readonly Ast.Statement[] | undefined,
        p_loc: SrcInfo,
    ): Ast.StatementCondition {
        return astF.createNode({
            kind: "statement_condition",
            condition: p_condition,
            trueStatements: p_trueStatements,
            falseStatements: p_falseStatements,
            loc: p_loc,
        }) as Ast.StatementCondition;
    }

    function makeDummyStatementCondition(
        p_condition: Ast.Expression,
        p_trueStatements: readonly Ast.Statement[],
        p_falseStatements: readonly Ast.Statement[] | undefined,
    ): Ast.StatementCondition {
        return astF.createNode({
            kind: "statement_condition",
            condition: p_condition,
            trueStatements: p_trueStatements,
            falseStatements: p_falseStatements,
            loc: emptySrcInfo,
        }) as Ast.StatementCondition;
    }

    function makeStatementWhile(
        p_condition: Ast.Expression,
        p_statements: readonly Ast.Statement[],
        p_loc: SrcInfo,
    ): Ast.StatementWhile {
        return astF.createNode({
            kind: "statement_while",
            condition: p_condition,
            statements: p_statements,
            loc: p_loc,
        }) as Ast.StatementWhile;
    }

    function makeDummyStatementWhile(
        p_condition: Ast.Expression,
        p_statements: readonly Ast.Statement[],
    ): Ast.StatementWhile {
        return astF.createNode({
            kind: "statement_while",
            condition: p_condition,
            statements: p_statements,
            loc: emptySrcInfo,
        }) as Ast.StatementWhile;
    }

    function makeStatementUntil(
        p_condition: Ast.Expression,
        p_statements: readonly Ast.Statement[],
        p_loc: SrcInfo,
    ): Ast.StatementUntil {
        return astF.createNode({
            kind: "statement_until",
            condition: p_condition,
            statements: p_statements,
            loc: p_loc,
        }) as Ast.StatementUntil;
    }

    function makeDummyStatementUntil(
        p_condition: Ast.Expression,
        p_statements: readonly Ast.Statement[],
    ): Ast.StatementUntil {
        return astF.createNode({
            kind: "statement_until",
            condition: p_condition,
            statements: p_statements,
            loc: emptySrcInfo,
        }) as Ast.StatementUntil;
    }

    function makeStatementRepeat(
        p_iterations: Ast.Expression,
        p_statements: readonly Ast.Statement[],
        p_loc: SrcInfo,
    ): Ast.StatementRepeat {
        return astF.createNode({
            kind: "statement_repeat",
            iterations: p_iterations,
            statements: p_statements,
            loc: p_loc,
        }) as Ast.StatementRepeat;
    }

    function makeDummyStatementRepeat(
        p_iterations: Ast.Expression,
        p_statements: readonly Ast.Statement[],
    ): Ast.StatementRepeat {
        return astF.createNode({
            kind: "statement_repeat",
            iterations: p_iterations,
            statements: p_statements,
            loc: emptySrcInfo,
        }) as Ast.StatementRepeat;
    }

    function makeStatementTry(
        p_statements: readonly Ast.Statement[],
        p_catchBlock: Ast.CatchBlock | undefined,
        p_loc: SrcInfo,
    ): Ast.StatementTry {
        return astF.createNode({
            kind: "statement_try",
            statements: p_statements,
            catchBlock: p_catchBlock,
            loc: p_loc,
        }) as Ast.StatementTry;
    }

    function makeDummyStatementTry(
        p_statements: readonly Ast.Statement[],
        p_catchBlock: Ast.CatchBlock | undefined,
    ): Ast.StatementTry {
        return astF.createNode({
            kind: "statement_try",
            statements: p_statements,
            catchBlock: p_catchBlock,
            loc: emptySrcInfo,
        }) as Ast.StatementTry;
    }

    function makeStatementForEach(
        p_keyName: Ast.OptionalId,
        p_valueName: Ast.OptionalId,
        p_map: Ast.Expression,
        p_statements: readonly Ast.Statement[],
        p_loc: SrcInfo,
    ): Ast.StatementForEach {
        return astF.createNode({
            kind: "statement_foreach",
            keyName: p_keyName,
            valueName: p_valueName,
            map: p_map,
            statements: p_statements,
            loc: p_loc,
        }) as Ast.StatementForEach;
    }

    function makeDummyStatementForEach(
        p_keyName: Ast.OptionalId,
        p_valueName: Ast.OptionalId,
        p_map: Ast.Expression,
        p_statements: readonly Ast.Statement[],
    ): Ast.StatementForEach {
        return astF.createNode({
            kind: "statement_foreach",
            keyName: p_keyName,
            valueName: p_valueName,
            map: p_map,
            statements: p_statements,
            loc: emptySrcInfo,
        }) as Ast.StatementForEach;
    }

    function makeStatementDestruct(
        p_type: Ast.TypeId,
        p_identifiers: ReadonlyMap<string, readonly [Ast.Id, Ast.OptionalId]>,
        p_ignoreUnspecifiedFields: boolean,
        p_expression: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.StatementDestruct {
        return astF.createNode({
            kind: "statement_destruct",
            type: p_type,
            identifiers: p_identifiers,
            ignoreUnspecifiedFields: p_ignoreUnspecifiedFields,
            expression: p_expression,
            loc: p_loc,
        }) as Ast.StatementDestruct;
    }

    function makeDummyStatementDestruct(
        p_type: Ast.TypeId,
        p_identifiers: ReadonlyMap<string, readonly [Ast.Id, Ast.OptionalId]>,
        p_ignoreUnspecifiedFields: boolean,
        p_expression: Ast.Expression,
    ): Ast.StatementDestruct {
        return astF.createNode({
            kind: "statement_destruct",
            type: p_type,
            identifiers: p_identifiers,
            ignoreUnspecifiedFields: p_ignoreUnspecifiedFields,
            expression: p_expression,
            loc: emptySrcInfo,
        }) as Ast.StatementDestruct;
    }

    function makeStatementBlock(
        p_statements: readonly Ast.Statement[],
        p_loc: SrcInfo,
    ): Ast.StatementBlock {
        return astF.createNode({
            kind: "statement_block",
            statements: p_statements,
            loc: p_loc,
        }) as Ast.StatementBlock;
    }

    function makeDummyStatementBlock(
        p_statements: readonly Ast.Statement[],
    ): Ast.StatementBlock {
        return astF.createNode({
            kind: "statement_block",
            statements: p_statements,
            loc: emptySrcInfo,
        }) as Ast.StatementBlock;
    }

    function makeTypeId(p_text: string, p_loc: SrcInfo): Ast.TypeId {
        return astF.createNode({
            kind: "type_id",
            text: p_text,
            loc: p_loc,
        }) as Ast.TypeId;
    }

    function makeDummyTypeId(p_text: string): Ast.TypeId {
        return astF.createNode({
            kind: "type_id",
            text: p_text,
            loc: emptySrcInfo,
        }) as Ast.TypeId;
    }

    function makeOptionalType(
        p_typeArg: Ast.Type,
        p_loc: SrcInfo,
    ): Ast.OptionalType {
        return astF.createNode({
            kind: "optional_type",
            typeArg: p_typeArg,
            loc: p_loc,
        }) as Ast.OptionalType;
    }

    function makeDummyOptionalType(p_typeArg: Ast.Type): Ast.OptionalType {
        return astF.createNode({
            kind: "optional_type",
            typeArg: p_typeArg,
            loc: emptySrcInfo,
        }) as Ast.OptionalType;
    }

    function makeMapType(
        p_keyType: Ast.TypeId,
        p_keyStorageType: Ast.Id | undefined,
        p_valueType: Ast.TypeId,
        p_valueStorageType: Ast.Id | undefined,
        p_loc: SrcInfo,
    ): Ast.MapType {
        return astF.createNode({
            kind: "map_type",
            keyType: p_keyType,
            keyStorageType: p_keyStorageType,
            valueType: p_valueType,
            valueStorageType: p_valueStorageType,
            loc: p_loc,
        }) as Ast.MapType;
    }

    function makeDummyMapType(
        p_keyType: Ast.TypeId,
        p_keyStorageType: Ast.Id | undefined,
        p_valueType: Ast.TypeId,
        p_valueStorageType: Ast.Id | undefined,
    ): Ast.MapType {
        return astF.createNode({
            kind: "map_type",
            keyType: p_keyType,
            keyStorageType: p_keyStorageType,
            valueType: p_valueType,
            valueStorageType: p_valueStorageType,
            loc: emptySrcInfo,
        }) as Ast.MapType;
    }

    function makeBouncedMessageType(
        p_messageType: Ast.TypeId,
        p_loc: SrcInfo,
    ): Ast.BouncedMessageType {
        return astF.createNode({
            kind: "bounced_message_type",
            messageType: p_messageType,
            loc: p_loc,
        }) as Ast.BouncedMessageType;
    }

    function makeDummyBouncedMessageType(
        p_messageType: Ast.TypeId,
    ): Ast.BouncedMessageType {
        return astF.createNode({
            kind: "bounced_message_type",
            messageType: p_messageType,
            loc: emptySrcInfo,
        }) as Ast.BouncedMessageType;
    }

    function makeOpBinary(
        p_op: Ast.BinaryOperation,
        p_left: Ast.Expression,
        p_right: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.OpBinary {
        return astF.createNode({
            kind: "op_binary",
            op: p_op,
            left: p_left,
            right: p_right,
            loc: p_loc,
        }) as Ast.OpBinary;
    }

    function makeDummyOpBinary(
        p_op: Ast.BinaryOperation,
        p_left: Ast.Expression,
        p_right: Ast.Expression,
    ): Ast.OpBinary {
        return astF.createNode({
            kind: "op_binary",
            op: p_op,
            left: p_left,
            right: p_right,
            loc: emptySrcInfo,
        }) as Ast.OpBinary;
    }

    function makeOpUnary(
        p_op: Ast.UnaryOperation,
        p_operand: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.OpUnary {
        return astF.createNode({
            kind: "op_unary",
            op: p_op,
            operand: p_operand,
            loc: p_loc,
        }) as Ast.OpUnary;
    }

    function makeDummyOpUnary(
        p_op: Ast.UnaryOperation,
        p_operand: Ast.Expression,
    ): Ast.OpUnary {
        return astF.createNode({
            kind: "op_unary",
            op: p_op,
            operand: p_operand,
            loc: emptySrcInfo,
        }) as Ast.OpUnary;
    }

    function makeConditional(
        p_condition: Ast.Expression,
        p_thenBranch: Ast.Expression,
        p_elseBranch: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.Conditional {
        return astF.createNode({
            kind: "conditional",
            condition: p_condition,
            thenBranch: p_thenBranch,
            elseBranch: p_elseBranch,
            loc: p_loc,
        }) as Ast.Conditional;
    }

    function makeDummyConditional(
        p_condition: Ast.Expression,
        p_thenBranch: Ast.Expression,
        p_elseBranch: Ast.Expression,
    ): Ast.Conditional {
        return astF.createNode({
            kind: "conditional",
            condition: p_condition,
            thenBranch: p_thenBranch,
            elseBranch: p_elseBranch,
            loc: emptySrcInfo,
        }) as Ast.Conditional;
    }

    function makeMethodCall(
        p_self: Ast.Expression,
        p_method: Ast.Id,
        p_args: readonly Ast.Expression[],
        p_loc: SrcInfo,
    ): Ast.MethodCall {
        return astF.createNode({
            kind: "method_call",
            self: p_self,
            method: p_method,
            args: p_args,
            loc: p_loc,
        }) as Ast.MethodCall;
    }

    function makeDummyMethodCall(
        p_self: Ast.Expression,
        p_method: Ast.Id,
        p_args: readonly Ast.Expression[],
    ): Ast.MethodCall {
        return astF.createNode({
            kind: "method_call",
            self: p_self,
            method: p_method,
            args: p_args,
            loc: emptySrcInfo,
        }) as Ast.MethodCall;
    }

    function makeFieldAccess(
        p_aggregate: Ast.Expression,
        p_field: Ast.Id,
        p_loc: SrcInfo,
    ): Ast.FieldAccess {
        return astF.createNode({
            kind: "field_access",
            aggregate: p_aggregate,
            field: p_field,
            loc: p_loc,
        }) as Ast.FieldAccess;
    }

    function makeDummyFieldAccess(
        p_aggregate: Ast.Expression,
        p_field: Ast.Id,
    ): Ast.FieldAccess {
        return astF.createNode({
            kind: "field_access",
            aggregate: p_aggregate,
            field: p_field,
            loc: emptySrcInfo,
        }) as Ast.FieldAccess;
    }

    function makeStaticCall(
        p_function: Ast.Id,
        p_args: readonly Ast.Expression[],
        p_loc: SrcInfo,
    ): Ast.StaticCall {
        return astF.createNode({
            kind: "static_call",
            function: p_function,
            args: p_args,
            loc: p_loc,
        }) as Ast.StaticCall;
    }

    function makeDummyStaticCall(
        p_function: Ast.Id,
        p_args: readonly Ast.Expression[],
    ): Ast.StaticCall {
        return astF.createNode({
            kind: "static_call",
            function: p_function,
            args: p_args,
            loc: emptySrcInfo,
        }) as Ast.StaticCall;
    }

    function makeStructInstance(
        p_type: Ast.Id,
        p_args: readonly Ast.StructFieldInitializer[],
        p_loc: SrcInfo,
    ): Ast.StructInstance {
        return astF.createNode({
            kind: "struct_instance",
            type: p_type,
            args: p_args,
            loc: p_loc,
        }) as Ast.StructInstance;
    }

    function makeDummyStructInstance(
        p_type: Ast.Id,
        p_args: readonly Ast.StructFieldInitializer[],
    ): Ast.StructInstance {
        return astF.createNode({
            kind: "struct_instance",
            type: p_type,
            args: p_args,
            loc: emptySrcInfo,
        }) as Ast.StructInstance;
    }

    function makeId(p_text: string, p_loc: SrcInfo): Ast.Id {
        return astF.createNode({
            kind: "id",
            text: p_text,
            loc: p_loc,
        }) as Ast.Id;
    }

    function makeDummyId(p_text: string): Ast.Id {
        return astF.createNode({
            kind: "id",
            text: p_text,
            loc: emptySrcInfo,
        }) as Ast.Id;
    }

    function makeInitOf(
        p_contract: Ast.Id,
        p_args: readonly Ast.Expression[],
        p_loc: SrcInfo,
    ): Ast.InitOf {
        return astF.createNode({
            kind: "init_of",
            contract: p_contract,
            args: p_args,
            loc: p_loc,
        }) as Ast.InitOf;
    }

    function makeDummyInitOf(
        p_contract: Ast.Id,
        p_args: readonly Ast.Expression[],
    ): Ast.InitOf {
        return astF.createNode({
            kind: "init_of",
            contract: p_contract,
            args: p_args,
            loc: emptySrcInfo,
        }) as Ast.InitOf;
    }

    function makeCodeOf(p_contract: Ast.Id, p_loc: SrcInfo): Ast.CodeOf {
        return astF.createNode({
            kind: "code_of",
            contract: p_contract,
            loc: p_loc,
        }) as Ast.CodeOf;
    }

    function makeDummyCodeOf(p_contract: Ast.Id): Ast.CodeOf {
        return astF.createNode({
            kind: "code_of",
            contract: p_contract,
            loc: emptySrcInfo,
        }) as Ast.CodeOf;
    }

    function makeNumber(
        p_base: Ast.NumberBase,
        p_value: bigint,
        p_loc: SrcInfo,
    ): Ast.Number {
        return astF.createNode({
            kind: "number",
            base: p_base,
            value: p_value,
            loc: p_loc,
        }) as Ast.Number;
    }

    function makeDummyNumber(
        p_base: Ast.NumberBase,
        p_value: bigint,
    ): Ast.Number {
        return astF.createNode({
            kind: "number",
            base: p_base,
            value: p_value,
            loc: emptySrcInfo,
        }) as Ast.Number;
    }

    function makeBoolean(p_value: boolean, p_loc: SrcInfo): Ast.Boolean {
        return astF.createNode({
            kind: "boolean",
            value: p_value,
            loc: p_loc,
        }) as Ast.Boolean;
    }

    function makeDummyBoolean(p_value: boolean): Ast.Boolean {
        return astF.createNode({
            kind: "boolean",
            value: p_value,
            loc: emptySrcInfo,
        }) as Ast.Boolean;
    }

    function makeNull(p_loc: SrcInfo): Ast.Null {
        return astF.createNode({
            kind: "null",
            loc: p_loc,
        }) as Ast.Null;
    }

    function makeDummyNull(): Ast.Null {
        return astF.createNode({
            kind: "null",
            loc: emptySrcInfo,
        }) as Ast.Null;
    }

    function makeString(p_value: string, p_loc: SrcInfo): Ast.String {
        return astF.createNode({
            kind: "string",
            value: p_value,
            loc: p_loc,
        }) as Ast.String;
    }

    function makeDummyString(p_value: string): Ast.String {
        return astF.createNode({
            kind: "string",
            value: p_value,
            loc: emptySrcInfo,
        }) as Ast.String;
    }

    function makeAddress(
        p_value: TonCore.Address,
        p_loc: SrcInfo,
    ): Ast.Address {
        return astF.createNode({
            kind: "address",
            value: p_value,
            loc: p_loc,
        }) as Ast.Address;
    }

    function makeDummyAddress(p_value: TonCore.Address): Ast.Address {
        return astF.createNode({
            kind: "address",
            value: p_value,
            loc: emptySrcInfo,
        }) as Ast.Address;
    }

    function makeCell(p_value: TonCore.Cell, p_loc: SrcInfo): Ast.Cell {
        return astF.createNode({
            kind: "cell",
            value: p_value,
            loc: p_loc,
        }) as Ast.Cell;
    }

    function makeDummyCell(p_value: TonCore.Cell): Ast.Cell {
        return astF.createNode({
            kind: "cell",
            value: p_value,
            loc: emptySrcInfo,
        }) as Ast.Cell;
    }

    function makeSlice(p_value: TonCore.Slice, p_loc: SrcInfo): Ast.Slice {
        return astF.createNode({
            kind: "slice",
            value: p_value,
            loc: p_loc,
        }) as Ast.Slice;
    }

    function makeDummySlice(p_value: TonCore.Slice): Ast.Slice {
        return astF.createNode({
            kind: "slice",
            value: p_value,
            loc: emptySrcInfo,
        }) as Ast.Slice;
    }

    function makeStructValue(
        p_type: Ast.Id,
        p_args: readonly Ast.StructFieldValue[],
        p_loc: SrcInfo,
    ): Ast.StructValue {
        return astF.createNode({
            kind: "struct_value",
            type: p_type,
            args: p_args,
            loc: p_loc,
        }) as Ast.StructValue;
    }

    function makeDummyStructValue(
        p_type: Ast.Id,
        p_args: readonly Ast.StructFieldValue[],
    ): Ast.StructValue {
        return astF.createNode({
            kind: "struct_value",
            type: p_type,
            args: p_args,
            loc: emptySrcInfo,
        }) as Ast.StructValue;
    }

    function makeWildcard(p_loc: SrcInfo): Ast.Wildcard {
        return astF.createNode({
            kind: "wildcard",
            loc: p_loc,
        }) as Ast.Wildcard;
    }

    function makeDummyWildcard(): Ast.Wildcard {
        return astF.createNode({
            kind: "wildcard",
            loc: emptySrcInfo,
        }) as Ast.Wildcard;
    }

    function makeFunctionAttributeGet(
        p_methodId: Ast.Expression | undefined,
        p_loc: SrcInfo,
    ): Ast.FunctionAttributeGet {
        return astF.createNode({
            kind: "function_attribute",
            type: "get",
            methodId: p_methodId,
            loc: p_loc,
        }) as Ast.FunctionAttributeGet;
    }

    function makeDummyFunctionAttributeGet(
        p_methodId: Ast.Expression | undefined,
    ): Ast.FunctionAttributeGet {
        return astF.createNode({
            kind: "function_attribute",
            type: "get",
            methodId: p_methodId,
            loc: emptySrcInfo,
        }) as Ast.FunctionAttributeGet;
    }

    function makeFunctionAttributeRest(
        p_type: Ast.FunctionAttributeName,
        p_loc: SrcInfo,
    ): Ast.FunctionAttributeRest {
        return astF.createNode({
            kind: "function_attribute",
            type: p_type,
            loc: p_loc,
        }) as Ast.FunctionAttributeRest;
    }

    function makeDummyFunctionAttributeRest(
        p_type: Ast.FunctionAttributeName,
    ): Ast.FunctionAttributeRest {
        return astF.createNode({
            kind: "function_attribute",
            type: p_type,
            loc: emptySrcInfo,
        }) as Ast.FunctionAttributeRest;
    }

    function makeReceiverSimple(
        p_param: Ast.TypedParameter,
    ): Ast.ReceiverSimple {
        return astF.createNode({
            kind: "simple",
            param: p_param,
        }) as Ast.ReceiverSimple;
    }

    function makeReceiverFallback(): Ast.ReceiverFallback {
        return astF.createNode({
            kind: "fallback",
        }) as Ast.ReceiverFallback;
    }

    function makeReceiverComment(p_comment: Ast.String): Ast.ReceiverComment {
        return astF.createNode({
            kind: "comment",
            comment: p_comment,
        }) as Ast.ReceiverComment;
    }

    function makeReceiverInternal(
        p_subKind: Ast.ReceiverSubKind,
        p_loc: SrcInfo,
    ): Ast.ReceiverInternal {
        return astF.createNode({
            kind: "internal",
            subKind: p_subKind,
            loc: p_loc,
        }) as Ast.ReceiverInternal;
    }

    function makeDummyReceiverInternal(
        p_subKind: Ast.ReceiverSubKind,
    ): Ast.ReceiverInternal {
        return astF.createNode({
            kind: "internal",
            subKind: p_subKind,
            loc: emptySrcInfo,
        }) as Ast.ReceiverInternal;
    }

    function makeReceiverExternal(
        p_subKind: Ast.ReceiverSubKind,
        p_loc: SrcInfo,
    ): Ast.ReceiverExternal {
        return astF.createNode({
            kind: "external",
            subKind: p_subKind,
            loc: p_loc,
        }) as Ast.ReceiverExternal;
    }

    function makeDummyReceiverExternal(
        p_subKind: Ast.ReceiverSubKind,
    ): Ast.ReceiverExternal {
        return astF.createNode({
            kind: "external",
            subKind: p_subKind,
            loc: emptySrcInfo,
        }) as Ast.ReceiverExternal;
    }

    function makeReceiverBounce(
        p_param: Ast.TypedParameter,
        p_loc: SrcInfo,
    ): Ast.ReceiverBounce {
        return astF.createNode({
            kind: "bounce",
            param: p_param,
            loc: p_loc,
        }) as Ast.ReceiverBounce;
    }

    function makeDummyReceiverBounce(
        p_param: Ast.TypedParameter,
    ): Ast.ReceiverBounce {
        return astF.createNode({
            kind: "bounce",
            param: p_param,
            loc: emptySrcInfo,
        }) as Ast.ReceiverBounce;
    }

    function makeFuncId(p_text: string, p_loc: SrcInfo): Ast.FuncId {
        return astF.createNode({
            kind: "func_id",
            text: p_text,
            loc: p_loc,
        }) as Ast.FuncId;
    }

    function makeDummyFuncId(p_text: string): Ast.FuncId {
        return astF.createNode({
            kind: "func_id",
            text: p_text,
            loc: emptySrcInfo,
        }) as Ast.FuncId;
    }

    function makeDestructMapping(
        p_field: Ast.Id,
        p_name: Ast.Id,
        p_loc: SrcInfo,
    ): Ast.DestructMapping {
        return astF.createNode({
            kind: "destruct_mapping",
            field: p_field,
            name: p_name,
            loc: p_loc,
        }) as Ast.DestructMapping;
    }

    function makeDummyDestructMapping(
        p_field: Ast.Id,
        p_name: Ast.Id,
    ): Ast.DestructMapping {
        return astF.createNode({
            kind: "destruct_mapping",
            field: p_field,
            name: p_name,
            loc: emptySrcInfo,
        }) as Ast.DestructMapping;
    }

    function makeDestructEnd(
        p_ignoreUnspecifiedFields: boolean,
        p_loc: SrcInfo,
    ): Ast.DestructEnd {
        return astF.createNode({
            kind: "destruct_end",
            ignoreUnspecifiedFields: p_ignoreUnspecifiedFields,
            loc: p_loc,
        }) as Ast.DestructEnd;
    }

    function makeDummyDestructEnd(
        p_ignoreUnspecifiedFields: boolean,
    ): Ast.DestructEnd {
        return astF.createNode({
            kind: "destruct_end",
            ignoreUnspecifiedFields: p_ignoreUnspecifiedFields,
            loc: emptySrcInfo,
        }) as Ast.DestructEnd;
    }

    function makeTypedParameter(
        p_name: Ast.OptionalId,
        p_type: Ast.Type,
        p_loc: SrcInfo,
    ): Ast.TypedParameter {
        return astF.createNode({
            kind: "typed_parameter",
            name: p_name,
            type: p_type,
            loc: p_loc,
            as: undefined,
        }) as Ast.TypedParameter;
    }

    function makeDummyTypedParameter(
        p_name: Ast.OptionalId,
        p_type: Ast.Type,
    ): Ast.TypedParameter {
        return astF.createNode({
            kind: "typed_parameter",
            name: p_name,
            type: p_type,
            loc: emptySrcInfo,
            as: undefined,
        }) as Ast.TypedParameter;
    }

    function makeModule(
        p_imports: readonly Ast.Import[],
        p_items: readonly Ast.ModuleItem[],
    ): Ast.Module {
        return astF.createNode({
            kind: "module",
            imports: p_imports,
            items: p_items,
        }) as Ast.Module;
    }

    function makeStructFieldInitializer(
        p_field: Ast.Id,
        p_initializer: Ast.Expression,
        p_loc: SrcInfo,
    ): Ast.StructFieldInitializer {
        return astF.createNode({
            kind: "struct_field_initializer",
            field: p_field,
            initializer: p_initializer,
            loc: p_loc,
        }) as Ast.StructFieldInitializer;
    }

    function makeDummyStructFieldInitializer(
        p_field: Ast.Id,
        p_initializer: Ast.Expression,
    ): Ast.StructFieldInitializer {
        return astF.createNode({
            kind: "struct_field_initializer",
            field: p_field,
            initializer: p_initializer,
            loc: emptySrcInfo,
        }) as Ast.StructFieldInitializer;
    }

    function makeStructFieldValue(
        p_field: Ast.Id,
        p_initializer: Ast.Literal,
        p_loc: SrcInfo,
    ): Ast.StructFieldValue {
        return astF.createNode({
            kind: "struct_field_value",
            field: p_field,
            initializer: p_initializer,
            loc: p_loc,
        }) as Ast.StructFieldValue;
    }

    function makeDummyStructFieldValue(
        p_field: Ast.Id,
        p_initializer: Ast.Literal,
    ): Ast.StructFieldValue {
        return astF.createNode({
            kind: "struct_field_value",
            field: p_field,
            initializer: p_initializer,
            loc: emptySrcInfo,
        }) as Ast.StructFieldValue;
    }

    function makeImport(
        p_importPath: Ast.ImportPath,
        p_loc: SrcInfo,
    ): Ast.Import {
        return astF.createNode({
            kind: "import",
            importPath: p_importPath,
            loc: p_loc,
        }) as Ast.Import;
    }

    function makeDummyImport(p_importPath: Ast.ImportPath): Ast.Import {
        return astF.createNode({
            kind: "import",
            importPath: p_importPath,
            loc: emptySrcInfo,
        }) as Ast.Import;
    }

    return {
        makePrimitiveTypeDecl,
        makeDummyPrimitiveTypeDecl,
        makeFunctionDef,
        makeDummyFunctionDef,
        makeAsmFunctionDef,
        makeDummyAsmFunctionDef,
        makeNativeFunctionDecl,
        makeDummyNativeFunctionDecl,
        makeConstantDef,
        makeDummyConstantDef,
        makeStructDecl,
        makeDummyStructDecl,
        makeMessageDecl,
        makeDummyMessageDecl,
        makeContract,
        makeDummyContract,
        makeTrait,
        makeDummyTrait,
        makeFieldDecl,
        makeDummyFieldDecl,
        makeContractInit,
        makeDummyContractInit,
        makeReceiver,
        makeDummyReceiver,
        makeFunctionDecl,
        makeDummyFunctionDecl,
        makeConstantDecl,
        makeDummyConstantDecl,
        makeStatementLet,
        makeDummyStatementLet,
        makeStatementReturn,
        makeDummyStatementReturn,
        makeStatementExpression,
        makeDummyStatementExpression,
        makeStatementAssign,
        makeDummyStatementAssign,
        makeStatementAugmentedAssign,
        makeDummyStatementAugmentedAssign,
        makeStatementCondition,
        makeDummyStatementCondition,
        makeStatementWhile,
        makeDummyStatementWhile,
        makeStatementUntil,
        makeDummyStatementUntil,
        makeStatementRepeat,
        makeDummyStatementRepeat,
        makeStatementTry,
        makeDummyStatementTry,
        makeStatementForEach,
        makeDummyStatementForEach,
        makeStatementDestruct,
        makeDummyStatementDestruct,
        makeStatementBlock,
        makeDummyStatementBlock,
        makeTypeId,
        makeDummyTypeId,
        makeOptionalType,
        makeDummyOptionalType,
        makeMapType,
        makeDummyMapType,
        makeBouncedMessageType,
        makeDummyBouncedMessageType,
        makeOpBinary,
        makeDummyOpBinary,
        makeOpUnary,
        makeDummyOpUnary,
        makeConditional,
        makeDummyConditional,
        makeMethodCall,
        makeDummyMethodCall,
        makeFieldAccess,
        makeDummyFieldAccess,
        makeStaticCall,
        makeDummyStaticCall,
        makeStructInstance,
        makeDummyStructInstance,
        makeId,
        makeDummyId,
        makeInitOf,
        makeDummyInitOf,
        makeCodeOf,
        makeDummyCodeOf,
        makeNumber,
        makeDummyNumber,
        makeBoolean,
        makeDummyBoolean,
        makeNull,
        makeDummyNull,
        makeString,
        makeDummyString,
        makeAddress,
        makeDummyAddress,
        makeCell,
        makeDummyCell,
        makeSlice,
        makeDummySlice,
        makeStructValue,
        makeDummyStructValue,
        makeWildcard,
        makeDummyWildcard,
        makeFunctionAttributeGet,
        makeDummyFunctionAttributeGet,
        makeFunctionAttributeRest,
        makeDummyFunctionAttributeRest,
        makeReceiverSimple,
        makeReceiverFallback,
        makeReceiverComment,
        makeReceiverInternal,
        makeDummyReceiverInternal,
        makeReceiverExternal,
        makeDummyReceiverExternal,
        makeReceiverBounce,
        makeDummyReceiverBounce,
        makeFuncId,
        makeDummyFuncId,
        makeDestructMapping,
        makeDummyDestructMapping,
        makeDestructEnd,
        makeDummyDestructEnd,
        makeTypedParameter,
        makeDummyTypedParameter,
        makeModule,
        makeStructFieldInitializer,
        makeDummyStructFieldInitializer,
        makeStructFieldValue,
        makeDummyStructFieldValue,
        makeImport,
        makeDummyImport,
    };
};

export type MakeAstFactory = ReturnType<typeof getMakeAst>;
