// This file is generated by `vscode-ext-gen`. Do not modify manually.
// @see https://github.com/antfu/vscode-ext-gen

// Meta info
export const publisher = "typed-ember"
export const name = "glint2-vscode"
export const version = "1.0.0"
export const displayName = "Glint V2"
export const description = "Volar.js-powered Ember.js language server and TS Plugin for VS Code"
export const extensionId = `${publisher}.${name}`

/**
 * Type union of all commands
 */
export type CommandKey = 
  | "glint2.restart-language-server"

/**
 * Commands map registed by `typed-ember.glint2-vscode`
 */
export const commands = {
  /**
   * Glint V2: Restart Glint V2 Server
   * @value `glint2.restart-language-server`
   */
  restartLanguageServer: "glint2.restart-language-server",
} satisfies Record<string, CommandKey>

/**
 * Type union of all configs
 */
export type ConfigKey = 
  | "glint2.libraryPath"
  | "glint2.trace.server"

export interface ConfigKeyTypeMap {
  "glint2.libraryPath": (string | undefined),
  "glint2.trace.server": ("off" | "messages" | "verbose"),
}

export interface ConfigShorthandMap {
  libraryPath: "glint2.libraryPath",
  traceServer: "glint2.trace.server",
}

export interface ConfigShorthandTypeMap {
  libraryPath: (string | undefined),
  traceServer: ("off" | "messages" | "verbose"),
}

export interface ConfigItem<T extends keyof ConfigKeyTypeMap> {
  key: T,
  default: ConfigKeyTypeMap[T],
}


/**
 * Configs map registered by `typed-ember.glint2-vscode`
 */
export const configs = {
  /**
   * 
   * @key `glint2.libraryPath`
   * @default `undefined`
   * @type `string`
   */
  libraryPath: {
    key: "glint2.libraryPath",
    default: undefined,
  } as ConfigItem<"glint2.libraryPath">,
  /**
   * Traces communication between VS Code and the Glint language server.
   * @key `glint2.trace.server`
   * @default `"off"`
   * @type `string`
   */
  traceServer: {
    key: "glint2.trace.server",
    default: "off",
  } as ConfigItem<"glint2.trace.server">,
}

export interface ScopedConfigKeyTypeMap {
  "libraryPath": (string | undefined),
  "trace.server": ("off" | "messages" | "verbose"),
}

export const scopedConfigs = {
  scope: "glint2",
  defaults: {
    "libraryPath": undefined,
    "trace.server": "off",
  } satisfies ScopedConfigKeyTypeMap,
}

export interface NestedConfigs {
  "glint2": {
    "libraryPath": (string | undefined),
    "trace": {
      "server": ("off" | "messages" | "verbose"),
    },
  },
}

export interface NestedScopedConfigs {
  "libraryPath": (string | undefined),
  "trace": {
    "server": ("off" | "messages" | "verbose"),
  },
}

