import { parse } from '@babel/parser';
import { traverse } from '@babel/core';
import { readFileSync, writeFileSync } from 'fs';
import { resolve } from 'path';
import { createRequire } from 'module';
import { fileURLToPath } from 'url';

const require = createRequire(import.meta.url);
const ts = require.resolve('typescript');
const libDomFile = resolve(ts, '..', 'lib.dom.d.ts');
const source = readFileSync(libDomFile).toString();
const ast = parse(source, {
  plugins: [['typescript', { dts: true }]],
});

const elements = new Set(['SVGElement']);
traverse(ast, {
  TSInterfaceDeclaration: function (path) {
    if (path.node.id.name === 'HTMLElementTagNameMap') {
      const items = path.node.body.body;
      for (const item of items) {
        elements.add(item.typeAnnotation.typeAnnotation.typeName.name);
      }
    }
    if (path.node.id.name === 'SVGElementTagNameMap') {
      const items = path.node.body.body;
      for (const item of items) {
        elements.add(item.typeAnnotation.typeAnnotation.typeName.name);
      }
    }
  },
});

let registry = [];
for (const element of elements) {
  registry.push(`  '${element}': ${element};`);
}

const prefix = `// generated by <Glint root>/bin/build-augmentations.mjs
//
// This serves to provide a UNIQUE mapping for HtmlElementType -> Html Element Name -> Html Element Attributes
//   (in combination with elements.d.ts)
// 
// The TypeScript lib.dom.d.ts already has HTMLElementTagNameMap, 
// but it does not provide unique types for each element, and the technique
// we use for looking up the type-string for each element does not work with the built in types.
`;
const filePath = resolve(
  fileURLToPath(import.meta.url),
  '../../packages/template/-private/dsl/lib.dom.augmentation.d.ts',
);
let content = prefix;
content += '\n';
content += `export interface GlintElementRegistry {\n`;
content += registry.join('\n') + '\n';
content += `}\n`;
writeFileSync(filePath, content);
