/*
 * Tencent is pleased to support the open source community by making Tinker available.
 *
 * Copyright (C) 2016 THL A29 Limited, a Tencent company. All rights reserved.
 *
 * Licensed under the BSD 3-Clause License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 * https://opensource.org/licenses/BSD-3-Clause
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tencent.tinker.entry;

/**
 * Created by zhangshaowen on 16/3/8.
 */

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;

import com.tencent.tinker.anno.Keep;

import com.tencent.tinker.loader.shareutil.ShareTinkerLog;

/**
 * Empty implementation of {@link ApplicationLike}.
 */
@Keep
public class DefaultApplicationLike extends ApplicationLike {
    private static final String TAG = "Tinker.DefaultAppLike";

    public DefaultApplicationLike(Application application, int tinkerFlags, boolean tinkerLoadVerifyFlag,
                                  long applicationStartElapsedTime, long applicationStartMillisTime, Intent tinkerResultIntent) {
        super(application, tinkerFlags, tinkerLoadVerifyFlag, applicationStartElapsedTime, applicationStartMillisTime, tinkerResultIntent);
    }

    @Override
    public void onCreate() {
        ShareTinkerLog.d(TAG, "onCreate");
    }

    @Override
    public void onLowMemory() {
        ShareTinkerLog.d(TAG, "onLowMemory");
    }

    @Override
    public void onTrimMemory(int level) {
        ShareTinkerLog.d(TAG, "onTrimMemory level:" + level);
    }

    @Override
    public void onTerminate() {
        ShareTinkerLog.d(TAG, "onTerminate");
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        ShareTinkerLog.d(TAG, "onConfigurationChanged:" + newConfig.toString());
    }

    @Override
    public void onBaseContextAttached(Context base) {
        ShareTinkerLog.d(TAG, "onBaseContextAttached:");
    }
}
