[![Deploy to now](https://deploy.now.sh/static/button.svg)](https://deploy.now.sh/?repo=https://github.com/zeit/next.js/tree/master/examples/with-react-intl)
# Example app with [React Intl][]

## How to use

Download the example [or clone the repo](https://github.com/zeit/next.js.git):

```bash
curl https://codeload.github.com/zeit/next.js/tar.gz/master | tar -xz --strip=2 next.js-master/examples/with-react-intl
cd with-react-intl
```

Install it and run:

```bash
npm install
npm run dev
```

Deploy it to the cloud with [now](https://zeit.co/now) ([download](https://zeit.co/download))

```bash
now
```

## The idea behind the example

This example app shows how to integrate [React Intl][] with Next.

### Features of this example app

- Server-side language negotiation
- React Intl locale data loading via `pages/_document.js` customization
- React Intl integration at Next page level via `pageWithIntl()` HOC
- `<IntlProvider>` creation with `locale`, `messages`, and `initialNow` props
- Default message extraction via `babel-plugin-react-intl` integration
- Translation management via build script and customized Next server

### Translation Management

This app stores translations and default strings in the `lang/` dir. This dir has `.messages/` subdir which is where React Intl's Babel plugin outputs the default messages it extracts from the source code. The default messages (`en.json` in this example app) is also generated by the build script. This file can then be sent to a translation service to perform localization for the other locales the app should support.

The translated messages files that exist at `lang/*.json` are only used during production, and are automatically provided to the `<IntlProvider>`. During development the `defaultMessage`s defined in the source code are used. To prepare the example app for localization and production run the build script and start the server in production mode:

```
$ npm run build
$ npm start
```

You can then switch your browser's language preferences to French and refresh the page to see the UI update accordingly.

[React Intl]: https://github.com/yahoo/react-intl
