%global soletta_major 0
%global soletta_minor 0
%global soletta_build 1
%global soletta_tag beta13

%global soletta_duktape_version 1.2.2
%global soletta_duktape_tag beta2

%global soletta_tinycbor_version 0.2

Summary: A framework for making IoT devices
Name: soletta
Version: %{soletta_major}.%{soletta_minor}.%{soletta_build}
Release: %{soletta_tag}.1%{?dist}
# BSD License:
#       builders/*
#       tools/*
#       data/*
#       src/*
#       doc/* (exceptions below)
# MIT License:
#       src/thirdparty/duktape/*
#       src/thirdparty/tinycbor/*
#       doc/node-types-html/jquery-ui.min.css
#       doc/node-types-html/js/frameworks/* (exceptions below)
# GPLv2+:
#       tools/kconfig/*
#       doc/node-types-html/js/frameworks/isotope.pkgd.min.js
# PSF:
#       src/modules/flow/converter/string-format.c
#       src/modules/flow/string/string-replace-ascii.c
#       src/modules/flow/string/string-replace-icu.c
License: BSD and MIT and GPLv2+ and PSF
URL: http://github.com/solettaproject/soletta
Source0: https://github.com/solettaproject/%{name}/archive/v1_%{soletta_tag}.tar.gz#/%{name}-%{version}.tar.gz
Source1: https://github.com/solettaproject/duktape-release/archive/v1_%{soletta_duktape_tag}.tar.gz#/%{name}-duktape-%{version}.tar.gz
Source2: https://github.com/01org/tinycbor/archive/v%{soletta_tinycbor_version}.tar.gz#/%{name}-tinycbor-%{version}.tar.gz
Provides: bundled(tinycbor) = %{soletta_tinycbor_version}
Provides: bundled(duktape) = %{soletta_duktape_version}
BuildRequires: gtk3-devel
BuildRequires: libcurl-devel
BuildRequires: libicu-devel
%if 0%{?fedora} > 23
BuildRequires: libmicrohttpd-devel
%endif
BuildRequires: mosquitto-devel
BuildRequires: pcre-devel
BuildRequires: systemd-devel
BuildRequires: python3 >= 3.4
BuildRequires: python3-jsonschema

%description
Soletta project is a framework for making IoT devices. With Soletta
library developers can easily write software for devices that control
actuators/sensors and communicate using standard technologies. It
enables adding smartness even on the smallest edge devices.

%package flow-module-accelerometer
Summary: Accelerometer flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-accelerometer
This package contains the accelerometer flow module for %{name}. The
module provides flow nodes for accelerometers such as ADXL345 and
LSM303DLHC.

%package flow-module-am2315
Summary: AM2315 flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-am2315
This package contains the AM2315 flow module for %{name}. The module
provides flow nodes that output AM2315 sensor readings (temperature
and humidity).

%package flow-module-calamari
Summary: Calamari flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-calamari
This package contains the calamari flow module for %{name}. The module
provides flow nodes for doing I/O on the Calamari board
(http://elinux.org/Calamari_Lure) components.

%package flow-module-compass
Summary: Compass flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-compass
This package contains the compass flow module for %{name}. The module
provides a compass node that takes direction-vectors of given
accelerometer and a magnetometer nodes and outputs heading towards
Magnetic North Pole, in degrees.

%package flow-module-evdev
Summary: Evdev flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-evdev
This package contains the evdev flow module for %{name}. The module
provides an evdev node that outputs boolean packets after evdev events
(being listened) occur.

%package flow-module-file
Summary: File flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-file
This package contains the file flow module for %{name}. The module
provides a file node meant to read and write data to files
(asynchronously).

%package flow-module-flower-power
Summary: Flower-power flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-flower-power
This package contains the flower-power flow module for %{name}. The
module interfaces with Parrot Flower Power
(http://www.parrot.com/usa/products/flower-power/), measuring and
analyzing the four elements crucial the health of plants: sunlight,
temperature, soil moisture and fertilizer. It fetches plant data via
HTTP, using a web service.

%package flow-module-form
Summary: Form flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-form
This package contains the form flow module for %{name}. The module
provides nodes producing formatted, string output to feed LCD
displays, getting input from buttons.

%package flow-module-grove
Summary: Grove flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-grove
This package contains the grove flow module for %{name}. The module
provides flow nodes for doing I/O and package conversions for the
Grove Starter Kit
(http://www.seeedstudio.com/wiki/Grove_-_Starter_Kit_v3) components.

%package flow-module-gtk
Summary: Gtk flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: gtk3

%description flow-module-gtk
This package contains the Gtk flow module for %{name}. The module
provides flow nodes for doing I/O of various Soletta basic packet
types, for simulation purposes. Both input and output nodes will be
Gtk UI elements.

%package flow-module-gyroscope
Summary: Gyroscope flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-gyroscope
This package contains the gyroscope flow module for %{name}. The
module provides a flow node for the L3G4200D gyroscope.

%package flow-module-http-client
Summary: HTTP client flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-http-client
This package contains the HTTP-client flow module for %{name}. The
module provides flow nodes that fetch and output the basic packet
types of Soletta, to be combined with the respective server nodes. It
also provides nodes that fetch arbitrary URL contents and output them
as either string or blob packets.

%if 0%{?fedora} > 23
%package flow-module-http-server
Summary: HTTP server flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-http-server
This package contains the HTTP-server flow module for %{name}. The
module provides flow nodes that serve the basic packet
types of Soletta, to be combined with the respective client nodes. It
also provides a node to serve static files.
%endif

%package flow-module-iio
Summary: IIO flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-iio
This package contains the iio flow module for %{name}. The module
provides an IIO-based gyroscope input flow node. As any IIO device, it
can use a buffer to get the readings.

%package flow-module-json
Summary: JSON flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-json
This package contains the json flow module for %{name}. The module
provides nodes to manipulate JSON packets, like retrieving arbitrary
content of the JSON object and output that in an appropriate port,
count the number of object fields, etc.

%package flow-module-keyboard
Summary: Keyboard flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-keyboard
This package contains the keyboard flow module for %{name}. The module
provides flow nodes for keyboard input.

%package flow-module-mqtt
Summary: MQTT flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-mqtt
This package contains the mqtt flow module for %{name}. The module
provides a flow node implementing a MQTT client.

# We depend on http-server for the oauth node
%if 0%{?fedora} > 23
%package flow-module-oauth
Summary: OAuth flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-oauth
This package contains the oauth flow module for %{name}. The module
provides a flow nodes to negotiate an OAuth access token.
%endif

%package flow-module-power-supply
Summary: Power supply flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-power-supply
This package contains the power supply flow module for %{name}. The
module provides flow nodes to list and query information from all
power supplies of the system.

%package flow-module-led-strip
Summary: Led-Strip flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-led-strip
This package contains the led-strip flow module for %{name}. The
module provides a flow node for the LPD8806 led strip controller.

%package flow-module-location
Summary: Location flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-location
This package contains the location flow module for %{name}. The module
provides flow nodes interfacing with the free FreeGeoip service, to
obtain the location of either a given IP address or the originating
address.

%package flow-module-magnetometer
Summary: Magnetometer flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-magnetometer
This package contains the magnetometer flow module for %{name}. The
module provides a flow node for the LSM303DLHC magnetometer.

%package flow-module-max31855
Summary: MAX31855 flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-max31855
This package contains the MAX31855 flow module for %{name}. The module
provides a flow node for the MAX31855 temperature reader.

%package flow-module-network
Summary: Network flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-network
This package contains the network flow module for %{name}. The module
provides a flow node that outputs boolean packets after network
connect/disconnect events occur.

%package flow-module-oic
Summary: OIC flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-oic
This package contains the OIC flow module for %{name}. The module
provides server and client flow nodes for Open Interconnect Consortium
"brightlight" class of devices.

%package flow-module-persistence
Summary: Persistence flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-persistence
This package contains the persistence flow module for %{name}. The
module provides flow nodes for storing/retrieving Soletta basic packet
type values on the file system or on EFI variables.

%package flow-module-piezo-speaker
Summary: Piezo-speaker flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-piezo-speaker
This package contains the piezo-speaker flow module for %{name}. The
module provides a flow node for sound output on (PWM) piezo speakers.

%package flow-module-process
Summary: Process flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-process
This package contains the process flow module for %{name}. The module
provides flow nodes for spawning a process and connecting its
stdin/stdout/stderr back into a flow.

%package flow-module-servo-motor
Summary: Servo-motor flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-servo-motor
This package contains the servo-motor flow module for %{name}. The
module provides a flow node to control servo motors.

%package flow-module-test
Summary: Test flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-test
This package contains the test flow module for %{name}. The module
provides flow nodes that aids one to write testing/validation flows
(checking for expected packet results).

%package flow-module-thingspeak
Summary: ThingSpeak flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-thingspeak
This package contains the ThingSpeak flow module for %{name}. The
module provides flow nodes that interface with ThingSpeak -- a service
that allows publishing data via HTTP, to be consumed by IoT devices.
To use these nodes, one must register and obtain an API key. API keys
for channels and talkbacks are different. For the talkback feature,
obtaining a Talkback ID is also required.

%package flow-module-udev
Summary: Udev flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: udev

%description flow-module-udev
This package contains the udev flow module for %{name}. The module
provides a udev flow node that outputs boolean packets after a devices
are attached or detached on the system.

%package flow-module-unix-socket
Summary: Unix-socket flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-unix-socket
This package contains the unix-socket flow module for %{name}. The
module provides I/O flow nodes that aid on isolating flows by means of
unix sockets.

%package flow-module-update
Summary: Update flow module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-module-update
This package contains the update flow module for %{name}. The module
provides flow nodes that assist on checking availability of, fetching
and installing Soletta-application updates.

%package flow-metatype-module-js
Summary: JavaScript flow metatype module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description flow-metatype-module-js
This package contains the JavaScript flow metatype module for %{name}.
The module a JavaScript metatype for flows, i. e., the possibility of
declaring new node types with the behavior implemented in that
language, directly in .fbp files.

%package pin-mux-module-galileo
Summary: Galileo pin-mux module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description pin-mux-module-galileo
This package contains the galileo pin-mux module for %{name}. The
module provides pin multiplexing rules/mapping for Galileo boards (all
revisions). Without this module, to use Galileo I/O pins with the
desired function, one would have to setup them on their own
beforehand.

%package pin-mux-module-edison
Summary: Edison pin-mux module for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}

%description pin-mux-module-edison
This package contains the edison pin-mux module for %{name}. The
module provides pin multiplexing rules/mapping for Edison boards
(revision C). Without this module, to use Edison I/O pins with the
desired function, one would have to setup them on their own
beforehand.

%package devel
Summary: Header files, libraries and development documentation for %{name}
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: python3 >= 3.4

%description devel
This package contains the header files, static libraries and
development documentation for %{name}. If you like to develop programs
using %{name}, you will need to install %{name}-devel.

# Docs disabled for now because the man-formatted output is not even
# being created yet

# %%package %%{name}-doc
# Summary: Development documentation for %%{name}

# %%description %%{name}-doc
# This package contains the development documentation for %%{name}.

%prep
%setup -qn %{name}-1_%{soletta_tag}
%setup -T -D -a 1 -qn %{name}-1_%{soletta_tag}
%setup -T -D -a 2 -qn %{name}-1_%{soletta_tag}
mv duktape-release-1_%{soletta_duktape_tag}/* src/thirdparty/duktape
mv tinycbor-%{soletta_tinycbor_version}/* src/thirdparty/tinycbor

%build
export LIBDIR=%{_libdir}/
make alldefconfig
sed -i 's/CONFIG_CFLAGS=\"\"/CONFIG_CFLAGS=\"-g\"/g' .config
sed -i 's/_SAMPLES=y/_SAMPLES=n/g' .config
%if 0%{?fedora} <= 23
# Don't bother testing http-server if we won't build it
find ./src/test-fbp/ -type f -print0 | xargs -0 grep -l "http-server" | xargs rm
%endif
make V=1 CFLAGS="$CFLAGS %optflags" LDFLAGS="$LDFLAGS %__global_ldflags" %{?_smp_mflags}

%install
export LIBDIR=%{_libdir}/
make CFLAGS="$CFLAGS %optflags" LDFLAGS="$LDFLAGS %__global_ldflags" %{?_smp_mflags} DESTDIR=%{buildroot} INSTALL="install -p" install

%check
make CFLAGS="$CFLAGS %optflags" LDFLAGS="$LDFLAGS %__global_ldflags" %{?_smp_mflags} check
make CFLAGS="$CFLAGS %optflags" LDFLAGS="$LDFLAGS %__global_ldflags" %{?_smp_mflags} check-fbp
make CFLAGS="$CFLAGS %optflags" LDFLAGS="$LDFLAGS %__global_ldflags" %{?_smp_mflags} check-fbp-bin
make CFLAGS="$CFLAGS %optflags" LDFLAGS="$LDFLAGS %__global_ldflags" %{?_smp_mflags} check-stub

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
# BSD License
%{_libdir}/libsoletta.so.%{soletta_major}
%{_libdir}/libsoletta.so.%{soletta_major}.%{soletta_minor}.%{soletta_build}
%{_bindir}/sol-fbp-runner
%dir %{_datadir}/soletta/
%dir %{_datadir}/soletta/boards
%{_datadir}/soletta/boards/50-default.json
%dir %{_libdir}/soletta/
%dir %{_libdir}/soletta/modules/
%dir %{_libdir}/soletta/modules/flow/
%dir %{_libdir}/soletta/modules/flow-metatype/
%dir %{_libdir}/soletta/modules/pin-mux/
%dir %{_datadir}/soletta/flow/
%dir %{_datadir}/soletta/flow/descriptions/
%dir %{_datadir}/soletta/flow/schemas/
%if 0%{?fedora} < 23
%dir %{_libdir}/soletta/modules/linux-micro/
%{_libdir}/soletta/modules/linux-micro/initial-services
%{_libdir}/soletta/modules/linux-micro/bluetooth.so
%{_libdir}/soletta/modules/linux-micro/console.so
%{_libdir}/soletta/modules/linux-micro/dbus.so
%{_libdir}/soletta/modules/linux-micro/fstab.so
%{_libdir}/soletta/modules/linux-micro/hostname.so
%{_libdir}/soletta/modules/linux-micro/locale.so
%{_libdir}/soletta/modules/linux-micro/machine-id.so
%{_libdir}/soletta/modules/linux-micro/network-up.so
%{_libdir}/soletta/modules/linux-micro/rc-d.so
%{_libdir}/soletta/modules/linux-micro/sysctl.so
%{_libdir}/soletta/modules/linux-micro/watchdog.so
%endif

%license COPYING

%files devel
# BSD License
%{_libdir}/libsoletta.so
%{_bindir}/sol-fbp-generator
%{_bindir}/sol-fbp-to-dot
%{_bindir}/sol-flow-node-type-gen.py
%{_bindir}/sol-flow-node-type-validate.py
%{_bindir}/sol-oic-gen.py
%{_includedir}/soletta/
%{_datadir}/gdb/auto-load/*
%{_libdir}/pkgconfig/soletta.pc
%{_datadir}/soletta/flow/schemas/node-type-genspec.schema
%{_datadir}/soletta/flow/descriptions/aio.json
%{_datadir}/soletta/flow/descriptions/app.json
%{_datadir}/soletta/flow/descriptions/boolean.json
%{_datadir}/soletta/flow/descriptions/byte.json
%{_datadir}/soletta/flow/descriptions/color.json
%{_datadir}/soletta/flow/descriptions/console.json
%{_datadir}/soletta/flow/descriptions/constant.json
%{_datadir}/soletta/flow/descriptions/converter.json
%{_datadir}/soletta/flow/descriptions/filter-repeated.json
%{_datadir}/soletta/flow/descriptions/float.json
%{_datadir}/soletta/flow/descriptions/gpio.json
%{_datadir}/soletta/flow/descriptions/int.json
%{_datadir}/soletta/flow/descriptions/led-7seg.json
%{_datadir}/soletta/flow/descriptions/platform.json
%{_datadir}/soletta/flow/descriptions/pwm.json
%{_datadir}/soletta/flow/descriptions/random.json
%{_datadir}/soletta/flow/descriptions/string.json
%{_datadir}/soletta/flow/descriptions/switcher.json
%{_datadir}/soletta/flow/descriptions/temperature.json
%{_datadir}/soletta/flow/descriptions/timer.json
%{_datadir}/soletta/flow/descriptions/timestamp.json
%{_datadir}/soletta/flow/descriptions/trigonometry.json
%{_datadir}/soletta/flow/descriptions/wallclock.json

%files flow-module-accelerometer
# BSD License
%{_libdir}/soletta/modules/flow/accelerometer.so
%{_datadir}/soletta/flow/descriptions/accelerometer.json

%files flow-module-am2315
# BSD License
%{_libdir}/soletta/modules/flow/am2315.so
%{_datadir}/soletta/flow/descriptions/am2315.json

%files flow-module-calamari
# BSD License
%{_libdir}/soletta/modules/flow/calamari.so
%{_datadir}/soletta/flow/descriptions/calamari.json

%files flow-module-compass
# BSD License
%{_libdir}/soletta/modules/flow/compass.so
%{_datadir}/soletta/flow/descriptions/compass.json

%files flow-module-evdev
# BSD License
%{_libdir}/soletta/modules/flow/evdev.so
%{_datadir}/soletta/flow/descriptions/evdev.json

%files flow-module-file
# BSD License
%{_libdir}/soletta/modules/flow/file.so
%{_datadir}/soletta/flow/descriptions/file.json

%files flow-module-flower-power
# BSD License
%{_libdir}/soletta/modules/flow/flower-power.so
%{_datadir}/soletta/flow/descriptions/flower-power.json

%files flow-module-form
# BSD License
%{_libdir}/soletta/modules/flow/form.so
%{_datadir}/soletta/flow/descriptions/form.json

%files flow-module-grove
# BSD License
%{_libdir}/soletta/modules/flow/grove.so
%{_datadir}/soletta/flow/descriptions/grove.json

%files flow-module-gtk
# BSD License
%{_libdir}/soletta/modules/flow/gtk.so
%{_datadir}/soletta/flow/descriptions/gtk.json

%files flow-module-gyroscope
# BSD License
%{_libdir}/soletta/modules/flow/gyroscope.so
%{_datadir}/soletta/flow/descriptions/gyroscope.json

%files flow-module-http-client
# BSD License
%{_libdir}/soletta/modules/flow/http-client.so
%{_datadir}/soletta/flow/descriptions/http-client.json

%if 0%{?fedora} > 23
%files flow-module-http-server
# BSD License
%{_libdir}/soletta/modules/flow/http-server.so
%{_datadir}/soletta/flow/descriptions/http-server.json
%endif

%files flow-module-iio
# BSD License
%{_libdir}/soletta/modules/flow/iio.so
%{_datadir}/soletta/flow/descriptions/iio.json

%files flow-module-json
# BSD License
%{_libdir}/soletta/modules/flow/json.so
%{_datadir}/soletta/flow/descriptions/json.json

%files flow-module-keyboard
# BSD License
%{_libdir}/soletta/modules/flow/keyboard.so
%{_datadir}/soletta/flow/descriptions/keyboard.json

%files flow-module-mqtt
# BSD License
%{_libdir}/soletta/modules/flow/mqtt.so
%{_datadir}/soletta/flow/descriptions/mqtt.json

%if 0%{?fedora} > 23
%files flow-module-oauth
# BSD License
%{_libdir}/soletta/modules/flow/oauth.so
%{_datadir}/soletta/flow/descriptions/oauth.json
%endif

%files flow-module-power-supply
# BSD License
%{_libdir}/soletta/modules/flow/power-supply.so
%{_datadir}/soletta/flow/descriptions/power-supply.json

%files flow-module-led-strip
# BSD License
%{_libdir}/soletta/modules/flow/led-strip.so
%{_datadir}/soletta/flow/descriptions/led-strip.json

%files flow-module-location
# BSD License
%{_libdir}/soletta/modules/flow/location.so
%{_datadir}/soletta/flow/descriptions/location.json

%files flow-module-magnetometer
# BSD License
%{_libdir}/soletta/modules/flow/magnetometer.so
%{_datadir}/soletta/flow/descriptions/magnetometer.json

%files flow-module-max31855
# BSD License
%{_libdir}/soletta/modules/flow/max31855.so
%{_datadir}/soletta/flow/descriptions/max31855.json

%files flow-module-network
# BSD License
%{_libdir}/soletta/modules/flow/network.so
%{_datadir}/soletta/flow/descriptions/network.json

%files flow-module-oic
# BSD License
%{_libdir}/soletta/modules/flow/oic.so
%{_datadir}/soletta/flow/descriptions/oic.json

%files flow-module-persistence
# BSD License
%{_libdir}/soletta/modules/flow/persistence.so
%{_datadir}/soletta/flow/descriptions/persistence.json

%files flow-module-piezo-speaker
# BSD License
%{_libdir}/soletta/modules/flow/piezo-speaker.so
%{_datadir}/soletta/flow/descriptions/piezo-speaker.json

%files flow-module-process
# BSD License
%{_libdir}/soletta/modules/flow/process.so
%{_datadir}/soletta/flow/descriptions/process.json

%files flow-module-servo-motor
# BSD License
%{_libdir}/soletta/modules/flow/servo-motor.so
%{_datadir}/soletta/flow/descriptions/servo-motor.json

%files flow-module-test
# BSD License
%{_libdir}/soletta/modules/flow/test.so
%{_datadir}/soletta/flow/descriptions/test.json

%files flow-module-thingspeak
# BSD License
%{_libdir}/soletta/modules/flow/thingspeak.so
%{_datadir}/soletta/flow/descriptions/thingspeak.json

%files flow-module-udev
# BSD License
%{_libdir}/soletta/modules/flow/udev.so
%{_datadir}/soletta/flow/descriptions/udev.json

%files flow-module-unix-socket
# BSD License
%{_libdir}/soletta/modules/flow/unix-socket.so
%{_datadir}/soletta/flow/descriptions/unix-socket.json

%files flow-module-update
# BSD License
%{_libdir}/soletta/modules/flow/update.so
%{_datadir}/soletta/flow/descriptions/update.json

%files flow-metatype-module-js
# BSD License
%{_libdir}/soletta/modules/flow-metatype/js.so

%files pin-mux-module-galileo
# BSD License
%{_libdir}/soletta/modules/pin-mux/intel-galileo-rev-d.so
%{_libdir}/soletta/modules/pin-mux/intel-galileo-rev-g.so

%files pin-mux-module-edison
# BSD License
%{_libdir}/soletta/modules/pin-mux/intel-edison-rev-c.so

# TODO: should we generate man pages from doxygen tags?
# %%files %%{name}-doc
# %%doc %%{_mandir}/man3/*

%changelog
* Wed Dec 02 2015 Gustavo Lima Chaves <gustavo.lima.chaves@intel.com> - 0.0.1.beta13-1
- New nodes were added -- http-client/request, http-client/get-json,
  http-client/create-url, oauth/v1, json/create-array-path,
  json/create-object-path, power-supply/get-list,
  power-supply/get-capacity, power-supply/get-info, mqtt/client,
  update/check, update/fetch, update/install.
- HTTP module now supports more HTTP methods
- HTTP server node was removed from the package on Fedora 23, since it
  demands a much newer version of libmicrohttpd than Fedora provides
  (and will ever provide at least on Fedora 23, since systemd also
  depends on it and newer versions change the soname).
- A new packet types was added -- HTTP response.
- The float/int option types were changed -- we now have float/int for
  single numbers of those types and float_spec/int_spec for ranges of
  those types.
- Minor bugfixes of the following modules got in: HTTP, flow, int
  node, build system, memmap-storage, OIC, socket abstraction, random
  numbers engine, CoAP, json node, platform, general use buffer,
  message digest, FBP generator, RIOT I/O, timer node.
- The file sol-pin-mux.h is now installed, as it should be.
- Board pins can now be addressed by a string label, if backed-up by
  their pin-mux modules.
- Thread-safety was added to the RIOT build. Worker threads were
  added to it too. Finally, a crypto backend was added to that system
  too.
- The form family of nodes got a handful of other nodes included:
  form/int, form/int-custom, form/string.
- The linux-micro module got gdb-server support, to be used to debug
  Soletta when running as PID1. It also got two new modules: kmod and
  automount.
- The persistence module was changed to an asynchronous implementation.
- OIC client nodes got a new SCAN port, meant to request scanning of
  all servers matching the client interface. A new DEVICE_ID output
  port was also added, that will dispatch the found IDs in that
  scanning request.
- The dummy platform implementation was removed.
- The platform modules got a new mount points manipulation API, as
  well as a uevent listening one (for Linux).
- All of our public API with ambiguous int sizes were made explicity
  with regards to size (e.g. int32_t).
- An API exposing power supply properties was added to Soletta.
- An API dealing with certificates was added to Soletta.
- MQTT in Soletta got TLS connections support.
- JavaScript code on FBP files now recognize all Soletta package
  types.
- A new root module was added to Soletta: update. It controls how
  Soletta apps will be updated.

* Mon Oct 26 2015 Gustavo Lima Chaves <gustavo.lima.chaves@intel.com> - 0.0.1.beta10-1
- Bump Soletta version to 0.0.1.beta10
- Fix RPM spec to sign bundled packages tinycbor and duktape
- Fix RPM package naming
- Add new flow-module: form
- The json module got a ton of new features and nodes
- string/concatenate node now supports mulitple inputs (up to 23)
- and/or logic nodes now accept multiple (up to 32) input connections
- The int module nodes now send new output packets on input changes
- Multicast packets are now sent to all machine interfaces
- The HTTP server node got some fixes, like recognizing more header fields
- The float/map node got a fix that led to bad conversions on ARM machines
- The form module got a new node: the boolean form.
- Legacy tool sol-flow-node types is now gone.
- file/writer node got some bad data access errors fixed.

* Tue Oct 20 2015 Gustavo Lima Chaves <gustavo.lima.chaves@intel.com> - 0.0.1.beta8-1
- first rpm build
