/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.schemas;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.identity.AbstractParty;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.schemas.PersistentState;
import net.corda.core.serialization.CordaSerializable;
import net.corda.finance.schemas.CashSchema;
import org.hibernate.annotations.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lnet/corda/finance/schemas/CashSchemaV1;", "Lnet/corda/core/schemas/MappedSchema;", "()V", "migrationResource", "", "getMigrationResource", "()Ljava/lang/String;", "PersistentCashState", "contracts"})
public final class CashSchemaV1
extends MappedSchema {
    @NotNull
    private static final String migrationResource = "cash.changelog-master";
    public static final CashSchemaV1 INSTANCE;

    @NotNull
    public String getMigrationResource() {
        return migrationResource;
    }

    private CashSchemaV1() {
        super(CashSchema.INSTANCE.getClass(), 1, (Iterable)CollectionsKt.listOf(PersistentCashState.class));
    }

    static {
        CashSchemaV1 cashSchemaV1;
        INSTANCE = cashSchemaV1 = new CashSchemaV1();
        migrationResource = migrationResource;
    }

    @Entity
    @Table(name="contract_cash_states", indexes={@Index(columnList="ccy_code", name="ccy_code_idx"), @Index(columnList="pennies", name="pennies_idx")})
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0014\b\u0017\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u001e\u0010\u0006\u001a\u00020\u00078\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\b\u001a\u00020\u00078\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001e\u0010\t\u001a\u00020\n8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R \u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u0004\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lnet/corda/finance/schemas/CashSchemaV1$PersistentCashState;", "Lnet/corda/core/schemas/PersistentState;", "owner", "Lnet/corda/core/identity/AbstractParty;", "pennies", "", "currency", "", "issuerPartyHash", "issuerRef", "", "(Lnet/corda/core/identity/AbstractParty;JLjava/lang/String;Ljava/lang/String;[B)V", "getCurrency", "()Ljava/lang/String;", "setCurrency", "(Ljava/lang/String;)V", "getIssuerPartyHash", "setIssuerPartyHash", "getIssuerRef", "()[B", "setIssuerRef", "([B)V", "getOwner", "()Lnet/corda/core/identity/AbstractParty;", "setOwner", "(Lnet/corda/core/identity/AbstractParty;)V", "getPennies", "()J", "setPennies", "(J)V", "contracts"})
    public static class PersistentCashState
    extends PersistentState {
        @Column(name="owner_name", nullable=true)
        @Nullable
        private AbstractParty owner;
        @Column(name="pennies", nullable=false)
        private long pennies;
        @Column(name="ccy_code", length=3, nullable=false)
        @NotNull
        private String currency;
        @Column(name="issuer_key_hash", length=130, nullable=false)
        @NotNull
        private String issuerPartyHash;
        @Column(name="issuer_ref", length=512, nullable=false)
        @Type(type="corda-wrapper-binary")
        @NotNull
        private byte[] issuerRef;

        @Nullable
        public AbstractParty getOwner() {
            return this.owner;
        }

        public void setOwner(@Nullable AbstractParty abstractParty) {
            this.owner = abstractParty;
        }

        public long getPennies() {
            return this.pennies;
        }

        public void setPennies(long l) {
            this.pennies = l;
        }

        @NotNull
        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.currency = string;
        }

        @NotNull
        public String getIssuerPartyHash() {
            return this.issuerPartyHash;
        }

        public void setIssuerPartyHash(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.issuerPartyHash = string;
        }

        @NotNull
        public byte[] getIssuerRef() {
            return this.issuerRef;
        }

        public void setIssuerRef(@NotNull byte[] byArray) {
            Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
            this.issuerRef = byArray;
        }

        public PersistentCashState(@Nullable AbstractParty owner, long pennies, @NotNull String currency, @NotNull String issuerPartyHash, @NotNull byte[] issuerRef) {
            Intrinsics.checkParameterIsNotNull((Object)currency, (String)"currency");
            Intrinsics.checkParameterIsNotNull((Object)issuerPartyHash, (String)"issuerPartyHash");
            Intrinsics.checkParameterIsNotNull((Object)issuerRef, (String)"issuerRef");
            super(null, 1, null);
            this.owner = owner;
            this.pennies = pennies;
            this.currency = currency;
            this.issuerPartyHash = issuerPartyHash;
            this.issuerRef = issuerRef;
        }

        public PersistentCashState() {
        }
    }
}

