/*
 * Decompiled with CFR 0.152.
 */
package net.corda.bank;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Currency;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.bank.IssueCash$WhenMappings;
import net.corda.bank.api.BankOfCordaClientApi;
import net.corda.bank.api.BankOfCordaWebApi;
import net.corda.core.contracts.Amount;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.transactions.SignedTransaction;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.testing.core.TestConstants;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u001b\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0016\u0010\u001a\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/corda/bank/IssueCash;", "", "()V", "BIGCORP_NAME", "Lnet/corda/core/identity/CordaX500Name;", "BOC_RPC_PORT", "", "BOC_WEB_PORT", "NOTARY_NAME", "createParams", "Lnet/corda/bank/api/BankOfCordaWebApi$IssueRequestParams;", "amount", "Lnet/corda/core/contracts/Amount;", "Ljava/util/Currency;", "notaryName", "main", "", "args", "", "", "([Ljava/lang/String;)V", "printHelp", "parser", "Ljoptsimple/OptionParser;", "requestRpcIssue", "Lnet/corda/core/transactions/SignedTransaction;", "requestWebIssue", "Role", "bank-of-corda-demo"})
public final class IssueCash {
    private static final CordaX500Name NOTARY_NAME;
    private static final CordaX500Name BIGCORP_NAME;
    private static final int BOC_RPC_PORT = 10006;
    private static final int BOC_WEB_PORT = 10007;
    public static final IssueCash INSTANCE;

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        OptionSet optionSet;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec roleArg = parser.accepts("role").withRequiredArg().ofType(Role.class).describedAs("[ISSUER|ISSUE_CASH_RPC|ISSUE_CASH_WEB]");
        ArgumentAcceptingOptionSpec quantity = parser.accepts("quantity").withOptionalArg().ofType(Long.TYPE);
        ArgumentAcceptingOptionSpec currency = parser.accepts("currency").withOptionalArg().ofType(String.class).describedAs("[GBP|USD|CHF|EUR]");
        try {
            optionSet = parser.parse(Arrays.copyOf(args, args.length));
        }
        catch (Exception e) {
            String string = e.getMessage();
            System.out.println((Object)string);
            INSTANCE.printHelp(parser);
            int n = 1;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        OptionSet options = optionSet;
        Object object = options.valueOf((OptionSpec)roleArg);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Role role = (Role)((Object)object);
        Object object2 = options.valueOf((OptionSpec)quantity);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"options.valueOf(quantity)");
        Amount amount = new Amount(((Number)object2).longValue(), (Object)Currency.getInstance((String)options.valueOf((OptionSpec)currency)));
        switch (IssueCash$WhenMappings.$EnumSwitchMapping$0[role.ordinal()]) {
            case 1: {
                String string = "Requesting Cash via RPC ...";
                System.out.println((Object)string);
                SignedTransaction result = INSTANCE.requestRpcIssue((Amount<Currency>)amount);
                String string2 = "Success!! Your transaction receipt is " + result.getTx().getId();
                System.out.println((Object)string2);
                break;
            }
            case 2: {
                String string = "Requesting Cash via Web ...";
                System.out.println((Object)string);
                INSTANCE.requestWebIssue((Amount<Currency>)amount);
                string = "Successfully processed Cash Issue request";
                System.out.println((Object)string);
            }
        }
    }

    @NotNull
    public final SignedTransaction requestRpcIssue(@NotNull Amount<Currency> amount) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        return BankOfCordaClientApi.INSTANCE.requestRPCIssue(new NetworkHostAndPort("localhost", 10006), this.createParams(amount, NOTARY_NAME));
    }

    private final void requestWebIssue(Amount<Currency> amount) {
        BankOfCordaClientApi.INSTANCE.requestWebIssue(new NetworkHostAndPort("localhost", 10007), this.createParams(amount, NOTARY_NAME));
    }

    private final BankOfCordaWebApi.IssueRequestParams createParams(Amount<Currency> amount, CordaX500Name notaryName) {
        return new BankOfCordaWebApi.IssueRequestParams(amount, BIGCORP_NAME, "1", TestConstants.BOC_NAME, notaryName);
    }

    private final void printHelp(OptionParser parser) {
        String string = StringsKt.trimIndent((String)"\n        Usage: bank-of-corda --role ISSUER\n               bank-of-corda --role (ISSUE_CASH_RPC|ISSUE_CASH_WEB) --quantity <quantity> --currency <currency>\n         Please refer to the documentation in docs/build/index.html for more info.\n         ");
        System.out.println((Object)string);
        parser.printHelpOn((OutputStream)System.out);
    }

    private IssueCash() {
    }

    static {
        IssueCash issueCash;
        INSTANCE = issueCash = new IssueCash();
        NOTARY_NAME = new CordaX500Name("Notary Service", "Zurich", "CH");
        BIGCORP_NAME = new CordaX500Name("BigCorporation", "New York", "US");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/bank/IssueCash$Role;", "", "(Ljava/lang/String;I)V", "ISSUE_CASH_RPC", "ISSUE_CASH_WEB", "bank-of-corda-demo"})
    public static final class Role
    extends Enum<Role> {
        public static final /* enum */ Role ISSUE_CASH_RPC;
        public static final /* enum */ Role ISSUE_CASH_WEB;
        private static final /* synthetic */ Role[] $VALUES;

        static {
            Role[] roleArray = new Role[2];
            Role[] roleArray2 = roleArray;
            roleArray[0] = ISSUE_CASH_RPC = new Role();
            roleArray[1] = ISSUE_CASH_WEB = new Role();
            $VALUES = roleArray;
        }

        public static Role[] values() {
            return (Role[])$VALUES.clone();
        }

        public static Role valueOf(String string) {
            return Enum.valueOf(Role.class, string);
        }
    }
}

