/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.concurrent.util.ConcurrentSkipListPriorityQueue;
import co.paralleluniverse.concurrent.util.SingleConsumerNonblockingProducerQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class SingleConsumerNonblockingProducerDelayQueue<E extends Delayed>
extends SingleConsumerNonblockingProducerQueue<E> {
    public SingleConsumerNonblockingProducerDelayQueue() {
        super(new ConcurrentSkipListPriorityQueue());
    }

    @Override
    public E poll() {
        Delayed first = (Delayed)this.peek();
        if (first == null || !this.isExpired(first)) {
            return null;
        }
        return (E)((Delayed)super.poll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        Delayed e = (Delayed)this.q.peek();
        if (e == null || this.getDelay(e) > 0L) {
            this.sync.register();
            try {
                e = (Delayed)this.q.peek();
                long delayNanos = this.getDelay(e);
                while (delayNanos > 0L) {
                    this.sync.awaitNanos(delayNanos);
                    e = (Delayed)this.q.peek();
                    delayNanos = this.getDelay(e);
                }
                Delayed delayed = (Delayed)this.q.poll();
                return (E)delayed;
            }
            finally {
                this.sync.unregister();
            }
        }
        e = (Delayed)this.q.poll();
        assert (e != null);
        return (E)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Delayed e = (Delayed)this.q.peek();
        if (e == null || this.getDelay(e) > 0L) {
            long left = unit.toNanos(timeout);
            this.sync.register();
            try {
                e = (Delayed)this.q.peek();
                long delayNanos = this.getDelay(e);
                while (left > 0L & delayNanos > 0L) {
                    left = this.sync.awaitNanos(Math.min(left, delayNanos));
                    e = (Delayed)this.q.peek();
                    delayNanos = this.getDelay(e);
                }
                Delayed delayed = delayNanos > 0L ? null : (Delayed)this.q.poll();
                return (E)delayed;
            }
            finally {
                this.sync.unregister();
            }
        }
        e = (Delayed)this.q.poll();
        assert (e != null);
        return (E)e;
    }

    private long getDelay(E e) {
        return e != null ? e.getDelay(TimeUnit.NANOSECONDS) : Long.MAX_VALUE;
    }

    protected boolean isExpired(E e) {
        return e.getDelay(TimeUnit.NANOSECONDS) <= 0L;
    }
}

