/*
 * This file is part of WebGoat, an Open Web Application Security Project utility. For details, please see http://www.owasp.org/
 *
 * Copyright (c) 2002 - 2019 Bruce Mayhew
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if
 * not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Getting Source ==============
 *
 * Source for this application is maintained at https://github.com/WebGoat/WebGoat, a repository for free software projects.
 */

package org.owasp.webgoat.idor;

import org.owasp.webgoat.assignments.AssignmentEndpoint;
import org.owasp.webgoat.assignments.AssignmentHints;
import org.owasp.webgoat.assignments.AttackResult;

import org.owasp.webgoat.session.UserSessionData;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@RestController
@AssignmentHints({"idor.hints.idor_login"})
public class IDORLogin extends AssignmentEndpoint {

    private Map<String, Map<String, String>> idorUserInfo = new HashMap<>();

    public void initIDORInfo() {

        idorUserInfo.put("tom", new HashMap<String, String>());
        idorUserInfo.get("tom").put("password", "cat");
        idorUserInfo.get("tom").put("id", "2342384");
        idorUserInfo.get("tom").put("color", "yellow");
        idorUserInfo.get("tom").put("size", "small");

        idorUserInfo.put("bill", new HashMap<String, String>());
        idorUserInfo.get("bill").put("password", "buffalo");
        idorUserInfo.get("bill").put("id", "2342388");
        idorUserInfo.get("bill").put("color", "brown");
        idorUserInfo.get("bill").put("size", "large");

    }

    @PostMapping("/IDOR/login")
    @ResponseBody
    public AttackResult completed(@RequestParam String username, @RequestParam String password) {
        initIDORInfo();
        UserSessionData userSessionData = getUserSessionData();

        if (idorUserInfo.containsKey(username)) {
            if ("tom".equals(username) && idorUserInfo.get("tom").get("password").equals(password)) {
                userSessionData.setValue("idor-authenticated-as", username);
                userSessionData.setValue("idor-authenticated-user-id", idorUserInfo.get(username).get("id"));
                return success(this).feedback("idor.login.success").feedbackArgs(username).build();
            } else {
                return failed(this).feedback("idor.login.failure").build();
            }
        } else {
            return failed(this).feedback("idor.login.failure").build();
        }
    }
}
