package rules

import data.rules.deny

import data.lib

is_kind(kind) {
	input.kind == kind
}

services[service] {
	is_kind("Service")
	service = input
}

is_clusterIP_service_type(service) {
	not lib.has_field(service.spec, "type")
} else {
	service.spec.type == "ClusterIP"
}

service_has_externalIPs(service) {
	lib.has_field(service.spec, "externalIPs")
	externalIPs := service.spec.externalIPs
	not is_null(externalIPs)
	count(externalIPs) > 0
}
