/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class WriterOutputStream
extends OutputStream {
    private final Writer writer;
    private boolean isOpen = true;
    private CharsetDecoder decoder;

    public WriterOutputStream(Writer writer) {
        this(writer, null);
    }

    public WriterOutputStream(Writer writer, String encoding) {
        this.writer = writer;
        if (encoding == null && writer instanceof OutputStreamWriter) {
            encoding = ((OutputStreamWriter)writer).getEncoding();
        }
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        } else if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException(encoding + " is not supported");
        }
        this.decoder = Charset.forName(encoding).newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Writer writer = this.writer;
        synchronized (writer) {
            if (!this.isOpen) {
                throw new IOException("This stream has been already closed.");
            }
            this.isOpen = false;
            this.decoder = null;
            this.writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Writer writer = this.writer;
        synchronized (writer) {
            if (!this.isOpen) {
                return;
            }
            this.writer.flush();
        }
    }

    public void write(int b) throws IOException {
        byte[] bb = new byte[]{(byte)b};
        this.write(bb, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Writer writer = this.writer;
        synchronized (writer) {
            if (!this.isOpen) {
                return;
            }
            if (off < 0 || len <= 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            ByteBuffer bytes = ByteBuffer.wrap(b, off, len);
            CharBuffer chars = CharBuffer.allocate(len);
            this.byte2char(bytes, chars);
            char[] cbuf = new char[chars.length()];
            chars.get(cbuf, 0, chars.length());
            this.writer.write(cbuf);
            this.writer.flush();
        }
    }

    private void byte2char(ByteBuffer bytes, CharBuffer chars) throws IOException {
        this.decoder.reset();
        chars.clear();
        CoderResult result = this.decoder.decode(bytes, chars, true);
        if (result.isError() || result.isOverflow()) {
            throw new IOException(result.toString());
        }
        if (result.isUnderflow()) {
            chars.flip();
        }
    }
}

