/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.PrintWriter;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedEvalUnitImpl
implements EmbedEvalUnit {
    private ScriptingContainer container;
    private Node node;
    private ManyVarsDynamicScope scope;
    private Script script;

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope) {
        this(container, node, scope, null);
    }

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope, Script script) {
        this.container = container;
        this.node = node;
        this.scope = scope;
        this.script = script;
    }

    public Node getNode() {
        return this.node;
    }

    public ManyVarsDynamicScope getScope() {
        return this.scope;
    }

    public IRubyObject run() {
        if (this.node == null && this.script == null) {
            return null;
        }
        BiVariableMap vars = this.container.getVarMap();
        try {
            vars.inject(this.scope, 0, null);
            this.container.getRuntime().getCurrentContext().pushScope((DynamicScope)this.scope);
            RubyInstanceConfig.CompileMode mode = this.container.getRuntime().getInstanceConfig().getCompileMode();
            IRubyObject ret = mode == RubyInstanceConfig.CompileMode.FORCE || mode == RubyInstanceConfig.CompileMode.JIT ? this.container.getRuntime().runScript(this.script) : this.container.getRuntime().runInterpreter(this.node);
            vars.retrieve(ret);
            IRubyObject iRubyObject = ret;
            return iRubyObject;
        }
        catch (RaiseException e) {
            e.printStackTrace();
            RubyException re = e.getException();
            this.container.getRuntime().printError(re);
            throw new RuntimeException(e);
        }
        catch (StackOverflowError soe) {
            throw this.container.getRuntime().newSystemStackError("stack level too deep", soe);
        }
        catch (Exception e) {
            PrintWriter w = (PrintWriter)this.container.getErrorWriter();
            e.printStackTrace(w);
            w.write(e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.container.getRuntime().getCurrentContext().popScope();
            JavaEmbedUtils.terminate((Ruby)this.container.getRuntime());
            vars.terminate();
        }
    }
}

