/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.jruby.Ruby;
import org.jruby.RubyGlobal;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyNil;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyObjectAdapter;
import org.jruby.embed.EmbedRubyRuntimeAdapter;
import org.jruby.embed.LocalContextProvider;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PathType;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.EmbedRubyObjectAdapterImpl;
import org.jruby.embed.internal.EmbedRubyRuntimeAdapterImpl;
import org.jruby.embed.internal.SingleThreadLocalContextProvider;
import org.jruby.embed.internal.SingletonLocalContextProvider;
import org.jruby.embed.internal.ThreadSafeLocalContextProvider;
import org.jruby.embed.io.ReaderInputStream;
import org.jruby.embed.io.WriterOutputStream;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingContainer {
    private static final String defaultProps = "org/jruby/embed/jruby-embed.properties";
    private final Map<String, String[]> properties;
    private LocalContextProvider provider = null;
    private EmbedRubyRuntimeAdapter runtimeAdapter = new EmbedRubyRuntimeAdapterImpl(this);
    private EmbedRubyObjectAdapter objectAdapter = new EmbedRubyObjectAdapterImpl(this);

    public ScriptingContainer() {
        this(LocalContextScope.THREADSAFE, LocalVariableBehavior.TRANSIENT, defaultProps);
    }

    public ScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT, defaultProps);
    }

    public ScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.THREADSAFE, behavior, defaultProps);
    }

    public ScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, defaultProps);
    }

    public ScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, String propertyname) {
        this.provider = this.getProviderInstance(scope, behavior);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        this.properties = Collections.unmodifiableMap(map);
        if (propertyname == null || propertyname.length() == 0) {
            return;
        }
        this.prepareProperties(propertyname, map);
        try {
            SystemPropertyCatcher.setJRubyHome(this);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private LocalContextProvider getProviderInstance(LocalContextScope scope, LocalVariableBehavior behavior) {
        switch (scope) {
            case SINGLETON: {
                return new SingletonLocalContextProvider(behavior);
            }
            case SINGLETHREAD: {
                return new SingleThreadLocalContextProvider(behavior);
            }
        }
        return new ThreadSafeLocalContextProvider(behavior);
    }

    private void prepareProperties(String propertyname, Map<String, String[]> map) {
        try {
            PropertyResourceBundle resource = new PropertyResourceBundle(this.getClass().getClassLoader().getResourceAsStream(propertyname));
            Enumeration<String> keys = resource.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String[] values = resource.getString(key).split(",\\s*");
                for (int i = 0; i < values.length; ++i) {
                    values[i] = values[i].trim();
                }
                map.put(key, values);
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String[] getProperty(String key) {
        return this.properties.get(key);
    }

    public String getSupportedRubyVersion() {
        Ruby ruby = this.getRuntime();
        RubyInstanceConfig config = ruby.getInstanceConfig();
        return config.getVersionString().trim();
    }

    public LocalContextProvider getProvider() {
        return this.provider;
    }

    public Ruby getRuntime() {
        return this.provider.getRuntime();
    }

    public BiVariableMap getVarMap() {
        return this.provider.getVarMap();
    }

    public Map getAttributeMap() {
        return this.provider.getAttributeMap();
    }

    public Object getAttribute(Object key) {
        return this.provider.getAttributeMap().get(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.provider.getAttributeMap().put(key, value);
    }

    public Object get(String key) {
        return this.provider.getVarMap().get(key);
    }

    public Object put(String key, Object value) {
        return this.provider.getVarMap().put(key, value);
    }

    public EmbedEvalUnit parse(String script, int ... lines) {
        return this.runtimeAdapter.parse(script, lines);
    }

    public EmbedEvalUnit parse(Reader reader, String filename, int ... lines) {
        return this.runtimeAdapter.parse(reader, filename, lines);
    }

    public EmbedEvalUnit parse(PathType type, String filename, int ... lines) {
        return this.runtimeAdapter.parse(type, filename, lines);
    }

    public EmbedEvalUnit parse(InputStream istream, String filename, int ... lines) {
        return this.runtimeAdapter.parse(istream, filename, lines);
    }

    public Object runScriptlet(String script) {
        EmbedEvalUnit node = this.parse(script, new int[0]);
        IRubyObject ret = node.run();
        return JavaEmbedUtils.rubyToJava((IRubyObject)ret);
    }

    public Object runScriptlet(Reader reader, String filename) {
        EmbedEvalUnit node = this.parse(reader, filename, new int[0]);
        IRubyObject ret = node.run();
        return JavaEmbedUtils.rubyToJava((IRubyObject)ret);
    }

    public Object runScriptlet(InputStream istream, String filename) {
        EmbedEvalUnit node = this.parse(istream, filename, new int[0]);
        IRubyObject ret = node.run();
        return JavaEmbedUtils.rubyToJava((IRubyObject)ret);
    }

    public Object runScriptlet(PathType type, String filename) {
        EmbedEvalUnit node = this.parse(type, filename, new int[0]);
        IRubyObject ret = node.run();
        return JavaEmbedUtils.rubyToJava((IRubyObject)ret);
    }

    public EmbedRubyRuntimeAdapter newRuntimeAdapter() {
        return this.runtimeAdapter;
    }

    public EmbedRubyObjectAdapter newObjectAdapter() {
        return this.objectAdapter;
    }

    public <T> T callMethod(Object receiver, String methodName, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver, methodName, returnType);
    }

    public <T> T callMethod(Object receiver, String methodName, Object singleArg, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver, methodName, singleArg, returnType);
    }

    public <T> T callMethod(Object receiver, String methodName, Object[] args, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver, methodName, args, returnType);
    }

    public <T> T callMethod(Object receiver, String methodName, Object[] args, Block block, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver, methodName, args, block, returnType);
    }

    public <T> T callMethod(Object receiver, String methodName, Class<T> returnType, EmbedEvalUnit unit) {
        return this.objectAdapter.callMethod(receiver, methodName, returnType, unit);
    }

    public <T> T callMethod(Object receiver, String methodName, Object[] args, Class<T> returnType, EmbedEvalUnit unit) {
        return this.objectAdapter.callMethod(receiver, methodName, args, returnType, unit);
    }

    public <T> T callMethod(Object receiver, String methodName, Object[] args, Block block, Class<T> returnType, EmbedEvalUnit unit) {
        return this.objectAdapter.callMethod(receiver, methodName, args, block, returnType, unit);
    }

    public <T> T callSuper(Object receiver, Object[] args, Class<T> returnType) {
        return this.objectAdapter.callSuper(receiver, args, returnType);
    }

    public <T> T callSuper(Object receiver, Object[] args, Block block, Class<T> returnType) {
        return this.objectAdapter.callSuper(receiver, args, block, returnType);
    }

    public <T> T getInstance(Object receiver, Class<T> clazz) {
        Object o;
        if (!clazz.isInterface()) {
            return null;
        }
        Ruby runtime = this.getRuntime();
        if (receiver == null || receiver instanceof RubyNil) {
            o = JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)runtime.getTopSelf(), clazz);
        } else if (receiver instanceof IRubyObject) {
            o = JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)((IRubyObject)receiver), clazz);
        } else {
            IRubyObject rubyReceiver = JavaUtil.convertJavaToRuby((Ruby)runtime, (Object)receiver);
            o = JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)rubyReceiver, clazz);
        }
        String name = clazz.getName();
        try {
            Class<?> c = Class.forName(name, true, o.getClass().getClassLoader());
            return (T)c.cast(o);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setReader(Reader reader) {
        Reader old;
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.READER) && (old = (Reader)map.get((Object)AttributeName.READER)) == reader) {
            return;
        }
        map.put(AttributeName.READER, reader);
        ReaderInputStream istream = new ReaderInputStream(reader);
        Ruby runtime = this.getRuntime();
        RubyIO io = new RubyIO(runtime, (InputStream)istream);
        io.getOpenFile().getMainStream().setSync(true);
        runtime.defineVariable((GlobalVariable)new RubyGlobal.InputGlobalVariable(runtime, "$stdin", (IRubyObject)io));
        runtime.defineGlobalConstant("STDIN", (IRubyObject)io);
    }

    public Reader getReader() {
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.READER)) {
            return (Reader)this.getAttributeMap().get((Object)AttributeName.READER);
        }
        return null;
    }

    public InputStream getIn() {
        return this.getRuntime().getIn();
    }

    public void setWriter(Writer writer) {
        Writer old;
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.WRITER) && (old = (Writer)map.get((Object)AttributeName.WRITER)) == writer) {
            return;
        }
        map.put(AttributeName.WRITER, writer);
        PrintStream pstream = new PrintStream(new WriterOutputStream(writer));
        this.setOutputStream(pstream);
    }

    private void setOutputStream(PrintStream pstream) {
        Ruby runtime = this.getRuntime();
        RubyIO io = new RubyIO(runtime, (OutputStream)pstream);
        io.getOpenFile().getMainStream().setSync(true);
        this.gulpWarning();
        runtime.defineVariable((GlobalVariable)new RubyGlobal.OutputGlobalVariable(runtime, "$stdout", (IRubyObject)io));
        runtime.defineGlobalConstant("STDOUT", (IRubyObject)io);
        runtime.getGlobalVariables().alias("$>", "$stdout");
        runtime.getGlobalVariables().alias("$defout", "$stdout");
        this.revertWarning();
    }

    public void resetWriter() {
        PrintStream pstream = this.provider.getRubyInstanceConfig().getOutput();
        this.setOutputStream(pstream);
    }

    public Writer getWriter() {
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.WRITER)) {
            return (Writer)this.getAttributeMap().get((Object)AttributeName.WRITER);
        }
        return null;
    }

    public PrintStream getOut() {
        return this.getRuntime().getOut();
    }

    public void setErrorWriter(Writer errorWriter) {
        Writer old;
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.ERROR_WRITER) && (old = (Writer)map.get((Object)AttributeName.ERROR_WRITER)) == errorWriter) {
            return;
        }
        map.put(AttributeName.ERROR_WRITER, errorWriter);
        PrintStream pstream = new PrintStream(new WriterOutputStream(errorWriter));
        this.setErrorStream(pstream);
    }

    private void setErrorStream(PrintStream error) {
        Ruby runtime = this.getRuntime();
        RubyIO io = new RubyIO(runtime, (OutputStream)error);
        io.getOpenFile().getMainStream().setSync(true);
        runtime.defineVariable((GlobalVariable)new RubyGlobal.OutputGlobalVariable(runtime, "$stderr", (IRubyObject)io));
        runtime.defineGlobalConstant("STDERR", (IRubyObject)io);
        runtime.getGlobalVariables().alias("$deferr", "$stderr");
    }

    public void resetErrorWriter() {
        PrintStream error = this.provider.getRubyInstanceConfig().getError();
        this.setErrorStream(error);
    }

    public Writer getErrorWriter() {
        Map map = this.getAttributeMap();
        if (map.containsKey((Object)AttributeName.ERROR_WRITER)) {
            return (Writer)this.getAttributeMap().get((Object)AttributeName.ERROR_WRITER);
        }
        return null;
    }

    public PrintStream getErr() {
        return this.getRuntime().getErr();
    }

    private void gulpWarning() {
        Boolean gulping = true;
        Object obj = this.getAttribute((Object)AttributeName.WARNING_GULPING);
        if (obj != null && obj instanceof Boolean) {
            gulping = (Boolean)obj;
        }
        if (!gulping.booleanValue()) {
            return;
        }
        RubyIO dummy_io = new RubyIO(this.getRuntime(), (OutputStream)new PrintStream(new WriterOutputStream(new StringWriter())));
        this.getRuntime().getGlobalVariables().set("$stderr", (IRubyObject)dummy_io);
    }

    private void revertWarning() {
        Writer errorWriter;
        Boolean gulping = true;
        Object obj = this.getAttribute((Object)AttributeName.WARNING_GULPING);
        if (obj != null && obj instanceof Boolean) {
            gulping = (Boolean)obj;
        }
        if (!gulping.booleanValue()) {
            return;
        }
        Map map = this.getAttributeMap();
        PrintStream pstream = null;
        if (map.containsKey((Object)AttributeName.ERROR_WRITER) && (errorWriter = (Writer)map.get((Object)AttributeName.ERROR_WRITER)) != null) {
            pstream = new PrintStream(new WriterOutputStream(errorWriter));
        }
        if (pstream == null) {
            pstream = new PrintStream(System.err);
        }
        RubyIO error_io = new RubyIO(this.getRuntime(), (OutputStream)pstream);
        this.getRuntime().getGlobalVariables().set("$stderr", (IRubyObject)error_io);
    }
}

