/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.util;

import java.util.ArrayList;
import java.util.Stack;
import org.jgrapht.util.FibonacciHeapNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FibonacciHeap<T> {
    private FibonacciHeapNode<T> minNode;
    private int nNodes;

    public boolean isEmpty() {
        return this.minNode == null;
    }

    public void clear() {
        this.minNode = null;
        this.nNodes = 0;
    }

    public void decreaseKey(FibonacciHeapNode<T> fibonacciHeapNode, double d) {
        if (d > fibonacciHeapNode.key) {
            throw new IllegalArgumentException("decreaseKey() got larger key value");
        }
        fibonacciHeapNode.key = d;
        FibonacciHeapNode fibonacciHeapNode2 = fibonacciHeapNode.parent;
        if (fibonacciHeapNode2 != null && fibonacciHeapNode.key < fibonacciHeapNode2.key) {
            this.cut(fibonacciHeapNode, fibonacciHeapNode2);
            this.cascadingCut(fibonacciHeapNode2);
        }
        if (fibonacciHeapNode.key < this.minNode.key) {
            this.minNode = fibonacciHeapNode;
        }
    }

    public void delete(FibonacciHeapNode<T> fibonacciHeapNode) {
        this.decreaseKey(fibonacciHeapNode, Double.NEGATIVE_INFINITY);
        this.removeMin();
    }

    public void insert(FibonacciHeapNode<T> fibonacciHeapNode, double d) {
        fibonacciHeapNode.key = d;
        if (this.minNode != null) {
            fibonacciHeapNode.left = this.minNode;
            fibonacciHeapNode.right = this.minNode.right;
            this.minNode.right = fibonacciHeapNode;
            fibonacciHeapNode.right.left = fibonacciHeapNode;
            if (d < this.minNode.key) {
                this.minNode = fibonacciHeapNode;
            }
        } else {
            this.minNode = fibonacciHeapNode;
        }
        ++this.nNodes;
    }

    public FibonacciHeapNode<T> min() {
        return this.minNode;
    }

    public FibonacciHeapNode<T> removeMin() {
        FibonacciHeapNode<T> fibonacciHeapNode = this.minNode;
        if (fibonacciHeapNode != null) {
            FibonacciHeapNode fibonacciHeapNode2 = fibonacciHeapNode.child;
            for (int i = fibonacciHeapNode.degree; i > 0; --i) {
                FibonacciHeapNode fibonacciHeapNode3 = fibonacciHeapNode2.right;
                fibonacciHeapNode2.left.right = fibonacciHeapNode2.right;
                fibonacciHeapNode2.right.left = fibonacciHeapNode2.left;
                fibonacciHeapNode2.left = this.minNode;
                fibonacciHeapNode2.right = this.minNode.right;
                this.minNode.right = fibonacciHeapNode2;
                fibonacciHeapNode2.right.left = fibonacciHeapNode2;
                fibonacciHeapNode2.parent = null;
                fibonacciHeapNode2 = fibonacciHeapNode3;
            }
            fibonacciHeapNode.left.right = fibonacciHeapNode.right;
            fibonacciHeapNode.right.left = fibonacciHeapNode.left;
            if (fibonacciHeapNode == fibonacciHeapNode.right) {
                this.minNode = null;
            } else {
                this.minNode = fibonacciHeapNode.right;
                this.consolidate();
            }
            --this.nNodes;
        }
        return fibonacciHeapNode;
    }

    public int size() {
        return this.nNodes;
    }

    public static <T> FibonacciHeap<T> union(FibonacciHeap<T> fibonacciHeap, FibonacciHeap<T> fibonacciHeap2) {
        FibonacciHeap<T> fibonacciHeap3 = new FibonacciHeap<T>();
        if (fibonacciHeap != null && fibonacciHeap2 != null) {
            fibonacciHeap3.minNode = fibonacciHeap.minNode;
            if (fibonacciHeap3.minNode != null) {
                if (fibonacciHeap2.minNode != null) {
                    fibonacciHeap3.minNode.right.left = fibonacciHeap2.minNode.left;
                    fibonacciHeap2.minNode.left.right = fibonacciHeap3.minNode.right;
                    fibonacciHeap3.minNode.right = fibonacciHeap2.minNode;
                    fibonacciHeap2.minNode.left = fibonacciHeap3.minNode;
                    if (fibonacciHeap2.minNode.key < fibonacciHeap.minNode.key) {
                        fibonacciHeap3.minNode = fibonacciHeap2.minNode;
                    }
                }
            } else {
                fibonacciHeap3.minNode = fibonacciHeap2.minNode;
            }
            fibonacciHeap3.nNodes = fibonacciHeap.nNodes + fibonacciHeap2.nNodes;
        }
        return fibonacciHeap3;
    }

    public String toString() {
        if (this.minNode == null) {
            return "FibonacciHeap=[]";
        }
        Stack stack = new Stack();
        stack.push(this.minNode);
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("FibonacciHeap=[");
        while (!stack.empty()) {
            FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)stack.pop();
            stringBuffer.append(fibonacciHeapNode);
            stringBuffer.append(", ");
            if (fibonacciHeapNode.child != null) {
                stack.push(fibonacciHeapNode.child);
            }
            FibonacciHeapNode fibonacciHeapNode2 = fibonacciHeapNode;
            fibonacciHeapNode = fibonacciHeapNode.right;
            while (fibonacciHeapNode != fibonacciHeapNode2) {
                stringBuffer.append(fibonacciHeapNode);
                stringBuffer.append(", ");
                if (fibonacciHeapNode.child != null) {
                    stack.push(fibonacciHeapNode.child);
                }
                fibonacciHeapNode = fibonacciHeapNode.right;
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected void cascadingCut(FibonacciHeapNode<T> fibonacciHeapNode) {
        FibonacciHeapNode fibonacciHeapNode2 = fibonacciHeapNode.parent;
        if (fibonacciHeapNode2 != null) {
            if (!fibonacciHeapNode.mark) {
                fibonacciHeapNode.mark = true;
            } else {
                this.cut(fibonacciHeapNode, fibonacciHeapNode2);
                this.cascadingCut(fibonacciHeapNode2);
            }
        }
    }

    protected void consolidate() {
        int n;
        int n2;
        int n3 = this.nNodes + 1;
        ArrayList<FibonacciHeapNode<T>> arrayList = new ArrayList<FibonacciHeapNode<T>>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(null);
        }
        n2 = 0;
        FibonacciHeapNode<T> fibonacciHeapNode = this.minNode;
        if (fibonacciHeapNode != null) {
            ++n2;
            fibonacciHeapNode = fibonacciHeapNode.right;
            while (fibonacciHeapNode != this.minNode) {
                ++n2;
                fibonacciHeapNode = fibonacciHeapNode.right;
            }
        }
        while (n2 > 0) {
            n = fibonacciHeapNode.degree;
            FibonacciHeapNode fibonacciHeapNode2 = fibonacciHeapNode.right;
            while (arrayList.get(n) != null) {
                FibonacciHeapNode<T> fibonacciHeapNode3 = (FibonacciHeapNode<T>)arrayList.get(n);
                if (fibonacciHeapNode.key > fibonacciHeapNode3.key) {
                    FibonacciHeapNode<T> fibonacciHeapNode4 = fibonacciHeapNode3;
                    fibonacciHeapNode3 = fibonacciHeapNode;
                    fibonacciHeapNode = fibonacciHeapNode4;
                }
                this.link(fibonacciHeapNode3, fibonacciHeapNode);
                arrayList.set(n, null);
                ++n;
            }
            arrayList.set(n, fibonacciHeapNode);
            fibonacciHeapNode = fibonacciHeapNode2;
            --n2;
        }
        this.minNode = null;
        for (n = 0; n < n3; ++n) {
            if (arrayList.get(n) == null) continue;
            if (this.minNode != null) {
                ((FibonacciHeapNode)arrayList.get((int)n)).left.right = ((FibonacciHeapNode)arrayList.get((int)n)).right;
                ((FibonacciHeapNode)arrayList.get((int)n)).right.left = ((FibonacciHeapNode)arrayList.get((int)n)).left;
                ((FibonacciHeapNode)arrayList.get((int)n)).left = this.minNode;
                ((FibonacciHeapNode)arrayList.get((int)n)).right = this.minNode.right;
                this.minNode.right = (FibonacciHeapNode)arrayList.get(n);
                ((FibonacciHeapNode)arrayList.get((int)n)).right.left = (FibonacciHeapNode)arrayList.get(n);
                if (!(((FibonacciHeapNode)arrayList.get((int)n)).key < this.minNode.key)) continue;
                this.minNode = (FibonacciHeapNode)arrayList.get(n);
                continue;
            }
            this.minNode = (FibonacciHeapNode)arrayList.get(n);
        }
    }

    protected void cut(FibonacciHeapNode<T> fibonacciHeapNode, FibonacciHeapNode<T> fibonacciHeapNode2) {
        fibonacciHeapNode.left.right = fibonacciHeapNode.right;
        fibonacciHeapNode.right.left = fibonacciHeapNode.left;
        --fibonacciHeapNode2.degree;
        if (fibonacciHeapNode2.child == fibonacciHeapNode) {
            fibonacciHeapNode2.child = fibonacciHeapNode.right;
        }
        if (fibonacciHeapNode2.degree == 0) {
            fibonacciHeapNode2.child = null;
        }
        fibonacciHeapNode.left = this.minNode;
        fibonacciHeapNode.right = this.minNode.right;
        this.minNode.right = fibonacciHeapNode;
        fibonacciHeapNode.right.left = fibonacciHeapNode;
        fibonacciHeapNode.parent = null;
        fibonacciHeapNode.mark = false;
    }

    protected void link(FibonacciHeapNode<T> fibonacciHeapNode, FibonacciHeapNode<T> fibonacciHeapNode2) {
        fibonacciHeapNode.left.right = fibonacciHeapNode.right;
        fibonacciHeapNode.right.left = fibonacciHeapNode.left;
        fibonacciHeapNode.parent = fibonacciHeapNode2;
        if (fibonacciHeapNode2.child == null) {
            fibonacciHeapNode2.child = fibonacciHeapNode;
            fibonacciHeapNode.right = fibonacciHeapNode;
            fibonacciHeapNode.left = fibonacciHeapNode;
        } else {
            fibonacciHeapNode.left = fibonacciHeapNode2.child;
            fibonacciHeapNode.right = fibonacciHeapNode2.child.right;
            fibonacciHeapNode2.child.right = fibonacciHeapNode;
            fibonacciHeapNode.right.left = fibonacciHeapNode;
        }
        ++fibonacciHeapNode2.degree;
        fibonacciHeapNode.mark = false;
    }
}

