/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.BiVariable;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;

public class InstanceVariable
extends AbstractVariable {
    public static BiVariable getInstance(Ruby runtime, String name, Object ... javaObject) {
        String pattern = "@([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";
        if (name.matches(pattern)) {
            return new InstanceVariable(runtime, name, javaObject);
        }
        return null;
    }

    private InstanceVariable(Ruby runtime, String name, Object ... javaObject) {
        super(runtime, name, javaObject);
    }

    public InstanceVariable(String name, IRubyObject irubyObject) {
        super(name, irubyObject);
    }

    public static void retrieve(Ruby runtime, IRubyObject receiver, BiVariableMap vars) {
        if (receiver == null) {
            receiver = runtime.getTopSelf();
        }
        InstanceVariables ivars = receiver.getInstanceVariables();
        List names = ivars.getInstanceVariableNameList();
        for (String name : names) {
            BiVariable var;
            IRubyObject value = ivars.fastGetInstanceVariable(name);
            if (vars.containsKey(name)) {
                var = vars.getVariable(name);
                var.setRubyObject(value);
                continue;
            }
            var = new InstanceVariable(name, value);
            vars.update(name, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.InstanceVariable;
    }

    public void inject(Ruby runtime, IRubyObject receiver) {
        ThreadContext context = runtime.getCurrentContext();
        IRubyObject rubyReceiver = receiver != null ? receiver : context.getFrameSelf();
        IRubyObject rubyName = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)this.name);
        ((RubyObject)rubyReceiver).instance_variable_set(rubyName, this.irubyObject);
    }

    public void remove(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        IRubyObject self = context.getFrameSelf();
        self.getInstanceVariables().removeInstanceVariable(this.name);
    }
}

