/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceFinder {
    private ClassLoader loader = null;
    private String serviceName;
    private HashSet<?> services;

    ServiceFinder(ClassLoader loader, String serviceName) throws IOException {
        this.serviceName = serviceName;
        Enumeration<URL> urls = this.findResources(loader);
        List<String> classNames = this.getClassNames(urls);
        this.services = this.instantiateClasses(classNames);
    }

    HashSet<?> getServices() {
        return this.services;
    }

    private Enumeration<URL> findResources(ClassLoader loader) throws IOException {
        Enumeration<URL> urls;
        if (loader == null) {
            this.loader = ClassLoader.getSystemClassLoader();
            urls = ClassLoader.getSystemResources(this.serviceName);
        } else {
            this.loader = loader;
            urls = loader.getResources(this.serviceName);
        }
        return urls;
    }

    private List<String> getClassNames(Enumeration<URL> urls) {
        String encoding = System.getProperty("file.encoding");
        ArrayList<String> names = new ArrayList<String>();
        URL url = null;
        while (urls.hasMoreElements()) {
            try {
                String line;
                url = urls.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), encoding));
                while ((line = reader.readLine()) != null) {
                    if ((line = this.deleteComments(line)) == null) continue;
                    names.add(line);
                }
            }
            catch (IOException e) {
                System.err.println("Failed to get a class name from " + url.toString());
            }
        }
        return names;
    }

    private String deleteComments(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        if (line.length() < 1) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(line, "#");
        return ((String)st.nextElement()).trim();
    }

    private <T> HashSet<T> instantiateClasses(List<String> names) {
        HashSet instances = new HashSet();
        for (String name : names) {
            try {
                Class<?> clazz = Class.forName(name, true, this.loader);
                Object instance = clazz.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException e) {
                System.err.println(name + " was not found");
            }
            catch (InstantiationException e) {
                System.err.println(name + " was not instantiated");
            }
            catch (IllegalAccessException e) {
                System.err.println(name + " committed illegal access");
            }
            catch (Throwable e) {
                System.err.println("failed to instantiate " + name);
            }
        }
        return instances;
    }
}

