/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyRuntimeAdapter;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.EmbedEvalUnitImpl;
import org.jruby.embed.io.ReaderInputStream;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.EvalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedRubyRuntimeAdapterImpl
implements EmbedRubyRuntimeAdapter {
    private RubyRuntimeAdapter adapter = JavaEmbedUtils.newRuntimeAdapter();
    private ScriptingContainer container;

    public EmbedRubyRuntimeAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    public EmbedEvalUnit parse(String script, int ... lines) {
        boolean unicode_escape = false;
        Object obj = this.container.getAttribute((Object)AttributeName.UNICODE_ESCAPE);
        if (obj != null && obj instanceof Boolean) {
            unicode_escape = (Boolean)obj;
        }
        if (unicode_escape) {
            ReaderInputStream istream = new ReaderInputStream(new StringReader(script));
            return this.runParser(istream, null, lines);
        }
        return this.runParser(script, null, lines);
    }

    public EmbedEvalUnit parse(Reader reader, String filename, int ... lines) {
        if (reader != null) {
            ReaderInputStream istream = new ReaderInputStream(reader);
            return this.runParser(istream, filename, lines);
        }
        return null;
    }

    public EmbedEvalUnit parse(PathType type, String filename, int ... lines) {
        try {
            InputStream istream = null;
            switch (type) {
                case ABSOLUTE: {
                    istream = new FileInputStream(filename);
                    break;
                }
                case RELATIVE: {
                    String basedir = (String)this.container.getAttribute((Object)AttributeName.BASE_DIR);
                    String absolutePath = basedir + File.separator + filename;
                    istream = new FileInputStream(absolutePath);
                    break;
                }
                case CLASSPATH: {
                    istream = this.container.getRuntime().getJRubyClassLoader().getResourceAsStream(filename);
                }
            }
            return this.parse(istream, filename, lines);
        }
        catch (FileNotFoundException e) {
            try {
                ((Writer)this.container.getAttributeMap().get((Object)AttributeName.ERROR_WRITER)).write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    public EmbedEvalUnit parse(InputStream istream, String filename, int ... lines) {
        if (istream != null) {
            return this.runParser(istream, filename, lines);
        }
        return null;
    }

    private EmbedEvalUnit runParser(Object input, String filename, int ... lines) {
        if (input == null) {
            return null;
        }
        if (filename == null || filename.length() == 0) {
            filename = "<script>";
        }
        int line = 0;
        if (lines.length > 0) {
            line = lines[0];
        }
        try {
            Ruby runtime = this.container.getRuntime();
            ManyVarsDynamicScope scope = this.getManyVarsDynamicScope(runtime, 0);
            Node node = null;
            node = input instanceof String ? this.container.getRuntime().parseEval((String)input, filename, (DynamicScope)scope, line) : this.container.getRuntime().parseFile((InputStream)input, filename, (DynamicScope)scope, line);
            RubyInstanceConfig.CompileMode compileMode = runtime.getInstanceConfig().getCompileMode();
            if (compileMode == RubyInstanceConfig.CompileMode.JIT || compileMode == RubyInstanceConfig.CompileMode.FORCE) {
                Script script = runtime.tryCompile(node);
                EmbedEvalUnitImpl embedEvalUnitImpl = new EmbedEvalUnitImpl(this.container, node, scope, script);
                return embedEvalUnitImpl;
            }
            EmbedEvalUnitImpl embedEvalUnitImpl = new EmbedEvalUnitImpl(this.container, node, scope);
            return embedEvalUnitImpl;
        }
        catch (RaiseException e) {
            RubyException re = e.getException();
            this.container.getRuntime().printError(re);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            try {
                ((Writer)this.container.getAttributeMap().get((Object)AttributeName.ERROR_WRITER)).write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (input instanceof InputStream) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    ManyVarsDynamicScope getManyVarsDynamicScope(Ruby runtime, int depth) {
        ThreadContext context = runtime.getCurrentContext();
        DynamicScope currentScope = context.getCurrentScope();
        String[] names4Injection = this.container.getVarMap().getLocalVarNames();
        ManyVarsDynamicScope scope = names4Injection == null || names4Injection.length == 0 ? new ManyVarsDynamicScope((StaticScope)new EvalStaticScope(currentScope.getStaticScope()), currentScope) : new ManyVarsDynamicScope((StaticScope)new EvalStaticScope(currentScope.getStaticScope(), names4Injection), currentScope);
        return scope;
    }

    public IRubyObject eval(Ruby runtime, String script) {
        return this.adapter.eval(runtime, script);
    }

    public JavaEmbedUtils.EvalUnit parse(Ruby runtime, String script, String filename, int lineNumber) {
        return this.adapter.parse(runtime, script, filename, lineNumber);
    }

    public JavaEmbedUtils.EvalUnit parse(Ruby runtime, InputStream istream, String filename, int lineNumber) {
        return this.adapter.parse(runtime, istream, filename, lineNumber);
    }
}

